/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mps.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.model.Packet;
import org.jcodec.containers.mps.MPSUtils;
import org.jcodec.containers.mps.index.MPSIndex;

public class MPSRandomAccessDemuxer {
    private Stream[] streams;
    private long[] pesTokens;
    private int[] pesStreamIds;

    public MPSRandomAccessDemuxer(SeekableByteChannel ch, MPSIndex mpsIndex) throws IOException {
        this.pesTokens = mpsIndex.getPesTokens();
        this.pesStreamIds = mpsIndex.getPesStreamIds().flattern();
        MPSIndex.MPSStreamIndex[] streamIndices = mpsIndex.getStreams();
        this.streams = new Stream[streamIndices.length];
        for (int i = 0; i < streamIndices.length; ++i) {
            this.streams[i] = this.newStream(ch, streamIndices[i]);
        }
    }

    protected Stream newStream(SeekableByteChannel ch, MPSIndex.MPSStreamIndex streamIndex) throws IOException {
        return new Stream(streamIndex, ch);
    }

    public Stream[] getStreams() {
        return this.streams;
    }

    public class Stream
    extends MPSIndex.MPSStreamIndex
    implements SeekableDemuxerTrack {
        private static final int MPEG_TIMESCALE = 90000;
        private int curPesIdx;
        private int curFrame;
        private ByteBuffer pesBuf;
        private int seekToFrame;
        protected SeekableByteChannel source;
        private long[] foffs;

        public Stream(MPSIndex.MPSStreamIndex streamIndex, SeekableByteChannel source) throws IOException {
            super(streamIndex);
            this.seekToFrame = -1;
            this.source = source;
            this.foffs = new long[this.fsizes.length];
            long curOff = 0L;
            for (int i = 0; i < this.fsizes.length; ++i) {
                this.foffs[i] = curOff;
                curOff += (long)this.fsizes[i];
            }
            int[] seg = Arrays.copyOf(streamIndex.getFpts(), 100);
            Arrays.sort(seg);
            this.seekToFrame = 0;
            this.seekToFrame();
        }

        @Override
        public Packet nextFrame() throws IOException {
            this.seekToFrame();
            if (this.curFrame >= this.fsizes.length) {
                return null;
            }
            int fs = this.fsizes[this.curFrame];
            ByteBuffer result = ByteBuffer.allocate(fs);
            return this.nextFrame(result);
        }

        public Packet nextFrame(ByteBuffer buf) throws IOException {
            this.seekToFrame();
            if (this.curFrame >= this.fsizes.length) {
                return null;
            }
            int fs = this.fsizes[this.curFrame];
            ByteBuffer result = buf.duplicate();
            result.limit(result.position() + fs);
            while (result.hasRemaining()) {
                if (this.pesBuf.hasRemaining()) {
                    result.put(NIOUtils.read(this.pesBuf, Math.min(this.pesBuf.remaining(), result.remaining())));
                    continue;
                }
                ++this.curPesIdx;
                long posShift = 0L;
                while (MPSRandomAccessDemuxer.this.pesStreamIds[this.curPesIdx] != this.streamId) {
                    posShift += (long)(MPSIndex.pesLen(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]) + MPSIndex.leadingSize(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]));
                    ++this.curPesIdx;
                }
                this.skip(posShift + (long)MPSIndex.leadingSize(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]));
                int pesLen = MPSIndex.pesLen(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]);
                this.pesBuf = this.fetch(pesLen);
                MPSUtils.readPESHeader(this.pesBuf, 0L);
            }
            result.flip();
            Packet pkt = new Packet(result, this.fpts[this.curFrame], 90000L, this.fdur[this.curFrame], this.curFrame, this.sync.length == 0 || Arrays.binarySearch(this.sync, this.curFrame) >= 0, null);
            ++this.curFrame;
            return pkt;
        }

        protected ByteBuffer fetch(int pesLen) throws IOException {
            return NIOUtils.fetchFrom(this.source, pesLen);
        }

        protected void skip(long leadingSize) throws IOException {
            this.source.position(this.source.position() + leadingSize);
        }

        protected void reset() throws IOException {
            this.source.position(0L);
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            return null;
        }

        @Override
        public boolean gotoFrame(long frameNo) {
            this.seekToFrame = (int)frameNo;
            return true;
        }

        @Override
        public boolean gotoSyncFrame(long frameNo) {
            for (int i = 0; i < this.sync.length; ++i) {
                if ((long)this.sync[i] <= frameNo) continue;
                this.seekToFrame = this.sync[i - 1];
                return true;
            }
            this.seekToFrame = this.sync[this.sync.length - 1];
            return true;
        }

        private void seekToFrame() throws IOException {
            if (this.seekToFrame == -1) {
                return;
            }
            this.curFrame = this.seekToFrame;
            long payloadOff = this.foffs[this.curFrame];
            long posShift = 0L;
            this.reset();
            this.curPesIdx = 0;
            while (true) {
                if (MPSRandomAccessDemuxer.this.pesStreamIds[this.curPesIdx] == this.streamId) {
                    int payloadSize = MPSIndex.payLoadSize(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]);
                    if (payloadOff < (long)payloadSize) break;
                    payloadOff -= (long)payloadSize;
                }
                posShift += (long)(MPSIndex.pesLen(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]) + MPSIndex.leadingSize(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]));
                ++this.curPesIdx;
            }
            this.skip(posShift + (long)MPSIndex.leadingSize(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]));
            this.pesBuf = this.fetch(MPSIndex.pesLen(MPSRandomAccessDemuxer.this.pesTokens[this.curPesIdx]));
            MPSUtils.readPESHeader(this.pesBuf, 0L);
            NIOUtils.skip(this.pesBuf, (int)payloadOff);
            this.seekToFrame = -1;
        }

        @Override
        public long getCurFrame() {
            return this.curFrame;
        }

        @Override
        public void seek(double second) {
            throw new UnsupportedOperationException();
        }
    }
}

