/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.io.model;

import org.jcodec.codecs.h264.decode.CAVLCReader;
import org.jcodec.codecs.h264.io.write.CAVLCWriter;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;

public class ScalingList {
    public int[] scalingList;
    public boolean useDefaultScalingMatrixFlag;

    public void write(BitWriter out) {
        if (this.useDefaultScalingMatrixFlag) {
            CAVLCWriter.writeSE(out, 0, "SPS: ");
            return;
        }
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < this.scalingList.length; ++j) {
            if (nextScale != 0) {
                int deltaScale = this.scalingList[j] - lastScale - 256;
                CAVLCWriter.writeSE(out, deltaScale, "SPS: ");
            }
            lastScale = this.scalingList[j];
        }
    }

    public static ScalingList read(BitReader in, int sizeOfScalingList) {
        ScalingList sl = new ScalingList();
        sl.scalingList = new int[sizeOfScalingList];
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < sizeOfScalingList; ++j) {
            if (nextScale != 0) {
                int deltaScale = CAVLCReader.readSE(in, "deltaScale");
                nextScale = (lastScale + deltaScale + 256) % 256;
                sl.useDefaultScalingMatrixFlag = j == 0 && nextScale == 0;
            }
            sl.scalingList[j] = nextScale == 0 ? lastScale : nextScale;
            lastScale = sl.scalingList[j];
        }
        return sl;
    }
}

