/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Binding;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114Aa\u0004\t\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)\u0011\t\u0001C\u0001\u0005\")1\n\u0001C!\u0019\"1\u0001\u000b\u0001Q!\nECQ\u0001\u0016\u0001\u0005\nUCQ!\u0017\u0001\u0005\u0002iCQA\u0019\u0001\u0005BUCQa\u0019\u0001\u0005BU\u0013QbQ8oGV\u0014(/\u001a8u\u0015>\u0014'BA\t\u0013\u0003\rqg/\u001c\u0006\u0003'Q\tQA\u001c7pO>T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u0003AI!a\u0007\t\u0003\u0007){'-A\u0003po:,'\u000f\u0005\u0002\u001fC5\tqD\u0003\u0002!%\u0005\u0019\u0011\r]5\n\u0005\tz\"\u0001\u0003&pE>;h.\u001a:\u0002\u0011\u0005<WM\u001c;tKR\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\n\u0002\u000b\u0005<WM\u001c;\n\u0005%2#\u0001C!hK:$8+\u001a;\u0002#Q|\u0007\u000fT3wK2\u0004&o\\2fIV\u0014X\r\u0005\u0002\u001aY%\u0011Q\u0006\u0005\u0002\n!J|7-\u001a3ve\u0016\fq!\u00193ee\u0016\u001c8\u000f\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0002J]R\fQ\u0002]1sK:$8i\u001c8uKb$\bCA\r8\u0013\tA\u0004CA\u0004D_:$X\r\u001f;\u0002\u0013]|'o[:qC\u000e,\u0007CA\r<\u0013\ta\u0004CA\u0005X_J\\7\u000f]1dK\u00061!/\u00198e_6\u0004\"AH \n\u0005\u0001{\"aE'feN,gN\\3Uo&\u001cH/\u001a:GCN$\u0018A\u0002\u001fj]&$h\b\u0006\u0005D\t\u00163u\tS%K!\tI\u0002\u0001C\u0003\u001d\u0011\u0001\u0007Q\u0004C\u0003$\u0011\u0001\u0007A\u0005C\u0003+\u0011\u0001\u00071\u0006C\u0003/\u0011\u0001\u0007q\u0006C\u00036\u0011\u0001\u0007a\u0007C\u0003:\u0011\u0001\u0007!\bC\u0003>\u0011\u0001\u0007a(A\u0005fq\u000edWo]5wKR\tQ\n\u0005\u00021\u001d&\u0011q*\r\u0002\b\u0005>|G.Z1o\u0003!\u0019wN\u001c;fqR\u001c\bc\u0001\u0019Sm%\u00111+\r\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000bS:LG/[1mSj,G#\u0001,\u0011\u0005A:\u0016B\u0001-2\u0005\u0011)f.\u001b;\u0002\u001f9,w/Q4f]RTu.\u001b8j]\u001e$BAV.`C\")q\u0005\u0004a\u00019B\u0011Q%X\u0005\u0003=\u001a\u0012Q!Q4f]RDQ\u0001\u0019\u0007A\u0002=\nA\"\u001b8ji&\fGnQ8v]RDQA\f\u0007A\u0002=\nAa\u001d;fa\u00061a-\u001b8jg\"\u0004")
public class ConcurrentJob
extends Job {
    private final AgentSet agentset;
    private final Procedure topLevelProcedure;
    private final int address;
    private final Context parentContext;
    private final MersenneTwisterFast random;
    private Context[] contexts;
    private volatile boolean bitmap$init$0;

    @Override
    public boolean exclusive() {
        return false;
    }

    private void initialize() {
        this.contexts = new Context[this.agentset.count()];
        int count = 0;
        AgentIterator iter = this.agentset.shufflerator(this.random);
        while (iter.hasNext()) {
            this.newAgentJoining(iter.next(), count, this.address);
            ++count;
        }
    }

    public void newAgentJoining(Agent agent, int initialCount, int address) {
        Activation activation;
        int count = initialCount;
        if (this.parentContext == null) {
            activation = new Activation(this.topLevelProcedure, null, 0);
        } else {
            Activation parent = this.parentContext.activation;
            activation = new Activation(parent.procedure, parent.parent, parent.args, parent.returnAddress, new Binding(parent.binding));
        }
        Activation activation2 = activation;
        Context context = new Context(this, agent, address, activation2);
        if (initialCount == -1) {
            if (this.contexts == null) {
                this.initialize();
            }
            count = this.contexts.length;
            Context[] newContexts = new Context[count + 1];
            System.arraycopy(this.contexts, 0, newContexts, 0, count);
            this.contexts = newContexts;
        }
        this.contexts[count] = context;
    }

    @Override
    public void step() {
        if (this.contexts == null) {
            this.initialize();
        }
        int max = this.contexts.length;
        boolean allContextsDone = true;
        Context context = null;
        try {
            for (int i = 0; i < max && this.state == 0; ++i) {
                context = this.contexts[i];
                if (context == null) continue;
                if (!context.finished) {
                    if (!context.waiting) {
                        context.stepConcurrent();
                    }
                    allContextsDone = false;
                    continue;
                }
                this.contexts[i] = null;
            }
        }
        catch (LogoException ex) {
            this.finish();
            if (!Thread.currentThread().isInterrupted()) {
                context.runtimeError(ex);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            this.finish();
            context.runtimeError(ex);
            throw ex;
        }
        if (this.state == 0 && allContextsDone) {
            this.finish();
        }
    }

    @Override
    public void finish() {
        super.finish();
        if (this.contexts != null) {
            for (Context context : this.contexts) {
                if (context == null) continue;
                context.finished = true;
            }
        }
    }

    public ConcurrentJob(JobOwner owner, AgentSet agentset, Procedure topLevelProcedure, int address, Context parentContext, Workspace workspace, MersenneTwisterFast random) {
        this.agentset = agentset;
        this.topLevelProcedure = topLevelProcedure;
        this.address = address;
        this.parentContext = parentContext;
        this.random = random;
        super(owner, agentset, topLevelProcedure, address, parentContext, workspace, random);
        this.contexts = null;
        this.bitmap$init$0 = true;
    }
}

