/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.content.animation.animator.LinearByteValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class RandomLinearByteValueAnimator
implements ValueAnimator<Byte> {
    private int seed;
    Uniform rng;
    LinearByteValueAnimator animator;
    private byte min;
    private byte max;
    private int duration;

    public RandomLinearByteValueAnimator(byte min, byte max, int duration) {
        this.seed = (int)System.nanoTime();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearByteValueAnimator(byte min, byte max, int duration, byte initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    public RandomLinearByteValueAnimator(int startWait, int stopWait, byte min, byte max, int duration) {
        this.seed = (int)System.currentTimeMillis();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearByteValueAnimator(int startWait, int stopWait, byte min, byte max, int duration, byte initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    @Override
    public Byte nextValue() {
        if (this.animator.hasFinished()) {
            this.setNextAnimator((Byte)this.animator.nextValue());
        }
        return (Byte)this.animator.nextValue();
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void reset() {
        this.rng = new Uniform((RandomEngine)new MersenneTwister(this.seed));
        byte v1 = (byte)this.rng.nextIntFromTo((int)this.min, (int)this.max);
        this.setNextAnimator(v1);
    }

    protected void setNextAnimator(byte v1) {
        byte v2 = (byte)this.rng.nextIntFromTo((int)this.min, (int)this.max);
        this.animator = new LinearByteValueAnimator(v1, v2, this.duration);
    }
}

