/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import org.tinfour.common.Circumcircle;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.vividsolutions.jts.math.DD;

public class GeometricOperations {
    private final DD q11 = new DD();
    private final DD q21 = new DD();
    private final DD q31 = new DD();
    private final DD q12 = new DD();
    private final DD q22 = new DD();
    private final DD q32 = new DD();
    private final DD q11s = new DD();
    private final DD q12s = new DD();
    private final DD q21s = new DD();
    private final DD q22s = new DD();
    private final DD q31s = new DD();
    private final DD q32s = new DD();
    private final DD q21_32 = new DD();
    private final DD q31_22 = new DD();
    private final DD q31_12 = new DD();
    private final DD q11_32 = new DD();
    private final DD q11_22 = new DD();
    private final DD q21_12 = new DD();
    private final Thresholds thresholds;
    private final double inCircleThreshold;
    private final double halfPlaneThresholdNeg;
    private final double halfPlaneThreshold;
    private int nInCircleCalls;
    private int nExtendedPrecisionInCircle;
    private int nExtendedConflict;
    private int nHalfPlaneCalls;

    public GeometricOperations() {
        this.thresholds = new Thresholds(1.0);
        this.inCircleThreshold = this.thresholds.getInCircleThreshold();
        this.halfPlaneThresholdNeg = -this.thresholds.getHalfPlaneThreshold();
        this.halfPlaneThreshold = this.thresholds.getHalfPlaneThreshold();
    }

    public GeometricOperations(Thresholds thresholds) {
        this.thresholds = thresholds;
        this.inCircleThreshold = thresholds.getInCircleThreshold();
        this.halfPlaneThresholdNeg = -thresholds.getHalfPlaneThreshold();
        this.halfPlaneThreshold = thresholds.getHalfPlaneThreshold();
    }

    public double inCircle(Vertex a, Vertex b, Vertex c, Vertex d) {
        return this.inCircle(a.x, a.y, b.x, b.y, c.x, c.y, d.x, d.y);
    }

    public double inCircle(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        ++this.nInCircleCalls;
        double a11 = ax - dx;
        double a12 = ay - dy;
        double a21 = bx - dx;
        double a32 = cy - dy;
        double a31 = cx - dx;
        double a22 = by - dy;
        double inCircle = (a11 * a11 + a12 * a12) * (a21 * a32 - a31 * a22) + (a21 * a21 + a22 * a22) * (a31 * a12 - a11 * a32) + (a31 * a31 + a32 * a32) * (a11 * a22 - a21 * a12);
        if (-this.inCircleThreshold < inCircle && inCircle < this.inCircleThreshold) {
            ++this.nExtendedPrecisionInCircle;
            double inCircle2 = this.inCircleQuadPrecision(ax, ay, bx, by, cx, cy, dx, dy);
            if (inCircle2 * inCircle <= 0.0 && (inCircle != 0.0 || inCircle2 != 0.0)) {
                ++this.nExtendedConflict;
            }
            inCircle = inCircle2;
        }
        return inCircle;
    }

    public double inCircleQuadPrecision(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        ++this.nExtendedPrecisionInCircle;
        this.q11.setValue(ax).selfSubtract(dx);
        this.q21.setValue(bx).selfSubtract(dx);
        this.q31.setValue(cx).selfSubtract(dx);
        this.q12.setValue(ay).selfSubtract(dy);
        this.q22.setValue(by).selfSubtract(dy);
        this.q32.setValue(cy).selfSubtract(dy);
        this.q11s.setValue(this.q11).selfMultiply(this.q11);
        this.q12s.setValue(this.q12).selfMultiply(this.q12);
        this.q21s.setValue(this.q21).selfMultiply(this.q21);
        this.q22s.setValue(this.q22).selfMultiply(this.q22);
        this.q31s.setValue(this.q31).selfMultiply(this.q31);
        this.q32s.setValue(this.q32).selfMultiply(this.q32);
        this.q11_22.setValue(this.q11).selfMultiply(this.q22);
        this.q11_32.setValue(this.q11).selfMultiply(this.q32);
        this.q21_12.setValue(this.q21).selfMultiply(this.q12);
        this.q21_32.setValue(this.q21).selfMultiply(this.q32);
        this.q31_22.setValue(this.q31).selfMultiply(this.q22);
        this.q31_12.setValue(this.q31).selfMultiply(this.q12);
        DD s1 = this.q11s.selfAdd(this.q12s);
        DD s2 = this.q21s.selfAdd(this.q22s);
        DD s3 = this.q31s.selfAdd(this.q32s);
        DD t1 = this.q21_32.selfSubtract(this.q31_22);
        DD t2 = this.q31_12.selfSubtract(this.q11_32);
        DD t3 = this.q11_22.selfSubtract(this.q21_12);
        s1.selfMultiply(t1);
        s2.selfMultiply(t2);
        s3.selfMultiply(t3);
        s1.selfAdd(s2).selfAdd(s3);
        return s1.doubleValue();
    }

    public double halfPlane(double ax, double ay, double bx, double by, double cx, double cy) {
        ++this.nHalfPlaneCalls;
        this.q11.setValue(cx).selfSubtract(ax);
        this.q12.setValue(ay).selfSubtract(by);
        this.q21.setValue(cy).selfSubtract(ay);
        this.q22.setValue(bx).selfSubtract(ax);
        this.q11.selfMultiply(this.q12);
        this.q21.selfMultiply(this.q22);
        this.q11.selfAdd(this.q21);
        return this.q11.doubleValue();
    }

    public double direction(double ax, double ay, double bx, double by, double cx, double cy) {
        ++this.nHalfPlaneCalls;
        this.q11.setValue(bx).selfSubtract(ax);
        this.q12.setValue(by).selfSubtract(ay);
        this.q21.setValue(cx).selfSubtract(ax);
        this.q22.setValue(cy).selfSubtract(ay);
        this.q11.selfMultiply(this.q21);
        this.q12.selfMultiply(this.q22);
        this.q11.selfAdd(this.q12);
        return this.q11.doubleValue();
    }

    public double orientation(double ax, double ay, double bx, double by, double cx, double cy) {
        double a = (ax - cx) * (by - cy) - (bx - cx) * (ay - cy);
        if (a > this.halfPlaneThresholdNeg && a < this.halfPlaneThreshold) {
            this.q11.setValue(ax).selfSubtract(cx);
            this.q12.setValue(by).selfSubtract(cy);
            this.q21.setValue(bx).selfSubtract(cx);
            this.q22.setValue(ay).selfSubtract(cy);
            this.q11.selfMultiply(this.q12);
            this.q21.selfMultiply(this.q22);
            this.q11.selfSubtract(this.q21);
            return this.q11.doubleValue();
        }
        return a;
    }

    int getInCircleCount() {
        return this.nInCircleCalls;
    }

    public int getExtendedPrecisionInCircleCount() {
        return this.nExtendedPrecisionInCircle;
    }

    public int getExtendedConflictCount() {
        return this.nExtendedConflict;
    }

    public int getHalfPlaneCount() {
        return this.nHalfPlaneCalls;
    }

    public double area(Vertex a, Vertex b, Vertex c) {
        double h = (c.y - a.y) * (b.x - a.x) - (c.x - a.x) * (b.y - a.y);
        if (-this.inCircleThreshold < h && h < this.inCircleThreshold) {
            h = this.halfPlane(a.x, a.y, b.x, b.y, c.x, c.y);
        }
        return h / 2.0;
    }

    public double area(double ax, double ay, double bx, double by, double cx, double cy) {
        double h = (cy - ay) * (bx - ax) - (cx - ax) * (by - ay);
        if (-this.inCircleThreshold < h && h < this.inCircleThreshold) {
            h = this.halfPlane(ax, ay, bx, by, cx, cy);
        }
        return h / 2.0;
    }

    public void clearDiagnostics() {
        this.nInCircleCalls = 0;
        this.nExtendedPrecisionInCircle = 0;
        this.nExtendedConflict = 0;
        this.nHalfPlaneCalls = 0;
    }

    public void computeCircumcircle(Vertex a, Vertex b, Vertex c, Circumcircle result) {
        double x0 = a.x;
        double bx = b.x - x0;
        double y0 = a.y;
        double cy = c.y - y0;
        double by = b.y - y0;
        double cx = c.x - x0;
        double d = 2.0 * (bx * cy - by * cx);
        if (d < 1.0E-11) {
            result.setCircumcenter(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return;
        }
        double b2 = bx * bx + by * by;
        double c2 = cx * cx + cy * cy;
        double x = (cy * b2 - by * c2) / d;
        double y = (bx * c2 - cx * b2) / d;
        result.setCircumcenter(x + a.x, y + a.y, x * x + y * y);
    }

    public void computeCircumcircle(double vax, double vay, double vbx, double vby, double vcx, double vcy, Circumcircle result) {
        double x0 = vax;
        double bx = vbx - x0;
        double y0 = vay;
        double cy = vcy - y0;
        double by = vby - y0;
        double cx = vcx - x0;
        double d = 2.0 * (bx * cy - by * cx);
        if (d < 1.0E-11) {
            result.setCircumcenter(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return;
        }
        double b2 = bx * bx + by * by;
        double c2 = cx * cx + cy * cy;
        double x = (cy * b2 - by * c2) / d;
        double y = (bx * c2 - cx * b2) / d;
        result.setCircumcenter(x + vax, y + vay, x * x + y * y);
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }
}

