//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cPistol.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cPistol_hpp
#define cPistol_hpp
//==============================================================================
// Includes
#include "cWeapon.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Pistol
//------------------------------------------------------------------------------
class cPistol : public cWeapon
{
	// Constructor & Destructor
	public:
		//! Constructor
		cPistol (void);
		//! Destructor
		virtual ~cPistol (void);
	
	// Protected methods
	public:
		virtual void Fire (const cVector2f &position, float angle);
		virtual string GetName (void) const { return "Pistol"; };
		virtual void EndReload (void);
	
	// Member variables
	private:
		Uint32 mSound;
		Uint32 mReloadSound;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cPistol_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
