//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//==============================================================================

//==============================================================================
//File: cAnimation.hpp
//Project: Shooting Star
//Author: Tuomas Peippo <tuomas.peippo@2ndpoint.fi>
//Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
//Revision history
//=============================================================================
#ifndef cFont_hpp
#define cFont_hpp

//============================================================================
// Includes
#include "Types.hpp"
#include <string>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar	{
//============================================================================	

// Use cTextureFont instead
namespace DontUse	{
  
class cFont
{
	// Constructor & Destructor
	public:
		//! Constructor
		cFont (string font = "fixed");
		//! Desturctor
		~cFont (void);

	// Public methods
	public:
		void PrintString (string text);
		void Print (const char *pFormat, ...);
	
	// Member variables
	private:
		Uint32 mListBase;
};

//==============================================================================
}	// End of the DontUse namespace
}	// End of the ShootingStar namespace
#endif // cFont_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
