//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cAnimationHandle.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cAnimationHandle_hpp
#define cAnimationHandle_hpp
//==============================================================================
// Includes
#include "Types.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! AnimationHandle
//------------------------------------------------------------------------------
class cAnimationHandle
{
	// Constructor & Destructor
	public:
		//! Constructor
		cAnimationHandle (void);
		//! Destructor
		~cAnimationHandle (void);
	
	// Public methods
	public:
		//! Set animation
		void SetAnimation (Uint32 animationBase) { mAnimationBase = animationBase; };
		//! Set current frame
		void SetCurrentFrame (Uint16 frame) { mCurrentFrame = frame; };
		//! Set number of frames
		void SetNumberOfFrames (Uint16 numberOfFrames) { mNumberOfFrames = numberOfFrames; };
		//! Set frame delay
		void SetFrameDelay (Uint32 delay)  { mFrameDelay = delay; };
		//! Set alpha
		void SetAlpha (float alpha) { mAlpha = alpha; };
	
		//! Update
		void Update (Uint32 deltaTime);
		//! Render
		void Render (void);
	// Member variables
	private:
		Uint32 mAnimationBase;
		Uint16 mCurrentFrame;
		Uint16 mNumberOfFrames;
		Uint32 mFrameDelay;
		Uint32 mLastFrame;
		Uint32 mLastUpdate;
		float mAlpha;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cAnimationHandle_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
