set(TEST_MCTESTER_ROOT_DIR  "" ${MCTESTER_ROOT_DIR})
IF(TEST_MCTESTER_ROOT_DIR STREQUAL "")
  IF(DEFINED ENV{MCTESTER_ROOT_DIR})
    set(MCTESTER_ROOT_DIR  $ENV{MCTESTER_ROOT_DIR})
  else()
    set(MCTESTER_ROOT_DIR  "/usr")
  endif()
endif()
find_path(MCTESTER_INCLUDE_DIR HepMCEvent.H HINTS $ENV{MCTESTER_ROOT_DIR}/include ${MCTESTER_ROOT_DIR}/include)
SET(MCTESTER_VERSION 0.0.0)

find_library(MCTESTER_MCTester_LIBRARY NAMES MCTester
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib ${MCTESTER_ROOT_DIR}/lib
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib64 ${MCTESTER_ROOT_DIR}/lib64
             )


find_library(MCTESTER_HEPEvent_LIBRARY NAMES HEPEvent
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib ${MCTESTER_ROOT_DIR}/lib
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib64 ${MCTESTER_ROOT_DIR}/lib64
             )

find_library(MCTESTER_HepMCEvent_LIBRARY NAMES HepMCEvent
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib ${MCTESTER_ROOT_DIR}/lib
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib64 ${MCTESTER_ROOT_DIR}/lib64
             )


find_library(MCTESTER_HepMC3Event_LIBRARY NAMES HepMC3Event
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib ${MCTESTER_ROOT_DIR}/lib
             HINTS $ENV{MCTESTER_ROOT_DIR}/lib64 ${MCTESTER_ROOT_DIR}/lib64
             )

foreach(comp ${MCTESTER_FIND_COMPONENTS})
  find_library(MCTESTER_${comp}_LIBRARY NAMES ${comp}
               HINTS $ENV{MCTESTER_ROOT_DIR}/lib   ${MCTESTER_ROOT_DIR}/lib
               HINTS $ENV{MCTESTER_ROOT_DIR}/lib64 ${MCTESTER_ROOT_DIR}/lib64
               )
endforeach()



set(MCTESTER_INCLUDE_DIRS ${MCTESTER_INCLUDE_DIR})
if (MCTESTER_MCTester_LIBRARY AND MCTESTER_HEPEvent_LIBRARY)
 set(MCTESTER_LIBRARIES ${MCTESTER_MCTester_LIBRARY} ${MCTESTER_LIBRARY_HEPEvent})
endif()
if (MCTESTER_HepMCEvent_LIBRARY)
    set(MCTESTER_HEPMC2_LIBRARIES  ${MCTESTER_HepMCEvent_LIBRARY} )
    set(MCTester_HEPMC2_FOUND TRUE)
endif()
if (MCTESTER_HepMC3Event_LIBRARY)
    set(MCTESTER_HEPMC3_LIBRARIES  ${MCTESTER_HepMC3Event_LIBRARY} )
    set(MCTester_HEPMC3_FOUND TRUE)
endif()


INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(MCTester REQUIRED_VARS MCTESTER_INCLUDE_DIR MCTESTER_LIBRARIES MCTESTER_VERSION  HANDLE_COMPONENTS)

mark_as_advanced(MCTester_FOUND MCTESTER_INCLUDE_DIR MCTESTER_INCLUDE_DIRS  MCTESTER_LIBRARIES)
