/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.infocenter;

import com.dlsc.gemsfx.infocenter.InfoCenterEvent;
import com.dlsc.gemsfx.infocenter.InfoCenterView;
import com.dlsc.gemsfx.skins.InfoCenterPaneSkin;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import one.jpro.jproutils.treeshowing.TreeShowing;

public class InfoCenterPane
extends Control {
    private static final Duration DEFAULT_SLIDE_IN_DURATION = Duration.millis((double)200.0);
    private static final Duration DEFAULT_AUTO_HIDE_DURATION = Duration.seconds((double)5.0);
    private static final boolean DEFAULT_PINNED = false;
    private static final boolean DEFAULT_AUTO_HIDE = true;
    private static final boolean DEFAULT_SHOW_INFO_CENTER = false;
    private final InfoCenterView infoCenterView = new InfoCenterView();
    private final ReadOnlyBooleanWrapper insideInfoCenter = new ReadOnlyBooleanWrapper((Object)this, "insideInfoCenter");
    private final EventHandler<MouseEvent> mouseClickedHandler = evt -> {
        if (evt.getTarget() == this.getContent() && this.isAutoHide() && !this.isPinned()) {
            this.setShowInfoCenter(false);
        }
    };
    private final WeakEventHandler<MouseEvent> weakMouseClickedHandler = new WeakEventHandler(this.mouseClickedHandler);
    private ObjectProperty<Duration> autoHideDuration;
    private BooleanProperty pinned;
    private BooleanProperty autoHide;
    private ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private ObjectProperty<Duration> slideInDuration;
    private BooleanProperty showInfoCenter;

    public InfoCenterPane() {
        this(null);
        this.setFocusTraversable(false);
    }

    public InfoCenterPane(Node content) {
        this.getStyleClass().add((Object)"info-center-pane");
        this.infoCenterView.showAllGroupProperty().addListener(it -> this.requestLayout());
        this.contentProperty().addListener((it, oldContent, newContent) -> {
            if (oldContent != null) {
                oldContent.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.weakMouseClickedHandler);
            }
            if (newContent != null) {
                newContent.addEventFilter(MouseEvent.MOUSE_CLICKED, this.weakMouseClickedHandler);
            }
        });
        this.setContent(content);
        this.infoCenterView.addEventHandler(InfoCenterEvent.NOTIFICATION_ADDED, evt -> this.setShowInfoCenter(true));
        this.infoCenterView.addEventHandler(InfoCenterEvent.HIDE, evt -> {
            if (!this.isPinned()) {
                this.setShowInfoCenter(false);
            }
        });
        this.infoCenterView.getUnmodifiableNotifications().addListener(it -> {
            if (this.infoCenterView.getUnmodifiableNotifications().isEmpty() && !this.isPinned()) {
                this.setShowInfoCenter(false);
            }
        });
        this.infoCenterView.setOnMouseClicked(evt -> {
            if (!evt.isConsumed() && evt.isStillSincePress() && evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getSource() == this.infoCenterView) {
                if (!this.isPinned()) {
                    this.setShowInfoCenter(false);
                }
                evt.consume();
            }
        });
        this.pinnedProperty().addListener(it -> this.setShowInfoCenter(this.isPinned()));
        AnimationTimer timer = new AnimationTimer(){
            private long lastToggle;
            private boolean reset;
            {
                InfoCenterPane.this.showInfoCenterProperty().addListener(it -> {
                    if (InfoCenterPane.this.isShowInfoCenter()) {
                        this.reset();
                    }
                });
                InfoCenterPane.this.insideInfoCenter.addListener(it -> {
                    if (!InfoCenterPane.this.insideInfoCenter.get()) {
                        this.reset();
                    }
                });
                InfoCenterPane.this.infoCenterView.addEventHandler(InfoCenterEvent.ANY, evt -> this.reset());
            }

            private void reset() {
                this.reset = true;
            }

            public void handle(long now) {
                if (this.lastToggle == 0L || this.reset) {
                    this.lastToggle = now;
                    this.reset = false;
                } else {
                    long diff = now - this.lastToggle;
                    if ((double)diff >= InfoCenterPane.this.getAutoHideDuration().toMillis() * 1000000.0) {
                        if (!InfoCenterPane.this.isPinned() && !InfoCenterPane.this.insideInfoCenter.get() && InfoCenterPane.this.isAutoHide()) {
                            InfoCenterPane.this.setShowInfoCenter(false);
                        }
                        this.lastToggle = now;
                    }
                }
            }
        };
        TreeShowing.treeShowing((Node)this).addListener((p, o, n) -> {
            if (n.booleanValue()) {
                timer.start();
            } else {
                timer.stop();
            }
        });
        timer.start();
        this.infoCenterView.addEventHandler(MouseEvent.MOUSE_ENTERED, evt -> this.insideInfoCenter.set(true));
        this.infoCenterView.addEventHandler(MouseEvent.MOUSE_EXITED, evt -> this.insideInfoCenter.set(false));
    }

    protected Skin<?> createDefaultSkin() {
        return new InfoCenterPaneSkin(this);
    }

    public final Duration getAutoHideDuration() {
        return this.autoHideDuration == null ? DEFAULT_AUTO_HIDE_DURATION : (Duration)this.autoHideDuration.get();
    }

    public final ObjectProperty<Duration> autoHideDurationProperty() {
        if (this.autoHideDuration == null) {
            this.autoHideDuration = new SimpleObjectProperty((Object)this, "autoHideDuration", (Object)DEFAULT_AUTO_HIDE_DURATION);
        }
        return this.autoHideDuration;
    }

    public final void setAutoHideDuration(Duration autoHideDuration) {
        this.autoHideDurationProperty().set((Object)autoHideDuration);
    }

    public final boolean isPinned() {
        return this.pinned == null ? false : this.pinned.get();
    }

    public final BooleanProperty pinnedProperty() {
        if (this.pinned == null) {
            this.pinned = new SimpleBooleanProperty((Object)this, "pinned", false);
        }
        return this.pinned;
    }

    public final void setPinned(boolean pinned) {
        this.pinnedProperty().set(pinned);
    }

    public final boolean isAutoHide() {
        return this.autoHide == null ? true : this.autoHide.get();
    }

    public final BooleanProperty autoHideProperty() {
        if (this.autoHide == null) {
            this.autoHide = new SimpleBooleanProperty((Object)this, "autoHide", true);
        }
        return this.autoHide;
    }

    public final void setAutoHide(boolean autoHide) {
        this.autoHideProperty().set(autoHide);
    }

    public final InfoCenterView getInfoCenterView() {
        return this.infoCenterView;
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public final void setContent(Node content) {
        this.contentProperty().set((Object)content);
    }

    public final ObjectProperty<Duration> slideInDurationProperty() {
        if (this.slideInDuration == null) {
            this.slideInDuration = new SimpleObjectProperty((Object)this, "slideInDuration", (Object)DEFAULT_SLIDE_IN_DURATION);
        }
        return this.slideInDuration;
    }

    public final Duration getSlideInDuration() {
        return this.slideInDuration == null ? DEFAULT_SLIDE_IN_DURATION : (Duration)this.slideInDuration.get();
    }

    public final void setSlideInDuration(Duration duration) {
        this.slideInDurationProperty().set((Object)duration);
    }

    public final boolean isShowInfoCenter() {
        return this.showInfoCenter == null ? false : this.showInfoCenter.get();
    }

    public final BooleanProperty showInfoCenterProperty() {
        if (this.showInfoCenter == null) {
            this.showInfoCenter = new SimpleBooleanProperty((Object)this, "showInfoCenter", false);
        }
        return this.showInfoCenter;
    }

    public final void setShowInfoCenter(boolean showInfoCenter) {
        this.showInfoCenterProperty().set(showInfoCenter);
    }
}

