/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

public class AnyConverter {
    private static final Type m_XInterface_type = new Type(XInterface.class);

    public static Type getType(Object object) {
        Type t;
        if (null == object) {
            t = m_XInterface_type;
        } else if (object instanceof Any) {
            t = ((Any)object).getType();
            if (14 == t.getTypeClass().getValue()) {
                return AnyConverter.getType(((Any)object).getObject());
            }
        } else {
            t = new Type(object.getClass());
        }
        return t;
    }

    public static boolean isVoid(Object object) {
        return AnyConverter.containsType(TypeClass.VOID, object);
    }

    public static boolean isChar(Object object) {
        return AnyConverter.containsType(TypeClass.CHAR, object);
    }

    public static boolean isBoolean(Object object) {
        return AnyConverter.containsType(TypeClass.BOOLEAN, object);
    }

    public static boolean isByte(Object object) {
        return AnyConverter.containsType(TypeClass.BYTE, object);
    }

    public static boolean isShort(Object object) {
        return AnyConverter.containsType(TypeClass.SHORT, object);
    }

    public static boolean isInt(Object object) {
        return AnyConverter.containsType(TypeClass.LONG, object);
    }

    public static boolean isLong(Object object) {
        return AnyConverter.containsType(TypeClass.HYPER, object);
    }

    public static boolean isFloat(Object object) {
        return AnyConverter.containsType(TypeClass.FLOAT, object);
    }

    public static boolean isDouble(Object object) {
        return AnyConverter.containsType(TypeClass.DOUBLE, object);
    }

    public static boolean isString(Object object) {
        return AnyConverter.containsType(TypeClass.STRING, object);
    }

    public static boolean isEnum(Object object) {
        return AnyConverter.containsType(TypeClass.ENUM, object);
    }

    public static boolean isType(Object object) {
        return AnyConverter.containsType(TypeClass.TYPE, object);
    }

    public static boolean isObject(Object object) {
        int tc = AnyConverter.getType(object).getTypeClass().getValue();
        return 22 == tc || 17 == tc || 19 == tc || 20 == tc || 15 == tc;
    }

    public static boolean isArray(Object object) {
        return AnyConverter.containsType(TypeClass.SEQUENCE, object);
    }

    public static char toChar(Object object) throws IllegalArgumentException {
        Character ret = (Character)AnyConverter.convertSimple(TypeClass.CHAR, null, object);
        return ret.charValue();
    }

    public static boolean toBoolean(Object object) throws IllegalArgumentException {
        Boolean ret = (Boolean)AnyConverter.convertSimple(TypeClass.BOOLEAN, null, object);
        return ret;
    }

    public static byte toByte(Object object) throws IllegalArgumentException {
        Byte ret = (Byte)AnyConverter.convertSimple(TypeClass.BYTE, null, object);
        return ret;
    }

    public static short toShort(Object object) throws IllegalArgumentException {
        Short ret = (Short)AnyConverter.convertSimple(TypeClass.SHORT, null, object);
        return ret;
    }

    public static short toUnsignedShort(Object object) throws IllegalArgumentException {
        Short ret = (Short)AnyConverter.convertSimple(TypeClass.UNSIGNED_SHORT, null, object);
        return ret;
    }

    public static int toInt(Object object) throws IllegalArgumentException {
        Integer ret = (Integer)AnyConverter.convertSimple(TypeClass.LONG, null, object);
        return ret;
    }

    public static int toUnsignedInt(Object object) throws IllegalArgumentException {
        Integer ret = (Integer)AnyConverter.convertSimple(TypeClass.UNSIGNED_LONG, null, object);
        return ret;
    }

    public static long toLong(Object object) throws IllegalArgumentException {
        Long ret = (Long)AnyConverter.convertSimple(TypeClass.HYPER, null, object);
        return ret;
    }

    public static long toUnsignedLong(Object object) throws IllegalArgumentException {
        Long ret = (Long)AnyConverter.convertSimple(TypeClass.UNSIGNED_HYPER, null, object);
        return ret;
    }

    public static float toFloat(Object object) throws IllegalArgumentException {
        Float ret = (Float)AnyConverter.convertSimple(TypeClass.FLOAT, null, object);
        return ret.floatValue();
    }

    public static double toDouble(Object object) throws IllegalArgumentException {
        Double ret = (Double)AnyConverter.convertSimple(TypeClass.DOUBLE, null, object);
        return ret;
    }

    public static String toString(Object object) throws IllegalArgumentException {
        return (String)AnyConverter.convertSimple(TypeClass.STRING, null, object);
    }

    public static Type toType(Object object) throws IllegalArgumentException {
        return (Type)AnyConverter.convertSimple(TypeClass.TYPE, null, object);
    }

    public static Object toObject(Type type, Object object) throws IllegalArgumentException {
        return AnyConverter.convertSimple(type.getTypeClass(), type, object);
    }

    public static Object toObject(Class<?> clazz, Object object) throws IllegalArgumentException {
        return AnyConverter.toObject(new Type(clazz), object);
    }

    public static Object toArray(Object object) throws IllegalArgumentException {
        return AnyConverter.convertSimple(TypeClass.SEQUENCE, null, object);
    }

    private static boolean containsType(TypeClass what, Object object) {
        return AnyConverter.getType(object).getTypeClass().getValue() == what.getValue();
    }

    private static Object convertSimple(TypeClass destTClass, Type destType, Object object_) throws IllegalArgumentException {
        Type type;
        Object object;
        if (object_ instanceof Any) {
            Any a = (Any)object_;
            object = a.getObject();
            type = a.getType();
            if (14 == type.getTypeClass().getValue()) {
                return AnyConverter.convertSimple(destTClass, destType, object);
            }
        } else {
            object = object_;
            type = null == object ? m_XInterface_type : new Type(object.getClass());
        }
        int tc = type.getTypeClass().getValue();
        int dest_tc = destTClass.getValue();
        if (null == object) {
            if (22 == tc && dest_tc == tc) {
                return null;
            }
        } else {
            switch (dest_tc) {
                case 1: {
                    if (tc != 1) break;
                    return object;
                }
                case 2: {
                    if (tc != 2) break;
                    return object;
                }
                case 3: {
                    if (tc != 3) break;
                    return object;
                }
                case 4: {
                    switch (tc) {
                        case 3: {
                            return (short)((Byte)object).byteValue();
                        }
                        case 4: {
                            return object;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (tc) {
                        case 5: {
                            return object;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (tc) {
                        case 3: {
                            return (int)((Byte)object).byteValue();
                        }
                        case 4: 
                        case 5: {
                            return (int)((Short)object).shortValue();
                        }
                        case 6: {
                            return object;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (tc) {
                        case 5: {
                            return (int)((Short)object).shortValue();
                        }
                        case 7: {
                            return object;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (tc) {
                        case 3: {
                            return (long)((Byte)object).byteValue();
                        }
                        case 4: 
                        case 5: {
                            return (long)((Short)object).shortValue();
                        }
                        case 6: 
                        case 7: {
                            return (long)((Integer)object).intValue();
                        }
                        case 8: {
                            return object;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (tc) {
                        case 5: {
                            return (long)((Short)object).shortValue();
                        }
                        case 7: {
                            return (long)((Integer)object).intValue();
                        }
                        case 9: {
                            return object;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (tc) {
                        case 3: {
                            return Float.valueOf(((Byte)object).byteValue());
                        }
                        case 4: {
                            return Float.valueOf(((Short)object).shortValue());
                        }
                        case 10: {
                            return object;
                        }
                    }
                    break;
                }
                case 11: {
                    switch (tc) {
                        case 3: {
                            return (double)((Byte)object).byteValue();
                        }
                        case 4: {
                            return (double)((Short)object).shortValue();
                        }
                        case 6: {
                            return (double)((Integer)object).intValue();
                        }
                        case 10: {
                            return (double)((Float)object).floatValue();
                        }
                        case 11: {
                            return object;
                        }
                    }
                    break;
                }
                case 15: {
                    if (tc != 15 || null != destType && !destType.equals(type)) break;
                    return object;
                }
                case 12: {
                    if (tc != 12) break;
                    return object;
                }
                case 13: {
                    if (tc != 13) break;
                    return object;
                }
                case 22: {
                    if (!(object instanceof XInterface)) break;
                    return UnoRuntime.queryInterface(destType, object);
                }
                case 17: 
                case 19: {
                    if (!destType.isSupertypeOf(type)) break;
                    return object;
                }
                case 20: {
                    if (tc != 20 || null != destType && !destType.equals(type)) break;
                    return object;
                }
            }
        }
        throw new IllegalArgumentException("The Argument did not hold the proper type");
    }
}

