/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.Range;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.DataKey;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.BodyDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.EnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.TypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.BinaryExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.EnclosedExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.FieldAccessExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodCallExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodReferenceExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NameExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ObjectCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.SimpleName;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ThisExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.VariableDeclarationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ForEachStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodAmbiguityException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Navigator;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Solver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.SymbolResolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.ConstructorResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.JavaSymbolSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.FailureHandler;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.TypeExtractor;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.FieldAccessContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnonymousClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.SymbolSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Log;

public class JavaParserFacade {
    private static final DataKey<ResolvedType> TYPE_WITH_LAMBDAS_RESOLVED = new DataKey<ResolvedType>(){};
    private static final DataKey<ResolvedType> TYPE_WITHOUT_LAMBDAS_RESOLVED = new DataKey<ResolvedType>(){};
    private static final Map<TypeSolver, JavaParserFacade> instances = new WeakHashMap<TypeSolver, JavaParserFacade>();
    private static final String JAVA_LANG_STRING = String.class.getCanonicalName();
    private final TypeSolver typeSolver;
    private final TypeExtractor typeExtractor;
    private final Solver symbolSolver;
    private final SymbolResolver symbolResolver;
    private FailureHandler failureHandler;

    public static synchronized JavaParserFacade get(TypeSolver typeSolver) {
        return instances.computeIfAbsent(typeSolver.getRoot(), JavaParserFacade::new);
    }

    public static void clearInstances() {
        instances.clear();
    }

    private JavaParserFacade(TypeSolver typeSolver) {
        this.typeSolver = typeSolver.getRoot();
        this.symbolSolver = new SymbolSolver(typeSolver);
        this.typeExtractor = new TypeExtractor(this.typeSolver, this);
        this.failureHandler = new FailureHandler();
        this.symbolResolver = new JavaSymbolSolver(this.typeSolver);
    }

    public TypeSolver getTypeSolver() {
        return this.typeSolver;
    }

    public Solver getSymbolSolver() {
        return this.symbolSolver;
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(NameExpr nameExpr) {
        return this.symbolSolver.solveSymbol(nameExpr.getName().getId(), nameExpr);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(SimpleName nameExpr) {
        return this.symbolSolver.solveSymbol(nameExpr.getId(), nameExpr);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(Expression expr) {
        return (SymbolReference)expr.toNameExpr().map(this::solve).orElseThrow((Supplier<IllegalArgumentException> & Serializable)() -> new IllegalArgumentException(expr.getClass().getCanonicalName()));
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodCallExpr methodCallExpr) {
        return this.solve(methodCallExpr, true);
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodReferenceExpr methodReferenceExpr) {
        return this.solve(methodReferenceExpr, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ObjectCreationExpr objectCreationExpr) {
        return this.solve(objectCreationExpr, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt) {
        return this.solve(explicitConstructorInvocationStmt, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, boolean solveLambdas) {
        Optional optAncestorClassOrInterfaceNode = explicitConstructorInvocationStmt.findAncestor(ClassOrInterfaceDeclaration.class);
        if (!optAncestorClassOrInterfaceNode.isPresent()) {
            return SymbolReference.unsolved();
        }
        ClassOrInterfaceDeclaration classOrInterfaceNode = (ClassOrInterfaceDeclaration)optAncestorClassOrInterfaceNode.get();
        ResolvedReferenceTypeDeclaration resolvedClassNode = classOrInterfaceNode.resolve();
        if (!resolvedClassNode.isClass()) {
            throw new IllegalStateException("Expected to be a class -- cannot call this() or super() within an interface.");
        }
        ResolvedTypeDeclaration typeDecl = null;
        if (explicitConstructorInvocationStmt.isThis()) {
            typeDecl = resolvedClassNode.asReferenceType();
        } else {
            Optional<ResolvedReferenceType> superClass = resolvedClassNode.asClass().getSuperClass();
            if (superClass.isPresent() && superClass.get().getTypeDeclaration().isPresent()) {
                typeDecl = superClass.get().getTypeDeclaration().get();
            }
        }
        if (typeDecl == null) {
            return SymbolReference.unsolved();
        }
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments(explicitConstructorInvocationStmt, explicitConstructorInvocationStmt.getArguments(), solveLambdas, argumentTypes, placeholders);
        SymbolReference<ResolvedConstructorDeclaration> res = ConstructorResolutionLogic.findMostApplicable(((ResolvedClassDeclaration)typeDecl).getConstructors(), argumentTypes, this.typeSolver);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    public SymbolReference<ResolvedTypeDeclaration> solve(ThisExpr node) {
        if (node.getTypeName().isPresent()) {
            Optional<ClassOrInterfaceDeclaration> classByName;
            String className = node.getTypeName().get().asString();
            SymbolReference<ResolvedReferenceTypeDeclaration> clazz = this.typeSolver.tryToSolveType(className);
            if (clazz.isSolved()) {
                return SymbolReference.solved(clazz.getCorrespondingDeclaration());
            }
            Optional cu = node.findAncestor(CompilationUnit.class);
            if (cu.isPresent() && (classByName = ((CompilationUnit)cu.get()).getClassByName(className)).isPresent()) {
                return SymbolReference.solved(this.getTypeDeclaration(classByName.get()));
            }
        }
        return SymbolReference.solved(this.getTypeDeclaration(this.findContainingTypeDeclOrObjectCreationExpr(node)));
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ObjectCreationExpr objectCreationExpr, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments(objectCreationExpr, objectCreationExpr.getArguments(), solveLambdas, argumentTypes, placeholders);
        ResolvedReferenceTypeDeclaration typeDecl = null;
        if (objectCreationExpr.getAnonymousClassBody().isPresent()) {
            typeDecl = new JavaParserAnonymousClassDeclaration(objectCreationExpr, this.typeSolver);
        } else {
            ResolvedType classDecl = JavaParserFacade.get(this.typeSolver).convert((Type)objectCreationExpr.getType(), objectCreationExpr);
            if (classDecl.isReferenceType() && classDecl.asReferenceType().getTypeDeclaration().isPresent()) {
                typeDecl = classDecl.asReferenceType().getTypeDeclaration().get();
            }
        }
        if (typeDecl == null) {
            return SymbolReference.unsolved();
        }
        SymbolReference<ResolvedConstructorDeclaration> res = ConstructorResolutionLogic.findMostApplicable(typeDecl.getConstructors(), argumentTypes, this.typeSolver);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    private void solveArguments(Node node, NodeList<Expression> args, boolean solveLambdas, List<ResolvedType> argumentTypes, List<LambdaArgumentTypePlaceholder> placeholders) {
        int i = 0;
        for (Expression parameterValue : args) {
            while (parameterValue instanceof EnclosedExpr) {
                parameterValue = ((EnclosedExpr)parameterValue).getInner();
            }
            if (parameterValue.isLambdaExpr() || parameterValue.isMethodReferenceExpr()) {
                LambdaArgumentTypePlaceholder placeholder = new LambdaArgumentTypePlaceholder(i);
                argumentTypes.add(placeholder);
                placeholders.add(placeholder);
            } else {
                try {
                    argumentTypes.add(JavaParserFacade.get(this.typeSolver).getType(parameterValue, solveLambdas));
                }
                catch (Exception e) {
                    throw this.failureHandler.handle(e, String.format("Unable to calculate the type of a parameter of a method call. Method call: %s, Parameter: %s", node, parameterValue));
                }
            }
            ++i;
        }
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodCallExpr methodCallExpr, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments(methodCallExpr, methodCallExpr.getArguments(), solveLambdas, argumentTypes, placeholders);
        SymbolReference<ResolvedMethodDeclaration> res = JavaParserFactory.getContext(methodCallExpr, this.typeSolver).solveMethod(methodCallExpr.getName().getId(), argumentTypes, false);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodReferenceExpr methodReferenceExpr, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        return JavaParserFactory.getContext(methodReferenceExpr, this.typeSolver).solveMethod(methodReferenceExpr.getIdentifier(), argumentTypes, false);
    }

    public SymbolReference<ResolvedAnnotationDeclaration> solve(AnnotationExpr annotationExpr) {
        Context context = JavaParserFactory.getContext(annotationExpr, this.typeSolver);
        SymbolReference<ResolvedTypeDeclaration> typeDeclarationSymbolReference = context.solveType(annotationExpr.getNameAsString());
        if (typeDeclarationSymbolReference.isSolved()) {
            ResolvedAnnotationDeclaration annotationDeclaration = (ResolvedAnnotationDeclaration)typeDeclarationSymbolReference.getCorrespondingDeclaration();
            return SymbolReference.solved(annotationDeclaration);
        }
        return SymbolReference.unsolved();
    }

    public SymbolReference<ResolvedValueDeclaration> solve(FieldAccessExpr fieldAccessExpr) {
        return ((FieldAccessContext)JavaParserFactory.getContext(fieldAccessExpr, this.typeSolver)).solveField(fieldAccessExpr.getName().getId());
    }

    public ResolvedType getType(Node node) {
        try {
            return this.getType(node, true);
        }
        catch (UnsolvedSymbolException e) {
            if (node instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)node;
                SymbolReference<ResolvedTypeDeclaration> typeDeclaration = JavaParserFactory.getContext(node, this.typeSolver).solveType(nameExpr.getNameAsString());
                if (typeDeclaration.isSolved() && typeDeclaration.getCorrespondingDeclaration() instanceof ResolvedReferenceTypeDeclaration) {
                    ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration = (ResolvedReferenceTypeDeclaration)typeDeclaration.getCorrespondingDeclaration();
                    return ReferenceTypeImpl.undeterminedParameters(resolvedReferenceTypeDeclaration);
                }
            }
            throw this.failureHandler.handle(e);
        }
    }

    public ResolvedType getType(Node node, boolean solveLambdas) {
        if (solveLambdas) {
            if (!node.containsData(TYPE_WITH_LAMBDAS_RESOLVED)) {
                ResolvedType res = this.getTypeConcrete(node, solveLambdas);
                node.setData(TYPE_WITH_LAMBDAS_RESOLVED, res);
                boolean secondPassNecessary = false;
                if (node instanceof MethodCallExpr) {
                    MethodCallExpr methodCallExpr = (MethodCallExpr)node;
                    for (Node node2 : methodCallExpr.getArguments()) {
                        if (node2.containsData(TYPE_WITH_LAMBDAS_RESOLVED)) continue;
                        this.getType(node2, true);
                        secondPassNecessary = true;
                    }
                }
                if (secondPassNecessary) {
                    node.removeData(TYPE_WITH_LAMBDAS_RESOLVED);
                    ResolvedType type = this.getType(node, true);
                    node.setData(TYPE_WITH_LAMBDAS_RESOLVED, type);
                }
                Log.trace("getType on %s  -> %s", (Supplier<Object> & Serializable)() -> node, (Supplier<Object> & Serializable)() -> res);
            }
            return node.getData(TYPE_WITH_LAMBDAS_RESOLVED);
        }
        Optional<ResolvedType> res = this.find(TYPE_WITH_LAMBDAS_RESOLVED, node);
        if (res.isPresent()) {
            return res.get();
        }
        res = this.find(TYPE_WITHOUT_LAMBDAS_RESOLVED, node);
        if (!res.isPresent()) {
            ResolvedType resType = this.getTypeConcrete(node, solveLambdas);
            node.setData(TYPE_WITHOUT_LAMBDAS_RESOLVED, resType);
            Optional<ResolvedType> finalRes = res;
            Log.trace("getType on %s (no solveLambdas) -> %s", (Supplier<Object> & Serializable)() -> node, (Supplier<Object> & Serializable)() -> finalRes);
            return resType;
        }
        return res.get();
    }

    private Optional<ResolvedType> find(DataKey<ResolvedType> dataKey, Node node) {
        if (node.containsData(dataKey)) {
            return Optional.of(node.getData(dataKey));
        }
        return Optional.empty();
    }

    protected MethodUsage toMethodUsage(MethodReferenceExpr methodReferenceExpr, List<ResolvedType> paramTypes) {
        Optional<MethodUsage> result;
        Expression scope = methodReferenceExpr.getScope();
        ResolvedType typeOfScope = this.getType(methodReferenceExpr.getScope());
        if (!typeOfScope.isReferenceType()) {
            throw new UnsupportedOperationException(typeOfScope.getClass().getCanonicalName());
        }
        ResolvedReferenceTypeDeclaration resolvedTypdeDecl = typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow((Supplier<RuntimeException> & Serializable)() -> new RuntimeException("TypeDeclaration unexpectedly empty."));
        Set<MethodUsage> allMethods = resolvedTypdeDecl.getAllMethods();
        if (scope.isTypeExpr()) {
            List<MethodUsage> staticMethodUsages = allMethods.stream().filter((Predicate<MethodUsage> & Serializable)it -> it.getDeclaration().isStatic()).collect(Collectors.toList());
            result = MethodResolutionLogic.findMostApplicableUsage(staticMethodUsages, methodReferenceExpr.getIdentifier(), paramTypes, this.typeSolver);
            if (!paramTypes.isEmpty()) {
                List<MethodUsage> instanceMethodUsages = allMethods.stream().filter((Predicate<MethodUsage> & Serializable)it -> !it.getDeclaration().isStatic()).collect(Collectors.toList());
                ArrayList<ResolvedType> instanceMethodParamTypes = new ArrayList<ResolvedType>(paramTypes);
                instanceMethodParamTypes.remove(0);
                Optional<MethodUsage> instanceResult = MethodResolutionLogic.findMostApplicableUsage(instanceMethodUsages, methodReferenceExpr.getIdentifier(), instanceMethodParamTypes, this.typeSolver);
                if (result.isPresent() && instanceResult.isPresent()) {
                    throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method for " + methodReferenceExpr.getIdentifier());
                }
                if (instanceResult.isPresent()) {
                    result = instanceResult;
                }
            }
        } else {
            result = MethodResolutionLogic.findMostApplicableUsage(new ArrayList<MethodUsage>(allMethods), methodReferenceExpr.getIdentifier(), paramTypes, this.typeSolver);
            if (result.isPresent() && result.get().getDeclaration().isStatic()) {
                throw new RuntimeException("Invalid static method reference " + methodReferenceExpr.getIdentifier());
            }
        }
        if (!result.isPresent()) {
            throw new UnsupportedOperationException();
        }
        return result.get();
    }

    protected ResolvedType getBinaryTypeConcrete(Node left, Node right, boolean solveLambdas, BinaryExpr.Operator operator) {
        boolean isRightNumeric;
        ResolvedType leftType = this.getTypeConcrete(left, solveLambdas);
        ResolvedType rightType = this.getTypeConcrete(right, solveLambdas);
        if (operator == BinaryExpr.Operator.PLUS) {
            boolean isRightString;
            boolean isLeftString = leftType.isReferenceType() && leftType.asReferenceType().getQualifiedName().equals(JAVA_LANG_STRING);
            boolean bl = isRightString = rightType.isReferenceType() && rightType.asReferenceType().getQualifiedName().equals(JAVA_LANG_STRING);
            if (isLeftString || isRightString) {
                return isLeftString ? leftType : rightType;
            }
        }
        boolean isLeftNumeric = leftType.isPrimitive() && leftType.asPrimitive().isNumeric();
        boolean bl = isRightNumeric = rightType.isPrimitive() && rightType.asPrimitive().isNumeric();
        if (isLeftNumeric && isRightNumeric) {
            return leftType.asPrimitive().bnp(rightType.asPrimitive());
        }
        if (rightType.isAssignableBy(leftType)) {
            return rightType;
        }
        return leftType;
    }

    private ResolvedType getTypeConcrete(Node node, boolean solveLambdas) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        return node.accept(this.typeExtractor, Boolean.valueOf(solveLambdas));
    }

    protected TypeDeclaration<?> findContainingTypeDecl(Node node) {
        Node parent = node;
        while (!((parent = Navigator.demandParentNode(parent)) instanceof TypeDeclaration)) {
        }
        return (TypeDeclaration)parent;
    }

    protected Node findContainingTypeDeclOrObjectCreationExpr(Node node) {
        Node parent = node;
        boolean detachFlag = false;
        do {
            if (!((parent = Navigator.demandParentNode(parent)) instanceof BodyDeclaration)) continue;
            if (parent instanceof TypeDeclaration) {
                return parent;
            }
            detachFlag = true;
        } while (!(parent instanceof ObjectCreationExpr) || !detachFlag);
        return parent;
    }

    protected Node findContainingTypeDeclOrObjectCreationExpr(Node node, String className) {
        Node parent = node;
        boolean detachFlag = false;
        do {
            if (!((parent = Navigator.demandParentNode(parent)) instanceof BodyDeclaration)) continue;
            if (parent instanceof TypeDeclaration && ((TypeDeclaration)parent).getFullyQualifiedName().get().endsWith(className)) {
                return parent;
            }
            detachFlag = true;
        } while (!(parent instanceof ObjectCreationExpr) || !((ObjectCreationExpr)parent).getType().getName().asString().equals(className) || !detachFlag);
        return parent;
    }

    protected ResolvedType convertToUsage(Type type, Context context) {
        if (context == null) {
            throw new NullPointerException("Context should not be null");
        }
        return type.convertToUsage(context);
    }

    public ResolvedType convertToUsage(Type type) {
        return this.convertToUsage(type, JavaParserFactory.getContext(type, this.typeSolver));
    }

    private Optional<ForEachStmt> forEachStmtWithVariableDeclarator(VariableDeclarator variableDeclarator) {
        Optional<Node> node = variableDeclarator.getParentNode();
        if (!node.isPresent() || !(node.get() instanceof VariableDeclarationExpr)) {
            return Optional.empty();
        }
        if (!(node = node.get().getParentNode()).isPresent() || !(node.get() instanceof ForEachStmt)) {
            return Optional.empty();
        }
        return Optional.of((ForEachStmt)node.get());
    }

    public ResolvedType convert(Type type, Node node) {
        return this.convert(type, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public ResolvedType convert(Type type, Context context) {
        return this.convertToUsage(type, context);
    }

    public MethodUsage solveMethodAsUsage(MethodCallExpr call) {
        Context context;
        Optional<MethodUsage> methodUsage;
        ArrayList<ResolvedType> params = new ArrayList<ResolvedType>();
        if (call.getArguments() != null) {
            for (Expression param : call.getArguments()) {
                try {
                    params.add(this.getType(param, false));
                }
                catch (Exception e) {
                    throw this.failureHandler.handle(e, String.format("Error calculating the type of parameter %s of method call %s", param, call));
                }
            }
        }
        if (!(methodUsage = (context = JavaParserFactory.getContext(call, this.typeSolver)).solveMethodAsUsage(call.getName().getId(), params)).isPresent()) {
            throw new UnsolvedSymbolException("Method '" + call.getName() + "' cannot be resolved in context " + call + " (line: " + call.getRange().map((Function<Range, String> & Serializable)r -> "" + r.begin.line).orElse("??") + ") " + context + ". Parameter types: " + params);
        }
        return methodUsage.get();
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(Node node) {
        if (node instanceof TypeDeclaration) {
            return this.getTypeDeclaration((TypeDeclaration)node);
        }
        if (node instanceof ObjectCreationExpr) {
            return new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)node, this.typeSolver);
        }
        throw new IllegalArgumentException();
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        return this.symbolResolver.toTypeDeclaration(classOrInterfaceDeclaration);
    }

    public ResolvedType getTypeOfThisIn(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            return new ReferenceTypeImpl(this.getTypeDeclaration((ClassOrInterfaceDeclaration)node));
        }
        if (node instanceof EnumDeclaration) {
            JavaParserEnumDeclaration enumDeclaration = new JavaParserEnumDeclaration((EnumDeclaration)node, this.typeSolver);
            return new ReferenceTypeImpl(enumDeclaration);
        }
        if (node instanceof ObjectCreationExpr && ((ObjectCreationExpr)node).getAnonymousClassBody().isPresent()) {
            JavaParserAnonymousClassDeclaration anonymousDeclaration = new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)node, this.typeSolver);
            return new ReferenceTypeImpl(anonymousDeclaration);
        }
        return this.getTypeOfThisIn(Navigator.demandParentNode(node));
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(TypeDeclaration<?> typeDeclaration) {
        return this.symbolResolver.toTypeDeclaration(typeDeclaration);
    }

    @Deprecated
    public ResolvedType classToResolvedType(Class<?> clazz) {
        SymbolSolver symbolSolver = new SymbolSolver(new ReflectionTypeSolver());
        return symbolSolver.classToResolvedType(clazz);
    }
}

