/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.CPX;
import fpc.tools.javapp.CPX2;
import fpc.tools.javapp.ClassData;
import fpc.tools.javapp.ClassIdentifierInfo;
import fpc.tools.javapp.FieldData;
import fpc.tools.javapp.InnerClassData;
import fpc.tools.javapp.JavapEnvironment;
import fpc.tools.javapp.MethodData;
import fpc.tools.javapp.PascalFieldData;
import fpc.tools.javapp.PascalInnerClassData;
import fpc.tools.javapp.PascalMethodData;
import fpc.tools.javapp.PascalUnit;
import fpc.tools.javapp.TypeSignature;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PascalClassData
extends ClassData {
    private JavapEnvironment env;
    public PascalClassData outerClass;
    private HashSet<String> nestedDependencies;
    boolean setOuterDependencies;
    public static PascalUnit currentUnit;
    static final String[] nonNestedDollarClasses;

    static {
        nonNestedDollarClasses = new String[1];
        PascalClassData.nonNestedDollarClasses[0] = "com/sun/org/apache/xalan/internal/xsltc/compiler/CUP$XPathParser$actions";
    }

    public PascalClassData(InputStream infile, PascalClassData outerClass, JavapEnvironment env, boolean doCollectDependencies) {
        super(infile);
        this.outerClass = outerClass;
        this.nestedDependencies = new HashSet();
        this.env = env;
        ClassIdentifierInfo.registerClassInfo(this.getClassName(), this.getSuperClassName(), this.getSuperInterfaces());
        if (doCollectDependencies) {
            this.collectDependencies();
        }
    }

    private void collectDependencies() {
        if (this.outerClass != null) {
            HashSet<String> myDeps = this.getDependencies();
            String mySuperClass = this.getSuperClassName();
            boolean foundMatch = false;
            String[] interfaces = this.getSuperInterfaces();
            boolean[] intfMatches = new boolean[interfaces.length];
            PascalClassData outerMostClass = this;
            while (outerMostClass.outerClass != null) {
                String outerClassName = outerMostClass.outerClass.getClassName();
                if (!foundMatch && mySuperClass.startsWith(outerClassName) && !mySuperClass.equals(outerClassName)) {
                    foundMatch = true;
                    outerMostClass.addNestedDepdency(mySuperClass);
                }
                int i = 0;
                while (i < interfaces.length) {
                    String intf;
                    if (!intfMatches[i] && (intf = interfaces[i]).startsWith(outerClassName) && !intf.equals(outerClassName)) {
                        intfMatches[i] = true;
                        outerMostClass.addNestedDepdency(intf);
                    }
                    ++i;
                }
                outerMostClass = outerMostClass.outerClass;
            }
            myDeps.remove(outerMostClass.getMasterClassName());
            outerMostClass.addNestedDepdencies(myDeps);
        }
    }

    public void addNestedDepdencies(HashSet<String> nestedDeps) {
        this.nestedDependencies.addAll(nestedDeps);
    }

    public void addNestedDepdency(String nestedDep) {
        this.nestedDependencies.add(nestedDep);
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public static boolean isInnerClass(String className) {
        if (className.indexOf(36) == -1) {
            return false;
        }
        className = className.replace('.', '/');
        String[] stringArray = nonNestedDollarClasses;
        int n = nonNestedDollarClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (className.equals(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isInnerClass() {
        return this.outerClass != null;
    }

    public static String getShortClassName(String className) {
        if (PascalClassData.isInnerClass(className = className.replace('-', '_'))) {
            int index = className.lastIndexOf("$") + 1;
            return "Inner" + className.substring(index);
        }
        int index = (className = className.replace("$", "__")).lastIndexOf("/") + 1;
        if (index == 0) {
            index = className.lastIndexOf(".") + 1;
        }
        if (index != 0) {
            return className.substring(index);
        }
        return className;
    }

    public static String getMasterClassName(String className) {
        if (!PascalClassData.isInnerClass(className.replace('.', '/'))) {
            return className;
        }
        int index = className.indexOf(36);
        if (index != -1) {
            return className.substring(0, index);
        }
        return className;
    }

    public static String getShortPascalClassName(String className) {
        currentUnit.registerUsedClass(className);
        return currentUnit.getShortPascalName(className);
    }

    public static String getClassPackageName(String className) {
        int index = className.lastIndexOf("/");
        if (index == -1) {
            index = className.lastIndexOf(".");
        }
        if (index != -1) {
            return className.substring(0, index).replace('/', '.');
        }
        return null;
    }

    public static String getFullPascalClassName(String className) {
        return PascalClassData.getShortPascalClassName(className);
    }

    public static String getExternalClassName(String className) {
        int index = className.lastIndexOf(47);
        if (index != -1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String getExternalShortClassName(String className) {
        if (PascalClassData.isInnerClass(className)) {
            int index = className.lastIndexOf("$") + 1;
            return className.substring(index);
        }
        return PascalClassData.getExternalClassName(className);
    }

    public String getShortClassName() {
        return PascalClassData.getShortClassName(this.getClassName());
    }

    public String getShortPascalClassName() {
        return PascalClassData.getShortPascalClassName(this.getClassName());
    }

    public String getClassPackageName() {
        return PascalClassData.getClassPackageName(this.getClassName());
    }

    public String getFullPascalClassName() {
        return PascalClassData.getFullPascalClassName(this.getClassName());
    }

    public String getMasterClassName() {
        return PascalClassData.getMasterClassName(this.getClassName());
    }

    public String getExternalClassName() {
        return PascalClassData.getExternalClassName(this.getClassName());
    }

    public String getExternalShortClassName() {
        return PascalClassData.getExternalShortClassName(this.getClassName());
    }

    public String[] getPascalSuperInterfaces() {
        String[] res = super.getSuperInterfaces();
        int i = 0;
        while (i < res.length) {
            res[i] = PascalClassData.getFullPascalClassName(res[i]);
            ++i;
        }
        return res;
    }

    public String getVisibilitySectionName() {
        if (this.isInnerClass()) {
            if (this.isPublic()) {
                return "public";
            }
            return "strict private";
        }
        return null;
    }

    public String[] getModifiers() {
        Vector<String> v = new Vector<String>();
        if ((this.access & 0x10) != 0) {
            v.addElement("sealed");
        }
        if ((this.access & 0x400) != 0) {
            v.addElement("abstract");
        }
        Object[] accflags = new String[v.size()];
        v.copyInto(accflags);
        return accflags;
    }

    @Override
    protected void readFields(DataInputStream in) throws IOException {
        int fields_count = in.readUnsignedShort();
        this.fields = new FieldData[fields_count];
        int k = 0;
        while (k < fields_count) {
            PascalFieldData field = new PascalFieldData(this);
            field.read(in);
            this.fields[k] = field;
            ++k;
        }
    }

    @Override
    protected void readMethods(DataInputStream in) throws IOException {
        int methods_count = in.readUnsignedShort();
        this.methods = new PascalMethodData[methods_count];
        int k = 0;
        while (k < methods_count) {
            PascalMethodData method = new PascalMethodData(this);
            method.read(in);
            this.methods[k] = method;
            ++k;
        }
    }

    @Override
    public String StringValue(int cpx) {
        Object x;
        byte tag;
        if (cpx == 0) {
            throw new ClassFormatError("Invalid CP index: 0");
        }
        try {
            tag = this.tags[cpx];
            x = this.cpool[cpx];
        }
        catch (IndexOutOfBoundsException e) {
            throw new ClassFormatError("<Incorrect CP index:" + cpx + ">");
        }
        if (x == null) {
            return "nil";
        }
        switch (tag) {
            case 1: {
                StringBuffer sb = new StringBuffer();
                String s = (String)x;
                sb.append('\'');
                int k = 0;
                while (k < s.length()) {
                    char c = s.charAt(k);
                    if (c == '\'') {
                        sb.append("''");
                    } else if (c >= ' ' && c <= '~') {
                        sb.append(c);
                    } else {
                        sb.append("'#$" + String.format("%04x", c) + "'");
                    }
                    ++k;
                }
                sb.append('\'');
                return sb.toString();
            }
            case 6: {
                Double d = (Double)x;
                String sd = d.toString();
                sd = sd.replace("Infinity", "1.0/0.0").replace("NaN", "0.0/0.0");
                return "jdouble(" + sd + ")";
            }
            case 4: {
                Float f = (Float)x;
                String sf = f.toString();
                sf = sf.replace("Infinity", "1.0/0.0").replace("NaN", "0.0/0.0");
                return "jfloat(" + sf + ")";
            }
            case 5: {
                Long ln = (Long)x;
                return "jlong(" + ln.toString() + ')';
            }
            case 3: {
                Integer in = (Integer)x;
                return in.toString();
            }
            case 7: {
                return this.javaName(this.getClassName(cpx));
            }
            case 8: {
                return this.StringValue(((CPX)x).cpx);
            }
            case 9: 
            case 10: 
            case 11: {
                return String.valueOf(this.javaName(this.getClassName(((CPX2)x).cpx1))) + "." + this.StringValue(((CPX2)x).cpx2);
            }
            case 12: {
                throw new ClassFormatError("Don't try to print out field/method/interfacemethod constant values");
            }
        }
        throw new ClassFormatError("Unknown constant tag: " + tag);
    }

    @Override
    protected InnerClassData NewInnerClassData() {
        return new PascalInnerClassData(this);
    }

    public HashSet<String> getDependencies() {
        MethodData[] methods;
        FieldData[] fields;
        String[] interfacelist;
        HashSet<String> res = new HashSet<String>();
        String superClass = this.getSuperClassName();
        if (superClass != null) {
            res.add(PascalClassData.getMasterClassName(superClass));
        }
        String[] stringArray = interfacelist = this.getSuperInterfaces();
        int n = interfacelist.length;
        int n2 = 0;
        while (n2 < n) {
            String intf = stringArray[n2];
            res.add(PascalClassData.getMasterClassName(intf));
            ++n2;
        }
        FieldData[] fieldDataArray = fields = this.getFields();
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            String fieldType;
            FieldData field = fieldDataArray[n];
            if (TypeSignature.checkAccess(field.getAccess(), this.env) && PascalClassData.isInnerClass(fieldType = ((PascalFieldData)field).getRawBaseType())) {
                res.add(PascalClassData.getMasterClassName(fieldType.replace('.', '/')));
            }
            ++n;
        }
        MethodData[] methodDataArray = methods = this.getMethods();
        int n4 = methods.length;
        n3 = 0;
        while (n3 < n4) {
            MethodData method = methodDataArray[n3];
            if (TypeSignature.checkAccess(method.getAccess(), this.env)) {
                String retType = ((PascalMethodData)method).getRawBaseReturnType();
                if (PascalClassData.isInnerClass(retType)) {
                    res.add(PascalClassData.getMasterClassName(retType.replace('.', '/')));
                }
                TypeSignature methodSig = new TypeSignature(method.getInternalSig());
                Vector<String> paras = methodSig.getParametersList(methodSig.parameterdes);
                int i = 0;
                while (i < paras.size()) {
                    String paraType = paras.get(i);
                    int arrPos = paraType.indexOf(91);
                    if (arrPos != -1) {
                        paraType = paraType.substring(0, arrPos);
                    }
                    if (PascalClassData.isInnerClass(paraType)) {
                        res.add(PascalClassData.getMasterClassName(paraType.replace('.', '/')));
                    }
                    ++i;
                }
            }
            ++n3;
        }
        res.addAll(this.nestedDependencies);
        res.remove(this.getClassName());
        return res;
    }
}

