/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.List;
import javafx.collections.ObservableList;
import org.reactfx.collection.ListModification;
import org.reactfx.util.Lists;

final class ListModificationImpl<E>
implements ListModification<E> {
    private int position;
    private List<? extends E> removed;
    private int addedSize;
    private final ObservableList<E> list;

    ListModificationImpl(int position, List<? extends E> removed, int addedSize, ObservableList<E> list) {
        this.position = position;
        this.removed = removed;
        this.addedSize = addedSize;
        this.list = list;
    }

    @Override
    public int getFrom() {
        return this.position;
    }

    @Override
    public List<? extends E> getRemoved() {
        return this.removed;
    }

    @Override
    public List<? extends E> getAddedSubList() {
        return this.list.subList(this.position, this.position + this.addedSize);
    }

    @Override
    public int getAddedSize() {
        return this.addedSize;
    }

    public String toString() {
        return "[modification at: " + this.getFrom() + ", removed: " + this.getRemoved() + ", added size: " + this.getAddedSize() + "]";
    }

    @Override
    public ListModification<E> trim() {
        return Lists.commonPrefixSuffixLengths(this.removed, this.getAddedSubList()).map((pref, suff) -> {
            if (pref == 0 && suff == 0) {
                return this;
            }
            return new ListModificationImpl<E>(this.position + pref, this.removed.subList((int)pref, this.getRemovedSize() - suff), this.addedSize - pref - suff, this.list);
        });
    }
}

