/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.scene.text.Font;
import javax.swing.UIManager;
import org.jabref.JabRefException;
import org.jabref.JabRefMain;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.entryeditor.EntryEditorTabList;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.preftabs.ImportSettingsTab;
import org.jabref.logic.bibtex.FieldContentParserPreferences;
import org.jabref.logic.bibtex.LatexFieldFormatterPreferences;
import org.jabref.logic.bibtexkeypattern.BibtexKeyPatternPreferences;
import org.jabref.logic.cleanup.CleanupPreferences;
import org.jabref.logic.cleanup.CleanupPreset;
import org.jabref.logic.cleanup.Cleanups;
import org.jabref.logic.exporter.ExporterFactory;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.TemplateExporter;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.format.FileLinkPreferences;
import org.jabref.logic.layout.format.NameFormatterPreferences;
import org.jabref.logic.net.ProxyPreferences;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.preferences.TimestampPreferences;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.protectedterms.ProtectedTermsPreferences;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.UpdateFieldPreferences;
import org.jabref.logic.util.Version;
import org.jabref.logic.util.io.AutoLinkPreferences;
import org.jabref.logic.util.io.FileHistory;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.model.cleanup.FieldFormatterCleanups;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.CustomEntryType;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.model.metadata.SaveOrderConfig;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.CustomExportList;
import org.jabref.preferences.CustomImportList;
import org.jabref.preferences.ExportComparator;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PreviewPreferences;
import org.jabref.preferences.SearchPreferences;
import org.jabref.preferences.VersionPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabRefPreferences
implements PreferencesService {
    public static final String EMACS_PATH = "emacsPath";
    public static final String EMACS_ADDITIONAL_PARAMETERS = "emacsParameters";
    public static final String TEXSTUDIO_PATH = "TeXstudioPath";
    public static final String WIN_EDT_PATH = "winEdtPath";
    public static final String TEXMAKER_PATH = "texmakerPath";
    public static final String VIM_SERVER = "vimServer";
    public static final String VIM = "vim";
    public static final String LYXPIPE = "lyxpipe";
    public static final String EXTERNAL_FILE_TYPES = "externalFileTypes";
    public static final String FONT_FAMILY = "fontFamily";
    public static final String WIN_LOOK_AND_FEEL = "lookAndFeel";
    public static final String FX_FONT_RENDERING_TWEAK = "fxFontRenderingTweak";
    public static final String LANGUAGE = "language";
    public static final String NAMES_LAST_ONLY = "namesLastOnly";
    public static final String ABBR_AUTHOR_NAMES = "abbrAuthorNames";
    public static final String NAMES_NATBIB = "namesNatbib";
    public static final String NAMES_FIRST_LAST = "namesFf";
    public static final String BIBLATEX_DEFAULT_MODE = "biblatexMode";
    public static final String NAMES_AS_IS = "namesAsIs";
    public static final String ENTRY_EDITOR_HEIGHT = "entryEditorHeight";
    public static final String AUTO_RESIZE_MODE = "autoResizeMode";
    public static final String WINDOW_MAXIMISED = "windowMaximised";
    public static final String USE_DEFAULT_LOOK_AND_FEEL = "useDefaultLookAndFeel";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_HOSTNAME = "proxyHostname";
    public static final String PROXY_USE = "useProxy";
    public static final String PROXY_USERNAME = "proxyUsername";
    public static final String PROXY_PASSWORD = "proxyPassword";
    public static final String PROXY_USE_AUTHENTICATION = "useProxyAuthentication";
    public static final String TABLE_PRIMARY_SORT_FIELD = "priSort";
    public static final String TABLE_PRIMARY_SORT_DESCENDING = "priDescending";
    public static final String TABLE_SECONDARY_SORT_FIELD = "secSort";
    public static final String TABLE_SECONDARY_SORT_DESCENDING = "secDescending";
    public static final String TABLE_TERTIARY_SORT_FIELD = "terSort";
    public static final String TABLE_TERTIARY_SORT_DESCENDING = "terDescending";
    public static final String REFORMAT_FILE_ON_SAVE_AND_EXPORT = "reformatFileOnSaveAndExport";
    public static final String EXPORT_IN_ORIGINAL_ORDER = "exportInOriginalOrder";
    public static final String EXPORT_IN_SPECIFIED_ORDER = "exportInSpecifiedOrder";
    public static final String EXPORT_PRIMARY_SORT_FIELD = "exportPriSort";
    public static final String EXPORT_PRIMARY_SORT_DESCENDING = "exportPriDescending";
    public static final String EXPORT_SECONDARY_SORT_FIELD = "exportSecSort";
    public static final String EXPORT_SECONDARY_SORT_DESCENDING = "exportSecDescending";
    public static final String EXPORT_TERTIARY_SORT_FIELD = "exportTerSort";
    public static final String EXPORT_TERTIARY_SORT_DESCENDING = "exportTerDescending";
    public static final String NEWLINE = "newline";
    public static final String COLUMN_WIDTHS = "columnWidths";
    public static final String COLUMN_NAMES = "columnNames";
    public static final String SIDE_PANE_COMPONENT_PREFERRED_POSITIONS = "sidePaneComponentPreferredPositions";
    public static final String SIDE_PANE_COMPONENT_NAMES = "sidePaneComponentNames";
    public static final String XMP_PRIVACY_FILTERS = "xmpPrivacyFilters";
    public static final String USE_XMP_PRIVACY_FILTER = "useXmpPrivacyFilter";
    public static final String DEFAULT_AUTO_SORT = "defaultAutoSort";
    public static final String DEFAULT_SHOW_SOURCE = "defaultShowSource";
    public static final String SIZE_Y = "mainWindowSizeY";
    public static final String SIZE_X = "mainWindowSizeX";
    public static final String POS_Y = "mainWindowPosY";
    public static final String POS_X = "mainWindowPosX";
    public static final String STRINGS_SIZE_Y = "stringsSizeY";
    public static final String STRINGS_SIZE_X = "stringsSizeX";
    public static final String STRINGS_POS_Y = "stringsPosY";
    public static final String STRINGS_POS_X = "stringsPosX";
    public static final String DUPLICATES_SIZE_Y = "duplicatesSizeY";
    public static final String DUPLICATES_SIZE_X = "duplicatesSizeX";
    public static final String DUPLICATES_POS_Y = "duplicatesPosY";
    public static final String DUPLICATES_POS_X = "duplicatesPosX";
    public static final String MERGEENTRIES_SIZE_Y = "mergeEntriesSizeY";
    public static final String MERGEENTRIES_SIZE_X = "mergeEntriesSizeX";
    public static final String MERGEENTRIES_POS_Y = "mergeEntriesPosY";
    public static final String MERGEENTRIES_POS_X = "mergeEntriesPosX";
    public static final String PREAMBLE_SIZE_Y = "preambleSizeY";
    public static final String PREAMBLE_SIZE_X = "preambleSizeX";
    public static final String PREAMBLE_POS_Y = "preamblePosY";
    public static final String PREAMBLE_POS_X = "preamblePosX";
    public static final String TERMS_SIZE_Y = "termsSizeY";
    public static final String TERMS_SIZE_X = "termsSizeX";
    public static final String TERMS_POS_Y = "termsPosY";
    public static final String TERMS_POS_X = "termsPosX";
    public static final String SEARCH_DIALOG_HEIGHT = "searchDialogHeight";
    public static final String SEARCH_DIALOG_WIDTH = "searchDialogWidth";
    public static final String IMPORT_INSPECTION_DIALOG_HEIGHT = "importInspectionDialogHeight";
    public static final String IMPORT_INSPECTION_DIALOG_WIDTH = "importInspectionDialogWidth";
    public static final String LAST_EDITED = "lastEdited";
    public static final String OPEN_LAST_EDITED = "openLastEdited";
    public static final String LAST_FOCUSED = "lastFocused";
    public static final String BACKUP = "backup";
    public static final String AUTO_OPEN_FORM = "autoOpenForm";
    public static final String IMPORT_WORKING_DIRECTORY = "importWorkingDirectory";
    public static final String EXPORT_WORKING_DIRECTORY = "exportWorkingDirectory";
    public static final String PREFS_EXPORT_PATH = "prefsExportPath";
    public static final String WORKING_DIRECTORY = "workingDirectory";
    public static final String NUMBER_COL_WIDTH = "numberColWidth";
    public static final String EDITOR_EMACS_KEYBINDINGS = "editorEMACSkeyBindings";
    public static final String EDITOR_EMACS_KEYBINDINGS_REBIND_CA = "editorEMACSkeyBindingsRebindCA";
    public static final String EDITOR_EMACS_KEYBINDINGS_REBIND_CF = "editorEMACSkeyBindingsRebindCF";
    public static final String GROUPS_DEFAULT_FIELD = "groupsDefaultField";
    public static final String GROUP_INTERSECT_SELECTIONS = "groupIntersectSelections";
    public static final String KEYWORD_SEPARATOR = "groupKeywordSeparator";
    public static final String AUTO_ASSIGN_GROUP = "autoAssignGroup";
    public static final String LIST_OF_FILE_COLUMNS = "listOfFileColumns";
    public static final String EXTRA_FILE_COLUMNS = "extraFileColumns";
    public static final String ARXIV_COLUMN = "arxivColumn";
    public static final String FILE_COLUMN = "fileColumn";
    public static final String PREFER_URL_DOI = "preferUrlDoi";
    public static final String URL_COLUMN = "urlColumn";
    public static final String TABLE_COLOR_CODES_ON = "tableColorCodesOn";
    public static final String TABLE_RESOLVED_COLOR_CODES_ON = "tableResolvedColorCodesOn";
    public static final String INCOMPLETE_ENTRY_BACKGROUND = "incompleteEntryBackground";
    public static final String FIELD_EDITOR_TEXT_COLOR = "fieldEditorTextColor";
    public static final String ACTIVE_FIELD_EDITOR_BACKGROUND_COLOR = "activeFieldEditorBackgroundColor";
    public static final String INVALID_FIELD_BACKGROUND_COLOR = "invalidFieldBackgroundColor";
    public static final String VALID_FIELD_BACKGROUND_COLOR = "validFieldBackgroundColor";
    public static final String MARKED_ENTRY_BACKGROUND5 = "markedEntryBackground5";
    public static final String MARKED_ENTRY_BACKGROUND4 = "markedEntryBackground4";
    public static final String MARKED_ENTRY_BACKGROUND3 = "markedEntryBackground3";
    public static final String MARKED_ENTRY_BACKGROUND2 = "markedEntryBackground2";
    public static final String MARKED_ENTRY_BACKGROUND1 = "markedEntryBackground1";
    public static final String MARKED_ENTRY_BACKGROUND0 = "markedEntryBackground0";
    public static final String VERY_GRAYED_OUT_TEXT = "veryGrayedOutText";
    public static final String VERY_GRAYED_OUT_BACKGROUND = "veryGrayedOutBackground";
    public static final String GRAYED_OUT_TEXT = "grayedOutText";
    public static final String GRAYED_OUT_BACKGROUND = "grayedOutBackground";
    public static final String GRID_COLOR = "gridColor";
    public static final String TABLE_TEXT = "tableText";
    public static final String TABLE_OPT_FIELD_BACKGROUND = "tableOptFieldBackground";
    public static final String TABLE_REQ_FIELD_BACKGROUND = "tableReqFieldBackground";
    public static final String MARKED_ENTRY_BACKGROUND = "markedEntryBackground";
    public static final String TABLE_RESOLVED_FIELD_BACKGROUND = "tableResolvedFieldBackground";
    public static final String TABLE_BACKGROUND = "tableBackground";
    public static final String ICON_ENABLED_COLOR = "iconEnabledColor";
    public static final String ICON_DISABLED_COLOR = "iconDisabledColor";
    public static final String TABLE_SHOW_GRID = "tableShowGrid";
    public static final String TABLE_ROW_PADDING = "tableRowPadding";
    public static final String MENU_FONT_SIZE = "menuFontSize";
    public static final String OVERRIDE_DEFAULT_FONTS = "overrideDefaultFonts";
    public static final String FONT_SIZE = "fontSize";
    public static final String FONT_STYLE = "fontStyle";
    public static final String ICON_SIZE_LARGE = "iconSizeLarge";
    public static final String ICON_SIZE_SMALL = "iconSizeSmall";
    public static final String RECENT_DATABASES = "recentDatabases";
    public static final String RENAME_ON_MOVE_FILE_TO_FILE_DIR = "renameOnMoveFileToFileDir";
    public static final String MEMORY_STICK_MODE = "memoryStickMode";
    public static final String DEFAULT_OWNER = "defaultOwner";
    public static final String DEFAULT_ENCODING = "defaultEncoding";
    public static final String TOOLBAR_VISIBLE = "toolbarVisible";
    public static final String USE_TIME_STAMP = "useTimeStamp";
    public static final String UPDATE_TIMESTAMP = "updateTimestamp";
    public static final String TIME_STAMP_FIELD = "timeStampField";
    public static final String TIME_STAMP_FORMAT = "timeStampFormat";
    public static final String OVERWRITE_TIME_STAMP = "overwriteTimeStamp";
    public static final String WARN_ABOUT_DUPLICATES_IN_INSPECTION = "warnAboutDuplicatesInInspection";
    public static final String UNMARK_ALL_ENTRIES_BEFORE_IMPORTING = "unmarkAllEntriesBeforeImporting";
    public static final String MARK_IMPORTED_ENTRIES = "markImportedEntries";
    public static final String GENERATE_KEYS_AFTER_INSPECTION = "generateKeysAfterInspection";
    public static final String NON_WRAPPABLE_FIELDS = "nonWrappableFields";
    public static final String RESOLVE_STRINGS_ALL_FIELDS = "resolveStringsAllFields";
    public static final String DO_NOT_RESOLVE_STRINGS_FOR = "doNotResolveStringsFor";
    public static final String MERGE_ENTRIES_DIFF_MODE = "mergeEntriesDiffMode";
    public static final String CUSTOM_EXPORT_FORMAT = "customExportFormat";
    public static final String CUSTOM_IMPORT_FORMAT = "customImportFormat";
    public static final String KEY_PATTERN_REGEX = "KeyPatternRegex";
    public static final String KEY_PATTERN_REPLACEMENT = "KeyPatternReplacement";
    public static final String CONSOLE_COMMAND = "consoleCommand";
    public static final String USE_DEFAULT_CONSOLE_APPLICATION = "useDefaultConsoleApplication";
    public static final String ADOBE_ACROBAT_COMMAND = "adobeAcrobatCommand";
    public static final String SUMATRA_PDF_COMMAND = "sumatraCommand";
    public static final String USE_PDF_READER = "usePDFReader";
    public static final String DEFAULT_BIBTEX_KEY_PATTERN = "defaultBibtexKeyPattern";
    public static final String GRAY_OUT_NON_HITS = "grayOutNonHits";
    public static final String CONFIRM_DELETE = "confirmDelete";
    public static final String WARN_BEFORE_OVERWRITING_KEY = "warnBeforeOverwritingKey";
    public static final String AVOID_OVERWRITING_KEY = "avoidOverwritingKey";
    public static final String OVERWRITE_OWNER = "overwriteOwner";
    public static final String USE_OWNER = "useOwner";
    public static final String AUTOLINK_EXACT_KEY_ONLY = "autolinkExactKeyOnly";
    public static final String SHOW_FILE_LINKS_UPGRADE_WARNING = "showFileLinksUpgradeWarning";
    public static final String SIDE_PANE_WIDTH = "sidePaneWidth";
    public static final String LAST_USED_EXPORT = "lastUsedExport";
    public static final String FLOAT_MARKED_ENTRIES = "floatMarkedEntries";
    public static final String CITE_COMMAND = "citeCommand";
    public static final String GENERATE_KEYS_BEFORE_SAVING = "generateKeysBeforeSaving";
    public static final String EMAIL_SUBJECT = "emailSubject";
    public static final String OPEN_FOLDERS_OF_ATTACHED_FILES = "openFoldersOfAttachedFiles";
    public static final String KEY_GEN_ALWAYS_ADD_LETTER = "keyGenAlwaysAddLetter";
    public static final String KEY_GEN_FIRST_LETTER_A = "keyGenFirstLetterA";
    public static final String ENFORCE_LEGAL_BIBTEX_KEY = "enforceLegalBibtexKey";
    public static final String LOCAL_AUTO_SAVE = "localAutoSave";
    public static final String RUN_AUTOMATIC_FILE_SEARCH = "runAutomaticFileSearch";
    public static final String NUMERIC_FIELDS = "numericFields";
    public static final String AUTOLINK_REG_EXP_SEARCH_EXPRESSION_KEY = "regExpSearchExpression";
    public static final String AUTOLINK_USE_REG_EXP_SEARCH_KEY = "useRegExpSearch";
    public static final String BIB_LOC_AS_PRIMARY_DIR = "bibLocAsPrimaryDir";
    public static final String SELECTED_FETCHER_INDEX = "selectedFetcherIndex";
    public static final String WEB_SEARCH_VISIBLE = "webSearchVisible";
    public static final String GROUP_SIDEPANE_VISIBLE = "groupSidepaneVisible";
    public static final String ALLOW_FILE_AUTO_OPEN_BROWSE = "allowFileAutoOpenBrowse";
    public static final String CUSTOM_TAB_NAME = "customTabName_";
    public static final String CUSTOM_TAB_FIELDS = "customTabFields_";
    public static final String USE_UNIT_FORMATTER_ON_SEARCH = "useUnitFormatterOnSearch";
    public static final String USE_CASE_KEEPER_ON_SEARCH = "useCaseKeeperOnSearch";
    public static final String ASK_AUTO_NAMING_PDFS_AGAIN = "AskAutoNamingPDFsAgain";
    public static final String CLEANUP_DOI = "CleanUpDOI";
    public static final String CLEANUP_ISSN = "CleanUpISSN";
    public static final String CLEANUP_MOVE_PDF = "CleanUpMovePDF";
    public static final String CLEANUP_MAKE_PATHS_RELATIVE = "CleanUpMakePathsRelative";
    public static final String CLEANUP_RENAME_PDF = "CleanUpRenamePDF";
    public static final String CLEANUP_RENAME_PDF_ONLY_RELATIVE_PATHS = "CleanUpRenamePDFonlyRelativePaths";
    public static final String CLEANUP_UPGRADE_EXTERNAL_LINKS = "CleanUpUpgradeExternalLinks";
    public static final String CLEANUP_CONVERT_TO_BIBLATEX = "CleanUpConvertToBiblatex";
    public static final String CLEANUP_CONVERT_TO_BIBTEX = "CleanUpConvertToBibtex";
    public static final String CLEANUP_FIX_FILE_LINKS = "CleanUpFixFileLinks";
    public static final String CLEANUP_FORMATTERS = "CleanUpFormatters";
    public static final String IMPORT_DEFAULT_PDF_IMPORT_STYLE = "importDefaultPDFimportStyle";
    public static final String IMPORT_ALWAYSUSE = "importAlwaysUsePDFImportStyle";
    public static final String IMPORT_FILENAMEPATTERN = "importFileNamePattern";
    public static final String IMPORT_FILEDIRPATTERN = "importFileDirPattern";
    public static final String NAME_FORMATTER_VALUE = "nameFormatterFormats";
    public static final String NAME_FORMATER_KEY = "nameFormatterNames";
    public static final String PUSH_TO_APPLICATION = "pushToApplication";
    public static final String SHOW_RECOMMENDATIONS = "showRecommendations";
    public static final String VALIDATE_IN_ENTRY_EDITOR = "validateInEntryEditor";
    public static final String DROPPEDFILEHANDLER_RENAME = "DroppedFileHandler_RenameFile";
    public static final String DROPPEDFILEHANDLER_MOVE = "DroppedFileHandler_MoveFile";
    public static final String DROPPEDFILEHANDLER_COPY = "DroppedFileHandler_CopyFile";
    public static final String DROPPEDFILEHANDLER_LEAVE = "DroppedFileHandler_LeaveFileInDir";
    public static final String USE_REMOTE_SERVER = "useRemoteServer";
    public static final String REMOTE_SERVER_PORT = "remoteServerPort";
    public static final String OO_EXECUTABLE_PATH = "ooExecutablePath";
    public static final String OO_PATH = "ooPath";
    public static final String OO_JARS_PATH = "ooJarsPath";
    public static final String OO_SHOW_PANEL = "showOOPanel";
    public static final String OO_SYNC_WHEN_CITING = "syncOOWhenCiting";
    public static final String OO_USE_ALL_OPEN_BASES = "useAllOpenBases";
    public static final String OO_BIBLIOGRAPHY_STYLE_FILE = "ooBibliographyStyleFile";
    public static final String OO_EXTERNAL_STYLE_FILES = "ooExternalStyleFiles";
    public static final String STYLES_SIZE_Y = "stylesSizeY";
    public static final String STYLES_SIZE_X = "stylesSizeX";
    public static final String STYLES_POS_Y = "stylesPosY";
    public static final String STYLES_POS_X = "stylesPosX";
    public static final String SHOWCOLUMN_RELEVANCE = "showRelevanceColumn";
    public static final String SHOWCOLUMN_READ = "showReadColumn";
    public static final String SHOWCOLUMN_RANKING = "showRankingColumn";
    public static final String SHOWCOLUMN_QUALITY = "showQualityColumn";
    public static final String SHOWCOLUMN_PRIORITY = "showPriorityColumn";
    public static final String SHOWCOLUMN_PRINTED = "showPrintedColumn";
    public static final String SPECIALFIELDSENABLED = "specialFieldsEnabled";
    public static final String SERIALIZESPECIALFIELDS = "serializeSpecialFields";
    public static final String AUTOSYNCSPECIALFIELDSTOKEYWORDS = "autoSyncSpecialFieldsToKeywords";
    public static final String BIBTEX_KEY_PATTERNS_NODE = "bibtexkeypatterns";
    public static final String CUSTOMIZED_BIBTEX_TYPES = "customizedBibtexTypes";
    public static final String CUSTOMIZED_BIBLATEX_TYPES = "customizedBiblatexTypes";
    public static final String VERSION_IGNORED_UPDATE = "versionIgnoreUpdate";
    public static final String BINDINGS = "bindings";
    public static final String AUTOCOMPLETER_COMPLETE_FIELDS = "autoCompleteFields";
    public static final String ID_ENTRY_GENERATOR = "idEntryGenerator";
    private static final String AUTO_COMPLETE = "autoComplete";
    private static final String AUTOCOMPLETER_FIRSTNAME_MODE = "autoCompFirstNameMode";
    private static final String AUTOCOMPLETER_LAST_FIRST = "autoCompLF";
    private static final String AUTOCOMPLETER_FIRST_LAST = "autoCompFF";
    private static final String BIND_NAMES = "bindNames";
    private static final String USER_ID = "userId";
    private static final String EXTERNAL_JOURNAL_LISTS = "externalJournalLists";
    private static final String PERSONAL_JOURNAL_LIST = "personalJournalList";
    private static final String USE_IEEE_ABRV = "useIEEEAbrv";
    private static final String COLLECT_TELEMETRY = "collectTelemetry";
    private static final String ALREADY_ASKED_TO_COLLECT_TELEMETRY = "askedCollectTelemetry";
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefPreferences.class);
    private static final Class PREFS_BASE_CLASS = JabRefMain.class;
    private static final String DB_CONNECT_USERNAME = "dbConnectUsername";
    private static final String DB_CONNECT_DATABASE = "dbConnectDatabase";
    private static final String DB_CONNECT_HOSTNAME = "dbConnectHostname";
    private static final String DB_CONNECT_SERVER_TYPE = "dbConnectServerType";
    private static final String PROTECTED_TERMS_ENABLED_EXTERNAL = "protectedTermsEnabledExternal";
    private static final String PROTECTED_TERMS_DISABLED_EXTERNAL = "protectedTermsDisabledExternal";
    private static final String PROTECTED_TERMS_ENABLED_INTERNAL = "protectedTermsEnabledInternal";
    private static final String PROTECTED_TERMS_DISABLED_INTERNAL = "protectedTermsDisabledInternal";
    private static final String CYCLE_PREVIEW_POS = "cyclePreviewPos";
    private static final String CYCLE_PREVIEW = "cyclePreview";
    private static final String PREVIEW_PANEL_HEIGHT = "previewPanelHeight";
    private static final String PREVIEW_STYLE = "previewStyle";
    private static final String PREVIEW_ENABLED = "previewEnabled";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final Integer UNSET_MENU_FONT_SIZE = -123;
    private static JabRefPreferences singleton;
    public final Map<String, Object> defaults = new HashMap<String, Object>();
    public final String MARKING_WITH_NUMBER_PATTERN;
    public final CustomExportList customExports;
    public final CustomImportList customImports;
    public List<String> fileDirForDatabase;
    private final Preferences prefs;
    private GlobalBibtexKeyPattern keyPattern;
    private EntryEditorTabList tabList;

    private JabRefPreferences() {
        try {
            if (new File("jabref.xml").exists()) {
                this.importPreferences("jabref.xml");
            }
        }
        catch (JabRefException e) {
            LOGGER.warn("Could not import preferences from jabref.xml: " + e.getMessage(), e);
        }
        this.prefs = Preferences.userNodeForPackage(PREFS_BASE_CLASS);
        Localization.setLanguage(this.prefs.get(LANGUAGE, "en"));
        SearchPreferences.putDefaults(this.defaults);
        this.defaults.put(TEXMAKER_PATH, JabRefDesktop.getNativeDesktop().detectProgramPath("texmaker", "Texmaker"));
        this.defaults.put(WIN_EDT_PATH, JabRefDesktop.getNativeDesktop().detectProgramPath("WinEdt", "WinEdt Team\\WinEdt"));
        this.defaults.put(TEXSTUDIO_PATH, JabRefDesktop.getNativeDesktop().detectProgramPath("texstudio", "TeXstudio"));
        this.defaults.put(BIBLATEX_DEFAULT_MODE, Boolean.FALSE);
        this.defaults.put(ID_ENTRY_GENERATOR, "DOI");
        if (OS.OS_X) {
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(WIN_LOOK_AND_FEEL, UIManager.getSystemLookAndFeelClassName());
            this.defaults.put(EMACS_PATH, "emacsclient");
        } else if (OS.WINDOWS) {
            this.defaults.put(WIN_LOOK_AND_FEEL, "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            this.defaults.put(EMACS_PATH, "emacsclient.exe");
        } else {
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(WIN_LOOK_AND_FEEL, "javax.swing.plaf.nimbus.NimbusLookAndFeel");
            this.defaults.put(EMACS_PATH, "emacsclient");
        }
        this.defaults.put(FX_FONT_RENDERING_TWEAK, OS.LINUX);
        this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-n -e");
        this.defaults.put(PUSH_TO_APPLICATION, "TeXstudio");
        this.defaults.put(RECENT_DATABASES, "");
        this.defaults.put(EXTERNAL_FILE_TYPES, "");
        this.defaults.put(KEY_PATTERN_REGEX, "");
        this.defaults.put(KEY_PATTERN_REPLACEMENT, "");
        this.defaults.put(PROXY_USE, Boolean.FALSE);
        this.defaults.put(PROXY_HOSTNAME, "");
        this.defaults.put(PROXY_PORT, "80");
        this.defaults.put(PROXY_USE_AUTHENTICATION, Boolean.FALSE);
        this.defaults.put(PROXY_USERNAME, "");
        this.defaults.put(PROXY_PASSWORD, "");
        this.defaults.put(USE_DEFAULT_LOOK_AND_FEEL, Boolean.TRUE);
        this.defaults.put(LYXPIPE, USER_HOME + File.separator + ".lyx/lyxpipe");
        this.defaults.put(VIM, VIM);
        this.defaults.put(VIM_SERVER, VIM);
        this.defaults.put(POS_X, 0);
        this.defaults.put(POS_Y, 0);
        this.defaults.put(SIZE_X, 1024);
        this.defaults.put(SIZE_Y, 768);
        this.defaults.put(WINDOW_MAXIMISED, Boolean.FALSE);
        this.defaults.put(AUTO_RESIZE_MODE, 4);
        this.defaults.put(ENTRY_EDITOR_HEIGHT, 400);
        this.defaults.put(TABLE_COLOR_CODES_ON, Boolean.FALSE);
        this.defaults.put(TABLE_RESOLVED_COLOR_CODES_ON, Boolean.FALSE);
        this.defaults.put(NAMES_AS_IS, Boolean.FALSE);
        this.defaults.put(NAMES_FIRST_LAST, Boolean.FALSE);
        this.defaults.put(NAMES_NATBIB, Boolean.TRUE);
        this.defaults.put(ABBR_AUTHOR_NAMES, Boolean.TRUE);
        this.defaults.put(NAMES_LAST_ONLY, Boolean.TRUE);
        this.defaults.put(LANGUAGE, Locale.getDefault().getLanguage());
        this.defaults.put(TABLE_PRIMARY_SORT_FIELD, "author");
        this.defaults.put(TABLE_PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(TABLE_SECONDARY_SORT_FIELD, "year");
        this.defaults.put(TABLE_SECONDARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(TABLE_TERTIARY_SORT_FIELD, "title");
        this.defaults.put(TABLE_TERTIARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(REFORMAT_FILE_ON_SAVE_AND_EXPORT, Boolean.FALSE);
        this.defaults.put(EXPORT_IN_ORIGINAL_ORDER, Boolean.FALSE);
        this.defaults.put(EXPORT_IN_SPECIFIED_ORDER, Boolean.FALSE);
        this.defaults.put(EXPORT_PRIMARY_SORT_FIELD, "bibtexkey");
        this.defaults.put(EXPORT_PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(EXPORT_SECONDARY_SORT_FIELD, "author");
        this.defaults.put(EXPORT_SECONDARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(EXPORT_TERTIARY_SORT_FIELD, "title");
        this.defaults.put(EXPORT_TERTIARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(NEWLINE, System.lineSeparator());
        this.defaults.put(SIDE_PANE_COMPONENT_NAMES, "");
        this.defaults.put(SIDE_PANE_COMPONENT_PREFERRED_POSITIONS, "");
        this.defaults.put(COLUMN_NAMES, "entrytype;author/editor;title;year;journal/booktitle;bibtexkey");
        this.defaults.put(COLUMN_WIDTHS, "75;300;470;60;130;100");
        this.defaults.put(XMP_PRIVACY_FILTERS, "pdf;timestamp;keywords;owner;note;review");
        this.defaults.put(USE_XMP_PRIVACY_FILTER, Boolean.FALSE);
        this.defaults.put(NUMBER_COL_WIDTH, 32);
        this.defaults.put(WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(EXPORT_WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(IMPORT_WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(PREFS_EXPORT_PATH, USER_HOME);
        this.defaults.put(AUTO_OPEN_FORM, Boolean.TRUE);
        this.defaults.put(BACKUP, Boolean.TRUE);
        this.defaults.put(OPEN_LAST_EDITED, Boolean.TRUE);
        this.defaults.put(LAST_EDITED, "");
        this.defaults.put(LAST_FOCUSED, "");
        this.defaults.put(STRINGS_POS_X, 0);
        this.defaults.put(STRINGS_POS_Y, 0);
        this.defaults.put(STRINGS_SIZE_X, 600);
        this.defaults.put(STRINGS_SIZE_Y, 400);
        this.defaults.put(DUPLICATES_POS_X, 0);
        this.defaults.put(DUPLICATES_POS_Y, 0);
        this.defaults.put(DUPLICATES_SIZE_X, 800);
        this.defaults.put(DUPLICATES_SIZE_Y, 600);
        this.defaults.put(MERGEENTRIES_POS_X, 0);
        this.defaults.put(MERGEENTRIES_POS_Y, 0);
        this.defaults.put(MERGEENTRIES_SIZE_X, 800);
        this.defaults.put(MERGEENTRIES_SIZE_Y, 600);
        this.defaults.put(PREAMBLE_POS_X, 0);
        this.defaults.put(PREAMBLE_POS_Y, 0);
        this.defaults.put(PREAMBLE_SIZE_X, 600);
        this.defaults.put(PREAMBLE_SIZE_Y, 400);
        this.defaults.put(TERMS_POS_X, 0);
        this.defaults.put(TERMS_POS_Y, 0);
        this.defaults.put(TERMS_SIZE_X, 500);
        this.defaults.put(TERMS_SIZE_Y, 500);
        this.defaults.put(DEFAULT_SHOW_SOURCE, Boolean.FALSE);
        this.defaults.put(DEFAULT_AUTO_SORT, Boolean.FALSE);
        this.defaults.put(MERGE_ENTRIES_DIFF_MODE, 2);
        this.defaults.put(SHOW_RECOMMENDATIONS, Boolean.TRUE);
        this.defaults.put(VALIDATE_IN_ENTRY_EDITOR, Boolean.TRUE);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS, Boolean.FALSE);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS_REBIND_CA, Boolean.TRUE);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS_REBIND_CF, Boolean.TRUE);
        this.defaults.put(AUTO_COMPLETE, Boolean.FALSE);
        this.defaults.put(AUTOCOMPLETER_FIRSTNAME_MODE, AutoCompleteFirstNameMode.BOTH.name());
        this.defaults.put(AUTOCOMPLETER_FIRST_LAST, Boolean.FALSE);
        this.defaults.put(AUTOCOMPLETER_LAST_FIRST, Boolean.FALSE);
        this.defaults.put(AUTOCOMPLETER_COMPLETE_FIELDS, "author;editor;title;journal;publisher;keywords;crossref;related;entryset");
        this.defaults.put(GROUP_INTERSECT_SELECTIONS, Boolean.FALSE);
        this.defaults.put(GROUPS_DEFAULT_FIELD, "keywords");
        this.defaults.put(AUTO_ASSIGN_GROUP, Boolean.TRUE);
        this.defaults.put(KEYWORD_SEPARATOR, ", ");
        this.defaults.put(TOOLBAR_VISIBLE, Boolean.TRUE);
        this.defaults.put(DEFAULT_ENCODING, StandardCharsets.UTF_8.name());
        this.defaults.put(DEFAULT_OWNER, System.getProperty("user.name"));
        this.defaults.put(MEMORY_STICK_MODE, Boolean.FALSE);
        this.defaults.put(RENAME_ON_MOVE_FILE_TO_FILE_DIR, Boolean.TRUE);
        this.defaults.put(FONT_STYLE, 0);
        this.defaults.put(FONT_SIZE, 12);
        this.defaults.put(OVERRIDE_DEFAULT_FONTS, Boolean.FALSE);
        this.defaults.put(MENU_FONT_SIZE, UNSET_MENU_FONT_SIZE);
        this.defaults.put(ICON_SIZE_LARGE, 24);
        this.defaults.put(ICON_SIZE_SMALL, 16);
        this.defaults.put(TABLE_ROW_PADDING, 9);
        this.defaults.put(TABLE_SHOW_GRID, Boolean.FALSE);
        this.defaults.put(TABLE_BACKGROUND, "255:255:255");
        this.defaults.put(TABLE_REQ_FIELD_BACKGROUND, "230:235:255");
        this.defaults.put(TABLE_OPT_FIELD_BACKGROUND, "230:255:230");
        this.defaults.put(TABLE_RESOLVED_FIELD_BACKGROUND, "240:240:240");
        this.defaults.put(TABLE_TEXT, "0:0:0");
        this.defaults.put(GRID_COLOR, "210:210:210");
        this.defaults.put(GRAYED_OUT_BACKGROUND, "210:210:210");
        this.defaults.put(GRAYED_OUT_TEXT, "40:40:40");
        this.defaults.put(VERY_GRAYED_OUT_BACKGROUND, "180:180:180");
        this.defaults.put(VERY_GRAYED_OUT_TEXT, "40:40:40");
        this.defaults.put(MARKED_ENTRY_BACKGROUND0, "255:255:180");
        this.defaults.put(MARKED_ENTRY_BACKGROUND1, "255:220:180");
        this.defaults.put(MARKED_ENTRY_BACKGROUND2, "255:180:160");
        this.defaults.put(MARKED_ENTRY_BACKGROUND3, "255:120:120");
        this.defaults.put(MARKED_ENTRY_BACKGROUND4, "255:75:75");
        this.defaults.put(MARKED_ENTRY_BACKGROUND5, "220:255:220");
        this.defaults.put(VALID_FIELD_BACKGROUND_COLOR, "255:255:255");
        this.defaults.put(INVALID_FIELD_BACKGROUND_COLOR, "255:0:0");
        this.defaults.put(ACTIVE_FIELD_EDITOR_BACKGROUND_COLOR, "220:220:255");
        this.defaults.put(FIELD_EDITOR_TEXT_COLOR, "0:0:0");
        this.defaults.put(ICON_ENABLED_COLOR, "79:95:143");
        this.defaults.put(ICON_DISABLED_COLOR, "200:200:200");
        this.defaults.put(INCOMPLETE_ENTRY_BACKGROUND, "250:175:175");
        this.defaults.put(URL_COLUMN, Boolean.TRUE);
        this.defaults.put(PREFER_URL_DOI, Boolean.FALSE);
        this.defaults.put(FILE_COLUMN, Boolean.TRUE);
        this.defaults.put(ARXIV_COLUMN, Boolean.FALSE);
        this.defaults.put(EXTRA_FILE_COLUMNS, Boolean.FALSE);
        this.defaults.put(LIST_OF_FILE_COLUMNS, "");
        this.defaults.put(PROTECTED_TERMS_ENABLED_INTERNAL, JabRefPreferences.convertListToString(ProtectedTermsLoader.getInternalLists()));
        this.defaults.put(PROTECTED_TERMS_DISABLED_INTERNAL, "");
        this.defaults.put(PROTECTED_TERMS_ENABLED_EXTERNAL, "");
        this.defaults.put(PROTECTED_TERMS_DISABLED_EXTERNAL, "");
        if (OS.WINDOWS) {
            this.defaults.put(OO_PATH, "C:\\Program Files\\LibreOffice 5");
            this.defaults.put(OO_EXECUTABLE_PATH, "C:\\Program Files\\LibreOffice 5\\program");
            this.defaults.put(OO_JARS_PATH, "C:\\Program Files\\LibreOffice 5");
        } else if (OS.OS_X) {
            this.defaults.put(OO_PATH, "/Applications/OpenOffice.org.app");
            this.defaults.put(OO_EXECUTABLE_PATH, "/Applications/OpenOffice.org.app/Contents/MacOS/soffice");
            this.defaults.put(OO_JARS_PATH, "/Applications/OpenOffice.org.app");
        } else {
            this.defaults.put(OO_PATH, "/usr/lib/libreoffice");
            this.defaults.put(OO_EXECUTABLE_PATH, "/usr/lib/libreoffice/program/soffice");
            this.defaults.put(OO_JARS_PATH, "/usr/lib/libreoffice");
        }
        this.defaults.put(OO_SYNC_WHEN_CITING, Boolean.FALSE);
        this.defaults.put(OO_SHOW_PANEL, Boolean.FALSE);
        this.defaults.put(OO_USE_ALL_OPEN_BASES, Boolean.TRUE);
        this.defaults.put(OO_BIBLIOGRAPHY_STYLE_FILE, "/resource/openoffice/default_authoryear.jstyle");
        this.defaults.put(OO_EXTERNAL_STYLE_FILES, "");
        this.defaults.put(STYLES_POS_X, 0);
        this.defaults.put(STYLES_POS_Y, 0);
        this.defaults.put(STYLES_SIZE_X, 600);
        this.defaults.put(STYLES_SIZE_Y, 400);
        this.defaults.put(SPECIALFIELDSENABLED, Boolean.TRUE);
        this.defaults.put(SHOWCOLUMN_PRIORITY, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_QUALITY, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_RANKING, Boolean.TRUE);
        this.defaults.put(SHOWCOLUMN_RELEVANCE, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_PRINTED, Boolean.FALSE);
        this.defaults.put(SHOWCOLUMN_READ, Boolean.FALSE);
        this.defaults.put(AUTOSYNCSPECIALFIELDSTOKEYWORDS, Boolean.TRUE);
        this.defaults.put(SERIALIZESPECIALFIELDS, Boolean.FALSE);
        this.defaults.put(USE_OWNER, Boolean.FALSE);
        this.defaults.put(OVERWRITE_OWNER, Boolean.FALSE);
        this.defaults.put(AVOID_OVERWRITING_KEY, Boolean.FALSE);
        this.defaults.put(WARN_BEFORE_OVERWRITING_KEY, Boolean.TRUE);
        this.defaults.put(CONFIRM_DELETE, Boolean.TRUE);
        this.defaults.put(GRAY_OUT_NON_HITS, Boolean.TRUE);
        this.defaults.put(DEFAULT_BIBTEX_KEY_PATTERN, "[auth][year]");
        this.defaults.put(DO_NOT_RESOLVE_STRINGS_FOR, "url");
        this.defaults.put(RESOLVE_STRINGS_ALL_FIELDS, Boolean.FALSE);
        this.defaults.put(NON_WRAPPABLE_FIELDS, "pdf;ps;url;doi;file;isbn;issn");
        this.defaults.put(GENERATE_KEYS_AFTER_INSPECTION, Boolean.TRUE);
        this.defaults.put(MARK_IMPORTED_ENTRIES, Boolean.TRUE);
        this.defaults.put(UNMARK_ALL_ENTRIES_BEFORE_IMPORTING, Boolean.TRUE);
        this.defaults.put(WARN_ABOUT_DUPLICATES_IN_INSPECTION, Boolean.TRUE);
        this.defaults.put(USE_TIME_STAMP, Boolean.FALSE);
        this.defaults.put(OVERWRITE_TIME_STAMP, Boolean.FALSE);
        this.defaults.put(TIME_STAMP_FORMAT, "yyyy-MM-dd");
        this.defaults.put(TIME_STAMP_FIELD, "timestamp");
        this.defaults.put(UPDATE_TIMESTAMP, Boolean.FALSE);
        this.defaults.put(GENERATE_KEYS_BEFORE_SAVING, Boolean.FALSE);
        this.defaults.put(USE_REMOTE_SERVER, Boolean.TRUE);
        this.defaults.put(REMOTE_SERVER_PORT, 6050);
        this.defaults.put(PERSONAL_JOURNAL_LIST, "");
        this.defaults.put(EXTERNAL_JOURNAL_LISTS, "");
        this.defaults.put(CITE_COMMAND, "\\cite");
        this.defaults.put(FLOAT_MARKED_ENTRIES, Boolean.TRUE);
        this.defaults.put(LAST_USED_EXPORT, "");
        this.defaults.put(SIDE_PANE_WIDTH, -1);
        this.defaults.put(IMPORT_INSPECTION_DIALOG_WIDTH, 650);
        this.defaults.put(IMPORT_INSPECTION_DIALOG_HEIGHT, 650);
        this.defaults.put(SHOW_FILE_LINKS_UPGRADE_WARNING, Boolean.TRUE);
        this.defaults.put(AUTOLINK_EXACT_KEY_ONLY, Boolean.FALSE);
        this.defaults.put(NUMERIC_FIELDS, "mittnum;author");
        this.defaults.put(RUN_AUTOMATIC_FILE_SEARCH, Boolean.FALSE);
        this.defaults.put(LOCAL_AUTO_SAVE, Boolean.FALSE);
        this.defaults.put(ENFORCE_LEGAL_BIBTEX_KEY, Boolean.TRUE);
        this.defaults.put(KEY_GEN_FIRST_LETTER_A, Boolean.TRUE);
        this.defaults.put(KEY_GEN_ALWAYS_ADD_LETTER, Boolean.FALSE);
        this.defaults.put(EMAIL_SUBJECT, Localization.lang("References", new String[0]));
        this.defaults.put(OPEN_FOLDERS_OF_ATTACHED_FILES, Boolean.FALSE);
        this.defaults.put(ALLOW_FILE_AUTO_OPEN_BROWSE, Boolean.TRUE);
        this.defaults.put(WEB_SEARCH_VISIBLE, Boolean.FALSE);
        this.defaults.put(GROUP_SIDEPANE_VISIBLE, Boolean.FALSE);
        this.defaults.put(SELECTED_FETCHER_INDEX, 0);
        this.defaults.put(BIB_LOC_AS_PRIMARY_DIR, Boolean.FALSE);
        this.defaults.put(DB_CONNECT_SERVER_TYPE, "MySQL");
        this.defaults.put(DB_CONNECT_HOSTNAME, "localhost");
        this.defaults.put(DB_CONNECT_DATABASE, "jabref");
        this.defaults.put(DB_CONNECT_USERNAME, "root");
        this.defaults.put(COLLECT_TELEMETRY, Boolean.FALSE);
        this.defaults.put(ALREADY_ASKED_TO_COLLECT_TELEMETRY, Boolean.FALSE);
        this.defaults.put(ASK_AUTO_NAMING_PDFS_AGAIN, Boolean.TRUE);
        JabRefPreferences.insertDefaultCleanupPreset(this.defaults);
        this.defaults.put(DROPPEDFILEHANDLER_LEAVE, Boolean.FALSE);
        this.defaults.put(DROPPEDFILEHANDLER_COPY, Boolean.TRUE);
        this.defaults.put(DROPPEDFILEHANDLER_MOVE, Boolean.FALSE);
        this.defaults.put(DROPPEDFILEHANDLER_RENAME, Boolean.FALSE);
        this.defaults.put(IMPORT_ALWAYSUSE, Boolean.FALSE);
        this.defaults.put(IMPORT_DEFAULT_PDF_IMPORT_STYLE, 2);
        this.defaults.put(IMPORT_FILENAMEPATTERN, ImportSettingsTab.DEFAULT_FILENAMEPATTERNS[1]);
        this.defaults.put(IMPORT_FILEDIRPATTERN, "");
        this.customExports = new CustomExportList(new ExportComparator());
        this.customImports = new CustomImportList(this);
        this.MARKING_WITH_NUMBER_PATTERN = "\\[" + this.get(DEFAULT_OWNER).replaceAll("\\\\", "\\\\\\\\") + ":(\\d+)\\]";
        String defaultExpression = "**/.*[bibtexkey].*\\\\.[extension]";
        this.defaults.put(AUTOLINK_REG_EXP_SEARCH_EXPRESSION_KEY, defaultExpression);
        this.defaults.put(AUTOLINK_USE_REG_EXP_SEARCH_KEY, Boolean.FALSE);
        this.defaults.put(USE_IEEE_ABRV, Boolean.FALSE);
        this.defaults.put(USE_CASE_KEEPER_ON_SEARCH, Boolean.TRUE);
        this.defaults.put(USE_UNIT_FORMATTER_ON_SEARCH, Boolean.TRUE);
        this.defaults.put(USE_DEFAULT_CONSOLE_APPLICATION, Boolean.TRUE);
        if (OS.WINDOWS) {
            this.defaults.put(CONSOLE_COMMAND, "C:\\Program Files\\ConEmu\\ConEmu64.exe /single /dir \"%DIR\"");
            this.defaults.put(ADOBE_ACROBAT_COMMAND, "C:\\Program Files (x86)\\Adobe\\Acrobat Reader DC\\Reader");
            this.defaults.put(SUMATRA_PDF_COMMAND, "C:\\Program Files\\SumatraPDF");
            this.defaults.put(USE_PDF_READER, ADOBE_ACROBAT_COMMAND);
        } else {
            this.defaults.put(CONSOLE_COMMAND, "");
            this.defaults.put(ADOBE_ACROBAT_COMMAND, "");
            this.defaults.put(SUMATRA_PDF_COMMAND, "");
            this.defaults.put(USE_PDF_READER, "");
        }
        this.defaults.put(VERSION_IGNORED_UPDATE, "");
        this.defaults.put(CYCLE_PREVIEW, "Preview;/ieee.csl");
        this.defaults.put(CYCLE_PREVIEW_POS, 0);
        this.defaults.put(PREVIEW_PANEL_HEIGHT, 200);
        this.defaults.put(PREVIEW_ENABLED, Boolean.TRUE);
        this.defaults.put(PREVIEW_STYLE, "<font face=\"sans-serif\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}__NEWLINE__\\begin{abstract}<BR><BR><b>Abstract: </b> \\format[HTMLChars]{\\abstract} \\end{abstract}__NEWLINE__\\begin{review}<BR><BR><b>Review: </b> \\format[HTMLChars]{\\review} \\end{review}</dd>__NEWLINE__<p></p></font>");
        this.setLanguageDependentDefaultValues();
    }

    public static JabRefPreferences getInstance() {
        if (singleton == null) {
            singleton = new JabRefPreferences();
        }
        return singleton;
    }

    private static String convertListToString(List<String> value) {
        return value.stream().map(val -> StringUtil.quote(val, ";", '\\')).collect(Collectors.joining(";"));
    }

    private static int[] getRgb(String value) {
        int[] values = new int[3];
        if (value != null && !value.isEmpty()) {
            String[] elements = value.split(":");
            values[0] = Integer.parseInt(elements[0]);
            values[1] = Integer.parseInt(elements[1]);
            values[2] = Integer.parseInt(elements[2]);
        } else {
            values[0] = 0;
            values[1] = 0;
            values[2] = 0;
        }
        return values;
    }

    private static Preferences getPrefsNodeForCustomizedEntryTypes(BibDatabaseMode mode) {
        if (mode == BibDatabaseMode.BIBLATEX) {
            return Preferences.userNodeForPackage(PREFS_BASE_CLASS).node(CUSTOMIZED_BIBLATEX_TYPES);
        }
        if (mode == BibDatabaseMode.BIBTEX) {
            return Preferences.userNodeForPackage(PREFS_BASE_CLASS).node(CUSTOMIZED_BIBTEX_TYPES);
        }
        throw new IllegalArgumentException("Unknown BibDatabaseMode: " + (Object)((Object)mode));
    }

    private static Optional<String> getNextUnit(Reader data) throws IOException {
        int c = -1;
        boolean escape = false;
        boolean done = false;
        StringBuilder res = new StringBuilder();
        while (!done && (c = data.read()) != -1) {
            if (c == 92) {
                if (escape) {
                    escape = false;
                    res.append('\\');
                    continue;
                }
                escape = true;
                continue;
            }
            if (c == 59) {
                if (escape) {
                    res.append(';');
                } else {
                    done = true;
                }
            } else {
                res.append((char)c);
            }
            escape = false;
        }
        if (res.length() > 0) {
            return Optional.of(res.toString());
        }
        if (c == -1) {
            return Optional.empty();
        }
        return Optional.of("");
    }

    private static void insertDefaultCleanupPreset(Map<String, Object> storage) {
        EnumSet<CleanupPreset.CleanupStep> deactivatedJobs = EnumSet.of(CleanupPreset.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS, CleanupPreset.CleanupStep.MOVE_PDF, CleanupPreset.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS, CleanupPreset.CleanupStep.CONVERT_TO_BIBLATEX, CleanupPreset.CleanupStep.CONVERT_TO_BIBTEX);
        CleanupPreset preset = new CleanupPreset(EnumSet.complementOf(deactivatedJobs), Cleanups.DEFAULT_SAVE_ACTIONS);
        storage.put(CLEANUP_DOI, preset.isCleanUpDOI());
        storage.put(CLEANUP_ISSN, preset.isCleanUpISSN());
        storage.put(CLEANUP_MOVE_PDF, preset.isMovePDF());
        storage.put(CLEANUP_MAKE_PATHS_RELATIVE, preset.isMakePathsRelative());
        storage.put(CLEANUP_RENAME_PDF, preset.isRenamePDF());
        storage.put(CLEANUP_RENAME_PDF_ONLY_RELATIVE_PATHS, preset.isRenamePdfOnlyRelativePaths());
        storage.put(CLEANUP_UPGRADE_EXTERNAL_LINKS, preset.isCleanUpUpgradeExternalLinks());
        storage.put(CLEANUP_CONVERT_TO_BIBLATEX, preset.isConvertToBiblatex());
        storage.put(CLEANUP_CONVERT_TO_BIBTEX, preset.isConvertToBibtex());
        storage.put(CLEANUP_FIX_FILE_LINKS, preset.isFixFileLinks());
        storage.put(CLEANUP_FORMATTERS, JabRefPreferences.convertListToString(preset.getFormatterCleanups().getAsStringList(OS.NEWLINE)));
    }

    public int getFontSizeFX() {
        return this.getInt(MENU_FONT_SIZE) - 3;
    }

    public String getUser() {
        try {
            return this.get(DEFAULT_OWNER) + '-' + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOGGER.debug("Hostname not found.", ex);
            return this.get(DEFAULT_OWNER);
        }
    }

    public List<String> getCustomTabFieldNames() {
        String fields;
        ArrayList<String> customFields = new ArrayList<String>();
        int defNumber = 0;
        while ((fields = (String)this.defaults.get("customTabFields__def" + defNumber)) != null && !fields.isEmpty()) {
            customFields.addAll(Arrays.asList(fields.split(";")));
            ++defNumber;
        }
        return customFields;
    }

    public void setLanguageDependentDefaultValues() {
        this.defaults.put("customTabName__def0", Localization.lang("General", new String[0]));
        String fieldNames = InternalBibtexFields.DEFAULT_GENERAL_FIELDS.stream().collect(Collectors.joining(";"));
        this.defaults.put("customTabFields__def0", fieldNames);
        this.defaults.put("customTabFields__def1", "abstract");
        this.defaults.put("customTabName__def1", Localization.lang("Abstract", new String[0]));
        this.defaults.put("customTabFields__def2", "comment");
        this.defaults.put("customTabName__def2", Localization.lang("Comments", new String[0]));
        this.defaults.put(EMAIL_SUBJECT, Localization.lang("References", new String[0]));
    }

    public boolean hasKey(String key) {
        return this.prefs.get(key, null) != null;
    }

    public String get(String key) {
        return this.prefs.get(key, (String)this.defaults.get(key));
    }

    public Optional<String> getAsOptional(String key) {
        return Optional.ofNullable(this.prefs.get(key, (String)this.defaults.get(key)));
    }

    public String get(String key, String def) {
        return this.prefs.get(key, def);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, this.getBooleanDefault(key));
    }

    public boolean getBoolean(String key, boolean def) {
        return this.prefs.getBoolean(key, def);
    }

    private boolean getBooleanDefault(String key) {
        return (Boolean)this.defaults.get(key);
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, this.getIntDefault(key));
    }

    public int getIntDefault(String key) {
        if (key.equals(MENU_FONT_SIZE)) {
            Integer menuFontSize = (Integer)this.defaults.get(key);
            if (menuFontSize.equals(UNSET_MENU_FONT_SIZE)) {
                menuFontSize = (int)Font.getDefault().getSize();
                this.defaults.put(key, menuFontSize);
            }
            return menuFontSize;
        }
        return (Integer)this.defaults.get(key);
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public void putInt(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public void putStringList(String key, List<String> value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        this.put(key, JabRefPreferences.convertListToString(value));
    }

    public List<String> getStringList(String key) {
        String names = this.get(key);
        if (names == null) {
            return new ArrayList<String>();
        }
        StringReader rd = new StringReader(names);
        ArrayList<String> res = new ArrayList<String>();
        try {
            Optional<String> rs;
            while ((rs = JabRefPreferences.getNextUnit(rd)).isPresent()) {
                res.add(rs.get());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public Color getColor(String key) {
        String value = this.get(key);
        int[] rgb = JabRefPreferences.getRgb(value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color getDefaultColor(String key) {
        String value = (String)this.defaults.get(key);
        int[] rgb = JabRefPreferences.getRgb(value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public BibDatabaseMode getDefaultBibDatabaseMode() {
        if (this.getBoolean(BIBLATEX_DEFAULT_MODE)) {
            return BibDatabaseMode.BIBLATEX;
        }
        return BibDatabaseMode.BIBTEX;
    }

    public void putDefaultValue(String key, Object value) {
        this.defaults.put(key, value);
    }

    public void putColor(String key, Color color) {
        String rgb = String.valueOf(color.getRed()) + ':' + color.getGreen() + ':' + color.getBlue();
        this.put(key, rgb);
    }

    public void clear() throws BackingStoreException {
        this.clearAllCustomEntryTypes();
        this.clearKeyPatterns();
        this.prefs.clear();
    }

    public void clear(String key) {
        this.prefs.remove(key);
    }

    public void flush() {
        if (this.getBoolean(MEMORY_STICK_MODE)) {
            try {
                this.exportPreferences("jabref.xml");
            }
            catch (JabRefException e) {
                LOGGER.warn("Could not export preferences for memory stick mode: " + e.getMessage(), e);
            }
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOGGER.warn("Cannot communicate with backing store", ex);
        }
    }

    public GlobalBibtexKeyPattern getKeyPattern() {
        this.keyPattern = GlobalBibtexKeyPattern.fromPattern(this.get(DEFAULT_BIBTEX_KEY_PATTERN));
        Preferences pre = Preferences.userNodeForPackage(PREFS_BASE_CLASS).node(BIBTEX_KEY_PATTERNS_NODE);
        try {
            String[] keys = pre.keys();
            if (keys.length > 0) {
                for (String key : keys) {
                    this.keyPattern.addBibtexKeyPattern(key, pre.get(key, null));
                }
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.info("BackingStoreException in JabRefPreferences.getKeyPattern", ex);
        }
        return this.keyPattern;
    }

    public void putKeyPattern(GlobalBibtexKeyPattern pattern) {
        this.keyPattern = pattern;
        Preferences pre = Preferences.userNodeForPackage(PREFS_BASE_CLASS).node(BIBTEX_KEY_PATTERNS_NODE);
        try {
            pre.clear();
        }
        catch (BackingStoreException ex) {
            LOGGER.info("BackingStoreException in JabRefPreferences.putKeyPattern", ex);
        }
        Set<String> allKeys = pattern.getAllKeys();
        for (String key : allKeys) {
            if (pattern.isDefaultValue(key)) continue;
            pre.put(key, pattern.getValue(key).get(0));
        }
    }

    private void clearKeyPatterns() throws BackingStoreException {
        Preferences pre = Preferences.userNodeForPackage(PREFS_BASE_CLASS).node(BIBTEX_KEY_PATTERNS_NODE);
        pre.clear();
    }

    public void storeCustomEntryTypes(List<CustomEntryType> customEntryTypes, BibDatabaseMode bibDatabaseMode) {
        Preferences prefsNode = JabRefPreferences.getPrefsNodeForCustomizedEntryTypes(bibDatabaseMode);
        try {
            this.clearCustomEntryTypes(bibDatabaseMode);
            customEntryTypes.forEach(type -> prefsNode.put(type.getName(), type.getAsString()));
            prefsNode.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.info("Updating stored custom entry types failed.", e);
        }
    }

    public List<CustomEntryType> loadCustomEntryTypes(BibDatabaseMode bibDatabaseMode) {
        ArrayList<CustomEntryType> storedEntryTypes = new ArrayList<CustomEntryType>();
        Preferences prefsNode = JabRefPreferences.getPrefsNodeForCustomizedEntryTypes(bibDatabaseMode);
        try {
            Arrays.stream(prefsNode.keys()).map(key -> prefsNode.get((String)key, null)).filter(Objects::nonNull).forEach(typeString -> CustomEntryType.parse(typeString).ifPresent(storedEntryTypes::add));
        }
        catch (BackingStoreException e) {
            LOGGER.info("Parsing customized entry types failed.", e);
        }
        return storedEntryTypes;
    }

    private void clearAllCustomEntryTypes() throws BackingStoreException {
        for (BibDatabaseMode mode : BibDatabaseMode.values()) {
            this.clearCustomEntryTypes(mode);
        }
    }

    private void clearCustomEntryTypes(BibDatabaseMode mode) throws BackingStoreException {
        Preferences prefsNode = JabRefPreferences.getPrefsNodeForCustomizedEntryTypes(mode);
        prefsNode.clear();
    }

    public Map<String, Object> getPreferences() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            for (String key : this.prefs.keys()) {
                Object value = this.getObject(key);
                result.put(key, value);
            }
        }
        catch (BackingStoreException e) {
            LOGGER.info("could not retrieve preference keys", e);
        }
        return result;
    }

    private Object getObject(String key) {
        try {
            return this.get(key);
        }
        catch (ClassCastException e) {
            try {
                return this.getBoolean(key);
            }
            catch (ClassCastException e2) {
                return this.getInt(key);
            }
        }
    }

    public void purgeSeries(String prefix, int number) {
        int n = number;
        while (this.get(prefix + n) != null) {
            this.remove(prefix + n);
            ++n;
        }
    }

    public EntryEditorTabList getEntryEditorTabList() {
        if (this.tabList == null) {
            this.updateEntryEditorTabList();
        }
        return this.tabList;
    }

    public void updateEntryEditorTabList() {
        this.tabList = new EntryEditorTabList();
    }

    public void exportPreferences(String filename) throws JabRefException {
        File f = new File(filename);
        try (FileOutputStream os = new FileOutputStream(f);){
            this.prefs.exportSubtree(os);
        }
        catch (IOException | BackingStoreException ex) {
            throw new JabRefException("Could not export preferences", Localization.lang("Could not export preferences", new String[0]), ex);
        }
    }

    public void importPreferences(String filename) throws JabRefException {
        File f = new File(filename);
        try {
            FileInputStream is = new FileInputStream(f);
            Throwable throwable = null;
            try {
                Preferences.importPreferences(is);
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    JabRefPreferences.$closeResource(throwable, is);
                    throw throwable3;
                }
            }
            JabRefPreferences.$closeResource(throwable, is);
        }
        catch (IOException | InvalidPreferencesFormatException ex) {
            throw new JabRefException("Could not import preferences", Localization.lang("Could not import preferences", new String[0]), ex);
        }
    }

    public void overwritePreferences(JabRefPreferences owPrefs) {
        singleton = owPrefs;
    }

    public String getWrappedUsername() {
        return '[' + this.get(DEFAULT_OWNER) + ']';
    }

    public Charset getDefaultEncoding() {
        return Charset.forName(this.get(DEFAULT_ENCODING));
    }

    public void setDefaultEncoding(Charset encoding) {
        this.put(DEFAULT_ENCODING, encoding.name());
    }

    public FileHistory getFileHistory() {
        return new FileHistory(this.getStringList(RECENT_DATABASES));
    }

    public void storeFileHistory(FileHistory history) {
        if (!history.isEmpty()) {
            this.putStringList(RECENT_DATABASES, history.getHistory());
        }
    }

    public FileDirectoryPreferences getFileDirectoryPreferences() {
        List<String> fields = Arrays.asList("file", "pdf", "ps");
        HashMap<String, String> fieldDirectories = new HashMap<String, String>();
        fields.stream().forEach(fieldName -> fieldDirectories.put((String)fieldName, this.get(fieldName + "Directory")));
        return new FileDirectoryPreferences(this.getUser(), fieldDirectories, this.getBoolean(BIB_LOC_AS_PRIMARY_DIR));
    }

    public UpdateFieldPreferences getUpdateFieldPreferences() {
        return new UpdateFieldPreferences(this.getBoolean(USE_OWNER), this.getBoolean(OVERWRITE_OWNER), this.get(DEFAULT_OWNER), this.getBoolean(USE_TIME_STAMP), this.getBoolean(OVERWRITE_TIME_STAMP), this.get(TIME_STAMP_FIELD), this.get(TIME_STAMP_FORMAT));
    }

    public LatexFieldFormatterPreferences getLatexFieldFormatterPreferences() {
        return new LatexFieldFormatterPreferences(this.getBoolean(RESOLVE_STRINGS_ALL_FIELDS), this.getStringList(DO_NOT_RESOLVE_STRINGS_FOR), this.getFieldContentParserPreferences());
    }

    public FieldContentParserPreferences getFieldContentParserPreferences() {
        return new FieldContentParserPreferences(this.getStringList(NON_WRAPPABLE_FIELDS));
    }

    public boolean isKeywordSyncEnabled() {
        return this.getBoolean(SPECIALFIELDSENABLED) && this.getBoolean(AUTOSYNCSPECIALFIELDSTOKEYWORDS);
    }

    public ImportFormatPreferences getImportFormatPreferences() {
        return new ImportFormatPreferences(this.customImports, this.getDefaultEncoding(), this.getKeywordDelimiter(), this.getBibtexKeyPatternPreferences(), this.getFieldContentParserPreferences(), this.isKeywordSyncEnabled());
    }

    public SavePreferences loadForExportFromPreferences() {
        Boolean saveInOriginalOrder = this.getBoolean(EXPORT_IN_ORIGINAL_ORDER);
        SaveOrderConfig saveOrder = null;
        if (!saveInOriginalOrder.booleanValue()) {
            saveOrder = this.getBoolean(EXPORT_IN_SPECIFIED_ORDER) ? this.loadExportSaveOrder() : this.loadTableSaveOrder();
        }
        Charset encoding = this.getDefaultEncoding();
        Boolean makeBackup = this.getBoolean(BACKUP);
        SavePreferences.DatabaseSaveType saveType = SavePreferences.DatabaseSaveType.ALL;
        Boolean takeMetadataSaveOrderInAccount = false;
        Boolean reformatFile = this.getBoolean(REFORMAT_FILE_ON_SAVE_AND_EXPORT);
        LatexFieldFormatterPreferences latexFieldFormatterPreferences = this.getLatexFieldFormatterPreferences();
        GlobalBibtexKeyPattern globalCiteKeyPattern = this.getKeyPattern();
        return new SavePreferences(saveInOriginalOrder, saveOrder, encoding, makeBackup, saveType, takeMetadataSaveOrderInAccount, reformatFile, latexFieldFormatterPreferences, globalCiteKeyPattern);
    }

    public SavePreferences loadForSaveFromPreferences() {
        Boolean saveInOriginalOrder = false;
        SaveOrderConfig saveOrder = null;
        Charset encoding = this.getDefaultEncoding();
        Boolean makeBackup = this.getBoolean(BACKUP);
        SavePreferences.DatabaseSaveType saveType = SavePreferences.DatabaseSaveType.ALL;
        Boolean takeMetadataSaveOrderInAccount = true;
        Boolean reformatFile = this.getBoolean(REFORMAT_FILE_ON_SAVE_AND_EXPORT);
        LatexFieldFormatterPreferences latexFieldFormatterPreferences = this.getLatexFieldFormatterPreferences();
        GlobalBibtexKeyPattern globalCiteKeyPattern = this.getKeyPattern();
        return new SavePreferences(saveInOriginalOrder, saveOrder, encoding, makeBackup, saveType, takeMetadataSaveOrderInAccount, reformatFile, latexFieldFormatterPreferences, globalCiteKeyPattern);
    }

    public ExporterFactory getExporterFactory(JournalAbbreviationLoader abbreviationLoader) {
        Map<String, TemplateExporter> customFormats = this.customExports.getCustomExportFormats(this, abbreviationLoader);
        LayoutFormatterPreferences layoutPreferences = this.getLayoutFormatterPreferences(abbreviationLoader);
        SavePreferences savePreferences = this.loadForExportFromPreferences();
        XmpPreferences xmpPreferences = this.getXMPPreferences();
        return ExporterFactory.create(customFormats, layoutPreferences, savePreferences, xmpPreferences);
    }

    public BibtexKeyPatternPreferences getBibtexKeyPatternPreferences() {
        return new BibtexKeyPatternPreferences(this.get(KEY_PATTERN_REGEX), this.get(KEY_PATTERN_REPLACEMENT), this.getBoolean(KEY_GEN_ALWAYS_ADD_LETTER), this.getBoolean(KEY_GEN_FIRST_LETTER_A), this.getBoolean(ENFORCE_LEGAL_BIBTEX_KEY), this.getKeyPattern(), this.getKeywordDelimiter());
    }

    public TimestampPreferences getTimestampPreferences() {
        return new TimestampPreferences(this.getBoolean(USE_TIME_STAMP), this.getBoolean(UPDATE_TIMESTAMP), this.get(TIME_STAMP_FIELD), this.get(TIME_STAMP_FORMAT), this.getBoolean(OVERWRITE_TIME_STAMP));
    }

    public LayoutFormatterPreferences getLayoutFormatterPreferences(JournalAbbreviationLoader journalAbbreviationLoader) {
        Objects.requireNonNull(journalAbbreviationLoader);
        return new LayoutFormatterPreferences(this.getNameFormatterPreferences(), this.getJournalAbbreviationPreferences(), this.getFileLinkPreferences(), journalAbbreviationLoader);
    }

    public XmpPreferences getXMPPreferences() {
        return new XmpPreferences(this.getBoolean(USE_XMP_PRIVACY_FILTER), this.getStringList(XMP_PRIVACY_FILTERS), this.getKeywordDelimiter());
    }

    public OpenOfficePreferences getOpenOfficePreferences() {
        return new OpenOfficePreferences(this.get(OO_JARS_PATH), this.get(OO_EXECUTABLE_PATH), this.get(OO_PATH), this.getBoolean(OO_USE_ALL_OPEN_BASES), this.getBoolean(OO_SYNC_WHEN_CITING), this.getBoolean(OO_SHOW_PANEL), this.getStringList(OO_EXTERNAL_STYLE_FILES), this.get(OO_BIBLIOGRAPHY_STYLE_FILE));
    }

    public void setOpenOfficePreferences(OpenOfficePreferences openOfficePreferences) {
        this.put(OO_JARS_PATH, openOfficePreferences.getJarsPath());
        this.put(OO_EXECUTABLE_PATH, openOfficePreferences.getExecutablePath());
        this.put(OO_PATH, openOfficePreferences.getInstallationPath());
        this.putBoolean(OO_USE_ALL_OPEN_BASES, openOfficePreferences.getUseAllDatabases());
        this.putBoolean(OO_SYNC_WHEN_CITING, openOfficePreferences.getSyncWhenCiting());
        this.putBoolean(OO_SHOW_PANEL, openOfficePreferences.getShowPanel());
        this.putStringList(OO_EXTERNAL_STYLE_FILES, openOfficePreferences.getExternalStyles());
        this.put(OO_BIBLIOGRAPHY_STYLE_FILE, openOfficePreferences.getCurrentStyle());
    }

    private NameFormatterPreferences getNameFormatterPreferences() {
        return new NameFormatterPreferences(this.getStringList(NAME_FORMATER_KEY), this.getStringList(NAME_FORMATTER_VALUE));
    }

    public FileLinkPreferences getFileLinkPreferences() {
        return new FileLinkPreferences(Collections.singletonList(this.get("fileDirectory")), this.fileDirForDatabase);
    }

    public JabRefPreferences storeVersionPreferences(VersionPreferences versionPreferences) {
        this.put(VERSION_IGNORED_UPDATE, versionPreferences.getIgnoredVersion().toString());
        return this;
    }

    public VersionPreferences getVersionPreferences() {
        Version ignoredVersion = Version.parse(this.get(VERSION_IGNORED_UPDATE));
        return new VersionPreferences(ignoredVersion);
    }

    public JabRefPreferences storePreviewPreferences(PreviewPreferences previewPreferences) {
        this.putInt(CYCLE_PREVIEW_POS, previewPreferences.getPreviewCyclePosition());
        this.putStringList(CYCLE_PREVIEW, previewPreferences.getPreviewCycle());
        this.putInt(PREVIEW_PANEL_HEIGHT, previewPreferences.getPreviewPanelHeight());
        this.put(PREVIEW_STYLE, previewPreferences.getPreviewStyle());
        this.putBoolean(PREVIEW_ENABLED, previewPreferences.isPreviewPanelEnabled());
        return this;
    }

    public PreviewPreferences getPreviewPreferences() {
        int cyclePos = this.getInt(CYCLE_PREVIEW_POS);
        List<String> cycle = this.getStringList(CYCLE_PREVIEW);
        int panelHeight = this.getInt(PREVIEW_PANEL_HEIGHT);
        String style = this.get(PREVIEW_STYLE);
        String styleDefault = (String)this.defaults.get(PREVIEW_STYLE);
        boolean enabled = this.getBoolean(PREVIEW_ENABLED);
        return new PreviewPreferences(cycle, cyclePos, panelHeight, enabled, style, styleDefault);
    }

    public void storeProxyPreferences(ProxyPreferences proxyPreferences) {
        this.putBoolean(PROXY_USE, proxyPreferences.isUseProxy());
        this.put(PROXY_HOSTNAME, proxyPreferences.getHostname());
        this.put(PROXY_PORT, proxyPreferences.getPort());
        this.putBoolean(PROXY_USE_AUTHENTICATION, proxyPreferences.isUseAuthentication());
        this.put(PROXY_USERNAME, proxyPreferences.getUsername());
        this.put(PROXY_PASSWORD, proxyPreferences.getPassword());
    }

    public ProxyPreferences getProxyPreferences() {
        Boolean useProxy = this.getBoolean(PROXY_USE);
        String hostname = this.get(PROXY_HOSTNAME);
        String port = this.get(PROXY_PORT);
        Boolean useAuthentication = this.getBoolean(PROXY_USE_AUTHENTICATION);
        String username = this.get(PROXY_USERNAME);
        String password = this.get(PROXY_PASSWORD);
        return new ProxyPreferences(useProxy, hostname, port, useAuthentication, username, password);
    }

    public ProtectedTermsPreferences getProtectedTermsPreferences() {
        return new ProtectedTermsPreferences(this.getStringList(PROTECTED_TERMS_ENABLED_INTERNAL), this.getStringList(PROTECTED_TERMS_ENABLED_EXTERNAL), this.getStringList(PROTECTED_TERMS_DISABLED_INTERNAL), this.getStringList(PROTECTED_TERMS_DISABLED_EXTERNAL));
    }

    public void setProtectedTermsPreferences(ProtectedTermsLoader loader) {
        ArrayList<String> enabledExternalList = new ArrayList<String>();
        ArrayList<String> disabledExternalList = new ArrayList<String>();
        ArrayList<String> enabledInternalList = new ArrayList<String>();
        ArrayList<String> disabledInternalList = new ArrayList<String>();
        for (ProtectedTermsList list : loader.getProtectedTermsLists()) {
            if (list.isInternalList()) {
                if (list.isEnabled()) {
                    enabledInternalList.add(list.getLocation());
                    continue;
                }
                disabledInternalList.add(list.getLocation());
                continue;
            }
            if (list.isEnabled()) {
                enabledExternalList.add(list.getLocation());
                continue;
            }
            disabledExternalList.add(list.getLocation());
        }
        this.putStringList(PROTECTED_TERMS_ENABLED_EXTERNAL, enabledExternalList);
        this.putStringList(PROTECTED_TERMS_DISABLED_EXTERNAL, disabledExternalList);
        this.putStringList(PROTECTED_TERMS_ENABLED_INTERNAL, enabledInternalList);
        this.putStringList(PROTECTED_TERMS_DISABLED_INTERNAL, disabledInternalList);
    }

    @Override
    public JournalAbbreviationPreferences getJournalAbbreviationPreferences() {
        return new JournalAbbreviationPreferences(this.getStringList(EXTERNAL_JOURNAL_LISTS), this.get(PERSONAL_JOURNAL_LIST), this.getBoolean(USE_IEEE_ABRV), this.getDefaultEncoding());
    }

    public CleanupPreferences getCleanupPreferences(JournalAbbreviationLoader journalAbbreviationLoader) {
        return new CleanupPreferences(this.get(IMPORT_FILENAMEPATTERN), this.get(IMPORT_FILEDIRPATTERN), this.getLayoutFormatterPreferences(journalAbbreviationLoader), this.getFileDirectoryPreferences());
    }

    public CleanupPreset getCleanupPreset() {
        EnumSet<CleanupPreset.CleanupStep> activeJobs = EnumSet.noneOf(CleanupPreset.CleanupStep.class);
        if (this.getBoolean(CLEANUP_DOI)) {
            activeJobs.add(CleanupPreset.CleanupStep.CLEAN_UP_DOI);
        }
        if (this.getBoolean(CLEANUP_ISSN)) {
            activeJobs.add(CleanupPreset.CleanupStep.CLEAN_UP_ISSN);
        }
        if (this.getBoolean(CLEANUP_MOVE_PDF)) {
            activeJobs.add(CleanupPreset.CleanupStep.MOVE_PDF);
        }
        if (this.getBoolean(CLEANUP_MAKE_PATHS_RELATIVE)) {
            activeJobs.add(CleanupPreset.CleanupStep.MAKE_PATHS_RELATIVE);
        }
        if (this.getBoolean(CLEANUP_RENAME_PDF)) {
            activeJobs.add(CleanupPreset.CleanupStep.RENAME_PDF);
        }
        if (this.getBoolean(CLEANUP_RENAME_PDF_ONLY_RELATIVE_PATHS)) {
            activeJobs.add(CleanupPreset.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS);
        }
        if (this.getBoolean(CLEANUP_UPGRADE_EXTERNAL_LINKS)) {
            activeJobs.add(CleanupPreset.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS);
        }
        if (this.getBoolean(CLEANUP_CONVERT_TO_BIBLATEX)) {
            activeJobs.add(CleanupPreset.CleanupStep.CONVERT_TO_BIBLATEX);
        }
        if (this.getBoolean(CLEANUP_CONVERT_TO_BIBTEX)) {
            activeJobs.add(CleanupPreset.CleanupStep.CONVERT_TO_BIBTEX);
        }
        if (this.getBoolean(CLEANUP_FIX_FILE_LINKS)) {
            activeJobs.add(CleanupPreset.CleanupStep.FIX_FILE_LINKS);
        }
        FieldFormatterCleanups formatterCleanups = Cleanups.parse(this.getStringList(CLEANUP_FORMATTERS));
        return new CleanupPreset(activeJobs, formatterCleanups);
    }

    public void setCleanupPreset(CleanupPreset cleanupPreset) {
        this.putBoolean(CLEANUP_DOI, cleanupPreset.isActive(CleanupPreset.CleanupStep.CLEAN_UP_DOI));
        this.putBoolean(CLEANUP_ISSN, cleanupPreset.isActive(CleanupPreset.CleanupStep.CLEAN_UP_ISSN));
        this.putBoolean(CLEANUP_MOVE_PDF, cleanupPreset.isActive(CleanupPreset.CleanupStep.MOVE_PDF));
        this.putBoolean(CLEANUP_MAKE_PATHS_RELATIVE, cleanupPreset.isActive(CleanupPreset.CleanupStep.MAKE_PATHS_RELATIVE));
        this.putBoolean(CLEANUP_RENAME_PDF, cleanupPreset.isActive(CleanupPreset.CleanupStep.RENAME_PDF));
        this.putBoolean(CLEANUP_RENAME_PDF_ONLY_RELATIVE_PATHS, cleanupPreset.isActive(CleanupPreset.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS));
        this.putBoolean(CLEANUP_UPGRADE_EXTERNAL_LINKS, cleanupPreset.isActive(CleanupPreset.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS));
        this.putBoolean(CLEANUP_CONVERT_TO_BIBLATEX, cleanupPreset.isActive(CleanupPreset.CleanupStep.CONVERT_TO_BIBLATEX));
        this.putBoolean(CLEANUP_CONVERT_TO_BIBTEX, cleanupPreset.isActive(CleanupPreset.CleanupStep.CONVERT_TO_BIBTEX));
        this.putBoolean(CLEANUP_FIX_FILE_LINKS, cleanupPreset.isActive(CleanupPreset.CleanupStep.FIX_FILE_LINKS));
        this.putStringList(CLEANUP_FORMATTERS, cleanupPreset.getFormatterCleanups().getAsStringList(OS.NEWLINE));
    }

    public RemotePreferences getRemotePreferences() {
        return new RemotePreferences(this.getInt(REMOTE_SERVER_PORT), this.getBoolean(USE_REMOTE_SERVER));
    }

    public void setRemotePreferences(RemotePreferences remotePreferences) {
        this.putInt(REMOTE_SERVER_PORT, remotePreferences.getPort());
        this.putBoolean(USE_REMOTE_SERVER, remotePreferences.useRemoteServer());
    }

    public void storeExportSaveOrder(SaveOrderConfig config) {
        this.putBoolean(EXPORT_PRIMARY_SORT_DESCENDING, config.sortCriteria[0].descending);
        this.putBoolean(EXPORT_SECONDARY_SORT_DESCENDING, config.sortCriteria[1].descending);
        this.putBoolean(EXPORT_TERTIARY_SORT_DESCENDING, config.sortCriteria[2].descending);
        this.put(EXPORT_PRIMARY_SORT_FIELD, config.sortCriteria[0].field);
        this.put(EXPORT_SECONDARY_SORT_FIELD, config.sortCriteria[1].field);
        this.put(EXPORT_TERTIARY_SORT_FIELD, config.sortCriteria[2].field);
    }

    public SaveOrderConfig loadTableSaveOrder() {
        SaveOrderConfig config = new SaveOrderConfig();
        config.sortCriteria[0].field = this.get(TABLE_PRIMARY_SORT_FIELD);
        config.sortCriteria[0].descending = this.getBoolean(TABLE_PRIMARY_SORT_DESCENDING);
        config.sortCriteria[1].field = this.get(TABLE_SECONDARY_SORT_FIELD);
        config.sortCriteria[1].descending = this.getBoolean(TABLE_SECONDARY_SORT_DESCENDING);
        config.sortCriteria[2].field = this.get(TABLE_TERTIARY_SORT_FIELD);
        config.sortCriteria[2].descending = this.getBoolean(TABLE_TERTIARY_SORT_DESCENDING);
        return config;
    }

    public SaveOrderConfig loadExportSaveOrder() {
        SaveOrderConfig config = new SaveOrderConfig();
        config.sortCriteria[0].field = this.get(EXPORT_PRIMARY_SORT_FIELD);
        config.sortCriteria[0].descending = this.getBoolean(EXPORT_PRIMARY_SORT_DESCENDING);
        config.sortCriteria[1].field = this.get(EXPORT_SECONDARY_SORT_FIELD);
        config.sortCriteria[1].descending = this.getBoolean(EXPORT_SECONDARY_SORT_DESCENDING);
        config.sortCriteria[2].field = this.get(EXPORT_TERTIARY_SORT_FIELD);
        config.sortCriteria[2].descending = this.getBoolean(EXPORT_TERTIARY_SORT_DESCENDING);
        return config;
    }

    public Character getKeywordDelimiter() {
        return Character.valueOf(this.get(KEYWORD_SEPARATOR).charAt(0));
    }

    public String getOrCreateUserId() {
        Optional<String> userId = this.getAsOptional(USER_ID);
        if (userId.isPresent()) {
            return userId.get();
        }
        String newUserId = UUID.randomUUID().toString();
        this.put(USER_ID, newUserId);
        return newUserId;
    }

    public Boolean shouldCollectTelemetry() {
        return this.getBoolean(COLLECT_TELEMETRY);
    }

    public void setShouldCollectTelemetry(boolean value) {
        this.putBoolean(COLLECT_TELEMETRY, value);
    }

    public Boolean shouldAskToCollectTelemetry() {
        return this.getBoolean(ALREADY_ASKED_TO_COLLECT_TELEMETRY);
    }

    public void askedToCollectTelemetry() {
        this.putBoolean(ALREADY_ASKED_TO_COLLECT_TELEMETRY, true);
    }

    @Override
    public void storeKeyBindingRepository(KeyBindingRepository keyBindingRepository) {
        this.putStringList(BIND_NAMES, keyBindingRepository.getBindNames());
        this.putStringList(BINDINGS, keyBindingRepository.getBindings());
    }

    @Override
    public KeyBindingRepository getKeyBindingRepository() {
        return new KeyBindingRepository(this.getStringList(BIND_NAMES), this.getStringList(BINDINGS));
    }

    @Override
    public void storeJournalAbbreviationPreferences(JournalAbbreviationPreferences abbreviationsPreferences) {
        this.putStringList(EXTERNAL_JOURNAL_LISTS, abbreviationsPreferences.getExternalJournalLists());
        this.putBoolean(USE_IEEE_ABRV, abbreviationsPreferences.useIEEEAbbreviations());
    }

    public AutoLinkPreferences getAutoLinkPreferences() {
        return new AutoLinkPreferences(this.getBoolean(AUTOLINK_USE_REG_EXP_SEARCH_KEY), this.get(AUTOLINK_REG_EXP_SEARCH_EXPRESSION_KEY), this.getBoolean(AUTOLINK_EXACT_KEY_ONLY), this.getKeywordDelimiter());
    }

    public AutoCompletePreferences getAutoCompletePreferences() {
        return new AutoCompletePreferences(this.getBoolean(AUTO_COMPLETE), AutoCompleteFirstNameMode.parse(this.get(AUTOCOMPLETER_FIRSTNAME_MODE)), this.getBoolean(AUTOCOMPLETER_LAST_FIRST), this.getBoolean(AUTOCOMPLETER_FIRST_LAST), this.getStringList(AUTOCOMPLETER_COMPLETE_FIELDS), this.getJournalAbbreviationPreferences());
    }

    public void storeAutoCompletePreferences(AutoCompletePreferences autoCompletePreferences) {
        this.putBoolean(AUTO_COMPLETE, autoCompletePreferences.shouldAutoComplete());
        this.put(AUTOCOMPLETER_FIRSTNAME_MODE, autoCompletePreferences.getFirstNameMode().name());
        this.putBoolean(AUTOCOMPLETER_LAST_FIRST, autoCompletePreferences.getOnlyCompleteLastFirst());
        this.putBoolean(AUTOCOMPLETER_FIRST_LAST, autoCompletePreferences.getOnlyCompleteFirstLast());
        this.putStringList(AUTOCOMPLETER_COMPLETE_FIELDS, autoCompletePreferences.getCompleteFields());
    }
}

