/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.jabref.model.EntryTypes;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.CanonicalBibtexEntry;
import org.jabref.model.entry.Date;
import org.jabref.model.entry.EntryConverter;
import org.jabref.model.entry.EntryLinkList;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.FileFieldParser;
import org.jabref.model.entry.FileFieldWriter;
import org.jabref.model.entry.IdGenerator;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.ParsedEntryLink;
import org.jabref.model.entry.SharedBibEntryData;
import org.jabref.model.entry.event.EntryEventSource;
import org.jabref.model.entry.event.FieldAddedOrRemovedEvent;
import org.jabref.model.entry.event.FieldChangedEvent;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.strings.LatexToUnicodeAdapter;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibEntry
implements Cloneable {
    public static final String TYPE_HEADER = "entrytype";
    public static final String OBSOLETE_TYPE_HEADER = "bibtextype";
    public static final String KEY_FIELD = "bibtexkey";
    public static final String DEFAULT_TYPE = "misc";
    protected static final String ID_FIELD = "id";
    private static final Logger LOGGER = LoggerFactory.getLogger(BibEntry.class);
    private static final Pattern REMOVE_TRAILING_WHITESPACE = Pattern.compile("\\s+$");
    private final SharedBibEntryData sharedBibEntryData;
    private final Map<String, Set<String>> fieldsAsWords = new HashMap<String, Set<String>>();
    private final Map<String, String> latexFreeFields = new ConcurrentHashMap<String, String>();
    private final EventBus eventBus = new EventBus();
    private String id;
    private StringProperty type = new SimpleStringProperty();
    private ObservableMap<String, String> fields = FXCollections.observableMap(new ConcurrentHashMap());
    private boolean searchHit;
    private boolean groupHit;
    private String parsedSerialization;
    private String commentsBeforeEntry = "";
    private boolean changed;

    public BibEntry() {
        this(IdGenerator.next(), DEFAULT_TYPE);
    }

    public BibEntry(String type) {
        this(IdGenerator.next(), type);
    }

    private BibEntry(String id, String type) {
        Objects.requireNonNull(id, "Every BibEntry must have an ID");
        this.id = id;
        this.setType(type);
        this.sharedBibEntryData = new SharedBibEntryData();
    }

    public Optional<FieldChange> setMonth(Month parsedMonth) {
        return this.setField("month", parsedMonth.getJabRefFormat());
    }

    public Optional<String> getResolvedFieldOrAlias(String field2, BibDatabase database) {
        if (TYPE_HEADER.equals(field2) || OBSOLETE_TYPE_HEADER.equals(field2)) {
            Optional<EntryType> entryType = EntryTypes.getType(this.getType(), BibDatabaseMode.BIBLATEX);
            if (entryType.isPresent()) {
                return Optional.of(entryType.get().getName());
            }
            return Optional.of(StringUtil.capitalizeFirst(this.getType()));
        }
        if (KEY_FIELD.equals(field2)) {
            return this.getCiteKeyOptional();
        }
        Optional<String> result = this.getFieldOrAlias(field2);
        if (!result.isPresent() && database != null) {
            Optional<BibEntry> referred = database.getReferencedEntry(this);
            result = referred.flatMap(entry -> entry.getFieldOrAlias(field2));
        }
        return result.map(resultText -> BibDatabase.getText(resultText, database));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Objects.requireNonNull(id, "Every BibEntry must have an ID");
        String oldId = this.id;
        this.eventBus.post(new FieldChangedEvent(this, ID_FIELD, id, oldId));
        this.id = id;
        this.changed = true;
    }

    @Deprecated
    public String getCiteKey() {
        return (String)this.fields.get((Object)KEY_FIELD);
    }

    public Optional<FieldChange> setCiteKey(String newCiteKey) {
        return this.setField(KEY_FIELD, newCiteKey);
    }

    public Optional<String> getCiteKeyOptional() {
        return Optional.ofNullable((String)this.fields.get((Object)KEY_FIELD));
    }

    public boolean hasCiteKey() {
        return !Strings.isNullOrEmpty(this.getCiteKey());
    }

    public String getType() {
        return this.type.getValue();
    }

    public StringProperty typeProperty() {
        return this.type;
    }

    public Optional<FieldChange> setType(EntryType type) {
        return this.setType(type.getName());
    }

    public Optional<FieldChange> setType(String type) {
        return this.setType(type, EntryEventSource.LOCAL);
    }

    public Optional<FieldChange> setType(String type, EntryEventSource eventSource) {
        String oldType;
        String newType = Strings.isNullOrEmpty(type) ? DEFAULT_TYPE : type;
        if (newType.equals(oldType = (String)this.getField(TYPE_HEADER).orElse(null))) {
            return Optional.empty();
        }
        this.type.setValue(newType.toLowerCase(Locale.ENGLISH));
        this.changed = true;
        FieldChange change = new FieldChange(this, TYPE_HEADER, oldType, newType);
        this.eventBus.post(new FieldChangedEvent(change, eventSource));
        return Optional.of(change);
    }

    public Set<String> getFieldNames() {
        return new TreeSet<String>(this.fields.keySet());
    }

    public Optional<String> getField(String name) {
        return Optional.ofNullable((String)this.fields.get((Object)this.toLowerCase(name)));
    }

    public boolean hasField(String name) {
        return this.fields.containsKey((Object)this.toLowerCase(name));
    }

    private String toLowerCase(String fieldName) {
        Objects.requireNonNull(fieldName, "field name must not be null");
        return fieldName.toLowerCase(Locale.ENGLISH);
    }

    private Optional<String> genericGetFieldOrAlias(String name, GetFieldInterface getFieldInterface) {
        Optional<String> fieldValue = getFieldInterface.getValueForField(this.toLowerCase(name));
        if (fieldValue.isPresent() && !fieldValue.get().isEmpty()) {
            return fieldValue;
        }
        String aliasForField = EntryConverter.FIELD_ALIASES.get(name);
        if (aliasForField != null) {
            return getFieldInterface.getValueForField(aliasForField);
        }
        if ("date".equals(name)) {
            Optional<Date> date = Date.parse(getFieldInterface.getValueForField("year"), getFieldInterface.getValueForField("month"), getFieldInterface.getValueForField("day"));
            return date.map(Date::getNormalized);
        }
        if ("year".equals(name) || "month".equals(name) || "day".equals(name)) {
            Optional<String> date = getFieldInterface.getValueForField("date");
            if (!date.isPresent()) {
                return Optional.empty();
            }
            Optional<Date> parsedDate = Date.parse(date.get());
            if (parsedDate.isPresent()) {
                if ("year".equals(name)) {
                    return parsedDate.get().getYear().map(Object::toString);
                }
                if ("month".equals(name)) {
                    return parsedDate.get().getMonth().map(Month::getJabRefFormat);
                }
                if ("day".equals(name)) {
                    return parsedDate.get().getDay().map(Object::toString);
                }
            } else {
                LOGGER.warn("Could not parse date " + date.get());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<DOI> getDOI() {
        return this.getField("doi").flatMap(DOI::parse);
    }

    public Optional<String> getFieldOrAliasLatexFree(String name) {
        return this.genericGetFieldOrAlias(name, this::getLatexFreeField);
    }

    public Optional<String> getFieldOrAlias(String name) {
        return this.genericGetFieldOrAlias(name, this::getField);
    }

    public void setField(Map<String, String> fields) {
        Objects.requireNonNull(fields, "fields must not be null");
        fields.forEach(this::setField);
    }

    public Optional<FieldChange> setField(String name, String value, EntryEventSource eventSource) {
        boolean isNewField;
        Objects.requireNonNull(name, "field name must not be null");
        Objects.requireNonNull(value, "field value must not be null");
        String fieldName = this.toLowerCase(name);
        if (value.isEmpty()) {
            return this.clearField(fieldName);
        }
        String oldValue = this.getField(fieldName).orElse(null);
        boolean bl = isNewField = oldValue == null;
        if (value.equals(oldValue)) {
            return Optional.empty();
        }
        if (ID_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("The field name '" + name + "' is reserved");
        }
        this.changed = true;
        this.fields.put((Object)fieldName, (Object)value.intern());
        this.invalidateFieldCache(fieldName);
        FieldChange change = new FieldChange(this, fieldName, oldValue, value);
        if (isNewField) {
            this.eventBus.post(new FieldAddedOrRemovedEvent(change, eventSource));
        } else {
            this.eventBus.post(new FieldChangedEvent(change, eventSource));
        }
        return Optional.of(change);
    }

    public Optional<FieldChange> setField(String name, Optional<String> value, EntryEventSource eventSource) {
        if (value.isPresent()) {
            return this.setField(name, value.get(), eventSource);
        }
        return Optional.empty();
    }

    public Optional<FieldChange> setField(String name, String value) {
        return this.setField(name, value, EntryEventSource.LOCAL);
    }

    public Optional<FieldChange> clearField(String name) {
        return this.clearField(name, EntryEventSource.LOCAL);
    }

    public Optional<FieldChange> clearField(String name, EntryEventSource eventSource) {
        String fieldName = this.toLowerCase(name);
        if (ID_FIELD.equals(fieldName)) {
            throw new IllegalArgumentException("The field name '" + name + "' is reserved");
        }
        Optional<String> oldValue = this.getField(fieldName);
        if (!oldValue.isPresent()) {
            return Optional.empty();
        }
        this.changed = true;
        this.fields.remove((Object)fieldName);
        this.invalidateFieldCache(fieldName);
        FieldChange change = new FieldChange(this, fieldName, oldValue.get(), null);
        this.eventBus.post(new FieldAddedOrRemovedEvent(change, eventSource));
        return Optional.of(change);
    }

    public boolean allFieldsPresent(Collection<String> allFields, BibDatabase database) {
        for (String field2 : allFields) {
            String[] altFields;
            String fieldName = this.toLowerCase(field2);
            if (!(fieldName.contains("/") ? !this.atLeastOnePresent(altFields = field2.split("/"), database) : !this.getResolvedFieldOrAlias(fieldName, database).isPresent())) continue;
            return false;
        }
        return true;
    }

    private boolean atLeastOnePresent(String[] fieldsToCheck, BibDatabase database) {
        for (String field2 : fieldsToCheck) {
            String fieldName = this.toLowerCase(field2);
            Optional<String> value = this.getResolvedFieldOrAlias(fieldName, database);
            if (!value.isPresent() || value.get().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        BibEntry clone = new BibEntry(this.type.getValue());
        clone.fields = FXCollections.observableMap(new ConcurrentHashMap<String, String>((Map<String, String>)this.fields));
        return clone;
    }

    public String toString() {
        return CanonicalBibtexEntry.getCanonicalRepresentation(this);
    }

    public boolean isSearchHit() {
        return this.searchHit;
    }

    public void setSearchHit(boolean searchHit) {
        this.searchHit = searchHit;
    }

    public boolean isGroupHit() {
        return this.groupHit;
    }

    public void setGroupHit(boolean groupHit) {
        this.groupHit = groupHit;
    }

    public String getAuthorTitleYear(int maxCharacters) {
        String[] s2 = new String[]{this.getField("author").orElse("N/A"), this.getField("title").orElse("N/A"), this.getField("year").orElse("N/A")};
        String text = s2[0] + ": \"" + s2[1] + "\" (" + s2[2] + ')';
        if (maxCharacters <= 0 || text.length() <= maxCharacters) {
            return text;
        }
        return text.substring(0, maxCharacters + 1) + "...";
    }

    public Optional<String> getTitle() {
        return this.getField("title");
    }

    public Optional<Date> getPublicationDate() {
        return this.getFieldOrAlias("date").flatMap(Date::parse);
    }

    public String getParsedSerialization() {
        return this.parsedSerialization;
    }

    public void setParsedSerialization(String parsedSerialization) {
        this.changed = false;
        this.parsedSerialization = parsedSerialization;
    }

    public void setCommentsBeforeEntry(String parsedComments) {
        this.commentsBeforeEntry = REMOVE_TRAILING_WHITESPACE.matcher(parsedComments).replaceFirst("");
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Optional<FieldChange> putKeywords(List<String> keywords, Character delimiter) {
        Objects.requireNonNull(delimiter);
        return this.putKeywords(new KeywordList(keywords), delimiter);
    }

    public Optional<FieldChange> putKeywords(KeywordList keywords, Character delimiter) {
        Objects.requireNonNull(keywords);
        Optional<String> oldValue = this.getField("keywords");
        if (keywords.isEmpty()) {
            if (oldValue.isPresent()) {
                return this.clearField("keywords");
            }
            return Optional.empty();
        }
        String newValue = keywords.getAsString(delimiter);
        return this.setField("keywords", newValue);
    }

    public void addKeyword(String keyword, Character delimiter) {
        Objects.requireNonNull(keyword, "keyword must not be null");
        if (keyword.isEmpty()) {
            return;
        }
        this.addKeyword(new Keyword(keyword), delimiter);
    }

    public void addKeyword(Keyword keyword, Character delimiter) {
        KeywordList keywords = this.getKeywords(delimiter);
        keywords.add(keyword);
        this.putKeywords(keywords, delimiter);
    }

    public void addKeywords(Collection<String> keywords, Character delimiter) {
        Objects.requireNonNull(keywords);
        keywords.forEach(keyword -> this.addKeyword((String)keyword, delimiter));
    }

    public KeywordList getKeywords(Character delimiter) {
        Optional<String> keywordsContent = this.getField("keywords");
        return keywordsContent.map(content -> KeywordList.parse(content, delimiter)).orElse(new KeywordList());
    }

    public KeywordList getResolvedKeywords(Character delimiter, BibDatabase database) {
        Optional<String> keywordsContent = this.getResolvedFieldOrAlias("keywords", database);
        return keywordsContent.map(content -> KeywordList.parse(content, delimiter)).orElse(new KeywordList());
    }

    public Optional<FieldChange> removeKeywords(KeywordList keywordsToRemove, Character keywordDelimiter) {
        KeywordList keywordList = this.getKeywords(keywordDelimiter);
        keywordList.removeAll(keywordsToRemove);
        return this.putKeywords(keywordList, keywordDelimiter);
    }

    public Optional<FieldChange> replaceKeywords(KeywordList keywordsToReplace, Keyword newValue, Character keywordDelimiter) {
        KeywordList keywordList = this.getKeywords(keywordDelimiter);
        keywordList.replaceAll(keywordsToReplace, newValue);
        return this.putKeywords(keywordList, keywordDelimiter);
    }

    public Collection<String> getFieldValues() {
        return this.fields.values();
    }

    public Map<String, String> getFieldMap() {
        return this.fields;
    }

    public SharedBibEntryData getSharedBibEntryData() {
        return this.sharedBibEntryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BibEntry entry = (BibEntry)o;
        return Objects.equals(this.type.getValue(), entry.type.getValue()) && Objects.equals(this.fields, entry.fields) && Objects.equals(this.commentsBeforeEntry, entry.commentsBeforeEntry);
    }

    public int hashCode() {
        return Objects.hash(this.type.getValue(), this.fields);
    }

    public void registerListener(Object object) {
        this.eventBus.register(object);
    }

    public void unregisterListener(Object object) {
        try {
            this.eventBus.unregister(object);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Problem unregistering", e);
        }
    }

    public BibEntry withField(String field2, String value) {
        this.setField(field2, value);
        return this;
    }

    public String getUserComments() {
        return this.commentsBeforeEntry;
    }

    public List<ParsedEntryLink> getEntryLinkList(String fieldName, BibDatabase database) {
        return this.getField(fieldName).map(fieldValue -> EntryLinkList.parse(fieldValue, database)).orElse(Collections.emptyList());
    }

    public Optional<FieldChange> setEntryLinkList(String fieldName, List<ParsedEntryLink> list) {
        return this.setField(fieldName, EntryLinkList.serialize(list));
    }

    public Set<String> getFieldAsWords(String field2) {
        String fieldName = this.toLowerCase(field2);
        Set<String> storedList = this.fieldsAsWords.get(fieldName);
        if (storedList != null) {
            return storedList;
        }
        String fieldValue = (String)this.fields.get((Object)fieldName);
        if (fieldValue == null) {
            return Collections.emptySet();
        }
        HashSet<String> words = new HashSet<String>(StringUtil.getStringAsWords(fieldValue));
        this.fieldsAsWords.put(fieldName, words);
        return words;
    }

    public Optional<FieldChange> clearCiteKey() {
        return this.clearField(KEY_FIELD);
    }

    private void invalidateFieldCache(String fieldName) {
        this.latexFreeFields.remove(fieldName);
        this.fieldsAsWords.remove(fieldName);
    }

    public Optional<String> getLatexFreeField(String name) {
        if (!this.hasField(name)) {
            return Optional.empty();
        }
        if (this.latexFreeFields.containsKey(name)) {
            return Optional.ofNullable(this.latexFreeFields.get(this.toLowerCase(name)));
        }
        if (KEY_FIELD.equals(name)) {
            Optional<String> citeKey = this.getCiteKeyOptional();
            this.latexFreeFields.put(name, citeKey.get());
            return citeKey;
        }
        String latexFreeField = LatexToUnicodeAdapter.format(this.getField(name).get()).intern();
        this.latexFreeFields.put(name, latexFreeField);
        return Optional.of(latexFreeField);
    }

    public Optional<FieldChange> setFiles(List<LinkedFile> files) {
        Optional<String> oldValue = this.getField("file");
        String newValue = FileFieldWriter.getStringRepresentation(files);
        if (oldValue.isPresent() && oldValue.get().equals(newValue)) {
            return Optional.empty();
        }
        return this.setField("file", newValue);
    }

    public List<LinkedFile> getFiles() {
        Optional<String> oldValue = this.getField("file");
        if (!oldValue.isPresent()) {
            return new ArrayList<LinkedFile>();
        }
        return FileFieldParser.parse(oldValue.get());
    }

    public void setDate(Date date) {
        date.getYear().ifPresent(year -> this.setField("year", year.toString()));
        date.getMonth().ifPresent(this::setMonth);
        date.getDay().ifPresent(day -> this.setField("day", day.toString()));
    }

    public Optional<Month> getMonth() {
        return this.getFieldOrAlias("month").flatMap(Month::parse);
    }

    public ObjectBinding<String> getFieldBinding(String fieldName) {
        return Bindings.valueAt(this.fields, (Object)fieldName);
    }

    public Optional<FieldChange> addFile(LinkedFile file) {
        List<LinkedFile> linkedFiles = this.getFiles();
        linkedFiles.add(file);
        return this.setFiles(linkedFiles);
    }

    public ObservableMap<String, String> getFieldsObservable() {
        return this.fields;
    }

    private static interface GetFieldInterface {
        public Optional<String> getValueForField(String var1);
    }
}

