/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;

public class RemoveBracesFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Remove enclosing braces", new String[0]);
    }

    @Override
    public String getKey() {
        return "remove_braces";
    }

    @Override
    public String format(String value) {
        Objects.requireNonNull(value);
        String formatted = value;
        while (formatted.length() >= 2 && formatted.charAt(0) == '{' && formatted.charAt(formatted.length() - 1) == '}') {
            String trimmed = formatted.substring(1, formatted.length() - 1);
            if (this.hasNegativeBraceCount(trimmed)) {
                return formatted;
            }
            formatted = trimmed;
        }
        return formatted;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Removes braces encapsulating the complete field content.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "{In CDMA}";
    }

    private boolean hasNegativeBraceCount(String value) {
        int braceCount = 0;
        for (int index = 0; index < value.length(); ++index) {
            char charAtIndex = value.charAt(index);
            if (charAtIndex == '{') {
                ++braceCount;
            } else if (charAtIndex == '}') {
                --braceCount;
            }
            if (braceCount >= 0) continue;
            return true;
        }
        return false;
    }
}

