/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.OSXCompatibleToolbar;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.preftabs.PrefsTab;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableColumnsTab
extends JPanel
implements PrefsTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableColumnsTab.class);
    private final JabRefPreferences prefs;
    private boolean tableChanged;
    private final JTable colSetup;
    private int rowCount = -1;
    private int ncWidth = -1;
    private final List<TableRow> tableRows = new ArrayList<TableRow>(10);
    private final JabRefFrame frame;
    private final JCheckBox urlColumn;
    private final JCheckBox fileColumn;
    private final JCheckBox arxivColumn;
    private final JCheckBox extraFileColumns;
    private final JList<String> listOfFileColumns;
    private final JRadioButton preferUrl;
    private final JRadioButton preferDoi;
    private final JCheckBox specialFieldsEnabled;
    private final JCheckBox rankingColumn;
    private final JCheckBox qualityColumn;
    private final JCheckBox priorityColumn;
    private final JCheckBox relevanceColumn;
    private final JCheckBox printedColumn;
    private final JCheckBox readStatusColumn;
    private final JRadioButton syncKeywords;
    private final JRadioButton writeSpecialFields;
    private boolean oldSpecialFieldsEnabled;
    private boolean oldRankingColumn;
    private boolean oldQualityColumn;
    private boolean oldPriorityColumn;
    private boolean oldRelevanceColumn;
    private boolean oldPrintedColumn;
    private boolean oldReadStatusColumn;
    private boolean oldSyncKeyWords;
    private boolean oldWriteSpecialFields;

    public TableColumnsTab(JabRefPreferences prefs, JabRefFrame frame) {
        this.prefs = prefs;
        this.frame = frame;
        this.setLayout(new BorderLayout());
        AbstractTableModel tm = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return TableColumnsTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                int internalRow = row;
                if (internalRow == 0) {
                    return column == 0 ? "#" : String.valueOf(TableColumnsTab.this.ncWidth);
                }
                if (--internalRow >= TableColumnsTab.this.tableRows.size()) {
                    return "";
                }
                TableRow rowContent = (TableRow)TableColumnsTab.this.tableRows.get(internalRow);
                if (rowContent == null) {
                    return "";
                }
                if (column == 0) {
                    return rowContent.getName();
                }
                return rowContent.getLength() > 0 ? Integer.toString(rowContent.getLength()) : "";
            }

            @Override
            public String getColumnName(int col) {
                return col == 0 ? Localization.lang("Field name", new String[0]) : Localization.lang("Column width", new String[0]);
            }

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return String.class;
                }
                return Integer.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return row != 0 || col != 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                TableColumnsTab.this.tableChanged = true;
                while (row >= TableColumnsTab.this.tableRows.size()) {
                    TableColumnsTab.this.tableRows.add(new TableRow("", -1));
                }
                if (row == 0 && col == 1) {
                    TableColumnsTab.this.ncWidth = Integer.parseInt(value.toString());
                    return;
                }
                TableRow rowContent = (TableRow)TableColumnsTab.this.tableRows.get(row - 1);
                if (col == 0) {
                    rowContent.setName(value.toString());
                    if ("".equals(this.getValueAt(row, 1))) {
                        this.setValueAt(String.valueOf(100), row, 1);
                    }
                } else if (value == null) {
                    rowContent.setLength(-1);
                } else {
                    rowContent.setLength(Integer.parseInt(value.toString()));
                }
            }
        };
        this.colSetup = new JTable(tm);
        TableColumnModel cm = this.colSetup.getColumnModel();
        cm.getColumn(0).setPreferredWidth(140);
        cm.getColumn(1).setPreferredWidth(80);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        JPanel tabPanel = new JPanel();
        tabPanel.setLayout(new BorderLayout());
        JScrollPane sp2 = new JScrollPane(this.colSetup, 20, 31);
        this.colSetup.setPreferredScrollableViewportSize(new Dimension(250, 200));
        sp2.setMinimumSize(new Dimension(250, 300));
        tabPanel.add((Component)sp2, "Center");
        OSXCompatibleToolbar toolBar = new OSXCompatibleToolbar(1);
        toolBar.setFloatable(false);
        AddRowAction addRow = new AddRowAction();
        DeleteRowAction deleteRow = new DeleteRowAction();
        MoveRowUpAction moveUp = new MoveRowUpAction();
        MoveRowDownAction moveDown = new MoveRowDownAction();
        toolBar.setBorder(null);
        toolBar.add(addRow);
        toolBar.add(deleteRow);
        toolBar.addSeparator();
        toolBar.add(moveUp);
        toolBar.add(moveDown);
        tabPanel.add((Component)toolBar, "East");
        this.fileColumn = new JCheckBox(Localization.lang("Show file column", new String[0]));
        this.urlColumn = new JCheckBox(Localization.lang("Show URL/DOI column", new String[0]));
        this.preferUrl = new JRadioButton(Localization.lang("Show URL first", new String[0]));
        this.preferDoi = new JRadioButton(Localization.lang("Show DOI first", new String[0]));
        ButtonGroup preferUrlDoiGroup = new ButtonGroup();
        preferUrlDoiGroup.add(this.preferUrl);
        preferUrlDoiGroup.add(this.preferDoi);
        this.urlColumn.addChangeListener(arg0 -> {
            this.preferUrl.setEnabled(this.urlColumn.isSelected());
            this.preferDoi.setEnabled(this.urlColumn.isSelected());
        });
        this.arxivColumn = new JCheckBox(Localization.lang("Show ArXiv column", new String[0]));
        Set<ExternalFileType> fileTypes = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
        String[] fileTypeNames = new String[fileTypes.size()];
        int i = 0;
        for (ExternalFileType fileType : fileTypes) {
            fileTypeNames[i++] = fileType.getName();
        }
        this.listOfFileColumns = new JList<String>(fileTypeNames);
        JScrollPane listOfFileColumnsScrollPane = new JScrollPane(this.listOfFileColumns);
        this.listOfFileColumns.setVisibleRowCount(3);
        this.extraFileColumns = new JCheckBox(Localization.lang("Show extra columns", new String[0]));
        this.extraFileColumns.addChangeListener(arg0 -> this.listOfFileColumns.setEnabled(this.extraFileColumns.isSelected()));
        JButton helpButton = new HelpAction(Localization.lang("Help on special fields", new String[0]), HelpFile.SPECIAL_FIELDS).getHelpButton();
        this.rankingColumn = new JCheckBox(Localization.lang("Show rank", new String[0]));
        this.qualityColumn = new JCheckBox(Localization.lang("Show quality", new String[0]));
        this.priorityColumn = new JCheckBox(Localization.lang("Show priority", new String[0]));
        this.relevanceColumn = new JCheckBox(Localization.lang("Show relevance", new String[0]));
        this.printedColumn = new JCheckBox(Localization.lang("Show printed status", new String[0]));
        this.readStatusColumn = new JCheckBox(Localization.lang("Show read status", new String[0]));
        this.syncKeywords = new JRadioButton(Localization.lang("Synchronize with keywords", new String[0]));
        this.writeSpecialFields = new JRadioButton(Localization.lang("Write values of special fields as separate fields to BibTeX", new String[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.syncKeywords);
        group.add(this.writeSpecialFields);
        this.specialFieldsEnabled = new JCheckBox(Localization.lang("Enable special fields", new String[0]));
        this.specialFieldsEnabled.addChangeListener(event -> {
            boolean isEnabled = this.specialFieldsEnabled.isSelected();
            this.rankingColumn.setEnabled(isEnabled);
            this.qualityColumn.setEnabled(isEnabled);
            this.priorityColumn.setEnabled(isEnabled);
            this.relevanceColumn.setEnabled(isEnabled);
            this.printedColumn.setEnabled(isEnabled);
            this.readStatusColumn.setEnabled(isEnabled);
            this.syncKeywords.setEnabled(isEnabled);
            this.writeSpecialFields.setEnabled(isEnabled);
        });
        builder.appendSeparator(Localization.lang("Special table columns", new String[0]));
        builder.nextLine();
        builder.append(pan);
        DefaultFormBuilder specialTableColumnsBuilder = new DefaultFormBuilder(new FormLayout("8dlu, 8dlu, 8cm, 8dlu, 8dlu, left:pref:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref"));
        CellConstraints cc = new CellConstraints();
        specialTableColumnsBuilder.add((Component)this.specialFieldsEnabled, cc.xyw(1, 1, 3));
        specialTableColumnsBuilder.add((Component)this.rankingColumn, cc.xyw(2, 2, 2));
        specialTableColumnsBuilder.add((Component)this.relevanceColumn, cc.xyw(2, 3, 2));
        specialTableColumnsBuilder.add((Component)this.qualityColumn, cc.xyw(2, 4, 2));
        specialTableColumnsBuilder.add((Component)this.priorityColumn, cc.xyw(2, 5, 2));
        specialTableColumnsBuilder.add((Component)this.printedColumn, cc.xyw(2, 6, 2));
        specialTableColumnsBuilder.add((Component)this.readStatusColumn, cc.xyw(2, 7, 2));
        specialTableColumnsBuilder.add((Component)this.syncKeywords, cc.xyw(2, 10, 2));
        specialTableColumnsBuilder.add((Component)this.writeSpecialFields, cc.xyw(2, 11, 2));
        specialTableColumnsBuilder.add((Component)helpButton, cc.xyw(1, 12, 2));
        specialTableColumnsBuilder.add((Component)this.fileColumn, cc.xyw(5, 1, 2));
        specialTableColumnsBuilder.add((Component)this.urlColumn, cc.xyw(5, 2, 2));
        specialTableColumnsBuilder.add((Component)this.preferUrl, cc.xy(6, 3));
        specialTableColumnsBuilder.add((Component)this.preferDoi, cc.xy(6, 4));
        specialTableColumnsBuilder.add((Component)this.arxivColumn, cc.xyw(5, 5, 2));
        specialTableColumnsBuilder.add((Component)this.extraFileColumns, cc.xyw(5, 6, 2));
        specialTableColumnsBuilder.add((Component)listOfFileColumnsScrollPane, cc.xywh(5, 7, 2, 6));
        builder.append(specialTableColumnsBuilder.getPanel());
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Entry table columns", new String[0]));
        builder.nextLine();
        builder.append(pan);
        builder.append(tabPanel);
        builder.nextLine();
        builder.append(pan);
        JButton buttonWidth = new JButton(new UpdateWidthsAction());
        JButton buttonOrder = new JButton(new UpdateOrderAction());
        builder.append(buttonWidth);
        builder.nextLine();
        builder.append(pan);
        builder.append(buttonOrder);
        builder.nextLine();
        builder.append(pan);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.fileColumn.setSelected(this.prefs.getBoolean("fileColumn"));
        this.urlColumn.setSelected(this.prefs.getBoolean("urlColumn"));
        this.preferUrl.setSelected(!this.prefs.getBoolean("preferUrlDoi"));
        this.preferDoi.setSelected(this.prefs.getBoolean("preferUrlDoi"));
        this.fileColumn.setSelected(this.prefs.getBoolean("fileColumn"));
        this.arxivColumn.setSelected(this.prefs.getBoolean("arxivColumn"));
        this.extraFileColumns.setSelected(this.prefs.getBoolean("extraFileColumns"));
        if (this.extraFileColumns.isSelected()) {
            List<String> desiredColumns = this.prefs.getStringList("listOfFileColumns");
            int listSize = this.listOfFileColumns.getModel().getSize();
            int[] indicesToSelect = new int[listSize];
            block0: for (int i = 0; i < listSize; ++i) {
                indicesToSelect[i] = listSize + 1;
                for (String desiredColumn : desiredColumns) {
                    if (!this.listOfFileColumns.getModel().getElementAt(i).equals(desiredColumn)) continue;
                    indicesToSelect[i] = i;
                    continue block0;
                }
            }
            this.listOfFileColumns.setSelectedIndices(indicesToSelect);
        } else {
            this.listOfFileColumns.setSelectedIndices(new int[0]);
        }
        this.oldRankingColumn = this.prefs.getBoolean("showRankingColumn");
        this.rankingColumn.setSelected(this.oldRankingColumn);
        this.oldQualityColumn = this.prefs.getBoolean("showQualityColumn");
        this.qualityColumn.setSelected(this.oldQualityColumn);
        this.oldPriorityColumn = this.prefs.getBoolean("showPriorityColumn");
        this.priorityColumn.setSelected(this.oldPriorityColumn);
        this.oldRelevanceColumn = this.prefs.getBoolean("showRelevanceColumn");
        this.relevanceColumn.setSelected(this.oldRelevanceColumn);
        this.oldPrintedColumn = this.prefs.getBoolean("showPrintedColumn");
        this.printedColumn.setSelected(this.oldPrintedColumn);
        this.oldReadStatusColumn = this.prefs.getBoolean("showReadColumn");
        this.readStatusColumn.setSelected(this.oldReadStatusColumn);
        this.oldSyncKeyWords = this.prefs.getBoolean("autoSyncSpecialFieldsToKeywords");
        this.syncKeywords.setSelected(this.oldSyncKeyWords);
        this.oldWriteSpecialFields = this.prefs.getBoolean("serializeSpecialFields");
        this.writeSpecialFields.setSelected(this.oldWriteSpecialFields);
        this.oldSpecialFieldsEnabled = this.prefs.getBoolean("specialFieldsEnabled");
        this.specialFieldsEnabled.setSelected(!this.oldSpecialFieldsEnabled);
        this.specialFieldsEnabled.setSelected(this.oldSpecialFieldsEnabled);
        this.tableRows.clear();
        List<String> names = this.prefs.getStringList("columnNames");
        List<String> lengths = this.prefs.getStringList("columnWidths");
        for (int i = 0; i < names.size(); ++i) {
            if (i < lengths.size()) {
                this.tableRows.add(new TableRow(names.get(i), Integer.parseInt(lengths.get(i))));
                continue;
            }
            this.tableRows.add(new TableRow(names.get(i)));
        }
        this.rowCount = this.tableRows.size() + 5;
        this.ncWidth = this.prefs.getInt("numberColWidth");
    }

    @Override
    public void storeSettings() {
        boolean restartRequired;
        this.prefs.putBoolean("fileColumn", this.fileColumn.isSelected());
        this.prefs.putBoolean("urlColumn", this.urlColumn.isSelected());
        this.prefs.putBoolean("preferUrlDoi", this.preferDoi.isSelected());
        this.prefs.putBoolean("arxivColumn", this.arxivColumn.isSelected());
        this.prefs.putBoolean("extraFileColumns", this.extraFileColumns.isSelected());
        if (this.extraFileColumns.isSelected() && !this.listOfFileColumns.isSelectionEmpty()) {
            int numberSelected = this.listOfFileColumns.getSelectedIndices().length;
            ArrayList<String> selections = new ArrayList<String>(numberSelected);
            for (int i = 0; i < numberSelected; ++i) {
                selections.add(this.listOfFileColumns.getModel().getElementAt(this.listOfFileColumns.getSelectedIndices()[i]));
            }
            this.prefs.putStringList("listOfFileColumns", selections);
        } else {
            this.prefs.putStringList("listOfFileColumns", new ArrayList<String>());
        }
        boolean newSpecialFieldsEnabled = this.specialFieldsEnabled.isSelected();
        boolean newRankingColumn = this.rankingColumn.isSelected();
        boolean newQualityColumn = this.qualityColumn.isSelected();
        boolean newPriorityColumn = this.priorityColumn.isSelected();
        boolean newRelevanceColumn = this.relevanceColumn.isSelected();
        boolean newPrintedColumn = this.printedColumn.isSelected();
        boolean newReadStatusColumn = this.readStatusColumn.isSelected();
        boolean newSyncKeyWords = this.syncKeywords.isSelected();
        boolean newWriteSpecialFields = this.writeSpecialFields.isSelected();
        boolean bl = restartRequired = this.oldSpecialFieldsEnabled != newSpecialFieldsEnabled || this.oldRankingColumn != newRankingColumn || this.oldQualityColumn != newQualityColumn || this.oldPriorityColumn != newPriorityColumn || this.oldRelevanceColumn != newRelevanceColumn || this.oldPrintedColumn != newPrintedColumn || this.oldReadStatusColumn != newReadStatusColumn || this.oldSyncKeyWords != newSyncKeyWords || this.oldWriteSpecialFields != newWriteSpecialFields;
        if (restartRequired) {
            JOptionPane.showMessageDialog(null, Localization.lang("You have changed settings for special fields.", new String[0]).concat(" ").concat(Localization.lang("You must restart JabRef for this to come into effect.", new String[0])), Localization.lang("Changed special field settings", new String[0]), 2);
        }
        if (restartRequired) {
            this.prefs.putBoolean("specialFieldsEnabled", newSpecialFieldsEnabled);
            this.prefs.putBoolean("showRankingColumn", newRankingColumn);
            this.prefs.putBoolean("showPriorityColumn", newPriorityColumn);
            this.prefs.putBoolean("showQualityColumn", newQualityColumn);
            this.prefs.putBoolean("showRelevanceColumn", newRelevanceColumn);
            this.prefs.putBoolean("showPrintedColumn", newPrintedColumn);
            this.prefs.putBoolean("showReadColumn", newReadStatusColumn);
            this.prefs.putBoolean("autoSyncSpecialFieldsToKeywords", newSyncKeyWords);
            this.prefs.putBoolean("serializeSpecialFields", newWriteSpecialFields);
        }
        if (this.colSetup.isEditing()) {
            int col = this.colSetup.getEditingColumn();
            int row = this.colSetup.getEditingRow();
            this.colSetup.getCellEditor(row, col).stopCellEditing();
        }
        if (this.tableChanged) {
            int i = 0;
            while (i < this.tableRows.size()) {
                if (this.tableRows.get(i).getName().isEmpty()) {
                    this.tableRows.remove(i);
                    continue;
                }
                ++i;
            }
            ArrayList<String> names = new ArrayList<String>(this.tableRows.size());
            ArrayList<String> widths = new ArrayList<String>(this.tableRows.size());
            ArrayList<Integer> nWidths = new ArrayList<Integer>(this.tableRows.size());
            this.prefs.putInt("numberColWidth", this.ncWidth);
            for (TableRow tr : this.tableRows) {
                names.add(tr.getName().toLowerCase(Locale.ROOT));
                nWidths.add(tr.getLength());
                widths.add(String.valueOf(tr.getLength()));
            }
            this.prefs.putStringList("columnNames", names);
            this.prefs.putStringList("columnWidths", widths);
        }
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry table columns", new String[0]);
    }

    class UpdateWidthsAction
    extends AbstractAction {
        public UpdateWidthsAction() {
            super(Localization.lang("Update to current column widths", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasePanel panel = TableColumnsTab.this.frame.getCurrentBasePanel();
            if (panel == null) {
                return;
            }
            TableColumnModel colMod = panel.getMainTable().getColumnModel();
            TableColumnsTab.this.colSetup.setValueAt(String.valueOf(colMod.getColumn(0).getWidth()), 0, 1);
            for (int i = 1; i < colMod.getColumnCount(); ++i) {
                block6: {
                    try {
                        String name = panel.getMainTable().getColumnName(i).toLowerCase(Locale.ROOT);
                        int width = colMod.getColumn(i).getWidth();
                        if (i <= TableColumnsTab.this.tableRows.size() && ((String)TableColumnsTab.this.colSetup.getValueAt(i, 0)).equalsIgnoreCase(name)) {
                            TableColumnsTab.this.colSetup.setValueAt(String.valueOf(width), i, 1);
                            break block6;
                        }
                        for (int j = 0; j < TableColumnsTab.this.colSetup.getRowCount(); ++j) {
                            if (j >= TableColumnsTab.this.tableRows.size() || !((String)TableColumnsTab.this.colSetup.getValueAt(j, 0)).equalsIgnoreCase(name)) continue;
                            TableColumnsTab.this.colSetup.setValueAt(String.valueOf(width), j, 1);
                            break;
                        }
                    }
                    catch (Throwable ex) {
                        LOGGER.warn("Problem with table columns", ex);
                    }
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
            }
        }
    }

    class UpdateOrderAction
    extends AbstractAction {
        public UpdateOrderAction() {
            super(Localization.lang("Update to current column order", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasePanel panel = TableColumnsTab.this.frame.getCurrentBasePanel();
            if (panel == null) {
                return;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 1; i < panel.getMainTable().getColumnCount(); ++i) {
                String name = panel.getMainTable().getColumnName(i);
                if (name == null || name.isEmpty()) continue;
                map.put(name.toLowerCase(Locale.ROOT), i);
            }
            Collections.sort(TableColumnsTab.this.tableRows, (o1, o2) -> {
                Integer n1 = (Integer)map.get(o1.getName());
                Integer n2 = (Integer)map.get(o2.getName());
                if (n1 == null || n2 == null) {
                    return 0;
                }
                return n1.compareTo(n2);
            });
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class MoveRowDownAction
    extends AbstractMoveRowAction {
        public MoveRowDownAction() {
            super("Down", IconTheme.JabRefIcon.DOWN.getIcon());
            this.putValue("ShortDescription", Localization.lang("Down", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = TableColumnsTab.this.colSetup.getSelectedRows();
            Arrays.sort(selected);
            int last = selected.length - 1;
            boolean[] newSelected = new boolean[TableColumnsTab.this.colSetup.getRowCount()];
            if (selected.length > 0 && selected[last] < TableColumnsTab.this.tableRows.size()) {
                int i;
                for (i = last; i >= 0; --i) {
                    this.swap(selected[i] - 1, selected[i]);
                    newSelected[selected[i] + 1] = true;
                }
                TableColumnsTab.this.colSetup.setRowSelectionInterval(0, TableColumnsTab.this.colSetup.getRowCount() - 1);
                for (i = 0; i < TableColumnsTab.this.colSetup.getRowCount(); ++i) {
                    if (newSelected[i]) continue;
                    TableColumnsTab.this.colSetup.removeRowSelectionInterval(i, i);
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                TableColumnsTab.this.tableChanged = true;
            }
        }
    }

    class MoveRowUpAction
    extends AbstractMoveRowAction {
        public MoveRowUpAction() {
            super("Up", IconTheme.JabRefIcon.UP.getIcon());
            this.putValue("ShortDescription", Localization.lang("Move up", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = TableColumnsTab.this.colSetup.getSelectedRows();
            Arrays.sort(selected);
            if (selected.length > 0 && selected[0] > 1) {
                boolean[] newSelected = new boolean[TableColumnsTab.this.colSetup.getRowCount()];
                for (int i : selected) {
                    this.swap(i - 1, i - 2);
                    newSelected[i - 1] = true;
                }
                TableColumnsTab.this.colSetup.setRowSelectionInterval(0, TableColumnsTab.this.colSetup.getRowCount() - 1);
                for (int i = 0; i < TableColumnsTab.this.colSetup.getRowCount(); ++i) {
                    if (newSelected[i]) continue;
                    TableColumnsTab.this.colSetup.removeRowSelectionInterval(i, i);
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                TableColumnsTab.this.tableChanged = true;
            }
        }
    }

    abstract class AbstractMoveRowAction
    extends AbstractAction {
        public AbstractMoveRowAction(String string, Icon image) {
            super(string, image);
        }

        public void swap(int i, int j) {
            if (i < 0 || i >= TableColumnsTab.this.tableRows.size()) {
                return;
            }
            if (j < 0 || j >= TableColumnsTab.this.tableRows.size()) {
                return;
            }
            TableRow tmp = (TableRow)TableColumnsTab.this.tableRows.get(i);
            TableColumnsTab.this.tableRows.set(i, (TableRow)TableColumnsTab.this.tableRows.get(j));
            TableColumnsTab.this.tableRows.set(j, tmp);
        }
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", IconTheme.JabRefIcon.ADD_NOBOX.getIcon());
            this.putValue("ShortDescription", Localization.lang("Insert rows", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = TableColumnsTab.this.colSetup.getSelectedRows();
            if (rows.length == 0) {
                TableColumnsTab.this.rowCount++;
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] + i - 1 >= TableColumnsTab.this.tableRows.size()) continue;
                TableColumnsTab.this.tableRows.add(Math.max(0, rows[i] + i - 1), new TableRow());
            }
            TableColumnsTab.this.rowCount += rows.length;
            if (rows.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", IconTheme.JabRefIcon.REMOVE_NOBOX.getIcon());
            this.putValue("ShortDescription", Localization.lang("Delete rows", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = TableColumnsTab.this.colSetup.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            int offs = 0;
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] > TableColumnsTab.this.tableRows.size() || rows[i] == 0) continue;
                TableColumnsTab.this.tableRows.remove(rows[i] - 1);
                ++offs;
            }
            TableColumnsTab.this.rowCount -= offs;
            if (rows.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    static class TableRow {
        private String name;
        private int length;

        public TableRow() {
            this.name = "";
            this.length = 100;
        }

        public TableRow(String name) {
            this.name = name;
            this.length = 100;
        }

        public TableRow(String name, int length) {
            this.name = name;
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }
}

