/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import javax.swing.undo.CompoundEdit;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class UndoableUnabbreviator {
    private final JournalAbbreviationRepository journalAbbreviationRepository;

    public UndoableUnabbreviator(JournalAbbreviationRepository journalAbbreviationRepository) {
        this.journalAbbreviationRepository = journalAbbreviationRepository;
    }

    public boolean unabbreviate(BibDatabase database, BibEntry entry, String fieldName, CompoundEdit ce) {
        String text;
        if (!entry.hasField(fieldName)) {
            return false;
        }
        String origText = text = entry.getField(fieldName).get();
        if (database != null) {
            text = database.resolveForStrings(text);
        }
        if (!this.journalAbbreviationRepository.isKnownName(text)) {
            return false;
        }
        if (!this.journalAbbreviationRepository.isAbbreviatedName(text)) {
            return false;
        }
        Abbreviation abbreviation = this.journalAbbreviationRepository.getAbbreviation(text).get();
        String newText = abbreviation.getName();
        entry.setField(fieldName, newText);
        ce.addEdit(new UndoableFieldChange(entry, fieldName, origText, newText));
        return true;
    }
}

