/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.importer.ZipFileChooser;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.fileformat.CustomImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCustomizationDialog
extends JabRefDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportCustomizationDialog.class);
    private static final int COL_0_WIDTH = 200;
    private static final int COL_1_WIDTH = 80;
    private static final int COL_2_WIDTH = 200;
    private static final int COL_3_WIDTH = 200;
    private final JTable customImporterTable;

    public ImportCustomizationDialog(JabRefFrame frame) {
        super((Frame)frame, Localization.lang("Manage custom imports", new String[0]), false, ImportCustomizationDialog.class);
        ImportTableModel tableModel = new ImportTableModel();
        this.customImporterTable = new JTable(tableModel);
        TableColumnModel cm = this.customImporterTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(80);
        cm.getColumn(2).setPreferredWidth(200);
        cm.getColumn(3).setPreferredWidth(200);
        JScrollPane sp2 = new JScrollPane(this.customImporterTable, 20, 31);
        this.customImporterTable.setSelectionMode(0);
        this.customImporterTable.setPreferredScrollableViewportSize(this.getSize());
        if (this.customImporterTable.getRowCount() > 0) {
            this.customImporterTable.setRowSelectionInterval(0, 0);
        }
        JButton addFromFolderButton = new JButton(Localization.lang("Add from folder", new String[0]));
        addFromFolderButton.addActionListener(e -> {
            FXDialogService ds = new FXDialogService();
            FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.CLASS, StandardFileType.JAR).withDefaultExtension(StandardFileType.JAR).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
            Optional selectedFile = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration));
            if (selectedFile.isPresent() && ((Path)selectedFile.get()).getParent() != null) {
                String chosenFileStr = ((Path)selectedFile.get()).toString();
                try {
                    String basePath = ((Path)selectedFile.get()).getParent().toString();
                    String className = ImportCustomizationDialog.pathToClass(basePath, new File(chosenFileStr));
                    CustomImporter importer = new CustomImporter(basePath, className);
                    this.addOrReplaceImporter(importer);
                    this.customImporterTable.revalidate();
                    this.customImporterTable.repaint();
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(frame, Localization.lang("Could not instantiate %0", chosenFileStr));
                }
                catch (NoClassDefFoundError exc) {
                    JOptionPane.showMessageDialog(frame, Localization.lang("Could not instantiate %0. Have you chosen the correct package path?", chosenFileStr));
                }
            }
        });
        addFromFolderButton.setToolTipText(Localization.lang("Add a (compiled) custom Importer class from a class path.", new String[0]) + "\n" + Localization.lang("The path need not be on the classpath of JabRef.", new String[0]));
        JButton addFromJarButton = new JButton(Localization.lang("Add from JAR", new String[0]));
        addFromJarButton.addActionListener(e -> {
            FXDialogService ds = new FXDialogService();
            FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.JAR, StandardFileType.ZIP).withDefaultExtension(StandardFileType.JAR).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
            Optional jarZipFile = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration));
            if (jarZipFile.isPresent()) {
                try (ZipFile zipFile = new ZipFile(((Path)jarZipFile.get()).toFile(), 1);){
                    ZipFileChooser zipFileChooser = new ZipFileChooser(this, zipFile);
                    zipFileChooser.setVisible(true);
                    this.customImporterTable.revalidate();
                    this.customImporterTable.repaint(10L);
                }
                catch (IOException exc) {
                    LOGGER.info("Could not open ZIP-archive.", exc);
                    JOptionPane.showMessageDialog(frame, Localization.lang("Could not open %0", ((Path)jarZipFile.get()).toString()) + "\n" + Localization.lang("Have you chosen the correct package path?", new String[0]));
                }
                catch (NoClassDefFoundError exc) {
                    LOGGER.info("Could not instantiate ZIP-archive reader.", exc);
                    JOptionPane.showMessageDialog(frame, Localization.lang("Could not instantiate %0", ((Path)jarZipFile.get()).toString()) + "\n" + Localization.lang("Have you chosen the correct package path?", new String[0]));
                }
            }
        });
        addFromJarButton.setToolTipText(Localization.lang("Add a (compiled) custom Importer class from a ZIP-archive.", new String[0]) + "\n" + Localization.lang("The ZIP-archive need not be on the classpath of JabRef.", new String[0]));
        JButton showDescButton = new JButton(Localization.lang("Show description", new String[0]));
        showDescButton.addActionListener(e -> {
            int row = this.customImporterTable.getSelectedRow();
            if (row == -1) {
                JOptionPane.showMessageDialog(frame, Localization.lang("Please select an importer.", new String[0]));
            } else {
                CustomImporter importer = ((ImportTableModel)this.customImporterTable.getModel()).getImporter(row);
                JOptionPane.showMessageDialog(frame, importer.getDescription());
            }
        });
        JButton removeButton = new JButton(Localization.lang("Remove", new String[0]));
        removeButton.addActionListener(e -> {
            int row = this.customImporterTable.getSelectedRow();
            if (row == -1) {
                JOptionPane.showMessageDialog(frame, Localization.lang("Please select an importer.", new String[0]));
            } else {
                this.customImporterTable.removeRowSelectionInterval(row, row);
                Globals.prefs.customImports.remove(((ImportTableModel)this.customImporterTable.getModel()).getImporter(row));
                Globals.IMPORT_FORMAT_READER.resetImportFormats(Globals.prefs.getImportFormatPreferences(), Globals.prefs.getXMPPreferences(), Globals.getFileUpdateMonitor());
                this.customImporterTable.revalidate();
                this.customImporterTable.repaint();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCustomizationDialog.this.dispose();
            }
        };
        JButton closeButton = new JButton(Localization.lang("Close", new String[0]));
        closeButton.addActionListener(closeAction);
        JButton helpButton = new HelpAction(HelpFile.CUSTOM_IMPORTS).getHelpButton();
        JPanel mainPanel = new JPanel();
        ActionMap am = mainPanel.getActionMap();
        InputMap im = mainPanel.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)sp2, "Center");
        JPanel buttons = new JPanel();
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)addFromFolderButton);
        bb.addButton((JComponent)addFromJarButton);
        bb.addButton((JComponent)showDescButton);
        bb.addButton((JComponent)removeButton);
        bb.addButton((JComponent)closeButton);
        bb.addUnrelatedGap();
        bb.addButton((JComponent)helpButton);
        bb.addGlue();
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.setSize(this.getSize());
        this.pack();
        this.setLocationRelativeTo(frame);
        this.customImporterTable.requestFocus();
    }

    @Override
    public Dimension getSize() {
        int width = 680;
        return new Dimension(width, width / 2);
    }

    private static String pathToClass(String basePath, File path) {
        String className = null;
        File actualPath = path;
        while (!actualPath.equals(new File(basePath))) {
            className = actualPath.getName() + (className == null ? "" : "." + className);
            actualPath = actualPath.getParentFile();
        }
        if (className != null) {
            int lastDot = className.lastIndexOf(46);
            if (lastDot < 0) {
                return className;
            }
            className = className.substring(0, lastDot);
        }
        return className;
    }

    public void addOrReplaceImporter(CustomImporter importer) {
        Globals.prefs.customImports.replaceImporter(importer);
        Globals.IMPORT_FORMAT_READER.resetImportFormats(Globals.prefs.getImportFormatPreferences(), Globals.prefs.getXMPPreferences(), Globals.getFileUpdateMonitor());
        ((ImportTableModel)this.customImporterTable.getModel()).fireTableDataChanged();
    }

    private class ImportTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{Localization.lang("Import name", new String[0]), Localization.lang("Command line id", new String[0]), Localization.lang("Importer class", new String[0]), Localization.lang("Contained in", new String[0])};

        private ImportTableModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            CustomImporter importer = this.getImporter(rowIndex);
            if (columnIndex == 0) {
                value = importer.getName();
            } else if (columnIndex == 1) {
                value = importer.getName();
            } else if (columnIndex == 2) {
                value = importer.getClassName();
            } else if (columnIndex == 3) {
                value = importer.getBasePath();
            }
            return value;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Globals.prefs.customImports.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public CustomImporter getImporter(int rowIndex) {
            CustomImporter[] importers = Globals.prefs.customImports.toArray(new CustomImporter[Globals.prefs.customImports.size()]);
            return importers[rowIndex];
        }
    }
}

