/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.SwingUtilities;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.groups.GroupDialog;
import org.jabref.gui.groups.GroupNodeViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.MetaData;

public class GroupTreeViewModel
extends AbstractViewModel {
    private final ObjectProperty<GroupNodeViewModel> rootGroup = new SimpleObjectProperty();
    private final ListProperty<GroupNodeViewModel> selectedGroups = new SimpleListProperty(FXCollections.observableArrayList());
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final ObjectProperty<Predicate<GroupNodeViewModel>> filterPredicate = new SimpleObjectProperty();
    private final StringProperty filterText = new SimpleStringProperty();
    private final Comparator<GroupTreeNode> compAlphabetIgnoreCase = (v1, v2) -> v1.getName().compareToIgnoreCase(v2.getName());
    private Optional<BibDatabaseContext> currentDatabase;

    public GroupTreeViewModel(StateManager stateManager, DialogService dialogService, TaskExecutor taskExecutor) {
        this.stateManager = Objects.requireNonNull(stateManager);
        this.dialogService = Objects.requireNonNull(dialogService);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        stateManager.activeDatabaseProperty().addListener((observable, oldValue, newValue) -> this.onActiveDatabaseChanged((Optional<BibDatabaseContext>)newValue));
        this.selectedGroups.addListener((observable, oldValue, newValue) -> this.onSelectedGroupChanged((ObservableList<GroupNodeViewModel>)newValue));
        this.filterPredicate.bind((ObservableValue)Bindings.createObjectBinding(() -> group -> group.isMatchedBy((String)this.filterText.get()), (Observable[])new Observable[]{this.filterText}));
        this.onActiveDatabaseChanged((Optional)stateManager.activeDatabaseProperty().getValue());
    }

    public ObjectProperty<GroupNodeViewModel> rootGroupProperty() {
        return this.rootGroup;
    }

    public ListProperty<GroupNodeViewModel> selectedGroupsProperty() {
        return this.selectedGroups;
    }

    public ObjectProperty<Predicate<GroupNodeViewModel>> filterPredicateProperty() {
        return this.filterPredicate;
    }

    public StringProperty filterTextProperty() {
        return this.filterText;
    }

    private void onSelectedGroupChanged(ObservableList<GroupNodeViewModel> newValue) {
        if (!this.currentDatabase.equals(this.stateManager.activeDatabaseProperty().getValue())) {
            return;
        }
        this.currentDatabase.ifPresent(database -> {
            if (newValue == null || newValue.isEmpty()) {
                this.stateManager.clearSelectedGroups((BibDatabaseContext)database);
            } else {
                this.stateManager.setSelectedGroups((BibDatabaseContext)database, newValue.stream().map(GroupNodeViewModel::getGroupNode).collect(Collectors.toList()));
            }
        });
    }

    public void addNewGroupToRoot() {
        this.addNewSubgroup((GroupNodeViewModel)this.rootGroup.get());
    }

    private void onActiveDatabaseChanged(Optional<BibDatabaseContext> newDatabase) {
        if (newDatabase.isPresent()) {
            GroupNodeViewModel newRoot = newDatabase.map(BibDatabaseContext::getMetaData).flatMap(MetaData::getGroups).map(root -> new GroupNodeViewModel((BibDatabaseContext)newDatabase.get(), this.stateManager, this.taskExecutor, (GroupTreeNode)root)).orElse(GroupNodeViewModel.getAllEntriesGroup(newDatabase.get(), this.stateManager, this.taskExecutor));
            this.rootGroup.setValue((Object)newRoot);
            this.selectedGroups.setAll((Collection)this.stateManager.getSelectedGroup(newDatabase.get()).stream().map(selectedGroup -> new GroupNodeViewModel((BibDatabaseContext)newDatabase.get(), this.stateManager, this.taskExecutor, (GroupTreeNode)selectedGroup)).collect(Collectors.toList()));
        }
        this.currentDatabase = newDatabase;
    }

    public void addNewSubgroup(GroupNodeViewModel parent) {
        SwingUtilities.invokeLater(() -> {
            Optional<AbstractGroup> newGroup = this.dialogService.showCustomDialogAndWait(new GroupDialog());
            newGroup.ifPresent(group -> {
                GroupTreeNode newGroupNode = parent.addSubgroup((AbstractGroup)group);
                this.dialogService.notify(Localization.lang("Added group \"%0\".", group.getName()));
                this.writeGroupChangesToMetaData();
            });
        });
    }

    private void writeGroupChangesToMetaData() {
        this.currentDatabase.get().getMetaData().setGroups(((GroupNodeViewModel)this.rootGroup.get()).getGroupNode());
    }

    public void editGroup(GroupNodeViewModel oldGroup) {
        SwingUtilities.invokeLater(() -> {
            Optional<AbstractGroup> newGroup = this.dialogService.showCustomDialogAndWait(new GroupDialog(oldGroup.getGroupNode().getGroup()));
            newGroup.ifPresent(group -> Platform.runLater(() -> {
                boolean keepPreviousAssignments = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Change of Grouping Method", new String[0]), Localization.lang("Assign the original group's entries to this group?", new String[0]));
                boolean removePreviousAssignents = oldGroup.getGroupNode().getGroup() instanceof ExplicitGroup && group instanceof ExplicitGroup;
                List<FieldChange> addChange = oldGroup.getGroupNode().setGroup((AbstractGroup)group, keepPreviousAssignments, removePreviousAssignents, this.stateManager.getEntriesInCurrentDatabase());
                this.dialogService.notify(Localization.lang("Modified group \"%0\".", group.getName()));
                this.writeGroupChangesToMetaData();
            }));
        });
    }

    public void removeSubgroups(GroupNodeViewModel group) {
        boolean confirmation = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove subgroups", new String[0]), Localization.lang("Remove all subgroups of \"%0\"?", group.getDisplayName()));
        if (confirmation) {
            group.getGroupNode().removeAllChildren();
            this.dialogService.notify(Localization.lang("Removed all subgroups of group \"%0\".", group.getDisplayName()));
            this.writeGroupChangesToMetaData();
        }
    }

    public void removeGroupKeepSubgroups(GroupNodeViewModel group) {
        boolean confirmation = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove group", new String[0]), Localization.lang("Remove group \"%0\"?", group.getDisplayName()));
        if (confirmation) {
            GroupTreeNode groupNode = group.getGroupNode();
            groupNode.getParent().ifPresent(parent -> groupNode.moveAllChildrenTo(parent, parent.getIndexOfChild(groupNode).get()));
            groupNode.removeFromParent();
            this.dialogService.notify(Localization.lang("Removed group \"%0\".", group.getDisplayName()));
            this.writeGroupChangesToMetaData();
        }
    }

    public void removeGroupAndSubgroups(GroupNodeViewModel group) {
        boolean confirmed = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove group and subgroups", new String[0]), Localization.lang("Remove group \"%0\" and its subgroups?", group.getDisplayName()), Localization.lang("Remove", new String[0]));
        if (confirmed) {
            this.removeGroupsAndSubGroupsFromEntries(group);
            group.getGroupNode().removeFromParent();
            this.dialogService.notify(Localization.lang("Removed group \"%0\" and its subgroups.", group.getDisplayName()));
            this.writeGroupChangesToMetaData();
        }
    }

    void removeGroupsAndSubGroupsFromEntries(GroupNodeViewModel group) {
        for (GroupNodeViewModel child : group.getChildren()) {
            this.removeGroupsAndSubGroupsFromEntries(child);
        }
        if (group.getGroupNode().getGroup() instanceof ExplicitGroup) {
            List<BibEntry> entriesInGroup = group.getGroupNode().getEntriesInGroup(this.currentDatabase.get().getEntries());
            group.getGroupNode().removeEntriesFromGroup(entriesInGroup);
        }
    }

    public void addSelectedEntries(GroupNodeViewModel group) {
        List<FieldChange> addChange = group.getGroupNode().addEntriesToGroup((List<BibEntry>)this.stateManager.getSelectedEntries());
    }

    public void removeSelectedEntries(GroupNodeViewModel group) {
        List<FieldChange> removeChange = group.getGroupNode().removeEntriesFromGroup((List<BibEntry>)this.stateManager.getSelectedEntries());
    }

    public void sortAlphabeticallyRecursive(GroupNodeViewModel group) {
        group.getGroupNode().sortChildren(this.compAlphabetIgnoreCase, true);
    }
}

