/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.List;
import javafx.util.StringConverter;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.OptionEditorViewModel;
import org.jabref.logic.integrity.FieldCheckers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapBasedEditorViewModel<T>
extends OptionEditorViewModel<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBasedEditorViewModel.class);

    public MapBasedEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
    }

    protected abstract BiMap<String, T> getItemMap();

    @Override
    public StringConverter<T> getStringConverter() {
        return new StringConverter<T>(){

            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                return MapBasedEditorViewModel.this.getItemMap().inverse().getOrDefault(object, object.toString());
            }

            public T fromString(String string) {
                if (string == null) {
                    return null;
                }
                return MapBasedEditorViewModel.this.getItemMap().getOrDefault(string, MapBasedEditorViewModel.this.getValueFromString(string));
            }
        };
    }

    protected T getValueFromString(String string) {
        try {
            return (T)string;
        }
        catch (ClassCastException ex) {
            LOGGER.error(String.format("Could not cast string to type %1$s. Try overriding the method in a subclass and provide a conversion from string to the concrete type %1$s", string.getClass()), ex);
            return null;
        }
    }

    @Override
    public List<T> getItems() {
        return new ArrayList(this.getItemMap().values());
    }
}

