/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import org.jabref.gui.BasePanel;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableInsertEntry;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.IdGenerator;

class EntryAddChangeViewModel
extends ChangeViewModel {
    private final BibEntry diskEntry;
    private final JFXPanel container;

    public EntryAddChangeViewModel(BibEntry diskEntry) {
        super(Localization.lang("Added entry", new String[0]));
        this.diskEntry = diskEntry;
        PreviewPanel previewPanel = new PreviewPanel(null, null);
        previewPanel.setEntry(diskEntry);
        this.container = CustomJFXPanel.wrap(new Scene((Parent)previewPanel));
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        this.diskEntry.setId(IdGenerator.next());
        panel.getDatabase().insertEntry(this.diskEntry);
        secondary.insertEntry(this.diskEntry);
        undoEdit.addEdit(new UndoableInsertEntry(panel.getDatabase(), this.diskEntry, panel));
        return true;
    }

    @Override
    public JComponent description() {
        return this.container;
    }
}

