/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind;

import java.util.function.Supplier;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.fxmisc.easybind.Subscription;

class ConditionalSubscription
implements Subscription {
    private final Supplier<? extends Subscription> bindFn;
    private final ObservableValue<Boolean> condition;
    private final ChangeListener<Boolean> conditionListener = this::conditionChanged;
    private Subscription subscription = null;

    public ConditionalSubscription(ObservableValue<Boolean> condition, Supplier<? extends Subscription> bindFn) {
        this.condition = condition;
        this.bindFn = bindFn;
        condition.addListener(this.conditionListener);
        if (((Boolean)condition.getValue()).booleanValue()) {
            this.subscription = bindFn.get();
        }
    }

    private void conditionChanged(ObservableValue<? extends Boolean> cond, Boolean wasTrue, Boolean isTrue) {
        if (isTrue.booleanValue()) {
            assert (this.subscription == null);
            this.subscription = this.bindFn.get();
        } else {
            assert (this.subscription != null);
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    @Override
    public void unsubscribe() {
        this.condition.removeListener(this.conditionListener);
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

