/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.encoding.Encoding;

public abstract class CFFEncoding
extends Encoding {
    private final Map<Integer, String> codeToName = new HashMap<Integer, String>(250);

    CFFEncoding() {
    }

    @Override
    public String getName(int code) {
        String name = this.codeToName.get(code);
        if (name == null) {
            return ".notdef";
        }
        return name;
    }

    public void add(int code, int sid, String name) {
        this.codeToName.put(code, name);
        this.addCharacterEncoding(code, name);
    }

    protected void add(int code, int sid) {
        String name = CFFStandardString.getName(sid);
        this.codeToName.put(code, name);
        this.addCharacterEncoding(code, name);
    }
}

