/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import de.undercouch.citeproc.script.JREScriptRunner;
import de.undercouch.citeproc.script.ScriptRunner;
import de.undercouch.citeproc.script.V8ScriptRunner;
import java.util.concurrent.atomic.AtomicReference;

public class ScriptRunnerFactory {
    private static AtomicReference<RunnerType> runner = new AtomicReference<RunnerType>(RunnerType.AUTO);

    public static RunnerType setRunnerType(RunnerType type) {
        return runner.getAndSet(type);
    }

    private static ScriptRunner createJreRunner() {
        return new JREScriptRunner();
    }

    private static ScriptRunner createV8Runner() {
        return new V8ScriptRunner();
    }

    public static ScriptRunner createRunner() {
        RunnerType t = runner.get();
        switch (t) {
            case AUTO: {
                if (ScriptRunnerFactory.supportsV8()) {
                    return ScriptRunnerFactory.createV8Runner();
                }
                return ScriptRunnerFactory.createJreRunner();
            }
            case JRE: {
                return ScriptRunnerFactory.createJreRunner();
            }
            case V8: {
                return ScriptRunnerFactory.createV8Runner();
            }
        }
        throw new RuntimeException("Invalid runner type");
    }

    private static boolean supportsV8() {
        try {
            Class.forName("com.eclipsesource.v8.V8");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static enum RunnerType {
        AUTO,
        JRE,
        V8;

    }
}

