/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.processor;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BuiltInProcessor(value="SyntheticSourceFilter")
public final class SyntheticSourceFilter
implements TelemetryProcessor {
    private final Set<String> notNeededSources = new HashSet<String>();

    @Override
    public boolean process(Telemetry telemetry) {
        if (telemetry == null) {
            return true;
        }
        if (this.notNeededSources.isEmpty()) {
            return LocalStringsUtils.isNullOrEmpty(telemetry.getContext().getOperation().getSyntheticSource());
        }
        return !this.notNeededSources.contains(telemetry.getContext().getOperation().getSyntheticSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotNeededSources(String notNeededSources) throws Throwable {
        try {
            List<String> notNeededAsList = Arrays.asList(notNeededSources.split(","));
            for (String notNeeded : notNeededAsList) {
                String ready = notNeeded.trim();
                if (LocalStringsUtils.isNullOrEmpty(ready)) continue;
                this.notNeededSources.add(ready);
            }
            InternalLogger.INSTANCE.trace(String.format("SyntheticSourceFilter: set NotNeededSources: %s", notNeededSources), new Object[0]);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error(String.format("SyntheticSourceFilter: failed to parse NotNeededSources: %s, exception : %s", notNeededSources, ExceptionUtils.getStackTrace(t)), new Object[0]);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            finally {
                throw t;
            }
        }
    }
}

