/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.processor;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class MetricTelemetryFilter
implements TelemetryProcessor {
    private HashSet<String> notNeeded = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotNeeded(String allNotNeeded) throws Throwable {
        try {
            List<String> notNeededAsList = Arrays.asList(allNotNeeded.split(","));
            for (String notNeeded : notNeededAsList) {
                String ready = notNeeded.trim();
                if (LocalStringsUtils.isNullOrEmpty(ready)) continue;
                this.notNeeded.add(ready);
            }
            InternalLogger.INSTANCE.trace(String.format("MetricTelemetryFilter: set NotNeeded: %s", this.notNeeded), new Object[0]);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("MetricTelemetryFilter: failed to parse NotNeededNames: %s, Exception : %s", allNotNeeded, ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            finally {
                throw t;
            }
        }
    }

    @Override
    public boolean process(Telemetry telemetry) {
        MetricTelemetry mt;
        if (telemetry == null) {
            return true;
        }
        return !(telemetry instanceof MetricTelemetry) || !this.notNeeded.contains((mt = (MetricTelemetry)telemetry).getName());
    }
}

