/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.googlecommon.graph;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.annotations.Beta;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Function;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Functions;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.collect.ImmutableMap;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.collect.Maps;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.AbstractGraphBuilder;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.ConfigurableValueGraph;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.DirectedGraphConnections;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.ForwardingGraph;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.Graph;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.GraphBuilder;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.GraphConnections;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.GraphConstants;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.UndirectedGraphConnections;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.graph.ValueGraph;

@Beta
public abstract class ImmutableGraph<N>
extends ForwardingGraph<N> {
    ImmutableGraph() {
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ValueBackedImpl<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size());
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node), Maps.asMap(graph.successors(node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    static class ValueBackedImpl<N, V>
    extends ImmutableGraph<N> {
        protected final ValueGraph<N, V> backingValueGraph;

        ValueBackedImpl(AbstractGraphBuilder<? super N> builder, ImmutableMap<N, GraphConnections<N, V>> nodeConnections, long edgeCount) {
            this.backingValueGraph = new ConfigurableValueGraph<N, V>(builder, nodeConnections, edgeCount);
        }

        @Override
        protected Graph<N> delegate() {
            return this.backingValueGraph;
        }
    }
}

