/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ConvertedBytes
extends SimpleProcProvider {
    public static final BinDecoder BINARY_DECODER = new BinDecoder();
    public static final BinEncoder BINARY_ENCODER = new BinEncoder();

    public ConvertedBytes() {
        super(null, null, (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "");
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return byte[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                byte[] bytes = (byte[])val;
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return byte[].class;
        }

        public byte[] decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            Integer maxLength = (Integer)context.getSetting("field.varying.length.max");
            byte[] bytes = maxLength != null ? new byte[Math.min(maxLength, length)] : new byte[length];
            buffer.readBytes(bytes);
            buffer.skipBytes(length - bytes.length);
            return bytes;
        }
    }
}

