/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.data.ACLItem;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGDriver;
import com.impossibl.postgres.jdbc.PGPreparedStatement;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.SQLTextEscapeFunctions;
import com.impossibl.postgres.jdbc.SQLTypeMetaData;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.ParsedDataRow;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.DomainType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.Joiner;
import com.impossibl.postgres.utils.guava.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PseudoColumnUsage;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class PGDatabaseMetaData
implements DatabaseMetaData {
    private static final String EXTRA_KEYWORDS = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    PGConnectionImpl connection;
    int maxNameLength;
    int maxIndexKeys;
    private static final Map<String, String> tableTypeClauses = new HashMap<String, String>();

    PGDatabaseMetaData(PGConnectionImpl connection) {
        this.connection = connection;
    }

    private int execForInteger(String query) throws SQLException {
        String res = this.connection.executeForString(query, false);
        if (res == null) {
            throw Exceptions.SERVER_VERSION_NOT_SUPPORTED;
        }
        try {
            return Integer.parseInt(res);
        }
        catch (NumberFormatException e) {
            throw Exceptions.SERVER_VERSION_NOT_SUPPORTED;
        }
    }

    private PGResultSet execForResultSet(String sql, Object ... params) throws SQLException {
        return this.execForResultSet(sql, Arrays.asList(params));
    }

    private PGResultSet execForResultSet(String sql, List<Object> params) throws SQLException {
        PGPreparedStatement ps = this.connection.prepareStatement(sql);
        ps.closeOnCompletion();
        for (int c = 0; c < params.size(); ++c) {
            ps.setObject(c + 1, params.get(c));
        }
        return ps.executeQuery();
    }

    private PGResultSet createResultSet(List<ResultField> resultFields, List<Object[]> results) throws SQLException {
        ArrayList<DataRow> dataRows = new ArrayList<DataRow>();
        for (Object[] row : results) {
            dataRows.add(new ParsedDataRow(row));
        }
        PGStatement stmt = this.connection.createStatement();
        stmt.closeOnCompletion();
        return stmt.createResultSet(resultFields, dataRows, false);
    }

    private int getMaxNameLength() throws SQLException {
        if (this.maxNameLength == 0) {
            this.maxNameLength = this.execForInteger("SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace=n.oid AND t.typname='name' AND n.nspname='pg_catalog'");
        }
        return this.maxNameLength;
    }

    protected int getMaxIndexKeys() throws SQLException {
        if (this.maxIndexKeys == 0) {
            this.maxIndexKeys = this.execForInteger("SELECT setting FROM pg_catalog.pg_settings WHERE name='max_index_keys'");
        }
        return this.maxIndexKeys;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        Object val = this.connection.getSetting("databaseUrl");
        if (val == null) {
            throw new SQLException("invalid connection");
        }
        return val.toString();
    }

    @Override
    public String getUserName() throws SQLException {
        Object val = this.connection.getSetting("user");
        if (val == null) {
            throw new SQLException("invalid connection");
        }
        return val.toString();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "PostgreSQL";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getServerVersion().toString();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "PostgreSQL JDBC - NG";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return PGDriver.VERSION.toString();
    }

    @Override
    public int getDriverMajorVersion() {
        return PGDriver.VERSION.getMajor();
    }

    @Override
    public int getDriverMinorVersion() {
        return PGDriver.VERSION.getMinor();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return EXTRA_KEYWORDS;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return Joiner.on(',').join(SQLTextEscapeFunctions.ALL_NUMERIC);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return Joiner.on(',').join(SQLTextEscapeFunctions.ALL_STRING);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return Joiner.on(',').join(SQLTextEscapeFunctions.ALL_SYSTEM);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return Joiner.on(',').join(SQLTextEscapeFunctions.ALL_DATE_TIME);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL,  d.description AS REMARKS, 2 AS PROCEDURE_TYPE, p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_namespace n, pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid)  LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc')  LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog')  WHERE p.pronamespace=n.oid");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        if (!Strings.isNullOrEmpty(procedureNamePattern)) {
            sql.append(" AND p.proname LIKE ?");
            params.add(procedureNamePattern);
        }
        sql.append(" ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, SPECIFIC_NAME");
        return this.execForResultSet(sql.toString(), params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        Registry reg = this.connection.getRegistry();
        ResultField[] resultFields = new ResultField[20];
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        resultFields[0] = new ResultField("PROCEDURE_CAT", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[1] = new ResultField("PROCEDURE_SCHEM", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[2] = new ResultField("PROCEDURE_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[3] = new ResultField("COLUMN_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[4] = new ResultField("COLUMN_TYPE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[5] = new ResultField("DATA_TYPE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[6] = new ResultField("TYPE_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[7] = new ResultField("PRECISION", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[8] = new ResultField("LENGTH", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[9] = new ResultField("SCALE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[10] = new ResultField("RADIX", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[11] = new ResultField("NULLABLE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[12] = new ResultField("REMARKS", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[13] = new ResultField("COLUMN_DEF", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[14] = new ResultField("SQL_DATA_TYPE", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[15] = new ResultField("SQL_DATETIME_SUB", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[16] = new ResultField("CHAR_OCTECT_LENGTH", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[17] = new ResultField("ORDINAL_POSITION", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[18] = new ResultField("IS_NULLABLE", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[19] = new ResultField("SPECIFIC_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid, p.proargnames,  p.proargmodes, p.proallargtypes, p.oid  FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        if (!Strings.isNullOrEmpty(procedureNamePattern)) {
            sql.append(" AND p.proname LIKE ?");
            params.add(procedureNamePattern);
        }
        sql.append(" ORDER BY n.nspname, p.proname, p.oid::text ");
        try (PGResultSet rs = this.execForResultSet(sql.toString(), params);){
            while (rs.next()) {
                PGStatement stmt;
                block44: {
                    int numArgs;
                    String schema = rs.getString("nspname");
                    String procedureName = rs.getString("proname");
                    String specificName = rs.getString("proname") + "_" + rs.getString("oid");
                    Type returnType = reg.loadType(rs.getInt("prorettype"));
                    String returnTypeType = rs.getString("typtype");
                    int returnTypeRelId = rs.getInt("typrelid");
                    Integer[] argTypeIds = rs.getObject("proargtypes", Integer[].class);
                    String[] argNames = rs.getObject("proargnames", String[].class);
                    String[] argModes = rs.getObject("proargmodes", String[].class);
                    Integer[] allArgTypeIds = rs.getObject("proallargtypes", Integer[].class);
                    int n = numArgs = allArgTypeIds != null ? allArgTypeIds.length : argTypeIds.length;
                    if (returnTypeType.equals("b") || returnTypeType.equals("d") || returnTypeType.equals("p") && argModes == null) {
                        Object[] row = new Object[resultFields.length];
                        row[0] = null;
                        row[1] = schema;
                        row[2] = procedureName;
                        row[3] = "returnValue";
                        row[4] = 5;
                        row[5] = SQLTypeMetaData.getSQLType(returnType);
                        row[6] = SQLTypeMetaData.getTypeName(returnType, null, 0);
                        row[7] = null;
                        row[8] = null;
                        row[9] = null;
                        row[10] = null;
                        row[11] = 2;
                        row[12] = null;
                        row[17] = 0;
                        row[18] = "";
                        row[19] = specificName;
                        results.add(row);
                    }
                    for (int i = 0; i < numArgs; ++i) {
                        Object[] row = new Object[resultFields.length];
                        row[0] = null;
                        row[1] = schema;
                        row[2] = procedureName;
                        row[3] = argNames != null ? argNames[i] : "$" + (i + 1);
                        int columnMode = 1;
                        if (argModes != null) {
                            if (argModes[i].equals("o")) {
                                columnMode = 4;
                            } else if (argModes[i].equals("b")) {
                                columnMode = 2;
                            }
                        }
                        row[4] = columnMode;
                        Type argType = allArgTypeIds != null ? reg.loadType(allArgTypeIds[i]) : reg.loadType(argTypeIds[i]);
                        row[5] = SQLTypeMetaData.getSQLType(argType);
                        row[6] = argType.getJavaType(argType.getPreferredFormat(), this.connection.getTypeMap()).getName();
                        row[7] = null;
                        row[8] = null;
                        row[9] = null;
                        row[10] = null;
                        row[11] = 2;
                        row[12] = null;
                        row[17] = i + 1;
                        row[18] = "";
                        row[19] = specificName;
                        results.add(row);
                    }
                    if (!returnTypeType.equals("c") && (!returnTypeType.equals("p") || argModes == null || returnTypeRelId == 0)) continue;
                    String columnsql = "SELECT a.attname,a.atttypid FROM pg_catalog.pg_attribute a WHERE a.attrelid = " + returnTypeRelId + " AND a.attnum > 0 ORDER BY a.attnum ";
                    stmt = this.connection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet columnrs = stmt.executeQuery(columnsql);){
                            while (columnrs.next()) {
                                Type columnType = reg.loadType(columnrs.getInt("atttypid"));
                                Object[] row = new Object[resultFields.length];
                                row[0] = null;
                                row[1] = schema;
                                row[2] = procedureName;
                                row[3] = columnrs.getString("attname");
                                row[4] = 3;
                                row[5] = SQLTypeMetaData.getSQLType(columnType);
                                row[6] = columnType.getJavaType(columnType.getPreferredFormat(), this.connection.getTypeMap()).getName();
                                row[7] = null;
                                row[8] = null;
                                row[9] = null;
                                row[10] = null;
                                row[11] = 2;
                                row[12] = null;
                                row[17] = 0;
                                row[18] = "";
                                row[19] = specificName;
                                results.add(row);
                            }
                        }
                        if (stmt == null) continue;
                        if (throwable == null) break block44;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (stmt == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            stmt.close();
                            throw throwable3;
                        }
                    }
                    try {
                        stmt.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                stmt.close();
            }
            return this.createResultSet(Arrays.asList(resultFields), results);
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname ~ '^pg_' OR n.nspname = 'information_schema'  WHEN true THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TABLE'   WHEN 'v' THEN 'SYSTEM VIEW'   WHEN 'i' THEN 'SYSTEM INDEX'   ELSE NULL   END  WHEN n.nspname = 'pg_toast' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TOAST TABLE'   WHEN 'i' THEN 'SYSTEM TOAST INDEX'   ELSE NULL   END  ELSE CASE c.relkind   WHEN 'r' THEN 'TEMPORARY TABLE'   WHEN 'i' THEN 'TEMPORARY INDEX'   WHEN 'S' THEN 'TEMPORARY SEQUENCE'   WHEN 'v' THEN 'TEMPORARY VIEW'   ELSE NULL   END  END  WHEN false THEN CASE c.relkind  WHEN 'r' THEN 'TABLE'  WHEN 'i' THEN 'INDEX'  WHEN 'S' THEN 'SEQUENCE'  WHEN 'v' THEN 'VIEW'  WHEN 'c' THEN 'TYPE'  WHEN 'f' THEN 'FOREIGN TABLE'  ELSE NULL  END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c  LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0)  LEFT JOIN pg_catalog.pg_class dc ON (d.classoid=dc.oid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='pg_catalog')  WHERE c.relnamespace = n.oid ");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        if (!Strings.isNullOrEmpty(tableNamePattern)) {
            sql.append(" AND c.relname LIKE ?");
            params.add(tableNamePattern);
        }
        if (types != null) {
            sql.append(" AND (false ");
            for (int i = 0; i < types.length; ++i) {
                String clause = tableTypeClauses.get(types[i]);
                if (clause == null) continue;
                sql.append(" OR ( " + clause + " ) ");
            }
            sql.append(") ");
        }
        sql.append(" ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ");
        return this.execForResultSet(sql.toString(), params);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT nspname AS TABLE_SCHEM,  NULL AS TABLE_CATALOG FROM pg_catalog.pg_namespace  WHERE  ( nspname <> 'pg_toast' AND (nspname !~ '^pg_temp_\\d+' OR nspname = (pg_catalog.current_schemas(true))[1]) AND (nspname !~ '^pg_toast_temp_' OR nspname = replace((pg_catalog.current_schemas(true))[1], 'pg_temp_', 'pg_toast_temp_')) )");
        if (schemaPattern != null) {
            sql.append(" AND nspname LIKE ?");
            params.add(schemaPattern);
        }
        sql.append(" ORDER BY TABLE_SCHEM");
        return this.execForResultSet(sql.toString(), params);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ResultField[] resultFields = new ResultField[]{new ResultField("TABLE_CAT", 0, 0, this.connection.getRegistry().loadType("text"), 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        results.add(new Object[]{this.connection.getCatalog()});
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ResultField[] resultFields = new ResultField[]{new ResultField("TABLE_TYPE", 0, 0, this.connection.getRegistry().loadType("text"), 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (String tableType : tableTypeClauses.keySet()) {
            results.add(new Object[]{tableType});
        }
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Registry registry = this.connection.getRegistry();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT * FROM (   SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,a.atttypmod,a.attlen,a.attrelid,     row_number() OVER (PARTITION BY a.attrelid ORDER BY a.attnum) AS attnum, pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS adsrc,dsc.description,t.typbasetype,t.typtype    FROM pg_catalog.pg_namespace n    JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)    JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)    JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid)    LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)    LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)    LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')    LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')    WHERE a.attnum > 0 AND NOT a.attisdropped ");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        if (!Strings.isNullOrEmpty(tableNamePattern)) {
            sql.append(" AND c.relname LIKE ?");
            params.add(tableNamePattern);
        }
        sql.append(") c");
        if (!Strings.isNullOrEmpty(columnNamePattern)) {
            sql.append(" WHERE attname LIKE ?");
            params.add(columnNamePattern);
        }
        sql.append(" ORDER BY nspname,c.relname,attnum ");
        ArrayList<ColumnData> columnsData = new ArrayList<ColumnData>();
        try (PGResultSet rs = this.execForResultSet(sql.toString(), params);){
            while (rs.next()) {
                ColumnData columnData = new ColumnData();
                columnData.tableSchemaName = rs.getString("nspname");
                columnData.tableName = rs.getString("relname");
                columnData.relationType = registry.loadRelationType(rs.getInt("attrelid"));
                columnData.relationAttrNum = rs.getInt("attnum");
                columnData.columnName = rs.getString("attname");
                columnData.type = registry.loadType(rs.getInt("atttypid"));
                columnData.typeModifier = rs.getInt("atttypmod");
                columnData.typeLength = rs.getInt("attlen");
                columnData.nullable = !rs.getBoolean("attnotnull");
                columnData.defaultValue = rs.getString("adsrc");
                columnData.description = rs.getString("description");
                columnData.baseType = registry.loadType(rs.getInt("typbasetype"));
                columnsData.add(columnData);
            }
        }
        ResultField[] resultFields = new ResultField[]{new ResultField("TABLE_CAT", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TABLE_SCHEM", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TABLE_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("COLUMN_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("DATA_TYPE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("TYPE_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("COLUMN_SIZE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("BUFFER_LENGTH", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("DECIMAL_DIGITS", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("NUM_PREC_RADIX", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("NULLABLE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("REMARKS", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("COLUMN_DEF", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SQL_DATA_TYPE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("SQL_DATETIME_SUB", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("CHAR_OCTET_LENGTH", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("ORDINAL_POSITION", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("IS_NULLABLE", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SCOPE_CATALOG", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SCOPE_SCHEMA", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SCOPE_TABLE", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SOURCE_DATA_TYPE", 0, 0, registry.loadType("int2"), 0, 0, ResultField.Format.Binary), new ResultField("IS_AUTOINCREMENT", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("IS_GENERATEDCOLUMN", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (int c = 0; c < columnsData.size(); ++c) {
            String nullable;
            ColumnData columnData = (ColumnData)columnsData.get(c);
            Object[] row = new Object[resultFields.length];
            row[0] = null;
            row[1] = columnData.tableSchemaName;
            row[2] = columnData.tableName;
            row[3] = columnData.columnName;
            row[4] = SQLTypeMetaData.getSQLType(columnData.type);
            row[5] = SQLTypeMetaData.getTypeName(columnData.type, columnData.relationType, columnData.relationAttrNum);
            int size = SQLTypeMetaData.getPrecision(columnData.type, columnData.typeLength, columnData.typeModifier);
            if (size == 0) {
                size = SQLTypeMetaData.getDisplaySize(columnData.type, columnData.typeLength, columnData.typeModifier);
            }
            row[6] = size;
            row[7] = null;
            row[8] = SQLTypeMetaData.getScale(columnData.type, columnData.typeLength, columnData.typeModifier);
            row[9] = SQLTypeMetaData.getPrecisionRadix(columnData.type);
            row[10] = SQLTypeMetaData.isNullable(columnData.type, columnData.relationType, columnData.relationAttrNum);
            row[11] = columnData.description;
            row[12] = columnData.defaultValue;
            row[13] = null;
            row[14] = null;
            row[15] = columnData.typeLength;
            row[16] = columnData.relationAttrNum;
            switch ((Integer)row[10]) {
                case 0: {
                    nullable = "NO";
                    break;
                }
                case 1: {
                    nullable = "YES";
                    break;
                }
                default: {
                    nullable = "";
                }
            }
            row[17] = nullable;
            row[18] = null;
            row[19] = null;
            row[20] = null;
            row[21] = columnData.baseType != null ? Integer.valueOf(SQLTypeMetaData.getSQLType(columnData.baseType)) : null;
            row[22] = SQLTypeMetaData.isAutoIncrement(columnData.type, columnData.relationType, columnData.relationAttrNum) ? "YES" : "NO";
            row[23] = columnData.relationType != null ? "YES" : "NO";
            results.add(row);
        }
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            table = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        Registry reg = this.connection.getRegistry();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT n.nspname,c.relname,r.rolname,c.relacl,a.attacl,a.attname FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_roles r, pg_catalog.pg_attribute a WHERE  c.relnamespace = n.oid AND c.relowner = r.oid AND c.oid = a.attrelid AND c.relkind = 'r' AND a.attnum > 0 AND NOT a.attisdropped ");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname = ?");
            params.add(schemaPattern);
        }
        sql.append(" AND c.relname = ?");
        params.add(table);
        if (!Strings.isNullOrEmpty(columnNamePattern)) {
            sql.append(" AND a.attname LIKE ?");
            params.add(columnNamePattern);
        }
        sql.append(" ORDER BY attname");
        ResultField[] fields = new ResultField[]{new ResultField("TABLE_CAT", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TABLE_SCHEM", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TABLE_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("COLUMN_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("GRANTOR", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("GRANTEE", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("PRIVILEGE", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("IS_GRANTABLE", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        try (PGResultSet rs = this.execForResultSet(sql.toString(), params);){
            while (rs.next()) {
                String schemaName = rs.getString("nspname");
                String tableName = rs.getString("relname");
                String column = rs.getString("attname");
                String owner = rs.getString("rolname");
                HashMap<String, Map<String, List<String[]>>> privileges = new HashMap<String, Map<String, List<String[]>>>();
                PGDatabaseMetaData.mapACLPrivileges(owner, rs.getObject("relacl", ACLItem[].class), privileges);
                PGDatabaseMetaData.mapACLPrivileges(owner, rs.getObject("attacl", ACLItem[].class), privileges);
                Object[] privNames = new String[privileges.size()];
                Iterator e = privileges.keySet().iterator();
                int i = 0;
                while (e.hasNext()) {
                    privNames[i++] = (String)e.next();
                }
                Arrays.sort(privNames);
                for (Object privName : privNames) {
                    Map grantees = (Map)privileges.get(privName);
                    String[] granteeUsers = new String[grantees.size()];
                    Iterator g2 = grantees.keySet().iterator();
                    int k = 0;
                    while (g2.hasNext()) {
                        granteeUsers[k++] = (String)g2.next();
                    }
                    for (int j = 0; j < grantees.size(); ++j) {
                        List grantors = (List)grantees.get(granteeUsers[j]);
                        String grantee = granteeUsers[j];
                        for (int l = 0; l < grantors.size(); ++l) {
                            String[] grants = (String[])grantors.get(l);
                            String grantor = Strings.isNullOrEmpty(grants[0]) ? owner : grants[0];
                            String grantable = owner.equals(grantee) ? "YES" : grants[1];
                            Object[] row = new Object[]{null, schemaName, tableName, column, grantor, grantee, privName, grantable};
                            results.add(row);
                        }
                    }
                }
            }
        }
        return this.createResultSet(Arrays.asList(fields), results);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Registry reg = this.connection.getRegistry();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT n.nspname,c.relname,r.rolname,c.relacl FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_roles r WHERE c.relnamespace = n.oid AND c.relowner = r.oid AND c.relkind = 'r' ");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        if (!Strings.isNullOrEmpty(tableNamePattern)) {
            sql.append(" AND c.relname LIKE ?");
            params.add(tableNamePattern);
        }
        sql.append(" ORDER BY nspname, relname ");
        ResultField[] fields = new ResultField[]{new ResultField("TABLE_CAT", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TABLE_SCHEM", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TABLE_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("GRANTOR", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("GRANTEE", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("PRIVILEGE", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("IS_GRANTABLE", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        try (PGResultSet rs = this.execForResultSet(sql.toString(), params);){
            while (rs.next()) {
                String schema = rs.getString("nspname");
                String table = rs.getString("relname");
                String owner = rs.getString("rolname");
                HashMap<String, Map<String, List<String[]>>> privileges = new HashMap<String, Map<String, List<String[]>>>();
                PGDatabaseMetaData.mapACLPrivileges(owner, rs.getObject("relacl", ACLItem[].class), privileges);
                Object[] privNames = new String[privileges.size()];
                Iterator e = privileges.keySet().iterator();
                int i = 0;
                while (e.hasNext()) {
                    privNames[i++] = (String)e.next();
                }
                Arrays.sort(privNames);
                for (Object privName : privNames) {
                    Map grantees = (Map)privileges.get(privName);
                    String[] granteeUsers = new String[grantees.size()];
                    Iterator g2 = grantees.keySet().iterator();
                    int k = 0;
                    while (g2.hasNext()) {
                        granteeUsers[k++] = (String)g2.next();
                    }
                    for (int j = 0; j < granteeUsers.length; ++j) {
                        List grantors = (List)grantees.get(granteeUsers[j]);
                        String grantee = granteeUsers[j];
                        for (int l = 0; l < grantors.size(); ++l) {
                            String[] grants = (String[])grantors.get(l);
                            String grantor = Strings.isNullOrEmpty(grants[0]) ? owner : grants[0];
                            String grantable = owner.equals(grantee) ? "YES" : grants[1];
                            Object[] row = new Object[]{null, schema, table, grantor, grantee, privName, grantable};
                            results.add(row);
                        }
                    }
                }
            }
        }
        return this.createResultSet(Arrays.asList(fields), results);
    }

    private static void mapACLPrivileges(String owner, ACLItem[] aclItems, Map<String, Map<String, List<String[]>>> privileges) {
        if (aclItems == null) {
            ACLItem fullPrivs = new ACLItem(owner, "arwdDxt", owner);
            aclItems = new ACLItem[]{fullPrivs};
        }
        for (ACLItem aclItem : aclItems) {
            if (aclItem == null) continue;
            for (int i = 0; i < aclItem.getPrivileges().length(); ++i) {
                List<String[]> permissionByGrantor;
                String sqlpriv;
                char c = aclItem.getPrivileges().charAt(i);
                if (c == '*') continue;
                String grantable = i < aclItem.getPrivileges().length() - 1 && aclItem.getPrivileges().charAt(i + 1) == '*' ? "YES" : "NO";
                switch (c) {
                    case 'a': {
                        sqlpriv = "INSERT";
                        break;
                    }
                    case 'r': {
                        sqlpriv = "SELECT";
                        break;
                    }
                    case 'w': {
                        sqlpriv = "UPDATE";
                        break;
                    }
                    case 'd': {
                        sqlpriv = "DELETE";
                        break;
                    }
                    case 'D': {
                        sqlpriv = "TRUNCATE";
                        break;
                    }
                    case 'R': {
                        sqlpriv = "RULE";
                        break;
                    }
                    case 'x': {
                        sqlpriv = "REFERENCES";
                        break;
                    }
                    case 't': {
                        sqlpriv = "TRIGGER";
                        break;
                    }
                    case 'X': {
                        sqlpriv = "EXECUTE";
                        break;
                    }
                    case 'U': {
                        sqlpriv = "USAGE";
                        break;
                    }
                    case 'C': {
                        sqlpriv = "CREATE";
                        break;
                    }
                    case 'T': {
                        sqlpriv = "CREATE TEMP";
                        break;
                    }
                    default: {
                        sqlpriv = "UNKNOWN";
                    }
                }
                Map<String, List<String[]>> usersWithPermission = privileges.get(sqlpriv);
                if (usersWithPermission == null) {
                    usersWithPermission = new HashMap<String, List<String[]>>();
                    privileges.put(sqlpriv, usersWithPermission);
                }
                if ((permissionByGrantor = usersWithPermission.get(aclItem.getUser())) == null) {
                    permissionByGrantor = new ArrayList<String[]>();
                    usersWithPermission.put(aclItem.getUser(), permissionByGrantor);
                }
                permissionByGrantor.add(new String[]{aclItem.getGrantor(), grantable});
            }
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schemaPattern, String table, int scope, boolean nullable) throws SQLException {
        Registry reg = this.connection.getRegistry();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT a.attname, a.atttypid, attlen, atttypmod FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid)   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              information_schema._pg_expandarray(i.indkey) AS keys         FROM pg_catalog.pg_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid) ");
        if (schemaPattern != null) {
            sql.append(" WHERE n.nspname = ?");
            params.add(schemaPattern);
        }
        ResultField[] resultFields = new ResultField[8];
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        resultFields[0] = new ResultField("SCOPE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[1] = new ResultField("COLUMN_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[2] = new ResultField("DATA_TYPE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[3] = new ResultField("TYPE_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[4] = new ResultField("COLUMN_SIZE", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[5] = new ResultField("BUFFER_LENGTH", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[6] = new ResultField("DECIMAL_DIGITS", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[7] = new ResultField("PSEUDO_COLUMN", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        try (PGResultSet rs = this.execForResultSet(sql.toString(), params);){
            while (rs.next()) {
                Object[] row = new Object[8];
                Type type = reg.loadType(rs.getInt("atttypid"));
                int typeLen = rs.getInt("attlen");
                int typeMod = rs.getInt("atttypmod");
                int decimalDigits = SQLTypeMetaData.getScale(type, typeLen, typeMod);
                int columnSize = SQLTypeMetaData.getPrecision(type, typeLen, typeMod);
                if (columnSize == 0) {
                    columnSize = SQLTypeMetaData.getDisplaySize(type, typeLen, typeMod);
                }
                row[0] = scope;
                row[1] = rs.getString("attname");
                row[2] = SQLTypeMetaData.getSQLType(type);
                row[3] = SQLTypeMetaData.getTypeName(type, null, 0);
                row[4] = columnSize;
                row[5] = null;
                row[6] = decimalDigits;
                row[7] = 1;
                results.add(row);
            }
        }
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schemaPattern, String table) throws SQLException {
        Registry reg = this.connection.getRegistry();
        ResultField[] resultFields = new ResultField[8];
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        resultFields[0] = new ResultField("SCOPE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[1] = new ResultField("COLUMN_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[2] = new ResultField("DATA_TYPE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[3] = new ResultField("TYPE_NAME", 0, 0, reg.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[4] = new ResultField("COLUMN_SIZE", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[5] = new ResultField("BUFFER_LENGTH", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[6] = new ResultField("DECIMAL_DIGITS", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[7] = new ResultField("PSEUDO_COLUMN", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary);
        Object[] row = new Object[8];
        Type type = reg.loadType("tid");
        row[0] = null;
        row[1] = "ctid";
        row[2] = SQLTypeMetaData.getSQLType(type);
        row[3] = SQLTypeMetaData.getTypeName(type, null, 0);
        row[4] = null;
        row[5] = null;
        row[6] = null;
        row[7] = 2;
        results.add(row);
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schemaPattern, String table) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME,   (i.keys).n AS KEY_SEQ, ci.relname AS PK_NAME FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid)   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              information_schema._pg_expandarray(i.indkey) AS keys         FROM pg_catalog.pg_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid)   JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid) ");
        if (schemaPattern != null) {
            sql.append(" WHERE n.nspname = ?");
            params.add(schemaPattern);
        }
        sql.append(" AND ct.relname = ?");
        params.add(table);
        sql.append(" AND i.indisprimary ORDER BY table_name, pk_name, key_seq");
        return this.execForResultSet(sql.toString(), params);
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'd' THEN 4 WHEN 'n' THEN 2 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n),  pg_catalog.pg_depend dep, pg_catalog.pg_class pkic  WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid  AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid  AND con.contype = 'f' AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND pkic.relkind = 'i' AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid ");
        if (!Strings.isNullOrEmpty(primarySchema)) {
            sql.append(" AND pkn.nspname = ?");
            params.add(primarySchema);
        }
        if (!Strings.isNullOrEmpty(foreignSchema)) {
            sql.append(" AND fkn.nspname = ?");
            params.add(foreignSchema);
        }
        if (!Strings.isNullOrEmpty(primaryTable)) {
            sql.append(" AND pkc.relname = ?");
            params.add(primaryTable);
        }
        if (!Strings.isNullOrEmpty(foreignTable)) {
            sql.append(" AND fkc.relname = ?");
            params.add(foreignTable);
        }
        if (primaryTable != null) {
            sql.append(" ORDER BY fkn.nspname,fkc.relname,pos.n");
        } else {
            sql.append(" ORDER BY pkn.nspname,pkc.relname,pos.n");
        }
        return this.execForResultSet(sql.toString(), params);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schemaPattern, String table) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, catalog, schemaPattern, table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schemaPattern, String table) throws SQLException {
        return this.getImportedExportedKeys(catalog, schemaPattern, table, null, null, null);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedExportedKeys(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Registry registry = this.connection.getRegistry();
        ResultField[] resultFields = new ResultField[18];
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        resultFields[0] = new ResultField("TYPE_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[1] = new ResultField("DATA_TYPE", 0, 0, registry.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[2] = new ResultField("PRECISION", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[3] = new ResultField("LITERAL_PREFIX", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[4] = new ResultField("LITERAL_SUFFIX", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[5] = new ResultField("CREATE_PARAMS", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[6] = new ResultField("NULLABLE", 0, 0, registry.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[7] = new ResultField("CASE_SENSITIVE", 0, 0, registry.loadType("bool"), 0, 0, ResultField.Format.Binary);
        resultFields[8] = new ResultField("SEARCHABLE", 0, 0, registry.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[9] = new ResultField("UNSIGNED_ATTRIBUTE", 0, 0, registry.loadType("bool"), 0, 0, ResultField.Format.Binary);
        resultFields[10] = new ResultField("FIXED_PREC_SCALE", 0, 0, registry.loadType("bool"), 0, 0, ResultField.Format.Binary);
        resultFields[11] = new ResultField("AUTO_INCREMENT", 0, 0, registry.loadType("bool"), 0, 0, ResultField.Format.Binary);
        resultFields[12] = new ResultField("LOCAL_TYPE_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[13] = new ResultField("MINIMUM_SCALE", 0, 0, registry.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[14] = new ResultField("MAXIMUM_SCALE", 0, 0, registry.loadType("int2"), 0, 0, ResultField.Format.Binary);
        resultFields[15] = new ResultField("SQL_DATA_TYPE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[16] = new ResultField("SQL_DATETIME_SUB", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[17] = new ResultField("NUM_PREC_RADIX", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        String sql = "SELECT t.typname,t.oid FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid)  WHERE n.nspname != 'pg_toast'";
        try (PGResultSet rs = this.execForResultSet(sql, new Object[0]);){
            while (rs.next()) {
                Object[] row = new Object[18];
                int typeOid = rs.getInt(2);
                Type type = registry.loadType(typeOid);
                row[0] = SQLTypeMetaData.getTypeName(type, null, 0);
                row[1] = SQLTypeMetaData.getSQLType(type);
                row[2] = SQLTypeMetaData.getMaxPrecision(type);
                if (SQLTypeMetaData.requiresQuoting(type)) {
                    row[3] = "'";
                    row[4] = "'";
                }
                row[6] = SQLTypeMetaData.isNullable(type, null, 0);
                row[7] = SQLTypeMetaData.isCaseSensitive(type);
                row[8] = true;
                row[9] = !SQLTypeMetaData.isSigned(type);
                row[10] = SQLTypeMetaData.isCurrency(type);
                row[11] = SQLTypeMetaData.isAutoIncrement(type, null, 0);
                row[13] = SQLTypeMetaData.getMinScale(type);
                row[14] = SQLTypeMetaData.getMaxScale(type);
                row[15] = null;
                row[16] = null;
                row[17] = SQLTypeMetaData.getPrecisionRadix(type);
                results.add(row);
            }
        }
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schemaPattern, String table, boolean unique, boolean approximate) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE,   NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME,   CASE i.indisclustered     WHEN true THEN 1    ELSE CASE am.amname       WHEN 'hash' THEN 2      ELSE 3    END   END AS TYPE,   (i.keys).n AS ORDINAL_POSITION,   pg_catalog.pg_get_indexdef(ci.oid, (i.keys).n, false) AS COLUMN_NAME, " + (this.connection.isServerMinimumVersion(9, 6) ? "  CASE am.amname     WHEN 'btree' THEN CASE i.indoption[(i.keys).n - 1] & 1       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, " : "  CASE am.amcanorder     WHEN true THEN CASE i.indoption[(i.keys).n - 1] & 1       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, ") + "  ci.reltuples AS CARDINALITY,   ci.relpages AS PAGES,   pg_catalog.pg_get_expr(i.indpred, i.indrelid) AS FILTER_CONDITION FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indoption,           i.indisunique, i.indisclustered, i.indpred,           i.indexprs,           information_schema._pg_expandarray(i.indkey) AS keys         FROM pg_catalog.pg_index i) i     ON (ct.oid = i.indrelid)   JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid)   JOIN pg_catalog.pg_am am ON (ci.relam = am.oid) WHERE true ");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname = ?");
            params.add(schemaPattern);
        }
        sql.append(" AND ct.relname = ?");
        params.add(table);
        if (unique) {
            sql.append(" AND i.indisunique ");
        }
        sql.append(" ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ");
        return this.execForResultSet(sql.toString(), params);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Registry reg = this.connection.getRegistry();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT  NULL AS TYPE_CAT, n.nspname AS TYPE_SCHEM, t.typname AS TYPE_NAME, NULL AS CLASS_NAME,  CASE WHEN t.typtype='c' THEN 2002 ELSE 2001 END AS DATA_TYPE,  pg_catalog.obj_description(t.oid, 'pg_type')  AS REMARKS,  typbasetype as BASE_TYPE_ID FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace = n.oid and n.nspname != 'pg_catalog' and n.nspname != 'pg_toast'");
        if (types != null) {
            sql.append(" AND (false ");
            block4: for (int i = 0; i < types.length; ++i) {
                switch (types[i]) {
                    case 2002: {
                        sql.append(" or t.typtype = 'c'");
                        continue block4;
                    }
                    case 2001: {
                        sql.append(" or t.typtype = 'd'");
                        continue block4;
                    }
                }
            }
            sql.append(" ) ");
        } else {
            sql.append(" and t.typtype IN ('c','d') ");
        }
        if (typeNamePattern != null) {
            int firstQualifier = typeNamePattern.indexOf(46);
            int secondQualifier = typeNamePattern.lastIndexOf(46);
            if (firstQualifier != -1) {
                schemaPattern = firstQualifier != secondQualifier ? typeNamePattern.substring(firstQualifier + 1, secondQualifier) : typeNamePattern.substring(0, firstQualifier);
                typeNamePattern = typeNamePattern.substring(secondQualifier + 1);
            }
            sql.append(" AND t.typname LIKE ?");
            params.add(typeNamePattern);
        }
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        sql.append(" ORDER BY data_type, type_schem, type_name");
        PGResultSet rs = this.execForResultSet(sql.toString(), params);
        ResultField[] fields = new ResultField[]{rs.getResultFields().get(0), rs.getResultFields().get(1), rs.getResultFields().get(2), rs.getResultFields().get(3), rs.getResultFields().get(4), rs.getResultFields().get(5), new ResultField("BASE_TYPE", 0, 0, reg.loadType("int2"), 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        while (rs.next()) {
            Type type;
            Object[] row = new Object[]{rs.get(1), rs.get(2), rs.get(3), rs.get(4), rs.get(5), rs.get(6), (type = reg.loadType(rs.getInt(7))) != null ? Integer.valueOf(SQLTypeMetaData.getSQLType(type)) : null};
            results.add(row);
        }
        rs.close();
        return this.createResultSet(Arrays.asList(fields), results);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        Registry registry = this.connection.getRegistry();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT * FROM (   SELECT n.nspname,t.typname,a.attname,a.atttypid,a.attrelid,a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,a.atttypmod,a.attlen,     row_number() OVER (PARTITION BY a.attrelid ORDER BY a.attnum) AS attnum, dsc.description   FROM pg_catalog.pg_namespace n    JOIN pg_catalog.pg_type t ON (t.typnamespace=n.oid)    JOIN pg_catalog.pg_attribute a ON (a.attrelid=t.typrelid)    LEFT JOIN pg_catalog.pg_description dsc ON (t.typrelid=dsc.objoid AND a.attnum = dsc.objsubid)    LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')    LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')    WHERE a.attnum > 0 AND NOT a.attisdropped AND t.typtype='c'");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        if (!Strings.isNullOrEmpty(typeNamePattern)) {
            sql.append(" AND t.typname LIKE ?");
            params.add(typeNamePattern);
        }
        sql.append(") c");
        if (!Strings.isNullOrEmpty(attributeNamePattern)) {
            sql.append(" WHERE attname LIKE ?");
            params.add(attributeNamePattern);
        }
        sql.append(" ORDER BY nspname,c.typname,attnum ");
        ArrayList<AttributeData> attrsData = new ArrayList<AttributeData>();
        try (PGResultSet rs = this.execForResultSet(sql.toString(), params);){
            while (rs.next()) {
                AttributeData attrData = new AttributeData();
                attrData.typeSchemaName = rs.getString("nspname");
                attrData.typeName = rs.getString("typname");
                attrData.relationType = registry.loadRelationType(rs.getInt("attrelid"));
                attrData.relationAttrNum = rs.getInt("attnum");
                attrData.attributeName = rs.getString("attname");
                attrData.type = registry.loadType(rs.getInt("atttypid"));
                attrData.typeModifier = rs.getInt("atttypmod");
                attrData.typeLength = rs.getInt("attlen");
                attrData.nullable = !rs.getBoolean("attnotnull");
                attrData.description = rs.getString("description");
                attrsData.add(attrData);
            }
        }
        ResultField[] resultFields = new ResultField[]{new ResultField("TYPE_CAT", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TYPE_SCHEM", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("TYPE_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("ATTR_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("DATA_TYPE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("ATTR_TYPE_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("ATTR_SIZE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("DECIMAL_DIGITS", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("NUM_PREC_RADIX", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("NULLABLE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("REMARKS", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("ATTR_DEF", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SQL_DATA_TYPE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("SQL_DATETIME_SUB", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("CHAR_OCTET_LENGTH", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("ORDINAL_POSITION", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("IS_NULLABLE", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SCOPE_CATALOG", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SCOPE_SCHEMA", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SCOPE_TABLE", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary), new ResultField("SOURCE_DATA_TYPE", 0, 0, registry.loadType("int2"), 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (int c = 0; c < attrsData.size(); ++c) {
            String nullable;
            AttributeData attrData = (AttributeData)attrsData.get(c);
            Object[] row = new Object[resultFields.length];
            row[0] = null;
            row[1] = attrData.typeSchemaName;
            row[2] = attrData.typeName;
            row[3] = attrData.attributeName;
            row[4] = SQLTypeMetaData.getSQLType(attrData.type);
            row[5] = SQLTypeMetaData.getTypeName(attrData.type, attrData.relationType, attrData.relationAttrNum);
            int size = SQLTypeMetaData.getPrecision(attrData.type, attrData.typeLength, attrData.typeModifier);
            if (size == 0) {
                size = SQLTypeMetaData.getDisplaySize(attrData.type, attrData.typeLength, attrData.typeModifier);
            }
            row[6] = size;
            row[7] = SQLTypeMetaData.getScale(attrData.type, attrData.typeLength, attrData.typeModifier);
            row[8] = SQLTypeMetaData.getPrecisionRadix(attrData.type);
            row[9] = SQLTypeMetaData.isNullable(attrData.type, attrData.relationType, attrData.relationAttrNum);
            row[10] = attrData.description;
            row[11] = null;
            row[12] = null;
            row[13] = null;
            row[14] = attrData.typeLength;
            row[15] = attrData.relationAttrNum;
            switch ((Integer)row[9]) {
                case 0: {
                    nullable = "NO";
                    break;
                }
                case 1: {
                    nullable = "YES";
                    break;
                }
                default: {
                    nullable = "";
                }
            }
            row[16] = nullable;
            row[17] = null;
            row[18] = null;
            row[19] = null;
            row[20] = attrData.type instanceof DomainType ? Integer.valueOf(SQLTypeMetaData.getSQLType(attrData.type.unwrap())) : null;
            results.add(row);
        }
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getServerVersion().getMajor();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getServerVersion().getMinor();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_SESSION;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Registry registry = this.connection.getRegistry();
        ResultField[] resultFields = new ResultField[18];
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        resultFields[0] = new ResultField("NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[1] = new ResultField("MAX_LEN", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[2] = new ResultField("DEFAULT_VALUE", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[3] = new ResultField("DESCRIPTION", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        Object[] row = new Object[]{"ApplicationName", -1, "pgjdbc app", "Name of application using the connection"};
        results.add(row);
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Registry registry = this.connection.getRegistry();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("SELECT * FROM (   SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,a.atttypmod,a.attlen,a.attrelid,     row_number() OVER (PARTITION BY a.attrelid ORDER BY a.attnum) AS attnum, pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS adsrc,dsc.description,t.typbasetype,t.typtype    FROM pg_catalog.pg_namespace n    JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)    JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)    JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid)    LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)    LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)    LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')    LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')    WHERE a.attnum < 1 AND NOT a.attisdropped ");
        if (schemaPattern != null) {
            sql.append(" AND n.nspname LIKE ?");
            params.add(schemaPattern);
        }
        if (!Strings.isNullOrEmpty(tableNamePattern)) {
            sql.append(" AND c.relname LIKE ?");
            params.add(tableNamePattern);
        }
        sql.append(") c");
        if (!Strings.isNullOrEmpty(columnNamePattern)) {
            sql.append(" WHERE attname LIKE ?");
            params.add(columnNamePattern);
        }
        sql.append(" ORDER BY nspname,c.relname,attnum ");
        ArrayList<ColumnData> columnsData = new ArrayList<ColumnData>();
        try (PGResultSet rs = this.execForResultSet(sql.toString(), params);){
            while (rs.next()) {
                ColumnData columnData = new ColumnData();
                columnData.tableSchemaName = rs.getString("nspname");
                columnData.tableName = rs.getString("relname");
                columnData.relationType = registry.loadRelationType(rs.getInt("attrelid"));
                columnData.relationAttrNum = rs.getInt("attnum");
                columnData.columnName = rs.getString("attname");
                columnData.type = registry.loadType(rs.getInt("atttypid"));
                columnData.typeModifier = rs.getInt("atttypmod");
                columnData.typeLength = rs.getInt("attlen");
                columnData.nullable = !rs.getBoolean("attnotnull");
                columnData.defaultValue = rs.getString("adsrc");
                columnData.description = rs.getString("description");
                columnData.baseType = registry.loadType(rs.getInt("typbasetype"));
                columnsData.add(columnData);
            }
        }
        ResultField[] resultFields = new ResultField[24];
        resultFields[0] = new ResultField("TABLE_CAT", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[1] = new ResultField("TABLE_SCHEM", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[2] = new ResultField("TABLE_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[3] = new ResultField("COLUMN_NAME", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[4] = new ResultField("DATA_TYPE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[5] = new ResultField("COLUMN_SIZE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[6] = new ResultField("DECIMAL_DIGITS", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[7] = new ResultField("NUM_PREC_RADIX", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[8] = new ResultField("COLUMN_USAGE", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[9] = new ResultField("REMARKS", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        resultFields[10] = new ResultField("CHAR_OCTET_LENGTH", 0, 0, registry.loadType("int4"), 0, 0, ResultField.Format.Binary);
        resultFields[11] = new ResultField("IS_NULLABLE", 0, 0, registry.loadType("text"), 0, 0, ResultField.Format.Binary);
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (int c = 0; c < columnsData.size(); ++c) {
            String nullable;
            ColumnData columnData = (ColumnData)columnsData.get(c);
            Object[] row = new Object[resultFields.length];
            row[0] = null;
            row[1] = columnData.tableSchemaName;
            row[2] = columnData.tableName;
            row[3] = columnData.columnName;
            row[4] = SQLTypeMetaData.getSQLType(columnData.type);
            int size = SQLTypeMetaData.getPrecision(columnData.type, columnData.typeLength, columnData.typeModifier);
            if (size == 0) {
                size = SQLTypeMetaData.getDisplaySize(columnData.type, columnData.typeLength, columnData.typeModifier);
            }
            row[5] = size;
            row[6] = SQLTypeMetaData.getScale(columnData.type, columnData.typeLength, columnData.typeModifier);
            row[7] = SQLTypeMetaData.getPrecisionRadix(columnData.type);
            row[8] = PseudoColumnUsage.NO_USAGE_RESTRICTIONS.name();
            row[9] = columnData.description;
            row[10] = columnData.typeLength;
            int isNullable = SQLTypeMetaData.isNullable(columnData.type, columnData.relationType, columnData.relationAttrNum);
            switch (isNullable) {
                case 0: {
                    nullable = "NO";
                    break;
                }
                case 1: {
                    nullable = "YES";
                    break;
                }
                default: {
                    nullable = "";
                }
            }
            row[11] = nullable;
            results.add(row);
        }
        return this.createResultSet(Arrays.asList(resultFields), results);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    static {
        tableTypeClauses.put("TABLE", "c.relkind = 'r' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        tableTypeClauses.put("VIEW", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        tableTypeClauses.put("INDEX", "c.relkind = 'i' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        tableTypeClauses.put("SEQUENCE", "c.relkind = 'S'");
        tableTypeClauses.put("TYPE", "c.relkind = 'c' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        tableTypeClauses.put("SYSTEM TABLE", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        tableTypeClauses.put("SYSTEM TOAST TABLE", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        tableTypeClauses.put("SYSTEM TOAST INDEX", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        tableTypeClauses.put("SYSTEM VIEW", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        tableTypeClauses.put("SYSTEM INDEX", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        tableTypeClauses.put("TEMPORARY TABLE", "c.relkind = 'r' AND n.nspname ~ '^pg_temp_' ");
        tableTypeClauses.put("TEMPORARY INDEX", "c.relkind = 'i' AND n.nspname ~ '^pg_temp_' ");
        tableTypeClauses.put("TEMPORARY VIEW", "c.relkind = 'v' AND n.nspname ~ '^pg_temp_' ");
        tableTypeClauses.put("TEMPORARY SEQUENCE", "c.relkind = 'S' AND n.nspname ~ '^pg_temp_' ");
        tableTypeClauses.put("FOREIGN TABLE", "c.relkind = 'f'");
    }

    static class AttributeData {
        String typeSchemaName;
        String typeName;
        CompositeType relationType;
        int relationAttrNum;
        String attributeName;
        Type type;
        int typeModifier;
        int typeLength;
        Boolean nullable;
        String description;

        AttributeData() {
        }
    }

    static class ColumnData {
        String tableSchemaName;
        String tableName;
        CompositeType relationType;
        int relationAttrNum;
        String columnName;
        Type type;
        int typeModifier;
        int typeLength;
        Boolean nullable;
        String defaultValue;
        String description;
        Type baseType;

        ColumnData() {
        }
    }
}

