/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/paypal
 *
 * This file is part of PlantUML.
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PlantUML distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 *
 * Original Author:  Arnaud Roques
 *
 */
package net.sourceforge.plantuml;

import static net.sourceforge.plantuml.klimt.shape.GraphicStrings.createBlackOnWhite;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.geom.GraphicPosition;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;

public abstract class PlainStringsDiagram extends PlainDiagram {
	// ::remove file when __HAXE__

	protected BufferedImage image = null;
	protected GraphicPosition imagePosition = null;

	protected final List<String> strings = new ArrayList<>();

	public PlainStringsDiagram(UmlSource source, PreprocessingArtifact preprocessing) {
		super(source, preprocessing);
	}

	@Override
	public UDrawable getRootDrawable(FileFormatOption fileFormatOption) {
		return createBlackOnWhite(strings, image, imagePosition);
	}
}
