package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySmsStatistics invokes the dm.QuerySmsStatistics API synchronously
// api document: https://help.aliyun.com/api/dm/querysmsstatistics.html
func (client *Client) QuerySmsStatistics(request *QuerySmsStatisticsRequest) (response *QuerySmsStatisticsResponse, err error) {
	response = CreateQuerySmsStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySmsStatisticsWithChan invokes the dm.QuerySmsStatistics API asynchronously
// api document: https://help.aliyun.com/api/dm/querysmsstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySmsStatisticsWithChan(request *QuerySmsStatisticsRequest) (<-chan *QuerySmsStatisticsResponse, <-chan error) {
	responseChan := make(chan *QuerySmsStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySmsStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySmsStatisticsWithCallback invokes the dm.QuerySmsStatistics API asynchronously
// api document: https://help.aliyun.com/api/dm/querysmsstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySmsStatisticsWithCallback(request *QuerySmsStatisticsRequest, callback func(response *QuerySmsStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySmsStatisticsResponse
		var err error
		defer close(result)
		response, err = client.QuerySmsStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySmsStatisticsRequest is the request struct for api QuerySmsStatistics
type QuerySmsStatisticsRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	EndTime              string           `position:"Query" name:"EndTime"`
	FromType             requests.Integer `position:"Query" name:"FromType"`
}

// QuerySmsStatisticsResponse is the response struct for api QuerySmsStatistics
type QuerySmsStatisticsResponse struct {
	*responses.BaseResponse
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	TotalCount int                      `json:"TotalCount" xml:"TotalCount"`
	Data       DataInQuerySmsStatistics `json:"data" xml:"data"`
}

// CreateQuerySmsStatisticsRequest creates a request to invoke QuerySmsStatistics API
func CreateQuerySmsStatisticsRequest() (request *QuerySmsStatisticsRequest) {
	request = &QuerySmsStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "QuerySmsStatistics", "", "")
	return
}

// CreateQuerySmsStatisticsResponse creates a response to parse from QuerySmsStatistics response
func CreateQuerySmsStatisticsResponse() (response *QuerySmsStatisticsResponse) {
	response = &QuerySmsStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
