package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHostInfo invokes the cms.ModifyHostInfo API synchronously
func (client *Client) ModifyHostInfo(request *ModifyHostInfoRequest) (response *ModifyHostInfoResponse, err error) {
	response = CreateModifyHostInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHostInfoWithChan invokes the cms.ModifyHostInfo API asynchronously
func (client *Client) ModifyHostInfoWithChan(request *ModifyHostInfoRequest) (<-chan *ModifyHostInfoResponse, <-chan error) {
	responseChan := make(chan *ModifyHostInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHostInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHostInfoWithCallback invokes the cms.ModifyHostInfo API asynchronously
func (client *Client) ModifyHostInfoWithCallback(request *ModifyHostInfoRequest, callback func(response *ModifyHostInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHostInfoResponse
		var err error
		defer close(result)
		response, err = client.ModifyHostInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHostInfoRequest is the request struct for api ModifyHostInfo
type ModifyHostInfoRequest struct {
	*requests.RpcRequest
	HostName   string `position:"Query" name:"HostName"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ModifyHostInfoResponse is the response struct for api ModifyHostInfo
type ModifyHostInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyHostInfoRequest creates a request to invoke ModifyHostInfo API
func CreateModifyHostInfoRequest() (request *ModifyHostInfoRequest) {
	request = &ModifyHostInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "ModifyHostInfo", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyHostInfoResponse creates a response to parse from ModifyHostInfo response
func CreateModifyHostInfoResponse() (response *ModifyHostInfoResponse) {
	response = &ModifyHostInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
