package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/2017-10-01-preview/sql"

// BackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type BackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupShortTermRetentionPoliciesClient) (BackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupShortTermRetentionPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupShortTermRetentionPoliciesCreateOrUpdateFuture.Result.
func (future *BackupShortTermRetentionPoliciesCreateOrUpdateFuture) result(client BackupShortTermRetentionPoliciesClient) (bstrp BackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bstrp.Response.Response, err = future.GetResult(sender); err == nil && bstrp.Response.Response.StatusCode != http.StatusNoContent {
		bstrp, err = client.CreateOrUpdateResponder(bstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", bstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type BackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupShortTermRetentionPoliciesClient) (BackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupShortTermRetentionPoliciesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupShortTermRetentionPoliciesUpdateFuture.Result.
func (future *BackupShortTermRetentionPoliciesUpdateFuture) result(client BackupShortTermRetentionPoliciesClient) (bstrp BackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.BackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bstrp.Response.Response, err = future.GetResult(sender); err == nil && bstrp.Response.Response.StatusCode != http.StatusNoContent {
		bstrp, err = client.UpdateResponder(bstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesUpdateFuture", "Result", bstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupShortTermRetentionPolicy a short term retention policy.
type BackupShortTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// BackupShortTermRetentionPolicyProperties - Resource properties.
	*BackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupShortTermRetentionPolicy.
func (bstrp BackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bstrp.BackupShortTermRetentionPolicyProperties != nil {
		objectMap["properties"] = bstrp.BackupShortTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupShortTermRetentionPolicy struct.
func (bstrp *BackupShortTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupShortTermRetentionPolicyProperties BackupShortTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &backupShortTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				bstrp.BackupShortTermRetentionPolicyProperties = &backupShortTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bstrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bstrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bstrp.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupShortTermRetentionPolicyListResult a list of short term retention policies.
type BackupShortTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]BackupShortTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupShortTermRetentionPolicyListResult.
func (bstrplr BackupShortTermRetentionPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BackupShortTermRetentionPolicyListResultIterator provides access to a complete listing of
// BackupShortTermRetentionPolicy values.
type BackupShortTermRetentionPolicyListResultIterator struct {
	i    int
	page BackupShortTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupShortTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupShortTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupShortTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupShortTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupShortTermRetentionPolicyListResultIterator) Response() BackupShortTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupShortTermRetentionPolicyListResultIterator) Value() BackupShortTermRetentionPolicy {
	if !iter.page.NotDone() {
		return BackupShortTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupShortTermRetentionPolicyListResultIterator type.
func NewBackupShortTermRetentionPolicyListResultIterator(page BackupShortTermRetentionPolicyListResultPage) BackupShortTermRetentionPolicyListResultIterator {
	return BackupShortTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bstrplr BackupShortTermRetentionPolicyListResult) IsEmpty() bool {
	return bstrplr.Value == nil || len(*bstrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bstrplr BackupShortTermRetentionPolicyListResult) hasNextLink() bool {
	return bstrplr.NextLink != nil && len(*bstrplr.NextLink) != 0
}

// backupShortTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bstrplr BackupShortTermRetentionPolicyListResult) backupShortTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bstrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bstrplr.NextLink)))
}

// BackupShortTermRetentionPolicyListResultPage contains a page of BackupShortTermRetentionPolicy values.
type BackupShortTermRetentionPolicyListResultPage struct {
	fn      func(context.Context, BackupShortTermRetentionPolicyListResult) (BackupShortTermRetentionPolicyListResult, error)
	bstrplr BackupShortTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupShortTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupShortTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bstrplr)
		if err != nil {
			return err
		}
		page.bstrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupShortTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupShortTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.bstrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupShortTermRetentionPolicyListResultPage) Response() BackupShortTermRetentionPolicyListResult {
	return page.bstrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupShortTermRetentionPolicyListResultPage) Values() []BackupShortTermRetentionPolicy {
	if page.bstrplr.IsEmpty() {
		return nil
	}
	return *page.bstrplr.Value
}

// Creates a new instance of the BackupShortTermRetentionPolicyListResultPage type.
func NewBackupShortTermRetentionPolicyListResultPage(cur BackupShortTermRetentionPolicyListResult, getNextPage func(context.Context, BackupShortTermRetentionPolicyListResult) (BackupShortTermRetentionPolicyListResult, error)) BackupShortTermRetentionPolicyListResultPage {
	return BackupShortTermRetentionPolicyListResultPage{
		fn:      getNextPage,
		bstrplr: cur,
	}
}

// BackupShortTermRetentionPolicyProperties properties of a short term retention policy
type BackupShortTermRetentionPolicyProperties struct {
	// RetentionDays - The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// Database a database resource.
type Database struct {
	autorest.Response `json:"-"`
	// Sku - The database SKU.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Kind of database. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - READ-ONLY; Resource that manages the database.
	ManagedBy *string `json:"managedBy,omitempty"`
	// DatabaseProperties - Resource properties.
	*DatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Sku != nil {
		objectMap["sku"] = d.Sku
	}
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				d.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				d.ManagedBy = &managedBy
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseListResult a list of databases.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Database `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseListResult.
func (dlr DatabaseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseListResultIterator provides access to a complete listing of Database values.
type DatabaseListResultIterator struct {
	i    int
	page DatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseListResultIterator) Response() DatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseListResultIterator) Value() Database {
	if !iter.page.NotDone() {
		return Database{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseListResultIterator type.
func NewDatabaseListResultIterator(page DatabaseListResultPage) DatabaseListResultIterator {
	return DatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DatabaseListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DatabaseListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// databaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DatabaseListResult) databaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DatabaseListResultPage contains a page of Database values.
type DatabaseListResultPage struct {
	fn  func(context.Context, DatabaseListResult) (DatabaseListResult, error)
	dlr DatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseListResultPage) Response() DatabaseListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseListResultPage) Values() []Database {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DatabaseListResultPage type.
func NewDatabaseListResultPage(cur DatabaseListResult, getNextPage func(context.Context, DatabaseListResult) (DatabaseListResult, error)) DatabaseListResultPage {
	return DatabaseListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// DatabaseOperation a database operation.
type DatabaseOperation struct {
	// DatabaseOperationProperties - Resource properties.
	*DatabaseOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperation.
func (do DatabaseOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if do.DatabaseOperationProperties != nil {
		objectMap["properties"] = do.DatabaseOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseOperation struct.
func (do *DatabaseOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseOperationProperties DatabaseOperationProperties
				err = json.Unmarshal(*v, &databaseOperationProperties)
				if err != nil {
					return err
				}
				do.DatabaseOperationProperties = &databaseOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				do.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				do.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				do.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseOperationListResult the response to a list database operations request
type DatabaseOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperationListResult.
func (dolr DatabaseOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseOperationListResultIterator provides access to a complete listing of DatabaseOperation values.
type DatabaseOperationListResultIterator struct {
	i    int
	page DatabaseOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseOperationListResultIterator) Response() DatabaseOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseOperationListResultIterator) Value() DatabaseOperation {
	if !iter.page.NotDone() {
		return DatabaseOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseOperationListResultIterator type.
func NewDatabaseOperationListResultIterator(page DatabaseOperationListResultPage) DatabaseOperationListResultIterator {
	return DatabaseOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DatabaseOperationListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dolr DatabaseOperationListResult) hasNextLink() bool {
	return dolr.NextLink != nil && len(*dolr.NextLink) != 0
}

// databaseOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DatabaseOperationListResult) databaseOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DatabaseOperationListResultPage contains a page of DatabaseOperation values.
type DatabaseOperationListResultPage struct {
	fn   func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)
	dolr DatabaseOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dolr)
		if err != nil {
			return err
		}
		page.dolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseOperationListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseOperationListResultPage) Response() DatabaseOperationListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseOperationListResultPage) Values() []DatabaseOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DatabaseOperationListResultPage type.
func NewDatabaseOperationListResultPage(cur DatabaseOperationListResult, getNextPage func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)) DatabaseOperationListResultPage {
	return DatabaseOperationListResultPage{
		fn:   getNextPage,
		dolr: cur,
	}
}

// DatabaseOperationProperties the properties of a database operation.
type DatabaseOperationProperties struct {
	// DatabaseName - READ-ONLY; The name of the database the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'Pending', 'InProgress', 'Succeeded', 'Failed', 'CancelInProgress', 'Cancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperationProperties.
func (dop DatabaseOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseProperties the database's properties.
type DatabaseProperties struct {
	// CreateMode - Specifies the mode of database creation.
	//
	// Default: regular database creation.
	//
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
	//
	// Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
	//
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
	//
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
	//
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
	//
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
	//
	// Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition. Possible values include: 'CreateModeDefault', 'CreateModeCopy', 'CreateModeSecondary', 'CreateModePointInTimeRestore', 'CreateModeRestore', 'CreateModeRecovery', 'CreateModeRestoreExternalBackup', 'CreateModeRestoreExternalBackupSecondary', 'CreateModeRestoreLongTermRetentionBackup', 'CreateModeOnlineSecondary'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// Collation - The collation of the database.
	Collation *string `json:"collation,omitempty"`
	// MaxSizeBytes - The max size of the database expressed in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// SampleName - The name of the sample schema to apply when creating this database. Possible values include: 'AdventureWorksLT', 'WideWorldImportersStd', 'WideWorldImportersFull'
	SampleName SampleName `json:"sampleName,omitempty"`
	// ElasticPoolID - The resource identifier of the elastic pool containing this database.
	ElasticPoolID *string `json:"elasticPoolId,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// Status - READ-ONLY; The status of the database. Possible values include: 'DatabaseStatusOnline', 'DatabaseStatusRestoring', 'DatabaseStatusRecoveryPending', 'DatabaseStatusRecovering', 'DatabaseStatusSuspect', 'DatabaseStatusOffline', 'DatabaseStatusStandby', 'DatabaseStatusShutdown', 'DatabaseStatusEmergencyMode', 'DatabaseStatusAutoClosed', 'DatabaseStatusCopying', 'DatabaseStatusCreating', 'DatabaseStatusInaccessible', 'DatabaseStatusOfflineSecondary', 'DatabaseStatusPausing', 'DatabaseStatusPaused', 'DatabaseStatusResuming', 'DatabaseStatusScaling', 'DatabaseStatusOfflineChangingDwPerformanceTiers', 'DatabaseStatusOnlineChangingDwPerformanceTiers', 'DatabaseStatusDisabled'
	Status DatabaseStatus `json:"status,omitempty"`
	// DatabaseID - READ-ONLY; The ID of the database.
	DatabaseID *uuid.UUID `json:"databaseId,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// CurrentServiceObjectiveName - READ-ONLY; The current service level objective name of the database.
	CurrentServiceObjectiveName *string `json:"currentServiceObjectiveName,omitempty"`
	// RequestedServiceObjectiveName - READ-ONLY; The requested service level objective name of the database.
	RequestedServiceObjectiveName *string `json:"requestedServiceObjectiveName,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// FailoverGroupID - READ-ONLY; Failover Group resource identifier that this database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RestorePointInTime - Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// SourceDatabaseDeletionDate - Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *date.Time `json:"sourceDatabaseDeletionDate,omitempty"`
	// RecoveryServicesRecoveryPointID - The resource identifier of the recovery point associated with create operation of this database.
	RecoveryServicesRecoveryPointID *string `json:"recoveryServicesRecoveryPointId,omitempty"`
	// LongTermRetentionBackupResourceID - The resource identifier of the long term retention backup associated with create operation of this database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The resource identifier of the restorable dropped database associated with create operation of this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'DATABASEDEFAULT', 'SQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// ZoneRedundant - Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit. Possible values include: 'LicenseIncluded', 'BasePrice'
	LicenseType DatabaseLicenseType `json:"licenseType,omitempty"`
	// MaxLogSizeBytes - READ-ONLY; The max log size for this database.
	MaxLogSizeBytes *int64 `json:"maxLogSizeBytes,omitempty"`
	// EarliestRestoreDate - READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// ReadScale - If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases. Possible values include: 'DatabaseReadScaleEnabled', 'DatabaseReadScaleDisabled'
	ReadScale DatabaseReadScale `json:"readScale,omitempty"`
	// ReadReplicaCount - The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
	ReadReplicaCount *int32 `json:"readReplicaCount,omitempty"`
	// CurrentSku - READ-ONLY; The name and tier of the SKU.
	CurrentSku *Sku `json:"currentSku,omitempty"`
	// AutoPauseDelay - Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
	AutoPauseDelay *int32 `json:"autoPauseDelay,omitempty"`
	// MinCapacity - Minimal capacity that database will always have allocated, if not paused
	MinCapacity *float64 `json:"minCapacity,omitempty"`
	// PausedDate - READ-ONLY; The date when database was paused by user configuration or action (ISO8601 format). Null if the database is ready.
	PausedDate *date.Time `json:"pausedDate,omitempty"`
	// ResumedDate - READ-ONLY; The date when database was resumed by user action or database login (ISO8601 format). Null if the database is paused.
	ResumedDate *date.Time `json:"resumedDate,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.CreateMode != "" {
		objectMap["createMode"] = dp.CreateMode
	}
	if dp.Collation != nil {
		objectMap["collation"] = dp.Collation
	}
	if dp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = dp.MaxSizeBytes
	}
	if dp.SampleName != "" {
		objectMap["sampleName"] = dp.SampleName
	}
	if dp.ElasticPoolID != nil {
		objectMap["elasticPoolId"] = dp.ElasticPoolID
	}
	if dp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = dp.SourceDatabaseID
	}
	if dp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = dp.RestorePointInTime
	}
	if dp.SourceDatabaseDeletionDate != nil {
		objectMap["sourceDatabaseDeletionDate"] = dp.SourceDatabaseDeletionDate
	}
	if dp.RecoveryServicesRecoveryPointID != nil {
		objectMap["recoveryServicesRecoveryPointId"] = dp.RecoveryServicesRecoveryPointID
	}
	if dp.LongTermRetentionBackupResourceID != nil {
		objectMap["longTermRetentionBackupResourceId"] = dp.LongTermRetentionBackupResourceID
	}
	if dp.RecoverableDatabaseID != nil {
		objectMap["recoverableDatabaseId"] = dp.RecoverableDatabaseID
	}
	if dp.RestorableDroppedDatabaseID != nil {
		objectMap["restorableDroppedDatabaseId"] = dp.RestorableDroppedDatabaseID
	}
	if dp.CatalogCollation != "" {
		objectMap["catalogCollation"] = dp.CatalogCollation
	}
	if dp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = dp.ZoneRedundant
	}
	if dp.LicenseType != "" {
		objectMap["licenseType"] = dp.LicenseType
	}
	if dp.ReadScale != "" {
		objectMap["readScale"] = dp.ReadScale
	}
	if dp.ReadReplicaCount != nil {
		objectMap["readReplicaCount"] = dp.ReadReplicaCount
	}
	if dp.AutoPauseDelay != nil {
		objectMap["autoPauseDelay"] = dp.AutoPauseDelay
	}
	if dp.MinCapacity != nil {
		objectMap["minCapacity"] = dp.MinCapacity
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateOrUpdateFuture.Result.
func (future *DatabasesCreateOrUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesPauseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesPauseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesPauseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesPauseFuture.Result.
func (future *DatabasesPauseFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesPauseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.PauseResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesResumeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesResumeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesResumeFuture.Result.
func (future *DatabasesResumeFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesResumeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.ResumeResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpdateFuture.Result.
func (future *DatabasesUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesUpgradeDataWarehouseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasesUpgradeDataWarehouseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpgradeDataWarehouseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpgradeDataWarehouseFuture.Result.
func (future *DatabasesUpgradeDataWarehouseFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpgradeDataWarehouseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpgradeDataWarehouseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseUpdate a database resource.
type DatabaseUpdate struct {
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// DatabaseProperties - Resource properties.
	*DatabaseProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Sku != nil {
		objectMap["sku"] = du.Sku
	}
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	if du.Tags != nil {
		objectMap["tags"] = du.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				du.Sku = &sku
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				du.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessment a database vulnerability assessment.
type DatabaseVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessment.
func (dva DatabaseVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dva.DatabaseVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = dva.DatabaseVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessment struct.
func (dva *DatabaseVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentProperties DatabaseVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				dva.DatabaseVulnerabilityAssessmentProperties = &databaseVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dva.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentListResult a list of the database's vulnerability assessments.
type DatabaseVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentListResult.
func (dvalr DatabaseVulnerabilityAssessmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultIterator struct {
	i    int
	page DatabaseVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Response() DatabaseVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Value() DatabaseVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return DatabaseVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultIterator type.
func NewDatabaseVulnerabilityAssessmentListResultIterator(page DatabaseVulnerabilityAssessmentListResultPage) DatabaseVulnerabilityAssessmentListResultIterator {
	return DatabaseVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dvalr DatabaseVulnerabilityAssessmentListResult) IsEmpty() bool {
	return dvalr.Value == nil || len(*dvalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dvalr DatabaseVulnerabilityAssessmentListResult) hasNextLink() bool {
	return dvalr.NextLink != nil && len(*dvalr.NextLink) != 0
}

// databaseVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dvalr DatabaseVulnerabilityAssessmentListResult) databaseVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dvalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dvalr.NextLink)))
}

// DatabaseVulnerabilityAssessmentListResultPage contains a page of DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultPage struct {
	fn    func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)
	dvalr DatabaseVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dvalr)
		if err != nil {
			return err
		}
		page.dvalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.dvalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseVulnerabilityAssessmentListResultPage) Response() DatabaseVulnerabilityAssessmentListResult {
	return page.dvalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseVulnerabilityAssessmentListResultPage) Values() []DatabaseVulnerabilityAssessment {
	if page.dvalr.IsEmpty() {
		return nil
	}
	return *page.dvalr.Value
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultPage type.
func NewDatabaseVulnerabilityAssessmentListResultPage(cur DatabaseVulnerabilityAssessmentListResult, getNextPage func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)) DatabaseVulnerabilityAssessmentListResultPage {
	return DatabaseVulnerabilityAssessmentListResultPage{
		fn:    getNextPage,
		dvalr: cur,
	}
}

// DatabaseVulnerabilityAssessmentProperties properties of a database Vulnerability Assessment.
type DatabaseVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaseline a database vulnerability assessment rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentRuleBaseline.
func (dvarb DatabaseVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentRuleBaseline struct.
func (dvarb *DatabaseVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentRuleBaselineProperties DatabaseVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties = &databaseVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentRuleBaselineItem properties for an Azure SQL Database Vulnerability
// Assessment rule baseline's result.
type DatabaseVulnerabilityAssessmentRuleBaselineItem struct {
	// Result - The rule baseline result
	Result *[]string `json:"result,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaselineProperties properties of a database Vulnerability Assessment
// rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaselineProperties struct {
	// BaselineResults - The rule baseline result
	BaselineResults *[]DatabaseVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// DatabaseVulnerabilityAssessmentScanExportProperties properties of the export operation's result.
type DatabaseVulnerabilityAssessmentScanExportProperties struct {
	// ExportedReportLocation - READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string `json:"exportedReportLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentScanExportProperties.
func (dvasep DatabaseVulnerabilityAssessmentScanExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseVulnerabilityAssessmentScansExport a database Vulnerability Assessment scan export resource.
type DatabaseVulnerabilityAssessmentScansExport struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentScanExportProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentScanExportProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentScansExport.
func (dvase DatabaseVulnerabilityAssessmentScansExport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvase.DatabaseVulnerabilityAssessmentScanExportProperties != nil {
		objectMap["properties"] = dvase.DatabaseVulnerabilityAssessmentScanExportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentScansExport struct.
func (dvase *DatabaseVulnerabilityAssessmentScansExport) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentScanExportProperties DatabaseVulnerabilityAssessmentScanExportProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentScanExportProperties)
				if err != nil {
					return err
				}
				dvase.DatabaseVulnerabilityAssessmentScanExportProperties = &databaseVulnerabilityAssessmentScanExportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvase.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvase.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvase.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseVulnerabilityAssessmentScansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseVulnerabilityAssessmentScansInitiateScanFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseVulnerabilityAssessmentScansInitiateScanFuture.Result.
func (future *DatabaseVulnerabilityAssessmentScansInitiateScanFuture) result(client DatabaseVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EditionCapability the edition capability.
type EditionCapability struct {
	// Name - READ-ONLY; The database edition name.
	Name *string `json:"name,omitempty"`
	// SupportedServiceLevelObjectives - READ-ONLY; The list of supported service objectives for the edition.
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for EditionCapability.
func (ec EditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ec.Reason != nil {
		objectMap["reason"] = ec.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPool an elastic pool.
type ElasticPool struct {
	autorest.Response `json:"-"`
	// Sku - The elastic pool SKU.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
	//
	// ```azurecli
	// az sql elastic-pool list-editions -l <location> -o table
	// ````
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Kind of elastic pool. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ElasticPoolProperties - Resource properties.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPool.
func (ep ElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.Sku != nil {
		objectMap["sku"] = ep.Sku
	}
	if ep.ElasticPoolProperties != nil {
		objectMap["properties"] = ep.ElasticPoolProperties
	}
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.Tags != nil {
		objectMap["tags"] = ep.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPool struct.
func (ep *ElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ep.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				ep.ElasticPoolProperties = &elasticPoolProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ep.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolEditionCapability the elastic pool edition capability.
type ElasticPoolEditionCapability struct {
	// Name - READ-ONLY; The elastic pool edition name.
	Name *string `json:"name,omitempty"`
	// SupportedElasticPoolPerformanceLevels - READ-ONLY; The list of supported elastic pool DTU levels for the edition.
	SupportedElasticPoolPerformanceLevels *[]ElasticPoolPerformanceLevelCapability `json:"supportedElasticPoolPerformanceLevels,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolEditionCapability.
func (epec ElasticPoolEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epec.Reason != nil {
		objectMap["reason"] = epec.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolListResult the result of an elastic pool list request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ElasticPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolListResult.
func (eplr ElasticPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolListResultIterator provides access to a complete listing of ElasticPool values.
type ElasticPoolListResultIterator struct {
	i    int
	page ElasticPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ElasticPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ElasticPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ElasticPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ElasticPoolListResultIterator) Response() ElasticPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ElasticPoolListResultIterator) Value() ElasticPool {
	if !iter.page.NotDone() {
		return ElasticPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ElasticPoolListResultIterator type.
func NewElasticPoolListResultIterator(page ElasticPoolListResultPage) ElasticPoolListResultIterator {
	return ElasticPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr ElasticPoolListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eplr ElasticPoolListResult) hasNextLink() bool {
	return eplr.NextLink != nil && len(*eplr.NextLink) != 0
}

// elasticPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr ElasticPoolListResult) elasticPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// ElasticPoolListResultPage contains a page of ElasticPool values.
type ElasticPoolListResultPage struct {
	fn   func(context.Context, ElasticPoolListResult) (ElasticPoolListResult, error)
	eplr ElasticPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ElasticPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eplr)
		if err != nil {
			return err
		}
		page.eplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ElasticPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ElasticPoolListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ElasticPoolListResultPage) Response() ElasticPoolListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ElasticPoolListResultPage) Values() []ElasticPool {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the ElasticPoolListResultPage type.
func NewElasticPoolListResultPage(cur ElasticPoolListResult, getNextPage func(context.Context, ElasticPoolListResult) (ElasticPoolListResult, error)) ElasticPoolListResultPage {
	return ElasticPoolListResultPage{
		fn:   getNextPage,
		eplr: cur,
	}
}

// ElasticPoolOperation a elastic pool operation.
type ElasticPoolOperation struct {
	// ElasticPoolOperationProperties - Resource properties.
	*ElasticPoolOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolOperation.
func (epo ElasticPoolOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epo.ElasticPoolOperationProperties != nil {
		objectMap["properties"] = epo.ElasticPoolOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolOperation struct.
func (epo *ElasticPoolOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var elasticPoolOperationProperties ElasticPoolOperationProperties
				err = json.Unmarshal(*v, &elasticPoolOperationProperties)
				if err != nil {
					return err
				}
				epo.ElasticPoolOperationProperties = &elasticPoolOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epo.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolOperationListResult the response to a list elastic pool operations request
type ElasticPoolOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ElasticPoolOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolOperationListResult.
func (epolr ElasticPoolOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolOperationListResultIterator provides access to a complete listing of ElasticPoolOperation
// values.
type ElasticPoolOperationListResultIterator struct {
	i    int
	page ElasticPoolOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ElasticPoolOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ElasticPoolOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ElasticPoolOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ElasticPoolOperationListResultIterator) Response() ElasticPoolOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ElasticPoolOperationListResultIterator) Value() ElasticPoolOperation {
	if !iter.page.NotDone() {
		return ElasticPoolOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ElasticPoolOperationListResultIterator type.
func NewElasticPoolOperationListResultIterator(page ElasticPoolOperationListResultPage) ElasticPoolOperationListResultIterator {
	return ElasticPoolOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (epolr ElasticPoolOperationListResult) IsEmpty() bool {
	return epolr.Value == nil || len(*epolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (epolr ElasticPoolOperationListResult) hasNextLink() bool {
	return epolr.NextLink != nil && len(*epolr.NextLink) != 0
}

// elasticPoolOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (epolr ElasticPoolOperationListResult) elasticPoolOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !epolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(epolr.NextLink)))
}

// ElasticPoolOperationListResultPage contains a page of ElasticPoolOperation values.
type ElasticPoolOperationListResultPage struct {
	fn    func(context.Context, ElasticPoolOperationListResult) (ElasticPoolOperationListResult, error)
	epolr ElasticPoolOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ElasticPoolOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.epolr)
		if err != nil {
			return err
		}
		page.epolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ElasticPoolOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ElasticPoolOperationListResultPage) NotDone() bool {
	return !page.epolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ElasticPoolOperationListResultPage) Response() ElasticPoolOperationListResult {
	return page.epolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ElasticPoolOperationListResultPage) Values() []ElasticPoolOperation {
	if page.epolr.IsEmpty() {
		return nil
	}
	return *page.epolr.Value
}

// Creates a new instance of the ElasticPoolOperationListResultPage type.
func NewElasticPoolOperationListResultPage(cur ElasticPoolOperationListResult, getNextPage func(context.Context, ElasticPoolOperationListResult) (ElasticPoolOperationListResult, error)) ElasticPoolOperationListResultPage {
	return ElasticPoolOperationListResultPage{
		fn:    getNextPage,
		epolr: cur,
	}
}

// ElasticPoolOperationProperties the properties of a elastic pool operation.
type ElasticPoolOperationProperties struct {
	// ElasticPoolName - READ-ONLY; The name of the elastic pool the operation is being performed on.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state.
	State *string `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolOperationProperties.
func (epop ElasticPoolOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseMaxPerformanceLevelCapability the max per-database performance level capability.
type ElasticPoolPerDatabaseMaxPerformanceLevelCapability struct {
	// Limit - READ-ONLY; The maximum performance level per database.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'DTU', 'VCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// SupportedPerDatabaseMinPerformanceLevels - READ-ONLY; The list of supported min database performance levels.
	SupportedPerDatabaseMinPerformanceLevels *[]ElasticPoolPerDatabaseMinPerformanceLevelCapability `json:"supportedPerDatabaseMinPerformanceLevels,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMaxPerformanceLevelCapability.
func (eppdmplc ElasticPoolPerDatabaseMaxPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eppdmplc.Reason != nil {
		objectMap["reason"] = eppdmplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseMinPerformanceLevelCapability the minimum per-database performance level
// capability.
type ElasticPoolPerDatabaseMinPerformanceLevelCapability struct {
	// Limit - READ-ONLY; The minimum performance level per database.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'DTU', 'VCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMinPerformanceLevelCapability.
func (eppdmplc ElasticPoolPerDatabaseMinPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eppdmplc.Reason != nil {
		objectMap["reason"] = eppdmplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseSettings per database settings of an elastic pool.
type ElasticPoolPerDatabaseSettings struct {
	// MinCapacity - The minimum capacity all databases are guaranteed.
	MinCapacity *float64 `json:"minCapacity,omitempty"`
	// MaxCapacity - The maximum capacity any one database can consume.
	MaxCapacity *float64 `json:"maxCapacity,omitempty"`
}

// ElasticPoolPerformanceLevelCapability the Elastic Pool performance level capability.
type ElasticPoolPerformanceLevelCapability struct {
	// PerformanceLevel - READ-ONLY; The performance level for the pool.
	PerformanceLevel *PerformanceLevelCapability `json:"performanceLevel,omitempty"`
	// Sku - READ-ONLY; The sku.
	Sku *Sku `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// MaxDatabaseCount - READ-ONLY; The maximum number of databases supported.
	MaxDatabaseCount *int32 `json:"maxDatabaseCount,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size for this performance level.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported max sizes.
	SupportedMaxSizes *[]MaxSizeRangeCapability `json:"supportedMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxSizes - READ-ONLY; The list of supported per database max sizes.
	SupportedPerDatabaseMaxSizes *[]MaxSizeRangeCapability `json:"supportedPerDatabaseMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxPerformanceLevels - READ-ONLY; The list of supported per database max performance levels.
	SupportedPerDatabaseMaxPerformanceLevels *[]ElasticPoolPerDatabaseMaxPerformanceLevelCapability `json:"supportedPerDatabaseMaxPerformanceLevels,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerformanceLevelCapability.
func (epplc ElasticPoolPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epplc.Reason != nil {
		objectMap["reason"] = epplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolProperties properties of an elastic pool
type ElasticPoolProperties struct {
	// State - READ-ONLY; The state of the elastic pool. Possible values include: 'ElasticPoolStateCreating', 'ElasticPoolStateReady', 'ElasticPoolStateDisabled'
	State ElasticPoolState `json:"state,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the elastic pool (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// MaxSizeBytes - The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// PerDatabaseSettings - The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`
	// ZoneRedundant - Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this elastic pool. Possible values include: 'ElasticPoolLicenseTypeLicenseIncluded', 'ElasticPoolLicenseTypeBasePrice'
	LicenseType ElasticPoolLicenseType `json:"licenseType,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolProperties.
func (epp ElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = epp.MaxSizeBytes
	}
	if epp.PerDatabaseSettings != nil {
		objectMap["perDatabaseSettings"] = epp.PerDatabaseSettings
	}
	if epp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = epp.ZoneRedundant
	}
	if epp.LicenseType != "" {
		objectMap["licenseType"] = epp.LicenseType
	}
	return json.Marshal(objectMap)
}

// ElasticPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ElasticPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsCreateOrUpdateFuture.Result.
func (future *ElasticPoolsCreateOrUpdateFuture) result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsDeleteFuture.Result.
func (future *ElasticPoolsDeleteFuture) result(client ElasticPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ElasticPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsUpdateFuture.Result.
func (future *ElasticPoolsUpdateFuture) result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.UpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolUpdate an elastic pool update.
type ElasticPoolUpdate struct {
	Sku *Sku `json:"sku,omitempty"`
	// ElasticPoolUpdateProperties - Resource properties.
	*ElasticPoolUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ElasticPoolUpdate.
func (epu ElasticPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epu.Sku != nil {
		objectMap["sku"] = epu.Sku
	}
	if epu.ElasticPoolUpdateProperties != nil {
		objectMap["properties"] = epu.ElasticPoolUpdateProperties
	}
	if epu.Tags != nil {
		objectMap["tags"] = epu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolUpdate struct.
func (epu *ElasticPoolUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				epu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var elasticPoolUpdateProperties ElasticPoolUpdateProperties
				err = json.Unmarshal(*v, &elasticPoolUpdateProperties)
				if err != nil {
					return err
				}
				epu.ElasticPoolUpdateProperties = &elasticPoolUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				epu.Tags = tags
			}
		}
	}

	return nil
}

// ElasticPoolUpdateProperties properties of an elastic pool
type ElasticPoolUpdateProperties struct {
	// MaxSizeBytes - The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// PerDatabaseSettings - The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`
	// ZoneRedundant - Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this elastic pool. Possible values include: 'ElasticPoolLicenseTypeLicenseIncluded', 'ElasticPoolLicenseTypeBasePrice'
	LicenseType ElasticPoolLicenseType `json:"licenseType,omitempty"`
}

// InstanceFailoverGroup an instance failover group.
type InstanceFailoverGroup struct {
	autorest.Response `json:"-"`
	// InstanceFailoverGroupProperties - Resource properties.
	*InstanceFailoverGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroup.
func (ifg InstanceFailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifg.InstanceFailoverGroupProperties != nil {
		objectMap["properties"] = ifg.InstanceFailoverGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InstanceFailoverGroup struct.
func (ifg *InstanceFailoverGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var instanceFailoverGroupProperties InstanceFailoverGroupProperties
				err = json.Unmarshal(*v, &instanceFailoverGroupProperties)
				if err != nil {
					return err
				}
				ifg.InstanceFailoverGroupProperties = &instanceFailoverGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ifg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ifg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ifg.Type = &typeVar
			}
		}
	}

	return nil
}

// InstanceFailoverGroupListResult a list of instance failover groups.
type InstanceFailoverGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]InstanceFailoverGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroupListResult.
func (ifglr InstanceFailoverGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InstanceFailoverGroupListResultIterator provides access to a complete listing of InstanceFailoverGroup
// values.
type InstanceFailoverGroupListResultIterator struct {
	i    int
	page InstanceFailoverGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InstanceFailoverGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceFailoverGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InstanceFailoverGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InstanceFailoverGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InstanceFailoverGroupListResultIterator) Response() InstanceFailoverGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InstanceFailoverGroupListResultIterator) Value() InstanceFailoverGroup {
	if !iter.page.NotDone() {
		return InstanceFailoverGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InstanceFailoverGroupListResultIterator type.
func NewInstanceFailoverGroupListResultIterator(page InstanceFailoverGroupListResultPage) InstanceFailoverGroupListResultIterator {
	return InstanceFailoverGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ifglr InstanceFailoverGroupListResult) IsEmpty() bool {
	return ifglr.Value == nil || len(*ifglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ifglr InstanceFailoverGroupListResult) hasNextLink() bool {
	return ifglr.NextLink != nil && len(*ifglr.NextLink) != 0
}

// instanceFailoverGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ifglr InstanceFailoverGroupListResult) instanceFailoverGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ifglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ifglr.NextLink)))
}

// InstanceFailoverGroupListResultPage contains a page of InstanceFailoverGroup values.
type InstanceFailoverGroupListResultPage struct {
	fn    func(context.Context, InstanceFailoverGroupListResult) (InstanceFailoverGroupListResult, error)
	ifglr InstanceFailoverGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InstanceFailoverGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceFailoverGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ifglr)
		if err != nil {
			return err
		}
		page.ifglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InstanceFailoverGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InstanceFailoverGroupListResultPage) NotDone() bool {
	return !page.ifglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InstanceFailoverGroupListResultPage) Response() InstanceFailoverGroupListResult {
	return page.ifglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InstanceFailoverGroupListResultPage) Values() []InstanceFailoverGroup {
	if page.ifglr.IsEmpty() {
		return nil
	}
	return *page.ifglr.Value
}

// Creates a new instance of the InstanceFailoverGroupListResultPage type.
func NewInstanceFailoverGroupListResultPage(cur InstanceFailoverGroupListResult, getNextPage func(context.Context, InstanceFailoverGroupListResult) (InstanceFailoverGroupListResult, error)) InstanceFailoverGroupListResultPage {
	return InstanceFailoverGroupListResultPage{
		fn:    getNextPage,
		ifglr: cur,
	}
}

// InstanceFailoverGroupProperties properties of a instance failover group.
type InstanceFailoverGroupProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *InstanceFailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *InstanceFailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// ReplicationRole - READ-ONLY; Local replication role of the failover group instance. Possible values include: 'Primary', 'Secondary'
	ReplicationRole InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty"`
	// ReplicationState - READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty"`
	// PartnerRegions - Partner region information for the failover group.
	PartnerRegions *[]PartnerRegionInfo `json:"partnerRegions,omitempty"`
	// ManagedInstancePairs - List of managed instance pairs in the failover group.
	ManagedInstancePairs *[]ManagedInstancePairInfo `json:"managedInstancePairs,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroupProperties.
func (ifgp InstanceFailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifgp.ReadWriteEndpoint != nil {
		objectMap["readWriteEndpoint"] = ifgp.ReadWriteEndpoint
	}
	if ifgp.ReadOnlyEndpoint != nil {
		objectMap["readOnlyEndpoint"] = ifgp.ReadOnlyEndpoint
	}
	if ifgp.PartnerRegions != nil {
		objectMap["partnerRegions"] = ifgp.PartnerRegions
	}
	if ifgp.ManagedInstancePairs != nil {
		objectMap["managedInstancePairs"] = ifgp.ManagedInstancePairs
	}
	return json.Marshal(objectMap)
}

// InstanceFailoverGroupReadOnlyEndpoint read-only endpoint of the failover group instance.
type InstanceFailoverGroupReadOnlyEndpoint struct {
	// FailoverPolicy - Failover policy of the read-only endpoint for the failover group. Possible values include: 'ReadOnlyEndpointFailoverPolicyDisabled', 'ReadOnlyEndpointFailoverPolicyEnabled'
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// InstanceFailoverGroupReadWriteEndpoint read-write endpoint of the failover group instance.
type InstanceFailoverGroupReadWriteEndpoint struct {
	// FailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Possible values include: 'Manual', 'Automatic'
	FailoverPolicy ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	// FailoverWithDataLossGracePeriodMinutes - Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// InstanceFailoverGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (InstanceFailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsCreateOrUpdateFuture.Result.
func (future *InstanceFailoverGroupsCreateOrUpdateFuture) result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ifg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.CreateOrUpdateResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsCreateOrUpdateFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstanceFailoverGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsDeleteFuture.Result.
func (future *InstanceFailoverGroupsDeleteFuture) result(client InstanceFailoverGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// InstanceFailoverGroupsFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (InstanceFailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsFailoverFuture.Result.
func (future *InstanceFailoverGroupsFailoverFuture) result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ifg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.FailoverResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsFailoverFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstanceFailoverGroupsForceFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type InstanceFailoverGroupsForceFailoverAllowDataLossFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (InstanceFailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsForceFailoverAllowDataLossFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsForceFailoverAllowDataLossFuture.Result.
func (future *InstanceFailoverGroupsForceFailoverAllowDataLossFuture) result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ifg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.ForceFailoverAllowDataLossResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LicenseTypeCapability the license type capability
type LicenseTypeCapability struct {
	// Name - READ-ONLY; License type identifier.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for LicenseTypeCapability.
func (ltc LicenseTypeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltc.Reason != nil {
		objectMap["reason"] = ltc.Reason
	}
	return json.Marshal(objectMap)
}

// LocationCapabilities the location capability.
type LocationCapabilities struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The location name.
	Name *string `json:"name,omitempty"`
	// SupportedServerVersions - READ-ONLY; The list of supported server versions.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
	// SupportedManagedInstanceVersions - READ-ONLY; The list of supported managed instance versions.
	SupportedManagedInstanceVersions *[]ManagedInstanceVersionCapability `json:"supportedManagedInstanceVersions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationCapabilities.
func (lc LocationCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lc.Reason != nil {
		objectMap["reason"] = lc.Reason
	}
	return json.Marshal(objectMap)
}

// LogSizeCapability the log size capability.
type LogSizeCapability struct {
	// Limit - READ-ONLY; The log size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes', 'Percent'
	Unit LogSizeUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for LogSizeCapability.
func (lsc LogSizeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabaseVulnerabilityAssessmentScansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture.Result.
func (future *ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture) result(client ManagedDatabaseVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceEditionCapability the managed server capability
type ManagedInstanceEditionCapability struct {
	// Name - READ-ONLY; The managed server version name.
	Name *string `json:"name,omitempty"`
	// SupportedFamilies - READ-ONLY; The supported families.
	SupportedFamilies *[]ManagedInstanceFamilyCapability `json:"supportedFamilies,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEditionCapability.
func (miec ManagedInstanceEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miec.Reason != nil {
		objectMap["reason"] = miec.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtector the managed instance encryption protector.
type ManagedInstanceEncryptionProtector struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedInstanceEncryptionProtectorProperties - Resource properties.
	*ManagedInstanceEncryptionProtectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtector.
func (miep ManagedInstanceEncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miep.ManagedInstanceEncryptionProtectorProperties != nil {
		objectMap["properties"] = miep.ManagedInstanceEncryptionProtectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceEncryptionProtector struct.
func (miep *ManagedInstanceEncryptionProtector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				miep.Kind = &kind
			}
		case "properties":
			if v != nil {
				var managedInstanceEncryptionProtectorProperties ManagedInstanceEncryptionProtectorProperties
				err = json.Unmarshal(*v, &managedInstanceEncryptionProtectorProperties)
				if err != nil {
					return err
				}
				miep.ManagedInstanceEncryptionProtectorProperties = &managedInstanceEncryptionProtectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miep.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceEncryptionProtectorListResult a list of managed instance encryption protectors.
type ManagedInstanceEncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceEncryptionProtector `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtectorListResult.
func (mieplr ManagedInstanceEncryptionProtectorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtectorListResultIterator provides access to a complete listing of
// ManagedInstanceEncryptionProtector values.
type ManagedInstanceEncryptionProtectorListResultIterator struct {
	i    int
	page ManagedInstanceEncryptionProtectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceEncryptionProtectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceEncryptionProtectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceEncryptionProtectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) Response() ManagedInstanceEncryptionProtectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) Value() ManagedInstanceEncryptionProtector {
	if !iter.page.NotDone() {
		return ManagedInstanceEncryptionProtector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceEncryptionProtectorListResultIterator type.
func NewManagedInstanceEncryptionProtectorListResultIterator(page ManagedInstanceEncryptionProtectorListResultPage) ManagedInstanceEncryptionProtectorListResultIterator {
	return ManagedInstanceEncryptionProtectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mieplr ManagedInstanceEncryptionProtectorListResult) IsEmpty() bool {
	return mieplr.Value == nil || len(*mieplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mieplr ManagedInstanceEncryptionProtectorListResult) hasNextLink() bool {
	return mieplr.NextLink != nil && len(*mieplr.NextLink) != 0
}

// managedInstanceEncryptionProtectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mieplr ManagedInstanceEncryptionProtectorListResult) managedInstanceEncryptionProtectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mieplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mieplr.NextLink)))
}

// ManagedInstanceEncryptionProtectorListResultPage contains a page of ManagedInstanceEncryptionProtector
// values.
type ManagedInstanceEncryptionProtectorListResultPage struct {
	fn     func(context.Context, ManagedInstanceEncryptionProtectorListResult) (ManagedInstanceEncryptionProtectorListResult, error)
	mieplr ManagedInstanceEncryptionProtectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceEncryptionProtectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceEncryptionProtectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mieplr)
		if err != nil {
			return err
		}
		page.mieplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceEncryptionProtectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceEncryptionProtectorListResultPage) NotDone() bool {
	return !page.mieplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceEncryptionProtectorListResultPage) Response() ManagedInstanceEncryptionProtectorListResult {
	return page.mieplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceEncryptionProtectorListResultPage) Values() []ManagedInstanceEncryptionProtector {
	if page.mieplr.IsEmpty() {
		return nil
	}
	return *page.mieplr.Value
}

// Creates a new instance of the ManagedInstanceEncryptionProtectorListResultPage type.
func NewManagedInstanceEncryptionProtectorListResultPage(cur ManagedInstanceEncryptionProtectorListResult, getNextPage func(context.Context, ManagedInstanceEncryptionProtectorListResult) (ManagedInstanceEncryptionProtectorListResult, error)) ManagedInstanceEncryptionProtectorListResultPage {
	return ManagedInstanceEncryptionProtectorListResultPage{
		fn:     getNextPage,
		mieplr: cur,
	}
}

// ManagedInstanceEncryptionProtectorProperties properties for an encryption protector execution.
type ManagedInstanceEncryptionProtectorProperties struct {
	// ServerKeyName - The name of the managed instance key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`
	// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtectorProperties.
func (miepp ManagedInstanceEncryptionProtectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miepp.ServerKeyName != nil {
		objectMap["serverKeyName"] = miepp.ServerKeyName
	}
	if miepp.ServerKeyType != "" {
		objectMap["serverKeyType"] = miepp.ServerKeyType
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceEncryptionProtectorsClient) (ManagedInstanceEncryptionProtector, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture.Result.
func (future *ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture) result(client ManagedInstanceEncryptionProtectorsClient) (miep ManagedInstanceEncryptionProtector, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		miep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if miep.Response.Response, err = future.GetResult(sender); err == nil && miep.Response.Response.StatusCode != http.StatusNoContent {
		miep, err = client.CreateOrUpdateResponder(miep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture", "Result", miep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceEncryptionProtectorsRevalidateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceEncryptionProtectorsRevalidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceEncryptionProtectorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceEncryptionProtectorsRevalidateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceEncryptionProtectorsRevalidateFuture.Result.
func (future *ManagedInstanceEncryptionProtectorsRevalidateFuture) result(client ManagedInstanceEncryptionProtectorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsRevalidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceEncryptionProtectorsRevalidateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceFamilyCapability the managed server family capability.
type ManagedInstanceFamilyCapability struct {
	// Name - READ-ONLY; Family name.
	Name *string `json:"name,omitempty"`
	// Sku - READ-ONLY; SKU name.
	Sku *string `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// SupportedVcoresValues - READ-ONLY; List of supported virtual cores values.
	SupportedVcoresValues *[]ManagedInstanceVcoresCapability `json:"supportedVcoresValues,omitempty"`
	// IncludedMaxSize - READ-ONLY; Included size.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedStorageSizes - READ-ONLY; Storage size ranges.
	SupportedStorageSizes *[]MaxSizeRangeCapability `json:"supportedStorageSizes,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceFamilyCapability.
func (mifc ManagedInstanceFamilyCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mifc.Reason != nil {
		objectMap["reason"] = mifc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceKey a managed instance key.
type ManagedInstanceKey struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedInstanceKeyProperties - Resource properties.
	*ManagedInstanceKeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKey.
func (mik ManagedInstanceKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mik.ManagedInstanceKeyProperties != nil {
		objectMap["properties"] = mik.ManagedInstanceKeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceKey struct.
func (mik *ManagedInstanceKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mik.Kind = &kind
			}
		case "properties":
			if v != nil {
				var managedInstanceKeyProperties ManagedInstanceKeyProperties
				err = json.Unmarshal(*v, &managedInstanceKeyProperties)
				if err != nil {
					return err
				}
				mik.ManagedInstanceKeyProperties = &managedInstanceKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mik.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mik.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mik.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceKeyListResult a list of managed instance keys.
type ManagedInstanceKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceKey `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKeyListResult.
func (miklr ManagedInstanceKeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceKeyListResultIterator provides access to a complete listing of ManagedInstanceKey values.
type ManagedInstanceKeyListResultIterator struct {
	i    int
	page ManagedInstanceKeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceKeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceKeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceKeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceKeyListResultIterator) Response() ManagedInstanceKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceKeyListResultIterator) Value() ManagedInstanceKey {
	if !iter.page.NotDone() {
		return ManagedInstanceKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceKeyListResultIterator type.
func NewManagedInstanceKeyListResultIterator(page ManagedInstanceKeyListResultPage) ManagedInstanceKeyListResultIterator {
	return ManagedInstanceKeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miklr ManagedInstanceKeyListResult) IsEmpty() bool {
	return miklr.Value == nil || len(*miklr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miklr ManagedInstanceKeyListResult) hasNextLink() bool {
	return miklr.NextLink != nil && len(*miklr.NextLink) != 0
}

// managedInstanceKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miklr ManagedInstanceKeyListResult) managedInstanceKeyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miklr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miklr.NextLink)))
}

// ManagedInstanceKeyListResultPage contains a page of ManagedInstanceKey values.
type ManagedInstanceKeyListResultPage struct {
	fn    func(context.Context, ManagedInstanceKeyListResult) (ManagedInstanceKeyListResult, error)
	miklr ManagedInstanceKeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceKeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceKeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miklr)
		if err != nil {
			return err
		}
		page.miklr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceKeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceKeyListResultPage) NotDone() bool {
	return !page.miklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceKeyListResultPage) Response() ManagedInstanceKeyListResult {
	return page.miklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceKeyListResultPage) Values() []ManagedInstanceKey {
	if page.miklr.IsEmpty() {
		return nil
	}
	return *page.miklr.Value
}

// Creates a new instance of the ManagedInstanceKeyListResultPage type.
func NewManagedInstanceKeyListResultPage(cur ManagedInstanceKeyListResult, getNextPage func(context.Context, ManagedInstanceKeyListResult) (ManagedInstanceKeyListResult, error)) ManagedInstanceKeyListResultPage {
	return ManagedInstanceKeyListResultPage{
		fn:    getNextPage,
		miklr: cur,
	}
}

// ManagedInstanceKeyProperties properties for a key execution.
type ManagedInstanceKeyProperties struct {
	// ServerKeyType - The key type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// CreationDate - READ-ONLY; The key creation date.
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKeyProperties.
func (mikp ManagedInstanceKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mikp.ServerKeyType != "" {
		objectMap["serverKeyType"] = mikp.ServerKeyType
	}
	if mikp.URI != nil {
		objectMap["uri"] = mikp.URI
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceKeysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceKeysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceKeysClient) (ManagedInstanceKey, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceKeysCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceKeysCreateOrUpdateFuture.Result.
func (future *ManagedInstanceKeysCreateOrUpdateFuture) result(client ManagedInstanceKeysClient) (mik ManagedInstanceKey, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mik.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceKeysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mik.Response.Response, err = future.GetResult(sender); err == nil && mik.Response.Response.StatusCode != http.StatusNoContent {
		mik, err = client.CreateOrUpdateResponder(mik.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysCreateOrUpdateFuture", "Result", mik.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceKeysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceKeysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceKeysClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceKeysDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceKeysDeleteFuture.Result.
func (future *ManagedInstanceKeysDeleteFuture) result(client ManagedInstanceKeysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceKeysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstancePairInfo pairs of Managed Instances in the failover group.
type ManagedInstancePairInfo struct {
	// PrimaryManagedInstanceID - Id of Primary Managed Instance in pair.
	PrimaryManagedInstanceID *string `json:"primaryManagedInstanceId,omitempty"`
	// PartnerManagedInstanceID - Id of Partner Managed Instance in pair.
	PartnerManagedInstanceID *string `json:"partnerManagedInstanceId,omitempty"`
}

// ManagedInstanceTdeCertificatesCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceTdeCertificatesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceTdeCertificatesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceTdeCertificatesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceTdeCertificatesCreateFuture.Result.
func (future *ManagedInstanceTdeCertificatesCreateFuture) result(client ManagedInstanceTdeCertificatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceTdeCertificatesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceTdeCertificatesCreateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceVcoresCapability the managed instance virtual cores capability.
type ManagedInstanceVcoresCapability struct {
	// Name - READ-ONLY; The virtual cores identifier.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The virtual cores value.
	Value *int32 `json:"value,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVcoresCapability.
func (mivc ManagedInstanceVcoresCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mivc.Reason != nil {
		objectMap["reason"] = mivc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceVersionCapability the managed instance capability
type ManagedInstanceVersionCapability struct {
	// Name - READ-ONLY; The server version name.
	Name *string `json:"name,omitempty"`
	// SupportedEditions - READ-ONLY; The list of supported managed instance editions.
	SupportedEditions *[]ManagedInstanceEditionCapability `json:"supportedEditions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVersionCapability.
func (mivc ManagedInstanceVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mivc.Reason != nil {
		objectMap["reason"] = mivc.Reason
	}
	return json.Marshal(objectMap)
}

// MaxSizeCapability the maximum size capability.
type MaxSizeCapability struct {
	// Limit - READ-ONLY; The maximum size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'MaxSizeUnitMegabytes', 'MaxSizeUnitGigabytes', 'MaxSizeUnitTerabytes', 'MaxSizeUnitPetabytes'
	Unit MaxSizeUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for MaxSizeCapability.
func (msc MaxSizeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MaxSizeRangeCapability the maximum size range capability.
type MaxSizeRangeCapability struct {
	// MinValue - READ-ONLY; Minimum value.
	MinValue *MaxSizeCapability `json:"minValue,omitempty"`
	// MaxValue - READ-ONLY; Maximum value.
	MaxValue *MaxSizeCapability `json:"maxValue,omitempty"`
	// ScaleSize - READ-ONLY; Scale/step size for discrete values between the minimum value and the maximum value.
	ScaleSize *MaxSizeCapability `json:"scaleSize,omitempty"`
	// LogSize - READ-ONLY; Size of transaction log.
	LogSize *LogSizeCapability `json:"logSize,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for MaxSizeRangeCapability.
func (msrc MaxSizeRangeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msrc.Reason != nil {
		objectMap["reason"] = msrc.Reason
	}
	return json.Marshal(objectMap)
}

// PartnerRegionInfo partner region information for the failover group.
type PartnerRegionInfo struct {
	// Location - Geo location of the partner managed instances.
	Location *string `json:"location,omitempty"`
	// ReplicationRole - READ-ONLY; Replication role of the partner managed instances. Possible values include: 'Primary', 'Secondary'
	ReplicationRole InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerRegionInfo.
func (pri PartnerRegionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pri.Location != nil {
		objectMap["location"] = pri.Location
	}
	return json.Marshal(objectMap)
}

// PerformanceLevelCapability the performance level capability.
type PerformanceLevelCapability struct {
	// Value - READ-ONLY; Performance level value.
	Value *float64 `json:"value,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'DTU', 'VCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for PerformanceLevelCapability.
func (plc PerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecoverableManagedDatabase a recoverable managed database resource.
type RecoverableManagedDatabase struct {
	autorest.Response `json:"-"`
	// RecoverableManagedDatabaseProperties - Resource properties.
	*RecoverableManagedDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableManagedDatabase.
func (rmd RecoverableManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmd.RecoverableManagedDatabaseProperties != nil {
		objectMap["properties"] = rmd.RecoverableManagedDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoverableManagedDatabase struct.
func (rmd *RecoverableManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recoverableManagedDatabaseProperties RecoverableManagedDatabaseProperties
				err = json.Unmarshal(*v, &recoverableManagedDatabaseProperties)
				if err != nil {
					return err
				}
				rmd.RecoverableManagedDatabaseProperties = &recoverableManagedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmd.Type = &typeVar
			}
		}
	}

	return nil
}

// RecoverableManagedDatabaseListResult a list of recoverable managed databases.
type RecoverableManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RecoverableManagedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableManagedDatabaseListResult.
func (rmdlr RecoverableManagedDatabaseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecoverableManagedDatabaseListResultIterator provides access to a complete listing of
// RecoverableManagedDatabase values.
type RecoverableManagedDatabaseListResultIterator struct {
	i    int
	page RecoverableManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoverableManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoverableManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecoverableManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoverableManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoverableManagedDatabaseListResultIterator) Response() RecoverableManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoverableManagedDatabaseListResultIterator) Value() RecoverableManagedDatabase {
	if !iter.page.NotDone() {
		return RecoverableManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecoverableManagedDatabaseListResultIterator type.
func NewRecoverableManagedDatabaseListResultIterator(page RecoverableManagedDatabaseListResultPage) RecoverableManagedDatabaseListResultIterator {
	return RecoverableManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmdlr RecoverableManagedDatabaseListResult) IsEmpty() bool {
	return rmdlr.Value == nil || len(*rmdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rmdlr RecoverableManagedDatabaseListResult) hasNextLink() bool {
	return rmdlr.NextLink != nil && len(*rmdlr.NextLink) != 0
}

// recoverableManagedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmdlr RecoverableManagedDatabaseListResult) recoverableManagedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rmdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmdlr.NextLink)))
}

// RecoverableManagedDatabaseListResultPage contains a page of RecoverableManagedDatabase values.
type RecoverableManagedDatabaseListResultPage struct {
	fn    func(context.Context, RecoverableManagedDatabaseListResult) (RecoverableManagedDatabaseListResult, error)
	rmdlr RecoverableManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoverableManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoverableManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rmdlr)
		if err != nil {
			return err
		}
		page.rmdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecoverableManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoverableManagedDatabaseListResultPage) NotDone() bool {
	return !page.rmdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoverableManagedDatabaseListResultPage) Response() RecoverableManagedDatabaseListResult {
	return page.rmdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoverableManagedDatabaseListResultPage) Values() []RecoverableManagedDatabase {
	if page.rmdlr.IsEmpty() {
		return nil
	}
	return *page.rmdlr.Value
}

// Creates a new instance of the RecoverableManagedDatabaseListResultPage type.
func NewRecoverableManagedDatabaseListResultPage(cur RecoverableManagedDatabaseListResult, getNextPage func(context.Context, RecoverableManagedDatabaseListResult) (RecoverableManagedDatabaseListResult, error)) RecoverableManagedDatabaseListResultPage {
	return RecoverableManagedDatabaseListResultPage{
		fn:    getNextPage,
		rmdlr: cur,
	}
}

// RecoverableManagedDatabaseProperties the recoverable managed database's properties.
type RecoverableManagedDatabaseProperties struct {
	// LastAvailableBackupDate - READ-ONLY; The last available backup date.
	LastAvailableBackupDate *string `json:"lastAvailableBackupDate,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableManagedDatabaseProperties.
func (rmdp RecoverableManagedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource ARM resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceMoveDefinition contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// ID - The target ID for the resource
	ID *string `json:"id,omitempty"`
}

// ServerVersionCapability the server capability
type ServerVersionCapability struct {
	// Name - READ-ONLY; The server version name.
	Name *string `json:"name,omitempty"`
	// SupportedEditions - READ-ONLY; The list of supported database editions.
	SupportedEditions *[]EditionCapability `json:"supportedEditions,omitempty"`
	// SupportedElasticPoolEditions - READ-ONLY; The list of supported elastic pool editions.
	SupportedElasticPoolEditions *[]ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVersionCapability.
func (svc ServerVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if svc.Reason != nil {
		objectMap["reason"] = svc.Reason
	}
	return json.Marshal(objectMap)
}

// ServiceObjectiveCapability the service objectives capability.
type ServiceObjectiveCapability struct {
	// ID - READ-ONLY; The unique ID of the service objective.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - READ-ONLY; The service objective name.
	Name *string `json:"name,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported maximum database sizes.
	SupportedMaxSizes *[]MaxSizeRangeCapability `json:"supportedMaxSizes,omitempty"`
	// PerformanceLevel - READ-ONLY; The performance level.
	PerformanceLevel *PerformanceLevelCapability `json:"performanceLevel,omitempty"`
	// Sku - READ-ONLY; The sku.
	Sku *Sku `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjectiveCapability.
func (soc ServiceObjectiveCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if soc.Reason != nil {
		objectMap["reason"] = soc.Reason
	}
	return json.Marshal(objectMap)
}

// Sku an ARM Resource SKU.
type Sku struct {
	// Name - The name of the SKU, typically, a letter + Number code, e.g. P3.
	Name *string `json:"name,omitempty"`
	// Tier - The tier or edition of the particular SKU, e.g. Basic, Premium.
	Tier *string `json:"tier,omitempty"`
	// Size - Size of the particular SKU
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - Capacity of the particular SKU.
	Capacity *int32 `json:"capacity,omitempty"`
}

// TdeCertificate a TDE certificate that can be uploaded into a server.
type TdeCertificate struct {
	// TdeCertificateProperties - Resource properties.
	*TdeCertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TdeCertificate.
func (tc TdeCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tc.TdeCertificateProperties != nil {
		objectMap["properties"] = tc.TdeCertificateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TdeCertificate struct.
func (tc *TdeCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tdeCertificateProperties TdeCertificateProperties
				err = json.Unmarshal(*v, &tdeCertificateProperties)
				if err != nil {
					return err
				}
				tc.TdeCertificateProperties = &tdeCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tc.Type = &typeVar
			}
		}
	}

	return nil
}

// TdeCertificateProperties properties of a TDE certificate.
type TdeCertificateProperties struct {
	// PrivateBlob - The base64 encoded certificate private blob.
	PrivateBlob *string `json:"privateBlob,omitempty"`
	// CertPassword - The certificate password.
	CertPassword *string `json:"certPassword,omitempty"`
}

// TdeCertificatesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TdeCertificatesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TdeCertificatesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TdeCertificatesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TdeCertificatesCreateFuture.Result.
func (future *TdeCertificatesCreateFuture) result(client TdeCertificatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.TdeCertificatesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.TdeCertificatesCreateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// VulnerabilityAssessmentRecurringScansProperties properties of a Vulnerability Assessment recurring
// scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// IsEnabled - Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EmailSubscriptionAdmins - Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`
	// Emails - Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails *[]string `json:"emails,omitempty"`
}

// VulnerabilityAssessmentScanError properties of a vulnerability assessment scan error.
type VulnerabilityAssessmentScanError struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for VulnerabilityAssessmentScanError.
func (vase VulnerabilityAssessmentScanError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VulnerabilityAssessmentScanRecord a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecord struct {
	autorest.Response `json:"-"`
	// VulnerabilityAssessmentScanRecordProperties - Resource properties.
	*VulnerabilityAssessmentScanRecordProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VulnerabilityAssessmentScanRecord.
func (vasr VulnerabilityAssessmentScanRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vasr.VulnerabilityAssessmentScanRecordProperties != nil {
		objectMap["properties"] = vasr.VulnerabilityAssessmentScanRecordProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VulnerabilityAssessmentScanRecord struct.
func (vasr *VulnerabilityAssessmentScanRecord) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vulnerabilityAssessmentScanRecordProperties VulnerabilityAssessmentScanRecordProperties
				err = json.Unmarshal(*v, &vulnerabilityAssessmentScanRecordProperties)
				if err != nil {
					return err
				}
				vasr.VulnerabilityAssessmentScanRecordProperties = &vulnerabilityAssessmentScanRecordProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vasr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vasr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vasr.Type = &typeVar
			}
		}
	}

	return nil
}

// VulnerabilityAssessmentScanRecordListResult a list of vulnerability assessment scan records.
type VulnerabilityAssessmentScanRecordListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VulnerabilityAssessmentScanRecord `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VulnerabilityAssessmentScanRecordListResult.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VulnerabilityAssessmentScanRecordListResultIterator provides access to a complete listing of
// VulnerabilityAssessmentScanRecord values.
type VulnerabilityAssessmentScanRecordListResultIterator struct {
	i    int
	page VulnerabilityAssessmentScanRecordListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Response() VulnerabilityAssessmentScanRecordListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Value() VulnerabilityAssessmentScanRecord {
	if !iter.page.NotDone() {
		return VulnerabilityAssessmentScanRecord{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultIterator type.
func NewVulnerabilityAssessmentScanRecordListResultIterator(page VulnerabilityAssessmentScanRecordListResultPage) VulnerabilityAssessmentScanRecordListResultIterator {
	return VulnerabilityAssessmentScanRecordListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) IsEmpty() bool {
	return vasrlr.Value == nil || len(*vasrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) hasNextLink() bool {
	return vasrlr.NextLink != nil && len(*vasrlr.NextLink) != 0
}

// vulnerabilityAssessmentScanRecordListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) vulnerabilityAssessmentScanRecordListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vasrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vasrlr.NextLink)))
}

// VulnerabilityAssessmentScanRecordListResultPage contains a page of VulnerabilityAssessmentScanRecord
// values.
type VulnerabilityAssessmentScanRecordListResultPage struct {
	fn     func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)
	vasrlr VulnerabilityAssessmentScanRecordListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VulnerabilityAssessmentScanRecordListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vasrlr)
		if err != nil {
			return err
		}
		page.vasrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VulnerabilityAssessmentScanRecordListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VulnerabilityAssessmentScanRecordListResultPage) NotDone() bool {
	return !page.vasrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VulnerabilityAssessmentScanRecordListResultPage) Response() VulnerabilityAssessmentScanRecordListResult {
	return page.vasrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VulnerabilityAssessmentScanRecordListResultPage) Values() []VulnerabilityAssessmentScanRecord {
	if page.vasrlr.IsEmpty() {
		return nil
	}
	return *page.vasrlr.Value
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultPage type.
func NewVulnerabilityAssessmentScanRecordListResultPage(cur VulnerabilityAssessmentScanRecordListResult, getNextPage func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)) VulnerabilityAssessmentScanRecordListResultPage {
	return VulnerabilityAssessmentScanRecordListResultPage{
		fn:     getNextPage,
		vasrlr: cur,
	}
}

// VulnerabilityAssessmentScanRecordProperties properties of a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecordProperties struct {
	// ScanID - READ-ONLY; The scan ID.
	ScanID *string `json:"scanId,omitempty"`
	// TriggerType - READ-ONLY; The scan trigger type. Possible values include: 'OnDemand', 'Recurring'
	TriggerType VulnerabilityAssessmentScanTriggerType `json:"triggerType,omitempty"`
	// State - READ-ONLY; The scan status. Possible values include: 'VulnerabilityAssessmentScanStatePassed', 'VulnerabilityAssessmentScanStateFailed', 'VulnerabilityAssessmentScanStateFailedToRun', 'VulnerabilityAssessmentScanStateInProgress'
	State VulnerabilityAssessmentScanState `json:"state,omitempty"`
	// StartTime - READ-ONLY; The scan start time (UTC).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The scan end time (UTC).
	EndTime *date.Time `json:"endTime,omitempty"`
	// Errors - READ-ONLY; The scan errors.
	Errors *[]VulnerabilityAssessmentScanError `json:"errors,omitempty"`
	// StorageContainerPath - READ-ONLY; The scan results storage container path.
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// NumberOfFailedSecurityChecks - READ-ONLY; The number of failed security checks.
	NumberOfFailedSecurityChecks *int32 `json:"numberOfFailedSecurityChecks,omitempty"`
}

// MarshalJSON is the custom marshaler for VulnerabilityAssessmentScanRecordProperties.
func (vasrp VulnerabilityAssessmentScanRecordProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
