
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/elem.hpp>
#include <boost/vmd/enum.hpp>
#include <boost/vmd/equal.hpp>
#include <boost/vmd/get_type.hpp>
#include <boost/vmd/is_empty_array.hpp>
#include <boost/vmd/to_array.hpp>
#include <boost/vmd/to_list.hpp>
#include <boost/vmd/to_seq.hpp>
#include <boost/vmd/to_tuple.hpp>
#include <boost/preprocessor/array/elem.hpp>
#include <boost/preprocessor/list/at.hpp>
#include <boost/preprocessor/tuple/elem.hpp>
#include <boost/preprocessor/variadic/elem.hpp>
#include <boost/detail/lightweight_test.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS
 
 #define TUPLE_IS_ARRAY (2,(3,4))
 #define TUPLE_IS_LIST (anydata,BOOST_PP_NIL)
 #define TUPLE_IS_LIST_OR_ARRAY (2,(3,BOOST_PP_NIL))
 #define TUPLE_BUT_INVALID_ARRAY (&2,(3,4))
 #define TUPLE_BUT_INVALID_LIST (anydata,^BOOST_PP_NIL)
 #define SEQUENCE_EMPTY
 #define SEQUENCE_MULTI TUPLE_BUT_INVALID_ARRAY TUPLE_BUT_INVALID_LIST

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_ARRAY),BOOST_VMD_TYPE_ARRAY));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_ARRAY,BOOST_VMD_RETURN_TYPE_TUPLE),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_ARRAY,BOOST_VMD_RETURN_TYPE_ARRAY),BOOST_VMD_TYPE_ARRAY));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_ARRAY,BOOST_VMD_RETURN_TYPE_LIST),BOOST_VMD_TYPE_TUPLE));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST),BOOST_VMD_TYPE_LIST));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST,BOOST_VMD_RETURN_TYPE_TUPLE),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST,BOOST_VMD_RETURN_TYPE_ARRAY),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST,BOOST_VMD_RETURN_TYPE_LIST),BOOST_VMD_TYPE_LIST));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST_OR_ARRAY),BOOST_VMD_TYPE_LIST));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST_OR_ARRAY,BOOST_VMD_RETURN_TYPE_TUPLE),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST_OR_ARRAY,BOOST_VMD_RETURN_TYPE_ARRAY),BOOST_VMD_TYPE_ARRAY));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_IS_LIST_OR_ARRAY,BOOST_VMD_RETURN_TYPE_LIST),BOOST_VMD_TYPE_LIST));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_BUT_INVALID_ARRAY,BOOST_VMD_RETURN_TYPE_TUPLE),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_BUT_INVALID_ARRAY,BOOST_VMD_RETURN_TYPE_LIST),BOOST_VMD_TYPE_TUPLE));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_BUT_INVALID_LIST,BOOST_VMD_RETURN_TYPE_TUPLE),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(TUPLE_BUT_INVALID_LIST,BOOST_VMD_RETURN_TYPE_ARRAY),BOOST_VMD_TYPE_TUPLE));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(SEQUENCE_EMPTY,BOOST_VMD_RETURN_TYPE_TUPLE),BOOST_VMD_TYPE_EMPTY));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(SEQUENCE_MULTI,BOOST_VMD_RETURN_TYPE_ARRAY),BOOST_VMD_TYPE_SEQUENCE));
 
 #define BOOST_VMD_REGISTER_ANID (ANID)
 #define BOOST_VMD_REGISTER_data (data)
 #define BOOST_VMD_REGISTER_more_data (more_data)
 #define BOOST_VMD_DETECT_ANID_ANID
 #define BOOST_VMD_DETECT_data_data
 #define BOOST_VMD_DETECT_more_data_more_data
 #define SEQUENCE_EMPTY_1
 #define SEQUENCE_SINGLE 35
 #define SEQUENCE_SINGLE_ID ANID
 #define SEQUENCE_SINGLE_ARRAY (3,(0,1,2))
 #define SEQUENCE_SINGLE_LIST (data,(more_data,BOOST_PP_NIL))
 #define SEQUENCE_MULTI_1 (0,1) (2)(3)(4)
 #define SEQUENCE_MULTI_2 BOOST_VMD_TYPE_SEQ (2,(5,6))
 
 BOOST_TEST(BOOST_VMD_IS_EMPTY_ARRAY(BOOST_VMD_TO_ARRAY(SEQUENCE_EMPTY_1)));
 BOOST_TEST(BOOST_VMD_IS_EMPTY_ARRAY(BOOST_VMD_TO_ARRAY(SEQUENCE_EMPTY_1,BOOST_VMD_RETURN_TYPE)));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_LIST(SEQUENCE_SINGLE),(35,BOOST_PP_NIL)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_LIST(SEQUENCE_SINGLE,BOOST_VMD_RETURN_TYPE),((BOOST_VMD_TYPE_NUMBER,35),BOOST_PP_NIL)));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_SEQ(SEQUENCE_SINGLE_ID),(ANID)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_SEQ(SEQUENCE_SINGLE_ID,BOOST_VMD_RETURN_TYPE),((BOOST_VMD_TYPE_IDENTIFIER,ANID))));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_TUPLE(SEQUENCE_SINGLE_ARRAY),((3,(0,1,2)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_TUPLE(SEQUENCE_SINGLE_ARRAY,BOOST_VMD_RETURN_TYPE),((BOOST_VMD_TYPE_ARRAY,(3,(0,1,2))))));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ENUM(SEQUENCE_SINGLE_LIST),(data,(more_data,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ENUM(SEQUENCE_SINGLE_LIST,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_LIST,(data,(more_data,BOOST_PP_NIL)))));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_TUPLE(SEQUENCE_MULTI_1),((0,1),(2)(3)(4))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_TUPLE(SEQUENCE_MULTI_1,BOOST_VMD_RETURN_TYPE),((BOOST_VMD_TYPE_TUPLE,(0,1)),(BOOST_VMD_TYPE_SEQ,(2)(3)(4)))));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_VARIADIC_ELEM(0,BOOST_VMD_ENUM(SEQUENCE_MULTI_2)),BOOST_VMD_TYPE_SEQ));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_VARIADIC_ELEM(1,BOOST_VMD_ENUM(SEQUENCE_MULTI_2)),(2,(5,6))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_VARIADIC_ELEM(0,BOOST_VMD_ENUM(SEQUENCE_MULTI_2,BOOST_VMD_RETURN_TYPE)),(BOOST_VMD_TYPE_TYPE,BOOST_VMD_TYPE_SEQ)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_VARIADIC_ELEM(1,BOOST_VMD_ENUM(SEQUENCE_MULTI_2,BOOST_VMD_RETURN_TYPE)),(BOOST_VMD_TYPE_ARRAY,(2,(5,6)))));
 
 #define BOOST_VMD_REGISTER_anydata (anydata)
 #define BOOST_VMD_DETECT_anydata_anydata
 #define TUPLE_IS_VALID_ARRAY (2,(3,4))
 #define TUPLE_IS_VALID_LIST (anydata,BOOST_PP_NIL)
 #define TUPLE_BUT_INVALID_ARRAY_2 (&2,(3,4))
 #define TUPLE_BUT_INVALID_LIST_2 (anydata,^BOOST_PP_NIL)
 
 #define SEQUENCE_MULTI_T1 TUPLE_IS_VALID_ARRAY TUPLE_IS_VALID_LIST
 #define SEQUENCE_MULTI_T2 TUPLE_BUT_INVALID_ARRAY_2 TUPLE_IS_VALID_LIST
 #define SEQUENCE_MULTI_T3 TUPLE_IS_VALID_ARRAY TUPLE_BUT_INVALID_LIST_2
 #define SEQUENCE_MULTI_T4 TUPLE_BUT_INVALID_ARRAY_2 TUPLE_BUT_INVALID_LIST_2
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_SEQ(SEQUENCE_MULTI_T1,BOOST_VMD_RETURN_TYPE),((BOOST_VMD_TYPE_ARRAY,(2,(3,4)))) ((BOOST_VMD_TYPE_LIST,(anydata,BOOST_PP_NIL)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_SEQ(SEQUENCE_MULTI_T1,BOOST_VMD_RETURN_TYPE_ARRAY),((BOOST_VMD_TYPE_ARRAY,(2,(3,4)))) ((BOOST_VMD_TYPE_TUPLE,(anydata,BOOST_PP_NIL)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_SEQ(SEQUENCE_MULTI_T1,BOOST_VMD_RETURN_TYPE_LIST),((BOOST_VMD_TYPE_TUPLE,(2,(3,4)))) ((BOOST_VMD_TYPE_LIST,(anydata,BOOST_PP_NIL)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_TO_SEQ(SEQUENCE_MULTI_T1,BOOST_VMD_RETURN_TYPE_TUPLE),((BOOST_VMD_TYPE_TUPLE,(2,(3,4)))) ((BOOST_VMD_TYPE_TUPLE,(anydata,BOOST_PP_NIL)))));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_TO_TUPLE(SEQUENCE_MULTI_T2,BOOST_VMD_RETURN_TYPE_LIST))),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_TO_TUPLE(SEQUENCE_MULTI_T2,BOOST_VMD_RETURN_TYPE_LIST))),BOOST_VMD_TYPE_LIST));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_TO_TUPLE(SEQUENCE_MULTI_T2,BOOST_VMD_RETURN_TYPE_TUPLE))),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_TUPLE_ELEM(1,BOOST_VMD_TO_TUPLE(SEQUENCE_MULTI_T2,BOOST_VMD_RETURN_TYPE_TUPLE))),BOOST_VMD_TYPE_TUPLE));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_ARRAY_ELEM(0,BOOST_VMD_TO_ARRAY(SEQUENCE_MULTI_T3,BOOST_VMD_RETURN_TYPE_ARRAY))),BOOST_VMD_TYPE_ARRAY));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_ARRAY_ELEM(1,BOOST_VMD_TO_ARRAY(SEQUENCE_MULTI_T3,BOOST_VMD_RETURN_TYPE_ARRAY))),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_ARRAY_ELEM(0,BOOST_VMD_TO_ARRAY(SEQUENCE_MULTI_T3,BOOST_VMD_RETURN_TYPE_TUPLE))),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_ARRAY_ELEM(1,BOOST_VMD_TO_ARRAY(SEQUENCE_MULTI_T3,BOOST_VMD_RETURN_TYPE_TUPLE))),BOOST_VMD_TYPE_TUPLE));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_LIST_AT(BOOST_VMD_TO_LIST(SEQUENCE_MULTI_T4,BOOST_VMD_RETURN_TYPE_TUPLE),0)),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_PP_LIST_AT(BOOST_VMD_TO_LIST(SEQUENCE_MULTI_T4,BOOST_VMD_RETURN_TYPE_TUPLE),1)),BOOST_VMD_TYPE_TUPLE));
 
 #define BOOST_VMD_REGISTER_ANID_E (ANID_E)
 #define BOOST_VMD_DETECT_ANID_E_ANID_E
 #define SEQUENCE_SINGLE_E 35
 #define SEQUENCE_SINGLE_E2 ANID_E
 #define SEQUENCE_MULTI_E (0,1) (2)(3)(4)
 #define SEQUENCE_MULTI_E_2 BOOST_VMD_TYPE_SEQ (2,(5,6))
 
 BOOST_TEST_EQ(BOOST_VMD_ELEM(0,SEQUENCE_SINGLE_E),35);
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_SINGLE_E,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_NUMBER,35)));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_SINGLE_E2),ANID_E));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_SINGLE_E2,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_IDENTIFIER,ANID_E)));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E),(2)(3)(4)));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_SEQ,(2)(3)(4))));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E_2),BOOST_VMD_TYPE_SEQ));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E_2,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_TYPE,BOOST_VMD_TYPE_SEQ)));

 #define TUPLE_IS_VALID_ARRAY_E (2,(3,4))
 #define TUPLE_IS_VALID_LIST_E (anydata,BOOST_PP_NIL)
 #define TUPLE_BUT_INVALID_ARRAY_E (&2,(3,4))
 #define TUPLE_BUT_INVALID_LIST_E (anydata,^BOOST_PP_NIL)
 
 #define SEQUENCE_MULTI_E1 TUPLE_IS_VALID_ARRAY_E TUPLE_IS_VALID_LIST_E
 #define SEQUENCE_MULTI_E2 TUPLE_BUT_INVALID_ARRAY_E TUPLE_IS_VALID_LIST_E
 #define SEQUENCE_MULTI_E3 TUPLE_IS_VALID_ARRAY_E TUPLE_BUT_INVALID_LIST_E
 #define SEQUENCE_MULTI_E4 TUPLE_BUT_INVALID_ARRAY_E TUPLE_BUT_INVALID_LIST_E
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_ARRAY,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE_ARRAY),(BOOST_VMD_TYPE_ARRAY,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE_LIST),(BOOST_VMD_TYPE_TUPLE,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE_TUPLE),(BOOST_VMD_TYPE_TUPLE,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_LIST,(anydata,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE_ARRAY),(BOOST_VMD_TYPE_TUPLE,(anydata,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE_LIST),(BOOST_VMD_TYPE_LIST,(anydata,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E1,BOOST_VMD_RETURN_TYPE_TUPLE),(BOOST_VMD_TYPE_TUPLE,(anydata,BOOST_PP_NIL))));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E2,BOOST_VMD_RETURN_TYPE_LIST)),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E2,BOOST_VMD_RETURN_TYPE_TUPLE)),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E2,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_LIST,(anydata,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E2,BOOST_VMD_RETURN_TYPE_ARRAY),(BOOST_VMD_TYPE_TUPLE,(anydata,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E2,BOOST_VMD_RETURN_TYPE_LIST),(BOOST_VMD_TYPE_LIST,(anydata,BOOST_PP_NIL))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E2,BOOST_VMD_RETURN_TYPE_TUPLE),(BOOST_VMD_TYPE_TUPLE,(anydata,BOOST_PP_NIL))));
 
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E3,BOOST_VMD_RETURN_TYPE),(BOOST_VMD_TYPE_ARRAY,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E3,BOOST_VMD_RETURN_TYPE_ARRAY),(BOOST_VMD_TYPE_ARRAY,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E3,BOOST_VMD_RETURN_TYPE_LIST),(BOOST_VMD_TYPE_TUPLE,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E3,BOOST_VMD_RETURN_TYPE_TUPLE),(BOOST_VMD_TYPE_TUPLE,(2,(3,4)))));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E3,BOOST_VMD_RETURN_TYPE_ARRAY)),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E3,BOOST_VMD_RETURN_TYPE_TUPLE)),BOOST_VMD_TYPE_TUPLE));

 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E4,BOOST_VMD_RETURN_TYPE_LIST)),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(0,SEQUENCE_MULTI_E4,BOOST_VMD_RETURN_TYPE_TUPLE)),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E4,BOOST_VMD_RETURN_TYPE_ARRAY)),BOOST_VMD_TYPE_TUPLE));
 BOOST_TEST(BOOST_VMD_EQUAL(BOOST_PP_TUPLE_ELEM(0,BOOST_VMD_ELEM(1,SEQUENCE_MULTI_E4,BOOST_VMD_RETURN_TYPE_TUPLE)),BOOST_VMD_TYPE_TUPLE));
 
#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
