/* gpx-viewer-mapwidget.c generated by valac 0.20.1, the Vala compiler
 * generated from gpx-viewer-mapwidget.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2011 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "gpx.h"
#include <champlain/champlain.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <champlain-gtk/champlain-gtk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _GpxViewerMapViewPrivate {
	ChamplainView* view;
	ClutterColor waypoint_color;
	ChamplainMarker* click_marker;
	ChamplainMarkerLayer* waypoint_layer;
	gboolean _show_waypoints;
	ChamplainMarkerLayer* marker_layer;
	gboolean _show_markers;
	GtkListStore* map_source_list;
	gchar* _map_source;
};


static gpointer gpx_viewer_map_view_parent_class = NULL;

#define GPX_VIEWER_MAP_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapViewPrivate))
enum  {
	GPX_VIEWER_MAP_VIEW_DUMMY_PROPERTY,
	GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS,
	GPX_VIEWER_MAP_VIEW_SHOW_MARKERS,
	GPX_VIEWER_MAP_VIEW_MAP_SOURCE
};
static void __lambda2_ (GpxViewerMapView* self);
static void ___lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gpx_viewer_map_view_button_press_callback (GpxViewerMapView* self, ClutterButtonEvent* event);
static gboolean _gpx_viewer_map_view_button_press_callback_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static void gpx_viewer_map_view_switch_map_source (GpxViewerMapView* self, const gchar* id);
static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gpx_viewer_map_view_finalize (GObject* obj);
static void _vala_gpx_viewer_map_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gpx_viewer_map_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


ChamplainMarker* gpx_viewer_map_view_create_marker (GpxViewerMapView* self, GpxPoint* p, const gchar* icon, gint size) {
	ChamplainMarker* result = NULL;
	ChamplainLabel* marker;
	GtkIconTheme* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gint _tmp2_;
	GtkIconInfo* _tmp3_ = NULL;
	GtkIconInfo* info;
	GtkIconInfo* _tmp4_;
	ChamplainLabel* _tmp17_;
	ChamplainLabel* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	ChamplainLabel* _tmp22_;
	GpxPoint* _tmp23_;
	gdouble _tmp24_;
	GpxPoint* _tmp25_;
	gdouble _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	marker = NULL;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = icon;
	_tmp2_ = size;
	_tmp3_ = gtk_icon_theme_lookup_icon (_tmp0_, _tmp1_, _tmp2_, 0);
	info = _tmp3_;
	_tmp4_ = info;
	if (_tmp4_ != NULL) {
		GtkIconInfo* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* path;
		const gchar* _tmp8_;
		_tmp5_ = info;
		_tmp6_ = gtk_icon_info_get_filename (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		path = _tmp7_;
		_tmp8_ = path;
		if (_tmp8_ != NULL) {
			ChamplainLabel* _tmp14_;
			{
				const gchar* _tmp9_;
				ChamplainLabel* _tmp10_;
				ChamplainLabel* _tmp11_;
				_tmp9_ = path;
				_tmp10_ = (ChamplainLabel*) champlain_label_new_from_file (_tmp9_, &_inner_error_);
				g_object_ref_sink (_tmp10_);
				_tmp11_ = _tmp10_;
				if (_inner_error_ != NULL) {
					goto __catch15_g_error;
				}
				g_object_ref_sink (_tmp11_);
				_g_object_unref0 (marker);
				marker = _tmp11_;
			}
			goto __finally15;
			__catch15_g_error:
			{
				GError* e = NULL;
				GError* _tmp12_;
				const gchar* _tmp13_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp12_ = e;
				_tmp13_ = _tmp12_->message;
				g_warning ("gpx-viewer-mapwidget.vala:53: %s", _tmp13_);
				_g_error_free0 (e);
			}
			__finally15:
			if (_inner_error_ != NULL) {
				_g_free0 (path);
				_gtk_icon_info_free0 (info);
				_g_object_unref0 (marker);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp14_ = marker;
			champlain_label_set_draw_background (_tmp14_, FALSE);
		}
		_g_free0 (path);
	} else {
		FILE* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = stdout;
		_tmp16_ = icon;
		fprintf (_tmp15_, "Info is null: %s\n", _tmp16_);
	}
	_tmp17_ = marker;
	if (_tmp17_ == NULL) {
		ChamplainLabel* _tmp18_;
		_tmp18_ = (ChamplainLabel*) champlain_label_new ();
		g_object_ref_sink (_tmp18_);
		_g_object_unref0 (marker);
		marker = _tmp18_;
	}
	_tmp19_ = marker;
	_tmp20_ = size;
	_tmp21_ = size;
	clutter_actor_set_size ((ClutterActor*) _tmp19_, (gfloat) _tmp20_, (gfloat) _tmp21_);
	_tmp22_ = marker;
	_tmp23_ = p;
	_tmp24_ = _tmp23_->lat_dec;
	_tmp25_ = p;
	_tmp26_ = _tmp25_->lon_dec;
	champlain_location_set_location ((ChamplainLocation*) _tmp22_, (gdouble) ((gfloat) _tmp24_), (gdouble) ((gfloat) _tmp26_));
	result = (ChamplainMarker*) marker;
	_gtk_icon_info_free0 (info);
	return result;
}


/**
 * Show marker at Point
 */
void gpx_viewer_map_view_click_marker_show (GpxViewerMapView* self, GpxPoint* p) {
	ChamplainMarker* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->click_marker;
	if (_tmp0_ == NULL) {
		GpxPoint* _tmp1_;
		ChamplainMarker* _tmp2_ = NULL;
		ChamplainMarker* _tmp3_;
		ChamplainMarker* _tmp4_;
		_tmp1_ = p;
		_tmp2_ = gpx_viewer_map_view_create_marker (self, _tmp1_, "pin-blue", 100);
		_g_object_unref0 (self->priv->click_marker);
		self->priv->click_marker = _tmp2_;
		_tmp3_ = self->priv->click_marker;
		gpx_viewer_map_view_add_marker (self, _tmp3_);
		_tmp4_ = self->priv->click_marker;
		clutter_actor_show ((ClutterActor*) _tmp4_);
	} else {
		ChamplainMarker* _tmp5_;
		GpxPoint* _tmp6_;
		gdouble _tmp7_;
		GpxPoint* _tmp8_;
		gdouble _tmp9_;
		ChamplainMarker* _tmp10_;
		_tmp5_ = self->priv->click_marker;
		_tmp6_ = p;
		_tmp7_ = _tmp6_->lat_dec;
		_tmp8_ = p;
		_tmp9_ = _tmp8_->lon_dec;
		champlain_location_set_location ((ChamplainLocation*) _tmp5_, (gdouble) ((gfloat) _tmp7_), (gdouble) ((gfloat) _tmp9_));
		_tmp10_ = self->priv->click_marker;
		clutter_actor_show ((ClutterActor*) _tmp10_);
	}
}


void gpx_viewer_map_view_click_marker_hide (GpxViewerMapView* self) {
	ChamplainMarker* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->click_marker;
	clutter_actor_hide ((ClutterActor*) _tmp0_);
}


void gpx_viewer_map_view_add_waypoint (GpxViewerMapView* self, GpxPoint* p) {
	GpxPoint* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ClutterColor _tmp3_;
	ChamplainLabel* _tmp4_;
	ChamplainMarker* marker;
	GpxPoint* _tmp5_;
	gdouble _tmp6_;
	GpxPoint* _tmp7_;
	gdouble _tmp8_;
	ChamplainMarkerLayer* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	_tmp1_ = gpx_point_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->waypoint_color;
	_tmp4_ = (ChamplainLabel*) champlain_label_new_with_text (_tmp2_, "Serif 12", NULL, &_tmp3_);
	g_object_ref_sink (_tmp4_);
	marker = (ChamplainMarker*) _tmp4_;
	_tmp5_ = p;
	_tmp6_ = _tmp5_->lat_dec;
	_tmp7_ = p;
	_tmp8_ = _tmp7_->lon_dec;
	champlain_location_set_location ((ChamplainLocation*) marker, _tmp6_, _tmp8_);
	_tmp9_ = self->priv->waypoint_layer;
	champlain_marker_layer_add_marker (_tmp9_, marker);
	_g_object_unref0 (marker);
}


void gpx_viewer_map_view_add_marker (GpxViewerMapView* self, ChamplainMarker* marker) {
	ChamplainMarkerLayer* _tmp0_;
	ChamplainMarker* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (marker != NULL);
	_tmp0_ = self->priv->marker_layer;
	_tmp1_ = marker;
	champlain_marker_layer_add_marker (_tmp0_, _tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GtkTreeModel* gpx_viewer_map_view_get_model (GpxViewerMapView* self) {
	GtkTreeModel* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->map_source_list;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}


static void __lambda2_ (GpxViewerMapView* self) {
	ChamplainView* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	ChamplainView* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	ChamplainView* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	_tmp0_ = self->priv->view;
	_tmp1_ = champlain_view_get_zoom_level (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->view;
	_tmp4_ = champlain_view_get_min_zoom_level (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->view;
	_tmp7_ = champlain_view_get_max_zoom_level (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_emit_by_name (self, "zoom-level-changed", _tmp2_, _tmp5_, _tmp8_);
}


static void ___lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda2_ (self);
}


static gboolean _gpx_viewer_map_view_button_press_callback_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = gpx_viewer_map_view_button_press_callback (self, event);
	return result;
}


GpxViewerMapView* gpx_viewer_map_view_construct (GType object_type) {
	GpxViewerMapView * self = NULL;
	ChamplainView* _tmp0_ = NULL;
	FILE* _tmp1_;
	ChamplainView* _tmp2_;
	ChamplainMapSourceFactory* _tmp3_ = NULL;
	ChamplainMapSourceFactory* fact;
	ChamplainMapSourceFactory* _tmp4_;
	GSList* _tmp5_ = NULL;
	GSList* l;
	GSList* _tmp6_;
	ChamplainView* _tmp22_;
	ChamplainView* _tmp23_;
	ChamplainMarkerLayer* _tmp24_;
	ChamplainView* _tmp25_;
	ChamplainMarkerLayer* _tmp26_;
	ChamplainMarkerLayer* _tmp27_;
	ChamplainView* _tmp28_;
	ChamplainView* _tmp29_;
	self = (GpxViewerMapView*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_champlain_embed_get_view ((GtkChamplainEmbed*) self);
	self->priv->view = _tmp0_;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "MapView init\n");
	self->priv->waypoint_color.red = (guint8) 0xf3;
	self->priv->waypoint_color.green = (guint8) 0x94;
	self->priv->waypoint_color.blue = (guint8) 0x07;
	self->priv->waypoint_color.alpha = (guint8) 0xff;
	_tmp2_ = self->priv->view;
	champlain_view_set_kinetic_mode (_tmp2_, TRUE);
	_tmp3_ = champlain_map_source_factory_dup_default ();
	fact = _tmp3_;
	_tmp4_ = fact;
	_tmp5_ = champlain_map_source_factory_get_registered (_tmp4_);
	l = _tmp5_;
	_tmp6_ = l;
	{
		GSList* a_collection = NULL;
		GSList* a_it = NULL;
		a_collection = _tmp6_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ChamplainMapSourceDesc* a = NULL;
			a = (ChamplainMapSourceDesc*) a_it->data;
			{
				GtkTreeIter iter = {0};
				const gchar* _tmp7_;
				GtkListStore* _tmp12_;
				GtkTreeIter _tmp13_ = {0};
				GtkListStore* _tmp14_;
				GtkTreeIter _tmp15_;
				ChamplainMapSourceDesc* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				ChamplainMapSourceDesc* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp7_ = self->priv->_map_source;
				if (_tmp7_ == NULL) {
					ChamplainMapSourceDesc* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp8_ = a;
					_tmp9_ = champlain_map_source_desc_get_id (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strdup (_tmp10_);
					_g_free0 (self->priv->_map_source);
					self->priv->_map_source = _tmp11_;
				}
				_tmp12_ = self->priv->map_source_list;
				gtk_list_store_append (_tmp12_, &_tmp13_);
				iter = _tmp13_;
				_tmp14_ = self->priv->map_source_list;
				_tmp15_ = iter;
				_tmp16_ = a;
				_tmp17_ = champlain_map_source_desc_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = a;
				_tmp20_ = champlain_map_source_desc_get_id (_tmp19_);
				_tmp21_ = _tmp20_;
				gtk_list_store_set (_tmp14_, &_tmp15_, 0, _tmp18_, 1, _tmp21_, -1);
			}
		}
	}
	_tmp22_ = self->priv->view;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::zoom-level", (GCallback) ___lambda2__g_object_notify, self, 0);
	_tmp23_ = self->priv->view;
	_tmp24_ = self->priv->waypoint_layer;
	champlain_view_add_layer (_tmp23_, (ChamplainLayer*) _tmp24_);
	_tmp25_ = self->priv->view;
	_tmp26_ = self->priv->marker_layer;
	champlain_view_add_layer (_tmp25_, (ChamplainLayer*) _tmp26_);
	_tmp27_ = self->priv->marker_layer;
	clutter_actor_show ((ClutterActor*) _tmp27_);
	_tmp28_ = self->priv->view;
	clutter_actor_set_reactive ((ClutterActor*) _tmp28_, TRUE);
	_tmp29_ = self->priv->view;
	g_signal_connect_object ((ClutterActor*) _tmp29_, "button-release-event", (GCallback) _gpx_viewer_map_view_button_press_callback_clutter_actor_button_release_event, self, 0);
	_g_slist_free0 (l);
	_g_object_unref0 (fact);
	return self;
}


GpxViewerMapView* gpx_viewer_map_view_new (void) {
	return gpx_viewer_map_view_construct (GPX_VIEWER_TYPE_MAP_VIEW);
}


static gboolean gpx_viewer_map_view_button_press_callback (GpxViewerMapView* self, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	ClutterButtonEvent _tmp0_;
	guint32 _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint32) 3)) {
		gdouble lat = 0.0;
		gdouble lon = 0.0;
		ChamplainView* _tmp2_;
		ClutterButtonEvent _tmp3_;
		gfloat _tmp4_;
		gdouble _tmp5_ = 0.0;
		ChamplainView* _tmp6_;
		ClutterButtonEvent _tmp7_;
		gfloat _tmp8_;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp2_ = self->priv->view;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.y;
		_tmp5_ = champlain_view_y_to_latitude (_tmp2_, (gdouble) _tmp4_);
		lat = _tmp5_;
		_tmp6_ = self->priv->view;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.x;
		_tmp9_ = champlain_view_x_to_longitude (_tmp6_, (gdouble) _tmp8_);
		lon = _tmp9_;
		_tmp10_ = lat;
		_tmp11_ = lon;
		g_signal_emit_by_name (self, "clicked", _tmp10_, _tmp11_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void gpx_viewer_map_view_switch_map_source (GpxViewerMapView* self, const gchar* id) {
	ChamplainMapSourceFactory* _tmp0_ = NULL;
	ChamplainMapSourceFactory* fact;
	const gchar* _tmp1_;
	ChamplainMapSource* _tmp2_ = NULL;
	ChamplainMapSource* _tmp3_;
	ChamplainMapSource* source;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = champlain_map_source_factory_dup_default ();
	fact = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = champlain_map_source_factory_create_cached_source (fact, _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	source = _tmp3_;
	if (source != NULL) {
		ChamplainView* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		ChamplainView* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		ChamplainView* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		ChamplainView* _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		_tmp4_ = self->priv->view;
		champlain_view_set_map_source (_tmp4_, source);
		_tmp5_ = id;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->priv->_map_source);
		self->priv->_map_source = _tmp6_;
		_tmp7_ = self->priv->view;
		_tmp8_ = champlain_view_get_zoom_level (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->view;
		_tmp11_ = champlain_view_get_min_zoom_level (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->view;
		_tmp14_ = champlain_view_get_max_zoom_level (_tmp13_);
		_tmp15_ = _tmp14_;
		g_signal_emit_by_name (self, "zoom-level-changed", _tmp9_, _tmp12_, _tmp15_);
	} else {
		g_error ("gpx-viewer-mapwidget.vala:218: Failed to get map source");
	}
	_g_object_unref0 (source);
	_g_object_unref0 (fact);
}


gboolean gpx_viewer_map_view_get_show_waypoints (GpxViewerMapView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_waypoints;
	result = _tmp0_;
	return result;
}


void gpx_viewer_map_view_set_show_waypoints (GpxViewerMapView* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_) {
		ChamplainMarkerLayer* _tmp1_;
		_tmp1_ = self->priv->waypoint_layer;
		clutter_actor_show ((ClutterActor*) _tmp1_);
	} else {
		ChamplainMarkerLayer* _tmp2_;
		_tmp2_ = self->priv->waypoint_layer;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
	}
	_tmp3_ = value;
	self->priv->_show_waypoints = _tmp3_;
	g_object_notify ((GObject *) self, "show-waypoints");
}


gboolean gpx_viewer_map_view_get_show_markers (GpxViewerMapView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_markers;
	result = _tmp0_;
	return result;
}


void gpx_viewer_map_view_set_show_markers (GpxViewerMapView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_) {
		ChamplainMarkerLayer* _tmp1_;
		_tmp1_ = self->priv->marker_layer;
		clutter_actor_show ((ClutterActor*) _tmp1_);
	} else {
		ChamplainMarkerLayer* _tmp2_;
		_tmp2_ = self->priv->marker_layer;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
	}
	g_object_notify ((GObject *) self, "show-markers");
}


const gchar* gpx_viewer_map_view_get_map_source (GpxViewerMapView* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_map_source;
	result = _tmp0_;
	return result;
}


void gpx_viewer_map_view_set_map_source (GpxViewerMapView* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->priv->_map_source;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	gpx_viewer_map_view_switch_map_source (self, _tmp2_);
	g_object_notify ((GObject *) self, "map-source");
}


static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void gpx_viewer_map_view_class_init (GpxViewerMapViewClass * klass) {
	gpx_viewer_map_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GpxViewerMapViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gpx_viewer_map_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gpx_viewer_map_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = gpx_viewer_map_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS, g_param_spec_boolean ("show-waypoints", "show-waypoints", "show-waypoints", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_MAP_VIEW_SHOW_MARKERS, g_param_spec_boolean ("show-markers", "show-markers", "show-markers", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_MAP_VIEW_MAP_SOURCE, g_param_spec_string ("map-source", "map-source", "map-source", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * @param lat_dec the latitude of the click point in dec.
	 * @param lon_dec the longitude of the click point.
	 * 
	 * Fired when the users right or middle clicks on the  map.
	 */
	g_signal_new ("clicked", GPX_VIEWER_TYPE_MAP_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	/**
	 * @param zoom the current zoom level.
	 * @param min_zoom the minimum supported zoom level.
	 * @param max_zoom the maximum supported zoom level.
	 * 
	 * Fired when the zoomlevel changed.
	 */
	g_signal_new ("zoom_level_changed", GPX_VIEWER_TYPE_MAP_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
}


static void gpx_viewer_map_view_instance_init (GpxViewerMapView * self) {
	ChamplainMarkerLayer* _tmp0_;
	ChamplainMarkerLayer* _tmp1_;
	GtkListStore* _tmp2_;
	self->priv = GPX_VIEWER_MAP_VIEW_GET_PRIVATE (self);
	self->priv->view = NULL;
	self->priv->click_marker = NULL;
	_tmp0_ = champlain_marker_layer_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->waypoint_layer = _tmp0_;
	self->priv->_show_waypoints = FALSE;
	_tmp1_ = champlain_marker_layer_new ();
	g_object_ref_sink (_tmp1_);
	self->priv->marker_layer = _tmp1_;
	self->priv->_show_markers = TRUE;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	self->priv->map_source_list = _tmp2_;
	self->priv->_map_source = NULL;
}


static void gpx_viewer_map_view_finalize (GObject* obj) {
	GpxViewerMapView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapView);
	g_debug ("gpx-viewer-mapwidget.vala:225: Destroying map-view");
	_g_object_unref0 (self->priv->click_marker);
	_g_object_unref0 (self->priv->waypoint_layer);
	_g_object_unref0 (self->priv->marker_layer);
	_g_object_unref0 (self->priv->map_source_list);
	_g_free0 (self->priv->_map_source);
	G_OBJECT_CLASS (gpx_viewer_map_view_parent_class)->finalize (obj);
}


GType gpx_viewer_map_view_get_type (void) {
	static volatile gsize gpx_viewer_map_view_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_viewer_map_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpxViewerMapViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_viewer_map_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxViewerMapView), 0, (GInstanceInitFunc) gpx_viewer_map_view_instance_init, NULL };
		GType gpx_viewer_map_view_type_id;
		gpx_viewer_map_view_type_id = g_type_register_static (gtk_champlain_embed_get_type (), "GpxViewerMapView", &g_define_type_info, 0);
		g_once_init_leave (&gpx_viewer_map_view_type_id__volatile, gpx_viewer_map_view_type_id);
	}
	return gpx_viewer_map_view_type_id__volatile;
}


static void _vala_gpx_viewer_map_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GpxViewerMapView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapView);
	switch (property_id) {
		case GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS:
		g_value_set_boolean (value, gpx_viewer_map_view_get_show_waypoints (self));
		break;
		case GPX_VIEWER_MAP_VIEW_SHOW_MARKERS:
		g_value_set_boolean (value, gpx_viewer_map_view_get_show_markers (self));
		break;
		case GPX_VIEWER_MAP_VIEW_MAP_SOURCE:
		g_value_set_string (value, gpx_viewer_map_view_get_map_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gpx_viewer_map_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GpxViewerMapView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapView);
	switch (property_id) {
		case GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS:
		gpx_viewer_map_view_set_show_waypoints (self, g_value_get_boolean (value));
		break;
		case GPX_VIEWER_MAP_VIEW_SHOW_MARKERS:
		gpx_viewer_map_view_set_show_markers (self, g_value_get_boolean (value));
		break;
		case GPX_VIEWER_MAP_VIEW_MAP_SOURCE:
		gpx_viewer_map_view_set_map_source (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



