/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.selector.DefaultContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import org.slf4j.ILoggerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.spi.LoggerFactoryBinder;

public class StaticLoggerBinder
implements LoggerFactoryBinder {
    private ContextSelector contextSelector;
    static final String NULL_CS_URL = "http://logback.qos.ch/codes.html#null_CS";
    public static final StaticLoggerBinder SINGLETON = new StaticLoggerBinder();
    private static final String loggerFactoryClassStr = ContextSelector.class.getName();

    private StaticLoggerBinder() {
        this.initialize();
    }

    public void initialize() {
        try {
            LoggerContext defaultLoggerContext = new LoggerContext();
            defaultLoggerContext.setName("default");
            try {
                ContextInitializer.autoConfig(defaultLoggerContext);
            }
            catch (JoranException je) {
                Util.reportFailure((String)"Failed to auto configure default logger context", (Throwable)je);
                StatusPrinter.print((Context)defaultLoggerContext);
            }
            String contextSelectorStr = OptionHelper.getSystemProperty((String)"logback.ContextSelector", null);
            if (contextSelectorStr == null) {
                this.contextSelector = new DefaultContextSelector(defaultLoggerContext);
            } else if (contextSelectorStr.equals("JNDI")) {
                this.contextSelector = new ContextJNDISelector(defaultLoggerContext);
            }
        }
        catch (Throwable t) {
            Util.reportFailure((String)("Failed to instantiate [" + LoggerContext.class.getName() + "]"), (Throwable)t);
        }
    }

    public ILoggerFactory getLoggerFactory() {
        if (this.contextSelector == null) {
            throw new IllegalStateException("contextSelector cannot be null. See also http://logback.qos.ch/codes.html#null_CS");
        }
        return this.contextSelector.getLoggerContext();
    }

    public String getLoggerFactoryClassStr() {
        return loggerFactoryClassStr;
    }

    public ContextSelector getContextSelector() {
        return this.contextSelector;
    }
}

