package components

var CRDsValidation map[string]string = map[string]string{
	"datavolumetemplatespec": `openAPIV3Schema:
  nullable: true
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: DataVolumeSpec contains the DataVolume specification.
      properties:
        checkpoints:
          description: Checkpoints is a list of DataVolumeCheckpoints, representing
            stages in a multistage import.
          items:
            description: DataVolumeCheckpoint defines a stage in a warm migration.
            properties:
              current:
                description: Current is the identifier of the snapshot created for
                  this checkpoint.
                type: string
              previous:
                description: Previous is the identifier of the snapshot from the previous
                  checkpoint.
                type: string
            required:
            - current
            - previous
            type: object
          type: array
        contentType:
          description: 'DataVolumeContentType options: "kubevirt", "archive"'
          enum:
          - kubevirt
          - archive
          type: string
        finalCheckpoint:
          description: FinalCheckpoint indicates whether the current DataVolumeCheckpoint
            is the final checkpoint.
          type: boolean
        preallocation:
          description: Preallocation controls whether storage for DataVolumes should
            be allocated in advance.
          type: boolean
        priorityClassName:
          description: PriorityClassName for Importer, Cloner and Uploader pod
          type: string
        pvc:
          description: PVC is the PVC specification
          properties:
            accessModes:
              description: |-
                accessModes contains the desired access modes the volume should have.
                More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
              items:
                type: string
              type: array
              x-kubernetes-list-type: atomic
            dataSource:
              description: |-
                dataSource field can be used to specify either:
                * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot)
                * An existing PVC (PersistentVolumeClaim)
                If the provisioner or an external controller can support the specified data source,
                it will create a new volume based on the contents of the specified data source.
                When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef,
                and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified.
                If the namespace is specified, then dataSourceRef will not be copied to dataSource.
              properties:
                apiGroup:
                  description: |-
                    APIGroup is the group for the resource being referenced.
                    If APIGroup is not specified, the specified Kind must be in the core API group.
                    For any other third-party types, APIGroup is required.
                  type: string
                kind:
                  description: Kind is the type of resource being referenced
                  type: string
                name:
                  description: Name is the name of resource being referenced
                  type: string
              required:
              - kind
              - name
              type: object
              x-kubernetes-map-type: atomic
            dataSourceRef:
              description: |-
                dataSourceRef specifies the object from which to populate the volume with data, if a non-empty
                volume is desired. This may be any object from a non-empty API group (non
                core object) or a PersistentVolumeClaim object.
                When this field is specified, volume binding will only succeed if the type of
                the specified object matches some installed volume populator or dynamic
                provisioner.
                This field will replace the functionality of the dataSource field and as such
                if both fields are non-empty, they must have the same value. For backwards
                compatibility, when namespace isn't specified in dataSourceRef,
                both fields (dataSource and dataSourceRef) will be set to the same
                value automatically if one of them is empty and the other is non-empty.
                When namespace is specified in dataSourceRef,
                dataSource isn't set to the same value and must be empty.
                There are three important differences between dataSource and dataSourceRef:
                * While dataSource only allows two specific types of objects, dataSourceRef
                  allows any non-core object, as well as PersistentVolumeClaim objects.
                * While dataSource ignores disallowed values (dropping them), dataSourceRef
                  preserves all values, and generates an error if a disallowed value is
                  specified.
                * While dataSource only allows local objects, dataSourceRef allows objects
                  in any namespaces.
                (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
                (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
              properties:
                apiGroup:
                  description: |-
                    APIGroup is the group for the resource being referenced.
                    If APIGroup is not specified, the specified Kind must be in the core API group.
                    For any other third-party types, APIGroup is required.
                  type: string
                kind:
                  description: Kind is the type of resource being referenced
                  type: string
                name:
                  description: Name is the name of resource being referenced
                  type: string
                namespace:
                  description: |-
                    Namespace is the namespace of resource being referenced
                    Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details.
                    (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
                  type: string
              required:
              - kind
              - name
              type: object
            resources:
              description: |-
                resources represents the minimum resources the volume should have.
                If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements
                that are lower than previous value but must still be higher than capacity recorded in the
                status field of the claim.
                More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
              properties:
                limits:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Limits describes the maximum amount of compute resources allowed.
                    More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                  type: object
                requests:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Requests describes the minimum amount of compute resources required.
                    If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
                    otherwise to an implementation-defined value. Requests cannot exceed Limits.
                    More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                  type: object
              type: object
            selector:
              description: selector is a label query over volumes to consider for
                binding.
              properties:
                matchExpressions:
                  description: matchExpressions is a list of label selector requirements.
                    The requirements are ANDed.
                  items:
                    description: |-
                      A label selector requirement is a selector that contains values, a key, and an operator that
                      relates the key and values.
                    properties:
                      key:
                        description: key is the label key that the selector applies
                          to.
                        type: string
                      operator:
                        description: |-
                          operator represents a key's relationship to a set of values.
                          Valid operators are In, NotIn, Exists and DoesNotExist.
                        type: string
                      values:
                        description: |-
                          values is an array of string values. If the operator is In or NotIn,
                          the values array must be non-empty. If the operator is Exists or DoesNotExist,
                          the values array must be empty. This array is replaced during a strategic
                          merge patch.
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                    required:
                    - key
                    - operator
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                matchLabels:
                  additionalProperties:
                    type: string
                  description: |-
                    matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                    map is equivalent to an element of matchExpressions, whose key field is "key", the
                    operator is "In", and the values array contains only "value". The requirements are ANDed.
                  type: object
              type: object
              x-kubernetes-map-type: atomic
            storageClassName:
              description: |-
                storageClassName is the name of the StorageClass required by the claim.
                More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
              type: string
            volumeAttributesClassName:
              description: |-
                volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim.
                If specified, the CSI driver will create or update the volume with the attributes defined
                in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName,
                it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass
                will be applied to the claim but it's not allowed to reset this field to empty string once it is set.
                If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass
                will be set by the persistentvolume controller if it exists.
                If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be
                set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource
                exists.
                More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/
                (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
              type: string
            volumeMode:
              description: |-
                volumeMode defines what type of volume is required by the claim.
                Value of Filesystem is implied when not included in claim spec.
              type: string
            volumeName:
              description: volumeName is the binding reference to the PersistentVolume
                backing this claim.
              type: string
          type: object
        source:
          description: Source is the src of the data for the requested DataVolume
          properties:
            blank:
              description: DataVolumeBlankImage provides the parameters to create
                a new raw blank image for the PVC
              type: object
            gcs:
              description: DataVolumeSourceGCS provides the parameters to create a
                Data Volume from an GCS source
              properties:
                secretRef:
                  description: SecretRef provides the secret reference needed to access
                    the GCS source
                  type: string
                url:
                  description: URL is the url of the GCS source
                  type: string
              required:
              - url
              type: object
            http:
              description: DataVolumeSourceHTTP can be either an http or https endpoint,
                with an optional basic auth user name and password, and an optional
                configmap containing additional CAs
              properties:
                certConfigMap:
                  description: CertConfigMap is a configmap reference, containing
                    a Certificate Authority(CA) public key, and a base64 encoded pem
                    certificate
                  type: string
                extraHeaders:
                  description: ExtraHeaders is a list of strings containing extra
                    headers to include with HTTP transfer requests
                  items:
                    type: string
                  type: array
                secretExtraHeaders:
                  description: SecretExtraHeaders is a list of Secret references,
                    each containing an extra HTTP header that may include sensitive
                    information
                  items:
                    type: string
                  type: array
                secretRef:
                  description: SecretRef A Secret reference, the secret should contain
                    accessKeyId (user name) base64 encoded, and secretKey (password)
                    also base64 encoded
                  type: string
                url:
                  description: URL is the URL of the http(s) endpoint
                  type: string
              required:
              - url
              type: object
            imageio:
              description: DataVolumeSourceImageIO provides the parameters to create
                a Data Volume from an imageio source
              properties:
                certConfigMap:
                  description: CertConfigMap provides a reference to the CA cert
                  type: string
                diskId:
                  description: DiskID provides id of a disk to be imported
                  type: string
                secretRef:
                  description: SecretRef provides the secret reference needed to access
                    the ovirt-engine
                  type: string
                url:
                  description: URL is the URL of the ovirt-engine
                  type: string
              required:
              - diskId
              - url
              type: object
            pvc:
              description: DataVolumeSourcePVC provides the parameters to create a
                Data Volume from an existing PVC
              properties:
                name:
                  description: The name of the source PVC
                  type: string
                namespace:
                  description: The namespace of the source PVC
                  type: string
              required:
              - name
              - namespace
              type: object
            registry:
              description: DataVolumeSourceRegistry provides the parameters to create
                a Data Volume from an registry source
              properties:
                certConfigMap:
                  description: CertConfigMap provides a reference to the Registry
                    certs
                  type: string
                imageStream:
                  description: ImageStream is the name of image stream for import
                  type: string
                pullMethod:
                  description: PullMethod can be either "pod" (default import), or
                    "node" (node docker cache based import)
                  type: string
                secretRef:
                  description: SecretRef provides the secret reference needed to access
                    the Registry source
                  type: string
                url:
                  description: 'URL is the url of the registry source (starting with
                    the scheme: docker, oci-archive)'
                  type: string
              type: object
            s3:
              description: DataVolumeSourceS3 provides the parameters to create a
                Data Volume from an S3 source
              properties:
                certConfigMap:
                  description: CertConfigMap is a configmap reference, containing
                    a Certificate Authority(CA) public key, and a base64 encoded pem
                    certificate
                  type: string
                secretRef:
                  description: SecretRef provides the secret reference needed to access
                    the S3 source
                  type: string
                url:
                  description: URL is the url of the S3 source
                  type: string
              required:
              - url
              type: object
            snapshot:
              description: DataVolumeSourceSnapshot provides the parameters to create
                a Data Volume from an existing VolumeSnapshot
              properties:
                name:
                  description: The name of the source VolumeSnapshot
                  type: string
                namespace:
                  description: The namespace of the source VolumeSnapshot
                  type: string
              required:
              - name
              - namespace
              type: object
            upload:
              description: DataVolumeSourceUpload provides the parameters to create
                a Data Volume by uploading the source
              type: object
            vddk:
              description: DataVolumeSourceVDDK provides the parameters to create
                a Data Volume from a Vmware source
              properties:
                backingFile:
                  description: BackingFile is the path to the virtual hard disk to
                    migrate from vCenter/ESXi
                  type: string
                initImageURL:
                  description: InitImageURL is an optional URL to an image containing
                    an extracted VDDK library, overrides v2v-vmware config map
                  type: string
                secretRef:
                  description: SecretRef provides a reference to a secret containing
                    the username and password needed to access the vCenter or ESXi
                    host
                  type: string
                thumbprint:
                  description: Thumbprint is the certificate thumbprint of the vCenter
                    or ESXi host
                  type: string
                url:
                  description: URL is the URL of the vCenter or ESXi host with the
                    VM to migrate
                  type: string
                uuid:
                  description: UUID is the UUID of the virtual machine that the backing
                    file is attached to in vCenter/ESXi
                  type: string
              type: object
          type: object
        sourceRef:
          description: SourceRef is an indirect reference to the source of data for
            the requested DataVolume
          properties:
            kind:
              description: The kind of the source reference, currently only "DataSource"
                is supported
              type: string
            name:
              description: The name of the source reference
              type: string
            namespace:
              description: The namespace of the source reference, defaults to the
                DataVolume namespace
              type: string
          required:
          - kind
          - name
          type: object
        storage:
          description: Storage is the requested storage specification
          properties:
            accessModes:
              description: |-
                AccessModes contains the desired access modes the volume should have.
                More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
              items:
                type: string
              type: array
            dataSource:
              description: |-
                This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.
                If the AnyVolumeDataSource feature gate is enabled, this field will always have the same contents as the DataSourceRef field.
              properties:
                apiGroup:
                  description: |-
                    APIGroup is the group for the resource being referenced.
                    If APIGroup is not specified, the specified Kind must be in the core API group.
                    For any other third-party types, APIGroup is required.
                  type: string
                kind:
                  description: Kind is the type of resource being referenced
                  type: string
                name:
                  description: Name is the name of resource being referenced
                  type: string
              required:
              - kind
              - name
              type: object
              x-kubernetes-map-type: atomic
            dataSourceRef:
              description: |-
                Specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any local object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner.
                This field will replace the functionality of the DataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, both fields (DataSource and DataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty.
                There are two important differences between DataSource and DataSourceRef:
                * While DataSource only allows two specific types of objects, DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects.
                * While DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and generates an error if a disallowed value is specified.
                (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
              properties:
                apiGroup:
                  description: |-
                    APIGroup is the group for the resource being referenced.
                    If APIGroup is not specified, the specified Kind must be in the core API group.
                    For any other third-party types, APIGroup is required.
                  type: string
                kind:
                  description: Kind is the type of resource being referenced
                  type: string
                name:
                  description: Name is the name of resource being referenced
                  type: string
                namespace:
                  description: |-
                    Namespace is the namespace of resource being referenced
                    Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details.
                    (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
                  type: string
              required:
              - kind
              - name
              type: object
            resources:
              description: |-
                Resources represents the minimum resources the volume should have.
                More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
              properties:
                limits:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Limits describes the maximum amount of compute resources allowed.
                    More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                  type: object
                requests:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Requests describes the minimum amount of compute resources required.
                    If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
                    otherwise to an implementation-defined value. Requests cannot exceed Limits.
                    More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                  type: object
              type: object
            selector:
              description: A label query over volumes to consider for binding.
              properties:
                matchExpressions:
                  description: matchExpressions is a list of label selector requirements.
                    The requirements are ANDed.
                  items:
                    description: |-
                      A label selector requirement is a selector that contains values, a key, and an operator that
                      relates the key and values.
                    properties:
                      key:
                        description: key is the label key that the selector applies
                          to.
                        type: string
                      operator:
                        description: |-
                          operator represents a key's relationship to a set of values.
                          Valid operators are In, NotIn, Exists and DoesNotExist.
                        type: string
                      values:
                        description: |-
                          values is an array of string values. If the operator is In or NotIn,
                          the values array must be non-empty. If the operator is Exists or DoesNotExist,
                          the values array must be empty. This array is replaced during a strategic
                          merge patch.
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                    required:
                    - key
                    - operator
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                matchLabels:
                  additionalProperties:
                    type: string
                  description: |-
                    matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                    map is equivalent to an element of matchExpressions, whose key field is "key", the
                    operator is "In", and the values array contains only "value". The requirements are ANDed.
                  type: object
              type: object
              x-kubernetes-map-type: atomic
            storageClassName:
              description: |-
                Name of the StorageClass required by the claim.
                More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
              type: string
            volumeMode:
              description: |-
                volumeMode defines what type of volume is required by the claim.
                Value of Filesystem is implied when not included in claim spec.
              type: string
            volumeName:
              description: VolumeName is the binding reference to the PersistentVolume
                backing this claim.
              type: string
          type: object
      type: object
    status:
      description: |-
        DataVolumeTemplateDummyStatus is here simply for backwards compatibility with
        a previous API.
      nullable: true
      type: object
  required:
  - spec
  type: object
`,
	"kubevirt": `openAPIV3Schema:
  description: KubeVirt represents the object deploying all KubeVirt resources
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      properties:
        certificateRotateStrategy:
          properties:
            selfSigned:
              properties:
                ca:
                  description: |-
                    CA configuration
                    CA certs are kept in the CA bundle as long as they are valid
                  properties:
                    duration:
                      description: The requested 'duration' (i.e. lifetime) of the
                        Certificate.
                      type: string
                    renewBefore:
                      description: |-
                        The amount of time before the currently issued certificate's "notAfter"
                        time that we will begin to attempt to renew the certificate.
                      type: string
                  type: object
                caOverlapInterval:
                  description: Deprecated. Use CA.Duration and CA.RenewBefore instead
                  type: string
                caRotateInterval:
                  description: Deprecated. Use CA.Duration instead
                  type: string
                certRotateInterval:
                  description: Deprecated. Use Server.Duration instead
                  type: string
                server:
                  description: |-
                    Server configuration
                    Certs are rotated and discarded
                  properties:
                    duration:
                      description: The requested 'duration' (i.e. lifetime) of the
                        Certificate.
                      type: string
                    renewBefore:
                      description: |-
                        The amount of time before the currently issued certificate's "notAfter"
                        time that we will begin to attempt to renew the certificate.
                      type: string
                  type: object
              type: object
          type: object
        configuration:
          description: |-
            holds kubevirt configurations.
            same as the virt-configMap
          properties:
            additionalGuestMemoryOverheadRatio:
              description: |-
                AdditionalGuestMemoryOverheadRatio can be used to increase the virtualization infrastructure
                overhead. This is useful, since the calculation of this overhead is not accurate and cannot
                be entirely known in advance. The ratio that is being set determines by which factor to increase
                the overhead calculated by Kubevirt. A higher ratio means that the VMs would be less compromised
                by node pressures, but would mean that fewer VMs could be scheduled to a node.
                If not set, the default is 1.
              type: string
            apiConfiguration:
              description: |-
                ReloadableComponentConfiguration holds all generic k8s configuration options which can
                be reloaded by components without requiring a restart.
              properties:
                restClient:
                  description: RestClient can be used to tune certain aspects of the
                    k8s client in use.
                  properties:
                    rateLimiter:
                      description: RateLimiter allows selecting and configuring different
                        rate limiters for the k8s client.
                      properties:
                        tokenBucketRateLimiter:
                          properties:
                            burst:
                              description: |-
                                Maximum burst for throttle.
                                If it's zero, the component default will be used
                              type: integer
                            qps:
                              description: |-
                                QPS indicates the maximum QPS to the apiserver from this client.
                                If it's zero, the component default will be used
                              type: number
                          required:
                          - burst
                          - qps
                          type: object
                      type: object
                  type: object
              type: object
            architectureConfiguration:
              properties:
                amd64:
                  properties:
                    emulatedMachines:
                      items:
                        type: string
                      type: array
                      x-kubernetes-list-type: atomic
                    machineType:
                      type: string
                    ovmfPath:
                      type: string
                  type: object
                arm64:
                  properties:
                    emulatedMachines:
                      items:
                        type: string
                      type: array
                      x-kubernetes-list-type: atomic
                    machineType:
                      type: string
                    ovmfPath:
                      type: string
                  type: object
                defaultArchitecture:
                  type: string
                ppc64le:
                  properties:
                    emulatedMachines:
                      items:
                        type: string
                      type: array
                      x-kubernetes-list-type: atomic
                    machineType:
                      type: string
                    ovmfPath:
                      type: string
                  type: object
              type: object
            autoCPULimitNamespaceLabelSelector:
              description: |-
                When set, AutoCPULimitNamespaceLabelSelector will set a CPU limit on virt-launcher for VMIs running inside
                namespaces that match the label selector.
                The CPU limit will equal the number of requested vCPUs.
                This setting does not apply to VMIs with dedicated CPUs.
              properties:
                matchExpressions:
                  description: matchExpressions is a list of label selector requirements.
                    The requirements are ANDed.
                  items:
                    description: |-
                      A label selector requirement is a selector that contains values, a key, and an operator that
                      relates the key and values.
                    properties:
                      key:
                        description: key is the label key that the selector applies
                          to.
                        type: string
                      operator:
                        description: |-
                          operator represents a key's relationship to a set of values.
                          Valid operators are In, NotIn, Exists and DoesNotExist.
                        type: string
                      values:
                        description: |-
                          values is an array of string values. If the operator is In or NotIn,
                          the values array must be non-empty. If the operator is Exists or DoesNotExist,
                          the values array must be empty. This array is replaced during a strategic
                          merge patch.
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                    required:
                    - key
                    - operator
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                matchLabels:
                  additionalProperties:
                    type: string
                  description: |-
                    matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                    map is equivalent to an element of matchExpressions, whose key field is "key", the
                    operator is "In", and the values array contains only "value". The requirements are ANDed.
                  type: object
              type: object
              x-kubernetes-map-type: atomic
            commonInstancetypesDeployment:
              description: CommonInstancetypesDeployment controls the deployment of
                common-instancetypes resources
              nullable: true
              properties:
                enabled:
                  description: Enabled controls the deployment of common-instancetypes
                    resources, defaults to True.
                  nullable: true
                  type: boolean
              type: object
            controllerConfiguration:
              description: |-
                ReloadableComponentConfiguration holds all generic k8s configuration options which can
                be reloaded by components without requiring a restart.
              properties:
                restClient:
                  description: RestClient can be used to tune certain aspects of the
                    k8s client in use.
                  properties:
                    rateLimiter:
                      description: RateLimiter allows selecting and configuring different
                        rate limiters for the k8s client.
                      properties:
                        tokenBucketRateLimiter:
                          properties:
                            burst:
                              description: |-
                                Maximum burst for throttle.
                                If it's zero, the component default will be used
                              type: integer
                            qps:
                              description: |-
                                QPS indicates the maximum QPS to the apiserver from this client.
                                If it's zero, the component default will be used
                              type: number
                          required:
                          - burst
                          - qps
                          type: object
                      type: object
                  type: object
              type: object
            cpuModel:
              type: string
            cpuRequest:
              anyOf:
              - type: integer
              - type: string
              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
              x-kubernetes-int-or-string: true
            defaultRuntimeClass:
              type: string
            developerConfiguration:
              description: DeveloperConfiguration holds developer options
              properties:
                clusterProfiler:
                  description: Enable the ability to pprof profile KubeVirt control
                    plane
                  type: boolean
                cpuAllocationRatio:
                  description: |-
                    For each requested virtual CPU, CPUAllocationRatio defines how much physical CPU to request per VMI
                    from the hosting node. The value is in fraction of a CPU thread (or core on non-hyperthreaded nodes).
                    For example, a value of 1 means 1 physical CPU thread per VMI CPU thread.
                    A value of 100 would be 1% of a physical thread allocated for each requested VMI thread.
                    This option has no effect on VMIs that request dedicated CPUs. More information at:
                    https://kubevirt.io/user-guide/operations/node_overcommit/#node-cpu-allocation-ratio
                    Defaults to 10
                  type: integer
                diskVerification:
                  description: DiskVerification holds container disks verification
                    limits
                  properties:
                    memoryLimit:
                      anyOf:
                      - type: integer
                      - type: string
                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                      x-kubernetes-int-or-string: true
                  required:
                  - memoryLimit
                  type: object
                featureGates:
                  description: FeatureGates is the list of experimental features to
                    enable. Defaults to none
                  items:
                    type: string
                  type: array
                logVerbosity:
                  description: LogVerbosity sets log verbosity level of  various components
                  properties:
                    nodeVerbosity:
                      additionalProperties:
                        type: integer
                      description: NodeVerbosity represents a map of nodes with a
                        specific verbosity level
                      type: object
                    virtAPI:
                      type: integer
                    virtController:
                      type: integer
                    virtHandler:
                      type: integer
                    virtLauncher:
                      type: integer
                    virtOperator:
                      type: integer
                    virtSynchronizationController:
                      type: integer
                  type: object
                memoryOvercommit:
                  description: |-
                    MemoryOvercommit is the percentage of memory we want to give VMIs compared to the amount
                    given to its parent pod (virt-launcher). For example, a value of 102 means the VMI will
                    "see" 2% more memory than its parent pod. Values under 100 are effectively "undercommits".
                    Overcommits can lead to memory exhaustion, which in turn can lead to crashes. Use carefully.
                    Defaults to 100
                  type: integer
                minimumClusterTSCFrequency:
                  description: |-
                    Allow overriding the automatically determined minimum TSC frequency of the cluster
                    and fixate the minimum to this frequency.
                  format: int64
                  type: integer
                minimumReservePVCBytes:
                  description: |-
                    MinimumReservePVCBytes is the amount of space, in bytes, to leave unused on disks.
                    Defaults to 131072 (128KiB)
                  format: int64
                  type: integer
                nodeSelectors:
                  additionalProperties:
                    type: string
                  description: |-
                    NodeSelectors allows restricting VMI creation to nodes that match a set of labels.
                    Defaults to none
                  type: object
                pvcTolerateLessSpaceUpToPercent:
                  description: |-
                    LessPVCSpaceToleration determines how much smaller, in percentage, disk PVCs are
                    allowed to be compared to the requested size (to account for various overheads).
                    Defaults to 10
                  type: integer
                useEmulation:
                  description: |-
                    UseEmulation can be set to true to allow fallback to software emulation
                    in case hardware-assisted emulation is not available. Defaults to false
                  type: boolean
              type: object
            emulatedMachines:
              description: Deprecated. Use architectureConfiguration instead.
              items:
                type: string
              type: array
            evictionStrategy:
              description: |-
                EvictionStrategy defines at the cluster level if the VirtualMachineInstance should be
                migrated instead of shut-off in case of a node drain. If the VirtualMachineInstance specific
                field is set it overrides the cluster level one.
              type: string
            handlerConfiguration:
              description: |-
                ReloadableComponentConfiguration holds all generic k8s configuration options which can
                be reloaded by components without requiring a restart.
              properties:
                restClient:
                  description: RestClient can be used to tune certain aspects of the
                    k8s client in use.
                  properties:
                    rateLimiter:
                      description: RateLimiter allows selecting and configuring different
                        rate limiters for the k8s client.
                      properties:
                        tokenBucketRateLimiter:
                          properties:
                            burst:
                              description: |-
                                Maximum burst for throttle.
                                If it's zero, the component default will be used
                              type: integer
                            qps:
                              description: |-
                                QPS indicates the maximum QPS to the apiserver from this client.
                                If it's zero, the component default will be used
                              type: number
                          required:
                          - burst
                          - qps
                          type: object
                      type: object
                  type: object
              type: object
            imagePullPolicy:
              description: PullPolicy describes a policy for if/when to pull a container
                image
              type: string
            instancetype:
              description: Instancetype configuration
              nullable: true
              properties:
                referencePolicy:
                  description: |-
                    ReferencePolicy defines how an instance type or preference should be referenced by the VM after submission, supported values are:
                    reference (default) - Where a copy of the original object is stashed in a ControllerRevision and referenced by the VM.
                    expand - Where the instance type or preference are expanded into the VM if no revisionNames have been populated.
                    expandAll - Where the instance type or preference are expanded into the VM regardless of revisionNames previously being populated.
                  enum:
                  - reference
                  - expand
                  - expandAll
                  nullable: true
                  type: string
              type: object
            ksmConfiguration:
              description: KSMConfiguration holds the information regarding the enabling
                the KSM in the nodes (if available).
              properties:
                nodeLabelSelector:
                  description: |-
                    NodeLabelSelector is a selector that filters in which nodes the KSM will be enabled.
                    Empty NodeLabelSelector will enable ksm for every node.
                  properties:
                    matchExpressions:
                      description: matchExpressions is a list of label selector requirements.
                        The requirements are ANDed.
                      items:
                        description: |-
                          A label selector requirement is a selector that contains values, a key, and an operator that
                          relates the key and values.
                        properties:
                          key:
                            description: key is the label key that the selector applies
                              to.
                            type: string
                          operator:
                            description: |-
                              operator represents a key's relationship to a set of values.
                              Valid operators are In, NotIn, Exists and DoesNotExist.
                            type: string
                          values:
                            description: |-
                              values is an array of string values. If the operator is In or NotIn,
                              the values array must be non-empty. If the operator is Exists or DoesNotExist,
                              the values array must be empty. This array is replaced during a strategic
                              merge patch.
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                        required:
                        - key
                        - operator
                        type: object
                      type: array
                      x-kubernetes-list-type: atomic
                    matchLabels:
                      additionalProperties:
                        type: string
                      description: |-
                        matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                        map is equivalent to an element of matchExpressions, whose key field is "key", the
                        operator is "In", and the values array contains only "value". The requirements are ANDed.
                      type: object
                  type: object
                  x-kubernetes-map-type: atomic
              type: object
            liveUpdateConfiguration:
              description: LiveUpdateConfiguration holds defaults for live update
                features
              properties:
                maxCpuSockets:
                  description: |-
                    MaxCpuSockets provides a MaxSockets value for VMs that do not provide their own.
                    For VMs with more sockets than maximum the MaxSockets will be set to equal number of sockets.
                  format: int32
                  type: integer
                maxGuest:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    MaxGuest defines the maximum amount memory that can be allocated
                    to the guest using hotplug.
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
                maxHotplugRatio:
                  description: |-
                    MaxHotplugRatio is the ratio used to define the max amount
                    of a hotplug resource that can be made available to a VM
                    when the specific Max* setting is not defined (MaxCpuSockets, MaxGuest)
                    Example: VM is configured with 512Mi of guest memory, if MaxGuest is not
                    defined and MaxHotplugRatio is 2 then MaxGuest = 1Gi
                    defaults to 4
                  format: int32
                  type: integer
              type: object
            machineType:
              description: Deprecated. Use architectureConfiguration instead.
              type: string
            mediatedDevicesConfiguration:
              description: MediatedDevicesConfiguration holds information about MDEV
                types to be defined, if available
              properties:
                mediatedDeviceTypes:
                  items:
                    type: string
                  type: array
                  x-kubernetes-list-type: atomic
                mediatedDevicesTypes:
                  description: Deprecated. Use mediatedDeviceTypes instead.
                  items:
                    type: string
                  type: array
                  x-kubernetes-list-type: atomic
                nodeMediatedDeviceTypes:
                  items:
                    description: NodeMediatedDeviceTypesConfig holds information about
                      MDEV types to be defined in a specific node that matches the
                      NodeSelector field.
                    properties:
                      mediatedDeviceTypes:
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      mediatedDevicesTypes:
                        description: Deprecated. Use mediatedDeviceTypes instead.
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      nodeSelector:
                        additionalProperties:
                          type: string
                        description: |-
                          NodeSelector is a selector which must be true for the vmi to fit on a node.
                          Selector which must match a node's labels for the vmi to be scheduled on that node.
                          More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
                        type: object
                    required:
                    - nodeSelector
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
              type: object
            memBalloonStatsPeriod:
              format: int32
              type: integer
            migrations:
              description: |-
                MigrationConfiguration holds migration options.
                Can be overridden for specific groups of VMs though migration policies.
                Visit https://kubevirt.io/user-guide/operations/migration_policies/ for more information.
              properties:
                allowAutoConverge:
                  description: |-
                    AllowAutoConverge allows the platform to compromise performance/availability of VMIs to
                    guarantee successful VMI live migrations. Defaults to false
                  type: boolean
                allowPostCopy:
                  description: |-
                    AllowPostCopy enables post-copy live migrations. Such migrations allow even the busiest VMIs
                    to successfully live-migrate. However, events like a network failure can cause a VMI crash.
                    If set to true, migrations will still start in pre-copy, but switch to post-copy when
                    CompletionTimeoutPerGiB triggers. Defaults to false
                  type: boolean
                allowWorkloadDisruption:
                  description: |-
                    AllowWorkloadDisruption indicates that the migration shouldn't be
                    canceled after acceptableCompletionTime is exceeded. Instead, if
                    permitted, migration will be switched to post-copy or the VMI will be
                    paused to allow the migration to complete
                  type: boolean
                bandwidthPerMigration:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    BandwidthPerMigration limits the amount of network bandwidth live migrations are allowed to use.
                    The value is in quantity per second. Defaults to 0 (no limit)
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
                completionTimeoutPerGiB:
                  description: |-
                    CompletionTimeoutPerGiB is the maximum number of seconds per GiB a migration is allowed to take.
                    If the timeout is reached, the migration will be either paused, switched
                    to post-copy or cancelled depending on other settings. Defaults to 150
                  format: int64
                  type: integer
                disableTLS:
                  description: |-
                    When set to true, DisableTLS will disable the additional layer of live migration encryption
                    provided by KubeVirt. This is usually a bad idea. Defaults to false
                  type: boolean
                matchSELinuxLevelOnMigration:
                  description: |-
                    By default, the SELinux level of target virt-launcher pods is forced to the level of the source virt-launcher.
                    When set to true, MatchSELinuxLevelOnMigration lets the CRI auto-assign a random level to the target.
                    That will ensure the target virt-launcher doesn't share categories with another pod on the node.
                    However, migrations will fail when using RWX volumes that don't automatically deal with SELinux levels.
                  type: boolean
                network:
                  description: |-
                    Network is the name of the CNI network to use for live migrations. By default, migrations go
                    through the pod network.
                  type: string
                nodeDrainTaintKey:
                  description: |-
                    NodeDrainTaintKey defines the taint key that indicates a node should be drained.
                    Note: this option relies on the deprecated node taint feature. Default: kubevirt.io/drain
                  type: string
                parallelMigrationsPerCluster:
                  description: |-
                    ParallelMigrationsPerCluster is the total number of concurrent live migrations
                    allowed cluster-wide. Defaults to 5
                  format: int32
                  type: integer
                parallelOutboundMigrationsPerNode:
                  description: |-
                    ParallelOutboundMigrationsPerNode is the maximum number of concurrent outgoing live migrations
                    allowed per node. Defaults to 2
                  format: int32
                  type: integer
                progressTimeout:
                  description: |-
                    ProgressTimeout is the maximum number of seconds a live migration is allowed to make no progress.
                    Hitting this timeout means a migration transferred 0 data for that many seconds. The migration is
                    then considered stuck and therefore cancelled. Defaults to 150
                  format: int64
                  type: integer
                unsafeMigrationOverride:
                  description: |-
                    UnsafeMigrationOverride allows live migrations to occur even if the compatibility check
                    indicates the migration will be unsafe to the guest. Defaults to false
                  type: boolean
              type: object
            minCPUModel:
              type: string
            network:
              description: NetworkConfiguration holds network options
              properties:
                binding:
                  additionalProperties:
                    properties:
                      computeResourceOverhead:
                        description: |-
                          ComputeResourceOverhead specifies the resource overhead that should be added to the compute container when using the binding.
                          version: v1alphav1
                        properties:
                          limits:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: |-
                              Limits describes the maximum amount of compute resources allowed.
                              More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                            type: object
                          requests:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: |-
                              Requests describes the minimum amount of compute resources required.
                              If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
                              otherwise to an implementation-defined value. Requests cannot exceed Limits.
                              More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                            type: object
                        type: object
                      domainAttachmentType:
                        description: |-
                          DomainAttachmentType is a standard domain network attachment method kubevirt supports.
                          Supported values: "tap", "managedTap" (since v1.4).
                          The standard domain attachment can be used instead or in addition to the sidecarImage.
                          version: 1alphav1
                        type: string
                      downwardAPI:
                        description: |-
                          DownwardAPI specifies what kind of data should be exposed to the binding plugin sidecar.
                          Supported values: "device-info"
                          version: v1alphav1
                        type: string
                      migration:
                        description: |-
                          Migration means the VM using the plugin can be safely migrated
                          version: 1alphav1
                        properties:
                          method:
                            description: |-
                              Method defines a pre-defined migration methodology
                              version: 1alphav1
                            type: string
                        type: object
                      networkAttachmentDefinition:
                        description: |-
                          NetworkAttachmentDefinition references to a NetworkAttachmentDefinition CR object.
                          Format: <name>, <namespace>/<name>.
                          If namespace is not specified, VMI namespace is assumed.
                          version: 1alphav1
                        type: string
                      sidecarImage:
                        description: |-
                          SidecarImage references a container image that runs in the virt-launcher pod.
                          The sidecar handles (libvirt) domain configuration and optional services.
                          version: 1alphav1
                        type: string
                    type: object
                  type: object
                defaultNetworkInterface:
                  type: string
                permitBridgeInterfaceOnPodNetwork:
                  type: boolean
                permitSlirpInterface:
                  description: |-
                    DeprecatedPermitSlirpInterface is an alias for the deprecated PermitSlirpInterface.
                    Deprecated: Removed in v1.3.
                  type: boolean
              type: object
            obsoleteCPUModels:
              additionalProperties:
                type: boolean
              type: object
            ovmfPath:
              description: Deprecated. Use architectureConfiguration instead.
              type: string
            permittedHostDevices:
              description: PermittedHostDevices holds information about devices allowed
                for passthrough
              properties:
                mediatedDevices:
                  items:
                    description: MediatedHostDevice represents a host mediated device
                      allowed for passthrough
                    properties:
                      externalResourceProvider:
                        type: boolean
                      mdevNameSelector:
                        type: string
                      resourceName:
                        type: string
                    required:
                    - mdevNameSelector
                    - resourceName
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                pciHostDevices:
                  items:
                    description: PciHostDevice represents a host PCI device allowed
                      for passthrough
                    properties:
                      externalResourceProvider:
                        description: |-
                          If true, KubeVirt will leave the allocation and monitoring to an
                          external device plugin
                        type: boolean
                      pciVendorSelector:
                        description: The vendor_id:product_id tuple of the PCI device
                        type: string
                      resourceName:
                        description: |-
                          The name of the resource that is representing the device. Exposed by
                          a device plugin and requested by VMs. Typically of the form
                          vendor.com/product_name
                        type: string
                    required:
                    - pciVendorSelector
                    - resourceName
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                usb:
                  items:
                    properties:
                      externalResourceProvider:
                        description: |-
                          If true, KubeVirt will leave the allocation and monitoring to an
                          external device plugin
                        type: boolean
                      resourceName:
                        description: |-
                          Identifies the list of USB host devices.
                          e.g: kubevirt.io/storage, kubevirt.io/bootable-usb, etc
                        type: string
                      selectors:
                        items:
                          properties:
                            product:
                              type: string
                            vendor:
                              type: string
                          required:
                          - product
                          - vendor
                          type: object
                        type: array
                        x-kubernetes-list-type: atomic
                    required:
                    - resourceName
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
              type: object
            seccompConfiguration:
              description: SeccompConfiguration holds Seccomp configuration for Kubevirt
                components
              properties:
                virtualMachineInstanceProfile:
                  description: VirtualMachineInstanceProfile defines what profile
                    should be used with virt-launcher. Defaults to none
                  properties:
                    customProfile:
                      description: CustomProfile allows to request arbitrary profile
                        for virt-launcher
                      properties:
                        localhostProfile:
                          type: string
                        runtimeDefaultProfile:
                          type: boolean
                      type: object
                  type: object
              type: object
            selinuxLauncherType:
              type: string
            smbios:
              properties:
                family:
                  type: string
                manufacturer:
                  type: string
                product:
                  type: string
                sku:
                  type: string
                version:
                  type: string
              type: object
            supportContainerResources:
              description: SupportContainerResources specifies the resource requirements
                for various types of supporting containers such as container disks/virtiofs/sidecars
                and hotplug attachment pods. If omitted a sensible default will be
                supplied.
              items:
                description: SupportContainerResources are used to specify the cpu/memory
                  request and limits for the containers that support various features
                  of Virtual Machines. These containers are usually idle and don't
                  require a lot of memory or cpu.
                properties:
                  resources:
                    description: |-
                      ResourceRequirementsWithoutClaims describes the compute resource requirements.
                      This struct was taken from the k8s.ResourceRequirements and cleaned up the 'Claims' field.
                    properties:
                      limits:
                        additionalProperties:
                          anyOf:
                          - type: integer
                          - type: string
                          pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                          x-kubernetes-int-or-string: true
                        description: |-
                          Limits describes the maximum amount of compute resources allowed.
                          More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                        type: object
                      requests:
                        additionalProperties:
                          anyOf:
                          - type: integer
                          - type: string
                          pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                          x-kubernetes-int-or-string: true
                        description: |-
                          Requests describes the minimum amount of compute resources required.
                          If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
                          otherwise to an implementation-defined value. Requests cannot exceed Limits.
                          More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                        type: object
                    type: object
                  type:
                    type: string
                required:
                - resources
                - type
                type: object
              type: array
              x-kubernetes-list-map-keys:
              - type
              x-kubernetes-list-type: map
            supportedGuestAgentVersions:
              description: deprecated
              items:
                type: string
              type: array
            tlsConfiguration:
              description: TLSConfiguration holds TLS options
              properties:
                ciphers:
                  items:
                    type: string
                  type: array
                  x-kubernetes-list-type: set
                minTLSVersion:
                  description: |-
                    MinTLSVersion is a way to specify the minimum protocol version that is acceptable for TLS connections.
                    Protocol versions are based on the following most common TLS configurations:

                      https://ssl-config.mozilla.org/

                    Note that SSLv3.0 is not a supported protocol version due to well known
                    vulnerabilities such as POODLE: https://en.wikipedia.org/wiki/POODLE
                  enum:
                  - VersionTLS10
                  - VersionTLS11
                  - VersionTLS12
                  - VersionTLS13
                  type: string
              type: object
            virtualMachineInstancesPerNode:
              type: integer
            virtualMachineOptions:
              description: VirtualMachineOptions holds the cluster level information
                regarding the virtual machine.
              properties:
                disableFreePageReporting:
                  description: |-
                    DisableFreePageReporting disable the free page reporting of
                    memory balloon device https://libvirt.org/formatdomain.html#memory-balloon-device.
                    This will have effect only if AutoattachMemBalloon is not false and the vmi is not
                    requesting any high performance feature (dedicatedCPU/realtime/hugePages), in which free page reporting is always disabled.
                  type: object
                disableSerialConsoleLog:
                  description: |-
                    DisableSerialConsoleLog disables logging the auto-attached default serial console.
                    If not set, serial console logs will be written to a file and then streamed from a container named 'guest-console-log'.
                    The value can be individually overridden for each VM, not relevant if AutoattachSerialConsole is disabled.
                  type: object
              type: object
            vmRolloutStrategy:
              description: |-
                VMRolloutStrategy defines how live-updatable fields, like CPU sockets, memory,
                tolerations, and affinity, are propagated from a VM to its VMI.
              enum:
              - Stage
              - LiveUpdate
              nullable: true
              type: string
            vmStateStorageClass:
              description: VMStateStorageClass is the name of the storage class to
                use for the PVCs created to preserve VM state, like TPM.
              type: string
            webhookConfiguration:
              description: |-
                ReloadableComponentConfiguration holds all generic k8s configuration options which can
                be reloaded by components without requiring a restart.
              properties:
                restClient:
                  description: RestClient can be used to tune certain aspects of the
                    k8s client in use.
                  properties:
                    rateLimiter:
                      description: RateLimiter allows selecting and configuring different
                        rate limiters for the k8s client.
                      properties:
                        tokenBucketRateLimiter:
                          properties:
                            burst:
                              description: |-
                                Maximum burst for throttle.
                                If it's zero, the component default will be used
                              type: integer
                            qps:
                              description: |-
                                QPS indicates the maximum QPS to the apiserver from this client.
                                If it's zero, the component default will be used
                              type: number
                          required:
                          - burst
                          - qps
                          type: object
                      type: object
                  type: object
              type: object
          type: object
        customizeComponents:
          properties:
            flags:
              description: Configure the value used for deployment and daemonset resources
              properties:
                api:
                  additionalProperties:
                    type: string
                  type: object
                controller:
                  additionalProperties:
                    type: string
                  type: object
                handler:
                  additionalProperties:
                    type: string
                  type: object
              type: object
            patches:
              items:
                properties:
                  patch:
                    type: string
                  resourceName:
                    minLength: 1
                    type: string
                  resourceType:
                    minLength: 1
                    type: string
                  type:
                    type: string
                required:
                - patch
                - resourceName
                - resourceType
                - type
                type: object
              type: array
              x-kubernetes-list-type: atomic
          type: object
        imagePullPolicy:
          description: The ImagePullPolicy to use.
          type: string
        imagePullSecrets:
          description: |-
            The imagePullSecrets to pull the container images from
            Defaults to none
          items:
            description: |-
              LocalObjectReference contains enough information to let you locate the
              referenced object inside the same namespace.
            properties:
              name:
                default: ""
                description: |-
                  Name of the referent.
                  This field is effectively required, but due to backwards compatibility is
                  allowed to be empty. Instances of this type with an empty value here are
                  almost certainly wrong.
                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                type: string
            type: object
            x-kubernetes-map-type: atomic
          type: array
          x-kubernetes-list-type: atomic
        imageRegistry:
          description: |-
            The image registry to pull the container images from
            Defaults to the same registry the operator's container image is pulled from.
          type: string
        imageTag:
          description: |-
            The image tag to use for the continer images installed.
            Defaults to the same tag as the operator's container image.
          type: string
        infra:
          description: selectors and tolerations that should apply to KubeVirt infrastructure
            components
          properties:
            nodePlacement:
              description: |-
                nodePlacement describes scheduling configuration for specific
                KubeVirt components
              properties:
                affinity:
                  description: |-
                    affinity enables pod affinity/anti-affinity placement expanding the types of constraints
                    that can be expressed with nodeSelector.
                    affinity is going to be applied to the relevant kind of pods in parallel with nodeSelector
                    See https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#affinity-and-anti-affinity
                  properties:
                    nodeAffinity:
                      description: Describes node affinity scheduling rules for the
                        pod.
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node matches the corresponding matchExpressions; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: |-
                              An empty preferred scheduling term matches all objects with implicit weight 0
                              (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
                            properties:
                              preference:
                                description: A node selector term, associated with
                                  the corresponding weight.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              weight:
                                description: Weight associated with matching the corresponding
                                  nodeSelectorTerm, in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - preference
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to an update), the system
                            may or may not try to eventually evict the pod from its node.
                          properties:
                            nodeSelectorTerms:
                              description: Required. A list of node selector terms.
                                The terms are ORed.
                              items:
                                description: |-
                                  A null or empty node selector term matches no objects. The requirements of
                                  them are ANDed.
                                  The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              type: array
                              x-kubernetes-list-type: atomic
                          required:
                          - nodeSelectorTerms
                          type: object
                          x-kubernetes-map-type: atomic
                      type: object
                    podAffinity:
                      description: Describes pod affinity scheduling rules (e.g. co-locate
                        this pod in the same node, zone, etc. as some other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                    podAntiAffinity:
                      description: Describes pod anti-affinity scheduling rules (e.g.
                        avoid putting this pod in the same node, zone, etc. as some
                        other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the anti-affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling anti-affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the anti-affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the anti-affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                  type: object
                nodeSelector:
                  additionalProperties:
                    type: string
                  description: |-
                    nodeSelector is the node selector applied to the relevant kind of pods
                    It specifies a map of key-value pairs: for the pod to be eligible to run on a node,
                    the node must have each of the indicated key-value pairs as labels
                    (it can have additional labels as well).
                    See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
                  type: object
                tolerations:
                  description: |-
                    tolerations is a list of tolerations applied to the relevant kind of pods
                    See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/ for more info.
                    These are additional tolerations other than default ones.
                  items:
                    description: |-
                      The pod this Toleration is attached to tolerates any taint that matches
                      the triple <key,value,effect> using the matching operator <operator>.
                    properties:
                      effect:
                        description: |-
                          Effect indicates the taint effect to match. Empty means match all taint effects.
                          When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
                        type: string
                      key:
                        description: |-
                          Key is the taint key that the toleration applies to. Empty means match all taint keys.
                          If the key is empty, operator must be Exists; this combination means to match all values and all keys.
                        type: string
                      operator:
                        description: |-
                          Operator represents a key's relationship to the value.
                          Valid operators are Exists and Equal. Defaults to Equal.
                          Exists is equivalent to wildcard for value, so that a pod can
                          tolerate all taints of a particular category.
                        type: string
                      tolerationSeconds:
                        description: |-
                          TolerationSeconds represents the period of time the toleration (which must be
                          of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
                          it is not set, which means tolerate the taint forever (do not evict). Zero and
                          negative values will be treated as 0 (evict immediately) by the system.
                        format: int64
                        type: integer
                      value:
                        description: |-
                          Value is the taint value the toleration matches to.
                          If the operator is Exists, the value should be empty, otherwise just a regular string.
                        type: string
                    type: object
                  type: array
              type: object
            replicas:
              description: |-
                replicas indicates how many replicas should be created for each KubeVirt infrastructure
                component (like virt-api or virt-controller). Defaults to 2.
                WARNING: this is an advanced feature that prevents auto-scaling for core kubevirt components. Please use with caution!
              type: integer
          type: object
        monitorAccount:
          description: |-
            The name of the Prometheus service account that needs read-access to KubeVirt endpoints
            Defaults to prometheus-k8s
          type: string
        monitorNamespace:
          description: |-
            The namespace Prometheus is deployed in
            Defaults to openshift-monitor
          type: string
        productComponent:
          description: |-
            Designate the apps.kubevirt.io/component label for KubeVirt components.
            Useful if KubeVirt is included as part of a product.
            If ProductComponent is not specified, the component label default value is kubevirt.
          type: string
        productName:
          description: |-
            Designate the apps.kubevirt.io/part-of label for KubeVirt components.
            Useful if KubeVirt is included as part of a product.
            If ProductName is not specified, the part-of label will be omitted.
          type: string
        productVersion:
          description: |-
            Designate the apps.kubevirt.io/version label for KubeVirt components.
            Useful if KubeVirt is included as part of a product.
            If ProductVersion is not specified, KubeVirt's version will be used.
          type: string
        serviceMonitorNamespace:
          description: |-
            The namespace the service monitor will be deployed
             When ServiceMonitorNamespace is set, then we'll install the service monitor object in that namespace
            otherwise we will use the monitoring namespace.
          type: string
        synchronizationPort:
          description: Specify the port to listen on for VMI status synchronization
            traffic. Default is 9185
          type: string
        uninstallStrategy:
          description: |-
            Specifies if kubevirt can be deleted if workloads are still present.
            This is mainly a precaution to avoid accidental data loss
          type: string
        workloadUpdateStrategy:
          description: |-
            WorkloadUpdateStrategy defines at the cluster level how to handle
            automated workload updates
          properties:
            batchEvictionInterval:
              description: |-
                BatchEvictionInterval Represents the interval to wait before issuing the next
                batch of shutdowns

                Defaults to 1 minute
              type: string
            batchEvictionSize:
              description: |-
                BatchEvictionSize Represents the number of VMIs that can be forced updated per
                the BatchShutdownInteral interval

                Defaults to 10
              type: integer
            workloadUpdateMethods:
              description: |-
                WorkloadUpdateMethods defines the methods that can be used to disrupt workloads
                during automated workload updates.
                When multiple methods are present, the least disruptive method takes
                precedence over more disruptive methods. For example if both LiveMigrate and Shutdown
                methods are listed, only VMs which are not live migratable will be restarted/shutdown

                An empty list defaults to no automated workload updating
              items:
                type: string
              type: array
              x-kubernetes-list-type: atomic
          type: object
        workloads:
          description: selectors and tolerations that should apply to KubeVirt workloads
          properties:
            nodePlacement:
              description: |-
                nodePlacement describes scheduling configuration for specific
                KubeVirt components
              properties:
                affinity:
                  description: |-
                    affinity enables pod affinity/anti-affinity placement expanding the types of constraints
                    that can be expressed with nodeSelector.
                    affinity is going to be applied to the relevant kind of pods in parallel with nodeSelector
                    See https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#affinity-and-anti-affinity
                  properties:
                    nodeAffinity:
                      description: Describes node affinity scheduling rules for the
                        pod.
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node matches the corresponding matchExpressions; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: |-
                              An empty preferred scheduling term matches all objects with implicit weight 0
                              (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
                            properties:
                              preference:
                                description: A node selector term, associated with
                                  the corresponding weight.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              weight:
                                description: Weight associated with matching the corresponding
                                  nodeSelectorTerm, in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - preference
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to an update), the system
                            may or may not try to eventually evict the pod from its node.
                          properties:
                            nodeSelectorTerms:
                              description: Required. A list of node selector terms.
                                The terms are ORed.
                              items:
                                description: |-
                                  A null or empty node selector term matches no objects. The requirements of
                                  them are ANDed.
                                  The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              type: array
                              x-kubernetes-list-type: atomic
                          required:
                          - nodeSelectorTerms
                          type: object
                          x-kubernetes-map-type: atomic
                      type: object
                    podAffinity:
                      description: Describes pod affinity scheduling rules (e.g. co-locate
                        this pod in the same node, zone, etc. as some other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                    podAntiAffinity:
                      description: Describes pod anti-affinity scheduling rules (e.g.
                        avoid putting this pod in the same node, zone, etc. as some
                        other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the anti-affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling anti-affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the anti-affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the anti-affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                  type: object
                nodeSelector:
                  additionalProperties:
                    type: string
                  description: |-
                    nodeSelector is the node selector applied to the relevant kind of pods
                    It specifies a map of key-value pairs: for the pod to be eligible to run on a node,
                    the node must have each of the indicated key-value pairs as labels
                    (it can have additional labels as well).
                    See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
                  type: object
                tolerations:
                  description: |-
                    tolerations is a list of tolerations applied to the relevant kind of pods
                    See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/ for more info.
                    These are additional tolerations other than default ones.
                  items:
                    description: |-
                      The pod this Toleration is attached to tolerates any taint that matches
                      the triple <key,value,effect> using the matching operator <operator>.
                    properties:
                      effect:
                        description: |-
                          Effect indicates the taint effect to match. Empty means match all taint effects.
                          When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
                        type: string
                      key:
                        description: |-
                          Key is the taint key that the toleration applies to. Empty means match all taint keys.
                          If the key is empty, operator must be Exists; this combination means to match all values and all keys.
                        type: string
                      operator:
                        description: |-
                          Operator represents a key's relationship to the value.
                          Valid operators are Exists and Equal. Defaults to Equal.
                          Exists is equivalent to wildcard for value, so that a pod can
                          tolerate all taints of a particular category.
                        type: string
                      tolerationSeconds:
                        description: |-
                          TolerationSeconds represents the period of time the toleration (which must be
                          of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
                          it is not set, which means tolerate the taint forever (do not evict). Zero and
                          negative values will be treated as 0 (evict immediately) by the system.
                        format: int64
                        type: integer
                      value:
                        description: |-
                          Value is the taint value the toleration matches to.
                          If the operator is Exists, the value should be empty, otherwise just a regular string.
                        type: string
                    type: object
                  type: array
              type: object
            replicas:
              description: |-
                replicas indicates how many replicas should be created for each KubeVirt infrastructure
                component (like virt-api or virt-controller). Defaults to 2.
                WARNING: this is an advanced feature that prevents auto-scaling for core kubevirt components. Please use with caution!
              type: integer
          type: object
      type: object
    status:
      description: KubeVirtStatus represents information pertaining to a KubeVirt
        deployment.
      properties:
        conditions:
          items:
            description: KubeVirtCondition represents a condition of a KubeVirt deployment
            properties:
              lastProbeTime:
                format: date-time
                nullable: true
                type: string
              lastTransitionTime:
                format: date-time
                nullable: true
                type: string
              message:
                type: string
              reason:
                type: string
              status:
                type: string
              type:
                type: string
            required:
            - status
            - type
            type: object
          type: array
        defaultArchitecture:
          type: string
        generations:
          items:
            description: GenerationStatus keeps track of the generation for a given
              resource so that decisions about forced updates can be made.
            properties:
              group:
                description: group is the group of the thing you're tracking
                type: string
              hash:
                description: hash is an optional field set for resources without generation
                  that are content sensitive like secrets and configmaps
                type: string
              lastGeneration:
                description: lastGeneration is the last generation of the workload
                  controller involved
                format: int64
                type: integer
              name:
                description: name is the name of the thing you're tracking
                type: string
              namespace:
                description: namespace is where the thing you're tracking is
                type: string
              resource:
                description: resource is the resource type of the thing you're tracking
                type: string
            required:
            - group
            - lastGeneration
            - name
            - resource
            type: object
          type: array
          x-kubernetes-list-type: atomic
        observedDeploymentConfig:
          type: string
        observedDeploymentID:
          type: string
        observedGeneration:
          format: int64
          type: integer
        observedKubeVirtRegistry:
          type: string
        observedKubeVirtVersion:
          type: string
        operatorVersion:
          type: string
        outdatedVirtualMachineInstanceWorkloads:
          type: integer
        phase:
          description: KubeVirtPhase is a label for the phase of a KubeVirt deployment
            at the current time.
          type: string
        synchronizationAddresses:
          items:
            type: string
          type: array
          x-kubernetes-list-type: atomic
        targetDeploymentConfig:
          type: string
        targetDeploymentID:
          type: string
        targetKubeVirtRegistry:
          type: string
        targetKubeVirtVersion:
          type: string
      type: object
  required:
  - spec
  type: object
`,
	"migrationpolicy": `openAPIV3Schema:
  description: MigrationPolicy holds migration policy (i.e. configurations) to apply
    to a VM or group of VMs
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      properties:
        allowAutoConverge:
          type: boolean
        allowPostCopy:
          type: boolean
        allowWorkloadDisruption:
          type: boolean
        bandwidthPerMigration:
          anyOf:
          - type: integer
          - type: string
          pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
          x-kubernetes-int-or-string: true
        completionTimeoutPerGiB:
          format: int64
          type: integer
        selectors:
          properties:
            namespaceSelector:
              additionalProperties:
                type: string
              type: object
            virtualMachineInstanceSelector:
              additionalProperties:
                type: string
              type: object
          type: object
      required:
      - selectors
      type: object
    status:
      nullable: true
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachine": `openAPIV3Schema:
  description: |-
    VirtualMachine handles the VirtualMachines that are not running
    or are in a stopped state
    The VirtualMachine contains the template to create the
    VirtualMachineInstance. It also mirrors the running state of the created
    VirtualMachineInstance in its status.
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: Spec contains the specification of VirtualMachineInstance created
      properties:
        dataVolumeTemplates:
          description: |-
            dataVolumeTemplates is a list of dataVolumes that the VirtualMachineInstance template can reference.
            DataVolumes in this list are dynamically created for the VirtualMachine and are tied to the VirtualMachine's life-cycle.
          items:
            nullable: true
            properties:
              apiVersion:
                description: |-
                  APIVersion defines the versioned schema of this representation of an object.
                  Servers should convert recognized schemas to the latest internal value, and
                  may reject unrecognized values.
                  More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
                type: string
              kind:
                description: |-
                  Kind is a string value representing the REST resource this object represents.
                  Servers may infer this from the endpoint the client submits requests to.
                  Cannot be updated.
                  In CamelCase.
                  More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
                type: string
              metadata:
                nullable: true
                type: object
                x-kubernetes-preserve-unknown-fields: true
              spec:
                description: DataVolumeSpec contains the DataVolume specification.
                properties:
                  checkpoints:
                    description: Checkpoints is a list of DataVolumeCheckpoints, representing
                      stages in a multistage import.
                    items:
                      description: DataVolumeCheckpoint defines a stage in a warm
                        migration.
                      properties:
                        current:
                          description: Current is the identifier of the snapshot created
                            for this checkpoint.
                          type: string
                        previous:
                          description: Previous is the identifier of the snapshot
                            from the previous checkpoint.
                          type: string
                      required:
                      - current
                      - previous
                      type: object
                    type: array
                  contentType:
                    description: 'DataVolumeContentType options: "kubevirt", "archive"'
                    enum:
                    - kubevirt
                    - archive
                    type: string
                  finalCheckpoint:
                    description: FinalCheckpoint indicates whether the current DataVolumeCheckpoint
                      is the final checkpoint.
                    type: boolean
                  preallocation:
                    description: Preallocation controls whether storage for DataVolumes
                      should be allocated in advance.
                    type: boolean
                  priorityClassName:
                    description: PriorityClassName for Importer, Cloner and Uploader
                      pod
                    type: string
                  pvc:
                    description: PVC is the PVC specification
                    properties:
                      accessModes:
                        description: |-
                          accessModes contains the desired access modes the volume should have.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      dataSource:
                        description: |-
                          dataSource field can be used to specify either:
                          * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot)
                          * An existing PVC (PersistentVolumeClaim)
                          If the provisioner or an external controller can support the specified data source,
                          it will create a new volume based on the contents of the specified data source.
                          When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef,
                          and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified.
                          If the namespace is specified, then dataSourceRef will not be copied to dataSource.
                        properties:
                          apiGroup:
                            description: |-
                              APIGroup is the group for the resource being referenced.
                              If APIGroup is not specified, the specified Kind must be in the core API group.
                              For any other third-party types, APIGroup is required.
                            type: string
                          kind:
                            description: Kind is the type of resource being referenced
                            type: string
                          name:
                            description: Name is the name of resource being referenced
                            type: string
                        required:
                        - kind
                        - name
                        type: object
                        x-kubernetes-map-type: atomic
                      dataSourceRef:
                        description: |-
                          dataSourceRef specifies the object from which to populate the volume with data, if a non-empty
                          volume is desired. This may be any object from a non-empty API group (non
                          core object) or a PersistentVolumeClaim object.
                          When this field is specified, volume binding will only succeed if the type of
                          the specified object matches some installed volume populator or dynamic
                          provisioner.
                          This field will replace the functionality of the dataSource field and as such
                          if both fields are non-empty, they must have the same value. For backwards
                          compatibility, when namespace isn't specified in dataSourceRef,
                          both fields (dataSource and dataSourceRef) will be set to the same
                          value automatically if one of them is empty and the other is non-empty.
                          When namespace is specified in dataSourceRef,
                          dataSource isn't set to the same value and must be empty.
                          There are three important differences between dataSource and dataSourceRef:
                          * While dataSource only allows two specific types of objects, dataSourceRef
                            allows any non-core object, as well as PersistentVolumeClaim objects.
                          * While dataSource ignores disallowed values (dropping them), dataSourceRef
                            preserves all values, and generates an error if a disallowed value is
                            specified.
                          * While dataSource only allows local objects, dataSourceRef allows objects
                            in any namespaces.
                          (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
                          (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
                        properties:
                          apiGroup:
                            description: |-
                              APIGroup is the group for the resource being referenced.
                              If APIGroup is not specified, the specified Kind must be in the core API group.
                              For any other third-party types, APIGroup is required.
                            type: string
                          kind:
                            description: Kind is the type of resource being referenced
                            type: string
                          name:
                            description: Name is the name of resource being referenced
                            type: string
                          namespace:
                            description: |-
                              Namespace is the namespace of resource being referenced
                              Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details.
                              (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
                            type: string
                        required:
                        - kind
                        - name
                        type: object
                      resources:
                        description: |-
                          resources represents the minimum resources the volume should have.
                          If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements
                          that are lower than previous value but must still be higher than capacity recorded in the
                          status field of the claim.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
                        properties:
                          limits:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: |-
                              Limits describes the maximum amount of compute resources allowed.
                              More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                            type: object
                          requests:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: |-
                              Requests describes the minimum amount of compute resources required.
                              If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
                              otherwise to an implementation-defined value. Requests cannot exceed Limits.
                              More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                            type: object
                        type: object
                      selector:
                        description: selector is a label query over volumes to consider
                          for binding.
                        properties:
                          matchExpressions:
                            description: matchExpressions is a list of label selector
                              requirements. The requirements are ANDed.
                            items:
                              description: |-
                                A label selector requirement is a selector that contains values, a key, and an operator that
                                relates the key and values.
                              properties:
                                key:
                                  description: key is the label key that the selector
                                    applies to.
                                  type: string
                                operator:
                                  description: |-
                                    operator represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists and DoesNotExist.
                                  type: string
                                values:
                                  description: |-
                                    values is an array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. This array is replaced during a strategic
                                    merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchLabels:
                            additionalProperties:
                              type: string
                            description: |-
                              matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                              map is equivalent to an element of matchExpressions, whose key field is "key", the
                              operator is "In", and the values array contains only "value". The requirements are ANDed.
                            type: object
                        type: object
                        x-kubernetes-map-type: atomic
                      storageClassName:
                        description: |-
                          storageClassName is the name of the StorageClass required by the claim.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
                        type: string
                      volumeAttributesClassName:
                        description: |-
                          volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim.
                          If specified, the CSI driver will create or update the volume with the attributes defined
                          in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName,
                          it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass
                          will be applied to the claim but it's not allowed to reset this field to empty string once it is set.
                          If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass
                          will be set by the persistentvolume controller if it exists.
                          If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be
                          set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource
                          exists.
                          More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/
                          (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
                        type: string
                      volumeMode:
                        description: |-
                          volumeMode defines what type of volume is required by the claim.
                          Value of Filesystem is implied when not included in claim spec.
                        type: string
                      volumeName:
                        description: volumeName is the binding reference to the PersistentVolume
                          backing this claim.
                        type: string
                    type: object
                  source:
                    description: Source is the src of the data for the requested DataVolume
                    properties:
                      blank:
                        description: DataVolumeBlankImage provides the parameters
                          to create a new raw blank image for the PVC
                        type: object
                      gcs:
                        description: DataVolumeSourceGCS provides the parameters to
                          create a Data Volume from an GCS source
                        properties:
                          secretRef:
                            description: SecretRef provides the secret reference needed
                              to access the GCS source
                            type: string
                          url:
                            description: URL is the url of the GCS source
                            type: string
                        required:
                        - url
                        type: object
                      http:
                        description: DataVolumeSourceHTTP can be either an http or
                          https endpoint, with an optional basic auth user name and
                          password, and an optional configmap containing additional
                          CAs
                        properties:
                          certConfigMap:
                            description: CertConfigMap is a configmap reference, containing
                              a Certificate Authority(CA) public key, and a base64
                              encoded pem certificate
                            type: string
                          extraHeaders:
                            description: ExtraHeaders is a list of strings containing
                              extra headers to include with HTTP transfer requests
                            items:
                              type: string
                            type: array
                          secretExtraHeaders:
                            description: SecretExtraHeaders is a list of Secret references,
                              each containing an extra HTTP header that may include
                              sensitive information
                            items:
                              type: string
                            type: array
                          secretRef:
                            description: SecretRef A Secret reference, the secret
                              should contain accessKeyId (user name) base64 encoded,
                              and secretKey (password) also base64 encoded
                            type: string
                          url:
                            description: URL is the URL of the http(s) endpoint
                            type: string
                        required:
                        - url
                        type: object
                      imageio:
                        description: DataVolumeSourceImageIO provides the parameters
                          to create a Data Volume from an imageio source
                        properties:
                          certConfigMap:
                            description: CertConfigMap provides a reference to the
                              CA cert
                            type: string
                          diskId:
                            description: DiskID provides id of a disk to be imported
                            type: string
                          secretRef:
                            description: SecretRef provides the secret reference needed
                              to access the ovirt-engine
                            type: string
                          url:
                            description: URL is the URL of the ovirt-engine
                            type: string
                        required:
                        - diskId
                        - url
                        type: object
                      pvc:
                        description: DataVolumeSourcePVC provides the parameters to
                          create a Data Volume from an existing PVC
                        properties:
                          name:
                            description: The name of the source PVC
                            type: string
                          namespace:
                            description: The namespace of the source PVC
                            type: string
                        required:
                        - name
                        - namespace
                        type: object
                      registry:
                        description: DataVolumeSourceRegistry provides the parameters
                          to create a Data Volume from an registry source
                        properties:
                          certConfigMap:
                            description: CertConfigMap provides a reference to the
                              Registry certs
                            type: string
                          imageStream:
                            description: ImageStream is the name of image stream for
                              import
                            type: string
                          pullMethod:
                            description: PullMethod can be either "pod" (default import),
                              or "node" (node docker cache based import)
                            type: string
                          secretRef:
                            description: SecretRef provides the secret reference needed
                              to access the Registry source
                            type: string
                          url:
                            description: 'URL is the url of the registry source (starting
                              with the scheme: docker, oci-archive)'
                            type: string
                        type: object
                      s3:
                        description: DataVolumeSourceS3 provides the parameters to
                          create a Data Volume from an S3 source
                        properties:
                          certConfigMap:
                            description: CertConfigMap is a configmap reference, containing
                              a Certificate Authority(CA) public key, and a base64
                              encoded pem certificate
                            type: string
                          secretRef:
                            description: SecretRef provides the secret reference needed
                              to access the S3 source
                            type: string
                          url:
                            description: URL is the url of the S3 source
                            type: string
                        required:
                        - url
                        type: object
                      snapshot:
                        description: DataVolumeSourceSnapshot provides the parameters
                          to create a Data Volume from an existing VolumeSnapshot
                        properties:
                          name:
                            description: The name of the source VolumeSnapshot
                            type: string
                          namespace:
                            description: The namespace of the source VolumeSnapshot
                            type: string
                        required:
                        - name
                        - namespace
                        type: object
                      upload:
                        description: DataVolumeSourceUpload provides the parameters
                          to create a Data Volume by uploading the source
                        type: object
                      vddk:
                        description: DataVolumeSourceVDDK provides the parameters
                          to create a Data Volume from a Vmware source
                        properties:
                          backingFile:
                            description: BackingFile is the path to the virtual hard
                              disk to migrate from vCenter/ESXi
                            type: string
                          initImageURL:
                            description: InitImageURL is an optional URL to an image
                              containing an extracted VDDK library, overrides v2v-vmware
                              config map
                            type: string
                          secretRef:
                            description: SecretRef provides a reference to a secret
                              containing the username and password needed to access
                              the vCenter or ESXi host
                            type: string
                          thumbprint:
                            description: Thumbprint is the certificate thumbprint
                              of the vCenter or ESXi host
                            type: string
                          url:
                            description: URL is the URL of the vCenter or ESXi host
                              with the VM to migrate
                            type: string
                          uuid:
                            description: UUID is the UUID of the virtual machine that
                              the backing file is attached to in vCenter/ESXi
                            type: string
                        type: object
                    type: object
                  sourceRef:
                    description: SourceRef is an indirect reference to the source
                      of data for the requested DataVolume
                    properties:
                      kind:
                        description: The kind of the source reference, currently only
                          "DataSource" is supported
                        type: string
                      name:
                        description: The name of the source reference
                        type: string
                      namespace:
                        description: The namespace of the source reference, defaults
                          to the DataVolume namespace
                        type: string
                    required:
                    - kind
                    - name
                    type: object
                  storage:
                    description: Storage is the requested storage specification
                    properties:
                      accessModes:
                        description: |-
                          AccessModes contains the desired access modes the volume should have.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
                        items:
                          type: string
                        type: array
                      dataSource:
                        description: |-
                          This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.
                          If the AnyVolumeDataSource feature gate is enabled, this field will always have the same contents as the DataSourceRef field.
                        properties:
                          apiGroup:
                            description: |-
                              APIGroup is the group for the resource being referenced.
                              If APIGroup is not specified, the specified Kind must be in the core API group.
                              For any other third-party types, APIGroup is required.
                            type: string
                          kind:
                            description: Kind is the type of resource being referenced
                            type: string
                          name:
                            description: Name is the name of resource being referenced
                            type: string
                        required:
                        - kind
                        - name
                        type: object
                        x-kubernetes-map-type: atomic
                      dataSourceRef:
                        description: |-
                          Specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any local object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner.
                          This field will replace the functionality of the DataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, both fields (DataSource and DataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty.
                          There are two important differences between DataSource and DataSourceRef:
                          * While DataSource only allows two specific types of objects, DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects.
                          * While DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and generates an error if a disallowed value is specified.
                          (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
                        properties:
                          apiGroup:
                            description: |-
                              APIGroup is the group for the resource being referenced.
                              If APIGroup is not specified, the specified Kind must be in the core API group.
                              For any other third-party types, APIGroup is required.
                            type: string
                          kind:
                            description: Kind is the type of resource being referenced
                            type: string
                          name:
                            description: Name is the name of resource being referenced
                            type: string
                          namespace:
                            description: |-
                              Namespace is the namespace of resource being referenced
                              Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details.
                              (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
                            type: string
                        required:
                        - kind
                        - name
                        type: object
                      resources:
                        description: |-
                          Resources represents the minimum resources the volume should have.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
                        properties:
                          limits:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: |-
                              Limits describes the maximum amount of compute resources allowed.
                              More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                            type: object
                          requests:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: |-
                              Requests describes the minimum amount of compute resources required.
                              If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
                              otherwise to an implementation-defined value. Requests cannot exceed Limits.
                              More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
                            type: object
                        type: object
                      selector:
                        description: A label query over volumes to consider for binding.
                        properties:
                          matchExpressions:
                            description: matchExpressions is a list of label selector
                              requirements. The requirements are ANDed.
                            items:
                              description: |-
                                A label selector requirement is a selector that contains values, a key, and an operator that
                                relates the key and values.
                              properties:
                                key:
                                  description: key is the label key that the selector
                                    applies to.
                                  type: string
                                operator:
                                  description: |-
                                    operator represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists and DoesNotExist.
                                  type: string
                                values:
                                  description: |-
                                    values is an array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. This array is replaced during a strategic
                                    merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchLabels:
                            additionalProperties:
                              type: string
                            description: |-
                              matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                              map is equivalent to an element of matchExpressions, whose key field is "key", the
                              operator is "In", and the values array contains only "value". The requirements are ANDed.
                            type: object
                        type: object
                        x-kubernetes-map-type: atomic
                      storageClassName:
                        description: |-
                          Name of the StorageClass required by the claim.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
                        type: string
                      volumeMode:
                        description: |-
                          volumeMode defines what type of volume is required by the claim.
                          Value of Filesystem is implied when not included in claim spec.
                        type: string
                      volumeName:
                        description: VolumeName is the binding reference to the PersistentVolume
                          backing this claim.
                        type: string
                    type: object
                type: object
              status:
                description: |-
                  DataVolumeTemplateDummyStatus is here simply for backwards compatibility with
                  a previous API.
                nullable: true
                type: object
            required:
            - spec
            type: object
          type: array
        instancetype:
          description: InstancetypeMatcher references a instancetype that is used
            to fill fields in Template
          properties:
            inferFromVolume:
              description: |-
                InferFromVolume lists the name of a volume that should be used to infer or discover the instancetype
                to be used through known annotations on the underlying resource. Once applied to the InstancetypeMatcher
                this field is removed.
              type: string
            inferFromVolumeFailurePolicy:
              description: |-
                InferFromVolumeFailurePolicy controls what should happen on failure when inferring the instancetype.
                Allowed values are: "RejectInferFromVolumeFailure" and "IgnoreInferFromVolumeFailure".
                If not specified, "RejectInferFromVolumeFailure" is used by default.
              type: string
            kind:
              description: |-
                Kind specifies which instancetype resource is referenced.
                Allowed values are: "VirtualMachineInstancetype" and "VirtualMachineClusterInstancetype".
                If not specified, "VirtualMachineClusterInstancetype" is used by default.
              type: string
            name:
              description: Name is the name of the VirtualMachineInstancetype or VirtualMachineClusterInstancetype
              type: string
            revisionName:
              description: |-
                RevisionName specifies a ControllerRevision containing a specific copy of the
                VirtualMachineInstancetype or VirtualMachineClusterInstancetype to be used. This is initially
                captured the first time the instancetype is applied to the VirtualMachineInstance.
              type: string
          type: object
        preference:
          description: PreferenceMatcher references a set of preference that is used
            to fill fields in Template
          properties:
            inferFromVolume:
              description: |-
                InferFromVolume lists the name of a volume that should be used to infer or discover the preference
                to be used through known annotations on the underlying resource. Once applied to the PreferenceMatcher
                this field is removed.
              type: string
            inferFromVolumeFailurePolicy:
              description: |-
                InferFromVolumeFailurePolicy controls what should happen on failure when preference the instancetype.
                Allowed values are: "RejectInferFromVolumeFailure" and "IgnoreInferFromVolumeFailure".
                If not specified, "RejectInferFromVolumeFailure" is used by default.
              type: string
            kind:
              description: |-
                Kind specifies which preference resource is referenced.
                Allowed values are: "VirtualMachinePreference" and "VirtualMachineClusterPreference".
                If not specified, "VirtualMachineClusterPreference" is used by default.
              type: string
            name:
              description: Name is the name of the VirtualMachinePreference or VirtualMachineClusterPreference
              type: string
            revisionName:
              description: |-
                RevisionName specifies a ControllerRevision containing a specific copy of the
                VirtualMachinePreference or VirtualMachineClusterPreference to be used. This is
                initially captured the first time the instancetype is applied to the VirtualMachineInstance.
              type: string
          type: object
        runStrategy:
          description: |-
            Running state indicates the requested running state of the VirtualMachineInstance
            mutually exclusive with Running
          type: string
        running:
          description: |-
            Running controls whether the associatied VirtualMachineInstance is created or not
            Mutually exclusive with RunStrategy
            Deprecated: VirtualMachineInstance field "Running" is now deprecated, please use RunStrategy instead.
          type: boolean
        template:
          description: Template is the direct specification of VirtualMachineInstance
          properties:
            metadata:
              nullable: true
              type: object
              x-kubernetes-preserve-unknown-fields: true
            spec:
              description: VirtualMachineInstance Spec contains the VirtualMachineInstance
                specification.
              properties:
                accessCredentials:
                  description: Specifies a set of public keys to inject into the vm
                    guest
                  items:
                    description: |-
                      AccessCredential represents a credential source that can be used to
                      authorize remote access to the vm guest
                      Only one of its members may be specified.
                    properties:
                      sshPublicKey:
                        description: |-
                          SSHPublicKey represents the source and method of applying a ssh public
                          key into a guest virtual machine.
                        properties:
                          propagationMethod:
                            description: PropagationMethod represents how the public
                              key is injected into the vm guest.
                            properties:
                              configDrive:
                                description: |-
                                  ConfigDrivePropagation means that the ssh public keys are injected
                                  into the VM using metadata using the configDrive cloud-init provider
                                type: object
                              noCloud:
                                description: |-
                                  NoCloudPropagation means that the ssh public keys are injected
                                  into the VM using metadata using the noCloud cloud-init provider
                                type: object
                              qemuGuestAgent:
                                description: |-
                                  QemuGuestAgentAccessCredentailPropagation means ssh public keys are
                                  dynamically injected into the vm at runtime via the qemu guest agent.
                                  This feature requires the qemu guest agent to be running within the guest.
                                properties:
                                  users:
                                    description: |-
                                      Users represents a list of guest users that should have the ssh public keys
                                      added to their authorized_keys file.
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: set
                                required:
                                - users
                                type: object
                            type: object
                          source:
                            description: Source represents where the public keys are
                              pulled from
                            properties:
                              secret:
                                description: Secret means that the access credential
                                  is pulled from a kubernetes secret
                                properties:
                                  secretName:
                                    description: SecretName represents the name of
                                      the secret in the VMI's namespace
                                    type: string
                                required:
                                - secretName
                                type: object
                            type: object
                        required:
                        - propagationMethod
                        - source
                        type: object
                      userPassword:
                        description: |-
                          UserPassword represents the source and method for applying a guest user's
                          password
                        properties:
                          propagationMethod:
                            description: propagationMethod represents how the user
                              passwords are injected into the vm guest.
                            properties:
                              qemuGuestAgent:
                                description: |-
                                  QemuGuestAgentAccessCredentailPropagation means passwords are
                                  dynamically injected into the vm at runtime via the qemu guest agent.
                                  This feature requires the qemu guest agent to be running within the guest.
                                type: object
                            type: object
                          source:
                            description: Source represents where the user passwords
                              are pulled from
                            properties:
                              secret:
                                description: Secret means that the access credential
                                  is pulled from a kubernetes secret
                                properties:
                                  secretName:
                                    description: SecretName represents the name of
                                      the secret in the VMI's namespace
                                    type: string
                                required:
                                - secretName
                                type: object
                            type: object
                        required:
                        - propagationMethod
                        - source
                        type: object
                    type: object
                  maxItems: 256
                  type: array
                  x-kubernetes-list-type: atomic
                affinity:
                  description: If affinity is specifies, obey all the affinity rules
                  properties:
                    nodeAffinity:
                      description: Describes node affinity scheduling rules for the
                        pod.
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node matches the corresponding matchExpressions; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: |-
                              An empty preferred scheduling term matches all objects with implicit weight 0
                              (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
                            properties:
                              preference:
                                description: A node selector term, associated with
                                  the corresponding weight.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              weight:
                                description: Weight associated with matching the corresponding
                                  nodeSelectorTerm, in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - preference
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to an update), the system
                            may or may not try to eventually evict the pod from its node.
                          properties:
                            nodeSelectorTerms:
                              description: Required. A list of node selector terms.
                                The terms are ORed.
                              items:
                                description: |-
                                  A null or empty node selector term matches no objects. The requirements of
                                  them are ANDed.
                                  The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              type: array
                              x-kubernetes-list-type: atomic
                          required:
                          - nodeSelectorTerms
                          type: object
                          x-kubernetes-map-type: atomic
                      type: object
                    podAffinity:
                      description: Describes pod affinity scheduling rules (e.g. co-locate
                        this pod in the same node, zone, etc. as some other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                    podAntiAffinity:
                      description: Describes pod anti-affinity scheduling rules (e.g.
                        avoid putting this pod in the same node, zone, etc. as some
                        other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the anti-affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling anti-affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the anti-affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the anti-affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                  type: object
                architecture:
                  description: Specifies the architecture of the vm guest you are
                    attempting to run. Defaults to the compiled architecture of the
                    KubeVirt components
                  type: string
                dnsConfig:
                  description: |-
                    Specifies the DNS parameters of a pod.
                    Parameters specified here will be merged to the generated DNS
                    configuration based on DNSPolicy.
                  properties:
                    nameservers:
                      description: |-
                        A list of DNS name server IP addresses.
                        This will be appended to the base nameservers generated from DNSPolicy.
                        Duplicated nameservers will be removed.
                      items:
                        type: string
                      type: array
                      x-kubernetes-list-type: atomic
                    options:
                      description: |-
                        A list of DNS resolver options.
                        This will be merged with the base options generated from DNSPolicy.
                        Duplicated entries will be removed. Resolution options given in Options
                        will override those that appear in the base DNSPolicy.
                      items:
                        description: PodDNSConfigOption defines DNS resolver options
                          of a pod.
                        properties:
                          name:
                            description: |-
                              Name is this DNS resolver option's name.
                              Required.
                            type: string
                          value:
                            description: Value is this DNS resolver option's value.
                            type: string
                        type: object
                      type: array
                      x-kubernetes-list-type: atomic
                    searches:
                      description: |-
                        A list of DNS search domains for host-name lookup.
                        This will be appended to the base search paths generated from DNSPolicy.
                        Duplicated search paths will be removed.
                      items:
                        type: string
                      type: array
                      x-kubernetes-list-type: atomic
                  type: object
                dnsPolicy:
                  description: |-
                    Set DNS policy for the pod.
                    Defaults to "ClusterFirst".
                    Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'.
                    DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy.
                    To have DNS options set along with hostNetwork, you have to specify DNS policy
                    explicitly to 'ClusterFirstWithHostNet'.
                  type: string
                domain:
                  description: Specification of the desired behavior of the VirtualMachineInstance
                    on the host.
                  properties:
                    chassis:
                      description: Chassis specifies the chassis info passed to the
                        domain.
                      properties:
                        asset:
                          type: string
                        manufacturer:
                          type: string
                        serial:
                          type: string
                        sku:
                          type: string
                        version:
                          type: string
                      type: object
                    clock:
                      description: Clock sets the clock and timers of the vmi.
                      properties:
                        timer:
                          description: Timer specifies whih timers are attached to
                            the vmi.
                          properties:
                            hpet:
                              description: HPET (High Precision Event Timer) - multiple
                                timers with periodic interrupts.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                                tickPolicy:
                                  description: |-
                                    TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                                    One of "delay", "catchup", "merge", "discard".
                                  type: string
                              type: object
                            hyperv:
                              description: Hyperv (Hypervclock) - lets guests read
                                the host’s wall clock time (paravirtualized). For
                                windows guests.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            kvm:
                              description: "KVM \t(KVM clock) - lets guests read the
                                host’s wall clock time (paravirtualized). For linux
                                guests."
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            pit:
                              description: PIT (Programmable Interval Timer) - a timer
                                with periodic interrupts.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                                tickPolicy:
                                  description: |-
                                    TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                                    One of "delay", "catchup", "discard".
                                  type: string
                              type: object
                            rtc:
                              description: RTC (Real Time Clock) - a continuously
                                running timer with periodic interrupts.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                                tickPolicy:
                                  description: |-
                                    TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                                    One of "delay", "catchup".
                                  type: string
                                track:
                                  description: Track the guest or the wall clock.
                                  type: string
                              type: object
                          type: object
                        timezone:
                          description: |-
                            Timezone sets the guest clock to the specified timezone.
                            Zone name follows the TZ environment variable format (e.g. 'America/New_York').
                          type: string
                        utc:
                          description: |-
                            UTC sets the guest clock to UTC on each boot. If an offset is specified,
                            guest changes to the clock will be kept during reboots and are not reset.
                          properties:
                            offsetSeconds:
                              description: |-
                                OffsetSeconds specifies an offset in seconds, relative to UTC. If set,
                                guest changes to the clock will be kept during reboots and not reset.
                              type: integer
                          type: object
                      type: object
                      x-kubernetes-preserve-unknown-fields: true
                    cpu:
                      description: CPU allow specified the detailed CPU topology inside
                        the vmi.
                      properties:
                        cores:
                          description: |-
                            Cores specifies the number of cores inside the vmi.
                            Must be a value greater or equal 1.
                          format: int32
                          type: integer
                        dedicatedCpuPlacement:
                          description: |-
                            DedicatedCPUPlacement requests the scheduler to place the VirtualMachineInstance on a node
                            with enough dedicated pCPUs and pin the vCPUs to it.
                          type: boolean
                        features:
                          description: Features specifies the CPU features list inside
                            the VMI.
                          items:
                            description: CPUFeature allows specifying a CPU feature.
                            properties:
                              name:
                                description: Name of the CPU feature
                                type: string
                              policy:
                                description: |-
                                  Policy is the CPU feature attribute which can have the following attributes:
                                  force    - The virtual CPU will claim the feature is supported regardless of it being supported by host CPU.
                                  require  - Guest creation will fail unless the feature is supported by the host CPU or the hypervisor is able to emulate it.
                                  optional - The feature will be supported by virtual CPU if and only if it is supported by host CPU.
                                  disable  - The feature will not be supported by virtual CPU.
                                  forbid   - Guest creation will fail if the feature is supported by host CPU.
                                  Defaults to require
                                type: string
                            required:
                            - name
                            type: object
                          type: array
                        isolateEmulatorThread:
                          description: |-
                            IsolateEmulatorThread requests one more dedicated pCPU to be allocated for the VMI to place
                            the emulator thread on it.
                          type: boolean
                        maxSockets:
                          description: |-
                            MaxSockets specifies the maximum amount of sockets that can
                            be hotplugged
                          format: int32
                          type: integer
                        model:
                          description: |-
                            Model specifies the CPU model inside the VMI.
                            List of available models https://github.com/libvirt/libvirt/tree/master/src/cpu_map.
                            It is possible to specify special cases like "host-passthrough" to get the same CPU as the node
                            and "host-model" to get CPU closest to the node one.
                            Defaults to host-model.
                          type: string
                        numa:
                          description: NUMA allows specifying settings for the guest
                            NUMA topology
                          properties:
                            guestMappingPassthrough:
                              description: |-
                                GuestMappingPassthrough will create an efficient guest topology based on host CPUs exclusively assigned to a pod.
                                The created topology ensures that memory and CPUs on the virtual numa nodes never cross boundaries of host numa nodes.
                              type: object
                          type: object
                        realtime:
                          description: Realtime instructs the virt-launcher to tune
                            the VMI for lower latency, optional for real time workloads
                          properties:
                            mask:
                              description: |-
                                Mask defines the vcpu mask expression that defines which vcpus are used for realtime. Format matches libvirt's expressions.
                                Example: "0-3,^1","0,2,3","2-3"
                              type: string
                          type: object
                        sockets:
                          description: |-
                            Sockets specifies the number of sockets inside the vmi.
                            Must be a value greater or equal 1.
                          format: int32
                          type: integer
                        threads:
                          description: |-
                            Threads specifies the number of threads inside the vmi.
                            Must be a value greater or equal 1.
                          format: int32
                          type: integer
                      type: object
                    devices:
                      description: Devices allows adding disks, network interfaces,
                        and others
                      properties:
                        autoattachGraphicsDevice:
                          description: |-
                            Whether to attach the default graphics device or not.
                            VNC will not be available if set to false. Defaults to true.
                          type: boolean
                        autoattachInputDevice:
                          description: |-
                            Whether to attach an Input Device.
                            Defaults to false.
                          type: boolean
                        autoattachMemBalloon:
                          description: |-
                            Whether to attach the Memory balloon device with default period.
                            Period can be adjusted in virt-config.
                            Defaults to true.
                          type: boolean
                        autoattachPodInterface:
                          description: Whether to attach a pod network interface.
                            Defaults to true.
                          type: boolean
                        autoattachSerialConsole:
                          description: |-
                            Whether to attach the default virtio-serial console or not.
                            Serial console access will not be available if set to false. Defaults to true.
                          type: boolean
                        autoattachVSOCK:
                          description: |-
                            Whether to attach the VSOCK CID to the VM or not.
                            VSOCK access will be available if set to true. Defaults to false.
                          type: boolean
                        blockMultiQueue:
                          description: |-
                            Whether or not to enable virtio multi-queue for block devices.
                            Defaults to false.
                          type: boolean
                        clientPassthrough:
                          description: To configure and access client devices such
                            as redirecting USB
                          type: object
                        disableHotplug:
                          description: DisableHotplug disabled the ability to hotplug
                            disks.
                          type: boolean
                        disks:
                          description: Disks describes disks, cdroms and luns which
                            are connected to the vmi.
                          items:
                            properties:
                              blockSize:
                                description: If specified, the virtual disk will be
                                  presented with the given block sizes.
                                properties:
                                  custom:
                                    description: CustomBlockSize represents the desired
                                      logical and physical block size for a VM disk.
                                    properties:
                                      logical:
                                        type: integer
                                      physical:
                                        type: integer
                                    required:
                                    - logical
                                    - physical
                                    type: object
                                  matchVolume:
                                    description: Represents if a feature is enabled
                                      or disabled.
                                    properties:
                                      enabled:
                                        description: |-
                                          Enabled determines if the feature should be enabled or disabled on the guest.
                                          Defaults to true.
                                        type: boolean
                                    type: object
                                type: object
                              bootOrder:
                                description: |-
                                  BootOrder is an integer value > 0, used to determine ordering of boot devices.
                                  Lower values take precedence.
                                  Each disk or interface that has a boot order must have a unique value.
                                  Disks without a boot order are not tried if a disk with a boot order exists.
                                type: integer
                              cache:
                                description: |-
                                  Cache specifies which kvm disk cache mode should be used.
                                  Supported values are:
                                  none: Guest I/O not cached on the host, but may be kept in a disk cache.
                                  writethrough: Guest I/O cached on the host but written through to the physical medium. Slowest but with most guarantees.
                                  writeback: Guest I/O cached on the host.
                                  Defaults to none if the storage supports O_DIRECT, otherwise writethrough.
                                type: string
                              cdrom:
                                description: Attach a volume as a cdrom to the vmi.
                                properties:
                                  bus:
                                    description: |-
                                      Bus indicates the type of disk device to emulate.
                                      supported values: virtio, sata, scsi.
                                    type: string
                                  readonly:
                                    description: |-
                                      ReadOnly.
                                      Defaults to true.
                                    type: boolean
                                  tray:
                                    description: |-
                                      Tray indicates if the tray of the device is open or closed.
                                      Allowed values are "open" and "closed".
                                      Defaults to closed.
                                    type: string
                                type: object
                              dedicatedIOThread:
                                description: |-
                                  dedicatedIOThread indicates this disk should have an exclusive IO Thread.
                                  Enabling this implies useIOThreads = true.
                                  Defaults to false.
                                type: boolean
                              disk:
                                description: Attach a volume as a disk to the vmi.
                                properties:
                                  bus:
                                    description: |-
                                      Bus indicates the type of disk device to emulate.
                                      supported values: virtio, sata, scsi, usb.
                                    type: string
                                  pciAddress:
                                    description: 'If specified, the virtual disk will
                                      be placed on the guests pci address with the
                                      specified PCI address. For example: 0000:81:01.10'
                                    type: string
                                  readonly:
                                    description: |-
                                      ReadOnly.
                                      Defaults to false.
                                    type: boolean
                                type: object
                              errorPolicy:
                                description: If specified, it can change the default
                                  error policy (stop) for the disk
                                type: string
                              io:
                                description: |-
                                  IO specifies which QEMU disk IO mode should be used.
                                  Supported values are: native, default, threads.
                                type: string
                              lun:
                                description: Attach a volume as a LUN to the vmi.
                                properties:
                                  bus:
                                    description: |-
                                      Bus indicates the type of disk device to emulate.
                                      supported values: virtio, sata, scsi.
                                    type: string
                                  readonly:
                                    description: |-
                                      ReadOnly.
                                      Defaults to false.
                                    type: boolean
                                  reservation:
                                    description: Reservation indicates if the disk
                                      needs to support the persistent reservation
                                      for the SCSI disk
                                    type: boolean
                                type: object
                              name:
                                description: Name is the device name
                                type: string
                              serial:
                                description: Serial provides the ability to specify
                                  a serial number for the disk device.
                                type: string
                              shareable:
                                description: If specified the disk is made sharable
                                  and multiple write from different VMs are permitted
                                type: boolean
                              tag:
                                description: If specified, disk address and its tag
                                  will be provided to the guest via config drive metadata
                                type: string
                            required:
                            - name
                            type: object
                          maxItems: 256
                          type: array
                        downwardMetrics:
                          description: DownwardMetrics creates a virtio serials for
                            exposing the downward metrics to the vmi.
                          type: object
                        filesystems:
                          description: Filesystems describes filesystem which is connected
                            to the vmi.
                          items:
                            properties:
                              name:
                                description: Name is the device name
                                type: string
                              virtiofs:
                                description: Virtiofs is supported
                                type: object
                            required:
                            - name
                            - virtiofs
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        gpus:
                          description: Whether to attach a GPU device to the vmi.
                          items:
                            properties:
                              claimName:
                                description: |-
                                  ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                                  device is allocated
                                type: string
                              deviceName:
                                description: DeviceName is the name of the device
                                  provisioned by device-plugins
                                type: string
                              name:
                                description: Name of the GPU device as exposed by
                                  a device plugin
                                type: string
                              requestName:
                                description: |-
                                  RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                                  device is requested
                                type: string
                              tag:
                                description: If specified, the virtual network interface
                                  address and its tag will be provided to the guest
                                  via config drive
                                type: string
                              virtualGPUOptions:
                                properties:
                                  display:
                                    properties:
                                      enabled:
                                        description: |-
                                          Enabled determines if a display addapter backed by a vGPU should be enabled or disabled on the guest.
                                          Defaults to true.
                                        type: boolean
                                      ramFB:
                                        description: |-
                                          Enables a boot framebuffer, until the guest OS loads a real GPU driver
                                          Defaults to true.
                                        properties:
                                          enabled:
                                            description: |-
                                              Enabled determines if the feature should be enabled or disabled on the guest.
                                              Defaults to true.
                                            type: boolean
                                        type: object
                                    type: object
                                type: object
                            required:
                            - name
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        hostDevices:
                          description: Whether to attach a host device to the vmi.
                          items:
                            properties:
                              claimName:
                                description: |-
                                  ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                                  device is allocated
                                type: string
                              deviceName:
                                description: DeviceName is the name of the device
                                  provisioned by device-plugins
                                type: string
                              name:
                                type: string
                              requestName:
                                description: |-
                                  RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                                  device is requested
                                type: string
                              tag:
                                description: If specified, the virtual network interface
                                  address and its tag will be provided to the guest
                                  via config drive
                                type: string
                            required:
                            - name
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        inputs:
                          description: Inputs describe input devices
                          items:
                            properties:
                              bus:
                                description: |-
                                  Bus indicates the bus of input device to emulate.
                                  Supported values: virtio, usb.
                                type: string
                              name:
                                description: Name is the device name
                                type: string
                              type:
                                description: |-
                                  Type indicated the type of input device.
                                  Supported values: tablet.
                                type: string
                            required:
                            - name
                            - type
                            type: object
                          type: array
                        interfaces:
                          description: Interfaces describe network interfaces which
                            are added to the vmi.
                          items:
                            properties:
                              acpiIndex:
                                description: |-
                                  If specified, the ACPI index is used to provide network interface device naming, that is stable across changes
                                  in PCI addresses assigned to the device.
                                  This value is required to be unique across all devices and be between 1 and (16*1024-1).
                                type: integer
                              binding:
                                description: |-
                                  Binding specifies the binding plugin that will be used to connect the interface to the guest.
                                  It provides an alternative to InterfaceBindingMethod.
                                  version: 1alphav1
                                properties:
                                  name:
                                    description: |-
                                      Name references to the binding name as denined in the kubevirt CR.
                                      version: 1alphav1
                                    type: string
                                required:
                                - name
                                type: object
                              bootOrder:
                                description: |-
                                  BootOrder is an integer value > 0, used to determine ordering of boot devices.
                                  Lower values take precedence.
                                  Each interface or disk that has a boot order must have a unique value.
                                  Interfaces without a boot order are not tried.
                                type: integer
                              bridge:
                                description: InterfaceBridge connects to a given network
                                  via a linux bridge.
                                type: object
                              dhcpOptions:
                                description: If specified the network interface will
                                  pass additional DHCP options to the VMI
                                properties:
                                  bootFileName:
                                    description: If specified will pass option 67
                                      to interface's DHCP server
                                    type: string
                                  ntpServers:
                                    description: If specified will pass the configured
                                      NTP server to the VM via DHCP option 042.
                                    items:
                                      type: string
                                    type: array
                                  privateOptions:
                                    description: 'If specified will pass extra DHCP
                                      options for private use, range: 224-254'
                                    items:
                                      description: DHCPExtraOptions defines Extra
                                        DHCP options for a VM.
                                      properties:
                                        option:
                                          description: |-
                                            Option is an Integer value from 224-254
                                            Required.
                                          type: integer
                                        value:
                                          description: |-
                                            Value is a String value for the Option provided
                                            Required.
                                          type: string
                                      required:
                                      - option
                                      - value
                                      type: object
                                    type: array
                                  tftpServerName:
                                    description: If specified will pass option 66
                                      to interface's DHCP server
                                    type: string
                                type: object
                              macAddress:
                                description: 'Interface MAC address. For example:
                                  de:ad:00:00:be:af or DE-AD-00-00-BE-AF.'
                                type: string
                              macvtap:
                                description: |-
                                  DeprecatedMacvtap is an alias to the deprecated Macvtap interface,
                                  please refer to Kubevirt user guide for alternatives.
                                  Deprecated: Removed in v1.3
                                type: object
                              masquerade:
                                description: InterfaceMasquerade connects to a given
                                  network using netfilter rules to nat the traffic.
                                type: object
                              model:
                                description: |-
                                  Interface model.
                                  One of: e1000, e1000e, igb, ne2k_pci, pcnet, rtl8139, virtio.
                                  Defaults to virtio.
                                type: string
                              name:
                                description: |-
                                  Logical name of the interface as well as a reference to the associated networks.
                                  Must match the Name of a Network.
                                type: string
                              passt:
                                description: |-
                                  DeprecatedPasst is an alias to the deprecated Passt interface,
                                  please refer to Kubevirt user guide for alternatives.
                                  Deprecated: Removed in v1.3
                                type: object
                              pciAddress:
                                description: 'If specified, the virtual network interface
                                  will be placed on the guests pci address with the
                                  specified PCI address. For example: 0000:81:01.10'
                                type: string
                              ports:
                                description: List of ports to be forwarded to the
                                  virtual machine.
                                items:
                                  description: |-
                                    Port represents a port to expose from the virtual machine.
                                    Default protocol TCP.
                                    The port field is mandatory
                                  properties:
                                    name:
                                      description: |-
                                        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
                                        named port in a pod must have a unique name. Name for the port that can be
                                        referred to by services.
                                      type: string
                                    port:
                                      description: |-
                                        Number of port to expose for the virtual machine.
                                        This must be a valid port number, 0 < x < 65536.
                                      format: int32
                                      type: integer
                                    protocol:
                                      description: |-
                                        Protocol for port. Must be UDP or TCP.
                                        Defaults to "TCP".
                                      type: string
                                  required:
                                  - port
                                  type: object
                                type: array
                              slirp:
                                description: |-
                                  DeprecatedSlirp is an alias to the deprecated Slirp interface
                                  Deprecated: Removed in v1.3
                                type: object
                              sriov:
                                description: InterfaceSRIOV connects to a given network
                                  by passing-through an SR-IOV PCI device via vfio.
                                type: object
                              state:
                                description: |-
                                  State represents the requested operational state of the interface.
                                  The supported values are:
                                  'absent', expressing a request to remove the interface.
                                  'down', expressing a request to set the link down.
                                  'up', expressing a request to set the link up.
                                  Empty value functions as 'up'.
                                type: string
                              tag:
                                description: If specified, the virtual network interface
                                  address and its tag will be provided to the guest
                                  via config drive
                                type: string
                            required:
                            - name
                            type: object
                          maxItems: 256
                          type: array
                        logSerialConsole:
                          description: |-
                            Whether to log the auto-attached default serial console or not.
                            Serial console logs will be collect to a file and then streamed from a named 'guest-console-log'.
                            Not relevant if autoattachSerialConsole is disabled.
                            Defaults to cluster wide setting on VirtualMachineOptions.
                          type: boolean
                        networkInterfaceMultiqueue:
                          description: If specified, virtual network interfaces configured
                            with a virtio bus will also enable the vhost multiqueue
                            feature for network devices. The number of queues created
                            depends on additional factors of the VirtualMachineInstance,
                            like the number of guest CPUs.
                          type: boolean
                        panicDevices:
                          description: PanicDevices provides additional crash information
                            when a guest crashes.
                          items:
                            properties:
                              model:
                                description: |-
                                  Model specifies what type of panic device is provided.
                                  The panic model used when this attribute is missing depends on the hypervisor and guest arch.
                                  One of: isa, hyperv, pvpanic.
                                type: string
                            type: object
                          type: array
                        rng:
                          description: Whether to have random number generator from
                            host
                          type: object
                        sound:
                          description: Whether to emulate a sound device.
                          properties:
                            model:
                              description: |-
                                We only support ich9 or ac97.
                                If SoundDevice is not set: No sound card is emulated.
                                If SoundDevice is set but Model is not: ich9
                              type: string
                            name:
                              description: User's defined name for this sound device
                              type: string
                          required:
                          - name
                          type: object
                        tpm:
                          description: Whether to emulate a TPM device.
                          properties:
                            enabled:
                              description: |-
                                Enabled allows a user to explicitly disable the vTPM even when one is enabled by a preference referenced by the VirtualMachine
                                Defaults to True
                              type: boolean
                            persistent:
                              description: |-
                                Persistent indicates the state of the TPM device should be kept accross reboots
                                Defaults to false
                              type: boolean
                          type: object
                        useVirtioTransitional:
                          description: |-
                            Fall back to legacy virtio 0.9 support if virtio bus is selected on devices.
                            This is helpful for old machines like CentOS6 or RHEL6 which
                            do not understand virtio_non_transitional (virtio 1.0).
                          type: boolean
                        video:
                          description: Video describes the video device configuration
                            for the vmi.
                          properties:
                            type:
                              description: |-
                                Type specifies the video device type (e.g., virtio, vga, bochs, ramfb).
                                If not specified, the default is architecture-dependent (VGA for BIOS-based VMs, Bochs for EFI-based VMs on AMD64; virtio for Arm and s390x).
                              type: string
                          type: object
                        watchdog:
                          description: Watchdog describes a watchdog device which
                            can be added to the vmi.
                          properties:
                            diag288:
                              description: diag288 watchdog device (specific to s390x
                                architecture).
                              properties:
                                action:
                                  description: |-
                                    The action to take. Valid values are poweroff, reset, shutdown.
                                    Defaults to reset.
                                  type: string
                              type: object
                            i6300esb:
                              description: i6300esb watchdog device.
                              properties:
                                action:
                                  description: |-
                                    The action to take. Valid values are poweroff, reset, shutdown.
                                    Defaults to reset.
                                  type: string
                              type: object
                            name:
                              description: Name of the watchdog.
                              type: string
                          required:
                          - name
                          type: object
                      type: object
                    features:
                      description: Features like acpi, apic, hyperv, smm.
                      properties:
                        acpi:
                          description: |-
                            ACPI enables/disables ACPI inside the guest.
                            Defaults to enabled.
                          properties:
                            enabled:
                              description: |-
                                Enabled determines if the feature should be enabled or disabled on the guest.
                                Defaults to true.
                              type: boolean
                          type: object
                        apic:
                          description: Defaults to the machine type setting.
                          properties:
                            enabled:
                              description: |-
                                Enabled determines if the feature should be enabled or disabled on the guest.
                                Defaults to true.
                              type: boolean
                            endOfInterrupt:
                              description: |-
                                EndOfInterrupt enables the end of interrupt notification in the guest.
                                Defaults to false.
                              type: boolean
                          type: object
                        hyperv:
                          description: Defaults to the machine type setting.
                          properties:
                            evmcs:
                              description: |-
                                EVMCS Speeds up L2 vmexits, but disables other virtualization features. Requires vapic.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            frequencies:
                              description: |-
                                Frequencies improves the TSC clock source handling for Hyper-V on KVM.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            ipi:
                              description: |-
                                IPI improves performances in overcommited environments. Requires vpindex.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            reenlightenment:
                              description: |-
                                Reenlightenment enables the notifications on TSC frequency changes.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            relaxed:
                              description: |-
                                Relaxed instructs the guest OS to disable watchdog timeouts.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            reset:
                              description: |-
                                Reset enables Hyperv reboot/reset for the vmi. Requires synic.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            runtime:
                              description: |-
                                Runtime improves the time accounting to improve scheduling in the guest.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            spinlocks:
                              description: Spinlocks allows to configure the spinlock
                                retry attempts.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                                spinlocks:
                                  description: |-
                                    Retries indicates the number of retries.
                                    Must be a value greater or equal 4096.
                                    Defaults to 4096.
                                  format: int32
                                  type: integer
                              type: object
                            synic:
                              description: |-
                                SyNIC enables the Synthetic Interrupt Controller.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            synictimer:
                              description: |-
                                SyNICTimer enables Synthetic Interrupt Controller Timers, reducing CPU load.
                                Defaults to the machine type setting.
                              properties:
                                direct:
                                  description: Represents if a feature is enabled
                                    or disabled.
                                  properties:
                                    enabled:
                                      description: |-
                                        Enabled determines if the feature should be enabled or disabled on the guest.
                                        Defaults to true.
                                      type: boolean
                                  type: object
                                enabled:
                                  type: boolean
                              type: object
                            tlbflush:
                              description: |-
                                TLBFlush improves performances in overcommited environments. Requires vpindex.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            vapic:
                              description: |-
                                VAPIC improves the paravirtualized handling of interrupts.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            vendorid:
                              description: |-
                                VendorID allows setting the hypervisor vendor id.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                                vendorid:
                                  description: |-
                                    VendorID sets the hypervisor vendor id, visible to the vmi.
                                    String up to twelve characters.
                                  type: string
                              type: object
                            vpindex:
                              description: |-
                                VPIndex enables the Virtual Processor Index to help windows identifying virtual processors.
                                Defaults to the machine type setting.
                              properties:
                                enabled:
                                  description: |-
                                    Enabled determines if the feature should be enabled or disabled on the guest.
                                    Defaults to true.
                                  type: boolean
                              type: object
                          type: object
                        hypervPassthrough:
                          description: |-
                            This enables all supported hyperv flags automatically.
                            Bear in mind that if this enabled hyperV features cannot
                            be enabled explicitly. In addition, a Virtual Machine
                            using it will be non-migratable.
                          properties:
                            enabled:
                              type: boolean
                          type: object
                        kvm:
                          description: Configure how KVM presence is exposed to the
                            guest.
                          properties:
                            hidden:
                              description: |-
                                Hide the KVM hypervisor from standard MSR based discovery.
                                Defaults to false
                              type: boolean
                          type: object
                        pvspinlock:
                          description: |-
                            Notify the guest that the host supports paravirtual spinlocks.
                            For older kernels this feature should be explicitly disabled.
                          properties:
                            enabled:
                              description: |-
                                Enabled determines if the feature should be enabled or disabled on the guest.
                                Defaults to true.
                              type: boolean
                          type: object
                        smm:
                          description: |-
                            SMM enables/disables System Management Mode.
                            TSEG not yet implemented.
                          properties:
                            enabled:
                              description: |-
                                Enabled determines if the feature should be enabled or disabled on the guest.
                                Defaults to true.
                              type: boolean
                          type: object
                      type: object
                    firmware:
                      description: Firmware.
                      properties:
                        acpi:
                          description: Information that can be set in the ACPI table
                          properties:
                            msdmNameRef:
                              description: |-
                                Similar to SlicNameRef, another ACPI entry that is used in more recent Windows versions.
                                The above points to the spec of MSDM too.
                              type: string
                            slicNameRef:
                              description: |-
                                SlicNameRef should match the volume name of a secret object. The data in the secret should
                                be a binary blob that follows the ACPI SLIC standard, see:
                                https://learn.microsoft.com/en-us/previous-versions/windows/hardware/design/dn653305(v=vs.85)
                              type: string
                          type: object
                        bootloader:
                          description: Settings to control the bootloader that is
                            used.
                          properties:
                            bios:
                              description: If set (default), BIOS will be used.
                              properties:
                                useSerial:
                                  description: If set, the BIOS output will be transmitted
                                    over serial
                                  type: boolean
                              type: object
                            efi:
                              description: If set, EFI will be used instead of BIOS.
                              properties:
                                persistent:
                                  description: |-
                                    If set to true, Persistent will persist the EFI NVRAM across reboots.
                                    Defaults to false
                                  type: boolean
                                secureBoot:
                                  description: |-
                                    If set, SecureBoot will be enabled and the OVMF roms will be swapped for
                                    SecureBoot-enabled ones.
                                    Requires SMM to be enabled.
                                    Defaults to true
                                  type: boolean
                              type: object
                          type: object
                        kernelBoot:
                          description: Settings to set the kernel for booting.
                          properties:
                            container:
                              description: Container defines the container that containes
                                kernel artifacts
                              properties:
                                image:
                                  description: Image that contains initrd / kernel
                                    files.
                                  type: string
                                imagePullPolicy:
                                  description: |-
                                    Image pull policy.
                                    One of Always, Never, IfNotPresent.
                                    Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
                                    Cannot be updated.
                                    More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
                                  type: string
                                imagePullSecret:
                                  description: ImagePullSecret is the name of the
                                    Docker registry secret required to pull the image.
                                    The secret must already exist.
                                  type: string
                                initrdPath:
                                  description: the fully-qualified path to the ramdisk
                                    image in the host OS
                                  type: string
                                kernelPath:
                                  description: The fully-qualified path to the kernel
                                    image in the host OS
                                  type: string
                              required:
                              - image
                              type: object
                            kernelArgs:
                              description: Arguments to be passed to the kernel at
                                boot time
                              type: string
                          type: object
                        serial:
                          description: The system-serial-number in SMBIOS
                          type: string
                        uuid:
                          description: |-
                            UUID reported by the vmi bios.
                            Defaults to a random generated uid.
                          type: string
                      type: object
                    ioThreads:
                      description: IOThreads specifies the IOThreads options.
                      properties:
                        supplementalPoolThreadCount:
                          description: SupplementalPoolThreadCount specifies how many
                            iothreads are allocated for the supplementalPool policy.
                          format: int32
                          type: integer
                      type: object
                    ioThreadsPolicy:
                      description: |-
                        Controls whether or not disks will share IOThreads.
                        Omitting IOThreadsPolicy disables use of IOThreads.
                        One of: shared, auto, supplementalPool
                      type: string
                    launchSecurity:
                      description: Launch Security setting of the vmi.
                      properties:
                        sev:
                          description: AMD Secure Encrypted Virtualization (SEV).
                          properties:
                            attestation:
                              description: If specified, run the attestation process
                                for a vmi.
                              type: object
                            dhCert:
                              description: Base64 encoded guest owner's Diffie-Hellman
                                key.
                              type: string
                            policy:
                              description: |-
                                Guest policy flags as defined in AMD SEV API specification.
                                Note: due to security reasons it is not allowed to enable guest debugging. Therefore NoDebug flag is not exposed to users and is always true.
                              properties:
                                encryptedState:
                                  description: |-
                                    SEV-ES is required.
                                    Defaults to false.
                                  type: boolean
                              type: object
                            session:
                              description: Base64 encoded session blob.
                              type: string
                          type: object
                      type: object
                    machine:
                      description: Machine type.
                      properties:
                        type:
                          description: QEMU machine type is the actual chipset of
                            the VirtualMachineInstance.
                          type: string
                      type: object
                    memory:
                      description: Memory allow specifying the VMI memory features.
                      properties:
                        guest:
                          anyOf:
                          - type: integer
                          - type: string
                          description: |-
                            Guest allows to specifying the amount of memory which is visible inside the Guest OS.
                            The Guest must lie between Requests and Limits from the resources section.
                            Defaults to the requested memory in the resources section if not specified.
                          pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                          x-kubernetes-int-or-string: true
                        hugepages:
                          description: Hugepages allow to use hugepages for the VirtualMachineInstance
                            instead of regular memory.
                          properties:
                            pageSize:
                              description: PageSize specifies the hugepage size, for
                                x86_64 architecture valid values are 1Gi and 2Mi.
                              type: string
                          type: object
                        maxGuest:
                          anyOf:
                          - type: integer
                          - type: string
                          description: |-
                            MaxGuest allows to specify the maximum amount of memory which is visible inside the Guest OS.
                            The delta between MaxGuest and Guest is the amount of memory that can be hot(un)plugged.
                          pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                          x-kubernetes-int-or-string: true
                      type: object
                    resources:
                      description: Resources describes the Compute Resources required
                        by this vmi.
                      properties:
                        limits:
                          additionalProperties:
                            anyOf:
                            - type: integer
                            - type: string
                            pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                            x-kubernetes-int-or-string: true
                          description: |-
                            Limits describes the maximum amount of compute resources allowed.
                            Valid resource keys are "memory" and "cpu".
                          type: object
                        overcommitGuestOverhead:
                          description: |-
                            Don't ask the scheduler to take the guest-management overhead into account. Instead
                            put the overhead only into the container's memory limit. This can lead to crashes if
                            all memory is in use on a node. Defaults to false.
                          type: boolean
                        requests:
                          additionalProperties:
                            anyOf:
                            - type: integer
                            - type: string
                            pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                            x-kubernetes-int-or-string: true
                          description: |-
                            Requests is a description of the initial vmi resources.
                            Valid resource keys are "memory" and "cpu".
                          type: object
                      type: object
                  required:
                  - devices
                  type: object
                evictionStrategy:
                  description: |-
                    EvictionStrategy describes the strategy to follow when a node drain occurs.
                    The possible options are:
                    - "None": No action will be taken, according to the specified 'RunStrategy' the VirtualMachine will be restarted or shutdown.
                    - "LiveMigrate": the VirtualMachineInstance will be migrated instead of being shutdown.
                    - "LiveMigrateIfPossible": the same as "LiveMigrate" but only if the VirtualMachine is Live-Migratable, otherwise it will behave as "None".
                    - "External": the VirtualMachineInstance will be protected and 'vmi.Status.EvacuationNodeName' will be set on eviction. This is mainly useful for cluster-api-provider-kubevirt (capk) which needs a way for VMI's to be blocked from eviction, yet signal capk that eviction has been called on the VMI so the capk controller can handle tearing the VMI down. Details can be found in the commit description https://github.com/kubevirt/kubevirt/commit/c1d77face705c8b126696bac9a3ee3825f27f1fa.
                  type: string
                hostname:
                  description: |-
                    Specifies the hostname of the vmi
                    If not specified, the hostname will be set to the name of the vmi, if dhcp or cloud-init is configured properly.
                  type: string
                livenessProbe:
                  description: |-
                    Periodic probe of VirtualMachineInstance liveness.
                    VirtualmachineInstances will be stopped if the probe fails.
                    Cannot be updated.
                    More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
                  properties:
                    exec:
                      description: |-
                        One and only one of the following should be specified.
                        Exec specifies the action to take, it will be executed on the guest through the qemu-guest-agent.
                        If the guest agent is not available, this probe will fail.
                      properties:
                        command:
                          description: |-
                            Command is the command line to execute inside the container, the working directory for the
                            command  is root ('/') in the container's filesystem. The command is simply exec'd, it is
                            not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use
                            a shell, you need to explicitly call out to that shell.
                            Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
                          items:
                            type: string
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                    failureThreshold:
                      description: |-
                        Minimum consecutive failures for the probe to be considered failed after having succeeded.
                        Defaults to 3. Minimum value is 1.
                      format: int32
                      type: integer
                    guestAgentPing:
                      description: GuestAgentPing contacts the qemu-guest-agent for
                        availability checks.
                      type: object
                    httpGet:
                      description: HTTPGet specifies the http request to perform.
                      properties:
                        host:
                          description: |-
                            Host name to connect to, defaults to the pod IP. You probably want to set
                            "Host" in httpHeaders instead.
                          type: string
                        httpHeaders:
                          description: Custom headers to set in the request. HTTP
                            allows repeated headers.
                          items:
                            description: HTTPHeader describes a custom header to be
                              used in HTTP probes
                            properties:
                              name:
                                description: |-
                                  The header field name.
                                  This will be canonicalized upon output, so case-variant names will be understood as the same header.
                                type: string
                              value:
                                description: The header field value
                                type: string
                            required:
                            - name
                            - value
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        path:
                          description: Path to access on the HTTP server.
                          type: string
                        port:
                          anyOf:
                          - type: integer
                          - type: string
                          description: |-
                            Name or number of the port to access on the container.
                            Number must be in the range 1 to 65535.
                            Name must be an IANA_SVC_NAME.
                          x-kubernetes-int-or-string: true
                        scheme:
                          description: |-
                            Scheme to use for connecting to the host.
                            Defaults to HTTP.
                          type: string
                      required:
                      - port
                      type: object
                    initialDelaySeconds:
                      description: |-
                        Number of seconds after the VirtualMachineInstance has started before liveness probes are initiated.
                        More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
                      format: int32
                      type: integer
                    periodSeconds:
                      description: |-
                        How often (in seconds) to perform the probe.
                        Default to 10 seconds. Minimum value is 1.
                      format: int32
                      type: integer
                    successThreshold:
                      description: |-
                        Minimum consecutive successes for the probe to be considered successful after having failed.
                        Defaults to 1. Must be 1 for liveness. Minimum value is 1.
                      format: int32
                      type: integer
                    tcpSocket:
                      description: |-
                        TCPSocket specifies an action involving a TCP port.
                        TCP hooks not yet supported
                      properties:
                        host:
                          description: 'Optional: Host name to connect to, defaults
                            to the pod IP.'
                          type: string
                        port:
                          anyOf:
                          - type: integer
                          - type: string
                          description: |-
                            Number or name of the port to access on the container.
                            Number must be in the range 1 to 65535.
                            Name must be an IANA_SVC_NAME.
                          x-kubernetes-int-or-string: true
                      required:
                      - port
                      type: object
                    timeoutSeconds:
                      description: |-
                        Number of seconds after which the probe times out.
                        For exec probes the timeout fails the probe but does not terminate the command running on the guest.
                        This means a blocking command can result in an increasing load on the guest.
                        A small buffer will be added to the resulting workload exec probe to compensate for delays
                        caused by the qemu guest exec mechanism.
                        Defaults to 1 second. Minimum value is 1.
                        More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
                      format: int32
                      type: integer
                  type: object
                networks:
                  description: List of networks that can be attached to a vm's virtual
                    interface.
                  items:
                    description: Network represents a network type and a resource
                      that should be connected to the vm.
                    properties:
                      multus:
                        description: Represents the multus cni network.
                        properties:
                          default:
                            description: |-
                              Select the default network and add it to the
                              multus-cni.io/default-network annotation.
                            type: boolean
                          networkName:
                            description: |-
                              References to a NetworkAttachmentDefinition CRD object. Format:
                              <networkName>, <namespace>/<networkName>. If namespace is not
                              specified, VMI namespace is assumed.
                            type: string
                        required:
                        - networkName
                        type: object
                      name:
                        description: |-
                          Network name.
                          Must be a DNS_LABEL and unique within the vm.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                      pod:
                        description: Represents the stock pod network interface.
                        properties:
                          vmIPv6NetworkCIDR:
                            description: |-
                              IPv6 CIDR for the vm network.
                              Defaults to fd10:0:2::/120 if not specified.
                            type: string
                          vmNetworkCIDR:
                            description: |-
                              CIDR for vm network.
                              Default 10.0.2.0/24 if not specified.
                            type: string
                        type: object
                    required:
                    - name
                    type: object
                  maxItems: 256
                  type: array
                nodeSelector:
                  additionalProperties:
                    type: string
                  description: |-
                    NodeSelector is a selector which must be true for the vmi to fit on a node.
                    Selector which must match a node's labels for the vmi to be scheduled on that node.
                    More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
                  type: object
                priorityClassName:
                  description: |-
                    If specified, indicates the pod's priority.
                    If not specified, the pod priority will be default or zero if there is no
                    default.
                  type: string
                readinessProbe:
                  description: |-
                    Periodic probe of VirtualMachineInstance service readiness.
                    VirtualmachineInstances will be removed from service endpoints if the probe fails.
                    Cannot be updated.
                    More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
                  properties:
                    exec:
                      description: |-
                        One and only one of the following should be specified.
                        Exec specifies the action to take, it will be executed on the guest through the qemu-guest-agent.
                        If the guest agent is not available, this probe will fail.
                      properties:
                        command:
                          description: |-
                            Command is the command line to execute inside the container, the working directory for the
                            command  is root ('/') in the container's filesystem. The command is simply exec'd, it is
                            not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use
                            a shell, you need to explicitly call out to that shell.
                            Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
                          items:
                            type: string
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                    failureThreshold:
                      description: |-
                        Minimum consecutive failures for the probe to be considered failed after having succeeded.
                        Defaults to 3. Minimum value is 1.
                      format: int32
                      type: integer
                    guestAgentPing:
                      description: GuestAgentPing contacts the qemu-guest-agent for
                        availability checks.
                      type: object
                    httpGet:
                      description: HTTPGet specifies the http request to perform.
                      properties:
                        host:
                          description: |-
                            Host name to connect to, defaults to the pod IP. You probably want to set
                            "Host" in httpHeaders instead.
                          type: string
                        httpHeaders:
                          description: Custom headers to set in the request. HTTP
                            allows repeated headers.
                          items:
                            description: HTTPHeader describes a custom header to be
                              used in HTTP probes
                            properties:
                              name:
                                description: |-
                                  The header field name.
                                  This will be canonicalized upon output, so case-variant names will be understood as the same header.
                                type: string
                              value:
                                description: The header field value
                                type: string
                            required:
                            - name
                            - value
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        path:
                          description: Path to access on the HTTP server.
                          type: string
                        port:
                          anyOf:
                          - type: integer
                          - type: string
                          description: |-
                            Name or number of the port to access on the container.
                            Number must be in the range 1 to 65535.
                            Name must be an IANA_SVC_NAME.
                          x-kubernetes-int-or-string: true
                        scheme:
                          description: |-
                            Scheme to use for connecting to the host.
                            Defaults to HTTP.
                          type: string
                      required:
                      - port
                      type: object
                    initialDelaySeconds:
                      description: |-
                        Number of seconds after the VirtualMachineInstance has started before liveness probes are initiated.
                        More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
                      format: int32
                      type: integer
                    periodSeconds:
                      description: |-
                        How often (in seconds) to perform the probe.
                        Default to 10 seconds. Minimum value is 1.
                      format: int32
                      type: integer
                    successThreshold:
                      description: |-
                        Minimum consecutive successes for the probe to be considered successful after having failed.
                        Defaults to 1. Must be 1 for liveness. Minimum value is 1.
                      format: int32
                      type: integer
                    tcpSocket:
                      description: |-
                        TCPSocket specifies an action involving a TCP port.
                        TCP hooks not yet supported
                      properties:
                        host:
                          description: 'Optional: Host name to connect to, defaults
                            to the pod IP.'
                          type: string
                        port:
                          anyOf:
                          - type: integer
                          - type: string
                          description: |-
                            Number or name of the port to access on the container.
                            Number must be in the range 1 to 65535.
                            Name must be an IANA_SVC_NAME.
                          x-kubernetes-int-or-string: true
                      required:
                      - port
                      type: object
                    timeoutSeconds:
                      description: |-
                        Number of seconds after which the probe times out.
                        For exec probes the timeout fails the probe but does not terminate the command running on the guest.
                        This means a blocking command can result in an increasing load on the guest.
                        A small buffer will be added to the resulting workload exec probe to compensate for delays
                        caused by the qemu guest exec mechanism.
                        Defaults to 1 second. Minimum value is 1.
                        More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
                      format: int32
                      type: integer
                  type: object
                resourceClaims:
                  description: |-
                    ResourceClaims define which ResourceClaims must be allocated
                    and reserved before the VMI, hence virt-launcher pod is allowed to start. The resources
                    will be made available to the domain which consumes them
                    by name.

                    This is an alpha field and requires enabling the
                    DynamicResourceAllocation feature gate in kubernetes
                     https://kubernetes.io/docs/concepts/scheduling-eviction/dynamic-resource-allocation/
                    This field should only be configured if one of the feature-gates GPUsWithDRA or HostDevicesWithDRA is enabled.
                    This feature is in alpha.
                  items:
                    description: |-
                      PodResourceClaim references exactly one ResourceClaim, either directly
                      or by naming a ResourceClaimTemplate which is then turned into a ResourceClaim
                      for the pod.

                      It adds a name to it that uniquely identifies the ResourceClaim inside the Pod.
                      Containers that need access to the ResourceClaim reference it with this name.
                    properties:
                      name:
                        description: |-
                          Name uniquely identifies this resource claim inside the pod.
                          This must be a DNS_LABEL.
                        type: string
                      resourceClaimName:
                        description: |-
                          ResourceClaimName is the name of a ResourceClaim object in the same
                          namespace as this pod.

                          Exactly one of ResourceClaimName and ResourceClaimTemplateName must
                          be set.
                        type: string
                      resourceClaimTemplateName:
                        description: |-
                          ResourceClaimTemplateName is the name of a ResourceClaimTemplate
                          object in the same namespace as this pod.

                          The template will be used to create a new ResourceClaim, which will
                          be bound to this pod. When this pod is deleted, the ResourceClaim
                          will also be deleted. The pod name and resource name, along with a
                          generated component, will be used to form a unique name for the
                          ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.

                          This field is immutable and no changes will be made to the
                          corresponding ResourceClaim by the control plane after creating the
                          ResourceClaim.

                          Exactly one of ResourceClaimName and ResourceClaimTemplateName must
                          be set.
                        type: string
                    required:
                    - name
                    type: object
                  type: array
                  x-kubernetes-list-map-keys:
                  - name
                  x-kubernetes-list-type: map
                schedulerName:
                  description: |-
                    If specified, the VMI will be dispatched by specified scheduler.
                    If not specified, the VMI will be dispatched by default scheduler.
                  type: string
                startStrategy:
                  description: StartStrategy can be set to "Paused" if Virtual Machine
                    should be started in paused state.
                  type: string
                subdomain:
                  description: |-
                    If specified, the fully qualified vmi hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>".
                    If not specified, the vmi will not have a domainname at all. The DNS entry will resolve to the vmi,
                    no matter if the vmi itself can pick up a hostname.
                  type: string
                terminationGracePeriodSeconds:
                  description: Grace period observed after signalling a VirtualMachineInstance
                    to stop after which the VirtualMachineInstance is force terminated.
                  format: int64
                  type: integer
                tolerations:
                  description: If toleration is specified, obey all the toleration
                    rules.
                  items:
                    description: |-
                      The pod this Toleration is attached to tolerates any taint that matches
                      the triple <key,value,effect> using the matching operator <operator>.
                    properties:
                      effect:
                        description: |-
                          Effect indicates the taint effect to match. Empty means match all taint effects.
                          When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
                        type: string
                      key:
                        description: |-
                          Key is the taint key that the toleration applies to. Empty means match all taint keys.
                          If the key is empty, operator must be Exists; this combination means to match all values and all keys.
                        type: string
                      operator:
                        description: |-
                          Operator represents a key's relationship to the value.
                          Valid operators are Exists and Equal. Defaults to Equal.
                          Exists is equivalent to wildcard for value, so that a pod can
                          tolerate all taints of a particular category.
                        type: string
                      tolerationSeconds:
                        description: |-
                          TolerationSeconds represents the period of time the toleration (which must be
                          of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
                          it is not set, which means tolerate the taint forever (do not evict). Zero and
                          negative values will be treated as 0 (evict immediately) by the system.
                        format: int64
                        type: integer
                      value:
                        description: |-
                          Value is the taint value the toleration matches to.
                          If the operator is Exists, the value should be empty, otherwise just a regular string.
                        type: string
                    type: object
                  type: array
                topologySpreadConstraints:
                  description: |-
                    TopologySpreadConstraints describes how a group of VMIs will be spread across a given topology
                    domains. K8s scheduler will schedule VMI pods in a way which abides by the constraints.
                  items:
                    description: TopologySpreadConstraint specifies how to spread
                      matching pods among the given topology.
                    properties:
                      labelSelector:
                        description: |-
                          LabelSelector is used to find matching pods.
                          Pods that match this label selector are counted to determine the number of pods
                          in their corresponding topology domain.
                        properties:
                          matchExpressions:
                            description: matchExpressions is a list of label selector
                              requirements. The requirements are ANDed.
                            items:
                              description: |-
                                A label selector requirement is a selector that contains values, a key, and an operator that
                                relates the key and values.
                              properties:
                                key:
                                  description: key is the label key that the selector
                                    applies to.
                                  type: string
                                operator:
                                  description: |-
                                    operator represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists and DoesNotExist.
                                  type: string
                                values:
                                  description: |-
                                    values is an array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. This array is replaced during a strategic
                                    merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchLabels:
                            additionalProperties:
                              type: string
                            description: |-
                              matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                              map is equivalent to an element of matchExpressions, whose key field is "key", the
                              operator is "In", and the values array contains only "value". The requirements are ANDed.
                            type: object
                        type: object
                        x-kubernetes-map-type: atomic
                      matchLabelKeys:
                        description: |-
                          MatchLabelKeys is a set of pod label keys to select the pods over which
                          spreading will be calculated. The keys are used to lookup values from the
                          incoming pod labels, those key-value labels are ANDed with labelSelector
                          to select the group of existing pods over which spreading will be calculated
                          for the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector.
                          MatchLabelKeys cannot be set when LabelSelector isn't set.
                          Keys that don't exist in the incoming pod labels will
                          be ignored. A null or empty list means only match against labelSelector.

                          This is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      maxSkew:
                        description: |-
                          MaxSkew describes the degree to which pods may be unevenly distributed.
                          When 'whenUnsatisfiable=DoNotSchedule', it is the maximum permitted difference
                          between the number of matching pods in the target topology and the global minimum.
                          The global minimum is the minimum number of matching pods in an eligible domain
                          or zero if the number of eligible domains is less than MinDomains.
                          For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
                          labelSelector spread as 2/2/1:
                          In this case, the global minimum is 1.
                          | zone1 | zone2 | zone3 |
                          |  P P  |  P P  |   P   |
                          - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2;
                          scheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2)
                          violate MaxSkew(1).
                          - if MaxSkew is 2, incoming pod can be scheduled onto any zone.
                          When 'whenUnsatisfiable=ScheduleAnyway', it is used to give higher precedence
                          to topologies that satisfy it.
                          It's a required field. Default value is 1 and 0 is not allowed.
                        format: int32
                        type: integer
                      minDomains:
                        description: |-
                          MinDomains indicates a minimum number of eligible domains.
                          When the number of eligible domains with matching topology keys is less than minDomains,
                          Pod Topology Spread treats "global minimum" as 0, and then the calculation of Skew is performed.
                          And when the number of eligible domains with matching topology keys equals or greater than minDomains,
                          this value has no effect on scheduling.
                          As a result, when the number of eligible domains is less than minDomains,
                          scheduler won't schedule more than maxSkew Pods to those domains.
                          If value is nil, the constraint behaves as if MinDomains is equal to 1.
                          Valid values are integers greater than 0.
                          When value is not nil, WhenUnsatisfiable must be DoNotSchedule.

                          For example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same
                          labelSelector spread as 2/2/2:
                          | zone1 | zone2 | zone3 |
                          |  P P  |  P P  |  P P  |
                          The number of domains is less than 5(MinDomains), so "global minimum" is treated as 0.
                          In this situation, new pod with the same labelSelector cannot be scheduled,
                          because computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones,
                          it will violate MaxSkew.
                        format: int32
                        type: integer
                      nodeAffinityPolicy:
                        description: |-
                          NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector
                          when calculating pod topology spread skew. Options are:
                          - Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations.
                          - Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.

                          If this value is nil, the behavior is equivalent to the Honor policy.
                          This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
                        type: string
                      nodeTaintsPolicy:
                        description: |-
                          NodeTaintsPolicy indicates how we will treat node taints when calculating
                          pod topology spread skew. Options are:
                          - Honor: nodes without taints, along with tainted nodes for which the incoming pod
                          has a toleration, are included.
                          - Ignore: node taints are ignored. All nodes are included.

                          If this value is nil, the behavior is equivalent to the Ignore policy.
                          This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
                        type: string
                      topologyKey:
                        description: |-
                          TopologyKey is the key of node labels. Nodes that have a label with this key
                          and identical values are considered to be in the same topology.
                          We consider each <key, value> as a "bucket", and try to put balanced number
                          of pods into each bucket.
                          We define a domain as a particular instance of a topology.
                          Also, we define an eligible domain as a domain whose nodes meet the requirements of
                          nodeAffinityPolicy and nodeTaintsPolicy.
                          e.g. If TopologyKey is "kubernetes.io/hostname", each Node is a domain of that topology.
                          And, if TopologyKey is "topology.kubernetes.io/zone", each zone is a domain of that topology.
                          It's a required field.
                        type: string
                      whenUnsatisfiable:
                        description: |-
                          WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy
                          the spread constraint.
                          - DoNotSchedule (default) tells the scheduler not to schedule it.
                          - ScheduleAnyway tells the scheduler to schedule the pod in any location,
                            but giving higher precedence to topologies that would help reduce the
                            skew.
                          A constraint is considered "Unsatisfiable" for an incoming pod
                          if and only if every possible node assignment for that pod would violate
                          "MaxSkew" on some topology.
                          For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
                          labelSelector spread as 3/1/1:
                          | zone1 | zone2 | zone3 |
                          | P P P |   P   |   P   |
                          If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled
                          to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies
                          MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler
                          won't make it *more* imbalanced.
                          It's a required field.
                        type: string
                    required:
                    - maxSkew
                    - topologyKey
                    - whenUnsatisfiable
                    type: object
                  type: array
                  x-kubernetes-list-map-keys:
                  - topologyKey
                  - whenUnsatisfiable
                  x-kubernetes-list-type: map
                volumes:
                  description: List of volumes that can be mounted by disks belonging
                    to the vmi.
                  items:
                    description: Volume represents a named volume in a vmi.
                    properties:
                      cloudInitConfigDrive:
                        description: |-
                          CloudInitConfigDrive represents a cloud-init Config Drive user-data source.
                          The Config Drive data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest.
                          More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html
                        properties:
                          networkData:
                            description: NetworkData contains config drive inline
                              cloud-init networkdata.
                            type: string
                          networkDataBase64:
                            description: NetworkDataBase64 contains config drive cloud-init
                              networkdata as a base64 encoded string.
                            type: string
                          networkDataSecretRef:
                            description: NetworkDataSecretRef references a k8s secret
                              that contains config drive networkdata.
                            properties:
                              name:
                                default: ""
                                description: |-
                                  Name of the referent.
                                  This field is effectively required, but due to backwards compatibility is
                                  allowed to be empty. Instances of this type with an empty value here are
                                  almost certainly wrong.
                                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                                type: string
                            type: object
                            x-kubernetes-map-type: atomic
                          secretRef:
                            description: UserDataSecretRef references a k8s secret
                              that contains config drive userdata.
                            properties:
                              name:
                                default: ""
                                description: |-
                                  Name of the referent.
                                  This field is effectively required, but due to backwards compatibility is
                                  allowed to be empty. Instances of this type with an empty value here are
                                  almost certainly wrong.
                                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                                type: string
                            type: object
                            x-kubernetes-map-type: atomic
                          userData:
                            description: UserData contains config drive inline cloud-init
                              userdata.
                            type: string
                          userDataBase64:
                            description: UserDataBase64 contains config drive cloud-init
                              userdata as a base64 encoded string.
                            type: string
                        type: object
                      cloudInitNoCloud:
                        description: |-
                          CloudInitNoCloud represents a cloud-init NoCloud user-data source.
                          The NoCloud data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest.
                          More info: http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html
                        properties:
                          networkData:
                            description: NetworkData contains NoCloud inline cloud-init
                              networkdata.
                            type: string
                          networkDataBase64:
                            description: NetworkDataBase64 contains NoCloud cloud-init
                              networkdata as a base64 encoded string.
                            type: string
                          networkDataSecretRef:
                            description: NetworkDataSecretRef references a k8s secret
                              that contains NoCloud networkdata.
                            properties:
                              name:
                                default: ""
                                description: |-
                                  Name of the referent.
                                  This field is effectively required, but due to backwards compatibility is
                                  allowed to be empty. Instances of this type with an empty value here are
                                  almost certainly wrong.
                                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                                type: string
                            type: object
                            x-kubernetes-map-type: atomic
                          secretRef:
                            description: UserDataSecretRef references a k8s secret
                              that contains NoCloud userdata.
                            properties:
                              name:
                                default: ""
                                description: |-
                                  Name of the referent.
                                  This field is effectively required, but due to backwards compatibility is
                                  allowed to be empty. Instances of this type with an empty value here are
                                  almost certainly wrong.
                                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                                type: string
                            type: object
                            x-kubernetes-map-type: atomic
                          userData:
                            description: UserData contains NoCloud inline cloud-init
                              userdata.
                            type: string
                          userDataBase64:
                            description: UserDataBase64 contains NoCloud cloud-init
                              userdata as a base64 encoded string.
                            type: string
                        type: object
                      configMap:
                        description: |-
                          ConfigMapSource represents a reference to a ConfigMap in the same namespace.
                          More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-pod-configmap/
                        properties:
                          name:
                            default: ""
                            description: |-
                              Name of the referent.
                              This field is effectively required, but due to backwards compatibility is
                              allowed to be empty. Instances of this type with an empty value here are
                              almost certainly wrong.
                              More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                            type: string
                          optional:
                            description: Specify whether the ConfigMap or it's keys
                              must be defined
                            type: boolean
                          volumeLabel:
                            description: |-
                              The volume label of the resulting disk inside the VMI.
                              Different bootstrapping mechanisms require different values.
                              Typical values are "cidata" (cloud-init), "config-2" (cloud-init) or "OEMDRV" (kickstart).
                            type: string
                        type: object
                        x-kubernetes-map-type: atomic
                      containerDisk:
                        description: |-
                          ContainerDisk references a docker image, embedding a qcow or raw disk.
                          More info: https://kubevirt.gitbooks.io/user-guide/registry-disk.html
                        properties:
                          image:
                            description: Image is the name of the image with the embedded
                              disk.
                            type: string
                          imagePullPolicy:
                            description: |-
                              Image pull policy.
                              One of Always, Never, IfNotPresent.
                              Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
                              Cannot be updated.
                              More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
                            type: string
                          imagePullSecret:
                            description: ImagePullSecret is the name of the Docker
                              registry secret required to pull the image. The secret
                              must already exist.
                            type: string
                          path:
                            description: Path defines the path to disk file in the
                              container
                            type: string
                        required:
                        - image
                        type: object
                      dataVolume:
                        description: |-
                          DataVolume represents the dynamic creation a PVC for this volume as well as
                          the process of populating that PVC with a disk image.
                        properties:
                          hotpluggable:
                            description: Hotpluggable indicates whether the volume
                              can be hotplugged and hotunplugged.
                            type: boolean
                          name:
                            description: Name of both the DataVolume and the PVC in
                              the same namespace.
                            type: string
                        required:
                        - name
                        type: object
                      downwardAPI:
                        description: DownwardAPI represents downward API about the
                          pod that should populate this volume
                        properties:
                          fields:
                            description: Fields is a list of downward API volume file
                            items:
                              description: DownwardAPIVolumeFile represents information
                                to create the file containing the pod field
                              properties:
                                fieldRef:
                                  description: 'Required: Selects a field of the pod:
                                    only annotations, labels, name, namespace and
                                    uid are supported.'
                                  properties:
                                    apiVersion:
                                      description: Version of the schema the FieldPath
                                        is written in terms of, defaults to "v1".
                                      type: string
                                    fieldPath:
                                      description: Path of the field to select in
                                        the specified API version.
                                      type: string
                                  required:
                                  - fieldPath
                                  type: object
                                  x-kubernetes-map-type: atomic
                                mode:
                                  description: |-
                                    Optional: mode bits used to set permissions on this file, must be an octal value
                                    between 0000 and 0777 or a decimal value between 0 and 511.
                                    YAML accepts both octal and decimal values, JSON requires decimal values for mode bits.
                                    If not specified, the volume defaultMode will be used.
                                    This might be in conflict with other options that affect the file
                                    mode, like fsGroup, and the result can be other mode bits set.
                                  format: int32
                                  type: integer
                                path:
                                  description: 'Required: Path is  the relative path
                                    name of the file to be created. Must not be absolute
                                    or contain the ''..'' path. Must be utf-8 encoded.
                                    The first item of the relative path must not start
                                    with ''..'''
                                  type: string
                                resourceFieldRef:
                                  description: |-
                                    Selects a resource of the container: only resources limits and requests
                                    (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
                                  properties:
                                    containerName:
                                      description: 'Container name: required for volumes,
                                        optional for env vars'
                                      type: string
                                    divisor:
                                      anyOf:
                                      - type: integer
                                      - type: string
                                      description: Specifies the output format of
                                        the exposed resources, defaults to "1"
                                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                                      x-kubernetes-int-or-string: true
                                    resource:
                                      description: 'Required: resource to select'
                                      type: string
                                  required:
                                  - resource
                                  type: object
                                  x-kubernetes-map-type: atomic
                              required:
                              - path
                              type: object
                            type: array
                          volumeLabel:
                            description: |-
                              The volume label of the resulting disk inside the VMI.
                              Different bootstrapping mechanisms require different values.
                              Typical values are "cidata" (cloud-init), "config-2" (cloud-init) or "OEMDRV" (kickstart).
                            type: string
                        type: object
                      downwardMetrics:
                        description: |-
                          DownwardMetrics adds a very small disk to VMIs which contains a limited view of host and guest
                          metrics. The disk content is compatible with vhostmd (https://github.com/vhostmd/vhostmd) and vm-dump-metrics.
                        type: object
                      emptyDisk:
                        description: |-
                          EmptyDisk represents a temporary disk which shares the vmis lifecycle.
                          More info: https://kubevirt.gitbooks.io/user-guide/disks-and-volumes.html
                        properties:
                          capacity:
                            anyOf:
                            - type: integer
                            - type: string
                            description: Capacity of the sparse disk.
                            pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                            x-kubernetes-int-or-string: true
                        required:
                        - capacity
                        type: object
                      ephemeral:
                        description: Ephemeral is a special volume source that "wraps"
                          specified source and provides copy-on-write image on top
                          of it.
                        properties:
                          persistentVolumeClaim:
                            description: |-
                              PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace.
                              Directly attached to the vmi via qemu.
                              More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                            properties:
                              claimName:
                                description: |-
                                  claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
                                  More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                                type: string
                              readOnly:
                                description: |-
                                  readOnly Will force the ReadOnly setting in VolumeMounts.
                                  Default false.
                                type: boolean
                            required:
                            - claimName
                            type: object
                        type: object
                      hostDisk:
                        description: HostDisk represents a disk created on the cluster
                          level
                        properties:
                          capacity:
                            anyOf:
                            - type: integer
                            - type: string
                            description: Capacity of the sparse disk
                            pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                            x-kubernetes-int-or-string: true
                          path:
                            description: The path to HostDisk image located on the
                              cluster
                            type: string
                          shared:
                            description: Shared indicate whether the path is shared
                              between nodes
                            type: boolean
                          type:
                            description: |-
                              Contains information if disk.img exists or should be created
                              allowed options are 'Disk' and 'DiskOrCreate'
                            type: string
                        required:
                        - path
                        - type
                        type: object
                      memoryDump:
                        description: MemoryDump is attached to the virt launcher and
                          is populated with a memory dump of the vmi
                        properties:
                          claimName:
                            description: |-
                              claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
                              More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                            type: string
                          hotpluggable:
                            description: Hotpluggable indicates whether the volume
                              can be hotplugged and hotunplugged.
                            type: boolean
                          readOnly:
                            description: |-
                              readOnly Will force the ReadOnly setting in VolumeMounts.
                              Default false.
                            type: boolean
                        required:
                        - claimName
                        type: object
                      name:
                        description: |-
                          Volume's name.
                          Must be a DNS_LABEL and unique within the vmi.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                      persistentVolumeClaim:
                        description: |-
                          PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace.
                          Directly attached to the vmi via qemu.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                        properties:
                          claimName:
                            description: |-
                              claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
                              More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                            type: string
                          hotpluggable:
                            description: Hotpluggable indicates whether the volume
                              can be hotplugged and hotunplugged.
                            type: boolean
                          readOnly:
                            description: |-
                              readOnly Will force the ReadOnly setting in VolumeMounts.
                              Default false.
                            type: boolean
                        required:
                        - claimName
                        type: object
                      secret:
                        description: |-
                          SecretVolumeSource represents a reference to a secret data in the same namespace.
                          More info: https://kubernetes.io/docs/concepts/configuration/secret/
                        properties:
                          optional:
                            description: Specify whether the Secret or it's keys must
                              be defined
                            type: boolean
                          secretName:
                            description: |-
                              Name of the secret in the pod's namespace to use.
                              More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
                            type: string
                          volumeLabel:
                            description: |-
                              The volume label of the resulting disk inside the VMI.
                              Different bootstrapping mechanisms require different values.
                              Typical values are "cidata" (cloud-init), "config-2" (cloud-init) or "OEMDRV" (kickstart).
                            type: string
                        type: object
                      serviceAccount:
                        description: |-
                          ServiceAccountVolumeSource represents a reference to a service account.
                          There can only be one volume of this type!
                          More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
                        properties:
                          serviceAccountName:
                            description: |-
                              Name of the service account in the pod's namespace to use.
                              More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
                            type: string
                        type: object
                      sysprep:
                        description: Represents a Sysprep volume source.
                        properties:
                          configMap:
                            description: ConfigMap references a ConfigMap that contains
                              Sysprep answer file named autounattend.xml that should
                              be attached as disk of CDROM type.
                            properties:
                              name:
                                default: ""
                                description: |-
                                  Name of the referent.
                                  This field is effectively required, but due to backwards compatibility is
                                  allowed to be empty. Instances of this type with an empty value here are
                                  almost certainly wrong.
                                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                                type: string
                            type: object
                            x-kubernetes-map-type: atomic
                          secret:
                            description: Secret references a k8s Secret that contains
                              Sysprep answer file named autounattend.xml that should
                              be attached as disk of CDROM type.
                            properties:
                              name:
                                default: ""
                                description: |-
                                  Name of the referent.
                                  This field is effectively required, but due to backwards compatibility is
                                  allowed to be empty. Instances of this type with an empty value here are
                                  almost certainly wrong.
                                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                                type: string
                            type: object
                            x-kubernetes-map-type: atomic
                        type: object
                    required:
                    - name
                    type: object
                  maxItems: 256
                  type: array
              required:
              - domain
              type: object
          type: object
        updateVolumesStrategy:
          description: UpdateVolumesStrategy is the strategy to apply on volumes updates
          type: string
      required:
      - template
      type: object
    status:
      description: |-
        Status holds the current state of the controller and brief information
        about its associated VirtualMachineInstance
      properties:
        conditions:
          description: Hold the state information of the VirtualMachine and its VirtualMachineInstance
          items:
            description: VirtualMachineCondition represents the state of VirtualMachine
            properties:
              lastProbeTime:
                format: date-time
                nullable: true
                type: string
              lastTransitionTime:
                format: date-time
                nullable: true
                type: string
              message:
                type: string
              reason:
                type: string
              status:
                type: string
              type:
                type: string
            required:
            - status
            - type
            type: object
          type: array
        created:
          description: Created indicates if the virtual machine is created in the
            cluster
          type: boolean
        desiredGeneration:
          description: |-
            DesiredGeneration is the generation which is desired for the VMI.
            This will be used in comparisons with ObservedGeneration to understand when
            the VMI is out of sync. This will be changed at the same time as
            ObservedGeneration to remove errors which could occur if Generation is
            updated through an Update() before ObservedGeneration in Status.
          format: int64
          type: integer
        instancetypeRef:
          description: InstancetypeRef captures the state of any referenced instance
            type from the VirtualMachine
          nullable: true
          properties:
            controllerRevisionRef:
              description: |-
                ControllerRef specifies the ControllerRevision storing a copy of the object captured
                when it is first seen by the VirtualMachine controller
              properties:
                name:
                  description: Name of the ControllerRevision
                  type: string
              type: object
            inferFromVolume:
              description: InferFromVolume lists the name of a volume that should
                be used to infer or discover the resource
              type: string
            inferFromVolumeFailurePolicy:
              description: InferFromVolumeFailurePolicy controls what should happen
                on failure when inferring the resource
              type: string
            kind:
              description: Kind specifies the kind of resource
              type: string
            name:
              description: Name is the name of resource
              type: string
          type: object
        memoryDumpRequest:
          description: |-
            MemoryDumpRequest tracks memory dump request phase and info of getting a memory
            dump to the given pvc
          nullable: true
          properties:
            claimName:
              description: ClaimName is the name of the pvc that will contain the
                memory dump
              type: string
            endTimestamp:
              description: EndTimestamp represents the time the memory dump was completed
              format: date-time
              type: string
            fileName:
              description: FileName represents the name of the output file
              type: string
            message:
              description: Message is a detailed message about failure of the memory
                dump
              type: string
            phase:
              description: Phase represents the memory dump phase
              type: string
            remove:
              description: Remove represents request of dissociating the memory dump
                pvc
              type: boolean
            startTimestamp:
              description: StartTimestamp represents the time the memory dump started
              format: date-time
              type: string
          required:
          - claimName
          - phase
          type: object
        observedGeneration:
          description: ObservedGeneration is the generation observed by the vmi when
            started.
          format: int64
          type: integer
        preferenceRef:
          description: PreferenceRef captures the state of any referenced preference
            from the VirtualMachine
          nullable: true
          properties:
            controllerRevisionRef:
              description: |-
                ControllerRef specifies the ControllerRevision storing a copy of the object captured
                when it is first seen by the VirtualMachine controller
              properties:
                name:
                  description: Name of the ControllerRevision
                  type: string
              type: object
            inferFromVolume:
              description: InferFromVolume lists the name of a volume that should
                be used to infer or discover the resource
              type: string
            inferFromVolumeFailurePolicy:
              description: InferFromVolumeFailurePolicy controls what should happen
                on failure when inferring the resource
              type: string
            kind:
              description: Kind specifies the kind of resource
              type: string
            name:
              description: Name is the name of resource
              type: string
          type: object
        printableStatus:
          default: Stopped
          description: PrintableStatus is a human readable, high-level representation
            of the status of the virtual machine
          type: string
        ready:
          description: Ready indicates if the virtual machine is running and ready
          type: boolean
        restoreInProgress:
          description: RestoreInProgress is the name of the VirtualMachineRestore
            currently executing
          type: string
        runStrategy:
          description: |-
            RunStrategy tracks the last recorded RunStrategy used by the VM.
            This is needed to correctly process the next strategy (for now only the RerunOnFailure)
          type: string
        snapshotInProgress:
          description: SnapshotInProgress is the name of the VirtualMachineSnapshot
            currently executing
          type: string
        startFailure:
          description: |-
            StartFailure tracks consecutive VMI startup failures for the purposes of
            crash loop backoffs
          nullable: true
          properties:
            consecutiveFailCount:
              type: integer
            lastFailedVMIUID:
              description: |-
                UID is a type that holds unique ID values, including UUIDs.  Because we
                don't ONLY use UUIDs, this is an alias to string.  Being a type captures
                intent and helps make sure that UIDs and names do not get conflated.
              type: string
            retryAfterTimestamp:
              format: date-time
              type: string
          type: object
        stateChangeRequests:
          description: |-
            StateChangeRequests indicates a list of actions that should be taken on a VMI
            e.g. stop a specific VMI then start a new one.
          items:
            properties:
              action:
                description: Indicates the type of action that is requested. e.g.
                  Start or Stop
                type: string
              data:
                additionalProperties:
                  type: string
                description: Provides additional data in order to perform the Action
                type: object
              uid:
                description: Indicates the UUID of an existing Virtual Machine Instance
                  that this change request applies to -- if applicable
                type: string
            required:
            - action
            type: object
          type: array
        volumeRequests:
          description: |-
            VolumeRequests indicates a list of volumes add or remove from the VMI template and
            hotplug on an active running VMI.
          items:
            properties:
              addVolumeOptions:
                description: |-
                  AddVolumeOptions when set indicates a volume should be added. The details
                  within this field specify how to add the volume
                properties:
                  disk:
                    description: Disk represents the hotplug disk that will be plugged
                      into the running VMI
                    properties:
                      blockSize:
                        description: If specified, the virtual disk will be presented
                          with the given block sizes.
                        properties:
                          custom:
                            description: CustomBlockSize represents the desired logical
                              and physical block size for a VM disk.
                            properties:
                              logical:
                                type: integer
                              physical:
                                type: integer
                            required:
                            - logical
                            - physical
                            type: object
                          matchVolume:
                            description: Represents if a feature is enabled or disabled.
                            properties:
                              enabled:
                                description: |-
                                  Enabled determines if the feature should be enabled or disabled on the guest.
                                  Defaults to true.
                                type: boolean
                            type: object
                        type: object
                      bootOrder:
                        description: |-
                          BootOrder is an integer value > 0, used to determine ordering of boot devices.
                          Lower values take precedence.
                          Each disk or interface that has a boot order must have a unique value.
                          Disks without a boot order are not tried if a disk with a boot order exists.
                        type: integer
                      cache:
                        description: |-
                          Cache specifies which kvm disk cache mode should be used.
                          Supported values are:
                          none: Guest I/O not cached on the host, but may be kept in a disk cache.
                          writethrough: Guest I/O cached on the host but written through to the physical medium. Slowest but with most guarantees.
                          writeback: Guest I/O cached on the host.
                          Defaults to none if the storage supports O_DIRECT, otherwise writethrough.
                        type: string
                      cdrom:
                        description: Attach a volume as a cdrom to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi.
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to true.
                            type: boolean
                          tray:
                            description: |-
                              Tray indicates if the tray of the device is open or closed.
                              Allowed values are "open" and "closed".
                              Defaults to closed.
                            type: string
                        type: object
                      dedicatedIOThread:
                        description: |-
                          dedicatedIOThread indicates this disk should have an exclusive IO Thread.
                          Enabling this implies useIOThreads = true.
                          Defaults to false.
                        type: boolean
                      disk:
                        description: Attach a volume as a disk to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi, usb.
                            type: string
                          pciAddress:
                            description: 'If specified, the virtual disk will be placed
                              on the guests pci address with the specified PCI address.
                              For example: 0000:81:01.10'
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to false.
                            type: boolean
                        type: object
                      errorPolicy:
                        description: If specified, it can change the default error
                          policy (stop) for the disk
                        type: string
                      io:
                        description: |-
                          IO specifies which QEMU disk IO mode should be used.
                          Supported values are: native, default, threads.
                        type: string
                      lun:
                        description: Attach a volume as a LUN to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi.
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to false.
                            type: boolean
                          reservation:
                            description: Reservation indicates if the disk needs to
                              support the persistent reservation for the SCSI disk
                            type: boolean
                        type: object
                      name:
                        description: Name is the device name
                        type: string
                      serial:
                        description: Serial provides the ability to specify a serial
                          number for the disk device.
                        type: string
                      shareable:
                        description: If specified the disk is made sharable and multiple
                          write from different VMs are permitted
                        type: boolean
                      tag:
                        description: If specified, disk address and its tag will be
                          provided to the guest via config drive metadata
                        type: string
                    required:
                    - name
                    type: object
                  dryRun:
                    description: |-
                      When present, indicates that modifications should not be
                      persisted. An invalid or unrecognized dryRun directive will
                      result in an error response and no further processing of the
                      request. Valid values are:
                      - All: all dry run stages will be processed
                    items:
                      type: string
                    type: array
                    x-kubernetes-list-type: atomic
                  name:
                    description: |-
                      Name represents the name that will be used to map the
                      disk to the corresponding volume. This overrides any name
                      set inside the Disk struct itself.
                    type: string
                  volumeSource:
                    description: VolumeSource represents the source of the volume
                      to map to the disk.
                    properties:
                      dataVolume:
                        description: |-
                          DataVolume represents the dynamic creation a PVC for this volume as well as
                          the process of populating that PVC with a disk image.
                        properties:
                          hotpluggable:
                            description: Hotpluggable indicates whether the volume
                              can be hotplugged and hotunplugged.
                            type: boolean
                          name:
                            description: Name of both the DataVolume and the PVC in
                              the same namespace.
                            type: string
                        required:
                        - name
                        type: object
                      persistentVolumeClaim:
                        description: |-
                          PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace.
                          Directly attached to the vmi via qemu.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                        properties:
                          claimName:
                            description: |-
                              claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
                              More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                            type: string
                          hotpluggable:
                            description: Hotpluggable indicates whether the volume
                              can be hotplugged and hotunplugged.
                            type: boolean
                          readOnly:
                            description: |-
                              readOnly Will force the ReadOnly setting in VolumeMounts.
                              Default false.
                            type: boolean
                        required:
                        - claimName
                        type: object
                    type: object
                required:
                - disk
                - name
                - volumeSource
                type: object
              removeVolumeOptions:
                description: |-
                  RemoveVolumeOptions when set indicates a volume should be removed. The details
                  within this field specify how to add the volume
                properties:
                  dryRun:
                    description: |-
                      When present, indicates that modifications should not be
                      persisted. An invalid or unrecognized dryRun directive will
                      result in an error response and no further processing of the
                      request. Valid values are:
                      - All: all dry run stages will be processed
                    items:
                      type: string
                    type: array
                    x-kubernetes-list-type: atomic
                  name:
                    description: |-
                      Name represents the name that maps to both the disk and volume that
                      should be removed
                    type: string
                required:
                - name
                type: object
            type: object
          type: array
          x-kubernetes-list-type: atomic
        volumeSnapshotStatuses:
          description: |-
            VolumeSnapshotStatuses indicates a list of statuses whether snapshotting is
            supported by each volume.
          items:
            properties:
              enabled:
                description: True if the volume supports snapshotting
                type: boolean
              name:
                description: Volume name
                type: string
              reason:
                description: Empty if snapshotting is enabled, contains reason otherwise
                type: string
            required:
            - enabled
            - name
            type: object
          type: array
        volumeUpdateState:
          description: |-
            VolumeUpdateState contains the information about the volumes set
            updates related to the volumeUpdateStrategy
          properties:
            volumeMigrationState:
              description: VolumeMigrationState tracks the information related to
                the volume migration
              properties:
                migratedVolumes:
                  description: MigratedVolumes lists the source and destination volumes
                    during the volume migration
                  items:
                    description: StorageMigratedVolumeInfo tracks the information
                      about the source and destination volumes during the volume migration
                    properties:
                      destinationPVCInfo:
                        description: DestinationPVCInfo contains the information about
                          the destination PVC
                        properties:
                          accessModes:
                            description: |-
                              AccessModes contains the desired access modes the volume should have.
                              More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          capacity:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: Capacity represents the capacity set on the
                              corresponding PVC status
                            type: object
                          claimName:
                            description: ClaimName is the name of the PVC
                            type: string
                          filesystemOverhead:
                            description: Percentage of filesystem's size to be reserved
                              when resizing the PVC
                            pattern: ^(0(?:\.\d{1,3})?|1)$
                            type: string
                          preallocated:
                            description: Preallocated indicates if the PVC's storage
                              is preallocated or not
                            type: boolean
                          requests:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: Requests represents the resources requested
                              by the corresponding PVC spec
                            type: object
                          volumeMode:
                            description: |-
                              VolumeMode defines what type of volume is required by the claim.
                              Value of Filesystem is implied when not included in claim spec.
                            type: string
                        type: object
                      sourcePVCInfo:
                        description: SourcePVCInfo contains the information about
                          the source PVC
                        properties:
                          accessModes:
                            description: |-
                              AccessModes contains the desired access modes the volume should have.
                              More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          capacity:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: Capacity represents the capacity set on the
                              corresponding PVC status
                            type: object
                          claimName:
                            description: ClaimName is the name of the PVC
                            type: string
                          filesystemOverhead:
                            description: Percentage of filesystem's size to be reserved
                              when resizing the PVC
                            pattern: ^(0(?:\.\d{1,3})?|1)$
                            type: string
                          preallocated:
                            description: Preallocated indicates if the PVC's storage
                              is preallocated or not
                            type: boolean
                          requests:
                            additionalProperties:
                              anyOf:
                              - type: integer
                              - type: string
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            description: Requests represents the resources requested
                              by the corresponding PVC spec
                            type: object
                          volumeMode:
                            description: |-
                              VolumeMode defines what type of volume is required by the claim.
                              Value of Filesystem is implied when not included in claim spec.
                            type: string
                        type: object
                      volumeName:
                        description: VolumeName is the name of the volume that is
                          being migrated
                        type: string
                    required:
                    - volumeName
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
              type: object
          type: object
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachineclone": `openAPIV3Schema:
  description: VirtualMachineClone is a CRD that clones one VM into another.
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      properties:
        annotationFilters:
          description: |-
            Example use: "!some/key*".
            For a detailed description, please refer to https://kubevirt.io/user-guide/operations/clone_api/#label-annotation-filters.
          items:
            type: string
          type: array
          x-kubernetes-list-type: atomic
        labelFilters:
          description: |-
            Example use: "!some/key*".
            For a detailed description, please refer to https://kubevirt.io/user-guide/operations/clone_api/#label-annotation-filters.
          items:
            type: string
          type: array
          x-kubernetes-list-type: atomic
        newMacAddresses:
          additionalProperties:
            type: string
          description: |-
            NewMacAddresses manually sets that target interfaces' mac addresses. The key is the interface name and the
            value is the new mac address. If this field is not specified, a new MAC address will
            be generated automatically, as for any interface that is not included in this map.
          type: object
        newSMBiosSerial:
          description: |-
            NewSMBiosSerial manually sets that target's SMbios serial. If this field is not specified, a new serial will
            be generated automatically.
          type: string
        patches:
          description: |-
            Patches holds JSON patches to apply to target. Patches should fit the target's Kind.
            Example: '{"op": "add", "path": "/spec/template/metadata/labels/example", "value": "new-label"}'
          items:
            type: string
          type: array
          x-kubernetes-list-type: atomic
        source:
          description: |-
            Source is the object that would be cloned. Currently supported source types are:
            VirtualMachine of kubevirt.io API group,
            VirtualMachineSnapshot of snapshot.kubevirt.io API group
          properties:
            apiGroup:
              description: |-
                APIGroup is the group for the resource being referenced.
                If APIGroup is not specified, the specified Kind must be in the core API group.
                For any other third-party types, APIGroup is required.
              type: string
            kind:
              description: Kind is the type of resource being referenced
              type: string
            name:
              description: Name is the name of resource being referenced
              type: string
          required:
          - kind
          - name
          type: object
          x-kubernetes-map-type: atomic
        target:
          description: |-
            Target is the outcome of the cloning process.
            Currently supported source types are:
            - VirtualMachine of kubevirt.io API group
            - Empty (nil).
            If the target is not provided, the target type would default to VirtualMachine and a random
            name would be generated for the target. The target's name can be viewed by
            inspecting status "TargetName" field below.
          properties:
            apiGroup:
              description: |-
                APIGroup is the group for the resource being referenced.
                If APIGroup is not specified, the specified Kind must be in the core API group.
                For any other third-party types, APIGroup is required.
              type: string
            kind:
              description: Kind is the type of resource being referenced
              type: string
            name:
              description: Name is the name of resource being referenced
              type: string
          required:
          - kind
          - name
          type: object
          x-kubernetes-map-type: atomic
        template:
          description: For a detailed description, please refer to https://kubevirt.io/user-guide/operations/clone_api/#label-annotation-filters.
          properties:
            annotationFilters:
              description: |-
                Example use: "!some/key*".
                For a detailed description, please refer to https://kubevirt.io/user-guide/operations/clone_api/#label-annotation-filters.
              items:
                type: string
              type: array
              x-kubernetes-list-type: atomic
            labelFilters:
              description: |-
                Example use: "!some/key*".
                For a detailed description, please refer to https://kubevirt.io/user-guide/operations/clone_api/#label-annotation-filters.
              items:
                type: string
              type: array
              x-kubernetes-list-type: atomic
          type: object
      required:
      - source
      type: object
    status:
      properties:
        conditions:
          items:
            description: Condition defines conditions
            properties:
              lastProbeTime:
                format: date-time
                nullable: true
                type: string
              lastTransitionTime:
                format: date-time
                nullable: true
                type: string
              message:
                type: string
              reason:
                type: string
              status:
                type: string
              type:
                description: ConditionType is the const type for Conditions
                type: string
            required:
            - status
            - type
            type: object
          type: array
          x-kubernetes-list-type: atomic
        creationTime:
          format: date-time
          nullable: true
          type: string
        phase:
          type: string
        restoreName:
          nullable: true
          type: string
        snapshotName:
          nullable: true
          type: string
        targetName:
          nullable: true
          type: string
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachineclusterinstancetype": `openAPIV3Schema:
  description: VirtualMachineClusterInstancetype is a cluster scoped version of VirtualMachineInstancetype
    resource.
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: Required spec describing the instancetype
      properties:
        annotations:
          additionalProperties:
            type: string
          description: Optionally defines the required Annotations to be used by the
            instance type and applied to the VirtualMachineInstance
          type: object
        cpu:
          description: Required CPU related attributes of the instancetype.
          properties:
            dedicatedCPUPlacement:
              description: |-
                DedicatedCPUPlacement requests the scheduler to place the VirtualMachineInstance on a node
                with enough dedicated pCPUs and pin the vCPUs to it.
              type: boolean
            guest:
              description: |-
                Required number of vCPUs to expose to the guest.

                The resulting CPU topology being derived from the optional PreferredCPUTopology attribute of CPUPreferences that itself defaults to PreferSockets.
              format: int32
              type: integer
            isolateEmulatorThread:
              description: |-
                IsolateEmulatorThread requests one more dedicated pCPU to be allocated for the VMI to place
                the emulator thread on it.
              type: boolean
            maxSockets:
              description: MaxSockets specifies the maximum amount of sockets that
                can be hotplugged
              format: int32
              type: integer
            model:
              description: |-
                Model specifies the CPU model inside the VMI.
                List of available models https://github.com/libvirt/libvirt/tree/master/src/cpu_map.
                It is possible to specify special cases like "host-passthrough" to get the same CPU as the node
                and "host-model" to get CPU closest to the node one.
                Defaults to host-model.
              type: string
            numa:
              description: NUMA allows specifying settings for the guest NUMA topology
              properties:
                guestMappingPassthrough:
                  description: |-
                    GuestMappingPassthrough will create an efficient guest topology based on host CPUs exclusively assigned to a pod.
                    The created topology ensures that memory and CPUs on the virtual numa nodes never cross boundaries of host numa nodes.
                  type: object
              type: object
            realtime:
              description: Realtime instructs the virt-launcher to tune the VMI for
                lower latency, optional for real time workloads
              properties:
                mask:
                  description: |-
                    Mask defines the vcpu mask expression that defines which vcpus are used for realtime. Format matches libvirt's expressions.
                    Example: "0-3,^1","0,2,3","2-3"
                  type: string
              type: object
          required:
          - guest
          type: object
        gpus:
          description: Optionally defines any GPU devices associated with the instancetype.
          items:
            properties:
              claimName:
                description: |-
                  ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                  device is allocated
                type: string
              deviceName:
                description: DeviceName is the name of the device provisioned by device-plugins
                type: string
              name:
                description: Name of the GPU device as exposed by a device plugin
                type: string
              requestName:
                description: |-
                  RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                  device is requested
                type: string
              tag:
                description: If specified, the virtual network interface address and
                  its tag will be provided to the guest via config drive
                type: string
              virtualGPUOptions:
                properties:
                  display:
                    properties:
                      enabled:
                        description: |-
                          Enabled determines if a display addapter backed by a vGPU should be enabled or disabled on the guest.
                          Defaults to true.
                        type: boolean
                      ramFB:
                        description: |-
                          Enables a boot framebuffer, until the guest OS loads a real GPU driver
                          Defaults to true.
                        properties:
                          enabled:
                            description: |-
                              Enabled determines if the feature should be enabled or disabled on the guest.
                              Defaults to true.
                            type: boolean
                        type: object
                    type: object
                type: object
            required:
            - name
            type: object
          type: array
          x-kubernetes-list-type: atomic
        hostDevices:
          description: Optionally defines any HostDevices associated with the instancetype.
          items:
            properties:
              claimName:
                description: |-
                  ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                  device is allocated
                type: string
              deviceName:
                description: DeviceName is the name of the device provisioned by device-plugins
                type: string
              name:
                type: string
              requestName:
                description: |-
                  RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                  device is requested
                type: string
              tag:
                description: If specified, the virtual network interface address and
                  its tag will be provided to the guest via config drive
                type: string
            required:
            - name
            type: object
          type: array
          x-kubernetes-list-type: atomic
        ioThreadsPolicy:
          description: Optionally defines the IOThreadsPolicy to be used by the instancetype.
          type: string
        launchSecurity:
          description: Optionally defines the LaunchSecurity to be used by the instancetype.
          properties:
            sev:
              description: AMD Secure Encrypted Virtualization (SEV).
              properties:
                attestation:
                  description: If specified, run the attestation process for a vmi.
                  type: object
                dhCert:
                  description: Base64 encoded guest owner's Diffie-Hellman key.
                  type: string
                policy:
                  description: |-
                    Guest policy flags as defined in AMD SEV API specification.
                    Note: due to security reasons it is not allowed to enable guest debugging. Therefore NoDebug flag is not exposed to users and is always true.
                  properties:
                    encryptedState:
                      description: |-
                        SEV-ES is required.
                        Defaults to false.
                      type: boolean
                  type: object
                session:
                  description: Base64 encoded session blob.
                  type: string
              type: object
          type: object
        memory:
          description: Required Memory related attributes of the instancetype.
          properties:
            guest:
              anyOf:
              - type: integer
              - type: string
              description: Required amount of memory which is visible inside the guest
                OS.
              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
              x-kubernetes-int-or-string: true
            hugepages:
              description: Optionally enables the use of hugepages for the VirtualMachineInstance
                instead of regular memory.
              properties:
                pageSize:
                  description: PageSize specifies the hugepage size, for x86_64 architecture
                    valid values are 1Gi and 2Mi.
                  type: string
              type: object
            maxGuest:
              anyOf:
              - type: integer
              - type: string
              description: |-
                MaxGuest allows to specify the maximum amount of memory which is visible inside the Guest OS.
                The delta between MaxGuest and Guest is the amount of memory that can be hot(un)plugged.
              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
              x-kubernetes-int-or-string: true
            overcommitPercent:
              description: |-
                OvercommitPercent is the percentage of the guest memory which will be overcommitted.
                This means that the VMIs parent pod (virt-launcher) will request less
                physical memory by a factor specified by the OvercommitPercent.
                Overcommits can lead to memory exhaustion, which in turn can lead to crashes. Use carefully.
                Defaults to 0
              maximum: 100
              minimum: 0
              type: integer
          required:
          - guest
          type: object
        nodeSelector:
          additionalProperties:
            type: string
          description: |-
            NodeSelector is a selector which must be true for the vmi to fit on a node.
            Selector which must match a node's labels for the vmi to be scheduled on that node.
            More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/

            NodeSelector is the name of the custom node selector for the instancetype.
          type: object
        schedulerName:
          description: |-
            If specified, the VMI will be dispatched by specified scheduler.
            If not specified, the VMI will be dispatched by default scheduler.

            SchedulerName is the name of the custom K8s scheduler for the instancetype.
          type: string
      required:
      - cpu
      - memory
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachineclusterpreference": `openAPIV3Schema:
  description: VirtualMachineClusterPreference is a cluster scoped version of the
    VirtualMachinePreference resource.
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: Required spec describing the preferences
      properties:
        annotations:
          additionalProperties:
            type: string
          description: Optionally defines preferred Annotations to be applied to the
            VirtualMachineInstance
          type: object
        clock:
          description: Clock optionally defines preferences associated with the Clock
            attribute of a VirtualMachineInstance DomainSpec
          properties:
            preferredClockOffset:
              description: ClockOffset allows specifying the UTC offset or the timezone
                of the guest clock.
              properties:
                timezone:
                  description: |-
                    Timezone sets the guest clock to the specified timezone.
                    Zone name follows the TZ environment variable format (e.g. 'America/New_York').
                  type: string
                utc:
                  description: |-
                    UTC sets the guest clock to UTC on each boot. If an offset is specified,
                    guest changes to the clock will be kept during reboots and are not reset.
                  properties:
                    offsetSeconds:
                      description: |-
                        OffsetSeconds specifies an offset in seconds, relative to UTC. If set,
                        guest changes to the clock will be kept during reboots and not reset.
                      type: integer
                  type: object
              type: object
            preferredTimer:
              description: Timer specifies whih timers are attached to the vmi.
              properties:
                hpet:
                  description: HPET (High Precision Event Timer) - multiple timers
                    with periodic interrupts.
                  properties:
                    present:
                      description: |-
                        Enabled set to false makes sure that the machine type or a preset can't add the timer.
                        Defaults to true.
                      type: boolean
                    tickPolicy:
                      description: |-
                        TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                        One of "delay", "catchup", "merge", "discard".
                      type: string
                  type: object
                hyperv:
                  description: Hyperv (Hypervclock) - lets guests read the host’s
                    wall clock time (paravirtualized). For windows guests.
                  properties:
                    present:
                      description: |-
                        Enabled set to false makes sure that the machine type or a preset can't add the timer.
                        Defaults to true.
                      type: boolean
                  type: object
                kvm:
                  description: "KVM \t(KVM clock) - lets guests read the host’s wall
                    clock time (paravirtualized). For linux guests."
                  properties:
                    present:
                      description: |-
                        Enabled set to false makes sure that the machine type or a preset can't add the timer.
                        Defaults to true.
                      type: boolean
                  type: object
                pit:
                  description: PIT (Programmable Interval Timer) - a timer with periodic
                    interrupts.
                  properties:
                    present:
                      description: |-
                        Enabled set to false makes sure that the machine type or a preset can't add the timer.
                        Defaults to true.
                      type: boolean
                    tickPolicy:
                      description: |-
                        TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                        One of "delay", "catchup", "discard".
                      type: string
                  type: object
                rtc:
                  description: RTC (Real Time Clock) - a continuously running timer
                    with periodic interrupts.
                  properties:
                    present:
                      description: |-
                        Enabled set to false makes sure that the machine type or a preset can't add the timer.
                        Defaults to true.
                      type: boolean
                    tickPolicy:
                      description: |-
                        TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                        One of "delay", "catchup".
                      type: string
                    track:
                      description: Track the guest or the wall clock.
                      type: string
                  type: object
              type: object
          type: object
        cpu:
          description: CPU optionally defines preferences associated with the CPU
            attribute of a VirtualMachineInstance DomainSpec
          properties:
            preferredCPUFeatures:
              description: PreferredCPUFeatures optionally defines a slice of preferred
                CPU features.
              items:
                description: CPUFeature allows specifying a CPU feature.
                properties:
                  name:
                    description: Name of the CPU feature
                    type: string
                  policy:
                    description: |-
                      Policy is the CPU feature attribute which can have the following attributes:
                      force    - The virtual CPU will claim the feature is supported regardless of it being supported by host CPU.
                      require  - Guest creation will fail unless the feature is supported by the host CPU or the hypervisor is able to emulate it.
                      optional - The feature will be supported by virtual CPU if and only if it is supported by host CPU.
                      disable  - The feature will not be supported by virtual CPU.
                      forbid   - Guest creation will fail if the feature is supported by host CPU.
                      Defaults to require
                    type: string
                required:
                - name
                type: object
              type: array
            preferredCPUTopology:
              description: PreferredCPUTopology optionally defines the preferred guest
                visible CPU topology, defaults to PreferSockets.
              type: string
            spreadOptions:
              properties:
                across:
                  description: |-
                    Across optionally defines how to spread vCPUs across the guest visible topology.
                    Default: SocketsCores
                  type: string
                ratio:
                  description: |-
                    Ratio optionally defines the ratio to spread vCPUs across the guest visible topology:

                    CoresThreads        - 1:2   - Controls the ratio of cores to threads. Only a ratio of 2 is currently accepted.
                    SocketsCores        - 1:N   - Controls the ratio of socket to cores.
                    SocketsCoresThreads - 1:N:2 - Controls the ratio of socket to cores. Each core providing 2 threads.

                    Default: 2
                  format: int32
                  type: integer
              type: object
          type: object
        devices:
          description: Devices optionally defines preferences associated with the
            Devices attribute of a VirtualMachineInstance DomainSpec
          properties:
            preferredAutoattachGraphicsDevice:
              description: PreferredAutoattachGraphicsDevice optionally defines the
                preferred value of AutoattachGraphicsDevice
              type: boolean
            preferredAutoattachInputDevice:
              description: PreferredAutoattachInputDevice optionally defines the preferred
                value of AutoattachInputDevice
              type: boolean
            preferredAutoattachMemBalloon:
              description: PreferredAutoattachMemBalloon optionally defines the preferred
                value of AutoattachMemBalloon
              type: boolean
            preferredAutoattachPodInterface:
              description: PreferredAutoattachPodInterface optionally defines the
                preferred value of AutoattachPodInterface
              type: boolean
            preferredAutoattachSerialConsole:
              description: PreferredAutoattachSerialConsole optionally defines the
                preferred value of AutoattachSerialConsole
              type: boolean
            preferredBlockMultiQueue:
              description: PreferredBlockMultiQueue optionally enables the vhost multiqueue
                feature for virtio disks.
              type: boolean
            preferredCdromBus:
              description: PreferredCdromBus optionally defines the preferred bus
                for Cdrom Disk devices.
              type: string
            preferredDisableHotplug:
              description: PreferredDisableHotplug optionally defines the preferred
                value of DisableHotplug
              type: boolean
            preferredDiskBlockSize:
              description: PreferredBlockSize optionally defines the block size of
                Disk devices.
              properties:
                custom:
                  description: CustomBlockSize represents the desired logical and
                    physical block size for a VM disk.
                  properties:
                    logical:
                      type: integer
                    physical:
                      type: integer
                  required:
                  - logical
                  - physical
                  type: object
                matchVolume:
                  description: Represents if a feature is enabled or disabled.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
              type: object
            preferredDiskBus:
              description: PreferredDiskBus optionally defines the preferred bus for
                Disk Disk devices.
              type: string
            preferredDiskCache:
              description: PreferredCache optionally defines the DriverCache to be
                used by Disk devices.
              type: string
            preferredDiskDedicatedIoThread:
              description: PreferredDedicatedIoThread optionally enables dedicated
                IO threads for Disk devices using the virtio bus.
              type: boolean
            preferredDiskIO:
              description: PreferredIo optionally defines the QEMU disk IO mode to
                be used by Disk devices.
              type: string
            preferredInputBus:
              description: PreferredInputBus optionally defines the preferred bus
                for Input devices.
              type: string
            preferredInputType:
              description: PreferredInputType optionally defines the preferred type
                for Input devices.
              type: string
            preferredInterfaceMasquerade:
              description: PreferredInterfaceMasquerade optionally defines the preferred
                masquerade configuration to use with each network interface.
              type: object
            preferredInterfaceModel:
              description: PreferredInterfaceModel optionally defines the preferred
                model to be used by Interface devices.
              type: string
            preferredLunBus:
              description: PreferredLunBus optionally defines the preferred bus for
                Lun Disk devices.
              type: string
            preferredNetworkInterfaceMultiQueue:
              description: PreferredNetworkInterfaceMultiQueue optionally enables
                the vhost multiqueue feature for virtio interfaces.
              type: boolean
            preferredPanicDeviceModel:
              description: PreferredPanicDeviceModel optionally defines the preferred
                panic device model to use with panic devices.
              type: string
            preferredRng:
              description: PreferredRng optionally defines the preferred rng device
                to be used.
              type: object
            preferredSoundModel:
              description: PreferredSoundModel optionally defines the preferred model
                for Sound devices.
              type: string
            preferredTPM:
              description: PreferredTPM optionally defines the preferred TPM device
                to be used.
              properties:
                enabled:
                  description: |-
                    Enabled allows a user to explicitly disable the vTPM even when one is enabled by a preference referenced by the VirtualMachine
                    Defaults to True
                  type: boolean
                persistent:
                  description: |-
                    Persistent indicates the state of the TPM device should be kept accross reboots
                    Defaults to false
                  type: boolean
              type: object
            preferredUseVirtioTransitional:
              description: PreferredUseVirtioTransitional optionally defines the preferred
                value of UseVirtioTransitional
              type: boolean
            preferredVirtualGPUOptions:
              description: PreferredVirtualGPUOptions optionally defines the preferred
                value of VirtualGPUOptions
              properties:
                display:
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if a display addapter backed by a vGPU should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                    ramFB:
                      description: |-
                        Enables a boot framebuffer, until the guest OS loads a real GPU driver
                        Defaults to true.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                  type: object
              type: object
          type: object
        features:
          description: Features optionally defines preferences associated with the
            Features attribute of a VirtualMachineInstance DomainSpec
          properties:
            preferredAcpi:
              description: PreferredAcpi optionally enables the ACPI feature
              properties:
                enabled:
                  description: |-
                    Enabled determines if the feature should be enabled or disabled on the guest.
                    Defaults to true.
                  type: boolean
              type: object
            preferredApic:
              description: PreferredApic optionally enables and configures the APIC
                feature
              properties:
                enabled:
                  description: |-
                    Enabled determines if the feature should be enabled or disabled on the guest.
                    Defaults to true.
                  type: boolean
                endOfInterrupt:
                  description: |-
                    EndOfInterrupt enables the end of interrupt notification in the guest.
                    Defaults to false.
                  type: boolean
              type: object
            preferredHyperv:
              description: PreferredHyperv optionally enables and configures HyperV
                features
              properties:
                evmcs:
                  description: |-
                    EVMCS Speeds up L2 vmexits, but disables other virtualization features. Requires vapic.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                frequencies:
                  description: |-
                    Frequencies improves the TSC clock source handling for Hyper-V on KVM.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                ipi:
                  description: |-
                    IPI improves performances in overcommited environments. Requires vpindex.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                reenlightenment:
                  description: |-
                    Reenlightenment enables the notifications on TSC frequency changes.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                relaxed:
                  description: |-
                    Relaxed instructs the guest OS to disable watchdog timeouts.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                reset:
                  description: |-
                    Reset enables Hyperv reboot/reset for the vmi. Requires synic.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                runtime:
                  description: |-
                    Runtime improves the time accounting to improve scheduling in the guest.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                spinlocks:
                  description: Spinlocks allows to configure the spinlock retry attempts.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                    spinlocks:
                      description: |-
                        Retries indicates the number of retries.
                        Must be a value greater or equal 4096.
                        Defaults to 4096.
                      format: int32
                      type: integer
                  type: object
                synic:
                  description: |-
                    SyNIC enables the Synthetic Interrupt Controller.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                synictimer:
                  description: |-
                    SyNICTimer enables Synthetic Interrupt Controller Timers, reducing CPU load.
                    Defaults to the machine type setting.
                  properties:
                    direct:
                      description: Represents if a feature is enabled or disabled.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    enabled:
                      type: boolean
                  type: object
                tlbflush:
                  description: |-
                    TLBFlush improves performances in overcommited environments. Requires vpindex.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                vapic:
                  description: |-
                    VAPIC improves the paravirtualized handling of interrupts.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                vendorid:
                  description: |-
                    VendorID allows setting the hypervisor vendor id.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                    vendorid:
                      description: |-
                        VendorID sets the hypervisor vendor id, visible to the vmi.
                        String up to twelve characters.
                      type: string
                  type: object
                vpindex:
                  description: |-
                    VPIndex enables the Virtual Processor Index to help windows identifying virtual processors.
                    Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
              type: object
            preferredKvm:
              description: PreferredKvm optionally enables and configures KVM features
              properties:
                hidden:
                  description: |-
                    Hide the KVM hypervisor from standard MSR based discovery.
                    Defaults to false
                  type: boolean
              type: object
            preferredPvspinlock:
              description: PreferredPvspinlock optionally enables the Pvspinlock feature
              properties:
                enabled:
                  description: |-
                    Enabled determines if the feature should be enabled or disabled on the guest.
                    Defaults to true.
                  type: boolean
              type: object
            preferredSmm:
              description: PreferredSmm optionally enables the SMM feature
              properties:
                enabled:
                  description: |-
                    Enabled determines if the feature should be enabled or disabled on the guest.
                    Defaults to true.
                  type: boolean
              type: object
          type: object
        firmware:
          description: Firmware optionally defines preferences associated with the
            Firmware attribute of a VirtualMachineInstance DomainSpec
          properties:
            preferredEfi:
              description: PreferredEfi optionally enables EFI
              properties:
                persistent:
                  description: |-
                    If set to true, Persistent will persist the EFI NVRAM across reboots.
                    Defaults to false
                  type: boolean
                secureBoot:
                  description: |-
                    If set, SecureBoot will be enabled and the OVMF roms will be swapped for
                    SecureBoot-enabled ones.
                    Requires SMM to be enabled.
                    Defaults to true
                  type: boolean
              type: object
            preferredUseBios:
              description: PreferredUseBios optionally enables BIOS
              type: boolean
            preferredUseBiosSerial:
              description: |-
                PreferredUseBiosSerial optionally transmitts BIOS output over the serial.

                Requires PreferredUseBios to be enabled.
              type: boolean
            preferredUseEfi:
              description: |-
                PreferredUseEfi optionally enables EFI

                Deprecated: Will be removed with v1beta2 or v1
              type: boolean
            preferredUseSecureBoot:
              description: |-
                PreferredUseSecureBoot optionally enables SecureBoot and the OVMF roms will be swapped for SecureBoot-enabled ones.

                Requires PreferredUseEfi and PreferredSmm to be enabled.

                Deprecated: Will be removed with v1beta2 or v1
              type: boolean
          type: object
        machine:
          description: Machine optionally defines preferences associated with the
            Machine attribute of a VirtualMachineInstance DomainSpec
          properties:
            preferredMachineType:
              description: PreferredMachineType optionally defines the preferred machine
                type to use.
              type: string
          type: object
        preferSpreadSocketToCoreRatio:
          description: PreferSpreadSocketToCoreRatio defines the ratio to spread vCPUs
            between cores and sockets, it defaults to 2.
          format: int32
          type: integer
        preferredSubdomain:
          description: Subdomain of the VirtualMachineInstance
          type: string
        preferredTerminationGracePeriodSeconds:
          description: Grace period observed after signalling a VirtualMachineInstance
            to stop after which the VirtualMachineInstance is force terminated.
          format: int64
          type: integer
        requirements:
          description: Requirements defines the minium amount of instance type defined
            resources required by a set of preferences
          properties:
            cpu:
              description: Required CPU related attributes of the instancetype.
              properties:
                guest:
                  description: Minimal number of vCPUs required by the preference.
                  format: int32
                  type: integer
              required:
              - guest
              type: object
            memory:
              description: Required Memory related attributes of the instancetype.
              properties:
                guest:
                  anyOf:
                  - type: integer
                  - type: string
                  description: Minimal amount of memory required by the preference.
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
              required:
              - guest
              type: object
          type: object
        volumes:
          description: Volumes optionally defines preferences associated with the
            Volumes attribute of a VirtualMachineInstace DomainSpec
          properties:
            preferredStorageClassName:
              description: PreffereedStorageClassName optionally defines the preferred
                storageClass
              type: string
          type: object
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachineexport": `openAPIV3Schema:
  description: VirtualMachineExport defines the operation of exporting a VM source
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: VirtualMachineExportSpec is the spec for a VirtualMachineExport
        resource
      properties:
        source:
          description: |-
            TypedLocalObjectReference contains enough information to let you locate the
            typed referenced object inside the same namespace.
          properties:
            apiGroup:
              description: |-
                APIGroup is the group for the resource being referenced.
                If APIGroup is not specified, the specified Kind must be in the core API group.
                For any other third-party types, APIGroup is required.
              type: string
            kind:
              description: Kind is the type of resource being referenced
              type: string
            name:
              description: Name is the name of resource being referenced
              type: string
          required:
          - kind
          - name
          type: object
          x-kubernetes-map-type: atomic
        tokenSecretRef:
          description: TokenSecretRef is the name of the custom-defined secret that
            contains the token used by the export server pod
          type: string
        ttlDuration:
          description: |-
            ttlDuration limits the lifetime of an export
            If this field is set, after this duration has passed from counting from CreationTimestamp,
            the export is eligible to be automatically deleted.
            If this field is omitted, a reasonable default is applied.
          type: string
      required:
      - source
      type: object
    status:
      description: VirtualMachineExportStatus is the status for a VirtualMachineExport
        resource
      properties:
        conditions:
          items:
            description: Condition defines conditions
            properties:
              lastProbeTime:
                format: date-time
                nullable: true
                type: string
              lastTransitionTime:
                format: date-time
                nullable: true
                type: string
              message:
                type: string
              reason:
                type: string
              status:
                type: string
              type:
                description: ConditionType is the const type for Conditions
                type: string
            required:
            - status
            - type
            type: object
          type: array
          x-kubernetes-list-type: atomic
        links:
          description: VirtualMachineExportLinks contains the links that point the
            exported VM resources
          properties:
            external:
              description: VirtualMachineExportLink contains a list of volumes available
                for export, as well as the URLs to obtain these volumes
              properties:
                cert:
                  description: Cert is the public CA certificate base64 encoded
                  type: string
                manifests:
                  description: Manifests is a list of available manifests for the
                    export
                  items:
                    description: VirtualMachineExportManifest contains the type and
                      URL of the exported manifest
                    properties:
                      type:
                        description: Type is the type of manifest returned
                        type: string
                      url:
                        description: Url is the url of the endpoint that returns the
                          manifest
                        type: string
                    required:
                    - type
                    - url
                    type: object
                  type: array
                  x-kubernetes-list-map-keys:
                  - type
                  x-kubernetes-list-type: map
                volumes:
                  description: Volumes is a list of available volumes to export
                  items:
                    description: VirtualMachineExportVolume contains the name and
                      available formats for the exported volume
                    properties:
                      formats:
                        items:
                          description: VirtualMachineExportVolumeFormat contains the
                            format type and URL to get the volume in that format
                          properties:
                            format:
                              description: Format is the format of the image at the
                                specified URL
                              type: string
                            url:
                              description: Url is the url that contains the volume
                                in the format specified
                              type: string
                          required:
                          - format
                          - url
                          type: object
                        type: array
                        x-kubernetes-list-map-keys:
                        - format
                        x-kubernetes-list-type: map
                      name:
                        description: Name is the name of the exported volume
                        type: string
                    required:
                    - name
                    type: object
                  type: array
                  x-kubernetes-list-map-keys:
                  - name
                  x-kubernetes-list-type: map
              required:
              - cert
              type: object
            internal:
              description: VirtualMachineExportLink contains a list of volumes available
                for export, as well as the URLs to obtain these volumes
              properties:
                cert:
                  description: Cert is the public CA certificate base64 encoded
                  type: string
                manifests:
                  description: Manifests is a list of available manifests for the
                    export
                  items:
                    description: VirtualMachineExportManifest contains the type and
                      URL of the exported manifest
                    properties:
                      type:
                        description: Type is the type of manifest returned
                        type: string
                      url:
                        description: Url is the url of the endpoint that returns the
                          manifest
                        type: string
                    required:
                    - type
                    - url
                    type: object
                  type: array
                  x-kubernetes-list-map-keys:
                  - type
                  x-kubernetes-list-type: map
                volumes:
                  description: Volumes is a list of available volumes to export
                  items:
                    description: VirtualMachineExportVolume contains the name and
                      available formats for the exported volume
                    properties:
                      formats:
                        items:
                          description: VirtualMachineExportVolumeFormat contains the
                            format type and URL to get the volume in that format
                          properties:
                            format:
                              description: Format is the format of the image at the
                                specified URL
                              type: string
                            url:
                              description: Url is the url that contains the volume
                                in the format specified
                              type: string
                          required:
                          - format
                          - url
                          type: object
                        type: array
                        x-kubernetes-list-map-keys:
                        - format
                        x-kubernetes-list-type: map
                      name:
                        description: Name is the name of the exported volume
                        type: string
                    required:
                    - name
                    type: object
                  type: array
                  x-kubernetes-list-map-keys:
                  - name
                  x-kubernetes-list-type: map
              required:
              - cert
              type: object
          type: object
        phase:
          description: VirtualMachineExportPhase is the current phase of the VirtualMachineExport
          type: string
        serviceName:
          description: |-
            ServiceName is the name of the service created associated with the Virtual Machine export. It will be used to
            create the internal URLs for downloading the images
          type: string
        tokenSecretRef:
          description: TokenSecretRef is the name of the secret that contains the
            token used by the export server pod
          type: string
        ttlExpirationTime:
          description: |-
            The time at which the VM Export will be completely removed according to specified TTL
            Formula is CreationTimestamp + TTL
          format: date-time
          type: string
        virtualMachineName:
          description: |-
            VirtualMachineName shows the name of the source virtual machine if the source is either a VirtualMachine or
            a VirtualMachineSnapshot. This is mainly to easily identify the source VirtualMachine in case of a
            VirtualMachineSnapshot
          type: string
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachineinstance": `openAPIV3Schema:
  description: VirtualMachineInstance is *the* VirtualMachineInstance Definition.
    It represents a virtual machine in the runtime environment of kubernetes.
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: VirtualMachineInstance Spec contains the VirtualMachineInstance
        specification.
      properties:
        accessCredentials:
          description: Specifies a set of public keys to inject into the vm guest
          items:
            description: |-
              AccessCredential represents a credential source that can be used to
              authorize remote access to the vm guest
              Only one of its members may be specified.
            properties:
              sshPublicKey:
                description: |-
                  SSHPublicKey represents the source and method of applying a ssh public
                  key into a guest virtual machine.
                properties:
                  propagationMethod:
                    description: PropagationMethod represents how the public key is
                      injected into the vm guest.
                    properties:
                      configDrive:
                        description: |-
                          ConfigDrivePropagation means that the ssh public keys are injected
                          into the VM using metadata using the configDrive cloud-init provider
                        type: object
                      noCloud:
                        description: |-
                          NoCloudPropagation means that the ssh public keys are injected
                          into the VM using metadata using the noCloud cloud-init provider
                        type: object
                      qemuGuestAgent:
                        description: |-
                          QemuGuestAgentAccessCredentailPropagation means ssh public keys are
                          dynamically injected into the vm at runtime via the qemu guest agent.
                          This feature requires the qemu guest agent to be running within the guest.
                        properties:
                          users:
                            description: |-
                              Users represents a list of guest users that should have the ssh public keys
                              added to their authorized_keys file.
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: set
                        required:
                        - users
                        type: object
                    type: object
                  source:
                    description: Source represents where the public keys are pulled
                      from
                    properties:
                      secret:
                        description: Secret means that the access credential is pulled
                          from a kubernetes secret
                        properties:
                          secretName:
                            description: SecretName represents the name of the secret
                              in the VMI's namespace
                            type: string
                        required:
                        - secretName
                        type: object
                    type: object
                required:
                - propagationMethod
                - source
                type: object
              userPassword:
                description: |-
                  UserPassword represents the source and method for applying a guest user's
                  password
                properties:
                  propagationMethod:
                    description: propagationMethod represents how the user passwords
                      are injected into the vm guest.
                    properties:
                      qemuGuestAgent:
                        description: |-
                          QemuGuestAgentAccessCredentailPropagation means passwords are
                          dynamically injected into the vm at runtime via the qemu guest agent.
                          This feature requires the qemu guest agent to be running within the guest.
                        type: object
                    type: object
                  source:
                    description: Source represents where the user passwords are pulled
                      from
                    properties:
                      secret:
                        description: Secret means that the access credential is pulled
                          from a kubernetes secret
                        properties:
                          secretName:
                            description: SecretName represents the name of the secret
                              in the VMI's namespace
                            type: string
                        required:
                        - secretName
                        type: object
                    type: object
                required:
                - propagationMethod
                - source
                type: object
            type: object
          maxItems: 256
          type: array
          x-kubernetes-list-type: atomic
        affinity:
          description: If affinity is specifies, obey all the affinity rules
          properties:
            nodeAffinity:
              description: Describes node affinity scheduling rules for the pod.
              properties:
                preferredDuringSchedulingIgnoredDuringExecution:
                  description: |-
                    The scheduler will prefer to schedule pods to nodes that satisfy
                    the affinity expressions specified by this field, but it may choose
                    a node that violates one or more of the expressions. The node that is
                    most preferred is the one with the greatest sum of weights, i.e.
                    for each node that meets all of the scheduling requirements (resource
                    request, requiredDuringScheduling affinity expressions, etc.),
                    compute a sum by iterating through the elements of this field and adding
                    "weight" to the sum if the node matches the corresponding matchExpressions; the
                    node(s) with the highest sum are the most preferred.
                  items:
                    description: |-
                      An empty preferred scheduling term matches all objects with implicit weight 0
                      (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
                    properties:
                      preference:
                        description: A node selector term, associated with the corresponding
                          weight.
                        properties:
                          matchExpressions:
                            description: A list of node selector requirements by node's
                              labels.
                            items:
                              description: |-
                                A node selector requirement is a selector that contains values, a key, and an operator
                                that relates the key and values.
                              properties:
                                key:
                                  description: The label key that the selector applies
                                    to.
                                  type: string
                                operator:
                                  description: |-
                                    Represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                  type: string
                                values:
                                  description: |-
                                    An array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. If the operator is Gt or Lt, the values
                                    array must have a single element, which will be interpreted as an integer.
                                    This array is replaced during a strategic merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchFields:
                            description: A list of node selector requirements by node's
                              fields.
                            items:
                              description: |-
                                A node selector requirement is a selector that contains values, a key, and an operator
                                that relates the key and values.
                              properties:
                                key:
                                  description: The label key that the selector applies
                                    to.
                                  type: string
                                operator:
                                  description: |-
                                    Represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                  type: string
                                values:
                                  description: |-
                                    An array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. If the operator is Gt or Lt, the values
                                    array must have a single element, which will be interpreted as an integer.
                                    This array is replaced during a strategic merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                        type: object
                        x-kubernetes-map-type: atomic
                      weight:
                        description: Weight associated with matching the corresponding
                          nodeSelectorTerm, in the range 1-100.
                        format: int32
                        type: integer
                    required:
                    - preference
                    - weight
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                requiredDuringSchedulingIgnoredDuringExecution:
                  description: |-
                    If the affinity requirements specified by this field are not met at
                    scheduling time, the pod will not be scheduled onto the node.
                    If the affinity requirements specified by this field cease to be met
                    at some point during pod execution (e.g. due to an update), the system
                    may or may not try to eventually evict the pod from its node.
                  properties:
                    nodeSelectorTerms:
                      description: Required. A list of node selector terms. The terms
                        are ORed.
                      items:
                        description: |-
                          A null or empty node selector term matches no objects. The requirements of
                          them are ANDed.
                          The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
                        properties:
                          matchExpressions:
                            description: A list of node selector requirements by node's
                              labels.
                            items:
                              description: |-
                                A node selector requirement is a selector that contains values, a key, and an operator
                                that relates the key and values.
                              properties:
                                key:
                                  description: The label key that the selector applies
                                    to.
                                  type: string
                                operator:
                                  description: |-
                                    Represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                  type: string
                                values:
                                  description: |-
                                    An array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. If the operator is Gt or Lt, the values
                                    array must have a single element, which will be interpreted as an integer.
                                    This array is replaced during a strategic merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchFields:
                            description: A list of node selector requirements by node's
                              fields.
                            items:
                              description: |-
                                A node selector requirement is a selector that contains values, a key, and an operator
                                that relates the key and values.
                              properties:
                                key:
                                  description: The label key that the selector applies
                                    to.
                                  type: string
                                operator:
                                  description: |-
                                    Represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                  type: string
                                values:
                                  description: |-
                                    An array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. If the operator is Gt or Lt, the values
                                    array must have a single element, which will be interpreted as an integer.
                                    This array is replaced during a strategic merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                        type: object
                        x-kubernetes-map-type: atomic
                      type: array
                      x-kubernetes-list-type: atomic
                  required:
                  - nodeSelectorTerms
                  type: object
                  x-kubernetes-map-type: atomic
              type: object
            podAffinity:
              description: Describes pod affinity scheduling rules (e.g. co-locate
                this pod in the same node, zone, etc. as some other pod(s)).
              properties:
                preferredDuringSchedulingIgnoredDuringExecution:
                  description: |-
                    The scheduler will prefer to schedule pods to nodes that satisfy
                    the affinity expressions specified by this field, but it may choose
                    a node that violates one or more of the expressions. The node that is
                    most preferred is the one with the greatest sum of weights, i.e.
                    for each node that meets all of the scheduling requirements (resource
                    request, requiredDuringScheduling affinity expressions, etc.),
                    compute a sum by iterating through the elements of this field and adding
                    "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                    node(s) with the highest sum are the most preferred.
                  items:
                    description: The weights of all of the matched WeightedPodAffinityTerm
                      fields are added per-node to find the most preferred node(s)
                    properties:
                      podAffinityTerm:
                        description: Required. A pod affinity term, associated with
                          the corresponding weight.
                        properties:
                          labelSelector:
                            description: |-
                              A label query over a set of resources, in this case pods.
                              If it's null, this PodAffinityTerm matches with no Pods.
                            properties:
                              matchExpressions:
                                description: matchExpressions is a list of label selector
                                  requirements. The requirements are ANDed.
                                items:
                                  description: |-
                                    A label selector requirement is a selector that contains values, a key, and an operator that
                                    relates the key and values.
                                  properties:
                                    key:
                                      description: key is the label key that the selector
                                        applies to.
                                      type: string
                                    operator:
                                      description: |-
                                        operator represents a key's relationship to a set of values.
                                        Valid operators are In, NotIn, Exists and DoesNotExist.
                                      type: string
                                    values:
                                      description: |-
                                        values is an array of string values. If the operator is In or NotIn,
                                        the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                        the values array must be empty. This array is replaced during a strategic
                                        merge patch.
                                      items:
                                        type: string
                                      type: array
                                      x-kubernetes-list-type: atomic
                                  required:
                                  - key
                                  - operator
                                  type: object
                                type: array
                                x-kubernetes-list-type: atomic
                              matchLabels:
                                additionalProperties:
                                  type: string
                                description: |-
                                  matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                  map is equivalent to an element of matchExpressions, whose key field is "key", the
                                  operator is "In", and the values array contains only "value". The requirements are ANDed.
                                type: object
                            type: object
                            x-kubernetes-map-type: atomic
                          matchLabelKeys:
                            description: |-
                              MatchLabelKeys is a set of pod label keys to select which pods will
                              be taken into consideration. The keys are used to lookup values from the
                              incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                              to select the group of existing pods which pods will be taken into consideration
                              for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                              pod labels will be ignored. The default value is empty.
                              The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                              Also, matchLabelKeys cannot be set when labelSelector isn't set.
                              This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          mismatchLabelKeys:
                            description: |-
                              MismatchLabelKeys is a set of pod label keys to select which pods will
                              be taken into consideration. The keys are used to lookup values from the
                              incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                              to select the group of existing pods which pods will be taken into consideration
                              for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                              pod labels will be ignored. The default value is empty.
                              The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                              Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                              This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          namespaceSelector:
                            description: |-
                              A label query over the set of namespaces that the term applies to.
                              The term is applied to the union of the namespaces selected by this field
                              and the ones listed in the namespaces field.
                              null selector and null or empty namespaces list means "this pod's namespace".
                              An empty selector ({}) matches all namespaces.
                            properties:
                              matchExpressions:
                                description: matchExpressions is a list of label selector
                                  requirements. The requirements are ANDed.
                                items:
                                  description: |-
                                    A label selector requirement is a selector that contains values, a key, and an operator that
                                    relates the key and values.
                                  properties:
                                    key:
                                      description: key is the label key that the selector
                                        applies to.
                                      type: string
                                    operator:
                                      description: |-
                                        operator represents a key's relationship to a set of values.
                                        Valid operators are In, NotIn, Exists and DoesNotExist.
                                      type: string
                                    values:
                                      description: |-
                                        values is an array of string values. If the operator is In or NotIn,
                                        the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                        the values array must be empty. This array is replaced during a strategic
                                        merge patch.
                                      items:
                                        type: string
                                      type: array
                                      x-kubernetes-list-type: atomic
                                  required:
                                  - key
                                  - operator
                                  type: object
                                type: array
                                x-kubernetes-list-type: atomic
                              matchLabels:
                                additionalProperties:
                                  type: string
                                description: |-
                                  matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                  map is equivalent to an element of matchExpressions, whose key field is "key", the
                                  operator is "In", and the values array contains only "value". The requirements are ANDed.
                                type: object
                            type: object
                            x-kubernetes-map-type: atomic
                          namespaces:
                            description: |-
                              namespaces specifies a static list of namespace names that the term applies to.
                              The term is applied to the union of the namespaces listed in this field
                              and the ones selected by namespaceSelector.
                              null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          topologyKey:
                            description: |-
                              This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                              the labelSelector in the specified namespaces, where co-located is defined as running on a node
                              whose value of the label with key topologyKey matches that of any node on which any of the
                              selected pods is running.
                              Empty topologyKey is not allowed.
                            type: string
                        required:
                        - topologyKey
                        type: object
                      weight:
                        description: |-
                          weight associated with matching the corresponding podAffinityTerm,
                          in the range 1-100.
                        format: int32
                        type: integer
                    required:
                    - podAffinityTerm
                    - weight
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                requiredDuringSchedulingIgnoredDuringExecution:
                  description: |-
                    If the affinity requirements specified by this field are not met at
                    scheduling time, the pod will not be scheduled onto the node.
                    If the affinity requirements specified by this field cease to be met
                    at some point during pod execution (e.g. due to a pod label update), the
                    system may or may not try to eventually evict the pod from its node.
                    When there are multiple elements, the lists of nodes corresponding to each
                    podAffinityTerm are intersected, i.e. all terms must be satisfied.
                  items:
                    description: |-
                      Defines a set of pods (namely those matching the labelSelector
                      relative to the given namespace(s)) that this pod should be
                      co-located (affinity) or not co-located (anti-affinity) with,
                      where co-located is defined as running on a node whose value of
                      the label with key <topologyKey> matches that of any node on which
                      a pod of the set of pods is running
                    properties:
                      labelSelector:
                        description: |-
                          A label query over a set of resources, in this case pods.
                          If it's null, this PodAffinityTerm matches with no Pods.
                        properties:
                          matchExpressions:
                            description: matchExpressions is a list of label selector
                              requirements. The requirements are ANDed.
                            items:
                              description: |-
                                A label selector requirement is a selector that contains values, a key, and an operator that
                                relates the key and values.
                              properties:
                                key:
                                  description: key is the label key that the selector
                                    applies to.
                                  type: string
                                operator:
                                  description: |-
                                    operator represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists and DoesNotExist.
                                  type: string
                                values:
                                  description: |-
                                    values is an array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. This array is replaced during a strategic
                                    merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchLabels:
                            additionalProperties:
                              type: string
                            description: |-
                              matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                              map is equivalent to an element of matchExpressions, whose key field is "key", the
                              operator is "In", and the values array contains only "value". The requirements are ANDed.
                            type: object
                        type: object
                        x-kubernetes-map-type: atomic
                      matchLabelKeys:
                        description: |-
                          MatchLabelKeys is a set of pod label keys to select which pods will
                          be taken into consideration. The keys are used to lookup values from the
                          incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                          to select the group of existing pods which pods will be taken into consideration
                          for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                          pod labels will be ignored. The default value is empty.
                          The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                          Also, matchLabelKeys cannot be set when labelSelector isn't set.
                          This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      mismatchLabelKeys:
                        description: |-
                          MismatchLabelKeys is a set of pod label keys to select which pods will
                          be taken into consideration. The keys are used to lookup values from the
                          incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                          to select the group of existing pods which pods will be taken into consideration
                          for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                          pod labels will be ignored. The default value is empty.
                          The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                          Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                          This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      namespaceSelector:
                        description: |-
                          A label query over the set of namespaces that the term applies to.
                          The term is applied to the union of the namespaces selected by this field
                          and the ones listed in the namespaces field.
                          null selector and null or empty namespaces list means "this pod's namespace".
                          An empty selector ({}) matches all namespaces.
                        properties:
                          matchExpressions:
                            description: matchExpressions is a list of label selector
                              requirements. The requirements are ANDed.
                            items:
                              description: |-
                                A label selector requirement is a selector that contains values, a key, and an operator that
                                relates the key and values.
                              properties:
                                key:
                                  description: key is the label key that the selector
                                    applies to.
                                  type: string
                                operator:
                                  description: |-
                                    operator represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists and DoesNotExist.
                                  type: string
                                values:
                                  description: |-
                                    values is an array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. This array is replaced during a strategic
                                    merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchLabels:
                            additionalProperties:
                              type: string
                            description: |-
                              matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                              map is equivalent to an element of matchExpressions, whose key field is "key", the
                              operator is "In", and the values array contains only "value". The requirements are ANDed.
                            type: object
                        type: object
                        x-kubernetes-map-type: atomic
                      namespaces:
                        description: |-
                          namespaces specifies a static list of namespace names that the term applies to.
                          The term is applied to the union of the namespaces listed in this field
                          and the ones selected by namespaceSelector.
                          null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      topologyKey:
                        description: |-
                          This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                          the labelSelector in the specified namespaces, where co-located is defined as running on a node
                          whose value of the label with key topologyKey matches that of any node on which any of the
                          selected pods is running.
                          Empty topologyKey is not allowed.
                        type: string
                    required:
                    - topologyKey
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
              type: object
            podAntiAffinity:
              description: Describes pod anti-affinity scheduling rules (e.g. avoid
                putting this pod in the same node, zone, etc. as some other pod(s)).
              properties:
                preferredDuringSchedulingIgnoredDuringExecution:
                  description: |-
                    The scheduler will prefer to schedule pods to nodes that satisfy
                    the anti-affinity expressions specified by this field, but it may choose
                    a node that violates one or more of the expressions. The node that is
                    most preferred is the one with the greatest sum of weights, i.e.
                    for each node that meets all of the scheduling requirements (resource
                    request, requiredDuringScheduling anti-affinity expressions, etc.),
                    compute a sum by iterating through the elements of this field and adding
                    "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                    node(s) with the highest sum are the most preferred.
                  items:
                    description: The weights of all of the matched WeightedPodAffinityTerm
                      fields are added per-node to find the most preferred node(s)
                    properties:
                      podAffinityTerm:
                        description: Required. A pod affinity term, associated with
                          the corresponding weight.
                        properties:
                          labelSelector:
                            description: |-
                              A label query over a set of resources, in this case pods.
                              If it's null, this PodAffinityTerm matches with no Pods.
                            properties:
                              matchExpressions:
                                description: matchExpressions is a list of label selector
                                  requirements. The requirements are ANDed.
                                items:
                                  description: |-
                                    A label selector requirement is a selector that contains values, a key, and an operator that
                                    relates the key and values.
                                  properties:
                                    key:
                                      description: key is the label key that the selector
                                        applies to.
                                      type: string
                                    operator:
                                      description: |-
                                        operator represents a key's relationship to a set of values.
                                        Valid operators are In, NotIn, Exists and DoesNotExist.
                                      type: string
                                    values:
                                      description: |-
                                        values is an array of string values. If the operator is In or NotIn,
                                        the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                        the values array must be empty. This array is replaced during a strategic
                                        merge patch.
                                      items:
                                        type: string
                                      type: array
                                      x-kubernetes-list-type: atomic
                                  required:
                                  - key
                                  - operator
                                  type: object
                                type: array
                                x-kubernetes-list-type: atomic
                              matchLabels:
                                additionalProperties:
                                  type: string
                                description: |-
                                  matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                  map is equivalent to an element of matchExpressions, whose key field is "key", the
                                  operator is "In", and the values array contains only "value". The requirements are ANDed.
                                type: object
                            type: object
                            x-kubernetes-map-type: atomic
                          matchLabelKeys:
                            description: |-
                              MatchLabelKeys is a set of pod label keys to select which pods will
                              be taken into consideration. The keys are used to lookup values from the
                              incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                              to select the group of existing pods which pods will be taken into consideration
                              for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                              pod labels will be ignored. The default value is empty.
                              The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                              Also, matchLabelKeys cannot be set when labelSelector isn't set.
                              This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          mismatchLabelKeys:
                            description: |-
                              MismatchLabelKeys is a set of pod label keys to select which pods will
                              be taken into consideration. The keys are used to lookup values from the
                              incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                              to select the group of existing pods which pods will be taken into consideration
                              for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                              pod labels will be ignored. The default value is empty.
                              The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                              Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                              This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          namespaceSelector:
                            description: |-
                              A label query over the set of namespaces that the term applies to.
                              The term is applied to the union of the namespaces selected by this field
                              and the ones listed in the namespaces field.
                              null selector and null or empty namespaces list means "this pod's namespace".
                              An empty selector ({}) matches all namespaces.
                            properties:
                              matchExpressions:
                                description: matchExpressions is a list of label selector
                                  requirements. The requirements are ANDed.
                                items:
                                  description: |-
                                    A label selector requirement is a selector that contains values, a key, and an operator that
                                    relates the key and values.
                                  properties:
                                    key:
                                      description: key is the label key that the selector
                                        applies to.
                                      type: string
                                    operator:
                                      description: |-
                                        operator represents a key's relationship to a set of values.
                                        Valid operators are In, NotIn, Exists and DoesNotExist.
                                      type: string
                                    values:
                                      description: |-
                                        values is an array of string values. If the operator is In or NotIn,
                                        the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                        the values array must be empty. This array is replaced during a strategic
                                        merge patch.
                                      items:
                                        type: string
                                      type: array
                                      x-kubernetes-list-type: atomic
                                  required:
                                  - key
                                  - operator
                                  type: object
                                type: array
                                x-kubernetes-list-type: atomic
                              matchLabels:
                                additionalProperties:
                                  type: string
                                description: |-
                                  matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                  map is equivalent to an element of matchExpressions, whose key field is "key", the
                                  operator is "In", and the values array contains only "value". The requirements are ANDed.
                                type: object
                            type: object
                            x-kubernetes-map-type: atomic
                          namespaces:
                            description: |-
                              namespaces specifies a static list of namespace names that the term applies to.
                              The term is applied to the union of the namespaces listed in this field
                              and the ones selected by namespaceSelector.
                              null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                            items:
                              type: string
                            type: array
                            x-kubernetes-list-type: atomic
                          topologyKey:
                            description: |-
                              This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                              the labelSelector in the specified namespaces, where co-located is defined as running on a node
                              whose value of the label with key topologyKey matches that of any node on which any of the
                              selected pods is running.
                              Empty topologyKey is not allowed.
                            type: string
                        required:
                        - topologyKey
                        type: object
                      weight:
                        description: |-
                          weight associated with matching the corresponding podAffinityTerm,
                          in the range 1-100.
                        format: int32
                        type: integer
                    required:
                    - podAffinityTerm
                    - weight
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                requiredDuringSchedulingIgnoredDuringExecution:
                  description: |-
                    If the anti-affinity requirements specified by this field are not met at
                    scheduling time, the pod will not be scheduled onto the node.
                    If the anti-affinity requirements specified by this field cease to be met
                    at some point during pod execution (e.g. due to a pod label update), the
                    system may or may not try to eventually evict the pod from its node.
                    When there are multiple elements, the lists of nodes corresponding to each
                    podAffinityTerm are intersected, i.e. all terms must be satisfied.
                  items:
                    description: |-
                      Defines a set of pods (namely those matching the labelSelector
                      relative to the given namespace(s)) that this pod should be
                      co-located (affinity) or not co-located (anti-affinity) with,
                      where co-located is defined as running on a node whose value of
                      the label with key <topologyKey> matches that of any node on which
                      a pod of the set of pods is running
                    properties:
                      labelSelector:
                        description: |-
                          A label query over a set of resources, in this case pods.
                          If it's null, this PodAffinityTerm matches with no Pods.
                        properties:
                          matchExpressions:
                            description: matchExpressions is a list of label selector
                              requirements. The requirements are ANDed.
                            items:
                              description: |-
                                A label selector requirement is a selector that contains values, a key, and an operator that
                                relates the key and values.
                              properties:
                                key:
                                  description: key is the label key that the selector
                                    applies to.
                                  type: string
                                operator:
                                  description: |-
                                    operator represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists and DoesNotExist.
                                  type: string
                                values:
                                  description: |-
                                    values is an array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. This array is replaced during a strategic
                                    merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchLabels:
                            additionalProperties:
                              type: string
                            description: |-
                              matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                              map is equivalent to an element of matchExpressions, whose key field is "key", the
                              operator is "In", and the values array contains only "value". The requirements are ANDed.
                            type: object
                        type: object
                        x-kubernetes-map-type: atomic
                      matchLabelKeys:
                        description: |-
                          MatchLabelKeys is a set of pod label keys to select which pods will
                          be taken into consideration. The keys are used to lookup values from the
                          incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                          to select the group of existing pods which pods will be taken into consideration
                          for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                          pod labels will be ignored. The default value is empty.
                          The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                          Also, matchLabelKeys cannot be set when labelSelector isn't set.
                          This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      mismatchLabelKeys:
                        description: |-
                          MismatchLabelKeys is a set of pod label keys to select which pods will
                          be taken into consideration. The keys are used to lookup values from the
                          incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                          to select the group of existing pods which pods will be taken into consideration
                          for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                          pod labels will be ignored. The default value is empty.
                          The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                          Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                          This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      namespaceSelector:
                        description: |-
                          A label query over the set of namespaces that the term applies to.
                          The term is applied to the union of the namespaces selected by this field
                          and the ones listed in the namespaces field.
                          null selector and null or empty namespaces list means "this pod's namespace".
                          An empty selector ({}) matches all namespaces.
                        properties:
                          matchExpressions:
                            description: matchExpressions is a list of label selector
                              requirements. The requirements are ANDed.
                            items:
                              description: |-
                                A label selector requirement is a selector that contains values, a key, and an operator that
                                relates the key and values.
                              properties:
                                key:
                                  description: key is the label key that the selector
                                    applies to.
                                  type: string
                                operator:
                                  description: |-
                                    operator represents a key's relationship to a set of values.
                                    Valid operators are In, NotIn, Exists and DoesNotExist.
                                  type: string
                                values:
                                  description: |-
                                    values is an array of string values. If the operator is In or NotIn,
                                    the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                    the values array must be empty. This array is replaced during a strategic
                                    merge patch.
                                  items:
                                    type: string
                                  type: array
                                  x-kubernetes-list-type: atomic
                              required:
                              - key
                              - operator
                              type: object
                            type: array
                            x-kubernetes-list-type: atomic
                          matchLabels:
                            additionalProperties:
                              type: string
                            description: |-
                              matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                              map is equivalent to an element of matchExpressions, whose key field is "key", the
                              operator is "In", and the values array contains only "value". The requirements are ANDed.
                            type: object
                        type: object
                        x-kubernetes-map-type: atomic
                      namespaces:
                        description: |-
                          namespaces specifies a static list of namespace names that the term applies to.
                          The term is applied to the union of the namespaces listed in this field
                          and the ones selected by namespaceSelector.
                          null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                        items:
                          type: string
                        type: array
                        x-kubernetes-list-type: atomic
                      topologyKey:
                        description: |-
                          This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                          the labelSelector in the specified namespaces, where co-located is defined as running on a node
                          whose value of the label with key topologyKey matches that of any node on which any of the
                          selected pods is running.
                          Empty topologyKey is not allowed.
                        type: string
                    required:
                    - topologyKey
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
              type: object
          type: object
        architecture:
          description: Specifies the architecture of the vm guest you are attempting
            to run. Defaults to the compiled architecture of the KubeVirt components
          type: string
        dnsConfig:
          description: |-
            Specifies the DNS parameters of a pod.
            Parameters specified here will be merged to the generated DNS
            configuration based on DNSPolicy.
          properties:
            nameservers:
              description: |-
                A list of DNS name server IP addresses.
                This will be appended to the base nameservers generated from DNSPolicy.
                Duplicated nameservers will be removed.
              items:
                type: string
              type: array
              x-kubernetes-list-type: atomic
            options:
              description: |-
                A list of DNS resolver options.
                This will be merged with the base options generated from DNSPolicy.
                Duplicated entries will be removed. Resolution options given in Options
                will override those that appear in the base DNSPolicy.
              items:
                description: PodDNSConfigOption defines DNS resolver options of a
                  pod.
                properties:
                  name:
                    description: |-
                      Name is this DNS resolver option's name.
                      Required.
                    type: string
                  value:
                    description: Value is this DNS resolver option's value.
                    type: string
                type: object
              type: array
              x-kubernetes-list-type: atomic
            searches:
              description: |-
                A list of DNS search domains for host-name lookup.
                This will be appended to the base search paths generated from DNSPolicy.
                Duplicated search paths will be removed.
              items:
                type: string
              type: array
              x-kubernetes-list-type: atomic
          type: object
        dnsPolicy:
          description: |-
            Set DNS policy for the pod.
            Defaults to "ClusterFirst".
            Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'.
            DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy.
            To have DNS options set along with hostNetwork, you have to specify DNS policy
            explicitly to 'ClusterFirstWithHostNet'.
          type: string
        domain:
          description: Specification of the desired behavior of the VirtualMachineInstance
            on the host.
          properties:
            chassis:
              description: Chassis specifies the chassis info passed to the domain.
              properties:
                asset:
                  type: string
                manufacturer:
                  type: string
                serial:
                  type: string
                sku:
                  type: string
                version:
                  type: string
              type: object
            clock:
              description: Clock sets the clock and timers of the vmi.
              properties:
                timer:
                  description: Timer specifies whih timers are attached to the vmi.
                  properties:
                    hpet:
                      description: HPET (High Precision Event Timer) - multiple timers
                        with periodic interrupts.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                        tickPolicy:
                          description: |-
                            TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                            One of "delay", "catchup", "merge", "discard".
                          type: string
                      type: object
                    hyperv:
                      description: Hyperv (Hypervclock) - lets guests read the host’s
                        wall clock time (paravirtualized). For windows guests.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                      type: object
                    kvm:
                      description: "KVM \t(KVM clock) - lets guests read the host’s
                        wall clock time (paravirtualized). For linux guests."
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                      type: object
                    pit:
                      description: PIT (Programmable Interval Timer) - a timer with
                        periodic interrupts.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                        tickPolicy:
                          description: |-
                            TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                            One of "delay", "catchup", "discard".
                          type: string
                      type: object
                    rtc:
                      description: RTC (Real Time Clock) - a continuously running
                        timer with periodic interrupts.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                        tickPolicy:
                          description: |-
                            TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                            One of "delay", "catchup".
                          type: string
                        track:
                          description: Track the guest or the wall clock.
                          type: string
                      type: object
                  type: object
                timezone:
                  description: |-
                    Timezone sets the guest clock to the specified timezone.
                    Zone name follows the TZ environment variable format (e.g. 'America/New_York').
                  type: string
                utc:
                  description: |-
                    UTC sets the guest clock to UTC on each boot. If an offset is specified,
                    guest changes to the clock will be kept during reboots and are not reset.
                  properties:
                    offsetSeconds:
                      description: |-
                        OffsetSeconds specifies an offset in seconds, relative to UTC. If set,
                        guest changes to the clock will be kept during reboots and not reset.
                      type: integer
                  type: object
              type: object
              x-kubernetes-preserve-unknown-fields: true
            cpu:
              description: CPU allow specified the detailed CPU topology inside the
                vmi.
              properties:
                cores:
                  description: |-
                    Cores specifies the number of cores inside the vmi.
                    Must be a value greater or equal 1.
                  format: int32
                  type: integer
                dedicatedCpuPlacement:
                  description: |-
                    DedicatedCPUPlacement requests the scheduler to place the VirtualMachineInstance on a node
                    with enough dedicated pCPUs and pin the vCPUs to it.
                  type: boolean
                features:
                  description: Features specifies the CPU features list inside the
                    VMI.
                  items:
                    description: CPUFeature allows specifying a CPU feature.
                    properties:
                      name:
                        description: Name of the CPU feature
                        type: string
                      policy:
                        description: |-
                          Policy is the CPU feature attribute which can have the following attributes:
                          force    - The virtual CPU will claim the feature is supported regardless of it being supported by host CPU.
                          require  - Guest creation will fail unless the feature is supported by the host CPU or the hypervisor is able to emulate it.
                          optional - The feature will be supported by virtual CPU if and only if it is supported by host CPU.
                          disable  - The feature will not be supported by virtual CPU.
                          forbid   - Guest creation will fail if the feature is supported by host CPU.
                          Defaults to require
                        type: string
                    required:
                    - name
                    type: object
                  type: array
                isolateEmulatorThread:
                  description: |-
                    IsolateEmulatorThread requests one more dedicated pCPU to be allocated for the VMI to place
                    the emulator thread on it.
                  type: boolean
                maxSockets:
                  description: |-
                    MaxSockets specifies the maximum amount of sockets that can
                    be hotplugged
                  format: int32
                  type: integer
                model:
                  description: |-
                    Model specifies the CPU model inside the VMI.
                    List of available models https://github.com/libvirt/libvirt/tree/master/src/cpu_map.
                    It is possible to specify special cases like "host-passthrough" to get the same CPU as the node
                    and "host-model" to get CPU closest to the node one.
                    Defaults to host-model.
                  type: string
                numa:
                  description: NUMA allows specifying settings for the guest NUMA
                    topology
                  properties:
                    guestMappingPassthrough:
                      description: |-
                        GuestMappingPassthrough will create an efficient guest topology based on host CPUs exclusively assigned to a pod.
                        The created topology ensures that memory and CPUs on the virtual numa nodes never cross boundaries of host numa nodes.
                      type: object
                  type: object
                realtime:
                  description: Realtime instructs the virt-launcher to tune the VMI
                    for lower latency, optional for real time workloads
                  properties:
                    mask:
                      description: |-
                        Mask defines the vcpu mask expression that defines which vcpus are used for realtime. Format matches libvirt's expressions.
                        Example: "0-3,^1","0,2,3","2-3"
                      type: string
                  type: object
                sockets:
                  description: |-
                    Sockets specifies the number of sockets inside the vmi.
                    Must be a value greater or equal 1.
                  format: int32
                  type: integer
                threads:
                  description: |-
                    Threads specifies the number of threads inside the vmi.
                    Must be a value greater or equal 1.
                  format: int32
                  type: integer
              type: object
            devices:
              description: Devices allows adding disks, network interfaces, and others
              properties:
                autoattachGraphicsDevice:
                  description: |-
                    Whether to attach the default graphics device or not.
                    VNC will not be available if set to false. Defaults to true.
                  type: boolean
                autoattachInputDevice:
                  description: |-
                    Whether to attach an Input Device.
                    Defaults to false.
                  type: boolean
                autoattachMemBalloon:
                  description: |-
                    Whether to attach the Memory balloon device with default period.
                    Period can be adjusted in virt-config.
                    Defaults to true.
                  type: boolean
                autoattachPodInterface:
                  description: Whether to attach a pod network interface. Defaults
                    to true.
                  type: boolean
                autoattachSerialConsole:
                  description: |-
                    Whether to attach the default virtio-serial console or not.
                    Serial console access will not be available if set to false. Defaults to true.
                  type: boolean
                autoattachVSOCK:
                  description: |-
                    Whether to attach the VSOCK CID to the VM or not.
                    VSOCK access will be available if set to true. Defaults to false.
                  type: boolean
                blockMultiQueue:
                  description: |-
                    Whether or not to enable virtio multi-queue for block devices.
                    Defaults to false.
                  type: boolean
                clientPassthrough:
                  description: To configure and access client devices such as redirecting
                    USB
                  type: object
                disableHotplug:
                  description: DisableHotplug disabled the ability to hotplug disks.
                  type: boolean
                disks:
                  description: Disks describes disks, cdroms and luns which are connected
                    to the vmi.
                  items:
                    properties:
                      blockSize:
                        description: If specified, the virtual disk will be presented
                          with the given block sizes.
                        properties:
                          custom:
                            description: CustomBlockSize represents the desired logical
                              and physical block size for a VM disk.
                            properties:
                              logical:
                                type: integer
                              physical:
                                type: integer
                            required:
                            - logical
                            - physical
                            type: object
                          matchVolume:
                            description: Represents if a feature is enabled or disabled.
                            properties:
                              enabled:
                                description: |-
                                  Enabled determines if the feature should be enabled or disabled on the guest.
                                  Defaults to true.
                                type: boolean
                            type: object
                        type: object
                      bootOrder:
                        description: |-
                          BootOrder is an integer value > 0, used to determine ordering of boot devices.
                          Lower values take precedence.
                          Each disk or interface that has a boot order must have a unique value.
                          Disks without a boot order are not tried if a disk with a boot order exists.
                        type: integer
                      cache:
                        description: |-
                          Cache specifies which kvm disk cache mode should be used.
                          Supported values are:
                          none: Guest I/O not cached on the host, but may be kept in a disk cache.
                          writethrough: Guest I/O cached on the host but written through to the physical medium. Slowest but with most guarantees.
                          writeback: Guest I/O cached on the host.
                          Defaults to none if the storage supports O_DIRECT, otherwise writethrough.
                        type: string
                      cdrom:
                        description: Attach a volume as a cdrom to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi.
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to true.
                            type: boolean
                          tray:
                            description: |-
                              Tray indicates if the tray of the device is open or closed.
                              Allowed values are "open" and "closed".
                              Defaults to closed.
                            type: string
                        type: object
                      dedicatedIOThread:
                        description: |-
                          dedicatedIOThread indicates this disk should have an exclusive IO Thread.
                          Enabling this implies useIOThreads = true.
                          Defaults to false.
                        type: boolean
                      disk:
                        description: Attach a volume as a disk to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi, usb.
                            type: string
                          pciAddress:
                            description: 'If specified, the virtual disk will be placed
                              on the guests pci address with the specified PCI address.
                              For example: 0000:81:01.10'
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to false.
                            type: boolean
                        type: object
                      errorPolicy:
                        description: If specified, it can change the default error
                          policy (stop) for the disk
                        type: string
                      io:
                        description: |-
                          IO specifies which QEMU disk IO mode should be used.
                          Supported values are: native, default, threads.
                        type: string
                      lun:
                        description: Attach a volume as a LUN to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi.
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to false.
                            type: boolean
                          reservation:
                            description: Reservation indicates if the disk needs to
                              support the persistent reservation for the SCSI disk
                            type: boolean
                        type: object
                      name:
                        description: Name is the device name
                        type: string
                      serial:
                        description: Serial provides the ability to specify a serial
                          number for the disk device.
                        type: string
                      shareable:
                        description: If specified the disk is made sharable and multiple
                          write from different VMs are permitted
                        type: boolean
                      tag:
                        description: If specified, disk address and its tag will be
                          provided to the guest via config drive metadata
                        type: string
                    required:
                    - name
                    type: object
                  maxItems: 256
                  type: array
                downwardMetrics:
                  description: DownwardMetrics creates a virtio serials for exposing
                    the downward metrics to the vmi.
                  type: object
                filesystems:
                  description: Filesystems describes filesystem which is connected
                    to the vmi.
                  items:
                    properties:
                      name:
                        description: Name is the device name
                        type: string
                      virtiofs:
                        description: Virtiofs is supported
                        type: object
                    required:
                    - name
                    - virtiofs
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                gpus:
                  description: Whether to attach a GPU device to the vmi.
                  items:
                    properties:
                      claimName:
                        description: |-
                          ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                          device is allocated
                        type: string
                      deviceName:
                        description: DeviceName is the name of the device provisioned
                          by device-plugins
                        type: string
                      name:
                        description: Name of the GPU device as exposed by a device
                          plugin
                        type: string
                      requestName:
                        description: |-
                          RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                          device is requested
                        type: string
                      tag:
                        description: If specified, the virtual network interface address
                          and its tag will be provided to the guest via config drive
                        type: string
                      virtualGPUOptions:
                        properties:
                          display:
                            properties:
                              enabled:
                                description: |-
                                  Enabled determines if a display addapter backed by a vGPU should be enabled or disabled on the guest.
                                  Defaults to true.
                                type: boolean
                              ramFB:
                                description: |-
                                  Enables a boot framebuffer, until the guest OS loads a real GPU driver
                                  Defaults to true.
                                properties:
                                  enabled:
                                    description: |-
                                      Enabled determines if the feature should be enabled or disabled on the guest.
                                      Defaults to true.
                                    type: boolean
                                type: object
                            type: object
                        type: object
                    required:
                    - name
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                hostDevices:
                  description: Whether to attach a host device to the vmi.
                  items:
                    properties:
                      claimName:
                        description: |-
                          ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                          device is allocated
                        type: string
                      deviceName:
                        description: DeviceName is the name of the device provisioned
                          by device-plugins
                        type: string
                      name:
                        type: string
                      requestName:
                        description: |-
                          RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                          device is requested
                        type: string
                      tag:
                        description: If specified, the virtual network interface address
                          and its tag will be provided to the guest via config drive
                        type: string
                    required:
                    - name
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                inputs:
                  description: Inputs describe input devices
                  items:
                    properties:
                      bus:
                        description: |-
                          Bus indicates the bus of input device to emulate.
                          Supported values: virtio, usb.
                        type: string
                      name:
                        description: Name is the device name
                        type: string
                      type:
                        description: |-
                          Type indicated the type of input device.
                          Supported values: tablet.
                        type: string
                    required:
                    - name
                    - type
                    type: object
                  type: array
                interfaces:
                  description: Interfaces describe network interfaces which are added
                    to the vmi.
                  items:
                    properties:
                      acpiIndex:
                        description: |-
                          If specified, the ACPI index is used to provide network interface device naming, that is stable across changes
                          in PCI addresses assigned to the device.
                          This value is required to be unique across all devices and be between 1 and (16*1024-1).
                        type: integer
                      binding:
                        description: |-
                          Binding specifies the binding plugin that will be used to connect the interface to the guest.
                          It provides an alternative to InterfaceBindingMethod.
                          version: 1alphav1
                        properties:
                          name:
                            description: |-
                              Name references to the binding name as denined in the kubevirt CR.
                              version: 1alphav1
                            type: string
                        required:
                        - name
                        type: object
                      bootOrder:
                        description: |-
                          BootOrder is an integer value > 0, used to determine ordering of boot devices.
                          Lower values take precedence.
                          Each interface or disk that has a boot order must have a unique value.
                          Interfaces without a boot order are not tried.
                        type: integer
                      bridge:
                        description: InterfaceBridge connects to a given network via
                          a linux bridge.
                        type: object
                      dhcpOptions:
                        description: If specified the network interface will pass
                          additional DHCP options to the VMI
                        properties:
                          bootFileName:
                            description: If specified will pass option 67 to interface's
                              DHCP server
                            type: string
                          ntpServers:
                            description: If specified will pass the configured NTP
                              server to the VM via DHCP option 042.
                            items:
                              type: string
                            type: array
                          privateOptions:
                            description: 'If specified will pass extra DHCP options
                              for private use, range: 224-254'
                            items:
                              description: DHCPExtraOptions defines Extra DHCP options
                                for a VM.
                              properties:
                                option:
                                  description: |-
                                    Option is an Integer value from 224-254
                                    Required.
                                  type: integer
                                value:
                                  description: |-
                                    Value is a String value for the Option provided
                                    Required.
                                  type: string
                              required:
                              - option
                              - value
                              type: object
                            type: array
                          tftpServerName:
                            description: If specified will pass option 66 to interface's
                              DHCP server
                            type: string
                        type: object
                      macAddress:
                        description: 'Interface MAC address. For example: de:ad:00:00:be:af
                          or DE-AD-00-00-BE-AF.'
                        type: string
                      macvtap:
                        description: |-
                          DeprecatedMacvtap is an alias to the deprecated Macvtap interface,
                          please refer to Kubevirt user guide for alternatives.
                          Deprecated: Removed in v1.3
                        type: object
                      masquerade:
                        description: InterfaceMasquerade connects to a given network
                          using netfilter rules to nat the traffic.
                        type: object
                      model:
                        description: |-
                          Interface model.
                          One of: e1000, e1000e, igb, ne2k_pci, pcnet, rtl8139, virtio.
                          Defaults to virtio.
                        type: string
                      name:
                        description: |-
                          Logical name of the interface as well as a reference to the associated networks.
                          Must match the Name of a Network.
                        type: string
                      passt:
                        description: |-
                          DeprecatedPasst is an alias to the deprecated Passt interface,
                          please refer to Kubevirt user guide for alternatives.
                          Deprecated: Removed in v1.3
                        type: object
                      pciAddress:
                        description: 'If specified, the virtual network interface
                          will be placed on the guests pci address with the specified
                          PCI address. For example: 0000:81:01.10'
                        type: string
                      ports:
                        description: List of ports to be forwarded to the virtual
                          machine.
                        items:
                          description: |-
                            Port represents a port to expose from the virtual machine.
                            Default protocol TCP.
                            The port field is mandatory
                          properties:
                            name:
                              description: |-
                                If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
                                named port in a pod must have a unique name. Name for the port that can be
                                referred to by services.
                              type: string
                            port:
                              description: |-
                                Number of port to expose for the virtual machine.
                                This must be a valid port number, 0 < x < 65536.
                              format: int32
                              type: integer
                            protocol:
                              description: |-
                                Protocol for port. Must be UDP or TCP.
                                Defaults to "TCP".
                              type: string
                          required:
                          - port
                          type: object
                        type: array
                      slirp:
                        description: |-
                          DeprecatedSlirp is an alias to the deprecated Slirp interface
                          Deprecated: Removed in v1.3
                        type: object
                      sriov:
                        description: InterfaceSRIOV connects to a given network by
                          passing-through an SR-IOV PCI device via vfio.
                        type: object
                      state:
                        description: |-
                          State represents the requested operational state of the interface.
                          The supported values are:
                          'absent', expressing a request to remove the interface.
                          'down', expressing a request to set the link down.
                          'up', expressing a request to set the link up.
                          Empty value functions as 'up'.
                        type: string
                      tag:
                        description: If specified, the virtual network interface address
                          and its tag will be provided to the guest via config drive
                        type: string
                    required:
                    - name
                    type: object
                  maxItems: 256
                  type: array
                logSerialConsole:
                  description: |-
                    Whether to log the auto-attached default serial console or not.
                    Serial console logs will be collect to a file and then streamed from a named 'guest-console-log'.
                    Not relevant if autoattachSerialConsole is disabled.
                    Defaults to cluster wide setting on VirtualMachineOptions.
                  type: boolean
                networkInterfaceMultiqueue:
                  description: If specified, virtual network interfaces configured
                    with a virtio bus will also enable the vhost multiqueue feature
                    for network devices. The number of queues created depends on additional
                    factors of the VirtualMachineInstance, like the number of guest
                    CPUs.
                  type: boolean
                panicDevices:
                  description: PanicDevices provides additional crash information
                    when a guest crashes.
                  items:
                    properties:
                      model:
                        description: |-
                          Model specifies what type of panic device is provided.
                          The panic model used when this attribute is missing depends on the hypervisor and guest arch.
                          One of: isa, hyperv, pvpanic.
                        type: string
                    type: object
                  type: array
                rng:
                  description: Whether to have random number generator from host
                  type: object
                sound:
                  description: Whether to emulate a sound device.
                  properties:
                    model:
                      description: |-
                        We only support ich9 or ac97.
                        If SoundDevice is not set: No sound card is emulated.
                        If SoundDevice is set but Model is not: ich9
                      type: string
                    name:
                      description: User's defined name for this sound device
                      type: string
                  required:
                  - name
                  type: object
                tpm:
                  description: Whether to emulate a TPM device.
                  properties:
                    enabled:
                      description: |-
                        Enabled allows a user to explicitly disable the vTPM even when one is enabled by a preference referenced by the VirtualMachine
                        Defaults to True
                      type: boolean
                    persistent:
                      description: |-
                        Persistent indicates the state of the TPM device should be kept accross reboots
                        Defaults to false
                      type: boolean
                  type: object
                useVirtioTransitional:
                  description: |-
                    Fall back to legacy virtio 0.9 support if virtio bus is selected on devices.
                    This is helpful for old machines like CentOS6 or RHEL6 which
                    do not understand virtio_non_transitional (virtio 1.0).
                  type: boolean
                video:
                  description: Video describes the video device configuration for
                    the vmi.
                  properties:
                    type:
                      description: |-
                        Type specifies the video device type (e.g., virtio, vga, bochs, ramfb).
                        If not specified, the default is architecture-dependent (VGA for BIOS-based VMs, Bochs for EFI-based VMs on AMD64; virtio for Arm and s390x).
                      type: string
                  type: object
                watchdog:
                  description: Watchdog describes a watchdog device which can be added
                    to the vmi.
                  properties:
                    diag288:
                      description: diag288 watchdog device (specific to s390x architecture).
                      properties:
                        action:
                          description: |-
                            The action to take. Valid values are poweroff, reset, shutdown.
                            Defaults to reset.
                          type: string
                      type: object
                    i6300esb:
                      description: i6300esb watchdog device.
                      properties:
                        action:
                          description: |-
                            The action to take. Valid values are poweroff, reset, shutdown.
                            Defaults to reset.
                          type: string
                      type: object
                    name:
                      description: Name of the watchdog.
                      type: string
                  required:
                  - name
                  type: object
              type: object
            features:
              description: Features like acpi, apic, hyperv, smm.
              properties:
                acpi:
                  description: |-
                    ACPI enables/disables ACPI inside the guest.
                    Defaults to enabled.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                apic:
                  description: Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                    endOfInterrupt:
                      description: |-
                        EndOfInterrupt enables the end of interrupt notification in the guest.
                        Defaults to false.
                      type: boolean
                  type: object
                hyperv:
                  description: Defaults to the machine type setting.
                  properties:
                    evmcs:
                      description: |-
                        EVMCS Speeds up L2 vmexits, but disables other virtualization features. Requires vapic.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    frequencies:
                      description: |-
                        Frequencies improves the TSC clock source handling for Hyper-V on KVM.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    ipi:
                      description: |-
                        IPI improves performances in overcommited environments. Requires vpindex.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    reenlightenment:
                      description: |-
                        Reenlightenment enables the notifications on TSC frequency changes.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    relaxed:
                      description: |-
                        Relaxed instructs the guest OS to disable watchdog timeouts.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    reset:
                      description: |-
                        Reset enables Hyperv reboot/reset for the vmi. Requires synic.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    runtime:
                      description: |-
                        Runtime improves the time accounting to improve scheduling in the guest.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    spinlocks:
                      description: Spinlocks allows to configure the spinlock retry
                        attempts.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                        spinlocks:
                          description: |-
                            Retries indicates the number of retries.
                            Must be a value greater or equal 4096.
                            Defaults to 4096.
                          format: int32
                          type: integer
                      type: object
                    synic:
                      description: |-
                        SyNIC enables the Synthetic Interrupt Controller.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    synictimer:
                      description: |-
                        SyNICTimer enables Synthetic Interrupt Controller Timers, reducing CPU load.
                        Defaults to the machine type setting.
                      properties:
                        direct:
                          description: Represents if a feature is enabled or disabled.
                          properties:
                            enabled:
                              description: |-
                                Enabled determines if the feature should be enabled or disabled on the guest.
                                Defaults to true.
                              type: boolean
                          type: object
                        enabled:
                          type: boolean
                      type: object
                    tlbflush:
                      description: |-
                        TLBFlush improves performances in overcommited environments. Requires vpindex.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    vapic:
                      description: |-
                        VAPIC improves the paravirtualized handling of interrupts.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    vendorid:
                      description: |-
                        VendorID allows setting the hypervisor vendor id.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                        vendorid:
                          description: |-
                            VendorID sets the hypervisor vendor id, visible to the vmi.
                            String up to twelve characters.
                          type: string
                      type: object
                    vpindex:
                      description: |-
                        VPIndex enables the Virtual Processor Index to help windows identifying virtual processors.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                  type: object
                hypervPassthrough:
                  description: |-
                    This enables all supported hyperv flags automatically.
                    Bear in mind that if this enabled hyperV features cannot
                    be enabled explicitly. In addition, a Virtual Machine
                    using it will be non-migratable.
                  properties:
                    enabled:
                      type: boolean
                  type: object
                kvm:
                  description: Configure how KVM presence is exposed to the guest.
                  properties:
                    hidden:
                      description: |-
                        Hide the KVM hypervisor from standard MSR based discovery.
                        Defaults to false
                      type: boolean
                  type: object
                pvspinlock:
                  description: |-
                    Notify the guest that the host supports paravirtual spinlocks.
                    For older kernels this feature should be explicitly disabled.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                smm:
                  description: |-
                    SMM enables/disables System Management Mode.
                    TSEG not yet implemented.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
              type: object
            firmware:
              description: Firmware.
              properties:
                acpi:
                  description: Information that can be set in the ACPI table
                  properties:
                    msdmNameRef:
                      description: |-
                        Similar to SlicNameRef, another ACPI entry that is used in more recent Windows versions.
                        The above points to the spec of MSDM too.
                      type: string
                    slicNameRef:
                      description: |-
                        SlicNameRef should match the volume name of a secret object. The data in the secret should
                        be a binary blob that follows the ACPI SLIC standard, see:
                        https://learn.microsoft.com/en-us/previous-versions/windows/hardware/design/dn653305(v=vs.85)
                      type: string
                  type: object
                bootloader:
                  description: Settings to control the bootloader that is used.
                  properties:
                    bios:
                      description: If set (default), BIOS will be used.
                      properties:
                        useSerial:
                          description: If set, the BIOS output will be transmitted
                            over serial
                          type: boolean
                      type: object
                    efi:
                      description: If set, EFI will be used instead of BIOS.
                      properties:
                        persistent:
                          description: |-
                            If set to true, Persistent will persist the EFI NVRAM across reboots.
                            Defaults to false
                          type: boolean
                        secureBoot:
                          description: |-
                            If set, SecureBoot will be enabled and the OVMF roms will be swapped for
                            SecureBoot-enabled ones.
                            Requires SMM to be enabled.
                            Defaults to true
                          type: boolean
                      type: object
                  type: object
                kernelBoot:
                  description: Settings to set the kernel for booting.
                  properties:
                    container:
                      description: Container defines the container that containes
                        kernel artifacts
                      properties:
                        image:
                          description: Image that contains initrd / kernel files.
                          type: string
                        imagePullPolicy:
                          description: |-
                            Image pull policy.
                            One of Always, Never, IfNotPresent.
                            Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
                            Cannot be updated.
                            More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
                          type: string
                        imagePullSecret:
                          description: ImagePullSecret is the name of the Docker registry
                            secret required to pull the image. The secret must already
                            exist.
                          type: string
                        initrdPath:
                          description: the fully-qualified path to the ramdisk image
                            in the host OS
                          type: string
                        kernelPath:
                          description: The fully-qualified path to the kernel image
                            in the host OS
                          type: string
                      required:
                      - image
                      type: object
                    kernelArgs:
                      description: Arguments to be passed to the kernel at boot time
                      type: string
                  type: object
                serial:
                  description: The system-serial-number in SMBIOS
                  type: string
                uuid:
                  description: |-
                    UUID reported by the vmi bios.
                    Defaults to a random generated uid.
                  type: string
              type: object
            ioThreads:
              description: IOThreads specifies the IOThreads options.
              properties:
                supplementalPoolThreadCount:
                  description: SupplementalPoolThreadCount specifies how many iothreads
                    are allocated for the supplementalPool policy.
                  format: int32
                  type: integer
              type: object
            ioThreadsPolicy:
              description: |-
                Controls whether or not disks will share IOThreads.
                Omitting IOThreadsPolicy disables use of IOThreads.
                One of: shared, auto, supplementalPool
              type: string
            launchSecurity:
              description: Launch Security setting of the vmi.
              properties:
                sev:
                  description: AMD Secure Encrypted Virtualization (SEV).
                  properties:
                    attestation:
                      description: If specified, run the attestation process for a
                        vmi.
                      type: object
                    dhCert:
                      description: Base64 encoded guest owner's Diffie-Hellman key.
                      type: string
                    policy:
                      description: |-
                        Guest policy flags as defined in AMD SEV API specification.
                        Note: due to security reasons it is not allowed to enable guest debugging. Therefore NoDebug flag is not exposed to users and is always true.
                      properties:
                        encryptedState:
                          description: |-
                            SEV-ES is required.
                            Defaults to false.
                          type: boolean
                      type: object
                    session:
                      description: Base64 encoded session blob.
                      type: string
                  type: object
              type: object
            machine:
              description: Machine type.
              properties:
                type:
                  description: QEMU machine type is the actual chipset of the VirtualMachineInstance.
                  type: string
              type: object
            memory:
              description: Memory allow specifying the VMI memory features.
              properties:
                guest:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    Guest allows to specifying the amount of memory which is visible inside the Guest OS.
                    The Guest must lie between Requests and Limits from the resources section.
                    Defaults to the requested memory in the resources section if not specified.
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
                hugepages:
                  description: Hugepages allow to use hugepages for the VirtualMachineInstance
                    instead of regular memory.
                  properties:
                    pageSize:
                      description: PageSize specifies the hugepage size, for x86_64
                        architecture valid values are 1Gi and 2Mi.
                      type: string
                  type: object
                maxGuest:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    MaxGuest allows to specify the maximum amount of memory which is visible inside the Guest OS.
                    The delta between MaxGuest and Guest is the amount of memory that can be hot(un)plugged.
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
              type: object
            resources:
              description: Resources describes the Compute Resources required by this
                vmi.
              properties:
                limits:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Limits describes the maximum amount of compute resources allowed.
                    Valid resource keys are "memory" and "cpu".
                  type: object
                overcommitGuestOverhead:
                  description: |-
                    Don't ask the scheduler to take the guest-management overhead into account. Instead
                    put the overhead only into the container's memory limit. This can lead to crashes if
                    all memory is in use on a node. Defaults to false.
                  type: boolean
                requests:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Requests is a description of the initial vmi resources.
                    Valid resource keys are "memory" and "cpu".
                  type: object
              type: object
          required:
          - devices
          type: object
        evictionStrategy:
          description: |-
            EvictionStrategy describes the strategy to follow when a node drain occurs.
            The possible options are:
            - "None": No action will be taken, according to the specified 'RunStrategy' the VirtualMachine will be restarted or shutdown.
            - "LiveMigrate": the VirtualMachineInstance will be migrated instead of being shutdown.
            - "LiveMigrateIfPossible": the same as "LiveMigrate" but only if the VirtualMachine is Live-Migratable, otherwise it will behave as "None".
            - "External": the VirtualMachineInstance will be protected and 'vmi.Status.EvacuationNodeName' will be set on eviction. This is mainly useful for cluster-api-provider-kubevirt (capk) which needs a way for VMI's to be blocked from eviction, yet signal capk that eviction has been called on the VMI so the capk controller can handle tearing the VMI down. Details can be found in the commit description https://github.com/kubevirt/kubevirt/commit/c1d77face705c8b126696bac9a3ee3825f27f1fa.
          type: string
        hostname:
          description: |-
            Specifies the hostname of the vmi
            If not specified, the hostname will be set to the name of the vmi, if dhcp or cloud-init is configured properly.
          type: string
        livenessProbe:
          description: |-
            Periodic probe of VirtualMachineInstance liveness.
            VirtualmachineInstances will be stopped if the probe fails.
            Cannot be updated.
            More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
          properties:
            exec:
              description: |-
                One and only one of the following should be specified.
                Exec specifies the action to take, it will be executed on the guest through the qemu-guest-agent.
                If the guest agent is not available, this probe will fail.
              properties:
                command:
                  description: |-
                    Command is the command line to execute inside the container, the working directory for the
                    command  is root ('/') in the container's filesystem. The command is simply exec'd, it is
                    not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use
                    a shell, you need to explicitly call out to that shell.
                    Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
                  items:
                    type: string
                  type: array
                  x-kubernetes-list-type: atomic
              type: object
            failureThreshold:
              description: |-
                Minimum consecutive failures for the probe to be considered failed after having succeeded.
                Defaults to 3. Minimum value is 1.
              format: int32
              type: integer
            guestAgentPing:
              description: GuestAgentPing contacts the qemu-guest-agent for availability
                checks.
              type: object
            httpGet:
              description: HTTPGet specifies the http request to perform.
              properties:
                host:
                  description: |-
                    Host name to connect to, defaults to the pod IP. You probably want to set
                    "Host" in httpHeaders instead.
                  type: string
                httpHeaders:
                  description: Custom headers to set in the request. HTTP allows repeated
                    headers.
                  items:
                    description: HTTPHeader describes a custom header to be used in
                      HTTP probes
                    properties:
                      name:
                        description: |-
                          The header field name.
                          This will be canonicalized upon output, so case-variant names will be understood as the same header.
                        type: string
                      value:
                        description: The header field value
                        type: string
                    required:
                    - name
                    - value
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                path:
                  description: Path to access on the HTTP server.
                  type: string
                port:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    Name or number of the port to access on the container.
                    Number must be in the range 1 to 65535.
                    Name must be an IANA_SVC_NAME.
                  x-kubernetes-int-or-string: true
                scheme:
                  description: |-
                    Scheme to use for connecting to the host.
                    Defaults to HTTP.
                  type: string
              required:
              - port
              type: object
            initialDelaySeconds:
              description: |-
                Number of seconds after the VirtualMachineInstance has started before liveness probes are initiated.
                More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
              format: int32
              type: integer
            periodSeconds:
              description: |-
                How often (in seconds) to perform the probe.
                Default to 10 seconds. Minimum value is 1.
              format: int32
              type: integer
            successThreshold:
              description: |-
                Minimum consecutive successes for the probe to be considered successful after having failed.
                Defaults to 1. Must be 1 for liveness. Minimum value is 1.
              format: int32
              type: integer
            tcpSocket:
              description: |-
                TCPSocket specifies an action involving a TCP port.
                TCP hooks not yet supported
              properties:
                host:
                  description: 'Optional: Host name to connect to, defaults to the
                    pod IP.'
                  type: string
                port:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    Number or name of the port to access on the container.
                    Number must be in the range 1 to 65535.
                    Name must be an IANA_SVC_NAME.
                  x-kubernetes-int-or-string: true
              required:
              - port
              type: object
            timeoutSeconds:
              description: |-
                Number of seconds after which the probe times out.
                For exec probes the timeout fails the probe but does not terminate the command running on the guest.
                This means a blocking command can result in an increasing load on the guest.
                A small buffer will be added to the resulting workload exec probe to compensate for delays
                caused by the qemu guest exec mechanism.
                Defaults to 1 second. Minimum value is 1.
                More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
              format: int32
              type: integer
          type: object
        networks:
          description: List of networks that can be attached to a vm's virtual interface.
          items:
            description: Network represents a network type and a resource that should
              be connected to the vm.
            properties:
              multus:
                description: Represents the multus cni network.
                properties:
                  default:
                    description: |-
                      Select the default network and add it to the
                      multus-cni.io/default-network annotation.
                    type: boolean
                  networkName:
                    description: |-
                      References to a NetworkAttachmentDefinition CRD object. Format:
                      <networkName>, <namespace>/<networkName>. If namespace is not
                      specified, VMI namespace is assumed.
                    type: string
                required:
                - networkName
                type: object
              name:
                description: |-
                  Network name.
                  Must be a DNS_LABEL and unique within the vm.
                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                type: string
              pod:
                description: Represents the stock pod network interface.
                properties:
                  vmIPv6NetworkCIDR:
                    description: |-
                      IPv6 CIDR for the vm network.
                      Defaults to fd10:0:2::/120 if not specified.
                    type: string
                  vmNetworkCIDR:
                    description: |-
                      CIDR for vm network.
                      Default 10.0.2.0/24 if not specified.
                    type: string
                type: object
            required:
            - name
            type: object
          maxItems: 256
          type: array
        nodeSelector:
          additionalProperties:
            type: string
          description: |-
            NodeSelector is a selector which must be true for the vmi to fit on a node.
            Selector which must match a node's labels for the vmi to be scheduled on that node.
            More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
          type: object
        priorityClassName:
          description: |-
            If specified, indicates the pod's priority.
            If not specified, the pod priority will be default or zero if there is no
            default.
          type: string
        readinessProbe:
          description: |-
            Periodic probe of VirtualMachineInstance service readiness.
            VirtualmachineInstances will be removed from service endpoints if the probe fails.
            Cannot be updated.
            More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
          properties:
            exec:
              description: |-
                One and only one of the following should be specified.
                Exec specifies the action to take, it will be executed on the guest through the qemu-guest-agent.
                If the guest agent is not available, this probe will fail.
              properties:
                command:
                  description: |-
                    Command is the command line to execute inside the container, the working directory for the
                    command  is root ('/') in the container's filesystem. The command is simply exec'd, it is
                    not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use
                    a shell, you need to explicitly call out to that shell.
                    Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
                  items:
                    type: string
                  type: array
                  x-kubernetes-list-type: atomic
              type: object
            failureThreshold:
              description: |-
                Minimum consecutive failures for the probe to be considered failed after having succeeded.
                Defaults to 3. Minimum value is 1.
              format: int32
              type: integer
            guestAgentPing:
              description: GuestAgentPing contacts the qemu-guest-agent for availability
                checks.
              type: object
            httpGet:
              description: HTTPGet specifies the http request to perform.
              properties:
                host:
                  description: |-
                    Host name to connect to, defaults to the pod IP. You probably want to set
                    "Host" in httpHeaders instead.
                  type: string
                httpHeaders:
                  description: Custom headers to set in the request. HTTP allows repeated
                    headers.
                  items:
                    description: HTTPHeader describes a custom header to be used in
                      HTTP probes
                    properties:
                      name:
                        description: |-
                          The header field name.
                          This will be canonicalized upon output, so case-variant names will be understood as the same header.
                        type: string
                      value:
                        description: The header field value
                        type: string
                    required:
                    - name
                    - value
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                path:
                  description: Path to access on the HTTP server.
                  type: string
                port:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    Name or number of the port to access on the container.
                    Number must be in the range 1 to 65535.
                    Name must be an IANA_SVC_NAME.
                  x-kubernetes-int-or-string: true
                scheme:
                  description: |-
                    Scheme to use for connecting to the host.
                    Defaults to HTTP.
                  type: string
              required:
              - port
              type: object
            initialDelaySeconds:
              description: |-
                Number of seconds after the VirtualMachineInstance has started before liveness probes are initiated.
                More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
              format: int32
              type: integer
            periodSeconds:
              description: |-
                How often (in seconds) to perform the probe.
                Default to 10 seconds. Minimum value is 1.
              format: int32
              type: integer
            successThreshold:
              description: |-
                Minimum consecutive successes for the probe to be considered successful after having failed.
                Defaults to 1. Must be 1 for liveness. Minimum value is 1.
              format: int32
              type: integer
            tcpSocket:
              description: |-
                TCPSocket specifies an action involving a TCP port.
                TCP hooks not yet supported
              properties:
                host:
                  description: 'Optional: Host name to connect to, defaults to the
                    pod IP.'
                  type: string
                port:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    Number or name of the port to access on the container.
                    Number must be in the range 1 to 65535.
                    Name must be an IANA_SVC_NAME.
                  x-kubernetes-int-or-string: true
              required:
              - port
              type: object
            timeoutSeconds:
              description: |-
                Number of seconds after which the probe times out.
                For exec probes the timeout fails the probe but does not terminate the command running on the guest.
                This means a blocking command can result in an increasing load on the guest.
                A small buffer will be added to the resulting workload exec probe to compensate for delays
                caused by the qemu guest exec mechanism.
                Defaults to 1 second. Minimum value is 1.
                More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
              format: int32
              type: integer
          type: object
        resourceClaims:
          description: |-
            ResourceClaims define which ResourceClaims must be allocated
            and reserved before the VMI, hence virt-launcher pod is allowed to start. The resources
            will be made available to the domain which consumes them
            by name.

            This is an alpha field and requires enabling the
            DynamicResourceAllocation feature gate in kubernetes
             https://kubernetes.io/docs/concepts/scheduling-eviction/dynamic-resource-allocation/
            This field should only be configured if one of the feature-gates GPUsWithDRA or HostDevicesWithDRA is enabled.
            This feature is in alpha.
          items:
            description: |-
              PodResourceClaim references exactly one ResourceClaim, either directly
              or by naming a ResourceClaimTemplate which is then turned into a ResourceClaim
              for the pod.

              It adds a name to it that uniquely identifies the ResourceClaim inside the Pod.
              Containers that need access to the ResourceClaim reference it with this name.
            properties:
              name:
                description: |-
                  Name uniquely identifies this resource claim inside the pod.
                  This must be a DNS_LABEL.
                type: string
              resourceClaimName:
                description: |-
                  ResourceClaimName is the name of a ResourceClaim object in the same
                  namespace as this pod.

                  Exactly one of ResourceClaimName and ResourceClaimTemplateName must
                  be set.
                type: string
              resourceClaimTemplateName:
                description: |-
                  ResourceClaimTemplateName is the name of a ResourceClaimTemplate
                  object in the same namespace as this pod.

                  The template will be used to create a new ResourceClaim, which will
                  be bound to this pod. When this pod is deleted, the ResourceClaim
                  will also be deleted. The pod name and resource name, along with a
                  generated component, will be used to form a unique name for the
                  ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.

                  This field is immutable and no changes will be made to the
                  corresponding ResourceClaim by the control plane after creating the
                  ResourceClaim.

                  Exactly one of ResourceClaimName and ResourceClaimTemplateName must
                  be set.
                type: string
            required:
            - name
            type: object
          type: array
          x-kubernetes-list-map-keys:
          - name
          x-kubernetes-list-type: map
        schedulerName:
          description: |-
            If specified, the VMI will be dispatched by specified scheduler.
            If not specified, the VMI will be dispatched by default scheduler.
          type: string
        startStrategy:
          description: StartStrategy can be set to "Paused" if Virtual Machine should
            be started in paused state.
          type: string
        subdomain:
          description: |-
            If specified, the fully qualified vmi hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>".
            If not specified, the vmi will not have a domainname at all. The DNS entry will resolve to the vmi,
            no matter if the vmi itself can pick up a hostname.
          type: string
        terminationGracePeriodSeconds:
          description: Grace period observed after signalling a VirtualMachineInstance
            to stop after which the VirtualMachineInstance is force terminated.
          format: int64
          type: integer
        tolerations:
          description: If toleration is specified, obey all the toleration rules.
          items:
            description: |-
              The pod this Toleration is attached to tolerates any taint that matches
              the triple <key,value,effect> using the matching operator <operator>.
            properties:
              effect:
                description: |-
                  Effect indicates the taint effect to match. Empty means match all taint effects.
                  When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
                type: string
              key:
                description: |-
                  Key is the taint key that the toleration applies to. Empty means match all taint keys.
                  If the key is empty, operator must be Exists; this combination means to match all values and all keys.
                type: string
              operator:
                description: |-
                  Operator represents a key's relationship to the value.
                  Valid operators are Exists and Equal. Defaults to Equal.
                  Exists is equivalent to wildcard for value, so that a pod can
                  tolerate all taints of a particular category.
                type: string
              tolerationSeconds:
                description: |-
                  TolerationSeconds represents the period of time the toleration (which must be
                  of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
                  it is not set, which means tolerate the taint forever (do not evict). Zero and
                  negative values will be treated as 0 (evict immediately) by the system.
                format: int64
                type: integer
              value:
                description: |-
                  Value is the taint value the toleration matches to.
                  If the operator is Exists, the value should be empty, otherwise just a regular string.
                type: string
            type: object
          type: array
        topologySpreadConstraints:
          description: |-
            TopologySpreadConstraints describes how a group of VMIs will be spread across a given topology
            domains. K8s scheduler will schedule VMI pods in a way which abides by the constraints.
          items:
            description: TopologySpreadConstraint specifies how to spread matching
              pods among the given topology.
            properties:
              labelSelector:
                description: |-
                  LabelSelector is used to find matching pods.
                  Pods that match this label selector are counted to determine the number of pods
                  in their corresponding topology domain.
                properties:
                  matchExpressions:
                    description: matchExpressions is a list of label selector requirements.
                      The requirements are ANDed.
                    items:
                      description: |-
                        A label selector requirement is a selector that contains values, a key, and an operator that
                        relates the key and values.
                      properties:
                        key:
                          description: key is the label key that the selector applies
                            to.
                          type: string
                        operator:
                          description: |-
                            operator represents a key's relationship to a set of values.
                            Valid operators are In, NotIn, Exists and DoesNotExist.
                          type: string
                        values:
                          description: |-
                            values is an array of string values. If the operator is In or NotIn,
                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                            the values array must be empty. This array is replaced during a strategic
                            merge patch.
                          items:
                            type: string
                          type: array
                          x-kubernetes-list-type: atomic
                      required:
                      - key
                      - operator
                      type: object
                    type: array
                    x-kubernetes-list-type: atomic
                  matchLabels:
                    additionalProperties:
                      type: string
                    description: |-
                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                    type: object
                type: object
                x-kubernetes-map-type: atomic
              matchLabelKeys:
                description: |-
                  MatchLabelKeys is a set of pod label keys to select the pods over which
                  spreading will be calculated. The keys are used to lookup values from the
                  incoming pod labels, those key-value labels are ANDed with labelSelector
                  to select the group of existing pods over which spreading will be calculated
                  for the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector.
                  MatchLabelKeys cannot be set when LabelSelector isn't set.
                  Keys that don't exist in the incoming pod labels will
                  be ignored. A null or empty list means only match against labelSelector.

                  This is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).
                items:
                  type: string
                type: array
                x-kubernetes-list-type: atomic
              maxSkew:
                description: |-
                  MaxSkew describes the degree to which pods may be unevenly distributed.
                  When 'whenUnsatisfiable=DoNotSchedule', it is the maximum permitted difference
                  between the number of matching pods in the target topology and the global minimum.
                  The global minimum is the minimum number of matching pods in an eligible domain
                  or zero if the number of eligible domains is less than MinDomains.
                  For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
                  labelSelector spread as 2/2/1:
                  In this case, the global minimum is 1.
                  | zone1 | zone2 | zone3 |
                  |  P P  |  P P  |   P   |
                  - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2;
                  scheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2)
                  violate MaxSkew(1).
                  - if MaxSkew is 2, incoming pod can be scheduled onto any zone.
                  When 'whenUnsatisfiable=ScheduleAnyway', it is used to give higher precedence
                  to topologies that satisfy it.
                  It's a required field. Default value is 1 and 0 is not allowed.
                format: int32
                type: integer
              minDomains:
                description: |-
                  MinDomains indicates a minimum number of eligible domains.
                  When the number of eligible domains with matching topology keys is less than minDomains,
                  Pod Topology Spread treats "global minimum" as 0, and then the calculation of Skew is performed.
                  And when the number of eligible domains with matching topology keys equals or greater than minDomains,
                  this value has no effect on scheduling.
                  As a result, when the number of eligible domains is less than minDomains,
                  scheduler won't schedule more than maxSkew Pods to those domains.
                  If value is nil, the constraint behaves as if MinDomains is equal to 1.
                  Valid values are integers greater than 0.
                  When value is not nil, WhenUnsatisfiable must be DoNotSchedule.

                  For example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same
                  labelSelector spread as 2/2/2:
                  | zone1 | zone2 | zone3 |
                  |  P P  |  P P  |  P P  |
                  The number of domains is less than 5(MinDomains), so "global minimum" is treated as 0.
                  In this situation, new pod with the same labelSelector cannot be scheduled,
                  because computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones,
                  it will violate MaxSkew.
                format: int32
                type: integer
              nodeAffinityPolicy:
                description: |-
                  NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector
                  when calculating pod topology spread skew. Options are:
                  - Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations.
                  - Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.

                  If this value is nil, the behavior is equivalent to the Honor policy.
                  This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
                type: string
              nodeTaintsPolicy:
                description: |-
                  NodeTaintsPolicy indicates how we will treat node taints when calculating
                  pod topology spread skew. Options are:
                  - Honor: nodes without taints, along with tainted nodes for which the incoming pod
                  has a toleration, are included.
                  - Ignore: node taints are ignored. All nodes are included.

                  If this value is nil, the behavior is equivalent to the Ignore policy.
                  This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
                type: string
              topologyKey:
                description: |-
                  TopologyKey is the key of node labels. Nodes that have a label with this key
                  and identical values are considered to be in the same topology.
                  We consider each <key, value> as a "bucket", and try to put balanced number
                  of pods into each bucket.
                  We define a domain as a particular instance of a topology.
                  Also, we define an eligible domain as a domain whose nodes meet the requirements of
                  nodeAffinityPolicy and nodeTaintsPolicy.
                  e.g. If TopologyKey is "kubernetes.io/hostname", each Node is a domain of that topology.
                  And, if TopologyKey is "topology.kubernetes.io/zone", each zone is a domain of that topology.
                  It's a required field.
                type: string
              whenUnsatisfiable:
                description: |-
                  WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy
                  the spread constraint.
                  - DoNotSchedule (default) tells the scheduler not to schedule it.
                  - ScheduleAnyway tells the scheduler to schedule the pod in any location,
                    but giving higher precedence to topologies that would help reduce the
                    skew.
                  A constraint is considered "Unsatisfiable" for an incoming pod
                  if and only if every possible node assignment for that pod would violate
                  "MaxSkew" on some topology.
                  For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
                  labelSelector spread as 3/1/1:
                  | zone1 | zone2 | zone3 |
                  | P P P |   P   |   P   |
                  If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled
                  to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies
                  MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler
                  won't make it *more* imbalanced.
                  It's a required field.
                type: string
            required:
            - maxSkew
            - topologyKey
            - whenUnsatisfiable
            type: object
          type: array
          x-kubernetes-list-map-keys:
          - topologyKey
          - whenUnsatisfiable
          x-kubernetes-list-type: map
        volumes:
          description: List of volumes that can be mounted by disks belonging to the
            vmi.
          items:
            description: Volume represents a named volume in a vmi.
            properties:
              cloudInitConfigDrive:
                description: |-
                  CloudInitConfigDrive represents a cloud-init Config Drive user-data source.
                  The Config Drive data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest.
                  More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html
                properties:
                  networkData:
                    description: NetworkData contains config drive inline cloud-init
                      networkdata.
                    type: string
                  networkDataBase64:
                    description: NetworkDataBase64 contains config drive cloud-init
                      networkdata as a base64 encoded string.
                    type: string
                  networkDataSecretRef:
                    description: NetworkDataSecretRef references a k8s secret that
                      contains config drive networkdata.
                    properties:
                      name:
                        default: ""
                        description: |-
                          Name of the referent.
                          This field is effectively required, but due to backwards compatibility is
                          allowed to be empty. Instances of this type with an empty value here are
                          almost certainly wrong.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                    type: object
                    x-kubernetes-map-type: atomic
                  secretRef:
                    description: UserDataSecretRef references a k8s secret that contains
                      config drive userdata.
                    properties:
                      name:
                        default: ""
                        description: |-
                          Name of the referent.
                          This field is effectively required, but due to backwards compatibility is
                          allowed to be empty. Instances of this type with an empty value here are
                          almost certainly wrong.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                    type: object
                    x-kubernetes-map-type: atomic
                  userData:
                    description: UserData contains config drive inline cloud-init
                      userdata.
                    type: string
                  userDataBase64:
                    description: UserDataBase64 contains config drive cloud-init userdata
                      as a base64 encoded string.
                    type: string
                type: object
              cloudInitNoCloud:
                description: |-
                  CloudInitNoCloud represents a cloud-init NoCloud user-data source.
                  The NoCloud data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest.
                  More info: http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html
                properties:
                  networkData:
                    description: NetworkData contains NoCloud inline cloud-init networkdata.
                    type: string
                  networkDataBase64:
                    description: NetworkDataBase64 contains NoCloud cloud-init networkdata
                      as a base64 encoded string.
                    type: string
                  networkDataSecretRef:
                    description: NetworkDataSecretRef references a k8s secret that
                      contains NoCloud networkdata.
                    properties:
                      name:
                        default: ""
                        description: |-
                          Name of the referent.
                          This field is effectively required, but due to backwards compatibility is
                          allowed to be empty. Instances of this type with an empty value here are
                          almost certainly wrong.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                    type: object
                    x-kubernetes-map-type: atomic
                  secretRef:
                    description: UserDataSecretRef references a k8s secret that contains
                      NoCloud userdata.
                    properties:
                      name:
                        default: ""
                        description: |-
                          Name of the referent.
                          This field is effectively required, but due to backwards compatibility is
                          allowed to be empty. Instances of this type with an empty value here are
                          almost certainly wrong.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                    type: object
                    x-kubernetes-map-type: atomic
                  userData:
                    description: UserData contains NoCloud inline cloud-init userdata.
                    type: string
                  userDataBase64:
                    description: UserDataBase64 contains NoCloud cloud-init userdata
                      as a base64 encoded string.
                    type: string
                type: object
              configMap:
                description: |-
                  ConfigMapSource represents a reference to a ConfigMap in the same namespace.
                  More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-pod-configmap/
                properties:
                  name:
                    default: ""
                    description: |-
                      Name of the referent.
                      This field is effectively required, but due to backwards compatibility is
                      allowed to be empty. Instances of this type with an empty value here are
                      almost certainly wrong.
                      More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                    type: string
                  optional:
                    description: Specify whether the ConfigMap or it's keys must be
                      defined
                    type: boolean
                  volumeLabel:
                    description: |-
                      The volume label of the resulting disk inside the VMI.
                      Different bootstrapping mechanisms require different values.
                      Typical values are "cidata" (cloud-init), "config-2" (cloud-init) or "OEMDRV" (kickstart).
                    type: string
                type: object
                x-kubernetes-map-type: atomic
              containerDisk:
                description: |-
                  ContainerDisk references a docker image, embedding a qcow or raw disk.
                  More info: https://kubevirt.gitbooks.io/user-guide/registry-disk.html
                properties:
                  image:
                    description: Image is the name of the image with the embedded
                      disk.
                    type: string
                  imagePullPolicy:
                    description: |-
                      Image pull policy.
                      One of Always, Never, IfNotPresent.
                      Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
                      Cannot be updated.
                      More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
                    type: string
                  imagePullSecret:
                    description: ImagePullSecret is the name of the Docker registry
                      secret required to pull the image. The secret must already exist.
                    type: string
                  path:
                    description: Path defines the path to disk file in the container
                    type: string
                required:
                - image
                type: object
              dataVolume:
                description: |-
                  DataVolume represents the dynamic creation a PVC for this volume as well as
                  the process of populating that PVC with a disk image.
                properties:
                  hotpluggable:
                    description: Hotpluggable indicates whether the volume can be
                      hotplugged and hotunplugged.
                    type: boolean
                  name:
                    description: Name of both the DataVolume and the PVC in the same
                      namespace.
                    type: string
                required:
                - name
                type: object
              downwardAPI:
                description: DownwardAPI represents downward API about the pod that
                  should populate this volume
                properties:
                  fields:
                    description: Fields is a list of downward API volume file
                    items:
                      description: DownwardAPIVolumeFile represents information to
                        create the file containing the pod field
                      properties:
                        fieldRef:
                          description: 'Required: Selects a field of the pod: only
                            annotations, labels, name, namespace and uid are supported.'
                          properties:
                            apiVersion:
                              description: Version of the schema the FieldPath is
                                written in terms of, defaults to "v1".
                              type: string
                            fieldPath:
                              description: Path of the field to select in the specified
                                API version.
                              type: string
                          required:
                          - fieldPath
                          type: object
                          x-kubernetes-map-type: atomic
                        mode:
                          description: |-
                            Optional: mode bits used to set permissions on this file, must be an octal value
                            between 0000 and 0777 or a decimal value between 0 and 511.
                            YAML accepts both octal and decimal values, JSON requires decimal values for mode bits.
                            If not specified, the volume defaultMode will be used.
                            This might be in conflict with other options that affect the file
                            mode, like fsGroup, and the result can be other mode bits set.
                          format: int32
                          type: integer
                        path:
                          description: 'Required: Path is  the relative path name
                            of the file to be created. Must not be absolute or contain
                            the ''..'' path. Must be utf-8 encoded. The first item
                            of the relative path must not start with ''..'''
                          type: string
                        resourceFieldRef:
                          description: |-
                            Selects a resource of the container: only resources limits and requests
                            (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
                          properties:
                            containerName:
                              description: 'Container name: required for volumes,
                                optional for env vars'
                              type: string
                            divisor:
                              anyOf:
                              - type: integer
                              - type: string
                              description: Specifies the output format of the exposed
                                resources, defaults to "1"
                              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                              x-kubernetes-int-or-string: true
                            resource:
                              description: 'Required: resource to select'
                              type: string
                          required:
                          - resource
                          type: object
                          x-kubernetes-map-type: atomic
                      required:
                      - path
                      type: object
                    type: array
                  volumeLabel:
                    description: |-
                      The volume label of the resulting disk inside the VMI.
                      Different bootstrapping mechanisms require different values.
                      Typical values are "cidata" (cloud-init), "config-2" (cloud-init) or "OEMDRV" (kickstart).
                    type: string
                type: object
              downwardMetrics:
                description: |-
                  DownwardMetrics adds a very small disk to VMIs which contains a limited view of host and guest
                  metrics. The disk content is compatible with vhostmd (https://github.com/vhostmd/vhostmd) and vm-dump-metrics.
                type: object
              emptyDisk:
                description: |-
                  EmptyDisk represents a temporary disk which shares the vmis lifecycle.
                  More info: https://kubevirt.gitbooks.io/user-guide/disks-and-volumes.html
                properties:
                  capacity:
                    anyOf:
                    - type: integer
                    - type: string
                    description: Capacity of the sparse disk.
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                required:
                - capacity
                type: object
              ephemeral:
                description: Ephemeral is a special volume source that "wraps" specified
                  source and provides copy-on-write image on top of it.
                properties:
                  persistentVolumeClaim:
                    description: |-
                      PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace.
                      Directly attached to the vmi via qemu.
                      More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                    properties:
                      claimName:
                        description: |-
                          claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
                          More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                        type: string
                      readOnly:
                        description: |-
                          readOnly Will force the ReadOnly setting in VolumeMounts.
                          Default false.
                        type: boolean
                    required:
                    - claimName
                    type: object
                type: object
              hostDisk:
                description: HostDisk represents a disk created on the cluster level
                properties:
                  capacity:
                    anyOf:
                    - type: integer
                    - type: string
                    description: Capacity of the sparse disk
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  path:
                    description: The path to HostDisk image located on the cluster
                    type: string
                  shared:
                    description: Shared indicate whether the path is shared between
                      nodes
                    type: boolean
                  type:
                    description: |-
                      Contains information if disk.img exists or should be created
                      allowed options are 'Disk' and 'DiskOrCreate'
                    type: string
                required:
                - path
                - type
                type: object
              memoryDump:
                description: MemoryDump is attached to the virt launcher and is populated
                  with a memory dump of the vmi
                properties:
                  claimName:
                    description: |-
                      claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
                      More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                    type: string
                  hotpluggable:
                    description: Hotpluggable indicates whether the volume can be
                      hotplugged and hotunplugged.
                    type: boolean
                  readOnly:
                    description: |-
                      readOnly Will force the ReadOnly setting in VolumeMounts.
                      Default false.
                    type: boolean
                required:
                - claimName
                type: object
              name:
                description: |-
                  Volume's name.
                  Must be a DNS_LABEL and unique within the vmi.
                  More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                type: string
              persistentVolumeClaim:
                description: |-
                  PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace.
                  Directly attached to the vmi via qemu.
                  More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                properties:
                  claimName:
                    description: |-
                      claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
                      More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
                    type: string
                  hotpluggable:
                    description: Hotpluggable indicates whether the volume can be
                      hotplugged and hotunplugged.
                    type: boolean
                  readOnly:
                    description: |-
                      readOnly Will force the ReadOnly setting in VolumeMounts.
                      Default false.
                    type: boolean
                required:
                - claimName
                type: object
              secret:
                description: |-
                  SecretVolumeSource represents a reference to a secret data in the same namespace.
                  More info: https://kubernetes.io/docs/concepts/configuration/secret/
                properties:
                  optional:
                    description: Specify whether the Secret or it's keys must be defined
                    type: boolean
                  secretName:
                    description: |-
                      Name of the secret in the pod's namespace to use.
                      More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
                    type: string
                  volumeLabel:
                    description: |-
                      The volume label of the resulting disk inside the VMI.
                      Different bootstrapping mechanisms require different values.
                      Typical values are "cidata" (cloud-init), "config-2" (cloud-init) or "OEMDRV" (kickstart).
                    type: string
                type: object
              serviceAccount:
                description: |-
                  ServiceAccountVolumeSource represents a reference to a service account.
                  There can only be one volume of this type!
                  More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
                properties:
                  serviceAccountName:
                    description: |-
                      Name of the service account in the pod's namespace to use.
                      More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
                    type: string
                type: object
              sysprep:
                description: Represents a Sysprep volume source.
                properties:
                  configMap:
                    description: ConfigMap references a ConfigMap that contains Sysprep
                      answer file named autounattend.xml that should be attached as
                      disk of CDROM type.
                    properties:
                      name:
                        default: ""
                        description: |-
                          Name of the referent.
                          This field is effectively required, but due to backwards compatibility is
                          allowed to be empty. Instances of this type with an empty value here are
                          almost certainly wrong.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                    type: object
                    x-kubernetes-map-type: atomic
                  secret:
                    description: Secret references a k8s Secret that contains Sysprep
                      answer file named autounattend.xml that should be attached as
                      disk of CDROM type.
                    properties:
                      name:
                        default: ""
                        description: |-
                          Name of the referent.
                          This field is effectively required, but due to backwards compatibility is
                          allowed to be empty. Instances of this type with an empty value here are
                          almost certainly wrong.
                          More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
                        type: string
                    type: object
                    x-kubernetes-map-type: atomic
                type: object
            required:
            - name
            type: object
          maxItems: 256
          type: array
      required:
      - domain
      type: object
    status:
      description: Status is the high level overview of how the VirtualMachineInstance
        is doing. It contains information available to controllers and users.
      properties:
        VSOCKCID:
          description: VSOCKCID is used to track the allocated VSOCK CID in the VM.
          format: int32
          type: integer
        activePods:
          additionalProperties:
            type: string
          description: |-
            ActivePods is a mapping of pod UID to node name.
            It is possible for multiple pods to be running for a single VMI during migration.
          type: object
        conditions:
          description: Conditions are specific points in VirtualMachineInstance's
            pod runtime.
          items:
            properties:
              lastProbeTime:
                format: date-time
                nullable: true
                type: string
              lastTransitionTime:
                format: date-time
                nullable: true
                type: string
              message:
                type: string
              reason:
                type: string
              status:
                type: string
              type:
                type: string
            required:
            - status
            - type
            type: object
          type: array
        currentCPUTopology:
          description: |-
            CurrentCPUTopology specifies the current CPU topology used by the VM workload.
            Current topology may differ from the desired topology in the spec while CPU hotplug
            takes place.
          properties:
            cores:
              description: |-
                Cores specifies the number of cores inside the vmi.
                Must be a value greater or equal 1.
              format: int32
              type: integer
            sockets:
              description: |-
                Sockets specifies the number of sockets inside the vmi.
                Must be a value greater or equal 1.
              format: int32
              type: integer
            threads:
              description: |-
                Threads specifies the number of threads inside the vmi.
                Must be a value greater or equal 1.
              format: int32
              type: integer
          type: object
        deviceStatus:
          description: |-
            DeviceStatus reflects the state of devices requested in spec.domain.devices. This is an optional field available
            only when DRA feature gate is enabled
            This field will only be populated if one of the feature-gates GPUsWithDRA or HostDevicesWithDRA is enabled.
            This feature is in alpha.
          properties:
            gpuStatuses:
              description: GPUStatuses reflects the state of GPUs requested in spec.domain.devices.gpus
              items:
                properties:
                  deviceResourceClaimStatus:
                    description: DeviceResourceClaimStatus reflects the DRA related
                      information for the device
                    properties:
                      attributes:
                        description: |-
                          Attributes are properties of the device that could be used by kubevirt and other copmonents to learn more
                          about the device, like pciAddress or mdevUUID
                        properties:
                          mDevUUID:
                            description: MDevUUID is the mediated device uuid of the
                              allocated device
                            type: string
                          pciAddress:
                            description: PCIAddress is the PCIe bus address of the
                              allocated device
                            type: string
                        type: object
                      name:
                        description: Name is the name of actual device on the host
                          provisioned by the driver as reflected in resourceclaim.status
                        type: string
                      resourceClaimName:
                        description: ResourceClaimName is the name of the resource
                          claims object used to provision this resource
                        type: string
                    type: object
                  name:
                    description: Name of the device as specified in spec.domain.devices.gpus.name
                      or spec.domain.devices.hostDevices.name
                    type: string
                required:
                - name
                type: object
              type: array
              x-kubernetes-list-type: atomic
            hostDeviceStatuses:
              description: |-
                HostDeviceStatuses reflects the state of GPUs requested in spec.domain.devices.hostDevices
                DRA
              items:
                properties:
                  deviceResourceClaimStatus:
                    description: DeviceResourceClaimStatus reflects the DRA related
                      information for the device
                    properties:
                      attributes:
                        description: |-
                          Attributes are properties of the device that could be used by kubevirt and other copmonents to learn more
                          about the device, like pciAddress or mdevUUID
                        properties:
                          mDevUUID:
                            description: MDevUUID is the mediated device uuid of the
                              allocated device
                            type: string
                          pciAddress:
                            description: PCIAddress is the PCIe bus address of the
                              allocated device
                            type: string
                        type: object
                      name:
                        description: Name is the name of actual device on the host
                          provisioned by the driver as reflected in resourceclaim.status
                        type: string
                      resourceClaimName:
                        description: ResourceClaimName is the name of the resource
                          claims object used to provision this resource
                        type: string
                    type: object
                  name:
                    description: Name of the device as specified in spec.domain.devices.gpus.name
                      or spec.domain.devices.hostDevices.name
                    type: string
                required:
                - name
                type: object
              type: array
              x-kubernetes-list-type: atomic
          type: object
        evacuationNodeName:
          description: |-
            EvacuationNodeName is used to track the eviction process of a VMI. It stores the name of the node that we want
            to evacuate. It is meant to be used by KubeVirt core components only and can't be set or modified by users.
          type: string
        fsFreezeStatus:
          description: |-
            FSFreezeStatus indicates whether a freeze operation was requested for the guest filesystem.
            It will be set to "frozen" if the request was made, or unset otherwise.
            This does not reflect the actual state of the guest filesystem.
          type: string
        guestOSInfo:
          description: Guest OS Information
          properties:
            id:
              description: Guest OS Id
              type: string
            kernelRelease:
              description: Guest OS Kernel Release
              type: string
            kernelVersion:
              description: Kernel version of the Guest OS
              type: string
            machine:
              description: Machine type of the Guest OS
              type: string
            name:
              description: Name of the Guest OS
              type: string
            prettyName:
              description: Guest OS Pretty Name
              type: string
            version:
              description: Guest OS Version
              type: string
            versionId:
              description: Version ID of the Guest OS
              type: string
          type: object
        interfaces:
          description: Interfaces represent the details of available network interfaces.
          items:
            properties:
              infoSource:
                description: 'Specifies the origin of the interface data collected.
                  values: domain, guest-agent, multus-status.'
                type: string
              interfaceName:
                description: The interface name inside the Virtual Machine
                type: string
              ipAddress:
                description: |-
                  IP address of a Virtual Machine interface. It is always the first item of
                  IPs
                type: string
              ipAddresses:
                description: List of all IP addresses of a Virtual Machine interface
                items:
                  type: string
                type: array
              linkState:
                description: 'LinkState Reports the current operational link state''.
                  values: up, down.'
                type: string
              mac:
                description: Hardware address of a Virtual Machine interface
                type: string
              name:
                description: Name of the interface, corresponds to name of the network
                  assigned to the interface
                type: string
              podInterfaceName:
                description: PodInterfaceName represents the name of the pod network
                  interface
                type: string
              queueCount:
                description: Specifies how many queues are allocated by MultiQueue
                format: int32
                type: integer
            type: object
          type: array
        kernelBootStatus:
          description: KernelBootStatus contains info about the kernelBootContainer
          properties:
            initrdInfo:
              description: InitrdInfo show info about the initrd file
              properties:
                checksum:
                  description: Checksum is the checksum of the initrd file
                  format: int32
                  type: integer
              type: object
            kernelInfo:
              description: KernelInfo show info about the kernel image
              properties:
                checksum:
                  description: Checksum is the checksum of the kernel image
                  format: int32
                  type: integer
              type: object
          type: object
        launcherContainerImageVersion:
          description: LauncherContainerImageVersion indicates what container image
            is currently active for the vmi.
          type: string
        machine:
          description: |-
            Machine shows the final resulting qemu machine type. This can be different
            than the machine type selected in the spec, due to qemus machine type alias mechanism.
          properties:
            type:
              description: QEMU machine type is the actual chipset of the VirtualMachineInstance.
              type: string
          type: object
        memory:
          description: Memory shows various informations about the VirtualMachine
            memory.
          properties:
            guestAtBoot:
              anyOf:
              - type: integer
              - type: string
              description: GuestAtBoot specifies with how much memory the VirtualMachine
                intiallly booted with.
              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
              x-kubernetes-int-or-string: true
            guestCurrent:
              anyOf:
              - type: integer
              - type: string
              description: GuestCurrent specifies how much memory is currently available
                for the VirtualMachine.
              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
              x-kubernetes-int-or-string: true
            guestRequested:
              anyOf:
              - type: integer
              - type: string
              description: GuestRequested specifies how much memory was requested
                (hotplug) for the VirtualMachine.
              pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
              x-kubernetes-int-or-string: true
          type: object
        migratedVolumes:
          description: MigratedVolumes lists the source and destination volumes during
            the volume migration
          items:
            description: StorageMigratedVolumeInfo tracks the information about the
              source and destination volumes during the volume migration
            properties:
              destinationPVCInfo:
                description: DestinationPVCInfo contains the information about the
                  destination PVC
                properties:
                  accessModes:
                    description: |-
                      AccessModes contains the desired access modes the volume should have.
                      More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
                    items:
                      type: string
                    type: array
                    x-kubernetes-list-type: atomic
                  capacity:
                    additionalProperties:
                      anyOf:
                      - type: integer
                      - type: string
                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                      x-kubernetes-int-or-string: true
                    description: Capacity represents the capacity set on the corresponding
                      PVC status
                    type: object
                  claimName:
                    description: ClaimName is the name of the PVC
                    type: string
                  filesystemOverhead:
                    description: Percentage of filesystem's size to be reserved when
                      resizing the PVC
                    pattern: ^(0(?:\.\d{1,3})?|1)$
                    type: string
                  preallocated:
                    description: Preallocated indicates if the PVC's storage is preallocated
                      or not
                    type: boolean
                  requests:
                    additionalProperties:
                      anyOf:
                      - type: integer
                      - type: string
                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                      x-kubernetes-int-or-string: true
                    description: Requests represents the resources requested by the
                      corresponding PVC spec
                    type: object
                  volumeMode:
                    description: |-
                      VolumeMode defines what type of volume is required by the claim.
                      Value of Filesystem is implied when not included in claim spec.
                    type: string
                type: object
              sourcePVCInfo:
                description: SourcePVCInfo contains the information about the source
                  PVC
                properties:
                  accessModes:
                    description: |-
                      AccessModes contains the desired access modes the volume should have.
                      More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
                    items:
                      type: string
                    type: array
                    x-kubernetes-list-type: atomic
                  capacity:
                    additionalProperties:
                      anyOf:
                      - type: integer
                      - type: string
                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                      x-kubernetes-int-or-string: true
                    description: Capacity represents the capacity set on the corresponding
                      PVC status
                    type: object
                  claimName:
                    description: ClaimName is the name of the PVC
                    type: string
                  filesystemOverhead:
                    description: Percentage of filesystem's size to be reserved when
                      resizing the PVC
                    pattern: ^(0(?:\.\d{1,3})?|1)$
                    type: string
                  preallocated:
                    description: Preallocated indicates if the PVC's storage is preallocated
                      or not
                    type: boolean
                  requests:
                    additionalProperties:
                      anyOf:
                      - type: integer
                      - type: string
                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                      x-kubernetes-int-or-string: true
                    description: Requests represents the resources requested by the
                      corresponding PVC spec
                    type: object
                  volumeMode:
                    description: |-
                      VolumeMode defines what type of volume is required by the claim.
                      Value of Filesystem is implied when not included in claim spec.
                    type: string
                type: object
              volumeName:
                description: VolumeName is the name of the volume that is being migrated
                type: string
            required:
            - volumeName
            type: object
          type: array
          x-kubernetes-list-type: atomic
        migrationMethod:
          description: 'Represents the method using which the vmi can be migrated:
            live migration or block migration'
          type: string
        migrationState:
          description: Represents the status of a live migration
          properties:
            abortRequested:
              description: Indicates that the migration has been requested to abort
              type: boolean
            abortStatus:
              description: Indicates the final status of the live migration abortion
              type: string
            completed:
              description: Indicates the migration completed
              type: boolean
            endTimestamp:
              description: The time the migration action ended
              format: date-time
              nullable: true
              type: string
            failed:
              description: Indicates that the migration failed
              type: boolean
            failureReason:
              description: Contains the reason why the migration failed
              type: string
            migrationConfiguration:
              description: Migration configurations to apply
              properties:
                allowAutoConverge:
                  description: |-
                    AllowAutoConverge allows the platform to compromise performance/availability of VMIs to
                    guarantee successful VMI live migrations. Defaults to false
                  type: boolean
                allowPostCopy:
                  description: |-
                    AllowPostCopy enables post-copy live migrations. Such migrations allow even the busiest VMIs
                    to successfully live-migrate. However, events like a network failure can cause a VMI crash.
                    If set to true, migrations will still start in pre-copy, but switch to post-copy when
                    CompletionTimeoutPerGiB triggers. Defaults to false
                  type: boolean
                allowWorkloadDisruption:
                  description: |-
                    AllowWorkloadDisruption indicates that the migration shouldn't be
                    canceled after acceptableCompletionTime is exceeded. Instead, if
                    permitted, migration will be switched to post-copy or the VMI will be
                    paused to allow the migration to complete
                  type: boolean
                bandwidthPerMigration:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    BandwidthPerMigration limits the amount of network bandwidth live migrations are allowed to use.
                    The value is in quantity per second. Defaults to 0 (no limit)
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
                completionTimeoutPerGiB:
                  description: |-
                    CompletionTimeoutPerGiB is the maximum number of seconds per GiB a migration is allowed to take.
                    If the timeout is reached, the migration will be either paused, switched
                    to post-copy or cancelled depending on other settings. Defaults to 150
                  format: int64
                  type: integer
                disableTLS:
                  description: |-
                    When set to true, DisableTLS will disable the additional layer of live migration encryption
                    provided by KubeVirt. This is usually a bad idea. Defaults to false
                  type: boolean
                matchSELinuxLevelOnMigration:
                  description: |-
                    By default, the SELinux level of target virt-launcher pods is forced to the level of the source virt-launcher.
                    When set to true, MatchSELinuxLevelOnMigration lets the CRI auto-assign a random level to the target.
                    That will ensure the target virt-launcher doesn't share categories with another pod on the node.
                    However, migrations will fail when using RWX volumes that don't automatically deal with SELinux levels.
                  type: boolean
                network:
                  description: |-
                    Network is the name of the CNI network to use for live migrations. By default, migrations go
                    through the pod network.
                  type: string
                nodeDrainTaintKey:
                  description: |-
                    NodeDrainTaintKey defines the taint key that indicates a node should be drained.
                    Note: this option relies on the deprecated node taint feature. Default: kubevirt.io/drain
                  type: string
                parallelMigrationsPerCluster:
                  description: |-
                    ParallelMigrationsPerCluster is the total number of concurrent live migrations
                    allowed cluster-wide. Defaults to 5
                  format: int32
                  type: integer
                parallelOutboundMigrationsPerNode:
                  description: |-
                    ParallelOutboundMigrationsPerNode is the maximum number of concurrent outgoing live migrations
                    allowed per node. Defaults to 2
                  format: int32
                  type: integer
                progressTimeout:
                  description: |-
                    ProgressTimeout is the maximum number of seconds a live migration is allowed to make no progress.
                    Hitting this timeout means a migration transferred 0 data for that many seconds. The migration is
                    then considered stuck and therefore cancelled. Defaults to 150
                  format: int64
                  type: integer
                unsafeMigrationOverride:
                  description: |-
                    UnsafeMigrationOverride allows live migrations to occur even if the compatibility check
                    indicates the migration will be unsafe to the guest. Defaults to false
                  type: boolean
              type: object
            migrationNetworkType:
              description: The type of migration network, either 'pod' or 'migration'
              type: string
            migrationPolicyName:
              description: Name of the migration policy. If string is empty, no policy
                is matched
              type: string
            migrationUid:
              description: The VirtualMachineInstanceMigration object associated with
                this migration
              type: string
            mode:
              description: Lets us know if the vmi is currently running pre or post
                copy migration
              type: string
            sourceNode:
              description: The source node that the VMI originated on
              type: string
            sourcePersistentStatePVCName:
              description: If the VMI being migrated uses persistent features (backend-storage),
                its source PVC name is saved here
              type: string
            sourcePod:
              type: string
            sourceState:
              description: SourceState contains migration state managed by the source
                virt handler
              properties:
                domainName:
                  description: The name of the domain on the source libvirt domain
                  type: string
                domainNamespace:
                  description: Namespace used in the name of the source libvirt domain.
                    Can be used to find and modify paths in the domain
                  type: string
                migrationUID:
                  description: The Source VirtualMachineInstanceMigration object associated
                    with this migration
                  type: string
                node:
                  description: The source node that the VMI originated on
                  type: string
                nodeSelectors:
                  additionalProperties:
                    type: string
                  description: Node selectors needed by the target to start the receiving
                    pod.
                  type: object
                persistentStatePVCName:
                  description: If the VMI being migrated uses persistent features
                    (backend-storage), its source PVC name is saved here
                  type: string
                pod:
                  description: The source pod that the VMI is originated on
                  type: string
                selinuxContext:
                  description: SELinuxContext is the actual SELinux context of the
                    pod
                  type: string
                syncAddress:
                  description: The ip address/fqdn:port combination to use to synchronize
                    the VMI with the target.
                  type: string
                virtualMachineInstanceUID:
                  description: VirtualMachineInstanceUID is the UID of the target
                    virtual machine instance
                  type: string
              type: object
            startTimestamp:
              description: The time the migration action began
              format: date-time
              nullable: true
              type: string
            targetAttachmentPodUID:
              description: The UID of the target attachment pod for hotplug volumes
              type: string
            targetCPUSet:
              description: |-
                If the VMI requires dedicated CPUs, this field will
                hold the dedicated CPU set on the target node
              items:
                type: integer
              type: array
              x-kubernetes-list-type: atomic
            targetDirectMigrationNodePorts:
              additionalProperties:
                type: integer
              description: The list of ports opened for live migration on the destination
                node
              type: object
            targetNode:
              description: The target node that the VMI is moving to
              type: string
            targetNodeAddress:
              description: The address of the target node to use for the migration
              type: string
            targetNodeDomainDetected:
              description: The Target Node has seen the Domain Start Event
              type: boolean
            targetNodeDomainReadyTimestamp:
              description: The timestamp at which the target node detects the domain
                is active
              format: date-time
              type: string
            targetNodeTopology:
              description: |-
                If the VMI requires dedicated CPUs, this field will
                hold the numa topology on the target node
              type: string
            targetPersistentStatePVCName:
              description: If the VMI being migrated uses persistent features (backend-storage),
                its target PVC name is saved here
              type: string
            targetPod:
              description: The target pod that the VMI is moving to
              type: string
            targetState:
              description: TargetState contains migration state managed by the target
                virt handler
              properties:
                attachmentPodUID:
                  description: The UID of the target attachment pod for hotplug volumes
                  type: string
                cpuSet:
                  description: |-
                    If the VMI requires dedicated CPUs, this field will
                    hold the dedicated CPU set on the target node
                  items:
                    type: integer
                  type: array
                  x-kubernetes-list-type: atomic
                directMigrationNodePorts:
                  additionalProperties:
                    type: integer
                  description: The list of ports opened for live migration on the
                    destination node
                  type: object
                domainDetected:
                  description: The Target Node has seen the Domain Start Event
                  type: boolean
                domainName:
                  description: The name of the domain on the source libvirt domain
                  type: string
                domainNamespace:
                  description: Namespace used in the name of the source libvirt domain.
                    Can be used to find and modify paths in the domain
                  type: string
                domainReadyTimestamp:
                  description: The timestamp at which the target node detects the
                    domain is active
                  format: date-time
                  type: string
                migrationUID:
                  description: The Source VirtualMachineInstanceMigration object associated
                    with this migration
                  type: string
                node:
                  description: The source node that the VMI originated on
                  type: string
                nodeAddress:
                  description: The address of the target node to use for the migration
                  type: string
                nodeTopology:
                  description: |-
                    If the VMI requires dedicated CPUs, this field will
                    hold the numa topology on the target node
                  type: string
                persistentStatePVCName:
                  description: If the VMI being migrated uses persistent features
                    (backend-storage), its source PVC name is saved here
                  type: string
                pod:
                  description: The source pod that the VMI is originated on
                  type: string
                selinuxContext:
                  description: SELinuxContext is the actual SELinux context of the
                    pod
                  type: string
                syncAddress:
                  description: The ip address/fqdn:port combination to use to synchronize
                    the VMI with the target.
                  type: string
                virtualMachineInstanceUID:
                  description: VirtualMachineInstanceUID is the UID of the target
                    virtual machine instance
                  type: string
              type: object
          type: object
        migrationTransport:
          description: This represents the migration transport
          type: string
        nodeName:
          description: NodeName is the name where the VirtualMachineInstance is currently
            running.
          type: string
        phase:
          description: Phase is the status of the VirtualMachineInstance in kubernetes
            world. It is not the VirtualMachineInstance status, but partially correlates
            to it.
          type: string
        phaseTransitionTimestamps:
          description: PhaseTransitionTimestamp is the timestamp of when the last
            phase change occurred
          items:
            description: VirtualMachineInstancePhaseTransitionTimestamp gives a timestamp
              in relation to when a phase is set on a vmi
            properties:
              phase:
                description: Phase is the status of the VirtualMachineInstance in
                  kubernetes world. It is not the VirtualMachineInstance status, but
                  partially correlates to it.
                type: string
              phaseTransitionTimestamp:
                description: PhaseTransitionTimestamp is the timestamp of when the
                  phase change occurred
                format: date-time
                type: string
            type: object
          type: array
          x-kubernetes-list-type: atomic
        qosClass:
          description: |-
            The Quality of Service (QOS) classification assigned to the virtual machine instance based on resource requirements
            See PodQOSClass type for available QOS classes
            More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
          type: string
        reason:
          description: A brief CamelCase message indicating details about why the
            VMI is in this state. e.g. 'NodeUnresponsive'
          type: string
        runtimeUser:
          description: RuntimeUser is used to determine what user will be used in
            launcher
          format: int64
          type: integer
        selinuxContext:
          description: SELinuxContext is the actual SELinux context of the virt-launcher
            pod
          type: string
        topologyHints:
          properties:
            tscFrequency:
              format: int64
              type: integer
          type: object
        virtualMachineRevisionName:
          description: |-
            VirtualMachineRevisionName is used to get the vm revision of the vmi when doing
            an online vm snapshot
          type: string
        volumeStatus:
          description: VolumeStatus contains the statuses of all the volumes
          items:
            description: VolumeStatus represents information about the status of volumes
              attached to the VirtualMachineInstance.
            properties:
              containerDiskVolume:
                description: ContainerDiskVolume shows info about the containerdisk,
                  if the volume is a containerdisk
                properties:
                  checksum:
                    description: Checksum is the checksum of the rootdisk or kernel
                      artifacts inside the containerdisk
                    format: int32
                    type: integer
                type: object
              hotplugVolume:
                description: If the volume is hotplug, this will contain the hotplug
                  status.
                properties:
                  attachPodName:
                    description: AttachPodName is the name of the pod used to attach
                      the volume to the node.
                    type: string
                  attachPodUID:
                    description: AttachPodUID is the UID of the pod used to attach
                      the volume to the node.
                    type: string
                type: object
              memoryDumpVolume:
                description: If the volume is memorydump volume, this will contain
                  the memorydump info.
                properties:
                  claimName:
                    description: ClaimName is the name of the pvc the memory was dumped
                      to
                    type: string
                  endTimestamp:
                    description: EndTimestamp is the time when the memory dump completed
                    format: date-time
                    type: string
                  startTimestamp:
                    description: StartTimestamp is the time when the memory dump started
                    format: date-time
                    type: string
                  targetFileName:
                    description: TargetFileName is the name of the memory dump output
                    type: string
                type: object
              message:
                description: Message is a detailed message about the current hotplug
                  volume phase
                type: string
              name:
                description: Name is the name of the volume
                type: string
              persistentVolumeClaimInfo:
                description: PersistentVolumeClaimInfo is information about the PVC
                  that handler requires during start flow
                properties:
                  accessModes:
                    description: |-
                      AccessModes contains the desired access modes the volume should have.
                      More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
                    items:
                      type: string
                    type: array
                    x-kubernetes-list-type: atomic
                  capacity:
                    additionalProperties:
                      anyOf:
                      - type: integer
                      - type: string
                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                      x-kubernetes-int-or-string: true
                    description: Capacity represents the capacity set on the corresponding
                      PVC status
                    type: object
                  claimName:
                    description: ClaimName is the name of the PVC
                    type: string
                  filesystemOverhead:
                    description: Percentage of filesystem's size to be reserved when
                      resizing the PVC
                    pattern: ^(0(?:\.\d{1,3})?|1)$
                    type: string
                  preallocated:
                    description: Preallocated indicates if the PVC's storage is preallocated
                      or not
                    type: boolean
                  requests:
                    additionalProperties:
                      anyOf:
                      - type: integer
                      - type: string
                      pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                      x-kubernetes-int-or-string: true
                    description: Requests represents the resources requested by the
                      corresponding PVC spec
                    type: object
                  volumeMode:
                    description: |-
                      VolumeMode defines what type of volume is required by the claim.
                      Value of Filesystem is implied when not included in claim spec.
                    type: string
                type: object
              phase:
                description: Phase is the phase
                type: string
              reason:
                description: Reason is a brief description of why we are in the current
                  hotplug volume phase
                type: string
              size:
                description: Represents the size of the volume
                format: int64
                type: integer
              target:
                description: 'Target is the target name used when adding the volume
                  to the VM, eg: vda'
                type: string
            required:
            - name
            - target
            type: object
          type: array
          x-kubernetes-list-type: atomic
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachineinstancemigration": `openAPIV3Schema:
  description: |-
    VirtualMachineInstanceMigration represents the object tracking a VMI's migration
    to another host in the cluster
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      properties:
        addedNodeSelector:
          additionalProperties:
            type: string
          description: |-
            AddedNodeSelector is an additional selector that can be used to
            complement a NodeSelector or NodeAffinity as set on the VM
            to restrict the set of allowed target nodes for a migration.
            In case of key collisions, values set on the VM objects
            are going to be preserved to ensure that addedNodeSelector
            can only restrict but not bypass constraints already set on the VM object.
          type: object
        receive:
          description: If receieve is specified, this VirtualMachineInstanceMigration
            will be considered the target
          properties:
            migrationID:
              description: A unique identifier to identify this migration.
              type: string
          required:
          - migrationID
          type: object
        sendTo:
          description: If sendTo is specified, this VirtualMachineInstanceMigration
            will be considered the source
          properties:
            connectURL:
              description: The synchronization controller URL to connect to.
              type: string
            migrationID:
              description: A unique identifier to identify this migration.
              type: string
          required:
          - connectURL
          - migrationID
          type: object
        vmiName:
          description: The name of the VMI to perform the migration on. VMI must exist
            in the migration objects namespace
          type: string
      type: object
    status:
      description: VirtualMachineInstanceMigration reprents information pertaining
        to a VMI's migration.
      properties:
        conditions:
          items:
            properties:
              lastProbeTime:
                format: date-time
                nullable: true
                type: string
              lastTransitionTime:
                format: date-time
                nullable: true
                type: string
              message:
                type: string
              reason:
                type: string
              status:
                type: string
              type:
                type: string
            required:
            - status
            - type
            type: object
          type: array
        migrationState:
          description: Represents the status of a live migration
          properties:
            abortRequested:
              description: Indicates that the migration has been requested to abort
              type: boolean
            abortStatus:
              description: Indicates the final status of the live migration abortion
              type: string
            completed:
              description: Indicates the migration completed
              type: boolean
            endTimestamp:
              description: The time the migration action ended
              format: date-time
              nullable: true
              type: string
            failed:
              description: Indicates that the migration failed
              type: boolean
            failureReason:
              description: Contains the reason why the migration failed
              type: string
            migrationConfiguration:
              description: Migration configurations to apply
              properties:
                allowAutoConverge:
                  description: |-
                    AllowAutoConverge allows the platform to compromise performance/availability of VMIs to
                    guarantee successful VMI live migrations. Defaults to false
                  type: boolean
                allowPostCopy:
                  description: |-
                    AllowPostCopy enables post-copy live migrations. Such migrations allow even the busiest VMIs
                    to successfully live-migrate. However, events like a network failure can cause a VMI crash.
                    If set to true, migrations will still start in pre-copy, but switch to post-copy when
                    CompletionTimeoutPerGiB triggers. Defaults to false
                  type: boolean
                allowWorkloadDisruption:
                  description: |-
                    AllowWorkloadDisruption indicates that the migration shouldn't be
                    canceled after acceptableCompletionTime is exceeded. Instead, if
                    permitted, migration will be switched to post-copy or the VMI will be
                    paused to allow the migration to complete
                  type: boolean
                bandwidthPerMigration:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    BandwidthPerMigration limits the amount of network bandwidth live migrations are allowed to use.
                    The value is in quantity per second. Defaults to 0 (no limit)
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
                completionTimeoutPerGiB:
                  description: |-
                    CompletionTimeoutPerGiB is the maximum number of seconds per GiB a migration is allowed to take.
                    If the timeout is reached, the migration will be either paused, switched
                    to post-copy or cancelled depending on other settings. Defaults to 150
                  format: int64
                  type: integer
                disableTLS:
                  description: |-
                    When set to true, DisableTLS will disable the additional layer of live migration encryption
                    provided by KubeVirt. This is usually a bad idea. Defaults to false
                  type: boolean
                matchSELinuxLevelOnMigration:
                  description: |-
                    By default, the SELinux level of target virt-launcher pods is forced to the level of the source virt-launcher.
                    When set to true, MatchSELinuxLevelOnMigration lets the CRI auto-assign a random level to the target.
                    That will ensure the target virt-launcher doesn't share categories with another pod on the node.
                    However, migrations will fail when using RWX volumes that don't automatically deal with SELinux levels.
                  type: boolean
                network:
                  description: |-
                    Network is the name of the CNI network to use for live migrations. By default, migrations go
                    through the pod network.
                  type: string
                nodeDrainTaintKey:
                  description: |-
                    NodeDrainTaintKey defines the taint key that indicates a node should be drained.
                    Note: this option relies on the deprecated node taint feature. Default: kubevirt.io/drain
                  type: string
                parallelMigrationsPerCluster:
                  description: |-
                    ParallelMigrationsPerCluster is the total number of concurrent live migrations
                    allowed cluster-wide. Defaults to 5
                  format: int32
                  type: integer
                parallelOutboundMigrationsPerNode:
                  description: |-
                    ParallelOutboundMigrationsPerNode is the maximum number of concurrent outgoing live migrations
                    allowed per node. Defaults to 2
                  format: int32
                  type: integer
                progressTimeout:
                  description: |-
                    ProgressTimeout is the maximum number of seconds a live migration is allowed to make no progress.
                    Hitting this timeout means a migration transferred 0 data for that many seconds. The migration is
                    then considered stuck and therefore cancelled. Defaults to 150
                  format: int64
                  type: integer
                unsafeMigrationOverride:
                  description: |-
                    UnsafeMigrationOverride allows live migrations to occur even if the compatibility check
                    indicates the migration will be unsafe to the guest. Defaults to false
                  type: boolean
              type: object
            migrationNetworkType:
              description: The type of migration network, either 'pod' or 'migration'
              type: string
            migrationPolicyName:
              description: Name of the migration policy. If string is empty, no policy
                is matched
              type: string
            migrationUid:
              description: The VirtualMachineInstanceMigration object associated with
                this migration
              type: string
            mode:
              description: Lets us know if the vmi is currently running pre or post
                copy migration
              type: string
            sourceNode:
              description: The source node that the VMI originated on
              type: string
            sourcePersistentStatePVCName:
              description: If the VMI being migrated uses persistent features (backend-storage),
                its source PVC name is saved here
              type: string
            sourcePod:
              type: string
            sourceState:
              description: SourceState contains migration state managed by the source
                virt handler
              properties:
                domainName:
                  description: The name of the domain on the source libvirt domain
                  type: string
                domainNamespace:
                  description: Namespace used in the name of the source libvirt domain.
                    Can be used to find and modify paths in the domain
                  type: string
                migrationUID:
                  description: The Source VirtualMachineInstanceMigration object associated
                    with this migration
                  type: string
                node:
                  description: The source node that the VMI originated on
                  type: string
                nodeSelectors:
                  additionalProperties:
                    type: string
                  description: Node selectors needed by the target to start the receiving
                    pod.
                  type: object
                persistentStatePVCName:
                  description: If the VMI being migrated uses persistent features
                    (backend-storage), its source PVC name is saved here
                  type: string
                pod:
                  description: The source pod that the VMI is originated on
                  type: string
                selinuxContext:
                  description: SELinuxContext is the actual SELinux context of the
                    pod
                  type: string
                syncAddress:
                  description: The ip address/fqdn:port combination to use to synchronize
                    the VMI with the target.
                  type: string
                virtualMachineInstanceUID:
                  description: VirtualMachineInstanceUID is the UID of the target
                    virtual machine instance
                  type: string
              type: object
            startTimestamp:
              description: The time the migration action began
              format: date-time
              nullable: true
              type: string
            targetAttachmentPodUID:
              description: The UID of the target attachment pod for hotplug volumes
              type: string
            targetCPUSet:
              description: |-
                If the VMI requires dedicated CPUs, this field will
                hold the dedicated CPU set on the target node
              items:
                type: integer
              type: array
              x-kubernetes-list-type: atomic
            targetDirectMigrationNodePorts:
              additionalProperties:
                type: integer
              description: The list of ports opened for live migration on the destination
                node
              type: object
            targetNode:
              description: The target node that the VMI is moving to
              type: string
            targetNodeAddress:
              description: The address of the target node to use for the migration
              type: string
            targetNodeDomainDetected:
              description: The Target Node has seen the Domain Start Event
              type: boolean
            targetNodeDomainReadyTimestamp:
              description: The timestamp at which the target node detects the domain
                is active
              format: date-time
              type: string
            targetNodeTopology:
              description: |-
                If the VMI requires dedicated CPUs, this field will
                hold the numa topology on the target node
              type: string
            targetPersistentStatePVCName:
              description: If the VMI being migrated uses persistent features (backend-storage),
                its target PVC name is saved here
              type: string
            targetPod:
              description: The target pod that the VMI is moving to
              type: string
            targetState:
              description: TargetState contains migration state managed by the target
                virt handler
              properties:
                attachmentPodUID:
                  description: The UID of the target attachment pod for hotplug volumes
                  type: string
                cpuSet:
                  description: |-
                    If the VMI requires dedicated CPUs, this field will
                    hold the dedicated CPU set on the target node
                  items:
                    type: integer
                  type: array
                  x-kubernetes-list-type: atomic
                directMigrationNodePorts:
                  additionalProperties:
                    type: integer
                  description: The list of ports opened for live migration on the
                    destination node
                  type: object
                domainDetected:
                  description: The Target Node has seen the Domain Start Event
                  type: boolean
                domainName:
                  description: The name of the domain on the source libvirt domain
                  type: string
                domainNamespace:
                  description: Namespace used in the name of the source libvirt domain.
                    Can be used to find and modify paths in the domain
                  type: string
                domainReadyTimestamp:
                  description: The timestamp at which the target node detects the
                    domain is active
                  format: date-time
                  type: string
                migrationUID:
                  description: The Source VirtualMachineInstanceMigration object associated
                    with this migration
                  type: string
                node:
                  description: The source node that the VMI originated on
                  type: string
                nodeAddress:
                  description: The address of the target node to use for the migration
                  type: string
                nodeTopology:
                  description: |-
                    If the VMI requires dedicated CPUs, this field will
                    hold the numa topology on the target node
                  type: string
                persistentStatePVCName:
                  description: If the VMI being migrated uses persistent features
                    (backend-storage), its source PVC name is saved here
                  type: string
                pod:
                  description: The source pod that the VMI is originated on
                  type: string
                selinuxContext:
                  description: SELinuxContext is the actual SELinux context of the
                    pod
                  type: string
                syncAddress:
                  description: The ip address/fqdn:port combination to use to synchronize
                    the VMI with the target.
                  type: string
                virtualMachineInstanceUID:
                  description: VirtualMachineInstanceUID is the UID of the target
                    virtual machine instance
                  type: string
              type: object
          type: object
        phase:
          description: VirtualMachineInstanceMigrationPhase is a label for the condition
            of a VirtualMachineInstanceMigration at the current time.
          type: string
        phaseTransitionTimestamps:
          description: PhaseTransitionTimestamp is the timestamp of when the last
            phase change occurred
          items:
            description: VirtualMachineInstanceMigrationPhaseTransitionTimestamp gives
              a timestamp in relation to when a phase is set on a vmi
            properties:
              phase:
                description: Phase is the status of the VirtualMachineInstanceMigrationPhase
                  in kubernetes world. It is not the VirtualMachineInstanceMigrationPhase
                  status, but partially correlates to it.
                type: string
              phaseTransitionTimestamp:
                description: PhaseTransitionTimestamp is the timestamp of when the
                  phase change occurred
                format: date-time
                type: string
            type: object
          type: array
          x-kubernetes-list-type: atomic
        synchronizationAddresses:
          description: |-
            The synchronization addresses one can use to connect to the synchronization controller, includes the port, if multiple
            addresses are available, the first one is reported in the synchronizationAddress field.
          items:
            type: string
          type: array
          x-kubernetes-list-type: atomic
      type: object
  required:
  - spec
  type: object
`,
	"virtualmachineinstancepreset": `openAPIV3Schema:
  description: |-
    Deprecated for removal in v2, please use VirtualMachineInstanceType and VirtualMachinePreference instead.

    VirtualMachineInstancePreset defines a VMI spec.domain to be applied to all VMIs that match the provided label selector
    More info: https://kubevirt.io/user-guide/virtual_machines/presets/#overrides
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: VirtualMachineInstance Spec contains the VirtualMachineInstance
        specification.
      properties:
        domain:
          description: Domain is the same object type as contained in VirtualMachineInstanceSpec
          properties:
            chassis:
              description: Chassis specifies the chassis info passed to the domain.
              properties:
                asset:
                  type: string
                manufacturer:
                  type: string
                serial:
                  type: string
                sku:
                  type: string
                version:
                  type: string
              type: object
            clock:
              description: Clock sets the clock and timers of the vmi.
              properties:
                timer:
                  description: Timer specifies whih timers are attached to the vmi.
                  properties:
                    hpet:
                      description: HPET (High Precision Event Timer) - multiple timers
                        with periodic interrupts.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                        tickPolicy:
                          description: |-
                            TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                            One of "delay", "catchup", "merge", "discard".
                          type: string
                      type: object
                    hyperv:
                      description: Hyperv (Hypervclock) - lets guests read the host’s
                        wall clock time (paravirtualized). For windows guests.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                      type: object
                    kvm:
                      description: "KVM \t(KVM clock) - lets guests read the host’s
                        wall clock time (paravirtualized). For linux guests."
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                      type: object
                    pit:
                      description: PIT (Programmable Interval Timer) - a timer with
                        periodic interrupts.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                        tickPolicy:
                          description: |-
                            TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                            One of "delay", "catchup", "discard".
                          type: string
                      type: object
                    rtc:
                      description: RTC (Real Time Clock) - a continuously running
                        timer with periodic interrupts.
                      properties:
                        present:
                          description: |-
                            Enabled set to false makes sure that the machine type or a preset can't add the timer.
                            Defaults to true.
                          type: boolean
                        tickPolicy:
                          description: |-
                            TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                            One of "delay", "catchup".
                          type: string
                        track:
                          description: Track the guest or the wall clock.
                          type: string
                      type: object
                  type: object
                timezone:
                  description: |-
                    Timezone sets the guest clock to the specified timezone.
                    Zone name follows the TZ environment variable format (e.g. 'America/New_York').
                  type: string
                utc:
                  description: |-
                    UTC sets the guest clock to UTC on each boot. If an offset is specified,
                    guest changes to the clock will be kept during reboots and are not reset.
                  properties:
                    offsetSeconds:
                      description: |-
                        OffsetSeconds specifies an offset in seconds, relative to UTC. If set,
                        guest changes to the clock will be kept during reboots and not reset.
                      type: integer
                  type: object
              type: object
              x-kubernetes-preserve-unknown-fields: true
            cpu:
              description: CPU allow specified the detailed CPU topology inside the
                vmi.
              properties:
                cores:
                  description: |-
                    Cores specifies the number of cores inside the vmi.
                    Must be a value greater or equal 1.
                  format: int32
                  type: integer
                dedicatedCpuPlacement:
                  description: |-
                    DedicatedCPUPlacement requests the scheduler to place the VirtualMachineInstance on a node
                    with enough dedicated pCPUs and pin the vCPUs to it.
                  type: boolean
                features:
                  description: Features specifies the CPU features list inside the
                    VMI.
                  items:
                    description: CPUFeature allows specifying a CPU feature.
                    properties:
                      name:
                        description: Name of the CPU feature
                        type: string
                      policy:
                        description: |-
                          Policy is the CPU feature attribute which can have the following attributes:
                          force    - The virtual CPU will claim the feature is supported regardless of it being supported by host CPU.
                          require  - Guest creation will fail unless the feature is supported by the host CPU or the hypervisor is able to emulate it.
                          optional - The feature will be supported by virtual CPU if and only if it is supported by host CPU.
                          disable  - The feature will not be supported by virtual CPU.
                          forbid   - Guest creation will fail if the feature is supported by host CPU.
                          Defaults to require
                        type: string
                    required:
                    - name
                    type: object
                  type: array
                isolateEmulatorThread:
                  description: |-
                    IsolateEmulatorThread requests one more dedicated pCPU to be allocated for the VMI to place
                    the emulator thread on it.
                  type: boolean
                maxSockets:
                  description: |-
                    MaxSockets specifies the maximum amount of sockets that can
                    be hotplugged
                  format: int32
                  type: integer
                model:
                  description: |-
                    Model specifies the CPU model inside the VMI.
                    List of available models https://github.com/libvirt/libvirt/tree/master/src/cpu_map.
                    It is possible to specify special cases like "host-passthrough" to get the same CPU as the node
                    and "host-model" to get CPU closest to the node one.
                    Defaults to host-model.
                  type: string
                numa:
                  description: NUMA allows specifying settings for the guest NUMA
                    topology
                  properties:
                    guestMappingPassthrough:
                      description: |-
                        GuestMappingPassthrough will create an efficient guest topology based on host CPUs exclusively assigned to a pod.
                        The created topology ensures that memory and CPUs on the virtual numa nodes never cross boundaries of host numa nodes.
                      type: object
                  type: object
                realtime:
                  description: Realtime instructs the virt-launcher to tune the VMI
                    for lower latency, optional for real time workloads
                  properties:
                    mask:
                      description: |-
                        Mask defines the vcpu mask expression that defines which vcpus are used for realtime. Format matches libvirt's expressions.
                        Example: "0-3,^1","0,2,3","2-3"
                      type: string
                  type: object
                sockets:
                  description: |-
                    Sockets specifies the number of sockets inside the vmi.
                    Must be a value greater or equal 1.
                  format: int32
                  type: integer
                threads:
                  description: |-
                    Threads specifies the number of threads inside the vmi.
                    Must be a value greater or equal 1.
                  format: int32
                  type: integer
              type: object
            devices:
              description: Devices allows adding disks, network interfaces, and others
              properties:
                autoattachGraphicsDevice:
                  description: |-
                    Whether to attach the default graphics device or not.
                    VNC will not be available if set to false. Defaults to true.
                  type: boolean
                autoattachInputDevice:
                  description: |-
                    Whether to attach an Input Device.
                    Defaults to false.
                  type: boolean
                autoattachMemBalloon:
                  description: |-
                    Whether to attach the Memory balloon device with default period.
                    Period can be adjusted in virt-config.
                    Defaults to true.
                  type: boolean
                autoattachPodInterface:
                  description: Whether to attach a pod network interface. Defaults
                    to true.
                  type: boolean
                autoattachSerialConsole:
                  description: |-
                    Whether to attach the default virtio-serial console or not.
                    Serial console access will not be available if set to false. Defaults to true.
                  type: boolean
                autoattachVSOCK:
                  description: |-
                    Whether to attach the VSOCK CID to the VM or not.
                    VSOCK access will be available if set to true. Defaults to false.
                  type: boolean
                blockMultiQueue:
                  description: |-
                    Whether or not to enable virtio multi-queue for block devices.
                    Defaults to false.
                  type: boolean
                clientPassthrough:
                  description: To configure and access client devices such as redirecting
                    USB
                  type: object
                disableHotplug:
                  description: DisableHotplug disabled the ability to hotplug disks.
                  type: boolean
                disks:
                  description: Disks describes disks, cdroms and luns which are connected
                    to the vmi.
                  items:
                    properties:
                      blockSize:
                        description: If specified, the virtual disk will be presented
                          with the given block sizes.
                        properties:
                          custom:
                            description: CustomBlockSize represents the desired logical
                              and physical block size for a VM disk.
                            properties:
                              logical:
                                type: integer
                              physical:
                                type: integer
                            required:
                            - logical
                            - physical
                            type: object
                          matchVolume:
                            description: Represents if a feature is enabled or disabled.
                            properties:
                              enabled:
                                description: |-
                                  Enabled determines if the feature should be enabled or disabled on the guest.
                                  Defaults to true.
                                type: boolean
                            type: object
                        type: object
                      bootOrder:
                        description: |-
                          BootOrder is an integer value > 0, used to determine ordering of boot devices.
                          Lower values take precedence.
                          Each disk or interface that has a boot order must have a unique value.
                          Disks without a boot order are not tried if a disk with a boot order exists.
                        type: integer
                      cache:
                        description: |-
                          Cache specifies which kvm disk cache mode should be used.
                          Supported values are:
                          none: Guest I/O not cached on the host, but may be kept in a disk cache.
                          writethrough: Guest I/O cached on the host but written through to the physical medium. Slowest but with most guarantees.
                          writeback: Guest I/O cached on the host.
                          Defaults to none if the storage supports O_DIRECT, otherwise writethrough.
                        type: string
                      cdrom:
                        description: Attach a volume as a cdrom to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi.
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to true.
                            type: boolean
                          tray:
                            description: |-
                              Tray indicates if the tray of the device is open or closed.
                              Allowed values are "open" and "closed".
                              Defaults to closed.
                            type: string
                        type: object
                      dedicatedIOThread:
                        description: |-
                          dedicatedIOThread indicates this disk should have an exclusive IO Thread.
                          Enabling this implies useIOThreads = true.
                          Defaults to false.
                        type: boolean
                      disk:
                        description: Attach a volume as a disk to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi, usb.
                            type: string
                          pciAddress:
                            description: 'If specified, the virtual disk will be placed
                              on the guests pci address with the specified PCI address.
                              For example: 0000:81:01.10'
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to false.
                            type: boolean
                        type: object
                      errorPolicy:
                        description: If specified, it can change the default error
                          policy (stop) for the disk
                        type: string
                      io:
                        description: |-
                          IO specifies which QEMU disk IO mode should be used.
                          Supported values are: native, default, threads.
                        type: string
                      lun:
                        description: Attach a volume as a LUN to the vmi.
                        properties:
                          bus:
                            description: |-
                              Bus indicates the type of disk device to emulate.
                              supported values: virtio, sata, scsi.
                            type: string
                          readonly:
                            description: |-
                              ReadOnly.
                              Defaults to false.
                            type: boolean
                          reservation:
                            description: Reservation indicates if the disk needs to
                              support the persistent reservation for the SCSI disk
                            type: boolean
                        type: object
                      name:
                        description: Name is the device name
                        type: string
                      serial:
                        description: Serial provides the ability to specify a serial
                          number for the disk device.
                        type: string
                      shareable:
                        description: If specified the disk is made sharable and multiple
                          write from different VMs are permitted
                        type: boolean
                      tag:
                        description: If specified, disk address and its tag will be
                          provided to the guest via config drive metadata
                        type: string
                    required:
                    - name
                    type: object
                  maxItems: 256
                  type: array
                downwardMetrics:
                  description: DownwardMetrics creates a virtio serials for exposing
                    the downward metrics to the vmi.
                  type: object
                filesystems:
                  description: Filesystems describes filesystem which is connected
                    to the vmi.
                  items:
                    properties:
                      name:
                        description: Name is the device name
                        type: string
                      virtiofs:
                        description: Virtiofs is supported
                        type: object
                    required:
                    - name
                    - virtiofs
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                gpus:
                  description: Whether to attach a GPU device to the vmi.
                  items:
                    properties:
                      claimName:
                        description: |-
                          ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                          device is allocated
                        type: string
                      deviceName:
                        description: DeviceName is the name of the device provisioned
                          by device-plugins
                        type: string
                      name:
                        description: Name of the GPU device as exposed by a device
                          plugin
                        type: string
                      requestName:
                        description: |-
                          RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                          device is requested
                        type: string
                      tag:
                        description: If specified, the virtual network interface address
                          and its tag will be provided to the guest via config drive
                        type: string
                      virtualGPUOptions:
                        properties:
                          display:
                            properties:
                              enabled:
                                description: |-
                                  Enabled determines if a display addapter backed by a vGPU should be enabled or disabled on the guest.
                                  Defaults to true.
                                type: boolean
                              ramFB:
                                description: |-
                                  Enables a boot framebuffer, until the guest OS loads a real GPU driver
                                  Defaults to true.
                                properties:
                                  enabled:
                                    description: |-
                                      Enabled determines if the feature should be enabled or disabled on the guest.
                                      Defaults to true.
                                    type: boolean
                                type: object
                            type: object
                        type: object
                    required:
                    - name
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                hostDevices:
                  description: Whether to attach a host device to the vmi.
                  items:
                    properties:
                      claimName:
                        description: |-
                          ClaimName needs to be provided from the list vmi.spec.resourceClaims[].name where this
                          device is allocated
                        type: string
                      deviceName:
                        description: DeviceName is the name of the device provisioned
                          by device-plugins
                        type: string
                      name:
                        type: string
                      requestName:
                        description: |-
                          RequestName needs to be provided from resourceClaim.spec.devices.requests[].name where this
                          device is requested
                        type: string
                      tag:
                        description: If specified, the virtual network interface address
                          and its tag will be provided to the guest via config drive
                        type: string
                    required:
                    - name
                    type: object
                  type: array
                  x-kubernetes-list-type: atomic
                inputs:
                  description: Inputs describe input devices
                  items:
                    properties:
                      bus:
                        description: |-
                          Bus indicates the bus of input device to emulate.
                          Supported values: virtio, usb.
                        type: string
                      name:
                        description: Name is the device name
                        type: string
                      type:
                        description: |-
                          Type indicated the type of input device.
                          Supported values: tablet.
                        type: string
                    required:
                    - name
                    - type
                    type: object
                  type: array
                interfaces:
                  description: Interfaces describe network interfaces which are added
                    to the vmi.
                  items:
                    properties:
                      acpiIndex:
                        description: |-
                          If specified, the ACPI index is used to provide network interface device naming, that is stable across changes
                          in PCI addresses assigned to the device.
                          This value is required to be unique across all devices and be between 1 and (16*1024-1).
                        type: integer
                      binding:
                        description: |-
                          Binding specifies the binding plugin that will be used to connect the interface to the guest.
                          It provides an alternative to InterfaceBindingMethod.
                          version: 1alphav1
                        properties:
                          name:
                            description: |-
                              Name references to the binding name as denined in the kubevirt CR.
                              version: 1alphav1
                            type: string
                        required:
                        - name
                        type: object
                      bootOrder:
                        description: |-
                          BootOrder is an integer value > 0, used to determine ordering of boot devices.
                          Lower values take precedence.
                          Each interface or disk that has a boot order must have a unique value.
                          Interfaces without a boot order are not tried.
                        type: integer
                      bridge:
                        description: InterfaceBridge connects to a given network via
                          a linux bridge.
                        type: object
                      dhcpOptions:
                        description: If specified the network interface will pass
                          additional DHCP options to the VMI
                        properties:
                          bootFileName:
                            description: If specified will pass option 67 to interface's
                              DHCP server
                            type: string
                          ntpServers:
                            description: If specified will pass the configured NTP
                              server to the VM via DHCP option 042.
                            items:
                              type: string
                            type: array
                          privateOptions:
                            description: 'If specified will pass extra DHCP options
                              for private use, range: 224-254'
                            items:
                              description: DHCPExtraOptions defines Extra DHCP options
                                for a VM.
                              properties:
                                option:
                                  description: |-
                                    Option is an Integer value from 224-254
                                    Required.
                                  type: integer
                                value:
                                  description: |-
                                    Value is a String value for the Option provided
                                    Required.
                                  type: string
                              required:
                              - option
                              - value
                              type: object
                            type: array
                          tftpServerName:
                            description: If specified will pass option 66 to interface's
                              DHCP server
                            type: string
                        type: object
                      macAddress:
                        description: 'Interface MAC address. For example: de:ad:00:00:be:af
                          or DE-AD-00-00-BE-AF.'
                        type: string
                      macvtap:
                        description: |-
                          DeprecatedMacvtap is an alias to the deprecated Macvtap interface,
                          please refer to Kubevirt user guide for alternatives.
                          Deprecated: Removed in v1.3
                        type: object
                      masquerade:
                        description: InterfaceMasquerade connects to a given network
                          using netfilter rules to nat the traffic.
                        type: object
                      model:
                        description: |-
                          Interface model.
                          One of: e1000, e1000e, igb, ne2k_pci, pcnet, rtl8139, virtio.
                          Defaults to virtio.
                        type: string
                      name:
                        description: |-
                          Logical name of the interface as well as a reference to the associated networks.
                          Must match the Name of a Network.
                        type: string
                      passt:
                        description: |-
                          DeprecatedPasst is an alias to the deprecated Passt interface,
                          please refer to Kubevirt user guide for alternatives.
                          Deprecated: Removed in v1.3
                        type: object
                      pciAddress:
                        description: 'If specified, the virtual network interface
                          will be placed on the guests pci address with the specified
                          PCI address. For example: 0000:81:01.10'
                        type: string
                      ports:
                        description: List of ports to be forwarded to the virtual
                          machine.
                        items:
                          description: |-
                            Port represents a port to expose from the virtual machine.
                            Default protocol TCP.
                            The port field is mandatory
                          properties:
                            name:
                              description: |-
                                If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
                                named port in a pod must have a unique name. Name for the port that can be
                                referred to by services.
                              type: string
                            port:
                              description: |-
                                Number of port to expose for the virtual machine.
                                This must be a valid port number, 0 < x < 65536.
                              format: int32
                              type: integer
                            protocol:
                              description: |-
                                Protocol for port. Must be UDP or TCP.
                                Defaults to "TCP".
                              type: string
                          required:
                          - port
                          type: object
                        type: array
                      slirp:
                        description: |-
                          DeprecatedSlirp is an alias to the deprecated Slirp interface
                          Deprecated: Removed in v1.3
                        type: object
                      sriov:
                        description: InterfaceSRIOV connects to a given network by
                          passing-through an SR-IOV PCI device via vfio.
                        type: object
                      state:
                        description: |-
                          State represents the requested operational state of the interface.
                          The supported values are:
                          'absent', expressing a request to remove the interface.
                          'down', expressing a request to set the link down.
                          'up', expressing a request to set the link up.
                          Empty value functions as 'up'.
                        type: string
                      tag:
                        description: If specified, the virtual network interface address
                          and its tag will be provided to the guest via config drive
                        type: string
                    required:
                    - name
                    type: object
                  maxItems: 256
                  type: array
                logSerialConsole:
                  description: |-
                    Whether to log the auto-attached default serial console or not.
                    Serial console logs will be collect to a file and then streamed from a named 'guest-console-log'.
                    Not relevant if autoattachSerialConsole is disabled.
                    Defaults to cluster wide setting on VirtualMachineOptions.
                  type: boolean
                networkInterfaceMultiqueue:
                  description: If specified, virtual network interfaces configured
                    with a virtio bus will also enable the vhost multiqueue feature
                    for network devices. The number of queues created depends on additional
                    factors of the VirtualMachineInstance, like the number of guest
                    CPUs.
                  type: boolean
                panicDevices:
                  description: PanicDevices provides additional crash information
                    when a guest crashes.
                  items:
                    properties:
                      model:
                        description: |-
                          Model specifies what type of panic device is provided.
                          The panic model used when this attribute is missing depends on the hypervisor and guest arch.
                          One of: isa, hyperv, pvpanic.
                        type: string
                    type: object
                  type: array
                rng:
                  description: Whether to have random number generator from host
                  type: object
                sound:
                  description: Whether to emulate a sound device.
                  properties:
                    model:
                      description: |-
                        We only support ich9 or ac97.
                        If SoundDevice is not set: No sound card is emulated.
                        If SoundDevice is set but Model is not: ich9
                      type: string
                    name:
                      description: User's defined name for this sound device
                      type: string
                  required:
                  - name
                  type: object
                tpm:
                  description: Whether to emulate a TPM device.
                  properties:
                    enabled:
                      description: |-
                        Enabled allows a user to explicitly disable the vTPM even when one is enabled by a preference referenced by the VirtualMachine
                        Defaults to True
                      type: boolean
                    persistent:
                      description: |-
                        Persistent indicates the state of the TPM device should be kept accross reboots
                        Defaults to false
                      type: boolean
                  type: object
                useVirtioTransitional:
                  description: |-
                    Fall back to legacy virtio 0.9 support if virtio bus is selected on devices.
                    This is helpful for old machines like CentOS6 or RHEL6 which
                    do not understand virtio_non_transitional (virtio 1.0).
                  type: boolean
                video:
                  description: Video describes the video device configuration for
                    the vmi.
                  properties:
                    type:
                      description: |-
                        Type specifies the video device type (e.g., virtio, vga, bochs, ramfb).
                        If not specified, the default is architecture-dependent (VGA for BIOS-based VMs, Bochs for EFI-based VMs on AMD64; virtio for Arm and s390x).
                      type: string
                  type: object
                watchdog:
                  description: Watchdog describes a watchdog device which can be added
                    to the vmi.
                  properties:
                    diag288:
                      description: diag288 watchdog device (specific to s390x architecture).
                      properties:
                        action:
                          description: |-
                            The action to take. Valid values are poweroff, reset, shutdown.
                            Defaults to reset.
                          type: string
                      type: object
                    i6300esb:
                      description: i6300esb watchdog device.
                      properties:
                        action:
                          description: |-
                            The action to take. Valid values are poweroff, reset, shutdown.
                            Defaults to reset.
                          type: string
                      type: object
                    name:
                      description: Name of the watchdog.
                      type: string
                  required:
                  - name
                  type: object
              type: object
            features:
              description: Features like acpi, apic, hyperv, smm.
              properties:
                acpi:
                  description: |-
                    ACPI enables/disables ACPI inside the guest.
                    Defaults to enabled.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                apic:
                  description: Defaults to the machine type setting.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                    endOfInterrupt:
                      description: |-
                        EndOfInterrupt enables the end of interrupt notification in the guest.
                        Defaults to false.
                      type: boolean
                  type: object
                hyperv:
                  description: Defaults to the machine type setting.
                  properties:
                    evmcs:
                      description: |-
                        EVMCS Speeds up L2 vmexits, but disables other virtualization features. Requires vapic.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    frequencies:
                      description: |-
                        Frequencies improves the TSC clock source handling for Hyper-V on KVM.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    ipi:
                      description: |-
                        IPI improves performances in overcommited environments. Requires vpindex.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    reenlightenment:
                      description: |-
                        Reenlightenment enables the notifications on TSC frequency changes.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    relaxed:
                      description: |-
                        Relaxed instructs the guest OS to disable watchdog timeouts.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    reset:
                      description: |-
                        Reset enables Hyperv reboot/reset for the vmi. Requires synic.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    runtime:
                      description: |-
                        Runtime improves the time accounting to improve scheduling in the guest.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    spinlocks:
                      description: Spinlocks allows to configure the spinlock retry
                        attempts.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                        spinlocks:
                          description: |-
                            Retries indicates the number of retries.
                            Must be a value greater or equal 4096.
                            Defaults to 4096.
                          format: int32
                          type: integer
                      type: object
                    synic:
                      description: |-
                        SyNIC enables the Synthetic Interrupt Controller.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    synictimer:
                      description: |-
                        SyNICTimer enables Synthetic Interrupt Controller Timers, reducing CPU load.
                        Defaults to the machine type setting.
                      properties:
                        direct:
                          description: Represents if a feature is enabled or disabled.
                          properties:
                            enabled:
                              description: |-
                                Enabled determines if the feature should be enabled or disabled on the guest.
                                Defaults to true.
                              type: boolean
                          type: object
                        enabled:
                          type: boolean
                      type: object
                    tlbflush:
                      description: |-
                        TLBFlush improves performances in overcommited environments. Requires vpindex.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    vapic:
                      description: |-
                        VAPIC improves the paravirtualized handling of interrupts.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                    vendorid:
                      description: |-
                        VendorID allows setting the hypervisor vendor id.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                        vendorid:
                          description: |-
                            VendorID sets the hypervisor vendor id, visible to the vmi.
                            String up to twelve characters.
                          type: string
                      type: object
                    vpindex:
                      description: |-
                        VPIndex enables the Virtual Processor Index to help windows identifying virtual processors.
                        Defaults to the machine type setting.
                      properties:
                        enabled:
                          description: |-
                            Enabled determines if the feature should be enabled or disabled on the guest.
                            Defaults to true.
                          type: boolean
                      type: object
                  type: object
                hypervPassthrough:
                  description: |-
                    This enables all supported hyperv flags automatically.
                    Bear in mind that if this enabled hyperV features cannot
                    be enabled explicitly. In addition, a Virtual Machine
                    using it will be non-migratable.
                  properties:
                    enabled:
                      type: boolean
                  type: object
                kvm:
                  description: Configure how KVM presence is exposed to the guest.
                  properties:
                    hidden:
                      description: |-
                        Hide the KVM hypervisor from standard MSR based discovery.
                        Defaults to false
                      type: boolean
                  type: object
                pvspinlock:
                  description: |-
                    Notify the guest that the host supports paravirtual spinlocks.
                    For older kernels this feature should be explicitly disabled.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
                smm:
                  description: |-
                    SMM enables/disables System Management Mode.
                    TSEG not yet implemented.
                  properties:
                    enabled:
                      description: |-
                        Enabled determines if the feature should be enabled or disabled on the guest.
                        Defaults to true.
                      type: boolean
                  type: object
              type: object
            firmware:
              description: Firmware.
              properties:
                acpi:
                  description: Information that can be set in the ACPI table
                  properties:
                    msdmNameRef:
                      description: |-
                        Similar to SlicNameRef, another ACPI entry that is used in more recent Windows versions.
                        The above points to the spec of MSDM too.
                      type: string
                    slicNameRef:
                      description: |-
                        SlicNameRef should match the volume name of a secret object. The data in the secret should
                        be a binary blob that follows the ACPI SLIC standard, see:
                        https://learn.microsoft.com/en-us/previous-versions/windows/hardware/design/dn653305(v=vs.85)
                      type: string
                  type: object
                bootloader:
                  description: Settings to control the bootloader that is used.
                  properties:
                    bios:
                      description: If set (default), BIOS will be used.
                      properties:
                        useSerial:
                          description: If set, the BIOS output will be transmitted
                            over serial
                          type: boolean
                      type: object
                    efi:
                      description: If set, EFI will be used instead of BIOS.
                      properties:
                        persistent:
                          description: |-
                            If set to true, Persistent will persist the EFI NVRAM across reboots.
                            Defaults to false
                          type: boolean
                        secureBoot:
                          description: |-
                            If set, SecureBoot will be enabled and the OVMF roms will be swapped for
                            SecureBoot-enabled ones.
                            Requires SMM to be enabled.
                            Defaults to true
                          type: boolean
                      type: object
                  type: object
                kernelBoot:
                  description: Settings to set the kernel for booting.
                  properties:
                    container:
                      description: Container defines the container that containes
                        kernel artifacts
                      properties:
                        image:
                          description: Image that contains initrd / kernel files.
                          type: string
                        imagePullPolicy:
                          description: |-
                            Image pull policy.
                            One of Always, Never, IfNotPresent.
                            Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
                            Cannot be updated.
                            More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
                          type: string
                        imagePullSecret:
                          description: ImagePullSecret is the name of the Docker registry
                            secret required to pull the image. The secret must already
                            exist.
                          type: string
                        initrdPath:
                          description: the fully-qualified path to the ramdisk image
                            in the host OS
                          type: string
                        kernelPath:
                          description: The fully-qualified path to the kernel image
                            in the host OS
                          type: string
                      required:
                      - image
                      type: object
                    kernelArgs:
                      description: Arguments to be passed to the kernel at boot time
                      type: string
                  type: object
                serial:
                  description: The system-serial-number in SMBIOS
                  type: string
                uuid:
                  description: |-
                    UUID reported by the vmi bios.
                    Defaults to a random generated uid.
                  type: string
              type: object
            ioThreads:
              description: IOThreads specifies the IOThreads options.
              properties:
                supplementalPoolThreadCount:
                  description: SupplementalPoolThreadCount specifies how many iothreads
                    are allocated for the supplementalPool policy.
                  format: int32
                  type: integer
              type: object
            ioThreadsPolicy:
              description: |-
                Controls whether or not disks will share IOThreads.
                Omitting IOThreadsPolicy disables use of IOThreads.
                One of: shared, auto, supplementalPool
              type: string
            launchSecurity:
              description: Launch Security setting of the vmi.
              properties:
                sev:
                  description: AMD Secure Encrypted Virtualization (SEV).
                  properties:
                    attestation:
                      description: If specified, run the attestation process for a
                        vmi.
                      type: object
                    dhCert:
                      description: Base64 encoded guest owner's Diffie-Hellman key.
                      type: string
                    policy:
                      description: |-
                        Guest policy flags as defined in AMD SEV API specification.
                        Note: due to security reasons it is not allowed to enable guest debugging. Therefore NoDebug flag is not exposed to users and is always true.
                      properties:
                        encryptedState:
                          description: |-
                            SEV-ES is required.
                            Defaults to false.
                          type: boolean
                      type: object
                    session:
                      description: Base64 encoded session blob.
                      type: string
                  type: object
              type: object
            machine:
              description: Machine type.
              properties:
                type:
                  description: QEMU machine type is the actual chipset of the VirtualMachineInstance.
                  type: string
              type: object
            memory:
              description: Memory allow specifying the VMI memory features.
              properties:
                guest:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    Guest allows to specifying the amount of memory which is visible inside the Guest OS.
                    The Guest must lie between Requests and Limits from the resources section.
                    Defaults to the requested memory in the resources section if not specified.
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
                hugepages:
                  description: Hugepages allow to use hugepages for the VirtualMachineInstance
                    instead of regular memory.
                  properties:
                    pageSize:
                      description: PageSize specifies the hugepage size, for x86_64
                        architecture valid values are 1Gi and 2Mi.
                      type: string
                  type: object
                maxGuest:
                  anyOf:
                  - type: integer
                  - type: string
                  description: |-
                    MaxGuest allows to specify the maximum amount of memory which is visible inside the Guest OS.
                    The delta between MaxGuest and Guest is the amount of memory that can be hot(un)plugged.
                  pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                  x-kubernetes-int-or-string: true
              type: object
            resources:
              description: Resources describes the Compute Resources required by this
                vmi.
              properties:
                limits:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Limits describes the maximum amount of compute resources allowed.
                    Valid resource keys are "memory" and "cpu".
                  type: object
                overcommitGuestOverhead:
                  description: |-
                    Don't ask the scheduler to take the guest-management overhead into account. Instead
                    put the overhead only into the container's memory limit. This can lead to crashes if
                    all memory is in use on a node. Defaults to false.
                  type: boolean
                requests:
                  additionalProperties:
                    anyOf:
                    - type: integer
                    - type: string
                    pattern: ^(\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\+|-)?(([0-9]+(\.[0-9]*)?)|(\.[0-9]+))))?$
                    x-kubernetes-int-or-string: true
                  description: |-
                    Requests is a description of the initial vmi resources.
                    Valid resource keys are "memory" and "cpu".
                  type: object
              type: object
          required:
          - devices
          type: object
        selector:
          description: |-
            Selector is a label query over a set of VMIs.
            Required.
          properties:
            matchExpressions:
              description: matchExpressions is a list of label selector requirements.
                The requirements are ANDed.
              items:
                description: |-
                  A label selector requirement is a selector that contains values, a key, and an operator that
                  relates the key and values.
                properties:
                  key:
                    description: key is the label key that the selector applies to.
                    type: string
                  operator:
                    description: |-
                      operator represents a key's relationship to a set of values.
                      Valid operators are In, NotIn, Exists and DoesNotExist.
                    type: string
                  values:
                    description: |-
                      values is an array of string values. If the operator is In or NotIn,
                      the values array must be non-empty. If the operator is Exists or DoesNotExist,
                      the values array must be empty. This array is replaced during a strategic
                      merge patch.
                    items:
                      type: string
                    type: array
                    x-kubernetes-list-type: atomic
                required:
                - key
                - operator
                type: object
              type: array
              x-kubernetes-list-type: atomic
            matchLabels:
              additionalProperties:
                type: string
              description: |-
                matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                map is equivalent to an element of matchExpressions, whose key field is "key", the
                operator is "In", and the values array contains only "value". The requirements are ANDed.
              type: object
          type: object
          x-kubernetes-map-type: atomic
      required:
      - selector
      type: object
  type: object
`,
	"virtualmachineinstancereplicaset": `openAPIV3Schema:
  description: VirtualMachineInstance is *the* VirtualMachineInstance Definition.
    It represents a virtual machine in the runtime environment of kubernetes.
  properties:
    apiVersion:
      description: |-
        APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      type: string
    kind:
      description: |-
        Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated.
        In CamelCase.
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      type: string
    metadata:
      type: object
    spec:
      description: VirtualMachineInstance Spec contains the VirtualMachineInstance
        specification.
      properties:
        paused:
          description: Indicates that the replica set is paused.
          type: boolean
        replicas:
          description: |-
            Number of desired pods. This is a pointer to distinguish between explicit
            zero and not specified. Defaults to 1.
          format: int32
          type: integer
        selector:
          description: |-
            Label selector for pods. Existing ReplicaSets whose pods are
            selected by this will be the ones affected by this deployment.
          properties:
            matchExpressions:
              description: matchExpressions is a list of label selector requirements.
                The requirements are ANDed.
              items:
                description: |-
                  A label selector requirement is a selector that contains values, a key, and an operator that
                  relates the key and values.
                properties:
                  key:
                    description: key is the label key that the selector applies to.
                    type: string
                  operator:
                    description: |-
                      operator represents a key's relationship to a set of values.
                      Valid operators are In, NotIn, Exists and DoesNotExist.
                    type: string
                  values:
                    description: |-
                      values is an array of string values. If the operator is In or NotIn,
                      the values array must be non-empty. If the operator is Exists or DoesNotExist,
                      the values array must be empty. This array is replaced during a strategic
                      merge patch.
                    items:
                      type: string
                    type: array
                    x-kubernetes-list-type: atomic
                required:
                - key
                - operator
                type: object
              type: array
              x-kubernetes-list-type: atomic
            matchLabels:
              additionalProperties:
                type: string
              description: |-
                matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                map is equivalent to an element of matchExpressions, whose key field is "key", the
                operator is "In", and the values array contains only "value". The requirements are ANDed.
              type: object
          type: object
          x-kubernetes-map-type: atomic
        template:
          description: Template describes the pods that will be created.
          properties:
            metadata:
              nullable: true
              type: object
              x-kubernetes-preserve-unknown-fields: true
            spec:
              description: VirtualMachineInstance Spec contains the VirtualMachineInstance
                specification.
              properties:
                accessCredentials:
                  description: Specifies a set of public keys to inject into the vm
                    guest
                  items:
                    description: |-
                      AccessCredential represents a credential source that can be used to
                      authorize remote access to the vm guest
                      Only one of its members may be specified.
                    properties:
                      sshPublicKey:
                        description: |-
                          SSHPublicKey represents the source and method of applying a ssh public
                          key into a guest virtual machine.
                        properties:
                          propagationMethod:
                            description: PropagationMethod represents how the public
                              key is injected into the vm guest.
                            properties:
                              configDrive:
                                description: |-
                                  ConfigDrivePropagation means that the ssh public keys are injected
                                  into the VM using metadata using the configDrive cloud-init provider
                                type: object
                              noCloud:
                                description: |-
                                  NoCloudPropagation means that the ssh public keys are injected
                                  into the VM using metadata using the noCloud cloud-init provider
                                type: object
                              qemuGuestAgent:
                                description: |-
                                  QemuGuestAgentAccessCredentailPropagation means ssh public keys are
                                  dynamically injected into the vm at runtime via the qemu guest agent.
                                  This feature requires the qemu guest agent to be running within the guest.
                                properties:
                                  users:
                                    description: |-
                                      Users represents a list of guest users that should have the ssh public keys
                                      added to their authorized_keys file.
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: set
                                required:
                                - users
                                type: object
                            type: object
                          source:
                            description: Source represents where the public keys are
                              pulled from
                            properties:
                              secret:
                                description: Secret means that the access credential
                                  is pulled from a kubernetes secret
                                properties:
                                  secretName:
                                    description: SecretName represents the name of
                                      the secret in the VMI's namespace
                                    type: string
                                required:
                                - secretName
                                type: object
                            type: object
                        required:
                        - propagationMethod
                        - source
                        type: object
                      userPassword:
                        description: |-
                          UserPassword represents the source and method for applying a guest user's
                          password
                        properties:
                          propagationMethod:
                            description: propagationMethod represents how the user
                              passwords are injected into the vm guest.
                            properties:
                              qemuGuestAgent:
                                description: |-
                                  QemuGuestAgentAccessCredentailPropagation means passwords are
                                  dynamically injected into the vm at runtime via the qemu guest agent.
                                  This feature requires the qemu guest agent to be running within the guest.
                                type: object
                            type: object
                          source:
                            description: Source represents where the user passwords
                              are pulled from
                            properties:
                              secret:
                                description: Secret means that the access credential
                                  is pulled from a kubernetes secret
                                properties:
                                  secretName:
                                    description: SecretName represents the name of
                                      the secret in the VMI's namespace
                                    type: string
                                required:
                                - secretName
                                type: object
                            type: object
                        required:
                        - propagationMethod
                        - source
                        type: object
                    type: object
                  maxItems: 256
                  type: array
                  x-kubernetes-list-type: atomic
                affinity:
                  description: If affinity is specifies, obey all the affinity rules
                  properties:
                    nodeAffinity:
                      description: Describes node affinity scheduling rules for the
                        pod.
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node matches the corresponding matchExpressions; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: |-
                              An empty preferred scheduling term matches all objects with implicit weight 0
                              (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
                            properties:
                              preference:
                                description: A node selector term, associated with
                                  the corresponding weight.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              weight:
                                description: Weight associated with matching the corresponding
                                  nodeSelectorTerm, in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - preference
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to an update), the system
                            may or may not try to eventually evict the pod from its node.
                          properties:
                            nodeSelectorTerms:
                              description: Required. A list of node selector terms.
                                The terms are ORed.
                              items:
                                description: |-
                                  A null or empty node selector term matches no objects. The requirements of
                                  them are ANDed.
                                  The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
                                properties:
                                  matchExpressions:
                                    description: A list of node selector requirements
                                      by node's labels.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchFields:
                                    description: A list of node selector requirements
                                      by node's fields.
                                    items:
                                      description: |-
                                        A node selector requirement is a selector that contains values, a key, and an operator
                                        that relates the key and values.
                                      properties:
                                        key:
                                          description: The label key that the selector
                                            applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            Represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
                                          type: string
                                        values:
                                          description: |-
                                            An array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. If the operator is Gt or Lt, the values
                                            array must have a single element, which will be interpreted as an integer.
                                            This array is replaced during a strategic merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                type: object
                                x-kubernetes-map-type: atomic
                              type: array
                              x-kubernetes-list-type: atomic
                          required:
                          - nodeSelectorTerms
                          type: object
                          x-kubernetes-map-type: atomic
                      type: object
                    podAffinity:
                      description: Describes pod affinity scheduling rules (e.g. co-locate
                        this pod in the same node, zone, etc. as some other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                    podAntiAffinity:
                      description: Describes pod anti-affinity scheduling rules (e.g.
                        avoid putting this pod in the same node, zone, etc. as some
                        other pod(s)).
                      properties:
                        preferredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            The scheduler will prefer to schedule pods to nodes that satisfy
                            the anti-affinity expressions specified by this field, but it may choose
                            a node that violates one or more of the expressions. The node that is
                            most preferred is the one with the greatest sum of weights, i.e.
                            for each node that meets all of the scheduling requirements (resource
                            request, requiredDuringScheduling anti-affinity expressions, etc.),
                            compute a sum by iterating through the elements of this field and adding
                            "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
                            node(s) with the highest sum are the most preferred.
                          items:
                            description: The weights of all of the matched WeightedPodAffinityTerm
                              fields are added per-node to find the most preferred
                              node(s)
                            properties:
                              podAffinityTerm:
                                description: Required. A pod affinity term, associated
                                  with the corresponding weight.
                                properties:
                                  labelSelector:
                                    description: |-
                                      A label query over a set of resources, in this case pods.
                                      If it's null, this PodAffinityTerm matches with no Pods.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  matchLabelKeys:
                                    description: |-
                                      MatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                      Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  mismatchLabelKeys:
                                    description: |-
                                      MismatchLabelKeys is a set of pod label keys to select which pods will
                                      be taken into consideration. The keys are used to lookup values from the
                                      incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                      to select the group of existing pods which pods will be taken into consideration
                                      for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                      pod labels will be ignored. The default value is empty.
                                      The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                      Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                      This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  namespaceSelector:
                                    description: |-
                                      A label query over the set of namespaces that the term applies to.
                                      The term is applied to the union of the namespaces selected by this field
                                      and the ones listed in the namespaces field.
                                      null selector and null or empty namespaces list means "this pod's namespace".
                                      An empty selector ({}) matches all namespaces.
                                    properties:
                                      matchExpressions:
                                        description: matchExpressions is a list of
                                          label selector requirements. The requirements
                                          are ANDed.
                                        items:
                                          description: |-
                                            A label selector requirement is a selector that contains values, a key, and an operator that
                                            relates the key and values.
                                          properties:
                                            key:
                                              description: key is the label key that
                                                the selector applies to.
                                              type: string
                                            operator:
                                              description: |-
                                                operator represents a key's relationship to a set of values.
                                                Valid operators are In, NotIn, Exists and DoesNotExist.
                                              type: string
                                            values:
                                              description: |-
                                                values is an array of string values. If the operator is In or NotIn,
                                                the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                                the values array must be empty. This array is replaced during a strategic
                                                merge patch.
                                              items:
                                                type: string
                                              type: array
                                              x-kubernetes-list-type: atomic
                                          required:
                                          - key
                                          - operator
                                          type: object
                                        type: array
                                        x-kubernetes-list-type: atomic
                                      matchLabels:
                                        additionalProperties:
                                          type: string
                                        description: |-
                                          matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                          map is equivalent to an element of matchExpressions, whose key field is "key", the
                                          operator is "In", and the values array contains only "value". The requirements are ANDed.
                                        type: object
                                    type: object
                                    x-kubernetes-map-type: atomic
                                  namespaces:
                                    description: |-
                                      namespaces specifies a static list of namespace names that the term applies to.
                                      The term is applied to the union of the namespaces listed in this field
                                      and the ones selected by namespaceSelector.
                                      null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                    items:
                                      type: string
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  topologyKey:
                                    description: |-
                                      This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                      the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                      whose value of the label with key topologyKey matches that of any node on which any of the
                                      selected pods is running.
                                      Empty topologyKey is not allowed.
                                    type: string
                                required:
                                - topologyKey
                                type: object
                              weight:
                                description: |-
                                  weight associated with matching the corresponding podAffinityTerm,
                                  in the range 1-100.
                                format: int32
                                type: integer
                            required:
                            - podAffinityTerm
                            - weight
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                        requiredDuringSchedulingIgnoredDuringExecution:
                          description: |-
                            If the anti-affinity requirements specified by this field are not met at
                            scheduling time, the pod will not be scheduled onto the node.
                            If the anti-affinity requirements specified by this field cease to be met
                            at some point during pod execution (e.g. due to a pod label update), the
                            system may or may not try to eventually evict the pod from its node.
                            When there are multiple elements, the lists of nodes corresponding to each
                            podAffinityTerm are intersected, i.e. all terms must be satisfied.
                          items:
                            description: |-
                              Defines a set of pods (namely those matching the labelSelector
                              relative to the given namespace(s)) that this pod should be
                              co-located (affinity) or not co-located (anti-affinity) with,
                              where co-located is defined as running on a node whose value of
                              the label with key <topologyKey> matches that of any node on which
                              a pod of the set of pods is running
                            properties:
                              labelSelector:
                                description: |-
                                  A label query over a set of resources, in this case pods.
                                  If it's null, this PodAffinityTerm matches with no Pods.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              matchLabelKeys:
                                description: |-
                                  MatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key in (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both matchLabelKeys and labelSelector.
                                  Also, matchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              mismatchLabelKeys:
                                description: |-
                                  MismatchLabelKeys is a set of pod label keys to select which pods will
                                  be taken into consideration. The keys are used to lookup values from the
                                  incoming pod labels, those key-value labels are merged with 'labelSelector' as 'key notin (value)'
                                  to select the group of existing pods which pods will be taken into consideration
                                  for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
                                  pod labels will be ignored. The default value is empty.
                                  The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
                                  Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
                                  This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              namespaceSelector:
                                description: |-
                                  A label query over the set of namespaces that the term applies to.
                                  The term is applied to the union of the namespaces selected by this field
                                  and the ones listed in the namespaces field.
                                  null selector and null or empty namespaces list means "this pod's namespace".
                                  An empty selector ({}) matches all namespaces.
                                properties:
                                  matchExpressions:
                                    description: matchExpressions is a list of label
                                      selector requirements. The requirements are
                                      ANDed.
                                    items:
                                      description: |-
                                        A label selector requirement is a selector that contains values, a key, and an operator that
                                        relates the key and values.
                                      properties:
                                        key:
                                          description: key is the label key that the
                                            selector applies to.
                                          type: string
                                        operator:
                                          description: |-
                                            operator represents a key's relationship to a set of values.
                                            Valid operators are In, NotIn, Exists and DoesNotExist.
                                          type: string
                                        values:
                                          description: |-
                                            values is an array of string values. If the operator is In or NotIn,
                                            the values array must be non-empty. If the operator is Exists or DoesNotExist,
                                            the values array must be empty. This array is replaced during a strategic
                                            merge patch.
                                          items:
                                            type: string
                                          type: array
                                          x-kubernetes-list-type: atomic
                                      required:
                                      - key
                                      - operator
                                      type: object
                                    type: array
                                    x-kubernetes-list-type: atomic
                                  matchLabels:
                                    additionalProperties:
                                      type: string
                                    description: |-
                                      matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
                                      map is equivalent to an element of matchExpressions, whose key field is "key", the
                                      operator is "In", and the values array contains only "value". The requirements are ANDed.
                                    type: object
                                type: object
                                x-kubernetes-map-type: atomic
                              namespaces:
                                description: |-
                                  namespaces specifies a static list of namespace names that the term applies to.
                                  The term is applied to the union of the namespaces listed in this field
                                  and the ones selected by namespaceSelector.
                                  null or empty namespaces list and null namespaceSelector means "this pod's namespace".
                                items:
                                  type: string
                                type: array
                                x-kubernetes-list-type: atomic
                              topologyKey:
                                description: |-
                                  This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
                                  the labelSelector in the specified namespaces, where co-located is defined as running on a node
                                  whose value of the label with key topologyKey matches that of any node on which any of the
                                  selected pods is running.
                                  Empty topologyKey is not allowed.
                                type: string
                            required:
                            - topologyKey
                            type: object
                          type: array
                          x-kubernetes-list-type: atomic
                      type: object
                  type: object
                architecture:
                  description: Specifies the architecture of the vm guest you are
                    attempting to run. Defaults to the compiled architecture of the
                    KubeVirt components
                  type: string
                dnsConfig:
                  description: |-
                    Specifies the DNS parameters of a pod.
                    Parameters specified here will be merged to the generated DNS
                    configuration based on DNSPolicy.
                  properties:
                    nameservers:
                      description: |-
                        A list of DNS name server IP addresses.
                        This will be appended to the base nameservers generated from DNSPolicy.
                        Duplicated nameservers will be removed.
                      items:
                        type: string
                      type: array
                      x-kubernetes-list-type: atomic
                    options:
                      description: |-
                        A list of DNS resolver options.
                        This will be merged with the base options generated from DNSPolicy.
                        Duplicated entries will be removed. Resolution options given in Options
                        will override those that appear in the base DNSPolicy.
                      items:
                        description: PodDNSConfigOption defines DNS resolver options
                          of a pod.
                        properties:
                          name:
                            description: |-
                              Name is this DNS resolver option's name.
                              Required.
                            type: string
                          value:
                            description: Value is this DNS resolver option's value.
                            type: string
                        type: object
                      type: array
                      x-kubernetes-list-type: atomic
                    searches:
                      description: |-
                        A list of DNS search domains for host-name lookup.
                        This will be appended to the base search paths generated from DNSPolicy.
                        Duplicated search paths will be removed.
                      items:
                        type: string
                      type: array
                      x-kubernetes-list-type: atomic
                  type: object
                dnsPolicy:
                  description: |-
                    Set DNS policy for the pod.
                    Defaults to "ClusterFirst".
                    Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'.
                    DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy.
                    To have DNS options set along with hostNetwork, you have to specify DNS policy
                    explicitly to 'ClusterFirstWithHostNet'.
                  type: string
                domain:
                  description: Specification of the desired behavior of the VirtualMachineInstance
                    on the host.
                  properties:
                    chassis:
                      description: Chassis specifies the chassis info passed to the
                        domain.
                      properties:
                        asset:
                          type: string
                        manufacturer:
                          type: string
                        serial:
                          type: string
                        sku:
                          type: string
                        version:
                          type: string
                      type: object
                    clock:
                      description: Clock sets the clock and timers of the vmi.
                      properties:
                        timer:
                          description: Timer specifies whih timers are attached to
                            the vmi.
                          properties:
                            hpet:
                              description: HPET (High Precision Event Timer) - multiple
                                timers with periodic interrupts.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                                tickPolicy:
                                  description: |-
                                    TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                                    One of "delay", "catchup", "merge", "discard".
                                  type: string
                              type: object
                            hyperv:
                              description: Hyperv (Hypervclock) - lets guests read
                                the host’s wall clock time (paravirtualized). For
                                windows guests.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            kvm:
                              description: "KVM \t(KVM clock) - lets guests read the
                                host’s wall clock time (paravirtualized). For linux
                                guests."
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                              type: object
                            pit:
                              description: PIT (Programmable Interval Timer) - a timer
                                with periodic interrupts.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                                tickPolicy:
                                  description: |-
                                    TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                                    One of "delay", "catchup", "discard".
                                  type: string
                              type: object
                            rtc:
                              description: RTC (Real Time Clock) - a continuously
                                running timer with periodic interrupts.
                              properties:
                                present:
                                  description: |-
                                    Enabled set to false makes sure that the machine type or a preset can't add the timer.
                                    Defaults to true.
                                  type: boolean
                                tickPolicy:
                                  description: |-
                                    TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest.
                                    One of "delay", "catchup".
                                  type: string
                                track:
                                  description: Track the guest or the wall clock.
                                  type: string
                              type: object
                          type: object
                        timezone:
                          description: |-
                            Timezone sets the guest clock to the specified timezone.
                            Zone name follows the TZ environment variable format (e.g. 'America/New_York').
                          type: string
                        utc:
                          description: |-
                            UTC sets the guest clock to UTC on each boot. If an offset is specified,
                            guest changes to the clock will be kept during reboots and are not reset.
                          properties:
                            offsetSeconds:
                              description: |-
                                OffsetSeconds specifies an offset in seconds, relative to UTC. If set,
                                guest changes to the clock will be kept during reboots and not reset.
                              type: integer
                          type: object
                      type: object
                      x-kubernetes-preserve-unknown-fields: true
                    cpu:
                      description: CPU allow specified the detailed CPU topology inside
                        the vmi.
                      properties:
                        cores:
                          description: |-
                            Cores specifies the number of cores inside the vmi.
                            Must be a value greater or equal 1.
                          format: int32
                          type: integer
                        dedicatedCpuPlacement:
                          description: |-
                            DedicatedCPUPlacement requests the scheduler to place the VirtualMachineInstance on a node
                            with enough dedicated pCPUs and pin the vCPUs to it.
                          type: boolean
                        features:
                          description: Features specifies the CPU features list inside
                            the VMI.
                          items:
                            description: CPUFeature allows specifying a CPU feature.
                            properties:
                              name:
                                description: Name of the CPU feature
                                type: string
                              policy:
                                description: |-
                                  Policy is the CPU feature attribute which can have the following attributes:
                                  force    - The virtual CPU will claim the feature is supported regardless of it being supported by host CPU.
                                  require  - Guest creation will fail unless the feature is supported by the host CPU or the hypervisor is able to emulate it.
                                  optional - The feature will be supported by virtual CPU if and only if it is supported by host CPU.
                                  disable  - The feature will not be supported by virtual CPU.
                                  forbid   - Guest creation will fail if the feature is supported by host CPU.
                                  Defaults to require
                                type: string
                            required:
                            - name
                            type: object
                          type: array
                        isolateEmulatorThread:
                          description: |-
                            IsolateEmulatorThread requests one more dedicated pCPU to be allocated for the VMI to place
                            the emulator thread on it.
                          type: boolean
                        maxSockets:
                          description: |-
                            MaxSockets specifies the maximum amount of sockets that can
                            be hotplugged
                          format: int32
                          type: integer
                        model:
                          description: |-
                            Model specifies the CPU model inside the VMI.
                            List of available models https://github.com/libvirt/libvirt/tree/master/src/cpu_map.
                            It is possible to specify special cases like "host-passthrough" to get the same CPU as the node
                            and "host-model" to get CPU closest to the node one.
                            Defaults to host-model.
                          type: string
                        numa:
                          description: NUMA allows specifying settings for the guest
                            NUMA topology
                          properties:
                            guestMappingPassthrough:
                              description: |-
                                GuestMappingPassthrough will create an efficient guest topology based on host CPUs exclusively assigned to a pod.
                                The created topology ensures that memory and CPUs on the virtual numa nodes never cross boundaries of host numa nodes.
                              type: object
                          type: object
                        realtime:
                          description: Realtime instructs the virt-launcher to tune
                            the VMI for lower latency, optional for real time workloads
                          properties:
                            mask:
                              description: |-
                                Mask defines the vcpu mask expression that defines which vcpus are used for realtime. Format matches libvirt's expressions.
                                Example: "0-3,^1","0,2,3","2-3"
                              type: string
                          type: object
                        sockets:
                          description: |-
                            Sockets specifies the number of sockets inside the vmi.
                            Must be a value greater or equal 1.
                          format: int32
                          type: integer
                        threads:
                          description: |-
                            Threads specifies the number of threads inside the vmi.
                            Must be a value greater or equal 1.
                          format: int32
                          type: integer
                      type: object
                    devices:
                      description: Devices allows adding disks, network interfaces,
                        and others
                      properties:
                        autoattachGraphicsDevice:
                          description: |-
                            Whether to attach the default graphics device or not.
                            VNC will not be available if set to false. Defaults to true.
                          type: boolean
                        autoattachInputDevice:
                          description: |-
                            Whether to attach an Input Device.
                            Defaults to false.
                          type: boolean
                        autoattachMemBalloon:
                          description: |-
                            Whether to attach the Memory balloon device with default period.
                            Period can be adjusted in virt-config.
                            Defaults to true.
                          type: boolean
                        autoattachPodInterface:
                          description: Whether to attach a pod network interface.
                            Defaults to true.
                          type: boolean
                        autoattachSerialConsole:
                          description: |-
                            Whether to attach the default virtio-serial console or not.
                            Serial console access will not be available if set to false. Defaults to true.
                          type: boolean
                        autoattachVSOCK:
                          description: |-
                            Whether to attach the VSOCK CID to the VM or not.
                            VSOCK access will be available if set to true. Defaults to false.
                          type: boolean
                        blockMultiQueue:
                          description: |-
                            Whether or not to enable virtio multi-queue for block devices.
                            Defaults to false.
                          type: boolean
                        clientPassthrough:
                          description: To configure and access client devices such
                            as redirecting USB
                          type: object
                        disableHotplug:
                          description: DisableHotplug disabled the ability to hotplug
                            disks.
                          type: boolean
                        disks:
                          description: Disks describes disks, cdroms and luns which
                            are connected to the vmi.
                          items:
                            properties:
                              blockSize:
                                description: If specified, the virtual disk will be
                                  presented with the given block sizes.
                                properties:
                                  custom:
                                    description: CustomBlockSize represents the desired
                                      logical and physical block size for a VM disk.
                                    properties:
                                      logical:
                                        type: integer
                                      physical:
                                        type: integer
                                    required:
                                    - logical
                                    - physical
                                    type: object
                                  matchVolume:
                                    description: Represents if a feature is enabled
                                      or disabled.
                                    properties:
                                      enabled:
                                        description: |-
                                          Enabled determines if the feature should be enabled or disabled on the guest.
                                          Defaults to true.
                                        type: boolean
                                    type: object
                                type: object
                              bootOrder:
                                description: |-
                                  BootOrder is an integer value > 0, used to determine ordering of boot devices.
                                  Lower values take precedence.
                                  Each disk or interface that has a boot order must have a unique value.
                                  Disks without a boot order are not tried if a disk with a boot order exists.
                                type: integer
                              cache:
                                description: |-
                                  Cache specifies which kvm disk cache mode should be used.
                                  Supported values are:
                                  none: Guest I/O not cached on the host, but may be kept in a disk cache.
                                  writethrough: Guest I/O cached on the host but written through to the physical medium. Slowest but with most guarantees.
                                  writeback: Guest I/O cached on the host.
                                  Defaults to none if the storage supports O_DIRECT, otherwise writethrough.
                                type: string
                              cdrom:
                                description: Attach a volume as a cdrom to the vmi.
                                properties:
                                  bus:
                                    description: |-
                                      Bus indicates the type of disk device to emulate.
                                      supported values: virtio, sata, scsi.
                                    type: string
                                  readonly:
                                    description: |-
                                      ReadOnly.
                                      Defaults to true.
                                    type: boolean
                                  tray:
                                    description: |-
                                      Tray indicates if the tray of the device is open or closed.
                                      Allowed values are "open" and "closed".
                                      Defaults to closed.
                                    type: string
                                type: object
                              dedicatedIOThread:
                                description: |-
                                  dedicatedIOThread indicates this disk should have an exclusive IO Thread.
                                  Enabling this implies useIOThreads = true.
                                  Defaults to false.
                                type: boolean
                              disk:
                                description: Attach a volume as a disk to the vmi.
                                properties:
                                  bus:
                                    description: |-
                                      Bus indicates the type of disk device to emulate.
                                      supported values: virtio, sata, scsi, usb.
                                    type: string
                                  pciAddress:
                                    description: 'If specified, the virtual disk will
                                      be placed on the guests pci address with the
                                      specified PCI address. For example: 0000:81:01.10'
    