/*
    HTML INCLUDE SYSTEM
    Copyright (C) 2000	Ulli Meybohm, www.meybohm.de (ulli@meybohm.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "bytevector.h"
#include "stringlist.h"
#include "help.h"

/* Global Variables */
Stringlist arg;
Bytevector temp;
Bytevector outputfile;
Bytevector errormsg;
Bytevector includedir;
Stringlist filelist;
int warnings=0;

void print_help() {
	errormsg=Stringlist(helpC,helpV).toBytevector();
	errormsg.fwriteln(fileno(stderr));
	exit(1);
}

void warning(Bytevector warn) {
	warnings++;
	Bytevector("Warning: ").fwrite(fileno(stderr));	
	warn.fwriteln(fileno(stderr));	
}

void info(Bytevector p){
	p.fwriteln(fileno(stdout));
}

void update(Bytevector & input, Bytevector file) {
Bytevector incfile,incdata,search,warn;
Bytevector incheader("<!--INC:\"");
int incbegin,incend;
int namebegin,nameend;
int nextstart=0;
bool deadend;
FILE* f=fopen(file.data,"w+b");
if (!f) {
	warn="Can't open/write ";
	warn+=file;
	return;
}
warn="Processing ";
warn+=file;
info(file);
int fd=fileno(f);
while ( (incbegin=input.find(incheader,nextstart)) !=-1 ) {
	namebegin=incbegin+9;
	nameend=namebegin+1;
	while ( (nameend<input.size) && 
	        (deadend=(input[nameend]!='"'))) nameend++;
	if ( ! ( (nameend==input.size-1) && deadend ) ) {
		incfile=input.copyRange(namebegin,nameend-1);	
		if ( incdata.readfile( includedir+incfile ) ) {
			search="<!--/INC:\"";
			search+=incfile;
			search+="\"-->";
			incend=input.find(search, incbegin+9);
			if (incend!=-1) {
				incend+=search.size;
				incdata+=search;
				// Reuse search Variable
				search="<!--INC:\"";
				search+=incfile;
				search+="\"-->";
				search+=incdata;
				input.copyRange(nextstart,incbegin-1).fwrite(fd);
				search.fwrite(fd);
				nextstart=incend;
			} else {
				input.copyRange(nextstart,input.size-1).fwrite(fd);
				warn="INC-Syntaxerror in ";
				warn+=file;
				warn+=". Skipped!";
				warning(warn);
				return;
			}	
		} else {
			warn="Can't open include-file ";
			warn+=includedir;
			warn+=incfile;
			warn+=". Skipped!\n";
			warning(warn);
			input.copyRange(nextstart,incbegin+8).fwrite(fd);
			nextstart=incbegin+9;
		}
	} else {
		input.copyRange(nextstart,input.size-1).fwrite(fd);
		warn="INC-Syntaxerror in ";
		warn+=file;
		warn=". Skipping!";
		warning(warn);
		return;
	}
}
if (nextstart!=input.size-1) {
	input.copyRange(nextstart,input.size-1).fwrite(fd);
}
}


void update_files(){
	Bytevector input, warn;
	printf("HTML INCLUDE SYSTEM - Updating includes:\n");
	for (int i=0; (unsigned)i<filelist.size(); i++) {
		if ( input.readfile(filelist[i])    ) {
			update(input, filelist[i]);
		} else {
			warn="Could not read file ";
			warn+=filelist[i];
			warn+=". Skipped!";
			warning(warn);
		}
	}
}


int main(int argc, char * argv[]){
  	Stringlist arg(argc,argv);
	if (arg.size()<3) print_help();
	includedir=arg[1];
	if (includedir[includedir.size-1]!='/') {
	    includedir+="/";
	}
	arg.del(0);
	arg.del(0);
	filelist=arg;
	update_files();
	return 0;
}
