/* 
 * sgsubmon.h
 *
 * Include file for sgraidmon.c, sgdiskmon.c, sgsafte.c
 *
 * 03/09/07 ARCress - created
 */
/*---------------------------------------------------------------------------
Copyright (c) 2001-2007, Intel Corporation
All rights reserved.
 
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
 
  a.. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
  b.. Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
  c.. Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *---------------------------------------------------------------------------*/
#ifndef ushort 
#define uchar     unsigned char
#define ushort    unsigned short
#define uint      unsigned int
#define ulong     unsigned long
#endif
#define SCHECK_CND    -2
#define SWRITE_ERR    -3
#define SREAD_ERR     -4
#define SIOCTL_ERR    -5
#define SIZE_ERR      -6
#define MAX_DEVS      64       /* was 32, should be <=255 (MAX_SLOTS too) */
#define MAX_ERRS       4
#define MAX_SENSE     16
#define SGHDR         36   /* sizeof(struct sg_header) */
#define SGDATALEN     65   /* data size: inquiry=64, get_defects=16*/
#define EBUFF_LEN     80
#define MAX_INQSAV    54
#define ENCSERV       0x40 /* EncServ bit mask for inq byte 6 */
#define SG_GET_SCSI_ID            0x2276
#define SG_EMULATED_HOST          0x2203
#define SCSI_IOCTL_GET_IDLUN      0x5382
#define SCSI_IOCTL_GET_BUS_NUMBER 0x5386
#define LINESZ  512
#define MSG_LEN 132 

/* SAF-TE Commands */
#define SAFTE_READ_ENCL_CONF  0x00   /* Read Enclosure Configuration */
#define SAFTE_READ_ENCL_STAT  0x01   /* Read Enclosure Status */
#define SAFTE_READ_DEV_INS    0x03   /* Read Device Insertions */
#define SAFTE_READ_DEV_STAT   0x04   /* Read Device Slot Status */
#define SAFTE_WRITE_DEV_STAT  0x10   /* Write Device Slot Status */

/* Device Statuses for devlist.dstatus: */
#define  DSTAT_DEAD   0  /*not inserted, dead, gone */
#define  DSTAT_FAIL   1  /*may be inserted, marked failed */
#define  DSTAT_NOTRDY 2  /*inserted, not yet ready (sense key=02)*/
#define  DSTAT_READY  3  /*ready, good sense */
#define  DSTAT_ONL    4  /*online, included in the raid */
typedef struct {
    uchar chn;
    uchar bus;
    uchar tgt;            /* SCSI target ID */
    uchar lun;
    uchar devtype;        /* device type: 0=disk, 3=proc */
    uchar dstatus;        /* device status =3 means online */
    ulong dcap;           /* disk capacity (or nslots if proc) */
    int   ret;            /* inquiry status ret */
    int   sgfd;           /* fd if open */
    int   maj;            /* device major number */
    int   min;            /* device major number */
    uchar fdoit;          /* if fdoit == 1, ok to send command */
    uchar inq[50];        /* inquiry buf, max 48 bytes */
    uchar fname[64];      /* store sg fname */
    uchar sdname[64];     /* store sd device filename */
    uchar vendor[9];
    uchar model[17];
    uchar fwrev[5];
    uchar sernum[13];
    uchar other[11];
    uchar fses;        /* =1 if SES enabled device */
    int sdactive; /* 0=active in raid, 1=failed, -1=missing*/
    int mdtab;    /* 0=in the raidtab */
} DEVLISTX_TYPE;

#define DEV_DISK   0
#define DEV_PROC   3
#define DEV_EMUL   10
#define DEV_ENCL   13
#define DEVT_MAX  13
// #define NDEVTYP  15

#define NUM_RETRIES   4   /*used in sense_err()*/ 

typedef struct {
	int host;
	int bus;
	int target;
	int lun;
	int all_leaves_searched;
} DEVFS_LIST;

typedef struct {
   uchar bus;           /* SAF-TE: bus for this proc slot */
   uchar num;           /* SAF-TE: slot number */
   uchar id;            /* SAF-TE: target id by slot */
   ushort ins;          /* SAF-TE: #insertions by slot */
   uchar  stat;         /* SAF-TE: read status by slot */
   uchar  wstat;        /* SAF-TE: write status by slot */
} SLOT_LIST;

/* Subroutines */
void logit(const char *format, ...);
void itoh(uchar * chp, int len, char *str);
void dumpbufr(FILE * fdout, uchar * bufp, int mlen, char *hdr);
void dump_buf(FILE * fdout, uchar * bufp, int mlen, char *hdr, char fascii);
void dump_log(uchar * bufp, int mlen, char *hdr, char fascii);
int  get_line(FILE * fd, char *buf, int len) ;
int  findmatch(char *buffer,int sbuf, char *pattern,int spattern,char figncase);
int  fillstr(char *to, uchar *from,int len);
int  IsSATA(int idev);
int  ses_decode_types(uchar *buf, int blen, int *nsestypes, int *ises);
int  ses_write_slots(int idev, int val);
int  check_ses(int idev, int sgfd);
int  read_ses(int sgfd, int page, uchar * buf, int len);
int  write_ses(int sgfd, int page, uchar * buf, int len);
int  read_safte(int sgfd, int mode, uchar * buf, int len, int idev);
int  write_safte(int sgfd, int mode, int iproc, int idev, int val);
int  write_slots(int idev, int val);
int  sg_cmd(int sgfd, uchar *cdb,int cdblen, uchar *rdata,int rlen);
void make_dev_name(int k, char *sg_name, char *sd_name, int fnum,
			DEVFS_LIST *devfsnums);
int get_dev_maj_min(uchar bus, uchar ch, uchar id, uchar lun, 
			int *pmaj, int *pmin);
int find_mmdev(int maj, int min, char *devname);
int find_blockdev(uchar bus, uchar ch, uchar id, uchar lun, char *devname);
int  sense_err(int sgfd, uchar *dbuf,int dlen, int idev, int ret, int *pretry);
void showlog(const char * format, ...); 

/*end sgsubmon.h*/
