/*---------------------------------------------------------------------------
 *  sgsub.h
 * 
 * SCSI Generic subroutine definitions 
 *
 *---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------
Copyright (c) 2002, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

  a.. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer. 
  b.. Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution. 
  c.. Neither the name of Intel Corporation nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *---------------------------------------------------------------------------*/
#define uchar  unsigned char
#define ushort unsigned short
#define uint   unsigned int
#define ulong  unsigned long     

#define HDR    36   /* sizeof(struct sg_header), =36 if 16 sense bytes*/
					       /*=38 if 18 sense bytes (error)*/

#define SG_GET_SCSI_ID 0x2276  
#define SG_EMULATED_HOST 0x2203
#define SCSI_IOCTL_GET_IDLUN 0x5382
#define SCSI_IOCTL_GET_BUS_NUMBER 0x5386  

typedef struct my_scsi_idlun {
    int dev_id;
    int host_unique_id;
} My_scsi_idlun;
 
typedef struct my_sg_scsi_id {
    int host_no;      
    int channel;
    int scsi_id;       
    int lun;
    int scsi_type;      
    short h_cmd_per_lun;
    short d_queue_depth;
    int unused1;        
    int unused2;     
} My_sg_scsi_id;    

/* This is an extended sg_header structure only for a diagnostic routine. */
#define SG_SENSE1 18
struct sg_hdr1
{
    int pack_len;   
    int reply_len; 
    int pack_id;   
    int result;    
    unsigned int twelve_byte:1;
    unsigned int target_status:5; 
    unsigned int host_status:8;   
    unsigned int driver_status:8; 
    unsigned int other_flags:10;  
    unsigned char sense_buffer[SG_SENSE1]; 
};      /* This structure is 38 bytes long on i386 */          

/* return values for these subroutines, if return >0 see errno. */
#define SUNKN_ERR   -1
#define SCHECK_CND  -2
#define SWRITE_ERR  -3
#define SREAD_ERR   -4
#define SIOCTL_ERR  -5
#define SIZE_ERR    -6

/* SCSI subroutine definitions */
int get_sense(int sts, uchar *buf);
int sense_report(int sts, const char *errmsg, uchar *buf);
int scsi_inquiry(int sgfd, uchar *buf, int rlen);
int test_unit_ready(int sgfd, char fshowerr);
int read_capacity(int sgfd, ulong *dsize);
int write_buffer(int sgfd, uchar *buf, ulong len, uchar mod, uchar bufid);
int mode_sense(int sgfd, uchar page, uchar *buf);
int mode_select(int sgfd, uchar *buf, uchar len);
int start_unit(int sgfd);
int stop_unit(int sgfd);
int scsi_reset(int sgfd, int type);
int scsi_format(int sgfd, uchar patt, int timeout, int noglist);
int seagate_inquiry(int sgfd, uchar *buf, int rlen);
int sn_inquiry(int sgfd, uchar pgcode, uchar *buf, int rlen);
int get_sernum(int sgfd, uchar *buf, int rlen);
int get_defects(int sgfd, uchar *buf, int len, char fplist);
int send_scsicdb(int sgfd, uchar *wbuf, int wlen, uchar *rbuf, int rlen);
int set_sg_debug(int sgfd, int dbglvl);
int read_safte(int sgfd, int mode, uchar * buf, int len);

/* end of sgsub.h */
