#--------------------------------------------------------
# Script 2 - md2.sh
# Check if md is linked into the running kernel
cat /proc/ksyms | grep md_wakeup_thread 
if [ $? -eq 0 ]
then
   echo "CONFIG_BLK_DEV_MD=y"
   echo "OK, continue"
   echo ""
else
   echo "Error: CONFIG_BLK_DEV_MD must be =y, rebuild kernel."
   exit 1
fi

cat /proc/ksyms | grep gamap_
if [ $? -eq 0 ]
then
   echo "Warning: CONFIG_SCSIFCHOTSWAP & CONFIG_GAMAP should be off."
   echo "Check for compatible versions, or rebuild kernel with these off."
   exit 1
fi

if [ -d /dev/md ]
then
   echo "DEVFS is configured"
fi

exit 0
# end script 2
#--------------------------------------------------------
