/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;

public final class TFTPAckPacket
extends TFTPPacket {
    int _blockNumber;

    TFTPAckPacket(DatagramPacket datagramPacket) throws TFTPPacketException {
        super(4, datagramPacket.getAddress(), datagramPacket.getPort());
        byte[] byArray = datagramPacket.getData();
        if (this.getType() != byArray[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        this._blockNumber = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public TFTPAckPacket(InetAddress inetAddress, int n, int n2) {
        super(4, inetAddress, n);
        this._blockNumber = n2;
    }

    DatagramPacket _newDatagram(DatagramPacket datagramPacket, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = (byte)this._type;
        byArray[2] = (byte)((this._blockNumber & 0xFFFF) >> 8);
        byArray[3] = (byte)(this._blockNumber & 0xFF);
        datagramPacket.setAddress(this._address);
        datagramPacket.setPort(this._port);
        datagramPacket.setData(byArray);
        datagramPacket.setLength(4);
        return datagramPacket;
    }

    public int getBlockNumber() {
        return this._blockNumber;
    }

    public DatagramPacket newDatagram() {
        byte[] byArray = new byte[]{0, (byte)this._type, (byte)((this._blockNumber & 0xFFFF) >> 8), (byte)(this._blockNumber & 0xFF)};
        return new DatagramPacket(byArray, byArray.length, this._address, this._port);
    }

    public void setBlockNumber(int n) {
        this._blockNumber = n;
    }
}

