pub const ext = @import("ext.zig");
const geoclue = @This();

const std = @import("std");
const compat = @import("compat");
const gio = @import("gio2");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
/// The `geoclue.ClientProxy` structure contains only private data and should only be accessed using the provided API.
pub const ClientProxy = extern struct {
    pub const Parent = gio.DBusProxy;
    pub const Implements = [_]type{ geoclue.Client, gio.AsyncInitable, gio.DBusInterface, gio.Initable };
    pub const Class = geoclue.ClientProxyClass;
    f_parent_instance: gio.DBusProxy,
    f_priv: ?*geoclue.ClientProxyPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// A utility function to create a `geoclue.ClientProxy` without having to deal with
    /// a `geoclue.Manager`. See also `geoclue.ClientProxy.createFull` which improves
    /// resource management.
    ///
    /// This is identitcal to calling `geoclue.ClientProxy.createFull` without any
    /// flags set.
    ///
    /// See `geoclue.ClientProxy.createSync``geoclue.ClientProxy.createSync` for the synchronous, blocking version
    /// of this function.
    extern fn gclue_client_proxy_create(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const create = gclue_client_proxy_create;

    /// Finishes an operation started with `geoclue.ClientProxy.create`.
    extern fn gclue_client_proxy_create_finish(p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const createFinish = gclue_client_proxy_create_finish;

    /// A utility function to create a `geoclue.ClientProxy` without having to deal with
    /// a `geoclue.Manager`.
    ///
    /// By setting the `GCLUE_CLIENT_PROXY_CREATE_AUTO_DELETE` flag you can ensure
    /// that the client will be deleted again from the geoclue service when
    /// it is destroyed. This flag should be used unless you are doing explicit
    /// resource management.
    ///
    /// See `geoclue.ClientProxy.createFullSync``geoclue.ClientProxy.createFullSync` for the synchronous, blocking
    /// version of this function.
    extern fn gclue_client_proxy_create_full(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_flags: geoclue.ClientProxyCreateFlags, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const createFull = gclue_client_proxy_create_full;

    /// Finishes an operation started with `geoclue.ClientProxy.createFull`.
    extern fn gclue_client_proxy_create_full_finish(p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const createFullFinish = gclue_client_proxy_create_full_finish;

    /// The synchronous and blocking version of `geoclue.ClientProxy.createFull``geoclue.ClientProxy.createFull`.
    ///
    /// By setting the `GCLUE_CLIENT_PROXY_CREATE_AUTO_DELETE` flag you can ensure
    /// that the client will be deleted again from the geoclue service when
    /// it is destroyed. This flag should be used unless you are doing explicit
    /// resource management.
    extern fn gclue_client_proxy_create_full_sync(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_flags: geoclue.ClientProxyCreateFlags, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const createFullSync = gclue_client_proxy_create_full_sync;

    /// The synchronous and blocking version of `geoclue.ClientProxy.create``geoclue.ClientProxy.create`.
    /// See also `geoclue.ClientProxy.createFullSync` which improves resource
    /// management.
    ///
    /// This function is identical to calling `geoclue.ClientProxy.createFullSync`
    /// without any flags set.
    extern fn gclue_client_proxy_create_sync(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const createSync = gclue_client_proxy_create_sync;

    /// Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>. See `gio.DBusProxy.new` for more details.
    ///
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.ClientProxy.newFinish` to get the result of the operation.
    ///
    /// See `geoclue.ClientProxy.newSync` for the synchronous, blocking version of this constructor.
    extern fn gclue_client_proxy_new(p_connection: *gio.DBusConnection, p_flags: gio.DBusProxyFlags, p_name: ?[*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const new = gclue_client_proxy_new;

    /// Like `geoclue.ClientProxy.new` but takes a `gio.BusType` instead of a `gio.DBusConnection`.
    ///
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.ClientProxy.newForBusFinish` to get the result of the operation.
    ///
    /// See `geoclue.ClientProxy.newForBusSync` for the synchronous, blocking version of this constructor.
    extern fn gclue_client_proxy_new_for_bus(p_bus_type: gio.BusType, p_flags: gio.DBusProxyFlags, p_name: [*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const newForBus = gclue_client_proxy_new_for_bus;

    /// Finishes an operation started with `geoclue.ClientProxy.new`.
    extern fn gclue_client_proxy_new_finish(p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const newFinish = gclue_client_proxy_new_finish;

    /// Finishes an operation started with `geoclue.ClientProxy.newForBus`.
    extern fn gclue_client_proxy_new_for_bus_finish(p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const newForBusFinish = gclue_client_proxy_new_for_bus_finish;

    /// Like `geoclue.ClientProxy.newSync` but takes a `gio.BusType` instead of a `gio.DBusConnection`.
    ///
    /// The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.ClientProxy.newForBus` for the asynchronous version of this constructor.
    extern fn gclue_client_proxy_new_for_bus_sync(p_bus_type: gio.BusType, p_flags: gio.DBusProxyFlags, p_name: [*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const newForBusSync = gclue_client_proxy_new_for_bus_sync;

    /// Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>. See `gio.DBusProxy.newSync` for more details.
    ///
    /// The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.ClientProxy.new` for the asynchronous version of this constructor.
    extern fn gclue_client_proxy_new_sync(p_connection: *gio.DBusConnection, p_flags: gio.DBusProxyFlags, p_name: ?[*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.ClientProxy;
    pub const newSync = gclue_client_proxy_new_sync;

    extern fn gclue_client_proxy_get_type() usize;
    pub const getGObjectType = gclue_client_proxy_get_type;

    extern fn g_object_ref(p_self: *geoclue.ClientProxy) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.ClientProxy) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ClientProxy, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `geoclue.ClientSkeleton` structure contains only private data and should only be accessed using the provided API.
pub const ClientSkeleton = extern struct {
    pub const Parent = gio.DBusInterfaceSkeleton;
    pub const Implements = [_]type{ geoclue.Client, gio.DBusInterface };
    pub const Class = geoclue.ClientSkeletonClass;
    f_parent_instance: gio.DBusInterfaceSkeleton,
    f_priv: ?*geoclue.ClientSkeletonPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>.
    extern fn gclue_client_skeleton_new() *geoclue.ClientSkeleton;
    pub const new = gclue_client_skeleton_new;

    extern fn gclue_client_skeleton_get_type() usize;
    pub const getGObjectType = gclue_client_skeleton_get_type;

    extern fn g_object_ref(p_self: *geoclue.ClientSkeleton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.ClientSkeleton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ClientSkeleton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `geoclue.LocationProxy` structure contains only private data and should only be accessed using the provided API.
pub const LocationProxy = extern struct {
    pub const Parent = gio.DBusProxy;
    pub const Implements = [_]type{ geoclue.Location, gio.AsyncInitable, gio.DBusInterface, gio.Initable };
    pub const Class = geoclue.LocationProxyClass;
    f_parent_instance: gio.DBusProxy,
    f_priv: ?*geoclue.LocationProxyPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>. See `gio.DBusProxy.new` for more details.
    ///
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.LocationProxy.newFinish` to get the result of the operation.
    ///
    /// See `geoclue.LocationProxy.newSync` for the synchronous, blocking version of this constructor.
    extern fn gclue_location_proxy_new(p_connection: *gio.DBusConnection, p_flags: gio.DBusProxyFlags, p_name: ?[*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const new = gclue_location_proxy_new;

    /// Like `geoclue.LocationProxy.new` but takes a `gio.BusType` instead of a `gio.DBusConnection`.
    ///
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.LocationProxy.newForBusFinish` to get the result of the operation.
    ///
    /// See `geoclue.LocationProxy.newForBusSync` for the synchronous, blocking version of this constructor.
    extern fn gclue_location_proxy_new_for_bus(p_bus_type: gio.BusType, p_flags: gio.DBusProxyFlags, p_name: [*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const newForBus = gclue_location_proxy_new_for_bus;

    /// Finishes an operation started with `geoclue.LocationProxy.new`.
    extern fn gclue_location_proxy_new_finish(p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.LocationProxy;
    pub const newFinish = gclue_location_proxy_new_finish;

    /// Finishes an operation started with `geoclue.LocationProxy.newForBus`.
    extern fn gclue_location_proxy_new_for_bus_finish(p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.LocationProxy;
    pub const newForBusFinish = gclue_location_proxy_new_for_bus_finish;

    /// Like `geoclue.LocationProxy.newSync` but takes a `gio.BusType` instead of a `gio.DBusConnection`.
    ///
    /// The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.LocationProxy.newForBus` for the asynchronous version of this constructor.
    extern fn gclue_location_proxy_new_for_bus_sync(p_bus_type: gio.BusType, p_flags: gio.DBusProxyFlags, p_name: [*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.LocationProxy;
    pub const newForBusSync = gclue_location_proxy_new_for_bus_sync;

    /// Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>. See `gio.DBusProxy.newSync` for more details.
    ///
    /// The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.LocationProxy.new` for the asynchronous version of this constructor.
    extern fn gclue_location_proxy_new_sync(p_connection: *gio.DBusConnection, p_flags: gio.DBusProxyFlags, p_name: ?[*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.LocationProxy;
    pub const newSync = gclue_location_proxy_new_sync;

    extern fn gclue_location_proxy_get_type() usize;
    pub const getGObjectType = gclue_location_proxy_get_type;

    extern fn g_object_ref(p_self: *geoclue.LocationProxy) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.LocationProxy) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *LocationProxy, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `geoclue.LocationSkeleton` structure contains only private data and should only be accessed using the provided API.
pub const LocationSkeleton = extern struct {
    pub const Parent = gio.DBusInterfaceSkeleton;
    pub const Implements = [_]type{ geoclue.Location, gio.DBusInterface };
    pub const Class = geoclue.LocationSkeletonClass;
    f_parent_instance: gio.DBusInterfaceSkeleton,
    f_priv: ?*geoclue.LocationSkeletonPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>.
    extern fn gclue_location_skeleton_new() *geoclue.LocationSkeleton;
    pub const new = gclue_location_skeleton_new;

    extern fn gclue_location_skeleton_get_type() usize;
    pub const getGObjectType = gclue_location_skeleton_get_type;

    extern fn g_object_ref(p_self: *geoclue.LocationSkeleton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.LocationSkeleton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *LocationSkeleton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `geoclue.ManagerProxy` structure contains only private data and should only be accessed using the provided API.
pub const ManagerProxy = extern struct {
    pub const Parent = gio.DBusProxy;
    pub const Implements = [_]type{ geoclue.Manager, gio.AsyncInitable, gio.DBusInterface, gio.Initable };
    pub const Class = geoclue.ManagerProxyClass;
    f_parent_instance: gio.DBusProxy,
    f_priv: ?*geoclue.ManagerProxyPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>. See `gio.DBusProxy.new` for more details.
    ///
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.ManagerProxy.newFinish` to get the result of the operation.
    ///
    /// See `geoclue.ManagerProxy.newSync` for the synchronous, blocking version of this constructor.
    extern fn gclue_manager_proxy_new(p_connection: *gio.DBusConnection, p_flags: gio.DBusProxyFlags, p_name: ?[*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const new = gclue_manager_proxy_new;

    /// Like `geoclue.ManagerProxy.new` but takes a `gio.BusType` instead of a `gio.DBusConnection`.
    ///
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.ManagerProxy.newForBusFinish` to get the result of the operation.
    ///
    /// See `geoclue.ManagerProxy.newForBusSync` for the synchronous, blocking version of this constructor.
    extern fn gclue_manager_proxy_new_for_bus(p_bus_type: gio.BusType, p_flags: gio.DBusProxyFlags, p_name: [*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const newForBus = gclue_manager_proxy_new_for_bus;

    /// Finishes an operation started with `geoclue.ManagerProxy.new`.
    extern fn gclue_manager_proxy_new_finish(p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.ManagerProxy;
    pub const newFinish = gclue_manager_proxy_new_finish;

    /// Finishes an operation started with `geoclue.ManagerProxy.newForBus`.
    extern fn gclue_manager_proxy_new_for_bus_finish(p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.ManagerProxy;
    pub const newForBusFinish = gclue_manager_proxy_new_for_bus_finish;

    /// Like `geoclue.ManagerProxy.newSync` but takes a `gio.BusType` instead of a `gio.DBusConnection`.
    ///
    /// The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.ManagerProxy.newForBus` for the asynchronous version of this constructor.
    extern fn gclue_manager_proxy_new_for_bus_sync(p_bus_type: gio.BusType, p_flags: gio.DBusProxyFlags, p_name: [*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.ManagerProxy;
    pub const newForBusSync = gclue_manager_proxy_new_for_bus_sync;

    /// Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>. See `gio.DBusProxy.newSync` for more details.
    ///
    /// The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.ManagerProxy.new` for the asynchronous version of this constructor.
    extern fn gclue_manager_proxy_new_sync(p_connection: *gio.DBusConnection, p_flags: gio.DBusProxyFlags, p_name: ?[*:0]const u8, p_object_path: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.ManagerProxy;
    pub const newSync = gclue_manager_proxy_new_sync;

    extern fn gclue_manager_proxy_get_type() usize;
    pub const getGObjectType = gclue_manager_proxy_get_type;

    extern fn g_object_ref(p_self: *geoclue.ManagerProxy) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.ManagerProxy) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ManagerProxy, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `geoclue.ManagerSkeleton` structure contains only private data and should only be accessed using the provided API.
pub const ManagerSkeleton = extern struct {
    pub const Parent = gio.DBusInterfaceSkeleton;
    pub const Implements = [_]type{ geoclue.Manager, gio.DBusInterface };
    pub const Class = geoclue.ManagerSkeletonClass;
    f_parent_instance: gio.DBusInterfaceSkeleton,
    f_priv: ?*geoclue.ManagerSkeletonPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
    extern fn gclue_manager_skeleton_new() *geoclue.ManagerSkeleton;
    pub const new = gclue_manager_skeleton_new;

    extern fn gclue_manager_skeleton_get_type() usize;
    pub const getGObjectType = gclue_manager_skeleton_get_type;

    extern fn g_object_ref(p_self: *geoclue.ManagerSkeleton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.ManagerSkeleton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ManagerSkeleton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Simple = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{gio.AsyncInitable};
    pub const Class = geoclue.SimpleClass;
    f_parent: gobject.Object,
    f_priv: ?*geoclue.SimplePrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The requested maximum accuracy level.
        pub const accuracy_level = struct {
            pub const name = "accuracy-level";

            pub const Type = geoclue.AccuracyLevel;
        };

        /// The client proxy. This is `NULL` if `simple` is not using a client proxy
        /// (i-e when inside the Flatpak sandbox).
        pub const client = struct {
            pub const name = "client";

            pub const Type = ?*geoclue.ClientProxy;
        };

        /// The Desktop ID of the application.
        pub const desktop_id = struct {
            pub const name = "desktop-id";

            pub const Type = ?[*:0]u8;
        };

        /// The current distance threshold in meters. This value is used by the
        /// service when it gets new location info. If the distance moved is
        /// below the threshold, it won't emit the LocationUpdated signal.
        ///
        /// When set to 0 (default), it always emits the signal.
        pub const distance_threshold = struct {
            pub const name = "distance-threshold";

            pub const Type = c_uint;
        };

        /// The current location.
        pub const location = struct {
            pub const name = "location";

            pub const Type = ?*geoclue.LocationProxy;
        };

        /// The current time threshold in seconds. This value is used by the
        /// service when it gets new location info. If the time passed is
        /// below the threshold, it won't emit the LocationUpdated signal.
        ///
        /// When set to 0 (default), it always emits the signal.
        pub const time_threshold = struct {
            pub const name = "time-threshold";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    /// Asynchronously creates a `geoclue.Simple` instance. Use
    /// `geoclue.Simple.newFinish``geoclue.Simple.newFinish` to get the created `geoclue.Simple` instance.
    ///
    /// See `geoclue.Simple.newSync``geoclue.Simple.newSync` for the synchronous, blocking version
    /// of this function.
    extern fn gclue_simple_new(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const new = gclue_simple_new;

    /// Asynchronously creates a `geoclue.Simple` instance. Use
    /// `geoclue.Simple.newWithThresholdsFinish``geoclue.Simple.newWithThresholdsFinish` to get the created `geoclue.Simple` instance.
    ///
    /// See `geoclue.Simple.newWithThresholdsSync``geoclue.Simple.newWithThresholdsSync` for the synchronous,
    /// blocking version of this function.
    extern fn gclue_simple_new_with_thresholds(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_time_threshold: c_uint, p_distance_threshold: c_uint, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const newWithThresholds = gclue_simple_new_with_thresholds;

    /// Finishes an operation started with `geoclue.Simple.new``geoclue.Simple.new`.
    extern fn gclue_simple_new_finish(p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.Simple;
    pub const newFinish = gclue_simple_new_finish;

    /// The synchronous and blocking version of `geoclue.Simple.new``geoclue.Simple.new`.
    extern fn gclue_simple_new_sync(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.Simple;
    pub const newSync = gclue_simple_new_sync;

    /// Finishes an operation started with `geoclue.Simple.newWithThresholds``geoclue.Simple.newWithThresholds`.
    extern fn gclue_simple_new_with_thresholds_finish(p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*geoclue.Simple;
    pub const newWithThresholdsFinish = gclue_simple_new_with_thresholds_finish;

    /// The synchronous and blocking version of `geoclue.Simple.newWithThresholds``geoclue.Simple.newWithThresholds`.
    extern fn gclue_simple_new_with_thresholds_sync(p_desktop_id: [*:0]const u8, p_accuracy_level: geoclue.AccuracyLevel, p_time_threshold: c_uint, p_distance_threshold: c_uint, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*geoclue.Simple;
    pub const newWithThresholdsSync = gclue_simple_new_with_thresholds_sync;

    /// Gets the client proxy, or `NULL` if `simple` is not using a client proxy (i-e
    /// when inside the Flatpak sandbox).
    extern fn gclue_simple_get_client(p_simple: *Simple) ?*geoclue.ClientProxy;
    pub const getClient = gclue_simple_get_client;

    /// Gets the current location.
    extern fn gclue_simple_get_location(p_simple: *Simple) ?*geoclue.Location;
    pub const getLocation = gclue_simple_get_location;

    extern fn gclue_simple_get_type() usize;
    pub const getGObjectType = gclue_simple_get_type;

    extern fn g_object_ref(p_self: *geoclue.Simple) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.Simple) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Simple, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>.
pub const Client = opaque {
    pub const Prerequisites = [_]type{gobject.Object};
    pub const Iface = geoclue.ClientIface;
    pub const virtual_methods = struct {
        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Active">"Active"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_active = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(Client.Iface, p_class).f_get_active.?(gobject.ext.as(Client, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(Client.Iface, p_class).f_get_active = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"</link> D-Bus property.
        ///
        /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
        ///
        /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Client.dupDesktopId` if on another thread.
        pub const get_desktop_id = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?[*:0]const u8 {
                return gobject.ext.as(Client.Iface, p_class).f_get_desktop_id.?(gobject.ext.as(Client, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?[*:0]const u8) void {
                gobject.ext.as(Client.Iface, p_class).f_get_desktop_id = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"</link> D-Bus property.
        ///
        /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
        pub const get_distance_threshold = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_uint {
                return gobject.ext.as(Client.Iface, p_class).f_get_distance_threshold.?(gobject.ext.as(Client, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_uint) void {
                gobject.ext.as(Client.Iface, p_class).f_get_distance_threshold = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        ///
        /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Client.dupLocation` if on another thread.
        pub const get_location = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?[*:0]const u8 {
                return gobject.ext.as(Client.Iface, p_class).f_get_location.?(gobject.ext.as(Client, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?[*:0]const u8) void {
                gobject.ext.as(Client.Iface, p_class).f_get_location = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.RequestedAccuracyLevel">"RequestedAccuracyLevel"</link> D-Bus property.
        ///
        /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
        pub const get_requested_accuracy_level = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_uint {
                return gobject.ext.as(Client.Iface, p_class).f_get_requested_accuracy_level.?(gobject.ext.as(Client, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_uint) void {
                gobject.ext.as(Client.Iface, p_class).f_get_requested_accuracy_level = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.TimeThreshold">"TimeThreshold"</link> D-Bus property.
        ///
        /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
        pub const get_time_threshold = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_uint {
                return gobject.ext.as(Client.Iface, p_class).f_get_time_threshold.?(gobject.ext.as(Client, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_uint) void {
                gobject.ext.as(Client.Iface, p_class).f_get_time_threshold = @ptrCast(p_implementation);
            }
        };

        /// Handler for the `geoclue.Client.signals.handle`-start signal.
        pub const handle_start = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) c_int {
                return gobject.ext.as(Client.Iface, p_class).f_handle_start.?(gobject.ext.as(Client, p_object), p_invocation);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int) void {
                gobject.ext.as(Client.Iface, p_class).f_handle_start = @ptrCast(p_implementation);
            }
        };

        /// Handler for the `geoclue.Client.signals.handle`-stop signal.
        pub const handle_stop = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) c_int {
                return gobject.ext.as(Client.Iface, p_class).f_handle_stop.?(gobject.ext.as(Client, p_object), p_invocation);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int) void {
                gobject.ext.as(Client.Iface, p_class).f_handle_stop = @ptrCast(p_implementation);
            }
        };

        /// Handler for the `geoclue.Client.signals.location`-updated signal.
        pub const location_updated = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_arg_old: [*:0]const u8, p_arg_new: [*:0]const u8) void {
                return gobject.ext.as(Client.Iface, p_class).f_location_updated.?(gobject.ext.as(Client, p_object), p_arg_old, p_arg_new);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_arg_old: [*:0]const u8, p_arg_new: [*:0]const u8) callconv(.C) void) void {
                gobject.ext.as(Client.Iface, p_class).f_location_updated = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Active">"Active"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const active = struct {
            pub const name = "active";

            pub const Type = c_int;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
        pub const desktop_id = struct {
            pub const name = "desktop-id";

            pub const Type = ?[*:0]u8;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
        pub const distance_threshold = struct {
            pub const name = "distance-threshold";

            pub const Type = c_uint;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const location = struct {
            pub const name = "location";

            pub const Type = ?[*:0]u8;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.RequestedAccuracyLevel">"RequestedAccuracyLevel"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
        pub const requested_accuracy_level = struct {
            pub const name = "requested-accuracy-level";

            pub const Type = c_uint;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.TimeThreshold">"TimeThreshold"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
        pub const time_threshold = struct {
            pub const name = "time-threshold";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {
        /// Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">`Start`</link> D-Bus method.
        ///
        /// If a signal handler returns `TRUE`, it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `geoclue.Client.completeStart` or e.g. `gio.DBusMethodInvocation.returnError` on it) and no other signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
        pub const handle_start = struct {
            pub const name = "handle-start";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_invocation: *gio.DBusMethodInvocation, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Client, p_instance))),
                    gobject.signalLookup("handle-start", Client.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">`Stop`</link> D-Bus method.
        ///
        /// If a signal handler returns `TRUE`, it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `geoclue.Client.completeStop` or e.g. `gio.DBusMethodInvocation.returnError` on it) and no other signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
        pub const handle_stop = struct {
            pub const name = "handle-stop";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_invocation: *gio.DBusMethodInvocation, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Client, p_instance))),
                    gobject.signalLookup("handle-stop", Client.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-GeoClue2-Client.LocationUpdated">"LocationUpdated"</link> is received.
        ///
        /// On the service-side, this signal can be used with e.g. `gobject.signalEmitByName` to make the object emit the D-Bus signal.
        pub const location_updated = struct {
            pub const name = "location-updated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_arg_old: [*:0]u8, p_arg_new: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Client, p_instance))),
                    gobject.signalLookup("location-updated", Client.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link> D-Bus interface.
    extern fn gclue_client_interface_info() *gio.DBusInterfaceInfo;
    pub const interfaceInfo = gclue_client_interface_info;

    /// Overrides all `gobject.Object` properties in the `geoclue.Client` interface for a concrete class.
    /// The properties are overridden in the order they are defined.
    extern fn gclue_client_override_properties(p_klass: *gobject.ObjectClass, p_property_id_begin: c_uint) c_uint;
    pub const overrideProperties = gclue_client_override_properties;

    /// Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">`Start`</link> D-Bus method on `proxy`.
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.Client.callStartFinish` to get the result of the operation.
    ///
    /// See `geoclue.Client.callStartSync` for the synchronous, blocking version of this method.
    extern fn gclue_client_call_start(p_proxy: *Client, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const callStart = gclue_client_call_start;

    /// Finishes an operation started with `geoclue.Client.callStart`.
    extern fn gclue_client_call_start_finish(p_proxy: *Client, p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const callStartFinish = gclue_client_call_start_finish;

    /// Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">`Start`</link> D-Bus method on `proxy`. The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.Client.callStart` for the asynchronous version of this method.
    extern fn gclue_client_call_start_sync(p_proxy: *Client, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) c_int;
    pub const callStartSync = gclue_client_call_start_sync;

    /// Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">`Stop`</link> D-Bus method on `proxy`.
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.Client.callStopFinish` to get the result of the operation.
    ///
    /// See `geoclue.Client.callStopSync` for the synchronous, blocking version of this method.
    extern fn gclue_client_call_stop(p_proxy: *Client, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const callStop = gclue_client_call_stop;

    /// Finishes an operation started with `geoclue.Client.callStop`.
    extern fn gclue_client_call_stop_finish(p_proxy: *Client, p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const callStopFinish = gclue_client_call_stop_finish;

    /// Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">`Stop`</link> D-Bus method on `proxy`. The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.Client.callStop` for the asynchronous version of this method.
    extern fn gclue_client_call_stop_sync(p_proxy: *Client, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) c_int;
    pub const callStopSync = gclue_client_call_stop_sync;

    /// Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">`Start`</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use `gio.DBusMethodInvocation.returnError` or similar.
    ///
    /// This method will free `invocation`, you cannot use it afterwards.
    extern fn gclue_client_complete_start(p_object: *Client, p_invocation: *gio.DBusMethodInvocation) void;
    pub const completeStart = gclue_client_complete_start;

    /// Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">`Stop`</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use `gio.DBusMethodInvocation.returnError` or similar.
    ///
    /// This method will free `invocation`, you cannot use it afterwards.
    extern fn gclue_client_complete_stop(p_object: *Client, p_invocation: *gio.DBusMethodInvocation) void;
    pub const completeStop = gclue_client_complete_stop;

    /// Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"</link> D-Bus property.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_dup_desktop_id(p_object: *Client) ?[*:0]u8;
    pub const dupDesktopId = gclue_client_dup_desktop_id;

    /// Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_dup_location(p_object: *Client) ?[*:0]u8;
    pub const dupLocation = gclue_client_dup_location;

    /// Emits the <link linkend="gdbus-signal-org-freedesktop-GeoClue2-Client.LocationUpdated">"LocationUpdated"</link> D-Bus signal.
    extern fn gclue_client_emit_location_updated(p_object: *Client, p_arg_old: [*:0]const u8, p_arg_new: [*:0]const u8) void;
    pub const emitLocationUpdated = gclue_client_emit_location_updated;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Active">"Active"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_get_active(p_object: *Client) c_int;
    pub const getActive = gclue_client_get_active;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"</link> D-Bus property.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    ///
    /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Client.dupDesktopId` if on another thread.
    extern fn gclue_client_get_desktop_id(p_object: *Client) ?[*:0]const u8;
    pub const getDesktopId = gclue_client_get_desktop_id;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"</link> D-Bus property.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_get_distance_threshold(p_object: *Client) c_uint;
    pub const getDistanceThreshold = gclue_client_get_distance_threshold;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    ///
    /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Client.dupLocation` if on another thread.
    extern fn gclue_client_get_location(p_object: *Client) ?[*:0]const u8;
    pub const getLocation = gclue_client_get_location;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.RequestedAccuracyLevel">"RequestedAccuracyLevel"</link> D-Bus property.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_get_requested_accuracy_level(p_object: *Client) c_uint;
    pub const getRequestedAccuracyLevel = gclue_client_get_requested_accuracy_level;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.TimeThreshold">"TimeThreshold"</link> D-Bus property.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_get_time_threshold(p_object: *Client) c_uint;
    pub const getTimeThreshold = gclue_client_get_time_threshold;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Active">"Active"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_client_set_active(p_object: *Client, p_value: c_int) void;
    pub const setActive = gclue_client_set_active;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DesktopId">"DesktopId"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_set_desktop_id(p_object: *Client, p_value: [*:0]const u8) void;
    pub const setDesktopId = gclue_client_set_desktop_id;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_set_distance_threshold(p_object: *Client, p_value: c_uint) void;
    pub const setDistanceThreshold = gclue_client_set_distance_threshold;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_client_set_location(p_object: *Client, p_value: [*:0]const u8) void;
    pub const setLocation = gclue_client_set_location;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.RequestedAccuracyLevel">"RequestedAccuracyLevel"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_set_requested_accuracy_level(p_object: *Client, p_value: c_uint) void;
    pub const setRequestedAccuracyLevel = gclue_client_set_requested_accuracy_level;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.TimeThreshold">"TimeThreshold"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_client_set_time_threshold(p_object: *Client, p_value: c_uint) void;
    pub const setTimeThreshold = gclue_client_set_time_threshold;

    extern fn gclue_client_get_type() usize;
    pub const getGObjectType = gclue_client_get_type;

    extern fn g_object_ref(p_self: *geoclue.Client) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.Client) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Client, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>.
pub const Location = opaque {
    pub const Prerequisites = [_]type{gobject.Object};
    pub const Iface = geoclue.LocationIface;
    pub const virtual_methods = struct {
        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_accuracy = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) f64 {
                return gobject.ext.as(Location.Iface, p_class).f_get_accuracy.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) f64) void {
                gobject.ext.as(Location.Iface, p_class).f_get_accuracy = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Altitude">"Altitude"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_altitude = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) f64 {
                return gobject.ext.as(Location.Iface, p_class).f_get_altitude.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) f64) void {
                gobject.ext.as(Location.Iface, p_class).f_get_altitude = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        ///
        /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Location.dupDescription` if on another thread.
        pub const get_description = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?[*:0]const u8 {
                return gobject.ext.as(Location.Iface, p_class).f_get_description.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?[*:0]const u8) void {
                gobject.ext.as(Location.Iface, p_class).f_get_description = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Heading">"Heading"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_heading = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) f64 {
                return gobject.ext.as(Location.Iface, p_class).f_get_heading.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) f64) void {
                gobject.ext.as(Location.Iface, p_class).f_get_heading = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_latitude = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) f64 {
                return gobject.ext.as(Location.Iface, p_class).f_get_latitude.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) f64) void {
                gobject.ext.as(Location.Iface, p_class).f_get_latitude = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_longitude = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) f64 {
                return gobject.ext.as(Location.Iface, p_class).f_get_longitude.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) f64) void {
                gobject.ext.as(Location.Iface, p_class).f_get_longitude = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Speed">"Speed"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_speed = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) f64 {
                return gobject.ext.as(Location.Iface, p_class).f_get_speed.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) f64) void {
                gobject.ext.as(Location.Iface, p_class).f_get_speed = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        ///
        /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Location.dupTimestamp` if on another thread.
        pub const get_timestamp = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?*glib.Variant {
                return gobject.ext.as(Location.Iface, p_class).f_get_timestamp.?(gobject.ext.as(Location, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?*glib.Variant) void {
                gobject.ext.as(Location.Iface, p_class).f_get_timestamp = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const accuracy = struct {
            pub const name = "accuracy";

            pub const Type = f64;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Altitude">"Altitude"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const altitude = struct {
            pub const name = "altitude";

            pub const Type = f64;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const description = struct {
            pub const name = "description";

            pub const Type = ?[*:0]u8;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Heading">"Heading"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const heading = struct {
            pub const name = "heading";

            pub const Type = f64;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const latitude = struct {
            pub const name = "latitude";

            pub const Type = f64;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const longitude = struct {
            pub const name = "longitude";

            pub const Type = f64;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Speed">"Speed"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const speed = struct {
            pub const name = "speed";

            pub const Type = f64;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const timestamp = struct {
            pub const name = "timestamp";

            pub const Type = ?*glib.Variant;
        };
    };

    pub const signals = struct {};

    /// Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link> D-Bus interface.
    extern fn gclue_location_interface_info() *gio.DBusInterfaceInfo;
    pub const interfaceInfo = gclue_location_interface_info;

    /// Overrides all `gobject.Object` properties in the `geoclue.Location` interface for a concrete class.
    /// The properties are overridden in the order they are defined.
    extern fn gclue_location_override_properties(p_klass: *gobject.ObjectClass, p_property_id_begin: c_uint) c_uint;
    pub const overrideProperties = gclue_location_override_properties;

    /// Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_dup_description(p_object: *Location) ?[*:0]u8;
    pub const dupDescription = gclue_location_dup_description;

    /// Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_dup_timestamp(p_object: *Location) ?*glib.Variant;
    pub const dupTimestamp = gclue_location_dup_timestamp;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_get_accuracy(p_object: *Location) f64;
    pub const getAccuracy = gclue_location_get_accuracy;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Altitude">"Altitude"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_get_altitude(p_object: *Location) f64;
    pub const getAltitude = gclue_location_get_altitude;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    ///
    /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Location.dupDescription` if on another thread.
    extern fn gclue_location_get_description(p_object: *Location) ?[*:0]const u8;
    pub const getDescription = gclue_location_get_description;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Heading">"Heading"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_get_heading(p_object: *Location) f64;
    pub const getHeading = gclue_location_get_heading;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_get_latitude(p_object: *Location) f64;
    pub const getLatitude = gclue_location_get_latitude;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_get_longitude(p_object: *Location) f64;
    pub const getLongitude = gclue_location_get_longitude;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Speed">"Speed"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_location_get_speed(p_object: *Location) f64;
    pub const getSpeed = gclue_location_get_speed;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    ///
    /// The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where `object` was constructed. Use `geoclue.Location.dupTimestamp` if on another thread.
    extern fn gclue_location_get_timestamp(p_object: *Location) ?*glib.Variant;
    pub const getTimestamp = gclue_location_get_timestamp;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_accuracy(p_object: *Location, p_value: f64) void;
    pub const setAccuracy = gclue_location_set_accuracy;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Altitude">"Altitude"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_altitude(p_object: *Location, p_value: f64) void;
    pub const setAltitude = gclue_location_set_altitude;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_description(p_object: *Location, p_value: [*:0]const u8) void;
    pub const setDescription = gclue_location_set_description;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Heading">"Heading"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_heading(p_object: *Location, p_value: f64) void;
    pub const setHeading = gclue_location_set_heading;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_latitude(p_object: *Location, p_value: f64) void;
    pub const setLatitude = gclue_location_set_latitude;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_longitude(p_object: *Location, p_value: f64) void;
    pub const setLongitude = gclue_location_set_longitude;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Speed">"Speed"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_speed(p_object: *Location, p_value: f64) void;
    pub const setSpeed = gclue_location_set_speed;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Timestamp">"Timestamp"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_location_set_timestamp(p_object: *Location, p_value: *glib.Variant) void;
    pub const setTimestamp = gclue_location_set_timestamp;

    extern fn gclue_location_get_type() usize;
    pub const getGObjectType = gclue_location_get_type;

    extern fn g_object_ref(p_self: *geoclue.Location) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.Location) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Location, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
pub const Manager = opaque {
    pub const Prerequisites = [_]type{gobject.Object};
    pub const Iface = geoclue.ManagerIface;
    pub const virtual_methods = struct {
        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_available_accuracy_level = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_uint {
                return gobject.ext.as(Manager.Iface, p_class).f_get_available_accuracy_level.?(gobject.ext.as(Manager, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_uint) void {
                gobject.ext.as(Manager.Iface, p_class).f_get_available_accuracy_level = @ptrCast(p_implementation);
            }
        };

        /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"</link> D-Bus property.
        ///
        /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
        pub const get_in_use = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(Manager.Iface, p_class).f_get_in_use.?(gobject.ext.as(Manager, p_object));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(Manager.Iface, p_class).f_get_in_use = @ptrCast(p_implementation);
            }
        };

        /// Handler for the `geoclue.Manager.signals.handle`-add-agent signal.
        pub const handle_add_agent = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation, p_arg_id: [*:0]const u8) c_int {
                return gobject.ext.as(Manager.Iface, p_class).f_handle_add_agent.?(gobject.ext.as(Manager, p_object), p_invocation, p_arg_id);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation, p_arg_id: [*:0]const u8) callconv(.C) c_int) void {
                gobject.ext.as(Manager.Iface, p_class).f_handle_add_agent = @ptrCast(p_implementation);
            }
        };

        /// Handler for the `geoclue.Manager.signals.handle`-create-client signal.
        pub const handle_create_client = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) c_int {
                return gobject.ext.as(Manager.Iface, p_class).f_handle_create_client.?(gobject.ext.as(Manager, p_object), p_invocation);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int) void {
                gobject.ext.as(Manager.Iface, p_class).f_handle_create_client = @ptrCast(p_implementation);
            }
        };

        /// Handler for the `geoclue.Manager.signals.handle`-delete-client signal.
        pub const handle_delete_client = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation, p_arg_client: [*:0]const u8) c_int {
                return gobject.ext.as(Manager.Iface, p_class).f_handle_delete_client.?(gobject.ext.as(Manager, p_object), p_invocation, p_arg_client);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation, p_arg_client: [*:0]const u8) callconv(.C) c_int) void {
                gobject.ext.as(Manager.Iface, p_class).f_handle_delete_client = @ptrCast(p_implementation);
            }
        };

        /// Handler for the `geoclue.Manager.signals.handle`-get-client signal.
        pub const handle_get_client = struct {
            pub fn call(p_class: anytype, p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) c_int {
                return gobject.ext.as(Manager.Iface, p_class).f_handle_get_client.?(gobject.ext.as(Manager, p_object), p_invocation);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_object: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int) void {
                gobject.ext.as(Manager.Iface, p_class).f_handle_get_client = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const available_accuracy_level = struct {
            pub const name = "available-accuracy-level";

            pub const Type = c_uint;
        };

        /// Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"</link>.
        ///
        /// Since the D-Bus property for this `gobject.Object` property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
        pub const in_use = struct {
            pub const name = "in-use";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">`AddAgent`</link> D-Bus method.
        ///
        /// If a signal handler returns `TRUE`, it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `geoclue.Manager.completeAddAgent` or e.g. `gio.DBusMethodInvocation.returnError` on it) and no other signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
        pub const handle_add_agent = struct {
            pub const name = "handle-add-agent";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_invocation: *gio.DBusMethodInvocation, p_arg_id: [*:0]u8, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Manager, p_instance))),
                    gobject.signalLookup("handle-add-agent", Manager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">`CreateClient`</link> D-Bus method.
        ///
        /// If a signal handler returns `TRUE`, it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `geoclue.Manager.completeCreateClient` or e.g. `gio.DBusMethodInvocation.returnError` on it) and no other signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
        pub const handle_create_client = struct {
            pub const name = "handle-create-client";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_invocation: *gio.DBusMethodInvocation, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Manager, p_instance))),
                    gobject.signalLookup("handle-create-client", Manager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">`DeleteClient`</link> D-Bus method.
        ///
        /// If a signal handler returns `TRUE`, it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `geoclue.Manager.completeDeleteClient` or e.g. `gio.DBusMethodInvocation.returnError` on it) and no other signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
        pub const handle_delete_client = struct {
            pub const name = "handle-delete-client";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_invocation: *gio.DBusMethodInvocation, p_arg_client: [*:0]u8, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Manager, p_instance))),
                    gobject.signalLookup("handle-delete-client", Manager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">`GetClient`</link> D-Bus method.
        ///
        /// If a signal handler returns `TRUE`, it means the signal handler will handle the invocation (e.g. take a reference to `invocation` and eventually call `geoclue.Manager.completeGetClient` or e.g. `gio.DBusMethodInvocation.returnError` on it) and no other signal handlers will run. If no signal handler handles the invocation, the `G_DBUS_ERROR_UNKNOWN_METHOD` error is returned.
        pub const handle_get_client = struct {
            pub const name = "handle-get-client";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_invocation: *gio.DBusMethodInvocation, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Manager, p_instance))),
                    gobject.signalLookup("handle-get-client", Manager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link> D-Bus interface.
    extern fn gclue_manager_interface_info() *gio.DBusInterfaceInfo;
    pub const interfaceInfo = gclue_manager_interface_info;

    /// Overrides all `gobject.Object` properties in the `geoclue.Manager` interface for a concrete class.
    /// The properties are overridden in the order they are defined.
    extern fn gclue_manager_override_properties(p_klass: *gobject.ObjectClass, p_property_id_begin: c_uint) c_uint;
    pub const overrideProperties = gclue_manager_override_properties;

    /// Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">`AddAgent`</link> D-Bus method on `proxy`.
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.Manager.callAddAgentFinish` to get the result of the operation.
    ///
    /// See `geoclue.Manager.callAddAgentSync` for the synchronous, blocking version of this method.
    extern fn gclue_manager_call_add_agent(p_proxy: *Manager, p_arg_id: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const callAddAgent = gclue_manager_call_add_agent;

    /// Finishes an operation started with `geoclue.Manager.callAddAgent`.
    extern fn gclue_manager_call_add_agent_finish(p_proxy: *Manager, p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const callAddAgentFinish = gclue_manager_call_add_agent_finish;

    /// Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">`AddAgent`</link> D-Bus method on `proxy`. The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.Manager.callAddAgent` for the asynchronous version of this method.
    extern fn gclue_manager_call_add_agent_sync(p_proxy: *Manager, p_arg_id: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) c_int;
    pub const callAddAgentSync = gclue_manager_call_add_agent_sync;

    /// Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">`CreateClient`</link> D-Bus method on `proxy`.
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.Manager.callCreateClientFinish` to get the result of the operation.
    ///
    /// See `geoclue.Manager.callCreateClientSync` for the synchronous, blocking version of this method.
    extern fn gclue_manager_call_create_client(p_proxy: *Manager, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const callCreateClient = gclue_manager_call_create_client;

    /// Finishes an operation started with `geoclue.Manager.callCreateClient`.
    extern fn gclue_manager_call_create_client_finish(p_proxy: *Manager, p_out_client: ?*[*:0]u8, p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const callCreateClientFinish = gclue_manager_call_create_client_finish;

    /// Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">`CreateClient`</link> D-Bus method on `proxy`. The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.Manager.callCreateClient` for the asynchronous version of this method.
    extern fn gclue_manager_call_create_client_sync(p_proxy: *Manager, p_out_client: ?*[*:0]u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) c_int;
    pub const callCreateClientSync = gclue_manager_call_create_client_sync;

    /// Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">`DeleteClient`</link> D-Bus method on `proxy`.
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.Manager.callDeleteClientFinish` to get the result of the operation.
    ///
    /// See `geoclue.Manager.callDeleteClientSync` for the synchronous, blocking version of this method.
    extern fn gclue_manager_call_delete_client(p_proxy: *Manager, p_arg_client: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const callDeleteClient = gclue_manager_call_delete_client;

    /// Finishes an operation started with `geoclue.Manager.callDeleteClient`.
    extern fn gclue_manager_call_delete_client_finish(p_proxy: *Manager, p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const callDeleteClientFinish = gclue_manager_call_delete_client_finish;

    /// Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">`DeleteClient`</link> D-Bus method on `proxy`. The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.Manager.callDeleteClient` for the asynchronous version of this method.
    extern fn gclue_manager_call_delete_client_sync(p_proxy: *Manager, p_arg_client: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) c_int;
    pub const callDeleteClientSync = gclue_manager_call_delete_client_sync;

    /// Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">`GetClient`</link> D-Bus method on `proxy`.
    /// When the operation is finished, `callback` will be invoked in the thread-default main loop of the thread you are calling this method from (see `glib.MainContext.pushThreadDefault`).
    /// You can then call `geoclue.Manager.callGetClientFinish` to get the result of the operation.
    ///
    /// See `geoclue.Manager.callGetClientSync` for the synchronous, blocking version of this method.
    extern fn gclue_manager_call_get_client(p_proxy: *Manager, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const callGetClient = gclue_manager_call_get_client;

    /// Finishes an operation started with `geoclue.Manager.callGetClient`.
    extern fn gclue_manager_call_get_client_finish(p_proxy: *Manager, p_out_client: ?*[*:0]u8, p_res: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const callGetClientFinish = gclue_manager_call_get_client_finish;

    /// Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">`GetClient`</link> D-Bus method on `proxy`. The calling thread is blocked until a reply is received.
    ///
    /// See `geoclue.Manager.callGetClient` for the asynchronous version of this method.
    extern fn gclue_manager_call_get_client_sync(p_proxy: *Manager, p_out_client: ?*[*:0]u8, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) c_int;
    pub const callGetClientSync = gclue_manager_call_get_client_sync;

    /// Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">`AddAgent`</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use `gio.DBusMethodInvocation.returnError` or similar.
    ///
    /// This method will free `invocation`, you cannot use it afterwards.
    extern fn gclue_manager_complete_add_agent(p_object: *Manager, p_invocation: *gio.DBusMethodInvocation) void;
    pub const completeAddAgent = gclue_manager_complete_add_agent;

    /// Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.CreateClient">`CreateClient`</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use `gio.DBusMethodInvocation.returnError` or similar.
    ///
    /// This method will free `invocation`, you cannot use it afterwards.
    extern fn gclue_manager_complete_create_client(p_object: *Manager, p_invocation: *gio.DBusMethodInvocation, p_client: [*:0]const u8) void;
    pub const completeCreateClient = gclue_manager_complete_create_client;

    /// Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.DeleteClient">`DeleteClient`</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use `gio.DBusMethodInvocation.returnError` or similar.
    ///
    /// This method will free `invocation`, you cannot use it afterwards.
    extern fn gclue_manager_complete_delete_client(p_object: *Manager, p_invocation: *gio.DBusMethodInvocation) void;
    pub const completeDeleteClient = gclue_manager_complete_delete_client;

    /// Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">`GetClient`</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use `gio.DBusMethodInvocation.returnError` or similar.
    ///
    /// This method will free `invocation`, you cannot use it afterwards.
    extern fn gclue_manager_complete_get_client(p_object: *Manager, p_invocation: *gio.DBusMethodInvocation, p_client: [*:0]const u8) void;
    pub const completeGetClient = gclue_manager_complete_get_client;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_manager_get_available_accuracy_level(p_object: *Manager) c_uint;
    pub const getAvailableAccuracyLevel = gclue_manager_get_available_accuracy_level;

    /// Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"</link> D-Bus property.
    ///
    /// Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
    extern fn gclue_manager_get_in_use(p_object: *Manager) c_int;
    pub const getInUse = gclue_manager_get_in_use;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.AvailableAccuracyLevel">"AvailableAccuracyLevel"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_manager_set_available_accuracy_level(p_object: *Manager, p_value: c_uint) void;
    pub const setAvailableAccuracyLevel = gclue_manager_set_available_accuracy_level;

    /// Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Manager.InUse">"InUse"</link> D-Bus property to `value`.
    ///
    /// Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
    extern fn gclue_manager_set_in_use(p_object: *Manager, p_value: c_int) void;
    pub const setInUse = gclue_manager_set_in_use;

    extern fn gclue_manager_get_type() usize;
    pub const getGObjectType = gclue_manager_get_type;

    extern fn g_object_ref(p_self: *geoclue.Manager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *geoclue.Manager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Manager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>.
pub const ClientIface = extern struct {
    pub const Instance = geoclue.Client;

    /// The parent interface.
    f_parent_iface: gobject.TypeInterface,
    /// Handler for the `geoclue.Client.signals.handle`-start signal.
    f_handle_start: ?*const fn (p_object: *geoclue.Client, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int,
    /// Handler for the `geoclue.Client.signals.handle`-stop signal.
    f_handle_stop: ?*const fn (p_object: *geoclue.Client, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int,
    /// Getter for the `geoclue.Client.properties.active` property.
    f_get_active: ?*const fn (p_object: *geoclue.Client) callconv(.C) c_int,
    /// Getter for the `geoclue.Client.properties.desktop`-id property.
    f_get_desktop_id: ?*const fn (p_object: *geoclue.Client) callconv(.C) ?[*:0]const u8,
    /// Getter for the `geoclue.Client.properties.distance`-threshold property.
    f_get_distance_threshold: ?*const fn (p_object: *geoclue.Client) callconv(.C) c_uint,
    /// Getter for the `geoclue.Client.properties.location` property.
    f_get_location: ?*const fn (p_object: *geoclue.Client) callconv(.C) ?[*:0]const u8,
    /// Getter for the `geoclue.Client.properties.requested`-accuracy-level property.
    f_get_requested_accuracy_level: ?*const fn (p_object: *geoclue.Client) callconv(.C) c_uint,
    /// Getter for the `geoclue.Client.properties.time`-threshold property.
    f_get_time_threshold: ?*const fn (p_object: *geoclue.Client) callconv(.C) c_uint,
    /// Handler for the `geoclue.Client.signals.location`-updated signal.
    f_location_updated: ?*const fn (p_object: *geoclue.Client, p_arg_old: [*:0]const u8, p_arg_new: [*:0]const u8) callconv(.C) void,

    pub fn as(p_instance: *ClientIface, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Class structure for `geoclue.ClientProxy`.
pub const ClientProxyClass = extern struct {
    pub const Instance = geoclue.ClientProxy;

    /// The parent class.
    f_parent_class: gio.DBusProxyClass,

    pub fn as(p_instance: *ClientProxyClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ClientProxyPrivate = opaque {};

/// Class structure for `geoclue.ClientSkeleton`.
pub const ClientSkeletonClass = extern struct {
    pub const Instance = geoclue.ClientSkeleton;

    /// The parent class.
    f_parent_class: gio.DBusInterfaceSkeletonClass,

    pub fn as(p_instance: *ClientSkeletonClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ClientSkeletonPrivate = opaque {};

/// Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>.
pub const LocationIface = extern struct {
    pub const Instance = geoclue.Location;

    /// The parent interface.
    f_parent_iface: gobject.TypeInterface,
    /// Getter for the `geoclue.Location.properties.accuracy` property.
    f_get_accuracy: ?*const fn (p_object: *geoclue.Location) callconv(.C) f64,
    /// Getter for the `geoclue.Location.properties.altitude` property.
    f_get_altitude: ?*const fn (p_object: *geoclue.Location) callconv(.C) f64,
    /// Getter for the `geoclue.Location.properties.description` property.
    f_get_description: ?*const fn (p_object: *geoclue.Location) callconv(.C) ?[*:0]const u8,
    /// Getter for the `geoclue.Location.properties.heading` property.
    f_get_heading: ?*const fn (p_object: *geoclue.Location) callconv(.C) f64,
    /// Getter for the `geoclue.Location.properties.latitude` property.
    f_get_latitude: ?*const fn (p_object: *geoclue.Location) callconv(.C) f64,
    /// Getter for the `geoclue.Location.properties.longitude` property.
    f_get_longitude: ?*const fn (p_object: *geoclue.Location) callconv(.C) f64,
    /// Getter for the `geoclue.Location.properties.speed` property.
    f_get_speed: ?*const fn (p_object: *geoclue.Location) callconv(.C) f64,
    /// Getter for the `geoclue.Location.properties.timestamp` property.
    f_get_timestamp: ?*const fn (p_object: *geoclue.Location) callconv(.C) ?*glib.Variant,

    pub fn as(p_instance: *LocationIface, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Class structure for `geoclue.LocationProxy`.
pub const LocationProxyClass = extern struct {
    pub const Instance = geoclue.LocationProxy;

    /// The parent class.
    f_parent_class: gio.DBusProxyClass,

    pub fn as(p_instance: *LocationProxyClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const LocationProxyPrivate = opaque {};

/// Class structure for `geoclue.LocationSkeleton`.
pub const LocationSkeletonClass = extern struct {
    pub const Instance = geoclue.LocationSkeleton;

    /// The parent class.
    f_parent_class: gio.DBusInterfaceSkeletonClass,

    pub fn as(p_instance: *LocationSkeletonClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const LocationSkeletonPrivate = opaque {};

/// Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
pub const ManagerIface = extern struct {
    pub const Instance = geoclue.Manager;

    /// The parent interface.
    f_parent_iface: gobject.TypeInterface,
    /// Handler for the `geoclue.Manager.signals.handle`-add-agent signal.
    f_handle_add_agent: ?*const fn (p_object: *geoclue.Manager, p_invocation: *gio.DBusMethodInvocation, p_arg_id: [*:0]const u8) callconv(.C) c_int,
    /// Handler for the `geoclue.Manager.signals.handle`-create-client signal.
    f_handle_create_client: ?*const fn (p_object: *geoclue.Manager, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int,
    /// Handler for the `geoclue.Manager.signals.handle`-delete-client signal.
    f_handle_delete_client: ?*const fn (p_object: *geoclue.Manager, p_invocation: *gio.DBusMethodInvocation, p_arg_client: [*:0]const u8) callconv(.C) c_int,
    /// Handler for the `geoclue.Manager.signals.handle`-get-client signal.
    f_handle_get_client: ?*const fn (p_object: *geoclue.Manager, p_invocation: *gio.DBusMethodInvocation) callconv(.C) c_int,
    /// Getter for the `geoclue.Manager.properties.available`-accuracy-level property.
    f_get_available_accuracy_level: ?*const fn (p_object: *geoclue.Manager) callconv(.C) c_uint,
    /// Getter for the `geoclue.Manager.properties.in`-use property.
    f_get_in_use: ?*const fn (p_object: *geoclue.Manager) callconv(.C) c_int,

    pub fn as(p_instance: *ManagerIface, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Class structure for `geoclue.ManagerProxy`.
pub const ManagerProxyClass = extern struct {
    pub const Instance = geoclue.ManagerProxy;

    /// The parent class.
    f_parent_class: gio.DBusProxyClass,

    pub fn as(p_instance: *ManagerProxyClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ManagerProxyPrivate = opaque {};

/// Class structure for `geoclue.ManagerSkeleton`.
pub const ManagerSkeletonClass = extern struct {
    pub const Instance = geoclue.ManagerSkeleton;

    /// The parent class.
    f_parent_class: gio.DBusInterfaceSkeletonClass,

    pub fn as(p_instance: *ManagerSkeletonClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ManagerSkeletonPrivate = opaque {};

pub const SimpleClass = extern struct {
    pub const Instance = geoclue.Simple;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *SimpleClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const SimplePrivate = opaque {};

pub const AccuracyLevel = enum(c_int) {
    none = 0,
    country = 1,
    city = 4,
    neighborhood = 5,
    street = 6,
    exact = 8,
    _,

    extern fn gclue_accuracy_level_get_type() usize;
    pub const getGObjectType = gclue_accuracy_level_get_type;
};

pub const ClientProxyCreateFlags = packed struct(c_uint) {
    auto_delete: bool = false,
    _padding1: bool = false,
    _padding2: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ClientProxyCreateFlags = @bitCast(@as(c_uint, 0));
    const flags_auto_delete: ClientProxyCreateFlags = @bitCast(@as(c_uint, 1));
    extern fn gclue_client_proxy_create_flags_get_type() usize;
    pub const getGObjectType = gclue_client_proxy_create_flags_get_type;
};
