#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 924
#define LARGE_STATE_COUNT 3
#define SYMBOL_COUNT 208
#define ALIAS_COUNT 2
#define TOKEN_COUNT 143
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 26

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_include = 2,
  anon_sym_cpp_include = 3,
  anon_sym_namespace = 4,
  anon_sym_SEMI = 5,
  anon_sym_package = 6,
  anon_sym_STAR = 7,
  anon_sym_as3 = 8,
  anon_sym_c_glib = 9,
  anon_sym_cl = 10,
  anon_sym_cocoa = 11,
  anon_sym_cpp = 12,
  anon_sym_cpp2 = 13,
  anon_sym_cpp_DOTnoexist = 14,
  anon_sym_csharp = 15,
  anon_sym_d = 16,
  anon_sym_dart = 17,
  anon_sym_delphi = 18,
  anon_sym_erl = 19,
  anon_sym_go = 20,
  anon_sym_haxe = 21,
  anon_sym_java = 22,
  anon_sym_javame = 23,
  anon_sym_js = 24,
  anon_sym_kotlin = 25,
  anon_sym_lua = 26,
  anon_sym_netcore = 27,
  anon_sym_netstd = 28,
  anon_sym_nodejs = 29,
  anon_sym_nodets = 30,
  anon_sym_noexist = 31,
  anon_sym_ocaml = 32,
  anon_sym_perl = 33,
  anon_sym_php = 34,
  anon_sym_php_DOTpath = 35,
  anon_sym_py = 36,
  anon_sym_py_DOTtwisted = 37,
  anon_sym_rb = 38,
  anon_sym_rs = 39,
  anon_sym_smalltalk_DOTprefix = 40,
  anon_sym_smalltalk_DOTcategory = 41,
  anon_sym_st = 42,
  anon_sym_swift = 43,
  anon_sym_ts = 44,
  anon_sym_xml = 45,
  anon_sym_xsd = 46,
  anon_sym_cocoa_prefix = 47,
  anon_sym_cpp_namespace = 48,
  anon_sym_csharp_namespace = 49,
  anon_sym_delphi_namespace = 50,
  anon_sym_java_package = 51,
  anon_sym_perl_package = 52,
  anon_sym_php_namespace = 53,
  anon_sym_py_module = 54,
  anon_sym_ruby_namespace = 55,
  anon_sym_smalltalk_category = 56,
  anon_sym_smalltalk_prefix = 57,
  anon_sym_xsd_namespace = 58,
  anon_sym_android = 59,
  anon_sym_hack = 60,
  anon_sym_hack_DOTmodule = 61,
  anon_sym_hs = 62,
  anon_sym_hs2 = 63,
  anon_sym_java_DOTswift = 64,
  anon_sym_java_DOTswift_DOTconstants = 65,
  anon_sym_json = 66,
  anon_sym_py_DOTasyncio = 67,
  anon_sym_py3 = 68,
  anon_sym_rust = 69,
  anon_sym_scala = 70,
  anon_sym_LPAREN = 71,
  anon_sym_uri = 72,
  anon_sym_EQ = 73,
  anon_sym_RPAREN = 74,
  anon_sym_const = 75,
  anon_sym_typedef = 76,
  anon_sym_enum = 77,
  anon_sym_LBRACE = 78,
  anon_sym_RBRACE = 79,
  anon_sym_senum = 80,
  anon_sym_struct = 81,
  anon_sym_xsd_all = 82,
  anon_sym_union = 83,
  anon_sym_exception = 84,
  anon_sym_client = 85,
  anon_sym_permanent = 86,
  anon_sym_server = 87,
  anon_sym_safe = 88,
  anon_sym_stateful = 89,
  anon_sym_transient = 90,
  anon_sym_service = 91,
  anon_sym_extends = 92,
  anon_sym_performs = 93,
  anon_sym_interaction = 94,
  anon_sym_AMP = 95,
  anon_sym_xsd_optional = 96,
  anon_sym_xsd_nillable = 97,
  anon_sym_COLON = 98,
  anon_sym_required = 99,
  anon_sym_optional = 100,
  anon_sym_xsd_attrs = 101,
  anon_sym_COMMA = 102,
  anon_sym_async = 103,
  anon_sym_oneway = 104,
  anon_sym_readonly = 105,
  anon_sym_idempotent = 106,
  anon_sym_throws = 107,
  anon_sym_void = 108,
  anon_sym_binary = 109,
  anon_sym_bool = 110,
  anon_sym_byte = 111,
  anon_sym_i8 = 112,
  anon_sym_i16 = 113,
  anon_sym_i32 = 114,
  anon_sym_i64 = 115,
  anon_sym_float = 116,
  anon_sym_double = 117,
  anon_sym_string = 118,
  anon_sym_slist = 119,
  anon_sym_list = 120,
  anon_sym_LT = 121,
  anon_sym_GT = 122,
  anon_sym_map = 123,
  anon_sym_set = 124,
  anon_sym_sink = 125,
  anon_sym_stream = 126,
  anon_sym_AT = 127,
  sym_number = 128,
  sym_double = 129,
  anon_sym_true = 130,
  anon_sym_false = 131,
  anon_sym_LBRACK = 132,
  anon_sym_RBRACK = 133,
  anon_sym_DQUOTE = 134,
  anon_sym_SQUOTE = 135,
  sym_unescaped_double_string_fragment = 136,
  sym_unescaped_single_string_fragment = 137,
  aux_sym__escape_sequence_token1 = 138,
  sym_escape_sequence = 139,
  aux_sym__identifier_with_dots_token1 = 140,
  anon_sym_DOT = 141,
  sym_comment = 142,
  sym_document = 143,
  sym_header = 144,
  sym_include_statement = 145,
  sym_namespace_declaration = 146,
  sym_package_declaration = 147,
  sym_namespace_scope = 148,
  sym_namespace_uri = 149,
  sym_definition = 150,
  sym_const_definition = 151,
  sym_typedef_definition = 152,
  sym_enum_definition = 153,
  sym_senum_definition = 154,
  sym_struct_definition = 155,
  sym_union_definition = 156,
  sym_exception_definition = 157,
  sym_exception_modifier = 158,
  sym_service_definition = 159,
  sym_interaction_definition = 160,
  sym_field = 161,
  sym_field_id = 162,
  sym_field_modifier = 163,
  sym_xsd_attrs = 164,
  sym_function_definition = 165,
  sym_function_modifier = 166,
  sym_parameters = 167,
  sym_parameter = 168,
  sym_throws = 169,
  sym_type = 170,
  sym_definition_type = 171,
  sym_primitive = 172,
  sym_container_type = 173,
  sym_list = 174,
  sym_map = 175,
  sym_set = 176,
  sym_sink = 177,
  sym_stream = 178,
  sym_annotation_definition = 179,
  sym_fb_annotation_definition = 180,
  sym_literal = 181,
  sym_boolean = 182,
  sym_list_literal = 183,
  sym_map_literal = 184,
  sym_struct_literal = 185,
  sym_string = 186,
  sym__escape_sequence = 187,
  sym__identifier_with_dots = 188,
  sym_annotation_identifier = 189,
  aux_sym_document_repeat1 = 190,
  aux_sym_document_repeat2 = 191,
  aux_sym_package_declaration_repeat1 = 192,
  aux_sym_enum_definition_repeat1 = 193,
  aux_sym_senum_definition_repeat1 = 194,
  aux_sym_struct_definition_repeat1 = 195,
  aux_sym_exception_definition_repeat1 = 196,
  aux_sym_service_definition_repeat1 = 197,
  aux_sym_interaction_definition_repeat1 = 198,
  aux_sym_function_definition_repeat1 = 199,
  aux_sym_parameters_repeat1 = 200,
  aux_sym_annotation_definition_repeat1 = 201,
  aux_sym_fb_annotation_definition_repeat1 = 202,
  aux_sym_list_literal_repeat1 = 203,
  aux_sym_map_literal_repeat1 = 204,
  aux_sym_string_repeat1 = 205,
  aux_sym_string_repeat2 = 206,
  aux_sym__type_identifier_repeat1 = 207,
  alias_sym_namespace = 208,
  alias_sym_typedef_identifier = 209,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_include] = "include",
  [anon_sym_cpp_include] = "cpp_include",
  [anon_sym_namespace] = "namespace",
  [anon_sym_SEMI] = ";",
  [anon_sym_package] = "package",
  [anon_sym_STAR] = "*",
  [anon_sym_as3] = "as3",
  [anon_sym_c_glib] = "c_glib",
  [anon_sym_cl] = "cl",
  [anon_sym_cocoa] = "cocoa",
  [anon_sym_cpp] = "cpp",
  [anon_sym_cpp2] = "cpp2",
  [anon_sym_cpp_DOTnoexist] = "cpp.noexist",
  [anon_sym_csharp] = "csharp",
  [anon_sym_d] = "d",
  [anon_sym_dart] = "dart",
  [anon_sym_delphi] = "delphi",
  [anon_sym_erl] = "erl",
  [anon_sym_go] = "go",
  [anon_sym_haxe] = "haxe",
  [anon_sym_java] = "java",
  [anon_sym_javame] = "javame",
  [anon_sym_js] = "js",
  [anon_sym_kotlin] = "kotlin",
  [anon_sym_lua] = "lua",
  [anon_sym_netcore] = "netcore",
  [anon_sym_netstd] = "netstd",
  [anon_sym_nodejs] = "nodejs",
  [anon_sym_nodets] = "nodets",
  [anon_sym_noexist] = "noexist",
  [anon_sym_ocaml] = "ocaml",
  [anon_sym_perl] = "perl",
  [anon_sym_php] = "php",
  [anon_sym_php_DOTpath] = "php.path",
  [anon_sym_py] = "py",
  [anon_sym_py_DOTtwisted] = "py.twisted",
  [anon_sym_rb] = "rb",
  [anon_sym_rs] = "rs",
  [anon_sym_smalltalk_DOTprefix] = "smalltalk.prefix",
  [anon_sym_smalltalk_DOTcategory] = "smalltalk.category",
  [anon_sym_st] = "st",
  [anon_sym_swift] = "swift",
  [anon_sym_ts] = "ts",
  [anon_sym_xml] = "xml",
  [anon_sym_xsd] = "xsd",
  [anon_sym_cocoa_prefix] = "cocoa_prefix",
  [anon_sym_cpp_namespace] = "cpp_namespace",
  [anon_sym_csharp_namespace] = "csharp_namespace",
  [anon_sym_delphi_namespace] = "delphi_namespace",
  [anon_sym_java_package] = "java_package",
  [anon_sym_perl_package] = "perl_package",
  [anon_sym_php_namespace] = "php_namespace",
  [anon_sym_py_module] = "py_module",
  [anon_sym_ruby_namespace] = "ruby_namespace",
  [anon_sym_smalltalk_category] = "smalltalk_category",
  [anon_sym_smalltalk_prefix] = "smalltalk_prefix",
  [anon_sym_xsd_namespace] = "xsd_namespace",
  [anon_sym_android] = "android",
  [anon_sym_hack] = "hack",
  [anon_sym_hack_DOTmodule] = "hack.module",
  [anon_sym_hs] = "hs",
  [anon_sym_hs2] = "hs2",
  [anon_sym_java_DOTswift] = "java.swift",
  [anon_sym_java_DOTswift_DOTconstants] = "java.swift.constants",
  [anon_sym_json] = "json",
  [anon_sym_py_DOTasyncio] = "py.asyncio",
  [anon_sym_py3] = "py3",
  [anon_sym_rust] = "rust",
  [anon_sym_scala] = "scala",
  [anon_sym_LPAREN] = "(",
  [anon_sym_uri] = "uri",
  [anon_sym_EQ] = "=",
  [anon_sym_RPAREN] = ")",
  [anon_sym_const] = "const",
  [anon_sym_typedef] = "typedef",
  [anon_sym_enum] = "enum",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_senum] = "senum",
  [anon_sym_struct] = "struct",
  [anon_sym_xsd_all] = "xsd_all",
  [anon_sym_union] = "union",
  [anon_sym_exception] = "exception",
  [anon_sym_client] = "client",
  [anon_sym_permanent] = "permanent",
  [anon_sym_server] = "server",
  [anon_sym_safe] = "safe",
  [anon_sym_stateful] = "stateful",
  [anon_sym_transient] = "transient",
  [anon_sym_service] = "service",
  [anon_sym_extends] = "extends",
  [anon_sym_performs] = "performs",
  [anon_sym_interaction] = "interaction",
  [anon_sym_AMP] = "&",
  [anon_sym_xsd_optional] = "xsd_optional",
  [anon_sym_xsd_nillable] = "xsd_nillable",
  [anon_sym_COLON] = ":",
  [anon_sym_required] = "required",
  [anon_sym_optional] = "optional",
  [anon_sym_xsd_attrs] = "xsd_attrs",
  [anon_sym_COMMA] = ",",
  [anon_sym_async] = "async",
  [anon_sym_oneway] = "oneway",
  [anon_sym_readonly] = "readonly",
  [anon_sym_idempotent] = "idempotent",
  [anon_sym_throws] = "throws",
  [anon_sym_void] = "void",
  [anon_sym_binary] = "binary",
  [anon_sym_bool] = "bool",
  [anon_sym_byte] = "byte",
  [anon_sym_i8] = "i8",
  [anon_sym_i16] = "i16",
  [anon_sym_i32] = "i32",
  [anon_sym_i64] = "i64",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [anon_sym_string] = "string",
  [anon_sym_slist] = "slist",
  [anon_sym_list] = "list",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_map] = "map",
  [anon_sym_set] = "set",
  [anon_sym_sink] = "sink",
  [anon_sym_stream] = "stream",
  [anon_sym_AT] = "@",
  [sym_number] = "number",
  [sym_double] = "double",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [aux_sym__identifier_with_dots_token1] = "identifier",
  [anon_sym_DOT] = ".",
  [sym_comment] = "comment",
  [sym_document] = "document",
  [sym_header] = "header",
  [sym_include_statement] = "include_statement",
  [sym_namespace_declaration] = "namespace_declaration",
  [sym_package_declaration] = "package_declaration",
  [sym_namespace_scope] = "namespace_scope",
  [sym_namespace_uri] = "namespace_uri",
  [sym_definition] = "definition",
  [sym_const_definition] = "const_definition",
  [sym_typedef_definition] = "typedef_definition",
  [sym_enum_definition] = "enum_definition",
  [sym_senum_definition] = "senum_definition",
  [sym_struct_definition] = "struct_definition",
  [sym_union_definition] = "union_definition",
  [sym_exception_definition] = "exception_definition",
  [sym_exception_modifier] = "exception_modifier",
  [sym_service_definition] = "service_definition",
  [sym_interaction_definition] = "interaction_definition",
  [sym_field] = "field",
  [sym_field_id] = "field_id",
  [sym_field_modifier] = "field_modifier",
  [sym_xsd_attrs] = "xsd_attrs",
  [sym_function_definition] = "function_definition",
  [sym_function_modifier] = "function_modifier",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym_throws] = "throws",
  [sym_type] = "type",
  [sym_definition_type] = "definition_type",
  [sym_primitive] = "primitive",
  [sym_container_type] = "container_type",
  [sym_list] = "list",
  [sym_map] = "map",
  [sym_set] = "set",
  [sym_sink] = "sink",
  [sym_stream] = "stream",
  [sym_annotation_definition] = "annotation_definition",
  [sym_fb_annotation_definition] = "fb_annotation_definition",
  [sym_literal] = "literal",
  [sym_boolean] = "boolean",
  [sym_list_literal] = "list_literal",
  [sym_map_literal] = "map_literal",
  [sym_struct_literal] = "struct_literal",
  [sym_string] = "string",
  [sym__escape_sequence] = "_escape_sequence",
  [sym__identifier_with_dots] = "_identifier_with_dots",
  [sym_annotation_identifier] = "annotation_identifier",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_document_repeat2] = "document_repeat2",
  [aux_sym_package_declaration_repeat1] = "package_declaration_repeat1",
  [aux_sym_enum_definition_repeat1] = "enum_definition_repeat1",
  [aux_sym_senum_definition_repeat1] = "senum_definition_repeat1",
  [aux_sym_struct_definition_repeat1] = "struct_definition_repeat1",
  [aux_sym_exception_definition_repeat1] = "exception_definition_repeat1",
  [aux_sym_service_definition_repeat1] = "service_definition_repeat1",
  [aux_sym_interaction_definition_repeat1] = "interaction_definition_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_annotation_definition_repeat1] = "annotation_definition_repeat1",
  [aux_sym_fb_annotation_definition_repeat1] = "fb_annotation_definition_repeat1",
  [aux_sym_list_literal_repeat1] = "list_literal_repeat1",
  [aux_sym_map_literal_repeat1] = "map_literal_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym__type_identifier_repeat1] = "_type_identifier_repeat1",
  [alias_sym_namespace] = "namespace",
  [alias_sym_typedef_identifier] = "typedef_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_cpp_include] = anon_sym_cpp_include,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_as3] = anon_sym_as3,
  [anon_sym_c_glib] = anon_sym_c_glib,
  [anon_sym_cl] = anon_sym_cl,
  [anon_sym_cocoa] = anon_sym_cocoa,
  [anon_sym_cpp] = anon_sym_cpp,
  [anon_sym_cpp2] = anon_sym_cpp2,
  [anon_sym_cpp_DOTnoexist] = anon_sym_cpp_DOTnoexist,
  [anon_sym_csharp] = anon_sym_csharp,
  [anon_sym_d] = anon_sym_d,
  [anon_sym_dart] = anon_sym_dart,
  [anon_sym_delphi] = anon_sym_delphi,
  [anon_sym_erl] = anon_sym_erl,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_haxe] = anon_sym_haxe,
  [anon_sym_java] = anon_sym_java,
  [anon_sym_javame] = anon_sym_javame,
  [anon_sym_js] = anon_sym_js,
  [anon_sym_kotlin] = anon_sym_kotlin,
  [anon_sym_lua] = anon_sym_lua,
  [anon_sym_netcore] = anon_sym_netcore,
  [anon_sym_netstd] = anon_sym_netstd,
  [anon_sym_nodejs] = anon_sym_nodejs,
  [anon_sym_nodets] = anon_sym_nodets,
  [anon_sym_noexist] = anon_sym_noexist,
  [anon_sym_ocaml] = anon_sym_ocaml,
  [anon_sym_perl] = anon_sym_perl,
  [anon_sym_php] = anon_sym_php,
  [anon_sym_php_DOTpath] = anon_sym_php_DOTpath,
  [anon_sym_py] = anon_sym_py,
  [anon_sym_py_DOTtwisted] = anon_sym_py_DOTtwisted,
  [anon_sym_rb] = anon_sym_rb,
  [anon_sym_rs] = anon_sym_rs,
  [anon_sym_smalltalk_DOTprefix] = anon_sym_smalltalk_DOTprefix,
  [anon_sym_smalltalk_DOTcategory] = anon_sym_smalltalk_DOTcategory,
  [anon_sym_st] = anon_sym_st,
  [anon_sym_swift] = anon_sym_swift,
  [anon_sym_ts] = anon_sym_ts,
  [anon_sym_xml] = anon_sym_xml,
  [anon_sym_xsd] = anon_sym_xsd,
  [anon_sym_cocoa_prefix] = anon_sym_cocoa_prefix,
  [anon_sym_cpp_namespace] = anon_sym_cpp_namespace,
  [anon_sym_csharp_namespace] = anon_sym_csharp_namespace,
  [anon_sym_delphi_namespace] = anon_sym_delphi_namespace,
  [anon_sym_java_package] = anon_sym_java_package,
  [anon_sym_perl_package] = anon_sym_perl_package,
  [anon_sym_php_namespace] = anon_sym_php_namespace,
  [anon_sym_py_module] = anon_sym_py_module,
  [anon_sym_ruby_namespace] = anon_sym_ruby_namespace,
  [anon_sym_smalltalk_category] = anon_sym_smalltalk_category,
  [anon_sym_smalltalk_prefix] = anon_sym_smalltalk_prefix,
  [anon_sym_xsd_namespace] = anon_sym_xsd_namespace,
  [anon_sym_android] = anon_sym_android,
  [anon_sym_hack] = anon_sym_hack,
  [anon_sym_hack_DOTmodule] = anon_sym_hack_DOTmodule,
  [anon_sym_hs] = anon_sym_hs,
  [anon_sym_hs2] = anon_sym_hs2,
  [anon_sym_java_DOTswift] = anon_sym_java_DOTswift,
  [anon_sym_java_DOTswift_DOTconstants] = anon_sym_java_DOTswift_DOTconstants,
  [anon_sym_json] = anon_sym_json,
  [anon_sym_py_DOTasyncio] = anon_sym_py_DOTasyncio,
  [anon_sym_py3] = anon_sym_py3,
  [anon_sym_rust] = anon_sym_rust,
  [anon_sym_scala] = anon_sym_scala,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_uri] = anon_sym_uri,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_senum] = anon_sym_senum,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_xsd_all] = anon_sym_xsd_all,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_exception] = anon_sym_exception,
  [anon_sym_client] = anon_sym_client,
  [anon_sym_permanent] = anon_sym_permanent,
  [anon_sym_server] = anon_sym_server,
  [anon_sym_safe] = anon_sym_safe,
  [anon_sym_stateful] = anon_sym_stateful,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_service] = anon_sym_service,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_performs] = anon_sym_performs,
  [anon_sym_interaction] = anon_sym_interaction,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_xsd_optional] = anon_sym_xsd_optional,
  [anon_sym_xsd_nillable] = anon_sym_xsd_nillable,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_optional] = anon_sym_optional,
  [anon_sym_xsd_attrs] = anon_sym_xsd_attrs,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_oneway] = anon_sym_oneway,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_idempotent] = anon_sym_idempotent,
  [anon_sym_throws] = anon_sym_throws,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_i8] = anon_sym_i8,
  [anon_sym_i16] = anon_sym_i16,
  [anon_sym_i32] = anon_sym_i32,
  [anon_sym_i64] = anon_sym_i64,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_slist] = anon_sym_slist,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_sink] = anon_sym_sink,
  [anon_sym_stream] = anon_sym_stream,
  [anon_sym_AT] = anon_sym_AT,
  [sym_number] = sym_number,
  [sym_double] = sym_double,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [aux_sym__identifier_with_dots_token1] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_comment] = sym_comment,
  [sym_document] = sym_document,
  [sym_header] = sym_header,
  [sym_include_statement] = sym_include_statement,
  [sym_namespace_declaration] = sym_namespace_declaration,
  [sym_package_declaration] = sym_package_declaration,
  [sym_namespace_scope] = sym_namespace_scope,
  [sym_namespace_uri] = sym_namespace_uri,
  [sym_definition] = sym_definition,
  [sym_const_definition] = sym_const_definition,
  [sym_typedef_definition] = sym_typedef_definition,
  [sym_enum_definition] = sym_enum_definition,
  [sym_senum_definition] = sym_senum_definition,
  [sym_struct_definition] = sym_struct_definition,
  [sym_union_definition] = sym_union_definition,
  [sym_exception_definition] = sym_exception_definition,
  [sym_exception_modifier] = sym_exception_modifier,
  [sym_service_definition] = sym_service_definition,
  [sym_interaction_definition] = sym_interaction_definition,
  [sym_field] = sym_field,
  [sym_field_id] = sym_field_id,
  [sym_field_modifier] = sym_field_modifier,
  [sym_xsd_attrs] = sym_xsd_attrs,
  [sym_function_definition] = sym_function_definition,
  [sym_function_modifier] = sym_function_modifier,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym_throws] = sym_throws,
  [sym_type] = sym_type,
  [sym_definition_type] = sym_definition_type,
  [sym_primitive] = sym_primitive,
  [sym_container_type] = sym_container_type,
  [sym_list] = sym_list,
  [sym_map] = sym_map,
  [sym_set] = sym_set,
  [sym_sink] = sym_sink,
  [sym_stream] = sym_stream,
  [sym_annotation_definition] = sym_annotation_definition,
  [sym_fb_annotation_definition] = sym_fb_annotation_definition,
  [sym_literal] = sym_literal,
  [sym_boolean] = sym_boolean,
  [sym_list_literal] = sym_list_literal,
  [sym_map_literal] = sym_map_literal,
  [sym_struct_literal] = sym_struct_literal,
  [sym_string] = sym_string,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym__identifier_with_dots] = sym__identifier_with_dots,
  [sym_annotation_identifier] = sym_annotation_identifier,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_document_repeat2] = aux_sym_document_repeat2,
  [aux_sym_package_declaration_repeat1] = aux_sym_package_declaration_repeat1,
  [aux_sym_enum_definition_repeat1] = aux_sym_enum_definition_repeat1,
  [aux_sym_senum_definition_repeat1] = aux_sym_senum_definition_repeat1,
  [aux_sym_struct_definition_repeat1] = aux_sym_struct_definition_repeat1,
  [aux_sym_exception_definition_repeat1] = aux_sym_exception_definition_repeat1,
  [aux_sym_service_definition_repeat1] = aux_sym_service_definition_repeat1,
  [aux_sym_interaction_definition_repeat1] = aux_sym_interaction_definition_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_annotation_definition_repeat1] = aux_sym_annotation_definition_repeat1,
  [aux_sym_fb_annotation_definition_repeat1] = aux_sym_fb_annotation_definition_repeat1,
  [aux_sym_list_literal_repeat1] = aux_sym_list_literal_repeat1,
  [aux_sym_map_literal_repeat1] = aux_sym_map_literal_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym__type_identifier_repeat1] = aux_sym__type_identifier_repeat1,
  [alias_sym_namespace] = alias_sym_namespace,
  [alias_sym_typedef_identifier] = alias_sym_typedef_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cpp_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_c_glib] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cocoa] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cpp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cpp2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cpp_DOTnoexist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_csharp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delphi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_haxe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_java] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javame] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_js] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_kotlin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lua] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_netcore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_netstd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nodejs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nodets] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noexist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ocaml] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_perl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_php] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_php_DOTpath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_py] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_py_DOTtwisted] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smalltalk_DOTprefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smalltalk_DOTcategory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_st] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_swift] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xml] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xsd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cocoa_prefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cpp_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_csharp_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delphi_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_java_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_perl_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_php_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_py_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ruby_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smalltalk_category] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smalltalk_prefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xsd_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_android] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hack] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hack_DOTmodule] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hs2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_java_DOTswift] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_java_DOTswift_DOTconstants] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_json] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_py_DOTasyncio] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_py3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rust] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_scala] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_senum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xsd_all] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exception] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_client] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_permanent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_server] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_safe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stateful] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_service] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_performs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interaction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xsd_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xsd_nillable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xsd_attrs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_oneway] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_idempotent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_slist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sink] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stream] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_double] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__identifier_with_dots_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_header] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_scope] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_definition] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_const_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_typedef_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_senum_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_union_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_exception_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_exception_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_service_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_interaction_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_field_id] = {
    .visible = true,
    .named = true,
  },
  [sym_field_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_xsd_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive] = {
    .visible = true,
    .named = true,
  },
  [sym_container_type] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_map] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_sink] = {
    .visible = true,
    .named = true,
  },
  [sym_stream] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_fb_annotation_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_list_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_map_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier_with_dots] = {
    .visible = false,
    .named = true,
  },
  [sym_annotation_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_document_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_package_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_senum_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exception_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_service_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interaction_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fb_annotation_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_map_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_namespace] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_typedef_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_type = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_type] = "type",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 2},
  [8] = {.index = 5, .length = 2},
  [10] = {.index = 1, .length = 1},
  [11] = {.index = 7, .length = 2},
  [12] = {.index = 9, .length = 2},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 3},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 18, .length = 2},
  [17] = {.index = 20, .length = 2},
  [18] = {.index = 22, .length = 3},
  [19] = {.index = 25, .length = 3},
  [20] = {.index = 28, .length = 3},
  [21] = {.index = 31, .length = 2},
  [22] = {.index = 33, .length = 3},
  [23] = {.index = 36, .length = 3},
  [24] = {.index = 39, .length = 3},
  [25] = {.index = 42, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type, 0},
  [1] =
    {field_type, 2},
  [2] =
    {field_type, 1},
  [3] =
    {field_type, 1},
    {field_type, 3, .inherited = true},
  [5] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [7] =
    {field_type, 1},
    {field_type, 3},
  [9] =
    {field_type, 1},
    {field_type, 4, .inherited = true},
  [11] =
    {field_type, 2},
    {field_type, 4, .inherited = true},
  [13] =
    {field_type, 1},
    {field_type, 3},
    {field_type, 5, .inherited = true},
  [16] =
    {field_type, 1},
    {field_type, 4},
  [18] =
    {field_type, 2},
    {field_type, 4},
  [20] =
    {field_type, 2},
    {field_type, 5, .inherited = true},
  [22] =
    {field_type, 1},
    {field_type, 3},
    {field_type, 6, .inherited = true},
  [25] =
    {field_type, 1},
    {field_type, 4},
    {field_type, 6, .inherited = true},
  [28] =
    {field_type, 2},
    {field_type, 4},
    {field_type, 6, .inherited = true},
  [31] =
    {field_type, 2},
    {field_type, 5},
  [33] =
    {field_type, 1},
    {field_type, 4},
    {field_type, 7, .inherited = true},
  [36] =
    {field_type, 2},
    {field_type, 4},
    {field_type, 7, .inherited = true},
  [39] =
    {field_type, 2},
    {field_type, 5},
    {field_type, 7, .inherited = true},
  [42] =
    {field_type, 2},
    {field_type, 5},
    {field_type, 8, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [2] = alias_sym_namespace,
  },
  [3] = {
    [2] = alias_sym_typedef_identifier,
  },
  [4] = {
    [2] = alias_sym_namespace,
    [3] = alias_sym_namespace,
  },
  [5] = {
    [3] = alias_sym_typedef_identifier,
  },
  [9] = {
    [4] = alias_sym_typedef_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 100,
  [133] = 133,
  [134] = 134,
  [135] = 90,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 3,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 4,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 210,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 208,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 216,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 217,
  [227] = 227,
  [228] = 221,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 225,
  [233] = 206,
  [234] = 212,
  [235] = 222,
  [236] = 236,
  [237] = 218,
  [238] = 238,
  [239] = 239,
  [240] = 229,
  [241] = 207,
  [242] = 213,
  [243] = 243,
  [244] = 244,
  [245] = 218,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 88,
  [293] = 293,
  [294] = 87,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 139,
  [305] = 140,
  [306] = 306,
  [307] = 142,
  [308] = 148,
  [309] = 141,
  [310] = 146,
  [311] = 143,
  [312] = 312,
  [313] = 313,
  [314] = 147,
  [315] = 315,
  [316] = 122,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 82,
  [352] = 83,
  [353] = 353,
  [354] = 80,
  [355] = 355,
  [356] = 356,
  [357] = 79,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 78,
  [362] = 81,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 433,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 431,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 438,
  [452] = 452,
  [453] = 434,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 438,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 431,
  [464] = 434,
  [465] = 433,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 485,
  [488] = 88,
  [489] = 489,
  [490] = 87,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 3,
  [498] = 485,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 100,
  [504] = 90,
  [505] = 4,
  [506] = 140,
  [507] = 139,
  [508] = 146,
  [509] = 141,
  [510] = 122,
  [511] = 148,
  [512] = 143,
  [513] = 147,
  [514] = 142,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 78,
  [520] = 82,
  [521] = 521,
  [522] = 81,
  [523] = 523,
  [524] = 524,
  [525] = 83,
  [526] = 80,
  [527] = 79,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 3,
  [536] = 529,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 531,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 529,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 531,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 539,
  [559] = 4,
  [560] = 560,
  [561] = 561,
  [562] = 551,
  [563] = 563,
  [564] = 539,
  [565] = 556,
  [566] = 566,
  [567] = 557,
  [568] = 560,
  [569] = 563,
  [570] = 556,
  [571] = 571,
  [572] = 572,
  [573] = 551,
  [574] = 574,
  [575] = 88,
  [576] = 87,
  [577] = 88,
  [578] = 87,
  [579] = 557,
  [580] = 560,
  [581] = 563,
  [582] = 582,
  [583] = 563,
  [584] = 557,
  [585] = 560,
  [586] = 556,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 541,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 594,
  [605] = 600,
  [606] = 606,
  [607] = 6,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 549,
  [613] = 613,
  [614] = 614,
  [615] = 5,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 603,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 614,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 574,
  [647] = 647,
  [648] = 648,
  [649] = 561,
  [650] = 582,
  [651] = 555,
  [652] = 640,
  [653] = 566,
  [654] = 654,
  [655] = 553,
  [656] = 656,
  [657] = 554,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 7,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 645,
  [668] = 668,
  [669] = 645,
  [670] = 643,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 679,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 703,
  [706] = 706,
  [707] = 706,
  [708] = 708,
  [709] = 709,
  [710] = 701,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 681,
  [715] = 684,
  [716] = 716,
  [717] = 717,
  [718] = 679,
  [719] = 719,
  [720] = 720,
  [721] = 593,
  [722] = 609,
  [723] = 685,
  [724] = 619,
  [725] = 725,
  [726] = 8,
  [727] = 727,
  [728] = 713,
  [729] = 689,
  [730] = 691,
  [731] = 691,
  [732] = 692,
  [733] = 692,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 610,
  [739] = 739,
  [740] = 740,
  [741] = 689,
  [742] = 742,
  [743] = 693,
  [744] = 696,
  [745] = 635,
  [746] = 746,
  [747] = 618,
  [748] = 748,
  [749] = 590,
  [750] = 750,
  [751] = 751,
  [752] = 699,
  [753] = 753,
  [754] = 633,
  [755] = 755,
  [756] = 687,
  [757] = 636,
  [758] = 735,
  [759] = 634,
  [760] = 760,
  [761] = 761,
  [762] = 701,
  [763] = 703,
  [764] = 592,
  [765] = 591,
  [766] = 766,
  [767] = 588,
  [768] = 589,
  [769] = 769,
  [770] = 770,
  [771] = 626,
  [772] = 686,
  [773] = 624,
  [774] = 736,
  [775] = 678,
  [776] = 608,
  [777] = 777,
  [778] = 620,
  [779] = 639,
  [780] = 638,
  [781] = 90,
  [782] = 100,
  [783] = 693,
  [784] = 784,
  [785] = 760,
  [786] = 786,
  [787] = 682,
  [788] = 696,
  [789] = 789,
  [790] = 777,
  [791] = 690,
  [792] = 683,
  [793] = 681,
  [794] = 794,
  [795] = 684,
  [796] = 716,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 717,
  [801] = 699,
  [802] = 802,
  [803] = 706,
  [804] = 697,
  [805] = 687,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 812,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 11,
  [822] = 822,
  [823] = 823,
  [824] = 10,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 844,
  [858] = 849,
  [859] = 859,
  [860] = 860,
  [861] = 852,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 867,
  [869] = 869,
  [870] = 867,
  [871] = 871,
  [872] = 872,
  [873] = 831,
  [874] = 843,
  [875] = 839,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 830,
  [886] = 860,
  [887] = 887,
  [888] = 829,
  [889] = 867,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 829,
  [896] = 850,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 845,
  [904] = 854,
  [905] = 905,
  [906] = 828,
  [907] = 907,
  [908] = 866,
  [909] = 909,
  [910] = 910,
  [911] = 887,
  [912] = 912,
  [913] = 882,
  [914] = 914,
  [915] = 833,
  [916] = 865,
  [917] = 854,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 827,
  [923] = 825,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(87);
      ADVANCE_MAP(
        '"', 125,
        '#', 168,
        '&', 109,
        '\'', 126,
        '(', 104,
        ')', 106,
        '*', 89,
        ',', 111,
        '.', 166,
        '/', 6,
        '0', 115,
        ':', 110,
        ';', 88,
        '<', 112,
        '=', 105,
        '>', 113,
        '@', 114,
        '[', 123,
        '\\', 11,
        ']', 124,
        'c', 160,
        'h', 145,
        'j', 146,
        'p', 151,
        's', 157,
        '{', 107,
        '}', 108,
        '+', 9,
        '-', 9,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(85);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(116);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 1:
      if (lookahead == '\r') ADVANCE(169);
      if (lookahead != 0) ADVANCE(168);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 125,
        '#', 168,
        '&', 109,
        '\'', 126,
        '(', 104,
        ',', 111,
        '.', 165,
        '/', 6,
        ';', 88,
        '=', 105,
        '@', 114,
        '{', 107,
        '}', 108,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(164);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '"', 125,
        '#', 168,
        '\'', 126,
        '(', 104,
        ',', 111,
        '.', 166,
        '/', 6,
        '0', 115,
        ';', 88,
        '[', 123,
        ']', 124,
        '{', 107,
        '}', 108,
        '+', 9,
        '-', 9,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(116);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(125);
      if (lookahead == '#') ADVANCE(127);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == '\\') ADVANCE(11);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(128);
      if (lookahead != 0) ADVANCE(132);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(133);
      if (lookahead == '\'') ADVANCE(126);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == '\\') ADVANCE(11);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(134);
      if (lookahead != 0) ADVANCE(138);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(7);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(7);
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '0') ADVANCE(115);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(116);
      END_STATE();
    case 10:
      if (lookahead == '0') ADVANCE(117);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 11:
      if (lookahead == 'U') ADVANCE(141);
      if (lookahead == 'u') ADVANCE(69);
      if (lookahead == 'x') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '?' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(142);
      if (lookahead != 0) ADVANCE(139);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(39);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 16:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(45);
      END_STATE();
    case 18:
      if (lookahead == 'c') ADVANCE(15);
      if (lookahead == 'p') ADVANCE(48);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(62);
      END_STATE();
    case 20:
      if (lookahead == 'd') ADVANCE(96);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 26:
      if (lookahead == 'f') ADVANCE(56);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(31);
      END_STATE();
    case 28:
      if (lookahead == 'g') ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == 'h') ADVANCE(94);
      END_STATE();
    case 30:
      if (lookahead == 'i') ADVANCE(26);
      END_STATE();
    case 31:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 32:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 33:
      if (lookahead == 'i') ADVANCE(43);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(22);
      END_STATE();
    case 36:
      if (lookahead == 'm') ADVANCE(42);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(16);
      END_STATE();
    case 39:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 41:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 44:
      if (lookahead == 'o') ADVANCE(47);
      END_STATE();
    case 45:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 46:
      if (lookahead == 'p') ADVANCE(13);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 48:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(68);
      END_STATE();
    case 50:
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 51:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 52:
      if (lookahead == 's') ADVANCE(57);
      END_STATE();
    case 53:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 56:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(14);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(24);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(23);
      END_STATE();
    case 62:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 63:
      if (lookahead == 'w') ADVANCE(32);
      END_STATE();
    case 64:
      if (lookahead == 'w') ADVANCE(30);
      END_STATE();
    case 65:
      if (lookahead == 'x') ADVANCE(97);
      END_STATE();
    case 66:
      if (lookahead == 'x') ADVANCE(34);
      END_STATE();
    case 67:
      if (lookahead == 'y') ADVANCE(98);
      END_STATE();
    case 68:
      if (lookahead == 'y') ADVANCE(38);
      END_STATE();
    case 69:
      if (lookahead == '{') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 70:
      if (lookahead == '}') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      END_STATE();
    case 72:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(118);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 77:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 78:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 79:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 80:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      END_STATE();
    case 81:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 82:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 83:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 84:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 85:
      if (eof) ADVANCE(87);
      ADVANCE_MAP(
        '"', 125,
        '#', 168,
        '&', 109,
        '\'', 126,
        '(', 104,
        ')', 106,
        '*', 89,
        ',', 111,
        '.', 166,
        '/', 6,
        '0', 115,
        ':', 110,
        ';', 88,
        '<', 112,
        '=', 105,
        '>', 113,
        '@', 114,
        '[', 123,
        ']', 124,
        'c', 160,
        'h', 145,
        'j', 146,
        'p', 151,
        's', 157,
        '{', 107,
        '}', 108,
        '+', 9,
        '-', 9,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(85);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(116);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 86:
      if (eof) ADVANCE(87);
      ADVANCE_MAP(
        '"', 125,
        '#', 168,
        '\'', 126,
        '(', 104,
        ')', 106,
        ',', 111,
        '.', 165,
        '/', 6,
        '0', 117,
        ':', 110,
        ';', 88,
        '<', 112,
        '=', 105,
        '>', 113,
        '@', 114,
        '{', 107,
        '}', 108,
        '+', 10,
        '-', 10,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(86);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(120);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_cpp);
      if (lookahead == '.') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_cpp_DOTnoexist);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_java);
      if (lookahead == '.') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_php);
      if (lookahead == '.') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_php_DOTpath);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_py);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_py_DOTtwisted);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_smalltalk_DOTprefix);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_smalltalk_DOTcategory);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_hack);
      if (lookahead == '.') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_hack_DOTmodule);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_java_DOTswift);
      if (lookahead == '.') ADVANCE(17);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_java_DOTswift_DOTconstants);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_py_DOTasyncio);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 73,
        '0', 116,
        '_', 74,
        'B', 72,
        'b', 72,
        'E', 71,
        'e', 71,
        'X', 77,
        'x', 77,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(116);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '_') ADVANCE(74);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0') ADVANCE(120);
      if (lookahead == '_') ADVANCE(74);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(72);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(77);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(72);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(118);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_double);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_double);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '#') ADVANCE(127);
      if (lookahead == '/') ADVANCE(129);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(128);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\') ADVANCE(132);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(131);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(132);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(130);
      if (lookahead == '/') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(131);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(130);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(131);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(132);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '#') ADVANCE(133);
      if (lookahead == '/') ADVANCE(135);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(134);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(138);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(138);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(142);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(159);
      if (lookahead == 'y') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym__identifier_with_dots_token1);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(164);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0) ADVANCE(168);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'h', 8,
        'i', 9,
        'j', 10,
        'k', 11,
        'l', 12,
        'm', 13,
        'n', 14,
        'o', 15,
        'p', 16,
        'r', 17,
        's', 18,
        't', 19,
        'u', 20,
        'v', 21,
        'x', 22,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      END_STATE();
    case 2:
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'y') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'p') ADVANCE(31);
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_d);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'e') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(36);
      if (lookahead == 'r') ADVANCE(37);
      if (lookahead == 'x') ADVANCE(38);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(39);
      if (lookahead == 'l') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 9:
      if (lookahead == '1') ADVANCE(44);
      if (lookahead == '3') ADVANCE(45);
      if (lookahead == '6') ADVANCE(46);
      if (lookahead == '8') ADVANCE(47);
      if (lookahead == 'd') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 's') ADVANCE(51);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 12:
      if (lookahead == 'i') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 15:
      if (lookahead == 'c') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead == 'p') ADVANCE(61);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'e') ADVANCE(63);
      if (lookahead == 'h') ADVANCE(64);
      if (lookahead == 'y') ADVANCE(65);
      END_STATE();
    case 17:
      if (lookahead == 'b') ADVANCE(66);
      if (lookahead == 'e') ADVANCE(67);
      if (lookahead == 's') ADVANCE(68);
      if (lookahead == 'u') ADVANCE(69);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        'a', 70,
        'c', 71,
        'e', 72,
        'i', 73,
        'l', 74,
        'm', 75,
        't', 76,
        'w', 77,
      );
      END_STATE();
    case 19:
      if (lookahead == 'h') ADVANCE(78);
      if (lookahead == 'r') ADVANCE(79);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == 'y') ADVANCE(81);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 22:
      if (lookahead == 'm') ADVANCE(85);
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 23:
      if (lookahead == 'd') ADVANCE(87);
      END_STATE();
    case 24:
      if (lookahead == '3') ADVANCE(88);
      if (lookahead == 'y') ADVANCE(89);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(91);
      END_STATE();
    case 27:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 28:
      if (lookahead == 'g') ADVANCE(93);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_cl);
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 31:
      if (lookahead == 'p') ADVANCE(97);
      END_STATE();
    case 32:
      if (lookahead == 'h') ADVANCE(98);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(100);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(101);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(102);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(103);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(106);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_go);
      END_STATE();
    case 42:
      if (lookahead == 'x') ADVANCE(108);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_hs);
      if (lookahead == '2') ADVANCE(109);
      END_STATE();
    case 44:
      if (lookahead == '6') ADVANCE(110);
      END_STATE();
    case 45:
      if (lookahead == '2') ADVANCE(111);
      END_STATE();
    case 46:
      if (lookahead == '4') ADVANCE(112);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 49:
      if (lookahead == 'c') ADVANCE(114);
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 50:
      if (lookahead == 'v') ADVANCE(116);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_js);
      if (lookahead == 'o') ADVANCE(117);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 53:
      if (lookahead == 's') ADVANCE(119);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 55:
      if (lookahead == 'p') ADVANCE(121);
      END_STATE();
    case 56:
      if (lookahead == 'm') ADVANCE(122);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 58:
      if (lookahead == 'd') ADVANCE(124);
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(126);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(128);
      END_STATE();
    case 62:
      if (lookahead == 'c') ADVANCE(129);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(131);
      END_STATE();
    case 65:
      if (lookahead == '3') ADVANCE(132);
      if (lookahead == '_') ADVANCE(133);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_rb);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(134);
      if (lookahead == 'q') ADVANCE(135);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_rs);
      END_STATE();
    case 69:
      if (lookahead == 'b') ADVANCE(136);
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'f') ADVANCE(138);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(140);
      if (lookahead == 'r') ADVANCE(141);
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(145);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_st);
      if (lookahead == 'a') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(150);
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_ts);
      END_STATE();
    case 81:
      if (lookahead == 'p') ADVANCE(152);
      END_STATE();
    case 82:
      if (lookahead == 'i') ADVANCE(153);
      END_STATE();
    case 83:
      if (lookahead == 'i') ADVANCE(154);
      END_STATE();
    case 84:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(156);
      END_STATE();
    case 86:
      if (lookahead == 'd') ADVANCE(157);
      END_STATE();
    case 87:
      if (lookahead == 'r') ADVANCE(158);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_as3);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(159);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 93:
      if (lookahead == 'l') ADVANCE(163);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 95:
      if (lookahead == 'o') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(166);
      END_STATE();
    case 97:
      if (lookahead == '2') ADVANCE(167);
      if (lookahead == '_') ADVANCE(168);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(169);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 100:
      if (lookahead == 'p') ADVANCE(171);
      END_STATE();
    case 101:
      if (lookahead == 'b') ADVANCE(172);
      END_STATE();
    case 102:
      if (lookahead == 'm') ADVANCE(173);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_erl);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(176);
      END_STATE();
    case 107:
      if (lookahead == 'a') ADVANCE(177);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_hs2);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_i16);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_i32);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_i64);
      END_STATE();
    case 113:
      if (lookahead == 'm') ADVANCE(179);
      END_STATE();
    case 114:
      if (lookahead == 'l') ADVANCE(180);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 118:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_lua);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 123:
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 125:
      if (lookahead == 'x') ADVANCE(190);
      END_STATE();
    case 126:
      if (lookahead == 'm') ADVANCE(191);
      END_STATE();
    case 127:
      if (lookahead == 'w') ADVANCE(192);
      END_STATE();
    case 128:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 129:
      if (lookahead == 'k') ADVANCE(194);
      END_STATE();
    case 130:
      if (lookahead == 'f') ADVANCE(195);
      if (lookahead == 'l') ADVANCE(196);
      if (lookahead == 'm') ADVANCE(197);
      END_STATE();
    case 131:
      if (lookahead == '_') ADVANCE(198);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_py3);
      END_STATE();
    case 133:
      if (lookahead == 'm') ADVANCE(199);
      END_STATE();
    case 134:
      if (lookahead == 'd') ADVANCE(200);
      END_STATE();
    case 135:
      if (lookahead == 'u') ADVANCE(201);
      END_STATE();
    case 136:
      if (lookahead == 'y') ADVANCE(202);
      END_STATE();
    case 137:
      if (lookahead == 't') ADVANCE(203);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 139:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 140:
      if (lookahead == 'u') ADVANCE(206);
      END_STATE();
    case 141:
      if (lookahead == 'v') ADVANCE(207);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 143:
      if (lookahead == 'k') ADVANCE(208);
      END_STATE();
    case 144:
      if (lookahead == 's') ADVANCE(209);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(210);
      END_STATE();
    case 146:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(212);
      if (lookahead == 'i') ADVANCE(213);
      if (lookahead == 'u') ADVANCE(214);
      END_STATE();
    case 148:
      if (lookahead == 'f') ADVANCE(215);
      END_STATE();
    case 149:
      if (lookahead == 'o') ADVANCE(216);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(217);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(220);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_uri);
      END_STATE();
    case 155:
      if (lookahead == 'd') ADVANCE(221);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_xml);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_xsd);
      if (lookahead == '_') ADVANCE(222);
      END_STATE();
    case 158:
      if (lookahead == 'o') ADVANCE(223);
      END_STATE();
    case 159:
      if (lookahead == 'c') ADVANCE(224);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 163:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 164:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(228);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_cpp2);
      END_STATE();
    case 168:
      if (lookahead == 'i') ADVANCE(230);
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 169:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_dart);
      END_STATE();
    case 171:
      if (lookahead == 'h') ADVANCE(233);
      END_STATE();
    case 172:
      if (lookahead == 'l') ADVANCE(234);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 174:
      if (lookahead == 'p') ADVANCE(235);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(236);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(237);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(238);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_haxe);
      END_STATE();
    case 179:
      if (lookahead == 'p') ADVANCE(239);
      END_STATE();
    case 180:
      if (lookahead == 'u') ADVANCE(240);
      END_STATE();
    case 181:
      if (lookahead == 'r') ADVANCE(241);
      END_STATE();
    case 182:
      if (lookahead == '_') ADVANCE(242);
      if (lookahead == 'm') ADVANCE(243);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_json);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(244);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 186:
      if (lookahead == 's') ADVANCE(245);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(246);
      END_STATE();
    case 188:
      if (lookahead == 't') ADVANCE(247);
      END_STATE();
    case 189:
      if (lookahead == 'j') ADVANCE(248);
      if (lookahead == 't') ADVANCE(249);
      END_STATE();
    case 190:
      if (lookahead == 'i') ADVANCE(250);
      END_STATE();
    case 191:
      if (lookahead == 'l') ADVANCE(251);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(252);
      END_STATE();
    case 193:
      if (lookahead == 'o') ADVANCE(253);
      END_STATE();
    case 194:
      if (lookahead == 'a') ADVANCE(254);
      END_STATE();
    case 195:
      if (lookahead == 'o') ADVANCE(255);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_perl);
      if (lookahead == '_') ADVANCE(256);
      END_STATE();
    case 197:
      if (lookahead == 'a') ADVANCE(257);
      END_STATE();
    case 198:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 199:
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 200:
      if (lookahead == 'o') ADVANCE(260);
      END_STATE();
    case 201:
      if (lookahead == 'i') ADVANCE(261);
      END_STATE();
    case 202:
      if (lookahead == '_') ADVANCE(262);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_rust);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_safe);
      END_STATE();
    case 205:
      if (lookahead == 'a') ADVANCE(263);
      END_STATE();
    case 206:
      if (lookahead == 'm') ADVANCE(264);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(265);
      if (lookahead == 'i') ADVANCE(266);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_sink);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(267);
      END_STATE();
    case 210:
      if (lookahead == 'l') ADVANCE(268);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(269);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(270);
      END_STATE();
    case 213:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 214:
      if (lookahead == 'c') ADVANCE(272);
      END_STATE();
    case 215:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 216:
      if (lookahead == 'w') ADVANCE(274);
      END_STATE();
    case 217:
      if (lookahead == 's') ADVANCE(275);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 219:
      if (lookahead == 'd') ADVANCE(276);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(277);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 222:
      if (lookahead == 'a') ADVANCE(278);
      if (lookahead == 'n') ADVANCE(279);
      if (lookahead == 'o') ADVANCE(280);
      END_STATE();
    case 223:
      if (lookahead == 'i') ADVANCE(281);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 225:
      if (lookahead == 'y') ADVANCE(282);
      END_STATE();
    case 226:
      if (lookahead == 'b') ADVANCE(283);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_cocoa);
      if (lookahead == '_') ADVANCE(285);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 230:
      if (lookahead == 'n') ADVANCE(286);
      END_STATE();
    case 231:
      if (lookahead == 'a') ADVANCE(287);
      END_STATE();
    case 232:
      if (lookahead == 'p') ADVANCE(288);
      END_STATE();
    case 233:
      if (lookahead == 'i') ADVANCE(289);
      END_STATE();
    case 234:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 236:
      if (lookahead == 'd') ADVANCE(292);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 239:
      if (lookahead == 'o') ADVANCE(293);
      END_STATE();
    case 240:
      if (lookahead == 'd') ADVANCE(294);
      END_STATE();
    case 241:
      if (lookahead == 'a') ADVANCE(295);
      END_STATE();
    case 242:
      if (lookahead == 'p') ADVANCE(296);
      END_STATE();
    case 243:
      if (lookahead == 'e') ADVANCE(297);
      END_STATE();
    case 244:
      if (lookahead == 'n') ADVANCE(298);
      END_STATE();
    case 245:
      if (lookahead == 'p') ADVANCE(299);
      END_STATE();
    case 246:
      if (lookahead == 'r') ADVANCE(300);
      END_STATE();
    case 247:
      if (lookahead == 'd') ADVANCE(301);
      END_STATE();
    case 248:
      if (lookahead == 's') ADVANCE(302);
      END_STATE();
    case 249:
      if (lookahead == 's') ADVANCE(303);
      END_STATE();
    case 250:
      if (lookahead == 's') ADVANCE(304);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_ocaml);
      END_STATE();
    case 252:
      if (lookahead == 'y') ADVANCE(305);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(306);
      END_STATE();
    case 254:
      if (lookahead == 'g') ADVANCE(307);
      END_STATE();
    case 255:
      if (lookahead == 'r') ADVANCE(308);
      END_STATE();
    case 256:
      if (lookahead == 'p') ADVANCE(309);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(310);
      END_STATE();
    case 258:
      if (lookahead == 'a') ADVANCE(311);
      END_STATE();
    case 259:
      if (lookahead == 'd') ADVANCE(312);
      END_STATE();
    case 260:
      if (lookahead == 'n') ADVANCE(313);
      END_STATE();
    case 261:
      if (lookahead == 'r') ADVANCE(314);
      END_STATE();
    case 262:
      if (lookahead == 'n') ADVANCE(315);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_scala);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_senum);
      END_STATE();
    case 265:
      if (lookahead == 'r') ADVANCE(316);
      END_STATE();
    case 266:
      if (lookahead == 'c') ADVANCE(317);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_slist);
      END_STATE();
    case 268:
      if (lookahead == 't') ADVANCE(318);
      END_STATE();
    case 269:
      if (lookahead == 'f') ADVANCE(319);
      END_STATE();
    case 270:
      if (lookahead == 'm') ADVANCE(320);
      END_STATE();
    case 271:
      if (lookahead == 'g') ADVANCE(321);
      END_STATE();
    case 272:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_swift);
      END_STATE();
    case 274:
      if (lookahead == 's') ADVANCE(323);
      END_STATE();
    case 275:
      if (lookahead == 'i') ADVANCE(324);
      END_STATE();
    case 276:
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 278:
      if (lookahead == 'l') ADVANCE(326);
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 279:
      if (lookahead == 'a') ADVANCE(328);
      if (lookahead == 'i') ADVANCE(329);
      END_STATE();
    case 280:
      if (lookahead == 'p') ADVANCE(330);
      END_STATE();
    case 281:
      if (lookahead == 'd') ADVANCE(331);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_c_glib);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_client);
      END_STATE();
    case 285:
      if (lookahead == 'p') ADVANCE(332);
      END_STATE();
    case 286:
      if (lookahead == 'c') ADVANCE(333);
      END_STATE();
    case 287:
      if (lookahead == 'm') ADVANCE(334);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_csharp);
      if (lookahead == '_') ADVANCE(335);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_delphi);
      if (lookahead == '_') ADVANCE(336);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 291:
      if (lookahead == 'i') ADVANCE(337);
      END_STATE();
    case 292:
      if (lookahead == 's') ADVANCE(338);
      END_STATE();
    case 293:
      if (lookahead == 't') ADVANCE(339);
      END_STATE();
    case 294:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 295:
      if (lookahead == 'c') ADVANCE(341);
      END_STATE();
    case 296:
      if (lookahead == 'a') ADVANCE(342);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_javame);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_kotlin);
      END_STATE();
    case 299:
      if (lookahead == 'a') ADVANCE(343);
      END_STATE();
    case 300:
      if (lookahead == 'e') ADVANCE(344);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_netstd);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_nodejs);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_nodets);
      END_STATE();
    case 304:
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_oneway);
      END_STATE();
    case 306:
      if (lookahead == 'a') ADVANCE(346);
      END_STATE();
    case 307:
      if (lookahead == 'e') ADVANCE(347);
      END_STATE();
    case 308:
      if (lookahead == 'm') ADVANCE(348);
      END_STATE();
    case 309:
      if (lookahead == 'a') ADVANCE(349);
      END_STATE();
    case 310:
      if (lookahead == 'e') ADVANCE(350);
      END_STATE();
    case 311:
      if (lookahead == 'm') ADVANCE(351);
      END_STATE();
    case 312:
      if (lookahead == 'u') ADVANCE(352);
      END_STATE();
    case 313:
      if (lookahead == 'l') ADVANCE(353);
      END_STATE();
    case 314:
      if (lookahead == 'e') ADVANCE(354);
      END_STATE();
    case 315:
      if (lookahead == 'a') ADVANCE(355);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_server);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(356);
      END_STATE();
    case 318:
      if (lookahead == 'a') ADVANCE(357);
      END_STATE();
    case 319:
      if (lookahead == 'u') ADVANCE(358);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_stream);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 324:
      if (lookahead == 'e') ADVANCE(359);
      END_STATE();
    case 325:
      if (lookahead == 'f') ADVANCE(360);
      END_STATE();
    case 326:
      if (lookahead == 'l') ADVANCE(361);
      END_STATE();
    case 327:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 328:
      if (lookahead == 'm') ADVANCE(363);
      END_STATE();
    case 329:
      if (lookahead == 'l') ADVANCE(364);
      END_STATE();
    case 330:
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_android);
      END_STATE();
    case 332:
      if (lookahead == 'r') ADVANCE(366);
      END_STATE();
    case 333:
      if (lookahead == 'l') ADVANCE(367);
      END_STATE();
    case 334:
      if (lookahead == 'e') ADVANCE(368);
      END_STATE();
    case 335:
      if (lookahead == 'n') ADVANCE(369);
      END_STATE();
    case 336:
      if (lookahead == 'n') ADVANCE(370);
      END_STATE();
    case 337:
      if (lookahead == 'o') ADVANCE(371);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 339:
      if (lookahead == 'e') ADVANCE(372);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 341:
      if (lookahead == 't') ADVANCE(373);
      END_STATE();
    case 342:
      if (lookahead == 'c') ADVANCE(374);
      END_STATE();
    case 343:
      if (lookahead == 'c') ADVANCE(375);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_netcore);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_noexist);
      END_STATE();
    case 346:
      if (lookahead == 'l') ADVANCE(376);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 348:
      if (lookahead == 's') ADVANCE(377);
      END_STATE();
    case 349:
      if (lookahead == 'c') ADVANCE(378);
      END_STATE();
    case 350:
      if (lookahead == 'n') ADVANCE(379);
      END_STATE();
    case 351:
      if (lookahead == 'e') ADVANCE(380);
      END_STATE();
    case 352:
      if (lookahead == 'l') ADVANCE(381);
      END_STATE();
    case 353:
      if (lookahead == 'y') ADVANCE(382);
      END_STATE();
    case 354:
      if (lookahead == 'd') ADVANCE(383);
      END_STATE();
    case 355:
      if (lookahead == 'm') ADVANCE(384);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_service);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(385);
      END_STATE();
    case 358:
      if (lookahead == 'l') ADVANCE(386);
      END_STATE();
    case 359:
      if (lookahead == 'n') ADVANCE(387);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_xsd_all);
      END_STATE();
    case 362:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 363:
      if (lookahead == 'e') ADVANCE(389);
      END_STATE();
    case 364:
      if (lookahead == 'l') ADVANCE(390);
      END_STATE();
    case 365:
      if (lookahead == 'i') ADVANCE(391);
      END_STATE();
    case 366:
      if (lookahead == 'e') ADVANCE(392);
      END_STATE();
    case 367:
      if (lookahead == 'u') ADVANCE(393);
      END_STATE();
    case 368:
      if (lookahead == 's') ADVANCE(394);
      END_STATE();
    case 369:
      if (lookahead == 'a') ADVANCE(395);
      END_STATE();
    case 370:
      if (lookahead == 'a') ADVANCE(396);
      END_STATE();
    case 371:
      if (lookahead == 'n') ADVANCE(397);
      END_STATE();
    case 372:
      if (lookahead == 'n') ADVANCE(398);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(399);
      END_STATE();
    case 374:
      if (lookahead == 'k') ADVANCE(400);
      END_STATE();
    case 375:
      if (lookahead == 'e') ADVANCE(401);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_optional);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_performs);
      END_STATE();
    case 378:
      if (lookahead == 'k') ADVANCE(402);
      END_STATE();
    case 379:
      if (lookahead == 't') ADVANCE(403);
      END_STATE();
    case 380:
      if (lookahead == 's') ADVANCE(404);
      END_STATE();
    case 381:
      if (lookahead == 'e') ADVANCE(405);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 384:
      if (lookahead == 'e') ADVANCE(406);
      END_STATE();
    case 385:
      if (lookahead == 'k') ADVANCE(407);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_stateful);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(408);
      END_STATE();
    case 388:
      if (lookahead == 's') ADVANCE(409);
      END_STATE();
    case 389:
      if (lookahead == 's') ADVANCE(410);
      END_STATE();
    case 390:
      if (lookahead == 'a') ADVANCE(411);
      END_STATE();
    case 391:
      if (lookahead == 'o') ADVANCE(412);
      END_STATE();
    case 392:
      if (lookahead == 'f') ADVANCE(413);
      END_STATE();
    case 393:
      if (lookahead == 'd') ADVANCE(414);
      END_STATE();
    case 394:
      if (lookahead == 'p') ADVANCE(415);
      END_STATE();
    case 395:
      if (lookahead == 'm') ADVANCE(416);
      END_STATE();
    case 396:
      if (lookahead == 'm') ADVANCE(417);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_exception);
      END_STATE();
    case 398:
      if (lookahead == 't') ADVANCE(418);
      END_STATE();
    case 399:
      if (lookahead == 'o') ADVANCE(419);
      END_STATE();
    case 400:
      if (lookahead == 'a') ADVANCE(420);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 402:
      if (lookahead == 'a') ADVANCE(421);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_permanent);
      END_STATE();
    case 404:
      if (lookahead == 'p') ADVANCE(422);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_py_module);
      END_STATE();
    case 406:
      if (lookahead == 's') ADVANCE(423);
      END_STATE();
    case 407:
      if (lookahead == '_') ADVANCE(424);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_xsd_attrs);
      END_STATE();
    case 410:
      if (lookahead == 'p') ADVANCE(425);
      END_STATE();
    case 411:
      if (lookahead == 'b') ADVANCE(426);
      END_STATE();
    case 412:
      if (lookahead == 'n') ADVANCE(427);
      END_STATE();
    case 413:
      if (lookahead == 'i') ADVANCE(428);
      END_STATE();
    case 414:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 415:
      if (lookahead == 'a') ADVANCE(430);
      END_STATE();
    case 416:
      if (lookahead == 'e') ADVANCE(431);
      END_STATE();
    case 417:
      if (lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_idempotent);
      END_STATE();
    case 419:
      if (lookahead == 'n') ADVANCE(433);
      END_STATE();
    case 420:
      if (lookahead == 'g') ADVANCE(434);
      END_STATE();
    case 421:
      if (lookahead == 'g') ADVANCE(435);
      END_STATE();
    case 422:
      if (lookahead == 'a') ADVANCE(436);
      END_STATE();
    case 423:
      if (lookahead == 'p') ADVANCE(437);
      END_STATE();
    case 424:
      if (lookahead == 'c') ADVANCE(438);
      if (lookahead == 'p') ADVANCE(439);
      END_STATE();
    case 425:
      if (lookahead == 'a') ADVANCE(440);
      END_STATE();
    case 426:
      if (lookahead == 'l') ADVANCE(441);
      END_STATE();
    case 427:
      if (lookahead == 'a') ADVANCE(442);
      END_STATE();
    case 428:
      if (lookahead == 'x') ADVANCE(443);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_cpp_include);
      END_STATE();
    case 430:
      if (lookahead == 'c') ADVANCE(444);
      END_STATE();
    case 431:
      if (lookahead == 's') ADVANCE(445);
      END_STATE();
    case 432:
      if (lookahead == 's') ADVANCE(446);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_interaction);
      END_STATE();
    case 434:
      if (lookahead == 'e') ADVANCE(447);
      END_STATE();
    case 435:
      if (lookahead == 'e') ADVANCE(448);
      END_STATE();
    case 436:
      if (lookahead == 'c') ADVANCE(449);
      END_STATE();
    case 437:
      if (lookahead == 'a') ADVANCE(450);
      END_STATE();
    case 438:
      if (lookahead == 'a') ADVANCE(451);
      END_STATE();
    case 439:
      if (lookahead == 'r') ADVANCE(452);
      END_STATE();
    case 440:
      if (lookahead == 'c') ADVANCE(453);
      END_STATE();
    case 441:
      if (lookahead == 'e') ADVANCE(454);
      END_STATE();
    case 442:
      if (lookahead == 'l') ADVANCE(455);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_cocoa_prefix);
      END_STATE();
    case 444:
      if (lookahead == 'e') ADVANCE(456);
      END_STATE();
    case 445:
      if (lookahead == 'p') ADVANCE(457);
      END_STATE();
    case 446:
      if (lookahead == 'p') ADVANCE(458);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_java_package);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_perl_package);
      END_STATE();
    case 449:
      if (lookahead == 'e') ADVANCE(459);
      END_STATE();
    case 450:
      if (lookahead == 'c') ADVANCE(460);
      END_STATE();
    case 451:
      if (lookahead == 't') ADVANCE(461);
      END_STATE();
    case 452:
      if (lookahead == 'e') ADVANCE(462);
      END_STATE();
    case 453:
      if (lookahead == 'e') ADVANCE(463);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_xsd_nillable);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_xsd_optional);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_cpp_namespace);
      END_STATE();
    case 457:
      if (lookahead == 'a') ADVANCE(464);
      END_STATE();
    case 458:
      if (lookahead == 'a') ADVANCE(465);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_php_namespace);
      END_STATE();
    case 460:
      if (lookahead == 'e') ADVANCE(466);
      END_STATE();
    case 461:
      if (lookahead == 'e') ADVANCE(467);
      END_STATE();
    case 462:
      if (lookahead == 'f') ADVANCE(468);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_xsd_namespace);
      END_STATE();
    case 464:
      if (lookahead == 'c') ADVANCE(469);
      END_STATE();
    case 465:
      if (lookahead == 'c') ADVANCE(470);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_ruby_namespace);
      END_STATE();
    case 467:
      if (lookahead == 'g') ADVANCE(471);
      END_STATE();
    case 468:
      if (lookahead == 'i') ADVANCE(472);
      END_STATE();
    case 469:
      if (lookahead == 'e') ADVANCE(473);
      END_STATE();
    case 470:
      if (lookahead == 'e') ADVANCE(474);
      END_STATE();
    case 471:
      if (lookahead == 'o') ADVANCE(475);
      END_STATE();
    case 472:
      if (lookahead == 'x') ADVANCE(476);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_csharp_namespace);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_delphi_namespace);
      END_STATE();
    case 475:
      if (lookahead == 'r') ADVANCE(477);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_smalltalk_prefix);
      END_STATE();
    case 477:
      if (lookahead == 'y') ADVANCE(478);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_smalltalk_category);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 86},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 86},
  [4] = {.lex_state = 86},
  [5] = {.lex_state = 86},
  [6] = {.lex_state = 86},
  [7] = {.lex_state = 86},
  [8] = {.lex_state = 86},
  [9] = {.lex_state = 86},
  [10] = {.lex_state = 86},
  [11] = {.lex_state = 86},
  [12] = {.lex_state = 86},
  [13] = {.lex_state = 86},
  [14] = {.lex_state = 86},
  [15] = {.lex_state = 86},
  [16] = {.lex_state = 86},
  [17] = {.lex_state = 86},
  [18] = {.lex_state = 86},
  [19] = {.lex_state = 86},
  [20] = {.lex_state = 86},
  [21] = {.lex_state = 86},
  [22] = {.lex_state = 86},
  [23] = {.lex_state = 86},
  [24] = {.lex_state = 86},
  [25] = {.lex_state = 86},
  [26] = {.lex_state = 86},
  [27] = {.lex_state = 86},
  [28] = {.lex_state = 86},
  [29] = {.lex_state = 86},
  [30] = {.lex_state = 86},
  [31] = {.lex_state = 86},
  [32] = {.lex_state = 86},
  [33] = {.lex_state = 86},
  [34] = {.lex_state = 86},
  [35] = {.lex_state = 86},
  [36] = {.lex_state = 86},
  [37] = {.lex_state = 86},
  [38] = {.lex_state = 86},
  [39] = {.lex_state = 86},
  [40] = {.lex_state = 86},
  [41] = {.lex_state = 86},
  [42] = {.lex_state = 86},
  [43] = {.lex_state = 86},
  [44] = {.lex_state = 86},
  [45] = {.lex_state = 86},
  [46] = {.lex_state = 86},
  [47] = {.lex_state = 86},
  [48] = {.lex_state = 86},
  [49] = {.lex_state = 86},
  [50] = {.lex_state = 86},
  [51] = {.lex_state = 86},
  [52] = {.lex_state = 86},
  [53] = {.lex_state = 86},
  [54] = {.lex_state = 86},
  [55] = {.lex_state = 86},
  [56] = {.lex_state = 86},
  [57] = {.lex_state = 86},
  [58] = {.lex_state = 86},
  [59] = {.lex_state = 86},
  [60] = {.lex_state = 86},
  [61] = {.lex_state = 86},
  [62] = {.lex_state = 86},
  [63] = {.lex_state = 86},
  [64] = {.lex_state = 86},
  [65] = {.lex_state = 86},
  [66] = {.lex_state = 86},
  [67] = {.lex_state = 86},
  [68] = {.lex_state = 86},
  [69] = {.lex_state = 86},
  [70] = {.lex_state = 86},
  [71] = {.lex_state = 86},
  [72] = {.lex_state = 86},
  [73] = {.lex_state = 86},
  [74] = {.lex_state = 86},
  [75] = {.lex_state = 86},
  [76] = {.lex_state = 86},
  [77] = {.lex_state = 86},
  [78] = {.lex_state = 86},
  [79] = {.lex_state = 86},
  [80] = {.lex_state = 86},
  [81] = {.lex_state = 86},
  [82] = {.lex_state = 86},
  [83] = {.lex_state = 86},
  [84] = {.lex_state = 86},
  [85] = {.lex_state = 86},
  [86] = {.lex_state = 86},
  [87] = {.lex_state = 86},
  [88] = {.lex_state = 86},
  [89] = {.lex_state = 86},
  [90] = {.lex_state = 86},
  [91] = {.lex_state = 86},
  [92] = {.lex_state = 86},
  [93] = {.lex_state = 86},
  [94] = {.lex_state = 86},
  [95] = {.lex_state = 86},
  [96] = {.lex_state = 86},
  [97] = {.lex_state = 86},
  [98] = {.lex_state = 86},
  [99] = {.lex_state = 86},
  [100] = {.lex_state = 86},
  [101] = {.lex_state = 86},
  [102] = {.lex_state = 86},
  [103] = {.lex_state = 86},
  [104] = {.lex_state = 86},
  [105] = {.lex_state = 86},
  [106] = {.lex_state = 86},
  [107] = {.lex_state = 86},
  [108] = {.lex_state = 86},
  [109] = {.lex_state = 86},
  [110] = {.lex_state = 86},
  [111] = {.lex_state = 86},
  [112] = {.lex_state = 86},
  [113] = {.lex_state = 86},
  [114] = {.lex_state = 86},
  [115] = {.lex_state = 86},
  [116] = {.lex_state = 86},
  [117] = {.lex_state = 86},
  [118] = {.lex_state = 86},
  [119] = {.lex_state = 86},
  [120] = {.lex_state = 86},
  [121] = {.lex_state = 86},
  [122] = {.lex_state = 86},
  [123] = {.lex_state = 86},
  [124] = {.lex_state = 86},
  [125] = {.lex_state = 86},
  [126] = {.lex_state = 86},
  [127] = {.lex_state = 86},
  [128] = {.lex_state = 86},
  [129] = {.lex_state = 86},
  [130] = {.lex_state = 86},
  [131] = {.lex_state = 86},
  [132] = {.lex_state = 86},
  [133] = {.lex_state = 86},
  [134] = {.lex_state = 86},
  [135] = {.lex_state = 86},
  [136] = {.lex_state = 86},
  [137] = {.lex_state = 86},
  [138] = {.lex_state = 86},
  [139] = {.lex_state = 86},
  [140] = {.lex_state = 86},
  [141] = {.lex_state = 86},
  [142] = {.lex_state = 86},
  [143] = {.lex_state = 86},
  [144] = {.lex_state = 86},
  [145] = {.lex_state = 86},
  [146] = {.lex_state = 86},
  [147] = {.lex_state = 86},
  [148] = {.lex_state = 86},
  [149] = {.lex_state = 86},
  [150] = {.lex_state = 86},
  [151] = {.lex_state = 86},
  [152] = {.lex_state = 86},
  [153] = {.lex_state = 86},
  [154] = {.lex_state = 86},
  [155] = {.lex_state = 86},
  [156] = {.lex_state = 86},
  [157] = {.lex_state = 86},
  [158] = {.lex_state = 86},
  [159] = {.lex_state = 86},
  [160] = {.lex_state = 86},
  [161] = {.lex_state = 86},
  [162] = {.lex_state = 86},
  [163] = {.lex_state = 86},
  [164] = {.lex_state = 86},
  [165] = {.lex_state = 86},
  [166] = {.lex_state = 86},
  [167] = {.lex_state = 86},
  [168] = {.lex_state = 86},
  [169] = {.lex_state = 86},
  [170] = {.lex_state = 86},
  [171] = {.lex_state = 86},
  [172] = {.lex_state = 86},
  [173] = {.lex_state = 86},
  [174] = {.lex_state = 86},
  [175] = {.lex_state = 86},
  [176] = {.lex_state = 86},
  [177] = {.lex_state = 86},
  [178] = {.lex_state = 86},
  [179] = {.lex_state = 86},
  [180] = {.lex_state = 86},
  [181] = {.lex_state = 86},
  [182] = {.lex_state = 86},
  [183] = {.lex_state = 86},
  [184] = {.lex_state = 86},
  [185] = {.lex_state = 86},
  [186] = {.lex_state = 86},
  [187] = {.lex_state = 86},
  [188] = {.lex_state = 86},
  [189] = {.lex_state = 86},
  [190] = {.lex_state = 86},
  [191] = {.lex_state = 86},
  [192] = {.lex_state = 86},
  [193] = {.lex_state = 86},
  [194] = {.lex_state = 86},
  [195] = {.lex_state = 86},
  [196] = {.lex_state = 86},
  [197] = {.lex_state = 86},
  [198] = {.lex_state = 86},
  [199] = {.lex_state = 86},
  [200] = {.lex_state = 86},
  [201] = {.lex_state = 86},
  [202] = {.lex_state = 86},
  [203] = {.lex_state = 86},
  [204] = {.lex_state = 86},
  [205] = {.lex_state = 86},
  [206] = {.lex_state = 86},
  [207] = {.lex_state = 86},
  [208] = {.lex_state = 86},
  [209] = {.lex_state = 86},
  [210] = {.lex_state = 86},
  [211] = {.lex_state = 86},
  [212] = {.lex_state = 86},
  [213] = {.lex_state = 86},
  [214] = {.lex_state = 86},
  [215] = {.lex_state = 86},
  [216] = {.lex_state = 86},
  [217] = {.lex_state = 86},
  [218] = {.lex_state = 86},
  [219] = {.lex_state = 86},
  [220] = {.lex_state = 86},
  [221] = {.lex_state = 86},
  [222] = {.lex_state = 86},
  [223] = {.lex_state = 86},
  [224] = {.lex_state = 86},
  [225] = {.lex_state = 86},
  [226] = {.lex_state = 86},
  [227] = {.lex_state = 86},
  [228] = {.lex_state = 86},
  [229] = {.lex_state = 86},
  [230] = {.lex_state = 86},
  [231] = {.lex_state = 86},
  [232] = {.lex_state = 86},
  [233] = {.lex_state = 86},
  [234] = {.lex_state = 86},
  [235] = {.lex_state = 86},
  [236] = {.lex_state = 86},
  [237] = {.lex_state = 86},
  [238] = {.lex_state = 86},
  [239] = {.lex_state = 86},
  [240] = {.lex_state = 86},
  [241] = {.lex_state = 86},
  [242] = {.lex_state = 86},
  [243] = {.lex_state = 86},
  [244] = {.lex_state = 86},
  [245] = {.lex_state = 86},
  [246] = {.lex_state = 86},
  [247] = {.lex_state = 86},
  [248] = {.lex_state = 86},
  [249] = {.lex_state = 86},
  [250] = {.lex_state = 86},
  [251] = {.lex_state = 86},
  [252] = {.lex_state = 86},
  [253] = {.lex_state = 86},
  [254] = {.lex_state = 86},
  [255] = {.lex_state = 86},
  [256] = {.lex_state = 86},
  [257] = {.lex_state = 86},
  [258] = {.lex_state = 86},
  [259] = {.lex_state = 86},
  [260] = {.lex_state = 86},
  [261] = {.lex_state = 86},
  [262] = {.lex_state = 86},
  [263] = {.lex_state = 86},
  [264] = {.lex_state = 86},
  [265] = {.lex_state = 86},
  [266] = {.lex_state = 86},
  [267] = {.lex_state = 86},
  [268] = {.lex_state = 86},
  [269] = {.lex_state = 86},
  [270] = {.lex_state = 86},
  [271] = {.lex_state = 86},
  [272] = {.lex_state = 86},
  [273] = {.lex_state = 86},
  [274] = {.lex_state = 86},
  [275] = {.lex_state = 86},
  [276] = {.lex_state = 86},
  [277] = {.lex_state = 86},
  [278] = {.lex_state = 86},
  [279] = {.lex_state = 86},
  [280] = {.lex_state = 86},
  [281] = {.lex_state = 86},
  [282] = {.lex_state = 86},
  [283] = {.lex_state = 86},
  [284] = {.lex_state = 86},
  [285] = {.lex_state = 86},
  [286] = {.lex_state = 86},
  [287] = {.lex_state = 86},
  [288] = {.lex_state = 86},
  [289] = {.lex_state = 86},
  [290] = {.lex_state = 86},
  [291] = {.lex_state = 86},
  [292] = {.lex_state = 86},
  [293] = {.lex_state = 86},
  [294] = {.lex_state = 86},
  [295] = {.lex_state = 86},
  [296] = {.lex_state = 86},
  [297] = {.lex_state = 86},
  [298] = {.lex_state = 86},
  [299] = {.lex_state = 86},
  [300] = {.lex_state = 86},
  [301] = {.lex_state = 86},
  [302] = {.lex_state = 86},
  [303] = {.lex_state = 86},
  [304] = {.lex_state = 86},
  [305] = {.lex_state = 86},
  [306] = {.lex_state = 86},
  [307] = {.lex_state = 86},
  [308] = {.lex_state = 86},
  [309] = {.lex_state = 86},
  [310] = {.lex_state = 86},
  [311] = {.lex_state = 86},
  [312] = {.lex_state = 86},
  [313] = {.lex_state = 86},
  [314] = {.lex_state = 86},
  [315] = {.lex_state = 86},
  [316] = {.lex_state = 86},
  [317] = {.lex_state = 86},
  [318] = {.lex_state = 86},
  [319] = {.lex_state = 86},
  [320] = {.lex_state = 86},
  [321] = {.lex_state = 86},
  [322] = {.lex_state = 86},
  [323] = {.lex_state = 86},
  [324] = {.lex_state = 86},
  [325] = {.lex_state = 86},
  [326] = {.lex_state = 86},
  [327] = {.lex_state = 86},
  [328] = {.lex_state = 86},
  [329] = {.lex_state = 86},
  [330] = {.lex_state = 86},
  [331] = {.lex_state = 86},
  [332] = {.lex_state = 86},
  [333] = {.lex_state = 86},
  [334] = {.lex_state = 86},
  [335] = {.lex_state = 86},
  [336] = {.lex_state = 86},
  [337] = {.lex_state = 86},
  [338] = {.lex_state = 86},
  [339] = {.lex_state = 86},
  [340] = {.lex_state = 86},
  [341] = {.lex_state = 86},
  [342] = {.lex_state = 86},
  [343] = {.lex_state = 86},
  [344] = {.lex_state = 86},
  [345] = {.lex_state = 86},
  [346] = {.lex_state = 86},
  [347] = {.lex_state = 86},
  [348] = {.lex_state = 86},
  [349] = {.lex_state = 86},
  [350] = {.lex_state = 86},
  [351] = {.lex_state = 86},
  [352] = {.lex_state = 86},
  [353] = {.lex_state = 86},
  [354] = {.lex_state = 86},
  [355] = {.lex_state = 86},
  [356] = {.lex_state = 86},
  [357] = {.lex_state = 86},
  [358] = {.lex_state = 86},
  [359] = {.lex_state = 86},
  [360] = {.lex_state = 86},
  [361] = {.lex_state = 86},
  [362] = {.lex_state = 86},
  [363] = {.lex_state = 86},
  [364] = {.lex_state = 86},
  [365] = {.lex_state = 86},
  [366] = {.lex_state = 86},
  [367] = {.lex_state = 86},
  [368] = {.lex_state = 86},
  [369] = {.lex_state = 86},
  [370] = {.lex_state = 86},
  [371] = {.lex_state = 86},
  [372] = {.lex_state = 86},
  [373] = {.lex_state = 86},
  [374] = {.lex_state = 86},
  [375] = {.lex_state = 86},
  [376] = {.lex_state = 86},
  [377] = {.lex_state = 86},
  [378] = {.lex_state = 86},
  [379] = {.lex_state = 86},
  [380] = {.lex_state = 86},
  [381] = {.lex_state = 86},
  [382] = {.lex_state = 86},
  [383] = {.lex_state = 86},
  [384] = {.lex_state = 86},
  [385] = {.lex_state = 86},
  [386] = {.lex_state = 86},
  [387] = {.lex_state = 86},
  [388] = {.lex_state = 86},
  [389] = {.lex_state = 86},
  [390] = {.lex_state = 86},
  [391] = {.lex_state = 86},
  [392] = {.lex_state = 86},
  [393] = {.lex_state = 86},
  [394] = {.lex_state = 86},
  [395] = {.lex_state = 86},
  [396] = {.lex_state = 86},
  [397] = {.lex_state = 86},
  [398] = {.lex_state = 86},
  [399] = {.lex_state = 86},
  [400] = {.lex_state = 86},
  [401] = {.lex_state = 86},
  [402] = {.lex_state = 86},
  [403] = {.lex_state = 86},
  [404] = {.lex_state = 86},
  [405] = {.lex_state = 86},
  [406] = {.lex_state = 86},
  [407] = {.lex_state = 86},
  [408] = {.lex_state = 86},
  [409] = {.lex_state = 86},
  [410] = {.lex_state = 86},
  [411] = {.lex_state = 86},
  [412] = {.lex_state = 86},
  [413] = {.lex_state = 86},
  [414] = {.lex_state = 86},
  [415] = {.lex_state = 86},
  [416] = {.lex_state = 86},
  [417] = {.lex_state = 86},
  [418] = {.lex_state = 86},
  [419] = {.lex_state = 86},
  [420] = {.lex_state = 86},
  [421] = {.lex_state = 3},
  [422] = {.lex_state = 86},
  [423] = {.lex_state = 86},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 86},
  [426] = {.lex_state = 86},
  [427] = {.lex_state = 86},
  [428] = {.lex_state = 86},
  [429] = {.lex_state = 86},
  [430] = {.lex_state = 86},
  [431] = {.lex_state = 3},
  [432] = {.lex_state = 86},
  [433] = {.lex_state = 3},
  [434] = {.lex_state = 3},
  [435] = {.lex_state = 86},
  [436] = {.lex_state = 86},
  [437] = {.lex_state = 86},
  [438] = {.lex_state = 3},
  [439] = {.lex_state = 3},
  [440] = {.lex_state = 86},
  [441] = {.lex_state = 86},
  [442] = {.lex_state = 86},
  [443] = {.lex_state = 86},
  [444] = {.lex_state = 3},
  [445] = {.lex_state = 86},
  [446] = {.lex_state = 86},
  [447] = {.lex_state = 86},
  [448] = {.lex_state = 86},
  [449] = {.lex_state = 86},
  [450] = {.lex_state = 86},
  [451] = {.lex_state = 3},
  [452] = {.lex_state = 86},
  [453] = {.lex_state = 3},
  [454] = {.lex_state = 86},
  [455] = {.lex_state = 86},
  [456] = {.lex_state = 86},
  [457] = {.lex_state = 3},
  [458] = {.lex_state = 86},
  [459] = {.lex_state = 86},
  [460] = {.lex_state = 86},
  [461] = {.lex_state = 86},
  [462] = {.lex_state = 86},
  [463] = {.lex_state = 3},
  [464] = {.lex_state = 3},
  [465] = {.lex_state = 3},
  [466] = {.lex_state = 86},
  [467] = {.lex_state = 86},
  [468] = {.lex_state = 86},
  [469] = {.lex_state = 86},
  [470] = {.lex_state = 86},
  [471] = {.lex_state = 86},
  [472] = {.lex_state = 86},
  [473] = {.lex_state = 86},
  [474] = {.lex_state = 86},
  [475] = {.lex_state = 86},
  [476] = {.lex_state = 86},
  [477] = {.lex_state = 86},
  [478] = {.lex_state = 86},
  [479] = {.lex_state = 86},
  [480] = {.lex_state = 86},
  [481] = {.lex_state = 3},
  [482] = {.lex_state = 3},
  [483] = {.lex_state = 3},
  [484] = {.lex_state = 3},
  [485] = {.lex_state = 3},
  [486] = {.lex_state = 3},
  [487] = {.lex_state = 3},
  [488] = {.lex_state = 3},
  [489] = {.lex_state = 3},
  [490] = {.lex_state = 3},
  [491] = {.lex_state = 3},
  [492] = {.lex_state = 3},
  [493] = {.lex_state = 3},
  [494] = {.lex_state = 3},
  [495] = {.lex_state = 3},
  [496] = {.lex_state = 3},
  [497] = {.lex_state = 3},
  [498] = {.lex_state = 3},
  [499] = {.lex_state = 3},
  [500] = {.lex_state = 3},
  [501] = {.lex_state = 3},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 3},
  [504] = {.lex_state = 3},
  [505] = {.lex_state = 3},
  [506] = {.lex_state = 3},
  [507] = {.lex_state = 3},
  [508] = {.lex_state = 3},
  [509] = {.lex_state = 3},
  [510] = {.lex_state = 3},
  [511] = {.lex_state = 3},
  [512] = {.lex_state = 3},
  [513] = {.lex_state = 3},
  [514] = {.lex_state = 3},
  [515] = {.lex_state = 3},
  [516] = {.lex_state = 3},
  [517] = {.lex_state = 3},
  [518] = {.lex_state = 3},
  [519] = {.lex_state = 2},
  [520] = {.lex_state = 2},
  [521] = {.lex_state = 86},
  [522] = {.lex_state = 2},
  [523] = {.lex_state = 86},
  [524] = {.lex_state = 86},
  [525] = {.lex_state = 2},
  [526] = {.lex_state = 2},
  [527] = {.lex_state = 2},
  [528] = {.lex_state = 2},
  [529] = {.lex_state = 86},
  [530] = {.lex_state = 2},
  [531] = {.lex_state = 86},
  [532] = {.lex_state = 2},
  [533] = {.lex_state = 2},
  [534] = {.lex_state = 2},
  [535] = {.lex_state = 2},
  [536] = {.lex_state = 86},
  [537] = {.lex_state = 2},
  [538] = {.lex_state = 2},
  [539] = {.lex_state = 86},
  [540] = {.lex_state = 86},
  [541] = {.lex_state = 86},
  [542] = {.lex_state = 2},
  [543] = {.lex_state = 2},
  [544] = {.lex_state = 2},
  [545] = {.lex_state = 2},
  [546] = {.lex_state = 86},
  [547] = {.lex_state = 2},
  [548] = {.lex_state = 2},
  [549] = {.lex_state = 86},
  [550] = {.lex_state = 2},
  [551] = {.lex_state = 86},
  [552] = {.lex_state = 2},
  [553] = {.lex_state = 86},
  [554] = {.lex_state = 86},
  [555] = {.lex_state = 86},
  [556] = {.lex_state = 4},
  [557] = {.lex_state = 5},
  [558] = {.lex_state = 86},
  [559] = {.lex_state = 2},
  [560] = {.lex_state = 4},
  [561] = {.lex_state = 86},
  [562] = {.lex_state = 2},
  [563] = {.lex_state = 5},
  [564] = {.lex_state = 2},
  [565] = {.lex_state = 4},
  [566] = {.lex_state = 86},
  [567] = {.lex_state = 5},
  [568] = {.lex_state = 4},
  [569] = {.lex_state = 5},
  [570] = {.lex_state = 4},
  [571] = {.lex_state = 5},
  [572] = {.lex_state = 4},
  [573] = {.lex_state = 86},
  [574] = {.lex_state = 86},
  [575] = {.lex_state = 86},
  [576] = {.lex_state = 86},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 5},
  [580] = {.lex_state = 4},
  [581] = {.lex_state = 5},
  [582] = {.lex_state = 86},
  [583] = {.lex_state = 5},
  [584] = {.lex_state = 5},
  [585] = {.lex_state = 4},
  [586] = {.lex_state = 4},
  [587] = {.lex_state = 2},
  [588] = {.lex_state = 86},
  [589] = {.lex_state = 86},
  [590] = {.lex_state = 86},
  [591] = {.lex_state = 86},
  [592] = {.lex_state = 86},
  [593] = {.lex_state = 86},
  [594] = {.lex_state = 86},
  [595] = {.lex_state = 2},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 2},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 2},
  [600] = {.lex_state = 86},
  [601] = {.lex_state = 86},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 86},
  [604] = {.lex_state = 86},
  [605] = {.lex_state = 86},
  [606] = {.lex_state = 86},
  [607] = {.lex_state = 2},
  [608] = {.lex_state = 86},
  [609] = {.lex_state = 86},
  [610] = {.lex_state = 86},
  [611] = {.lex_state = 2},
  [612] = {.lex_state = 2},
  [613] = {.lex_state = 2},
  [614] = {.lex_state = 86},
  [615] = {.lex_state = 2},
  [616] = {.lex_state = 86},
  [617] = {.lex_state = 2},
  [618] = {.lex_state = 86},
  [619] = {.lex_state = 86},
  [620] = {.lex_state = 86},
  [621] = {.lex_state = 86},
  [622] = {.lex_state = 2},
  [623] = {.lex_state = 86},
  [624] = {.lex_state = 86},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 86},
  [627] = {.lex_state = 86},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 86},
  [631] = {.lex_state = 2},
  [632] = {.lex_state = 2},
  [633] = {.lex_state = 86},
  [634] = {.lex_state = 86},
  [635] = {.lex_state = 86},
  [636] = {.lex_state = 86},
  [637] = {.lex_state = 86},
  [638] = {.lex_state = 86},
  [639] = {.lex_state = 86},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 86},
  [642] = {.lex_state = 86},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 86},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 2},
  [647] = {.lex_state = 86},
  [648] = {.lex_state = 2},
  [649] = {.lex_state = 2},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 2},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 2},
  [654] = {.lex_state = 2},
  [655] = {.lex_state = 2},
  [656] = {.lex_state = 86},
  [657] = {.lex_state = 2},
  [658] = {.lex_state = 86},
  [659] = {.lex_state = 86},
  [660] = {.lex_state = 86},
  [661] = {.lex_state = 2},
  [662] = {.lex_state = 2},
  [663] = {.lex_state = 86},
  [664] = {.lex_state = 86},
  [665] = {.lex_state = 86},
  [666] = {.lex_state = 86},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 86},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 86},
  [672] = {.lex_state = 86},
  [673] = {.lex_state = 86},
  [674] = {.lex_state = 86},
  [675] = {.lex_state = 2},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 86},
  [681] = {.lex_state = 86},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 86},
  [684] = {.lex_state = 86},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 86},
  [690] = {.lex_state = 86},
  [691] = {.lex_state = 86},
  [692] = {.lex_state = 86},
  [693] = {.lex_state = 86},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 86},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 86},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 86},
  [700] = {.lex_state = 2},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 86},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 86},
  [706] = {.lex_state = 86},
  [707] = {.lex_state = 86},
  [708] = {.lex_state = 86},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 86},
  [712] = {.lex_state = 2},
  [713] = {.lex_state = 86},
  [714] = {.lex_state = 86},
  [715] = {.lex_state = 86},
  [716] = {.lex_state = 86},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 2},
  [722] = {.lex_state = 2},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 2},
  [725] = {.lex_state = 2},
  [726] = {.lex_state = 2},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 86},
  [729] = {.lex_state = 86},
  [730] = {.lex_state = 86},
  [731] = {.lex_state = 86},
  [732] = {.lex_state = 86},
  [733] = {.lex_state = 86},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 86},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 2},
  [739] = {.lex_state = 86},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 86},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 86},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 2},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 2},
  [748] = {.lex_state = 86},
  [749] = {.lex_state = 2},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 86},
  [752] = {.lex_state = 86},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 2},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 2},
  [758] = {.lex_state = 86},
  [759] = {.lex_state = 2},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 2},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 86},
  [764] = {.lex_state = 2},
  [765] = {.lex_state = 2},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 2},
  [768] = {.lex_state = 2},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 86},
  [771] = {.lex_state = 2},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 2},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 2},
  [777] = {.lex_state = 86},
  [778] = {.lex_state = 2},
  [779] = {.lex_state = 2},
  [780] = {.lex_state = 2},
  [781] = {.lex_state = 2},
  [782] = {.lex_state = 2},
  [783] = {.lex_state = 86},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 2},
  [790] = {.lex_state = 86},
  [791] = {.lex_state = 86},
  [792] = {.lex_state = 86},
  [793] = {.lex_state = 86},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 86},
  [796] = {.lex_state = 86},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 86},
  [799] = {.lex_state = 86},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 86},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 86},
  [804] = {.lex_state = 86},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 2},
  [807] = {.lex_state = 2},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 2},
  [810] = {.lex_state = 86},
  [811] = {.lex_state = 86},
  [812] = {.lex_state = 86},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 86},
  [815] = {.lex_state = 2},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 86},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 2},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 2},
  [824] = {.lex_state = 2},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 86},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 86},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 86},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 86},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 86},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 86},
  [847] = {.lex_state = 86},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 86},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 86},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 86},
  [856] = {.lex_state = 86},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 86},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 86},
  [863] = {.lex_state = 86},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 86},
  [868] = {.lex_state = 86},
  [869] = {.lex_state = 86},
  [870] = {.lex_state = 86},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 86},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 86},
  [878] = {.lex_state = 86},
  [879] = {.lex_state = 86},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 86},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 86},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 86},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 86},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 86},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 86},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 86},
  [902] = {.lex_state = 86},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 86},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 86},
  [910] = {.lex_state = 86},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 86},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 86},
  [919] = {.lex_state = 86},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 86},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_cpp_include] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_as3] = ACTIONS(1),
    [anon_sym_c_glib] = ACTIONS(1),
    [anon_sym_cl] = ACTIONS(1),
    [anon_sym_cocoa] = ACTIONS(1),
    [anon_sym_cpp] = ACTIONS(1),
    [anon_sym_cpp2] = ACTIONS(1),
    [anon_sym_cpp_DOTnoexist] = ACTIONS(1),
    [anon_sym_csharp] = ACTIONS(1),
    [anon_sym_d] = ACTIONS(1),
    [anon_sym_dart] = ACTIONS(1),
    [anon_sym_delphi] = ACTIONS(1),
    [anon_sym_erl] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_haxe] = ACTIONS(1),
    [anon_sym_java] = ACTIONS(1),
    [anon_sym_javame] = ACTIONS(1),
    [anon_sym_js] = ACTIONS(1),
    [anon_sym_kotlin] = ACTIONS(1),
    [anon_sym_lua] = ACTIONS(1),
    [anon_sym_netcore] = ACTIONS(1),
    [anon_sym_netstd] = ACTIONS(1),
    [anon_sym_nodejs] = ACTIONS(1),
    [anon_sym_nodets] = ACTIONS(1),
    [anon_sym_noexist] = ACTIONS(1),
    [anon_sym_ocaml] = ACTIONS(1),
    [anon_sym_perl] = ACTIONS(1),
    [anon_sym_php] = ACTIONS(1),
    [anon_sym_php_DOTpath] = ACTIONS(1),
    [anon_sym_py] = ACTIONS(1),
    [anon_sym_py_DOTtwisted] = ACTIONS(1),
    [anon_sym_rb] = ACTIONS(1),
    [anon_sym_rs] = ACTIONS(1),
    [anon_sym_smalltalk_DOTprefix] = ACTIONS(1),
    [anon_sym_smalltalk_DOTcategory] = ACTIONS(1),
    [anon_sym_st] = ACTIONS(1),
    [anon_sym_swift] = ACTIONS(1),
    [anon_sym_ts] = ACTIONS(1),
    [anon_sym_xml] = ACTIONS(1),
    [anon_sym_xsd] = ACTIONS(1),
    [anon_sym_cocoa_prefix] = ACTIONS(1),
    [anon_sym_cpp_namespace] = ACTIONS(1),
    [anon_sym_csharp_namespace] = ACTIONS(1),
    [anon_sym_delphi_namespace] = ACTIONS(1),
    [anon_sym_java_package] = ACTIONS(1),
    [anon_sym_perl_package] = ACTIONS(1),
    [anon_sym_php_namespace] = ACTIONS(1),
    [anon_sym_py_module] = ACTIONS(1),
    [anon_sym_ruby_namespace] = ACTIONS(1),
    [anon_sym_smalltalk_category] = ACTIONS(1),
    [anon_sym_smalltalk_prefix] = ACTIONS(1),
    [anon_sym_xsd_namespace] = ACTIONS(1),
    [anon_sym_android] = ACTIONS(1),
    [anon_sym_hack] = ACTIONS(1),
    [anon_sym_hack_DOTmodule] = ACTIONS(1),
    [anon_sym_hs] = ACTIONS(1),
    [anon_sym_hs2] = ACTIONS(1),
    [anon_sym_java_DOTswift] = ACTIONS(1),
    [anon_sym_java_DOTswift_DOTconstants] = ACTIONS(1),
    [anon_sym_json] = ACTIONS(1),
    [anon_sym_py_DOTasyncio] = ACTIONS(1),
    [anon_sym_py3] = ACTIONS(1),
    [anon_sym_rust] = ACTIONS(1),
    [anon_sym_scala] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_uri] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_senum] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_xsd_all] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_exception] = ACTIONS(1),
    [anon_sym_client] = ACTIONS(1),
    [anon_sym_permanent] = ACTIONS(1),
    [anon_sym_server] = ACTIONS(1),
    [anon_sym_safe] = ACTIONS(1),
    [anon_sym_stateful] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_service] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_performs] = ACTIONS(1),
    [anon_sym_interaction] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_xsd_optional] = ACTIONS(1),
    [anon_sym_xsd_nillable] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_required] = ACTIONS(1),
    [anon_sym_optional] = ACTIONS(1),
    [anon_sym_xsd_attrs] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_oneway] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_idempotent] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_slist] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_sink] = ACTIONS(1),
    [anon_sym_stream] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_double] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [aux_sym__escape_sequence_token1] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_document] = STATE(894),
    [sym_header] = STATE(9),
    [sym_include_statement] = STATE(325),
    [sym_namespace_declaration] = STATE(325),
    [sym_package_declaration] = STATE(325),
    [sym_definition] = STATE(97),
    [sym_const_definition] = STATE(413),
    [sym_typedef_definition] = STATE(413),
    [sym_enum_definition] = STATE(413),
    [sym_senum_definition] = STATE(413),
    [sym_struct_definition] = STATE(413),
    [sym_union_definition] = STATE(413),
    [sym_exception_definition] = STATE(413),
    [sym_exception_modifier] = STATE(524),
    [sym_service_definition] = STATE(413),
    [sym_interaction_definition] = STATE(413),
    [sym_fb_annotation_definition] = STATE(369),
    [aux_sym_document_repeat1] = STATE(9),
    [aux_sym_document_repeat2] = STATE(97),
    [aux_sym_package_declaration_repeat1] = STATE(369),
    [aux_sym_exception_definition_repeat1] = STATE(524),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_include] = ACTIONS(7),
    [anon_sym_cpp_include] = ACTIONS(7),
    [anon_sym_namespace] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_typedef] = ACTIONS(15),
    [anon_sym_enum] = ACTIONS(17),
    [anon_sym_senum] = ACTIONS(19),
    [anon_sym_struct] = ACTIONS(21),
    [anon_sym_union] = ACTIONS(23),
    [anon_sym_exception] = ACTIONS(25),
    [anon_sym_client] = ACTIONS(27),
    [anon_sym_permanent] = ACTIONS(27),
    [anon_sym_server] = ACTIONS(27),
    [anon_sym_safe] = ACTIONS(27),
    [anon_sym_stateful] = ACTIONS(27),
    [anon_sym_transient] = ACTIONS(27),
    [anon_sym_service] = ACTIONS(29),
    [anon_sym_interaction] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_namespace_scope] = STATE(644),
    [anon_sym_STAR] = ACTIONS(35),
    [anon_sym_as3] = ACTIONS(35),
    [anon_sym_c_glib] = ACTIONS(35),
    [anon_sym_cl] = ACTIONS(35),
    [anon_sym_cocoa] = ACTIONS(37),
    [anon_sym_cpp] = ACTIONS(37),
    [anon_sym_cpp2] = ACTIONS(35),
    [anon_sym_cpp_DOTnoexist] = ACTIONS(35),
    [anon_sym_csharp] = ACTIONS(37),
    [anon_sym_d] = ACTIONS(37),
    [anon_sym_dart] = ACTIONS(35),
    [anon_sym_delphi] = ACTIONS(37),
    [anon_sym_erl] = ACTIONS(35),
    [anon_sym_go] = ACTIONS(35),
    [anon_sym_haxe] = ACTIONS(35),
    [anon_sym_java] = ACTIONS(37),
    [anon_sym_javame] = ACTIONS(35),
    [anon_sym_js] = ACTIONS(37),
    [anon_sym_kotlin] = ACTIONS(35),
    [anon_sym_lua] = ACTIONS(35),
    [anon_sym_netcore] = ACTIONS(35),
    [anon_sym_netstd] = ACTIONS(35),
    [anon_sym_nodejs] = ACTIONS(35),
    [anon_sym_nodets] = ACTIONS(35),
    [anon_sym_noexist] = ACTIONS(35),
    [anon_sym_ocaml] = ACTIONS(35),
    [anon_sym_perl] = ACTIONS(37),
    [anon_sym_php] = ACTIONS(37),
    [anon_sym_php_DOTpath] = ACTIONS(35),
    [anon_sym_py] = ACTIONS(37),
    [anon_sym_py_DOTtwisted] = ACTIONS(35),
    [anon_sym_rb] = ACTIONS(35),
    [anon_sym_rs] = ACTIONS(35),
    [anon_sym_smalltalk_DOTprefix] = ACTIONS(35),
    [anon_sym_smalltalk_DOTcategory] = ACTIONS(35),
    [anon_sym_st] = ACTIONS(35),
    [anon_sym_swift] = ACTIONS(35),
    [anon_sym_ts] = ACTIONS(35),
    [anon_sym_xml] = ACTIONS(35),
    [anon_sym_xsd] = ACTIONS(37),
    [anon_sym_cocoa_prefix] = ACTIONS(35),
    [anon_sym_cpp_namespace] = ACTIONS(35),
    [anon_sym_csharp_namespace] = ACTIONS(35),
    [anon_sym_delphi_namespace] = ACTIONS(35),
    [anon_sym_java_package] = ACTIONS(35),
    [anon_sym_perl_package] = ACTIONS(35),
    [anon_sym_php_namespace] = ACTIONS(35),
    [anon_sym_py_module] = ACTIONS(35),
    [anon_sym_ruby_namespace] = ACTIONS(35),
    [anon_sym_smalltalk_category] = ACTIONS(35),
    [anon_sym_smalltalk_prefix] = ACTIONS(35),
    [anon_sym_xsd_namespace] = ACTIONS(35),
    [anon_sym_android] = ACTIONS(35),
    [anon_sym_hack] = ACTIONS(37),
    [anon_sym_hack_DOTmodule] = ACTIONS(35),
    [anon_sym_hs] = ACTIONS(37),
    [anon_sym_hs2] = ACTIONS(35),
    [anon_sym_java_DOTswift] = ACTIONS(37),
    [anon_sym_java_DOTswift_DOTconstants] = ACTIONS(35),
    [anon_sym_json] = ACTIONS(35),
    [anon_sym_py_DOTasyncio] = ACTIONS(35),
    [anon_sym_py3] = ACTIONS(35),
    [anon_sym_rust] = ACTIONS(35),
    [anon_sym_scala] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_DOT,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(41), 11,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
    ACTIONS(39), 44,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_xsd_all,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_extends,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [69] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 12,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
      anon_sym_DOT,
    ACTIONS(39), 44,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_xsd_all,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_extends,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [133] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(48), 6,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(46), 38,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [191] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    STATE(5), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(54), 6,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(52), 38,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [249] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(58), 1,
      anon_sym_AT,
    ACTIONS(61), 1,
      sym_number,
    STATE(7), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    ACTIONS(56), 38,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [303] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(65), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 2,
      anon_sym_AT,
      sym_number,
    ACTIONS(63), 38,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [354] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_namespace,
    ACTIONS(11), 1,
      anon_sym_package,
    ACTIONS(13), 1,
      anon_sym_const,
    ACTIONS(15), 1,
      anon_sym_typedef,
    ACTIONS(17), 1,
      anon_sym_enum,
    ACTIONS(19), 1,
      anon_sym_senum,
    ACTIONS(21), 1,
      anon_sym_struct,
    ACTIONS(23), 1,
      anon_sym_union,
    ACTIONS(25), 1,
      anon_sym_exception,
    ACTIONS(29), 1,
      anon_sym_service,
    ACTIONS(31), 1,
      anon_sym_interaction,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(69), 1,
      ts_builtin_sym_end,
    ACTIONS(7), 2,
      anon_sym_include,
      anon_sym_cpp_include,
    STATE(92), 2,
      sym_definition,
      aux_sym_document_repeat2,
    STATE(176), 2,
      sym_header,
      aux_sym_document_repeat1,
    STATE(369), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(524), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    STATE(325), 3,
      sym_include_statement,
      sym_namespace_declaration,
      sym_package_declaration,
    ACTIONS(27), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
    STATE(413), 9,
      sym_const_definition,
      sym_typedef_definition,
      sym_enum_definition,
      sym_senum_definition,
      sym_struct_definition,
      sym_union_definition,
      sym_exception_definition,
      sym_service_definition,
      sym_interaction_definition,
  [441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 2,
      anon_sym_AT,
      sym_number,
    ACTIONS(71), 38,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [489] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 2,
      anon_sym_AT,
      sym_number,
    ACTIONS(75), 38,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [537] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(25), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [615] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(101), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [693] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(103), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(28), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [771] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(105), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [849] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(107), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(21), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [927] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(109), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1005] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(111), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1083] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      sym_identifier,
    ACTIONS(116), 1,
      anon_sym_RBRACE,
    ACTIONS(118), 1,
      anon_sym_performs,
    ACTIONS(124), 1,
      anon_sym_void,
    ACTIONS(130), 1,
      anon_sym_list,
    ACTIONS(133), 1,
      anon_sym_map,
    ACTIONS(136), 1,
      anon_sym_set,
    ACTIONS(139), 1,
      anon_sym_sink,
    ACTIONS(142), 1,
      anon_sym_stream,
    ACTIONS(145), 1,
      anon_sym_AT,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(121), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(127), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1161] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(148), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1239] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(150), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1317] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(152), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(35), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1395] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(154), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1473] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(156), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(36), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1551] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(158), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1629] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(160), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(13), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1707] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(162), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(18), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1785] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(164), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1863] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(166), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(23), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [1941] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(168), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(20), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2019] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(170), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2097] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(172), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(17), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2175] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(174), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(31), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2253] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(176), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(15), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2331] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(178), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2409] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(83), 1,
      anon_sym_performs,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(180), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(19), 2,
      sym_function_definition,
      aux_sym_service_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2487] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(184), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2566] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      sym_identifier,
    ACTIONS(207), 1,
      anon_sym_RBRACE,
    ACTIONS(212), 1,
      anon_sym_void,
    ACTIONS(218), 1,
      anon_sym_list,
    ACTIONS(221), 1,
      anon_sym_map,
    ACTIONS(224), 1,
      anon_sym_set,
    ACTIONS(227), 1,
      anon_sym_sink,
    ACTIONS(230), 1,
      anon_sym_stream,
    ACTIONS(233), 1,
      anon_sym_AT,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(38), 2,
      sym_function_definition,
      aux_sym_interaction_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(209), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(215), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2641] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(236), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(52), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2720] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(238), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2799] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(240), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(77), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2878] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(242), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [2957] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(244), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3036] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(238), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(72), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3115] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(249), 1,
      anon_sym_RBRACE,
    ACTIONS(254), 1,
      anon_sym_void,
    ACTIONS(260), 1,
      anon_sym_list,
    ACTIONS(263), 1,
      anon_sym_map,
    ACTIONS(266), 1,
      anon_sym_set,
    ACTIONS(269), 1,
      anon_sym_sink,
    ACTIONS(272), 1,
      anon_sym_stream,
    ACTIONS(275), 1,
      anon_sym_AT,
    ACTIONS(278), 1,
      sym_number,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(251), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(257), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3194] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(281), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3273] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(283), 1,
      anon_sym_RPAREN,
    STATE(170), 1,
      sym_field_id,
    STATE(220), 1,
      sym_field_modifier,
    STATE(748), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(69), 2,
      sym_parameter,
      aux_sym_parameters_repeat1,
    STATE(85), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3352] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(285), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(61), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3431] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(287), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(38), 2,
      sym_function_definition,
      aux_sym_interaction_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3506] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(289), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3585] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(281), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(43), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3664] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(291), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3743] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(184), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(42), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3822] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(291), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(46), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3901] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(293), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [3980] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(295), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4059] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(297), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4138] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(289), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(74), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4217] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(297), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(37), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4296] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(285), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4375] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(299), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4454] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(301), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(38), 2,
      sym_function_definition,
      aux_sym_interaction_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4529] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(301), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(49), 2,
      sym_function_definition,
      aux_sym_interaction_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4604] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(303), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4683] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(305), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(50), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4762] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(307), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(57), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4841] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(309), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(60), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4920] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(170), 1,
      sym_field_id,
    STATE(220), 1,
      sym_field_modifier,
    STATE(748), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(47), 2,
      sym_parameter,
      aux_sym_parameters_repeat1,
    STATE(85), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [4999] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 1,
      sym_identifier,
    ACTIONS(316), 1,
      anon_sym_RPAREN,
    ACTIONS(321), 1,
      anon_sym_void,
    ACTIONS(327), 1,
      anon_sym_list,
    ACTIONS(330), 1,
      anon_sym_map,
    ACTIONS(333), 1,
      anon_sym_set,
    ACTIONS(336), 1,
      anon_sym_sink,
    ACTIONS(339), 1,
      anon_sym_stream,
    ACTIONS(342), 1,
      anon_sym_AT,
    ACTIONS(345), 1,
      sym_number,
    STATE(170), 1,
      sym_field_id,
    STATE(220), 1,
      sym_field_modifier,
    STATE(748), 1,
      sym_type,
    ACTIONS(318), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(69), 2,
      sym_parameter,
      aux_sym_parameters_repeat1,
    STATE(85), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(324), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5078] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(348), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(56), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5157] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5236] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(352), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5315] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(354), 1,
      anon_sym_RBRACE,
    STATE(214), 1,
      sym_function_modifier,
    STATE(621), 1,
      sym_type,
    STATE(62), 2,
      sym_function_definition,
      aux_sym_interaction_definition_repeat1,
    STATE(84), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5390] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(348), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5469] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(299), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(71), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5548] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(352), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(55), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5627] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    ACTIONS(356), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_field_id,
    STATE(230), 1,
      sym_field_modifier,
    STATE(631), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(45), 2,
      sym_field,
      aux_sym_struct_definition_repeat1,
    STATE(86), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [5706] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 10,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(358), 26,
      anon_sym_performs,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [5750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(364), 10,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(362), 26,
      anon_sym_performs,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [5794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 10,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(366), 26,
      anon_sym_performs,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [5838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 10,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 26,
      anon_sym_performs,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [5882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 10,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 26,
      anon_sym_performs,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [5926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 10,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(378), 26,
      anon_sym_performs,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [5970] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(224), 1,
      sym_function_modifier,
    STATE(630), 1,
      sym_type,
    STATE(7), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    ACTIONS(85), 4,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [6038] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    STATE(157), 1,
      sym_field_id,
    STATE(244), 1,
      sym_field_modifier,
    STATE(799), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(7), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [6110] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    ACTIONS(202), 1,
      sym_number,
    STATE(174), 1,
      sym_field_id,
    STATE(239), 1,
      sym_field_modifier,
    STATE(611), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(7), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [6182] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(386), 1,
      anon_sym_LBRACE,
    STATE(88), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(384), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(382), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6229] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(392), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(390), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(388), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6276] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(400), 1,
      anon_sym_EQ,
    ACTIONS(404), 1,
      anon_sym_xsd_optional,
    ACTIONS(406), 1,
      anon_sym_xsd_nillable,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(187), 1,
      sym_xsd_attrs,
    STATE(259), 1,
      sym_annotation_definition,
    ACTIONS(396), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(402), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(394), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6332] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 32,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_RBRACE,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_throws,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6370] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(416), 1,
      anon_sym_EQ,
    ACTIONS(420), 1,
      anon_sym_xsd_optional,
    ACTIONS(422), 1,
      anon_sym_xsd_nillable,
    STATE(202), 1,
      sym_xsd_attrs,
    STATE(268), 1,
      sym_annotation_definition,
    ACTIONS(414), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(418), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(412), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6426] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_const,
    ACTIONS(15), 1,
      anon_sym_typedef,
    ACTIONS(17), 1,
      anon_sym_enum,
    ACTIONS(19), 1,
      anon_sym_senum,
    ACTIONS(21), 1,
      anon_sym_struct,
    ACTIONS(23), 1,
      anon_sym_union,
    ACTIONS(25), 1,
      anon_sym_exception,
    ACTIONS(29), 1,
      anon_sym_service,
    ACTIONS(31), 1,
      anon_sym_interaction,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(424), 1,
      ts_builtin_sym_end,
    STATE(93), 2,
      sym_definition,
      aux_sym_document_repeat2,
    STATE(400), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(524), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(27), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
    STATE(413), 9,
      sym_const_definition,
      sym_typedef_definition,
      sym_enum_definition,
      sym_senum_definition,
      sym_struct_definition,
      sym_union_definition,
      sym_exception_definition,
      sym_service_definition,
      sym_interaction_definition,
  [6494] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      ts_builtin_sym_end,
    ACTIONS(428), 1,
      anon_sym_const,
    ACTIONS(431), 1,
      anon_sym_typedef,
    ACTIONS(434), 1,
      anon_sym_enum,
    ACTIONS(437), 1,
      anon_sym_senum,
    ACTIONS(440), 1,
      anon_sym_struct,
    ACTIONS(443), 1,
      anon_sym_union,
    ACTIONS(446), 1,
      anon_sym_exception,
    ACTIONS(452), 1,
      anon_sym_service,
    ACTIONS(455), 1,
      anon_sym_interaction,
    ACTIONS(458), 1,
      anon_sym_AT,
    STATE(93), 2,
      sym_definition,
      aux_sym_document_repeat2,
    STATE(400), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(524), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(449), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
    STATE(413), 9,
      sym_const_definition,
      sym_typedef_definition,
      sym_enum_definition,
      sym_senum_definition,
      sym_struct_definition,
      sym_union_definition,
      sym_exception_definition,
      sym_service_definition,
      sym_interaction_definition,
  [6562] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(465), 1,
      anon_sym_EQ,
    ACTIONS(469), 1,
      anon_sym_xsd_optional,
    ACTIONS(471), 1,
      anon_sym_xsd_nillable,
    STATE(184), 1,
      sym_xsd_attrs,
    STATE(253), 1,
      sym_annotation_definition,
    ACTIONS(463), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(467), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(461), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6618] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(477), 1,
      anon_sym_EQ,
    ACTIONS(481), 1,
      anon_sym_xsd_optional,
    ACTIONS(483), 1,
      anon_sym_xsd_nillable,
    STATE(177), 1,
      sym_xsd_attrs,
    STATE(247), 1,
      sym_annotation_definition,
    ACTIONS(475), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(479), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(473), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6674] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(489), 1,
      anon_sym_EQ,
    ACTIONS(493), 1,
      anon_sym_xsd_optional,
    ACTIONS(495), 1,
      anon_sym_xsd_nillable,
    STATE(191), 1,
      sym_xsd_attrs,
    STATE(252), 1,
      sym_annotation_definition,
    ACTIONS(487), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(491), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(485), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6730] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_const,
    ACTIONS(15), 1,
      anon_sym_typedef,
    ACTIONS(17), 1,
      anon_sym_enum,
    ACTIONS(19), 1,
      anon_sym_senum,
    ACTIONS(21), 1,
      anon_sym_struct,
    ACTIONS(23), 1,
      anon_sym_union,
    ACTIONS(25), 1,
      anon_sym_exception,
    ACTIONS(29), 1,
      anon_sym_service,
    ACTIONS(31), 1,
      anon_sym_interaction,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(69), 1,
      ts_builtin_sym_end,
    STATE(93), 2,
      sym_definition,
      aux_sym_document_repeat2,
    STATE(400), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(524), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(27), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
    STATE(413), 9,
      sym_const_definition,
      sym_typedef_definition,
      sym_enum_definition,
      sym_senum_definition,
      sym_struct_definition,
      sym_union_definition,
      sym_exception_definition,
      sym_service_definition,
      sym_interaction_definition,
  [6798] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(501), 1,
      anon_sym_EQ,
    ACTIONS(505), 1,
      anon_sym_xsd_optional,
    ACTIONS(507), 1,
      anon_sym_xsd_nillable,
    STATE(178), 1,
      sym_xsd_attrs,
    STATE(261), 1,
      sym_annotation_definition,
    ACTIONS(499), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(503), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(497), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6854] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(513), 1,
      anon_sym_EQ,
    ACTIONS(517), 1,
      anon_sym_xsd_optional,
    ACTIONS(519), 1,
      anon_sym_xsd_nillable,
    STATE(204), 1,
      sym_xsd_attrs,
    STATE(273), 1,
      sym_annotation_definition,
    ACTIONS(511), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(515), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(509), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [6910] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 32,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_RBRACE,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_throws,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6948] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(527), 1,
      anon_sym_EQ,
    ACTIONS(531), 1,
      anon_sym_xsd_optional,
    ACTIONS(533), 1,
      anon_sym_xsd_nillable,
    STATE(193), 1,
      sym_xsd_attrs,
    STATE(248), 1,
      sym_annotation_definition,
    ACTIONS(525), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(529), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(523), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7004] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(539), 1,
      anon_sym_EQ,
    ACTIONS(543), 1,
      anon_sym_xsd_optional,
    ACTIONS(545), 1,
      anon_sym_xsd_nillable,
    STATE(197), 1,
      sym_xsd_attrs,
    STATE(271), 1,
      sym_annotation_definition,
    ACTIONS(537), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(541), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(535), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7060] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(551), 1,
      anon_sym_EQ,
    ACTIONS(555), 1,
      anon_sym_xsd_optional,
    ACTIONS(557), 1,
      anon_sym_xsd_nillable,
    STATE(195), 1,
      sym_xsd_attrs,
    STATE(258), 1,
      sym_annotation_definition,
    ACTIONS(549), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(553), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(547), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7116] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(563), 1,
      anon_sym_EQ,
    ACTIONS(567), 1,
      anon_sym_xsd_optional,
    ACTIONS(569), 1,
      anon_sym_xsd_nillable,
    STATE(203), 1,
      sym_xsd_attrs,
    STATE(246), 1,
      sym_annotation_definition,
    ACTIONS(561), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(565), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(559), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7172] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(577), 1,
      anon_sym_throws,
    STATE(162), 1,
      sym_throws,
    STATE(199), 1,
      sym_annotation_definition,
    ACTIONS(573), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(575), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(571), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7221] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(543), 1,
      anon_sym_xsd_optional,
    ACTIONS(545), 1,
      anon_sym_xsd_nillable,
    STATE(197), 1,
      sym_xsd_attrs,
    STATE(271), 1,
      sym_annotation_definition,
    ACTIONS(537), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(541), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(535), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7274] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(404), 1,
      anon_sym_xsd_optional,
    ACTIONS(406), 1,
      anon_sym_xsd_nillable,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(187), 1,
      sym_xsd_attrs,
    STATE(259), 1,
      sym_annotation_definition,
    ACTIONS(396), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(402), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(394), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7327] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(585), 1,
      anon_sym_xsd_optional,
    ACTIONS(587), 1,
      anon_sym_xsd_nillable,
    STATE(180), 1,
      sym_xsd_attrs,
    STATE(274), 1,
      sym_annotation_definition,
    ACTIONS(581), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(583), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(579), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7380] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(577), 1,
      anon_sym_throws,
    STATE(167), 1,
      sym_throws,
    STATE(186), 1,
      sym_annotation_definition,
    ACTIONS(591), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(593), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(589), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7429] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(531), 1,
      anon_sym_xsd_optional,
    ACTIONS(533), 1,
      anon_sym_xsd_nillable,
    STATE(193), 1,
      sym_xsd_attrs,
    STATE(248), 1,
      sym_annotation_definition,
    ACTIONS(525), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(529), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(523), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7482] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(601), 1,
      anon_sym_xsd_optional,
    ACTIONS(603), 1,
      anon_sym_xsd_nillable,
    STATE(183), 1,
      sym_xsd_attrs,
    STATE(270), 1,
      sym_annotation_definition,
    ACTIONS(597), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(599), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(595), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7535] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(611), 1,
      anon_sym_xsd_optional,
    ACTIONS(613), 1,
      anon_sym_xsd_nillable,
    STATE(190), 1,
      sym_xsd_attrs,
    STATE(262), 1,
      sym_annotation_definition,
    ACTIONS(607), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(609), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(605), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7588] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(505), 1,
      anon_sym_xsd_optional,
    ACTIONS(507), 1,
      anon_sym_xsd_nillable,
    STATE(178), 1,
      sym_xsd_attrs,
    STATE(261), 1,
      sym_annotation_definition,
    ACTIONS(499), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(503), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(497), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7641] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(481), 1,
      anon_sym_xsd_optional,
    ACTIONS(483), 1,
      anon_sym_xsd_nillable,
    STATE(177), 1,
      sym_xsd_attrs,
    STATE(247), 1,
      sym_annotation_definition,
    ACTIONS(475), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(479), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(473), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7694] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(555), 1,
      anon_sym_xsd_optional,
    ACTIONS(557), 1,
      anon_sym_xsd_nillable,
    STATE(195), 1,
      sym_xsd_attrs,
    STATE(258), 1,
      sym_annotation_definition,
    ACTIONS(549), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(553), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(547), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7747] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(577), 1,
      anon_sym_throws,
    STATE(151), 1,
      sym_throws,
    STATE(200), 1,
      sym_annotation_definition,
    ACTIONS(617), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(619), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(615), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7796] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(469), 1,
      anon_sym_xsd_optional,
    ACTIONS(471), 1,
      anon_sym_xsd_nillable,
    STATE(184), 1,
      sym_xsd_attrs,
    STATE(253), 1,
      sym_annotation_definition,
    ACTIONS(463), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(467), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(461), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7849] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(627), 1,
      anon_sym_xsd_optional,
    ACTIONS(629), 1,
      anon_sym_xsd_nillable,
    STATE(181), 1,
      sym_xsd_attrs,
    STATE(269), 1,
      sym_annotation_definition,
    ACTIONS(623), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(625), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(621), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7902] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(577), 1,
      anon_sym_throws,
    STATE(158), 1,
      sym_throws,
    STATE(198), 1,
      sym_annotation_definition,
    ACTIONS(633), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(635), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(631), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [7951] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(577), 1,
      anon_sym_throws,
    STATE(171), 1,
      sym_throws,
    STATE(179), 1,
      sym_annotation_definition,
    ACTIONS(639), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(641), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(637), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8000] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(533), 1,
      anon_sym_xsd_nillable,
    STATE(193), 1,
      sym_xsd_attrs,
    STATE(248), 1,
      sym_annotation_definition,
    ACTIONS(525), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(529), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(523), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(643), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8088] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(587), 1,
      anon_sym_xsd_nillable,
    STATE(180), 1,
      sym_xsd_attrs,
    STATE(274), 1,
      sym_annotation_definition,
    ACTIONS(581), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(583), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(579), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8138] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 6,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
    ACTIONS(647), 24,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8176] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(471), 1,
      anon_sym_xsd_nillable,
    STATE(184), 1,
      sym_xsd_attrs,
    STATE(253), 1,
      sym_annotation_definition,
    ACTIONS(463), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(467), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(461), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8226] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(519), 1,
      anon_sym_xsd_nillable,
    STATE(204), 1,
      sym_xsd_attrs,
    STATE(273), 1,
      sym_annotation_definition,
    ACTIONS(511), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(515), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(509), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8276] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(483), 1,
      anon_sym_xsd_nillable,
    STATE(177), 1,
      sym_xsd_attrs,
    STATE(247), 1,
      sym_annotation_definition,
    ACTIONS(475), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(479), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(473), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8326] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(422), 1,
      anon_sym_xsd_nillable,
    STATE(202), 1,
      sym_xsd_attrs,
    STATE(268), 1,
      sym_annotation_definition,
    ACTIONS(414), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(418), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(412), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8376] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(507), 1,
      anon_sym_xsd_nillable,
    STATE(178), 1,
      sym_xsd_attrs,
    STATE(261), 1,
      sym_annotation_definition,
    ACTIONS(499), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(503), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(497), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8426] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(603), 1,
      anon_sym_xsd_nillable,
    STATE(183), 1,
      sym_xsd_attrs,
    STATE(270), 1,
      sym_annotation_definition,
    ACTIONS(597), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(599), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(595), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8476] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(657), 1,
      anon_sym_xsd_nillable,
    STATE(189), 1,
      sym_xsd_attrs,
    STATE(264), 1,
      sym_annotation_definition,
    ACTIONS(653), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(655), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(651), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8526] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(659), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8564] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(545), 1,
      anon_sym_xsd_nillable,
    STATE(197), 1,
      sym_xsd_attrs,
    STATE(271), 1,
      sym_annotation_definition,
    ACTIONS(537), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(541), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(535), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8614] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_xsd_nillable,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(187), 1,
      sym_xsd_attrs,
    STATE(259), 1,
      sym_annotation_definition,
    ACTIONS(396), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(402), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(394), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8664] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(661), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8702] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(629), 1,
      anon_sym_xsd_nillable,
    STATE(181), 1,
      sym_xsd_attrs,
    STATE(269), 1,
      sym_annotation_definition,
    ACTIONS(623), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(625), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(621), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8752] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(557), 1,
      anon_sym_xsd_nillable,
    STATE(195), 1,
      sym_xsd_attrs,
    STATE(258), 1,
      sym_annotation_definition,
    ACTIONS(549), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(553), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(547), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8802] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(669), 1,
      anon_sym_xsd_nillable,
    STATE(194), 1,
      sym_xsd_attrs,
    STATE(277), 1,
      sym_annotation_definition,
    ACTIONS(665), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(667), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(663), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(671), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(675), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(679), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [8966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(683), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(687), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 6,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
    ACTIONS(691), 24,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_throws,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9080] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    ACTIONS(613), 1,
      anon_sym_xsd_nillable,
    STATE(190), 1,
      sym_xsd_attrs,
    STATE(262), 1,
      sym_annotation_definition,
    ACTIONS(607), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(609), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(605), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9130] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(695), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(699), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9206] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(703), 23,
      anon_sym_xsd_optional,
      anon_sym_xsd_nillable,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_xsd_attrs,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9244] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(178), 1,
      sym_xsd_attrs,
    STATE(261), 1,
      sym_annotation_definition,
    ACTIONS(499), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(503), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(497), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9291] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(185), 1,
      sym_xsd_attrs,
    STATE(263), 1,
      sym_annotation_definition,
    ACTIONS(709), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(711), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(707), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9338] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(188), 1,
      sym_annotation_definition,
    ACTIONS(715), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(717), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(713), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9381] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(190), 1,
      sym_xsd_attrs,
    STATE(262), 1,
      sym_annotation_definition,
    ACTIONS(607), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(609), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(605), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9428] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(180), 1,
      sym_xsd_attrs,
    STATE(274), 1,
      sym_annotation_definition,
    ACTIONS(581), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(583), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(579), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9475] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 6,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_AT,
    ACTIONS(719), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9512] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(192), 1,
      sym_xsd_attrs,
    STATE(254), 1,
      sym_annotation_definition,
    ACTIONS(725), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(727), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(723), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9559] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(187), 1,
      sym_xsd_attrs,
    STATE(259), 1,
      sym_annotation_definition,
    ACTIONS(396), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(402), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(394), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9606] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(236), 1,
      sym_field_modifier,
    STATE(739), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [9665] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(186), 1,
      sym_annotation_definition,
    ACTIONS(591), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(593), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(589), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9708] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(195), 1,
      sym_xsd_attrs,
    STATE(258), 1,
      sym_annotation_definition,
    ACTIONS(549), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(553), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(547), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9755] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(193), 1,
      sym_xsd_attrs,
    STATE(248), 1,
      sym_annotation_definition,
    ACTIONS(525), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(529), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(523), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9802] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    STATE(239), 1,
      sym_field_modifier,
    STATE(611), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [9861] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(179), 1,
      sym_annotation_definition,
    ACTIONS(639), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(641), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(637), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9904] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(194), 1,
      sym_xsd_attrs,
    STATE(277), 1,
      sym_annotation_definition,
    ACTIONS(665), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(667), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(663), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9951] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(183), 1,
      sym_xsd_attrs,
    STATE(270), 1,
      sym_annotation_definition,
    ACTIONS(597), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(599), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(595), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [9998] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(177), 1,
      sym_xsd_attrs,
    STATE(247), 1,
      sym_annotation_definition,
    ACTIONS(475), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(479), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(473), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10045] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(181), 1,
      sym_xsd_attrs,
    STATE(269), 1,
      sym_annotation_definition,
    ACTIONS(623), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(625), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(621), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10092] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(200), 1,
      sym_annotation_definition,
    ACTIONS(617), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(619), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(615), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10135] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(204), 1,
      sym_xsd_attrs,
    STATE(273), 1,
      sym_annotation_definition,
    ACTIONS(511), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(515), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(509), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10182] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(189), 1,
      sym_xsd_attrs,
    STATE(264), 1,
      sym_annotation_definition,
    ACTIONS(653), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(655), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(651), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10229] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(244), 1,
      sym_field_modifier,
    STATE(799), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [10288] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_annotation_definition,
    ACTIONS(633), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(635), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(631), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10331] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(202), 1,
      sym_xsd_attrs,
    STATE(268), 1,
      sym_annotation_definition,
    ACTIONS(414), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(418), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(412), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10378] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(184), 1,
      sym_xsd_attrs,
    STATE(253), 1,
      sym_annotation_definition,
    ACTIONS(463), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(467), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(461), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10425] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    STATE(223), 1,
      sym_field_modifier,
    STATE(599), 1,
      sym_type,
    ACTIONS(186), 2,
      anon_sym_required,
      anon_sym_optional,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [10484] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(408), 1,
      anon_sym_xsd_attrs,
    STATE(197), 1,
      sym_xsd_attrs,
    STATE(271), 1,
      sym_annotation_definition,
    ACTIONS(537), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(541), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(535), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10531] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_namespace,
    ACTIONS(737), 1,
      anon_sym_package,
    ACTIONS(740), 1,
      anon_sym_AT,
    ACTIONS(731), 2,
      anon_sym_include,
      anon_sym_cpp_include,
    STATE(176), 2,
      sym_header,
      aux_sym_document_repeat1,
    STATE(641), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(325), 3,
      sym_include_statement,
      sym_namespace_declaration,
      sym_package_declaration,
    ACTIONS(729), 16,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
  [10579] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(258), 1,
      sym_annotation_definition,
    ACTIONS(549), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(553), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(547), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10620] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(259), 1,
      sym_annotation_definition,
    ACTIONS(396), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(402), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(394), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10661] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(635), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(631), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10698] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(269), 1,
      sym_annotation_definition,
    ACTIONS(623), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(625), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(621), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10739] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(264), 1,
      sym_annotation_definition,
    ACTIONS(653), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(655), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(651), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(743), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10815] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(277), 1,
      sym_annotation_definition,
    ACTIONS(665), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(667), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(663), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10856] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(262), 1,
      sym_annotation_definition,
    ACTIONS(607), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(609), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(605), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10897] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(249), 1,
      sym_annotation_definition,
    ACTIONS(749), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(751), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(747), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10938] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(619), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(615), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [10975] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(274), 1,
      sym_annotation_definition,
    ACTIONS(581), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(583), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(579), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11016] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(757), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(753), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11053] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(254), 1,
      sym_annotation_definition,
    ACTIONS(725), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(727), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(723), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11094] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(270), 1,
      sym_annotation_definition,
    ACTIONS(597), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(599), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(595), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11135] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(273), 1,
      sym_annotation_definition,
    ACTIONS(511), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(515), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(509), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11176] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(256), 1,
      sym_annotation_definition,
    ACTIONS(761), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(763), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(759), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11217] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(253), 1,
      sym_annotation_definition,
    ACTIONS(463), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(467), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(461), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11258] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(263), 1,
      sym_annotation_definition,
    ACTIONS(709), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(711), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(707), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11299] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_annotation_definition,
    ACTIONS(525), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(529), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(523), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11340] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      sym_number,
    ACTIONS(765), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11375] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(261), 1,
      sym_annotation_definition,
    ACTIONS(499), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(503), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(497), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11416] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(593), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(589), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11453] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(641), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(637), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11490] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(717), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(713), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11527] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      anon_sym_DOT,
    STATE(201), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(41), 25,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_LBRACE,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [11564] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(247), 1,
      sym_annotation_definition,
    ACTIONS(475), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(479), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(473), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11605] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(268), 1,
      sym_annotation_definition,
    ACTIONS(414), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(418), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(412), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11646] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(271), 1,
      sym_annotation_definition,
    ACTIONS(537), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(541), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(535), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [11687] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 26,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_LBRACE,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DOT,
  [11719] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(800), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [11771] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(594), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [11823] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(600), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [11875] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(832), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [11927] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(785), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [11979] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(760), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12031] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(787), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12083] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(775), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12135] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(630), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12187] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(605), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12239] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(792), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12291] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(723), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12343] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(805), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12395] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(683), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12447] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(799), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12499] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(614), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12551] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(772), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12603] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    STATE(613), 1,
      sym_type,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12655] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(616), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12707] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(736), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12759] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(685), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12811] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(711), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12863] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(637), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12915] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(603), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [12967] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    STATE(611), 1,
      sym_type,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13019] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(878), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13071] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(774), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13123] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(717), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13175] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(682), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13227] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(686), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13279] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(680), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13331] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(687), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13383] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 1,
      anon_sym_SEMI,
    ACTIONS(778), 1,
      anon_sym_LPAREN,
    ACTIONS(780), 1,
      anon_sym_DOT,
    STATE(243), 1,
      aux_sym__type_identifier_repeat1,
    STATE(312), 1,
      sym_namespace_uri,
    ACTIONS(774), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [13425] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      sym_identifier,
    ACTIONS(188), 1,
      anon_sym_void,
    ACTIONS(192), 1,
      anon_sym_list,
    ACTIONS(194), 1,
      anon_sym_map,
    ACTIONS(196), 1,
      anon_sym_set,
    ACTIONS(198), 1,
      anon_sym_sink,
    ACTIONS(200), 1,
      anon_sym_stream,
    STATE(599), 1,
      sym_type,
    STATE(721), 2,
      sym_primitive,
      sym_container_type,
    STATE(724), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(190), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13477] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(627), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13529] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(604), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13581] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(678), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13633] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      anon_sym_LPAREN,
    ACTIONS(780), 1,
      anon_sym_DOT,
    ACTIONS(784), 1,
      anon_sym_SEMI,
    STATE(201), 1,
      aux_sym__type_identifier_repeat1,
    STATE(306), 1,
      sym_namespace_uri,
    ACTIONS(782), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [13675] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    STATE(739), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13727] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(87), 1,
      anon_sym_void,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(772), 1,
      anon_sym_list,
    STATE(756), 1,
      sym_type,
    STATE(593), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [13779] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(418), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(412), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [13814] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(553), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(547), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [13849] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(467), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(461), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [13884] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(790), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(786), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [13919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(631), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [13952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(757), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(753), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [13985] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(515), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(509), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14020] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(609), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(605), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14055] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(763), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(759), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14090] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(792), 1,
      sym_identifier,
    STATE(695), 1,
      sym_definition_type,
    STATE(810), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [14139] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(798), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(794), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14174] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(615), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14207] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(529), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(523), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(583), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(579), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(589), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14310] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(402), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(394), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14345] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(599), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(595), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14380] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(751), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(747), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14415] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(725), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(727), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(723), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(637), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(800), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(804), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14549] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(479), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(473), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14584] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(655), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(651), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14619] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(667), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(663), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14654] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(503), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(497), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(808), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14722] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(541), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(535), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14757] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(625), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(621), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14792] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_list,
    ACTIONS(93), 1,
      anon_sym_map,
    ACTIONS(95), 1,
      anon_sym_set,
    ACTIONS(97), 1,
      anon_sym_sink,
    ACTIONS(99), 1,
      anon_sym_stream,
    ACTIONS(792), 1,
      sym_identifier,
    STATE(770), 1,
      sym_definition_type,
    STATE(810), 2,
      sym_primitive,
      sym_container_type,
    STATE(619), 5,
      sym_list,
      sym_map,
      sym_set,
      sym_sink,
      sym_stream,
    ACTIONS(89), 11,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
  [14841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(717), 2,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(713), 23,
      anon_sym_performs,
      anon_sym_async,
      anon_sym_oneway,
      anon_sym_readonly,
      anon_sym_idempotent,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14874] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(709), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(711), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(707), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14909] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      anon_sym_LPAREN,
    ACTIONS(814), 1,
      anon_sym_SEMI,
    STATE(313), 1,
      sym_namespace_uri,
    ACTIONS(812), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [14945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(655), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(651), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [14976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(547), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(497), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15038] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(816), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(412), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(523), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(820), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15162] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(707), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(621), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15224] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(605), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(759), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15286] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(461), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(394), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15348] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_DOT,
    ACTIONS(824), 1,
      anon_sym_LBRACE,
    STATE(201), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(390), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [15383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(747), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15414] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_DOT,
    ACTIONS(826), 1,
      anon_sym_LBRACE,
    STATE(292), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(384), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [15449] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(786), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(535), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(509), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15542] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(723), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15573] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(667), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(663), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(595), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_number,
    ACTIONS(473), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(579), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 3,
      anon_sym_RPAREN,
      anon_sym_AT,
      sym_number,
    ACTIONS(794), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [15728] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [15756] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [15784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 1,
      anon_sym_SEMI,
    ACTIONS(828), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [15814] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [15842] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [15870] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [15898] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [15926] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [15954] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_SEMI,
    ACTIONS(832), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [15984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      anon_sym_SEMI,
    ACTIONS(836), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16014] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [16042] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 22,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16070] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
  [16098] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16125] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(335), 1,
      sym_annotation_definition,
    ACTIONS(846), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(844), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16158] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16185] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16212] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16239] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(355), 1,
      sym_annotation_definition,
    ACTIONS(856), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(854), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16272] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16326] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16353] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(347), 1,
      sym_annotation_definition,
    ACTIONS(864), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(862), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16386] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(340), 1,
      sym_annotation_definition,
    ACTIONS(868), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(866), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16419] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16446] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 21,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_cpp_include,
      anon_sym_namespace,
      anon_sym_package,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16500] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(378), 1,
      sym_annotation_definition,
    ACTIONS(876), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(874), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16533] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 20,
      anon_sym_required,
      anon_sym_optional,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [16559] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(420), 1,
      sym_annotation_definition,
    ACTIONS(880), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16588] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(401), 1,
      sym_annotation_definition,
    ACTIONS(882), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(886), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(884), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16644] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(437), 1,
      sym_annotation_definition,
    ACTIONS(888), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16673] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(478), 1,
      sym_annotation_definition,
    ACTIONS(890), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16702] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(419), 1,
      sym_annotation_definition,
    ACTIONS(892), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16731] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(468), 1,
      sym_annotation_definition,
    ACTIONS(894), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16760] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(896), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16787] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(475), 1,
      sym_annotation_definition,
    ACTIONS(900), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16816] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(422), 1,
      sym_annotation_definition,
    ACTIONS(902), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16845] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(414), 1,
      sym_annotation_definition,
    ACTIONS(904), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16874] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(472), 1,
      sym_annotation_definition,
    ACTIONS(906), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16903] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(410), 1,
      sym_annotation_definition,
    ACTIONS(908), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16932] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(441), 1,
      sym_annotation_definition,
    ACTIONS(910), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(914), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(912), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [16988] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(409), 1,
      sym_annotation_definition,
    ACTIONS(916), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17017] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(407), 1,
      sym_annotation_definition,
    ACTIONS(918), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17046] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(450), 1,
      sym_annotation_definition,
    ACTIONS(920), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [17100] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [17125] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(452), 1,
      sym_annotation_definition,
    ACTIONS(922), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17154] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [17179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(844), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17206] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(408), 1,
      sym_annotation_definition,
    ACTIONS(924), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(364), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [17260] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(406), 1,
      sym_annotation_definition,
    ACTIONS(926), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17289] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(425), 1,
      sym_annotation_definition,
    ACTIONS(928), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17318] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(427), 1,
      sym_annotation_definition,
    ACTIONS(930), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17347] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [17372] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_COMMA,
      anon_sym_AT,
  [17397] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(405), 1,
      sym_annotation_definition,
    ACTIONS(932), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17426] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(462), 1,
      sym_annotation_definition,
    ACTIONS(934), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17455] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(460), 1,
      sym_annotation_definition,
    ACTIONS(936), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17484] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(415), 1,
      sym_annotation_definition,
    ACTIONS(938), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(459), 1,
      sym_annotation_definition,
    ACTIONS(940), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17542] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(404), 1,
      sym_annotation_definition,
    ACTIONS(942), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17571] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(944), 1,
      anon_sym_package,
    ACTIONS(946), 1,
      anon_sym_const,
    ACTIONS(948), 1,
      anon_sym_typedef,
    ACTIONS(950), 1,
      anon_sym_enum,
    ACTIONS(952), 1,
      anon_sym_struct,
    ACTIONS(954), 1,
      anon_sym_union,
    ACTIONS(956), 1,
      anon_sym_exception,
    ACTIONS(958), 1,
      anon_sym_service,
    STATE(7), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(523), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(27), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
  [17618] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(466), 1,
      sym_annotation_definition,
    ACTIONS(960), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17647] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(403), 1,
      sym_annotation_definition,
    ACTIONS(962), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17676] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(454), 1,
      sym_annotation_definition,
    ACTIONS(964), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17705] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(456), 1,
      sym_annotation_definition,
    ACTIONS(966), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17734] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(470), 1,
      sym_annotation_definition,
    ACTIONS(968), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17763] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(458), 1,
      sym_annotation_definition,
    ACTIONS(970), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17792] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(446), 1,
      sym_annotation_definition,
    ACTIONS(972), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17821] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(461), 1,
      sym_annotation_definition,
    ACTIONS(974), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(976), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17877] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(445), 1,
      sym_annotation_definition,
    ACTIONS(980), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17906] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(474), 1,
      sym_annotation_definition,
    ACTIONS(982), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17935] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(467), 1,
      sym_annotation_definition,
    ACTIONS(984), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17964] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(443), 1,
      sym_annotation_definition,
    ACTIONS(986), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [17993] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(402), 1,
      sym_annotation_definition,
    ACTIONS(988), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18022] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(476), 1,
      sym_annotation_definition,
    ACTIONS(990), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18051] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(418), 1,
      sym_annotation_definition,
    ACTIONS(992), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18080] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(430), 1,
      sym_annotation_definition,
    ACTIONS(994), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18109] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(479), 1,
      sym_annotation_definition,
    ACTIONS(996), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18138] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(416), 1,
      sym_annotation_definition,
    ACTIONS(998), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18167] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(411), 1,
      sym_annotation_definition,
    ACTIONS(1000), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18196] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(477), 1,
      sym_annotation_definition,
    ACTIONS(1002), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18225] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(423), 1,
      sym_annotation_definition,
    ACTIONS(1004), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18254] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(471), 1,
      sym_annotation_definition,
    ACTIONS(1006), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18283] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(429), 1,
      sym_annotation_definition,
    ACTIONS(1008), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18312] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(412), 1,
      sym_annotation_definition,
    ACTIONS(1010), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18341] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(455), 1,
      sym_annotation_definition,
    ACTIONS(1012), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18370] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(435), 1,
      sym_annotation_definition,
    ACTIONS(1014), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18399] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(432), 1,
      sym_annotation_definition,
    ACTIONS(1016), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18428] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 18,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [18452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 18,
      anon_sym_void,
      anon_sym_binary,
      anon_sym_bool,
      anon_sym_byte,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_float,
      anon_sym_double,
      anon_sym_string,
      anon_sym_slist,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_sink,
      anon_sym_stream,
      sym_identifier,
  [18476] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(946), 1,
      anon_sym_const,
    ACTIONS(948), 1,
      anon_sym_typedef,
    ACTIONS(950), 1,
      anon_sym_enum,
    ACTIONS(952), 1,
      anon_sym_struct,
    ACTIONS(954), 1,
      anon_sym_union,
    ACTIONS(956), 1,
      anon_sym_exception,
    ACTIONS(958), 1,
      anon_sym_service,
    STATE(7), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
    STATE(523), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(27), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
  [18520] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18543] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18566] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18589] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18612] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18658] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18681] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18704] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18727] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18750] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18773] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18796] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18819] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18842] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18888] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18911] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18934] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18957] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [18980] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_identifier,
    ACTIONS(1047), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_RBRACE,
    ACTIONS(1058), 1,
      anon_sym_LBRACK,
    ACTIONS(1061), 1,
      anon_sym_DQUOTE,
    ACTIONS(1064), 1,
      anon_sym_SQUOTE,
    STATE(421), 1,
      aux_sym_map_literal_repeat1,
    STATE(884), 1,
      sym_literal,
    ACTIONS(1052), 2,
      sym_number,
      sym_double,
    ACTIONS(1055), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19023] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19046] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19069] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1069), 1,
      sym_identifier,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1081), 1,
      anon_sym_LBRACK,
    ACTIONS(1084), 1,
      anon_sym_RBRACK,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    STATE(424), 1,
      aux_sym_list_literal_repeat1,
    STATE(516), 1,
      sym_literal,
    ACTIONS(1075), 2,
      sym_number,
      sym_double,
    ACTIONS(1078), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19112] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19135] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19158] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19181] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19204] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19250] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1108), 1,
      anon_sym_RBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    STATE(424), 1,
      aux_sym_list_literal_repeat1,
    STATE(516), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19293] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19316] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1118), 1,
      anon_sym_RBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(421), 1,
      aux_sym_map_literal_repeat1,
    STATE(884), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19359] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    ACTIONS(1130), 1,
      anon_sym_RBRACK,
    STATE(431), 1,
      aux_sym_list_literal_repeat1,
    STATE(516), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19402] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19425] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1132), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19448] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19471] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1136), 1,
      anon_sym_RBRACE,
    STATE(433), 1,
      aux_sym_map_literal_repeat1,
    STATE(884), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19514] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1138), 1,
      anon_sym_RBRACE,
    STATE(421), 1,
      aux_sym_map_literal_repeat1,
    STATE(884), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19557] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19580] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19603] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19626] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19649] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    ACTIONS(1140), 1,
      anon_sym_RBRACK,
    STATE(424), 1,
      aux_sym_list_literal_repeat1,
    STATE(516), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19692] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19715] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1144), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19738] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19761] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1146), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19784] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19807] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19830] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1148), 1,
      anon_sym_RBRACE,
    STATE(439), 1,
      aux_sym_map_literal_repeat1,
    STATE(884), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19873] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19896] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    ACTIONS(1150), 1,
      anon_sym_RBRACK,
    STATE(444), 1,
      aux_sym_list_literal_repeat1,
    STATE(516), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [19939] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19962] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [19985] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1154), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20008] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1156), 1,
      anon_sym_RBRACE,
    STATE(465), 1,
      aux_sym_map_literal_repeat1,
    STATE(884), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20051] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20074] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20097] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20120] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1160), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20143] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20166] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    ACTIONS(1162), 1,
      anon_sym_RBRACK,
    STATE(424), 1,
      aux_sym_list_literal_repeat1,
    STATE(516), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20209] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    ACTIONS(1164), 1,
      anon_sym_RBRACK,
    STATE(463), 1,
      aux_sym_list_literal_repeat1,
    STATE(516), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20252] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1166), 1,
      anon_sym_RBRACE,
    STATE(421), 1,
      aux_sym_map_literal_repeat1,
    STATE(884), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20295] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20318] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20341] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20364] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1174), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20387] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20433] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20456] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20479] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20502] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20525] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20548] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20571] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20594] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20617] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 17,
      ts_builtin_sym_end,
      anon_sym_const,
      anon_sym_typedef,
      anon_sym_enum,
      anon_sym_senum,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
      anon_sym_service,
      anon_sym_interaction,
      anon_sym_AT,
  [20640] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(106), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20677] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1202), 1,
      sym_identifier,
    STATE(322), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20714] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1202), 1,
      sym_identifier,
    STATE(318), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20751] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(114), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20788] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(696), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20825] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    STATE(515), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20862] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(788), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20899] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1204), 1,
      anon_sym_LBRACE,
    ACTIONS(1206), 1,
      anon_sym_DOT,
    STATE(497), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(388), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(390), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [20928] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(118), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [20965] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      anon_sym_DOT,
    ACTIONS(1208), 1,
      anon_sym_LBRACE,
    STATE(488), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(382), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(384), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [20994] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(113), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21031] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(112), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21068] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(115), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21105] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(108), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21142] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(110), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21179] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(808), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21216] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 1,
      anon_sym_DOT,
    STATE(497), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(39), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(41), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21243] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(744), 1,
      sym_literal,
    ACTIONS(1120), 2,
      sym_number,
      sym_double,
    ACTIONS(1122), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21280] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(107), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21317] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(111), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21354] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1106), 1,
      anon_sym_LBRACK,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(708), 1,
      sym_literal,
    ACTIONS(1102), 2,
      sym_number,
      sym_double,
    ACTIONS(1104), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(507), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21391] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      anon_sym_SQUOTE,
    STATE(117), 1,
      sym_literal,
    ACTIONS(1192), 2,
      sym_number,
      sym_double,
    ACTIONS(1194), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(139), 5,
      sym_boolean,
      sym_list_literal,
      sym_map_literal,
      sym_struct_literal,
      sym_string,
  [21428] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(659), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(521), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(410), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21472] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 6,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_DOT,
    ACTIONS(41), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(675), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(677), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(673), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21536] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(697), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(681), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(645), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(705), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(689), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21641] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(701), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(683), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(685), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1215), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(1219), 5,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21705] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1223), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1221), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(1225), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1227), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(1229), 5,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1084), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(1231), 5,
      sym_number,
      sym_double,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [21763] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym__identifier_with_dots_token1,
  [21778] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym__identifier_with_dots_token1,
  [21793] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1233), 1,
      anon_sym_exception,
    STATE(521), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(1235), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
  [21812] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym__identifier_with_dots_token1,
  [21827] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1238), 1,
      anon_sym_exception,
    STATE(521), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(27), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
  [21846] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_exception,
    STATE(521), 2,
      sym_exception_modifier,
      aux_sym_exception_definition_repeat1,
    ACTIONS(27), 6,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
  [21865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym__identifier_with_dots_token1,
  [21880] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym__identifier_with_dots_token1,
  [21895] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(364), 9,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      aux_sym__identifier_with_dots_token1,
  [21910] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1244), 1,
      anon_sym_EQ,
    STATE(597), 1,
      sym_annotation_definition,
    ACTIONS(1240), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1246), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [21932] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(551), 1,
      sym_annotation_definition,
    STATE(633), 1,
      sym_string,
    ACTIONS(1248), 3,
      anon_sym_COMMA,
      anon_sym_throws,
      anon_sym_GT,
  [21956] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1252), 1,
      anon_sym_EQ,
    STATE(587), 1,
      sym_annotation_definition,
    ACTIONS(1250), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1254), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [21978] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(539), 1,
      sym_annotation_definition,
    STATE(635), 1,
      sym_string,
    ACTIONS(1256), 3,
      anon_sym_COMMA,
      anon_sym_throws,
      anon_sym_GT,
  [22002] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1246), 1,
      anon_sym_RBRACE,
    ACTIONS(1258), 1,
      anon_sym_AT,
    ACTIONS(1261), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(532), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22025] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 1,
      anon_sym_RBRACE,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(544), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22048] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    ACTIONS(1270), 1,
      anon_sym_RBRACE,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(532), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22071] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_DOT,
    STATE(535), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(41), 5,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [22088] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    STATE(573), 1,
      sym_annotation_definition,
    STATE(633), 1,
      sym_string,
    ACTIONS(1248), 2,
      anon_sym_COMMA,
      sym_identifier,
  [22111] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    ACTIONS(1270), 1,
      anon_sym_RBRACE,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(538), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22134] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    ACTIONS(1275), 1,
      anon_sym_RBRACE,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(532), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22157] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(633), 1,
      sym_string,
    ACTIONS(1248), 4,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_throws,
      anon_sym_GT,
  [22176] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    STATE(558), 1,
      sym_annotation_definition,
    STATE(635), 1,
      sym_string,
    ACTIONS(1256), 2,
      anon_sym_COMMA,
      sym_identifier,
  [22199] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    STATE(549), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(1277), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1279), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [22218] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 1,
      anon_sym_RBRACE,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(532), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22241] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(617), 1,
      sym_annotation_definition,
    ACTIONS(1281), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1283), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [22260] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    ACTIONS(1285), 1,
      anon_sym_RBRACE,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(532), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22283] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1287), 1,
      anon_sym_DQUOTE,
    ACTIONS(1289), 1,
      anon_sym_SQUOTE,
    STATE(562), 1,
      sym_annotation_definition,
    STATE(754), 1,
      sym_string,
    ACTIONS(1248), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [22306] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1291), 7,
      anon_sym_exception,
      anon_sym_client,
      anon_sym_permanent,
      anon_sym_server,
      anon_sym_safe,
      anon_sym_stateful,
      anon_sym_transient,
  [22319] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(622), 1,
      sym_annotation_definition,
    ACTIONS(1293), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1295), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [22338] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    ACTIONS(1297), 1,
      anon_sym_RBRACE,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(534), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22361] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(1299), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1301), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [22380] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1268), 1,
      aux_sym__identifier_with_dots_token1,
    ACTIONS(1303), 1,
      anon_sym_RBRACE,
    STATE(530), 1,
      sym__identifier_with_dots,
    STATE(542), 1,
      aux_sym_enum_definition_repeat1,
    STATE(632), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [22403] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(592), 1,
      sym_string,
    ACTIONS(1305), 4,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_throws,
      anon_sym_GT,
  [22422] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1287), 1,
      anon_sym_DQUOTE,
    ACTIONS(1289), 1,
      anon_sym_SQUOTE,
    STATE(564), 1,
      sym_annotation_definition,
    STATE(745), 1,
      sym_string,
    ACTIONS(1256), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [22445] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(636), 1,
      sym_annotation_definition,
    ACTIONS(1307), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1309), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22463] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(618), 1,
      sym_annotation_definition,
    ACTIONS(1311), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1313), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22481] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(588), 1,
      sym_annotation_definition,
    ACTIONS(1315), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1317), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22499] = 5,
    ACTIONS(1319), 1,
      anon_sym_DQUOTE,
    ACTIONS(1321), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1323), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(585), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [22517] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_SQUOTE,
    ACTIONS(1329), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1331), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(571), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22535] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    STATE(633), 1,
      sym_string,
    ACTIONS(1248), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_identifier,
  [22553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 6,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
      anon_sym_DOT,
  [22565] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_DQUOTE,
    ACTIONS(1333), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1335), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(572), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [22583] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(608), 1,
      sym_annotation_definition,
    ACTIONS(1337), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1339), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22601] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 1,
      anon_sym_DQUOTE,
    ACTIONS(1289), 1,
      anon_sym_SQUOTE,
    STATE(764), 1,
      sym_string,
    ACTIONS(1305), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [22619] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1341), 1,
      anon_sym_SQUOTE,
    ACTIONS(1343), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1345), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(557), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22637] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 1,
      anon_sym_DQUOTE,
    ACTIONS(1289), 1,
      anon_sym_SQUOTE,
    STATE(754), 1,
      sym_string,
    ACTIONS(1248), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [22655] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1341), 1,
      anon_sym_DQUOTE,
    ACTIONS(1347), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1349), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(560), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [22673] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(591), 1,
      sym_annotation_definition,
    ACTIONS(1351), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1353), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22691] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1329), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1355), 1,
      anon_sym_SQUOTE,
    ACTIONS(1331), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(571), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22709] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1333), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1355), 1,
      anon_sym_DQUOTE,
    ACTIONS(1335), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(572), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [22727] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1357), 1,
      anon_sym_SQUOTE,
    ACTIONS(1359), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1361), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(567), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22745] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1357), 1,
      anon_sym_DQUOTE,
    ACTIONS(1363), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1365), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(568), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [22763] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1367), 1,
      anon_sym_SQUOTE,
    ACTIONS(1369), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1372), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(571), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22781] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1375), 1,
      anon_sym_DQUOTE,
    ACTIONS(1377), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1380), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(572), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [22799] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    STATE(592), 1,
      sym_string,
    ACTIONS(1305), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_identifier,
  [22817] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(639), 1,
      sym_annotation_definition,
    ACTIONS(1383), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1385), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22835] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1204), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(390), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_identifier,
  [22853] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1208), 1,
      anon_sym_LBRACE,
    STATE(575), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(384), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      sym_identifier,
  [22871] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(824), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(390), 3,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
  [22889] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(826), 1,
      anon_sym_LBRACE,
    STATE(577), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(384), 3,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
  [22907] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1329), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1387), 1,
      anon_sym_SQUOTE,
    ACTIONS(1331), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(571), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22925] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1333), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1387), 1,
      anon_sym_DQUOTE,
    ACTIONS(1335), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(572), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [22943] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1389), 1,
      anon_sym_SQUOTE,
    ACTIONS(1391), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1393), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(579), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22961] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    STATE(626), 1,
      sym_annotation_definition,
    ACTIONS(1395), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1397), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22979] = 5,
    ACTIONS(1319), 1,
      anon_sym_SQUOTE,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1399), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1401), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(584), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [22997] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1329), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(1403), 1,
      anon_sym_SQUOTE,
    ACTIONS(1331), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(571), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [23015] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1333), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1403), 1,
      anon_sym_DQUOTE,
    ACTIONS(1335), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(572), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [23033] = 5,
    ACTIONS(1325), 1,
      sym_comment,
    ACTIONS(1389), 1,
      anon_sym_DQUOTE,
    ACTIONS(1405), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(1407), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(580), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [23051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1246), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [23064] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1409), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1411), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1413), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1415), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1417), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1419), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23103] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1395), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1397), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23116] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1421), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1423), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23129] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1425), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1427), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23142] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1431), 1,
      anon_sym_GT,
    STATE(728), 1,
      sym_annotation_definition,
    STATE(849), 1,
      sym_throws,
  [23161] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 1,
      anon_sym_DOT,
    STATE(612), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(1279), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [23176] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1435), 1,
      anon_sym_RBRACE,
    ACTIONS(1437), 1,
      anon_sym_DQUOTE,
    ACTIONS(1440), 1,
      anon_sym_SQUOTE,
    STATE(596), 1,
      aux_sym_senum_definition_repeat1,
    STATE(625), 1,
      sym_string,
  [23195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1295), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [23208] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1443), 1,
      anon_sym_RBRACE,
    STATE(625), 1,
      sym_string,
    STATE(628), 1,
      aux_sym_senum_definition_repeat1,
  [23227] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1445), 1,
      anon_sym_AMP,
    ACTIONS(1447), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(95), 1,
      sym__identifier_with_dots,
    STATE(815), 1,
      sym_annotation_definition,
  [23246] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1449), 1,
      anon_sym_GT,
    STATE(735), 1,
      sym_annotation_definition,
    STATE(845), 1,
      sym_throws,
  [23265] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1451), 1,
      sym_identifier,
    ACTIONS(1453), 1,
      anon_sym_COMMA,
    STATE(663), 1,
      aux_sym_function_definition_repeat1,
    STATE(840), 1,
      sym_annotation_definition,
  [23284] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1455), 1,
      anon_sym_RBRACE,
    STATE(596), 1,
      aux_sym_senum_definition_repeat1,
    STATE(625), 1,
      sym_string,
  [23303] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1457), 1,
      anon_sym_GT,
    STATE(716), 1,
      sym_annotation_definition,
    STATE(852), 1,
      sym_throws,
  [23322] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1459), 1,
      anon_sym_GT,
    STATE(713), 1,
      sym_annotation_definition,
    STATE(858), 1,
      sym_throws,
  [23341] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1461), 1,
      anon_sym_GT,
    STATE(758), 1,
      sym_annotation_definition,
    STATE(903), 1,
      sym_throws,
  [23360] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1453), 1,
      anon_sym_COMMA,
    ACTIONS(1463), 1,
      sym_identifier,
    STATE(663), 1,
      aux_sym_function_definition_repeat1,
    STATE(847), 1,
      sym_annotation_definition,
  [23379] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 1,
      anon_sym_DOT,
    STATE(615), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(54), 3,
      anon_sym_LBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [23394] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1383), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1385), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1467), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1471), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23433] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1473), 1,
      anon_sym_AMP,
    ACTIONS(1475), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(91), 1,
      sym__identifier_with_dots,
    STATE(823), 1,
      sym_annotation_definition,
  [23452] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 1,
      anon_sym_DOT,
    STATE(535), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(1301), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [23467] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1477), 1,
      anon_sym_AMP,
    ACTIONS(1479), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(103), 1,
      sym__identifier_with_dots,
    STATE(809), 1,
      sym_annotation_definition,
  [23486] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1481), 1,
      anon_sym_COMMA,
    STATE(690), 1,
      sym_annotation_definition,
    STATE(882), 1,
      sym_throws,
  [23505] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 1,
      anon_sym_DOT,
    STATE(535), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(48), 3,
      anon_sym_LBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [23520] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1453), 1,
      anon_sym_COMMA,
    ACTIONS(1463), 1,
      sym_identifier,
    STATE(601), 1,
      aux_sym_function_definition_repeat1,
    STATE(847), 1,
      sym_annotation_definition,
  [23539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1483), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1485), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [23552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1307), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1309), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1489), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1491), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1493), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23591] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1453), 1,
      anon_sym_COMMA,
    ACTIONS(1495), 1,
      sym_identifier,
    STATE(623), 1,
      aux_sym_function_definition_repeat1,
    STATE(842), 1,
      sym_annotation_definition,
  [23610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1283), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [23623] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1453), 1,
      anon_sym_COMMA,
    ACTIONS(1497), 1,
      sym_identifier,
    STATE(663), 1,
      aux_sym_function_definition_repeat1,
    STATE(862), 1,
      sym_annotation_definition,
  [23642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1501), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23655] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1503), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(1505), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [23668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1339), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23681] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1507), 1,
      anon_sym_GT,
    STATE(796), 1,
      sym_annotation_definition,
    STATE(861), 1,
      sym_throws,
  [23700] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1509), 1,
      anon_sym_RBRACE,
    STATE(596), 1,
      aux_sym_senum_definition_repeat1,
    STATE(625), 1,
      sym_string,
  [23719] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1509), 1,
      anon_sym_RBRACE,
    STATE(602), 1,
      aux_sym_senum_definition_repeat1,
    STATE(625), 1,
      sym_string,
  [23738] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1453), 1,
      anon_sym_COMMA,
    ACTIONS(1497), 1,
      sym_identifier,
    STATE(606), 1,
      aux_sym_function_definition_repeat1,
    STATE(862), 1,
      sym_annotation_definition,
  [23757] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1511), 1,
      anon_sym_AMP,
    ACTIONS(1513), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(104), 1,
      sym__identifier_with_dots,
    STATE(807), 1,
      sym_annotation_definition,
  [23776] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      anon_sym_AT,
    ACTIONS(1515), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(528), 1,
      sym__identifier_with_dots,
    STATE(662), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [23793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1305), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23806] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1519), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1521), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1523), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1248), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23832] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1317), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23845] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1525), 1,
      anon_sym_COMMA,
    STATE(791), 1,
      sym_annotation_definition,
    STATE(913), 1,
      sym_throws,
  [23864] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1529), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1531), 2,
      anon_sym_throws,
      sym_identifier,
    ACTIONS(1533), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23890] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1535), 1,
      anon_sym_LT,
    STATE(866), 1,
      sym_string,
  [23906] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(944), 1,
      anon_sym_package,
    STATE(7), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [23920] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
    ACTIONS(1539), 1,
      anon_sym_xsd_all,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [23936] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1541), 1,
      anon_sym_LT,
    STATE(923), 1,
      sym_string,
  [23952] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1543), 1,
      sym_identifier,
    STATE(278), 1,
      sym_string,
  [23968] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1545), 1,
      anon_sym_EQ,
    ACTIONS(1547), 1,
      anon_sym_RPAREN,
    ACTIONS(1549), 1,
      anon_sym_COMMA,
    STATE(762), 1,
      aux_sym_annotation_definition_repeat1,
  [23984] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(779), 1,
      sym_annotation_definition,
    ACTIONS(1385), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [23998] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    STATE(664), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(1551), 2,
      anon_sym_LPAREN,
      sym_identifier,
  [24012] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1553), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(101), 1,
      sym__identifier_with_dots,
    STATE(806), 1,
      sym_annotation_definition,
  [24028] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(776), 1,
      sym_annotation_definition,
    ACTIONS(1339), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [24042] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(771), 1,
      sym_annotation_definition,
    ACTIONS(1397), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [24056] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(767), 1,
      sym_annotation_definition,
    ACTIONS(1317), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [24070] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1555), 1,
      anon_sym_LT,
    STATE(908), 1,
      sym_string,
  [24086] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(765), 1,
      sym_annotation_definition,
    ACTIONS(1353), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [24100] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1447), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(95), 1,
      sym__identifier_with_dots,
    STATE(815), 1,
      sym_annotation_definition,
  [24116] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(757), 1,
      sym_annotation_definition,
    ACTIONS(1309), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [24130] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1557), 1,
      anon_sym_LBRACE,
    ACTIONS(1559), 1,
      anon_sym_xsd_all,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24146] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(747), 1,
      sym_annotation_definition,
    ACTIONS(1313), 2,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [24160] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1561), 1,
      anon_sym_LBRACE,
    ACTIONS(1563), 1,
      anon_sym_xsd_all,
    STATE(674), 1,
      aux_sym__type_identifier_repeat1,
  [24176] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1565), 1,
      anon_sym_LBRACE,
    ACTIONS(1567), 1,
      anon_sym_extends,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24192] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1569), 1,
      anon_sym_LBRACE,
    ACTIONS(1571), 1,
      anon_sym_xsd_all,
    STATE(671), 1,
      aux_sym__type_identifier_repeat1,
  [24208] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(91), 1,
      sym__identifier_with_dots,
    STATE(823), 1,
      sym_annotation_definition,
  [24224] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      aux_sym__identifier_with_dots_token1,
    ACTIONS(1573), 1,
      anon_sym_AT,
    STATE(662), 2,
      sym_fb_annotation_definition,
      aux_sym_package_declaration_repeat1,
  [24238] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1578), 1,
      anon_sym_COMMA,
    STATE(663), 1,
      aux_sym_function_definition_repeat1,
    ACTIONS(1576), 2,
      anon_sym_LPAREN,
      sym_identifier,
  [24252] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
    ACTIONS(1581), 2,
      anon_sym_LPAREN,
      sym_identifier,
  [24266] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1583), 1,
      anon_sym_LBRACE,
    ACTIONS(1585), 1,
      anon_sym_extends,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24282] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1587), 1,
      anon_sym_LBRACE,
    ACTIONS(1589), 1,
      anon_sym_extends,
    STATE(659), 1,
      aux_sym__type_identifier_repeat1,
  [24298] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1591), 1,
      anon_sym_EQ,
    ACTIONS(1593), 1,
      anon_sym_RPAREN,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    STATE(701), 1,
      aux_sym_annotation_definition_repeat1,
  [24314] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1597), 1,
      anon_sym_LBRACE,
    ACTIONS(1599), 1,
      anon_sym_xsd_all,
    STATE(656), 1,
      aux_sym__type_identifier_repeat1,
  [24330] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1601), 1,
      anon_sym_EQ,
    ACTIONS(1603), 1,
      anon_sym_RPAREN,
    ACTIONS(1605), 1,
      anon_sym_COMMA,
    STATE(710), 1,
      aux_sym_annotation_definition_repeat1,
  [24346] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    ACTIONS(1607), 1,
      anon_sym_LT,
    STATE(825), 1,
      sym_string,
  [24362] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1609), 1,
      anon_sym_LBRACE,
    ACTIONS(1611), 1,
      anon_sym_xsd_all,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24378] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LBRACE,
    ACTIONS(1615), 1,
      anon_sym_xsd_all,
    STATE(642), 1,
      aux_sym__type_identifier_repeat1,
  [24394] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1617), 1,
      anon_sym_LBRACE,
    ACTIONS(1619), 1,
      anon_sym_extends,
    STATE(665), 1,
      aux_sym__type_identifier_repeat1,
  [24410] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1621), 1,
      anon_sym_LBRACE,
    ACTIONS(1623), 1,
      anon_sym_xsd_all,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24426] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1479), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(103), 1,
      sym__identifier_with_dots,
    STATE(809), 1,
      sym_annotation_definition,
  [24442] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1435), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [24451] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1625), 1,
      anon_sym_SEMI,
    STATE(740), 1,
      aux_sym__type_identifier_repeat1,
  [24464] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1627), 1,
      anon_sym_COMMA,
    STATE(833), 1,
      sym_annotation_definition,
  [24477] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1629), 1,
      anon_sym_RPAREN,
    ACTIONS(1631), 1,
      anon_sym_COMMA,
    STATE(769), 1,
      aux_sym_annotation_definition_repeat1,
  [24490] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1633), 1,
      sym_identifier,
    STATE(910), 1,
      sym_annotation_definition,
  [24503] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1637), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [24516] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1639), 1,
      anon_sym_GT,
    STATE(875), 1,
      sym_annotation_definition,
  [24529] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1641), 1,
      anon_sym_GT,
    STATE(873), 1,
      sym_throws,
  [24542] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1645), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [24555] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1647), 1,
      anon_sym_GT,
    STATE(885), 1,
      sym_annotation_definition,
  [24568] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1649), 1,
      anon_sym_COMMA,
    STATE(887), 1,
      sym_annotation_definition,
  [24581] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1651), 1,
      anon_sym_GT,
    STATE(888), 1,
      sym_annotation_definition,
  [24594] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1653), 1,
      anon_sym_RPAREN,
    ACTIONS(1655), 1,
      anon_sym_COMMA,
    STATE(769), 1,
      aux_sym_annotation_definition_repeat1,
  [24607] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1653), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [24620] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1657), 1,
      anon_sym_COMMA,
    STATE(865), 1,
      sym_throws,
  [24633] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1659), 1,
      anon_sym_RBRACE,
    STATE(684), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [24646] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1659), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [24659] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1661), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [24672] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1663), 1,
      anon_sym_LBRACE,
    STATE(727), 1,
      aux_sym__type_identifier_repeat1,
  [24685] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1665), 1,
      sym_identifier,
    STATE(921), 1,
      sym_annotation_definition,
  [24698] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1661), 1,
      anon_sym_RPAREN,
    ACTIONS(1667), 1,
      anon_sym_COMMA,
    STATE(688), 1,
      aux_sym_annotation_definition_repeat1,
  [24711] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1669), 1,
      anon_sym_RBRACE,
    STATE(777), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [24724] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1671), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24737] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1673), 1,
      anon_sym_RBRACE,
    STATE(692), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [24750] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [24759] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1675), 1,
      anon_sym_RPAREN,
    ACTIONS(1677), 1,
      anon_sym_COMMA,
    STATE(769), 1,
      aux_sym_annotation_definition_repeat1,
  [24772] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1679), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24785] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1675), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [24798] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1681), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24811] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1683), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [24824] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1685), 1,
      anon_sym_RPAREN,
    STATE(669), 1,
      sym_annotation_identifier,
  [24837] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1687), 1,
      anon_sym_RPAREN,
    STATE(667), 1,
      sym_annotation_identifier,
  [24850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1691), 1,
      anon_sym_COMMA,
    ACTIONS(1689), 2,
      anon_sym_RBRACE,
      sym_identifier,
  [24861] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1693), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [24874] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1683), 1,
      anon_sym_RPAREN,
    ACTIONS(1695), 1,
      anon_sym_COMMA,
    STATE(769), 1,
      aux_sym_annotation_definition_repeat1,
  [24887] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1576), 3,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_identifier,
  [24896] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1246), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [24905] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1697), 1,
      anon_sym_GT,
    STATE(860), 1,
      sym_throws,
  [24918] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1699), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [24931] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1701), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [24944] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1459), 1,
      anon_sym_GT,
    STATE(858), 1,
      sym_throws,
  [24957] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1703), 1,
      anon_sym_GT,
    STATE(857), 1,
      sym_annotation_definition,
  [24970] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1705), 1,
      anon_sym_RPAREN,
    ACTIONS(1707), 1,
      anon_sym_COMMA,
    STATE(769), 1,
      aux_sym_annotation_definition_repeat1,
  [24983] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(319), 1,
      sym_string,
  [24996] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1709), 1,
      anon_sym_LBRACE,
    STATE(698), 1,
      aux_sym__type_identifier_repeat1,
  [25009] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1427), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25018] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25027] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1711), 1,
      anon_sym_GT,
    STATE(830), 1,
      sym_annotation_definition,
  [25040] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1489), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25049] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1713), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [25058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1715), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 2,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [25069] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1717), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [25082] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1719), 1,
      anon_sym_GT,
    STATE(886), 1,
      sym_throws,
  [25095] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1705), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [25108] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1721), 1,
      anon_sym_RBRACE,
    STATE(795), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25121] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1723), 1,
      anon_sym_RBRACE,
    STATE(715), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25134] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1723), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25147] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1721), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25160] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1725), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [25173] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1457), 1,
      anon_sym_GT,
    STATE(852), 1,
      sym_throws,
  [25186] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1727), 1,
      anon_sym_GT,
    STATE(850), 1,
      sym_annotation_definition,
  [25199] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    STATE(802), 1,
      aux_sym__type_identifier_repeat1,
  [25212] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1471), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25221] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1731), 1,
      sym_identifier,
    STATE(879), 1,
      sym_annotation_definition,
  [25234] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1733), 1,
      anon_sym_SEMI,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [25247] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1629), 1,
      anon_sym_RPAREN,
    ACTIONS(1635), 1,
      sym_identifier,
    STATE(786), 1,
      sym_annotation_identifier,
  [25260] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1735), 1,
      anon_sym_LBRACE,
    STATE(702), 1,
      aux_sym__type_identifier_repeat1,
  [25273] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1737), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [25286] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1737), 1,
      anon_sym_RPAREN,
    ACTIONS(1739), 1,
      anon_sym_COMMA,
    STATE(718), 1,
      aux_sym_annotation_definition_repeat1,
  [25299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25308] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1741), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [25321] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25330] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1743), 1,
      sym_identifier,
    STATE(869), 1,
      sym_annotation_definition,
  [25343] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1419), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25352] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1745), 1,
      anon_sym_LBRACE,
    STATE(709), 1,
      aux_sym__type_identifier_repeat1,
  [25365] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1747), 1,
      sym_identifier,
    ACTIONS(1750), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25378] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1752), 1,
      anon_sym_RBRACE,
    STATE(732), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25391] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1754), 1,
      anon_sym_LBRACE,
    STATE(704), 1,
      aux_sym__type_identifier_repeat1,
  [25404] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25413] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1756), 1,
      anon_sym_LBRACE,
    STATE(734), 1,
      aux_sym__type_identifier_repeat1,
  [25426] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1758), 1,
      anon_sym_GT,
    STATE(895), 1,
      sym_annotation_definition,
  [25439] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1317), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25448] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1507), 1,
      anon_sym_GT,
    STATE(861), 1,
      sym_throws,
  [25461] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1521), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25470] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1760), 1,
      anon_sym_GT,
    STATE(843), 1,
      sym_annotation_definition,
  [25483] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [25492] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1762), 1,
      anon_sym_RPAREN,
    ACTIONS(1764), 1,
      anon_sym_COMMA,
    STATE(769), 1,
      aux_sym_annotation_definition_repeat1,
  [25505] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1762), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [25518] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1423), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25536] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1766), 1,
      anon_sym_LBRACE,
    STATE(746), 1,
      aux_sym__type_identifier_repeat1,
  [25549] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25558] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1415), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25567] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1768), 1,
      anon_sym_RPAREN,
    ACTIONS(1770), 1,
      anon_sym_COMMA,
    STATE(769), 1,
      aux_sym_annotation_definition_repeat1,
  [25580] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1773), 1,
      sym_identifier,
    STATE(872), 1,
      sym_annotation_definition,
  [25593] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1339), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25602] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1775), 1,
      anon_sym_COMMA,
    STATE(911), 1,
      sym_annotation_definition,
  [25615] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1501), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25624] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1777), 1,
      anon_sym_GT,
    STATE(896), 1,
      sym_annotation_definition,
  [25637] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1779), 1,
      anon_sym_COMMA,
    STATE(915), 1,
      sym_annotation_definition,
  [25650] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25659] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1781), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25672] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1493), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25681] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1533), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25690] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1529), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25699] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25708] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      aux_sym__identifier_with_dots_token1,
  [25717] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1783), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [25730] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(898), 1,
      sym_string,
  [25743] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1785), 1,
      anon_sym_GT,
    STATE(874), 1,
      sym_annotation_definition,
  [25756] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1787), 1,
      anon_sym_EQ,
    ACTIONS(1768), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [25767] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1789), 1,
      anon_sym_GT,
    STATE(839), 1,
      sym_annotation_definition,
  [25780] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1783), 1,
      anon_sym_RPAREN,
    ACTIONS(1791), 1,
      anon_sym_COMMA,
    STATE(679), 1,
      aux_sym_annotation_definition_repeat1,
  [25793] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [25802] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1793), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25815] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1795), 1,
      anon_sym_COMMA,
    STATE(916), 1,
      sym_throws,
  [25828] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1797), 1,
      anon_sym_GT,
    STATE(831), 1,
      sym_throws,
  [25841] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1799), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_annotation_identifier,
  [25854] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(329), 1,
      sym_string,
  [25867] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1801), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25880] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_throws,
    ACTIONS(1431), 1,
      anon_sym_GT,
    STATE(849), 1,
      sym_throws,
  [25893] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE,
    STATE(317), 1,
      sym_string,
  [25906] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1803), 3,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_identifier,
  [25915] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1805), 1,
      sym_identifier,
    STATE(846), 1,
      sym_annotation_definition,
  [25928] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1807), 1,
      anon_sym_GT,
    STATE(844), 1,
      sym_annotation_definition,
  [25941] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1809), 1,
      anon_sym_RBRACE,
    STATE(733), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25954] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 1,
      anon_sym_DOT,
    ACTIONS(1811), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      aux_sym__type_identifier_repeat1,
  [25967] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    ACTIONS(1813), 1,
      anon_sym_RPAREN,
    STATE(645), 1,
      sym_annotation_identifier,
  [25980] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1815), 1,
      anon_sym_RBRACE,
    STATE(790), 1,
      aux_sym_fb_annotation_definition_repeat1,
  [25993] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_LPAREN,
    ACTIONS(1817), 1,
      anon_sym_GT,
    STATE(829), 1,
      sym_annotation_definition,
  [26006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1819), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(94), 1,
      sym__identifier_with_dots,
  [26016] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1475), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(91), 1,
      sym__identifier_with_dots,
  [26026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1821), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [26034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1553), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(101), 1,
      sym__identifier_with_dots,
  [26044] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1823), 2,
      anon_sym_LPAREN,
      sym_identifier,
  [26052] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1825), 2,
      anon_sym_RBRACE,
      sym_identifier,
  [26060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    STATE(8), 1,
      sym_annotation_identifier,
  [26070] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      anon_sym_LPAREN,
    STATE(154), 1,
      sym_parameters,
  [26080] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    STATE(786), 1,
      sym_annotation_identifier,
  [26090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(103), 1,
      sym__identifier_with_dots,
  [26100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      anon_sym_LPAREN,
    STATE(116), 1,
      sym_parameters,
  [26110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1829), 1,
      sym_identifier,
    STATE(726), 1,
      sym_annotation_identifier,
  [26120] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      anon_sym_LPAREN,
    STATE(120), 1,
      sym_parameters,
  [26130] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      anon_sym_LPAREN,
    STATE(119), 1,
      sym_parameters,
  [26140] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      anon_sym_LPAREN,
    STATE(105), 1,
      sym_parameters,
  [26150] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 2,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [26158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      sym_parameters,
  [26168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1447), 1,
      aux_sym__identifier_with_dots_token1,
    STATE(95), 1,
      sym__identifier_with_dots,
  [26178] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 2,
      anon_sym_AT,
      aux_sym__identifier_with_dots_token1,
  [26186] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1831), 1,
      anon_sym_LT,
  [26193] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_LBRACE,
  [26200] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1833), 1,
      anon_sym_LT,
  [26207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1835), 1,
      anon_sym_LT,
  [26214] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1837), 1,
      anon_sym_GT,
  [26221] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1789), 1,
      anon_sym_GT,
  [26228] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1839), 1,
      anon_sym_GT,
  [26235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1841), 1,
      sym_identifier,
  [26242] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1843), 1,
      anon_sym_COMMA,
  [26249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
  [26256] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1845), 1,
      sym_identifier,
  [26263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1847), 1,
      anon_sym_LBRACE,
  [26270] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1849), 1,
      sym_number,
  [26277] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1851), 1,
      anon_sym_LBRACE,
  [26284] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1853), 1,
      anon_sym_GT,
  [26291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1855), 1,
      sym_identifier,
  [26298] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1857), 1,
      anon_sym_LBRACE,
  [26305] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1497), 1,
      sym_identifier,
  [26312] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1727), 1,
      anon_sym_GT,
  [26319] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1859), 1,
      anon_sym_GT,
  [26326] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 1,
      anon_sym_GT,
  [26333] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1731), 1,
      sym_identifier,
  [26340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1451), 1,
      sym_identifier,
  [26347] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1861), 1,
      anon_sym_LBRACE,
  [26354] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_GT,
  [26361] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1703), 1,
      anon_sym_GT,
  [26368] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1863), 1,
      sym_identifier,
  [26375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1459), 1,
      anon_sym_GT,
  [26382] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1865), 1,
      sym_identifier,
  [26389] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1867), 1,
      anon_sym_LT,
  [26396] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1869), 1,
      sym_identifier,
  [26403] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1871), 1,
      sym_identifier,
  [26410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1873), 1,
      anon_sym_GT,
  [26417] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1697), 1,
      anon_sym_GT,
  [26424] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1875), 1,
      sym_identifier,
  [26431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1877), 1,
      anon_sym_GT,
  [26438] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 1,
      anon_sym_GT,
  [26445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 1,
      sym_identifier,
  [26452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1879), 1,
      sym_number,
  [26459] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_LBRACE,
  [26466] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1881), 1,
      anon_sym_COMMA,
  [26473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1883), 1,
      anon_sym_LT,
  [26480] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1885), 1,
      sym_identifier,
  [26487] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1887), 1,
      sym_identifier,
  [26494] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1805), 1,
      sym_identifier,
  [26501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1889), 1,
      sym_identifier,
  [26508] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1891), 1,
      anon_sym_EQ,
  [26515] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1665), 1,
      sym_identifier,
  [26522] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1893), 1,
      anon_sym_GT,
  [26529] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1777), 1,
      anon_sym_GT,
  [26536] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1895), 1,
      anon_sym_GT,
  [26543] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1609), 1,
      anon_sym_LBRACE,
  [26550] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1897), 1,
      sym_identifier,
  [26557] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1899), 1,
      sym_identifier,
  [26564] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1633), 1,
      sym_identifier,
  [26571] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1901), 1,
      anon_sym_LBRACE,
  [26578] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1903), 1,
      sym_identifier,
  [26585] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1657), 1,
      anon_sym_COMMA,
  [26592] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1905), 1,
      anon_sym_uri,
  [26599] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1907), 1,
      anon_sym_COLON,
  [26606] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1639), 1,
      anon_sym_GT,
  [26613] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1909), 1,
      anon_sym_GT,
  [26620] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1627), 1,
      anon_sym_COMMA,
  [26627] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1911), 1,
      anon_sym_GT,
  [26634] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1913), 1,
      sym_identifier,
  [26641] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1915), 1,
      anon_sym_EQ,
  [26648] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1917), 1,
      anon_sym_LBRACE,
  [26655] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1919), 1,
      sym_identifier,
  [26662] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1921), 1,
      anon_sym_COLON,
  [26669] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1923), 1,
      ts_builtin_sym_end,
  [26676] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1925), 1,
      anon_sym_GT,
  [26683] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1807), 1,
      anon_sym_GT,
  [26690] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1927), 1,
      sym_identifier,
  [26697] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1929), 1,
      anon_sym_RPAREN,
  [26704] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1931), 1,
      sym_identifier,
  [26711] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1933), 1,
      anon_sym_LBRACE,
  [26718] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1935), 1,
      sym_identifier,
  [26725] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1937), 1,
      sym_identifier,
  [26732] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_GT,
  [26739] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1939), 1,
      anon_sym_LT,
  [26746] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1941), 1,
      anon_sym_LBRACE,
  [26753] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1943), 1,
      anon_sym_LT,
  [26760] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1945), 1,
      sym_identifier,
  [26767] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1947), 1,
      anon_sym_LT,
  [26774] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1949), 1,
      sym_identifier,
  [26781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1951), 1,
      sym_identifier,
  [26788] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1779), 1,
      anon_sym_COMMA,
  [26795] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1953), 1,
      sym_identifier,
  [26802] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1795), 1,
      anon_sym_COMMA,
  [26809] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1955), 1,
      anon_sym_EQ,
  [26816] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1957), 1,
      anon_sym_COMMA,
  [26823] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1959), 1,
      anon_sym_COMMA,
  [26830] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1961), 1,
      anon_sym_LT,
  [26837] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1963), 1,
      sym_identifier,
  [26844] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1965), 1,
      sym_identifier,
  [26851] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1967), 1,
      anon_sym_EQ,
  [26858] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1969), 1,
      sym_identifier,
  [26865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1971), 1,
      anon_sym_LT,
  [26872] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1973), 1,
      anon_sym_LT,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(3)] = 0,
  [SMALL_STATE(4)] = 69,
  [SMALL_STATE(5)] = 133,
  [SMALL_STATE(6)] = 191,
  [SMALL_STATE(7)] = 249,
  [SMALL_STATE(8)] = 303,
  [SMALL_STATE(9)] = 354,
  [SMALL_STATE(10)] = 441,
  [SMALL_STATE(11)] = 489,
  [SMALL_STATE(12)] = 537,
  [SMALL_STATE(13)] = 615,
  [SMALL_STATE(14)] = 693,
  [SMALL_STATE(15)] = 771,
  [SMALL_STATE(16)] = 849,
  [SMALL_STATE(17)] = 927,
  [SMALL_STATE(18)] = 1005,
  [SMALL_STATE(19)] = 1083,
  [SMALL_STATE(20)] = 1161,
  [SMALL_STATE(21)] = 1239,
  [SMALL_STATE(22)] = 1317,
  [SMALL_STATE(23)] = 1395,
  [SMALL_STATE(24)] = 1473,
  [SMALL_STATE(25)] = 1551,
  [SMALL_STATE(26)] = 1629,
  [SMALL_STATE(27)] = 1707,
  [SMALL_STATE(28)] = 1785,
  [SMALL_STATE(29)] = 1863,
  [SMALL_STATE(30)] = 1941,
  [SMALL_STATE(31)] = 2019,
  [SMALL_STATE(32)] = 2097,
  [SMALL_STATE(33)] = 2175,
  [SMALL_STATE(34)] = 2253,
  [SMALL_STATE(35)] = 2331,
  [SMALL_STATE(36)] = 2409,
  [SMALL_STATE(37)] = 2487,
  [SMALL_STATE(38)] = 2566,
  [SMALL_STATE(39)] = 2641,
  [SMALL_STATE(40)] = 2720,
  [SMALL_STATE(41)] = 2799,
  [SMALL_STATE(42)] = 2878,
  [SMALL_STATE(43)] = 2957,
  [SMALL_STATE(44)] = 3036,
  [SMALL_STATE(45)] = 3115,
  [SMALL_STATE(46)] = 3194,
  [SMALL_STATE(47)] = 3273,
  [SMALL_STATE(48)] = 3352,
  [SMALL_STATE(49)] = 3431,
  [SMALL_STATE(50)] = 3506,
  [SMALL_STATE(51)] = 3585,
  [SMALL_STATE(52)] = 3664,
  [SMALL_STATE(53)] = 3743,
  [SMALL_STATE(54)] = 3822,
  [SMALL_STATE(55)] = 3901,
  [SMALL_STATE(56)] = 3980,
  [SMALL_STATE(57)] = 4059,
  [SMALL_STATE(58)] = 4138,
  [SMALL_STATE(59)] = 4217,
  [SMALL_STATE(60)] = 4296,
  [SMALL_STATE(61)] = 4375,
  [SMALL_STATE(62)] = 4454,
  [SMALL_STATE(63)] = 4529,
  [SMALL_STATE(64)] = 4604,
  [SMALL_STATE(65)] = 4683,
  [SMALL_STATE(66)] = 4762,
  [SMALL_STATE(67)] = 4841,
  [SMALL_STATE(68)] = 4920,
  [SMALL_STATE(69)] = 4999,
  [SMALL_STATE(70)] = 5078,
  [SMALL_STATE(71)] = 5157,
  [SMALL_STATE(72)] = 5236,
  [SMALL_STATE(73)] = 5315,
  [SMALL_STATE(74)] = 5390,
  [SMALL_STATE(75)] = 5469,
  [SMALL_STATE(76)] = 5548,
  [SMALL_STATE(77)] = 5627,
  [SMALL_STATE(78)] = 5706,
  [SMALL_STATE(79)] = 5750,
  [SMALL_STATE(80)] = 5794,
  [SMALL_STATE(81)] = 5838,
  [SMALL_STATE(82)] = 5882,
  [SMALL_STATE(83)] = 5926,
  [SMALL_STATE(84)] = 5970,
  [SMALL_STATE(85)] = 6038,
  [SMALL_STATE(86)] = 6110,
  [SMALL_STATE(87)] = 6182,
  [SMALL_STATE(88)] = 6229,
  [SMALL_STATE(89)] = 6276,
  [SMALL_STATE(90)] = 6332,
  [SMALL_STATE(91)] = 6370,
  [SMALL_STATE(92)] = 6426,
  [SMALL_STATE(93)] = 6494,
  [SMALL_STATE(94)] = 6562,
  [SMALL_STATE(95)] = 6618,
  [SMALL_STATE(96)] = 6674,
  [SMALL_STATE(97)] = 6730,
  [SMALL_STATE(98)] = 6798,
  [SMALL_STATE(99)] = 6854,
  [SMALL_STATE(100)] = 6910,
  [SMALL_STATE(101)] = 6948,
  [SMALL_STATE(102)] = 7004,
  [SMALL_STATE(103)] = 7060,
  [SMALL_STATE(104)] = 7116,
  [SMALL_STATE(105)] = 7172,
  [SMALL_STATE(106)] = 7221,
  [SMALL_STATE(107)] = 7274,
  [SMALL_STATE(108)] = 7327,
  [SMALL_STATE(109)] = 7380,
  [SMALL_STATE(110)] = 7429,
  [SMALL_STATE(111)] = 7482,
  [SMALL_STATE(112)] = 7535,
  [SMALL_STATE(113)] = 7588,
  [SMALL_STATE(114)] = 7641,
  [SMALL_STATE(115)] = 7694,
  [SMALL_STATE(116)] = 7747,
  [SMALL_STATE(117)] = 7796,
  [SMALL_STATE(118)] = 7849,
  [SMALL_STATE(119)] = 7902,
  [SMALL_STATE(120)] = 7951,
  [SMALL_STATE(121)] = 8000,
  [SMALL_STATE(122)] = 8050,
  [SMALL_STATE(123)] = 8088,
  [SMALL_STATE(124)] = 8138,
  [SMALL_STATE(125)] = 8176,
  [SMALL_STATE(126)] = 8226,
  [SMALL_STATE(127)] = 8276,
  [SMALL_STATE(128)] = 8326,
  [SMALL_STATE(129)] = 8376,
  [SMALL_STATE(130)] = 8426,
  [SMALL_STATE(131)] = 8476,
  [SMALL_STATE(132)] = 8526,
  [SMALL_STATE(133)] = 8564,
  [SMALL_STATE(134)] = 8614,
  [SMALL_STATE(135)] = 8664,
  [SMALL_STATE(136)] = 8702,
  [SMALL_STATE(137)] = 8752,
  [SMALL_STATE(138)] = 8802,
  [SMALL_STATE(139)] = 8852,
  [SMALL_STATE(140)] = 8890,
  [SMALL_STATE(141)] = 8928,
  [SMALL_STATE(142)] = 8966,
  [SMALL_STATE(143)] = 9004,
  [SMALL_STATE(144)] = 9042,
  [SMALL_STATE(145)] = 9080,
  [SMALL_STATE(146)] = 9130,
  [SMALL_STATE(147)] = 9168,
  [SMALL_STATE(148)] = 9206,
  [SMALL_STATE(149)] = 9244,
  [SMALL_STATE(150)] = 9291,
  [SMALL_STATE(151)] = 9338,
  [SMALL_STATE(152)] = 9381,
  [SMALL_STATE(153)] = 9428,
  [SMALL_STATE(154)] = 9475,
  [SMALL_STATE(155)] = 9512,
  [SMALL_STATE(156)] = 9559,
  [SMALL_STATE(157)] = 9606,
  [SMALL_STATE(158)] = 9665,
  [SMALL_STATE(159)] = 9708,
  [SMALL_STATE(160)] = 9755,
  [SMALL_STATE(161)] = 9802,
  [SMALL_STATE(162)] = 9861,
  [SMALL_STATE(163)] = 9904,
  [SMALL_STATE(164)] = 9951,
  [SMALL_STATE(165)] = 9998,
  [SMALL_STATE(166)] = 10045,
  [SMALL_STATE(167)] = 10092,
  [SMALL_STATE(168)] = 10135,
  [SMALL_STATE(169)] = 10182,
  [SMALL_STATE(170)] = 10229,
  [SMALL_STATE(171)] = 10288,
  [SMALL_STATE(172)] = 10331,
  [SMALL_STATE(173)] = 10378,
  [SMALL_STATE(174)] = 10425,
  [SMALL_STATE(175)] = 10484,
  [SMALL_STATE(176)] = 10531,
  [SMALL_STATE(177)] = 10579,
  [SMALL_STATE(178)] = 10620,
  [SMALL_STATE(179)] = 10661,
  [SMALL_STATE(180)] = 10698,
  [SMALL_STATE(181)] = 10739,
  [SMALL_STATE(182)] = 10780,
  [SMALL_STATE(183)] = 10815,
  [SMALL_STATE(184)] = 10856,
  [SMALL_STATE(185)] = 10897,
  [SMALL_STATE(186)] = 10938,
  [SMALL_STATE(187)] = 10975,
  [SMALL_STATE(188)] = 11016,
  [SMALL_STATE(189)] = 11053,
  [SMALL_STATE(190)] = 11094,
  [SMALL_STATE(191)] = 11135,
  [SMALL_STATE(192)] = 11176,
  [SMALL_STATE(193)] = 11217,
  [SMALL_STATE(194)] = 11258,
  [SMALL_STATE(195)] = 11299,
  [SMALL_STATE(196)] = 11340,
  [SMALL_STATE(197)] = 11375,
  [SMALL_STATE(198)] = 11416,
  [SMALL_STATE(199)] = 11453,
  [SMALL_STATE(200)] = 11490,
  [SMALL_STATE(201)] = 11527,
  [SMALL_STATE(202)] = 11564,
  [SMALL_STATE(203)] = 11605,
  [SMALL_STATE(204)] = 11646,
  [SMALL_STATE(205)] = 11687,
  [SMALL_STATE(206)] = 11719,
  [SMALL_STATE(207)] = 11771,
  [SMALL_STATE(208)] = 11823,
  [SMALL_STATE(209)] = 11875,
  [SMALL_STATE(210)] = 11927,
  [SMALL_STATE(211)] = 11979,
  [SMALL_STATE(212)] = 12031,
  [SMALL_STATE(213)] = 12083,
  [SMALL_STATE(214)] = 12135,
  [SMALL_STATE(215)] = 12187,
  [SMALL_STATE(216)] = 12239,
  [SMALL_STATE(217)] = 12291,
  [SMALL_STATE(218)] = 12343,
  [SMALL_STATE(219)] = 12395,
  [SMALL_STATE(220)] = 12447,
  [SMALL_STATE(221)] = 12499,
  [SMALL_STATE(222)] = 12551,
  [SMALL_STATE(223)] = 12603,
  [SMALL_STATE(224)] = 12655,
  [SMALL_STATE(225)] = 12707,
  [SMALL_STATE(226)] = 12759,
  [SMALL_STATE(227)] = 12811,
  [SMALL_STATE(228)] = 12863,
  [SMALL_STATE(229)] = 12915,
  [SMALL_STATE(230)] = 12967,
  [SMALL_STATE(231)] = 13019,
  [SMALL_STATE(232)] = 13071,
  [SMALL_STATE(233)] = 13123,
  [SMALL_STATE(234)] = 13175,
  [SMALL_STATE(235)] = 13227,
  [SMALL_STATE(236)] = 13279,
  [SMALL_STATE(237)] = 13331,
  [SMALL_STATE(238)] = 13383,
  [SMALL_STATE(239)] = 13425,
  [SMALL_STATE(240)] = 13477,
  [SMALL_STATE(241)] = 13529,
  [SMALL_STATE(242)] = 13581,
  [SMALL_STATE(243)] = 13633,
  [SMALL_STATE(244)] = 13675,
  [SMALL_STATE(245)] = 13727,
  [SMALL_STATE(246)] = 13779,
  [SMALL_STATE(247)] = 13814,
  [SMALL_STATE(248)] = 13849,
  [SMALL_STATE(249)] = 13884,
  [SMALL_STATE(250)] = 13919,
  [SMALL_STATE(251)] = 13952,
  [SMALL_STATE(252)] = 13985,
  [SMALL_STATE(253)] = 14020,
  [SMALL_STATE(254)] = 14055,
  [SMALL_STATE(255)] = 14090,
  [SMALL_STATE(256)] = 14139,
  [SMALL_STATE(257)] = 14174,
  [SMALL_STATE(258)] = 14207,
  [SMALL_STATE(259)] = 14242,
  [SMALL_STATE(260)] = 14277,
  [SMALL_STATE(261)] = 14310,
  [SMALL_STATE(262)] = 14345,
  [SMALL_STATE(263)] = 14380,
  [SMALL_STATE(264)] = 14415,
  [SMALL_STATE(265)] = 14450,
  [SMALL_STATE(266)] = 14483,
  [SMALL_STATE(267)] = 14516,
  [SMALL_STATE(268)] = 14549,
  [SMALL_STATE(269)] = 14584,
  [SMALL_STATE(270)] = 14619,
  [SMALL_STATE(271)] = 14654,
  [SMALL_STATE(272)] = 14689,
  [SMALL_STATE(273)] = 14722,
  [SMALL_STATE(274)] = 14757,
  [SMALL_STATE(275)] = 14792,
  [SMALL_STATE(276)] = 14841,
  [SMALL_STATE(277)] = 14874,
  [SMALL_STATE(278)] = 14909,
  [SMALL_STATE(279)] = 14945,
  [SMALL_STATE(280)] = 14976,
  [SMALL_STATE(281)] = 15007,
  [SMALL_STATE(282)] = 15038,
  [SMALL_STATE(283)] = 15069,
  [SMALL_STATE(284)] = 15100,
  [SMALL_STATE(285)] = 15131,
  [SMALL_STATE(286)] = 15162,
  [SMALL_STATE(287)] = 15193,
  [SMALL_STATE(288)] = 15224,
  [SMALL_STATE(289)] = 15255,
  [SMALL_STATE(290)] = 15286,
  [SMALL_STATE(291)] = 15317,
  [SMALL_STATE(292)] = 15348,
  [SMALL_STATE(293)] = 15383,
  [SMALL_STATE(294)] = 15414,
  [SMALL_STATE(295)] = 15449,
  [SMALL_STATE(296)] = 15480,
  [SMALL_STATE(297)] = 15511,
  [SMALL_STATE(298)] = 15542,
  [SMALL_STATE(299)] = 15573,
  [SMALL_STATE(300)] = 15604,
  [SMALL_STATE(301)] = 15635,
  [SMALL_STATE(302)] = 15666,
  [SMALL_STATE(303)] = 15697,
  [SMALL_STATE(304)] = 15728,
  [SMALL_STATE(305)] = 15756,
  [SMALL_STATE(306)] = 15784,
  [SMALL_STATE(307)] = 15814,
  [SMALL_STATE(308)] = 15842,
  [SMALL_STATE(309)] = 15870,
  [SMALL_STATE(310)] = 15898,
  [SMALL_STATE(311)] = 15926,
  [SMALL_STATE(312)] = 15954,
  [SMALL_STATE(313)] = 15984,
  [SMALL_STATE(314)] = 16014,
  [SMALL_STATE(315)] = 16042,
  [SMALL_STATE(316)] = 16070,
  [SMALL_STATE(317)] = 16098,
  [SMALL_STATE(318)] = 16125,
  [SMALL_STATE(319)] = 16158,
  [SMALL_STATE(320)] = 16185,
  [SMALL_STATE(321)] = 16212,
  [SMALL_STATE(322)] = 16239,
  [SMALL_STATE(323)] = 16272,
  [SMALL_STATE(324)] = 16299,
  [SMALL_STATE(325)] = 16326,
  [SMALL_STATE(326)] = 16353,
  [SMALL_STATE(327)] = 16386,
  [SMALL_STATE(328)] = 16419,
  [SMALL_STATE(329)] = 16446,
  [SMALL_STATE(330)] = 16473,
  [SMALL_STATE(331)] = 16500,
  [SMALL_STATE(332)] = 16533,
  [SMALL_STATE(333)] = 16559,
  [SMALL_STATE(334)] = 16588,
  [SMALL_STATE(335)] = 16617,
  [SMALL_STATE(336)] = 16644,
  [SMALL_STATE(337)] = 16673,
  [SMALL_STATE(338)] = 16702,
  [SMALL_STATE(339)] = 16731,
  [SMALL_STATE(340)] = 16760,
  [SMALL_STATE(341)] = 16787,
  [SMALL_STATE(342)] = 16816,
  [SMALL_STATE(343)] = 16845,
  [SMALL_STATE(344)] = 16874,
  [SMALL_STATE(345)] = 16903,
  [SMALL_STATE(346)] = 16932,
  [SMALL_STATE(347)] = 16961,
  [SMALL_STATE(348)] = 16988,
  [SMALL_STATE(349)] = 17017,
  [SMALL_STATE(350)] = 17046,
  [SMALL_STATE(351)] = 17075,
  [SMALL_STATE(352)] = 17100,
  [SMALL_STATE(353)] = 17125,
  [SMALL_STATE(354)] = 17154,
  [SMALL_STATE(355)] = 17179,
  [SMALL_STATE(356)] = 17206,
  [SMALL_STATE(357)] = 17235,
  [SMALL_STATE(358)] = 17260,
  [SMALL_STATE(359)] = 17289,
  [SMALL_STATE(360)] = 17318,
  [SMALL_STATE(361)] = 17347,
  [SMALL_STATE(362)] = 17372,
  [SMALL_STATE(363)] = 17397,
  [SMALL_STATE(364)] = 17426,
  [SMALL_STATE(365)] = 17455,
  [SMALL_STATE(366)] = 17484,
  [SMALL_STATE(367)] = 17513,
  [SMALL_STATE(368)] = 17542,
  [SMALL_STATE(369)] = 17571,
  [SMALL_STATE(370)] = 17618,
  [SMALL_STATE(371)] = 17647,
  [SMALL_STATE(372)] = 17676,
  [SMALL_STATE(373)] = 17705,
  [SMALL_STATE(374)] = 17734,
  [SMALL_STATE(375)] = 17763,
  [SMALL_STATE(376)] = 17792,
  [SMALL_STATE(377)] = 17821,
  [SMALL_STATE(378)] = 17850,
  [SMALL_STATE(379)] = 17877,
  [SMALL_STATE(380)] = 17906,
  [SMALL_STATE(381)] = 17935,
  [SMALL_STATE(382)] = 17964,
  [SMALL_STATE(383)] = 17993,
  [SMALL_STATE(384)] = 18022,
  [SMALL_STATE(385)] = 18051,
  [SMALL_STATE(386)] = 18080,
  [SMALL_STATE(387)] = 18109,
  [SMALL_STATE(388)] = 18138,
  [SMALL_STATE(389)] = 18167,
  [SMALL_STATE(390)] = 18196,
  [SMALL_STATE(391)] = 18225,
  [SMALL_STATE(392)] = 18254,
  [SMALL_STATE(393)] = 18283,
  [SMALL_STATE(394)] = 18312,
  [SMALL_STATE(395)] = 18341,
  [SMALL_STATE(396)] = 18370,
  [SMALL_STATE(397)] = 18399,
  [SMALL_STATE(398)] = 18428,
  [SMALL_STATE(399)] = 18452,
  [SMALL_STATE(400)] = 18476,
  [SMALL_STATE(401)] = 18520,
  [SMALL_STATE(402)] = 18543,
  [SMALL_STATE(403)] = 18566,
  [SMALL_STATE(404)] = 18589,
  [SMALL_STATE(405)] = 18612,
  [SMALL_STATE(406)] = 18635,
  [SMALL_STATE(407)] = 18658,
  [SMALL_STATE(408)] = 18681,
  [SMALL_STATE(409)] = 18704,
  [SMALL_STATE(410)] = 18727,
  [SMALL_STATE(411)] = 18750,
  [SMALL_STATE(412)] = 18773,
  [SMALL_STATE(413)] = 18796,
  [SMALL_STATE(414)] = 18819,
  [SMALL_STATE(415)] = 18842,
  [SMALL_STATE(416)] = 18865,
  [SMALL_STATE(417)] = 18888,
  [SMALL_STATE(418)] = 18911,
  [SMALL_STATE(419)] = 18934,
  [SMALL_STATE(420)] = 18957,
  [SMALL_STATE(421)] = 18980,
  [SMALL_STATE(422)] = 19023,
  [SMALL_STATE(423)] = 19046,
  [SMALL_STATE(424)] = 19069,
  [SMALL_STATE(425)] = 19112,
  [SMALL_STATE(426)] = 19135,
  [SMALL_STATE(427)] = 19158,
  [SMALL_STATE(428)] = 19181,
  [SMALL_STATE(429)] = 19204,
  [SMALL_STATE(430)] = 19227,
  [SMALL_STATE(431)] = 19250,
  [SMALL_STATE(432)] = 19293,
  [SMALL_STATE(433)] = 19316,
  [SMALL_STATE(434)] = 19359,
  [SMALL_STATE(435)] = 19402,
  [SMALL_STATE(436)] = 19425,
  [SMALL_STATE(437)] = 19448,
  [SMALL_STATE(438)] = 19471,
  [SMALL_STATE(439)] = 19514,
  [SMALL_STATE(440)] = 19557,
  [SMALL_STATE(441)] = 19580,
  [SMALL_STATE(442)] = 19603,
  [SMALL_STATE(443)] = 19626,
  [SMALL_STATE(444)] = 19649,
  [SMALL_STATE(445)] = 19692,
  [SMALL_STATE(446)] = 19715,
  [SMALL_STATE(447)] = 19738,
  [SMALL_STATE(448)] = 19761,
  [SMALL_STATE(449)] = 19784,
  [SMALL_STATE(450)] = 19807,
  [SMALL_STATE(451)] = 19830,
  [SMALL_STATE(452)] = 19873,
  [SMALL_STATE(453)] = 19896,
  [SMALL_STATE(454)] = 19939,
  [SMALL_STATE(455)] = 19962,
  [SMALL_STATE(456)] = 19985,
  [SMALL_STATE(457)] = 20008,
  [SMALL_STATE(458)] = 20051,
  [SMALL_STATE(459)] = 20074,
  [SMALL_STATE(460)] = 20097,
  [SMALL_STATE(461)] = 20120,
  [SMALL_STATE(462)] = 20143,
  [SMALL_STATE(463)] = 20166,
  [SMALL_STATE(464)] = 20209,
  [SMALL_STATE(465)] = 20252,
  [SMALL_STATE(466)] = 20295,
  [SMALL_STATE(467)] = 20318,
  [SMALL_STATE(468)] = 20341,
  [SMALL_STATE(469)] = 20364,
  [SMALL_STATE(470)] = 20387,
  [SMALL_STATE(471)] = 20410,
  [SMALL_STATE(472)] = 20433,
  [SMALL_STATE(473)] = 20456,
  [SMALL_STATE(474)] = 20479,
  [SMALL_STATE(475)] = 20502,
  [SMALL_STATE(476)] = 20525,
  [SMALL_STATE(477)] = 20548,
  [SMALL_STATE(478)] = 20571,
  [SMALL_STATE(479)] = 20594,
  [SMALL_STATE(480)] = 20617,
  [SMALL_STATE(481)] = 20640,
  [SMALL_STATE(482)] = 20677,
  [SMALL_STATE(483)] = 20714,
  [SMALL_STATE(484)] = 20751,
  [SMALL_STATE(485)] = 20788,
  [SMALL_STATE(486)] = 20825,
  [SMALL_STATE(487)] = 20862,
  [SMALL_STATE(488)] = 20899,
  [SMALL_STATE(489)] = 20928,
  [SMALL_STATE(490)] = 20965,
  [SMALL_STATE(491)] = 20994,
  [SMALL_STATE(492)] = 21031,
  [SMALL_STATE(493)] = 21068,
  [SMALL_STATE(494)] = 21105,
  [SMALL_STATE(495)] = 21142,
  [SMALL_STATE(496)] = 21179,
  [SMALL_STATE(497)] = 21216,
  [SMALL_STATE(498)] = 21243,
  [SMALL_STATE(499)] = 21280,
  [SMALL_STATE(500)] = 21317,
  [SMALL_STATE(501)] = 21354,
  [SMALL_STATE(502)] = 21391,
  [SMALL_STATE(503)] = 21428,
  [SMALL_STATE(504)] = 21450,
  [SMALL_STATE(505)] = 21472,
  [SMALL_STATE(506)] = 21494,
  [SMALL_STATE(507)] = 21515,
  [SMALL_STATE(508)] = 21536,
  [SMALL_STATE(509)] = 21557,
  [SMALL_STATE(510)] = 21578,
  [SMALL_STATE(511)] = 21599,
  [SMALL_STATE(512)] = 21620,
  [SMALL_STATE(513)] = 21641,
  [SMALL_STATE(514)] = 21662,
  [SMALL_STATE(515)] = 21683,
  [SMALL_STATE(516)] = 21705,
  [SMALL_STATE(517)] = 21727,
  [SMALL_STATE(518)] = 21745,
  [SMALL_STATE(519)] = 21763,
  [SMALL_STATE(520)] = 21778,
  [SMALL_STATE(521)] = 21793,
  [SMALL_STATE(522)] = 21812,
  [SMALL_STATE(523)] = 21827,
  [SMALL_STATE(524)] = 21846,
  [SMALL_STATE(525)] = 21865,
  [SMALL_STATE(526)] = 21880,
  [SMALL_STATE(527)] = 21895,
  [SMALL_STATE(528)] = 21910,
  [SMALL_STATE(529)] = 21932,
  [SMALL_STATE(530)] = 21956,
  [SMALL_STATE(531)] = 21978,
  [SMALL_STATE(532)] = 22002,
  [SMALL_STATE(533)] = 22025,
  [SMALL_STATE(534)] = 22048,
  [SMALL_STATE(535)] = 22071,
  [SMALL_STATE(536)] = 22088,
  [SMALL_STATE(537)] = 22111,
  [SMALL_STATE(538)] = 22134,
  [SMALL_STATE(539)] = 22157,
  [SMALL_STATE(540)] = 22176,
  [SMALL_STATE(541)] = 22199,
  [SMALL_STATE(542)] = 22218,
  [SMALL_STATE(543)] = 22241,
  [SMALL_STATE(544)] = 22260,
  [SMALL_STATE(545)] = 22283,
  [SMALL_STATE(546)] = 22306,
  [SMALL_STATE(547)] = 22319,
  [SMALL_STATE(548)] = 22338,
  [SMALL_STATE(549)] = 22361,
  [SMALL_STATE(550)] = 22380,
  [SMALL_STATE(551)] = 22403,
  [SMALL_STATE(552)] = 22422,
  [SMALL_STATE(553)] = 22445,
  [SMALL_STATE(554)] = 22463,
  [SMALL_STATE(555)] = 22481,
  [SMALL_STATE(556)] = 22499,
  [SMALL_STATE(557)] = 22517,
  [SMALL_STATE(558)] = 22535,
  [SMALL_STATE(559)] = 22553,
  [SMALL_STATE(560)] = 22565,
  [SMALL_STATE(561)] = 22583,
  [SMALL_STATE(562)] = 22601,
  [SMALL_STATE(563)] = 22619,
  [SMALL_STATE(564)] = 22637,
  [SMALL_STATE(565)] = 22655,
  [SMALL_STATE(566)] = 22673,
  [SMALL_STATE(567)] = 22691,
  [SMALL_STATE(568)] = 22709,
  [SMALL_STATE(569)] = 22727,
  [SMALL_STATE(570)] = 22745,
  [SMALL_STATE(571)] = 22763,
  [SMALL_STATE(572)] = 22781,
  [SMALL_STATE(573)] = 22799,
  [SMALL_STATE(574)] = 22817,
  [SMALL_STATE(575)] = 22835,
  [SMALL_STATE(576)] = 22853,
  [SMALL_STATE(577)] = 22871,
  [SMALL_STATE(578)] = 22889,
  [SMALL_STATE(579)] = 22907,
  [SMALL_STATE(580)] = 22925,
  [SMALL_STATE(581)] = 22943,
  [SMALL_STATE(582)] = 22961,
  [SMALL_STATE(583)] = 22979,
  [SMALL_STATE(584)] = 22997,
  [SMALL_STATE(585)] = 23015,
  [SMALL_STATE(586)] = 23033,
  [SMALL_STATE(587)] = 23051,
  [SMALL_STATE(588)] = 23064,
  [SMALL_STATE(589)] = 23077,
  [SMALL_STATE(590)] = 23090,
  [SMALL_STATE(591)] = 23103,
  [SMALL_STATE(592)] = 23116,
  [SMALL_STATE(593)] = 23129,
  [SMALL_STATE(594)] = 23142,
  [SMALL_STATE(595)] = 23161,
  [SMALL_STATE(596)] = 23176,
  [SMALL_STATE(597)] = 23195,
  [SMALL_STATE(598)] = 23208,
  [SMALL_STATE(599)] = 23227,
  [SMALL_STATE(600)] = 23246,
  [SMALL_STATE(601)] = 23265,
  [SMALL_STATE(602)] = 23284,
  [SMALL_STATE(603)] = 23303,
  [SMALL_STATE(604)] = 23322,
  [SMALL_STATE(605)] = 23341,
  [SMALL_STATE(606)] = 23360,
  [SMALL_STATE(607)] = 23379,
  [SMALL_STATE(608)] = 23394,
  [SMALL_STATE(609)] = 23407,
  [SMALL_STATE(610)] = 23420,
  [SMALL_STATE(611)] = 23433,
  [SMALL_STATE(612)] = 23452,
  [SMALL_STATE(613)] = 23467,
  [SMALL_STATE(614)] = 23486,
  [SMALL_STATE(615)] = 23505,
  [SMALL_STATE(616)] = 23520,
  [SMALL_STATE(617)] = 23539,
  [SMALL_STATE(618)] = 23552,
  [SMALL_STATE(619)] = 23565,
  [SMALL_STATE(620)] = 23578,
  [SMALL_STATE(621)] = 23591,
  [SMALL_STATE(622)] = 23610,
  [SMALL_STATE(623)] = 23623,
  [SMALL_STATE(624)] = 23642,
  [SMALL_STATE(625)] = 23655,
  [SMALL_STATE(626)] = 23668,
  [SMALL_STATE(627)] = 23681,
  [SMALL_STATE(628)] = 23700,
  [SMALL_STATE(629)] = 23719,
  [SMALL_STATE(630)] = 23738,
  [SMALL_STATE(631)] = 23757,
  [SMALL_STATE(632)] = 23776,
  [SMALL_STATE(633)] = 23793,
  [SMALL_STATE(634)] = 23806,
  [SMALL_STATE(635)] = 23819,
  [SMALL_STATE(636)] = 23832,
  [SMALL_STATE(637)] = 23845,
  [SMALL_STATE(638)] = 23864,
  [SMALL_STATE(639)] = 23877,
  [SMALL_STATE(640)] = 23890,
  [SMALL_STATE(641)] = 23906,
  [SMALL_STATE(642)] = 23920,
  [SMALL_STATE(643)] = 23936,
  [SMALL_STATE(644)] = 23952,
  [SMALL_STATE(645)] = 23968,
  [SMALL_STATE(646)] = 23984,
  [SMALL_STATE(647)] = 23998,
  [SMALL_STATE(648)] = 24012,
  [SMALL_STATE(649)] = 24028,
  [SMALL_STATE(650)] = 24042,
  [SMALL_STATE(651)] = 24056,
  [SMALL_STATE(652)] = 24070,
  [SMALL_STATE(653)] = 24086,
  [SMALL_STATE(654)] = 24100,
  [SMALL_STATE(655)] = 24116,
  [SMALL_STATE(656)] = 24130,
  [SMALL_STATE(657)] = 24146,
  [SMALL_STATE(658)] = 24160,
  [SMALL_STATE(659)] = 24176,
  [SMALL_STATE(660)] = 24192,
  [SMALL_STATE(661)] = 24208,
  [SMALL_STATE(662)] = 24224,
  [SMALL_STATE(663)] = 24238,
  [SMALL_STATE(664)] = 24252,
  [SMALL_STATE(665)] = 24266,
  [SMALL_STATE(666)] = 24282,
  [SMALL_STATE(667)] = 24298,
  [SMALL_STATE(668)] = 24314,
  [SMALL_STATE(669)] = 24330,
  [SMALL_STATE(670)] = 24346,
  [SMALL_STATE(671)] = 24362,
  [SMALL_STATE(672)] = 24378,
  [SMALL_STATE(673)] = 24394,
  [SMALL_STATE(674)] = 24410,
  [SMALL_STATE(675)] = 24426,
  [SMALL_STATE(676)] = 24442,
  [SMALL_STATE(677)] = 24451,
  [SMALL_STATE(678)] = 24464,
  [SMALL_STATE(679)] = 24477,
  [SMALL_STATE(680)] = 24490,
  [SMALL_STATE(681)] = 24503,
  [SMALL_STATE(682)] = 24516,
  [SMALL_STATE(683)] = 24529,
  [SMALL_STATE(684)] = 24542,
  [SMALL_STATE(685)] = 24555,
  [SMALL_STATE(686)] = 24568,
  [SMALL_STATE(687)] = 24581,
  [SMALL_STATE(688)] = 24594,
  [SMALL_STATE(689)] = 24607,
  [SMALL_STATE(690)] = 24620,
  [SMALL_STATE(691)] = 24633,
  [SMALL_STATE(692)] = 24646,
  [SMALL_STATE(693)] = 24659,
  [SMALL_STATE(694)] = 24672,
  [SMALL_STATE(695)] = 24685,
  [SMALL_STATE(696)] = 24698,
  [SMALL_STATE(697)] = 24711,
  [SMALL_STATE(698)] = 24724,
  [SMALL_STATE(699)] = 24737,
  [SMALL_STATE(700)] = 24750,
  [SMALL_STATE(701)] = 24759,
  [SMALL_STATE(702)] = 24772,
  [SMALL_STATE(703)] = 24785,
  [SMALL_STATE(704)] = 24798,
  [SMALL_STATE(705)] = 24811,
  [SMALL_STATE(706)] = 24824,
  [SMALL_STATE(707)] = 24837,
  [SMALL_STATE(708)] = 24850,
  [SMALL_STATE(709)] = 24861,
  [SMALL_STATE(710)] = 24874,
  [SMALL_STATE(711)] = 24887,
  [SMALL_STATE(712)] = 24896,
  [SMALL_STATE(713)] = 24905,
  [SMALL_STATE(714)] = 24918,
  [SMALL_STATE(715)] = 24931,
  [SMALL_STATE(716)] = 24944,
  [SMALL_STATE(717)] = 24957,
  [SMALL_STATE(718)] = 24970,
  [SMALL_STATE(719)] = 24983,
  [SMALL_STATE(720)] = 24996,
  [SMALL_STATE(721)] = 25009,
  [SMALL_STATE(722)] = 25018,
  [SMALL_STATE(723)] = 25027,
  [SMALL_STATE(724)] = 25040,
  [SMALL_STATE(725)] = 25049,
  [SMALL_STATE(726)] = 25058,
  [SMALL_STATE(727)] = 25069,
  [SMALL_STATE(728)] = 25082,
  [SMALL_STATE(729)] = 25095,
  [SMALL_STATE(730)] = 25108,
  [SMALL_STATE(731)] = 25121,
  [SMALL_STATE(732)] = 25134,
  [SMALL_STATE(733)] = 25147,
  [SMALL_STATE(734)] = 25160,
  [SMALL_STATE(735)] = 25173,
  [SMALL_STATE(736)] = 25186,
  [SMALL_STATE(737)] = 25199,
  [SMALL_STATE(738)] = 25212,
  [SMALL_STATE(739)] = 25221,
  [SMALL_STATE(740)] = 25234,
  [SMALL_STATE(741)] = 25247,
  [SMALL_STATE(742)] = 25260,
  [SMALL_STATE(743)] = 25273,
  [SMALL_STATE(744)] = 25286,
  [SMALL_STATE(745)] = 25299,
  [SMALL_STATE(746)] = 25308,
  [SMALL_STATE(747)] = 25321,
  [SMALL_STATE(748)] = 25330,
  [SMALL_STATE(749)] = 25343,
  [SMALL_STATE(750)] = 25352,
  [SMALL_STATE(751)] = 25365,
  [SMALL_STATE(752)] = 25378,
  [SMALL_STATE(753)] = 25391,
  [SMALL_STATE(754)] = 25404,
  [SMALL_STATE(755)] = 25413,
  [SMALL_STATE(756)] = 25426,
  [SMALL_STATE(757)] = 25439,
  [SMALL_STATE(758)] = 25448,
  [SMALL_STATE(759)] = 25461,
  [SMALL_STATE(760)] = 25470,
  [SMALL_STATE(761)] = 25483,
  [SMALL_STATE(762)] = 25492,
  [SMALL_STATE(763)] = 25505,
  [SMALL_STATE(764)] = 25518,
  [SMALL_STATE(765)] = 25527,
  [SMALL_STATE(766)] = 25536,
  [SMALL_STATE(767)] = 25549,
  [SMALL_STATE(768)] = 25558,
  [SMALL_STATE(769)] = 25567,
  [SMALL_STATE(770)] = 25580,
  [SMALL_STATE(771)] = 25593,
  [SMALL_STATE(772)] = 25602,
  [SMALL_STATE(773)] = 25615,
  [SMALL_STATE(774)] = 25624,
  [SMALL_STATE(775)] = 25637,
  [SMALL_STATE(776)] = 25650,
  [SMALL_STATE(777)] = 25659,
  [SMALL_STATE(778)] = 25672,
  [SMALL_STATE(779)] = 25681,
  [SMALL_STATE(780)] = 25690,
  [SMALL_STATE(781)] = 25699,
  [SMALL_STATE(782)] = 25708,
  [SMALL_STATE(783)] = 25717,
  [SMALL_STATE(784)] = 25730,
  [SMALL_STATE(785)] = 25743,
  [SMALL_STATE(786)] = 25756,
  [SMALL_STATE(787)] = 25767,
  [SMALL_STATE(788)] = 25780,
  [SMALL_STATE(789)] = 25793,
  [SMALL_STATE(790)] = 25802,
  [SMALL_STATE(791)] = 25815,
  [SMALL_STATE(792)] = 25828,
  [SMALL_STATE(793)] = 25841,
  [SMALL_STATE(794)] = 25854,
  [SMALL_STATE(795)] = 25867,
  [SMALL_STATE(796)] = 25880,
  [SMALL_STATE(797)] = 25893,
  [SMALL_STATE(798)] = 25906,
  [SMALL_STATE(799)] = 25915,
  [SMALL_STATE(800)] = 25928,
  [SMALL_STATE(801)] = 25941,
  [SMALL_STATE(802)] = 25954,
  [SMALL_STATE(803)] = 25967,
  [SMALL_STATE(804)] = 25980,
  [SMALL_STATE(805)] = 25993,
  [SMALL_STATE(806)] = 26006,
  [SMALL_STATE(807)] = 26016,
  [SMALL_STATE(808)] = 26026,
  [SMALL_STATE(809)] = 26034,
  [SMALL_STATE(810)] = 26044,
  [SMALL_STATE(811)] = 26052,
  [SMALL_STATE(812)] = 26060,
  [SMALL_STATE(813)] = 26070,
  [SMALL_STATE(814)] = 26080,
  [SMALL_STATE(815)] = 26090,
  [SMALL_STATE(816)] = 26100,
  [SMALL_STATE(817)] = 26110,
  [SMALL_STATE(818)] = 26120,
  [SMALL_STATE(819)] = 26130,
  [SMALL_STATE(820)] = 26140,
  [SMALL_STATE(821)] = 26150,
  [SMALL_STATE(822)] = 26158,
  [SMALL_STATE(823)] = 26168,
  [SMALL_STATE(824)] = 26178,
  [SMALL_STATE(825)] = 26186,
  [SMALL_STATE(826)] = 26193,
  [SMALL_STATE(827)] = 26200,
  [SMALL_STATE(828)] = 26207,
  [SMALL_STATE(829)] = 26214,
  [SMALL_STATE(830)] = 26221,
  [SMALL_STATE(831)] = 26228,
  [SMALL_STATE(832)] = 26235,
  [SMALL_STATE(833)] = 26242,
  [SMALL_STATE(834)] = 26249,
  [SMALL_STATE(835)] = 26256,
  [SMALL_STATE(836)] = 26263,
  [SMALL_STATE(837)] = 26270,
  [SMALL_STATE(838)] = 26277,
  [SMALL_STATE(839)] = 26284,
  [SMALL_STATE(840)] = 26291,
  [SMALL_STATE(841)] = 26298,
  [SMALL_STATE(842)] = 26305,
  [SMALL_STATE(843)] = 26312,
  [SMALL_STATE(844)] = 26319,
  [SMALL_STATE(845)] = 26326,
  [SMALL_STATE(846)] = 26333,
  [SMALL_STATE(847)] = 26340,
  [SMALL_STATE(848)] = 26347,
  [SMALL_STATE(849)] = 26354,
  [SMALL_STATE(850)] = 26361,
  [SMALL_STATE(851)] = 26368,
  [SMALL_STATE(852)] = 26375,
  [SMALL_STATE(853)] = 26382,
  [SMALL_STATE(854)] = 26389,
  [SMALL_STATE(855)] = 26396,
  [SMALL_STATE(856)] = 26403,
  [SMALL_STATE(857)] = 26410,
  [SMALL_STATE(858)] = 26417,
  [SMALL_STATE(859)] = 26424,
  [SMALL_STATE(860)] = 26431,
  [SMALL_STATE(861)] = 26438,
  [SMALL_STATE(862)] = 26445,
  [SMALL_STATE(863)] = 26452,
  [SMALL_STATE(864)] = 26459,
  [SMALL_STATE(865)] = 26466,
  [SMALL_STATE(866)] = 26473,
  [SMALL_STATE(867)] = 26480,
  [SMALL_STATE(868)] = 26487,
  [SMALL_STATE(869)] = 26494,
  [SMALL_STATE(870)] = 26501,
  [SMALL_STATE(871)] = 26508,
  [SMALL_STATE(872)] = 26515,
  [SMALL_STATE(873)] = 26522,
  [SMALL_STATE(874)] = 26529,
  [SMALL_STATE(875)] = 26536,
  [SMALL_STATE(876)] = 26543,
  [SMALL_STATE(877)] = 26550,
  [SMALL_STATE(878)] = 26557,
  [SMALL_STATE(879)] = 26564,
  [SMALL_STATE(880)] = 26571,
  [SMALL_STATE(881)] = 26578,
  [SMALL_STATE(882)] = 26585,
  [SMALL_STATE(883)] = 26592,
  [SMALL_STATE(884)] = 26599,
  [SMALL_STATE(885)] = 26606,
  [SMALL_STATE(886)] = 26613,
  [SMALL_STATE(887)] = 26620,
  [SMALL_STATE(888)] = 26627,
  [SMALL_STATE(889)] = 26634,
  [SMALL_STATE(890)] = 26641,
  [SMALL_STATE(891)] = 26648,
  [SMALL_STATE(892)] = 26655,
  [SMALL_STATE(893)] = 26662,
  [SMALL_STATE(894)] = 26669,
  [SMALL_STATE(895)] = 26676,
  [SMALL_STATE(896)] = 26683,
  [SMALL_STATE(897)] = 26690,
  [SMALL_STATE(898)] = 26697,
  [SMALL_STATE(899)] = 26704,
  [SMALL_STATE(900)] = 26711,
  [SMALL_STATE(901)] = 26718,
  [SMALL_STATE(902)] = 26725,
  [SMALL_STATE(903)] = 26732,
  [SMALL_STATE(904)] = 26739,
  [SMALL_STATE(905)] = 26746,
  [SMALL_STATE(906)] = 26753,
  [SMALL_STATE(907)] = 26760,
  [SMALL_STATE(908)] = 26767,
  [SMALL_STATE(909)] = 26774,
  [SMALL_STATE(910)] = 26781,
  [SMALL_STATE(911)] = 26788,
  [SMALL_STATE(912)] = 26795,
  [SMALL_STATE(913)] = 26802,
  [SMALL_STATE(914)] = 26809,
  [SMALL_STATE(915)] = 26816,
  [SMALL_STATE(916)] = 26823,
  [SMALL_STATE(917)] = 26830,
  [SMALL_STATE(918)] = 26837,
  [SMALL_STATE(919)] = 26844,
  [SMALL_STATE(920)] = 26851,
  [SMALL_STATE(921)] = 26858,
  [SMALL_STATE(922)] = 26865,
  [SMALL_STATE(923)] = 26872,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(794),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(797),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(919),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(918),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(907),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(902),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(901),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(899),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(897),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(812),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(798),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(798),
  [39] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__type_identifier_repeat1, 2, 0, 0),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__type_identifier_repeat1, 2, 0, 0),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__type_identifier_repeat1, 2, 0, 0), SHIFT_REPEAT(868),
  [46] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_identifier, 2, 0, 1),
  [48] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_identifier, 2, 0, 1),
  [50] = {.entry = {.count = 1, .reusable = true}}, SHIFT(868),
  [52] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_identifier, 1, 0, 1),
  [54] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_identifier, 1, 0, 1),
  [56] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_package_declaration_repeat1, 2, 0, 0),
  [58] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_package_declaration_repeat1, 2, 0, 0), SHIFT_REPEAT(812),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_package_declaration_repeat1, 2, 0, 0),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fb_annotation_definition, 2, 0, 0),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fb_annotation_definition, 2, 0, 0),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1, 0, 0),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fb_annotation_definition, 5, 0, 0),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fb_annotation_definition, 5, 0, 0),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fb_annotation_definition, 4, 0, 0),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fb_annotation_definition, 4, 0, 0),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(541),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(909),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(593),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(609),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(854),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(670),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(640),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(827),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(828),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [113] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(541),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8),
  [118] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(909),
  [121] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(399),
  [124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(593),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(609),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(854),
  [133] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(670),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(640),
  [139] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(827),
  [142] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(828),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_service_definition_repeat1, 2, 0, 8), SHIFT_REPEAT(812),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(595),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(721),
  [190] = {.entry = {.count = 1, .reusable = false}}, SHIFT(722),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(904),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(643),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(652),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(922),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(906),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(893),
  [204] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(541),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0),
  [209] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(399),
  [212] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(593),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(609),
  [218] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(854),
  [221] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(670),
  [224] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(640),
  [227] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(827),
  [230] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(828),
  [233] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interaction_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(812),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [246] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(595),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0),
  [251] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(398),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(721),
  [257] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(722),
  [260] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(904),
  [263] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(643),
  [266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(652),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(922),
  [272] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(906),
  [275] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(812),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(893),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [313] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(541),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(398),
  [321] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(593),
  [324] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(609),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(854),
  [330] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(670),
  [333] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(640),
  [336] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(827),
  [339] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(828),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(812),
  [345] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(893),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_definition, 6, 0, 0),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_definition, 6, 0, 0),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_definition, 5, 0, 0),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_definition, 5, 0, 0),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_definition, 4, 0, 0),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_definition, 4, 0, 0),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_definition, 7, 0, 0),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_definition, 7, 0, 0),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_definition, 2, 0, 0),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_definition, 2, 0, 0),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_definition, 3, 0, 0),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_definition, 3, 0, 0),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1, 0, 1),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1, 0, 1),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(699),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 2, 0, 1),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 2, 0, 1),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(691),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 6, 0, 0),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(706),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 6, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(841),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 3, 0, 0),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [418] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, 0, 0),
  [420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 2, 0, 0),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0),
  [428] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(209),
  [431] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(275),
  [434] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(919),
  [437] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(918),
  [440] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(907),
  [443] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(902),
  [446] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(901),
  [449] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(546),
  [452] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(899),
  [455] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(897),
  [458] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2, 0, 0), SHIFT_REPEAT(812),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 7, 0, 0),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 7, 0, 0),
  [469] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [473] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 4, 0, 0),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, 0, 0),
  [481] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [483] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [485] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 2, 0, 0),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 2, 0, 0),
  [493] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [495] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [497] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 5, 0, 0),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 5, 0, 0),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [509] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 3, 0, 0),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 3, 0, 0),
  [517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 6, 0, 0),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 6, 0, 0),
  [531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 4, 0, 0),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 4, 0, 0),
  [543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(149),
  [547] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 5, 0, 0),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, 0, 0),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [559] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 2, 0, 0),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 2, 0, 0),
  [567] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [571] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 3, 0, 0),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 3, 0, 0),
  [577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(813),
  [579] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 7, 0, 0),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 7, 0, 0),
  [585] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [587] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 6, 0, 0),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 6, 0, 0),
  [595] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 9, 0, 0),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 9, 0, 0),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [605] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 8, 0, 0),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 8, 0, 0),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [613] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [615] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 7, 0, 0),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 7, 0, 0),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 8, 0, 0),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 8, 0, 0),
  [627] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [629] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 5, 0, 0),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [635] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 5, 0, 0),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 4, 0, 0),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 4, 0, 0),
  [643] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 2, 0, 0),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 2, 0, 0),
  [647] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 2, 0, 0),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2, 0, 0),
  [651] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 9, 0, 0),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 9, 0, 0),
  [657] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [659] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [663] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 10, 0, 0),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 10, 0, 0),
  [669] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [671] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1, 0, 0),
  [673] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1, 0, 0),
  [675] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_literal, 5, 0, 1),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_literal, 5, 0, 1),
  [679] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [683] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_literal, 4, 0, 1),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_literal, 4, 0, 1),
  [687] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_literal, 3, 0, 1),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_literal, 3, 0, 1),
  [691] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 3, 0, 0),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3, 0, 0),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 3, 0, 0),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 3, 0, 0),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_literal, 2, 0, 0),
  [701] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_literal, 2, 0, 0),
  [703] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_literal, 3, 0, 0),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_literal, 3, 0, 0),
  [707] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 11, 0, 0),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 11, 0, 0),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 8, 0, 0),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 8, 0, 0),
  [719] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_throws, 2, 0, 0),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_throws, 2, 0, 0),
  [723] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 10, 0, 0),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [727] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 10, 0, 0),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0),
  [731] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(794),
  [734] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(2),
  [737] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(797),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(812),
  [743] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_xsd_attrs, 3, 0, 0),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_xsd_attrs, 3, 0, 0),
  [747] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 12, 0, 0),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 12, 0, 0),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 9, 0, 0),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 9, 0, 0),
  [759] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 11, 0, 0),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 11, 0, 0),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_xsd_attrs, 4, 0, 0),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_xsd_attrs, 4, 0, 0),
  [769] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__type_identifier_repeat1, 2, 0, 0), SHIFT_REPEAT(870),
  [772] = {.entry = {.count = 1, .reusable = false}}, SHIFT(917),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 3, 0, 2),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(883),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(870),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 4, 0, 4),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [786] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 13, 0, 0),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 13, 0, 0),
  [792] = {.entry = {.count = 1, .reusable = false}}, SHIFT(647),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 12, 0, 0),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 12, 0, 0),
  [800] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 3, 0, 6),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_service_definition_repeat1, 3, 0, 6),
  [804] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_service_definition_repeat1, 4, 0, 6),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_service_definition_repeat1, 4, 0, 6),
  [808] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 10, 0, 0),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 10, 0, 0),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 3, 0, 0),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [816] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 14, 0, 0),
  [818] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 14, 0, 0),
  [820] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter, 13, 0, 0),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 13, 0, 0),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(730),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(801),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 5, 0, 4),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 4, 0, 2),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 4, 0, 0),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_uri, 5, 0, 0),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_package_declaration, 2, 0, 0),
  [844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_definition, 6, 0, 0),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(803),
  [850] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_package_declaration, 3, 0, 0),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 6, 0, 4),
  [854] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_definition, 5, 0, 0),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [858] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 5, 0, 2),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_header, 1, 0, 0),
  [862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 4, 0, 5),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 3, 0, 3),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_declaration, 5, 0, 0),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2, 0, 0),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 5, 0, 9),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_id, 2, 0, 0),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 11),
  [882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 6, 0, 11),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_definition, 7, 0, 0),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 6, 0, 6),
  [890] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 18),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 15),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 15),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 4, 0, 3),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [900] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 19),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 14),
  [904] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 7, 0, 10),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 5, 0, 6),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 7, 0, 10),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 4, 0, 6),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 5, 0, 5),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 16),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 22),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 6, 0, 6),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 6, 0, 6),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 17),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 23),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 7, 0, 6),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 7, 0, 6),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exception_definition, 7, 0, 0),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 5, 0, 6),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 5, 0, 6),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 7, 0, 10),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exception_definition, 5, 0, 0),
  [942] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 24),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(719),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(851),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(853),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(855),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(856),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(859),
  [960] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 6, 0, 12),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 21),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 21),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 16),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interaction_definition, 6, 0, 6),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 20),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 5, 0, 7),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 8, 0, 10),
  [976] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 6, 0, 9),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 5, 0, 6),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 6, 0, 10),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 8, 0, 10),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interaction_definition, 5, 0, 6),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 6, 0, 10),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 4, 0, 6),
  [992] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 5, 0, 10),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exception_definition, 4, 0, 0),
  [996] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 6, 0, 10),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 10, 0, 25),
  [1000] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 5, 0, 10),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exception_definition, 6, 0, 0),
  [1004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 5, 0, 10),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 6, 0, 13),
  [1008] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 5, 0, 10),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interaction_definition, 4, 0, 6),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 6, 0, 10),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 4, 0, 6),
  [1016] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 4, 0, 6),
  [1018] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_modifier, 1, 0, 0),
  [1020] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_modifier, 1, 0, 0),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 10, 0, 21),
  [1024] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 10, 0, 24),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exception_definition, 8, 0, 0),
  [1028] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 10, 0, 23),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 10, 0, 22),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 17),
  [1034] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition, 1, 0, 0),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 8, 0, 10),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 11, 0, 25),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_definition, 8, 0, 0),
  [1042] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 11),
  [1044] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(578),
  [1047] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(451),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0),
  [1052] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(304),
  [1055] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(309),
  [1058] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(453),
  [1061] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(556),
  [1064] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_map_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(583),
  [1067] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 8, 0, 14),
  [1069] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(490),
  [1072] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(457),
  [1075] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(507),
  [1078] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(509),
  [1081] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(464),
  [1084] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0),
  [1086] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(586),
  [1089] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(581),
  [1092] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 8, 0, 6),
  [1094] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_senum_definition, 4, 0, 6),
  [1096] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 8, 0, 6),
  [1098] = {.entry = {.count = 1, .reusable = false}}, SHIFT(490),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1102] = {.entry = {.count = 1, .reusable = false}}, SHIFT(507),
  [1104] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1114] = {.entry = {.count = 1, .reusable = false}}, SHIFT(578),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1120] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [1122] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_senum_definition, 5, 0, 6),
  [1134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 7, 0, 6),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 6, 0, 6),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 6, 0, 7),
  [1146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 5, 0, 3),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 10),
  [1154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 16),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 20),
  [1160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_definition, 9, 0, 10),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 12),
  [1170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 9, 0, 10),
  [1172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 15),
  [1174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_senum_definition, 6, 0, 6),
  [1176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interaction_definition, 7, 0, 6),
  [1178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 7, 0, 13),
  [1180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 7, 0, 9),
  [1182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 19),
  [1184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_definition, 9, 0, 18),
  [1186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typedef_definition, 6, 0, 5),
  [1188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [1194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [1206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(889),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(752),
  [1210] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__type_identifier_repeat1, 2, 0, 0), SHIFT_REPEAT(889),
  [1213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(576),
  [1215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_map_literal_repeat1, 3, 0, 0),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_map_literal_repeat1, 3, 0, 0),
  [1221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_literal_repeat1, 1, 0, 0),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_literal_repeat1, 1, 0, 0),
  [1227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_map_literal_repeat1, 4, 0, 0),
  [1229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_map_literal_repeat1, 4, 0, 0),
  [1231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_literal_repeat1, 2, 0, 0),
  [1233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_exception_definition_repeat1, 2, 0, 0),
  [1235] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_exception_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(546),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(881),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(761),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(707),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(837),
  [1246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 2, 0, 0),
  [1248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5, 0, 0),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(863),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 1, 0, 0),
  [1256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, 0, 0),
  [1258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(817),
  [1261] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(530),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(817),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1272] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__type_identifier_repeat1, 2, 0, 0), SHIFT_REPEAT(867),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type, 1, 0, 1),
  [1279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1, 0, 1),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(789),
  [1283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 4, 0, 0),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exception_modifier, 1, 0, 0),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [1295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 3, 0, 0),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type, 2, 0, 1),
  [1301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 2, 0, 1),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 6, 0, 0),
  [1307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 5, 0, 0),
  [1309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 5, 0, 0),
  [1311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 4, 0, 0),
  [1313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 4, 0, 0),
  [1315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 6, 0, 0),
  [1317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 6, 0, 0),
  [1319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [1323] = {.entry = {.count = 1, .reusable = false}}, SHIFT(585),
  [1325] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(782),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1331] = {.entry = {.count = 1, .reusable = false}}, SHIFT(571),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(572),
  [1337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 8, 0, 0),
  [1339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 8, 0, 0),
  [1341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(781),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(557),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(560),
  [1351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 6, 0, 0),
  [1353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 6, 0, 0),
  [1355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [1357] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1361] = {.entry = {.count = 1, .reusable = false}}, SHIFT(567),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1365] = {.entry = {.count = 1, .reusable = false}}, SHIFT(568),
  [1367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0),
  [1369] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0), SHIFT_REPEAT(571),
  [1372] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0), SHIFT_REPEAT(571),
  [1375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [1377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(572),
  [1380] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(572),
  [1383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 9, 0, 0),
  [1385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 9, 0, 0),
  [1387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [1389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(579),
  [1395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 7, 0, 0),
  [1397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 7, 0, 0),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [1401] = {.entry = {.count = 1, .reusable = false}}, SHIFT(584),
  [1403] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(580),
  [1409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 7, 0, 0),
  [1411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 7, 0, 0),
  [1413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sink, 7, 0, 0),
  [1415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sink, 7, 0, 0),
  [1417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stream, 5, 0, 0),
  [1419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stream, 5, 0, 0),
  [1421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 7, 0, 0),
  [1423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 7, 0, 0),
  [1425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type, 1, 0, 0),
  [1427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1, 0, 0),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(813),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(867),
  [1435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_senum_definition_repeat1, 2, 0, 0),
  [1437] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_senum_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(556),
  [1440] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_senum_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(583),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(822),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(768),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(773),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(819),
  [1465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primitive, 1, 0, 0),
  [1467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primitive, 1, 0, 0),
  [1469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stream, 4, 0, 0),
  [1471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stream, 4, 0, 0),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(725),
  [1485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 5, 0, 0),
  [1487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_container_type, 1, 0, 0),
  [1489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_container_type, 1, 0, 0),
  [1491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sink, 9, 0, 0),
  [1493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sink, 9, 0, 0),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(820),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(818),
  [1499] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sink, 8, 0, 0),
  [1501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sink, 8, 0, 0),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [1505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_senum_definition_repeat1, 1, 0, 0),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 6, 0, 0),
  [1519] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sink, 6, 0, 0),
  [1521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sink, 6, 0, 0),
  [1523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5, 0, 0),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sink, 10, 0, 0),
  [1529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sink, 10, 0, 0),
  [1531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 10, 0, 0),
  [1533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 10, 0, 0),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(838),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(763),
  [1551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition_type, 1, 0, 1),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(836),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(826),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(835),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(876),
  [1573] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_package_declaration_repeat1, 2, 0, 0), SHIFT_REPEAT(817),
  [1576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_definition_repeat1, 2, 0, 0),
  [1578] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(227),
  [1581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition_type, 2, 0, 1),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(912),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(892),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(703),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(864),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(705),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(905),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(834),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(877),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(900),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(793),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(914),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(681),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [1669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [1683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fb_annotation_definition_repeat1, 3, 0, 0),
  [1691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(811),
  [1693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(783),
  [1697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(778),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(714),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [1713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_definition_repeat1, 6, 0, 0),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [1729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [1741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1747] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fb_annotation_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(914),
  [1750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fb_annotation_definition_repeat1, 2, 0, 0),
  [1752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [1762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(743),
  [1766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_definition_repeat1, 2, 0, 0),
  [1770] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(814),
  [1773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [1791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(741),
  [1793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(824),
  [1795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(738),
  [1799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_scope, 1, 0, 0),
  [1805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(821),
  [1817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_definition_repeat1, 4, 0, 0),
  [1823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition_type, 1, 0, 0),
  [1825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fb_annotation_definition_repeat1, 4, 0, 0),
  [1827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(749),
  [1841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(871),
  [1843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(737),
  [1847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [1855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(816),
  [1857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [1865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(672),
  [1867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(880),
  [1873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [1875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [1877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(780),
  [1879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(766),
  [1899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(920),
  [1901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(891),
  [1905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(890),
  [1907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [1911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(784),
  [1917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(755),
  [1921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1923] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(720),
  [1929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [1933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(848),
  [1937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [1939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [1947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [1951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(750),
  [1955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(742),
  [1965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(753),
  [1967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_thrift(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
