#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 654
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 207
#define ALIAS_COUNT 0
#define TOKEN_COUNT 87
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 8
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 14

enum ts_symbol_identifiers {
  anon_sym_POUND = 1,
  anon_sym_LBRACK = 2,
  anon_sym_RBRACK = 3,
  anon_sym_SEMI = 4,
  anon_sym_fn = 5,
  anon_sym_entity = 6,
  anon_sym_DASH_GT = 7,
  anon_sym_pipeline = 8,
  anon_sym_LPAREN = 9,
  anon_sym_RPAREN = 10,
  anon_sym_where = 11,
  anon_sym_COLON = 12,
  anon_sym_COMMA = 13,
  anon_sym_struct = 14,
  anon_sym_port = 15,
  anon_sym_enum = 16,
  anon_sym_impl = 17,
  anon_sym_for = 18,
  anon_sym_LBRACE = 19,
  anon_sym_RBRACE = 20,
  anon_sym_trait = 21,
  anon_sym_use = 22,
  anon_sym_mod = 23,
  anon_sym_DOLLARconfig = 24,
  anon_sym_EQ = 25,
  anon_sym_let = 26,
  anon_sym_reg = 27,
  anon_sym_set = 28,
  anon_sym_decl = 29,
  anon_sym_STAR = 30,
  anon_sym_SQUOTE = 31,
  anon_sym_DOLLARif = 32,
  anon_sym_DOLLARelse = 33,
  anon_sym_assert = 34,
  anon_sym_reset = 35,
  anon_sym_initial = 36,
  anon_sym_PLUS = 37,
  anon_sym_DASH = 38,
  sym_op_div = 39,
  sym_op_mod = 40,
  sym_op_equals = 41,
  sym_op_ne = 42,
  anon_sym_LT = 43,
  anon_sym_GT = 44,
  sym_op_le = 45,
  sym_op_ge = 46,
  sym_op_lshift = 47,
  sym_op_rshift = 48,
  anon_sym_AMP = 49,
  sym_op_bitwise_xor = 50,
  sym_op_bitwise_or = 51,
  sym_op_logical_and = 52,
  sym_op_logical_or = 53,
  anon_sym_BQUOTE = 54,
  anon_sym_BANG = 55,
  anon_sym_TILDE = 56,
  anon_sym_if = 57,
  anon_sym_else = 58,
  anon_sym_gen = 59,
  anon_sym_match = 60,
  anon_sym_EQ_GT = 61,
  anon_sym_DOT = 62,
  anon_sym_inst = 63,
  anon_sym_COLON_COLON_LT = 64,
  anon_sym_COLON_COLON_DOLLAR_LT = 65,
  anon_sym_stage = 66,
  anon_sym_RPAREN_DOT = 67,
  anon_sym_true = 68,
  anon_sym_false = 69,
  anon_sym___builtin__ = 70,
  anon_sym_DOLLAR_LPAREN = 71,
  sym_self = 72,
  anon_sym_inv = 73,
  anon_sym_int = 74,
  anon_sym_bool = 75,
  anon_sym_clock = 76,
  sym_identifier = 77,
  anon_sym_COLON_COLON = 78,
  aux_sym_int_literal_token1 = 79,
  aux_sym_int_literal_token2 = 80,
  aux_sym_int_literal_token3 = 81,
  sym_doc_comment = 82,
  sym_line_comment = 83,
  anon_sym_SLASH_STAR = 84,
  aux_sym_block_comment_token1 = 85,
  anon_sym_STAR_SLASH = 86,
  sym_source_file = 87,
  sym_attribute = 88,
  sym__item = 89,
  sym_unit_definition = 90,
  sym_unit_declaration = 91,
  sym__unit_head = 92,
  sym__pipeline_start = 93,
  sym_where_clause = 94,
  sym_struct_definition = 95,
  sym_enum_definition = 96,
  sym_impl = 97,
  sym_trait = 98,
  sym_enum_body = 99,
  sym_enum_member = 100,
  sym_use = 101,
  sym_mod = 102,
  sym_comptime_config = 103,
  sym__body_or_builtin = 104,
  sym_block = 105,
  sym__statement = 106,
  sym_let_binding = 107,
  sym_reg_statement = 108,
  sym_set_statement = 109,
  sym_decl_statement = 110,
  sym_pipeline_reg_marker = 111,
  sym_pipeline_stage_name = 112,
  sym__comptime_operator = 113,
  sym_comptime_if = 114,
  sym_comptime_else = 115,
  sym_assert_statement = 116,
  sym_reg_reset = 117,
  sym_reg_initial = 118,
  sym__expression = 119,
  sym_op_add = 120,
  sym_op_sub = 121,
  sym_op_mul = 122,
  sym_op_lt = 123,
  sym_op_gt = 124,
  sym_op_bitwise_and = 125,
  sym__op_mul_like = 126,
  sym__op_add_like = 127,
  sym__op_relational = 128,
  sym__op_eq_like = 129,
  sym__op_shifty = 130,
  sym_op_custom_infix = 131,
  sym_binary_expression = 132,
  sym_unary_expression = 133,
  sym_if_expression = 134,
  sym_gen_if_expression = 135,
  sym_naked_gen_if_expression = 136,
  sym_match_expression = 137,
  sym_match_block = 138,
  sym_match_arm = 139,
  sym_last_match_arm = 140,
  sym__base_expression = 141,
  sym__simple_base_expression = 142,
  sym_field_access = 143,
  sym_method_call = 144,
  sym_index = 145,
  sym_array_literal = 146,
  sym_tuple_literal = 147,
  sym_paren_expression = 148,
  sym_function_call = 149,
  sym_entity_instance = 150,
  sym_pipeline_instance = 151,
  sym_turbofish = 152,
  sym_named_turbofish_arg = 153,
  sym_stage_reference = 154,
  sym_bool_literal = 155,
  sym_builtin_marker = 156,
  sym_argument_list = 157,
  sym__named_argument_list = 158,
  sym__named_argument = 159,
  sym__positional_argument_list = 160,
  sym_parameter_list = 161,
  sym_braced_parameter_list = 162,
  sym_typed_parameter = 163,
  sym_parameter = 164,
  sym__pattern = 165,
  sym_tuple_pattern = 166,
  sym_named_unpack = 167,
  sym_positional_unpack = 168,
  sym__named_pattern_list = 169,
  sym__positional_pattern_list = 170,
  sym_named_pattern_param = 171,
  sym_type = 172,
  sym_tuple_type = 173,
  sym_array_type = 174,
  sym_wire = 175,
  sym_inverted = 176,
  sym__generic_list = 177,
  sym_generic_parameters = 178,
  sym_generic_param = 179,
  sym__base_type = 180,
  sym_builtin_type = 181,
  sym_scoped_identifier = 182,
  sym__path = 183,
  sym__scoped_or_raw_ident = 184,
  sym_int_literal = 185,
  sym_block_comment = 186,
  aux_sym_source_file_repeat1 = 187,
  aux_sym__item_repeat1 = 188,
  aux_sym_where_clause_repeat1 = 189,
  aux_sym_impl_repeat1 = 190,
  aux_sym_trait_repeat1 = 191,
  aux_sym_enum_body_repeat1 = 192,
  aux_sym_block_repeat1 = 193,
  aux_sym_reg_statement_repeat1 = 194,
  aux_sym_decl_statement_repeat1 = 195,
  aux_sym_match_block_repeat1 = 196,
  aux_sym_array_literal_repeat1 = 197,
  aux_sym_turbofish_repeat1 = 198,
  aux_sym_turbofish_repeat2 = 199,
  aux_sym__named_argument_list_repeat1 = 200,
  aux_sym__positional_argument_list_repeat1 = 201,
  aux_sym_parameter_list_repeat1 = 202,
  aux_sym_tuple_pattern_repeat1 = 203,
  aux_sym__named_pattern_list_repeat1 = 204,
  aux_sym_generic_parameters_repeat1 = 205,
  aux_sym_block_comment_repeat1 = 206,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_SEMI] = ";",
  [anon_sym_fn] = "fn",
  [anon_sym_entity] = "entity",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_pipeline] = "pipeline",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_where] = "where",
  [anon_sym_COLON] = ":",
  [anon_sym_COMMA] = ",",
  [anon_sym_struct] = "struct",
  [anon_sym_port] = "port",
  [anon_sym_enum] = "enum",
  [anon_sym_impl] = "impl",
  [anon_sym_for] = "for",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_trait] = "trait",
  [anon_sym_use] = "use",
  [anon_sym_mod] = "mod",
  [anon_sym_DOLLARconfig] = "$config",
  [anon_sym_EQ] = "=",
  [anon_sym_let] = "let",
  [anon_sym_reg] = "reg",
  [anon_sym_set] = "set",
  [anon_sym_decl] = "decl",
  [anon_sym_STAR] = "*",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DOLLARif] = "$if",
  [anon_sym_DOLLARelse] = "$else",
  [anon_sym_assert] = "assert",
  [anon_sym_reset] = "reset",
  [anon_sym_initial] = "initial",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [sym_op_div] = "op_div",
  [sym_op_mod] = "op_mod",
  [sym_op_equals] = "op_equals",
  [sym_op_ne] = "op_ne",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [sym_op_le] = "op_le",
  [sym_op_ge] = "op_ge",
  [sym_op_lshift] = "op_lshift",
  [sym_op_rshift] = "op_rshift",
  [anon_sym_AMP] = "&",
  [sym_op_bitwise_xor] = "op_bitwise_xor",
  [sym_op_bitwise_or] = "op_bitwise_or",
  [sym_op_logical_and] = "op_logical_and",
  [sym_op_logical_or] = "op_logical_or",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_gen] = "gen",
  [anon_sym_match] = "match",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_DOT] = ".",
  [anon_sym_inst] = "inst",
  [anon_sym_COLON_COLON_LT] = "::<",
  [anon_sym_COLON_COLON_DOLLAR_LT] = "::$<",
  [anon_sym_stage] = "stage",
  [anon_sym_RPAREN_DOT] = ").",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym___builtin__] = "__builtin__",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [sym_self] = "self",
  [anon_sym_inv] = "inv",
  [anon_sym_int] = "int",
  [anon_sym_bool] = "bool",
  [anon_sym_clock] = "clock",
  [sym_identifier] = "identifier",
  [anon_sym_COLON_COLON] = "::",
  [aux_sym_int_literal_token1] = "int_literal_token1",
  [aux_sym_int_literal_token2] = "int_literal_token2",
  [aux_sym_int_literal_token3] = "int_literal_token3",
  [sym_doc_comment] = "doc_comment",
  [sym_line_comment] = "line_comment",
  [anon_sym_SLASH_STAR] = "/*",
  [aux_sym_block_comment_token1] = "block_comment_token1",
  [anon_sym_STAR_SLASH] = "*/",
  [sym_source_file] = "source_file",
  [sym_attribute] = "attribute",
  [sym__item] = "_item",
  [sym_unit_definition] = "unit_definition",
  [sym_unit_declaration] = "unit_declaration",
  [sym__unit_head] = "_unit_head",
  [sym__pipeline_start] = "_pipeline_start",
  [sym_where_clause] = "where_clause",
  [sym_struct_definition] = "struct_definition",
  [sym_enum_definition] = "enum_definition",
  [sym_impl] = "impl",
  [sym_trait] = "trait",
  [sym_enum_body] = "enum_body",
  [sym_enum_member] = "enum_member",
  [sym_use] = "use",
  [sym_mod] = "mod",
  [sym_comptime_config] = "comptime_config",
  [sym__body_or_builtin] = "_body_or_builtin",
  [sym_block] = "block",
  [sym__statement] = "_statement",
  [sym_let_binding] = "let_binding",
  [sym_reg_statement] = "reg_statement",
  [sym_set_statement] = "set_statement",
  [sym_decl_statement] = "decl_statement",
  [sym_pipeline_reg_marker] = "pipeline_reg_marker",
  [sym_pipeline_stage_name] = "pipeline_stage_name",
  [sym__comptime_operator] = "_comptime_operator",
  [sym_comptime_if] = "comptime_if",
  [sym_comptime_else] = "comptime_else",
  [sym_assert_statement] = "assert_statement",
  [sym_reg_reset] = "reg_reset",
  [sym_reg_initial] = "reg_initial",
  [sym__expression] = "_expression",
  [sym_op_add] = "op_add",
  [sym_op_sub] = "op_sub",
  [sym_op_mul] = "op_mul",
  [sym_op_lt] = "op_lt",
  [sym_op_gt] = "op_gt",
  [sym_op_bitwise_and] = "op_bitwise_and",
  [sym__op_mul_like] = "_op_mul_like",
  [sym__op_add_like] = "_op_add_like",
  [sym__op_relational] = "_op_relational",
  [sym__op_eq_like] = "_op_eq_like",
  [sym__op_shifty] = "_op_shifty",
  [sym_op_custom_infix] = "op_custom_infix",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_if_expression] = "if_expression",
  [sym_gen_if_expression] = "gen_if_expression",
  [sym_naked_gen_if_expression] = "naked_gen_if_expression",
  [sym_match_expression] = "match_expression",
  [sym_match_block] = "match_block",
  [sym_match_arm] = "match_arm",
  [sym_last_match_arm] = "match_arm",
  [sym__base_expression] = "_base_expression",
  [sym__simple_base_expression] = "_simple_base_expression",
  [sym_field_access] = "field_access",
  [sym_method_call] = "method_call",
  [sym_index] = "index",
  [sym_array_literal] = "array_literal",
  [sym_tuple_literal] = "tuple_literal",
  [sym_paren_expression] = "paren_expression",
  [sym_function_call] = "function_call",
  [sym_entity_instance] = "entity_instance",
  [sym_pipeline_instance] = "pipeline_instance",
  [sym_turbofish] = "turbofish",
  [sym_named_turbofish_arg] = "named_turbofish_arg",
  [sym_stage_reference] = "stage_reference",
  [sym_bool_literal] = "bool_literal",
  [sym_builtin_marker] = "builtin_marker",
  [sym_argument_list] = "argument_list",
  [sym__named_argument_list] = "_named_argument_list",
  [sym__named_argument] = "_named_argument",
  [sym__positional_argument_list] = "_positional_argument_list",
  [sym_parameter_list] = "parameter_list",
  [sym_braced_parameter_list] = "braced_parameter_list",
  [sym_typed_parameter] = "typed_parameter",
  [sym_parameter] = "parameter",
  [sym__pattern] = "_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_named_unpack] = "named_unpack",
  [sym_positional_unpack] = "positional_unpack",
  [sym__named_pattern_list] = "_named_pattern_list",
  [sym__positional_pattern_list] = "_positional_pattern_list",
  [sym_named_pattern_param] = "named_pattern_param",
  [sym_type] = "type",
  [sym_tuple_type] = "tuple_type",
  [sym_array_type] = "array_type",
  [sym_wire] = "wire",
  [sym_inverted] = "inverted",
  [sym__generic_list] = "_generic_list",
  [sym_generic_parameters] = "generic_parameters",
  [sym_generic_param] = "generic_param",
  [sym__base_type] = "_base_type",
  [sym_builtin_type] = "builtin_type",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym__path] = "_path",
  [sym__scoped_or_raw_ident] = "_scoped_or_raw_ident",
  [sym_int_literal] = "int_literal",
  [sym_block_comment] = "block_comment",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym__item_repeat1] = "_item_repeat1",
  [aux_sym_where_clause_repeat1] = "where_clause_repeat1",
  [aux_sym_impl_repeat1] = "impl_repeat1",
  [aux_sym_trait_repeat1] = "trait_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_reg_statement_repeat1] = "reg_statement_repeat1",
  [aux_sym_decl_statement_repeat1] = "decl_statement_repeat1",
  [aux_sym_match_block_repeat1] = "match_block_repeat1",
  [aux_sym_array_literal_repeat1] = "array_literal_repeat1",
  [aux_sym_turbofish_repeat1] = "turbofish_repeat1",
  [aux_sym_turbofish_repeat2] = "turbofish_repeat2",
  [aux_sym__named_argument_list_repeat1] = "_named_argument_list_repeat1",
  [aux_sym__positional_argument_list_repeat1] = "_positional_argument_list_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [aux_sym__named_pattern_list_repeat1] = "_named_pattern_list_repeat1",
  [aux_sym_generic_parameters_repeat1] = "generic_parameters_repeat1",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_entity] = anon_sym_entity,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_pipeline] = anon_sym_pipeline,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_where] = anon_sym_where,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_port] = anon_sym_port,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_impl] = anon_sym_impl,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_trait] = anon_sym_trait,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_DOLLARconfig] = anon_sym_DOLLARconfig,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_reg] = anon_sym_reg,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_decl] = anon_sym_decl,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DOLLARif] = anon_sym_DOLLARif,
  [anon_sym_DOLLARelse] = anon_sym_DOLLARelse,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_reset] = anon_sym_reset,
  [anon_sym_initial] = anon_sym_initial,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_op_div] = sym_op_div,
  [sym_op_mod] = sym_op_mod,
  [sym_op_equals] = sym_op_equals,
  [sym_op_ne] = sym_op_ne,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [sym_op_le] = sym_op_le,
  [sym_op_ge] = sym_op_ge,
  [sym_op_lshift] = sym_op_lshift,
  [sym_op_rshift] = sym_op_rshift,
  [anon_sym_AMP] = anon_sym_AMP,
  [sym_op_bitwise_xor] = sym_op_bitwise_xor,
  [sym_op_bitwise_or] = sym_op_bitwise_or,
  [sym_op_logical_and] = sym_op_logical_and,
  [sym_op_logical_or] = sym_op_logical_or,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_gen] = anon_sym_gen,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_inst] = anon_sym_inst,
  [anon_sym_COLON_COLON_LT] = anon_sym_COLON_COLON_LT,
  [anon_sym_COLON_COLON_DOLLAR_LT] = anon_sym_COLON_COLON_DOLLAR_LT,
  [anon_sym_stage] = anon_sym_stage,
  [anon_sym_RPAREN_DOT] = anon_sym_RPAREN_DOT,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym___builtin__] = anon_sym___builtin__,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [sym_self] = sym_self,
  [anon_sym_inv] = anon_sym_inv,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_clock] = anon_sym_clock,
  [sym_identifier] = sym_identifier,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [aux_sym_int_literal_token1] = aux_sym_int_literal_token1,
  [aux_sym_int_literal_token2] = aux_sym_int_literal_token2,
  [aux_sym_int_literal_token3] = aux_sym_int_literal_token3,
  [sym_doc_comment] = sym_doc_comment,
  [sym_line_comment] = sym_line_comment,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [aux_sym_block_comment_token1] = aux_sym_block_comment_token1,
  [anon_sym_STAR_SLASH] = anon_sym_STAR_SLASH,
  [sym_source_file] = sym_source_file,
  [sym_attribute] = sym_attribute,
  [sym__item] = sym__item,
  [sym_unit_definition] = sym_unit_definition,
  [sym_unit_declaration] = sym_unit_declaration,
  [sym__unit_head] = sym__unit_head,
  [sym__pipeline_start] = sym__pipeline_start,
  [sym_where_clause] = sym_where_clause,
  [sym_struct_definition] = sym_struct_definition,
  [sym_enum_definition] = sym_enum_definition,
  [sym_impl] = sym_impl,
  [sym_trait] = sym_trait,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_member] = sym_enum_member,
  [sym_use] = sym_use,
  [sym_mod] = sym_mod,
  [sym_comptime_config] = sym_comptime_config,
  [sym__body_or_builtin] = sym__body_or_builtin,
  [sym_block] = sym_block,
  [sym__statement] = sym__statement,
  [sym_let_binding] = sym_let_binding,
  [sym_reg_statement] = sym_reg_statement,
  [sym_set_statement] = sym_set_statement,
  [sym_decl_statement] = sym_decl_statement,
  [sym_pipeline_reg_marker] = sym_pipeline_reg_marker,
  [sym_pipeline_stage_name] = sym_pipeline_stage_name,
  [sym__comptime_operator] = sym__comptime_operator,
  [sym_comptime_if] = sym_comptime_if,
  [sym_comptime_else] = sym_comptime_else,
  [sym_assert_statement] = sym_assert_statement,
  [sym_reg_reset] = sym_reg_reset,
  [sym_reg_initial] = sym_reg_initial,
  [sym__expression] = sym__expression,
  [sym_op_add] = sym_op_add,
  [sym_op_sub] = sym_op_sub,
  [sym_op_mul] = sym_op_mul,
  [sym_op_lt] = sym_op_lt,
  [sym_op_gt] = sym_op_gt,
  [sym_op_bitwise_and] = sym_op_bitwise_and,
  [sym__op_mul_like] = sym__op_mul_like,
  [sym__op_add_like] = sym__op_add_like,
  [sym__op_relational] = sym__op_relational,
  [sym__op_eq_like] = sym__op_eq_like,
  [sym__op_shifty] = sym__op_shifty,
  [sym_op_custom_infix] = sym_op_custom_infix,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_if_expression] = sym_if_expression,
  [sym_gen_if_expression] = sym_gen_if_expression,
  [sym_naked_gen_if_expression] = sym_naked_gen_if_expression,
  [sym_match_expression] = sym_match_expression,
  [sym_match_block] = sym_match_block,
  [sym_match_arm] = sym_match_arm,
  [sym_last_match_arm] = sym_match_arm,
  [sym__base_expression] = sym__base_expression,
  [sym__simple_base_expression] = sym__simple_base_expression,
  [sym_field_access] = sym_field_access,
  [sym_method_call] = sym_method_call,
  [sym_index] = sym_index,
  [sym_array_literal] = sym_array_literal,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_paren_expression] = sym_paren_expression,
  [sym_function_call] = sym_function_call,
  [sym_entity_instance] = sym_entity_instance,
  [sym_pipeline_instance] = sym_pipeline_instance,
  [sym_turbofish] = sym_turbofish,
  [sym_named_turbofish_arg] = sym_named_turbofish_arg,
  [sym_stage_reference] = sym_stage_reference,
  [sym_bool_literal] = sym_bool_literal,
  [sym_builtin_marker] = sym_builtin_marker,
  [sym_argument_list] = sym_argument_list,
  [sym__named_argument_list] = sym__named_argument_list,
  [sym__named_argument] = sym__named_argument,
  [sym__positional_argument_list] = sym__positional_argument_list,
  [sym_parameter_list] = sym_parameter_list,
  [sym_braced_parameter_list] = sym_braced_parameter_list,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_parameter] = sym_parameter,
  [sym__pattern] = sym__pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_named_unpack] = sym_named_unpack,
  [sym_positional_unpack] = sym_positional_unpack,
  [sym__named_pattern_list] = sym__named_pattern_list,
  [sym__positional_pattern_list] = sym__positional_pattern_list,
  [sym_named_pattern_param] = sym_named_pattern_param,
  [sym_type] = sym_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_array_type] = sym_array_type,
  [sym_wire] = sym_wire,
  [sym_inverted] = sym_inverted,
  [sym__generic_list] = sym__generic_list,
  [sym_generic_parameters] = sym_generic_parameters,
  [sym_generic_param] = sym_generic_param,
  [sym__base_type] = sym__base_type,
  [sym_builtin_type] = sym_builtin_type,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym__path] = sym__path,
  [sym__scoped_or_raw_ident] = sym__scoped_or_raw_ident,
  [sym_int_literal] = sym_int_literal,
  [sym_block_comment] = sym_block_comment,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym__item_repeat1] = aux_sym__item_repeat1,
  [aux_sym_where_clause_repeat1] = aux_sym_where_clause_repeat1,
  [aux_sym_impl_repeat1] = aux_sym_impl_repeat1,
  [aux_sym_trait_repeat1] = aux_sym_trait_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_reg_statement_repeat1] = aux_sym_reg_statement_repeat1,
  [aux_sym_decl_statement_repeat1] = aux_sym_decl_statement_repeat1,
  [aux_sym_match_block_repeat1] = aux_sym_match_block_repeat1,
  [aux_sym_array_literal_repeat1] = aux_sym_array_literal_repeat1,
  [aux_sym_turbofish_repeat1] = aux_sym_turbofish_repeat1,
  [aux_sym_turbofish_repeat2] = aux_sym_turbofish_repeat2,
  [aux_sym__named_argument_list_repeat1] = aux_sym__named_argument_list_repeat1,
  [aux_sym__positional_argument_list_repeat1] = aux_sym__positional_argument_list_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [aux_sym__named_pattern_list_repeat1] = aux_sym__named_pattern_list_repeat1,
  [aux_sym_generic_parameters_repeat1] = aux_sym_generic_parameters_repeat1,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_entity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pipeline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_port] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_impl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARconfig] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARelse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_initial] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_op_div] = {
    .visible = true,
    .named = true,
  },
  [sym_op_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_op_equals] = {
    .visible = true,
    .named = true,
  },
  [sym_op_ne] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_op_le] = {
    .visible = true,
    .named = true,
  },
  [sym_op_ge] = {
    .visible = true,
    .named = true,
  },
  [sym_op_lshift] = {
    .visible = true,
    .named = true,
  },
  [sym_op_rshift] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_op_bitwise_xor] = {
    .visible = true,
    .named = true,
  },
  [sym_op_bitwise_or] = {
    .visible = true,
    .named = true,
  },
  [sym_op_logical_and] = {
    .visible = true,
    .named = true,
  },
  [sym_op_logical_or] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gen] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_DOLLAR_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___builtin__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_self] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_inv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_clock] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_int_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_int_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_int_literal_token3] = {
    .visible = false,
    .named = false,
  },
  [sym_doc_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_block_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_STAR_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_unit_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__unit_head] = {
    .visible = false,
    .named = true,
  },
  [sym__pipeline_start] = {
    .visible = false,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_impl] = {
    .visible = true,
    .named = true,
  },
  [sym_trait] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_member] = {
    .visible = true,
    .named = true,
  },
  [sym_use] = {
    .visible = true,
    .named = true,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_comptime_config] = {
    .visible = true,
    .named = true,
  },
  [sym__body_or_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_let_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_reg_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_decl_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline_reg_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline_stage_name] = {
    .visible = true,
    .named = true,
  },
  [sym__comptime_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_comptime_if] = {
    .visible = true,
    .named = true,
  },
  [sym_comptime_else] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_reg_reset] = {
    .visible = true,
    .named = true,
  },
  [sym_reg_initial] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_op_add] = {
    .visible = true,
    .named = true,
  },
  [sym_op_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_op_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_op_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_op_gt] = {
    .visible = true,
    .named = true,
  },
  [sym_op_bitwise_and] = {
    .visible = true,
    .named = true,
  },
  [sym__op_mul_like] = {
    .visible = false,
    .named = true,
  },
  [sym__op_add_like] = {
    .visible = false,
    .named = true,
  },
  [sym__op_relational] = {
    .visible = false,
    .named = true,
  },
  [sym__op_eq_like] = {
    .visible = false,
    .named = true,
  },
  [sym__op_shifty] = {
    .visible = false,
    .named = true,
  },
  [sym_op_custom_infix] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gen_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_naked_gen_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_match_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_last_match_arm] = {
    .visible = true,
    .named = true,
  },
  [sym__base_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_base_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_call] = {
    .visible = true,
    .named = true,
  },
  [sym_index] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_turbofish] = {
    .visible = true,
    .named = true,
  },
  [sym_named_turbofish_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_stage_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym__named_argument_list] = {
    .visible = false,
    .named = true,
  },
  [sym__named_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__positional_argument_list] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_named_unpack] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_unpack] = {
    .visible = true,
    .named = true,
  },
  [sym__named_pattern_list] = {
    .visible = false,
    .named = true,
  },
  [sym__positional_pattern_list] = {
    .visible = false,
    .named = true,
  },
  [sym_named_pattern_param] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_wire] = {
    .visible = true,
    .named = true,
  },
  [sym_inverted] = {
    .visible = true,
    .named = true,
  },
  [sym__generic_list] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_param] = {
    .visible = true,
    .named = true,
  },
  [sym__base_type] = {
    .visible = false,
    .named = true,
  },
  [sym_builtin_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__path] = {
    .visible = false,
    .named = true,
  },
  [sym__scoped_or_raw_ident] = {
    .visible = false,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_where_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_impl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trait_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_reg_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decl_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_turbofish_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_turbofish_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__named_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__positional_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__named_pattern_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_base = 1,
  field_for = 2,
  field_meta = 3,
  field_name = 4,
  field_path = 5,
  field_pattern = 6,
  field_stage = 7,
  field_value = 8,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_base] = "base",
  [field_for] = "for",
  [field_meta] = "meta",
  [field_name] = "name",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_stage] = "stage",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 3},
  [8] = {.index = 14, .length = 1},
  [9] = {.index = 15, .length = 2},
  [10] = {.index = 17, .length = 3},
  [11] = {.index = 20, .length = 2},
  [12] = {.index = 22, .length = 2},
  [13] = {.index = 24, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_name, 2},
    {field_path, 0},
  [3] =
    {field_meta, 0},
    {field_meta, 1},
  [5] =
    {field_for, 2},
    {field_for, 3},
  [7] =
    {field_base, 0},
    {field_name, 2},
  [9] =
    {field_for, 3},
    {field_for, 4},
  [11] =
    {field_for, 2},
    {field_for, 3},
    {field_for, 4},
  [14] =
    {field_stage, 2},
  [15] =
    {field_base, 0},
    {field_name, 3},
  [17] =
    {field_for, 3},
    {field_for, 4},
    {field_for, 5},
  [20] =
    {field_for, 4},
    {field_for, 5},
  [22] =
    {field_pattern, 0},
    {field_value, 2},
  [24] =
    {field_for, 4},
    {field_for, 5},
    {field_for, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 28,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 95,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 163,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 164,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 166,
  [188] = 186,
  [189] = 168,
  [190] = 169,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 191,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 192,
  [208] = 208,
  [209] = 208,
  [210] = 210,
  [211] = 199,
  [212] = 204,
  [213] = 191,
  [214] = 204,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 68,
  [222] = 222,
  [223] = 223,
  [224] = 218,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 223,
  [229] = 217,
  [230] = 216,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 108,
  [299] = 107,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 304,
  [322] = 322,
  [323] = 323,
  [324] = 152,
  [325] = 150,
  [326] = 155,
  [327] = 151,
  [328] = 328,
  [329] = 153,
  [330] = 149,
  [331] = 154,
  [332] = 156,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 72,
  [355] = 71,
  [356] = 356,
  [357] = 73,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 29,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 258,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 416,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 427,
  [441] = 435,
  [442] = 442,
  [443] = 443,
  [444] = 439,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 236,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 491,
  [515] = 496,
  [516] = 516,
  [517] = 517,
  [518] = 517,
  [519] = 468,
  [520] = 472,
  [521] = 521,
  [522] = 466,
  [523] = 467,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 295,
  [538] = 255,
  [539] = 256,
  [540] = 540,
  [541] = 541,
  [542] = 424,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 442,
  [547] = 547,
  [548] = 548,
  [549] = 412,
  [550] = 431,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 296,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 281,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 285,
  [584] = 286,
  [585] = 288,
  [586] = 291,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 284,
  [593] = 292,
  [594] = 290,
  [595] = 595,
  [596] = 287,
  [597] = 289,
  [598] = 598,
  [599] = 282,
  [600] = 283,
  [601] = 601,
  [602] = 294,
  [603] = 293,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 587,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 619,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 628,
  [634] = 634,
  [635] = 635,
  [636] = 611,
  [637] = 637,
  [638] = 638,
  [639] = 577,
  [640] = 635,
  [641] = 641,
  [642] = 618,
  [643] = 588,
  [644] = 570,
  [645] = 564,
  [646] = 591,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 648,
  [651] = 571,
  [652] = 652,
  [653] = 653,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(147);
      ADVANCE_MAP(
        '!', 220,
        '#', 148,
        '$', 13,
        '%', 199,
        '&', 213,
        '\'', 188,
        '(', 156,
        ')', 157,
        '*', 187,
        '+', 195,
        ',', 163,
        '-', 197,
        '.', 230,
        '/', 198,
        '0', 318,
        ':', 160,
        ';', 151,
        '<', 203,
        '=', 178,
        '>', 207,
        '[', 149,
        ']', 150,
        '^', 214,
        '_', 26,
        '`', 218,
        'a', 123,
        'b', 106,
        'c', 87,
        'd', 42,
        'e', 90,
        'f', 34,
        'g', 43,
        'i', 61,
        'l', 44,
        'm', 30,
        'p', 72,
        'r', 45,
        's', 46,
        't', 110,
        'u', 117,
        'w', 69,
        '{', 170,
        '|', 215,
        '}', 171,
        '~', 221,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 219,
        '$', 55,
        '&', 212,
        '\'', 188,
        '(', 156,
        ')', 17,
        '*', 187,
        '-', 196,
        '/', 15,
        '0', 318,
        ':', 21,
        '<', 204,
        '=', 24,
        '>', 206,
        '[', 149,
        'a', 302,
        'd', 265,
        'f', 258,
        'g', 266,
        'i', 276,
        'l', 267,
        'm', 259,
        'r', 268,
        's', 269,
        't', 299,
        '{', 170,
        '}', 171,
        '~', 221,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 219,
        '&', 212,
        '(', 156,
        ')', 157,
        '*', 187,
        ',', 163,
        '-', 196,
        '/', 15,
        '0', 318,
        ':', 21,
        '=', 176,
        '>', 205,
        '[', 149,
        ']', 150,
        'f', 258,
        'g', 266,
        'i', 276,
        'm', 259,
        's', 274,
        't', 299,
        '{', 170,
        '~', 221,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 23,
        '$', 11,
        '%', 199,
        '&', 213,
        '(', 156,
        ')', 157,
        '*', 187,
        '+', 195,
        ',', 163,
        '-', 196,
        '.', 230,
        '/', 198,
        ':', 160,
        ';', 151,
        '<', 203,
        '=', 178,
        '>', 207,
        '[', 149,
        ']', 150,
        '^', 214,
        '_', 26,
        '`', 218,
        'f', 103,
        '{', 170,
        '|', 215,
        '}', 171,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 23,
        '$', 11,
        '%', 199,
        '&', 213,
        '(', 156,
        ')', 157,
        '*', 187,
        '+', 195,
        ',', 163,
        '-', 196,
        '.', 230,
        '/', 198,
        ':', 162,
        ';', 151,
        '<', 203,
        '=', 177,
        '>', 207,
        '[', 149,
        ']', 150,
        '^', 214,
        '_', 26,
        '`', 218,
        '{', 170,
        '|', 215,
        '}', 171,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '#', 148,
        '$', 11,
        '(', 156,
        ')', 157,
        '+', 195,
        ',', 163,
        '-', 196,
        '/', 15,
        ':', 20,
        ';', 151,
        '<', 202,
        '>', 205,
        '{', 170,
        '}', 171,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(148);
      if (lookahead == ')') ADVANCE(157);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == 's') ADVANCE(275);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 7:
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '<') ADVANCE(233);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '$', 11,
        '(', 156,
        ')', 157,
        ',', 163,
        '-', 25,
        '/', 15,
        ':', 161,
        ';', 151,
        '<', 202,
        '=', 176,
        '>', 205,
        ']', 150,
        '_', 26,
        'i', 101,
        'r', 60,
        'w', 69,
        '{', 170,
        '}', 171,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '&', 212,
        '(', 156,
        ')', 157,
        ',', 163,
        '/', 15,
        '0', 318,
        ':', 159,
        '>', 205,
        '[', 149,
        'b', 295,
        'c', 288,
        'i', 292,
        '{', 170,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '(', 156,
        ')', 157,
        '/', 15,
        '0', 318,
        ':', 21,
        'f', 258,
        't', 299,
        '}', 171,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(244);
      END_STATE();
    case 12:
      if (lookahead == '(') ADVANCE(244);
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 13:
      if (lookahead == '(') ADVANCE(244);
      if (lookahead == 'c') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(91);
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        ')', 17,
        ',', 163,
        '/', 15,
        ';', 151,
        '<', 202,
        '>', 205,
        '_', 255,
        '{', 170,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(328);
      if (lookahead == '/') ADVANCE(326);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(332);
      if (lookahead == '/') ADVANCE(330);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(331);
      if (lookahead != 0) ADVANCE(329);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(237);
      END_STATE();
    case 18:
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == 'i') ADVANCE(294);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 19:
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == 'p') ADVANCE(298);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(315);
      END_STATE();
    case 20:
      if (lookahead == ':') ADVANCE(317);
      END_STATE();
    case 21:
      if (lookahead == ':') ADVANCE(316);
      END_STATE();
    case 22:
      if (lookahead == '<') ADVANCE(234);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(201);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(200);
      if (lookahead == '>') ADVANCE(229);
      END_STATE();
    case 25:
      if (lookahead == '>') ADVANCE(154);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(35);
      END_STATE();
    case 27:
      if (lookahead == '_') ADVANCE(242);
      END_STATE();
    case 28:
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(85);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(80);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(92);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == 'o') ADVANCE(111);
      END_STATE();
    case 35:
      if (lookahead == 'b') ADVANCE(137);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(81);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(68);
      END_STATE();
    case 39:
      if (lookahead == 'c') ADVANCE(83);
      END_STATE();
    case 40:
      if (lookahead == 'c') ADVANCE(132);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(174);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(86);
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(238);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(91);
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 61:
      if (lookahead == 'f') ADVANCE(222);
      if (lookahead == 'm') ADVANCE(108);
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 62:
      if (lookahead == 'f') ADVANCE(189);
      END_STATE();
    case 63:
      if (lookahead == 'f') ADVANCE(245);
      END_STATE();
    case 64:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 65:
      if (lookahead == 'g') ADVANCE(181);
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 66:
      if (lookahead == 'g') ADVANCE(175);
      END_STATE();
    case 67:
      if (lookahead == 'g') ADVANCE(52);
      END_STATE();
    case 68:
      if (lookahead == 'h') ADVANCE(227);
      END_STATE();
    case 69:
      if (lookahead == 'h') ADVANCE(56);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(109);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 'o') ADVANCE(114);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 's') ADVANCE(126);
      if (lookahead == 't') ADVANCE(249);
      if (lookahead == 'v') ADVANCE(247);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 78:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 79:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 80:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 81:
      if (lookahead == 'k') ADVANCE(253);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(251);
      END_STATE();
    case 83:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(194);
      END_STATE();
    case 86:
      if (lookahead == 'l') ADVANCE(63);
      if (lookahead == 't') ADVANCE(183);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(104);
      END_STATE();
    case 88:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(136);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(119);
      if (lookahead == 'n') ADVANCE(124);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(121);
      END_STATE();
    case 92:
      if (lookahead == 'l') ADVANCE(122);
      END_STATE();
    case 93:
      if (lookahead == 'm') ADVANCE(108);
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 94:
      if (lookahead == 'm') ADVANCE(167);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(124);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 97:
      if (lookahead == 'n') ADVANCE(225);
      END_STATE();
    case 98:
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 99:
      if (lookahead == 'n') ADVANCE(64);
      END_STATE();
    case 100:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 101:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 102:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 103:
      if (lookahead == 'o') ADVANCE(111);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 105:
      if (lookahead == 'o') ADVANCE(99);
      END_STATE();
    case 106:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 108:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 109:
      if (lookahead == 'p') ADVANCE(57);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 112:
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 115:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 117:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 119:
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 120:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 122:
      if (lookahead == 's') ADVANCE(51);
      END_STATE();
    case 123:
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(78);
      if (lookahead == 'u') ADVANCE(94);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(179);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(193);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 134:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 137:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 138:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 139:
      if (lookahead == 'y') ADVANCE(153);
      END_STATE();
    case 140:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(323);
      END_STATE();
    case 141:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(320);
      END_STATE();
    case 142:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(324);
      END_STATE();
    case 143:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(322);
      END_STATE();
    case 144:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(321);
      END_STATE();
    case 145:
      if (eof) ADVANCE(147);
      ADVANCE_MAP(
        '!', 23,
        '#', 148,
        '$', 12,
        '%', 199,
        '&', 213,
        '(', 156,
        ')', 157,
        '*', 187,
        '+', 195,
        ',', 163,
        '-', 196,
        '.', 230,
        '/', 198,
        ':', 159,
        ';', 151,
        '<', 203,
        '=', 178,
        '>', 207,
        '[', 149,
        ']', 150,
        '^', 214,
        '_', 26,
        '`', 218,
        'e', 95,
        'f', 96,
        'i', 93,
        'm', 102,
        'p', 71,
        'r', 60,
        's', 135,
        't', 113,
        'u', 117,
        'w', 69,
        '{', 170,
        '|', 215,
        '}', 171,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(145);
      END_STATE();
    case 146:
      if (eof) ADVANCE(147);
      ADVANCE_MAP(
        '!', 23,
        '#', 148,
        '$', 37,
        '%', 199,
        '&', 213,
        ')', 157,
        '*', 187,
        '+', 195,
        ',', 163,
        '-', 196,
        '.', 230,
        '/', 198,
        ':', 159,
        ';', 151,
        '<', 203,
        '=', 177,
        '>', 207,
        '[', 149,
        ']', 150,
        '^', 214,
        '_', 26,
        '`', 218,
        'e', 90,
        'f', 96,
        'i', 93,
        'm', 102,
        'p', 71,
        'r', 60,
        's', 135,
        't', 113,
        'u', 117,
        '{', 170,
        '|', 215,
        '}', 171,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_entity);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_pipeline);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(317);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(316);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(7);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_port);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_port);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_impl);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_trait);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_mod);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DOLLARconfig);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(200);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(200);
      if (lookahead == '>') ADVANCE(229);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_let);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_reg);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_reg);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_set);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_decl);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_decl);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_DOLLARif);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DOLLARelse);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_assert);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_reset);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_initial);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(154);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_op_div);
      if (lookahead == '*') ADVANCE(328);
      if (lookahead == '/') ADVANCE(326);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_op_mod);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_op_equals);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_op_ne);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(210);
      if (lookahead == '=') ADVANCE(208);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(208);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(209);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(209);
      if (lookahead == '>') ADVANCE(211);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_op_le);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_op_ge);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_op_lshift);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_op_rshift);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(216);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_op_bitwise_xor);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_op_bitwise_or);
      if (lookahead == '|') ADVANCE(217);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_op_logical_and);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_op_logical_or);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(201);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_if);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_gen);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_gen);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_match);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_inst);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_inst);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_LT);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_DOLLAR_LT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_stage);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_stage);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_RPAREN_DOT);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_true);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_false);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym___builtin__);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym___builtin__);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_self);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_self);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_inv);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_inv);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_int);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_bool);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_clock);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_clock);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(261);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(243);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(256);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(290);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(311);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(279);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(313);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(280);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(283);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(286);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(264);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(291);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(306);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(278);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(284);
      if (lookahead == 't') ADVANCE(260);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(239);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(241);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(236);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(300);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(285);
      if (lookahead == 't') ADVANCE(260);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(285);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(223);
      if (lookahead == 'n') ADVANCE(303);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(246);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(182);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(272);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(228);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(293);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(289);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(254);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(277);
      if (lookahead == 't') ADVANCE(184);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(277);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(186);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(252);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(296);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(312);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(305);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(226);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(309);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(257);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(303);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(297);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(263);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(287);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(301);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(314);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(308);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(310);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(304);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(307);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(273);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(271);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(180);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(232);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(192);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(250);
      if (lookahead == 'v') ADVANCE(248);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(166);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(262);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(281);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(282);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(270);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(315);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '<') ADVANCE(233);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(aux_sym_int_literal_token1);
      if (lookahead == 'b') ADVANCE(140);
      if (lookahead == 'x') ADVANCE(144);
      if (lookahead == 'i' ||
          lookahead == 'u') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(319);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym_int_literal_token1);
      if (lookahead == 'i' ||
          lookahead == 'u') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(319);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym_int_literal_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(320);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(aux_sym_int_literal_token2);
      if (lookahead == 'i' ||
          lookahead == 'u') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(321);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(aux_sym_int_literal_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(aux_sym_int_literal_token3);
      if (lookahead == 'i' ||
          lookahead == 'u') ADVANCE(142);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(323);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(aux_sym_int_literal_token3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(324);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_doc_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(325);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '/') ADVANCE(325);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(327);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(327);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(aux_sym_block_comment_token1);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(aux_sym_block_comment_token1);
      if (lookahead == '*') ADVANCE(328);
      if (lookahead == '/') ADVANCE(326);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(aux_sym_block_comment_token1);
      if (lookahead == '*') ADVANCE(332);
      if (lookahead == '/') ADVANCE(330);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(331);
      if (lookahead != 0) ADVANCE(329);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(aux_sym_block_comment_token1);
      if (lookahead == '/') ADVANCE(333);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_STAR_SLASH);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 2},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 2},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 2},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 145},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 2},
  [50] = {.lex_state = 2},
  [51] = {.lex_state = 2},
  [52] = {.lex_state = 2},
  [53] = {.lex_state = 146},
  [54] = {.lex_state = 146},
  [55] = {.lex_state = 146},
  [56] = {.lex_state = 146},
  [57] = {.lex_state = 146},
  [58] = {.lex_state = 146},
  [59] = {.lex_state = 146},
  [60] = {.lex_state = 146},
  [61] = {.lex_state = 146},
  [62] = {.lex_state = 146},
  [63] = {.lex_state = 146},
  [64] = {.lex_state = 146},
  [65] = {.lex_state = 146},
  [66] = {.lex_state = 146},
  [67] = {.lex_state = 146},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 4},
  [70] = {.lex_state = 4},
  [71] = {.lex_state = 3},
  [72] = {.lex_state = 3},
  [73] = {.lex_state = 3},
  [74] = {.lex_state = 145},
  [75] = {.lex_state = 145},
  [76] = {.lex_state = 145},
  [77] = {.lex_state = 145},
  [78] = {.lex_state = 145},
  [79] = {.lex_state = 145},
  [80] = {.lex_state = 145},
  [81] = {.lex_state = 145},
  [82] = {.lex_state = 145},
  [83] = {.lex_state = 145},
  [84] = {.lex_state = 145},
  [85] = {.lex_state = 145},
  [86] = {.lex_state = 145},
  [87] = {.lex_state = 145},
  [88] = {.lex_state = 145},
  [89] = {.lex_state = 146},
  [90] = {.lex_state = 145},
  [91] = {.lex_state = 145},
  [92] = {.lex_state = 145},
  [93] = {.lex_state = 145},
  [94] = {.lex_state = 145},
  [95] = {.lex_state = 145},
  [96] = {.lex_state = 145},
  [97] = {.lex_state = 145},
  [98] = {.lex_state = 145},
  [99] = {.lex_state = 145},
  [100] = {.lex_state = 145},
  [101] = {.lex_state = 145},
  [102] = {.lex_state = 145},
  [103] = {.lex_state = 145},
  [104] = {.lex_state = 145},
  [105] = {.lex_state = 145},
  [106] = {.lex_state = 145},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 146},
  [110] = {.lex_state = 146},
  [111] = {.lex_state = 146},
  [112] = {.lex_state = 146},
  [113] = {.lex_state = 146},
  [114] = {.lex_state = 146},
  [115] = {.lex_state = 146},
  [116] = {.lex_state = 146},
  [117] = {.lex_state = 146},
  [118] = {.lex_state = 146},
  [119] = {.lex_state = 146},
  [120] = {.lex_state = 146},
  [121] = {.lex_state = 146},
  [122] = {.lex_state = 146},
  [123] = {.lex_state = 146},
  [124] = {.lex_state = 146},
  [125] = {.lex_state = 146},
  [126] = {.lex_state = 146},
  [127] = {.lex_state = 146},
  [128] = {.lex_state = 146},
  [129] = {.lex_state = 146},
  [130] = {.lex_state = 146},
  [131] = {.lex_state = 146},
  [132] = {.lex_state = 146},
  [133] = {.lex_state = 146},
  [134] = {.lex_state = 146},
  [135] = {.lex_state = 146},
  [136] = {.lex_state = 146},
  [137] = {.lex_state = 146},
  [138] = {.lex_state = 146},
  [139] = {.lex_state = 146},
  [140] = {.lex_state = 146},
  [141] = {.lex_state = 146},
  [142] = {.lex_state = 146},
  [143] = {.lex_state = 146},
  [144] = {.lex_state = 146},
  [145] = {.lex_state = 146},
  [146] = {.lex_state = 146},
  [147] = {.lex_state = 146},
  [148] = {.lex_state = 146},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 146},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 9},
  [164] = {.lex_state = 9},
  [165] = {.lex_state = 10},
  [166] = {.lex_state = 9},
  [167] = {.lex_state = 9},
  [168] = {.lex_state = 9},
  [169] = {.lex_state = 9},
  [170] = {.lex_state = 2},
  [171] = {.lex_state = 9},
  [172] = {.lex_state = 9},
  [173] = {.lex_state = 9},
  [174] = {.lex_state = 2},
  [175] = {.lex_state = 2},
  [176] = {.lex_state = 2},
  [177] = {.lex_state = 2},
  [178] = {.lex_state = 2},
  [179] = {.lex_state = 2},
  [180] = {.lex_state = 2},
  [181] = {.lex_state = 2},
  [182] = {.lex_state = 2},
  [183] = {.lex_state = 2},
  [184] = {.lex_state = 9},
  [185] = {.lex_state = 2},
  [186] = {.lex_state = 9},
  [187] = {.lex_state = 9},
  [188] = {.lex_state = 9},
  [189] = {.lex_state = 9},
  [190] = {.lex_state = 9},
  [191] = {.lex_state = 9},
  [192] = {.lex_state = 9},
  [193] = {.lex_state = 9},
  [194] = {.lex_state = 9},
  [195] = {.lex_state = 9},
  [196] = {.lex_state = 9},
  [197] = {.lex_state = 9},
  [198] = {.lex_state = 10},
  [199] = {.lex_state = 9},
  [200] = {.lex_state = 9},
  [201] = {.lex_state = 9},
  [202] = {.lex_state = 9},
  [203] = {.lex_state = 9},
  [204] = {.lex_state = 9},
  [205] = {.lex_state = 9},
  [206] = {.lex_state = 9},
  [207] = {.lex_state = 9},
  [208] = {.lex_state = 9},
  [209] = {.lex_state = 9},
  [210] = {.lex_state = 9},
  [211] = {.lex_state = 9},
  [212] = {.lex_state = 9},
  [213] = {.lex_state = 9},
  [214] = {.lex_state = 9},
  [215] = {.lex_state = 10},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 10},
  [220] = {.lex_state = 10},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 10},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 10},
  [226] = {.lex_state = 10},
  [227] = {.lex_state = 10},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 10},
  [232] = {.lex_state = 10},
  [233] = {.lex_state = 10},
  [234] = {.lex_state = 10},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 8},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 8},
  [256] = {.lex_state = 8},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 8},
  [282] = {.lex_state = 8},
  [283] = {.lex_state = 8},
  [284] = {.lex_state = 8},
  [285] = {.lex_state = 8},
  [286] = {.lex_state = 8},
  [287] = {.lex_state = 8},
  [288] = {.lex_state = 8},
  [289] = {.lex_state = 8},
  [290] = {.lex_state = 8},
  [291] = {.lex_state = 8},
  [292] = {.lex_state = 8},
  [293] = {.lex_state = 8},
  [294] = {.lex_state = 8},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 145},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 10},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 6},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 5},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 10},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 10},
  [323] = {.lex_state = 5},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 145},
  [343] = {.lex_state = 145},
  [344] = {.lex_state = 145},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 146},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 145},
  [349] = {.lex_state = 145},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 8},
  [355] = {.lex_state = 8},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 8},
  [358] = {.lex_state = 145},
  [359] = {.lex_state = 145},
  [360] = {.lex_state = 145},
  [361] = {.lex_state = 145},
  [362] = {.lex_state = 145},
  [363] = {.lex_state = 145},
  [364] = {.lex_state = 145},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 145},
  [367] = {.lex_state = 145},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 145},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 146},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 146},
  [374] = {.lex_state = 8},
  [375] = {.lex_state = 146},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 146},
  [378] = {.lex_state = 8},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 8},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 8},
  [388] = {.lex_state = 8},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 8},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 5},
  [401] = {.lex_state = 8},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 8},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 5},
  [406] = {.lex_state = 14},
  [407] = {.lex_state = 5},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 5},
  [413] = {.lex_state = 5},
  [414] = {.lex_state = 14},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 5},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 5},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 5},
  [422] = {.lex_state = 5},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 5},
  [425] = {.lex_state = 5},
  [426] = {.lex_state = 5},
  [427] = {.lex_state = 5},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 5},
  [430] = {.lex_state = 5},
  [431] = {.lex_state = 5},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 5},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 5},
  [440] = {.lex_state = 5},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 5},
  [443] = {.lex_state = 5},
  [444] = {.lex_state = 5},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 2},
  [448] = {.lex_state = 9},
  [449] = {.lex_state = 2},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 145},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 5},
  [461] = {.lex_state = 2},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 2},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 2},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 5},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 5},
  [472] = {.lex_state = 2},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 146},
  [476] = {.lex_state = 5},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 5},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 2},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 5},
  [485] = {.lex_state = 145},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 145},
  [488] = {.lex_state = 5},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 2},
  [492] = {.lex_state = 16},
  [493] = {.lex_state = 5},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 2},
  [500] = {.lex_state = 5},
  [501] = {.lex_state = 146},
  [502] = {.lex_state = 2},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 16},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 146},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 2},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 2},
  [518] = {.lex_state = 2},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 2},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 2},
  [523] = {.lex_state = 2},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 5},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 16},
  [529] = {.lex_state = 16},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 146},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 5},
  [538] = {.lex_state = 1},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 5},
  [541] = {.lex_state = 2},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 2},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 5},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 2},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 5},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 19},
  [555] = {.lex_state = 2},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 5},
  [558] = {.lex_state = 18},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 2},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 5},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 5},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 5},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 1},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 1},
  [577] = {.lex_state = 5},
  [578] = {.lex_state = 145},
  [579] = {.lex_state = 1},
  [580] = {.lex_state = 1},
  [581] = {.lex_state = 5},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 1},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 1},
  [586] = {.lex_state = 1},
  [587] = {.lex_state = 5},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 5},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 5},
  [596] = {.lex_state = 1},
  [597] = {.lex_state = 1},
  [598] = {.lex_state = 5},
  [599] = {.lex_state = 1},
  [600] = {.lex_state = 1},
  [601] = {.lex_state = 5},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 1},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 145},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 5},
  [612] = {.lex_state = 5},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 5},
  [615] = {.lex_state = 5},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 5},
  [618] = {.lex_state = 5},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 145},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 2},
  [624] = {.lex_state = 5},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 5},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 145},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 5},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 5},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 5},
  [637] = {.lex_state = 2},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 5},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 5},
  [642] = {.lex_state = 5},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 5},
  [649] = {.lex_state = 5},
  [650] = {.lex_state = 5},
  [651] = {.lex_state = 0},
  [652] = {(TSStateId)(-1)},
  [653] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_entity] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_pipeline] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_port] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_impl] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_trait] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_DOLLARconfig] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_reg] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_decl] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLARif] = ACTIONS(1),
    [anon_sym_DOLLARelse] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_reset] = ACTIONS(1),
    [anon_sym_initial] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_op_div] = ACTIONS(1),
    [sym_op_mod] = ACTIONS(1),
    [sym_op_equals] = ACTIONS(1),
    [sym_op_ne] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym_op_le] = ACTIONS(1),
    [sym_op_ge] = ACTIONS(1),
    [sym_op_lshift] = ACTIONS(1),
    [sym_op_rshift] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [sym_op_bitwise_xor] = ACTIONS(1),
    [sym_op_bitwise_or] = ACTIONS(1),
    [sym_op_logical_and] = ACTIONS(1),
    [sym_op_logical_or] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_gen] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_inst] = ACTIONS(1),
    [anon_sym_COLON_COLON_LT] = ACTIONS(1),
    [anon_sym_COLON_COLON_DOLLAR_LT] = ACTIONS(1),
    [anon_sym_stage] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym___builtin__] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [sym_self] = ACTIONS(1),
    [anon_sym_inv] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_clock] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [aux_sym_int_literal_token1] = ACTIONS(1),
    [aux_sym_int_literal_token2] = ACTIONS(1),
    [aux_sym_int_literal_token3] = ACTIONS(1),
    [sym_doc_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_SLASH_STAR] = ACTIONS(7),
  },
  [1] = {
    [sym_source_file] = STATE(606),
    [sym_attribute] = STATE(295),
    [sym__item] = STATE(273),
    [sym_unit_definition] = STATE(249),
    [sym__unit_head] = STATE(386),
    [sym__pipeline_start] = STATE(598),
    [sym_struct_definition] = STATE(249),
    [sym_enum_definition] = STATE(249),
    [sym_impl] = STATE(249),
    [sym_trait] = STATE(249),
    [sym_use] = STATE(249),
    [sym_mod] = STATE(249),
    [sym_comptime_config] = STATE(249),
    [sym_block_comment] = STATE(1),
    [aux_sym_source_file_repeat1] = STATE(159),
    [aux_sym__item_repeat1] = STATE(162),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_POUND] = ACTIONS(11),
    [anon_sym_fn] = ACTIONS(13),
    [anon_sym_entity] = ACTIONS(13),
    [anon_sym_pipeline] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_enum] = ACTIONS(19),
    [anon_sym_impl] = ACTIONS(21),
    [anon_sym_trait] = ACTIONS(23),
    [anon_sym_use] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(27),
    [anon_sym_DOLLARconfig] = ACTIONS(29),
    [sym_doc_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_SLASH_STAR] = ACTIONS(7),
  },
  [2] = {
    [sym_block] = STATE(119),
    [sym__statement] = STATE(152),
    [sym_let_binding] = STATE(626),
    [sym_reg_statement] = STATE(626),
    [sym_set_statement] = STATE(626),
    [sym_decl_statement] = STATE(626),
    [sym_pipeline_reg_marker] = STATE(626),
    [sym_pipeline_stage_name] = STATE(150),
    [sym_comptime_if] = STATE(150),
    [sym_assert_statement] = STATE(626),
    [sym__expression] = STATE(98),
    [sym_op_sub] = STATE(35),
    [sym_binary_expression] = STATE(157),
    [sym_unary_expression] = STATE(157),
    [sym_if_expression] = STATE(119),
    [sym_gen_if_expression] = STATE(119),
    [sym_match_expression] = STATE(119),
    [sym__base_expression] = STATE(157),
    [sym__simple_base_expression] = STATE(142),
    [sym_field_access] = STATE(119),
    [sym_method_call] = STATE(119),
    [sym_index] = STATE(119),
    [sym_array_literal] = STATE(119),
    [sym_tuple_literal] = STATE(119),
    [sym_paren_expression] = STATE(119),
    [sym_function_call] = STATE(119),
    [sym_entity_instance] = STATE(119),
    [sym_pipeline_instance] = STATE(119),
    [sym_stage_reference] = STATE(119),
    [sym_bool_literal] = STATE(119),
    [sym_scoped_identifier] = STATE(72),
    [sym__path] = STATE(635),
    [sym__scoped_or_raw_ident] = STATE(69),
    [sym_int_literal] = STATE(119),
    [sym_block_comment] = STATE(2),
    [aux_sym_block_repeat1] = STATE(3),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_RBRACE] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_reg] = ACTIONS(41),
    [anon_sym_set] = ACTIONS(43),
    [anon_sym_decl] = ACTIONS(45),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DOLLARif] = ACTIONS(51),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(55),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_gen] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_inst] = ACTIONS(63),
    [anon_sym_stage] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(67),
    [anon_sym_false] = ACTIONS(67),
    [sym_self] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [aux_sym_int_literal_token1] = ACTIONS(75),
    [aux_sym_int_literal_token2] = ACTIONS(77),
    [aux_sym_int_literal_token3] = ACTIONS(77),
    [sym_doc_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_SLASH_STAR] = ACTIONS(7),
  },
  [3] = {
    [sym_block] = STATE(119),
    [sym__statement] = STATE(152),
    [sym_let_binding] = STATE(626),
    [sym_reg_statement] = STATE(626),
    [sym_set_statement] = STATE(626),
    [sym_decl_statement] = STATE(626),
    [sym_pipeline_reg_marker] = STATE(626),
    [sym_pipeline_stage_name] = STATE(150),
    [sym_comptime_if] = STATE(150),
    [sym_assert_statement] = STATE(626),
    [sym__expression] = STATE(92),
    [sym_op_sub] = STATE(35),
    [sym_binary_expression] = STATE(157),
    [sym_unary_expression] = STATE(157),
    [sym_if_expression] = STATE(119),
    [sym_gen_if_expression] = STATE(119),
    [sym_match_expression] = STATE(119),
    [sym__base_expression] = STATE(157),
    [sym__simple_base_expression] = STATE(142),
    [sym_field_access] = STATE(119),
    [sym_method_call] = STATE(119),
    [sym_index] = STATE(119),
    [sym_array_literal] = STATE(119),
    [sym_tuple_literal] = STATE(119),
    [sym_paren_expression] = STATE(119),
    [sym_function_call] = STATE(119),
    [sym_entity_instance] = STATE(119),
    [sym_pipeline_instance] = STATE(119),
    [sym_stage_reference] = STATE(119),
    [sym_bool_literal] = STATE(119),
    [sym_scoped_identifier] = STATE(72),
    [sym__path] = STATE(635),
    [sym__scoped_or_raw_ident] = STATE(69),
    [sym_int_literal] = STATE(119),
    [sym_block_comment] = STATE(3),
    [aux_sym_block_repeat1] = STATE(68),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_RBRACE] = ACTIONS(79),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_reg] = ACTIONS(41),
    [anon_sym_set] = ACTIONS(43),
    [anon_sym_decl] = ACTIONS(45),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DOLLARif] = ACTIONS(51),
    [anon_sym_assert] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(55),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_gen] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_inst] = ACTIONS(63),
    [anon_sym_stage] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(67),
    [anon_sym_false] = ACTIONS(67),
    [sym_self] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [aux_sym_int_literal_token1] = ACTIONS(75),
    [aux_sym_int_literal_token2] = ACTIONS(77),
    [aux_sym_int_literal_token3] = ACTIONS(77),
    [sym_doc_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_SLASH_STAR] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(4), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(76), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [110] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(79), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [220] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(76), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [330] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(87), 1,
      anon_sym_RPAREN,
    STATE(7), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(77), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [440] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(89), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(76), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [550] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(91), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(78), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [660] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    STATE(10), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(80), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [770] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(76), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [880] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    STATE(12), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(80), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [990] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(13), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(81), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1097] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(14), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(104), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1204] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(15), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(86), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1311] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(16), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(65), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1418] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(17), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(66), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1525] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(18), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(67), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1632] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(19), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(63), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1739] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(20), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(62), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1846] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(21), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(56), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [1953] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(22), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(57), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2060] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(23), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(58), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2167] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(24), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(59), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2274] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(25), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(60), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2381] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(26), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(61), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2488] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(27), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(93), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2595] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(28), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(95), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2702] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(29), 1,
      sym_block_comment,
    ACTIONS(101), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(99), 40,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
      anon_sym_STAR,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_EQ_GT,
      anon_sym_DOT,
      anon_sym___builtin__,
  [2765] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(30), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(90), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2872] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(31), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(91), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [2979] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(32), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(74), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3086] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(33), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(106), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3193] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(34), 1,
      sym_block_comment,
    STATE(35), 1,
      sym_op_sub,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(89), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3300] = 27,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(64), 1,
      sym__expression,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(35), 2,
      sym_op_sub,
      sym_block_comment,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3405] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(36), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(94), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3512] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(37), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(84), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3619] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(38), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(76), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3726] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(39), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(83), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3833] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(40), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(97), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [3940] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(41), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(87), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4047] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(42), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(85), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4154] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(43), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(96), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4261] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(44), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(88), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4368] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(45), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(80), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4475] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(46), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(99), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4582] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(47), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(100), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4689] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(48), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(101), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4796] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(49), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(102), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [4903] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(50), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(75), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [5010] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(51), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(103), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [5117] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_gen,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_inst,
    ACTIONS(65), 1,
      anon_sym_stage,
    ACTIONS(69), 1,
      sym_self,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(35), 1,
      sym_op_sub,
    STATE(52), 1,
      sym_block_comment,
    STATE(69), 1,
      sym__scoped_or_raw_ident,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(105), 1,
      sym__expression,
    STATE(142), 1,
      sym__simple_base_expression,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(157), 3,
      sym_binary_expression,
      sym_unary_expression,
      sym__base_expression,
    ACTIONS(47), 4,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(119), 16,
      sym_block,
      sym_if_expression,
      sym_gen_if_expression,
      sym_match_expression,
      sym_field_access,
      sym_method_call,
      sym_index,
      sym_array_literal,
      sym_tuple_literal,
      sym_paren_expression,
      sym_function_call,
      sym_entity_instance,
      sym_pipeline_instance,
      sym_stage_reference,
      sym_bool_literal,
      sym_int_literal,
  [5224] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(53), 1,
      sym_block_comment,
    ACTIONS(105), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(103), 37,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym___builtin__,
  [5284] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(54), 1,
      sym_block_comment,
    ACTIONS(109), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(107), 37,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym___builtin__,
  [5344] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(55), 1,
      sym_block_comment,
    ACTIONS(113), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(111), 37,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym___builtin__,
  [5404] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(56), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(117), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(115), 22,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [5481] = 19,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(57), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(117), 5,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(115), 20,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [5564] = 23,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(58), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(117), 5,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(115), 14,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_le,
      sym_op_ge,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [5655] = 22,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(59), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(117), 5,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(115), 16,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [5744] = 21,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(60), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(117), 5,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(115), 18,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [5831] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(117), 1,
      anon_sym_EQ,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(61), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(115), 9,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [5938] = 26,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(62), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(117), 3,
      anon_sym_EQ,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(115), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [6035] = 30,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(117), 1,
      anon_sym_EQ,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(63), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(115), 10,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [6140] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(64), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(149), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(147), 22,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [6217] = 27,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(65), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(117), 2,
      anon_sym_EQ,
      sym_op_bitwise_or,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(115), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [6316] = 28,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(66), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(117), 2,
      anon_sym_EQ,
      sym_op_bitwise_or,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(115), 11,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [6417] = 29,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(117), 1,
      anon_sym_EQ,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(67), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(115), 11,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [6520] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(156), 1,
      anon_sym_reg,
    ACTIONS(159), 1,
      anon_sym_set,
    ACTIONS(162), 1,
      anon_sym_decl,
    ACTIONS(165), 1,
      anon_sym_SQUOTE,
    ACTIONS(168), 1,
      anon_sym_DOLLARif,
    ACTIONS(171), 1,
      anon_sym_assert,
    STATE(152), 1,
      sym__statement,
    STATE(68), 2,
      sym_block_comment,
      aux_sym_block_repeat1,
    STATE(150), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(626), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
    ACTIONS(174), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(151), 12,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [6596] = 13,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(182), 1,
      anon_sym_COLON_COLON_LT,
    ACTIONS(184), 1,
      anon_sym_COLON_COLON_DOLLAR_LT,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(69), 1,
      sym_block_comment,
    STATE(120), 1,
      sym_argument_list,
    STATE(383), 1,
      sym_turbofish,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
    ACTIONS(180), 7,
      anon_sym_COLON,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(176), 23,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [6665] = 13,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(182), 1,
      anon_sym_COLON_COLON_LT,
    ACTIONS(184), 1,
      anon_sym_COLON_COLON_DOLLAR_LT,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(70), 1,
      sym_block_comment,
    STATE(136), 1,
      sym_argument_list,
    STATE(381), 1,
      sym_turbofish,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
    ACTIONS(190), 7,
      anon_sym_COLON,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(188), 23,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [6734] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(71), 1,
      sym_block_comment,
    ACTIONS(194), 8,
      anon_sym_COLON,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
      anon_sym_COLON_COLON,
    ACTIONS(192), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_for,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_EQ_GT,
      anon_sym_DOT,
      anon_sym_COLON_COLON_LT,
      anon_sym_COLON_COLON_DOLLAR_LT,
      anon_sym___builtin__,
      anon_sym_DOLLAR_LPAREN,
  [6788] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(200), 1,
      anon_sym_COLON_COLON,
    STATE(72), 1,
      sym_block_comment,
    ACTIONS(198), 7,
      anon_sym_COLON,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(196), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_for,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_EQ_GT,
      anon_sym_DOT,
      anon_sym_COLON_COLON_LT,
      anon_sym_COLON_COLON_DOLLAR_LT,
      anon_sym___builtin__,
      anon_sym_DOLLAR_LPAREN,
  [6844] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(73), 1,
      sym_block_comment,
    ACTIONS(204), 8,
      anon_sym_COLON,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
      anon_sym_COLON_COLON,
    ACTIONS(202), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_for,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_EQ_GT,
      anon_sym_DOT,
      anon_sym_COLON_COLON_LT,
      anon_sym_COLON_COLON_DOLLAR_LT,
      anon_sym___builtin__,
      anon_sym_DOLLAR_LPAREN,
  [6898] = 33,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(208), 1,
      anon_sym_COMMA,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(74), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(395), 1,
      aux_sym_where_clause_repeat1,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(206), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [7005] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(75), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(212), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [7107] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(76), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
    ACTIONS(214), 3,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [7208] = 33,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(216), 1,
      anon_sym_RPAREN,
    ACTIONS(218), 1,
      anon_sym_COMMA,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(77), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(521), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [7313] = 33,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(220), 1,
      anon_sym_RBRACK,
    ACTIONS(222), 1,
      anon_sym_COMMA,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(78), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(495), 1,
      aux_sym_array_literal_repeat1,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [7418] = 33,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(224), 1,
      anon_sym_RPAREN,
    ACTIONS(226), 1,
      anon_sym_COMMA,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(79), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(498), 1,
      aux_sym__positional_argument_list_repeat1,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [7523] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(80), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    ACTIONS(228), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [7623] = 32,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(230), 1,
      anon_sym_RPAREN,
    ACTIONS(232), 1,
      anon_sym_COMMA,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(81), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [7725] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(82), 1,
      sym_block_comment,
    ACTIONS(236), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(234), 27,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_EQ_GT,
      anon_sym_DOT,
      anon_sym___builtin__,
  [7775] = 32,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(83), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(589), 1,
      sym_block,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [7877] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(84), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    ACTIONS(238), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [7977] = 32,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(240), 1,
      anon_sym_LBRACE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(85), 1,
      sym_block_comment,
    STATE(122), 1,
      sym_match_block,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8079] = 32,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(86), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(616), 1,
      sym_block,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8181] = 32,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(242), 1,
      anon_sym_COMMA,
    ACTIONS(244), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(87), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8283] = 32,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(88), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    STATE(608), 1,
      sym_block,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8385] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(246), 1,
      anon_sym_EQ,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(89), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8484] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(248), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(90), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8583] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(250), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(91), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8682] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(252), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(92), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8781] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(254), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(93), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8880] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(256), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(94), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [8979] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(258), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(95), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9078] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(260), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(96), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9177] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(262), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(97), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9276] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(98), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9375] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(264), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(99), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9474] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(266), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(100), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9573] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(268), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(101), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9672] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(270), 1,
      anon_sym_COMMA,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(102), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9771] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(272), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(103), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9870] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(274), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(104), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [9969] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(276), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(105), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [10068] = 31,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      sym_op_div,
    ACTIONS(123), 1,
      sym_op_mod,
    ACTIONS(125), 1,
      anon_sym_PLUS,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      anon_sym_AMP,
    ACTIONS(139), 1,
      sym_op_bitwise_xor,
    ACTIONS(141), 1,
      sym_op_bitwise_or,
    ACTIONS(143), 1,
      sym_op_logical_and,
    ACTIONS(145), 1,
      sym_op_logical_or,
    ACTIONS(210), 1,
      anon_sym_BQUOTE,
    ACTIONS(278), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      sym_op_bitwise_and,
    STATE(21), 1,
      sym__op_mul_like,
    STATE(22), 1,
      sym__op_add_like,
    STATE(23), 1,
      sym__op_relational,
    STATE(24), 1,
      sym__op_eq_like,
    STATE(25), 1,
      sym__op_shifty,
    STATE(26), 1,
      sym_op_custom_infix,
    STATE(106), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_op_mul,
    ACTIONS(127), 2,
      sym_op_equals,
      sym_op_ne,
    ACTIONS(129), 2,
      sym_op_lshift,
      sym_op_rshift,
    ACTIONS(135), 2,
      sym_op_le,
      sym_op_ge,
    STATE(180), 2,
      sym_op_lt,
      sym_op_gt,
    STATE(183), 2,
      sym_op_add,
      sym_op_sub,
  [10167] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(284), 1,
      anon_sym_DOLLARelse,
    STATE(107), 1,
      sym_block_comment,
    STATE(153), 1,
      sym_comptime_else,
    ACTIONS(280), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(282), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [10219] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(284), 1,
      anon_sym_DOLLARelse,
    STATE(108), 1,
      sym_block_comment,
    STATE(149), 1,
      sym_comptime_else,
    ACTIONS(286), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(288), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [10271] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(109), 1,
      sym_block_comment,
    ACTIONS(292), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(290), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10318] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(110), 1,
      sym_block_comment,
    ACTIONS(296), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(294), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10365] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(111), 1,
      sym_block_comment,
    ACTIONS(300), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(298), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10412] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(112), 1,
      sym_block_comment,
    ACTIONS(304), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(302), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10459] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(113), 1,
      sym_block_comment,
    ACTIONS(308), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(306), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10506] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(114), 1,
      sym_block_comment,
    ACTIONS(312), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(310), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10553] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(115), 1,
      sym_block_comment,
    ACTIONS(316), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(314), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10600] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(116), 1,
      sym_block_comment,
    ACTIONS(320), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(318), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10647] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(117), 1,
      sym_block_comment,
    ACTIONS(324), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(322), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10694] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(118), 1,
      sym_block_comment,
    ACTIONS(328), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(326), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10741] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(119), 1,
      sym_block_comment,
    ACTIONS(180), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(176), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10788] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(120), 1,
      sym_block_comment,
    ACTIONS(332), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(330), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10835] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(121), 1,
      sym_block_comment,
    ACTIONS(336), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(334), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10882] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(122), 1,
      sym_block_comment,
    ACTIONS(340), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(338), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10929] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(123), 1,
      sym_block_comment,
    ACTIONS(344), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(342), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [10976] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(124), 1,
      sym_block_comment,
    ACTIONS(348), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(346), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11023] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(125), 1,
      sym_block_comment,
    ACTIONS(352), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(350), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11070] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(126), 1,
      sym_block_comment,
    ACTIONS(356), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(354), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11117] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(127), 1,
      sym_block_comment,
    ACTIONS(360), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(358), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11164] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(128), 1,
      sym_block_comment,
    ACTIONS(364), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(362), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11211] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(129), 1,
      sym_block_comment,
    ACTIONS(368), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(366), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11258] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(130), 1,
      sym_block_comment,
    ACTIONS(372), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(370), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11305] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(131), 1,
      sym_block_comment,
    ACTIONS(376), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(374), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11352] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(132), 1,
      sym_block_comment,
    ACTIONS(380), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(378), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11399] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(133), 1,
      sym_block_comment,
    ACTIONS(384), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(382), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11446] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(134), 1,
      sym_block_comment,
    ACTIONS(388), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(386), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11493] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(135), 1,
      sym_block_comment,
    ACTIONS(392), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(390), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11540] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(136), 1,
      sym_block_comment,
    ACTIONS(396), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(394), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11587] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(137), 1,
      sym_block_comment,
    ACTIONS(400), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(398), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11634] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(138), 1,
      sym_block_comment,
    ACTIONS(404), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(402), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11681] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(139), 1,
      sym_block_comment,
    ACTIONS(408), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(406), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11728] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(140), 1,
      sym_block_comment,
    ACTIONS(412), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(410), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11775] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(141), 1,
      sym_block_comment,
    ACTIONS(416), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(414), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11822] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(418), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    STATE(142), 1,
      sym_block_comment,
    ACTIONS(422), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(420), 22,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [11873] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(143), 1,
      sym_block_comment,
    ACTIONS(428), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(426), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11920] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(144), 1,
      sym_block_comment,
    ACTIONS(432), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(430), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [11967] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(145), 1,
      sym_block_comment,
    ACTIONS(436), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(434), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [12014] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(146), 1,
      sym_block_comment,
    ACTIONS(440), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(438), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [12061] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(147), 1,
      sym_block_comment,
    ACTIONS(444), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(442), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [12108] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(148), 1,
      sym_block_comment,
    ACTIONS(448), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(446), 24,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      anon_sym___builtin__,
  [12155] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(149), 1,
      sym_block_comment,
    ACTIONS(450), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(452), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12201] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(150), 1,
      sym_block_comment,
    ACTIONS(454), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(456), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12247] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(151), 1,
      sym_block_comment,
    ACTIONS(458), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(460), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12293] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(152), 1,
      sym_block_comment,
    ACTIONS(462), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(464), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12339] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(153), 1,
      sym_block_comment,
    ACTIONS(286), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(288), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12385] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(154), 1,
      sym_block_comment,
    ACTIONS(466), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(468), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12431] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(155), 1,
      sym_block_comment,
    ACTIONS(470), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(472), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12477] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(156), 1,
      sym_block_comment,
    ACTIONS(474), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(476), 15,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_assert,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
  [12523] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(157), 1,
      sym_block_comment,
    ACTIONS(480), 6,
      anon_sym_EQ,
      sym_op_div,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_op_bitwise_or,
    ACTIONS(478), 22,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      sym_op_mod,
      sym_op_equals,
      sym_op_ne,
      sym_op_le,
      sym_op_ge,
      sym_op_lshift,
      sym_op_rshift,
      sym_op_bitwise_xor,
      sym_op_logical_and,
      sym_op_logical_or,
      anon_sym_BQUOTE,
      anon_sym___builtin__,
  [12568] = 21,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(484), 1,
      anon_sym_POUND,
    ACTIONS(490), 1,
      anon_sym_pipeline,
    ACTIONS(493), 1,
      anon_sym_struct,
    ACTIONS(496), 1,
      anon_sym_enum,
    ACTIONS(499), 1,
      anon_sym_impl,
    ACTIONS(502), 1,
      anon_sym_trait,
    ACTIONS(505), 1,
      anon_sym_use,
    ACTIONS(508), 1,
      anon_sym_mod,
    ACTIONS(511), 1,
      anon_sym_DOLLARconfig,
    STATE(162), 1,
      aux_sym__item_repeat1,
    STATE(273), 1,
      sym__item,
    STATE(295), 1,
      sym_attribute,
    STATE(386), 1,
      sym__unit_head,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(482), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(487), 2,
      anon_sym_fn,
      anon_sym_entity,
    STATE(158), 2,
      sym_block_comment,
      aux_sym_source_file_repeat1,
    STATE(249), 8,
      sym_unit_definition,
      sym_struct_definition,
      sym_enum_definition,
      sym_impl,
      sym_trait,
      sym_use,
      sym_mod,
      sym_comptime_config,
  [12642] = 22,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(17), 1,
      anon_sym_struct,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(21), 1,
      anon_sym_impl,
    ACTIONS(23), 1,
      anon_sym_trait,
    ACTIONS(25), 1,
      anon_sym_use,
    ACTIONS(27), 1,
      anon_sym_mod,
    ACTIONS(29), 1,
      anon_sym_DOLLARconfig,
    ACTIONS(514), 1,
      ts_builtin_sym_end,
    STATE(158), 1,
      aux_sym_source_file_repeat1,
    STATE(159), 1,
      sym_block_comment,
    STATE(162), 1,
      aux_sym__item_repeat1,
    STATE(273), 1,
      sym__item,
    STATE(295), 1,
      sym_attribute,
    STATE(386), 1,
      sym__unit_head,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
    STATE(249), 8,
      sym_unit_definition,
      sym_struct_definition,
      sym_enum_definition,
      sym_impl,
      sym_trait,
      sym_use,
      sym_mod,
      sym_comptime_config,
  [12717] = 22,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(17), 1,
      anon_sym_struct,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(21), 1,
      anon_sym_impl,
    ACTIONS(23), 1,
      anon_sym_trait,
    ACTIONS(25), 1,
      anon_sym_use,
    ACTIONS(27), 1,
      anon_sym_mod,
    ACTIONS(29), 1,
      anon_sym_DOLLARconfig,
    ACTIONS(516), 1,
      anon_sym_RBRACE,
    STATE(158), 1,
      aux_sym_source_file_repeat1,
    STATE(160), 1,
      sym_block_comment,
    STATE(162), 1,
      aux_sym__item_repeat1,
    STATE(273), 1,
      sym__item,
    STATE(295), 1,
      sym_attribute,
    STATE(386), 1,
      sym__unit_head,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
    STATE(249), 8,
      sym_unit_definition,
      sym_struct_definition,
      sym_enum_definition,
      sym_impl,
      sym_trait,
      sym_use,
      sym_mod,
      sym_comptime_config,
  [12792] = 22,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(17), 1,
      anon_sym_struct,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(21), 1,
      anon_sym_impl,
    ACTIONS(23), 1,
      anon_sym_trait,
    ACTIONS(25), 1,
      anon_sym_use,
    ACTIONS(27), 1,
      anon_sym_mod,
    ACTIONS(29), 1,
      anon_sym_DOLLARconfig,
    ACTIONS(518), 1,
      anon_sym_RBRACE,
    STATE(160), 1,
      aux_sym_source_file_repeat1,
    STATE(161), 1,
      sym_block_comment,
    STATE(162), 1,
      aux_sym__item_repeat1,
    STATE(273), 1,
      sym__item,
    STATE(295), 1,
      sym_attribute,
    STATE(386), 1,
      sym__unit_head,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
    STATE(249), 8,
      sym_unit_definition,
      sym_struct_definition,
      sym_enum_definition,
      sym_impl,
      sym_trait,
      sym_use,
      sym_mod,
      sym_comptime_config,
  [12867] = 19,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(17), 1,
      anon_sym_struct,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(21), 1,
      anon_sym_impl,
    ACTIONS(23), 1,
      anon_sym_trait,
    ACTIONS(25), 1,
      anon_sym_use,
    ACTIONS(27), 1,
      anon_sym_mod,
    ACTIONS(29), 1,
      anon_sym_DOLLARconfig,
    STATE(162), 1,
      sym_block_comment,
    STATE(258), 1,
      aux_sym__item_repeat1,
    STATE(295), 1,
      sym_attribute,
    STATE(386), 1,
      sym__unit_head,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
    STATE(257), 8,
      sym_unit_definition,
      sym_struct_definition,
      sym_enum_definition,
      sym_impl,
      sym_trait,
      sym_use,
      sym_mod,
      sym_comptime_config,
  [12933] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(526), 1,
      anon_sym_GT,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    STATE(163), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(520), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [12995] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(540), 1,
      anon_sym_GT,
    STATE(164), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13057] = 19,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(544), 1,
      anon_sym_RBRACE,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(165), 1,
      sym_block_comment,
    STATE(198), 1,
      aux_sym_match_block_repeat1,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(318), 1,
      sym_match_arm,
    STATE(573), 1,
      sym_last_match_arm,
    STATE(574), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [13121] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(166), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(496), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13183] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(552), 1,
      anon_sym_GT,
    STATE(167), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(472), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13245] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    ACTIONS(554), 1,
      anon_sym_RPAREN,
    STATE(168), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13307] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(556), 1,
      anon_sym_GT,
    STATE(169), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13369] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(170), 1,
      sym_block_comment,
    ACTIONS(560), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(558), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13407] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(562), 1,
      anon_sym_GT,
    STATE(171), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13469] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(564), 1,
      anon_sym_GT,
    STATE(172), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13531] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(566), 1,
      anon_sym_GT,
    STATE(173), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [13593] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(174), 1,
      sym_block_comment,
    ACTIONS(570), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(568), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13631] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(175), 1,
      sym_block_comment,
    ACTIONS(574), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(572), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13669] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(176), 1,
      sym_block_comment,
    ACTIONS(578), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(576), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13707] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(177), 1,
      sym_block_comment,
    ACTIONS(582), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(580), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13745] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(178), 1,
      sym_block_comment,
    ACTIONS(586), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(584), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13783] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(179), 1,
      sym_block_comment,
    ACTIONS(590), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(588), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13821] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(180), 1,
      sym_block_comment,
    ACTIONS(594), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(592), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13859] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(181), 1,
      sym_block_comment,
    ACTIONS(598), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(596), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13897] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(182), 1,
      sym_block_comment,
    ACTIONS(602), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(600), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13935] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(183), 1,
      sym_block_comment,
    ACTIONS(606), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(604), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [13973] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(608), 1,
      anon_sym_GT,
    STATE(184), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(447), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14035] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(185), 1,
      sym_block_comment,
    ACTIONS(612), 10,
      anon_sym_if,
      anon_sym_gen,
      anon_sym_match,
      anon_sym_inst,
      anon_sym_stage,
      anon_sym_true,
      anon_sym_false,
      sym_self,
      sym_identifier,
      aux_sym_int_literal_token1,
    ACTIONS(610), 11,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [14073] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    STATE(186), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14135] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    ACTIONS(616), 1,
      anon_sym_RPAREN,
    STATE(187), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(515), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14197] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    ACTIONS(618), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14259] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    ACTIONS(620), 1,
      anon_sym_RPAREN,
    STATE(189), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14321] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(622), 1,
      anon_sym_GT,
    STATE(190), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14383] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    STATE(191), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(286), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14442] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(192), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(628), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14501] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(193), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(567), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14560] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(194), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(373), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14619] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(195), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(605), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14678] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(196), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(507), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14737] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_AMP,
    ACTIONS(632), 1,
      anon_sym_inv,
    ACTIONS(636), 1,
      sym_identifier,
    STATE(197), 1,
      sym_block_comment,
    STATE(508), 1,
      sym__base_type,
    STATE(579), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(539), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(634), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(576), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14796] = 18,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(198), 1,
      sym_block_comment,
    STATE(215), 1,
      aux_sym_match_block_repeat1,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(318), 1,
      sym_match_arm,
    STATE(574), 1,
      sym__pattern,
    STATE(625), 1,
      sym_last_match_arm,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [14857] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(199), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(591), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14916] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(200), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(390), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [14975] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    STATE(201), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(541), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15034] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(202), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(575), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15093] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(203), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(286), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15152] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(204), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(288), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15211] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(205), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(459), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15270] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(206), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(393), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15329] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(207), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(633), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15388] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(208), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15447] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    STATE(209), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(464), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15506] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(210), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(623), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15565] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_AMP,
    ACTIONS(550), 1,
      anon_sym_inv,
    STATE(211), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(646), 1,
      sym_type,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15624] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(520), 1,
      anon_sym_LBRACK,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_AMP,
    ACTIONS(530), 1,
      anon_sym_inv,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    STATE(212), 1,
      sym_block_comment,
    STATE(236), 1,
      sym__base_type,
    STATE(288), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(256), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(532), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(281), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15683] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_AMP,
    ACTIONS(632), 1,
      anon_sym_inv,
    ACTIONS(636), 1,
      sym_identifier,
    STATE(213), 1,
      sym_block_comment,
    STATE(508), 1,
      sym__base_type,
    STATE(584), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(539), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(634), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(576), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15742] = 17,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(536), 1,
      aux_sym_int_literal_token1,
    ACTIONS(624), 1,
      anon_sym_LBRACK,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_LBRACE,
    ACTIONS(630), 1,
      anon_sym_AMP,
    ACTIONS(632), 1,
      anon_sym_inv,
    ACTIONS(636), 1,
      sym_identifier,
    STATE(214), 1,
      sym_block_comment,
    STATE(508), 1,
      sym__base_type,
    STATE(585), 1,
      sym_type,
    ACTIONS(538), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(539), 2,
      sym_builtin_type,
      sym_int_literal,
    ACTIONS(634), 3,
      anon_sym_int,
      anon_sym_bool,
      anon_sym_clock,
    STATE(576), 4,
      sym_tuple_type,
      sym_array_type,
      sym_wire,
      sym_inverted,
  [15801] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    ACTIONS(644), 1,
      sym_identifier,
    ACTIONS(647), 1,
      anon_sym_COLON_COLON,
    ACTIONS(650), 1,
      aux_sym_int_literal_token1,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(318), 1,
      sym_match_arm,
    STATE(580), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(641), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(653), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(215), 2,
      sym_block_comment,
      aux_sym_match_block_repeat1,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [15857] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(656), 1,
      anon_sym_RBRACE,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    STATE(216), 1,
      sym_block_comment,
    STATE(221), 1,
      aux_sym_block_repeat1,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [15912] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    ACTIONS(672), 1,
      anon_sym_RBRACE,
    STATE(217), 1,
      sym_block_comment,
    STATE(221), 1,
      aux_sym_block_repeat1,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [15967] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    ACTIONS(674), 1,
      anon_sym_RBRACE,
    STATE(217), 1,
      aux_sym_block_repeat1,
    STATE(218), 1,
      sym_block_comment,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [16022] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(219), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(559), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16077] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(678), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(220), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(559), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16132] = 15,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(151), 1,
      anon_sym_RBRACE,
    ACTIONS(680), 1,
      anon_sym_let,
    ACTIONS(683), 1,
      anon_sym_reg,
    ACTIONS(686), 1,
      anon_sym_set,
    ACTIONS(689), 1,
      anon_sym_decl,
    ACTIONS(692), 1,
      anon_sym_SQUOTE,
    ACTIONS(695), 1,
      anon_sym_DOLLARif,
    ACTIONS(698), 1,
      anon_sym_assert,
    STATE(324), 1,
      sym__statement,
    STATE(221), 2,
      sym_block_comment,
      aux_sym_block_repeat1,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [16185] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(701), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(222), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(445), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16240] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    ACTIONS(703), 1,
      anon_sym_RBRACE,
    STATE(223), 1,
      sym_block_comment,
    STATE(230), 1,
      aux_sym_block_repeat1,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [16295] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    ACTIONS(705), 1,
      anon_sym_RBRACE,
    STATE(224), 1,
      sym_block_comment,
    STATE(229), 1,
      aux_sym_block_repeat1,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [16350] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(707), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(225), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(497), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16405] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(226), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(559), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16460] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(227), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(559), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16515] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    ACTIONS(713), 1,
      anon_sym_RBRACE,
    STATE(216), 1,
      aux_sym_block_repeat1,
    STATE(228), 1,
      sym_block_comment,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [16570] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    ACTIONS(715), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym_block_repeat1,
    STATE(229), 1,
      sym_block_comment,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [16625] = 16,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_let,
    ACTIONS(660), 1,
      anon_sym_reg,
    ACTIONS(662), 1,
      anon_sym_set,
    ACTIONS(664), 1,
      anon_sym_decl,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLARif,
    ACTIONS(670), 1,
      anon_sym_assert,
    ACTIONS(717), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym_block_repeat1,
    STATE(230), 1,
      sym_block_comment,
    STATE(324), 1,
      sym__statement,
    STATE(325), 2,
      sym_pipeline_stage_name,
      sym_comptime_if,
    STATE(619), 6,
      sym_let_binding,
      sym_reg_statement,
      sym_set_statement,
      sym_decl_statement,
      sym_pipeline_reg_marker,
      sym_assert_statement,
  [16680] = 15,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(719), 1,
      sym_identifier,
    ACTIONS(721), 1,
      anon_sym_COLON_COLON,
    STATE(231), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(346), 1,
      sym__pattern,
    STATE(354), 1,
      sym_scoped_identifier,
    STATE(640), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16732] = 15,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(232), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(531), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16784] = 15,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    ACTIONS(719), 1,
      sym_identifier,
    ACTIONS(721), 1,
      anon_sym_COLON_COLON,
    STATE(233), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(354), 1,
      sym_scoped_identifier,
    STATE(535), 1,
      sym__pattern,
    STATE(640), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16836] = 15,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    ACTIONS(542), 1,
      anon_sym_LPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(234), 1,
      sym_block_comment,
    STATE(297), 1,
      sym__scoped_or_raw_ident,
    STATE(559), 1,
      sym__pattern,
    STATE(635), 1,
      sym__path,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    STATE(363), 5,
      sym_bool_literal,
      sym_tuple_pattern,
      sym_named_unpack,
      sym_positional_unpack,
      sym_int_literal,
  [16888] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(235), 1,
      sym_block_comment,
    ACTIONS(723), 14,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [16917] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(727), 1,
      anon_sym_LT,
    STATE(236), 1,
      sym_block_comment,
    STATE(291), 1,
      sym__generic_list,
    ACTIONS(725), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [16950] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(237), 1,
      sym_block_comment,
    ACTIONS(729), 14,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [16979] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(238), 1,
      sym_block_comment,
    ACTIONS(731), 14,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17008] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(239), 1,
      sym_block_comment,
    ACTIONS(733), 14,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_COMMA,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17037] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(240), 1,
      sym_block_comment,
    ACTIONS(735), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17065] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(241), 1,
      sym_block_comment,
    ACTIONS(737), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17093] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(242), 1,
      sym_block_comment,
    ACTIONS(739), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17121] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(243), 1,
      sym_block_comment,
    ACTIONS(741), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17149] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(244), 1,
      sym_block_comment,
    ACTIONS(743), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17177] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(245), 1,
      sym_block_comment,
    ACTIONS(745), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17205] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(246), 1,
      sym_block_comment,
    ACTIONS(747), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17233] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(247), 1,
      sym_block_comment,
    ACTIONS(749), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17261] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(248), 1,
      sym_block_comment,
    ACTIONS(751), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17289] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(249), 1,
      sym_block_comment,
    ACTIONS(753), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17317] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(250), 1,
      sym_block_comment,
    ACTIONS(755), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17345] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(251), 1,
      sym_block_comment,
    ACTIONS(757), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17373] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(252), 1,
      sym_block_comment,
    ACTIONS(759), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17401] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(253), 1,
      sym_block_comment,
    ACTIONS(761), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17429] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(254), 1,
      sym_block_comment,
    ACTIONS(763), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17457] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(255), 1,
      sym_block_comment,
    ACTIONS(765), 13,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym___builtin__,
  [17485] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(256), 1,
      sym_block_comment,
    ACTIONS(767), 13,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym___builtin__,
  [17513] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(257), 1,
      sym_block_comment,
    ACTIONS(769), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17541] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(771), 1,
      anon_sym_POUND,
    STATE(295), 1,
      sym_attribute,
    STATE(258), 2,
      sym_block_comment,
      aux_sym__item_repeat1,
    ACTIONS(774), 10,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17573] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(259), 1,
      sym_block_comment,
    ACTIONS(776), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17601] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(260), 1,
      sym_block_comment,
    ACTIONS(778), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17629] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(261), 1,
      sym_block_comment,
    ACTIONS(780), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17657] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(262), 1,
      sym_block_comment,
    ACTIONS(782), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17685] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(263), 1,
      sym_block_comment,
    ACTIONS(784), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17713] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(264), 1,
      sym_block_comment,
    ACTIONS(786), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17741] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(265), 1,
      sym_block_comment,
    ACTIONS(788), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17769] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(266), 1,
      sym_block_comment,
    ACTIONS(790), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17797] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(267), 1,
      sym_block_comment,
    ACTIONS(792), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17825] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(268), 1,
      sym_block_comment,
    ACTIONS(794), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17853] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(269), 1,
      sym_block_comment,
    ACTIONS(796), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17881] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(270), 1,
      sym_block_comment,
    ACTIONS(798), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17909] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(271), 1,
      sym_block_comment,
    ACTIONS(800), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17937] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(272), 1,
      sym_block_comment,
    ACTIONS(802), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17965] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(273), 1,
      sym_block_comment,
    ACTIONS(804), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [17993] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(274), 1,
      sym_block_comment,
    ACTIONS(806), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18021] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(275), 1,
      sym_block_comment,
    ACTIONS(808), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18049] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(276), 1,
      sym_block_comment,
    ACTIONS(810), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18077] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(277), 1,
      sym_block_comment,
    ACTIONS(812), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18105] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(278), 1,
      sym_block_comment,
    ACTIONS(814), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18133] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(279), 1,
      sym_block_comment,
    ACTIONS(816), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18161] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(280), 1,
      sym_block_comment,
    ACTIONS(818), 13,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_RBRACE,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18189] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(281), 1,
      sym_block_comment,
    ACTIONS(725), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18216] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(282), 1,
      sym_block_comment,
    ACTIONS(820), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18243] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(283), 1,
      sym_block_comment,
    ACTIONS(822), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18270] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(284), 1,
      sym_block_comment,
    ACTIONS(824), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18297] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(285), 1,
      sym_block_comment,
    ACTIONS(826), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18324] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(286), 1,
      sym_block_comment,
    ACTIONS(828), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18351] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(287), 1,
      sym_block_comment,
    ACTIONS(830), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18378] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(288), 1,
      sym_block_comment,
    ACTIONS(832), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18405] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(289), 1,
      sym_block_comment,
    ACTIONS(834), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18432] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(290), 1,
      sym_block_comment,
    ACTIONS(836), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18459] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(291), 1,
      sym_block_comment,
    ACTIONS(838), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18486] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(292), 1,
      sym_block_comment,
    ACTIONS(840), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18513] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(293), 1,
      sym_block_comment,
    ACTIONS(842), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18540] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(294), 1,
      sym_block_comment,
    ACTIONS(844), 12,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_where,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_GT,
      anon_sym___builtin__,
  [18567] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(295), 1,
      sym_block_comment,
    ACTIONS(846), 11,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18593] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(296), 1,
      sym_block_comment,
    ACTIONS(848), 11,
      anon_sym_POUND,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_impl,
      anon_sym_trait,
      anon_sym_use,
      anon_sym_mod,
      anon_sym_DOLLARconfig,
  [18619] = 10,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(854), 1,
      anon_sym_EQ,
    ACTIONS(856), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(297), 1,
      sym_block_comment,
    STATE(348), 1,
      sym__named_pattern_list,
    STATE(362), 1,
      sym__positional_pattern_list,
    ACTIONS(852), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [18655] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(858), 1,
      anon_sym_DOLLARelse,
    STATE(298), 1,
      sym_block_comment,
    STATE(330), 1,
      sym_comptime_else,
    ACTIONS(286), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [18684] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(858), 1,
      anon_sym_DOLLARelse,
    STATE(299), 1,
      sym_block_comment,
    STATE(329), 1,
      sym_comptime_else,
    ACTIONS(280), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [18713] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(862), 1,
      anon_sym_RBRACE,
    STATE(300), 1,
      sym_block_comment,
    ACTIONS(860), 4,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(864), 4,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      aux_sym_int_literal_token1,
  [18741] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(866), 1,
      anon_sym_RBRACE,
    STATE(301), 1,
      sym_block_comment,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [18776] = 12,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(870), 1,
      anon_sym_RPAREN,
    ACTIONS(872), 1,
      sym_self,
    ACTIONS(874), 1,
      sym_identifier,
    STATE(302), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(490), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [18813] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(876), 1,
      anon_sym_RBRACE,
    STATE(303), 1,
      sym_block_comment,
    STATE(334), 1,
      aux_sym_trait_repeat1,
    STATE(370), 1,
      sym__unit_head,
    STATE(428), 1,
      sym_unit_declaration,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [18848] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    STATE(304), 1,
      sym_block_comment,
    STATE(435), 1,
      sym__comptime_operator,
    STATE(511), 2,
      sym_op_lt,
      sym_op_gt,
    ACTIONS(878), 3,
      sym_op_equals,
      sym_op_le,
      sym_op_ge,
  [18879] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(880), 1,
      anon_sym_RBRACE,
    STATE(305), 1,
      sym_block_comment,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [18914] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(182), 1,
      anon_sym_COLON_COLON_LT,
    ACTIONS(184), 1,
      anon_sym_COLON_COLON_DOLLAR_LT,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(130), 1,
      sym_argument_list,
    STATE(306), 1,
      sym_block_comment,
    STATE(399), 1,
      sym_turbofish,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [18949] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(882), 1,
      anon_sym_RBRACE,
    STATE(307), 1,
      sym_block_comment,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [18984] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(884), 1,
      anon_sym_RBRACE,
    STATE(308), 1,
      sym_block_comment,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19019] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(886), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_block_comment,
    STATE(315), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19054] = 12,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(888), 1,
      anon_sym_RPAREN,
    ACTIONS(890), 1,
      anon_sym_COMMA,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(310), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(452), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [19091] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(880), 1,
      anon_sym_RBRACE,
    STATE(311), 1,
      sym_block_comment,
    STATE(337), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19126] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(894), 1,
      anon_sym_RBRACE,
    STATE(312), 1,
      sym_block_comment,
    STATE(338), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19161] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(896), 1,
      anon_sym_RBRACE,
    STATE(301), 1,
      aux_sym_impl_repeat1,
    STATE(313), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19196] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(898), 1,
      anon_sym_RBRACE,
    STATE(314), 1,
      sym_block_comment,
    STATE(340), 1,
      aux_sym_trait_repeat1,
    STATE(370), 1,
      sym__unit_head,
    STATE(428), 1,
      sym_unit_declaration,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19231] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(900), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym_block_comment,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19266] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(866), 1,
      anon_sym_RBRACE,
    STATE(305), 1,
      aux_sym_impl_repeat1,
    STATE(316), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19301] = 10,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(905), 1,
      anon_sym_pipeline,
    ACTIONS(908), 1,
      anon_sym_RBRACE,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(902), 2,
      anon_sym_fn,
      anon_sym_entity,
    STATE(317), 2,
      sym_block_comment,
      aux_sym_impl_repeat1,
  [19334] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(318), 1,
      sym_block_comment,
    ACTIONS(910), 4,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(912), 4,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      aux_sym_int_literal_token1,
  [19359] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(914), 1,
      anon_sym_RBRACE,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(319), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19394] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(916), 1,
      anon_sym_RBRACE,
    STATE(307), 1,
      aux_sym_impl_repeat1,
    STATE(320), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19429] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(133), 1,
      anon_sym_GT,
    STATE(321), 1,
      sym_block_comment,
    STATE(441), 1,
      sym__comptime_operator,
    STATE(511), 2,
      sym_op_lt,
      sym_op_gt,
    ACTIONS(878), 3,
      sym_op_equals,
      sym_op_le,
      sym_op_ge,
  [19460] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(322), 1,
      sym_block_comment,
    ACTIONS(860), 4,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
    ACTIONS(864), 4,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      aux_sym_int_literal_token1,
  [19485] = 12,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(182), 1,
      anon_sym_COLON_COLON_LT,
    ACTIONS(184), 1,
      anon_sym_COLON_COLON_DOLLAR_LT,
    ACTIONS(918), 1,
      sym_identifier,
    ACTIONS(920), 1,
      anon_sym_COLON_COLON,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(323), 1,
      sym_block_comment,
    STATE(400), 1,
      sym_turbofish,
    STATE(404), 1,
      sym__scoped_or_raw_ident,
    STATE(635), 1,
      sym__path,
  [19522] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(324), 1,
      sym_block_comment,
    ACTIONS(462), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19545] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(325), 1,
      sym_block_comment,
    ACTIONS(454), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19568] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(326), 1,
      sym_block_comment,
    ACTIONS(470), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19591] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(327), 1,
      sym_block_comment,
    ACTIONS(458), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19614] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(922), 1,
      anon_sym_RBRACE,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(328), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19649] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(329), 1,
      sym_block_comment,
    ACTIONS(286), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19672] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(330), 1,
      sym_block_comment,
    ACTIONS(450), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19695] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(331), 1,
      sym_block_comment,
    ACTIONS(466), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19718] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(332), 1,
      sym_block_comment,
    ACTIONS(474), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_reg,
      anon_sym_set,
      anon_sym_decl,
      anon_sym_SQUOTE,
      anon_sym_DOLLARif,
      anon_sym_assert,
  [19741] = 10,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(927), 1,
      anon_sym_pipeline,
    ACTIONS(930), 1,
      anon_sym_RBRACE,
    STATE(370), 1,
      sym__unit_head,
    STATE(428), 1,
      sym_unit_declaration,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(924), 2,
      anon_sym_fn,
      anon_sym_entity,
    STATE(333), 2,
      sym_block_comment,
      aux_sym_trait_repeat1,
  [19774] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(932), 1,
      anon_sym_RBRACE,
    STATE(333), 1,
      aux_sym_trait_repeat1,
    STATE(334), 1,
      sym_block_comment,
    STATE(370), 1,
      sym__unit_head,
    STATE(428), 1,
      sym_unit_declaration,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19809] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(182), 1,
      anon_sym_COLON_COLON_LT,
    ACTIONS(184), 1,
      anon_sym_COLON_COLON_DOLLAR_LT,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(111), 1,
      sym_argument_list,
    STATE(335), 1,
      sym_block_comment,
    STATE(397), 1,
      sym_turbofish,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [19844] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    STATE(319), 1,
      aux_sym_impl_repeat1,
    STATE(336), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19879] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(936), 1,
      anon_sym_RBRACE,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(337), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19914] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(938), 1,
      anon_sym_RBRACE,
    STATE(317), 1,
      aux_sym_impl_repeat1,
    STATE(338), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19949] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(940), 1,
      anon_sym_RBRACE,
    STATE(328), 1,
      aux_sym_impl_repeat1,
    STATE(339), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [19984] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(876), 1,
      anon_sym_RBRACE,
    STATE(333), 1,
      aux_sym_trait_repeat1,
    STATE(340), 1,
      sym_block_comment,
    STATE(370), 1,
      sym__unit_head,
    STATE(428), 1,
      sym_unit_declaration,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [20019] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(15), 1,
      anon_sym_pipeline,
    ACTIONS(942), 1,
      anon_sym_RBRACE,
    STATE(308), 1,
      aux_sym_impl_repeat1,
    STATE(341), 1,
      sym_block_comment,
    STATE(386), 1,
      sym__unit_head,
    STATE(418), 1,
      sym_unit_definition,
    STATE(598), 1,
      sym__pipeline_start,
    ACTIONS(13), 2,
      anon_sym_fn,
      anon_sym_entity,
  [20054] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(946), 1,
      anon_sym_EQ,
    STATE(342), 1,
      sym_block_comment,
    ACTIONS(944), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20078] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(950), 1,
      anon_sym_EQ,
    STATE(343), 1,
      sym_block_comment,
    ACTIONS(948), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20102] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(954), 1,
      anon_sym_EQ,
    STATE(344), 1,
      sym_block_comment,
    ACTIONS(952), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20126] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(956), 1,
      anon_sym_RBRACE,
    STATE(345), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(457), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20160] = 10,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(958), 1,
      anon_sym_COLON,
    ACTIONS(960), 1,
      anon_sym_EQ,
    ACTIONS(962), 1,
      anon_sym_reset,
    ACTIONS(964), 1,
      anon_sym_initial,
    STATE(346), 1,
      sym_block_comment,
    STATE(371), 1,
      aux_sym_reg_statement_repeat1,
    STATE(475), 2,
      sym_reg_reset,
      sym_reg_initial,
  [20192] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(966), 1,
      anon_sym_RBRACE,
    STATE(347), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(512), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20226] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(970), 1,
      anon_sym_EQ,
    STATE(348), 1,
      sym_block_comment,
    ACTIONS(968), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20250] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(974), 1,
      anon_sym_EQ,
    STATE(349), 1,
      sym_block_comment,
    ACTIONS(972), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20274] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    ACTIONS(976), 1,
      anon_sym_LT,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(350), 1,
      sym_block_comment,
    STATE(384), 1,
      sym_generic_parameters,
    STATE(410), 1,
      sym__scoped_or_raw_ident,
    STATE(635), 1,
      sym__path,
  [20308] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(978), 1,
      anon_sym_RPAREN,
    STATE(351), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(454), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20342] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(978), 1,
      anon_sym_RPAREN,
    STATE(352), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(457), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20376] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(980), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(457), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20410] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(198), 1,
      anon_sym_COLON,
    ACTIONS(982), 1,
      anon_sym_COLON_COLON,
    STATE(354), 1,
      sym_block_comment,
    ACTIONS(196), 5,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_DOLLAR_LPAREN,
  [20436] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(194), 1,
      anon_sym_COLON,
    STATE(355), 1,
      sym_block_comment,
    ACTIONS(192), 6,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_COLON_COLON,
  [20460] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(984), 1,
      anon_sym_RPAREN,
    STATE(356), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(457), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20494] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(204), 1,
      anon_sym_COLON,
    STATE(357), 1,
      sym_block_comment,
    ACTIONS(202), 6,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_COLON_COLON,
  [20518] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(988), 1,
      anon_sym_EQ,
    STATE(358), 1,
      sym_block_comment,
    ACTIONS(986), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20542] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(992), 1,
      anon_sym_EQ,
    STATE(359), 1,
      sym_block_comment,
    ACTIONS(990), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20566] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(996), 1,
      anon_sym_EQ,
    STATE(360), 1,
      sym_block_comment,
    ACTIONS(994), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20590] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1000), 1,
      anon_sym_EQ,
    STATE(361), 1,
      sym_block_comment,
    ACTIONS(998), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20614] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1004), 1,
      anon_sym_EQ,
    STATE(362), 1,
      sym_block_comment,
    ACTIONS(1002), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20638] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(854), 1,
      anon_sym_EQ,
    STATE(363), 1,
      sym_block_comment,
    ACTIONS(852), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20662] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1008), 1,
      anon_sym_EQ,
    STATE(364), 1,
      sym_block_comment,
    ACTIONS(1006), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20686] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1010), 1,
      anon_sym_RBRACE,
    STATE(365), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(457), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20720] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1014), 1,
      anon_sym_EQ,
    STATE(366), 1,
      sym_block_comment,
    ACTIONS(1012), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20744] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    STATE(367), 1,
      sym_block_comment,
    ACTIONS(1016), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20768] = 11,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1020), 1,
      anon_sym_RPAREN,
    STATE(368), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(457), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [20802] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1024), 1,
      anon_sym_EQ,
    STATE(369), 1,
      sym_block_comment,
    ACTIONS(1022), 6,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_reset,
      anon_sym_initial,
      anon_sym_EQ_GT,
  [20826] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(1026), 1,
      anon_sym_SEMI,
    ACTIONS(1028), 1,
      anon_sym___builtin__,
    STATE(370), 1,
      sym_block_comment,
    STATE(420), 1,
      sym__body_or_builtin,
    STATE(246), 2,
      sym_block,
      sym_builtin_marker,
  [20855] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(962), 1,
      anon_sym_reset,
    ACTIONS(964), 1,
      anon_sym_initial,
    ACTIONS(1030), 1,
      anon_sym_EQ,
    STATE(371), 1,
      sym_block_comment,
    STATE(375), 1,
      aux_sym_reg_statement_repeat1,
    STATE(475), 2,
      sym_reg_reset,
      sym_reg_initial,
  [20884] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(1032), 1,
      anon_sym_if,
    ACTIONS(1034), 1,
      anon_sym_gen,
    STATE(372), 1,
      sym_block_comment,
    STATE(146), 3,
      sym_block,
      sym_gen_if_expression,
      sym_naked_gen_if_expression,
  [20911] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(962), 1,
      anon_sym_reset,
    ACTIONS(964), 1,
      anon_sym_initial,
    ACTIONS(1036), 1,
      anon_sym_EQ,
    STATE(373), 1,
      sym_block_comment,
    STATE(377), 1,
      aux_sym_reg_statement_repeat1,
    STATE(475), 2,
      sym_reg_reset,
      sym_reg_initial,
  [20940] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1040), 1,
      anon_sym_DASH_GT,
    ACTIONS(1042), 1,
      anon_sym_where,
    STATE(374), 1,
      sym_block_comment,
    STATE(494), 1,
      sym_where_clause,
    ACTIONS(1038), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [20967] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1044), 1,
      anon_sym_EQ,
    ACTIONS(1046), 1,
      anon_sym_reset,
    ACTIONS(1049), 1,
      anon_sym_initial,
    STATE(375), 2,
      sym_block_comment,
      aux_sym_reg_statement_repeat1,
    STATE(475), 2,
      sym_reg_reset,
      sym_reg_initial,
  [20994] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(1032), 1,
      anon_sym_if,
    ACTIONS(1034), 1,
      anon_sym_gen,
    STATE(376), 1,
      sym_block_comment,
    STATE(123), 3,
      sym_block,
      sym_gen_if_expression,
      sym_naked_gen_if_expression,
  [21021] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(962), 1,
      anon_sym_reset,
    ACTIONS(964), 1,
      anon_sym_initial,
    ACTIONS(1052), 1,
      anon_sym_EQ,
    STATE(375), 1,
      aux_sym_reg_statement_repeat1,
    STATE(377), 1,
      sym_block_comment,
    STATE(475), 2,
      sym_reg_reset,
      sym_reg_initial,
  [21050] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1042), 1,
      anon_sym_where,
    ACTIONS(1056), 1,
      anon_sym_DASH_GT,
    STATE(378), 1,
      sym_block_comment,
    STATE(465), 1,
      sym_where_clause,
    ACTIONS(1054), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21077] = 10,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    ACTIONS(1058), 1,
      anon_sym_LPAREN,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(306), 1,
      sym__scoped_or_raw_ident,
    STATE(379), 1,
      sym_block_comment,
    STATE(635), 1,
      sym__path,
  [21108] = 10,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(380), 1,
      sym_block_comment,
    STATE(394), 1,
      aux_sym__item_repeat1,
    STATE(457), 1,
      sym_typed_parameter,
    STATE(537), 1,
      sym_attribute,
    STATE(620), 1,
      sym_parameter,
  [21139] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(112), 1,
      sym_argument_list,
    STATE(381), 1,
      sym_block_comment,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [21165] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(382), 1,
      sym_block_comment,
    STATE(474), 1,
      sym__scoped_or_raw_ident,
    STATE(635), 1,
      sym__path,
  [21193] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(115), 1,
      sym_argument_list,
    STATE(383), 1,
      sym_block_comment,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [21219] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(384), 1,
      sym_block_comment,
    STATE(415), 1,
      sym__scoped_or_raw_ident,
    STATE(635), 1,
      sym__path,
  [21247] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(385), 1,
      sym_block_comment,
    ACTIONS(1060), 5,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      anon_sym_where,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21267] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(1028), 1,
      anon_sym___builtin__,
    STATE(244), 1,
      sym__body_or_builtin,
    STATE(386), 1,
      sym_block_comment,
    STATE(246), 2,
      sym_block,
      sym_builtin_marker,
  [21293] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(387), 1,
      sym_block_comment,
    ACTIONS(1062), 5,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      anon_sym_where,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21313] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(388), 1,
      sym_block_comment,
    ACTIONS(1064), 5,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      anon_sym_where,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21333] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1068), 1,
      anon_sym_COMMA,
    STATE(389), 2,
      sym_block_comment,
      aux_sym_where_clause_repeat1,
    ACTIONS(1066), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21355] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1042), 1,
      anon_sym_where,
    STATE(390), 1,
      sym_block_comment,
    STATE(462), 1,
      sym_where_clause,
    ACTIONS(1071), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21379] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(391), 1,
      sym_block_comment,
    STATE(453), 1,
      sym__scoped_or_raw_ident,
    STATE(635), 1,
      sym__path,
  [21407] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(392), 1,
      sym_block_comment,
    ACTIONS(1073), 5,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      anon_sym_where,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21427] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1042), 1,
      anon_sym_where,
    STATE(393), 1,
      sym_block_comment,
    STATE(509), 1,
      sym_where_clause,
    ACTIONS(1075), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21451] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(394), 1,
      sym_block_comment,
    STATE(421), 1,
      aux_sym__item_repeat1,
    STATE(537), 1,
      sym_attribute,
    STATE(578), 1,
      sym_parameter,
  [21479] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(208), 1,
      anon_sym_COMMA,
    STATE(389), 1,
      aux_sym_where_clause_repeat1,
    STATE(395), 1,
      sym_block_comment,
    ACTIONS(1077), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21503] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(137), 1,
      sym_argument_list,
    STATE(396), 1,
      sym_block_comment,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [21529] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(128), 1,
      sym_argument_list,
    STATE(397), 1,
      sym_block_comment,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [21555] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(398), 1,
      sym_block_comment,
    STATE(481), 1,
      sym__scoped_or_raw_ident,
    STATE(635), 1,
      sym__path,
  [21583] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(133), 1,
      sym_argument_list,
    STATE(399), 1,
      sym_block_comment,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [21609] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(396), 1,
      sym__scoped_or_raw_ident,
    STATE(400), 1,
      sym_block_comment,
    STATE(635), 1,
      sym__path,
  [21637] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(401), 1,
      sym_block_comment,
    ACTIONS(1079), 5,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      anon_sym_where,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21657] = 9,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(918), 1,
      sym_identifier,
    STATE(72), 1,
      sym_scoped_identifier,
    STATE(402), 1,
      sym_block_comment,
    STATE(527), 1,
      sym__scoped_or_raw_ident,
    STATE(635), 1,
      sym__path,
  [21685] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(403), 1,
      sym_block_comment,
    ACTIONS(1081), 5,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      anon_sym_where,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [21705] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(178), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(126), 1,
      sym_argument_list,
    STATE(404), 1,
      sym_block_comment,
    STATE(139), 2,
      sym__named_argument_list,
      sym__positional_argument_list,
  [21731] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1083), 1,
      anon_sym_RPAREN,
    STATE(405), 1,
      sym_block_comment,
    STATE(485), 1,
      sym_parameter,
    STATE(532), 1,
      sym_named_pattern_param,
  [21756] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(406), 1,
      sym_block_comment,
    ACTIONS(99), 4,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_RPAREN_DOT,
  [21775] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1085), 1,
      anon_sym_RPAREN,
    STATE(407), 1,
      sym_block_comment,
    STATE(485), 1,
      sym_parameter,
    STATE(486), 1,
      sym_named_pattern_param,
  [21800] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1089), 1,
      anon_sym_LBRACE,
    STATE(408), 1,
      sym_block_comment,
    STATE(536), 1,
      sym_braced_parameter_list,
    ACTIONS(1087), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21823] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(409), 1,
      sym_block_comment,
    ACTIONS(1091), 4,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_identifier,
      anon_sym_COLON_COLON,
  [21842] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1093), 1,
      anon_sym_for,
    ACTIONS(1095), 1,
      anon_sym_LBRACE,
    ACTIONS(1097), 1,
      anon_sym_LT,
    STATE(410), 1,
      sym_block_comment,
    STATE(534), 1,
      sym_generic_parameters,
  [21867] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1101), 1,
      anon_sym_COMMA,
    ACTIONS(1099), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    STATE(411), 2,
      sym_block_comment,
      aux_sym_parameter_list_repeat1,
  [21888] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(412), 1,
      sym_block_comment,
    ACTIONS(1104), 4,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_identifier,
      anon_sym_COLON_COLON,
  [21907] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1106), 1,
      anon_sym_RPAREN,
    STATE(413), 1,
      sym_block_comment,
    STATE(451), 1,
      sym_parameter,
    STATE(530), 1,
      sym__named_argument,
  [21932] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1110), 1,
      anon_sym___builtin__,
    ACTIONS(1112), 1,
      sym_identifier,
    STATE(414), 1,
      sym_block_comment,
    ACTIONS(1108), 2,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [21955] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1097), 1,
      anon_sym_LT,
    ACTIONS(1114), 1,
      anon_sym_for,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    STATE(415), 1,
      sym_block_comment,
    STATE(561), 1,
      sym_generic_parameters,
  [21980] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1118), 1,
      anon_sym_POUND,
    ACTIONS(1120), 1,
      anon_sym_GT,
    ACTIONS(1122), 1,
      sym_identifier,
    STATE(416), 1,
      sym_block_comment,
    STATE(548), 1,
      sym_generic_param,
  [22005] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    STATE(374), 1,
      sym_parameter_list,
    STATE(417), 1,
      sym_block_comment,
    STATE(552), 1,
      sym_generic_parameters,
  [22030] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(418), 1,
      sym_block_comment,
    ACTIONS(1126), 4,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_RBRACE,
  [22049] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1128), 1,
      anon_sym_RPAREN,
    STATE(419), 1,
      sym_block_comment,
    STATE(451), 1,
      sym_parameter,
    STATE(530), 1,
      sym__named_argument,
  [22074] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(420), 1,
      sym_block_comment,
    ACTIONS(1130), 4,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_RBRACE,
  [22093] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(774), 1,
      sym_identifier,
    ACTIONS(1132), 1,
      anon_sym_POUND,
    STATE(537), 1,
      sym_attribute,
    STATE(421), 2,
      sym_block_comment,
      aux_sym__item_repeat1,
  [22116] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1135), 1,
      anon_sym_RPAREN,
    STATE(422), 1,
      sym_block_comment,
    STATE(450), 1,
      sym__named_argument,
    STATE(451), 1,
      sym_parameter,
  [22141] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(248), 1,
      sym_int_literal,
    STATE(423), 1,
      sym_block_comment,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [22164] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(424), 1,
      sym_block_comment,
    ACTIONS(1137), 4,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_identifier,
      anon_sym_COLON_COLON,
  [22183] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(425), 1,
      sym_block_comment,
    ACTIONS(1139), 4,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_identifier,
      anon_sym_COLON_COLON,
  [22202] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1141), 1,
      sym_identifier,
    STATE(426), 1,
      sym_block_comment,
    STATE(556), 1,
      sym_scoped_identifier,
    STATE(635), 1,
      sym__path,
  [22227] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1118), 1,
      anon_sym_POUND,
    ACTIONS(1122), 1,
      sym_identifier,
    ACTIONS(1143), 1,
      anon_sym_GT,
    STATE(427), 1,
      sym_block_comment,
    STATE(548), 1,
      sym_generic_param,
  [22252] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(428), 1,
      sym_block_comment,
    ACTIONS(1145), 4,
      anon_sym_fn,
      anon_sym_entity,
      anon_sym_pipeline,
      anon_sym_RBRACE,
  [22271] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1118), 1,
      anon_sym_POUND,
    ACTIONS(1122), 1,
      sym_identifier,
    ACTIONS(1147), 1,
      anon_sym_GT,
    STATE(429), 1,
      sym_block_comment,
    STATE(548), 1,
      sym_generic_param,
  [22296] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    ACTIONS(1149), 1,
      anon_sym_RPAREN,
    STATE(430), 1,
      sym_block_comment,
    STATE(485), 1,
      sym_parameter,
    STATE(532), 1,
      sym_named_pattern_param,
  [22321] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(431), 1,
      sym_block_comment,
    ACTIONS(1151), 4,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_identifier,
      anon_sym_COLON_COLON,
  [22340] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1089), 1,
      anon_sym_LBRACE,
    STATE(259), 1,
      sym_braced_parameter_list,
    STATE(432), 1,
      sym_block_comment,
    STATE(533), 1,
      sym_generic_parameters,
  [22365] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1153), 1,
      anon_sym_LBRACE,
    STATE(260), 1,
      sym_enum_body,
    STATE(433), 1,
      sym_block_comment,
    STATE(553), 1,
      sym_generic_parameters,
  [22390] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1155), 1,
      anon_sym_COMMA,
    ACTIONS(214), 2,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
    STATE(434), 2,
      sym_block_comment,
      aux_sym_array_literal_repeat1,
  [22411] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(435), 1,
      sym_block_comment,
    STATE(588), 1,
      sym_int_literal,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [22434] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1089), 1,
      anon_sym_LBRACE,
    STATE(269), 1,
      sym_braced_parameter_list,
    STATE(436), 1,
      sym_block_comment,
    STATE(547), 1,
      sym_generic_parameters,
  [22459] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(437), 1,
      sym_block_comment,
    ACTIONS(1158), 4,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_identifier,
      anon_sym_COLON_COLON,
  [22478] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(1160), 1,
      anon_sym_if,
    STATE(438), 1,
      sym_block_comment,
    STATE(127), 2,
      sym_block,
      sym_if_expression,
  [22501] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1118), 1,
      anon_sym_POUND,
    ACTIONS(1122), 1,
      sym_identifier,
    ACTIONS(1162), 1,
      anon_sym_GT,
    STATE(439), 1,
      sym_block_comment,
    STATE(491), 1,
      sym_generic_param,
  [22526] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1118), 1,
      anon_sym_POUND,
    ACTIONS(1122), 1,
      sym_identifier,
    ACTIONS(1164), 1,
      anon_sym_GT,
    STATE(440), 1,
      sym_block_comment,
    STATE(548), 1,
      sym_generic_param,
  [22551] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      aux_sym_int_literal_token1,
    STATE(441), 1,
      sym_block_comment,
    STATE(643), 1,
      sym_int_literal,
    ACTIONS(77), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [22574] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(442), 1,
      sym_block_comment,
    ACTIONS(1166), 4,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_identifier,
      anon_sym_COLON_COLON,
  [22593] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(443), 1,
      sym_block_comment,
    ACTIONS(1168), 4,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_identifier,
      anon_sym_COLON_COLON,
  [22612] = 8,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1118), 1,
      anon_sym_POUND,
    ACTIONS(1122), 1,
      sym_identifier,
    ACTIONS(1170), 1,
      anon_sym_GT,
    STATE(444), 1,
      sym_block_comment,
    STATE(514), 1,
      sym_generic_param,
  [22637] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1172), 1,
      anon_sym_RPAREN,
    ACTIONS(1174), 1,
      anon_sym_COMMA,
    STATE(445), 1,
      sym_block_comment,
    STATE(526), 1,
      aux_sym_tuple_pattern_repeat1,
  [22659] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1083), 1,
      anon_sym_RPAREN,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    STATE(446), 1,
      sym_block_comment,
    STATE(473), 1,
      aux_sym__named_pattern_list_repeat1,
  [22681] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1178), 1,
      anon_sym_COMMA,
    ACTIONS(1180), 1,
      anon_sym_GT,
    STATE(447), 1,
      sym_block_comment,
    STATE(499), 1,
      aux_sym_turbofish_repeat1,
  [22703] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1182), 1,
      anon_sym_COLON,
    STATE(448), 1,
      sym_block_comment,
    ACTIONS(1184), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [22723] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1180), 1,
      anon_sym_GT,
    ACTIONS(1186), 1,
      anon_sym_COMMA,
    STATE(449), 1,
      sym_block_comment,
    STATE(502), 1,
      aux_sym_turbofish_repeat2,
  [22745] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1188), 1,
      anon_sym_RPAREN,
    ACTIONS(1190), 1,
      anon_sym_COMMA,
    STATE(450), 1,
      sym_block_comment,
    STATE(503), 1,
      aux_sym__named_argument_list_repeat1,
  [22767] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1194), 1,
      anon_sym_COLON,
    STATE(451), 1,
      sym_block_comment,
    ACTIONS(1192), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [22787] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(978), 1,
      anon_sym_RPAREN,
    ACTIONS(1196), 1,
      anon_sym_COMMA,
    STATE(452), 1,
      sym_block_comment,
    STATE(456), 1,
      aux_sym_parameter_list_repeat1,
  [22809] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    STATE(453), 1,
      sym_block_comment,
    STATE(638), 1,
      sym_generic_parameters,
  [22831] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(980), 1,
      anon_sym_RPAREN,
    ACTIONS(1200), 1,
      anon_sym_COMMA,
    STATE(454), 1,
      sym_block_comment,
    STATE(505), 1,
      aux_sym_parameter_list_repeat1,
  [22853] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(978), 1,
      anon_sym_RPAREN,
    ACTIONS(1196), 1,
      anon_sym_COMMA,
    STATE(411), 1,
      aux_sym_parameter_list_repeat1,
    STATE(455), 1,
      sym_block_comment,
  [22875] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(980), 1,
      anon_sym_RPAREN,
    ACTIONS(1200), 1,
      anon_sym_COMMA,
    STATE(411), 1,
      aux_sym_parameter_list_repeat1,
    STATE(456), 1,
      sym_block_comment,
  [22897] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(457), 1,
      sym_block_comment,
    ACTIONS(1099), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [22915] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(228), 1,
      anon_sym_RPAREN,
    ACTIONS(1202), 1,
      anon_sym_COMMA,
    STATE(458), 2,
      sym_block_comment,
      aux_sym__positional_argument_list_repeat1,
  [22935] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(459), 1,
      sym_block_comment,
    ACTIONS(1205), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [22953] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(566), 1,
      anon_sym_GT,
    ACTIONS(1207), 1,
      sym_identifier,
    STATE(460), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_named_turbofish_arg,
  [22975] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1209), 1,
      anon_sym_COMMA,
    ACTIONS(1212), 1,
      anon_sym_GT,
    STATE(461), 2,
      sym_block_comment,
      aux_sym_turbofish_repeat2,
  [22995] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(462), 1,
      sym_block_comment,
    ACTIONS(1075), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [23013] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1214), 1,
      anon_sym_RPAREN,
    ACTIONS(1216), 1,
      anon_sym_COMMA,
    STATE(463), 2,
      sym_block_comment,
      aux_sym__named_argument_list_repeat1,
  [23033] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(464), 1,
      sym_block_comment,
    ACTIONS(1219), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT,
  [23051] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(465), 1,
      sym_block_comment,
    ACTIONS(1071), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [23069] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    ACTIONS(1221), 1,
      anon_sym_COMMA,
    STATE(466), 2,
      sym_block_comment,
      aux_sym_turbofish_repeat1,
  [23089] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(556), 1,
      anon_sym_GT,
    ACTIONS(1224), 1,
      anon_sym_COMMA,
    STATE(467), 1,
      sym_block_comment,
    STATE(522), 1,
      aux_sym_turbofish_repeat1,
  [23111] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    ACTIONS(1226), 1,
      anon_sym_COMMA,
    STATE(466), 1,
      aux_sym_turbofish_repeat1,
    STATE(468), 1,
      sym_block_comment,
  [23133] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1228), 1,
      anon_sym_RBRACE,
    ACTIONS(1230), 1,
      sym_identifier,
    STATE(469), 1,
      sym_block_comment,
    STATE(562), 1,
      sym_enum_member,
  [23155] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1232), 1,
      anon_sym_COMMA,
    ACTIONS(1235), 1,
      anon_sym_RBRACE,
    STATE(470), 2,
      sym_block_comment,
      aux_sym_enum_body_repeat1,
  [23175] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1118), 1,
      anon_sym_POUND,
    ACTIONS(1122), 1,
      sym_identifier,
    STATE(471), 1,
      sym_block_comment,
    STATE(548), 1,
      sym_generic_param,
  [23197] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1237), 1,
      anon_sym_COMMA,
    ACTIONS(1239), 1,
      anon_sym_GT,
    STATE(467), 1,
      aux_sym_turbofish_repeat1,
    STATE(472), 1,
      sym_block_comment,
  [23219] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1241), 1,
      anon_sym_RPAREN,
    ACTIONS(1243), 1,
      anon_sym_COMMA,
    STATE(473), 2,
      sym_block_comment,
      aux_sym__named_pattern_list_repeat1,
  [23239] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1246), 1,
      anon_sym_LBRACE,
    STATE(474), 1,
      sym_block_comment,
    STATE(609), 1,
      sym_generic_parameters,
  [23261] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(475), 1,
      sym_block_comment,
    ACTIONS(1248), 3,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
  [23279] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1230), 1,
      sym_identifier,
    ACTIONS(1250), 1,
      anon_sym_RBRACE,
    STATE(476), 1,
      sym_block_comment,
    STATE(513), 1,
      sym_enum_member,
  [23301] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(956), 1,
      anon_sym_RBRACE,
    ACTIONS(1252), 1,
      anon_sym_COMMA,
    STATE(411), 1,
      aux_sym_parameter_list_repeat1,
    STATE(477), 1,
      sym_block_comment,
  [23323] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1230), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_RBRACE,
    STATE(478), 1,
      sym_block_comment,
    STATE(562), 1,
      sym_enum_member,
  [23345] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1254), 1,
      anon_sym_RBRACE,
    ACTIONS(1256), 1,
      anon_sym_COMMA,
    STATE(470), 1,
      aux_sym_enum_body_repeat1,
    STATE(479), 1,
      sym_block_comment,
  [23367] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1258), 1,
      anon_sym_COMMA,
    ACTIONS(1261), 1,
      anon_sym_GT,
    STATE(480), 2,
      sym_block_comment,
      aux_sym_generic_parameters_repeat1,
  [23387] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1263), 1,
      anon_sym_LBRACE,
    STATE(481), 1,
      sym_block_comment,
    STATE(582), 1,
      sym_generic_parameters,
  [23409] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(676), 1,
      anon_sym_RPAREN,
    ACTIONS(1265), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      sym_block_comment,
    STATE(524), 1,
      aux_sym_tuple_pattern_repeat1,
  [23431] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1267), 1,
      anon_sym_SEMI,
    ACTIONS(1269), 1,
      anon_sym_COMMA,
    STATE(483), 1,
      sym_block_comment,
    STATE(510), 1,
      aux_sym_decl_statement_repeat1,
  [23453] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(451), 1,
      sym_parameter,
    STATE(484), 1,
      sym_block_comment,
    STATE(530), 1,
      sym__named_argument,
  [23475] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1273), 1,
      anon_sym_COLON,
    STATE(485), 1,
      sym_block_comment,
    ACTIONS(1271), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23495] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1275), 1,
      anon_sym_RPAREN,
    ACTIONS(1277), 1,
      anon_sym_COMMA,
    STATE(446), 1,
      aux_sym__named_pattern_list_repeat1,
    STATE(486), 1,
      sym_block_comment,
  [23517] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(487), 1,
      sym_block_comment,
    ACTIONS(1279), 3,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_COMMA,
  [23535] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(892), 1,
      sym_identifier,
    STATE(485), 1,
      sym_parameter,
    STATE(488), 1,
      sym_block_comment,
    STATE(532), 1,
      sym_named_pattern_param,
  [23557] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1281), 1,
      anon_sym_SEMI,
    ACTIONS(1283), 1,
      anon_sym_COMMA,
    STATE(489), 2,
      sym_block_comment,
      aux_sym_decl_statement_repeat1,
  [23577] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(888), 1,
      anon_sym_RPAREN,
    ACTIONS(1286), 1,
      anon_sym_COMMA,
    STATE(455), 1,
      aux_sym_parameter_list_repeat1,
    STATE(490), 1,
      sym_block_comment,
  [23599] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1288), 1,
      anon_sym_COMMA,
    ACTIONS(1290), 1,
      anon_sym_GT,
    STATE(491), 1,
      sym_block_comment,
    STATE(517), 1,
      aux_sym_generic_parameters_repeat1,
  [23621] = 6,
    ACTIONS(1292), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1294), 1,
      aux_sym_block_comment_token1,
    ACTIONS(1296), 1,
      anon_sym_STAR_SLASH,
    STATE(492), 1,
      sym_block_comment,
    STATE(504), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(5), 2,
      sym_doc_comment,
      sym_line_comment,
  [23641] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1300), 1,
      sym_identifier,
    STATE(493), 1,
      sym_block_comment,
    ACTIONS(1298), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
  [23661] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(494), 1,
      sym_block_comment,
    ACTIONS(1054), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [23679] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    ACTIONS(1302), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_array_literal_repeat1,
    STATE(495), 1,
      sym_block_comment,
  [23701] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1304), 1,
      anon_sym_RPAREN,
    ACTIONS(1306), 1,
      anon_sym_COMMA,
    STATE(468), 1,
      aux_sym_turbofish_repeat1,
    STATE(496), 1,
      sym_block_comment,
  [23723] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1308), 1,
      anon_sym_RPAREN,
    ACTIONS(1310), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      aux_sym_tuple_pattern_repeat1,
    STATE(497), 1,
      sym_block_comment,
  [23745] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    ACTIONS(1312), 1,
      anon_sym_COMMA,
    STATE(458), 1,
      aux_sym__positional_argument_list_repeat1,
    STATE(498), 1,
      sym_block_comment,
  [23767] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(562), 1,
      anon_sym_GT,
    ACTIONS(1314), 1,
      anon_sym_COMMA,
    STATE(499), 1,
      sym_block_comment,
    STATE(522), 1,
      aux_sym_turbofish_repeat1,
  [23789] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(562), 1,
      anon_sym_GT,
    ACTIONS(1207), 1,
      sym_identifier,
    STATE(500), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_named_turbofish_arg,
  [23811] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(501), 1,
      sym_block_comment,
    ACTIONS(1316), 3,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
  [23829] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(562), 1,
      anon_sym_GT,
    ACTIONS(1318), 1,
      anon_sym_COMMA,
    STATE(461), 1,
      aux_sym_turbofish_repeat2,
    STATE(502), 1,
      sym_block_comment,
  [23851] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1106), 1,
      anon_sym_RPAREN,
    ACTIONS(1320), 1,
      anon_sym_COMMA,
    STATE(463), 1,
      aux_sym__named_argument_list_repeat1,
    STATE(503), 1,
      sym_block_comment,
  [23873] = 5,
    ACTIONS(1292), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1322), 1,
      aux_sym_block_comment_token1,
    ACTIONS(1325), 1,
      anon_sym_STAR_SLASH,
    ACTIONS(5), 2,
      sym_doc_comment,
      sym_line_comment,
    STATE(504), 2,
      sym_block_comment,
      aux_sym_block_comment_repeat1,
  [23891] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1020), 1,
      anon_sym_RPAREN,
    ACTIONS(1327), 1,
      anon_sym_COMMA,
    STATE(411), 1,
      aux_sym_parameter_list_repeat1,
    STATE(505), 1,
      sym_block_comment,
  [23913] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(506), 1,
      sym_block_comment,
    ACTIONS(1329), 3,
      anon_sym_EQ,
      anon_sym_reset,
      anon_sym_initial,
  [23931] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(507), 1,
      sym_block_comment,
    ACTIONS(1331), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [23949] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(725), 1,
      anon_sym_RPAREN_DOT,
    ACTIONS(1333), 1,
      anon_sym_LT,
    STATE(508), 1,
      sym_block_comment,
    STATE(586), 1,
      sym__generic_list,
  [23971] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(509), 1,
      sym_block_comment,
    ACTIONS(1335), 3,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym___builtin__,
  [23989] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1337), 1,
      anon_sym_SEMI,
    ACTIONS(1339), 1,
      anon_sym_COMMA,
    STATE(489), 1,
      aux_sym_decl_statement_repeat1,
    STATE(510), 1,
      sym_block_comment,
  [24011] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1341), 1,
      aux_sym_int_literal_token1,
    STATE(511), 1,
      sym_block_comment,
    ACTIONS(1343), 2,
      aux_sym_int_literal_token2,
      aux_sym_int_literal_token3,
  [24031] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1345), 1,
      anon_sym_COMMA,
    ACTIONS(1347), 1,
      anon_sym_RBRACE,
    STATE(477), 1,
      aux_sym_parameter_list_repeat1,
    STATE(512), 1,
      sym_block_comment,
  [24053] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1349), 1,
      anon_sym_COMMA,
    ACTIONS(1351), 1,
      anon_sym_RBRACE,
    STATE(479), 1,
      aux_sym_enum_body_repeat1,
    STATE(513), 1,
      sym_block_comment,
  [24075] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1353), 1,
      anon_sym_COMMA,
    ACTIONS(1355), 1,
      anon_sym_GT,
    STATE(514), 1,
      sym_block_comment,
    STATE(518), 1,
      aux_sym_generic_parameters_repeat1,
  [24097] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1357), 1,
      anon_sym_RPAREN,
    ACTIONS(1359), 1,
      anon_sym_COMMA,
    STATE(515), 1,
      sym_block_comment,
    STATE(519), 1,
      aux_sym_turbofish_repeat1,
  [24119] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1361), 1,
      anon_sym_SEMI,
    ACTIONS(1363), 1,
      anon_sym_LPAREN,
    ACTIONS(1365), 1,
      anon_sym_STAR,
    STATE(516), 1,
      sym_block_comment,
  [24141] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1164), 1,
      anon_sym_GT,
    ACTIONS(1367), 1,
      anon_sym_COMMA,
    STATE(480), 1,
      aux_sym_generic_parameters_repeat1,
    STATE(517), 1,
      sym_block_comment,
  [24163] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1143), 1,
      anon_sym_GT,
    ACTIONS(1369), 1,
      anon_sym_COMMA,
    STATE(480), 1,
      aux_sym_generic_parameters_repeat1,
    STATE(518), 1,
      sym_block_comment,
  [24185] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(618), 1,
      anon_sym_RPAREN,
    ACTIONS(1371), 1,
      anon_sym_COMMA,
    STATE(466), 1,
      aux_sym_turbofish_repeat1,
    STATE(519), 1,
      sym_block_comment,
  [24207] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1373), 1,
      anon_sym_COMMA,
    ACTIONS(1375), 1,
      anon_sym_GT,
    STATE(520), 1,
      sym_block_comment,
    STATE(523), 1,
      aux_sym_turbofish_repeat1,
  [24229] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    ACTIONS(1377), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_array_literal_repeat1,
    STATE(521), 1,
      sym_block_comment,
  [24251] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1219), 1,
      anon_sym_GT,
    ACTIONS(1379), 1,
      anon_sym_COMMA,
    STATE(522), 2,
      sym_block_comment,
      aux_sym_turbofish_repeat1,
  [24271] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(622), 1,
      anon_sym_GT,
    ACTIONS(1382), 1,
      anon_sym_COMMA,
    STATE(522), 1,
      aux_sym_turbofish_repeat1,
    STATE(523), 1,
      sym_block_comment,
  [24293] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1384), 1,
      anon_sym_RPAREN,
    ACTIONS(1386), 1,
      anon_sym_COMMA,
    STATE(524), 2,
      sym_block_comment,
      aux_sym_tuple_pattern_repeat1,
  [24313] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(608), 1,
      anon_sym_GT,
    ACTIONS(1207), 1,
      sym_identifier,
    STATE(449), 1,
      sym_named_turbofish_arg,
    STATE(525), 1,
      sym_block_comment,
  [24335] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(711), 1,
      anon_sym_RPAREN,
    ACTIONS(1389), 1,
      anon_sym_COMMA,
    STATE(524), 1,
      aux_sym_tuple_pattern_repeat1,
    STATE(526), 1,
      sym_block_comment,
  [24357] = 7,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(976), 1,
      anon_sym_LT,
    ACTIONS(1391), 1,
      anon_sym_LBRACE,
    STATE(527), 1,
      sym_block_comment,
    STATE(647), 1,
      sym_generic_parameters,
  [24379] = 6,
    ACTIONS(1292), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1294), 1,
      aux_sym_block_comment_token1,
    ACTIONS(1393), 1,
      anon_sym_STAR_SLASH,
    STATE(492), 1,
      aux_sym_block_comment_repeat1,
    STATE(528), 1,
      sym_block_comment,
    ACTIONS(5), 2,
      sym_doc_comment,
      sym_line_comment,
  [24399] = 4,
    ACTIONS(1292), 1,
      anon_sym_SLASH_STAR,
    STATE(529), 1,
      sym_block_comment,
    ACTIONS(5), 2,
      sym_doc_comment,
      sym_line_comment,
    ACTIONS(1395), 2,
      aux_sym_block_comment_token1,
      anon_sym_STAR_SLASH,
  [24414] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(530), 1,
      sym_block_comment,
    ACTIONS(1214), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [24431] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(531), 1,
      sym_block_comment,
    ACTIONS(1397), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [24448] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(532), 1,
      sym_block_comment,
    ACTIONS(1241), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [24465] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1089), 1,
      anon_sym_LBRACE,
    STATE(269), 1,
      sym_braced_parameter_list,
    STATE(533), 1,
      sym_block_comment,
  [24484] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1114), 1,
      anon_sym_for,
    ACTIONS(1116), 1,
      anon_sym_LBRACE,
    STATE(534), 1,
      sym_block_comment,
  [24503] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1399), 1,
      anon_sym_COLON,
    ACTIONS(1401), 1,
      anon_sym_EQ,
    STATE(535), 1,
      sym_block_comment,
  [24522] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(536), 1,
      sym_block_comment,
    ACTIONS(1403), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24539] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(537), 1,
      sym_block_comment,
    ACTIONS(846), 2,
      anon_sym_POUND,
      sym_identifier,
  [24556] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(538), 1,
      sym_block_comment,
    ACTIONS(765), 2,
      anon_sym_LT,
      anon_sym_RPAREN_DOT,
  [24573] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(539), 1,
      sym_block_comment,
    ACTIONS(767), 2,
      anon_sym_LT,
      anon_sym_RPAREN_DOT,
  [24590] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1337), 1,
      anon_sym_SEMI,
    ACTIONS(1405), 1,
      sym_identifier,
    STATE(540), 1,
      sym_block_comment,
  [24609] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(541), 1,
      sym_block_comment,
    ACTIONS(1407), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [24626] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(542), 1,
      sym_block_comment,
    ACTIONS(1137), 2,
      anon_sym_for,
      anon_sym_LBRACE,
  [24643] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(543), 1,
      sym_block_comment,
    ACTIONS(1409), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [24660] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(544), 1,
      sym_block_comment,
    ACTIONS(1281), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [24677] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1405), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_SEMI,
    STATE(545), 1,
      sym_block_comment,
  [24696] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(546), 1,
      sym_block_comment,
    ACTIONS(1166), 2,
      anon_sym_for,
      anon_sym_LBRACE,
  [24713] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1089), 1,
      anon_sym_LBRACE,
    STATE(280), 1,
      sym_braced_parameter_list,
    STATE(547), 1,
      sym_block_comment,
  [24732] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(548), 1,
      sym_block_comment,
    ACTIONS(1261), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [24749] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(549), 1,
      sym_block_comment,
    ACTIONS(1104), 2,
      anon_sym_for,
      anon_sym_LBRACE,
  [24766] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(550), 1,
      sym_block_comment,
    ACTIONS(1151), 2,
      anon_sym_for,
      anon_sym_LBRACE,
  [24783] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1230), 1,
      sym_identifier,
    STATE(551), 1,
      sym_block_comment,
    STATE(562), 1,
      sym_enum_member,
  [24802] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1124), 1,
      anon_sym_LPAREN,
    STATE(378), 1,
      sym_parameter_list,
    STATE(552), 1,
      sym_block_comment,
  [24821] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1153), 1,
      anon_sym_LBRACE,
    STATE(274), 1,
      sym_enum_body,
    STATE(553), 1,
      sym_block_comment,
  [24840] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1413), 1,
      anon_sym_port,
    ACTIONS(1415), 1,
      sym_identifier,
    STATE(554), 1,
      sym_block_comment,
  [24859] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(555), 1,
      sym_block_comment,
    ACTIONS(1212), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [24876] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(982), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1417), 1,
      anon_sym_SEMI,
    STATE(556), 1,
      sym_block_comment,
  [24895] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1207), 1,
      sym_identifier,
    STATE(555), 1,
      sym_named_turbofish_arg,
    STATE(557), 1,
      sym_block_comment,
  [24914] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1419), 1,
      anon_sym_inst,
    ACTIONS(1421), 1,
      sym_identifier,
    STATE(558), 1,
      sym_block_comment,
  [24933] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(559), 1,
      sym_block_comment,
    ACTIONS(1384), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [24950] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(560), 1,
      sym_block_comment,
    ACTIONS(1423), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [24967] = 6,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1425), 1,
      anon_sym_for,
    ACTIONS(1427), 1,
      anon_sym_LBRACE,
    STATE(561), 1,
      sym_block_comment,
  [24986] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(562), 1,
      sym_block_comment,
    ACTIONS(1235), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25003] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    STATE(563), 1,
      sym_block_comment,
    ACTIONS(848), 2,
      anon_sym_POUND,
      sym_identifier,
  [25020] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1429), 1,
      anon_sym_LBRACK,
    STATE(564), 1,
      sym_block_comment,
  [25036] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(982), 1,
      anon_sym_COLON_COLON,
    STATE(565), 1,
      sym_block_comment,
  [25052] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1431), 1,
      anon_sym_RPAREN,
    STATE(566), 1,
      sym_block_comment,
  [25068] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1433), 1,
      anon_sym_SEMI,
    STATE(567), 1,
      sym_block_comment,
  [25084] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1435), 1,
      sym_identifier,
    STATE(568), 1,
      sym_block_comment,
  [25100] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1437), 1,
      anon_sym_if,
    STATE(569), 1,
      sym_block_comment,
  [25116] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1439), 1,
      anon_sym_LBRACE,
    STATE(570), 1,
      sym_block_comment,
  [25132] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1441), 1,
      anon_sym_RBRACK,
    STATE(571), 1,
      sym_block_comment,
  [25148] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1443), 1,
      sym_identifier,
    STATE(572), 1,
      sym_block_comment,
  [25164] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1445), 1,
      anon_sym_RBRACE,
    STATE(573), 1,
      sym_block_comment,
  [25180] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1447), 1,
      anon_sym_EQ_GT,
    STATE(574), 1,
      sym_block_comment,
  [25196] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1449), 1,
      anon_sym_RPAREN,
    STATE(575), 1,
      sym_block_comment,
  [25212] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(725), 1,
      anon_sym_RPAREN_DOT,
    STATE(576), 1,
      sym_block_comment,
  [25228] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1451), 1,
      sym_identifier,
    STATE(577), 1,
      sym_block_comment,
  [25244] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1453), 1,
      anon_sym_COLON,
    STATE(578), 1,
      sym_block_comment,
  [25260] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1455), 1,
      anon_sym_RPAREN_DOT,
    STATE(579), 1,
      sym_block_comment,
  [25276] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1457), 1,
      anon_sym_EQ_GT,
    STATE(580), 1,
      sym_block_comment,
  [25292] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1459), 1,
      sym_identifier,
    STATE(581), 1,
      sym_block_comment,
  [25308] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1461), 1,
      anon_sym_LBRACE,
    STATE(582), 1,
      sym_block_comment,
  [25324] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(826), 1,
      anon_sym_RPAREN_DOT,
    STATE(583), 1,
      sym_block_comment,
  [25340] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(828), 1,
      anon_sym_RPAREN_DOT,
    STATE(584), 1,
      sym_block_comment,
  [25356] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(832), 1,
      anon_sym_RPAREN_DOT,
    STATE(585), 1,
      sym_block_comment,
  [25372] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(838), 1,
      anon_sym_RPAREN_DOT,
    STATE(586), 1,
      sym_block_comment,
  [25388] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1463), 1,
      sym_identifier,
    STATE(587), 1,
      sym_block_comment,
  [25404] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1465), 1,
      anon_sym_LBRACE,
    STATE(588), 1,
      sym_block_comment,
  [25420] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1467), 1,
      anon_sym_else,
    STATE(589), 1,
      sym_block_comment,
  [25436] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1469), 1,
      sym_identifier,
    STATE(590), 1,
      sym_block_comment,
  [25452] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1471), 1,
      anon_sym_SEMI,
    STATE(591), 1,
      sym_block_comment,
  [25468] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(824), 1,
      anon_sym_RPAREN_DOT,
    STATE(592), 1,
      sym_block_comment,
  [25484] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(840), 1,
      anon_sym_RPAREN_DOT,
    STATE(593), 1,
      sym_block_comment,
  [25500] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(836), 1,
      anon_sym_RPAREN_DOT,
    STATE(594), 1,
      sym_block_comment,
  [25516] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1473), 1,
      sym_identifier,
    STATE(595), 1,
      sym_block_comment,
  [25532] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(830), 1,
      anon_sym_RPAREN_DOT,
    STATE(596), 1,
      sym_block_comment,
  [25548] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(834), 1,
      anon_sym_RPAREN_DOT,
    STATE(597), 1,
      sym_block_comment,
  [25564] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1475), 1,
      sym_identifier,
    STATE(598), 1,
      sym_block_comment,
  [25580] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(820), 1,
      anon_sym_RPAREN_DOT,
    STATE(599), 1,
      sym_block_comment,
  [25596] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(822), 1,
      anon_sym_RPAREN_DOT,
    STATE(600), 1,
      sym_block_comment,
  [25612] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1477), 1,
      sym_identifier,
    STATE(601), 1,
      sym_block_comment,
  [25628] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(844), 1,
      anon_sym_RPAREN_DOT,
    STATE(602), 1,
      sym_block_comment,
  [25644] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(842), 1,
      anon_sym_RPAREN_DOT,
    STATE(603), 1,
      sym_block_comment,
  [25660] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1479), 1,
      anon_sym_LPAREN,
    STATE(604), 1,
      sym_block_comment,
  [25676] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1481), 1,
      anon_sym_RPAREN,
    STATE(605), 1,
      sym_block_comment,
  [25692] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1483), 1,
      ts_builtin_sym_end,
    STATE(606), 1,
      sym_block_comment,
  [25708] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1485), 1,
      anon_sym_COLON,
    STATE(607), 1,
      sym_block_comment,
  [25724] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1487), 1,
      anon_sym_else,
    STATE(608), 1,
      sym_block_comment,
  [25740] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1489), 1,
      anon_sym_LBRACE,
    STATE(609), 1,
      sym_block_comment,
  [25756] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1491), 1,
      anon_sym_RPAREN_DOT,
    STATE(610), 1,
      sym_block_comment,
  [25772] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1493), 1,
      sym_identifier,
    STATE(611), 1,
      sym_block_comment,
  [25788] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1495), 1,
      sym_identifier,
    STATE(612), 1,
      sym_block_comment,
  [25804] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1497), 1,
      anon_sym_LPAREN,
    STATE(613), 1,
      sym_block_comment,
  [25820] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1499), 1,
      sym_identifier,
    STATE(614), 1,
      sym_block_comment,
  [25836] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1501), 1,
      sym_identifier,
    STATE(615), 1,
      sym_block_comment,
  [25852] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1503), 1,
      anon_sym_else,
    STATE(616), 1,
      sym_block_comment,
  [25868] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1505), 1,
      sym_identifier,
    STATE(617), 1,
      sym_block_comment,
  [25884] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1507), 1,
      sym_identifier,
    STATE(618), 1,
      sym_block_comment,
  [25900] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1509), 1,
      anon_sym_SEMI,
    STATE(619), 1,
      sym_block_comment,
  [25916] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1511), 1,
      anon_sym_COLON,
    STATE(620), 1,
      sym_block_comment,
  [25932] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1513), 1,
      anon_sym_LBRACE,
    STATE(621), 1,
      sym_block_comment,
  [25948] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1515), 1,
      anon_sym_BQUOTE,
    STATE(622), 1,
      sym_block_comment,
  [25964] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1517), 1,
      anon_sym_EQ,
    STATE(623), 1,
      sym_block_comment,
  [25980] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1519), 1,
      sym_identifier,
    STATE(624), 1,
      sym_block_comment,
  [25996] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1521), 1,
      anon_sym_RBRACE,
    STATE(625), 1,
      sym_block_comment,
  [26012] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1523), 1,
      anon_sym_SEMI,
    STATE(626), 1,
      sym_block_comment,
  [26028] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1525), 1,
      sym_identifier,
    STATE(627), 1,
      sym_block_comment,
  [26044] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1527), 1,
      anon_sym_RBRACK,
    STATE(628), 1,
      sym_block_comment,
  [26060] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1529), 1,
      anon_sym_LPAREN,
    STATE(629), 1,
      sym_block_comment,
  [26076] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1531), 1,
      anon_sym_COLON,
    STATE(630), 1,
      sym_block_comment,
  [26092] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1533), 1,
      anon_sym_LPAREN,
    STATE(631), 1,
      sym_block_comment,
  [26108] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1535), 1,
      sym_identifier,
    STATE(632), 1,
      sym_block_comment,
  [26124] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1537), 1,
      anon_sym_RBRACK,
    STATE(633), 1,
      sym_block_comment,
  [26140] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1539), 1,
      sym_identifier,
    STATE(634), 1,
      sym_block_comment,
  [26156] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1541), 1,
      anon_sym_COLON_COLON,
    STATE(635), 1,
      sym_block_comment,
  [26172] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1543), 1,
      sym_identifier,
    STATE(636), 1,
      sym_block_comment,
  [26188] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1545), 1,
      anon_sym_EQ,
    STATE(637), 1,
      sym_block_comment,
  [26204] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1547), 1,
      anon_sym_LBRACE,
    STATE(638), 1,
      sym_block_comment,
  [26220] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1549), 1,
      sym_identifier,
    STATE(639), 1,
      sym_block_comment,
  [26236] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1551), 1,
      anon_sym_COLON_COLON,
    STATE(640), 1,
      sym_block_comment,
  [26252] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1553), 1,
      sym_identifier,
    STATE(641), 1,
      sym_block_comment,
  [26268] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1555), 1,
      sym_identifier,
    STATE(642), 1,
      sym_block_comment,
  [26284] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1557), 1,
      anon_sym_LBRACE,
    STATE(643), 1,
      sym_block_comment,
  [26300] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1559), 1,
      anon_sym_LBRACE,
    STATE(644), 1,
      sym_block_comment,
  [26316] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1561), 1,
      anon_sym_LBRACK,
    STATE(645), 1,
      sym_block_comment,
  [26332] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1563), 1,
      anon_sym_SEMI,
    STATE(646), 1,
      sym_block_comment,
  [26348] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1565), 1,
      anon_sym_LBRACE,
    STATE(647), 1,
      sym_block_comment,
  [26364] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1567), 1,
      sym_identifier,
    STATE(648), 1,
      sym_block_comment,
  [26380] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1405), 1,
      sym_identifier,
    STATE(649), 1,
      sym_block_comment,
  [26396] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1569), 1,
      sym_identifier,
    STATE(650), 1,
      sym_block_comment,
  [26412] = 5,
    ACTIONS(3), 1,
      sym_doc_comment,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1571), 1,
      anon_sym_RBRACK,
    STATE(651), 1,
      sym_block_comment,
  [26428] = 1,
    ACTIONS(1573), 1,
      ts_builtin_sym_end,
  [26432] = 1,
    ACTIONS(1575), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 110,
  [SMALL_STATE(6)] = 220,
  [SMALL_STATE(7)] = 330,
  [SMALL_STATE(8)] = 440,
  [SMALL_STATE(9)] = 550,
  [SMALL_STATE(10)] = 660,
  [SMALL_STATE(11)] = 770,
  [SMALL_STATE(12)] = 880,
  [SMALL_STATE(13)] = 990,
  [SMALL_STATE(14)] = 1097,
  [SMALL_STATE(15)] = 1204,
  [SMALL_STATE(16)] = 1311,
  [SMALL_STATE(17)] = 1418,
  [SMALL_STATE(18)] = 1525,
  [SMALL_STATE(19)] = 1632,
  [SMALL_STATE(20)] = 1739,
  [SMALL_STATE(21)] = 1846,
  [SMALL_STATE(22)] = 1953,
  [SMALL_STATE(23)] = 2060,
  [SMALL_STATE(24)] = 2167,
  [SMALL_STATE(25)] = 2274,
  [SMALL_STATE(26)] = 2381,
  [SMALL_STATE(27)] = 2488,
  [SMALL_STATE(28)] = 2595,
  [SMALL_STATE(29)] = 2702,
  [SMALL_STATE(30)] = 2765,
  [SMALL_STATE(31)] = 2872,
  [SMALL_STATE(32)] = 2979,
  [SMALL_STATE(33)] = 3086,
  [SMALL_STATE(34)] = 3193,
  [SMALL_STATE(35)] = 3300,
  [SMALL_STATE(36)] = 3405,
  [SMALL_STATE(37)] = 3512,
  [SMALL_STATE(38)] = 3619,
  [SMALL_STATE(39)] = 3726,
  [SMALL_STATE(40)] = 3833,
  [SMALL_STATE(41)] = 3940,
  [SMALL_STATE(42)] = 4047,
  [SMALL_STATE(43)] = 4154,
  [SMALL_STATE(44)] = 4261,
  [SMALL_STATE(45)] = 4368,
  [SMALL_STATE(46)] = 4475,
  [SMALL_STATE(47)] = 4582,
  [SMALL_STATE(48)] = 4689,
  [SMALL_STATE(49)] = 4796,
  [SMALL_STATE(50)] = 4903,
  [SMALL_STATE(51)] = 5010,
  [SMALL_STATE(52)] = 5117,
  [SMALL_STATE(53)] = 5224,
  [SMALL_STATE(54)] = 5284,
  [SMALL_STATE(55)] = 5344,
  [SMALL_STATE(56)] = 5404,
  [SMALL_STATE(57)] = 5481,
  [SMALL_STATE(58)] = 5564,
  [SMALL_STATE(59)] = 5655,
  [SMALL_STATE(60)] = 5744,
  [SMALL_STATE(61)] = 5831,
  [SMALL_STATE(62)] = 5938,
  [SMALL_STATE(63)] = 6035,
  [SMALL_STATE(64)] = 6140,
  [SMALL_STATE(65)] = 6217,
  [SMALL_STATE(66)] = 6316,
  [SMALL_STATE(67)] = 6417,
  [SMALL_STATE(68)] = 6520,
  [SMALL_STATE(69)] = 6596,
  [SMALL_STATE(70)] = 6665,
  [SMALL_STATE(71)] = 6734,
  [SMALL_STATE(72)] = 6788,
  [SMALL_STATE(73)] = 6844,
  [SMALL_STATE(74)] = 6898,
  [SMALL_STATE(75)] = 7005,
  [SMALL_STATE(76)] = 7107,
  [SMALL_STATE(77)] = 7208,
  [SMALL_STATE(78)] = 7313,
  [SMALL_STATE(79)] = 7418,
  [SMALL_STATE(80)] = 7523,
  [SMALL_STATE(81)] = 7623,
  [SMALL_STATE(82)] = 7725,
  [SMALL_STATE(83)] = 7775,
  [SMALL_STATE(84)] = 7877,
  [SMALL_STATE(85)] = 7977,
  [SMALL_STATE(86)] = 8079,
  [SMALL_STATE(87)] = 8181,
  [SMALL_STATE(88)] = 8283,
  [SMALL_STATE(89)] = 8385,
  [SMALL_STATE(90)] = 8484,
  [SMALL_STATE(91)] = 8583,
  [SMALL_STATE(92)] = 8682,
  [SMALL_STATE(93)] = 8781,
  [SMALL_STATE(94)] = 8880,
  [SMALL_STATE(95)] = 8979,
  [SMALL_STATE(96)] = 9078,
  [SMALL_STATE(97)] = 9177,
  [SMALL_STATE(98)] = 9276,
  [SMALL_STATE(99)] = 9375,
  [SMALL_STATE(100)] = 9474,
  [SMALL_STATE(101)] = 9573,
  [SMALL_STATE(102)] = 9672,
  [SMALL_STATE(103)] = 9771,
  [SMALL_STATE(104)] = 9870,
  [SMALL_STATE(105)] = 9969,
  [SMALL_STATE(106)] = 10068,
  [SMALL_STATE(107)] = 10167,
  [SMALL_STATE(108)] = 10219,
  [SMALL_STATE(109)] = 10271,
  [SMALL_STATE(110)] = 10318,
  [SMALL_STATE(111)] = 10365,
  [SMALL_STATE(112)] = 10412,
  [SMALL_STATE(113)] = 10459,
  [SMALL_STATE(114)] = 10506,
  [SMALL_STATE(115)] = 10553,
  [SMALL_STATE(116)] = 10600,
  [SMALL_STATE(117)] = 10647,
  [SMALL_STATE(118)] = 10694,
  [SMALL_STATE(119)] = 10741,
  [SMALL_STATE(120)] = 10788,
  [SMALL_STATE(121)] = 10835,
  [SMALL_STATE(122)] = 10882,
  [SMALL_STATE(123)] = 10929,
  [SMALL_STATE(124)] = 10976,
  [SMALL_STATE(125)] = 11023,
  [SMALL_STATE(126)] = 11070,
  [SMALL_STATE(127)] = 11117,
  [SMALL_STATE(128)] = 11164,
  [SMALL_STATE(129)] = 11211,
  [SMALL_STATE(130)] = 11258,
  [SMALL_STATE(131)] = 11305,
  [SMALL_STATE(132)] = 11352,
  [SMALL_STATE(133)] = 11399,
  [SMALL_STATE(134)] = 11446,
  [SMALL_STATE(135)] = 11493,
  [SMALL_STATE(136)] = 11540,
  [SMALL_STATE(137)] = 11587,
  [SMALL_STATE(138)] = 11634,
  [SMALL_STATE(139)] = 11681,
  [SMALL_STATE(140)] = 11728,
  [SMALL_STATE(141)] = 11775,
  [SMALL_STATE(142)] = 11822,
  [SMALL_STATE(143)] = 11873,
  [SMALL_STATE(144)] = 11920,
  [SMALL_STATE(145)] = 11967,
  [SMALL_STATE(146)] = 12014,
  [SMALL_STATE(147)] = 12061,
  [SMALL_STATE(148)] = 12108,
  [SMALL_STATE(149)] = 12155,
  [SMALL_STATE(150)] = 12201,
  [SMALL_STATE(151)] = 12247,
  [SMALL_STATE(152)] = 12293,
  [SMALL_STATE(153)] = 12339,
  [SMALL_STATE(154)] = 12385,
  [SMALL_STATE(155)] = 12431,
  [SMALL_STATE(156)] = 12477,
  [SMALL_STATE(157)] = 12523,
  [SMALL_STATE(158)] = 12568,
  [SMALL_STATE(159)] = 12642,
  [SMALL_STATE(160)] = 12717,
  [SMALL_STATE(161)] = 12792,
  [SMALL_STATE(162)] = 12867,
  [SMALL_STATE(163)] = 12933,
  [SMALL_STATE(164)] = 12995,
  [SMALL_STATE(165)] = 13057,
  [SMALL_STATE(166)] = 13121,
  [SMALL_STATE(167)] = 13183,
  [SMALL_STATE(168)] = 13245,
  [SMALL_STATE(169)] = 13307,
  [SMALL_STATE(170)] = 13369,
  [SMALL_STATE(171)] = 13407,
  [SMALL_STATE(172)] = 13469,
  [SMALL_STATE(173)] = 13531,
  [SMALL_STATE(174)] = 13593,
  [SMALL_STATE(175)] = 13631,
  [SMALL_STATE(176)] = 13669,
  [SMALL_STATE(177)] = 13707,
  [SMALL_STATE(178)] = 13745,
  [SMALL_STATE(179)] = 13783,
  [SMALL_STATE(180)] = 13821,
  [SMALL_STATE(181)] = 13859,
  [SMALL_STATE(182)] = 13897,
  [SMALL_STATE(183)] = 13935,
  [SMALL_STATE(184)] = 13973,
  [SMALL_STATE(185)] = 14035,
  [SMALL_STATE(186)] = 14073,
  [SMALL_STATE(187)] = 14135,
  [SMALL_STATE(188)] = 14197,
  [SMALL_STATE(189)] = 14259,
  [SMALL_STATE(190)] = 14321,
  [SMALL_STATE(191)] = 14383,
  [SMALL_STATE(192)] = 14442,
  [SMALL_STATE(193)] = 14501,
  [SMALL_STATE(194)] = 14560,
  [SMALL_STATE(195)] = 14619,
  [SMALL_STATE(196)] = 14678,
  [SMALL_STATE(197)] = 14737,
  [SMALL_STATE(198)] = 14796,
  [SMALL_STATE(199)] = 14857,
  [SMALL_STATE(200)] = 14916,
  [SMALL_STATE(201)] = 14975,
  [SMALL_STATE(202)] = 15034,
  [SMALL_STATE(203)] = 15093,
  [SMALL_STATE(204)] = 15152,
  [SMALL_STATE(205)] = 15211,
  [SMALL_STATE(206)] = 15270,
  [SMALL_STATE(207)] = 15329,
  [SMALL_STATE(208)] = 15388,
  [SMALL_STATE(209)] = 15447,
  [SMALL_STATE(210)] = 15506,
  [SMALL_STATE(211)] = 15565,
  [SMALL_STATE(212)] = 15624,
  [SMALL_STATE(213)] = 15683,
  [SMALL_STATE(214)] = 15742,
  [SMALL_STATE(215)] = 15801,
  [SMALL_STATE(216)] = 15857,
  [SMALL_STATE(217)] = 15912,
  [SMALL_STATE(218)] = 15967,
  [SMALL_STATE(219)] = 16022,
  [SMALL_STATE(220)] = 16077,
  [SMALL_STATE(221)] = 16132,
  [SMALL_STATE(222)] = 16185,
  [SMALL_STATE(223)] = 16240,
  [SMALL_STATE(224)] = 16295,
  [SMALL_STATE(225)] = 16350,
  [SMALL_STATE(226)] = 16405,
  [SMALL_STATE(227)] = 16460,
  [SMALL_STATE(228)] = 16515,
  [SMALL_STATE(229)] = 16570,
  [SMALL_STATE(230)] = 16625,
  [SMALL_STATE(231)] = 16680,
  [SMALL_STATE(232)] = 16732,
  [SMALL_STATE(233)] = 16784,
  [SMALL_STATE(234)] = 16836,
  [SMALL_STATE(235)] = 16888,
  [SMALL_STATE(236)] = 16917,
  [SMALL_STATE(237)] = 16950,
  [SMALL_STATE(238)] = 16979,
  [SMALL_STATE(239)] = 17008,
  [SMALL_STATE(240)] = 17037,
  [SMALL_STATE(241)] = 17065,
  [SMALL_STATE(242)] = 17093,
  [SMALL_STATE(243)] = 17121,
  [SMALL_STATE(244)] = 17149,
  [SMALL_STATE(245)] = 17177,
  [SMALL_STATE(246)] = 17205,
  [SMALL_STATE(247)] = 17233,
  [SMALL_STATE(248)] = 17261,
  [SMALL_STATE(249)] = 17289,
  [SMALL_STATE(250)] = 17317,
  [SMALL_STATE(251)] = 17345,
  [SMALL_STATE(252)] = 17373,
  [SMALL_STATE(253)] = 17401,
  [SMALL_STATE(254)] = 17429,
  [SMALL_STATE(255)] = 17457,
  [SMALL_STATE(256)] = 17485,
  [SMALL_STATE(257)] = 17513,
  [SMALL_STATE(258)] = 17541,
  [SMALL_STATE(259)] = 17573,
  [SMALL_STATE(260)] = 17601,
  [SMALL_STATE(261)] = 17629,
  [SMALL_STATE(262)] = 17657,
  [SMALL_STATE(263)] = 17685,
  [SMALL_STATE(264)] = 17713,
  [SMALL_STATE(265)] = 17741,
  [SMALL_STATE(266)] = 17769,
  [SMALL_STATE(267)] = 17797,
  [SMALL_STATE(268)] = 17825,
  [SMALL_STATE(269)] = 17853,
  [SMALL_STATE(270)] = 17881,
  [SMALL_STATE(271)] = 17909,
  [SMALL_STATE(272)] = 17937,
  [SMALL_STATE(273)] = 17965,
  [SMALL_STATE(274)] = 17993,
  [SMALL_STATE(275)] = 18021,
  [SMALL_STATE(276)] = 18049,
  [SMALL_STATE(277)] = 18077,
  [SMALL_STATE(278)] = 18105,
  [SMALL_STATE(279)] = 18133,
  [SMALL_STATE(280)] = 18161,
  [SMALL_STATE(281)] = 18189,
  [SMALL_STATE(282)] = 18216,
  [SMALL_STATE(283)] = 18243,
  [SMALL_STATE(284)] = 18270,
  [SMALL_STATE(285)] = 18297,
  [SMALL_STATE(286)] = 18324,
  [SMALL_STATE(287)] = 18351,
  [SMALL_STATE(288)] = 18378,
  [SMALL_STATE(289)] = 18405,
  [SMALL_STATE(290)] = 18432,
  [SMALL_STATE(291)] = 18459,
  [SMALL_STATE(292)] = 18486,
  [SMALL_STATE(293)] = 18513,
  [SMALL_STATE(294)] = 18540,
  [SMALL_STATE(295)] = 18567,
  [SMALL_STATE(296)] = 18593,
  [SMALL_STATE(297)] = 18619,
  [SMALL_STATE(298)] = 18655,
  [SMALL_STATE(299)] = 18684,
  [SMALL_STATE(300)] = 18713,
  [SMALL_STATE(301)] = 18741,
  [SMALL_STATE(302)] = 18776,
  [SMALL_STATE(303)] = 18813,
  [SMALL_STATE(304)] = 18848,
  [SMALL_STATE(305)] = 18879,
  [SMALL_STATE(306)] = 18914,
  [SMALL_STATE(307)] = 18949,
  [SMALL_STATE(308)] = 18984,
  [SMALL_STATE(309)] = 19019,
  [SMALL_STATE(310)] = 19054,
  [SMALL_STATE(311)] = 19091,
  [SMALL_STATE(312)] = 19126,
  [SMALL_STATE(313)] = 19161,
  [SMALL_STATE(314)] = 19196,
  [SMALL_STATE(315)] = 19231,
  [SMALL_STATE(316)] = 19266,
  [SMALL_STATE(317)] = 19301,
  [SMALL_STATE(318)] = 19334,
  [SMALL_STATE(319)] = 19359,
  [SMALL_STATE(320)] = 19394,
  [SMALL_STATE(321)] = 19429,
  [SMALL_STATE(322)] = 19460,
  [SMALL_STATE(323)] = 19485,
  [SMALL_STATE(324)] = 19522,
  [SMALL_STATE(325)] = 19545,
  [SMALL_STATE(326)] = 19568,
  [SMALL_STATE(327)] = 19591,
  [SMALL_STATE(328)] = 19614,
  [SMALL_STATE(329)] = 19649,
  [SMALL_STATE(330)] = 19672,
  [SMALL_STATE(331)] = 19695,
  [SMALL_STATE(332)] = 19718,
  [SMALL_STATE(333)] = 19741,
  [SMALL_STATE(334)] = 19774,
  [SMALL_STATE(335)] = 19809,
  [SMALL_STATE(336)] = 19844,
  [SMALL_STATE(337)] = 19879,
  [SMALL_STATE(338)] = 19914,
  [SMALL_STATE(339)] = 19949,
  [SMALL_STATE(340)] = 19984,
  [SMALL_STATE(341)] = 20019,
  [SMALL_STATE(342)] = 20054,
  [SMALL_STATE(343)] = 20078,
  [SMALL_STATE(344)] = 20102,
  [SMALL_STATE(345)] = 20126,
  [SMALL_STATE(346)] = 20160,
  [SMALL_STATE(347)] = 20192,
  [SMALL_STATE(348)] = 20226,
  [SMALL_STATE(349)] = 20250,
  [SMALL_STATE(350)] = 20274,
  [SMALL_STATE(351)] = 20308,
  [SMALL_STATE(352)] = 20342,
  [SMALL_STATE(353)] = 20376,
  [SMALL_STATE(354)] = 20410,
  [SMALL_STATE(355)] = 20436,
  [SMALL_STATE(356)] = 20460,
  [SMALL_STATE(357)] = 20494,
  [SMALL_STATE(358)] = 20518,
  [SMALL_STATE(359)] = 20542,
  [SMALL_STATE(360)] = 20566,
  [SMALL_STATE(361)] = 20590,
  [SMALL_STATE(362)] = 20614,
  [SMALL_STATE(363)] = 20638,
  [SMALL_STATE(364)] = 20662,
  [SMALL_STATE(365)] = 20686,
  [SMALL_STATE(366)] = 20720,
  [SMALL_STATE(367)] = 20744,
  [SMALL_STATE(368)] = 20768,
  [SMALL_STATE(369)] = 20802,
  [SMALL_STATE(370)] = 20826,
  [SMALL_STATE(371)] = 20855,
  [SMALL_STATE(372)] = 20884,
  [SMALL_STATE(373)] = 20911,
  [SMALL_STATE(374)] = 20940,
  [SMALL_STATE(375)] = 20967,
  [SMALL_STATE(376)] = 20994,
  [SMALL_STATE(377)] = 21021,
  [SMALL_STATE(378)] = 21050,
  [SMALL_STATE(379)] = 21077,
  [SMALL_STATE(380)] = 21108,
  [SMALL_STATE(381)] = 21139,
  [SMALL_STATE(382)] = 21165,
  [SMALL_STATE(383)] = 21193,
  [SMALL_STATE(384)] = 21219,
  [SMALL_STATE(385)] = 21247,
  [SMALL_STATE(386)] = 21267,
  [SMALL_STATE(387)] = 21293,
  [SMALL_STATE(388)] = 21313,
  [SMALL_STATE(389)] = 21333,
  [SMALL_STATE(390)] = 21355,
  [SMALL_STATE(391)] = 21379,
  [SMALL_STATE(392)] = 21407,
  [SMALL_STATE(393)] = 21427,
  [SMALL_STATE(394)] = 21451,
  [SMALL_STATE(395)] = 21479,
  [SMALL_STATE(396)] = 21503,
  [SMALL_STATE(397)] = 21529,
  [SMALL_STATE(398)] = 21555,
  [SMALL_STATE(399)] = 21583,
  [SMALL_STATE(400)] = 21609,
  [SMALL_STATE(401)] = 21637,
  [SMALL_STATE(402)] = 21657,
  [SMALL_STATE(403)] = 21685,
  [SMALL_STATE(404)] = 21705,
  [SMALL_STATE(405)] = 21731,
  [SMALL_STATE(406)] = 21756,
  [SMALL_STATE(407)] = 21775,
  [SMALL_STATE(408)] = 21800,
  [SMALL_STATE(409)] = 21823,
  [SMALL_STATE(410)] = 21842,
  [SMALL_STATE(411)] = 21867,
  [SMALL_STATE(412)] = 21888,
  [SMALL_STATE(413)] = 21907,
  [SMALL_STATE(414)] = 21932,
  [SMALL_STATE(415)] = 21955,
  [SMALL_STATE(416)] = 21980,
  [SMALL_STATE(417)] = 22005,
  [SMALL_STATE(418)] = 22030,
  [SMALL_STATE(419)] = 22049,
  [SMALL_STATE(420)] = 22074,
  [SMALL_STATE(421)] = 22093,
  [SMALL_STATE(422)] = 22116,
  [SMALL_STATE(423)] = 22141,
  [SMALL_STATE(424)] = 22164,
  [SMALL_STATE(425)] = 22183,
  [SMALL_STATE(426)] = 22202,
  [SMALL_STATE(427)] = 22227,
  [SMALL_STATE(428)] = 22252,
  [SMALL_STATE(429)] = 22271,
  [SMALL_STATE(430)] = 22296,
  [SMALL_STATE(431)] = 22321,
  [SMALL_STATE(432)] = 22340,
  [SMALL_STATE(433)] = 22365,
  [SMALL_STATE(434)] = 22390,
  [SMALL_STATE(435)] = 22411,
  [SMALL_STATE(436)] = 22434,
  [SMALL_STATE(437)] = 22459,
  [SMALL_STATE(438)] = 22478,
  [SMALL_STATE(439)] = 22501,
  [SMALL_STATE(440)] = 22526,
  [SMALL_STATE(441)] = 22551,
  [SMALL_STATE(442)] = 22574,
  [SMALL_STATE(443)] = 22593,
  [SMALL_STATE(444)] = 22612,
  [SMALL_STATE(445)] = 22637,
  [SMALL_STATE(446)] = 22659,
  [SMALL_STATE(447)] = 22681,
  [SMALL_STATE(448)] = 22703,
  [SMALL_STATE(449)] = 22723,
  [SMALL_STATE(450)] = 22745,
  [SMALL_STATE(451)] = 22767,
  [SMALL_STATE(452)] = 22787,
  [SMALL_STATE(453)] = 22809,
  [SMALL_STATE(454)] = 22831,
  [SMALL_STATE(455)] = 22853,
  [SMALL_STATE(456)] = 22875,
  [SMALL_STATE(457)] = 22897,
  [SMALL_STATE(458)] = 22915,
  [SMALL_STATE(459)] = 22935,
  [SMALL_STATE(460)] = 22953,
  [SMALL_STATE(461)] = 22975,
  [SMALL_STATE(462)] = 22995,
  [SMALL_STATE(463)] = 23013,
  [SMALL_STATE(464)] = 23033,
  [SMALL_STATE(465)] = 23051,
  [SMALL_STATE(466)] = 23069,
  [SMALL_STATE(467)] = 23089,
  [SMALL_STATE(468)] = 23111,
  [SMALL_STATE(469)] = 23133,
  [SMALL_STATE(470)] = 23155,
  [SMALL_STATE(471)] = 23175,
  [SMALL_STATE(472)] = 23197,
  [SMALL_STATE(473)] = 23219,
  [SMALL_STATE(474)] = 23239,
  [SMALL_STATE(475)] = 23261,
  [SMALL_STATE(476)] = 23279,
  [SMALL_STATE(477)] = 23301,
  [SMALL_STATE(478)] = 23323,
  [SMALL_STATE(479)] = 23345,
  [SMALL_STATE(480)] = 23367,
  [SMALL_STATE(481)] = 23387,
  [SMALL_STATE(482)] = 23409,
  [SMALL_STATE(483)] = 23431,
  [SMALL_STATE(484)] = 23453,
  [SMALL_STATE(485)] = 23475,
  [SMALL_STATE(486)] = 23495,
  [SMALL_STATE(487)] = 23517,
  [SMALL_STATE(488)] = 23535,
  [SMALL_STATE(489)] = 23557,
  [SMALL_STATE(490)] = 23577,
  [SMALL_STATE(491)] = 23599,
  [SMALL_STATE(492)] = 23621,
  [SMALL_STATE(493)] = 23641,
  [SMALL_STATE(494)] = 23661,
  [SMALL_STATE(495)] = 23679,
  [SMALL_STATE(496)] = 23701,
  [SMALL_STATE(497)] = 23723,
  [SMALL_STATE(498)] = 23745,
  [SMALL_STATE(499)] = 23767,
  [SMALL_STATE(500)] = 23789,
  [SMALL_STATE(501)] = 23811,
  [SMALL_STATE(502)] = 23829,
  [SMALL_STATE(503)] = 23851,
  [SMALL_STATE(504)] = 23873,
  [SMALL_STATE(505)] = 23891,
  [SMALL_STATE(506)] = 23913,
  [SMALL_STATE(507)] = 23931,
  [SMALL_STATE(508)] = 23949,
  [SMALL_STATE(509)] = 23971,
  [SMALL_STATE(510)] = 23989,
  [SMALL_STATE(511)] = 24011,
  [SMALL_STATE(512)] = 24031,
  [SMALL_STATE(513)] = 24053,
  [SMALL_STATE(514)] = 24075,
  [SMALL_STATE(515)] = 24097,
  [SMALL_STATE(516)] = 24119,
  [SMALL_STATE(517)] = 24141,
  [SMALL_STATE(518)] = 24163,
  [SMALL_STATE(519)] = 24185,
  [SMALL_STATE(520)] = 24207,
  [SMALL_STATE(521)] = 24229,
  [SMALL_STATE(522)] = 24251,
  [SMALL_STATE(523)] = 24271,
  [SMALL_STATE(524)] = 24293,
  [SMALL_STATE(525)] = 24313,
  [SMALL_STATE(526)] = 24335,
  [SMALL_STATE(527)] = 24357,
  [SMALL_STATE(528)] = 24379,
  [SMALL_STATE(529)] = 24399,
  [SMALL_STATE(530)] = 24414,
  [SMALL_STATE(531)] = 24431,
  [SMALL_STATE(532)] = 24448,
  [SMALL_STATE(533)] = 24465,
  [SMALL_STATE(534)] = 24484,
  [SMALL_STATE(535)] = 24503,
  [SMALL_STATE(536)] = 24522,
  [SMALL_STATE(537)] = 24539,
  [SMALL_STATE(538)] = 24556,
  [SMALL_STATE(539)] = 24573,
  [SMALL_STATE(540)] = 24590,
  [SMALL_STATE(541)] = 24609,
  [SMALL_STATE(542)] = 24626,
  [SMALL_STATE(543)] = 24643,
  [SMALL_STATE(544)] = 24660,
  [SMALL_STATE(545)] = 24677,
  [SMALL_STATE(546)] = 24696,
  [SMALL_STATE(547)] = 24713,
  [SMALL_STATE(548)] = 24732,
  [SMALL_STATE(549)] = 24749,
  [SMALL_STATE(550)] = 24766,
  [SMALL_STATE(551)] = 24783,
  [SMALL_STATE(552)] = 24802,
  [SMALL_STATE(553)] = 24821,
  [SMALL_STATE(554)] = 24840,
  [SMALL_STATE(555)] = 24859,
  [SMALL_STATE(556)] = 24876,
  [SMALL_STATE(557)] = 24895,
  [SMALL_STATE(558)] = 24914,
  [SMALL_STATE(559)] = 24933,
  [SMALL_STATE(560)] = 24950,
  [SMALL_STATE(561)] = 24967,
  [SMALL_STATE(562)] = 24986,
  [SMALL_STATE(563)] = 25003,
  [SMALL_STATE(564)] = 25020,
  [SMALL_STATE(565)] = 25036,
  [SMALL_STATE(566)] = 25052,
  [SMALL_STATE(567)] = 25068,
  [SMALL_STATE(568)] = 25084,
  [SMALL_STATE(569)] = 25100,
  [SMALL_STATE(570)] = 25116,
  [SMALL_STATE(571)] = 25132,
  [SMALL_STATE(572)] = 25148,
  [SMALL_STATE(573)] = 25164,
  [SMALL_STATE(574)] = 25180,
  [SMALL_STATE(575)] = 25196,
  [SMALL_STATE(576)] = 25212,
  [SMALL_STATE(577)] = 25228,
  [SMALL_STATE(578)] = 25244,
  [SMALL_STATE(579)] = 25260,
  [SMALL_STATE(580)] = 25276,
  [SMALL_STATE(581)] = 25292,
  [SMALL_STATE(582)] = 25308,
  [SMALL_STATE(583)] = 25324,
  [SMALL_STATE(584)] = 25340,
  [SMALL_STATE(585)] = 25356,
  [SMALL_STATE(586)] = 25372,
  [SMALL_STATE(587)] = 25388,
  [SMALL_STATE(588)] = 25404,
  [SMALL_STATE(589)] = 25420,
  [SMALL_STATE(590)] = 25436,
  [SMALL_STATE(591)] = 25452,
  [SMALL_STATE(592)] = 25468,
  [SMALL_STATE(593)] = 25484,
  [SMALL_STATE(594)] = 25500,
  [SMALL_STATE(595)] = 25516,
  [SMALL_STATE(596)] = 25532,
  [SMALL_STATE(597)] = 25548,
  [SMALL_STATE(598)] = 25564,
  [SMALL_STATE(599)] = 25580,
  [SMALL_STATE(600)] = 25596,
  [SMALL_STATE(601)] = 25612,
  [SMALL_STATE(602)] = 25628,
  [SMALL_STATE(603)] = 25644,
  [SMALL_STATE(604)] = 25660,
  [SMALL_STATE(605)] = 25676,
  [SMALL_STATE(606)] = 25692,
  [SMALL_STATE(607)] = 25708,
  [SMALL_STATE(608)] = 25724,
  [SMALL_STATE(609)] = 25740,
  [SMALL_STATE(610)] = 25756,
  [SMALL_STATE(611)] = 25772,
  [SMALL_STATE(612)] = 25788,
  [SMALL_STATE(613)] = 25804,
  [SMALL_STATE(614)] = 25820,
  [SMALL_STATE(615)] = 25836,
  [SMALL_STATE(616)] = 25852,
  [SMALL_STATE(617)] = 25868,
  [SMALL_STATE(618)] = 25884,
  [SMALL_STATE(619)] = 25900,
  [SMALL_STATE(620)] = 25916,
  [SMALL_STATE(621)] = 25932,
  [SMALL_STATE(622)] = 25948,
  [SMALL_STATE(623)] = 25964,
  [SMALL_STATE(624)] = 25980,
  [SMALL_STATE(625)] = 25996,
  [SMALL_STATE(626)] = 26012,
  [SMALL_STATE(627)] = 26028,
  [SMALL_STATE(628)] = 26044,
  [SMALL_STATE(629)] = 26060,
  [SMALL_STATE(630)] = 26076,
  [SMALL_STATE(631)] = 26092,
  [SMALL_STATE(632)] = 26108,
  [SMALL_STATE(633)] = 26124,
  [SMALL_STATE(634)] = 26140,
  [SMALL_STATE(635)] = 26156,
  [SMALL_STATE(636)] = 26172,
  [SMALL_STATE(637)] = 26188,
  [SMALL_STATE(638)] = 26204,
  [SMALL_STATE(639)] = 26220,
  [SMALL_STATE(640)] = 26236,
  [SMALL_STATE(641)] = 26252,
  [SMALL_STATE(642)] = 26268,
  [SMALL_STATE(643)] = 26284,
  [SMALL_STATE(644)] = 26300,
  [SMALL_STATE(645)] = 26316,
  [SMALL_STATE(646)] = 26332,
  [SMALL_STATE(647)] = 26348,
  [SMALL_STATE(648)] = 26364,
  [SMALL_STATE(649)] = 26380,
  [SMALL_STATE(650)] = 26396,
  [SMALL_STATE(651)] = 26412,
  [SMALL_STATE(652)] = 26428,
  [SMALL_STATE(653)] = 26432,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [9] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(632),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(569),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(604),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(636),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int_literal, 1, 0, 0),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_int_literal, 1, 0, 0),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3, 0, 0),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3, 0, 0),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 2, 0, 0),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 2, 0, 0),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 4, 0, 0),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 4, 0, 0),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, 0, 0),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, 0, 0),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0),
  [153] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(233),
  [156] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(516),
  [159] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(34),
  [162] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(632),
  [165] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(642),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(648),
  [171] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(36),
  [174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0),
  [176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_base_expression, 1, 0, 0),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_base_expression, 1, 0, 0),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_access, 3, 0, 0),
  [190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_access, 3, 0, 0),
  [192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scoped_identifier, 2, 0, 1),
  [194] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scoped_identifier, 2, 0, 1),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__scoped_or_raw_ident, 1, 0, 0),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__scoped_or_raw_ident, 1, 0, 0),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__path, 1, 0, 0),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scoped_identifier, 3, 0, 2),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scoped_identifier, 3, 0, 2),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_where_clause, 4, 0, 0),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_where_clause_repeat1, 4, 0, 0),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_literal_repeat1, 2, 0, 0),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__positional_argument_list_repeat1, 2, 0, 0),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_argument, 3, 0, 0),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_match_arm, 3, 0, 12),
  [246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_binding, 4, 0, 0),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_statement, 4, 0, 0),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_statement, 2, 0, 0),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reg_statement, 7, 0, 0),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_binding, 6, 0, 0),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reg_statement, 8, 0, 0),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reg_statement, 9, 0, 0),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reg_statement, 10, 0, 0),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comptime_if, 6, 0, 0),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comptime_if, 6, 0, 0),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comptime_if, 7, 0, 0),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comptime_if, 7, 0, 0),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stage_reference, 6, 0, 0),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stage_reference, 6, 0, 0),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stage_reference, 5, 0, 8),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stage_reference, 5, 0, 8),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 5, 0, 9),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 5, 0, 9),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 5, 0, 5),
  [304] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 5, 0, 5),
  [306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_argument_list, 4, 0, 0),
  [308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_argument_list, 4, 0, 0),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 4, 0, 0),
  [312] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 4, 0, 0),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 3, 0, 0),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 3, 0, 0),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_argument_list, 4, 0, 0),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_argument_list, 4, 0, 0),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 2, 0, 0),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 2, 0, 0),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 6, 0, 0),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 6, 0, 0),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, 0, 0),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, 0, 0),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_argument_list, 2, 0, 0),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_argument_list, 2, 0, 0),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_expression, 3, 0, 0),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_expression, 3, 0, 0),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_if_expression, 6, 0, 0),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_if_expression, 6, 0, 0),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_block, 2, 0, 0),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_block, 2, 0, 0),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_block, 3, 0, 0),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_block, 3, 0, 0),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipeline_instance, 6, 0, 0),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipeline_instance, 6, 0, 0),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_expression, 5, 0, 0),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_expression, 5, 0, 0),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 6, 0, 9),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 6, 0, 9),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_argument_list, 5, 0, 0),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_argument_list, 5, 0, 0),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_instance, 3, 0, 0),
  [372] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_entity_instance, 3, 0, 0),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_argument_list, 5, 0, 0),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_argument_list, 5, 0, 0),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 7, 0, 0),
  [380] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 7, 0, 0),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_instance, 4, 0, 0),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_entity_instance, 4, 0, 0),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 4, 0, 0),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index, 4, 0, 0),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_argument_list, 2, 0, 0),
  [392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_argument_list, 2, 0, 0),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 4, 0, 5),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 4, 0, 5),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipeline_instance, 7, 0, 0),
  [400] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipeline_instance, 7, 0, 0),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_argument_list, 3, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_argument_list, 3, 0, 0),
  [406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1, 0, 0),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 1, 0, 0),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_argument_list, 3, 0, 0),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_argument_list, 3, 0, 0),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 4, 0, 0),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 4, 0, 0),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__base_expression, 1, 0, 0),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__base_expression, 1, 0, 0),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 5, 0, 0),
  [428] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 5, 0, 0),
  [430] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 3, 0, 0),
  [432] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 3, 0, 0),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 5, 0, 0),
  [436] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 5, 0, 0),
  [438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_naked_gen_if_expression, 5, 0, 0),
  [440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_naked_gen_if_expression, 5, 0, 0),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paren_expression, 3, 0, 0),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paren_expression, 3, 0, 0),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_block, 4, 0, 0),
  [448] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_block, 4, 0, 0),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comptime_if, 8, 0, 0),
  [452] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comptime_if, 8, 0, 0),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1, 0, 0),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1, 0, 0),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 2, 0, 0),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 2, 0, 0),
  [462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 1, 0, 0),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 1, 0, 0),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comptime_else, 3, 0, 0),
  [468] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comptime_else, 3, 0, 0),
  [470] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipeline_stage_name, 2, 0, 0),
  [472] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipeline_stage_name, 2, 0, 0),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comptime_else, 4, 0, 0),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comptime_else, 4, 0, 0),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [484] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(564),
  [487] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(598),
  [490] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(613),
  [493] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(554),
  [496] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(624),
  [499] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(350),
  [502] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(391),
  [505] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(426),
  [508] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(595),
  [511] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(615),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [532] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [534] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(406),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_custom_infix, 3, 0, 0),
  [560] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_custom_infix, 3, 0, 0),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_mul, 1, 0, 0),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_mul, 1, 0, 0),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_add, 1, 0, 0),
  [574] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_add, 1, 0, 0),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__op_mul_like, 1, 0, 0),
  [578] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__op_mul_like, 1, 0, 0),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__op_eq_like, 1, 0, 0),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__op_eq_like, 1, 0, 0),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_lt, 1, 0, 0),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_lt, 1, 0, 0),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_gt, 1, 0, 0),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_gt, 1, 0, 0),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__op_relational, 1, 0, 0),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__op_relational, 1, 0, 0),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__op_shifty, 1, 0, 0),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__op_shifty, 1, 0, 0),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_bitwise_and, 1, 0, 0),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_bitwise_and, 1, 0, 0),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__op_add_like, 1, 0, 0),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__op_add_like, 1, 0, 0),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_sub, 1, 0, 0),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_sub, 1, 0, 0),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [632] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [634] = {.entry = {.count = 1, .reusable = false}}, SHIFT(538),
  [636] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [638] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_match_block_repeat1, 2, 0, 0), SHIFT_REPEAT(225),
  [641] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_match_block_repeat1, 2, 0, 0), SHIFT_REPEAT(82),
  [644] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_match_block_repeat1, 2, 0, 0), SHIFT_REPEAT(72),
  [647] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_match_block_repeat1, 2, 0, 0), SHIFT_REPEAT(636),
  [650] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_match_block_repeat1, 2, 0, 0), SHIFT_REPEAT(29),
  [653] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_match_block_repeat1, 2, 0, 0), SHIFT_REPEAT(29),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [680] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(233),
  [683] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(516),
  [686] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(34),
  [689] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(632),
  [692] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(618),
  [695] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(650),
  [698] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2, 0, 0), SHIFT_REPEAT(36),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_parameter_list, 4, 0, 0),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1, 0, 0),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_parameter_list, 2, 0, 0),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_parameter_list, 3, 0, 0),
  [733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_parameter_list, 5, 0, 0),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 5, 0, 0),
  [737] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 4, 0, 0),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait, 4, 0, 0),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_marker, 1, 0, 0),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unit_definition, 2, 0, 0),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 4, 0, 0),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__body_or_builtin, 1, 0, 0),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 3, 0, 0),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comptime_config, 4, 0, 0),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 1, 0, 0),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 5, 0, 0),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 7, 0, 6),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 7, 0, 0),
  [761] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 7, 0, 4),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 7, 0, 7),
  [765] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_type, 1, 0, 0),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__base_type, 1, 0, 0),
  [769] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 2, 0, 0),
  [771] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__item_repeat1, 2, 0, 0), SHIFT_REPEAT(564),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__item_repeat1, 2, 0, 0),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 3, 0, 0),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 3, 0, 0),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 5, 0, 0),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 8, 0, 6),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 8, 0, 10),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 8, 0, 11),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 8, 0, 7),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 9, 0, 10),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 9, 0, 11),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 9, 0, 13),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 4, 0, 0),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use, 3, 0, 0),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2, 0, 0),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 10, 0, 13),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1, 0, 0),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_definition, 4, 0, 0),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait, 5, 0, 0),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 4, 0, 0),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 6, 0, 0),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_impl, 6, 0, 4),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait, 6, 0, 0),
  [818] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_definition, 5, 0, 0),
  [820] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type, 5, 0, 0),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 5, 0, 0),
  [824] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 3, 0, 0),
  [826] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 2, 0, 0),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_wire, 2, 0, 0),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 4, 0, 0),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inverted, 2, 0, 0),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__generic_list, 3, 0, 0),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__generic_list, 2, 0, 0),
  [838] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 2, 0, 0),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 3, 0, 0),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__generic_list, 5, 0, 0),
  [844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__generic_list, 4, 0, 0),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__item_repeat1, 1, 0, 0),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 4, 0, 0),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 1, 0, 0),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 1, 0, 0),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(644),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_arm, 4, 0, 0),
  [862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_match_arm, 4, 0, 12),
  [864] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_arm, 4, 0, 0),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(645),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [872] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [874] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [902] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_impl_repeat1, 2, 0, 0), SHIFT_REPEAT(598),
  [905] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_impl_repeat1, 2, 0, 0), SHIFT_REPEAT(613),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_impl_repeat1, 2, 0, 0),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_match_block_repeat1, 1, 0, 0),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_match_block_repeat1, 1, 0, 0),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [920] = {.entry = {.count = 1, .reusable = false}}, SHIFT(636),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [924] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trait_repeat1, 2, 0, 0), SHIFT_REPEAT(598),
  [927] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trait_repeat1, 2, 0, 0), SHIFT_REPEAT(613),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_trait_repeat1, 2, 0, 0),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_pattern_list, 5, 0, 0),
  [946] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_pattern_list, 5, 0, 0),
  [948] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_pattern_list, 3, 0, 0),
  [950] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_pattern_list, 3, 0, 0),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_pattern_list, 2, 0, 0),
  [954] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_pattern_list, 2, 0, 0),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_unpack, 2, 0, 0),
  [970] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_unpack, 2, 0, 0),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_pattern_list, 5, 0, 0),
  [974] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_pattern_list, 5, 0, 0),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__path, 1, 0, 0),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_pattern, 2, 0, 0),
  [988] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_pattern, 2, 0, 0),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_pattern_list, 2, 0, 0),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_pattern_list, 2, 0, 0),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_pattern, 3, 0, 0),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_pattern, 3, 0, 0),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_pattern_list, 4, 0, 0),
  [1000] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_pattern_list, 4, 0, 0),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_positional_unpack, 2, 0, 0),
  [1004] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_positional_unpack, 2, 0, 0),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_pattern, 4, 0, 0),
  [1008] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_pattern, 4, 0, 0),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_pattern, 5, 0, 0),
  [1014] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_pattern, 5, 0, 0),
  [1016] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_pattern_list, 3, 0, 0),
  [1018] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_pattern_list, 3, 0, 0),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_pattern_list, 4, 0, 0),
  [1024] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__positional_pattern_list, 4, 0, 0),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unit_head, 3, 0, 0),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_reg_statement_repeat1, 2, 0, 0),
  [1046] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_reg_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(629),
  [1049] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_reg_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(631),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unit_head, 4, 0, 0),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1060] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4, 0, 0),
  [1062] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3, 0, 0),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 7, 0, 0),
  [1066] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_where_clause_repeat1, 2, 0, 0),
  [1068] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_where_clause_repeat1, 2, 0, 0), SHIFT_REPEAT(612),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unit_head, 5, 0, 0),
  [1073] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 6, 0, 0),
  [1075] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unit_head, 6, 0, 0),
  [1077] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_where_clause, 5, 0, 0),
  [1079] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 5, 0, 0),
  [1081] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2, 0, 0),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1087] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 1, 0, 0),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1091] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_turbofish, 5, 0, 0),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1099] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 0),
  [1101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(380),
  [1104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_parameters, 4, 0, 0),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_where_clause, 1, 0, 0),
  [1110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_where_clause, 1, 0, 0),
  [1112] = {.entry = {.count = 1, .reusable = false}}, SHIFT(607),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_impl_repeat1, 1, 0, 0),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unit_declaration, 2, 0, 0),
  [1132] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__item_repeat1, 2, 0, 0), SHIFT_REPEAT(645),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_parameters, 2, 0, 0),
  [1139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_turbofish, 2, 0, 0),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_trait_repeat1, 1, 0, 0),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_parameters, 5, 0, 0),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(38),
  [1158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_turbofish, 4, 0, 0),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_parameters, 3, 0, 0),
  [1168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_turbofish, 3, 0, 0),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_turbofish_arg, 1, 0, 0),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_argument, 1, 0, 0),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1202] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__positional_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(45),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_parameter, 3, 0, 0),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1209] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_turbofish_repeat2, 2, 0, 0), SHIFT_REPEAT(557),
  [1212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_turbofish_repeat2, 2, 0, 0),
  [1214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__named_argument_list_repeat1, 2, 0, 0),
  [1216] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__named_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(484),
  [1219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_turbofish_repeat1, 2, 0, 0),
  [1221] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_turbofish_repeat1, 2, 0, 0), SHIFT_REPEAT(208),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1232] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(551),
  [1235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__named_pattern_list_repeat1, 2, 0, 0),
  [1243] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__named_pattern_list_repeat1, 2, 0, 0), SHIFT_REPEAT(488),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_reg_statement_repeat1, 1, 0, 0),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_generic_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(471),
  [1261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_generic_parameters_repeat1, 2, 0, 0),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decl_statement, 2, 0, 0),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_pattern_param, 1, 0, 0),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1, 0, 0),
  [1281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_decl_statement_repeat1, 2, 0, 0),
  [1283] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_decl_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(649),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1292] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [1294] = {.entry = {.count = 1, .reusable = false}}, SHIFT(529),
  [1296] = {.entry = {.count = 1, .reusable = false}}, SHIFT(653),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reg_initial, 4, 0, 0),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1322] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 2, 0, 0), SHIFT_REPEAT(529),
  [1325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 2, 0, 0),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reg_reset, 6, 0, 0),
  [1331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_parameter, 4, 0, 0),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unit_head, 7, 0, 0),
  [1337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decl_statement, 3, 0, 0),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1341] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__comptime_operator, 1, 0, 0),
  [1343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comptime_operator, 1, 0, 0),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipeline_reg_marker, 1, 0, 0),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1379] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_turbofish_repeat1, 2, 0, 0), SHIFT_REPEAT(209),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_pattern_repeat1, 2, 0, 0),
  [1386] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tuple_pattern_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(652),
  [1395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 1, 0, 0),
  [1397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_pattern_param, 3, 0, 0),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 2, 0, 0),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [1407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_turbofish_arg, 3, 0, 0),
  [1409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_param, 3, 0, 3),
  [1411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decl_statement, 4, 0, 0),
  [1413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(590),
  [1415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(432),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(641),
  [1421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [1423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_param, 1, 0, 0),
  [1425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipeline_reg_marker, 3, 0, 0),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1483] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pipeline_start, 4, 0, 0),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_comment, 2, 0, 0),
  [1575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_comment, 3, 0, 0),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_spade(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
