#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 307
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 146
#define ALIAS_COUNT 1
#define TOKEN_COUNT 83
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 14
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 27

enum ts_symbol_identifiers {
  anon_sym_pragma = 1,
  anon_sym_custom_templates = 2,
  anon_sym_circom = 3,
  sym_circom_version = 4,
  anon_sym_include = 5,
  anon_sym_DQUOTE = 6,
  anon_sym_SQUOTE = 7,
  sym__escape_sequence = 8,
  sym__string_immediate_elt_inside_double_quote = 9,
  sym__string_immediate_elt_inside_quote = 10,
  anon_sym_template = 11,
  anon_sym_LBRACE = 12,
  anon_sym_RBRACE = 13,
  anon_sym_function = 14,
  anon_sym_LPAREN = 15,
  anon_sym_COMMA = 16,
  anon_sym_RPAREN = 17,
  anon_sym_component = 18,
  anon_sym_main = 19,
  anon_sym_EQ = 20,
  anon_sym_public = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_if = 24,
  anon_sym_else = 25,
  anon_sym_for = 26,
  anon_sym_while = 27,
  anon_sym_return = 28,
  anon_sym_signal = 29,
  anon_sym_LT_EQ_EQ = 30,
  anon_sym_LT_DASH_DASH = 31,
  anon_sym_input = 32,
  anon_sym_output = 33,
  anon_sym_var = 34,
  anon_sym_EQ_EQ_GT = 35,
  anon_sym_DASH_DASH_GT = 36,
  anon_sym_AMP_EQ = 37,
  anon_sym_PLUS_EQ = 38,
  anon_sym_DASH_EQ = 39,
  anon_sym_STAR_EQ = 40,
  anon_sym_STAR_STAR_EQ = 41,
  anon_sym_SLASH_EQ = 42,
  anon_sym_BSLASH_EQ = 43,
  anon_sym_PERCENT_EQ = 44,
  anon_sym_PIPE_EQ = 45,
  anon_sym_CARET_EQ = 46,
  anon_sym_GT_GT_EQ = 47,
  anon_sym_LT_LT_EQ = 48,
  anon_sym_EQ_EQ_EQ = 49,
  anon_sym_PLUS_PLUS = 50,
  anon_sym_DASH_DASH = 51,
  anon_sym_DOT = 52,
  anon_sym_QMARK = 53,
  anon_sym_COLON = 54,
  anon_sym_BANG = 55,
  anon_sym_TILDE = 56,
  anon_sym_DASH = 57,
  anon_sym_PLUS = 58,
  anon_sym_AMP_AMP = 59,
  anon_sym_AMP = 60,
  anon_sym_PIPE_PIPE = 61,
  anon_sym_PIPE = 62,
  anon_sym_GT_GT = 63,
  anon_sym_LT_LT = 64,
  anon_sym_CARET = 65,
  anon_sym_STAR = 66,
  anon_sym_SLASH = 67,
  anon_sym_BSLASH = 68,
  anon_sym_PERCENT = 69,
  anon_sym_STAR_STAR = 70,
  anon_sym_LT = 71,
  anon_sym_LT_EQ = 72,
  anon_sym_EQ_EQ = 73,
  anon_sym_BANG_EQ = 74,
  anon_sym_GT_EQ = 75,
  anon_sym_GT = 76,
  anon_sym_SEMI = 77,
  sym_identifier = 78,
  sym_int_literal = 79,
  sym_custom = 80,
  sym_parallel = 81,
  sym_comment = 82,
  sym_source_file = 83,
  sym__source_unit = 84,
  sym__directive = 85,
  sym_pragma_directive = 86,
  sym_circom_custom_templates_token = 87,
  sym_circom_pragma_token = 88,
  sym__circom = 89,
  sym_include_directive = 90,
  sym_string = 91,
  sym__definition = 92,
  sym_template_definition = 93,
  sym_template_type = 94,
  sym_template_body = 95,
  sym_function_definition = 96,
  sym_function_body = 97,
  sym_parameter_list = 98,
  sym_parameter = 99,
  sym_main_component_definition = 100,
  sym_main_component_public_signals = 101,
  sym__statement = 102,
  sym_block_statement = 103,
  sym_expression_statement = 104,
  sym_if_statement = 105,
  sym_for_statement = 106,
  sym_while_statement = 107,
  sym_return_statement = 108,
  sym_signal_declaration_statement = 109,
  sym__signal_declaration = 110,
  sym_signal_visibility = 111,
  sym_signal_tags = 112,
  sym_variable_declaration_statement = 113,
  sym__variable_declaration = 114,
  sym_component_declaration_statement = 115,
  sym__component_declaration = 116,
  sym_array_type = 117,
  sym__expression = 118,
  sym_array_expression = 119,
  sym_tuple_expression = 120,
  sym_assignment_expression = 121,
  sym_increment_expression = 122,
  sym_decrement_expression = 123,
  sym_call_expression = 124,
  sym_anonymous_inputs = 125,
  sym_argument_list = 126,
  sym_member_expression = 127,
  sym_array_access_expression = 128,
  sym_parenthesized_expression = 129,
  sym_ternary_expression = 130,
  sym_unary_expression = 131,
  sym_binary_expression = 132,
  sym__semicolon = 133,
  aux_sym_source_file_repeat1 = 134,
  aux_sym_string_repeat1 = 135,
  aux_sym_string_repeat2 = 136,
  aux_sym_template_body_repeat1 = 137,
  aux_sym_parameter_list_repeat1 = 138,
  aux_sym_signal_declaration_statement_repeat1 = 139,
  aux_sym_signal_tags_repeat1 = 140,
  aux_sym_variable_declaration_statement_repeat1 = 141,
  aux_sym_component_declaration_statement_repeat1 = 142,
  aux_sym_array_type_repeat1 = 143,
  aux_sym_array_expression_repeat1 = 144,
  aux_sym_argument_list_repeat1 = 145,
  alias_sym_property_identifier = 146,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_pragma] = "pragma",
  [anon_sym_custom_templates] = "custom_templates",
  [anon_sym_circom] = "circom",
  [sym_circom_version] = "circom_version",
  [anon_sym_include] = "include",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym__escape_sequence] = "_escape_sequence",
  [sym__string_immediate_elt_inside_double_quote] = "_string_immediate_elt_inside_double_quote",
  [sym__string_immediate_elt_inside_quote] = "_string_immediate_elt_inside_quote",
  [anon_sym_template] = "template",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_component] = "component",
  [anon_sym_main] = "main",
  [anon_sym_EQ] = "=",
  [anon_sym_public] = "public",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_while] = "while",
  [anon_sym_return] = "return",
  [anon_sym_signal] = "signal",
  [anon_sym_LT_EQ_EQ] = "<==",
  [anon_sym_LT_DASH_DASH] = "<--",
  [anon_sym_input] = "input",
  [anon_sym_output] = "output",
  [anon_sym_var] = "var",
  [anon_sym_EQ_EQ_GT] = "==>",
  [anon_sym_DASH_DASH_GT] = "-->",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_BSLASH_EQ] = "\\=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DOT] = ".",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PIPE] = "|",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_CARET] = "^",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_SEMI] = ";",
  [sym_identifier] = "identifier",
  [sym_int_literal] = "int_literal",
  [sym_custom] = "custom",
  [sym_parallel] = "parallel",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__source_unit] = "_source_unit",
  [sym__directive] = "_directive",
  [sym_pragma_directive] = "pragma_directive",
  [sym_circom_custom_templates_token] = "circom_custom_templates_token",
  [sym_circom_pragma_token] = "circom_pragma_token",
  [sym__circom] = "_circom",
  [sym_include_directive] = "include_directive",
  [sym_string] = "string",
  [sym__definition] = "_definition",
  [sym_template_definition] = "template_definition",
  [sym_template_type] = "template_type",
  [sym_template_body] = "template_body",
  [sym_function_definition] = "function_definition",
  [sym_function_body] = "function_body",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter] = "parameter",
  [sym_main_component_definition] = "main_component_definition",
  [sym_main_component_public_signals] = "main_component_public_signals",
  [sym__statement] = "_statement",
  [sym_block_statement] = "block_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_return_statement] = "return_statement",
  [sym_signal_declaration_statement] = "signal_declaration_statement",
  [sym__signal_declaration] = "_signal_declaration",
  [sym_signal_visibility] = "signal_visibility",
  [sym_signal_tags] = "signal_tags",
  [sym_variable_declaration_statement] = "variable_declaration_statement",
  [sym__variable_declaration] = "_variable_declaration",
  [sym_component_declaration_statement] = "component_declaration_statement",
  [sym__component_declaration] = "_component_declaration",
  [sym_array_type] = "array_type",
  [sym__expression] = "_expression",
  [sym_array_expression] = "array_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_increment_expression] = "increment_expression",
  [sym_decrement_expression] = "decrement_expression",
  [sym_call_expression] = "call_expression",
  [sym_anonymous_inputs] = "anonymous_inputs",
  [sym_argument_list] = "argument_list",
  [sym_member_expression] = "member_expression",
  [sym_array_access_expression] = "array_access_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__semicolon] = "_semicolon",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_body_repeat1] = "template_body_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_signal_declaration_statement_repeat1] = "signal_declaration_statement_repeat1",
  [aux_sym_signal_tags_repeat1] = "signal_tags_repeat1",
  [aux_sym_variable_declaration_statement_repeat1] = "variable_declaration_statement_repeat1",
  [aux_sym_component_declaration_statement_repeat1] = "component_declaration_statement_repeat1",
  [aux_sym_array_type_repeat1] = "array_type_repeat1",
  [aux_sym_array_expression_repeat1] = "array_expression_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [alias_sym_property_identifier] = "property_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_pragma] = anon_sym_pragma,
  [anon_sym_custom_templates] = anon_sym_custom_templates,
  [anon_sym_circom] = anon_sym_circom,
  [sym_circom_version] = sym_circom_version,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym__string_immediate_elt_inside_double_quote] = sym__string_immediate_elt_inside_double_quote,
  [sym__string_immediate_elt_inside_quote] = sym__string_immediate_elt_inside_quote,
  [anon_sym_template] = anon_sym_template,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_component] = anon_sym_component,
  [anon_sym_main] = anon_sym_main,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_signal] = anon_sym_signal,
  [anon_sym_LT_EQ_EQ] = anon_sym_LT_EQ_EQ,
  [anon_sym_LT_DASH_DASH] = anon_sym_LT_DASH_DASH,
  [anon_sym_input] = anon_sym_input,
  [anon_sym_output] = anon_sym_output,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_EQ_EQ_GT] = anon_sym_EQ_EQ_GT,
  [anon_sym_DASH_DASH_GT] = anon_sym_DASH_DASH_GT,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_BSLASH_EQ] = anon_sym_BSLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_identifier] = sym_identifier,
  [sym_int_literal] = sym_int_literal,
  [sym_custom] = sym_custom,
  [sym_parallel] = sym_parallel,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__source_unit] = sym__source_unit,
  [sym__directive] = sym__directive,
  [sym_pragma_directive] = sym_pragma_directive,
  [sym_circom_custom_templates_token] = sym_circom_custom_templates_token,
  [sym_circom_pragma_token] = sym_circom_pragma_token,
  [sym__circom] = sym__circom,
  [sym_include_directive] = sym_include_directive,
  [sym_string] = sym_string,
  [sym__definition] = sym__definition,
  [sym_template_definition] = sym_template_definition,
  [sym_template_type] = sym_template_type,
  [sym_template_body] = sym_template_body,
  [sym_function_definition] = sym_function_definition,
  [sym_function_body] = sym_function_body,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter] = sym_parameter,
  [sym_main_component_definition] = sym_main_component_definition,
  [sym_main_component_public_signals] = sym_main_component_public_signals,
  [sym__statement] = sym__statement,
  [sym_block_statement] = sym_block_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_signal_declaration_statement] = sym_signal_declaration_statement,
  [sym__signal_declaration] = sym__signal_declaration,
  [sym_signal_visibility] = sym_signal_visibility,
  [sym_signal_tags] = sym_signal_tags,
  [sym_variable_declaration_statement] = sym_variable_declaration_statement,
  [sym__variable_declaration] = sym__variable_declaration,
  [sym_component_declaration_statement] = sym_component_declaration_statement,
  [sym__component_declaration] = sym__component_declaration,
  [sym_array_type] = sym_array_type,
  [sym__expression] = sym__expression,
  [sym_array_expression] = sym_array_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_increment_expression] = sym_increment_expression,
  [sym_decrement_expression] = sym_decrement_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_anonymous_inputs] = sym_anonymous_inputs,
  [sym_argument_list] = sym_argument_list,
  [sym_member_expression] = sym_member_expression,
  [sym_array_access_expression] = sym_array_access_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__semicolon] = sym__semicolon,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_body_repeat1] = aux_sym_template_body_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_signal_declaration_statement_repeat1] = aux_sym_signal_declaration_statement_repeat1,
  [aux_sym_signal_tags_repeat1] = aux_sym_signal_tags_repeat1,
  [aux_sym_variable_declaration_statement_repeat1] = aux_sym_variable_declaration_statement_repeat1,
  [aux_sym_component_declaration_statement_repeat1] = aux_sym_component_declaration_statement_repeat1,
  [aux_sym_array_type_repeat1] = aux_sym_array_type_repeat1,
  [aux_sym_array_expression_repeat1] = aux_sym_array_expression_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_pragma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_custom_templates] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_circom] = {
    .visible = true,
    .named = false,
  },
  [sym_circom_version] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__string_immediate_elt_inside_double_quote] = {
    .visible = false,
    .named = true,
  },
  [sym__string_immediate_elt_inside_quote] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_template] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_component] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_main] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_input] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_output] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_custom] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__source_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym_pragma_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_circom_custom_templates_token] = {
    .visible = true,
    .named = true,
  },
  [sym_circom_pragma_token] = {
    .visible = true,
    .named = true,
  },
  [sym__circom] = {
    .visible = false,
    .named = true,
  },
  [sym_include_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_template_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_main_component_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_main_component_public_signals] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_signal_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__signal_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_signal_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_signal_tags] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_component_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__component_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_increment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decrement_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_inputs] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_signal_declaration_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_signal_tags_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_component_declaration_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_base = 2,
  field_body = 3,
  field_index = 4,
  field_left = 5,
  field_name = 6,
  field_object = 7,
  field_operator = 8,
  field_property = 9,
  field_right = 10,
  field_source = 11,
  field_type = 12,
  field_value = 13,
  field_version = 14,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_base] = "base",
  [field_body] = "body",
  [field_index] = "index",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_type] = "type",
  [field_value] = "value",
  [field_version] = "version",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 3},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 1},
  [9] = {.index = 12, .length = 1},
  [10] = {.index = 13, .length = 2},
  [11] = {.index = 15, .length = 3},
  [12] = {.index = 18, .length = 2},
  [13] = {.index = 20, .length = 1},
  [14] = {.index = 21, .length = 3},
  [15] = {.index = 24, .length = 2},
  [16] = {.index = 26, .length = 2},
  [17] = {.index = 28, .length = 6},
  [18] = {.index = 34, .length = 6},
  [19] = {.index = 40, .length = 3},
  [20] = {.index = 43, .length = 2},
  [21] = {.index = 45, .length = 1},
  [22] = {.index = 46, .length = 2},
  [23] = {.index = 48, .length = 3},
  [24] = {.index = 51, .length = 6},
  [25] = {.index = 57, .length = 3},
  [26] = {.index = 60, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_version, 1},
  [1] =
    {field_source, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 3},
    {field_name, 1},
  [5] =
    {field_body, 4},
    {field_name, 2},
    {field_type, 1},
  [8] =
    {field_value, 3},
  [9] =
    {field_argument, 1},
    {field_operator, 0},
  [11] =
    {field_argument, 0},
  [12] =
    {field_value, 4},
  [13] =
    {field_name, 0},
    {field_type, 1},
  [15] =
    {field_name, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [18] =
    {field_object, 0},
    {field_property, 2},
  [20] =
    {field_base, 0},
  [21] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [24] =
    {field_argument, 0},
    {field_argument, 1, .inherited = true},
  [26] =
    {field_name, 0},
    {field_value, 2},
  [28] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [34] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [40] =
    {field_name, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [43] =
    {field_base, 0},
    {field_index, 2},
  [45] =
    {field_argument, 1},
  [46] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [48] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 3},
  [51] =
    {field_name, 2, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type, 3, .inherited = true},
    {field_value, 2, .inherited = true},
    {field_value, 3, .inherited = true},
  [57] =
    {field_name, 3, .inherited = true},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [60] =
    {field_name, 3, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3, .inherited = true},
    {field_type, 4, .inherited = true},
    {field_value, 3, .inherited = true},
    {field_value, 4, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [12] = {
    [2] = alias_sym_property_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 35,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 38,
  [43] = 35,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 50,
  [53] = 51,
  [54] = 54,
  [55] = 47,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 54,
  [62] = 45,
  [63] = 63,
  [64] = 63,
  [65] = 65,
  [66] = 65,
  [67] = 67,
  [68] = 68,
  [69] = 68,
  [70] = 67,
  [71] = 71,
  [72] = 71,
  [73] = 73,
  [74] = 73,
  [75] = 75,
  [76] = 75,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 81,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 85,
  [88] = 88,
  [89] = 86,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 90,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 111,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 122,
  [132] = 123,
  [133] = 113,
  [134] = 110,
  [135] = 118,
  [136] = 129,
  [137] = 119,
  [138] = 115,
  [139] = 109,
  [140] = 112,
  [141] = 117,
  [142] = 128,
  [143] = 124,
  [144] = 127,
  [145] = 125,
  [146] = 130,
  [147] = 126,
  [148] = 116,
  [149] = 120,
  [150] = 114,
  [151] = 151,
  [152] = 152,
  [153] = 114,
  [154] = 113,
  [155] = 112,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 156,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 176,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 177,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 184,
  [194] = 194,
  [195] = 195,
  [196] = 180,
  [197] = 179,
  [198] = 185,
  [199] = 178,
  [200] = 186,
  [201] = 201,
  [202] = 177,
  [203] = 203,
  [204] = 176,
  [205] = 205,
  [206] = 192,
  [207] = 207,
  [208] = 208,
  [209] = 187,
  [210] = 190,
  [211] = 211,
  [212] = 208,
  [213] = 211,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 242,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 241,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 257,
  [261] = 261,
  [262] = 262,
  [263] = 241,
  [264] = 264,
  [265] = 265,
  [266] = 262,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 285,
  [302] = 302,
  [303] = 303,
  [304] = 284,
  [305] = 305,
  [306] = 282,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(128);
      ADVANCE_MAP(
        '!', 214,
        '"', 138,
        '%', 232,
        '&', 223,
        '\'', 139,
        '(', 163,
        ')', 165,
        '*', 229,
        '+', 220,
        ',', 164,
        '-', 217,
        '.', 210,
        '/', 230,
        ':', 212,
        ';', 240,
        '<', 234,
        '=', 169,
        '>', 239,
        '?', 211,
        '[', 171,
        '\\', 231,
        ']', 172,
        '^', 228,
        'c', 54,
        'e', 63,
        'f', 85,
        'i', 50,
        'm', 26,
        'o', 115,
        'p', 28,
        'r', 44,
        's', 56,
        't', 48,
        'v', 29,
        'w', 53,
        '{', 160,
        '|', 225,
        '}', 161,
        '~', 215,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(15);
      if (lookahead == '"') ADVANCE(138);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '\\') ADVANCE(2);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(150);
      if (lookahead != 0) ADVANCE(151);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(145);
      if (lookahead == '\r') ADVANCE(141);
      if (lookahead == 'u') ADVANCE(127);
      if (lookahead == 'x') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(144);
      if (lookahead != 0) ADVANCE(140);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(16);
      if (lookahead == '\'') ADVANCE(139);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\\') ADVANCE(4);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(157);
      if (lookahead != 0) ADVANCE(158);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(152);
      if (lookahead == '\r') ADVANCE(142);
      if (lookahead == 'u') ADVANCE(127);
      if (lookahead == 'x') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(144);
      if (lookahead != 0) ADVANCE(140);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        ' ', 5,
        '\'', 6,
        '.', 7,
        '/', 18,
        'c', 289,
        'p', 241,
        '$', 120,
        '_', 120,
      );
      if (('\t' <= lookahead && lookahead <= '\r')) SKIP(5);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 6:
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == '.') ADVANCE(7);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 7:
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 8:
      if (lookahead == ' ') ADVANCE(122);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(133);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 22,
        '%', 232,
        '&', 223,
        '(', 163,
        ')', 165,
        '*', 229,
        '+', 220,
        ',', 164,
        '-', 217,
        '.', 210,
        '/', 230,
        ':', 212,
        ';', 240,
        '<', 234,
        '=', 169,
        '>', 239,
        '?', 211,
        '[', 171,
        '\\', 231,
        ']', 172,
        '^', 228,
        'i', 263,
        'o', 287,
        '{', 160,
        '|', 225,
        '$', 120,
        '_', 120,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 22,
        '%', 232,
        '&', 223,
        '(', 163,
        ')', 165,
        '*', 229,
        '+', 221,
        ',', 164,
        '-', 218,
        '.', 210,
        '/', 230,
        ':', 212,
        ';', 240,
        '<', 234,
        '=', 169,
        '>', 239,
        '?', 211,
        '[', 171,
        '\\', 231,
        ']', 172,
        '^', 228,
        'c', 55,
        '|', 225,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 213,
        '(', 163,
        ')', 165,
        '+', 219,
        '-', 216,
        '/', 18,
        ';', 240,
        '[', 171,
        ']', 172,
        'p', 241,
        '~', 215,
        '$', 120,
        '_', 120,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 213,
        '(', 163,
        '+', 219,
        '-', 216,
        '/', 18,
        ';', 240,
        '[', 171,
        'p', 241,
        'v', 243,
        '~', 215,
        '$', 120,
        '_', 120,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 213,
        '(', 163,
        '+', 219,
        '-', 216,
        '/', 18,
        '[', 171,
        'c', 268,
        'e', 257,
        'f', 269,
        'i', 250,
        'p', 241,
        'r', 247,
        's', 253,
        'v', 243,
        'w', 252,
        '{', 160,
        '}', 161,
        '~', 215,
        '$', 120,
        '_', 120,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 213,
        '(', 163,
        '+', 219,
        '-', 216,
        '/', 18,
        '[', 171,
        'c', 268,
        'f', 269,
        'i', 250,
        'p', 241,
        'r', 247,
        's', 253,
        'v', 243,
        'w', 252,
        '{', 160,
        '}', 161,
        '~', 215,
        '$', 120,
        '_', 120,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(138);
      if (lookahead == '/') ADVANCE(18);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      END_STATE();
    case 16:
      if (lookahead == '\'') ADVANCE(139);
      if (lookahead == '/') ADVANCE(18);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      END_STATE();
    case 17:
      if (lookahead == ')') ADVANCE(165);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '{') ADVANCE(160);
      if (lookahead == '$' ||
          lookahead == '_') ADVANCE(120);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(299);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 20:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(186);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(237);
      END_STATE();
    case 23:
      if (lookahead == '>') ADVANCE(194);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(114);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'r') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(97);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(110);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(111);
      END_STATE();
    case 34:
      if (lookahead == 'b') ADVANCE(66);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(86);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(170);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(64);
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(109);
      END_STATE();
    case 39:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 50:
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(76);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(84);
      END_STATE();
    case 53:
      if (lookahead == 'h') ADVANCE(59);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'o') ADVANCE(71);
      if (lookahead == 'u') ADVANCE(102);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'u') ADVANCE(103);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(36);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(90);
      END_STATE();
    case 61:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(296);
      END_STATE();
    case 63:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(116);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(58);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(32);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(47);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(91);
      END_STATE();
    case 72:
      if (lookahead == 'm') ADVANCE(131);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(294);
      END_STATE();
    case 74:
      if (lookahead == 'm') ADVANCE(24);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(92);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(25);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(94);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(168);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(162);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(96);
      if (lookahead == 'u') ADVANCE(81);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 91:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 92:
      if (lookahead == 'p') ADVANCE(67);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(119);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(70);
      END_STATE();
    case 95:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 99:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 100:
      if (lookahead == 's') ADVANCE(130);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(40);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 115:
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 116:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 117:
      if (lookahead == 'u') ADVANCE(99);
      END_STATE();
    case 118:
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 119:
      if (lookahead == 'u') ADVANCE(105);
      END_STATE();
    case 120:
      if (lookahead == '$' ||
          lookahead == '_') ADVANCE(120);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 121:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 122:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(133);
      END_STATE();
    case 123:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 124:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(140);
      END_STATE();
    case 125:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(124);
      END_STATE();
    case 126:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 127:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_pragma);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_custom_templates);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_circom);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_circom_version);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_circom_version);
      if (lookahead == ' ') ADVANCE(135);
      if (lookahead == '\'') ADVANCE(132);
      if (lookahead == '.') ADVANCE(123);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_circom_version);
      if (lookahead == '\'') ADVANCE(132);
      if (lookahead == '.') ADVANCE(8);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_circom_version);
      if (lookahead == '\'') ADVANCE(132);
      if (lookahead == '.') ADVANCE(123);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_circom_version);
      if (lookahead == '\'') ADVANCE(132);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym__escape_sequence);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(145);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(152);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_double_quote);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_double_quote);
      if (lookahead == '\r') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_double_quote);
      if (lookahead == '*') ADVANCE(149);
      if (lookahead == '/') ADVANCE(146);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_double_quote);
      if (lookahead == '*') ADVANCE(148);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(149);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_double_quote);
      if (lookahead == '*') ADVANCE(148);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(149);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_double_quote);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(150);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_double_quote);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_quote);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_quote);
      if (lookahead == '\r') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_quote);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_quote);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_quote);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_quote);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(157);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym__string_immediate_elt_inside_quote);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_template);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_component);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_component);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_main);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(236);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_signal);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_signal);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LT_EQ_EQ);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_LT_DASH_DASH);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_input);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_input);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_output);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_output);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_var);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_GT);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_GT);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_BSLASH_EQ);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '>') ADVANCE(194);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(237);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(209);
      if (lookahead == '=') ADVANCE(197);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '=') ADVANCE(197);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(208);
      if (lookahead == '=') ADVANCE(196);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(196);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(222);
      if (lookahead == '=') ADVANCE(195);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '|') ADVANCE(224);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(205);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(206);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(204);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(233);
      if (lookahead == '=') ADVANCE(198);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(299);
      if (lookahead == '=') ADVANCE(200);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '=') ADVANCE(201);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(202);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(199);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(227);
      if (lookahead == '=') ADVANCE(235);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '=') ADVANCE(185);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(193);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(238);
      if (lookahead == '>') ADVANCE(226);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(277);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(260);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(276);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(255);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(176);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(284);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(256);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(266);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(267);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(254);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(251);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(258);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(184);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(297);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(279);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(248);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(259);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(295);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(272);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(273);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(182);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(249);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(283);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(244);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(262);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(275);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(261);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(265);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(271);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(288);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(178);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(192);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(242);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(264);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(246);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(285);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(188);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(190);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(167);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(291);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(270);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(274);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(286);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(281);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(280);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(282);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(278);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_custom);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_custom);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_parallel);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_parallel);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(292);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(299);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 9},
  [3] = {.lex_state = 9},
  [4] = {.lex_state = 10},
  [5] = {.lex_state = 10},
  [6] = {.lex_state = 9},
  [7] = {.lex_state = 9},
  [8] = {.lex_state = 10},
  [9] = {.lex_state = 9},
  [10] = {.lex_state = 10},
  [11] = {.lex_state = 10},
  [12] = {.lex_state = 10},
  [13] = {.lex_state = 10},
  [14] = {.lex_state = 10},
  [15] = {.lex_state = 10},
  [16] = {.lex_state = 10},
  [17] = {.lex_state = 10},
  [18] = {.lex_state = 10},
  [19] = {.lex_state = 10},
  [20] = {.lex_state = 10},
  [21] = {.lex_state = 10},
  [22] = {.lex_state = 10},
  [23] = {.lex_state = 10},
  [24] = {.lex_state = 10},
  [25] = {.lex_state = 10},
  [26] = {.lex_state = 10},
  [27] = {.lex_state = 10},
  [28] = {.lex_state = 10},
  [29] = {.lex_state = 10},
  [30] = {.lex_state = 10},
  [31] = {.lex_state = 10},
  [32] = {.lex_state = 10},
  [33] = {.lex_state = 10},
  [34] = {.lex_state = 10},
  [35] = {.lex_state = 10},
  [36] = {.lex_state = 10},
  [37] = {.lex_state = 10},
  [38] = {.lex_state = 10},
  [39] = {.lex_state = 10},
  [40] = {.lex_state = 10},
  [41] = {.lex_state = 10},
  [42] = {.lex_state = 10},
  [43] = {.lex_state = 10},
  [44] = {.lex_state = 10},
  [45] = {.lex_state = 10},
  [46] = {.lex_state = 14},
  [47] = {.lex_state = 10},
  [48] = {.lex_state = 10},
  [49] = {.lex_state = 10},
  [50] = {.lex_state = 14},
  [51] = {.lex_state = 14},
  [52] = {.lex_state = 14},
  [53] = {.lex_state = 14},
  [54] = {.lex_state = 10},
  [55] = {.lex_state = 10},
  [56] = {.lex_state = 14},
  [57] = {.lex_state = 14},
  [58] = {.lex_state = 10},
  [59] = {.lex_state = 14},
  [60] = {.lex_state = 14},
  [61] = {.lex_state = 10},
  [62] = {.lex_state = 10},
  [63] = {.lex_state = 14},
  [64] = {.lex_state = 14},
  [65] = {.lex_state = 14},
  [66] = {.lex_state = 14},
  [67] = {.lex_state = 14},
  [68] = {.lex_state = 14},
  [69] = {.lex_state = 14},
  [70] = {.lex_state = 14},
  [71] = {.lex_state = 14},
  [72] = {.lex_state = 14},
  [73] = {.lex_state = 12},
  [74] = {.lex_state = 12},
  [75] = {.lex_state = 11},
  [76] = {.lex_state = 11},
  [77] = {.lex_state = 11},
  [78] = {.lex_state = 11},
  [79] = {.lex_state = 11},
  [80] = {.lex_state = 11},
  [81] = {.lex_state = 11},
  [82] = {.lex_state = 11},
  [83] = {.lex_state = 11},
  [84] = {.lex_state = 11},
  [85] = {.lex_state = 11},
  [86] = {.lex_state = 11},
  [87] = {.lex_state = 11},
  [88] = {.lex_state = 11},
  [89] = {.lex_state = 11},
  [90] = {.lex_state = 11},
  [91] = {.lex_state = 11},
  [92] = {.lex_state = 11},
  [93] = {.lex_state = 11},
  [94] = {.lex_state = 11},
  [95] = {.lex_state = 11},
  [96] = {.lex_state = 11},
  [97] = {.lex_state = 11},
  [98] = {.lex_state = 11},
  [99] = {.lex_state = 11},
  [100] = {.lex_state = 11},
  [101] = {.lex_state = 11},
  [102] = {.lex_state = 11},
  [103] = {.lex_state = 11},
  [104] = {.lex_state = 11},
  [105] = {.lex_state = 11},
  [106] = {.lex_state = 11},
  [107] = {.lex_state = 11},
  [108] = {.lex_state = 11},
  [109] = {.lex_state = 13},
  [110] = {.lex_state = 13},
  [111] = {.lex_state = 13},
  [112] = {.lex_state = 13},
  [113] = {.lex_state = 13},
  [114] = {.lex_state = 13},
  [115] = {.lex_state = 13},
  [116] = {.lex_state = 13},
  [117] = {.lex_state = 13},
  [118] = {.lex_state = 13},
  [119] = {.lex_state = 13},
  [120] = {.lex_state = 13},
  [121] = {.lex_state = 13},
  [122] = {.lex_state = 13},
  [123] = {.lex_state = 13},
  [124] = {.lex_state = 13},
  [125] = {.lex_state = 13},
  [126] = {.lex_state = 13},
  [127] = {.lex_state = 13},
  [128] = {.lex_state = 13},
  [129] = {.lex_state = 13},
  [130] = {.lex_state = 13},
  [131] = {.lex_state = 14},
  [132] = {.lex_state = 14},
  [133] = {.lex_state = 14},
  [134] = {.lex_state = 14},
  [135] = {.lex_state = 14},
  [136] = {.lex_state = 14},
  [137] = {.lex_state = 14},
  [138] = {.lex_state = 14},
  [139] = {.lex_state = 14},
  [140] = {.lex_state = 14},
  [141] = {.lex_state = 14},
  [142] = {.lex_state = 14},
  [143] = {.lex_state = 14},
  [144] = {.lex_state = 14},
  [145] = {.lex_state = 14},
  [146] = {.lex_state = 14},
  [147] = {.lex_state = 14},
  [148] = {.lex_state = 14},
  [149] = {.lex_state = 14},
  [150] = {.lex_state = 14},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 11},
  [154] = {.lex_state = 11},
  [155] = {.lex_state = 11},
  [156] = {.lex_state = 9},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 9},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 0},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 10},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 0},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 5},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 3},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 3},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 3},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 17},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 17},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 11},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 11},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 17},
  [229] = {.lex_state = 11},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 11},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 17},
  [242] = {.lex_state = 17},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 17},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 17},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 17},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 17},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 17},
  [257] = {.lex_state = 17},
  [258] = {.lex_state = 17},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 17},
  [261] = {.lex_state = 17},
  [262] = {.lex_state = 17},
  [263] = {.lex_state = 17},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 17},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 17},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 17},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 17},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 17},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 17},
  [291] = {.lex_state = 17},
  [292] = {.lex_state = 17},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 5},
  [297] = {.lex_state = 17},
  [298] = {.lex_state = 17},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 17},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_pragma] = ACTIONS(1),
    [anon_sym_circom] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_template] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_component] = ACTIONS(1),
    [anon_sym_main] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_signal] = ACTIONS(1),
    [anon_sym_LT_EQ_EQ] = ACTIONS(1),
    [anon_sym_LT_DASH_DASH] = ACTIONS(1),
    [anon_sym_input] = ACTIONS(1),
    [anon_sym_output] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_EQ_EQ_GT] = ACTIONS(1),
    [anon_sym_DASH_DASH_GT] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_BSLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_custom] = ACTIONS(1),
    [sym_parallel] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(300),
    [sym__source_unit] = STATE(152),
    [sym__directive] = STATE(152),
    [sym_pragma_directive] = STATE(152),
    [sym_include_directive] = STATE(152),
    [sym__definition] = STATE(152),
    [sym_template_definition] = STATE(152),
    [sym_function_definition] = STATE(152),
    [sym_main_component_definition] = STATE(152),
    [aux_sym_source_file_repeat1] = STATE(152),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_pragma] = ACTIONS(7),
    [anon_sym_include] = ACTIONS(9),
    [anon_sym_template] = ACTIONS(11),
    [anon_sym_function] = ACTIONS(13),
    [anon_sym_component] = ACTIONS(15),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(25), 1,
      anon_sym_DASH_DASH,
    ACTIONS(27), 1,
      anon_sym_DOT,
    ACTIONS(21), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(19), 28,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [65] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(32), 18,
      anon_sym_EQ,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(30), 30,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [121] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(34), 1,
      anon_sym_LPAREN,
    STATE(25), 1,
      sym_anonymous_inputs,
    ACTIONS(38), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(36), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [181] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(34), 1,
      anon_sym_LPAREN,
    STATE(14), 1,
      sym_anonymous_inputs,
    ACTIONS(42), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(40), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [241] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(46), 18,
      anon_sym_EQ,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(44), 30,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [297] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(25), 1,
      anon_sym_DASH_DASH,
    ACTIONS(21), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(19), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [357] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(34), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_anonymous_inputs,
    ACTIONS(50), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(48), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(54), 18,
      anon_sym_EQ,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(52), 30,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(58), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(56), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(62), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(60), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(66), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(64), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(70), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(68), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(74), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(72), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [743] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(78), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(76), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [797] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(82), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(80), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [851] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(82), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(80), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(86), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(84), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [959] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(88), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [1033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(114), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(112), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1087] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(118), 8,
      anon_sym_EQ,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(116), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1147] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(118), 10,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(116), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1205] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(120), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [1279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(42), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(40), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(50), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(48), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(118), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(116), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 17,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(122), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1495] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(118), 16,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(116), 29,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_SEMI,
  [1551] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(118), 3,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(116), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_SEMI,
  [1619] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(118), 4,
      anon_sym_EQ,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(116), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_SEMI,
  [1683] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(126), 1,
      anon_sym_COMMA,
    ACTIONS(128), 1,
      anon_sym_RPAREN,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    STATE(220), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [1765] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(136), 1,
      anon_sym_COMMA,
    ACTIONS(138), 1,
      anon_sym_RPAREN,
    STATE(218), 1,
      aux_sym_array_expression_repeat1,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [1847] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(136), 1,
      anon_sym_COMMA,
    ACTIONS(140), 1,
      anon_sym_RBRACK,
    STATE(232), 1,
      aux_sym_array_expression_repeat1,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [1929] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(142), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2007] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(144), 1,
      anon_sym_SEMI,
    STATE(153), 1,
      sym__semicolon,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2086] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(146), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2163] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(148), 1,
      anon_sym_SEMI,
    STATE(114), 1,
      sym__semicolon,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2242] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(150), 1,
      anon_sym_SEMI,
    STATE(139), 1,
      sym__semicolon,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2321] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(152), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2398] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(154), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2475] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(156), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2552] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(158), 1,
      anon_sym_SEMI,
    STATE(109), 1,
      sym__semicolon,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2631] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(160), 1,
      anon_sym_SEMI,
    STATE(150), 1,
      sym__semicolon,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2710] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(162), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2787] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(164), 1,
      anon_sym_RPAREN,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [2863] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(168), 1,
      anon_sym_RBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(60), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [2947] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(198), 1,
      anon_sym_RPAREN,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [3023] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(200), 1,
      anon_sym_RBRACK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [3099] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(202), 1,
      anon_sym_COLON,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [3175] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(204), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(53), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [3259] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(206), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(56), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [3343] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(208), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(51), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [3427] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(210), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(56), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [3511] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(212), 1,
      anon_sym_RPAREN,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [3587] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(214), 1,
      anon_sym_RPAREN,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [3663] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    ACTIONS(219), 1,
      anon_sym_RBRACE,
    ACTIONS(221), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_component,
    ACTIONS(227), 1,
      anon_sym_LBRACK,
    ACTIONS(230), 1,
      anon_sym_if,
    ACTIONS(233), 1,
      anon_sym_for,
    ACTIONS(236), 1,
      anon_sym_while,
    ACTIONS(239), 1,
      anon_sym_return,
    ACTIONS(242), 1,
      anon_sym_signal,
    ACTIONS(245), 1,
      anon_sym_var,
    ACTIONS(254), 1,
      sym_identifier,
    ACTIONS(257), 1,
      sym_int_literal,
    ACTIONS(260), 1,
      sym_parallel,
    ACTIONS(248), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(251), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(56), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [3747] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(263), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(56), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [3831] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(265), 1,
      anon_sym_RBRACK,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [3907] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(267), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(57), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [3991] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(269), 1,
      anon_sym_RBRACE,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(56), 11,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
      aux_sym_template_body_repeat1,
  [4075] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [4151] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_EQ,
    ACTIONS(96), 1,
      anon_sym_AMP_AMP,
    ACTIONS(98), 1,
      anon_sym_AMP,
    ACTIONS(100), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(106), 1,
      anon_sym_STAR_STAR,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(132), 1,
      anon_sym_DOT,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(273), 1,
      anon_sym_RPAREN,
    ACTIONS(94), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(102), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(110), 2,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(108), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT,
    ACTIONS(104), 6,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_BSLASH,
      anon_sym_PERCENT,
    ACTIONS(92), 17,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_EQ_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_AMP_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_BSLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_EQ_EQ_EQ,
  [4227] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(275), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_component,
    ACTIONS(279), 1,
      anon_sym_if,
    ACTIONS(281), 1,
      anon_sym_for,
    ACTIONS(283), 1,
      anon_sym_while,
    ACTIONS(285), 1,
      anon_sym_return,
    ACTIONS(287), 1,
      anon_sym_signal,
    ACTIONS(289), 1,
      anon_sym_var,
    ACTIONS(291), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(118), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(37), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4307] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(135), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4387] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(143), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4467] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(275), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_component,
    ACTIONS(279), 1,
      anon_sym_if,
    ACTIONS(281), 1,
      anon_sym_for,
    ACTIONS(283), 1,
      anon_sym_while,
    ACTIONS(285), 1,
      anon_sym_return,
    ACTIONS(287), 1,
      anon_sym_signal,
    ACTIONS(289), 1,
      anon_sym_var,
    ACTIONS(291), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(124), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(37), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4547] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(275), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_component,
    ACTIONS(279), 1,
      anon_sym_if,
    ACTIONS(281), 1,
      anon_sym_for,
    ACTIONS(283), 1,
      anon_sym_while,
    ACTIONS(285), 1,
      anon_sym_return,
    ACTIONS(287), 1,
      anon_sym_signal,
    ACTIONS(289), 1,
      anon_sym_var,
    ACTIONS(291), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(116), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(37), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4627] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(138), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4707] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(275), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_component,
    ACTIONS(279), 1,
      anon_sym_if,
    ACTIONS(281), 1,
      anon_sym_for,
    ACTIONS(283), 1,
      anon_sym_while,
    ACTIONS(285), 1,
      anon_sym_return,
    ACTIONS(287), 1,
      anon_sym_signal,
    ACTIONS(289), 1,
      anon_sym_var,
    ACTIONS(291), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(115), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(37), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4787] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_component,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(176), 1,
      anon_sym_if,
    ACTIONS(178), 1,
      anon_sym_for,
    ACTIONS(180), 1,
      anon_sym_while,
    ACTIONS(182), 1,
      anon_sym_return,
    ACTIONS(184), 1,
      anon_sym_signal,
    ACTIONS(186), 1,
      anon_sym_var,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(194), 1,
      sym_int_literal,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(148), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(43), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4867] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(275), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_component,
    ACTIONS(279), 1,
      anon_sym_if,
    ACTIONS(281), 1,
      anon_sym_for,
    ACTIONS(283), 1,
      anon_sym_while,
    ACTIONS(285), 1,
      anon_sym_return,
    ACTIONS(287), 1,
      anon_sym_signal,
    ACTIONS(289), 1,
      anon_sym_var,
    ACTIONS(291), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(121), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(37), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [4947] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(275), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_component,
    ACTIONS(279), 1,
      anon_sym_if,
    ACTIONS(281), 1,
      anon_sym_for,
    ACTIONS(283), 1,
      anon_sym_while,
    ACTIONS(285), 1,
      anon_sym_return,
    ACTIONS(287), 1,
      anon_sym_signal,
    ACTIONS(289), 1,
      anon_sym_var,
    ACTIONS(291), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(111), 10,
      sym__statement,
      sym_block_statement,
      sym_expression_statement,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_return_statement,
      sym_signal_declaration_statement,
      sym_variable_declaration_statement,
      sym_component_declaration_statement,
    STATE(37), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5027] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(293), 1,
      anon_sym_var,
    ACTIONS(295), 1,
      anon_sym_SEMI,
    ACTIONS(297), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(76), 3,
      sym_expression_statement,
      sym_variable_declaration_statement,
      sym__semicolon,
    STATE(35), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5082] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(293), 1,
      anon_sym_var,
    ACTIONS(297), 1,
      sym_int_literal,
    ACTIONS(299), 1,
      anon_sym_SEMI,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(75), 3,
      sym_expression_statement,
      sym_variable_declaration_statement,
      sym__semicolon,
    STATE(35), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5137] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(297), 1,
      sym_int_literal,
    ACTIONS(301), 1,
      anon_sym_SEMI,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(81), 2,
      sym_expression_statement,
      sym__semicolon,
    STATE(35), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5188] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(297), 1,
      sym_int_literal,
    ACTIONS(303), 1,
      anon_sym_SEMI,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(82), 2,
      sym_expression_statement,
      sym__semicolon,
    STATE(35), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5239] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(305), 1,
      anon_sym_RPAREN,
    ACTIONS(307), 1,
      sym_int_literal,
    STATE(281), 1,
      sym_argument_list,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(31), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5289] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(307), 1,
      sym_int_literal,
    ACTIONS(309), 1,
      anon_sym_RPAREN,
    STATE(293), 1,
      sym_argument_list,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(31), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5339] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(307), 1,
      sym_int_literal,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(294), 1,
      sym_argument_list,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(31), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5389] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(313), 1,
      anon_sym_RBRACK,
    ACTIONS(315), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(58), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5436] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(317), 1,
      anon_sym_RPAREN,
    ACTIONS(319), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(61), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5483] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(321), 1,
      anon_sym_RPAREN,
    ACTIONS(323), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(54), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5530] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(325), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(19), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5574] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(327), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(29), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5618] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(329), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(55), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5662] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(331), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(62), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5706] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(333), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(47), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5750] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(335), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(44), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5794] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(337), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(45), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5838] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(339), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(42), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5882] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(341), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(41), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5926] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(343), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(40), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [5970] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(345), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(36), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6014] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(347), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(39), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6058] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(349), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(28), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6102] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(351), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(26), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6146] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(353), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(21), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6190] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(355), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(34), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6234] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(357), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(17), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6278] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(359), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(16), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6322] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(361), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(32), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6366] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(363), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(33), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6410] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(365), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(38), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6454] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(367), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(23), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6498] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(369), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(48), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6542] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(371), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(49), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6586] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(373), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(22), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6630] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      sym_identifier,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(375), 1,
      sym_int_literal,
    ACTIONS(188), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(190), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(7), 2,
      sym_member_expression,
      sym_array_access_expression,
    STATE(30), 11,
      sym__expression,
      sym_array_expression,
      sym_tuple_expression,
      sym_assignment_expression,
      sym_increment_expression,
      sym_decrement_expression,
      sym_call_expression,
      sym_parenthesized_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_binary_expression,
  [6674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(379), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(383), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6728] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      anon_sym_else,
    ACTIONS(385), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(387), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(393), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(397), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(401), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(405), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(409), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6892] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(413), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(417), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6946] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(421), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [6973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(425), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7000] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      anon_sym_else,
    ACTIONS(385), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(387), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(431), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(421), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(435), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(439), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(443), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(447), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(451), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(455), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(439), 10,
      anon_sym_component,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(431), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(421), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(397), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(383), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7376] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(417), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7402] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(455), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7428] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(421), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(405), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(379), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7506] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(393), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(413), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(451), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(435), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(447), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7636] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(439), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(439), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(443), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(409), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7740] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(425), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7766] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      sym_int_literal,
    ACTIONS(401), 9,
      anon_sym_component,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_return,
      anon_sym_signal,
      anon_sym_var,
      sym_identifier,
      sym_parallel,
  [7792] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      ts_builtin_sym_end,
    ACTIONS(459), 1,
      anon_sym_pragma,
    ACTIONS(462), 1,
      anon_sym_include,
    ACTIONS(465), 1,
      anon_sym_template,
    ACTIONS(468), 1,
      anon_sym_function,
    ACTIONS(471), 1,
      anon_sym_component,
    STATE(151), 9,
      sym__source_unit,
      sym__directive,
      sym_pragma_directive,
      sym_include_directive,
      sym__definition,
      sym_template_definition,
      sym_function_definition,
      sym_main_component_definition,
      aux_sym_source_file_repeat1,
  [7825] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_pragma,
    ACTIONS(9), 1,
      anon_sym_include,
    ACTIONS(11), 1,
      anon_sym_template,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_component,
    ACTIONS(474), 1,
      ts_builtin_sym_end,
    STATE(151), 9,
      sym__source_unit,
      sym__directive,
      sym_pragma_directive,
      sym_include_directive,
      sym__definition,
      sym_template_definition,
      sym_function_definition,
      sym_main_component_definition,
      aux_sym_source_file_repeat1,
  [7858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 2,
      sym_identifier,
      sym_parallel,
    ACTIONS(399), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SEMI,
      sym_int_literal,
  [7877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 2,
      sym_identifier,
      sym_parallel,
    ACTIONS(395), 8,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SEMI,
      sym_int_literal,
  [7895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 2,
      sym_identifier,
      sym_parallel,
    ACTIONS(391), 8,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SEMI,
      sym_int_literal,
  [7913] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      anon_sym_LBRACE,
    ACTIONS(480), 1,
      sym_identifier,
    STATE(210), 1,
      sym__signal_declaration,
    STATE(211), 1,
      sym_signal_visibility,
    STATE(262), 1,
      sym_signal_tags,
    ACTIONS(478), 2,
      anon_sym_input,
      anon_sym_output,
  [7936] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      anon_sym_LBRACK,
    STATE(157), 1,
      aux_sym_array_type_repeat1,
    ACTIONS(482), 5,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_SEMI,
  [7953] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_LBRACK,
    STATE(157), 1,
      aux_sym_array_type_repeat1,
    ACTIONS(487), 5,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_SEMI,
  [7970] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      anon_sym_LBRACE,
    ACTIONS(480), 1,
      sym_identifier,
    STATE(190), 1,
      sym__signal_declaration,
    STATE(213), 1,
      sym_signal_visibility,
    STATE(266), 1,
      sym_signal_tags,
    ACTIONS(478), 2,
      anon_sym_input,
      anon_sym_output,
  [7993] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_LBRACK,
    STATE(158), 1,
      aux_sym_array_type_repeat1,
    STATE(203), 1,
      sym_array_type,
    ACTIONS(491), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(493), 2,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
  [8014] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8038] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8050] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 6,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
      anon_sym_SEMI,
  [8062] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8074] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8086] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8098] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8110] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8122] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_LBRACK,
    ACTIONS(515), 1,
      anon_sym_EQ,
    STATE(158), 1,
      aux_sym_array_type_repeat1,
    STATE(224), 1,
      sym_array_type,
    ACTIONS(513), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [8142] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8154] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8166] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      anon_sym_EQ,
    STATE(158), 1,
      aux_sym_array_type_repeat1,
    STATE(216), 1,
      sym_array_type,
    ACTIONS(521), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [8186] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 6,
      ts_builtin_sym_end,
      anon_sym_pragma,
      anon_sym_include,
      anon_sym_template,
      anon_sym_function,
      anon_sym_component,
  [8198] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 1,
      anon_sym_custom_templates,
    ACTIONS(529), 1,
      anon_sym_circom,
    STATE(296), 1,
      sym__circom,
    STATE(264), 2,
      sym_circom_custom_templates_token,
      sym_circom_pragma_token,
  [8215] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_COMMA,
    ACTIONS(533), 1,
      anon_sym_SEMI,
    STATE(140), 1,
      sym__semicolon,
    STATE(215), 1,
      aux_sym_variable_declaration_statement_repeat1,
  [8231] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_COMMA,
    ACTIONS(535), 1,
      anon_sym_SEMI,
    STATE(133), 1,
      sym__semicolon,
    STATE(176), 1,
      aux_sym_variable_declaration_statement_repeat1,
  [8247] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(539), 1,
      anon_sym_SEMI,
    STATE(119), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8263] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(541), 1,
      anon_sym_SEMI,
    STATE(120), 1,
      sym__semicolon,
    STATE(212), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8279] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(543), 1,
      anon_sym_SEMI,
    STATE(123), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8295] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_COMMA,
    STATE(181), 1,
      aux_sym_array_expression_repeat1,
    ACTIONS(142), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [8309] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_COMMA,
    ACTIONS(548), 1,
      anon_sym_SEMI,
    STATE(155), 1,
      sym__semicolon,
    STATE(215), 1,
      aux_sym_variable_declaration_statement_repeat1,
  [8325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_identifier,
    STATE(283), 1,
      sym_template_type,
    ACTIONS(552), 2,
      sym_custom,
      sym_parallel,
  [8339] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(554), 1,
      anon_sym_SEMI,
    STATE(125), 1,
      sym__semicolon,
    STATE(178), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8355] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(556), 1,
      anon_sym_SEMI,
    STATE(130), 1,
      sym__semicolon,
    STATE(180), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8371] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(558), 1,
      anon_sym_SEMI,
    STATE(126), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8387] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(562), 1,
      anon_sym_SEMI,
    STATE(110), 1,
      sym__semicolon,
    STATE(219), 1,
      aux_sym_component_declaration_statement_repeat1,
  [8403] = 5,
    ACTIONS(564), 1,
      anon_sym_DQUOTE,
    ACTIONS(566), 1,
      sym__escape_sequence,
    ACTIONS(568), 1,
      sym__string_immediate_elt_inside_double_quote,
    ACTIONS(570), 1,
      sym_comment,
    STATE(191), 1,
      aux_sym_string_repeat1,
  [8419] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_COMMA,
    ACTIONS(572), 1,
      anon_sym_SEMI,
    STATE(154), 1,
      sym__semicolon,
    STATE(182), 1,
      aux_sym_variable_declaration_statement_repeat1,
  [8435] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(574), 1,
      anon_sym_SEMI,
    STATE(127), 1,
      sym__semicolon,
    STATE(186), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8451] = 5,
    ACTIONS(570), 1,
      sym_comment,
    ACTIONS(576), 1,
      anon_sym_DQUOTE,
    ACTIONS(578), 1,
      sym__escape_sequence,
    ACTIONS(580), 1,
      sym__string_immediate_elt_inside_double_quote,
    STATE(195), 1,
      aux_sym_string_repeat1,
  [8467] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(582), 1,
      anon_sym_SEMI,
    STATE(129), 1,
      sym__semicolon,
    STATE(187), 1,
      aux_sym_component_declaration_statement_repeat1,
  [8483] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(584), 1,
      anon_sym_SEMI,
    STATE(145), 1,
      sym__semicolon,
    STATE(199), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8499] = 5,
    ACTIONS(570), 1,
      sym_comment,
    ACTIONS(576), 1,
      anon_sym_SQUOTE,
    ACTIONS(586), 1,
      sym__escape_sequence,
    ACTIONS(588), 1,
      sym__string_immediate_elt_inside_quote,
    STATE(201), 1,
      aux_sym_string_repeat2,
  [8515] = 5,
    ACTIONS(570), 1,
      sym_comment,
    ACTIONS(590), 1,
      anon_sym_DQUOTE,
    ACTIONS(592), 1,
      sym__escape_sequence,
    ACTIONS(595), 1,
      sym__string_immediate_elt_inside_double_quote,
    STATE(195), 1,
      aux_sym_string_repeat1,
  [8531] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(598), 1,
      anon_sym_SEMI,
    STATE(132), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8547] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(600), 1,
      anon_sym_SEMI,
    STATE(149), 1,
      sym__semicolon,
    STATE(208), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8563] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(602), 1,
      anon_sym_SEMI,
    STATE(146), 1,
      sym__semicolon,
    STATE(196), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8579] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(604), 1,
      anon_sym_SEMI,
    STATE(137), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8595] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(606), 1,
      anon_sym_SEMI,
    STATE(147), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8611] = 5,
    ACTIONS(570), 1,
      sym_comment,
    ACTIONS(608), 1,
      anon_sym_SQUOTE,
    ACTIONS(610), 1,
      sym__escape_sequence,
    ACTIONS(613), 1,
      sym__string_immediate_elt_inside_quote,
    STATE(201), 1,
      aux_sym_string_repeat2,
  [8627] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_COMMA,
    ACTIONS(616), 1,
      anon_sym_SEMI,
    STATE(113), 1,
      sym__semicolon,
    STATE(204), 1,
      aux_sym_variable_declaration_statement_repeat1,
  [8643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(620), 2,
      anon_sym_LT_EQ_EQ,
      anon_sym_LT_DASH_DASH,
  [8655] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_COMMA,
    ACTIONS(622), 1,
      anon_sym_SEMI,
    STATE(112), 1,
      sym__semicolon,
    STATE(215), 1,
      aux_sym_variable_declaration_statement_repeat1,
  [8671] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 1,
      anon_sym_COMMA,
    STATE(205), 1,
      aux_sym_parameter_list_repeat1,
    ACTIONS(627), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [8685] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(629), 1,
      anon_sym_SEMI,
    STATE(136), 1,
      sym__semicolon,
    STATE(209), 1,
      aux_sym_component_declaration_statement_repeat1,
  [8701] = 5,
    ACTIONS(564), 1,
      anon_sym_SQUOTE,
    ACTIONS(570), 1,
      sym_comment,
    ACTIONS(631), 1,
      sym__escape_sequence,
    ACTIONS(633), 1,
      sym__string_immediate_elt_inside_quote,
    STATE(194), 1,
      aux_sym_string_repeat2,
  [8717] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(635), 1,
      anon_sym_SEMI,
    STATE(141), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8733] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(637), 1,
      anon_sym_SEMI,
    STATE(134), 1,
      sym__semicolon,
    STATE(219), 1,
      aux_sym_component_declaration_statement_repeat1,
  [8749] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(639), 1,
      anon_sym_SEMI,
    STATE(144), 1,
      sym__semicolon,
    STATE(200), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8765] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      sym_identifier,
    STATE(198), 1,
      sym__signal_declaration,
    STATE(257), 1,
      sym_signal_tags,
  [8781] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(643), 1,
      anon_sym_SEMI,
    STATE(117), 1,
      sym__semicolon,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8797] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      sym_identifier,
    STATE(185), 1,
      sym__signal_declaration,
    STATE(260), 1,
      sym_signal_tags,
  [8813] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_RBRACE,
    ACTIONS(647), 1,
      anon_sym_COMMA,
    STATE(214), 1,
      aux_sym_signal_tags_repeat1,
  [8826] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 1,
      anon_sym_COMMA,
    ACTIONS(653), 1,
      anon_sym_SEMI,
    STATE(215), 1,
      aux_sym_variable_declaration_statement_repeat1,
  [8839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 1,
      anon_sym_EQ,
    ACTIONS(655), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [8850] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(659), 1,
      sym_identifier,
    STATE(252), 1,
      sym_call_expression,
  [8863] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 1,
      anon_sym_COMMA,
    ACTIONS(661), 1,
      anon_sym_RPAREN,
    STATE(181), 1,
      aux_sym_array_expression_repeat1,
  [8876] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(663), 1,
      anon_sym_COMMA,
    ACTIONS(666), 1,
      anon_sym_SEMI,
    STATE(219), 1,
      aux_sym_component_declaration_statement_repeat1,
  [8889] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(126), 1,
      anon_sym_COMMA,
    ACTIONS(668), 1,
      anon_sym_RPAREN,
    STATE(237), 1,
      aux_sym_argument_list_repeat1,
  [8902] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_COMMA,
    ACTIONS(672), 1,
      anon_sym_RBRACK,
    STATE(222), 1,
      aux_sym_parameter_list_repeat1,
  [8915] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_COMMA,
    ACTIONS(674), 1,
      anon_sym_RBRACK,
    STATE(205), 1,
      aux_sym_parameter_list_repeat1,
  [8928] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 1,
      anon_sym_RBRACE,
    ACTIONS(678), 1,
      anon_sym_COMMA,
    STATE(214), 1,
      aux_sym_signal_tags_repeat1,
  [8941] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 1,
      anon_sym_EQ,
    ACTIONS(680), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [8952] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(659), 1,
      sym_identifier,
    STATE(243), 1,
      sym_call_expression,
  [8965] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 1,
      anon_sym_DQUOTE,
    ACTIONS(686), 1,
      anon_sym_SQUOTE,
    STATE(267), 1,
      sym_string,
  [8978] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_COMMA,
    ACTIONS(691), 1,
      anon_sym_SEMI,
    STATE(227), 1,
      aux_sym_signal_declaration_statement_repeat1,
  [8991] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 1,
      anon_sym_RPAREN,
    ACTIONS(695), 1,
      sym_identifier,
    STATE(231), 1,
      sym_parameter,
  [9004] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(659), 1,
      sym_identifier,
    STATE(246), 1,
      sym_call_expression,
  [9017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9026] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_COMMA,
    ACTIONS(699), 1,
      anon_sym_RPAREN,
    STATE(235), 1,
      aux_sym_parameter_list_repeat1,
  [9039] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 1,
      anon_sym_COMMA,
    ACTIONS(701), 1,
      anon_sym_RBRACK,
    STATE(181), 1,
      aux_sym_array_expression_repeat1,
  [9052] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      sym_parallel,
    ACTIONS(659), 1,
      sym_identifier,
    STATE(245), 1,
      sym_call_expression,
  [9065] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9074] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_COMMA,
    ACTIONS(703), 1,
      anon_sym_RPAREN,
    STATE(205), 1,
      aux_sym_parameter_list_repeat1,
  [9087] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 1,
      anon_sym_COMMA,
    ACTIONS(705), 1,
      anon_sym_RBRACE,
    STATE(223), 1,
      aux_sym_signal_tags_repeat1,
  [9100] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 1,
      anon_sym_COMMA,
    ACTIONS(710), 1,
      anon_sym_RPAREN,
    STATE(237), 1,
      aux_sym_argument_list_repeat1,
  [9113] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 1,
      anon_sym_LBRACE,
    ACTIONS(714), 1,
      anon_sym_EQ,
    STATE(274), 1,
      sym_main_component_public_signals,
  [9126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    STATE(253), 1,
      sym_parameter_list,
  [9136] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    STATE(247), 1,
      sym_parameter_list,
  [9146] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(177), 1,
      sym__variable_declaration,
  [9156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 1,
      sym_identifier,
    STATE(206), 1,
      sym__component_declaration,
  [9166] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(722), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [9174] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      sym_identifier,
    STATE(234), 1,
      sym_parameter,
  [9184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_SEMI,
    STATE(169), 1,
      sym__semicolon,
  [9194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_SEMI,
    STATE(171), 1,
      sym__semicolon,
  [9204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_LBRACE,
    STATE(166), 1,
      sym_template_body,
  [9214] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 1,
      sym_identifier,
    STATE(192), 1,
      sym__component_declaration,
  [9224] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    STATE(255), 1,
      sym_parameter_list,
  [9234] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [9242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_identifier,
    STATE(259), 1,
      sym__signal_declaration,
  [9252] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [9260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_LBRACE,
    STATE(167), 1,
      sym_function_body,
  [9270] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      sym_identifier,
    STATE(221), 1,
      sym_parameter,
  [9280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_LBRACE,
    STATE(162), 1,
      sym_template_body,
  [9290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(189), 1,
      sym__variable_declaration,
  [9300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_identifier,
    STATE(197), 1,
      sym__signal_declaration,
  [9310] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 2,
      anon_sym_LBRACE,
      sym_identifier,
  [9318] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [9326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_identifier,
    STATE(179), 1,
      sym__signal_declaration,
  [9336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(250), 1,
      sym__variable_declaration,
  [9346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_identifier,
    STATE(193), 1,
      sym__signal_declaration,
  [9356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(202), 1,
      sym__variable_declaration,
  [9366] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 1,
      anon_sym_SEMI,
    STATE(161), 1,
      sym__semicolon,
  [9376] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [9384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_identifier,
    STATE(184), 1,
      sym__signal_declaration,
  [9394] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 1,
      anon_sym_SEMI,
    STATE(165), 1,
      sym__semicolon,
  [9404] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [9412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 1,
      sym_identifier,
    STATE(268), 1,
      sym__component_declaration,
  [9422] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 1,
      anon_sym_RBRACE,
  [9429] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_LBRACK,
  [9436] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_LBRACE,
  [9443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_SEMI,
  [9450] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 1,
      anon_sym_EQ,
  [9457] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_SEMI,
  [9464] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      sym_identifier,
  [9471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 1,
      anon_sym_public,
  [9478] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
  [9485] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 1,
      anon_sym_SEMI,
  [9492] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
  [9499] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_RPAREN,
  [9506] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 1,
      anon_sym_LPAREN,
  [9513] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 1,
      sym_identifier,
  [9520] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_LPAREN,
  [9527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LPAREN,
  [9534] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 1,
      anon_sym_LPAREN,
  [9541] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      sym_identifier,
  [9548] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_LBRACE,
  [9555] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 1,
      anon_sym_EQ,
  [9562] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 1,
      sym_identifier,
  [9569] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 1,
      sym_identifier,
  [9576] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 1,
      sym_identifier,
  [9583] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      anon_sym_RPAREN,
  [9590] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 1,
      anon_sym_RPAREN,
  [9597] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
  [9604] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 1,
      sym_circom_version,
  [9611] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 1,
      sym_identifier,
  [9618] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 1,
      sym_identifier,
  [9625] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_SEMI,
  [9632] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      ts_builtin_sym_end,
  [9639] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 1,
      anon_sym_LPAREN,
  [9646] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_main,
  [9653] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(808), 1,
      sym_identifier,
  [9660] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      anon_sym_LPAREN,
  [9667] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      anon_sym_RBRACE,
  [9674] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_LPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 65,
  [SMALL_STATE(4)] = 121,
  [SMALL_STATE(5)] = 181,
  [SMALL_STATE(6)] = 241,
  [SMALL_STATE(7)] = 297,
  [SMALL_STATE(8)] = 357,
  [SMALL_STATE(9)] = 417,
  [SMALL_STATE(10)] = 473,
  [SMALL_STATE(11)] = 527,
  [SMALL_STATE(12)] = 581,
  [SMALL_STATE(13)] = 635,
  [SMALL_STATE(14)] = 689,
  [SMALL_STATE(15)] = 743,
  [SMALL_STATE(16)] = 797,
  [SMALL_STATE(17)] = 851,
  [SMALL_STATE(18)] = 905,
  [SMALL_STATE(19)] = 959,
  [SMALL_STATE(20)] = 1033,
  [SMALL_STATE(21)] = 1087,
  [SMALL_STATE(22)] = 1147,
  [SMALL_STATE(23)] = 1205,
  [SMALL_STATE(24)] = 1279,
  [SMALL_STATE(25)] = 1333,
  [SMALL_STATE(26)] = 1387,
  [SMALL_STATE(27)] = 1441,
  [SMALL_STATE(28)] = 1495,
  [SMALL_STATE(29)] = 1551,
  [SMALL_STATE(30)] = 1619,
  [SMALL_STATE(31)] = 1683,
  [SMALL_STATE(32)] = 1765,
  [SMALL_STATE(33)] = 1847,
  [SMALL_STATE(34)] = 1929,
  [SMALL_STATE(35)] = 2007,
  [SMALL_STATE(36)] = 2086,
  [SMALL_STATE(37)] = 2163,
  [SMALL_STATE(38)] = 2242,
  [SMALL_STATE(39)] = 2321,
  [SMALL_STATE(40)] = 2398,
  [SMALL_STATE(41)] = 2475,
  [SMALL_STATE(42)] = 2552,
  [SMALL_STATE(43)] = 2631,
  [SMALL_STATE(44)] = 2710,
  [SMALL_STATE(45)] = 2787,
  [SMALL_STATE(46)] = 2863,
  [SMALL_STATE(47)] = 2947,
  [SMALL_STATE(48)] = 3023,
  [SMALL_STATE(49)] = 3099,
  [SMALL_STATE(50)] = 3175,
  [SMALL_STATE(51)] = 3259,
  [SMALL_STATE(52)] = 3343,
  [SMALL_STATE(53)] = 3427,
  [SMALL_STATE(54)] = 3511,
  [SMALL_STATE(55)] = 3587,
  [SMALL_STATE(56)] = 3663,
  [SMALL_STATE(57)] = 3747,
  [SMALL_STATE(58)] = 3831,
  [SMALL_STATE(59)] = 3907,
  [SMALL_STATE(60)] = 3991,
  [SMALL_STATE(61)] = 4075,
  [SMALL_STATE(62)] = 4151,
  [SMALL_STATE(63)] = 4227,
  [SMALL_STATE(64)] = 4307,
  [SMALL_STATE(65)] = 4387,
  [SMALL_STATE(66)] = 4467,
  [SMALL_STATE(67)] = 4547,
  [SMALL_STATE(68)] = 4627,
  [SMALL_STATE(69)] = 4707,
  [SMALL_STATE(70)] = 4787,
  [SMALL_STATE(71)] = 4867,
  [SMALL_STATE(72)] = 4947,
  [SMALL_STATE(73)] = 5027,
  [SMALL_STATE(74)] = 5082,
  [SMALL_STATE(75)] = 5137,
  [SMALL_STATE(76)] = 5188,
  [SMALL_STATE(77)] = 5239,
  [SMALL_STATE(78)] = 5289,
  [SMALL_STATE(79)] = 5339,
  [SMALL_STATE(80)] = 5389,
  [SMALL_STATE(81)] = 5436,
  [SMALL_STATE(82)] = 5483,
  [SMALL_STATE(83)] = 5530,
  [SMALL_STATE(84)] = 5574,
  [SMALL_STATE(85)] = 5618,
  [SMALL_STATE(86)] = 5662,
  [SMALL_STATE(87)] = 5706,
  [SMALL_STATE(88)] = 5750,
  [SMALL_STATE(89)] = 5794,
  [SMALL_STATE(90)] = 5838,
  [SMALL_STATE(91)] = 5882,
  [SMALL_STATE(92)] = 5926,
  [SMALL_STATE(93)] = 5970,
  [SMALL_STATE(94)] = 6014,
  [SMALL_STATE(95)] = 6058,
  [SMALL_STATE(96)] = 6102,
  [SMALL_STATE(97)] = 6146,
  [SMALL_STATE(98)] = 6190,
  [SMALL_STATE(99)] = 6234,
  [SMALL_STATE(100)] = 6278,
  [SMALL_STATE(101)] = 6322,
  [SMALL_STATE(102)] = 6366,
  [SMALL_STATE(103)] = 6410,
  [SMALL_STATE(104)] = 6454,
  [SMALL_STATE(105)] = 6498,
  [SMALL_STATE(106)] = 6542,
  [SMALL_STATE(107)] = 6586,
  [SMALL_STATE(108)] = 6630,
  [SMALL_STATE(109)] = 6674,
  [SMALL_STATE(110)] = 6701,
  [SMALL_STATE(111)] = 6728,
  [SMALL_STATE(112)] = 6757,
  [SMALL_STATE(113)] = 6784,
  [SMALL_STATE(114)] = 6811,
  [SMALL_STATE(115)] = 6838,
  [SMALL_STATE(116)] = 6865,
  [SMALL_STATE(117)] = 6892,
  [SMALL_STATE(118)] = 6919,
  [SMALL_STATE(119)] = 6946,
  [SMALL_STATE(120)] = 6973,
  [SMALL_STATE(121)] = 7000,
  [SMALL_STATE(122)] = 7029,
  [SMALL_STATE(123)] = 7056,
  [SMALL_STATE(124)] = 7083,
  [SMALL_STATE(125)] = 7110,
  [SMALL_STATE(126)] = 7137,
  [SMALL_STATE(127)] = 7164,
  [SMALL_STATE(128)] = 7191,
  [SMALL_STATE(129)] = 7218,
  [SMALL_STATE(130)] = 7245,
  [SMALL_STATE(131)] = 7272,
  [SMALL_STATE(132)] = 7298,
  [SMALL_STATE(133)] = 7324,
  [SMALL_STATE(134)] = 7350,
  [SMALL_STATE(135)] = 7376,
  [SMALL_STATE(136)] = 7402,
  [SMALL_STATE(137)] = 7428,
  [SMALL_STATE(138)] = 7454,
  [SMALL_STATE(139)] = 7480,
  [SMALL_STATE(140)] = 7506,
  [SMALL_STATE(141)] = 7532,
  [SMALL_STATE(142)] = 7558,
  [SMALL_STATE(143)] = 7584,
  [SMALL_STATE(144)] = 7610,
  [SMALL_STATE(145)] = 7636,
  [SMALL_STATE(146)] = 7662,
  [SMALL_STATE(147)] = 7688,
  [SMALL_STATE(148)] = 7714,
  [SMALL_STATE(149)] = 7740,
  [SMALL_STATE(150)] = 7766,
  [SMALL_STATE(151)] = 7792,
  [SMALL_STATE(152)] = 7825,
  [SMALL_STATE(153)] = 7858,
  [SMALL_STATE(154)] = 7877,
  [SMALL_STATE(155)] = 7895,
  [SMALL_STATE(156)] = 7913,
  [SMALL_STATE(157)] = 7936,
  [SMALL_STATE(158)] = 7953,
  [SMALL_STATE(159)] = 7970,
  [SMALL_STATE(160)] = 7993,
  [SMALL_STATE(161)] = 8014,
  [SMALL_STATE(162)] = 8026,
  [SMALL_STATE(163)] = 8038,
  [SMALL_STATE(164)] = 8050,
  [SMALL_STATE(165)] = 8062,
  [SMALL_STATE(166)] = 8074,
  [SMALL_STATE(167)] = 8086,
  [SMALL_STATE(168)] = 8098,
  [SMALL_STATE(169)] = 8110,
  [SMALL_STATE(170)] = 8122,
  [SMALL_STATE(171)] = 8142,
  [SMALL_STATE(172)] = 8154,
  [SMALL_STATE(173)] = 8166,
  [SMALL_STATE(174)] = 8186,
  [SMALL_STATE(175)] = 8198,
  [SMALL_STATE(176)] = 8215,
  [SMALL_STATE(177)] = 8231,
  [SMALL_STATE(178)] = 8247,
  [SMALL_STATE(179)] = 8263,
  [SMALL_STATE(180)] = 8279,
  [SMALL_STATE(181)] = 8295,
  [SMALL_STATE(182)] = 8309,
  [SMALL_STATE(183)] = 8325,
  [SMALL_STATE(184)] = 8339,
  [SMALL_STATE(185)] = 8355,
  [SMALL_STATE(186)] = 8371,
  [SMALL_STATE(187)] = 8387,
  [SMALL_STATE(188)] = 8403,
  [SMALL_STATE(189)] = 8419,
  [SMALL_STATE(190)] = 8435,
  [SMALL_STATE(191)] = 8451,
  [SMALL_STATE(192)] = 8467,
  [SMALL_STATE(193)] = 8483,
  [SMALL_STATE(194)] = 8499,
  [SMALL_STATE(195)] = 8515,
  [SMALL_STATE(196)] = 8531,
  [SMALL_STATE(197)] = 8547,
  [SMALL_STATE(198)] = 8563,
  [SMALL_STATE(199)] = 8579,
  [SMALL_STATE(200)] = 8595,
  [SMALL_STATE(201)] = 8611,
  [SMALL_STATE(202)] = 8627,
  [SMALL_STATE(203)] = 8643,
  [SMALL_STATE(204)] = 8655,
  [SMALL_STATE(205)] = 8671,
  [SMALL_STATE(206)] = 8685,
  [SMALL_STATE(207)] = 8701,
  [SMALL_STATE(208)] = 8717,
  [SMALL_STATE(209)] = 8733,
  [SMALL_STATE(210)] = 8749,
  [SMALL_STATE(211)] = 8765,
  [SMALL_STATE(212)] = 8781,
  [SMALL_STATE(213)] = 8797,
  [SMALL_STATE(214)] = 8813,
  [SMALL_STATE(215)] = 8826,
  [SMALL_STATE(216)] = 8839,
  [SMALL_STATE(217)] = 8850,
  [SMALL_STATE(218)] = 8863,
  [SMALL_STATE(219)] = 8876,
  [SMALL_STATE(220)] = 8889,
  [SMALL_STATE(221)] = 8902,
  [SMALL_STATE(222)] = 8915,
  [SMALL_STATE(223)] = 8928,
  [SMALL_STATE(224)] = 8941,
  [SMALL_STATE(225)] = 8952,
  [SMALL_STATE(226)] = 8965,
  [SMALL_STATE(227)] = 8978,
  [SMALL_STATE(228)] = 8991,
  [SMALL_STATE(229)] = 9004,
  [SMALL_STATE(230)] = 9017,
  [SMALL_STATE(231)] = 9026,
  [SMALL_STATE(232)] = 9039,
  [SMALL_STATE(233)] = 9052,
  [SMALL_STATE(234)] = 9065,
  [SMALL_STATE(235)] = 9074,
  [SMALL_STATE(236)] = 9087,
  [SMALL_STATE(237)] = 9100,
  [SMALL_STATE(238)] = 9113,
  [SMALL_STATE(239)] = 9126,
  [SMALL_STATE(240)] = 9136,
  [SMALL_STATE(241)] = 9146,
  [SMALL_STATE(242)] = 9156,
  [SMALL_STATE(243)] = 9166,
  [SMALL_STATE(244)] = 9174,
  [SMALL_STATE(245)] = 9184,
  [SMALL_STATE(246)] = 9194,
  [SMALL_STATE(247)] = 9204,
  [SMALL_STATE(248)] = 9214,
  [SMALL_STATE(249)] = 9224,
  [SMALL_STATE(250)] = 9234,
  [SMALL_STATE(251)] = 9242,
  [SMALL_STATE(252)] = 9252,
  [SMALL_STATE(253)] = 9260,
  [SMALL_STATE(254)] = 9270,
  [SMALL_STATE(255)] = 9280,
  [SMALL_STATE(256)] = 9290,
  [SMALL_STATE(257)] = 9300,
  [SMALL_STATE(258)] = 9310,
  [SMALL_STATE(259)] = 9318,
  [SMALL_STATE(260)] = 9326,
  [SMALL_STATE(261)] = 9336,
  [SMALL_STATE(262)] = 9346,
  [SMALL_STATE(263)] = 9356,
  [SMALL_STATE(264)] = 9366,
  [SMALL_STATE(265)] = 9376,
  [SMALL_STATE(266)] = 9384,
  [SMALL_STATE(267)] = 9394,
  [SMALL_STATE(268)] = 9404,
  [SMALL_STATE(269)] = 9412,
  [SMALL_STATE(270)] = 9422,
  [SMALL_STATE(271)] = 9429,
  [SMALL_STATE(272)] = 9436,
  [SMALL_STATE(273)] = 9443,
  [SMALL_STATE(274)] = 9450,
  [SMALL_STATE(275)] = 9457,
  [SMALL_STATE(276)] = 9464,
  [SMALL_STATE(277)] = 9471,
  [SMALL_STATE(278)] = 9478,
  [SMALL_STATE(279)] = 9485,
  [SMALL_STATE(280)] = 9492,
  [SMALL_STATE(281)] = 9499,
  [SMALL_STATE(282)] = 9506,
  [SMALL_STATE(283)] = 9513,
  [SMALL_STATE(284)] = 9520,
  [SMALL_STATE(285)] = 9527,
  [SMALL_STATE(286)] = 9534,
  [SMALL_STATE(287)] = 9541,
  [SMALL_STATE(288)] = 9548,
  [SMALL_STATE(289)] = 9555,
  [SMALL_STATE(290)] = 9562,
  [SMALL_STATE(291)] = 9569,
  [SMALL_STATE(292)] = 9576,
  [SMALL_STATE(293)] = 9583,
  [SMALL_STATE(294)] = 9590,
  [SMALL_STATE(295)] = 9597,
  [SMALL_STATE(296)] = 9604,
  [SMALL_STATE(297)] = 9611,
  [SMALL_STATE(298)] = 9618,
  [SMALL_STATE(299)] = 9625,
  [SMALL_STATE(300)] = 9632,
  [SMALL_STATE(301)] = 9639,
  [SMALL_STATE(302)] = 9646,
  [SMALL_STATE(303)] = 9653,
  [SMALL_STATE(304)] = 9660,
  [SMALL_STATE(305)] = 9667,
  [SMALL_STATE(306)] = 9674,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [19] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [21] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [27] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0), SHIFT(292),
  [30] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_access_expression, 3, 0, 13),
  [32] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_access_expression, 3, 0, 13),
  [34] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [36] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 3, 0, 0),
  [38] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 3, 0, 0),
  [40] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 5, 0, 0),
  [42] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 5, 0, 0),
  [44] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_access_expression, 4, 0, 20),
  [46] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_access_expression, 4, 0, 20),
  [48] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 4, 0, 0),
  [50] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 4, 0, 0),
  [52] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_expression, 3, 1, 12),
  [54] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_expression, 3, 1, 12),
  [56] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_expression, 3, 0, 0),
  [58] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_expression, 3, 0, 0),
  [60] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [62] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [64] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_inputs, 3, 0, 0),
  [66] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_inputs, 3, 0, 0),
  [68] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_expression, 4, 0, 0),
  [70] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_expression, 4, 0, 0),
  [72] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 6, 0, 0),
  [74] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 6, 0, 0),
  [76] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_expression, 4, 0, 0),
  [78] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_expression, 4, 0, 0),
  [80] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, 0, 7),
  [82] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, 0, 7),
  [84] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_increment_expression, 2, 0, 0),
  [86] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_increment_expression, 2, 0, 0),
  [88] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, 0, 0),
  [90] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [92] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [94] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [96] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [98] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [102] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [104] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [106] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [108] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decrement_expression, 2, 0, 0),
  [114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decrement_expression, 2, 0, 0),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, 0, 14),
  [118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, 0, 14),
  [120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_expression, 3, 0, 0),
  [122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_inputs, 2, 0, 0),
  [124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_inputs, 2, 0, 0),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1, 0, 8),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_expression_repeat1, 2, 0, 0),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration, 4, 0, 23),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__signal_declaration, 3, 0, 16),
  [154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__signal_declaration, 4, 0, 23),
  [156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration, 3, 0, 16),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 21),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [172] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [216] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(52),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0),
  [221] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(101),
  [224] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(242),
  [227] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(102),
  [230] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(282),
  [233] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(284),
  [236] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(285),
  [239] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(103),
  [242] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(156),
  [245] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(241),
  [248] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(100),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(99),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(2),
  [257] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(43),
  [260] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_body_repeat1, 2, 0, 0), SHIFT_REPEAT(276),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3, 0, 0),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3, 0, 0),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_component_declaration_statement, 4, 0, 17),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_component_declaration_statement, 4, 0, 17),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, 0, 0),
  [387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, 0, 0),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration_statement, 4, 0, 17),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration_statement, 4, 0, 17),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration_statement, 3, 0, 11),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration_statement, 3, 0, 11),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_statement, 2, 0, 0),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression_statement, 2, 0, 0),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 7, 0, 0),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 7, 0, 0),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, 0, 0),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, 0, 0),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_declaration_statement, 6, 0, 26),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signal_declaration_statement, 6, 0, 26),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 6, 0, 0),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 6, 0, 0),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_declaration_statement, 5, 0, 24),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signal_declaration_statement, 5, 0, 24),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_declaration_statement, 5, 0, 25),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signal_declaration_statement, 5, 0, 25),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 2, 0, 0),
  [431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 2, 0, 0),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5, 0, 0),
  [435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5, 0, 0),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_declaration_statement, 4, 0, 19),
  [439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signal_declaration_statement, 4, 0, 19),
  [441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_declaration_statement, 4, 0, 17),
  [443] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signal_declaration_statement, 4, 0, 17),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_declaration_statement, 3, 0, 11),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signal_declaration_statement, 3, 0, 11),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 3, 0, 0),
  [451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 3, 0, 0),
  [453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_component_declaration_statement, 3, 0, 11),
  [455] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_component_declaration_statement, 3, 0, 11),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [459] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(175),
  [462] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(226),
  [465] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(183),
  [468] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(303),
  [471] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(302),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_type_repeat1, 2, 0, 0),
  [484] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_type_repeat1, 2, 0, 0), SHIFT_REPEAT(105),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type, 1, 0, 0),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__signal_declaration, 1, 0, 3),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pragma_directive, 3, 0, 0),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_definition, 4, 0, 4),
  [499] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_body, 2, 0, 0),
  [501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_type_repeat1, 3, 0, 0),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_directive, 3, 0, 2),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_definition, 5, 0, 5),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 4, 0, 4),
  [509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_body, 3, 0, 0),
  [511] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_main_component_definition, 6, 0, 9),
  [513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration, 1, 0, 3),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_main_component_definition, 5, 0, 6),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_body, 3, 0, 0),
  [521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__component_declaration, 1, 0, 3),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_body, 2, 0, 0),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [545] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_expression_repeat1, 2, 0, 0), SHIFT_REPEAT(98),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [570] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [592] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(195),
  [595] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(195),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0),
  [610] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0), SHIFT_REPEAT(201),
  [613] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0), SHIFT_REPEAT(201),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__signal_declaration, 2, 0, 10),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [624] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(244),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 0),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [631] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_signal_tags_repeat1, 2, 0, 0),
  [647] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_signal_tags_repeat1, 2, 0, 0), SHIFT_REPEAT(297),
  [650] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_declaration_statement_repeat1, 2, 0, 18), SHIFT_REPEAT(261),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_declaration_statement_repeat1, 2, 0, 18),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__component_declaration, 2, 0, 10),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [663] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_component_declaration_statement_repeat1, 2, 0, 18), SHIFT_REPEAT(269),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_component_declaration_statement_repeat1, 2, 0, 18),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2, 0, 15),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration, 2, 0, 10),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [688] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_signal_declaration_statement_repeat1, 2, 0, 18), SHIFT_REPEAT(251),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_signal_declaration_statement_repeat1, 2, 0, 18),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1, 0, 3),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [707] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 22), SHIFT_REPEAT(88),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 22),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__component_declaration, 4, 0, 23),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_declaration_statement_repeat1, 2, 0, 11),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__component_declaration, 3, 0, 16),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_visibility, 1, 0, 0),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_signal_declaration_statement_repeat1, 2, 0, 11),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_component_declaration_statement_repeat1, 2, 0, 11),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3, 0, 0),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_circom_pragma_token, 2, 0, 1),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2, 0, 0),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_type, 1, 0, 0),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4, 0, 0),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_main_component_public_signals, 7, 0, 0),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_tags, 4, 0, 0),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_main_component_public_signals, 6, 0, 0),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signal_tags, 3, 0, 0),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_circom_custom_templates_token, 1, 0, 0),
  [802] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_circom(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
