// Copyright (C) 2018 Torbjorn Sjostrand.
// PYTHIA is licenced under the GNU GPL v2 or later, see COPYING for details.
// Please respect the MCnet Guidelines, see GUIDELINES for details.
// Author: Philip Ilten, March 2016.

// This file contains a Python interface to Pythia 8 generated with SWIG.

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.8
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGPYTHON
#define SWIGPYTHON
#endif

#define SWIG_DIRECTORS
#define SWIG_PYTHON_DIRECTOR_NO_VTABLE


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


#if defined(_DEBUG) && defined(SWIG_PYTHON_INTERPRETER_NO_DEBUG)
/* Use debug wrappers with the Python release dll */
# undef _DEBUG
# include <Python.h>
# define _DEBUG
#else
# include <Python.h>
#endif

/* -----------------------------------------------------------------------------
 * swigrun.swg
 *
 * This file contains generic C API SWIG runtime support for pointer
 * type checking.
 * ----------------------------------------------------------------------------- */

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "4"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the SWIG runtime code.
  In 99.9% of the cases, SWIG just needs to declare them as 'static'.

  But only do this if strictly necessary, ie, if you have problems
  with your compiler or suchlike.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

/*  Generic buffer size */
#ifndef SWIG_BUFFER_SIZE
# define SWIG_BUFFER_SIZE 1024
#endif

/* Flags for pointer conversions */
#define SWIG_POINTER_DISOWN        0x1
#define SWIG_CAST_NEW_MEMORY       0x2

/* Flags for new pointer objects */
#define SWIG_POINTER_OWN           0x1


/*
   Flags/methods for returning states.

   The SWIG conversion methods, as ConvertPtr, return an integer
   that tells if the conversion was successful or not. And if not,
   an error code can be returned (see swigerrors.swg for the codes).

   Use the following macros/flags to set or process the returning
   states.

   In old versions of SWIG, code such as the following was usually written:

     if (SWIG_ConvertPtr(obj,vptr,ty.flags) != -1) {
       // success code
     } else {
       //fail code
     }

   Now you can be more explicit:

    int res = SWIG_ConvertPtr(obj,vptr,ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
    } else {
      // fail code
    }

   which is the same really, but now you can also do

    Type *ptr;
    int res = SWIG_ConvertPtr(obj,(void **)(&ptr),ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
      if (SWIG_IsNewObj(res) {
        ...
	delete *ptr;
      } else {
        ...
      }
    } else {
      // fail code
    }

   I.e., now SWIG_ConvertPtr can return new objects and you can
   identify the case and take care of the deallocation. Of course that
   also requires SWIG_ConvertPtr to return new result values, such as

      int SWIG_ConvertPtr(obj, ptr,...) {
        if (<obj is ok>) {
          if (<need new object>) {
            *ptr = <ptr to new allocated object>;
            return SWIG_NEWOBJ;
          } else {
            *ptr = <ptr to old object>;
            return SWIG_OLDOBJ;
          }
        } else {
          return SWIG_BADOBJ;
        }
      }

   Of course, returning the plain '0(success)/-1(fail)' still works, but you can be
   more explicit by returning SWIG_BADOBJ, SWIG_ERROR or any of the
   SWIG errors code.

   Finally, if the SWIG_CASTRANK_MODE is enabled, the result code
   allows to return the 'cast rank', for example, if you have this

       int food(double)
       int fooi(int);

   and you call

      food(1)   // cast rank '1'  (1 -> 1.0)
      fooi(1)   // cast rank '0'

   just use the SWIG_AddCast()/SWIG_CheckState()
*/

#define SWIG_OK                    (0)
#define SWIG_ERROR                 (-1)
#define SWIG_IsOK(r)               (r >= 0)
#define SWIG_ArgError(r)           ((r != SWIG_ERROR) ? r : SWIG_TypeError)

/* The CastRankLimit says how many bits are used for the cast rank */
#define SWIG_CASTRANKLIMIT         (1 << 8)
/* The NewMask denotes the object was created (using new/malloc) */
#define SWIG_NEWOBJMASK            (SWIG_CASTRANKLIMIT  << 1)
/* The TmpMask is for in/out typemaps that use temporal objects */
#define SWIG_TMPOBJMASK            (SWIG_NEWOBJMASK << 1)
/* Simple returning values */
#define SWIG_BADOBJ                (SWIG_ERROR)
#define SWIG_OLDOBJ                (SWIG_OK)
#define SWIG_NEWOBJ                (SWIG_OK | SWIG_NEWOBJMASK)
#define SWIG_TMPOBJ                (SWIG_OK | SWIG_TMPOBJMASK)
/* Check, add and del mask methods */
#define SWIG_AddNewMask(r)         (SWIG_IsOK(r) ? (r | SWIG_NEWOBJMASK) : r)
#define SWIG_DelNewMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_NEWOBJMASK) : r)
#define SWIG_IsNewObj(r)           (SWIG_IsOK(r) && (r & SWIG_NEWOBJMASK))
#define SWIG_AddTmpMask(r)         (SWIG_IsOK(r) ? (r | SWIG_TMPOBJMASK) : r)
#define SWIG_DelTmpMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_TMPOBJMASK) : r)
#define SWIG_IsTmpObj(r)           (SWIG_IsOK(r) && (r & SWIG_TMPOBJMASK))

/* Cast-Rank Mode */
#if defined(SWIG_CASTRANK_MODE)
#  ifndef SWIG_TypeRank
#    define SWIG_TypeRank             unsigned long
#  endif
#  ifndef SWIG_MAXCASTRANK            /* Default cast allowed */
#    define SWIG_MAXCASTRANK          (2)
#  endif
#  define SWIG_CASTRANKMASK          ((SWIG_CASTRANKLIMIT) -1)
#  define SWIG_CastRank(r)           (r & SWIG_CASTRANKMASK)
SWIGINTERNINLINE int SWIG_AddCast(int r) {
  return SWIG_IsOK(r) ? ((SWIG_CastRank(r) < SWIG_MAXCASTRANK) ? (r + 1) : SWIG_ERROR) : r;
}
SWIGINTERNINLINE int SWIG_CheckState(int r) {
  return SWIG_IsOK(r) ? SWIG_CastRank(r) + 1 : 0;
}
#else /* no cast-rank mode */
#  define SWIG_AddCast(r) (r)
#  define SWIG_CheckState(r) (SWIG_IsOK(r) ? 1 : 0)
#endif


#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *, int *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store information on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
  int                    owndata;		/* flag if the structure owns the clientdata */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;

/*
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (*f1 > *f2) ? 1 : -1;
  }
  return (int)((l1 - f1) - (l2 - f2));
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCmp(const char *nb, const char *tb) {
  int equiv = 1;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (equiv != 0 && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te);
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  return SWIG_TypeCmp(nb, tb) == 0 ? 1 : 0;
}

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  if (ty) {
    swig_cast_info *iter = ty->cast;
    while (iter) {
      if (strcmp(iter->type->name, c) == 0) {
        if (iter == ty->cast)
          return iter;
        /* Move iter to the top of the linked list */
        iter->prev->next = iter->next;
        if (iter->next)
          iter->next->prev = iter->prev;
        iter->next = ty->cast;
        iter->prev = 0;
        if (ty->cast) ty->cast->prev = iter;
        ty->cast = iter;
        return iter;
      }
      iter = iter->next;
    }
  }
  return 0;
}

/*
  Identical to SWIG_TypeCheck, except strcmp is replaced with a pointer comparison
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *ty) {
  if (ty) {
    swig_cast_info *iter = ty->cast;
    while (iter) {
      if (iter->type == from) {
        if (iter == ty->cast)
          return iter;
        /* Move iter to the top of the linked list */
        iter->prev->next = iter->next;
        if (iter->next)
          iter->next->prev = iter->prev;
        iter->next = ty->cast;
        iter->prev = 0;
        if (ty->cast) ty->cast->prev = iter;
        ty->cast = iter;
        return iter;
      }
      iter = iter->next;
    }
  }
  return 0;
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr, int *newmemory) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr, newmemory);
}

/*
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (!type) return NULL;
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/*
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;

  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }
    cast = cast->next;
  }
}
SWIGRUNTIME void
SWIG_TypeNewClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientData(ti, clientdata);
  ti->owndata = 1;
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)

  We start searching at module start, and finish searching when start == end.
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start,
                            swig_module_info *end,
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      size_t l = 0;
      size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	size_t i = (l + r) >> 1;
	const char *iname = iter->types[i]->name;
	if (iname) {
	  int compare = strcmp(name, iname);
	  if (compare == 0) {
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).

  We start searching at module start, and finish searching when start == end.
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start,
                     swig_module_info *end,
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }

  /* neither found a match */
  return 0;
}

/*
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  const unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/*
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    char d = *(c++);
    unsigned char uu;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/*
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13



/* Compatibility macros for Python 3 */
#if PY_VERSION_HEX >= 0x03000000

#define PyClass_Check(obj) PyObject_IsInstance(obj, (PyObject *)&PyType_Type)
#define PyInt_Check(x) PyLong_Check(x)
#define PyInt_AsLong(x) PyLong_AsLong(x)
#define PyInt_FromLong(x) PyLong_FromLong(x)
#define PyInt_FromSize_t(x) PyLong_FromSize_t(x)
#define PyString_Check(name) PyBytes_Check(name)
#define PyString_FromString(x) PyUnicode_FromString(x)
#define PyString_Format(fmt, args)  PyUnicode_Format(fmt, args)
#define PyString_AsString(str) PyBytes_AsString(str)
#define PyString_Size(str) PyBytes_Size(str)	
#define PyString_InternFromString(key) PyUnicode_InternFromString(key)
#define Py_TPFLAGS_HAVE_CLASS Py_TPFLAGS_BASETYPE
#define PyString_AS_STRING(x) PyUnicode_AS_STRING(x)
#define _PyLong_FromSsize_t(x) PyLong_FromSsize_t(x)

#endif

#ifndef Py_TYPE
#  define Py_TYPE(op) ((op)->ob_type)
#endif

/* SWIG APIs for compatibility of both Python 2 & 3 */

#if PY_VERSION_HEX >= 0x03000000
#  define SWIG_Python_str_FromFormat PyUnicode_FromFormat
#else
#  define SWIG_Python_str_FromFormat PyString_FromFormat
#endif


/* Warning: This function will allocate a new string in Python 3,
 * so please call SWIG_Python_str_DelForPy3(x) to free the space.
 */
SWIGINTERN char*
SWIG_Python_str_AsChar(PyObject *str)
{
#if PY_VERSION_HEX >= 0x03000000
  char *cstr;
  char *newstr;
  Py_ssize_t len;
  str = PyUnicode_AsUTF8String(str);
  PyBytes_AsStringAndSize(str, &cstr, &len);
  newstr = (char *) malloc(len+1);
  memcpy(newstr, cstr, len+1);
  Py_XDECREF(str);
  return newstr;
#else
  return PyString_AsString(str);
#endif
}

#if PY_VERSION_HEX >= 0x03000000
#  define SWIG_Python_str_DelForPy3(x) free( (void*) (x) )
#else
#  define SWIG_Python_str_DelForPy3(x) 
#endif


SWIGINTERN PyObject*
SWIG_Python_str_FromChar(const char *c)
{
#if PY_VERSION_HEX >= 0x03000000
  return PyUnicode_FromString(c); 
#else
  return PyString_FromString(c);
#endif
}

/* Add PyOS_snprintf for old Pythons */
#if PY_VERSION_HEX < 0x02020000
# if defined(_MSC_VER) || defined(__BORLANDC__) || defined(_WATCOM)
#  define PyOS_snprintf _snprintf
# else
#  define PyOS_snprintf snprintf
# endif
#endif

/* A crude PyString_FromFormat implementation for old Pythons */
#if PY_VERSION_HEX < 0x02020000

#ifndef SWIG_PYBUFFER_SIZE
# define SWIG_PYBUFFER_SIZE 1024
#endif

static PyObject *
PyString_FromFormat(const char *fmt, ...) {
  va_list ap;
  char buf[SWIG_PYBUFFER_SIZE * 2];
  int res;
  va_start(ap, fmt);
  res = vsnprintf(buf, sizeof(buf), fmt, ap);
  va_end(ap);
  return (res < 0 || res >= (int)sizeof(buf)) ? 0 : PyString_FromString(buf);
}
#endif

/* Add PyObject_Del for old Pythons */
#if PY_VERSION_HEX < 0x01060000
# define PyObject_Del(op) PyMem_DEL((op))
#endif
#ifndef PyObject_DEL
# define PyObject_DEL PyObject_Del
#endif

/* A crude PyExc_StopIteration exception for old Pythons */
#if PY_VERSION_HEX < 0x02020000
# ifndef PyExc_StopIteration
#  define PyExc_StopIteration PyExc_RuntimeError
# endif
# ifndef PyObject_GenericGetAttr
#  define PyObject_GenericGetAttr 0
# endif
#endif

/* Py_NotImplemented is defined in 2.1 and up. */
#if PY_VERSION_HEX < 0x02010000
# ifndef Py_NotImplemented
#  define Py_NotImplemented PyExc_RuntimeError
# endif
#endif

/* A crude PyString_AsStringAndSize implementation for old Pythons */
#if PY_VERSION_HEX < 0x02010000
# ifndef PyString_AsStringAndSize
#  define PyString_AsStringAndSize(obj, s, len) {*s = PyString_AsString(obj); *len = *s ? strlen(*s) : 0;}
# endif
#endif

/* PySequence_Size for old Pythons */
#if PY_VERSION_HEX < 0x02000000
# ifndef PySequence_Size
#  define PySequence_Size PySequence_Length
# endif
#endif

/* PyBool_FromLong for old Pythons */
#if PY_VERSION_HEX < 0x02030000
static
PyObject *PyBool_FromLong(long ok)
{
  PyObject *result = ok ? Py_True : Py_False;
  Py_INCREF(result);
  return result;
}
#endif

/* Py_ssize_t for old Pythons */
/* This code is as recommended by: */
/* http://www.python.org/dev/peps/pep-0353/#conversion-guidelines */
#if PY_VERSION_HEX < 0x02050000 && !defined(PY_SSIZE_T_MIN)
typedef int Py_ssize_t;
# define PY_SSIZE_T_MAX INT_MAX
# define PY_SSIZE_T_MIN INT_MIN
typedef inquiry lenfunc;
typedef intargfunc ssizeargfunc;
typedef intintargfunc ssizessizeargfunc;
typedef intobjargproc ssizeobjargproc;
typedef intintobjargproc ssizessizeobjargproc;
typedef getreadbufferproc readbufferproc;
typedef getwritebufferproc writebufferproc;
typedef getsegcountproc segcountproc;
typedef getcharbufferproc charbufferproc;
static long PyNumber_AsSsize_t (PyObject *x, void *SWIGUNUSEDPARM(exc))
{
  long result = 0;
  PyObject *i = PyNumber_Int(x);
  if (i) {
    result = PyInt_AsLong(i);
    Py_DECREF(i);
  }
  return result;
}
#endif

#if PY_VERSION_HEX < 0x02050000
#define PyInt_FromSize_t(x) PyInt_FromLong((long)x)
#endif

#if PY_VERSION_HEX < 0x02040000
#define Py_VISIT(op)				\
  do { 						\
    if (op) {					\
      int vret = visit((op), arg);		\
      if (vret)					\
        return vret;				\
    }						\
  } while (0)
#endif

#if PY_VERSION_HEX < 0x02030000
typedef struct {
  PyTypeObject type;
  PyNumberMethods as_number;
  PyMappingMethods as_mapping;
  PySequenceMethods as_sequence;
  PyBufferProcs as_buffer;
  PyObject *name, *slots;
} PyHeapTypeObject;
#endif

#if PY_VERSION_HEX < 0x02030000
typedef destructor freefunc;
#endif

#if ((PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION > 6) || \
     (PY_MAJOR_VERSION == 3 && PY_MINOR_VERSION > 0) || \
     (PY_MAJOR_VERSION > 3))
# define SWIGPY_USE_CAPSULE
# define SWIGPY_CAPSULE_NAME ((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION ".type_pointer_capsule" SWIG_TYPE_TABLE_NAME)
#endif

#if PY_VERSION_HEX < 0x03020000
#define PyDescr_TYPE(x) (((PyDescrObject *)(x))->d_type)
#define PyDescr_NAME(x) (((PyDescrObject *)(x))->d_name)
#endif

/* -----------------------------------------------------------------------------
 * error manipulation
 * ----------------------------------------------------------------------------- */

SWIGRUNTIME PyObject*
SWIG_Python_ErrorType(int code) {
  PyObject* type = 0;
  switch(code) {
  case SWIG_MemoryError:
    type = PyExc_MemoryError;
    break;
  case SWIG_IOError:
    type = PyExc_IOError;
    break;
  case SWIG_RuntimeError:
    type = PyExc_RuntimeError;
    break;
  case SWIG_IndexError:
    type = PyExc_IndexError;
    break;
  case SWIG_TypeError:
    type = PyExc_TypeError;
    break;
  case SWIG_DivisionByZero:
    type = PyExc_ZeroDivisionError;
    break;
  case SWIG_OverflowError:
    type = PyExc_OverflowError;
    break;
  case SWIG_SyntaxError:
    type = PyExc_SyntaxError;
    break;
  case SWIG_ValueError:
    type = PyExc_ValueError;
    break;
  case SWIG_SystemError:
    type = PyExc_SystemError;
    break;
  case SWIG_AttributeError:
    type = PyExc_AttributeError;
    break;
  default:
    type = PyExc_RuntimeError;
  }
  return type;
}


SWIGRUNTIME void
SWIG_Python_AddErrorMsg(const char* mesg)
{
  PyObject *type = 0;
  PyObject *value = 0;
  PyObject *traceback = 0;

  if (PyErr_Occurred()) PyErr_Fetch(&type, &value, &traceback);
  if (value) {
    char *tmp;
    PyObject *old_str = PyObject_Str(value);
    PyErr_Clear();
    Py_XINCREF(type);

    PyErr_Format(type, "%s %s", tmp = SWIG_Python_str_AsChar(old_str), mesg);
    SWIG_Python_str_DelForPy3(tmp);
    Py_DECREF(old_str);
    Py_DECREF(value);
  } else {
    PyErr_SetString(PyExc_RuntimeError, mesg);
  }
}

#if defined(SWIG_PYTHON_NO_THREADS)
#  if defined(SWIG_PYTHON_THREADS)
#    undef SWIG_PYTHON_THREADS
#  endif
#endif
#if defined(SWIG_PYTHON_THREADS) /* Threading support is enabled */
#  if !defined(SWIG_PYTHON_USE_GIL) && !defined(SWIG_PYTHON_NO_USE_GIL)
#    if (PY_VERSION_HEX >= 0x02030000) /* For 2.3 or later, use the PyGILState calls */
#      define SWIG_PYTHON_USE_GIL
#    endif
#  endif
#  if defined(SWIG_PYTHON_USE_GIL) /* Use PyGILState threads calls */
#    ifndef SWIG_PYTHON_INITIALIZE_THREADS
#     define SWIG_PYTHON_INITIALIZE_THREADS  PyEval_InitThreads() 
#    endif
#    ifdef __cplusplus /* C++ code */
       class SWIG_Python_Thread_Block {
         bool status;
         PyGILState_STATE state;
       public:
         void end() { if (status) { PyGILState_Release(state); status = false;} }
         SWIG_Python_Thread_Block() : status(true), state(PyGILState_Ensure()) {}
         ~SWIG_Python_Thread_Block() { end(); }
       };
       class SWIG_Python_Thread_Allow {
         bool status;
         PyThreadState *save;
       public:
         void end() { if (status) { PyEval_RestoreThread(save); status = false; }}
         SWIG_Python_Thread_Allow() : status(true), save(PyEval_SaveThread()) {}
         ~SWIG_Python_Thread_Allow() { end(); }
       };
#      define SWIG_PYTHON_THREAD_BEGIN_BLOCK   SWIG_Python_Thread_Block _swig_thread_block
#      define SWIG_PYTHON_THREAD_END_BLOCK     _swig_thread_block.end()
#      define SWIG_PYTHON_THREAD_BEGIN_ALLOW   SWIG_Python_Thread_Allow _swig_thread_allow
#      define SWIG_PYTHON_THREAD_END_ALLOW     _swig_thread_allow.end()
#    else /* C code */
#      define SWIG_PYTHON_THREAD_BEGIN_BLOCK   PyGILState_STATE _swig_thread_block = PyGILState_Ensure()
#      define SWIG_PYTHON_THREAD_END_BLOCK     PyGILState_Release(_swig_thread_block)
#      define SWIG_PYTHON_THREAD_BEGIN_ALLOW   PyThreadState *_swig_thread_allow = PyEval_SaveThread()
#      define SWIG_PYTHON_THREAD_END_ALLOW     PyEval_RestoreThread(_swig_thread_allow)
#    endif
#  else /* Old thread way, not implemented, user must provide it */
#    if !defined(SWIG_PYTHON_INITIALIZE_THREADS)
#      define SWIG_PYTHON_INITIALIZE_THREADS
#    endif
#    if !defined(SWIG_PYTHON_THREAD_BEGIN_BLOCK)
#      define SWIG_PYTHON_THREAD_BEGIN_BLOCK
#    endif
#    if !defined(SWIG_PYTHON_THREAD_END_BLOCK)
#      define SWIG_PYTHON_THREAD_END_BLOCK
#    endif
#    if !defined(SWIG_PYTHON_THREAD_BEGIN_ALLOW)
#      define SWIG_PYTHON_THREAD_BEGIN_ALLOW
#    endif
#    if !defined(SWIG_PYTHON_THREAD_END_ALLOW)
#      define SWIG_PYTHON_THREAD_END_ALLOW
#    endif
#  endif
#else /* No thread support */
#  define SWIG_PYTHON_INITIALIZE_THREADS
#  define SWIG_PYTHON_THREAD_BEGIN_BLOCK
#  define SWIG_PYTHON_THREAD_END_BLOCK
#  define SWIG_PYTHON_THREAD_BEGIN_ALLOW
#  define SWIG_PYTHON_THREAD_END_ALLOW
#endif

/* -----------------------------------------------------------------------------
 * Python API portion that goes into the runtime
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * Constant declarations
 * ----------------------------------------------------------------------------- */

/* Constant Types */
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Constant information structure */
typedef struct swig_const_info {
  int type;
  char *name;
  long lvalue;
  double dvalue;
  void   *pvalue;
  swig_type_info **ptype;
} swig_const_info;


/* -----------------------------------------------------------------------------
 * Wrapper of PyInstanceMethod_New() used in Python 3
 * It is exported to the generated module, used for -fastproxy
 * ----------------------------------------------------------------------------- */
#if PY_VERSION_HEX >= 0x03000000
SWIGRUNTIME PyObject* SWIG_PyInstanceMethod_New(PyObject *SWIGUNUSEDPARM(self), PyObject *func)
{
  return PyInstanceMethod_New(func);
}
#else
SWIGRUNTIME PyObject* SWIG_PyInstanceMethod_New(PyObject *SWIGUNUSEDPARM(self), PyObject *SWIGUNUSEDPARM(func))
{
  return NULL;
}
#endif

#ifdef __cplusplus
}
#endif


/* -----------------------------------------------------------------------------
 * pyrun.swg
 *
 * This file contains the runtime support for Python modules
 * and includes code for managing global variables and pointer
 * type checking.
 *
 * ----------------------------------------------------------------------------- */

/* Common SWIG API */

/* for raw pointers */
#define SWIG_Python_ConvertPtr(obj, pptr, type, flags)  SWIG_Python_ConvertPtrAndOwn(obj, pptr, type, flags, 0)
#define SWIG_ConvertPtr(obj, pptr, type, flags)         SWIG_Python_ConvertPtr(obj, pptr, type, flags)
#define SWIG_ConvertPtrAndOwn(obj,pptr,type,flags,own)  SWIG_Python_ConvertPtrAndOwn(obj, pptr, type, flags, own)

#ifdef SWIGPYTHON_BUILTIN
#define SWIG_NewPointerObj(ptr, type, flags)            SWIG_Python_NewPointerObj(self, ptr, type, flags)
#else
#define SWIG_NewPointerObj(ptr, type, flags)            SWIG_Python_NewPointerObj(NULL, ptr, type, flags)
#endif

#define SWIG_InternalNewPointerObj(ptr, type, flags)	SWIG_Python_NewPointerObj(NULL, ptr, type, flags)

#define SWIG_CheckImplicit(ty)                          SWIG_Python_CheckImplicit(ty) 
#define SWIG_AcquirePtr(ptr, src)                       SWIG_Python_AcquirePtr(ptr, src)
#define swig_owntype                                    int

/* for raw packed data */
#define SWIG_ConvertPacked(obj, ptr, sz, ty)            SWIG_Python_ConvertPacked(obj, ptr, sz, ty)
#define SWIG_NewPackedObj(ptr, sz, type)                SWIG_Python_NewPackedObj(ptr, sz, type)

/* for class or struct pointers */
#define SWIG_ConvertInstance(obj, pptr, type, flags)    SWIG_ConvertPtr(obj, pptr, type, flags)
#define SWIG_NewInstanceObj(ptr, type, flags)           SWIG_NewPointerObj(ptr, type, flags)

/* for C or C++ function pointers */
#define SWIG_ConvertFunctionPtr(obj, pptr, type)        SWIG_Python_ConvertFunctionPtr(obj, pptr, type)
#define SWIG_NewFunctionPtrObj(ptr, type)               SWIG_Python_NewPointerObj(NULL, ptr, type, 0)

/* for C++ member pointers, ie, member methods */
#define SWIG_ConvertMember(obj, ptr, sz, ty)            SWIG_Python_ConvertPacked(obj, ptr, sz, ty)
#define SWIG_NewMemberObj(ptr, sz, type)                SWIG_Python_NewPackedObj(ptr, sz, type)


/* Runtime API */

#define SWIG_GetModule(clientdata)                      SWIG_Python_GetModule(clientdata)
#define SWIG_SetModule(clientdata, pointer)             SWIG_Python_SetModule(pointer)
#define SWIG_NewClientData(obj)                         SwigPyClientData_New(obj)

#define SWIG_SetErrorObj                                SWIG_Python_SetErrorObj                            
#define SWIG_SetErrorMsg                        	SWIG_Python_SetErrorMsg				   
#define SWIG_ErrorType(code)                    	SWIG_Python_ErrorType(code)                        
#define SWIG_Error(code, msg)            		SWIG_Python_SetErrorMsg(SWIG_ErrorType(code), msg) 
#define SWIG_fail                        		goto fail					   


/* Runtime API implementation */

/* Error manipulation */

SWIGINTERN void 
SWIG_Python_SetErrorObj(PyObject *errtype, PyObject *obj) {
  SWIG_PYTHON_THREAD_BEGIN_BLOCK; 
  PyErr_SetObject(errtype, obj);
  Py_DECREF(obj);
  SWIG_PYTHON_THREAD_END_BLOCK;
}

SWIGINTERN void 
SWIG_Python_SetErrorMsg(PyObject *errtype, const char *msg) {
  SWIG_PYTHON_THREAD_BEGIN_BLOCK;
  PyErr_SetString(errtype, msg);
  SWIG_PYTHON_THREAD_END_BLOCK;
}

#define SWIG_Python_Raise(obj, type, desc)  SWIG_Python_SetErrorObj(SWIG_Python_ExceptionType(desc), obj)

/* Set a constant value */

#if defined(SWIGPYTHON_BUILTIN)

SWIGINTERN void
SwigPyBuiltin_AddPublicSymbol(PyObject *seq, const char *key) {
  PyObject *s = PyString_InternFromString(key);
  PyList_Append(seq, s);
  Py_DECREF(s);
}

SWIGINTERN void
SWIG_Python_SetConstant(PyObject *d, PyObject *public_interface, const char *name, PyObject *obj) {   
#if PY_VERSION_HEX < 0x02030000
  PyDict_SetItemString(d, (char *)name, obj);
#else
  PyDict_SetItemString(d, name, obj);
#endif
  Py_DECREF(obj);
  if (public_interface)
    SwigPyBuiltin_AddPublicSymbol(public_interface, name);
}

#else

SWIGINTERN void
SWIG_Python_SetConstant(PyObject *d, const char *name, PyObject *obj) {   
#if PY_VERSION_HEX < 0x02030000
  PyDict_SetItemString(d, (char *)name, obj);
#else
  PyDict_SetItemString(d, name, obj);
#endif
  Py_DECREF(obj);                            
}

#endif

/* Append a value to the result obj */

SWIGINTERN PyObject*
SWIG_Python_AppendOutput(PyObject* result, PyObject* obj) {
#if !defined(SWIG_PYTHON_OUTPUT_TUPLE)
  if (!result) {
    result = obj;
  } else if (result == Py_None) {
    Py_DECREF(result);
    result = obj;
  } else {
    if (!PyList_Check(result)) {
      PyObject *o2 = result;
      result = PyList_New(1);
      PyList_SetItem(result, 0, o2);
    }
    PyList_Append(result,obj);
    Py_DECREF(obj);
  }
  return result;
#else
  PyObject*   o2;
  PyObject*   o3;
  if (!result) {
    result = obj;
  } else if (result == Py_None) {
    Py_DECREF(result);
    result = obj;
  } else {
    if (!PyTuple_Check(result)) {
      o2 = result;
      result = PyTuple_New(1);
      PyTuple_SET_ITEM(result, 0, o2);
    }
    o3 = PyTuple_New(1);
    PyTuple_SET_ITEM(o3, 0, obj);
    o2 = result;
    result = PySequence_Concat(o2, o3);
    Py_DECREF(o2);
    Py_DECREF(o3);
  }
  return result;
#endif
}

/* Unpack the argument tuple */

SWIGINTERN Py_ssize_t
SWIG_Python_UnpackTuple(PyObject *args, const char *name, Py_ssize_t min, Py_ssize_t max, PyObject **objs)
{
  if (!args) {
    if (!min && !max) {
      return 1;
    } else {
      PyErr_Format(PyExc_TypeError, "%s expected %s%d arguments, got none", 
		   name, (min == max ? "" : "at least "), (int)min);
      return 0;
    }
  }  
  if (!PyTuple_Check(args)) {
    if (min <= 1 && max >= 1) {
      Py_ssize_t i;
      objs[0] = args;
      for (i = 1; i < max; ++i) {
	objs[i] = 0;
      }
      return 2;
    }
    PyErr_SetString(PyExc_SystemError, "UnpackTuple() argument list is not a tuple");
    return 0;
  } else {
    Py_ssize_t l = PyTuple_GET_SIZE(args);
    if (l < min) {
      PyErr_Format(PyExc_TypeError, "%s expected %s%d arguments, got %d", 
		   name, (min == max ? "" : "at least "), (int)min, (int)l);
      return 0;
    } else if (l > max) {
      PyErr_Format(PyExc_TypeError, "%s expected %s%d arguments, got %d", 
		   name, (min == max ? "" : "at most "), (int)max, (int)l);
      return 0;
    } else {
      Py_ssize_t i;
      for (i = 0; i < l; ++i) {
	objs[i] = PyTuple_GET_ITEM(args, i);
      }
      for (; l < max; ++l) {
	objs[l] = 0;
      }
      return i + 1;
    }    
  }
}

/* A functor is a function object with one single object argument */
#if PY_VERSION_HEX >= 0x02020000
#define SWIG_Python_CallFunctor(functor, obj)	        PyObject_CallFunctionObjArgs(functor, obj, NULL);
#else
#define SWIG_Python_CallFunctor(functor, obj)	        PyObject_CallFunction(functor, "O", obj);
#endif

/*
  Helper for static pointer initialization for both C and C++ code, for example
  static PyObject *SWIG_STATIC_POINTER(MyVar) = NewSomething(...);
*/
#ifdef __cplusplus
#define SWIG_STATIC_POINTER(var)  var
#else
#define SWIG_STATIC_POINTER(var)  var = 0; if (!var) var
#endif

/* -----------------------------------------------------------------------------
 * Pointer declarations
 * ----------------------------------------------------------------------------- */

/* Flags for new pointer objects */
#define SWIG_POINTER_NOSHADOW       (SWIG_POINTER_OWN      << 1)
#define SWIG_POINTER_NEW            (SWIG_POINTER_NOSHADOW | SWIG_POINTER_OWN)

#define SWIG_POINTER_IMPLICIT_CONV  (SWIG_POINTER_DISOWN   << 1)

#define SWIG_BUILTIN_TP_INIT	    (SWIG_POINTER_OWN << 2)
#define SWIG_BUILTIN_INIT	    (SWIG_BUILTIN_TP_INIT | SWIG_POINTER_OWN)

#ifdef __cplusplus
extern "C" {
#endif

/*  How to access Py_None */
#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  ifndef SWIG_PYTHON_NO_BUILD_NONE
#    ifndef SWIG_PYTHON_BUILD_NONE
#      define SWIG_PYTHON_BUILD_NONE
#    endif
#  endif
#endif

#ifdef SWIG_PYTHON_BUILD_NONE
#  ifdef Py_None
#   undef Py_None
#   define Py_None SWIG_Py_None()
#  endif
SWIGRUNTIMEINLINE PyObject * 
_SWIG_Py_None(void)
{
  PyObject *none = Py_BuildValue((char*)"");
  Py_DECREF(none);
  return none;
}
SWIGRUNTIME PyObject * 
SWIG_Py_None(void)
{
  static PyObject *SWIG_STATIC_POINTER(none) = _SWIG_Py_None();
  return none;
}
#endif

/* The python void return value */

SWIGRUNTIMEINLINE PyObject * 
SWIG_Py_Void(void)
{
  PyObject *none = Py_None;
  Py_INCREF(none);
  return none;
}

/* SwigPyClientData */

typedef struct {
  PyObject *klass;
  PyObject *newraw;
  PyObject *newargs;
  PyObject *destroy;
  int delargs;
  int implicitconv;
  PyTypeObject *pytype;
} SwigPyClientData;

SWIGRUNTIMEINLINE int 
SWIG_Python_CheckImplicit(swig_type_info *ty)
{
  SwigPyClientData *data = (SwigPyClientData *)ty->clientdata;
  return data ? data->implicitconv : 0;
}

SWIGRUNTIMEINLINE PyObject *
SWIG_Python_ExceptionType(swig_type_info *desc) {
  SwigPyClientData *data = desc ? (SwigPyClientData *) desc->clientdata : 0;
  PyObject *klass = data ? data->klass : 0;
  return (klass ? klass : PyExc_RuntimeError);
}


SWIGRUNTIME SwigPyClientData * 
SwigPyClientData_New(PyObject* obj)
{
  if (!obj) {
    return 0;
  } else {
    SwigPyClientData *data = (SwigPyClientData *)malloc(sizeof(SwigPyClientData));
    /* the klass element */
    data->klass = obj;
    Py_INCREF(data->klass);
    /* the newraw method and newargs arguments used to create a new raw instance */
    if (PyClass_Check(obj)) {
      data->newraw = 0;
      data->newargs = obj;
      Py_INCREF(obj);
    } else {
#if (PY_VERSION_HEX < 0x02020000)
      data->newraw = 0;
#else
      data->newraw = PyObject_GetAttrString(data->klass, (char *)"__new__");
#endif
      if (data->newraw) {
	Py_INCREF(data->newraw);
	data->newargs = PyTuple_New(1);
	PyTuple_SetItem(data->newargs, 0, obj);
      } else {
	data->newargs = obj;
      }
      Py_INCREF(data->newargs);
    }
    /* the destroy method, aka as the C++ delete method */
    data->destroy = PyObject_GetAttrString(data->klass, (char *)"__swig_destroy__");
    if (PyErr_Occurred()) {
      PyErr_Clear();
      data->destroy = 0;
    }
    if (data->destroy) {
      int flags;
      Py_INCREF(data->destroy);
      flags = PyCFunction_GET_FLAGS(data->destroy);
#ifdef METH_O
      data->delargs = !(flags & (METH_O));
#else
      data->delargs = 0;
#endif
    } else {
      data->delargs = 0;
    }
    data->implicitconv = 0;
    data->pytype = 0;
    return data;
  }
}

SWIGRUNTIME void 
SwigPyClientData_Del(SwigPyClientData *data) {
  Py_XDECREF(data->newraw);
  Py_XDECREF(data->newargs);
  Py_XDECREF(data->destroy);
}

/* =============== SwigPyObject =====================*/

typedef struct {
  PyObject_HEAD
  void *ptr;
  swig_type_info *ty;
  int own;
  PyObject *next;
#ifdef SWIGPYTHON_BUILTIN
  PyObject *dict;
#endif
} SwigPyObject;


#ifdef SWIGPYTHON_BUILTIN

SWIGRUNTIME PyObject *
SwigPyObject_get___dict__(PyObject *v, PyObject *SWIGUNUSEDPARM(args))
{
  SwigPyObject *sobj = (SwigPyObject *)v;

  if (!sobj->dict)
    sobj->dict = PyDict_New();

  Py_INCREF(sobj->dict);
  return sobj->dict;
}

#endif

SWIGRUNTIME PyObject *
SwigPyObject_long(SwigPyObject *v)
{
  return PyLong_FromVoidPtr(v->ptr);
}

SWIGRUNTIME PyObject *
SwigPyObject_format(const char* fmt, SwigPyObject *v)
{
  PyObject *res = NULL;
  PyObject *args = PyTuple_New(1);
  if (args) {
    if (PyTuple_SetItem(args, 0, SwigPyObject_long(v)) == 0) {
      PyObject *ofmt = SWIG_Python_str_FromChar(fmt);
      if (ofmt) {
#if PY_VERSION_HEX >= 0x03000000
	res = PyUnicode_Format(ofmt,args);
#else
	res = PyString_Format(ofmt,args);
#endif
	Py_DECREF(ofmt);
      }
      Py_DECREF(args);
    }
  }
  return res;
}

SWIGRUNTIME PyObject *
SwigPyObject_oct(SwigPyObject *v)
{
  return SwigPyObject_format("%o",v);
}

SWIGRUNTIME PyObject *
SwigPyObject_hex(SwigPyObject *v)
{
  return SwigPyObject_format("%x",v);
}

SWIGRUNTIME PyObject *
#ifdef METH_NOARGS
SwigPyObject_repr(SwigPyObject *v)
#else
SwigPyObject_repr(SwigPyObject *v, PyObject *args)
#endif
{
  const char *name = SWIG_TypePrettyName(v->ty);
  PyObject *repr = SWIG_Python_str_FromFormat("<Swig Object of type '%s' at %p>", (name ? name : "unknown"), (void *)v);
  if (v->next) {
# ifdef METH_NOARGS
    PyObject *nrep = SwigPyObject_repr((SwigPyObject *)v->next);
# else
    PyObject *nrep = SwigPyObject_repr((SwigPyObject *)v->next, args);
# endif
# if PY_VERSION_HEX >= 0x03000000
    PyObject *joined = PyUnicode_Concat(repr, nrep);
    Py_DecRef(repr);
    Py_DecRef(nrep);
    repr = joined;
# else
    PyString_ConcatAndDel(&repr,nrep);
# endif
  }
  return repr;  
}

SWIGRUNTIME int
SwigPyObject_compare(SwigPyObject *v, SwigPyObject *w)
{
  void *i = v->ptr;
  void *j = w->ptr;
  return (i < j) ? -1 : ((i > j) ? 1 : 0);
}

/* Added for Python 3.x, would it also be useful for Python 2.x? */
SWIGRUNTIME PyObject*
SwigPyObject_richcompare(SwigPyObject *v, SwigPyObject *w, int op)
{
  PyObject* res;
  if( op != Py_EQ && op != Py_NE ) {
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
  }
  res = PyBool_FromLong( (SwigPyObject_compare(v, w)==0) == (op == Py_EQ) ? 1 : 0);
  return res;  
}


SWIGRUNTIME PyTypeObject* SwigPyObject_TypeOnce(void);

#ifdef SWIGPYTHON_BUILTIN
static swig_type_info *SwigPyObject_stype = 0;
SWIGRUNTIME PyTypeObject*
SwigPyObject_type(void) {
    SwigPyClientData *cd;
    assert(SwigPyObject_stype);
    cd = (SwigPyClientData*) SwigPyObject_stype->clientdata;
    assert(cd);
    assert(cd->pytype);
    return cd->pytype;
}
#else
SWIGRUNTIME PyTypeObject*
SwigPyObject_type(void) {
  static PyTypeObject *SWIG_STATIC_POINTER(type) = SwigPyObject_TypeOnce();
  return type;
}
#endif

SWIGRUNTIMEINLINE int
SwigPyObject_Check(PyObject *op) {
#ifdef SWIGPYTHON_BUILTIN
  PyTypeObject *target_tp = SwigPyObject_type();
  if (PyType_IsSubtype(op->ob_type, target_tp))
    return 1;
  return (strcmp(op->ob_type->tp_name, "SwigPyObject") == 0);
#else
  return (Py_TYPE(op) == SwigPyObject_type())
    || (strcmp(Py_TYPE(op)->tp_name,"SwigPyObject") == 0);
#endif
}

SWIGRUNTIME PyObject *
SwigPyObject_New(void *ptr, swig_type_info *ty, int own);

SWIGRUNTIME void
SwigPyObject_dealloc(PyObject *v)
{
  SwigPyObject *sobj = (SwigPyObject *) v;
  PyObject *next = sobj->next;
  if (sobj->own == SWIG_POINTER_OWN) {
    swig_type_info *ty = sobj->ty;
    SwigPyClientData *data = ty ? (SwigPyClientData *) ty->clientdata : 0;
    PyObject *destroy = data ? data->destroy : 0;
    if (destroy) {
      /* destroy is always a VARARGS method */
      PyObject *res;

      /* PyObject_CallFunction() has the potential to silently drop
         the active active exception.  In cases of unnamed temporary
         variable or where we just finished iterating over a generator
         StopIteration will be active right now, and this needs to
         remain true upon return from SwigPyObject_dealloc.  So save
         and restore. */
      
      PyObject *val = NULL, *type = NULL, *tb = NULL;
      PyErr_Fetch(&val, &type, &tb);

      if (data->delargs) {
        /* we need to create a temporary object to carry the destroy operation */
        PyObject *tmp = SwigPyObject_New(sobj->ptr, ty, 0);
        res = SWIG_Python_CallFunctor(destroy, tmp);
        Py_DECREF(tmp);
      } else {
        PyCFunction meth = PyCFunction_GET_FUNCTION(destroy);
        PyObject *mself = PyCFunction_GET_SELF(destroy);
        res = ((*meth)(mself, v));
      }
      if (!res)
        PyErr_WriteUnraisable(destroy);

      PyErr_Restore(val, type, tb);

      Py_XDECREF(res);
    } 
#if !defined(SWIG_PYTHON_SILENT_MEMLEAK)
    else {
      const char *name = SWIG_TypePrettyName(ty);
      printf("swig/python detected a memory leak of type '%s', no destructor found.\n", (name ? name : "unknown"));
    }
#endif
  } 
  Py_XDECREF(next);
  PyObject_DEL(v);
}

SWIGRUNTIME PyObject* 
SwigPyObject_append(PyObject* v, PyObject* next)
{
  SwigPyObject *sobj = (SwigPyObject *) v;
#ifndef METH_O
  PyObject *tmp = 0;
  if (!PyArg_ParseTuple(next,(char *)"O:append", &tmp)) return NULL;
  next = tmp;
#endif
  if (!SwigPyObject_Check(next)) {
    PyErr_SetString(PyExc_TypeError, "Attempt to append a non SwigPyObject");
    return NULL;
  }
  sobj->next = next;
  Py_INCREF(next);
  return SWIG_Py_Void();
}

SWIGRUNTIME PyObject* 
#ifdef METH_NOARGS
SwigPyObject_next(PyObject* v)
#else
SwigPyObject_next(PyObject* v, PyObject *SWIGUNUSEDPARM(args))
#endif
{
  SwigPyObject *sobj = (SwigPyObject *) v;
  if (sobj->next) {    
    Py_INCREF(sobj->next);
    return sobj->next;
  } else {
    return SWIG_Py_Void();
  }
}

SWIGINTERN PyObject*
#ifdef METH_NOARGS
SwigPyObject_disown(PyObject *v)
#else
SwigPyObject_disown(PyObject* v, PyObject *SWIGUNUSEDPARM(args))
#endif
{
  SwigPyObject *sobj = (SwigPyObject *)v;
  sobj->own = 0;
  return SWIG_Py_Void();
}

SWIGINTERN PyObject*
#ifdef METH_NOARGS
SwigPyObject_acquire(PyObject *v)
#else
SwigPyObject_acquire(PyObject* v, PyObject *SWIGUNUSEDPARM(args))
#endif
{
  SwigPyObject *sobj = (SwigPyObject *)v;
  sobj->own = SWIG_POINTER_OWN;
  return SWIG_Py_Void();
}

SWIGINTERN PyObject*
SwigPyObject_own(PyObject *v, PyObject *args)
{
  PyObject *val = 0;
#if (PY_VERSION_HEX < 0x02020000)
  if (!PyArg_ParseTuple(args,(char *)"|O:own",&val))
#elif (PY_VERSION_HEX < 0x02050000)
  if (!PyArg_UnpackTuple(args, (char *)"own", 0, 1, &val)) 
#else
  if (!PyArg_UnpackTuple(args, "own", 0, 1, &val)) 
#endif
    {
      return NULL;
    } 
  else
    {
      SwigPyObject *sobj = (SwigPyObject *)v;
      PyObject *obj = PyBool_FromLong(sobj->own);
      if (val) {
#ifdef METH_NOARGS
	if (PyObject_IsTrue(val)) {
	  SwigPyObject_acquire(v);
	} else {
	  SwigPyObject_disown(v);
	}
#else
	if (PyObject_IsTrue(val)) {
	  SwigPyObject_acquire(v,args);
	} else {
	  SwigPyObject_disown(v,args);
	}
#endif
      } 
      return obj;
    }
}

#ifdef METH_O
static PyMethodDef
swigobject_methods[] = {
  {(char *)"disown",  (PyCFunction)SwigPyObject_disown,  METH_NOARGS,  (char *)"releases ownership of the pointer"},
  {(char *)"acquire", (PyCFunction)SwigPyObject_acquire, METH_NOARGS,  (char *)"acquires ownership of the pointer"},
  {(char *)"own",     (PyCFunction)SwigPyObject_own,     METH_VARARGS, (char *)"returns/sets ownership of the pointer"},
  {(char *)"append",  (PyCFunction)SwigPyObject_append,  METH_O,       (char *)"appends another 'this' object"},
  {(char *)"next",    (PyCFunction)SwigPyObject_next,    METH_NOARGS,  (char *)"returns the next 'this' object"},
  {(char *)"__repr__",(PyCFunction)SwigPyObject_repr,    METH_NOARGS,  (char *)"returns object representation"},
  {0, 0, 0, 0}  
};
#else
static PyMethodDef
swigobject_methods[] = {
  {(char *)"disown",  (PyCFunction)SwigPyObject_disown,  METH_VARARGS,  (char *)"releases ownership of the pointer"},
  {(char *)"acquire", (PyCFunction)SwigPyObject_acquire, METH_VARARGS,  (char *)"acquires ownership of the pointer"},
  {(char *)"own",     (PyCFunction)SwigPyObject_own,     METH_VARARGS,  (char *)"returns/sets ownership of the pointer"},
  {(char *)"append",  (PyCFunction)SwigPyObject_append,  METH_VARARGS,  (char *)"appends another 'this' object"},
  {(char *)"next",    (PyCFunction)SwigPyObject_next,    METH_VARARGS,  (char *)"returns the next 'this' object"},
  {(char *)"__repr__",(PyCFunction)SwigPyObject_repr,   METH_VARARGS,  (char *)"returns object representation"},
  {0, 0, 0, 0}  
};
#endif

#if PY_VERSION_HEX < 0x02020000
SWIGINTERN PyObject *
SwigPyObject_getattr(SwigPyObject *sobj,char *name)
{
  return Py_FindMethod(swigobject_methods, (PyObject *)sobj, name);
}
#endif

SWIGRUNTIME PyTypeObject*
SwigPyObject_TypeOnce(void) {
  static char swigobject_doc[] = "Swig object carries a C/C++ instance pointer";

  static PyNumberMethods SwigPyObject_as_number = {
    (binaryfunc)0, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)0, /*nb_multiply*/
    /* nb_divide removed in Python 3 */
#if PY_VERSION_HEX < 0x03000000
    (binaryfunc)0, /*nb_divide*/
#endif
    (binaryfunc)0, /*nb_remainder*/
    (binaryfunc)0, /*nb_divmod*/
    (ternaryfunc)0,/*nb_power*/
    (unaryfunc)0,  /*nb_negative*/
    (unaryfunc)0,  /*nb_positive*/
    (unaryfunc)0,  /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    0,		   /*nb_invert*/
    0,		   /*nb_lshift*/
    0,		   /*nb_rshift*/
    0,		   /*nb_and*/
    0,		   /*nb_xor*/
    0,		   /*nb_or*/
#if PY_VERSION_HEX < 0x03000000
    0,   /*nb_coerce*/
#endif
    (unaryfunc)SwigPyObject_long, /*nb_int*/
#if PY_VERSION_HEX < 0x03000000
    (unaryfunc)SwigPyObject_long, /*nb_long*/
#else
    0, /*nb_reserved*/
#endif
    (unaryfunc)0,                 /*nb_float*/
#if PY_VERSION_HEX < 0x03000000
    (unaryfunc)SwigPyObject_oct,  /*nb_oct*/
    (unaryfunc)SwigPyObject_hex,  /*nb_hex*/
#endif
#if PY_VERSION_HEX >= 0x03050000 /* 3.5 */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_matrix_multiply */
#elif PY_VERSION_HEX >= 0x03000000 /* 3.0 */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_index, nb_inplace_divide removed */
#elif PY_VERSION_HEX >= 0x02050000 /* 2.5.0 */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_index */
#elif PY_VERSION_HEX >= 0x02020000 /* 2.2.0 */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_true_divide */
#elif PY_VERSION_HEX >= 0x02000000 /* 2.0.0 */
    0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_or */
#endif
  };

  static PyTypeObject swigpyobject_type;
  static int type_init = 0;
  if (!type_init) {
    const PyTypeObject tmp = {
      /* PyObject header changed in Python 3 */
#if PY_VERSION_HEX >= 0x03000000
      PyVarObject_HEAD_INIT(NULL, 0)
#else
      PyObject_HEAD_INIT(NULL)
      0,                                    /* ob_size */
#endif
      (char *)"SwigPyObject",               /* tp_name */
      sizeof(SwigPyObject),                 /* tp_basicsize */
      0,                                    /* tp_itemsize */
      (destructor)SwigPyObject_dealloc,     /* tp_dealloc */
      0,				    /* tp_print */
#if PY_VERSION_HEX < 0x02020000
      (getattrfunc)SwigPyObject_getattr,    /* tp_getattr */
#else
      (getattrfunc)0,                       /* tp_getattr */
#endif
      (setattrfunc)0,                       /* tp_setattr */
#if PY_VERSION_HEX >= 0x03000000
    0, /* tp_reserved in 3.0.1, tp_compare in 3.0.0 but not used */
#else
      (cmpfunc)SwigPyObject_compare,        /* tp_compare */
#endif
      (reprfunc)SwigPyObject_repr,          /* tp_repr */
      &SwigPyObject_as_number,              /* tp_as_number */
      0,                                    /* tp_as_sequence */
      0,                                    /* tp_as_mapping */
      (hashfunc)0,                          /* tp_hash */
      (ternaryfunc)0,                       /* tp_call */
      0,				    /* tp_str */
      PyObject_GenericGetAttr,              /* tp_getattro */
      0,                                    /* tp_setattro */
      0,                                    /* tp_as_buffer */
      Py_TPFLAGS_DEFAULT,                   /* tp_flags */
      swigobject_doc,                       /* tp_doc */
      0,                                    /* tp_traverse */
      0,                                    /* tp_clear */
      (richcmpfunc)SwigPyObject_richcompare,/* tp_richcompare */
      0,                                    /* tp_weaklistoffset */
#if PY_VERSION_HEX >= 0x02020000
      0,                                    /* tp_iter */
      0,                                    /* tp_iternext */
      swigobject_methods,                   /* tp_methods */
      0,                                    /* tp_members */
      0,                                    /* tp_getset */
      0,                                    /* tp_base */
      0,                                    /* tp_dict */
      0,                                    /* tp_descr_get */
      0,                                    /* tp_descr_set */
      0,                                    /* tp_dictoffset */
      0,                                    /* tp_init */
      0,                                    /* tp_alloc */
      0,                                    /* tp_new */
      0,                                    /* tp_free */
      0,                                    /* tp_is_gc */
      0,                                    /* tp_bases */
      0,                                    /* tp_mro */
      0,                                    /* tp_cache */
      0,                                    /* tp_subclasses */
      0,                                    /* tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
      0,                                    /* tp_del */
#endif
#if PY_VERSION_HEX >= 0x02060000
      0,                                    /* tp_version_tag */
#endif
#if PY_VERSION_HEX >= 0x03040000
      0,                                    /* tp_finalize */
#endif
#ifdef COUNT_ALLOCS
      0,                                    /* tp_allocs */
      0,                                    /* tp_frees */
      0,                                    /* tp_maxalloc */
#if PY_VERSION_HEX >= 0x02050000
      0,                                    /* tp_prev */
#endif
      0                                     /* tp_next */
#endif
    };
    swigpyobject_type = tmp;
    type_init = 1;
#if PY_VERSION_HEX < 0x02020000
    swigpyobject_type.ob_type = &PyType_Type;
#else
    if (PyType_Ready(&swigpyobject_type) < 0)
      return NULL;
#endif
  }
  return &swigpyobject_type;
}

SWIGRUNTIME PyObject *
SwigPyObject_New(void *ptr, swig_type_info *ty, int own)
{
  SwigPyObject *sobj = PyObject_NEW(SwigPyObject, SwigPyObject_type());
  if (sobj) {
    sobj->ptr  = ptr;
    sobj->ty   = ty;
    sobj->own  = own;
    sobj->next = 0;
  }
  return (PyObject *)sobj;
}

/* -----------------------------------------------------------------------------
 * Implements a simple Swig Packed type, and use it instead of string
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *pack;
  swig_type_info *ty;
  size_t size;
} SwigPyPacked;

SWIGRUNTIME int
SwigPyPacked_print(SwigPyPacked *v, FILE *fp, int SWIGUNUSEDPARM(flags))
{
  char result[SWIG_BUFFER_SIZE];
  fputs("<Swig Packed ", fp); 
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    fputs("at ", fp); 
    fputs(result, fp); 
  }
  fputs(v->ty->name,fp); 
  fputs(">", fp);
  return 0; 
}
  
SWIGRUNTIME PyObject *
SwigPyPacked_repr(SwigPyPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    return SWIG_Python_str_FromFormat("<Swig Packed at %s%s>", result, v->ty->name);
  } else {
    return SWIG_Python_str_FromFormat("<Swig Packed %s>", v->ty->name);
  }  
}

SWIGRUNTIME PyObject *
SwigPyPacked_str(SwigPyPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))){
    return SWIG_Python_str_FromFormat("%s%s", result, v->ty->name);
  } else {
    return SWIG_Python_str_FromChar(v->ty->name);
  }  
}

SWIGRUNTIME int
SwigPyPacked_compare(SwigPyPacked *v, SwigPyPacked *w)
{
  size_t i = v->size;
  size_t j = w->size;
  int s = (i < j) ? -1 : ((i > j) ? 1 : 0);
  return s ? s : strncmp((char *)v->pack, (char *)w->pack, 2*v->size);
}

SWIGRUNTIME PyTypeObject* SwigPyPacked_TypeOnce(void);

SWIGRUNTIME PyTypeObject*
SwigPyPacked_type(void) {
  static PyTypeObject *SWIG_STATIC_POINTER(type) = SwigPyPacked_TypeOnce();
  return type;
}

SWIGRUNTIMEINLINE int
SwigPyPacked_Check(PyObject *op) {
  return ((op)->ob_type == SwigPyPacked_TypeOnce()) 
    || (strcmp((op)->ob_type->tp_name,"SwigPyPacked") == 0);
}

SWIGRUNTIME void
SwigPyPacked_dealloc(PyObject *v)
{
  if (SwigPyPacked_Check(v)) {
    SwigPyPacked *sobj = (SwigPyPacked *) v;
    free(sobj->pack);
  }
  PyObject_DEL(v);
}

SWIGRUNTIME PyTypeObject*
SwigPyPacked_TypeOnce(void) {
  static char swigpacked_doc[] = "Swig object carries a C/C++ instance pointer";
  static PyTypeObject swigpypacked_type;
  static int type_init = 0;
  if (!type_init) {
    const PyTypeObject tmp = {
      /* PyObject header changed in Python 3 */
#if PY_VERSION_HEX>=0x03000000
      PyVarObject_HEAD_INIT(NULL, 0)
#else
      PyObject_HEAD_INIT(NULL)
      0,                                    /* ob_size */
#endif
      (char *)"SwigPyPacked",               /* tp_name */
      sizeof(SwigPyPacked),                 /* tp_basicsize */
      0,                                    /* tp_itemsize */
      (destructor)SwigPyPacked_dealloc,     /* tp_dealloc */
      (printfunc)SwigPyPacked_print,        /* tp_print */
      (getattrfunc)0,                       /* tp_getattr */
      (setattrfunc)0,                       /* tp_setattr */
#if PY_VERSION_HEX>=0x03000000
      0, /* tp_reserved in 3.0.1 */
#else
      (cmpfunc)SwigPyPacked_compare,        /* tp_compare */
#endif
      (reprfunc)SwigPyPacked_repr,          /* tp_repr */
      0,                                    /* tp_as_number */
      0,                                    /* tp_as_sequence */
      0,                                    /* tp_as_mapping */
      (hashfunc)0,                          /* tp_hash */
      (ternaryfunc)0,                       /* tp_call */
      (reprfunc)SwigPyPacked_str,           /* tp_str */
      PyObject_GenericGetAttr,              /* tp_getattro */
      0,                                    /* tp_setattro */
      0,                                    /* tp_as_buffer */
      Py_TPFLAGS_DEFAULT,                   /* tp_flags */
      swigpacked_doc,                       /* tp_doc */
      0,                                    /* tp_traverse */
      0,                                    /* tp_clear */
      0,                                    /* tp_richcompare */
      0,                                    /* tp_weaklistoffset */
#if PY_VERSION_HEX >= 0x02020000
      0,                                    /* tp_iter */
      0,                                    /* tp_iternext */
      0,                                    /* tp_methods */
      0,                                    /* tp_members */
      0,                                    /* tp_getset */
      0,                                    /* tp_base */
      0,                                    /* tp_dict */
      0,                                    /* tp_descr_get */
      0,                                    /* tp_descr_set */
      0,                                    /* tp_dictoffset */
      0,                                    /* tp_init */
      0,                                    /* tp_alloc */
      0,                                    /* tp_new */
      0,                                    /* tp_free */
      0,                                    /* tp_is_gc */
      0,                                    /* tp_bases */
      0,                                    /* tp_mro */
      0,                                    /* tp_cache */
      0,                                    /* tp_subclasses */
      0,                                    /* tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
      0,                                    /* tp_del */
#endif
#if PY_VERSION_HEX >= 0x02060000
      0,                                    /* tp_version_tag */
#endif
#if PY_VERSION_HEX >= 0x03040000
      0,                                    /* tp_finalize */
#endif
#ifdef COUNT_ALLOCS
      0,                                    /* tp_allocs */
      0,                                    /* tp_frees */
      0,                                    /* tp_maxalloc */
#if PY_VERSION_HEX >= 0x02050000
      0,                                    /* tp_prev */
#endif
      0                                     /* tp_next */
#endif
    };
    swigpypacked_type = tmp;
    type_init = 1;
#if PY_VERSION_HEX < 0x02020000
    swigpypacked_type.ob_type = &PyType_Type;
#else
    if (PyType_Ready(&swigpypacked_type) < 0)
      return NULL;
#endif
  }
  return &swigpypacked_type;
}

SWIGRUNTIME PyObject *
SwigPyPacked_New(void *ptr, size_t size, swig_type_info *ty)
{
  SwigPyPacked *sobj = PyObject_NEW(SwigPyPacked, SwigPyPacked_type());
  if (sobj) {
    void *pack = malloc(size);
    if (pack) {
      memcpy(pack, ptr, size);
      sobj->pack = pack;
      sobj->ty   = ty;
      sobj->size = size;
    } else {
      PyObject_DEL((PyObject *) sobj);
      sobj = 0;
    }
  }
  return (PyObject *) sobj;
}

SWIGRUNTIME swig_type_info *
SwigPyPacked_UnpackData(PyObject *obj, void *ptr, size_t size)
{
  if (SwigPyPacked_Check(obj)) {
    SwigPyPacked *sobj = (SwigPyPacked *)obj;
    if (sobj->size != size) return 0;
    memcpy(ptr, sobj->pack, size);
    return sobj->ty;
  } else {
    return 0;
  }
}

/* -----------------------------------------------------------------------------
 * pointers/data manipulation
 * ----------------------------------------------------------------------------- */

SWIGRUNTIMEINLINE PyObject *
_SWIG_This(void)
{
    return SWIG_Python_str_FromChar("this");
}

static PyObject *swig_this = NULL;

SWIGRUNTIME PyObject *
SWIG_This(void)
{
  if (swig_this == NULL)
    swig_this = _SWIG_This();
  return swig_this;
}

/* #define SWIG_PYTHON_SLOW_GETSET_THIS */

/* TODO: I don't know how to implement the fast getset in Python 3 right now */
#if PY_VERSION_HEX>=0x03000000
#define SWIG_PYTHON_SLOW_GETSET_THIS 
#endif

SWIGRUNTIME SwigPyObject *
SWIG_Python_GetSwigThis(PyObject *pyobj) 
{
  PyObject *obj;

  if (SwigPyObject_Check(pyobj))
    return (SwigPyObject *) pyobj;

#ifdef SWIGPYTHON_BUILTIN
  (void)obj;
# ifdef PyWeakref_CheckProxy
  if (PyWeakref_CheckProxy(pyobj)) {
    pyobj = PyWeakref_GET_OBJECT(pyobj);
    if (pyobj && SwigPyObject_Check(pyobj))
      return (SwigPyObject*) pyobj;
  }
# endif
  return NULL;
#else

  obj = 0;

#if (!defined(SWIG_PYTHON_SLOW_GETSET_THIS) && (PY_VERSION_HEX >= 0x02030000))
  if (PyInstance_Check(pyobj)) {
    obj = _PyInstance_Lookup(pyobj, SWIG_This());      
  } else {
    PyObject **dictptr = _PyObject_GetDictPtr(pyobj);
    if (dictptr != NULL) {
      PyObject *dict = *dictptr;
      obj = dict ? PyDict_GetItem(dict, SWIG_This()) : 0;
    } else {
#ifdef PyWeakref_CheckProxy
      if (PyWeakref_CheckProxy(pyobj)) {
	PyObject *wobj = PyWeakref_GET_OBJECT(pyobj);
	return wobj ? SWIG_Python_GetSwigThis(wobj) : 0;
      }
#endif
      obj = PyObject_GetAttr(pyobj,SWIG_This());
      if (obj) {
	Py_DECREF(obj);
      } else {
	if (PyErr_Occurred()) PyErr_Clear();
	return 0;
      }
    }
  }
#else
  obj = PyObject_GetAttr(pyobj,SWIG_This());
  if (obj) {
    Py_DECREF(obj);
  } else {
    if (PyErr_Occurred()) PyErr_Clear();
    return 0;
  }
#endif
  if (obj && !SwigPyObject_Check(obj)) {
    /* a PyObject is called 'this', try to get the 'real this'
       SwigPyObject from it */ 
    return SWIG_Python_GetSwigThis(obj);
  }
  return (SwigPyObject *)obj;
#endif
}

/* Acquire a pointer value */

SWIGRUNTIME int
SWIG_Python_AcquirePtr(PyObject *obj, int own) {
  if (own == SWIG_POINTER_OWN) {
    SwigPyObject *sobj = SWIG_Python_GetSwigThis(obj);
    if (sobj) {
      int oldown = sobj->own;
      sobj->own = own;
      return oldown;
    }
  }
  return 0;
}

/* Convert a pointer value */

SWIGRUNTIME int
SWIG_Python_ConvertPtrAndOwn(PyObject *obj, void **ptr, swig_type_info *ty, int flags, int *own) {
  int res;
  SwigPyObject *sobj;
  int implicit_conv = (flags & SWIG_POINTER_IMPLICIT_CONV) != 0;

  if (!obj)
    return SWIG_ERROR;
  if (obj == Py_None && !implicit_conv) {
    if (ptr)
      *ptr = 0;
    return SWIG_OK;
  }

  res = SWIG_ERROR;

  sobj = SWIG_Python_GetSwigThis(obj);
  if (own)
    *own = 0;
  while (sobj) {
    void *vptr = sobj->ptr;
    if (ty) {
      swig_type_info *to = sobj->ty;
      if (to == ty) {
        /* no type cast needed */
        if (ptr) *ptr = vptr;
        break;
      } else {
        swig_cast_info *tc = SWIG_TypeCheck(to->name,ty);
        if (!tc) {
          sobj = (SwigPyObject *)sobj->next;
        } else {
          if (ptr) {
            int newmemory = 0;
            *ptr = SWIG_TypeCast(tc,vptr,&newmemory);
            if (newmemory == SWIG_CAST_NEW_MEMORY) {
              assert(own); /* badly formed typemap which will lead to a memory leak - it must set and use own to delete *ptr */
              if (own)
                *own = *own | SWIG_CAST_NEW_MEMORY;
            }
          }
          break;
        }
      }
    } else {
      if (ptr) *ptr = vptr;
      break;
    }
  }
  if (sobj) {
    if (own)
      *own = *own | sobj->own;
    if (flags & SWIG_POINTER_DISOWN) {
      sobj->own = 0;
    }
    res = SWIG_OK;
  } else {
    if (implicit_conv) {
      SwigPyClientData *data = ty ? (SwigPyClientData *) ty->clientdata : 0;
      if (data && !data->implicitconv) {
        PyObject *klass = data->klass;
        if (klass) {
          PyObject *impconv;
          data->implicitconv = 1; /* avoid recursion and call 'explicit' constructors*/
          impconv = SWIG_Python_CallFunctor(klass, obj);
          data->implicitconv = 0;
          if (PyErr_Occurred()) {
            PyErr_Clear();
            impconv = 0;
          }
          if (impconv) {
            SwigPyObject *iobj = SWIG_Python_GetSwigThis(impconv);
            if (iobj) {
              void *vptr;
              res = SWIG_Python_ConvertPtrAndOwn((PyObject*)iobj, &vptr, ty, 0, 0);
              if (SWIG_IsOK(res)) {
                if (ptr) {
                  *ptr = vptr;
                  /* transfer the ownership to 'ptr' */
                  iobj->own = 0;
                  res = SWIG_AddCast(res);
                  res = SWIG_AddNewMask(res);
                } else {
                  res = SWIG_AddCast(res);		    
                }
              }
            }
            Py_DECREF(impconv);
          }
        }
      }
    }
    if (!SWIG_IsOK(res) && obj == Py_None) {
      if (ptr)
        *ptr = 0;
      if (PyErr_Occurred())
        PyErr_Clear();
      res = SWIG_OK;
    }
  }
  return res;
}

/* Convert a function ptr value */

SWIGRUNTIME int
SWIG_Python_ConvertFunctionPtr(PyObject *obj, void **ptr, swig_type_info *ty) {
  if (!PyCFunction_Check(obj)) {
    return SWIG_ConvertPtr(obj, ptr, ty, 0);
  } else {
    void *vptr = 0;
    
    /* here we get the method pointer for callbacks */
    const char *doc = (((PyCFunctionObject *)obj) -> m_ml -> ml_doc);
    const char *desc = doc ? strstr(doc, "swig_ptr: ") : 0;
    if (desc)
      desc = ty ? SWIG_UnpackVoidPtr(desc + 10, &vptr, ty->name) : 0;
    if (!desc) 
      return SWIG_ERROR;
    if (ty) {
      swig_cast_info *tc = SWIG_TypeCheck(desc,ty);
      if (tc) {
        int newmemory = 0;
        *ptr = SWIG_TypeCast(tc,vptr,&newmemory);
        assert(!newmemory); /* newmemory handling not yet implemented */
      } else {
        return SWIG_ERROR;
      }
    } else {
      *ptr = vptr;
    }
    return SWIG_OK;
  }
}

/* Convert a packed value value */

SWIGRUNTIME int
SWIG_Python_ConvertPacked(PyObject *obj, void *ptr, size_t sz, swig_type_info *ty) {
  swig_type_info *to = SwigPyPacked_UnpackData(obj, ptr, sz);
  if (!to) return SWIG_ERROR;
  if (ty) {
    if (to != ty) {
      /* check type cast? */
      swig_cast_info *tc = SWIG_TypeCheck(to->name,ty);
      if (!tc) return SWIG_ERROR;
    }
  }
  return SWIG_OK;
}  

/* -----------------------------------------------------------------------------
 * Create a new pointer object
 * ----------------------------------------------------------------------------- */

/*
  Create a new instance object, without calling __init__, and set the
  'this' attribute.
*/

SWIGRUNTIME PyObject* 
SWIG_Python_NewShadowInstance(SwigPyClientData *data, PyObject *swig_this)
{
#if (PY_VERSION_HEX >= 0x02020000)
  PyObject *inst = 0;
  PyObject *newraw = data->newraw;
  if (newraw) {
    inst = PyObject_Call(newraw, data->newargs, NULL);
    if (inst) {
#if !defined(SWIG_PYTHON_SLOW_GETSET_THIS)
      PyObject **dictptr = _PyObject_GetDictPtr(inst);
      if (dictptr != NULL) {
	PyObject *dict = *dictptr;
	if (dict == NULL) {
	  dict = PyDict_New();
	  *dictptr = dict;
	  PyDict_SetItem(dict, SWIG_This(), swig_this);
	}
      }
#else
      PyObject *key = SWIG_This();
      PyObject_SetAttr(inst, key, swig_this);
#endif
    }
  } else {
#if PY_VERSION_HEX >= 0x03000000
    inst = ((PyTypeObject*) data->newargs)->tp_new((PyTypeObject*) data->newargs, Py_None, Py_None);
    if (inst) {
      PyObject_SetAttr(inst, SWIG_This(), swig_this);
      Py_TYPE(inst)->tp_flags &= ~Py_TPFLAGS_VALID_VERSION_TAG;
    }
#else
    PyObject *dict = PyDict_New();
    if (dict) {
      PyDict_SetItem(dict, SWIG_This(), swig_this);
      inst = PyInstance_NewRaw(data->newargs, dict);
      Py_DECREF(dict);
    }
#endif
  }
  return inst;
#else
#if (PY_VERSION_HEX >= 0x02010000)
  PyObject *inst = 0;
  PyObject *dict = PyDict_New();
  if (dict) {
    PyDict_SetItem(dict, SWIG_This(), swig_this);
    inst = PyInstance_NewRaw(data->newargs, dict);
    Py_DECREF(dict);
  }
  return (PyObject *) inst;
#else
  PyInstanceObject *inst = PyObject_NEW(PyInstanceObject, &PyInstance_Type);
  if (inst == NULL) {
    return NULL;
  }
  inst->in_class = (PyClassObject *)data->newargs;
  Py_INCREF(inst->in_class);
  inst->in_dict = PyDict_New();
  if (inst->in_dict == NULL) {
    Py_DECREF(inst);
    return NULL;
  }
#ifdef Py_TPFLAGS_HAVE_WEAKREFS
  inst->in_weakreflist = NULL;
#endif
#ifdef Py_TPFLAGS_GC
  PyObject_GC_Init(inst);
#endif
  PyDict_SetItem(inst->in_dict, SWIG_This(), swig_this);
  return (PyObject *) inst;
#endif
#endif
}

SWIGRUNTIME void
SWIG_Python_SetSwigThis(PyObject *inst, PyObject *swig_this)
{
 PyObject *dict;
#if (PY_VERSION_HEX >= 0x02020000) && !defined(SWIG_PYTHON_SLOW_GETSET_THIS)
 PyObject **dictptr = _PyObject_GetDictPtr(inst);
 if (dictptr != NULL) {
   dict = *dictptr;
   if (dict == NULL) {
     dict = PyDict_New();
     *dictptr = dict;
   }
   PyDict_SetItem(dict, SWIG_This(), swig_this);
   return;
 }
#endif
 dict = PyObject_GetAttrString(inst, (char*)"__dict__");
 PyDict_SetItem(dict, SWIG_This(), swig_this);
 Py_DECREF(dict);
} 


SWIGINTERN PyObject *
SWIG_Python_InitShadowInstance(PyObject *args) {
  PyObject *obj[2];
  if (!SWIG_Python_UnpackTuple(args, "swiginit", 2, 2, obj)) {
    return NULL;
  } else {
    SwigPyObject *sthis = SWIG_Python_GetSwigThis(obj[0]);
    if (sthis) {
      SwigPyObject_append((PyObject*) sthis, obj[1]);
    } else {
      SWIG_Python_SetSwigThis(obj[0], obj[1]);
    }
    return SWIG_Py_Void();
  }
}

/* Create a new pointer object */

SWIGRUNTIME PyObject *
SWIG_Python_NewPointerObj(PyObject *self, void *ptr, swig_type_info *type, int flags) {
  SwigPyClientData *clientdata;
  PyObject * robj;
  int own;

  if (!ptr)
    return SWIG_Py_Void();

  clientdata = type ? (SwigPyClientData *)(type->clientdata) : 0;
  own = (flags & SWIG_POINTER_OWN) ? SWIG_POINTER_OWN : 0;
  if (clientdata && clientdata->pytype) {
    SwigPyObject *newobj;
    if (flags & SWIG_BUILTIN_TP_INIT) {
      newobj = (SwigPyObject*) self;
      if (newobj->ptr) {
        PyObject *next_self = clientdata->pytype->tp_alloc(clientdata->pytype, 0);
        while (newobj->next)
	  newobj = (SwigPyObject *) newobj->next;
        newobj->next = next_self;
        newobj = (SwigPyObject *)next_self;
#ifdef SWIGPYTHON_BUILTIN
        newobj->dict = 0;
#endif
      }
    } else {
      newobj = PyObject_New(SwigPyObject, clientdata->pytype);
#ifdef SWIGPYTHON_BUILTIN
      newobj->dict = 0;
#endif
    }
    if (newobj) {
      newobj->ptr = ptr;
      newobj->ty = type;
      newobj->own = own;
      newobj->next = 0;
      return (PyObject*) newobj;
    }
    return SWIG_Py_Void();
  }

  assert(!(flags & SWIG_BUILTIN_TP_INIT));

  robj = SwigPyObject_New(ptr, type, own);
  if (robj && clientdata && !(flags & SWIG_POINTER_NOSHADOW)) {
    PyObject *inst = SWIG_Python_NewShadowInstance(clientdata, robj);
    Py_DECREF(robj);
    robj = inst;
  }
  return robj;
}

/* Create a new packed object */

SWIGRUNTIMEINLINE PyObject *
SWIG_Python_NewPackedObj(void *ptr, size_t sz, swig_type_info *type) {
  return ptr ? SwigPyPacked_New((void *) ptr, sz, type) : SWIG_Py_Void();
}

/* -----------------------------------------------------------------------------*
 *  Get type list 
 * -----------------------------------------------------------------------------*/

#ifdef SWIG_LINK_RUNTIME
void *SWIG_ReturnGlobalTypeList(void *);
#endif

SWIGRUNTIME swig_module_info *
SWIG_Python_GetModule(void *SWIGUNUSEDPARM(clientdata)) {
  static void *type_pointer = (void *)0;
  /* first check if module already created */
  if (!type_pointer) {
#ifdef SWIG_LINK_RUNTIME
    type_pointer = SWIG_ReturnGlobalTypeList((void *)0);
#else
# ifdef SWIGPY_USE_CAPSULE
    type_pointer = PyCapsule_Import(SWIGPY_CAPSULE_NAME, 0);
# else
    type_pointer = PyCObject_Import((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
				    (char*)"type_pointer" SWIG_TYPE_TABLE_NAME);
# endif
    if (PyErr_Occurred()) {
      PyErr_Clear();
      type_pointer = (void *)0;
    }
#endif
  }
  return (swig_module_info *) type_pointer;
}

#if PY_MAJOR_VERSION < 2
/* PyModule_AddObject function was introduced in Python 2.0.  The following function
   is copied out of Python/modsupport.c in python version 2.3.4 */
SWIGINTERN int
PyModule_AddObject(PyObject *m, char *name, PyObject *o)
{
  PyObject *dict;
  if (!PyModule_Check(m)) {
    PyErr_SetString(PyExc_TypeError, "PyModule_AddObject() needs module as first arg");
    return SWIG_ERROR;
  }
  if (!o) {
    PyErr_SetString(PyExc_TypeError, "PyModule_AddObject() needs non-NULL value");
    return SWIG_ERROR;
  }
  
  dict = PyModule_GetDict(m);
  if (dict == NULL) {
    /* Internal error -- modules must have a dict! */
    PyErr_Format(PyExc_SystemError, "module '%s' has no __dict__",
		 PyModule_GetName(m));
    return SWIG_ERROR;
  }
  if (PyDict_SetItemString(dict, name, o))
    return SWIG_ERROR;
  Py_DECREF(o);
  return SWIG_OK;
}
#endif

SWIGRUNTIME void
#ifdef SWIGPY_USE_CAPSULE
SWIG_Python_DestroyModule(PyObject *obj)
#else
SWIG_Python_DestroyModule(void *vptr)
#endif
{
#ifdef SWIGPY_USE_CAPSULE
  swig_module_info *swig_module = (swig_module_info *) PyCapsule_GetPointer(obj, SWIGPY_CAPSULE_NAME);
#else
  swig_module_info *swig_module = (swig_module_info *) vptr;
#endif
  swig_type_info **types = swig_module->types;
  size_t i;
  for (i =0; i < swig_module->size; ++i) {
    swig_type_info *ty = types[i];
    if (ty->owndata) {
      SwigPyClientData *data = (SwigPyClientData *) ty->clientdata;
      if (data) SwigPyClientData_Del(data);
    }
  }
  Py_DECREF(SWIG_This());
  swig_this = NULL;
}

SWIGRUNTIME void
SWIG_Python_SetModule(swig_module_info *swig_module) {
#if PY_VERSION_HEX >= 0x03000000
 /* Add a dummy module object into sys.modules */
  PyObject *module = PyImport_AddModule((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION);
#else
  static PyMethodDef swig_empty_runtime_method_table[] = { {NULL, NULL, 0, NULL} }; /* Sentinel */
  PyObject *module = Py_InitModule((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION, swig_empty_runtime_method_table);
#endif
#ifdef SWIGPY_USE_CAPSULE
  PyObject *pointer = PyCapsule_New((void *) swig_module, SWIGPY_CAPSULE_NAME, SWIG_Python_DestroyModule);
  if (pointer && module) {
    PyModule_AddObject(module, (char*)"type_pointer_capsule" SWIG_TYPE_TABLE_NAME, pointer);
  } else {
    Py_XDECREF(pointer);
  }
#else
  PyObject *pointer = PyCObject_FromVoidPtr((void *) swig_module, SWIG_Python_DestroyModule);
  if (pointer && module) {
    PyModule_AddObject(module, (char*)"type_pointer" SWIG_TYPE_TABLE_NAME, pointer);
  } else {
    Py_XDECREF(pointer);
  }
#endif
}

/* The python cached type query */
SWIGRUNTIME PyObject *
SWIG_Python_TypeCache(void) {
  static PyObject *SWIG_STATIC_POINTER(cache) = PyDict_New();
  return cache;
}

SWIGRUNTIME swig_type_info *
SWIG_Python_TypeQuery(const char *type)
{
  PyObject *cache = SWIG_Python_TypeCache();
  PyObject *key = SWIG_Python_str_FromChar(type); 
  PyObject *obj = PyDict_GetItem(cache, key);
  swig_type_info *descriptor;
  if (obj) {
#ifdef SWIGPY_USE_CAPSULE
    descriptor = (swig_type_info *) PyCapsule_GetPointer(obj, NULL);
#else
    descriptor = (swig_type_info *) PyCObject_AsVoidPtr(obj);
#endif
  } else {
    swig_module_info *swig_module = SWIG_GetModule(0);
    descriptor = SWIG_TypeQueryModule(swig_module, swig_module, type);
    if (descriptor) {
#ifdef SWIGPY_USE_CAPSULE
      obj = PyCapsule_New((void*) descriptor, NULL, NULL);
#else
      obj = PyCObject_FromVoidPtr(descriptor, NULL);
#endif
      PyDict_SetItem(cache, key, obj);
      Py_DECREF(obj);
    }
  }
  Py_DECREF(key);
  return descriptor;
}

/* 
   For backward compatibility only
*/
#define SWIG_POINTER_EXCEPTION  0
#define SWIG_arg_fail(arg)      SWIG_Python_ArgFail(arg)
#define SWIG_MustGetPtr(p, type, argnum, flags)  SWIG_Python_MustGetPtr(p, type, argnum, flags)

SWIGRUNTIME int
SWIG_Python_AddErrMesg(const char* mesg, int infront)
{  
  if (PyErr_Occurred()) {
    PyObject *type = 0;
    PyObject *value = 0;
    PyObject *traceback = 0;
    PyErr_Fetch(&type, &value, &traceback);
    if (value) {
      char *tmp;
      PyObject *old_str = PyObject_Str(value);
      Py_XINCREF(type);
      PyErr_Clear();
      if (infront) {
	PyErr_Format(type, "%s %s", mesg, tmp = SWIG_Python_str_AsChar(old_str));
      } else {
	PyErr_Format(type, "%s %s", tmp = SWIG_Python_str_AsChar(old_str), mesg);
      }
      SWIG_Python_str_DelForPy3(tmp);
      Py_DECREF(old_str);
    }
    return 1;
  } else {
    return 0;
  }
}
  
SWIGRUNTIME int
SWIG_Python_ArgFail(int argnum)
{
  if (PyErr_Occurred()) {
    /* add information about failing argument */
    char mesg[256];
    PyOS_snprintf(mesg, sizeof(mesg), "argument number %d:", argnum);
    return SWIG_Python_AddErrMesg(mesg, 1);
  } else {
    return 0;
  }
}

SWIGRUNTIMEINLINE const char *
SwigPyObject_GetDesc(PyObject *self)
{
  SwigPyObject *v = (SwigPyObject *)self;
  swig_type_info *ty = v ? v->ty : 0;
  return ty ? ty->str : "";
}

SWIGRUNTIME void
SWIG_Python_TypeError(const char *type, PyObject *obj)
{
  if (type) {
#if defined(SWIG_COBJECT_TYPES)
    if (obj && SwigPyObject_Check(obj)) {
      const char *otype = (const char *) SwigPyObject_GetDesc(obj);
      if (otype) {
	PyErr_Format(PyExc_TypeError, "a '%s' is expected, 'SwigPyObject(%s)' is received",
		     type, otype);
	return;
      }
    } else 
#endif      
    {
      const char *otype = (obj ? obj->ob_type->tp_name : 0); 
      if (otype) {
	PyObject *str = PyObject_Str(obj);
	const char *cstr = str ? SWIG_Python_str_AsChar(str) : 0;
	if (cstr) {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s(%s)' is received",
		       type, otype, cstr);
          SWIG_Python_str_DelForPy3(cstr);
	} else {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s' is received",
		       type, otype);
	}
	Py_XDECREF(str);
	return;
      }
    }   
    PyErr_Format(PyExc_TypeError, "a '%s' is expected", type);
  } else {
    PyErr_Format(PyExc_TypeError, "unexpected type is received");
  }
}


/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME void *
SWIG_Python_MustGetPtr(PyObject *obj, swig_type_info *ty, int SWIGUNUSEDPARM(argnum), int flags) {
  void *result;
  if (SWIG_Python_ConvertPtr(obj, &result, ty, flags) == -1) {
    PyErr_Clear();
#if SWIG_POINTER_EXCEPTION
    if (flags) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
      SWIG_Python_ArgFail(argnum);
    }
#endif
  }
  return result;
}

#ifdef SWIGPYTHON_BUILTIN
SWIGRUNTIME int
SWIG_Python_NonDynamicSetAttr(PyObject *obj, PyObject *name, PyObject *value) {
  PyTypeObject *tp = obj->ob_type;
  PyObject *descr;
  PyObject *encoded_name;
  descrsetfunc f;
  int res = -1;

# ifdef Py_USING_UNICODE
  if (PyString_Check(name)) {
    name = PyUnicode_Decode(PyString_AsString(name), PyString_Size(name), NULL, NULL);
    if (!name)
      return -1;
  } else if (!PyUnicode_Check(name))
# else
  if (!PyString_Check(name))
# endif
  {
    PyErr_Format(PyExc_TypeError, "attribute name must be string, not '%.200s'", name->ob_type->tp_name);
    return -1;
  } else {
    Py_INCREF(name);
  }

  if (!tp->tp_dict) {
    if (PyType_Ready(tp) < 0)
      goto done;
  }

  descr = _PyType_Lookup(tp, name);
  f = NULL;
  if (descr != NULL)
    f = descr->ob_type->tp_descr_set;
  if (!f) {
    if (PyString_Check(name)) {
      encoded_name = name;
      Py_INCREF(name);
    } else {
      encoded_name = PyUnicode_AsUTF8String(name);
    }
    PyErr_Format(PyExc_AttributeError, "'%.100s' object has no attribute '%.200s'", tp->tp_name, PyString_AsString(encoded_name));
    Py_DECREF(encoded_name);
  } else {
    res = f(descr, obj, value);
  }
  
  done:
  Py_DECREF(name);
  return res;
}
#endif


#ifdef __cplusplus
}
#endif



#define SWIG_exception_fail(code, msg) do { SWIG_Error(code, msg); SWIG_fail; } while(0) 

#define SWIG_contract_assert(expr, msg) if (!(expr)) { SWIG_Error(SWIG_RuntimeError, msg); SWIG_fail; } else 



  #define SWIG_exception(code, msg) do { SWIG_Error(code, msg); SWIG_fail;; } while(0) 

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Python proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#ifndef SWIG_DIRECTOR_PYTHON_HEADER_
#define SWIG_DIRECTOR_PYTHON_HEADER_

#include <string>
#include <iostream>
#include <exception>
#include <vector>
#include <map>


/*
  Use -DSWIG_PYTHON_DIRECTOR_NO_VTABLE if you don't want to generate a 'virtual
  table', and avoid multiple GetAttr calls to retrieve the python
  methods.
*/

#ifndef SWIG_PYTHON_DIRECTOR_NO_VTABLE
#ifndef SWIG_PYTHON_DIRECTOR_VTABLE
#define SWIG_PYTHON_DIRECTOR_VTABLE
#endif
#endif



/*
  Use -DSWIG_DIRECTOR_NO_UEH if you prefer to avoid the use of the
  Undefined Exception Handler provided by swig.
*/
#ifndef SWIG_DIRECTOR_NO_UEH
#ifndef SWIG_DIRECTOR_UEH
#define SWIG_DIRECTOR_UEH
#endif
#endif


/*
  Use -DSWIG_DIRECTOR_NORTTI if you prefer to avoid the use of the
  native C++ RTTI and dynamic_cast<>. But be aware that directors
  could stop working when using this option.
*/
#ifdef SWIG_DIRECTOR_NORTTI
/*
   When we don't use the native C++ RTTI, we implement a minimal one
   only for Directors.
*/
# ifndef SWIG_DIRECTOR_RTDIR
# define SWIG_DIRECTOR_RTDIR

namespace Swig {
  class Director;
  SWIGINTERN std::map<void *, Director *>& get_rtdir_map() {
    static std::map<void *, Director *> rtdir_map;
    return rtdir_map;
  }

  SWIGINTERNINLINE void set_rtdir(void *vptr, Director *rtdir) {
    get_rtdir_map()[vptr] = rtdir;
  }

  SWIGINTERNINLINE Director *get_rtdir(void *vptr) {
    std::map<void *, Director *>::const_iterator pos = get_rtdir_map().find(vptr);
    Director *rtdir = (pos != get_rtdir_map().end()) ? pos->second : 0;
    return rtdir;
  }
}
# endif /* SWIG_DIRECTOR_RTDIR */

# define SWIG_DIRECTOR_CAST(ARG) Swig::get_rtdir(static_cast<void *>(ARG))
# define SWIG_DIRECTOR_RGTR(ARG1, ARG2) Swig::set_rtdir(static_cast<void *>(ARG1), ARG2)

#else

# define SWIG_DIRECTOR_CAST(ARG) dynamic_cast<Swig::Director *>(ARG)
# define SWIG_DIRECTOR_RGTR(ARG1, ARG2)

#endif /* SWIG_DIRECTOR_NORTTI */

extern "C" {
  struct swig_type_info;
}

namespace Swig {

  /* memory handler */
  struct GCItem {
    virtual ~GCItem() {}

    virtual int get_own() const {
      return 0;
    }
  };

  struct GCItem_var {
    GCItem_var(GCItem *item = 0) : _item(item) {
    }

    GCItem_var& operator=(GCItem *item) {
      GCItem *tmp = _item;
      _item = item;
      delete tmp;
      return *this;
    }

    ~GCItem_var() {
      delete _item;
    }

    GCItem * operator->() const {
      return _item;
    }

  private:
    GCItem *_item;
  };

  struct GCItem_Object : GCItem {
    GCItem_Object(int own) : _own(own) {
    }

    virtual ~GCItem_Object() {
    }

    int get_own() const {
      return _own;
    }

  private:
    int _own;
  };

  template <typename Type>
  struct GCItem_T : GCItem {
    GCItem_T(Type *ptr) : _ptr(ptr) {
    }

    virtual ~GCItem_T() {
      delete _ptr;
    }

  private:
    Type *_ptr;
  };

  template <typename Type>
  struct GCArray_T : GCItem {
    GCArray_T(Type *ptr) : _ptr(ptr) {
    }

    virtual ~GCArray_T() {
      delete[] _ptr;
    }

  private:
    Type *_ptr;
  };

  /* base class for director exceptions */
  class DirectorException : public std::exception {
  protected:
    std::string swig_msg;
  public:
    DirectorException(PyObject *error, const char *hdr ="", const char *msg ="") : swig_msg(hdr) {
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (msg[0]) {
        swig_msg += " ";
        swig_msg += msg;
      }
      if (!PyErr_Occurred()) {
        PyErr_SetString(error, what());
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
    }

    virtual ~DirectorException() throw() {
    }

    /* Deprecated, use what() instead */
    const char *getMessage() const {
      return what();
    }

    const char *what() const throw() {
      return swig_msg.c_str();
    }

    static void raise(PyObject *error, const char *msg) {
      throw DirectorException(error, msg);
    }

    static void raise(const char *msg) {
      raise(PyExc_RuntimeError, msg);
    }
  };

  /* unknown exception handler  */
  class UnknownExceptionHandler {
#ifdef SWIG_DIRECTOR_UEH
    static void handler() {
      try {
        throw;
      } catch (DirectorException& e) {
        std::cerr << "SWIG Director exception caught:" << std::endl
                  << e.what() << std::endl;
      } catch (std::exception& e) {
        std::cerr << "std::exception caught: "<< e.what() << std::endl;
      } catch (...) {
        std::cerr << "Unknown exception caught." << std::endl;
      }

      std::cerr << std::endl
                << "Python interpreter traceback:" << std::endl;
      PyErr_Print();
      std::cerr << std::endl;

      std::cerr << "This exception was caught by the SWIG unexpected exception handler." << std::endl
                << "Try using %feature(\"director:except\") to avoid reaching this point." << std::endl
                << std::endl
                << "Exception is being re-thrown, program will likely abort/terminate." << std::endl;
      throw;
    }

  public:

    std::unexpected_handler old;
    UnknownExceptionHandler(std::unexpected_handler nh = handler) {
      old = std::set_unexpected(nh);
    }

    ~UnknownExceptionHandler() {
      std::set_unexpected(old);
    }
#endif
  };

  /* type mismatch in the return value from a python method call */
  class DirectorTypeMismatchException : public DirectorException {
  public:
    DirectorTypeMismatchException(PyObject *error, const char *msg="")
      : DirectorException(error, "SWIG director type mismatch", msg) {
    }

    DirectorTypeMismatchException(const char *msg="")
      : DirectorException(PyExc_TypeError, "SWIG director type mismatch", msg) {
    }

    static void raise(PyObject *error, const char *msg) {
      throw DirectorTypeMismatchException(error, msg);
    }

    static void raise(const char *msg) {
      throw DirectorTypeMismatchException(msg);
    }
  };

  /* any python exception that occurs during a director method call */
  class DirectorMethodException : public DirectorException {
  public:
    DirectorMethodException(const char *msg = "")
      : DirectorException(PyExc_RuntimeError, "SWIG director method error.", msg) {
    }

    static void raise(const char *msg) {
      throw DirectorMethodException(msg);
    }
  };

  /* attempt to call a pure virtual method via a director method */
  class DirectorPureVirtualException : public DirectorException {
  public:
    DirectorPureVirtualException(const char *msg = "")
      : DirectorException(PyExc_RuntimeError, "SWIG director pure virtual method called", msg) {
    }

    static void raise(const char *msg) {
      throw DirectorPureVirtualException(msg);
    }
  };


#if defined(SWIG_PYTHON_THREADS)
/*  __THREAD__ is the old macro to activate some thread support */
# if !defined(__THREAD__)
#   define __THREAD__ 1
# endif
#endif

#ifdef __THREAD__
# include "pythread.h"
  class Guard {
    PyThread_type_lock &mutex_;

  public:
    Guard(PyThread_type_lock & mutex) : mutex_(mutex) {
      PyThread_acquire_lock(mutex_, WAIT_LOCK);
    }

    ~Guard() {
      PyThread_release_lock(mutex_);
    }
  };
# define SWIG_GUARD(mutex) Guard _guard(mutex)
#else
# define SWIG_GUARD(mutex)
#endif

  /* director base class */
  class Director {
  private:
    /* pointer to the wrapped python object */
    PyObject *swig_self;
    /* flag indicating whether the object is owned by python or c++ */
    mutable bool swig_disown_flag;

    /* decrement the reference count of the wrapped python object */
    void swig_decref() const {
      if (swig_disown_flag) {
        SWIG_PYTHON_THREAD_BEGIN_BLOCK;
        Py_DECREF(swig_self);
        SWIG_PYTHON_THREAD_END_BLOCK;
      }
    }

  public:
    /* wrap a python object. */
    Director(PyObject *self) : swig_self(self), swig_disown_flag(false) {
    }

    /* discard our reference at destruction */
    virtual ~Director() {
      swig_decref();
    }

    /* return a pointer to the wrapped python object */
    PyObject *swig_get_self() const {
      return swig_self;
    }

    /* acquire ownership of the wrapped python object (the sense of "disown" is from python) */
    void swig_disown() const {
      if (!swig_disown_flag) {
        swig_disown_flag=true;
        swig_incref();
      }
    }

    /* increase the reference count of the wrapped python object */
    void swig_incref() const {
      if (swig_disown_flag) {
        Py_INCREF(swig_self);
      }
    }

    /* methods to implement pseudo protected director members */
    virtual bool swig_get_inner(const char * /* swig_protected_method_name */) const {
      return true;
    }

    virtual void swig_set_inner(const char * /* swig_protected_method_name */, bool /* swig_val */) const {
    }

  /* ownership management */
  private:
    typedef std::map<void *, GCItem_var> swig_ownership_map;
    mutable swig_ownership_map swig_owner;
#ifdef __THREAD__
    static PyThread_type_lock swig_mutex_own;
#endif

  public:
    template <typename Type>
    void swig_acquire_ownership_array(Type *vptr) const {
      if (vptr) {
        SWIG_GUARD(swig_mutex_own);
        swig_owner[vptr] = new GCArray_T<Type>(vptr);
      }
    }

    template <typename Type>
    void swig_acquire_ownership(Type *vptr) const {
      if (vptr) {
        SWIG_GUARD(swig_mutex_own);
        swig_owner[vptr] = new GCItem_T<Type>(vptr);
      }
    }

    void swig_acquire_ownership_obj(void *vptr, int own) const {
      if (vptr && own) {
        SWIG_GUARD(swig_mutex_own);
        swig_owner[vptr] = new GCItem_Object(own);
      }
    }

    int swig_release_ownership(void *vptr) const {
      int own = 0;
      if (vptr) {
        SWIG_GUARD(swig_mutex_own);
        swig_ownership_map::iterator iter = swig_owner.find(vptr);
        if (iter != swig_owner.end()) {
          own = iter->second->get_own();
          swig_owner.erase(iter);
        }
      }
      return own;
    }

    template <typename Type>
    static PyObject *swig_pyobj_disown(PyObject *pyobj, PyObject *SWIGUNUSEDPARM(args)) {
      SwigPyObject *sobj = (SwigPyObject *)pyobj;
      sobj->own = 0;
      Director *d = SWIG_DIRECTOR_CAST(reinterpret_cast<Type *>(sobj->ptr));
      if (d)
        d->swig_disown();
      return PyWeakref_NewProxy(pyobj, NULL);
    }
  };

#ifdef __THREAD__
  PyThread_type_lock Director::swig_mutex_own = PyThread_allocate_lock();
#endif
}

#endif

/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_Pythia8__AlpgenHooks swig_types[0]
#define SWIGTYPE_p_Pythia8__AlpgenPar swig_types[1]
#define SWIGTYPE_p_Pythia8__AlphaEM swig_types[2]
#define SWIGTYPE_p_Pythia8__AlphaStrong swig_types[3]
#define SWIGTYPE_p_Pythia8__Angantyr swig_types[4]
#define SWIGTYPE_p_Pythia8__BeamParticle swig_types[5]
#define SWIGTYPE_p_Pythia8__BeamRemnants swig_types[6]
#define SWIGTYPE_p_Pythia8__BeamShape swig_types[7]
#define SWIGTYPE_p_Pythia8__BlackSubCollisionModel swig_types[8]
#define SWIGTYPE_p_Pythia8__BoseEinstein swig_types[9]
#define SWIGTYPE_p_Pythia8__BoseEinsteinHadron swig_types[10]
#define SWIGTYPE_p_Pythia8__CJKL swig_types[11]
#define SWIGTYPE_p_Pythia8__CTEQ5L swig_types[12]
#define SWIGTYPE_p_Pythia8__CTEQ6pdf swig_types[13]
#define SWIGTYPE_p_Pythia8__CellJet swig_types[14]
#define SWIGTYPE_p_Pythia8__ClusterJet swig_types[15]
#define SWIGTYPE_p_Pythia8__Clustering swig_types[16]
#define SWIGTYPE_p_Pythia8__ColConfig swig_types[17]
#define SWIGTYPE_p_Pythia8__ColSinglet swig_types[18]
#define SWIGTYPE_p_Pythia8__ColourDipole swig_types[19]
#define SWIGTYPE_p_Pythia8__ColourJunction swig_types[20]
#define SWIGTYPE_p_Pythia8__ColourParticle swig_types[21]
#define SWIGTYPE_p_Pythia8__ColourReconnection swig_types[22]
#define SWIGTYPE_p_Pythia8__ColourTracing swig_types[23]
#define SWIGTYPE_p_Pythia8__CombineMatchingInput swig_types[24]
#define SWIGTYPE_p_Pythia8__CoupSM swig_types[25]
#define SWIGTYPE_p_Pythia8__CoupSUSY swig_types[26]
#define SWIGTYPE_p_Pythia8__Couplings swig_types[27]
#define SWIGTYPE_p_Pythia8__DecayChannel swig_types[28]
#define SWIGTYPE_p_Pythia8__DecayHandler swig_types[29]
#define SWIGTYPE_p_Pythia8__DeuteronProduction swig_types[30]
#define SWIGTYPE_p_Pythia8__DoubleStrikman swig_types[31]
#define SWIGTYPE_p_Pythia8__DummyForStreams swig_types[32]
#define SWIGTYPE_p_Pythia8__EPAexternal swig_types[33]
#define SWIGTYPE_p_Pythia8__EPPS16 swig_types[34]
#define SWIGTYPE_p_Pythia8__EPS09 swig_types[35]
#define SWIGTYPE_p_Pythia8__Event swig_types[36]
#define SWIGTYPE_p_Pythia8__EventInfo swig_types[37]
#define SWIGTYPE_p_Pythia8__FVec swig_types[38]
#define SWIGTYPE_p_Pythia8__Flag swig_types[39]
#define SWIGTYPE_p_Pythia8__FlavContainer swig_types[40]
#define SWIGTYPE_p_Pythia8__FlavourRope swig_types[41]
#define SWIGTYPE_p_Pythia8__GLISSANDOModel swig_types[42]
#define SWIGTYPE_p_Pythia8__GRV94L swig_types[43]
#define SWIGTYPE_p_Pythia8__GRVpiL swig_types[44]
#define SWIGTYPE_p_Pythia8__GammaKinematics swig_types[45]
#define SWIGTYPE_p_Pythia8__GammaMatrix swig_types[46]
#define SWIGTYPE_p_Pythia8__GammaPoint swig_types[47]
#define SWIGTYPE_p_Pythia8__HEPEUP swig_types[48]
#define SWIGTYPE_p_Pythia8__HEPRUP swig_types[49]
#define SWIGTYPE_p_Pythia8__HIInfo swig_types[50]
#define SWIGTYPE_p_Pythia8__HIUserHooks swig_types[51]
#define SWIGTYPE_p_Pythia8__HJSlowJet swig_types[52]
#define SWIGTYPE_p_Pythia8__HMEGamma2TwoFermions swig_types[53]
#define SWIGTYPE_p_Pythia8__HMEHiggs2TwoFermions swig_types[54]
#define SWIGTYPE_p_Pythia8__HMETau2FivePions swig_types[55]
#define SWIGTYPE_p_Pythia8__HMETau2FourPions swig_types[56]
#define SWIGTYPE_p_Pythia8__HMETau2Meson swig_types[57]
#define SWIGTYPE_p_Pythia8__HMETau2PhaseSpace swig_types[58]
#define SWIGTYPE_p_Pythia8__HMETau2ThreeMesons swig_types[59]
#define SWIGTYPE_p_Pythia8__HMETau2ThreeMesonsGeneric swig_types[60]
#define SWIGTYPE_p_Pythia8__HMETau2ThreeMesonsWithKaons swig_types[61]
#define SWIGTYPE_p_Pythia8__HMETau2ThreePions swig_types[62]
#define SWIGTYPE_p_Pythia8__HMETau2TwoLeptons swig_types[63]
#define SWIGTYPE_p_Pythia8__HMETau2TwoMesonsViaVector swig_types[64]
#define SWIGTYPE_p_Pythia8__HMETau2TwoMesonsViaVectorScalar swig_types[65]
#define SWIGTYPE_p_Pythia8__HMETau2TwoPionsGamma swig_types[66]
#define SWIGTYPE_p_Pythia8__HMETauDecay swig_types[67]
#define SWIGTYPE_p_Pythia8__HMETwoFermions2GammaZ2TwoFermions swig_types[68]
#define SWIGTYPE_p_Pythia8__HMETwoFermions2W2TwoFermions swig_types[69]
#define SWIGTYPE_p_Pythia8__HMEW2TwoFermions swig_types[70]
#define SWIGTYPE_p_Pythia8__HMEX2TwoFermions swig_types[71]
#define SWIGTYPE_p_Pythia8__HMEZ2TwoFermions swig_types[72]
#define SWIGTYPE_p_Pythia8__HVStringFlav swig_types[73]
#define SWIGTYPE_p_Pythia8__HVStringPT swig_types[74]
#define SWIGTYPE_p_Pythia8__HVStringZ swig_types[75]
#define SWIGTYPE_p_Pythia8__HadronLevel swig_types[76]
#define SWIGTYPE_p_Pythia8__HadronScatter swig_types[77]
#define SWIGTYPE_p_Pythia8__HadronScatterPair swig_types[78]
#define SWIGTYPE_p_Pythia8__HardDiffraction swig_types[79]
#define SWIGTYPE_p_Pythia8__HardProcess swig_types[80]
#define SWIGTYPE_p_Pythia8__HeavyIons swig_types[81]
#define SWIGTYPE_p_Pythia8__HelicityMatrixElement swig_types[82]
#define SWIGTYPE_p_Pythia8__HelicityParticle swig_types[83]
#define SWIGTYPE_p_Pythia8__HiddenValleyFragmentation swig_types[84]
#define SWIGTYPE_p_Pythia8__Hist swig_types[85]
#define SWIGTYPE_p_Pythia8__HistPlot swig_types[86]
#define SWIGTYPE_p_Pythia8__History swig_types[87]
#define SWIGTYPE_p_Pythia8__ImpactParameterGenerator swig_types[88]
#define SWIGTYPE_p_Pythia8__InBeam swig_types[89]
#define SWIGTYPE_p_Pythia8__InPair swig_types[90]
#define SWIGTYPE_p_Pythia8__Info swig_types[91]
#define SWIGTYPE_p_Pythia8__Isospin swig_types[92]
#define SWIGTYPE_p_Pythia8__JetMatching swig_types[93]
#define SWIGTYPE_p_Pythia8__JetMatchingAlpgen swig_types[94]
#define SWIGTYPE_p_Pythia8__JetMatchingAlpgenInputAlpgen swig_types[95]
#define SWIGTYPE_p_Pythia8__JetMatchingMadgraph swig_types[96]
#define SWIGTYPE_p_Pythia8__JetMatchingMadgraphInputAlpgen swig_types[97]
#define SWIGTYPE_p_Pythia8__Junction swig_types[98]
#define SWIGTYPE_p_Pythia8__JunctionSplitting swig_types[99]
#define SWIGTYPE_p_Pythia8__LHAGrid1 swig_types[100]
#define SWIGTYPE_p_Pythia8__LHAPDF swig_types[101]
#define SWIGTYPE_p_Pythia8__LHAParticle swig_types[102]
#define SWIGTYPE_p_Pythia8__LHAProcess swig_types[103]
#define SWIGTYPE_p_Pythia8__LHAgenerator swig_types[104]
#define SWIGTYPE_p_Pythia8__LHAinitrwgt swig_types[105]
#define SWIGTYPE_p_Pythia8__LHArwgt swig_types[106]
#define SWIGTYPE_p_Pythia8__LHAscales swig_types[107]
#define SWIGTYPE_p_Pythia8__LHAup swig_types[108]
#define SWIGTYPE_p_Pythia8__LHAupAlpgen swig_types[109]
#define SWIGTYPE_p_Pythia8__LHAupFromPYTHIA8 swig_types[110]
#define SWIGTYPE_p_Pythia8__LHAupHelaconia swig_types[111]
#define SWIGTYPE_p_Pythia8__LHAupLHEF swig_types[112]
#define SWIGTYPE_p_Pythia8__LHAupMadgraph swig_types[113]
#define SWIGTYPE_p_Pythia8__LHAweight swig_types[114]
#define SWIGTYPE_p_Pythia8__LHAweightgroup swig_types[115]
#define SWIGTYPE_p_Pythia8__LHAweights swig_types[116]
#define SWIGTYPE_p_Pythia8__LHAwgt swig_types[117]
#define SWIGTYPE_p_Pythia8__LHEF3FromPythia8 swig_types[118]
#define SWIGTYPE_p_Pythia8__LHblockT_double_t swig_types[119]
#define SWIGTYPE_p_Pythia8__LHblockT_int_t swig_types[120]
#define SWIGTYPE_p_Pythia8__LHblockT_std__string_t swig_types[121]
#define SWIGTYPE_p_Pythia8__LHdecayChannel swig_types[122]
#define SWIGTYPE_p_Pythia8__LHdecayTable swig_types[123]
#define SWIGTYPE_p_Pythia8__LHgenericBlock swig_types[124]
#define SWIGTYPE_p_Pythia8__LHmatrixBlockT_2_t swig_types[125]
#define SWIGTYPE_p_Pythia8__LHmatrixBlockT_3_t swig_types[126]
#define SWIGTYPE_p_Pythia8__LHmatrixBlockT_4_t swig_types[127]
#define SWIGTYPE_p_Pythia8__LHmatrixBlockT_5_t swig_types[128]
#define SWIGTYPE_p_Pythia8__LHmatrixBlockT_6_t swig_types[129]
#define SWIGTYPE_p_Pythia8__LHmatrixBlockT_7_t swig_types[130]
#define SWIGTYPE_p_Pythia8__LHmatrixBlockT_8_t swig_types[131]
#define SWIGTYPE_p_Pythia8__LHtensor3BlockT_3_t swig_types[132]
#define SWIGTYPE_p_Pythia8__Lepton swig_types[133]
#define SWIGTYPE_p_Pythia8__Lepton2gamma swig_types[134]
#define SWIGTYPE_p_Pythia8__LeptonPoint swig_types[135]
#define SWIGTYPE_p_Pythia8__LundFFAvg swig_types[136]
#define SWIGTYPE_p_Pythia8__LundFFRaw swig_types[137]
#define SWIGTYPE_p_Pythia8__MBReconUserHooks swig_types[138]
#define SWIGTYPE_p_Pythia8__MSTWpdf swig_types[139]
#define SWIGTYPE_p_Pythia8__MVec swig_types[140]
#define SWIGTYPE_p_Pythia8__MadgraphPar swig_types[141]
#define SWIGTYPE_p_Pythia8__Merging swig_types[142]
#define SWIGTYPE_p_Pythia8__MergingHooks swig_types[143]
#define SWIGTYPE_p_Pythia8__MiniStringFragmentation swig_types[144]
#define SWIGTYPE_p_Pythia8__Mode swig_types[145]
#define SWIGTYPE_p_Pythia8__MultiRadial swig_types[146]
#define SWIGTYPE_p_Pythia8__MultipartonInteractions swig_types[147]
#define SWIGTYPE_p_Pythia8__NNPDF swig_types[148]
#define SWIGTYPE_p_Pythia8__NaiveSubCollisionModel swig_types[149]
#define SWIGTYPE_p_Pythia8__NeutrinoPoint swig_types[150]
#define SWIGTYPE_p_Pythia8__Nucleon swig_types[151]
#define SWIGTYPE_p_Pythia8__NucleusModel swig_types[152]
#define SWIGTYPE_p_Pythia8__OverlappingRopeDipole swig_types[153]
#define SWIGTYPE_p_Pythia8__PDF swig_types[154]
#define SWIGTYPE_p_Pythia8__PDF__PDFEnvelope swig_types[155]
#define SWIGTYPE_p_Pythia8__PVec swig_types[156]
#define SWIGTYPE_p_Pythia8__Parm swig_types[157]
#define SWIGTYPE_p_Pythia8__Particle swig_types[158]
#define SWIGTYPE_p_Pythia8__ParticleData swig_types[159]
#define SWIGTYPE_p_Pythia8__ParticleDataEntry swig_types[160]
#define SWIGTYPE_p_Pythia8__ParticleDecays swig_types[161]
#define SWIGTYPE_p_Pythia8__PartonLevel swig_types[162]
#define SWIGTYPE_p_Pythia8__PartonSystem swig_types[163]
#define SWIGTYPE_p_Pythia8__PartonSystems swig_types[164]
#define SWIGTYPE_p_Pythia8__PartonVertex swig_types[165]
#define SWIGTYPE_p_Pythia8__PhaseSpace swig_types[166]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to1tauy swig_types[167]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to2diffractive swig_types[168]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to2elastic swig_types[169]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to2nondiffractive swig_types[170]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to2tauyz swig_types[171]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to3diffractive swig_types[172]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to3tauycyl swig_types[173]
#define SWIGTYPE_p_Pythia8__PhaseSpace2to3yyycyl swig_types[174]
#define SWIGTYPE_p_Pythia8__PhaseSpaceLHA swig_types[175]
#define SWIGTYPE_p_Pythia8__PomFix swig_types[176]
#define SWIGTYPE_p_Pythia8__PomH1FitAB swig_types[177]
#define SWIGTYPE_p_Pythia8__PomH1Jets swig_types[178]
#define SWIGTYPE_p_Pythia8__PomHISASD swig_types[179]
#define SWIGTYPE_p_Pythia8__PowhegHooks swig_types[180]
#define SWIGTYPE_p_Pythia8__PowhegProcs swig_types[181]
#define SWIGTYPE_p_Pythia8__ProcessContainer swig_types[182]
#define SWIGTYPE_p_Pythia8__ProcessLevel swig_types[183]
#define SWIGTYPE_p_Pythia8__ProgressLog swig_types[184]
#define SWIGTYPE_p_Pythia8__ProtonPoint swig_types[185]
#define SWIGTYPE_p_Pythia8__Pythia swig_types[186]
#define SWIGTYPE_p_Pythia8__RHadrons swig_types[187]
#define SWIGTYPE_p_Pythia8__Reader swig_types[188]
#define SWIGTYPE_p_Pythia8__ResolvedParton swig_types[189]
#define SWIGTYPE_p_Pythia8__ResonanceCha swig_types[190]
#define SWIGTYPE_p_Pythia8__ResonanceChaD swig_types[191]
#define SWIGTYPE_p_Pythia8__ResonanceChar swig_types[192]
#define SWIGTYPE_p_Pythia8__ResonanceDM2 swig_types[193]
#define SWIGTYPE_p_Pythia8__ResonanceDecays swig_types[194]
#define SWIGTYPE_p_Pythia8__ResonanceExcited swig_types[195]
#define SWIGTYPE_p_Pythia8__ResonanceFour swig_types[196]
#define SWIGTYPE_p_Pythia8__ResonanceGeneric swig_types[197]
#define SWIGTYPE_p_Pythia8__ResonanceGluino swig_types[198]
#define SWIGTYPE_p_Pythia8__ResonanceGmZ swig_types[199]
#define SWIGTYPE_p_Pythia8__ResonanceGraviton swig_types[200]
#define SWIGTYPE_p_Pythia8__ResonanceH swig_types[201]
#define SWIGTYPE_p_Pythia8__ResonanceHchg swig_types[202]
#define SWIGTYPE_p_Pythia8__ResonanceHchgchgLeft swig_types[203]
#define SWIGTYPE_p_Pythia8__ResonanceHchgchgRight swig_types[204]
#define SWIGTYPE_p_Pythia8__ResonanceKKgluon swig_types[205]
#define SWIGTYPE_p_Pythia8__ResonanceLeptoquark swig_types[206]
#define SWIGTYPE_p_Pythia8__ResonanceNeut swig_types[207]
#define SWIGTYPE_p_Pythia8__ResonanceNuRight swig_types[208]
#define SWIGTYPE_p_Pythia8__ResonanceRhorizontal swig_types[209]
#define SWIGTYPE_p_Pythia8__ResonanceS swig_types[210]
#define SWIGTYPE_p_Pythia8__ResonanceSl swig_types[211]
#define SWIGTYPE_p_Pythia8__ResonanceSlepton swig_types[212]
#define SWIGTYPE_p_Pythia8__ResonanceSquark swig_types[213]
#define SWIGTYPE_p_Pythia8__ResonanceTop swig_types[214]
#define SWIGTYPE_p_Pythia8__ResonanceW swig_types[215]
#define SWIGTYPE_p_Pythia8__ResonanceWRight swig_types[216]
#define SWIGTYPE_p_Pythia8__ResonanceWidths swig_types[217]
#define SWIGTYPE_p_Pythia8__ResonanceWprime swig_types[218]
#define SWIGTYPE_p_Pythia8__ResonanceZRight swig_types[219]
#define SWIGTYPE_p_Pythia8__ResonanceZp swig_types[220]
#define SWIGTYPE_p_Pythia8__ResonanceZprime swig_types[221]
#define SWIGTYPE_p_Pythia8__Rndm swig_types[222]
#define SWIGTYPE_p_Pythia8__RndmEngine swig_types[223]
#define SWIGTYPE_p_Pythia8__RopeDipole swig_types[224]
#define SWIGTYPE_p_Pythia8__RopeDipoleEnd swig_types[225]
#define SWIGTYPE_p_Pythia8__RopeFragPars swig_types[226]
#define SWIGTYPE_p_Pythia8__Ropewalk swig_types[227]
#define SWIGTYPE_p_Pythia8__RotBstMatrix swig_types[228]
#define SWIGTYPE_p_Pythia8__SLHAinterface swig_types[229]
#define SWIGTYPE_p_Pythia8__SUSYResonanceWidths swig_types[230]
#define SWIGTYPE_p_Pythia8__Settings swig_types[231]
#define SWIGTYPE_p_Pythia8__SetupContainers swig_types[232]
#define SWIGTYPE_p_Pythia8__Sigma0AB2AB swig_types[233]
#define SWIGTYPE_p_Pythia8__Sigma0AB2AX swig_types[234]
#define SWIGTYPE_p_Pythia8__Sigma0AB2AXB swig_types[235]
#define SWIGTYPE_p_Pythia8__Sigma0AB2XB swig_types[236]
#define SWIGTYPE_p_Pythia8__Sigma0AB2XX swig_types[237]
#define SWIGTYPE_p_Pythia8__Sigma0Process swig_types[238]
#define SWIGTYPE_p_Pythia8__Sigma0nonDiffractive swig_types[239]
#define SWIGTYPE_p_Pythia8__Sigma1Process swig_types[240]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2GravitonStar swig_types[241]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2H swig_types[242]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2Hchg swig_types[243]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2Rhorizontal swig_types[244]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2W swig_types[245]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2WRight swig_types[246]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2Wprime swig_types[247]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2ZRight swig_types[248]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2Zp2XX swig_types[249]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2Zv swig_types[250]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2gmZ swig_types[251]
#define SWIGTYPE_p_Pythia8__Sigma1ffbar2gmZZprime swig_types[252]
#define SWIGTYPE_p_Pythia8__Sigma1ffbarZprimeWprime swig_types[253]
#define SWIGTYPE_p_Pythia8__Sigma1gg2GravitonStar swig_types[254]
#define SWIGTYPE_p_Pythia8__Sigma1gg2H swig_types[255]
#define SWIGTYPE_p_Pythia8__Sigma1gg2S2XX swig_types[256]
#define SWIGTYPE_p_Pythia8__Sigma1gmgm2H swig_types[257]
#define SWIGTYPE_p_Pythia8__Sigma1lgm2lStar swig_types[258]
#define SWIGTYPE_p_Pythia8__Sigma1ll2Hchgchg swig_types[259]
#define SWIGTYPE_p_Pythia8__Sigma1qg2qStar swig_types[260]
#define SWIGTYPE_p_Pythia8__Sigma1ql2LeptoQuark swig_types[261]
#define SWIGTYPE_p_Pythia8__Sigma1qq2antisquark swig_types[262]
#define SWIGTYPE_p_Pythia8__Sigma1qqbar2KKgluonStar swig_types[263]
#define SWIGTYPE_p_Pythia8__Sigma2Process swig_types[264]
#define SWIGTYPE_p_Pythia8__Sigma2QCffbar2llbar swig_types[265]
#define SWIGTYPE_p_Pythia8__Sigma2QCqq2qq swig_types[266]
#define SWIGTYPE_p_Pythia8__Sigma2QCqqbar2qqbar swig_types[267]
#define SWIGTYPE_p_Pythia8__Sigma2SUSY swig_types[268]
#define SWIGTYPE_p_Pythia8__Sigma2ff2fftW swig_types[269]
#define SWIGTYPE_p_Pythia8__Sigma2ff2fftgmZ swig_types[270]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2A3H12 swig_types[271]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2FFbarsgmZ swig_types[272]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2FfbarsW swig_types[273]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2HW swig_types[274]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2HZ swig_types[275]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2HchgH12 swig_types[276]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2HchgchgHchgchg swig_types[277]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2HposHneg swig_types[278]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2LEDUnparticleZ swig_types[279]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2LEDUnparticlegamma swig_types[280]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2LEDgammagamma swig_types[281]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2LEDllbar swig_types[282]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2TEVffbar swig_types[283]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2WW swig_types[284]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2Wgm swig_types[285]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2ZW swig_types[286]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2ZpH swig_types[287]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2fGfGbar swig_types[288]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2ffbarsW swig_types[289]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2ffbarsgm swig_types[290]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2ffbarsgmZ swig_types[291]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2gammagamma swig_types[292]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2gmZgm swig_types[293]
#define SWIGTYPE_p_Pythia8__Sigma2ffbar2gmZgmZ swig_types[294]
#define SWIGTYPE_p_Pythia8__Sigma2ffbarWggm swig_types[295]
#define SWIGTYPE_p_Pythia8__Sigma2ffbargmZWgmZW swig_types[296]
#define SWIGTYPE_p_Pythia8__Sigma2ffbargmZggm swig_types[297]
#define SWIGTYPE_p_Pythia8__Sigma2fgm2Wf swig_types[298]
#define SWIGTYPE_p_Pythia8__Sigma2fgm2gmZf swig_types[299]
#define SWIGTYPE_p_Pythia8__Sigma2gg2GravitonStarg swig_types[300]
#define SWIGTYPE_p_Pythia8__Sigma2gg2Hglt swig_types[301]
#define SWIGTYPE_p_Pythia8__Sigma2gg2LEDUnparticleg swig_types[302]
#define SWIGTYPE_p_Pythia8__Sigma2gg2LEDgammagamma swig_types[303]
#define SWIGTYPE_p_Pythia8__Sigma2gg2LEDgg swig_types[304]
#define SWIGTYPE_p_Pythia8__Sigma2gg2LEDllbar swig_types[305]
#define SWIGTYPE_p_Pythia8__Sigma2gg2LEDqqbar swig_types[306]
#define SWIGTYPE_p_Pythia8__Sigma2gg2LQLQbar swig_types[307]
#define SWIGTYPE_p_Pythia8__Sigma2gg2QQbar swig_types[308]
#define SWIGTYPE_p_Pythia8__Sigma2gg2QQbar3DJ1g swig_types[309]
#define SWIGTYPE_p_Pythia8__Sigma2gg2QQbar3PJ1g swig_types[310]
#define SWIGTYPE_p_Pythia8__Sigma2gg2QQbar3S11QQbar3S11 swig_types[311]
#define SWIGTYPE_p_Pythia8__Sigma2gg2QQbar3S11g swig_types[312]
#define SWIGTYPE_p_Pythia8__Sigma2gg2QQbar3S11gm swig_types[313]
#define SWIGTYPE_p_Pythia8__Sigma2gg2QQbarX8g swig_types[314]
#define SWIGTYPE_p_Pythia8__Sigma2gg2Sg2XXj swig_types[315]
#define SWIGTYPE_p_Pythia8__Sigma2gg2gammagamma swig_types[316]
#define SWIGTYPE_p_Pythia8__Sigma2gg2gg swig_types[317]
#define SWIGTYPE_p_Pythia8__Sigma2gg2ggamma swig_types[318]
#define SWIGTYPE_p_Pythia8__Sigma2gg2gluinogluino swig_types[319]
#define SWIGTYPE_p_Pythia8__Sigma2gg2qGqGbar swig_types[320]
#define SWIGTYPE_p_Pythia8__Sigma2gg2qqbar swig_types[321]
#define SWIGTYPE_p_Pythia8__Sigma2gg2squarkantisquark swig_types[322]
#define SWIGTYPE_p_Pythia8__Sigma2ggm2qqbar swig_types[323]
#define SWIGTYPE_p_Pythia8__Sigma2gmgm2ffbar swig_types[324]
#define SWIGTYPE_p_Pythia8__Sigma2lgm2Hchgchgl swig_types[325]
#define SWIGTYPE_p_Pythia8__Sigma2qg2GravitonStarq swig_types[326]
#define SWIGTYPE_p_Pythia8__Sigma2qg2Hchgq swig_types[327]
#define SWIGTYPE_p_Pythia8__Sigma2qg2Hq swig_types[328]
#define SWIGTYPE_p_Pythia8__Sigma2qg2Hqlt swig_types[329]
#define SWIGTYPE_p_Pythia8__Sigma2qg2LEDUnparticleq swig_types[330]
#define SWIGTYPE_p_Pythia8__Sigma2qg2LEDqg swig_types[331]
#define SWIGTYPE_p_Pythia8__Sigma2qg2LeptoQuarkl swig_types[332]
#define SWIGTYPE_p_Pythia8__Sigma2qg2QQbar3PJ1q swig_types[333]
#define SWIGTYPE_p_Pythia8__Sigma2qg2QQbarX8q swig_types[334]
#define SWIGTYPE_p_Pythia8__Sigma2qg2Sq2XXj swig_types[335]
#define SWIGTYPE_p_Pythia8__Sigma2qg2Wq swig_types[336]
#define SWIGTYPE_p_Pythia8__Sigma2qg2Zpq2XXj swig_types[337]
#define SWIGTYPE_p_Pythia8__Sigma2qg2charsquark swig_types[338]
#define SWIGTYPE_p_Pythia8__Sigma2qg2chi0squark swig_types[339]
#define SWIGTYPE_p_Pythia8__Sigma2qg2gmZq swig_types[340]
#define SWIGTYPE_p_Pythia8__Sigma2qg2qg swig_types[341]
#define SWIGTYPE_p_Pythia8__Sigma2qg2qgamma swig_types[342]
#define SWIGTYPE_p_Pythia8__Sigma2qg2squarkgluino swig_types[343]
#define SWIGTYPE_p_Pythia8__Sigma2qgm2qg swig_types[344]
#define SWIGTYPE_p_Pythia8__Sigma2qgm2qgm swig_types[345]
#define SWIGTYPE_p_Pythia8__Sigma2qq2LEDqq swig_types[346]
#define SWIGTYPE_p_Pythia8__Sigma2qq2QqtW swig_types[347]
#define SWIGTYPE_p_Pythia8__Sigma2qq2qStarq swig_types[348]
#define SWIGTYPE_p_Pythia8__Sigma2qq2qq swig_types[349]
#define SWIGTYPE_p_Pythia8__Sigma2qq2squarksquark swig_types[350]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2DY swig_types[351]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2GravitonStarg swig_types[352]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2Hglt swig_types[353]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2LEDUnparticleg swig_types[354]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2LEDgg swig_types[355]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2LEDqqbarNew swig_types[356]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2LQLQbar swig_types[357]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2QQbar swig_types[358]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2QQbar3PJ1g swig_types[359]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2QQbar3S11QQbar3S11 swig_types[360]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2QQbarX8g swig_types[361]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2Wg swig_types[362]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2Zpg2XXj swig_types[363]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2charchar swig_types[364]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2charchi0 swig_types[365]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2chargluino swig_types[366]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2chi0chi0 swig_types[367]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2chi0gluino swig_types[368]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2gg swig_types[369]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2ggamma swig_types[370]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2gluinogluino swig_types[371]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2gmZg swig_types[372]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2lStarlStarBar swig_types[373]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2lStarlbar swig_types[374]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2qGqGbar swig_types[375]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2qqbarNew swig_types[376]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2sleptonantislepton swig_types[377]
#define SWIGTYPE_p_Pythia8__Sigma2qqbar2squarkantisquark swig_types[378]
#define SWIGTYPE_p_Pythia8__Sigma3Process swig_types[379]
#define SWIGTYPE_p_Pythia8__Sigma3ff2HchgchgfftWW swig_types[380]
#define SWIGTYPE_p_Pythia8__Sigma3ff2HfftWW swig_types[381]
#define SWIGTYPE_p_Pythia8__Sigma3ff2HfftZZ swig_types[382]
#define SWIGTYPE_p_Pythia8__Sigma3gg2HQQbar swig_types[383]
#define SWIGTYPE_p_Pythia8__Sigma3gg2ggg swig_types[384]
#define SWIGTYPE_p_Pythia8__Sigma3gg2qqbarg swig_types[385]
#define SWIGTYPE_p_Pythia8__Sigma3qg2qgg swig_types[386]
#define SWIGTYPE_p_Pythia8__Sigma3qg2qqqbarDiff swig_types[387]
#define SWIGTYPE_p_Pythia8__Sigma3qg2qqqbarSame swig_types[388]
#define SWIGTYPE_p_Pythia8__Sigma3qq2qqgDiff swig_types[389]
#define SWIGTYPE_p_Pythia8__Sigma3qq2qqgSame swig_types[390]
#define SWIGTYPE_p_Pythia8__Sigma3qqbar2HQQbar swig_types[391]
#define SWIGTYPE_p_Pythia8__Sigma3qqbar2ggg swig_types[392]
#define SWIGTYPE_p_Pythia8__Sigma3qqbar2qqbargDiff swig_types[393]
#define SWIGTYPE_p_Pythia8__Sigma3qqbar2qqbargSame swig_types[394]
#define SWIGTYPE_p_Pythia8__SigmaABMST swig_types[395]
#define SWIGTYPE_p_Pythia8__SigmaLHAProcess swig_types[396]
#define SWIGTYPE_p_Pythia8__SigmaMBR swig_types[397]
#define SWIGTYPE_p_Pythia8__SigmaMultiparton swig_types[398]
#define SWIGTYPE_p_Pythia8__SigmaOniaSetup swig_types[399]
#define SWIGTYPE_p_Pythia8__SigmaPartialWave swig_types[400]
#define SWIGTYPE_p_Pythia8__SigmaProcess swig_types[401]
#define SWIGTYPE_p_Pythia8__SigmaRPP swig_types[402]
#define SWIGTYPE_p_Pythia8__SigmaSaSDL swig_types[403]
#define SWIGTYPE_p_Pythia8__SigmaTotAux swig_types[404]
#define SWIGTYPE_p_Pythia8__SigmaTotOwn swig_types[405]
#define SWIGTYPE_p_Pythia8__SigmaTotal swig_types[406]
#define SWIGTYPE_p_Pythia8__SimpleSpaceShower swig_types[407]
#define SWIGTYPE_p_Pythia8__SimpleTimeShower swig_types[408]
#define SWIGTYPE_p_Pythia8__SimpleWeakShowerMEs swig_types[409]
#define SWIGTYPE_p_Pythia8__SingleCell swig_types[410]
#define SWIGTYPE_p_Pythia8__SingleCellJet swig_types[411]
#define SWIGTYPE_p_Pythia8__SingleClusterJet swig_types[412]
#define SWIGTYPE_p_Pythia8__SingleSlowJet swig_types[413]
#define SWIGTYPE_p_Pythia8__SlowJet swig_types[414]
#define SWIGTYPE_p_Pythia8__SlowJetHook swig_types[415]
#define SWIGTYPE_p_Pythia8__SpaceDipoleEnd swig_types[416]
#define SWIGTYPE_p_Pythia8__SpaceShower swig_types[417]
#define SWIGTYPE_p_Pythia8__Sphericity swig_types[418]
#define SWIGTYPE_p_Pythia8__StauWidths swig_types[419]
#define SWIGTYPE_p_Pythia8__StringEnd swig_types[420]
#define SWIGTYPE_p_Pythia8__StringFlav swig_types[421]
#define SWIGTYPE_p_Pythia8__StringFragmentation swig_types[422]
#define SWIGTYPE_p_Pythia8__StringLength swig_types[423]
#define SWIGTYPE_p_Pythia8__StringPT swig_types[424]
#define SWIGTYPE_p_Pythia8__StringRegion swig_types[425]
#define SWIGTYPE_p_Pythia8__StringSystem swig_types[426]
#define SWIGTYPE_p_Pythia8__StringVertex swig_types[427]
#define SWIGTYPE_p_Pythia8__StringZ swig_types[428]
#define SWIGTYPE_p_Pythia8__SubCollision swig_types[429]
#define SWIGTYPE_p_Pythia8__SubCollisionModel swig_types[430]
#define SWIGTYPE_p_Pythia8__SubCollisionModel__SigEst swig_types[431]
#define SWIGTYPE_p_Pythia8__SuppressSmallPT swig_types[432]
#define SWIGTYPE_p_Pythia8__SusyLesHouches swig_types[433]
#define SWIGTYPE_p_Pythia8__TauDecays swig_types[434]
#define SWIGTYPE_p_Pythia8__Thrust swig_types[435]
#define SWIGTYPE_p_Pythia8__TimeDipoleEnd swig_types[436]
#define SWIGTYPE_p_Pythia8__TimeShower swig_types[437]
#define SWIGTYPE_p_Pythia8__TopReconUserHooks swig_types[438]
#define SWIGTYPE_p_Pythia8__TrialReconnection swig_types[439]
#define SWIGTYPE_p_Pythia8__UserHooks swig_types[440]
#define SWIGTYPE_p_Pythia8__UserHooksVector swig_types[441]
#define SWIGTYPE_p_Pythia8__Vec4 swig_types[442]
#define SWIGTYPE_p_Pythia8__WVec swig_types[443]
#define SWIGTYPE_p_Pythia8__Wave4 swig_types[444]
#define SWIGTYPE_p_Pythia8__WidthFunction swig_types[445]
#define SWIGTYPE_p_Pythia8__WoodsSaxonModel swig_types[446]
#define SWIGTYPE_p_Pythia8__Word swig_types[447]
#define SWIGTYPE_p_Pythia8__Writer swig_types[448]
#define SWIGTYPE_p_Pythia8__XMLTag swig_types[449]
#define SWIGTYPE_p_Pythia8__amcnlo_unitarised_interface swig_types[450]
#define SWIGTYPE_p_Pythia8__nPDF swig_types[451]
#define SWIGTYPE_p_State swig_types[452]
#define SWIGTYPE_p_a_3__std__complexT_double_t swig_types[453]
#define SWIGTYPE_p_a_4__std__complexT_double_t swig_types[454]
#define SWIGTYPE_p_a_6__std__complexT_double_t swig_types[455]
#define SWIGTYPE_p_a_7__std__complexT_double_t swig_types[456]
#define SWIGTYPE_p_a_8__double swig_types[457]
#define SWIGTYPE_p_allocator_type swig_types[458]
#define SWIGTYPE_p_basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[459]
#define SWIGTYPE_p_bool swig_types[460]
#define SWIGTYPE_p_char swig_types[461]
#define SWIGTYPE_p_char_type swig_types[462]
#define SWIGTYPE_p_const_reference swig_types[463]
#define SWIGTYPE_p_difference_type swig_types[464]
#define SWIGTYPE_p_double swig_types[465]
#define SWIGTYPE_p_f_enum_std__ios_base__event_r_std__ios_base_int__void swig_types[466]
#define SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_iosT_char_std__char_traitsT_char_t_t swig_types[467]
#define SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_iostreamT_char_std__char_traitsT_char_t_t swig_types[468]
#define SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_istreamT_char_std__char_traitsT_char_t_t swig_types[469]
#define SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[470]
#define SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_ostreamT_char_std__char_traitsT_char_t_t swig_types[471]
#define SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_ostringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[472]
#define SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_stringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[473]
#define SWIGTYPE_p_f_r_std__basic_istream__char_std__char_traits__char______r_std__basic_iostreamT_char_std__char_traitsT_char_t_t swig_types[474]
#define SWIGTYPE_p_f_r_std__basic_istream__char_std__char_traits__char______r_std__basic_istreamT_char_std__char_traitsT_char_t_t swig_types[475]
#define SWIGTYPE_p_f_r_std__basic_istream__char_std__char_traits__char______r_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[476]
#define SWIGTYPE_p_f_r_std__basic_istream__char_std__char_traits__char______r_std__basic_stringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[477]
#define SWIGTYPE_p_f_r_std__basic_ostream__char_std__char_traits__char______r_std__basic_iostreamT_char_std__char_traitsT_char_t_t swig_types[478]
#define SWIGTYPE_p_f_r_std__basic_ostream__char_std__char_traits__char______r_std__basic_ostreamT_char_std__char_traitsT_char_t_t swig_types[479]
#define SWIGTYPE_p_f_r_std__basic_ostream__char_std__char_traits__char______r_std__basic_ostringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[480]
#define SWIGTYPE_p_f_r_std__basic_ostream__char_std__char_traits__char______r_std__basic_stringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[481]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__basic_iosT_char_std__char_traitsT_char_t_t swig_types[482]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__basic_iostreamT_char_std__char_traitsT_char_t_t swig_types[483]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__basic_istreamT_char_std__char_traitsT_char_t_t swig_types[484]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[485]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__basic_ostreamT_char_std__char_traitsT_char_t_t swig_types[486]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__basic_ostringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[487]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__basic_stringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[488]
#define SWIGTYPE_p_f_r_std__ios_base__r_std__ios_base swig_types[489]
#define SWIGTYPE_p_first_type swig_types[490]
#define SWIGTYPE_p_float swig_types[491]
#define SWIGTYPE_p_fmtflags swig_types[492]
#define SWIGTYPE_p_ifstream swig_types[493]
#define SWIGTYPE_p_int swig_types[494]
#define SWIGTYPE_p_int_type swig_types[495]
#define SWIGTYPE_p_iostate swig_types[496]
#define SWIGTYPE_p_key_type swig_types[497]
#define SWIGTYPE_p_long swig_types[498]
#define SWIGTYPE_p_long_double swig_types[499]
#define SWIGTYPE_p_long_long swig_types[500]
#define SWIGTYPE_p_mapped_type swig_types[501]
#define SWIGTYPE_p_off_type swig_types[502]
#define SWIGTYPE_p_openmode swig_types[503]
#define SWIGTYPE_p_p_PyObject swig_types[504]
#define SWIGTYPE_p_p_Pythia8__ColourDipole swig_types[505]
#define SWIGTYPE_p_p_std__basic_iostreamT_char_std__char_traitsT_char_t_t swig_types[506]
#define SWIGTYPE_p_p_std__basic_istreamT_char_std__char_traitsT_char_t_t swig_types[507]
#define SWIGTYPE_p_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[508]
#define SWIGTYPE_p_p_std__basic_stringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[509]
#define SWIGTYPE_p_p_void swig_types[510]
#define SWIGTYPE_p_pos_t swig_types[511]
#define SWIGTYPE_p_pos_type swig_types[512]
#define SWIGTYPE_p_reference swig_types[513]
#define SWIGTYPE_p_second_type swig_types[514]
#define SWIGTYPE_p_seekdir swig_types[515]
#define SWIGTYPE_p_short swig_types[516]
#define SWIGTYPE_p_size_t swig_types[517]
#define SWIGTYPE_p_size_type swig_types[518]
#define SWIGTYPE_p_state_type swig_types[519]
#define SWIGTYPE_p_std__allocatorT_Pythia8__Clustering_t swig_types[520]
#define SWIGTYPE_p_std__allocatorT_Pythia8__HelicityParticle_t swig_types[521]
#define SWIGTYPE_p_std__allocatorT_Pythia8__ProcessContainer_p_t swig_types[522]
#define SWIGTYPE_p_std__allocatorT_Pythia8__ResonanceWidths_p_t swig_types[523]
#define SWIGTYPE_p_std__allocatorT_Pythia8__SigmaProcess_p_t swig_types[524]
#define SWIGTYPE_p_std__allocatorT_Pythia8__Vec4_t swig_types[525]
#define SWIGTYPE_p_std__allocatorT_bool_t swig_types[526]
#define SWIGTYPE_p_std__allocatorT_double_t swig_types[527]
#define SWIGTYPE_p_std__allocatorT_int_t swig_types[528]
#define SWIGTYPE_p_std__allocatorT_std__complexT_double_t_t swig_types[529]
#define SWIGTYPE_p_std__allocatorT_std__pairT_double_const_std__pairT_int_int_t_t_t swig_types[530]
#define SWIGTYPE_p_std__allocatorT_std__pairT_int_const_int_t_t swig_types[531]
#define SWIGTYPE_p_std__allocatorT_std__pairT_int_int_t_t swig_types[532]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_Pythia8__FVec_t_t swig_types[533]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_Pythia8__Flag_t_t swig_types[534]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_Pythia8__MVec_t_t swig_types[535]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_Pythia8__Mode_t_t swig_types[536]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_Pythia8__PVec_t_t swig_types[537]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_Pythia8__Parm_t_t swig_types[538]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_Pythia8__Word_t_t swig_types[539]
#define SWIGTYPE_p_std__allocatorT_std__pairT_std__string_const_std__string_t_t swig_types[540]
#define SWIGTYPE_p_std__allocatorT_std__string_t swig_types[541]
#define SWIGTYPE_p_std__allocatorT_std__vectorT_int_std__allocatorT_int_t_t_t swig_types[542]
#define SWIGTYPE_p_std__allocatorT_std__vectorT_std__complexT_double_t_std__allocatorT_std__complexT_double_t_t_t_t swig_types[543]
#define SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t swig_types[544]
#define SWIGTYPE_p_std__basic_iostreamT_char_std__char_traitsT_char_t_t swig_types[545]
#define SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t swig_types[546]
#define SWIGTYPE_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[547]
#define SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t swig_types[548]
#define SWIGTYPE_p_std__basic_ostringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[549]
#define SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t swig_types[550]
#define SWIGTYPE_p_std__basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[551]
#define SWIGTYPE_p_std__basic_stringbufT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[552]
#define SWIGTYPE_p_std__basic_stringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t swig_types[553]
#define SWIGTYPE_p_std__complexT_double_t swig_types[554]
#define SWIGTYPE_p_std__ifstream swig_types[555]
#define SWIGTYPE_p_std__invalid_argument swig_types[556]
#define SWIGTYPE_p_std__ios_base swig_types[557]
#define SWIGTYPE_p_std__lessT_double_t swig_types[558]
#define SWIGTYPE_p_std__lessT_int_t swig_types[559]
#define SWIGTYPE_p_std__lessT_std__string_t swig_types[560]
#define SWIGTYPE_p_std__locale swig_types[561]
#define SWIGTYPE_p_std__mapT_Pythia8__Nucleon_p_std__pairT_int_int_t_std__lessT_Pythia8__Nucleon_p_t_std__allocatorT_std__pairT_Pythia8__Nucleon_pconst_std__pairT_int_int_t_t_t_t swig_types[562]
#define SWIGTYPE_p_std__mapT_double_std__pairT_int_int_t_std__lessT_double_t_std__allocatorT_std__pairT_double_const_std__pairT_int_int_t_t_t_t swig_types[563]
#define SWIGTYPE_p_std__mapT_int_double_std__lessT_int_t_std__allocatorT_std__pairT_int_const_double_t_t_t swig_types[564]
#define SWIGTYPE_p_std__mapT_int_int_std__lessT_int_t_std__allocatorT_std__pairT_int_const_int_t_t_t swig_types[565]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__FVec_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__FVec_t_t_t swig_types[566]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__Flag_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__Flag_t_t_t swig_types[567]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__LHAweight_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__LHAweight_t_t_t swig_types[568]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__LHAweightgroup_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__LHAweightgroup_t_t_t swig_types[569]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__LHAwgt_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__LHAwgt_t_t_t swig_types[570]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__LHgenericBlock_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__LHgenericBlock_t_t_t swig_types[571]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__MVec_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__MVec_t_t_t swig_types[572]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__Mode_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__Mode_t_t_t swig_types[573]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__PVec_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__PVec_t_t_t swig_types[574]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__Parm_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__Parm_t_t_t swig_types[575]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__WVec_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__WVec_t_t_t swig_types[576]
#define SWIGTYPE_p_std__mapT_std__string_Pythia8__Word_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_Pythia8__Word_t_t_t swig_types[577]
#define SWIGTYPE_p_std__mapT_std__string_double_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_double_t_t_t swig_types[578]
#define SWIGTYPE_p_std__mapT_std__string_std__string_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_std__string_t_t_t swig_types[579]
#define SWIGTYPE_p_std__multisetT_Pythia8__SubCollision_std__lessT_Pythia8__SubCollision_t_std__allocatorT_Pythia8__SubCollision_t_t swig_types[580]
#define SWIGTYPE_p_std__ofstream swig_types[581]
#define SWIGTYPE_p_std__pairT_Pythia8__RotBstMatrix_Pythia8__RotBstMatrix_t swig_types[582]
#define SWIGTYPE_p_std__pairT_Pythia8__Vec4_Pythia8__Vec4_t swig_types[583]
#define SWIGTYPE_p_std__pairT_double_double_t swig_types[584]
#define SWIGTYPE_p_std__pairT_int_int_t swig_types[585]
#define SWIGTYPE_p_std__pairT_long_long_t swig_types[586]
#define SWIGTYPE_p_std__setT_int_std__lessT_int_t_std__allocatorT_int_t_t swig_types[587]
#define SWIGTYPE_p_std__string swig_types[588]
#define SWIGTYPE_p_std__string__size_type swig_types[589]
#define SWIGTYPE_p_std__vectorT_Pythia8__Clustering_std__allocatorT_Pythia8__Clustering_t_t swig_types[590]
#define SWIGTYPE_p_std__vectorT_Pythia8__ColourDipole_p_std__allocatorT_Pythia8__ColourDipole_p_t_t swig_types[591]
#define SWIGTYPE_p_std__vectorT_Pythia8__HelicityParticle_std__allocatorT_Pythia8__HelicityParticle_t_t swig_types[592]
#define SWIGTYPE_p_std__vectorT_Pythia8__InBeam_std__allocatorT_Pythia8__InBeam_t_t swig_types[593]
#define SWIGTYPE_p_std__vectorT_Pythia8__InPair_std__allocatorT_Pythia8__InPair_t_t swig_types[594]
#define SWIGTYPE_p_std__vectorT_Pythia8__LHAParticle_std__allocatorT_Pythia8__LHAParticle_t_t swig_types[595]
#define SWIGTYPE_p_std__vectorT_Pythia8__LHAgenerator_std__allocatorT_Pythia8__LHAgenerator_t_t swig_types[596]
#define SWIGTYPE_p_std__vectorT_Pythia8__LHblockT_double_t_std__allocatorT_Pythia8__LHblockT_double_t_t_t swig_types[597]
#define SWIGTYPE_p_std__vectorT_Pythia8__LHdecayTable_std__allocatorT_Pythia8__LHdecayTable_t_t swig_types[598]
#define SWIGTYPE_p_std__vectorT_Pythia8__Nucleon_std__allocatorT_Pythia8__Nucleon_t_t swig_types[599]
#define SWIGTYPE_p_std__vectorT_Pythia8__Nucleon_std__allocatorT_Pythia8__Nucleon_t_t__iterator swig_types[600]
#define SWIGTYPE_p_std__vectorT_Pythia8__PhaseSpace_p_std__allocatorT_Pythia8__PhaseSpace_p_t_t swig_types[601]
#define SWIGTYPE_p_std__vectorT_Pythia8__ProcessContainer_p_std__allocatorT_Pythia8__ProcessContainer_p_t_t swig_types[602]
#define SWIGTYPE_p_std__vectorT_Pythia8__ResonanceWidths_p_std__allocatorT_Pythia8__ResonanceWidths_p_t_t swig_types[603]
#define SWIGTYPE_p_std__vectorT_Pythia8__SigmaProcess_p_std__allocatorT_Pythia8__SigmaProcess_p_t_t swig_types[604]
#define SWIGTYPE_p_std__vectorT_Pythia8__StringRegion_std__allocatorT_Pythia8__StringRegion_t_t swig_types[605]
#define SWIGTYPE_p_std__vectorT_Pythia8__StringVertex_std__allocatorT_Pythia8__StringVertex_t_t swig_types[606]
#define SWIGTYPE_p_std__vectorT_Pythia8__UserHooks_p_std__allocatorT_Pythia8__UserHooks_p_t_t swig_types[607]
#define SWIGTYPE_p_std__vectorT_Pythia8__Vec4_std__allocatorT_Pythia8__Vec4_t_t swig_types[608]
#define SWIGTYPE_p_std__vectorT_Pythia8__XMLTag_p_std__allocatorT_Pythia8__XMLTag_p_t_t swig_types[609]
#define SWIGTYPE_p_std__vectorT_bool_std__allocatorT_bool_t_t swig_types[610]
#define SWIGTYPE_p_std__vectorT_double_std__allocatorT_double_t_t swig_types[611]
#define SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t swig_types[612]
#define SWIGTYPE_p_std__vectorT_long_std__allocatorT_long_t_t swig_types[613]
#define SWIGTYPE_p_std__vectorT_std__complexT_double_t_std__allocatorT_std__complexT_double_t_t_t swig_types[614]
#define SWIGTYPE_p_std__vectorT_std__pairT_int_int_t_std__allocatorT_std__pairT_int_int_t_t_t swig_types[615]
#define SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t swig_types[616]
#define SWIGTYPE_p_std__vectorT_std__vectorT_Pythia8__ColourDipole_p_std__allocatorT_Pythia8__ColourDipole_p_t_t_std__allocatorT_std__vectorT_Pythia8__ColourDipole_p_std__allocatorT_Pythia8__ColourDipole_p_t_t_t_t swig_types[617]
#define SWIGTYPE_p_std__vectorT_std__vectorT_double_std__allocatorT_double_t_t_std__allocatorT_std__vectorT_double_std__allocatorT_double_t_t_t_t swig_types[618]
#define SWIGTYPE_p_std__vectorT_std__vectorT_int_std__allocatorT_int_t_t_std__allocatorT_std__vectorT_int_std__allocatorT_int_t_t_t_t swig_types[619]
#define SWIGTYPE_p_std__vectorT_std__vectorT_std__complexT_double_t_std__allocatorT_std__complexT_double_t_t_t_std__allocatorT_std__vectorT_std__complexT_double_t_std__allocatorT_std__complexT_double_t_t_t_t_t swig_types[620]
#define SWIGTYPE_p_std__vectorT_std__vectorT_std__pairT_double_double_t_std__allocatorT_std__pairT_double_double_t_t_t_std__allocatorT_std__vectorT_std__pairT_double_double_t_std__allocatorT_std__pairT_double_double_t_t_t_t_t swig_types[621]
#define SWIGTYPE_p_streamoff swig_types[622]
#define SWIGTYPE_p_streampos swig_types[623]
#define SWIGTYPE_p_stringstream swig_types[624]
#define SWIGTYPE_p_swig__SwigPyIterator swig_types[625]
#define SWIGTYPE_p_traits_type swig_types[626]
#define SWIGTYPE_p_unsigned_int swig_types[627]
#define SWIGTYPE_p_unsigned_long swig_types[628]
#define SWIGTYPE_p_unsigned_long_long swig_types[629]
#define SWIGTYPE_p_unsigned_short swig_types[630]
#define SWIGTYPE_p_value_type swig_types[631]
static swig_type_info *swig_types[633];
static swig_module_info swig_module = {swig_types, 632, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#if (PY_VERSION_HEX <= 0x02000000)
# if !defined(SWIG_PYTHON_CLASSIC)
#  error "This python version requires swig to be run with the '-classic' option"
# endif
#endif

/*-----------------------------------------------
              @(target):= _pythia8.so
  ------------------------------------------------*/
#if PY_VERSION_HEX >= 0x03000000
#  define SWIG_init    PyInit__pythia8

#else
#  define SWIG_init    init_pythia8

#endif
#define SWIG_name    "_pythia8"

#define SWIGVERSION 0x030008 
#define SWIG_VERSION SWIGVERSION


#define SWIG_as_voidptr(a) const_cast< void * >(static_cast< const void * >(a)) 
#define SWIG_as_voidptrptr(a) ((void)SWIG_as_voidptr(*a),reinterpret_cast< void** >(a)) 


#include <stdexcept>


namespace swig {
  class SwigPtr_PyObject {
  protected:
    PyObject *_obj;

  public:
    SwigPtr_PyObject() :_obj(0)
    {
    }

    SwigPtr_PyObject(const SwigPtr_PyObject& item) : _obj(item._obj)
    {
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      Py_XINCREF(_obj);      
      SWIG_PYTHON_THREAD_END_BLOCK;
    }
    
    SwigPtr_PyObject(PyObject *obj, bool initial_ref = true) :_obj(obj)
    {
      if (initial_ref) {
        SWIG_PYTHON_THREAD_BEGIN_BLOCK;
        Py_XINCREF(_obj);
        SWIG_PYTHON_THREAD_END_BLOCK;
      }
    }
    
    SwigPtr_PyObject & operator=(const SwigPtr_PyObject& item) 
    {
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      Py_XINCREF(item._obj);
      Py_XDECREF(_obj);
      _obj = item._obj;
      SWIG_PYTHON_THREAD_END_BLOCK;
      return *this;      
    }
    
    ~SwigPtr_PyObject() 
    {
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      Py_XDECREF(_obj);
      SWIG_PYTHON_THREAD_END_BLOCK;
    }
    
    operator PyObject *() const
    {
      return _obj;
    }

    PyObject *operator->() const
    {
      return _obj;
    }
  };
}


namespace swig {
  struct SwigVar_PyObject : SwigPtr_PyObject {
    SwigVar_PyObject(PyObject* obj = 0) : SwigPtr_PyObject(obj, false) { }
    
    SwigVar_PyObject & operator = (PyObject* obj)
    {
      Py_XDECREF(_obj);
      _obj = obj;
      return *this;      
    }
  };
}


#include <cstddef>


#include <string>


#include <iostream>

#if PY_VERSION_HEX >= 0x03020000
# define SWIGPY_SLICE_ARG(obj) ((PyObject*) (obj))
#else
# define SWIGPY_SLICE_ARG(obj) ((PySliceObject*) (obj))
#endif


#include <stdexcept>


#if defined(__GNUC__)
#  if __GNUC__ == 2 && __GNUC_MINOR <= 96
#     define SWIG_STD_NOMODERN_STL
#  endif
#endif


#include <stddef.h>


namespace swig {
  struct stop_iteration {
  };

  struct SwigPyIterator {
  private:
    SwigPtr_PyObject _seq;

  protected:
    SwigPyIterator(PyObject *seq) : _seq(seq)
    {
    }
      
  public:
    virtual ~SwigPyIterator() {}

    // Access iterator method, required by Python
    virtual PyObject *value() const = 0;

    // Forward iterator method, required by Python
    virtual SwigPyIterator *incr(size_t n = 1) = 0;
    
    // Backward iterator method, very common in C++, but not required in Python
    virtual SwigPyIterator *decr(size_t /*n*/ = 1)
    {
      throw stop_iteration();
    }

    // Random access iterator methods, but not required in Python
    virtual ptrdiff_t distance(const SwigPyIterator &/*x*/) const
    {
      throw std::invalid_argument("operation not supported");
    }

    virtual bool equal (const SwigPyIterator &/*x*/) const
    {
      throw std::invalid_argument("operation not supported");
    }
    
    // C++ common/needed methods
    virtual SwigPyIterator *copy() const = 0;

    PyObject *next()     
    {
      SWIG_PYTHON_THREAD_BEGIN_BLOCK; // disable threads       
      PyObject *obj = value();
      incr();       
      SWIG_PYTHON_THREAD_END_BLOCK; // re-enable threads
      return obj;     
    }

    /* Make an alias for Python 3.x */
    PyObject *__next__()
    {
      return next();
    }

    PyObject *previous()
    {
      SWIG_PYTHON_THREAD_BEGIN_BLOCK; // disable threads       
      decr();
      PyObject *obj = value();
      SWIG_PYTHON_THREAD_END_BLOCK; // re-enable threads       
      return obj;
    }

    SwigPyIterator *advance(ptrdiff_t n)
    {
      return  (n > 0) ?  incr(n) : decr(-n);
    }
      
    bool operator == (const SwigPyIterator& x)  const
    {
      return equal(x);
    }
      
    bool operator != (const SwigPyIterator& x) const
    {
      return ! operator==(x);
    }
      
    SwigPyIterator& operator += (ptrdiff_t n)
    {
      return *advance(n);
    }

    SwigPyIterator& operator -= (ptrdiff_t n)
    {
      return *advance(-n);
    }
      
    SwigPyIterator* operator + (ptrdiff_t n) const
    {
      return copy()->advance(n);
    }

    SwigPyIterator* operator - (ptrdiff_t n) const
    {
      return copy()->advance(-n);
    }
      
    ptrdiff_t operator - (const SwigPyIterator& x) const
    {
      return x.distance(*this);
    }
      
    static swig_type_info* descriptor() {
      static int init = 0;
      static swig_type_info* desc = 0;
      if (!init) {
	desc = SWIG_TypeQuery("swig::SwigPyIterator *");
	init = 1;
      }	
      return desc;
    }    
  };

#if defined(SWIGPYTHON_BUILTIN)
  inline PyObject* make_output_iterator_builtin (PyObject *pyself)
  {
    Py_INCREF(pyself);
    return pyself;
  }
#endif
}


SWIGINTERN int
SWIG_AsVal_double (PyObject *obj, double *val)
{
  int res = SWIG_TypeError;
  if (PyFloat_Check(obj)) {
    if (val) *val = PyFloat_AsDouble(obj);
    return SWIG_OK;
#if PY_VERSION_HEX < 0x03000000
  } else if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AsLong(obj);
    return SWIG_OK;
#endif
  } else if (PyLong_Check(obj)) {
    double v = PyLong_AsDouble(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return SWIG_OK;
    } else {
      PyErr_Clear();
    }
  }
#ifdef SWIG_PYTHON_CAST_MODE
  {
    int dispatch = 0;
    double d = PyFloat_AsDouble(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = d;
      return SWIG_AddCast(SWIG_OK);
    } else {
      PyErr_Clear();
    }
    if (!dispatch) {
      long v = PyLong_AsLong(obj);
      if (!PyErr_Occurred()) {
	if (val) *val = v;
	return SWIG_AddCast(SWIG_AddCast(SWIG_OK));
      } else {
	PyErr_Clear();
      }
    }
  }
#endif
  return res;
}


#include <float.h>


#include <math.h>


SWIGINTERNINLINE int
SWIG_CanCastAsInteger(double *d, double min, double max) {
  double x = *d;
  if ((min <= x && x <= max)) {
   double fx = floor(x);
   double cx = ceil(x);
   double rd =  ((x - fx) < 0.5) ? fx : cx; /* simple rint */
   if ((errno == EDOM) || (errno == ERANGE)) {
     errno = 0;
   } else {
     double summ, reps, diff;
     if (rd < x) {
       diff = x - rd;
     } else if (rd > x) {
       diff = rd - x;
     } else {
       return 1;
     }
     summ = rd + x;
     reps = diff/summ;
     if (reps < 8*DBL_EPSILON) {
       *d = rd;
       return 1;
     }
   }
  }
  return 0;
}


SWIGINTERN int
SWIG_AsVal_unsigned_SS_long (PyObject *obj, unsigned long *val) 
{
#if PY_VERSION_HEX < 0x03000000
  if (PyInt_Check(obj)) {
    long v = PyInt_AsLong(obj);
    if (v >= 0) {
      if (val) *val = v;
      return SWIG_OK;
    } else {
      return SWIG_OverflowError;
    }
  } else
#endif
  if (PyLong_Check(obj)) {
    unsigned long v = PyLong_AsUnsignedLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return SWIG_OK;
    } else {
      PyErr_Clear();
      return SWIG_OverflowError;
    }
  }
#ifdef SWIG_PYTHON_CAST_MODE
  {
    int dispatch = 0;
    unsigned long v = PyLong_AsUnsignedLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return SWIG_AddCast(SWIG_OK);
    } else {
      PyErr_Clear();
    }
    if (!dispatch) {
      double d;
      int res = SWIG_AddCast(SWIG_AsVal_double (obj,&d));
      if (SWIG_IsOK(res) && SWIG_CanCastAsInteger(&d, 0, ULONG_MAX)) {
	if (val) *val = (unsigned long)(d);
	return res;
      }
    }
  }
#endif
  return SWIG_TypeError;
}


SWIGINTERNINLINE int
SWIG_AsVal_size_t (PyObject * obj, size_t *val)
{
  unsigned long v;
  int res = SWIG_AsVal_unsigned_SS_long (obj, val ? &v : 0);
  if (SWIG_IsOK(res) && val) *val = static_cast< size_t >(v);
  return res;
}


  #define SWIG_From_long   PyLong_FromLong 


SWIGINTERNINLINE PyObject *
SWIG_From_ptrdiff_t  (ptrdiff_t value)
{    
  return SWIG_From_long  (static_cast< long >(value));
}


SWIGINTERNINLINE PyObject*
  SWIG_From_bool  (bool value)
{
  return PyBool_FromLong(value ? 1 : 0);
}


SWIGINTERN int
SWIG_AsVal_long (PyObject *obj, long* val)
{
#if PY_VERSION_HEX < 0x03000000
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AsLong(obj);
    return SWIG_OK;
  } else
#endif
  if (PyLong_Check(obj)) {
    long v = PyLong_AsLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return SWIG_OK;
    } else {
      PyErr_Clear();
      return SWIG_OverflowError;
    }
  }
#ifdef SWIG_PYTHON_CAST_MODE
  {
    int dispatch = 0;
    long v = PyInt_AsLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return SWIG_AddCast(SWIG_OK);
    } else {
      PyErr_Clear();
    }
    if (!dispatch) {
      double d;
      int res = SWIG_AddCast(SWIG_AsVal_double (obj,&d));
      if (SWIG_IsOK(res) && SWIG_CanCastAsInteger(&d, LONG_MIN, LONG_MAX)) {
	if (val) *val = (long)(d);
	return res;
      }
    }
  }
#endif
  return SWIG_TypeError;
}


SWIGINTERNINLINE int
SWIG_AsVal_ptrdiff_t (PyObject * obj, ptrdiff_t *val)
{
  long v;
  int res = SWIG_AsVal_long (obj, val ? &v : 0);
  if (SWIG_IsOK(res) && val) *val = static_cast< ptrdiff_t >(v);
  return res;
}


#include <algorithm>


#include <vector>


#include <utility>


#include <map>


#include <algorithm>


#include <deque>


#include <set>


#include <list>


#ifndef SWIG_STD_NOMODERN_STL
# include <ios>
#else
# include <streambuf.h>
#endif


SWIGINTERNINLINE PyObject*
  SWIG_From_int  (int value)
{
  return PyInt_FromLong((long) value);
}


#include <limits.h>
#if !defined(SWIG_NO_LLONG_MAX)
# if !defined(LLONG_MAX) && defined(__GNUC__) && defined (__LONG_LONG_MAX__)
#   define LLONG_MAX __LONG_LONG_MAX__
#   define LLONG_MIN (-LLONG_MAX - 1LL)
#   define ULLONG_MAX (LLONG_MAX * 2ULL + 1ULL)
# endif
#endif


SWIGINTERN int
SWIG_AsVal_int (PyObject * obj, int *val)
{
  long v;
  int res = SWIG_AsVal_long (obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v < INT_MIN || v > INT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< int >(v);
    }
  }  
  return res;
}


SWIGINTERNINLINE PyObject* 
SWIG_From_unsigned_SS_long  (unsigned long value)
{
  return (value > LONG_MAX) ?
    PyLong_FromUnsignedLong(value) : PyLong_FromLong(static_cast< long >(value)); 
}


SWIGINTERNINLINE PyObject *
SWIG_From_size_t  (size_t value)
{    
  return SWIG_From_unsigned_SS_long  (static_cast< unsigned long >(value));
}


SWIGINTERN int
SWIG_AsVal_bool (PyObject *obj, bool *val)
{
  int r;
  if (!PyBool_Check(obj))
    return SWIG_ERROR;
  r = PyObject_IsTrue(obj);
  if (r == -1)
    return SWIG_ERROR;
  if (val) *val = r ? true : false;
  return SWIG_OK;
}


SWIGINTERN swig_type_info*
SWIG_pchar_descriptor(void)
{
  static int init = 0;
  static swig_type_info* info = 0;
  if (!init) {
    info = SWIG_TypeQuery("_p_char");
    init = 1;
  }
  return info;
}


SWIGINTERNINLINE PyObject *
SWIG_FromCharPtrAndSize(const char* carray, size_t size)
{
  if (carray) {
    if (size > INT_MAX) {
      swig_type_info* pchar_descriptor = SWIG_pchar_descriptor();
      return pchar_descriptor ? 
	SWIG_InternalNewPointerObj(const_cast< char * >(carray), pchar_descriptor, 0) : SWIG_Py_Void();
    } else {
#if PY_VERSION_HEX >= 0x03000000
#if PY_VERSION_HEX >= 0x03010000
      return PyUnicode_DecodeUTF8(carray, static_cast< Py_ssize_t >(size), "surrogateescape");
#else
      return PyUnicode_FromStringAndSize(carray, static_cast< Py_ssize_t >(size));
#endif
#else
      return PyString_FromStringAndSize(carray, static_cast< Py_ssize_t >(size));
#endif
    }
  } else {
    return SWIG_Py_Void();
  }
}


SWIGINTERNINLINE PyObject *
SWIG_From_char  (char c) 
{ 
  return SWIG_FromCharPtrAndSize(&c,1);
}


SWIGINTERN int
SWIG_AsCharPtrAndSize(PyObject *obj, char** cptr, size_t* psize, int *alloc)
{
#if PY_VERSION_HEX>=0x03000000
  if (PyUnicode_Check(obj))
#else  
  if (PyString_Check(obj))
#endif
  {
    char *cstr; Py_ssize_t len;
#if PY_VERSION_HEX>=0x03000000
    if (!alloc && cptr) {
        /* We can't allow converting without allocation, since the internal
           representation of string in Python 3 is UCS-2/UCS-4 but we require
           a UTF-8 representation.
           TODO(bhy) More detailed explanation */
        return SWIG_RuntimeError;
    }
    obj = PyUnicode_AsUTF8String(obj);
    PyBytes_AsStringAndSize(obj, &cstr, &len);
    if(alloc) *alloc = SWIG_NEWOBJ;
#else
    PyString_AsStringAndSize(obj, &cstr, &len);
#endif
    if (cptr) {
      if (alloc) {
	/* 
	   In python the user should not be able to modify the inner
	   string representation. To warranty that, if you define
	   SWIG_PYTHON_SAFE_CSTRINGS, a new/copy of the python string
	   buffer is always returned.

	   The default behavior is just to return the pointer value,
	   so, be careful.
	*/ 
#if defined(SWIG_PYTHON_SAFE_CSTRINGS)
	if (*alloc != SWIG_OLDOBJ) 
#else
	if (*alloc == SWIG_NEWOBJ) 
#endif
	{
	  *cptr = reinterpret_cast< char* >(memcpy((new char[len + 1]), cstr, sizeof(char)*(len + 1)));
	  *alloc = SWIG_NEWOBJ;
	} else {
	  *cptr = cstr;
	  *alloc = SWIG_OLDOBJ;
	}
      } else {
	#if PY_VERSION_HEX>=0x03000000
	assert(0); /* Should never reach here in Python 3 */
	#endif
	*cptr = SWIG_Python_str_AsChar(obj);
      }
    }
    if (psize) *psize = len + 1;
#if PY_VERSION_HEX>=0x03000000
    Py_XDECREF(obj);
#endif
    return SWIG_OK;
  } else {
#if defined(SWIG_PYTHON_2_UNICODE)
#if PY_VERSION_HEX<0x03000000
    if (PyUnicode_Check(obj)) {
      char *cstr; Py_ssize_t len;
      if (!alloc && cptr) {
        return SWIG_RuntimeError;
      }
      obj = PyUnicode_AsUTF8String(obj);
      if (PyString_AsStringAndSize(obj, &cstr, &len) != -1) {
        if (cptr) {
          if (alloc) *alloc = SWIG_NEWOBJ;
          *cptr = reinterpret_cast< char* >(memcpy((new char[len + 1]), cstr, sizeof(char)*(len + 1)));
        }
        if (psize) *psize = len + 1;

        Py_XDECREF(obj);
        return SWIG_OK;
      } else {
        Py_XDECREF(obj);
      }
    }
#endif
#endif

    swig_type_info* pchar_descriptor = SWIG_pchar_descriptor();
    if (pchar_descriptor) {
      void* vptr = 0;
      if (SWIG_ConvertPtr(obj, &vptr, pchar_descriptor, 0) == SWIG_OK) {
	if (cptr) *cptr = (char *) vptr;
	if (psize) *psize = vptr ? (strlen((char *)vptr) + 1) : 0;
	if (alloc) *alloc = SWIG_OLDOBJ;
	return SWIG_OK;
      }
    }
  }
  return SWIG_TypeError;
}


SWIGINTERN int
SWIG_AsCharArray(PyObject * obj, char *val, size_t size)
{ 
  char* cptr = 0; size_t csize = 0; int alloc = SWIG_OLDOBJ;
  int res = SWIG_AsCharPtrAndSize(obj, &cptr, &csize, &alloc);
  if (SWIG_IsOK(res)) {
    /* special case of single char conversion when we don't need space for NUL */
    if (size == 1 && csize == 2 && cptr && !cptr[1]) --csize;
    if (csize <= size) {
      if (val) {
	if (csize) memcpy(val, cptr, csize*sizeof(char));
	if (csize < size) memset(val + csize, 0, (size - csize)*sizeof(char));
      }
      if (alloc == SWIG_NEWOBJ) {
	delete[] cptr;
	res = SWIG_DelNewMask(res);
      }      
      return res;
    }
    if (alloc == SWIG_NEWOBJ) delete[] cptr;
  }
  return SWIG_TypeError;
}


SWIGINTERN int
SWIG_AsVal_char (PyObject * obj, char *val)
{    
  int res = SWIG_AsCharArray(obj, val, 1);
  if (!SWIG_IsOK(res)) {
    long v;
    res = SWIG_AddCast(SWIG_AsVal_long (obj, &v));
    if (SWIG_IsOK(res)) {
      if ((CHAR_MIN <= v) && (v <= CHAR_MAX)) {
	if (val) *val = static_cast< char >(v);
      } else {
	res = SWIG_OverflowError;
      }
    }
  }
  return res;
}


#include <iostream>


SWIGINTERN int
SWIG_AsVal_short (PyObject * obj, short *val)
{
  long v;
  int res = SWIG_AsVal_long (obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v < SHRT_MIN || v > SHRT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< short >(v);
    }
  }  
  return res;
}


SWIGINTERN int
SWIG_AsVal_unsigned_SS_short (PyObject * obj, unsigned short *val)
{
  unsigned long v;
  int res = SWIG_AsVal_unsigned_SS_long (obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v > USHRT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< unsigned short >(v);
    }
  }  
  return res;
}


SWIGINTERN int
SWIG_AsVal_unsigned_SS_int (PyObject * obj, unsigned int *val)
{
  unsigned long v;
  int res = SWIG_AsVal_unsigned_SS_long (obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v > UINT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< unsigned int >(v);
    }
  }  
  return res;
}


SWIGINTERN int
SWIG_AsVal_long_SS_long (PyObject *obj, long long *val)
{
  int res = SWIG_TypeError;
  if (PyLong_Check(obj)) {
    long long v = PyLong_AsLongLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return SWIG_OK;
    } else {
      PyErr_Clear();
      res = SWIG_OverflowError;
    }
  } else {
    long v;
    res = SWIG_AsVal_long (obj,&v);
    if (SWIG_IsOK(res)) {
      if (val) *val = v;
      return res;
    }
  }
#ifdef SWIG_PYTHON_CAST_MODE
  {
    const double mant_max = 1LL << DBL_MANT_DIG;
    const double mant_min = -mant_max;
    double d;
    res = SWIG_AsVal_double (obj,&d);
    if (SWIG_IsOK(res) && SWIG_CanCastAsInteger(&d, mant_min, mant_max)) {
      if (val) *val = (long long)(d);
      return SWIG_AddCast(res);
    }
    res = SWIG_TypeError;
  }
#endif
  return res;
}


SWIGINTERN int
SWIG_AsVal_unsigned_SS_long_SS_long (PyObject *obj, unsigned long long *val)
{
  int res = SWIG_TypeError;
  if (PyLong_Check(obj)) {
    unsigned long long v = PyLong_AsUnsignedLongLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return SWIG_OK;
    } else {
      PyErr_Clear();
      res = SWIG_OverflowError;
    }
  } else {
    unsigned long v;
    res = SWIG_AsVal_unsigned_SS_long (obj,&v);
    if (SWIG_IsOK(res)) {
      if (val) *val = v;
      return res;
    }
  }
#ifdef SWIG_PYTHON_CAST_MODE
  {
    const double mant_max = 1LL << DBL_MANT_DIG;
    double d;
    res = SWIG_AsVal_double (obj,&d);
    if (SWIG_IsOK(res) && SWIG_CanCastAsInteger(&d, 0, mant_max)) {
      if (val) *val = (unsigned long long)(d);
      return SWIG_AddCast(res);
    }
    res = SWIG_TypeError;
  }
#endif
  return res;
}


/* Getting isfinite working pre C99 across multiple platforms is non-trivial. Users can provide SWIG_isfinite on older platforms. */
#ifndef SWIG_isfinite
# if defined(isfinite)
#  define SWIG_isfinite(X) (isfinite(X))
# elif defined(_MSC_VER)
#  define SWIG_isfinite(X) (_finite(X))
# elif defined(__sun) && defined(__SVR4)
#  include <ieeefp.h>
#  define SWIG_isfinite(X) (finite(X))
# endif
#endif


/* Accept infinite as a valid float value unless we are unable to check if a value is finite */
#ifdef SWIG_isfinite
# define SWIG_Float_Overflow_Check(X) ((X < -FLT_MAX || X > FLT_MAX) && SWIG_isfinite(X))
#else
# define SWIG_Float_Overflow_Check(X) ((X < -FLT_MAX || X > FLT_MAX))
#endif


SWIGINTERN int
SWIG_AsVal_float (PyObject * obj, float *val)
{
  double v;
  int res = SWIG_AsVal_double (obj, &v);
  if (SWIG_IsOK(res)) {
    if (SWIG_Float_Overflow_Check(v)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< float >(v);
    }
  }  
  return res;
}

SWIGINTERN std::basic_ostream< char,std::char_traits< char > > &std_basic_ostream_Sl_char_Sg__operator_Sl__Sl___SWIG_17(std::basic_ostream< char > *self,std::basic_string< char,std::char_traits< char >,std::allocator< char > > const &s){
	  *self << s;
	  return *self;
	}




#ifndef SWIG_STD_NOMODERN_STL
#include <streambuf>
#else
#include <streambuf.h>
#endif


#include <sstream>


#include <complex> 


namespace swig {
  template <class Type>
  struct noconst_traits {
    typedef Type noconst_type;
  };

  template <class Type>
  struct noconst_traits<const Type> {
    typedef Type noconst_type;
  };

  /*
    type categories
  */
  struct pointer_category { };
  struct value_category { };

  /*
    General traits that provides type_name and type_info
  */
  template <class Type> struct traits { };

  template <class Type>
  inline const char* type_name() {
    return traits<typename noconst_traits<Type >::noconst_type >::type_name();
  }

  template <class Type>
  struct traits_info {
    static swig_type_info *type_query(std::string name) {
      name += " *";
      return SWIG_TypeQuery(name.c_str());
    }
    static swig_type_info *type_info() {
      static swig_type_info *info = type_query(type_name<Type>());
      return info;
    }
  };

  template <class Type>
  inline swig_type_info *type_info() {
    return traits_info<Type>::type_info();
  }

  /*
    Partial specialization for pointers
  */
  template <class Type> struct traits <Type *> {
    typedef pointer_category category;
    static std::string make_ptr_name(const char* name) {
      std::string ptrname = name;
      ptrname += " *";
      return ptrname;
    }
    static const char* type_name() {
      static std::string name = make_ptr_name(swig::type_name<Type>());
      return name.c_str();
    }
  };

  template <class Type, class Category>
  struct traits_as { };

  template <class Type, class Category>
  struct traits_check { };

}


namespace swig {  
  /*
    Traits that provides the from method
  */
  template <class Type> struct traits_from_ptr {
    static PyObject *from(Type *val, int owner = 0) {
      return SWIG_InternalNewPointerObj(val, type_info<Type>(), owner);
    }
  };

  template <class Type> struct traits_from {
    static PyObject *from(const Type& val) {
      return traits_from_ptr<Type>::from(new Type(val), 1);
    }
  };

  template <class Type> struct traits_from<Type *> {
    static PyObject *from(Type* val) {
      return traits_from_ptr<Type>::from(val, 0);
    }
  };

  template <class Type> struct traits_from<const Type *> {
    static PyObject *from(const Type* val) {
      return traits_from_ptr<Type>::from(const_cast<Type*>(val), 0);
    }
  };


  template <class Type>
  inline PyObject *from(const Type& val) {
    return traits_from<Type>::from(val);
  }

  template <class Type>
  inline PyObject *from_ptr(Type* val, int owner) {
    return traits_from_ptr<Type>::from(val, owner);
  }

  /*
    Traits that provides the asval/as/check method
  */
  template <class Type>
  struct traits_asptr {   
    static int asptr(PyObject *obj, Type **val) {
      Type *p;
      int res = SWIG_ConvertPtr(obj, (void**)&p, type_info<Type>(), 0);
      if (SWIG_IsOK(res)) {
	if (val) *val = p;
      }
      return res;
    }
  }; 

  template <class Type>
  inline int asptr(PyObject *obj, Type **vptr) {
    return traits_asptr<Type>::asptr(obj, vptr);
  }

  template <class Type> 
  struct traits_asval {
    static int asval(PyObject *obj, Type *val) {
      if (val) {
	Type *p = 0;
	int res = traits_asptr<Type>::asptr(obj, &p);
	if (!SWIG_IsOK(res)) return res;	
	if (p) {
	  typedef typename noconst_traits<Type>::noconst_type noconst_type;
	  *(const_cast<noconst_type*>(val)) = *p;
	  if (SWIG_IsNewObj(res)){
	    delete p;
	    res = SWIG_DelNewMask(res);
	  }
	  return res;
	} else {
	  return SWIG_ERROR;
	}
      } else {
	return traits_asptr<Type>::asptr(obj, (Type **)(0));
      }
    }
  };

  template <class Type> struct traits_asval<Type*> {
    static int asval(PyObject *obj, Type **val) {
      if (val) {
        typedef typename noconst_traits<Type>::noconst_type noconst_type;
        noconst_type *p = 0;
        int res = traits_asptr<noconst_type>::asptr(obj,  &p);
        if (SWIG_IsOK(res)) {
          *(const_cast<noconst_type**>(val)) = p;
	}
	return res;
      } else {
	return traits_asptr<Type>::asptr(obj, (Type **)(0));
      }
    }
  };
  
  template <class Type>
  inline int asval(PyObject *obj, Type *val) {
    return traits_asval<Type>::asval(obj, val);
  }

  template <class Type> 
  struct traits_as<Type, value_category> {
    static Type as(PyObject *obj, bool throw_error) {
      Type v;
      int res = asval(obj, &v);
      if (!obj || !SWIG_IsOK(res)) {
	if (!PyErr_Occurred()) {
	  ::SWIG_Error(SWIG_TypeError,  swig::type_name<Type>());
	}
	if (throw_error) throw std::invalid_argument("bad type");
      }
      return v;
    }
  };

  template <class Type> 
  struct traits_as<Type, pointer_category> {
    static Type as(PyObject *obj, bool throw_error) {
      Type *v = 0;      
      int res = (obj ? traits_asptr<Type>::asptr(obj, &v) : SWIG_ERROR);
      if (SWIG_IsOK(res) && v) {
	if (SWIG_IsNewObj(res)) {
	  Type r(*v);
	  delete v;
	  return r;
	} else {
	  return *v;
	}
      } else {
	// Uninitialized return value, no Type() constructor required.
	static Type *v_def = (Type*) malloc(sizeof(Type));
	if (!PyErr_Occurred()) {
	  SWIG_Error(SWIG_TypeError,  swig::type_name<Type>());
	}
	if (throw_error) throw std::invalid_argument("bad type");
	memset(v_def,0,sizeof(Type));
	return *v_def;
      }
    }
  };

  template <class Type> 
  struct traits_as<Type*, pointer_category> {
    static Type* as(PyObject *obj, bool throw_error) {
      Type *v = 0;      
      int res = (obj ? traits_asptr<Type>::asptr(obj, &v) : SWIG_ERROR);
      if (SWIG_IsOK(res)) {
	return v;
      } else {
	if (!PyErr_Occurred()) {
	  SWIG_Error(SWIG_TypeError,  swig::type_name<Type>());
	}
	if (throw_error) throw std::invalid_argument("bad type");
	return 0;
      }
    }
  };
    
  template <class Type>
  inline Type as(PyObject *obj, bool te = false) {
    return traits_as<Type, typename traits<Type>::category>::as(obj, te);
  }

  template <class Type> 
  struct traits_check<Type, value_category> {
    static bool check(PyObject *obj) {
      int res = obj ? asval(obj, (Type *)(0)) : SWIG_ERROR;
      return SWIG_IsOK(res) ? true : false;
    }
  };

  template <class Type> 
  struct traits_check<Type, pointer_category> {
    static bool check(PyObject *obj) {
      int res = obj ? asptr(obj, (Type **)(0)) : SWIG_ERROR;
      return SWIG_IsOK(res) ? true : false;
    }
  };

  template <class Type>
  inline bool check(PyObject *obj) {
    return traits_check<Type, typename traits<Type>::category>::check(obj);
  }
}


namespace swig {
  template <> struct traits< int > {
    typedef value_category category;
    static const char* type_name() { return"int"; }
  };
  template <>  struct traits_asval< int > {
    typedef int value_type;
    static int asval(PyObject *obj, value_type *val) {
      return SWIG_AsVal_int (obj, val);
    }
  };
  template <>  struct traits_from< int > {
    typedef int value_type;
    static PyObject *from(const value_type& val) {
      return SWIG_From_int  (val);
    }
  };
}


  namespace swig {

















































    template <class T, class U >
    struct traits_asptr<std::pair<T,U> >  {
      typedef std::pair<T,U> value_type;

      static int get_pair(PyObject* first, PyObject* second,
			  std::pair<T,U> **val) 
      {
	if (val) {
	  value_type *vp = (new std::pair<T,U>);
	  T *pfirst = &(vp->first);
	  int res1 = swig::asval((PyObject*)first, pfirst);
	  if (!SWIG_IsOK(res1)) return res1;
	  U *psecond = &(vp->second);
	  int res2 = swig::asval((PyObject*)second, psecond);
	  if (!SWIG_IsOK(res2)) return res2;
	  *val = vp;
	  return SWIG_AddNewMask(res1 > res2 ? res1 : res2);
	} else {
	  T *pfirst = 0;
	  int res1 = swig::asval((PyObject*)first, pfirst);
	  if (!SWIG_IsOK(res1)) return res1;
	  U *psecond = 0;
	  int res2 = swig::asval((PyObject*)second, psecond);
	  if (!SWIG_IsOK(res2)) return res2;
	  return res1 > res2 ? res1 : res2;
	}	
      }

      static int asptr(PyObject *obj, std::pair<T,U> **val) {
	int res = SWIG_ERROR;
	if (PyTuple_Check(obj)) {
	  if (PyTuple_GET_SIZE(obj) == 2) {
	    res = get_pair(PyTuple_GET_ITEM(obj,0),PyTuple_GET_ITEM(obj,1), val);
	  }
	} else if (PySequence_Check(obj)) {
	  if (PySequence_Size(obj) == 2) {
	    swig::SwigVar_PyObject first = PySequence_GetItem(obj,0);
	    swig::SwigVar_PyObject second = PySequence_GetItem(obj,1);
	    res = get_pair(first, second, val);
	  }
	} else {
	  value_type *p;
	  res = SWIG_ConvertPtr(obj,(void**)&p,swig::type_info<value_type>(),0);
	  if (SWIG_IsOK(res) && val)  *val = p;
	}
	return res;
      }
    };


    template <class T, class U >
    struct traits_from<std::pair<T,U> >   {
      static PyObject *from(const std::pair<T,U>& val) {
	PyObject* obj = PyTuple_New(2);
	PyTuple_SetItem(obj,0,swig::from(val.first));
	PyTuple_SetItem(obj,1,swig::from(val.second));
	return obj;
      }
    };
  }





































      namespace swig {
	template <>  struct traits<std::pair< int, int > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "int" "," "int" " >";
	  }
	};
      }
    

#include <functional>

namespace std {
  template <>
  struct less <PyObject *>: public binary_function<PyObject *, PyObject *, bool>
  {
    bool
    operator()(PyObject * v, PyObject *w) const
    { 
      bool res;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      res = PyObject_RichCompareBool(v, w, Py_LT) ? true : false;
      /* This may fall into a case of inconsistent
               eg. ObjA > ObjX > ObjB
               but ObjA < ObjB
      */
      if( PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_TypeError) )
      {
        /* Objects can't be compared, this mostly occurred in Python 3.0 */
        /* Compare their ptr directly for a workaround */
        res = (v < w);
        PyErr_Clear();
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return res;
    }
  };

  template <>
  struct less <swig::SwigPtr_PyObject>: public binary_function<swig::SwigPtr_PyObject, swig::SwigPtr_PyObject, bool>
  {
    bool
    operator()(const swig::SwigPtr_PyObject& v, const swig::SwigPtr_PyObject& w) const
    {
      return std::less<PyObject *>()(v, w);
    }
  };

  template <>
  struct less <swig::SwigVar_PyObject>: public binary_function<swig::SwigVar_PyObject, swig::SwigVar_PyObject, bool>
  {
    bool
    operator()(const swig::SwigVar_PyObject& v, const swig::SwigVar_PyObject& w) const
    {
      return std::less<PyObject *>()(v, w);
    }
  };

}

namespace swig {
  template <> struct traits<PyObject *> {
    typedef value_category category;
    static const char* type_name() { return "PyObject *"; }
  };  

  template <>  struct traits_asval<PyObject * > {   
    typedef PyObject * value_type;
    static int asval(PyObject *obj, value_type *val) {
      if (val) *val = obj;
      return SWIG_OK;
    }
  };

  template <> 
  struct traits_check<PyObject *, value_category> {
    static bool check(PyObject *) {
      return true;
    }
  };

  template <>  struct traits_from<PyObject *> {
    typedef PyObject * value_type;
    static PyObject *from(const value_type& val) {
      Py_XINCREF(val);
      return val;
    }
  };
  
}

namespace swig {
  template <class Difference>
  inline size_t
  check_index(Difference i, size_t size, bool insert = false) {
    if ( i < 0 ) {
      if ((size_t) (-i) <= size)
	return (size_t) (i + size);
    } else if ( (size_t) i < size ) {
      return (size_t) i;
    } else if (insert && ((size_t) i == size)) {
      return size;
    }
    throw std::out_of_range("index out of range");
  }

  template <class Difference>
  void
  slice_adjust(Difference i, Difference j, Py_ssize_t step, size_t size, Difference &ii, Difference &jj, bool insert = false) {
    if (step == 0) {
      throw std::invalid_argument("slice step cannot be zero");
    } else if (step > 0) {
      // Required range: 0 <= i < size, 0 <= j < size
      if (i < 0) {
        ii = 0;
      } else if (i < (Difference)size) {
        ii = i;
      } else if (insert && (i >= (Difference)size)) {
        ii = (Difference)size;
      }
      if ( j < 0 ) {
        jj = 0;
      } else {
        jj = (j < (Difference)size) ? j : (Difference)size;
      }
    } else {
      // Required range: -1 <= i < size-1, -1 <= j < size-1
      if (i < -1) {
        ii = -1;
      } else if (i < (Difference) size) {
        ii = i;
      } else if (i >= (Difference)(size-1)) {
        ii = (Difference)(size-1);
      }
      if (j < -1) {
        jj = -1;
      } else {
        jj = (j < (Difference)size ) ? j : (Difference)(size-1);
      }
    }
  }

  template <class Sequence, class Difference>
  inline typename Sequence::iterator
  getpos(Sequence* self, Difference i)  {
    typename Sequence::iterator pos = self->begin();
    std::advance(pos, check_index(i,self->size()));
    return pos;
  }

  template <class Sequence, class Difference>
  inline typename Sequence::const_iterator
  cgetpos(const Sequence* self, Difference i)  {
    typename Sequence::const_iterator pos = self->begin();
    std::advance(pos, check_index(i,self->size()));
    return pos;
  }

  template <class Sequence>
  inline void
  erase(Sequence* seq, const typename Sequence::iterator& position) {
    seq->erase(position);
  }

  template <class Sequence, class Difference>
  inline Sequence*
  getslice(const Sequence* self, Difference i, Difference j, Py_ssize_t step) {
    typename Sequence::size_type size = self->size();
    Difference ii = 0;
    Difference jj = 0;
    swig::slice_adjust(i, j, step, size, ii, jj);

    if (step > 0) {
      typename Sequence::const_iterator sb = self->begin();
      typename Sequence::const_iterator se = self->begin();
      std::advance(sb,ii);
      std::advance(se,jj);
      if (step == 1) {
        return new Sequence(sb, se);
      } else {
        Sequence *sequence = new Sequence();
        typename Sequence::const_iterator it = sb;
        while (it!=se) {
          sequence->push_back(*it);
          for (Py_ssize_t c=0; c<step && it!=se; ++c)
            it++;
        }
        return sequence;
      } 
    } else {
      Sequence *sequence = new Sequence();
      if (ii > jj) {
        typename Sequence::const_reverse_iterator sb = self->rbegin();
        typename Sequence::const_reverse_iterator se = self->rbegin();
        std::advance(sb,size-ii-1);
        std::advance(se,size-jj-1);
        typename Sequence::const_reverse_iterator it = sb;
        while (it!=se) {
          sequence->push_back(*it);
          for (Py_ssize_t c=0; c<-step && it!=se; ++c)
            it++;
        }
      }
      return sequence;
    }
  }

  template <class Sequence, class Difference, class InputSeq>
  inline void
  setslice(Sequence* self, Difference i, Difference j, Py_ssize_t step, const InputSeq& is = InputSeq()) {
    typename Sequence::size_type size = self->size();
    Difference ii = 0;
    Difference jj = 0;
    swig::slice_adjust(i, j, step, size, ii, jj, true);
    if (step > 0) {
      if (jj < ii)
        jj = ii;
      if (step == 1) {
        size_t ssize = jj - ii;
        if (ssize <= is.size()) {
          // expanding/staying the same size
          typename Sequence::iterator sb = self->begin();
          typename InputSeq::const_iterator isit = is.begin();
          std::advance(sb,ii);
          std::advance(isit, jj - ii);
          self->insert(std::copy(is.begin(), isit, sb), isit, is.end());
        } else {
          // shrinking
          typename Sequence::iterator sb = self->begin();
          typename Sequence::iterator se = self->begin();
          std::advance(sb,ii);
          std::advance(se,jj);
          self->erase(sb,se);
          sb = self->begin();
          std::advance(sb,ii);
          self->insert(sb, is.begin(), is.end());
        }
      } else {
        size_t replacecount = (jj - ii + step - 1) / step;
        if (is.size() != replacecount) {
          char msg[1024];
          sprintf(msg, "attempt to assign sequence of size %lu to extended slice of size %lu", (unsigned long)is.size(), (unsigned long)replacecount);
          throw std::invalid_argument(msg);
        }
        typename Sequence::const_iterator isit = is.begin();
        typename Sequence::iterator it = self->begin();
        std::advance(it,ii);
        for (size_t rc=0; rc<replacecount; ++rc) {
          *it++ = *isit++;
          for (Py_ssize_t c=0; c<(step-1) && it != self->end(); ++c)
            it++;
        }
      }
    } else {
      if (jj > ii)
        jj = ii;
      size_t replacecount = (ii - jj - step - 1) / -step;
      if (is.size() != replacecount) {
        char msg[1024];
        sprintf(msg, "attempt to assign sequence of size %lu to extended slice of size %lu", (unsigned long)is.size(), (unsigned long)replacecount);
        throw std::invalid_argument(msg);
      }
      typename Sequence::const_iterator isit = is.begin();
      typename Sequence::reverse_iterator it = self->rbegin();
      std::advance(it,size-ii-1);
      for (size_t rc=0; rc<replacecount; ++rc) {
        *it++ = *isit++;
        for (Py_ssize_t c=0; c<(-step-1) && it != self->rend(); ++c)
          it++;
      }
    }
  }

  template <class Sequence, class Difference>
  inline void
  delslice(Sequence* self, Difference i, Difference j, Py_ssize_t step) {
    typename Sequence::size_type size = self->size();
    Difference ii = 0;
    Difference jj = 0;
    swig::slice_adjust(i, j, step, size, ii, jj, true);
    if (step > 0) {
      if (jj > ii) {
        typename Sequence::iterator sb = self->begin();
        std::advance(sb,ii);
        if (step == 1) {
          typename Sequence::iterator se = self->begin();
          std::advance(se,jj);
          self->erase(sb,se);
        } else {
          typename Sequence::iterator it = sb;
          size_t delcount = (jj - ii + step - 1) / step;
          while (delcount) {
            it = self->erase(it);
            for (Py_ssize_t c=0; c<(step-1) && it != self->end(); ++c)
              it++;
            delcount--;
          }
        }
      }
    } else {
      if (ii > jj) {
        typename Sequence::reverse_iterator sb = self->rbegin();
        std::advance(sb,size-ii-1);
        typename Sequence::reverse_iterator it = sb;
        size_t delcount = (ii - jj - step - 1) / -step;
        while (delcount) {
          it = typename Sequence::reverse_iterator(self->erase((++it).base()));
          for (Py_ssize_t c=0; c<(-step-1) && it != self->rend(); ++c)
            it++;
          delcount--;
        }
      }
    }
  }
}


#if defined(__SUNPRO_CC) && defined(_RWSTD_VER)
#  if !defined(SWIG_NO_STD_NOITERATOR_TRAITS_STL)
#    define SWIG_STD_NOITERATOR_TRAITS_STL
#  endif
#endif

#if !defined(SWIG_STD_NOITERATOR_TRAITS_STL)
#include <iterator>
#else
namespace std {
  template <class Iterator>
  struct iterator_traits {
    typedef ptrdiff_t difference_type;
    typedef typename Iterator::value_type value_type;
  };

  template <class Iterator, class Category,class T, class Reference, class Pointer, class Distance>
  struct iterator_traits<__reverse_bi_iterator<Iterator,Category,T,Reference,Pointer,Distance> > {
    typedef Distance difference_type;
    typedef T value_type;
  };

  template <class T>
  struct iterator_traits<T*> {
    typedef T value_type;
    typedef ptrdiff_t difference_type;
  };

  template<typename _InputIterator>
  inline typename iterator_traits<_InputIterator>::difference_type
  distance(_InputIterator __first, _InputIterator __last)
  {
    typename iterator_traits<_InputIterator>::difference_type __n = 0;
    while (__first != __last) {
      ++__first; ++__n;
    }
    return __n;
  }
}
#endif


namespace swig {
  template<typename OutIterator>
  class SwigPyIterator_T :  public SwigPyIterator
  {
  public:
    typedef OutIterator out_iterator;
    typedef typename std::iterator_traits<out_iterator>::value_type value_type;    
    typedef SwigPyIterator_T<out_iterator> self_type;

    SwigPyIterator_T(out_iterator curr, PyObject *seq)
      : SwigPyIterator(seq), current(curr)
    {
    }

    const out_iterator& get_current() const
    {
      return current;
    }

    
    bool equal (const SwigPyIterator &iter) const
    {
      const self_type *iters = dynamic_cast<const self_type *>(&iter);
      if (iters) {
	return (current == iters->get_current());
      } else {
	throw std::invalid_argument("bad iterator type");
      }
    }
    
    ptrdiff_t distance(const SwigPyIterator &iter) const
    {
      const self_type *iters = dynamic_cast<const self_type *>(&iter);
      if (iters) {
	return std::distance(current, iters->get_current());
      } else {
	throw std::invalid_argument("bad iterator type");
      }
    }    
    
  protected:
    out_iterator current;
  };
  
  template <class ValueType>
  struct from_oper 
  {
    typedef const ValueType& argument_type;
    typedef PyObject *result_type;
    result_type operator()(argument_type v) const
    {
      return swig::from(v);
    }
  };

  template<typename OutIterator, 
	   typename ValueType = typename std::iterator_traits<OutIterator>::value_type,
	   typename FromOper = from_oper<ValueType> >
  class SwigPyIteratorOpen_T :  public SwigPyIterator_T<OutIterator>
  {
  public:
    FromOper from;
    typedef OutIterator out_iterator;
    typedef ValueType value_type;
    typedef SwigPyIterator_T<out_iterator>  base;
    typedef SwigPyIteratorOpen_T<OutIterator, ValueType, FromOper> self_type;
    
    SwigPyIteratorOpen_T(out_iterator curr, PyObject *seq)
      : SwigPyIterator_T<OutIterator>(curr, seq)
    {
    }
    
    PyObject *value() const {
      return from(static_cast<const value_type&>(*(base::current)));
    }
    
    SwigPyIterator *copy() const
    {
      return new self_type(*this);
    }

    SwigPyIterator *incr(size_t n = 1)
    {
      while (n--) {
	++base::current;
      }
      return this;
    }

    SwigPyIterator *decr(size_t n = 1)
    {
      while (n--) {
	--base::current;
      }
      return this;
    }
  };

  template<typename OutIterator, 
	   typename ValueType = typename std::iterator_traits<OutIterator>::value_type,
	   typename FromOper = from_oper<ValueType> >
  class SwigPyIteratorClosed_T :  public SwigPyIterator_T<OutIterator>
  {
  public:
    FromOper from;
    typedef OutIterator out_iterator;
    typedef ValueType value_type;
    typedef SwigPyIterator_T<out_iterator>  base;    
    typedef SwigPyIteratorClosed_T<OutIterator, ValueType, FromOper> self_type;
    
    SwigPyIteratorClosed_T(out_iterator curr, out_iterator first, out_iterator last, PyObject *seq)
      : SwigPyIterator_T<OutIterator>(curr, seq), begin(first), end(last)
    {
    }
    
    PyObject *value() const {
      if (base::current == end) {
	throw stop_iteration();
      } else {
	return from(static_cast<const value_type&>(*(base::current)));
      }
    }
    
    SwigPyIterator *copy() const
    {
      return new self_type(*this);
    }

    SwigPyIterator *incr(size_t n = 1)
    {
      while (n--) {
	if (base::current == end) {
	  throw stop_iteration();
	} else {
	  ++base::current;
	}
      }
      return this;
    }

    SwigPyIterator *decr(size_t n = 1)
    {
      while (n--) {
	if (base::current == begin) {
	  throw stop_iteration();
	} else {
	  --base::current;
	}
      }
      return this;
    }

  private:
    out_iterator begin;
    out_iterator end;
  };

  template<typename OutIter>
  inline SwigPyIterator*
  make_output_iterator(const OutIter& current, const OutIter& begin,const OutIter& end, PyObject *seq = 0)
  {
    return new SwigPyIteratorClosed_T<OutIter>(current, begin, end, seq);
  }

  template<typename OutIter>
  inline SwigPyIterator*
  make_output_iterator(const OutIter& current, PyObject *seq = 0)
  {
    return new SwigPyIteratorOpen_T<OutIter>(current, seq);
  }

}


namespace swig
{
  template <class T>
  struct SwigPySequence_Ref
  {
    SwigPySequence_Ref(PyObject* seq, Py_ssize_t index)
      : _seq(seq), _index(index)
    {
    }
    
    operator T () const
    {
      swig::SwigVar_PyObject item = PySequence_GetItem(_seq, _index);
      try {
	return swig::as<T>(item, true);
      } catch (std::exception& e) {
	char msg[1024];
	sprintf(msg, "in sequence element %d ", (int)_index);
	if (!PyErr_Occurred()) {
	  ::SWIG_Error(SWIG_TypeError,  swig::type_name<T>());
	}
	SWIG_Python_AddErrorMsg(msg);
	SWIG_Python_AddErrorMsg(e.what());
	throw;
      }
    }

    SwigPySequence_Ref& operator=(const T& v)
    {
      PySequence_SetItem(_seq, _index, swig::from<T>(v));
      return *this;
    }

  private:
    PyObject* _seq;
    Py_ssize_t _index;
  };

  template <class T>
  struct SwigPySequence_ArrowProxy
  {
    SwigPySequence_ArrowProxy(const T& x): m_value(x) {}
    const T* operator->() const { return &m_value; }
    operator const T*() const { return &m_value; }
    T m_value;
  };

  template <class T, class Reference >
  struct SwigPySequence_InputIterator
  {
    typedef SwigPySequence_InputIterator<T, Reference > self;

    typedef std::random_access_iterator_tag iterator_category;
    typedef Reference reference;
    typedef T value_type;
    typedef T* pointer;
    typedef Py_ssize_t difference_type;

    SwigPySequence_InputIterator()
    {
    }

    SwigPySequence_InputIterator(PyObject* seq, Py_ssize_t index)
      : _seq(seq), _index(index)
    {
    }

    reference operator*() const
    {
      return reference(_seq, _index);
    }

    SwigPySequence_ArrowProxy<T>
    operator->() const {
      return SwigPySequence_ArrowProxy<T>(operator*());
    }

    bool operator==(const self& ri) const
    {
      return (_index == ri._index) && (_seq == ri._seq);
    }

    bool operator!=(const self& ri) const
    {
      return !(operator==(ri));
    }

    self& operator ++ ()
    {
      ++_index;
      return *this;
    }

    self& operator -- ()
    {
      --_index;
      return *this;
    }

    self& operator += (difference_type n)
    {
      _index += n;
      return *this;
    }

    self operator +(difference_type n) const
    {
      return self(_seq, _index + n);
    }

    self& operator -= (difference_type n)
    {
      _index -= n;
      return *this;
    }

    self operator -(difference_type n) const
    {
      return self(_seq, _index - n);
    }

    difference_type operator - (const self& ri) const
    {
      return _index - ri._index;
    }

    bool operator < (const self& ri) const
    {
      return _index < ri._index;
    }

    reference
    operator[](difference_type n) const
    {
      return reference(_seq, _index + n);
    }

  private:
    PyObject* _seq;
    difference_type _index;
  };

  // STL container wrapper around a Python sequence
  template <class T>
  struct SwigPySequence_Cont
  {
    typedef SwigPySequence_Ref<T> reference;
    typedef const SwigPySequence_Ref<T> const_reference;
    typedef T value_type;
    typedef T* pointer;
    typedef Py_ssize_t difference_type;
    typedef size_t size_type;
    typedef const pointer const_pointer;
    typedef SwigPySequence_InputIterator<T, reference> iterator;
    typedef SwigPySequence_InputIterator<T, const_reference> const_iterator;

    SwigPySequence_Cont(PyObject* seq) : _seq(0)
    {
      if (!PySequence_Check(seq)) {
	throw std::invalid_argument("a sequence is expected");
      }
      _seq = seq;
      Py_INCREF(_seq);
    }

    ~SwigPySequence_Cont()
    {
      Py_XDECREF(_seq);
    }

    size_type size() const
    {
      return static_cast<size_type>(PySequence_Size(_seq));
    }

    bool empty() const
    {
      return size() == 0;
    }

    iterator begin()
    {
      return iterator(_seq, 0);
    }

    const_iterator begin() const
    {
      return const_iterator(_seq, 0);
    }

    iterator end()
    {
      return iterator(_seq, size());
    }

    const_iterator end() const
    {
      return const_iterator(_seq, size());
    }

    reference operator[](difference_type n)
    {
      return reference(_seq, n);
    }

    const_reference operator[](difference_type n)  const
    {
      return const_reference(_seq, n);
    }

    bool check(bool set_err = true) const
    {
      Py_ssize_t s = size();
      for (Py_ssize_t i = 0; i < s; ++i) {
	swig::SwigVar_PyObject item = PySequence_GetItem(_seq, i);
	if (!swig::check<value_type>(item)) {
	  if (set_err) {
	    char msg[1024];
	    sprintf(msg, "in sequence element %d", (int)i);
	    SWIG_Error(SWIG_RuntimeError, msg);
	  }
	  return false;
	}
      }
      return true;
    }

  private:
    PyObject* _seq;
  };

}


namespace swig {
  template <class SwigPySeq, class Seq>
  inline void
  assign(const SwigPySeq& swigpyseq, Seq* seq) {
    // seq->assign(swigpyseq.begin(), swigpyseq.end()); // not used as not always implemented
    typedef typename SwigPySeq::value_type value_type;
    typename SwigPySeq::const_iterator it = swigpyseq.begin();
    for (;it != swigpyseq.end(); ++it) {
      seq->insert(seq->end(),(value_type)(*it));
    }
  }

  template <class Seq, class T = typename Seq::value_type >
  struct traits_asptr_stdseq {
    typedef Seq sequence;
    typedef T value_type;

    static int asptr(PyObject *obj, sequence **seq) {
      if (obj == Py_None || SWIG_Python_GetSwigThis(obj)) {
	sequence *p;
	if (::SWIG_ConvertPtr(obj,(void**)&p,
			      swig::type_info<sequence>(),0) == SWIG_OK) {
	  if (seq) *seq = p;
	  return SWIG_OLDOBJ;
	}
      } else if (PySequence_Check(obj)) {
	try {
	  SwigPySequence_Cont<value_type> swigpyseq(obj);
	  if (seq) {
	    sequence *pseq = new sequence();
	    assign(swigpyseq, pseq);
	    *seq = pseq;
	    return SWIG_NEWOBJ;
	  } else {
	    return swigpyseq.check() ? SWIG_OK : SWIG_ERROR;
	  }
	} catch (std::exception& e) {
	  if (seq) {
	    if (!PyErr_Occurred()) {
	      PyErr_SetString(PyExc_TypeError, e.what());
	    }
	  }
	  return SWIG_ERROR;
	}
      }
      return SWIG_ERROR;
    }
  };

  template <class Seq, class T = typename Seq::value_type >
  struct traits_from_stdseq {
    typedef Seq sequence;
    typedef T value_type;
    typedef typename Seq::size_type size_type;
    typedef typename sequence::const_iterator const_iterator;

    static PyObject *from(const sequence& seq) {
#ifdef SWIG_PYTHON_EXTRA_NATIVE_CONTAINERS
      swig_type_info *desc = swig::type_info<sequence>();
      if (desc && desc->clientdata) {
	return SWIG_NewPointerObj(new sequence(seq), desc, SWIG_POINTER_OWN);
      }
#endif
      size_type size = seq.size();
      if (size <= (size_type)INT_MAX) {
	PyObject *obj = PyTuple_New((Py_ssize_t)size);
	Py_ssize_t i = 0;
	for (const_iterator it = seq.begin(); it != seq.end(); ++it, ++i) {
	  PyTuple_SetItem(obj,i,swig::from<value_type>(*it));
	}
	return obj;
      } else {
	PyErr_SetString(PyExc_OverflowError,"sequence size not valid in python");
	return NULL;
      }
    }
  };
}


  namespace swig {
    template <class ValueType>
    struct from_key_oper 
    {
      typedef const ValueType& argument_type;
      typedef  PyObject *result_type;
      result_type operator()(argument_type v) const
      {
	return swig::from(v.first);
      }
    };

    template <class ValueType>
    struct from_value_oper 
    {
      typedef const ValueType& argument_type;
      typedef  PyObject *result_type;
      result_type operator()(argument_type v) const
      {
	return swig::from(v.second);
      }
    };

    template<class OutIterator, class FromOper, class ValueType = typename OutIterator::value_type>
    struct SwigPyMapIterator_T : SwigPyIteratorClosed_T<OutIterator, ValueType, FromOper>
    {
      SwigPyMapIterator_T(OutIterator curr, OutIterator first, OutIterator last, PyObject *seq)
	: SwigPyIteratorClosed_T<OutIterator,ValueType,FromOper>(curr, first, last, seq)
      {
      }
    };


    template<class OutIterator,
	     class FromOper = from_key_oper<typename OutIterator::value_type> >
    struct SwigPyMapKeyIterator_T : SwigPyMapIterator_T<OutIterator, FromOper>
    {
      SwigPyMapKeyIterator_T(OutIterator curr, OutIterator first, OutIterator last, PyObject *seq)
	: SwigPyMapIterator_T<OutIterator, FromOper>(curr, first, last, seq)
      {
      }
    };

    template<typename OutIter>
    inline SwigPyIterator*
    make_output_key_iterator(const OutIter& current, const OutIter& begin, const OutIter& end, PyObject *seq = 0)
    {
      return new SwigPyMapKeyIterator_T<OutIter>(current, begin, end, seq);
    }

    template<class OutIterator,
	     class FromOper = from_value_oper<typename OutIterator::value_type> >
    struct SwigPyMapValueITerator_T : SwigPyMapIterator_T<OutIterator, FromOper>
    {
      SwigPyMapValueITerator_T(OutIterator curr, OutIterator first, OutIterator last, PyObject *seq)
	: SwigPyMapIterator_T<OutIterator, FromOper>(curr, first, last, seq)
      {
      }
    };
    

    template<typename OutIter>
    inline SwigPyIterator*
    make_output_value_iterator(const OutIter& current, const OutIter& begin, const OutIter& end, PyObject *seq = 0)
    {
      return new SwigPyMapValueITerator_T<OutIter>(current, begin, end, seq);
    }
  }


  namespace swig {
    template <class SwigPySeq, class K, class T, class Compare, class Alloc >
    inline void
    assign(const SwigPySeq& swigpyseq, std::map<K,T,Compare,Alloc > *map) {
      typedef typename std::map<K,T,Compare,Alloc >::value_type value_type;
      typename SwigPySeq::const_iterator it = swigpyseq.begin();
      for (;it != swigpyseq.end(); ++it) {
	map->insert(value_type(it->first, it->second));
      }
    }

    template <class K, class T, class Compare, class Alloc>
    struct traits_asptr<std::map<K,T,Compare,Alloc > >  {
      typedef std::map<K,T,Compare,Alloc > map_type;
      static int asptr(PyObject *obj, map_type **val) {
	int res = SWIG_ERROR;
	SWIG_PYTHON_THREAD_BEGIN_BLOCK;
	if (PyDict_Check(obj)) {
	  SwigVar_PyObject items = PyObject_CallMethod(obj,(char *)"items",NULL);
#if PY_VERSION_HEX >= 0x03000000
          /* In Python 3.x the ".items()" method returns a dict_items object */
          items = PySequence_Fast(items, ".items() didn't return a sequence!");
#endif
	  res = traits_asptr_stdseq<map_type, std::pair<K, T> >::asptr(items, val);
	} else {
	  map_type *p;
	  res = SWIG_ConvertPtr(obj,(void**)&p,swig::type_info<map_type>(),0);
	  if (SWIG_IsOK(res) && val)  *val = p;
	}
	SWIG_PYTHON_THREAD_END_BLOCK;
	return res;
      }      
    };
      
    template <class K, class T, class Compare, class Alloc >
    struct traits_from<std::map<K,T,Compare,Alloc > >  {
      typedef std::map<K,T,Compare,Alloc > map_type;
      typedef typename map_type::const_iterator const_iterator;
      typedef typename map_type::size_type size_type;

      static PyObject *asdict(const map_type& map) {
	SWIG_PYTHON_THREAD_BEGIN_BLOCK;
	size_type size = map.size();
	Py_ssize_t pysize = (size <= (size_type) INT_MAX) ? (Py_ssize_t) size : -1;
	if (pysize < 0) {
	  PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	  SWIG_PYTHON_THREAD_END_BLOCK;
	  return NULL;
	}
	PyObject *obj = PyDict_New();
	for (const_iterator i= map.begin(); i!= map.end(); ++i) {
	  swig::SwigVar_PyObject key = swig::from(i->first);
	  swig::SwigVar_PyObject val = swig::from(i->second);
	  PyDict_SetItem(obj, key, val);
	}
	SWIG_PYTHON_THREAD_END_BLOCK;
	return obj;
      }
                
      static PyObject *from(const map_type& map) {
	swig_type_info *desc = swig::type_info<map_type>();
	if (desc && desc->clientdata) {
	  return SWIG_InternalNewPointerObj(new map_type(map), desc, SWIG_POINTER_OWN);
	} else {
	  return asdict(map);
	}
      }
    };
  }


      namespace swig {
	template <>  struct traits<std::map< int, int, std::less< int >, std::allocator< std::pair< int const,int > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "int" "," "int" "," "std::less< int >" "," "std::allocator< std::pair< int const,int > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_int_Sc_int_Sg__iterator(std::map< int,int > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_int_Sc_int_Sg____nonzero__(std::map< int,int > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_int_Sc_int_Sg____bool__(std::map< int,int > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< int,int >::size_type std_map_Sl_int_Sc_int_Sg____len__(std::map< int,int > const *self){
      return self->size();
    }
SWIGINTERN std::map< int,int >::mapped_type const &std_map_Sl_int_Sc_int_Sg____getitem__(std::map< int,int > *self,std::map< int,int >::key_type const &key){
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_int_Sc_int_Sg____delitem__(std::map< int,int > *self,std::map< int,int >::key_type const &key){
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_int_Sc_int_Sg__has_key(std::map< int,int > const *self,std::map< int,int >::key_type const &key){
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_int_Sc_int_Sg__keys(std::map< int,int > *self){
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_int_Sc_int_Sg__values(std::map< int,int > *self){
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_int_Sc_int_Sg__items(std::map< int,int > *self){
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_int_Sc_int_Sg____contains__(std::map< int,int > *self,std::map< int,int >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_int_Sc_int_Sg__key_iterator(std::map< int,int > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_int_Sc_int_Sg__value_iterator(std::map< int,int > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_int_Sc_int_Sg____setitem____SWIG_0(std::map< int,int > *self,std::map< int,int >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_int_Sc_int_Sg____setitem____SWIG_1(std::map< int,int > *self,std::map< int,int >::key_type const &key,std::map< int,int >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_int_Sc_int_Sg__asdict(std::map< int,int > *self){
      return swig::traits_from< std::map< int,int,std::less< int >,std::allocator< std::pair< int const,int > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_int_Sc_int_Sg__erase__SWIG_1(std::map< int,int > *self,std::map< int,int >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_int_Sc_int_Sg__erase__SWIG_2(std::map< int,int > *self,std::map< int,int >::iterator first,std::map< int,int >::iterator last){ self->erase(first, last); }

SWIGINTERN int
SWIG_AsPtr_std_string (PyObject * obj, std::string **val) 
{
  char* buf = 0 ; size_t size = 0; int alloc = SWIG_OLDOBJ;
  if (SWIG_IsOK((SWIG_AsCharPtrAndSize(obj, &buf, &size, &alloc)))) {
    if (buf) {
      if (val) *val = new std::string(buf, size - 1);
      if (alloc == SWIG_NEWOBJ) delete[] buf;
      return SWIG_NEWOBJ;
    } else {
      if (val) *val = 0;
      return SWIG_OLDOBJ;
    }
  } else {
    static int init = 0;
    static swig_type_info* descriptor = 0;
    if (!init) {
      descriptor = SWIG_TypeQuery("std::string" " *");
      init = 1;
    }
    if (descriptor) {
      std::string *vptr;
      int res = SWIG_ConvertPtr(obj, (void**)&vptr, descriptor, 0);
      if (SWIG_IsOK(res) && val) *val = vptr;
      return res;
    }
  }
  return SWIG_ERROR;
}


SWIGINTERN int
SWIG_AsVal_std_string (PyObject * obj, std::string *val)
{
  std::string* v = (std::string *) 0;
  int res = SWIG_AsPtr_std_string (obj, &v);
  if (!SWIG_IsOK(res)) return res;
  if (v) {
    if (val) *val = *v;
    if (SWIG_IsNewObj(res)) {
      delete v;
      res = SWIG_DelNewMask(res);
    }
    return res;
  }
  return SWIG_ERROR;
}


SWIGINTERNINLINE PyObject *
SWIG_From_std_string  (const std::string& s)
{
  return SWIG_FromCharPtrAndSize(s.data(), s.size());
}


namespace swig {
  template <> struct traits< std::string > {
    typedef value_category category;
    static const char* type_name() { return"std::string"; }
  };
  template <>  struct traits_asval< std::string > {
    typedef std::string value_type;
    static int asval(PyObject *obj, value_type *val) {
      return SWIG_AsVal_std_string (obj, val);
    }
  };
  template <>  struct traits_from< std::string > {
    typedef std::string value_type;
    static PyObject *from(const value_type& val) {
      return SWIG_From_std_string  (val);
    }
  };
}


      namespace swig {
	template <>  struct traits<std::pair< std::string, std::string > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "std::string" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, std::string, std::less< std::string >, std::allocator< std::pair< std::string const,std::string > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "std::string" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,std::string > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_std_string_Sg__iterator(std::map< std::string,std::string > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_std_string_Sg____nonzero__(std::map< std::string,std::string > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_std_string_Sg____bool__(std::map< std::string,std::string > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,std::string >::size_type std_map_Sl_std_string_Sc_std_string_Sg____len__(std::map< std::string,std::string > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,std::string >::mapped_type const &std_map_Sl_std_string_Sc_std_string_Sg____getitem__(std::map< std::string,std::string > *self,std::map< std::string,std::string >::key_type const &key){
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg____delitem__(std::map< std::string,std::string > *self,std::map< std::string,std::string >::key_type const &key){
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_std_string_Sg__has_key(std::map< std::string,std::string > const *self,std::map< std::string,std::string >::key_type const &key){
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_std_string_Sg__keys(std::map< std::string,std::string > *self){
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_std_string_Sg__values(std::map< std::string,std::string > *self){
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_std_string_Sg__items(std::map< std::string,std::string > *self){
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_std_string_Sg____contains__(std::map< std::string,std::string > *self,std::map< std::string,std::string >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_std_string_Sg__key_iterator(std::map< std::string,std::string > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_std_string_Sg__value_iterator(std::map< std::string,std::string > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg____setitem____SWIG_0(std::map< std::string,std::string > *self,std::map< std::string,std::string >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg____setitem____SWIG_1(std::map< std::string,std::string > *self,std::map< std::string,std::string >::key_type const &key,std::map< std::string,std::string >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_std_string_Sg__asdict(std::map< std::string,std::string > *self){
      return swig::traits_from< std::map< std::string,std::string,std::less< std::string >,std::allocator< std::pair< std::string const,std::string > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg__erase__SWIG_1(std::map< std::string,std::string > *self,std::map< std::string,std::string >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg__erase__SWIG_2(std::map< std::string,std::string > *self,std::map< std::string,std::string >::iterator first,std::map< std::string,std::string >::iterator last){ self->erase(first, last); }

  #define SWIG_From_double   PyFloat_FromDouble 


namespace swig {
  template <> struct traits< double > {
    typedef value_category category;
    static const char* type_name() { return"double"; }
  };
  template <>  struct traits_asval< double > {
    typedef double value_type;
    static int asval(PyObject *obj, value_type *val) {
      return SWIG_AsVal_double (obj, val);
    }
  };
  template <>  struct traits_from< double > {
    typedef double value_type;
    static PyObject *from(const value_type& val) {
      return SWIG_From_double  (val);
    }
  };
}


      namespace swig {
	template <>  struct traits<std::pair< double, std::pair< int,int > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "double" "," "std::pair< int,int >" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< double, std::pair< int,int >, std::less< double >, std::allocator< std::pair< double const,std::pair< int,int > > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "double" "," "std::pair< int,int >" "," "std::less< double >" "," "std::allocator< std::pair< double const,std::pair< int,int > > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__iterator(std::map< double,std::pair< int,int > > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____nonzero__(std::map< double,std::pair< int,int > > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____bool__(std::map< double,std::pair< int,int > > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< double,std::pair< int,int > >::size_type std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____len__(std::map< double,std::pair< int,int > > const *self){
      return self->size();
    }
SWIGINTERN std::map< double,std::pair< int,int > >::mapped_type const &std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____getitem__(std::map< double,std::pair< int,int > > *self,std::map< double,std::pair< int,int > >::key_type const &key){
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____delitem__(std::map< double,std::pair< int,int > > *self,std::map< double,std::pair< int,int > >::key_type const &key){
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__has_key(std::map< double,std::pair< int,int > > const *self,std::map< double,std::pair< int,int > >::key_type const &key){
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__keys(std::map< double,std::pair< int,int > > *self){
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__values(std::map< double,std::pair< int,int > > *self){
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__items(std::map< double,std::pair< int,int > > *self){
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____contains__(std::map< double,std::pair< int,int > > *self,std::map< double,std::pair< int,int > >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__key_iterator(std::map< double,std::pair< int,int > > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__value_iterator(std::map< double,std::pair< int,int > > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____setitem____SWIG_0(std::map< double,std::pair< int,int > > *self,std::map< double,std::pair< int,int > >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg____setitem____SWIG_1(std::map< double,std::pair< int,int > > *self,std::map< double,std::pair< int,int > >::key_type const &key,std::map< double,std::pair< int,int > >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__asdict(std::map< double,std::pair< int,int > > *self){
      return swig::traits_from< std::map< double,std::pair< int,int >,std::less< double >,std::allocator< std::pair< double const,std::pair< int,int > > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__erase__SWIG_1(std::map< double,std::pair< int,int > > *self,std::map< double,std::pair< int,int > >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_double_Sc_std_pair_Sl_int_Sc_int_Sg__Sg__erase__SWIG_2(std::map< double,std::pair< int,int > > *self,std::map< double,std::pair< int,int > >::iterator first,std::map< double,std::pair< int,int > >::iterator last){ self->erase(first, last); }

namespace swig {
  template <> struct traits< bool > {
    typedef value_category category;
    static const char* type_name() { return"bool"; }
  };
  template <>  struct traits_asval< bool > {
    typedef bool value_type;
    static int asval(PyObject *obj, value_type *val) {
      return SWIG_AsVal_bool (obj, val);
    }
  };
  template <>  struct traits_from< bool > {
    typedef bool value_type;
    static PyObject *from(const value_type& val) {
      return SWIG_From_bool  (val);
    }
  };
}


  namespace swig {
    template <class T>
    struct traits_asptr<std::vector<T> >  {
      static int asptr(PyObject *obj, std::vector<T> **vec) {
	return traits_asptr_stdseq<std::vector<T> >::asptr(obj, vec);
      }
    };
    
    template <class T>
    struct traits_from<std::vector<T> > {
      static PyObject *from(const std::vector<T>& vec) {
	return traits_from_stdseq<std::vector<T> >::from(vec);
      }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector<bool, std::allocator< bool > > > {
	  typedef value_category category;
	  static const char* type_name() {
	    return "std::vector<bool, std::allocator< bool > >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_bool_Sg__iterator(std::vector< bool > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_bool_Sg____nonzero__(std::vector< bool > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_bool_Sg____bool__(std::vector< bool > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< bool >::size_type std_vector_Sl_bool_Sg____len__(std::vector< bool > const *self){
      return self->size();
    }
SWIGINTERN std::vector< bool,std::allocator< bool > > *std_vector_Sl_bool_Sg____getslice__(std::vector< bool > *self,std::vector< bool >::difference_type i,std::vector< bool >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_bool_Sg____setslice____SWIG_0(std::vector< bool > *self,std::vector< bool >::difference_type i,std::vector< bool >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector<bool,std::allocator< bool > >());
    }
SWIGINTERN void std_vector_Sl_bool_Sg____setslice____SWIG_1(std::vector< bool > *self,std::vector< bool >::difference_type i,std::vector< bool >::difference_type j,std::vector< bool,std::allocator< bool > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_bool_Sg____delslice__(std::vector< bool > *self,std::vector< bool >::difference_type i,std::vector< bool >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_bool_Sg____delitem____SWIG_0(std::vector< bool > *self,std::vector< bool >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< bool,std::allocator< bool > > *std_vector_Sl_bool_Sg____getitem____SWIG_0(std::vector< bool > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector<bool,std::allocator< bool > >::difference_type id = i;
      std::vector<bool,std::allocator< bool > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_bool_Sg____setitem____SWIG_0(std::vector< bool > *self,PySliceObject *slice,std::vector< bool,std::allocator< bool > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector<bool,std::allocator< bool > >::difference_type id = i;
      std::vector<bool,std::allocator< bool > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_bool_Sg____setitem____SWIG_1(std::vector< bool > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector<bool,std::allocator< bool > >::difference_type id = i;
      std::vector<bool,std::allocator< bool > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_bool_Sg____delitem____SWIG_1(std::vector< bool > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector<bool,std::allocator< bool > >::difference_type id = i;
      std::vector<bool,std::allocator< bool > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< bool >::value_type std_vector_Sl_bool_Sg____getitem____SWIG_1(std::vector< bool > *self,std::vector< bool >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_bool_Sg____setitem____SWIG_2(std::vector< bool > *self,std::vector< bool >::difference_type i,std::vector< bool >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< bool >::value_type std_vector_Sl_bool_Sg__pop(std::vector< bool > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector<bool,std::allocator< bool > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_bool_Sg__append(std::vector< bool > *self,std::vector< bool >::value_type x){
      self->push_back(x);
    }
SWIGINTERN std::vector< bool >::iterator std_vector_Sl_bool_Sg__erase__SWIG_0(std::vector< bool > *self,std::vector< bool >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< bool >::iterator std_vector_Sl_bool_Sg__erase__SWIG_1(std::vector< bool > *self,std::vector< bool >::iterator first,std::vector< bool >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< bool >::iterator std_vector_Sl_bool_Sg__insert__SWIG_0(std::vector< bool > *self,std::vector< bool >::iterator pos,std::vector< bool >::value_type x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_bool_Sg__insert__SWIG_1(std::vector< bool > *self,std::vector< bool >::iterator pos,std::vector< bool >::size_type n,std::vector< bool >::value_type x){ self->insert(pos, n, x); }

SWIGINTERN int
SWIG_AsVal_std_complex_Sl_double_Sg_  (PyObject *o, std::complex<double>* val)
{
  if (PyComplex_Check(o)) {
    if (val) *val = std::complex<double>(PyComplex_RealAsDouble(o), PyComplex_ImagAsDouble(o));
    return SWIG_OK;
  } else {
    double d;    
    int res = SWIG_AddCast(SWIG_AsVal_double (o, &d));
    if (SWIG_IsOK(res)) {
      if (val) *val = std::complex<double>(d, 0.0);
      return res;
    }
  }
  return SWIG_TypeError;
}


SWIGINTERNINLINE PyObject*
SWIG_From_std_complex_Sl_double_Sg_  (/*@SWIG:/usr/share/swig3.0/typemaps/swigmacros.swg,104,%ifcplusplus@*/

const std::complex<double>&



/*@SWIG@*/ c)
{
  return PyComplex_FromDoubles(std::real(c), std::imag(c));
}


namespace swig {
  template <> struct traits< std::complex<double> > {
    typedef value_category category;
    static const char* type_name() { return"std::complex<double>"; }
  };
  template <>  struct traits_asval< std::complex<double> > {
    typedef std::complex<double> value_type;
    static int asval(PyObject *obj, value_type *val) {
      return SWIG_AsVal_std_complex_Sl_double_Sg_ (obj, val);
    }
  };
  template <>  struct traits_from< std::complex<double> > {
    typedef std::complex<double> value_type;
    static PyObject *from(const value_type& val) {
      return SWIG_From_std_complex_Sl_double_Sg_  (val);
    }
  };
}


      namespace swig {
	template <>  struct traits<std::vector< std::complex< double >, std::allocator< std::complex< double > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "std::complex< double >" "," "std::allocator< std::complex< double > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_std_complex_Sl_double_Sg__Sg__iterator(std::vector< std::complex< double > > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_std_complex_Sl_double_Sg__Sg____nonzero__(std::vector< std::complex< double > > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_std_complex_Sl_double_Sg__Sg____bool__(std::vector< std::complex< double > > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< std::complex< double > >::size_type std_vector_Sl_std_complex_Sl_double_Sg__Sg____len__(std::vector< std::complex< double > > const *self){
      return self->size();
    }
SWIGINTERN std::vector< std::complex< double >,std::allocator< std::complex< double > > > *std_vector_Sl_std_complex_Sl_double_Sg__Sg____getslice__(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::difference_type i,std::vector< std::complex< double > >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____setslice____SWIG_0(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::difference_type i,std::vector< std::complex< double > >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< std::complex< double >,std::allocator< std::complex< double > > >());
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____setslice____SWIG_1(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::difference_type i,std::vector< std::complex< double > >::difference_type j,std::vector< std::complex< double >,std::allocator< std::complex< double > > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____delslice__(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::difference_type i,std::vector< std::complex< double > >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____delitem____SWIG_0(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< std::complex< double >,std::allocator< std::complex< double > > > *std_vector_Sl_std_complex_Sl_double_Sg__Sg____getitem____SWIG_0(std::vector< std::complex< double > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type id = i;
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____setitem____SWIG_0(std::vector< std::complex< double > > *self,PySliceObject *slice,std::vector< std::complex< double >,std::allocator< std::complex< double > > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type id = i;
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____setitem____SWIG_1(std::vector< std::complex< double > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type id = i;
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____delitem____SWIG_1(std::vector< std::complex< double > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type id = i;
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< std::complex< double > >::value_type const &std_vector_Sl_std_complex_Sl_double_Sg__Sg____getitem____SWIG_1(std::vector< std::complex< double > > const *self,std::vector< std::complex< double > >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg____setitem____SWIG_2(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::difference_type i,std::vector< std::complex< double > >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< std::complex< double > >::value_type std_vector_Sl_std_complex_Sl_double_Sg__Sg__pop(std::vector< std::complex< double > > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< std::complex< double >,std::allocator< std::complex< double > > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg__append(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< std::complex< double > >::iterator std_vector_Sl_std_complex_Sl_double_Sg__Sg__erase__SWIG_0(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< std::complex< double > >::iterator std_vector_Sl_std_complex_Sl_double_Sg__Sg__erase__SWIG_1(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::iterator first,std::vector< std::complex< double > >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< std::complex< double > >::iterator std_vector_Sl_std_complex_Sl_double_Sg__Sg__insert__SWIG_0(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::iterator pos,std::vector< std::complex< double > >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_std_complex_Sl_double_Sg__Sg__insert__SWIG_1(std::vector< std::complex< double > > *self,std::vector< std::complex< double > >::iterator pos,std::vector< std::complex< double > >::size_type n,std::vector< std::complex< double > >::value_type const &x){ self->insert(pos, n, x); }

      namespace swig {
	template <>  struct traits<std::vector< double, std::allocator< double > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "double" "," "std::allocator< double >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_double_Sg__iterator(std::vector< double > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_double_Sg____nonzero__(std::vector< double > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_double_Sg____bool__(std::vector< double > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< double >::size_type std_vector_Sl_double_Sg____len__(std::vector< double > const *self){
      return self->size();
    }
SWIGINTERN std::vector< double,std::allocator< double > > *std_vector_Sl_double_Sg____getslice__(std::vector< double > *self,std::vector< double >::difference_type i,std::vector< double >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_double_Sg____setslice____SWIG_0(std::vector< double > *self,std::vector< double >::difference_type i,std::vector< double >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< double,std::allocator< double > >());
    }
SWIGINTERN void std_vector_Sl_double_Sg____setslice____SWIG_1(std::vector< double > *self,std::vector< double >::difference_type i,std::vector< double >::difference_type j,std::vector< double,std::allocator< double > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_double_Sg____delslice__(std::vector< double > *self,std::vector< double >::difference_type i,std::vector< double >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_double_Sg____delitem____SWIG_0(std::vector< double > *self,std::vector< double >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< double,std::allocator< double > > *std_vector_Sl_double_Sg____getitem____SWIG_0(std::vector< double > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< double,std::allocator< double > >::difference_type id = i;
      std::vector< double,std::allocator< double > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_double_Sg____setitem____SWIG_0(std::vector< double > *self,PySliceObject *slice,std::vector< double,std::allocator< double > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< double,std::allocator< double > >::difference_type id = i;
      std::vector< double,std::allocator< double > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_double_Sg____setitem____SWIG_1(std::vector< double > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< double,std::allocator< double > >::difference_type id = i;
      std::vector< double,std::allocator< double > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_double_Sg____delitem____SWIG_1(std::vector< double > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< double,std::allocator< double > >::difference_type id = i;
      std::vector< double,std::allocator< double > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< double >::value_type const &std_vector_Sl_double_Sg____getitem____SWIG_1(std::vector< double > const *self,std::vector< double >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_double_Sg____setitem____SWIG_2(std::vector< double > *self,std::vector< double >::difference_type i,std::vector< double >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< double >::value_type std_vector_Sl_double_Sg__pop(std::vector< double > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< double,std::allocator< double > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_double_Sg__append(std::vector< double > *self,std::vector< double >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< double >::iterator std_vector_Sl_double_Sg__erase__SWIG_0(std::vector< double > *self,std::vector< double >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< double >::iterator std_vector_Sl_double_Sg__erase__SWIG_1(std::vector< double > *self,std::vector< double >::iterator first,std::vector< double >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< double >::iterator std_vector_Sl_double_Sg__insert__SWIG_0(std::vector< double > *self,std::vector< double >::iterator pos,std::vector< double >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_double_Sg__insert__SWIG_1(std::vector< double > *self,std::vector< double >::iterator pos,std::vector< double >::size_type n,std::vector< double >::value_type const &x){ self->insert(pos, n, x); }

      namespace swig {
	template <>  struct traits<std::vector< int, std::allocator< int > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "int" "," "std::allocator< int >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_int_Sg__iterator(std::vector< int > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_int_Sg____nonzero__(std::vector< int > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_int_Sg____bool__(std::vector< int > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< int >::size_type std_vector_Sl_int_Sg____len__(std::vector< int > const *self){
      return self->size();
    }
SWIGINTERN std::vector< int,std::allocator< int > > *std_vector_Sl_int_Sg____getslice__(std::vector< int > *self,std::vector< int >::difference_type i,std::vector< int >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_int_Sg____setslice____SWIG_0(std::vector< int > *self,std::vector< int >::difference_type i,std::vector< int >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< int,std::allocator< int > >());
    }
SWIGINTERN void std_vector_Sl_int_Sg____setslice____SWIG_1(std::vector< int > *self,std::vector< int >::difference_type i,std::vector< int >::difference_type j,std::vector< int,std::allocator< int > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_int_Sg____delslice__(std::vector< int > *self,std::vector< int >::difference_type i,std::vector< int >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_int_Sg____delitem____SWIG_0(std::vector< int > *self,std::vector< int >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< int,std::allocator< int > > *std_vector_Sl_int_Sg____getitem____SWIG_0(std::vector< int > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< int,std::allocator< int > >::difference_type id = i;
      std::vector< int,std::allocator< int > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_int_Sg____setitem____SWIG_0(std::vector< int > *self,PySliceObject *slice,std::vector< int,std::allocator< int > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< int,std::allocator< int > >::difference_type id = i;
      std::vector< int,std::allocator< int > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_int_Sg____setitem____SWIG_1(std::vector< int > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< int,std::allocator< int > >::difference_type id = i;
      std::vector< int,std::allocator< int > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_int_Sg____delitem____SWIG_1(std::vector< int > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< int,std::allocator< int > >::difference_type id = i;
      std::vector< int,std::allocator< int > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< int >::value_type const &std_vector_Sl_int_Sg____getitem____SWIG_1(std::vector< int > const *self,std::vector< int >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_int_Sg____setitem____SWIG_2(std::vector< int > *self,std::vector< int >::difference_type i,std::vector< int >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int_Sg__pop(std::vector< int > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< int,std::allocator< int > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_int_Sg__append(std::vector< int > *self,std::vector< int >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< int >::iterator std_vector_Sl_int_Sg__erase__SWIG_0(std::vector< int > *self,std::vector< int >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< int >::iterator std_vector_Sl_int_Sg__erase__SWIG_1(std::vector< int > *self,std::vector< int >::iterator first,std::vector< int >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< int >::iterator std_vector_Sl_int_Sg__insert__SWIG_0(std::vector< int > *self,std::vector< int >::iterator pos,std::vector< int >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_int_Sg__insert__SWIG_1(std::vector< int > *self,std::vector< int >::iterator pos,std::vector< int >::size_type n,std::vector< int >::value_type const &x){ self->insert(pos, n, x); }

      namespace swig {
	template <>  struct traits<std::vector< std::string, std::allocator< std::string > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "std::string" "," "std::allocator< std::string >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_std_string_Sg__iterator(std::vector< std::string > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_std_string_Sg____nonzero__(std::vector< std::string > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_std_string_Sg____bool__(std::vector< std::string > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< std::string >::size_type std_vector_Sl_std_string_Sg____len__(std::vector< std::string > const *self){
      return self->size();
    }
SWIGINTERN std::vector< std::string,std::allocator< std::string > > *std_vector_Sl_std_string_Sg____getslice__(std::vector< std::string > *self,std::vector< std::string >::difference_type i,std::vector< std::string >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____setslice____SWIG_0(std::vector< std::string > *self,std::vector< std::string >::difference_type i,std::vector< std::string >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< std::string,std::allocator< std::string > >());
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____setslice____SWIG_1(std::vector< std::string > *self,std::vector< std::string >::difference_type i,std::vector< std::string >::difference_type j,std::vector< std::string,std::allocator< std::string > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____delslice__(std::vector< std::string > *self,std::vector< std::string >::difference_type i,std::vector< std::string >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____delitem____SWIG_0(std::vector< std::string > *self,std::vector< std::string >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< std::string,std::allocator< std::string > > *std_vector_Sl_std_string_Sg____getitem____SWIG_0(std::vector< std::string > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::string,std::allocator< std::string > >::difference_type id = i;
      std::vector< std::string,std::allocator< std::string > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____setitem____SWIG_0(std::vector< std::string > *self,PySliceObject *slice,std::vector< std::string,std::allocator< std::string > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::string,std::allocator< std::string > >::difference_type id = i;
      std::vector< std::string,std::allocator< std::string > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____setitem____SWIG_1(std::vector< std::string > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::string,std::allocator< std::string > >::difference_type id = i;
      std::vector< std::string,std::allocator< std::string > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____delitem____SWIG_1(std::vector< std::string > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::string,std::allocator< std::string > >::difference_type id = i;
      std::vector< std::string,std::allocator< std::string > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< std::string >::value_type const &std_vector_Sl_std_string_Sg____getitem____SWIG_1(std::vector< std::string > const *self,std::vector< std::string >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_std_string_Sg____setitem____SWIG_2(std::vector< std::string > *self,std::vector< std::string >::difference_type i,std::vector< std::string >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__pop(std::vector< std::string > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< std::string,std::allocator< std::string > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_std_string_Sg__append(std::vector< std::string > *self,std::vector< std::string >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< std::string >::iterator std_vector_Sl_std_string_Sg__erase__SWIG_0(std::vector< std::string > *self,std::vector< std::string >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< std::string >::iterator std_vector_Sl_std_string_Sg__erase__SWIG_1(std::vector< std::string > *self,std::vector< std::string >::iterator first,std::vector< std::string >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< std::string >::iterator std_vector_Sl_std_string_Sg__insert__SWIG_0(std::vector< std::string > *self,std::vector< std::string >::iterator pos,std::vector< std::string >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_std_string_Sg__insert__SWIG_1(std::vector< std::string > *self,std::vector< std::string >::iterator pos,std::vector< std::string >::size_type n,std::vector< std::string >::value_type const &x){ self->insert(pos, n, x); }

      namespace swig {
	template <>  struct traits<std::vector< std::pair< int,int >, std::allocator< std::pair< int,int > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "std::pair< int,int >" "," "std::allocator< std::pair< int,int > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg__iterator(std::vector< std::pair< int,int > > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____nonzero__(std::vector< std::pair< int,int > > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____bool__(std::vector< std::pair< int,int > > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< std::pair< int,int > >::size_type std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____len__(std::vector< std::pair< int,int > > const *self){
      return self->size();
    }
SWIGINTERN std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > *std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____getslice__(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::difference_type i,std::vector< std::pair< int,int > >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____setslice____SWIG_0(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::difference_type i,std::vector< std::pair< int,int > >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >());
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____setslice____SWIG_1(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::difference_type i,std::vector< std::pair< int,int > >::difference_type j,std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____delslice__(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::difference_type i,std::vector< std::pair< int,int > >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____delitem____SWIG_0(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > *std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____getitem____SWIG_0(std::vector< std::pair< int,int > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type id = i;
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____setitem____SWIG_0(std::vector< std::pair< int,int > > *self,PySliceObject *slice,std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type id = i;
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____setitem____SWIG_1(std::vector< std::pair< int,int > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type id = i;
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____delitem____SWIG_1(std::vector< std::pair< int,int > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type id = i;
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< std::pair< int,int > >::value_type const &std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____getitem____SWIG_1(std::vector< std::pair< int,int > > const *self,std::vector< std::pair< int,int > >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg____setitem____SWIG_2(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::difference_type i,std::vector< std::pair< int,int > >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< std::pair< int,int > >::value_type std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg__pop(std::vector< std::pair< int,int > > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg__append(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< std::pair< int,int > >::iterator std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg__erase__SWIG_0(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< std::pair< int,int > >::iterator std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg__erase__SWIG_1(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::iterator first,std::vector< std::pair< int,int > >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< std::pair< int,int > >::iterator std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg__insert__SWIG_0(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::iterator pos,std::vector< std::pair< int,int > >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_std_pair_Sl_int_Sc_int_Sg__Sg__insert__SWIG_1(std::vector< std::pair< int,int > > *self,std::vector< std::pair< int,int > >::iterator pos,std::vector< std::pair< int,int > >::size_type n,std::vector< std::pair< int,int > >::value_type const &x){ self->insert(pos, n, x); }

      namespace swig {
	template <>  struct traits<std::vector< std::vector< int,std::allocator< int > >, std::allocator< std::vector< int,std::allocator< int > > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "std::vector< int,std::allocator< int > >" "," "std::allocator< std::vector< int,std::allocator< int > > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_std_vector_Sl_int_Sg__Sg__iterator(std::vector< std::vector< int > > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_std_vector_Sl_int_Sg__Sg____nonzero__(std::vector< std::vector< int > > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_std_vector_Sl_int_Sg__Sg____bool__(std::vector< std::vector< int > > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< std::vector< int > >::size_type std_vector_Sl_std_vector_Sl_int_Sg__Sg____len__(std::vector< std::vector< int > > const *self){
      return self->size();
    }
SWIGINTERN std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > *std_vector_Sl_std_vector_Sl_int_Sg__Sg____getslice__(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::difference_type i,std::vector< std::vector< int > >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____setslice____SWIG_0(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::difference_type i,std::vector< std::vector< int > >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >());
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____setslice____SWIG_1(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::difference_type i,std::vector< std::vector< int > >::difference_type j,std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____delslice__(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::difference_type i,std::vector< std::vector< int > >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____delitem____SWIG_0(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > *std_vector_Sl_std_vector_Sl_int_Sg__Sg____getitem____SWIG_0(std::vector< std::vector< int > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type id = i;
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____setitem____SWIG_0(std::vector< std::vector< int > > *self,PySliceObject *slice,std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type id = i;
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____setitem____SWIG_1(std::vector< std::vector< int > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type id = i;
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____delitem____SWIG_1(std::vector< std::vector< int > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type id = i;
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< std::vector< int > >::value_type const &std_vector_Sl_std_vector_Sl_int_Sg__Sg____getitem____SWIG_1(std::vector< std::vector< int > > const *self,std::vector< std::vector< int > >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg____setitem____SWIG_2(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::difference_type i,std::vector< std::vector< int > >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< std::vector< int > >::value_type std_vector_Sl_std_vector_Sl_int_Sg__Sg__pop(std::vector< std::vector< int > > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg__append(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< std::vector< int > >::iterator std_vector_Sl_std_vector_Sl_int_Sg__Sg__erase__SWIG_0(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< std::vector< int > >::iterator std_vector_Sl_std_vector_Sl_int_Sg__Sg__erase__SWIG_1(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::iterator first,std::vector< std::vector< int > >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< std::vector< int > >::iterator std_vector_Sl_std_vector_Sl_int_Sg__Sg__insert__SWIG_0(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::iterator pos,std::vector< std::vector< int > >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg__insert__SWIG_1(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::iterator pos,std::vector< std::vector< int > >::size_type n,std::vector< std::vector< int > >::value_type const &x){ self->insert(pos, n, x); }

      namespace swig {
	template <>  struct traits<std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >, std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "std::vector< std::complex< double >,std::allocator< std::complex< double > > >" "," "std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg__iterator(std::vector< std::vector< std::complex< double > > > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____nonzero__(std::vector< std::vector< std::complex< double > > > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____bool__(std::vector< std::vector< std::complex< double > > > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< std::vector< std::complex< double > > >::size_type std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____len__(std::vector< std::vector< std::complex< double > > > const *self){
      return self->size();
    }
SWIGINTERN std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > > *std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____getslice__(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::difference_type i,std::vector< std::vector< std::complex< double > > >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____setslice____SWIG_0(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::difference_type i,std::vector< std::vector< std::complex< double > > >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >());
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____setslice____SWIG_1(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::difference_type i,std::vector< std::vector< std::complex< double > > >::difference_type j,std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____delslice__(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::difference_type i,std::vector< std::vector< std::complex< double > > >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____delitem____SWIG_0(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > > *std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____getitem____SWIG_0(std::vector< std::vector< std::complex< double > > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type id = i;
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____setitem____SWIG_0(std::vector< std::vector< std::complex< double > > > *self,PySliceObject *slice,std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type id = i;
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____setitem____SWIG_1(std::vector< std::vector< std::complex< double > > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type id = i;
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____delitem____SWIG_1(std::vector< std::vector< std::complex< double > > > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type id = i;
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< std::vector< std::complex< double > > >::value_type const &std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____getitem____SWIG_1(std::vector< std::vector< std::complex< double > > > const *self,std::vector< std::vector< std::complex< double > > >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg____setitem____SWIG_2(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::difference_type i,std::vector< std::vector< std::complex< double > > >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< std::vector< std::complex< double > > >::value_type std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg__pop(std::vector< std::vector< std::complex< double > > > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< std::vector< std::complex< double >,std::allocator< std::complex< double > > >,std::allocator< std::vector< std::complex< double >,std::allocator< std::complex< double > > > > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg__append(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< std::vector< std::complex< double > > >::iterator std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg__erase__SWIG_0(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< std::vector< std::complex< double > > >::iterator std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg__erase__SWIG_1(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::iterator first,std::vector< std::vector< std::complex< double > > >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< std::vector< std::complex< double > > >::iterator std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg__insert__SWIG_0(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::iterator pos,std::vector< std::vector< std::complex< double > > >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_std_vector_Sl_std_complex_Sl_double_Sg__Sg__Sg__insert__SWIG_1(std::vector< std::vector< std::complex< double > > > *self,std::vector< std::vector< std::complex< double > > >::iterator pos,std::vector< std::vector< std::complex< double > > >::size_type n,std::vector< std::vector< std::complex< double > > >::value_type const &x){ self->insert(pos, n, x); }

#include <assert.h>
static int VEC4_ERROR(0), EVENT_ERROR(0), BEAMPARTICLE_ERROR(0),
  COLCONFIG_ERROR(0);


#include "Pythia8/Pythia.h"
using namespace Pythia8;
#include "Pythia8/Analysis.h"
#include "Pythia8/Basics.h"
#include "Pythia8/BeamParticle.h"
#include "Pythia8/BeamRemnants.h"
#include "Pythia8/BeamShape.h"
#include "Pythia8/BoseEinstein.h"
#include "Pythia8/ColourReconnection.h"
#include "Pythia8/ColourTracing.h"
#include "Pythia8/DeuteronProduction.h"
#include "Pythia8/Event.h"
#include "Pythia8/FragmentationFlavZpT.h"
#include "Pythia8/FragmentationSystems.h"
#include "Pythia8/GammaKinematics.h"
#include "Pythia8/HadronLevel.h"
#include "Pythia8/HadronScatter.h"
#include "Pythia8/HardDiffraction.h"
#include "Pythia8/HeavyIons.h"
#include "Pythia8/HelicityBasics.h"
#include "Pythia8/HelicityMatrixElements.h"
#include "Pythia8/HiddenValleyFragmentation.h"
#include "Pythia8/History.h"
#include "Pythia8/HIUserHooks.h"
#include "Pythia8/Info.h"
#include "Pythia8/JunctionSplitting.h"
#include "Pythia8/LesHouches.h"
#include "Pythia8/LHEF3.h"
#include "Pythia8/Merging.h"
#include "Pythia8/MergingHooks.h"
#include "Pythia8/MiniStringFragmentation.h"
#include "Pythia8/MultipartonInteractions.h"
#include "Pythia8/ParticleData.h"
#include "Pythia8/ParticleDecays.h"
#include "Pythia8/PartonDistributions.h"
#include "Pythia8/PartonLevel.h"
#include "Pythia8/PartonSystems.h"
#include "Pythia8/PartonVertex.h"
#include "Pythia8/PhaseSpace.h"
#include "Pythia8Plugins/aMCatNLOHooks.h"
#include "Pythia8Plugins/ColourReconnectionHooks.h"
#include "Pythia8Plugins/CombineMatchingInput.h"
#include "Pythia8Plugins/GeneratorInput.h"
#include "Pythia8Plugins/JetMatching.h"
#include "Pythia8Plugins/LHAHelaconia.h"
#include "Pythia8Plugins/LHAMadgraph.h"
#include "Pythia8Plugins/PowhegHooks.h"
#include "Pythia8Plugins/PowhegProcs.h"
#include "Pythia8Plugins/ProgressLog.h"
#include "Pythia8/ProcessContainer.h"
#include "Pythia8/ProcessLevel.h"
#include "Pythia8/PythiaComplex.h"
#include "Pythia8/Pythia.h"
#include "Pythia8/PythiaStdlib.h"
#include "Pythia8/ResonanceDecays.h"
#include "Pythia8/ResonanceWidthsDM.h"
#include "Pythia8/ResonanceWidths.h"
#include "Pythia8/RHadrons.h"
#include "Pythia8/Ropewalk.h"
#include "Pythia8/Settings.h"
#include "Pythia8/SigmaCompositeness.h"
#include "Pythia8/SigmaDM.h"
#include "Pythia8/SigmaEW.h"
#include "Pythia8/SigmaExtraDim.h"
#include "Pythia8/SigmaGeneric.h"
#include "Pythia8/SigmaHiggs.h"
#include "Pythia8/SigmaLeftRightSym.h"
#include "Pythia8/SigmaLeptoquark.h"
#include "Pythia8/SigmaNewGaugeBosons.h"
#include "Pythia8/SigmaOnia.h"
#include "Pythia8/SigmaProcess.h"
#include "Pythia8/SigmaQCD.h"
#include "Pythia8/SigmaSUSY.h"
#include "Pythia8/SigmaTotal.h"
#include "Pythia8/SimpleSpaceShower.h"
#include "Pythia8/SimpleTimeShower.h"
#include "Pythia8/SimpleWeakShowerMEs.h"
#include "Pythia8/SLHAinterface.h"
#include "Pythia8/SpaceShower.h"
#include "Pythia8/StandardModel.h"
#include "Pythia8/Streams.h"
#include "Pythia8/StringFragmentation.h"
#include "Pythia8/StringLength.h"
#include "Pythia8/SusyCouplings.h"
#include "Pythia8/SusyLesHouches.h"
#include "Pythia8/SusyResonanceWidths.h"
#include "Pythia8/SusyWidthFunctions.h"
#include "Pythia8/TauDecays.h"
#include "Pythia8/TimeShower.h"
#include "Pythia8/UserHooks.h"

SWIGINTERN std::string Pythia8_Vec4___str__(Pythia8::Vec4 *self){
    std::ostringstream oss(std::ostringstream::out); oss << *(self);
    return oss.str();}
SWIGINTERN double Pythia8_Vec4___getitem__(Pythia8::Vec4 *self,int i){
    if (i >= 4) {VEC4_ERROR = 1; return 0;} return (*(self))[i];}
SWIGINTERN Pythia8::Vec4 Pythia8_Vec4___rmul__(Pythia8::Vec4 *self,double f){
    Pythia8::Vec4 v = *self; return f*v;}
SWIGINTERN std::string Pythia8_RotBstMatrix___str__(Pythia8::RotBstMatrix *self){
    std::ostringstream oss(std::ostringstream::out); oss << *(self);
    return oss.str();}
SWIGINTERN std::string Pythia8_Hist___str__(Pythia8::Hist *self){
    std::ostringstream oss(std::ostringstream::out); oss << *(self);
    return oss.str();}
SWIGINTERN Pythia8::Hist Pythia8_Hist___radd__(Pythia8::Hist *self,double f){
    Pythia8::Hist h = *self; return f+h;}
SWIGINTERN Pythia8::Hist Pythia8_Hist___rsub__(Pythia8::Hist *self,double f){
    Pythia8::Hist h = *self; return f-h;}
SWIGINTERN Pythia8::Hist Pythia8_Hist___rmul__(Pythia8::Hist *self,double f){
    Pythia8::Hist h = *self; return f*h;}
SWIGINTERN Pythia8::Hist Pythia8_Hist___rdiv__(Pythia8::Hist *self,double f){
    Pythia8::Hist h = *self; return f/h;}
SWIGINTERN std::string Pythia8_XMLTag___str__(Pythia8::XMLTag *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHAweights___str__(Pythia8::LHAweights *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHAscales___str__(Pythia8::LHAscales *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHAgenerator___str__(Pythia8::LHAgenerator *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHAwgt___str__(Pythia8::LHAwgt *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHAweight___str__(Pythia8::LHAweight *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHAweightgroup___str__(Pythia8::LHAweightgroup *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHArwgt___str__(Pythia8::LHArwgt *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_LHAinitrwgt___str__(Pythia8::LHAinitrwgt *self){
    std::ostringstream oss(std::ostringstream::out); self->list(oss);
    return oss.str();}
SWIGINTERN std::string Pythia8_PartonSystems___str__(Pythia8::PartonSystems *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}

SWIGINTERNINLINE PyObject*
  SWIG_From_unsigned_SS_int  (unsigned int value)
{
  return PyInt_FromSize_t((size_t) value);
}

SWIGINTERN std::string Pythia8_Info___str__(Pythia8::Info *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_ParticleData___str__(Pythia8::ParticleData *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_Event___str__(Pythia8::Event *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN Pythia8::Particle *Pythia8_Event___getitem__(Pythia8::Event *self,int i){
    if (i >= self->size()) {EVENT_ERROR = 1; return 0;}
    return &(*(self))[i];}
SWIGINTERN std::string Pythia8_ColConfig___str__(Pythia8::ColConfig *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN Pythia8::ColSinglet *Pythia8_ColConfig___getitem__(Pythia8::ColConfig *self,int i){
    if (i >= self->size()) {COLCONFIG_ERROR = 1; return 0;}
    return &(*(self))[i];}
SWIGINTERN std::string Pythia8_Wave4___str__(Pythia8::Wave4 *self){
    std::ostringstream oss(std::ostringstream::out); oss << *(self);
    return oss.str();}
SWIGINTERN Pythia8::Wave4 Pythia8_Wave4___rmul____SWIG_0(Pythia8::Wave4 *self,std::complex< double > s){
    Pythia8::Wave4 w = *self; return s*w;}
SWIGINTERN Pythia8::Wave4 Pythia8_Wave4___rmul____SWIG_1(Pythia8::Wave4 *self,double s){
    Pythia8::Wave4 w = *self; return s*w;}
SWIGINTERN Pythia8::Wave4 Pythia8_Wave4___mul____SWIG_3(Pythia8::Wave4 *self,Pythia8::GammaMatrix g){
    Pythia8::Wave4 w = *self; return w*g;}
SWIGINTERN std::string Pythia8_GammaMatrix___str__(Pythia8::GammaMatrix *self){
    std::ostringstream oss(std::ostringstream::out); oss << *(self);
    return oss.str();}
SWIGINTERN Pythia8::GammaMatrix Pythia8_GammaMatrix___rmul__(Pythia8::GammaMatrix *self,std::complex< double > s){
    Pythia8::GammaMatrix g = *self; return s*g;}
SWIGINTERN Pythia8::GammaMatrix Pythia8_GammaMatrix___rsub__(Pythia8::GammaMatrix *self,std::complex< double > s){
    Pythia8::GammaMatrix g = *self; return s-g;}
SWIGINTERN Pythia8::GammaMatrix Pythia8_GammaMatrix___radd__(Pythia8::GammaMatrix *self,std::complex< double > s){
    Pythia8::GammaMatrix g = *self; return s+g;}

SWIGINTERNINLINE PyObject * 
SWIG_FromCharPtr(const char *cptr)
{ 
  return SWIG_FromCharPtrAndSize(cptr, (cptr ? strlen(cptr) : 0));
}


size_t
SWIG_strnlen(const char* s, size_t maxlen)
{
  const char *p;
  for (p = s; maxlen-- && *p; p++)
    ;
  return p - s;
}

SWIGINTERN std::string Pythia8_Sphericity___str__(Pythia8::Sphericity *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_Thrust___str__(Pythia8::Thrust *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_ClusterJet___str__(Pythia8::ClusterJet *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_CellJet___str__(Pythia8::CellJet *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_SlowJet___str__(Pythia8::SlowJet *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_BeamParticle___str__(Pythia8::BeamParticle *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN Pythia8::ResolvedParton *Pythia8_BeamParticle___getitem__(Pythia8::BeamParticle *self,int i){
  if (i >= self->size()) {
    BEAMPARTICLE_ERROR = 1; return 0;} return &(*(self))[i];}
SWIGINTERN std::string Pythia8_HardProcess___str__(Pythia8::HardProcess *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_SpaceShower___str__(Pythia8::SpaceShower *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_TimeShower___str__(Pythia8::TimeShower *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_ColourDipole___str__(Pythia8::ColourDipole *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_ColourJunction___str__(Pythia8::ColourJunction *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}
SWIGINTERN std::string Pythia8_Clustering___str__(Pythia8::Clustering *self){
    std::streambuf* old = cout.rdbuf();
    std::ostringstream oss(std::ostringstream::out);
    cout.rdbuf(oss.rdbuf()); self->list(); cout.rdbuf(old);
    return oss.str();}

  namespace swig {
    template <>  struct traits< Pythia8::Flag > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::Flag"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::pair< std::string, Pythia8::Flag > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "Pythia8::Flag" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, Pythia8::Flag, std::less< std::string >, std::allocator< std::pair< std::string const,Pythia8::Flag > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "Pythia8::Flag" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,Pythia8::Flag > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__iterator(std::map< std::string,Pythia8::Flag > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____nonzero__(std::map< std::string,Pythia8::Flag > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____bool__(std::map< std::string,Pythia8::Flag > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,Pythia8::Flag >::size_type std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____len__(std::map< std::string,Pythia8::Flag > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,Pythia8::Flag >::mapped_type const &std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____getitem__(std::map< std::string,Pythia8::Flag > *self,std::map< std::string,Pythia8::Flag >::key_type const &key){
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____delitem__(std::map< std::string,Pythia8::Flag > *self,std::map< std::string,Pythia8::Flag >::key_type const &key){
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__has_key(std::map< std::string,Pythia8::Flag > const *self,std::map< std::string,Pythia8::Flag >::key_type const &key){
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__keys(std::map< std::string,Pythia8::Flag > *self){
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__values(std::map< std::string,Pythia8::Flag > *self){
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__items(std::map< std::string,Pythia8::Flag > *self){
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____contains__(std::map< std::string,Pythia8::Flag > *self,std::map< std::string,Pythia8::Flag >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__key_iterator(std::map< std::string,Pythia8::Flag > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__value_iterator(std::map< std::string,Pythia8::Flag > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____setitem____SWIG_0(std::map< std::string,Pythia8::Flag > *self,std::map< std::string,Pythia8::Flag >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Flag_Sg____setitem____SWIG_1(std::map< std::string,Pythia8::Flag > *self,std::map< std::string,Pythia8::Flag >::key_type const &key,std::map< std::string,Pythia8::Flag >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__asdict(std::map< std::string,Pythia8::Flag > *self){
      return swig::traits_from< std::map< std::string,Pythia8::Flag,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Flag > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__erase__SWIG_1(std::map< std::string,Pythia8::Flag > *self,std::map< std::string,Pythia8::Flag >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Flag_Sg__erase__SWIG_2(std::map< std::string,Pythia8::Flag > *self,std::map< std::string,Pythia8::Flag >::iterator first,std::map< std::string,Pythia8::Flag >::iterator last){ self->erase(first, last); }

  namespace swig {
    template <>  struct traits< Pythia8::Mode > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::Mode"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::pair< std::string, Pythia8::Mode > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "Pythia8::Mode" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, Pythia8::Mode, std::less< std::string >, std::allocator< std::pair< std::string const,Pythia8::Mode > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "Pythia8::Mode" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,Pythia8::Mode > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__iterator(std::map< std::string,Pythia8::Mode > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____nonzero__(std::map< std::string,Pythia8::Mode > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____bool__(std::map< std::string,Pythia8::Mode > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,Pythia8::Mode >::size_type std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____len__(std::map< std::string,Pythia8::Mode > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,Pythia8::Mode >::mapped_type const &std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____getitem__(std::map< std::string,Pythia8::Mode > *self,std::map< std::string,Pythia8::Mode >::key_type const &key){
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____delitem__(std::map< std::string,Pythia8::Mode > *self,std::map< std::string,Pythia8::Mode >::key_type const &key){
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__has_key(std::map< std::string,Pythia8::Mode > const *self,std::map< std::string,Pythia8::Mode >::key_type const &key){
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__keys(std::map< std::string,Pythia8::Mode > *self){
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__values(std::map< std::string,Pythia8::Mode > *self){
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__items(std::map< std::string,Pythia8::Mode > *self){
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____contains__(std::map< std::string,Pythia8::Mode > *self,std::map< std::string,Pythia8::Mode >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__key_iterator(std::map< std::string,Pythia8::Mode > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__value_iterator(std::map< std::string,Pythia8::Mode > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____setitem____SWIG_0(std::map< std::string,Pythia8::Mode > *self,std::map< std::string,Pythia8::Mode >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Mode_Sg____setitem____SWIG_1(std::map< std::string,Pythia8::Mode > *self,std::map< std::string,Pythia8::Mode >::key_type const &key,std::map< std::string,Pythia8::Mode >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__asdict(std::map< std::string,Pythia8::Mode > *self){
      return swig::traits_from< std::map< std::string,Pythia8::Mode,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Mode > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__erase__SWIG_1(std::map< std::string,Pythia8::Mode > *self,std::map< std::string,Pythia8::Mode >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Mode_Sg__erase__SWIG_2(std::map< std::string,Pythia8::Mode > *self,std::map< std::string,Pythia8::Mode >::iterator first,std::map< std::string,Pythia8::Mode >::iterator last){ self->erase(first, last); }

  namespace swig {
    template <>  struct traits< Pythia8::Parm > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::Parm"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::pair< std::string, Pythia8::Parm > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "Pythia8::Parm" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, Pythia8::Parm, std::less< std::string >, std::allocator< std::pair< std::string const,Pythia8::Parm > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "Pythia8::Parm" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,Pythia8::Parm > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__iterator(std::map< std::string,Pythia8::Parm > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____nonzero__(std::map< std::string,Pythia8::Parm > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____bool__(std::map< std::string,Pythia8::Parm > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,Pythia8::Parm >::size_type std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____len__(std::map< std::string,Pythia8::Parm > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,Pythia8::Parm >::mapped_type const &std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____getitem__(std::map< std::string,Pythia8::Parm > *self,std::map< std::string,Pythia8::Parm >::key_type const &key){
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____delitem__(std::map< std::string,Pythia8::Parm > *self,std::map< std::string,Pythia8::Parm >::key_type const &key){
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__has_key(std::map< std::string,Pythia8::Parm > const *self,std::map< std::string,Pythia8::Parm >::key_type const &key){
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__keys(std::map< std::string,Pythia8::Parm > *self){
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__values(std::map< std::string,Pythia8::Parm > *self){
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__items(std::map< std::string,Pythia8::Parm > *self){
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____contains__(std::map< std::string,Pythia8::Parm > *self,std::map< std::string,Pythia8::Parm >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__key_iterator(std::map< std::string,Pythia8::Parm > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__value_iterator(std::map< std::string,Pythia8::Parm > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____setitem____SWIG_0(std::map< std::string,Pythia8::Parm > *self,std::map< std::string,Pythia8::Parm >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Parm_Sg____setitem____SWIG_1(std::map< std::string,Pythia8::Parm > *self,std::map< std::string,Pythia8::Parm >::key_type const &key,std::map< std::string,Pythia8::Parm >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__asdict(std::map< std::string,Pythia8::Parm > *self){
      return swig::traits_from< std::map< std::string,Pythia8::Parm,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Parm > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__erase__SWIG_1(std::map< std::string,Pythia8::Parm > *self,std::map< std::string,Pythia8::Parm >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Parm_Sg__erase__SWIG_2(std::map< std::string,Pythia8::Parm > *self,std::map< std::string,Pythia8::Parm >::iterator first,std::map< std::string,Pythia8::Parm >::iterator last){ self->erase(first, last); }

  namespace swig {
    template <>  struct traits< Pythia8::Word > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::Word"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::pair< std::string, Pythia8::Word > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "Pythia8::Word" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, Pythia8::Word, std::less< std::string >, std::allocator< std::pair< std::string const,Pythia8::Word > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "Pythia8::Word" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,Pythia8::Word > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Word_Sg__iterator(std::map< std::string,Pythia8::Word > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Word_Sg____nonzero__(std::map< std::string,Pythia8::Word > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Word_Sg____bool__(std::map< std::string,Pythia8::Word > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,Pythia8::Word >::size_type std_map_Sl_std_string_Sc_Pythia8_Word_Sg____len__(std::map< std::string,Pythia8::Word > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,Pythia8::Word >::mapped_type const &std_map_Sl_std_string_Sc_Pythia8_Word_Sg____getitem__(std::map< std::string,Pythia8::Word > *self,std::map< std::string,Pythia8::Word >::key_type const &key){
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Word_Sg____delitem__(std::map< std::string,Pythia8::Word > *self,std::map< std::string,Pythia8::Word >::key_type const &key){
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Word_Sg__has_key(std::map< std::string,Pythia8::Word > const *self,std::map< std::string,Pythia8::Word >::key_type const &key){
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Word_Sg__keys(std::map< std::string,Pythia8::Word > *self){
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Word_Sg__values(std::map< std::string,Pythia8::Word > *self){
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Word_Sg__items(std::map< std::string,Pythia8::Word > *self){
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_Word_Sg____contains__(std::map< std::string,Pythia8::Word > *self,std::map< std::string,Pythia8::Word >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Word_Sg__key_iterator(std::map< std::string,Pythia8::Word > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_Word_Sg__value_iterator(std::map< std::string,Pythia8::Word > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Word_Sg____setitem____SWIG_0(std::map< std::string,Pythia8::Word > *self,std::map< std::string,Pythia8::Word >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Word_Sg____setitem____SWIG_1(std::map< std::string,Pythia8::Word > *self,std::map< std::string,Pythia8::Word >::key_type const &key,std::map< std::string,Pythia8::Word >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_Word_Sg__asdict(std::map< std::string,Pythia8::Word > *self){
      return swig::traits_from< std::map< std::string,Pythia8::Word,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::Word > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Word_Sg__erase__SWIG_1(std::map< std::string,Pythia8::Word > *self,std::map< std::string,Pythia8::Word >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_Word_Sg__erase__SWIG_2(std::map< std::string,Pythia8::Word > *self,std::map< std::string,Pythia8::Word >::iterator first,std::map< std::string,Pythia8::Word >::iterator last){ self->erase(first, last); }

  namespace swig {
    template <>  struct traits< Pythia8::FVec > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::FVec"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::pair< std::string, Pythia8::FVec > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "Pythia8::FVec" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, Pythia8::FVec, std::less< std::string >, std::allocator< std::pair< std::string const,Pythia8::FVec > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "Pythia8::FVec" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,Pythia8::FVec > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__iterator(std::map< std::string,Pythia8::FVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____nonzero__(std::map< std::string,Pythia8::FVec > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____bool__(std::map< std::string,Pythia8::FVec > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,Pythia8::FVec >::size_type std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____len__(std::map< std::string,Pythia8::FVec > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,Pythia8::FVec >::mapped_type const &std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____getitem__(std::map< std::string,Pythia8::FVec > *self,std::map< std::string,Pythia8::FVec >::key_type const &key){
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____delitem__(std::map< std::string,Pythia8::FVec > *self,std::map< std::string,Pythia8::FVec >::key_type const &key){
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__has_key(std::map< std::string,Pythia8::FVec > const *self,std::map< std::string,Pythia8::FVec >::key_type const &key){
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__keys(std::map< std::string,Pythia8::FVec > *self){
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__values(std::map< std::string,Pythia8::FVec > *self){
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__items(std::map< std::string,Pythia8::FVec > *self){
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____contains__(std::map< std::string,Pythia8::FVec > *self,std::map< std::string,Pythia8::FVec >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__key_iterator(std::map< std::string,Pythia8::FVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__value_iterator(std::map< std::string,Pythia8::FVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____setitem____SWIG_0(std::map< std::string,Pythia8::FVec > *self,std::map< std::string,Pythia8::FVec >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_FVec_Sg____setitem____SWIG_1(std::map< std::string,Pythia8::FVec > *self,std::map< std::string,Pythia8::FVec >::key_type const &key,std::map< std::string,Pythia8::FVec >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__asdict(std::map< std::string,Pythia8::FVec > *self){
      return swig::traits_from< std::map< std::string,Pythia8::FVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::FVec > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__erase__SWIG_1(std::map< std::string,Pythia8::FVec > *self,std::map< std::string,Pythia8::FVec >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_FVec_Sg__erase__SWIG_2(std::map< std::string,Pythia8::FVec > *self,std::map< std::string,Pythia8::FVec >::iterator first,std::map< std::string,Pythia8::FVec >::iterator last){ self->erase(first, last); }

  namespace swig {
    template <>  struct traits< Pythia8::MVec > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::MVec"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::pair< std::string, Pythia8::MVec > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "Pythia8::MVec" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, Pythia8::MVec, std::less< std::string >, std::allocator< std::pair< std::string const,Pythia8::MVec > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "Pythia8::MVec" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,Pythia8::MVec > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__iterator(std::map< std::string,Pythia8::MVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____nonzero__(std::map< std::string,Pythia8::MVec > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____bool__(std::map< std::string,Pythia8::MVec > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,Pythia8::MVec >::size_type std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____len__(std::map< std::string,Pythia8::MVec > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,Pythia8::MVec >::mapped_type const &std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____getitem__(std::map< std::string,Pythia8::MVec > *self,std::map< std::string,Pythia8::MVec >::key_type const &key){
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____delitem__(std::map< std::string,Pythia8::MVec > *self,std::map< std::string,Pythia8::MVec >::key_type const &key){
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__has_key(std::map< std::string,Pythia8::MVec > const *self,std::map< std::string,Pythia8::MVec >::key_type const &key){
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__keys(std::map< std::string,Pythia8::MVec > *self){
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__values(std::map< std::string,Pythia8::MVec > *self){
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__items(std::map< std::string,Pythia8::MVec > *self){
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____contains__(std::map< std::string,Pythia8::MVec > *self,std::map< std::string,Pythia8::MVec >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__key_iterator(std::map< std::string,Pythia8::MVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__value_iterator(std::map< std::string,Pythia8::MVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____setitem____SWIG_0(std::map< std::string,Pythia8::MVec > *self,std::map< std::string,Pythia8::MVec >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_MVec_Sg____setitem____SWIG_1(std::map< std::string,Pythia8::MVec > *self,std::map< std::string,Pythia8::MVec >::key_type const &key,std::map< std::string,Pythia8::MVec >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__asdict(std::map< std::string,Pythia8::MVec > *self){
      return swig::traits_from< std::map< std::string,Pythia8::MVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::MVec > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__erase__SWIG_1(std::map< std::string,Pythia8::MVec > *self,std::map< std::string,Pythia8::MVec >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_MVec_Sg__erase__SWIG_2(std::map< std::string,Pythia8::MVec > *self,std::map< std::string,Pythia8::MVec >::iterator first,std::map< std::string,Pythia8::MVec >::iterator last){ self->erase(first, last); }

  namespace swig {
    template <>  struct traits< Pythia8::PVec > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::PVec"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::pair< std::string, Pythia8::PVec > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::pair<" "std::string" "," "Pythia8::PVec" " >";
	  }
	};
      }
    

      namespace swig {
	template <>  struct traits<std::map< std::string, Pythia8::PVec, std::less< std::string >, std::allocator< std::pair< std::string const,Pythia8::PVec > > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::map<" "std::string" "," "Pythia8::PVec" "," "std::less< std::string >" "," "std::allocator< std::pair< std::string const,Pythia8::PVec > >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__iterator(std::map< std::string,Pythia8::PVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____nonzero__(std::map< std::string,Pythia8::PVec > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____bool__(std::map< std::string,Pythia8::PVec > const *self){
      return !(self->empty());
    }
SWIGINTERN std::map< std::string,Pythia8::PVec >::size_type std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____len__(std::map< std::string,Pythia8::PVec > const *self){
      return self->size();
    }
SWIGINTERN std::map< std::string,Pythia8::PVec >::mapped_type const &std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____getitem__(std::map< std::string,Pythia8::PVec > *self,std::map< std::string,Pythia8::PVec >::key_type const &key){
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::const_iterator i = self->find(key);
      if (i != self->end())
	return i->second;
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____delitem__(std::map< std::string,Pythia8::PVec > *self,std::map< std::string,Pythia8::PVec >::key_type const &key){
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::iterator i = self->find(key);
      if (i != self->end())
	self->erase(i);
      else
	throw std::out_of_range("key not found");
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__has_key(std::map< std::string,Pythia8::PVec > const *self,std::map< std::string,Pythia8::PVec >::key_type const &key){
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::const_iterator i = self->find(key);
      return i != self->end();
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__keys(std::map< std::string,Pythia8::PVec > *self){
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* keyList = PyList_New(pysize);
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(keyList, j, swig::from(i->first));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return keyList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__values(std::map< std::string,Pythia8::PVec > *self){
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }
      PyObject* valList = PyList_New(pysize);
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(valList, j, swig::from(i->second));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return valList;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__items(std::map< std::string,Pythia8::PVec > *self){
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::size_type size = self->size();
      Py_ssize_t pysize = (size <= (std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::size_type) INT_MAX) ? (Py_ssize_t) size : -1;
      SWIG_PYTHON_THREAD_BEGIN_BLOCK;
      if (pysize < 0) {
	PyErr_SetString(PyExc_OverflowError, "map size not valid in python");
	SWIG_PYTHON_THREAD_END_BLOCK;
	return NULL;
      }    
      PyObject* itemList = PyList_New(pysize);
      std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > >::const_iterator i = self->begin();
      for (Py_ssize_t j = 0; j < pysize; ++i, ++j) {
	PyList_SET_ITEM(itemList, j, swig::from(*i));
      }
      SWIG_PYTHON_THREAD_END_BLOCK;
      return itemList;
    }
SWIGINTERN bool std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____contains__(std::map< std::string,Pythia8::PVec > *self,std::map< std::string,Pythia8::PVec >::key_type const &key){
      return self->find(key) != self->end();
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__key_iterator(std::map< std::string,Pythia8::PVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_key_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN swig::SwigPyIterator *std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__value_iterator(std::map< std::string,Pythia8::PVec > *self,PyObject **PYTHON_SELF){
      return swig::make_output_value_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____setitem____SWIG_0(std::map< std::string,Pythia8::PVec > *self,std::map< std::string,Pythia8::PVec >::key_type const &key){
      self->erase(key);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_PVec_Sg____setitem____SWIG_1(std::map< std::string,Pythia8::PVec > *self,std::map< std::string,Pythia8::PVec >::key_type const &key,std::map< std::string,Pythia8::PVec >::mapped_type const &x){
      (*self)[key] = x;
    }
SWIGINTERN PyObject *std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__asdict(std::map< std::string,Pythia8::PVec > *self){
      return swig::traits_from< std::map< std::string,Pythia8::PVec,std::less< std::string >,std::allocator< std::pair< std::string const,Pythia8::PVec > > > >::asdict(*self);
    }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__erase__SWIG_1(std::map< std::string,Pythia8::PVec > *self,std::map< std::string,Pythia8::PVec >::iterator position){ self->erase(position); }
SWIGINTERN void std_map_Sl_std_string_Sc_Pythia8_PVec_Sg__erase__SWIG_2(std::map< std::string,Pythia8::PVec > *self,std::map< std::string,Pythia8::PVec >::iterator first,std::map< std::string,Pythia8::PVec >::iterator last){ self->erase(first, last); }

  namespace swig {
    template <>  struct traits< Pythia8::Clustering > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::Clustering"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector< Pythia8::Clustering, std::allocator< Pythia8::Clustering > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "Pythia8::Clustering" "," "std::allocator< Pythia8::Clustering >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_Pythia8_Clustering_Sg__iterator(std::vector< Pythia8::Clustering > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_Pythia8_Clustering_Sg____nonzero__(std::vector< Pythia8::Clustering > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_Pythia8_Clustering_Sg____bool__(std::vector< Pythia8::Clustering > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< Pythia8::Clustering >::size_type std_vector_Sl_Pythia8_Clustering_Sg____len__(std::vector< Pythia8::Clustering > const *self){
      return self->size();
    }
SWIGINTERN std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > > *std_vector_Sl_Pythia8_Clustering_Sg____getslice__(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::difference_type i,std::vector< Pythia8::Clustering >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____setslice____SWIG_0(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::difference_type i,std::vector< Pythia8::Clustering >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >());
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____setslice____SWIG_1(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::difference_type i,std::vector< Pythia8::Clustering >::difference_type j,std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____delslice__(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::difference_type i,std::vector< Pythia8::Clustering >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____delitem____SWIG_0(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > > *std_vector_Sl_Pythia8_Clustering_Sg____getitem____SWIG_0(std::vector< Pythia8::Clustering > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type id = i;
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____setitem____SWIG_0(std::vector< Pythia8::Clustering > *self,PySliceObject *slice,std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type id = i;
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____setitem____SWIG_1(std::vector< Pythia8::Clustering > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type id = i;
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____delitem____SWIG_1(std::vector< Pythia8::Clustering > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type id = i;
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< Pythia8::Clustering >::value_type const &std_vector_Sl_Pythia8_Clustering_Sg____getitem____SWIG_1(std::vector< Pythia8::Clustering > const *self,std::vector< Pythia8::Clustering >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg____setitem____SWIG_2(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::difference_type i,std::vector< Pythia8::Clustering >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< Pythia8::Clustering >::value_type std_vector_Sl_Pythia8_Clustering_Sg__pop(std::vector< Pythia8::Clustering > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< Pythia8::Clustering,std::allocator< Pythia8::Clustering > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg__append(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< Pythia8::Clustering >::iterator std_vector_Sl_Pythia8_Clustering_Sg__erase__SWIG_0(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< Pythia8::Clustering >::iterator std_vector_Sl_Pythia8_Clustering_Sg__erase__SWIG_1(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::iterator first,std::vector< Pythia8::Clustering >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< Pythia8::Clustering >::iterator std_vector_Sl_Pythia8_Clustering_Sg__insert__SWIG_0(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::iterator pos,std::vector< Pythia8::Clustering >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_Pythia8_Clustering_Sg__insert__SWIG_1(std::vector< Pythia8::Clustering > *self,std::vector< Pythia8::Clustering >::iterator pos,std::vector< Pythia8::Clustering >::size_type n,std::vector< Pythia8::Clustering >::value_type const &x){ self->insert(pos, n, x); }

  namespace swig {
    template <>  struct traits< Pythia8::HelicityParticle > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::HelicityParticle"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector< Pythia8::HelicityParticle, std::allocator< Pythia8::HelicityParticle > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "Pythia8::HelicityParticle" "," "std::allocator< Pythia8::HelicityParticle >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_Pythia8_HelicityParticle_Sg__iterator(std::vector< Pythia8::HelicityParticle > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_Pythia8_HelicityParticle_Sg____nonzero__(std::vector< Pythia8::HelicityParticle > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_Pythia8_HelicityParticle_Sg____bool__(std::vector< Pythia8::HelicityParticle > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< Pythia8::HelicityParticle >::size_type std_vector_Sl_Pythia8_HelicityParticle_Sg____len__(std::vector< Pythia8::HelicityParticle > const *self){
      return self->size();
    }
SWIGINTERN std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > > *std_vector_Sl_Pythia8_HelicityParticle_Sg____getslice__(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::difference_type i,std::vector< Pythia8::HelicityParticle >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____setslice____SWIG_0(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::difference_type i,std::vector< Pythia8::HelicityParticle >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >());
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____setslice____SWIG_1(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::difference_type i,std::vector< Pythia8::HelicityParticle >::difference_type j,std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____delslice__(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::difference_type i,std::vector< Pythia8::HelicityParticle >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____delitem____SWIG_0(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > > *std_vector_Sl_Pythia8_HelicityParticle_Sg____getitem____SWIG_0(std::vector< Pythia8::HelicityParticle > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type id = i;
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____setitem____SWIG_0(std::vector< Pythia8::HelicityParticle > *self,PySliceObject *slice,std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type id = i;
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____setitem____SWIG_1(std::vector< Pythia8::HelicityParticle > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type id = i;
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____delitem____SWIG_1(std::vector< Pythia8::HelicityParticle > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type id = i;
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< Pythia8::HelicityParticle >::value_type const &std_vector_Sl_Pythia8_HelicityParticle_Sg____getitem____SWIG_1(std::vector< Pythia8::HelicityParticle > const *self,std::vector< Pythia8::HelicityParticle >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg____setitem____SWIG_2(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::difference_type i,std::vector< Pythia8::HelicityParticle >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< Pythia8::HelicityParticle >::value_type std_vector_Sl_Pythia8_HelicityParticle_Sg__pop(std::vector< Pythia8::HelicityParticle > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< Pythia8::HelicityParticle,std::allocator< Pythia8::HelicityParticle > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg__append(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< Pythia8::HelicityParticle >::iterator std_vector_Sl_Pythia8_HelicityParticle_Sg__erase__SWIG_0(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< Pythia8::HelicityParticle >::iterator std_vector_Sl_Pythia8_HelicityParticle_Sg__erase__SWIG_1(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::iterator first,std::vector< Pythia8::HelicityParticle >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< Pythia8::HelicityParticle >::iterator std_vector_Sl_Pythia8_HelicityParticle_Sg__insert__SWIG_0(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::iterator pos,std::vector< Pythia8::HelicityParticle >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_Pythia8_HelicityParticle_Sg__insert__SWIG_1(std::vector< Pythia8::HelicityParticle > *self,std::vector< Pythia8::HelicityParticle >::iterator pos,std::vector< Pythia8::HelicityParticle >::size_type n,std::vector< Pythia8::HelicityParticle >::value_type const &x){ self->insert(pos, n, x); }

  namespace swig {
    template <>  struct traits< Pythia8::ProcessContainer > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::ProcessContainer"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector< Pythia8::ProcessContainer*, std::allocator< Pythia8::ProcessContainer * > > > {
	  typedef value_category category;
	  static const char* type_name() {
	    return "std::vector<" "Pythia8::ProcessContainer" " *," "std::allocator< Pythia8::ProcessContainer * >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg__iterator(std::vector< Pythia8::ProcessContainer * > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____nonzero__(std::vector< Pythia8::ProcessContainer * > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____bool__(std::vector< Pythia8::ProcessContainer * > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< Pythia8::ProcessContainer * >::size_type std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____len__(std::vector< Pythia8::ProcessContainer * > const *self){
      return self->size();
    }
SWIGINTERN std::vector< Pythia8::ProcessContainer *,std::allocator< Pythia8::ProcessContainer * > > *std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____getslice__(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::difference_type i,std::vector< Pythia8::ProcessContainer * >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____setslice____SWIG_0(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::difference_type i,std::vector< Pythia8::ProcessContainer * >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >());
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____setslice____SWIG_1(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::difference_type i,std::vector< Pythia8::ProcessContainer * >::difference_type j,std::vector< Pythia8::ProcessContainer *,std::allocator< Pythia8::ProcessContainer * > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____delslice__(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::difference_type i,std::vector< Pythia8::ProcessContainer * >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____delitem____SWIG_0(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< Pythia8::ProcessContainer *,std::allocator< Pythia8::ProcessContainer * > > *std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____getitem____SWIG_0(std::vector< Pythia8::ProcessContainer * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type id = i;
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____setitem____SWIG_0(std::vector< Pythia8::ProcessContainer * > *self,PySliceObject *slice,std::vector< Pythia8::ProcessContainer *,std::allocator< Pythia8::ProcessContainer * > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type id = i;
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____setitem____SWIG_1(std::vector< Pythia8::ProcessContainer * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type id = i;
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____delitem____SWIG_1(std::vector< Pythia8::ProcessContainer * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type id = i;
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< Pythia8::ProcessContainer * >::value_type std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____getitem____SWIG_1(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg____setitem____SWIG_2(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::difference_type i,std::vector< Pythia8::ProcessContainer * >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< Pythia8::ProcessContainer * >::value_type std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg__pop(std::vector< Pythia8::ProcessContainer * > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< Pythia8::ProcessContainer*,std::allocator< Pythia8::ProcessContainer * > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg__append(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::value_type x){
      self->push_back(x);
    }
SWIGINTERN std::vector< Pythia8::ProcessContainer * >::iterator std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg__erase__SWIG_0(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< Pythia8::ProcessContainer * >::iterator std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg__erase__SWIG_1(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::iterator first,std::vector< Pythia8::ProcessContainer * >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< Pythia8::ProcessContainer * >::iterator std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg__insert__SWIG_0(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::iterator pos,std::vector< Pythia8::ProcessContainer * >::value_type x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_Pythia8_ProcessContainer_Sm__Sg__insert__SWIG_1(std::vector< Pythia8::ProcessContainer * > *self,std::vector< Pythia8::ProcessContainer * >::iterator pos,std::vector< Pythia8::ProcessContainer * >::size_type n,std::vector< Pythia8::ProcessContainer * >::value_type x){ self->insert(pos, n, x); }

  namespace swig {
    template <>  struct traits< Pythia8::ResonanceWidths > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::ResonanceWidths"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector< Pythia8::ResonanceWidths*, std::allocator< Pythia8::ResonanceWidths * > > > {
	  typedef value_category category;
	  static const char* type_name() {
	    return "std::vector<" "Pythia8::ResonanceWidths" " *," "std::allocator< Pythia8::ResonanceWidths * >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg__iterator(std::vector< Pythia8::ResonanceWidths * > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____nonzero__(std::vector< Pythia8::ResonanceWidths * > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____bool__(std::vector< Pythia8::ResonanceWidths * > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< Pythia8::ResonanceWidths * >::size_type std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____len__(std::vector< Pythia8::ResonanceWidths * > const *self){
      return self->size();
    }
SWIGINTERN std::vector< Pythia8::ResonanceWidths *,std::allocator< Pythia8::ResonanceWidths * > > *std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____getslice__(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::difference_type i,std::vector< Pythia8::ResonanceWidths * >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____setslice____SWIG_0(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::difference_type i,std::vector< Pythia8::ResonanceWidths * >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >());
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____setslice____SWIG_1(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::difference_type i,std::vector< Pythia8::ResonanceWidths * >::difference_type j,std::vector< Pythia8::ResonanceWidths *,std::allocator< Pythia8::ResonanceWidths * > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____delslice__(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::difference_type i,std::vector< Pythia8::ResonanceWidths * >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____delitem____SWIG_0(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< Pythia8::ResonanceWidths *,std::allocator< Pythia8::ResonanceWidths * > > *std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____getitem____SWIG_0(std::vector< Pythia8::ResonanceWidths * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type id = i;
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____setitem____SWIG_0(std::vector< Pythia8::ResonanceWidths * > *self,PySliceObject *slice,std::vector< Pythia8::ResonanceWidths *,std::allocator< Pythia8::ResonanceWidths * > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type id = i;
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____setitem____SWIG_1(std::vector< Pythia8::ResonanceWidths * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type id = i;
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____delitem____SWIG_1(std::vector< Pythia8::ResonanceWidths * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type id = i;
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< Pythia8::ResonanceWidths * >::value_type std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____getitem____SWIG_1(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg____setitem____SWIG_2(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::difference_type i,std::vector< Pythia8::ResonanceWidths * >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< Pythia8::ResonanceWidths * >::value_type std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg__pop(std::vector< Pythia8::ResonanceWidths * > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< Pythia8::ResonanceWidths*,std::allocator< Pythia8::ResonanceWidths * > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg__append(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::value_type x){
      self->push_back(x);
    }
SWIGINTERN std::vector< Pythia8::ResonanceWidths * >::iterator std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg__erase__SWIG_0(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< Pythia8::ResonanceWidths * >::iterator std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg__erase__SWIG_1(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::iterator first,std::vector< Pythia8::ResonanceWidths * >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< Pythia8::ResonanceWidths * >::iterator std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg__insert__SWIG_0(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::iterator pos,std::vector< Pythia8::ResonanceWidths * >::value_type x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_Pythia8_ResonanceWidths_Sm__Sg__insert__SWIG_1(std::vector< Pythia8::ResonanceWidths * > *self,std::vector< Pythia8::ResonanceWidths * >::iterator pos,std::vector< Pythia8::ResonanceWidths * >::size_type n,std::vector< Pythia8::ResonanceWidths * >::value_type x){ self->insert(pos, n, x); }

  namespace swig {
    template <>  struct traits< Pythia8::SigmaProcess > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::SigmaProcess"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector< Pythia8::SigmaProcess*, std::allocator< Pythia8::SigmaProcess * > > > {
	  typedef value_category category;
	  static const char* type_name() {
	    return "std::vector<" "Pythia8::SigmaProcess" " *," "std::allocator< Pythia8::SigmaProcess * >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg__iterator(std::vector< Pythia8::SigmaProcess * > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____nonzero__(std::vector< Pythia8::SigmaProcess * > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____bool__(std::vector< Pythia8::SigmaProcess * > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< Pythia8::SigmaProcess * >::size_type std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____len__(std::vector< Pythia8::SigmaProcess * > const *self){
      return self->size();
    }
SWIGINTERN std::vector< Pythia8::SigmaProcess *,std::allocator< Pythia8::SigmaProcess * > > *std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____getslice__(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::difference_type i,std::vector< Pythia8::SigmaProcess * >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____setslice____SWIG_0(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::difference_type i,std::vector< Pythia8::SigmaProcess * >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >());
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____setslice____SWIG_1(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::difference_type i,std::vector< Pythia8::SigmaProcess * >::difference_type j,std::vector< Pythia8::SigmaProcess *,std::allocator< Pythia8::SigmaProcess * > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____delslice__(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::difference_type i,std::vector< Pythia8::SigmaProcess * >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____delitem____SWIG_0(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< Pythia8::SigmaProcess *,std::allocator< Pythia8::SigmaProcess * > > *std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____getitem____SWIG_0(std::vector< Pythia8::SigmaProcess * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type id = i;
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____setitem____SWIG_0(std::vector< Pythia8::SigmaProcess * > *self,PySliceObject *slice,std::vector< Pythia8::SigmaProcess *,std::allocator< Pythia8::SigmaProcess * > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type id = i;
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____setitem____SWIG_1(std::vector< Pythia8::SigmaProcess * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type id = i;
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____delitem____SWIG_1(std::vector< Pythia8::SigmaProcess * > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type id = i;
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< Pythia8::SigmaProcess * >::value_type std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____getitem____SWIG_1(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg____setitem____SWIG_2(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::difference_type i,std::vector< Pythia8::SigmaProcess * >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< Pythia8::SigmaProcess * >::value_type std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg__pop(std::vector< Pythia8::SigmaProcess * > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< Pythia8::SigmaProcess*,std::allocator< Pythia8::SigmaProcess * > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg__append(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::value_type x){
      self->push_back(x);
    }
SWIGINTERN std::vector< Pythia8::SigmaProcess * >::iterator std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg__erase__SWIG_0(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< Pythia8::SigmaProcess * >::iterator std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg__erase__SWIG_1(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::iterator first,std::vector< Pythia8::SigmaProcess * >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< Pythia8::SigmaProcess * >::iterator std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg__insert__SWIG_0(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::iterator pos,std::vector< Pythia8::SigmaProcess * >::value_type x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_Pythia8_SigmaProcess_Sm__Sg__insert__SWIG_1(std::vector< Pythia8::SigmaProcess * > *self,std::vector< Pythia8::SigmaProcess * >::iterator pos,std::vector< Pythia8::SigmaProcess * >::size_type n,std::vector< Pythia8::SigmaProcess * >::value_type x){ self->insert(pos, n, x); }

  namespace swig {
    template <>  struct traits< Pythia8::Vec4 > {
      typedef pointer_category category;
      static const char* type_name() { return"Pythia8::Vec4"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector< Pythia8::Vec4, std::allocator< Pythia8::Vec4 > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "Pythia8::Vec4" "," "std::allocator< Pythia8::Vec4 >" " >";
	  }
	};
      }
    
SWIGINTERN swig::SwigPyIterator *std_vector_Sl_Pythia8_Vec4_Sg__iterator(std::vector< Pythia8::Vec4 > *self,PyObject **PYTHON_SELF){
      return swig::make_output_iterator(self->begin(), self->begin(), self->end(), *PYTHON_SELF);
    }
SWIGINTERN bool std_vector_Sl_Pythia8_Vec4_Sg____nonzero__(std::vector< Pythia8::Vec4 > const *self){
      return !(self->empty());
    }
SWIGINTERN bool std_vector_Sl_Pythia8_Vec4_Sg____bool__(std::vector< Pythia8::Vec4 > const *self){
      return !(self->empty());
    }
SWIGINTERN std::vector< Pythia8::Vec4 >::size_type std_vector_Sl_Pythia8_Vec4_Sg____len__(std::vector< Pythia8::Vec4 > const *self){
      return self->size();
    }
SWIGINTERN std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > *std_vector_Sl_Pythia8_Vec4_Sg____getslice__(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::difference_type i,std::vector< Pythia8::Vec4 >::difference_type j){
      return swig::getslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____setslice____SWIG_0(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::difference_type i,std::vector< Pythia8::Vec4 >::difference_type j){
      swig::setslice(self, i, j, 1, std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >());
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____setslice____SWIG_1(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::difference_type i,std::vector< Pythia8::Vec4 >::difference_type j,std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > const &v){
      swig::setslice(self, i, j, 1, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____delslice__(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::difference_type i,std::vector< Pythia8::Vec4 >::difference_type j){
      swig::delslice(self, i, j, 1);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____delitem____SWIG_0(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::difference_type i){
      swig::erase(self, swig::getpos(self, i));
    }
SWIGINTERN std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > *std_vector_Sl_Pythia8_Vec4_Sg____getitem____SWIG_0(std::vector< Pythia8::Vec4 > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return NULL;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type id = i;
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type jd = j;
      return swig::getslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____setitem____SWIG_0(std::vector< Pythia8::Vec4 > *self,PySliceObject *slice,std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > const &v){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type id = i;
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type jd = j;
      swig::setslice(self, id, jd, step, v);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____setitem____SWIG_1(std::vector< Pythia8::Vec4 > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type id = i;
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____delitem____SWIG_1(std::vector< Pythia8::Vec4 > *self,PySliceObject *slice){
      Py_ssize_t i, j, step;
      if( !PySlice_Check(slice) ) {
        SWIG_Error(SWIG_TypeError, "Slice object expected.");
        return;
      }
      PySlice_GetIndices(SWIGPY_SLICE_ARG(slice), (Py_ssize_t)self->size(), &i, &j, &step);
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type id = i;
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::difference_type jd = j;
      swig::delslice(self, id, jd, step);
    }
SWIGINTERN std::vector< Pythia8::Vec4 >::value_type const &std_vector_Sl_Pythia8_Vec4_Sg____getitem____SWIG_1(std::vector< Pythia8::Vec4 > const *self,std::vector< Pythia8::Vec4 >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg____setitem____SWIG_2(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::difference_type i,std::vector< Pythia8::Vec4 >::value_type const &x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN std::vector< Pythia8::Vec4 >::value_type std_vector_Sl_Pythia8_Vec4_Sg__pop(std::vector< Pythia8::Vec4 > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg__append(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::value_type const &x){
      self->push_back(x);
    }
SWIGINTERN std::vector< Pythia8::Vec4 >::iterator std_vector_Sl_Pythia8_Vec4_Sg__erase__SWIG_0(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::iterator pos){ return self->erase(pos); }
SWIGINTERN std::vector< Pythia8::Vec4 >::iterator std_vector_Sl_Pythia8_Vec4_Sg__erase__SWIG_1(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::iterator first,std::vector< Pythia8::Vec4 >::iterator last){ return self->erase(first, last); }
SWIGINTERN std::vector< Pythia8::Vec4 >::iterator std_vector_Sl_Pythia8_Vec4_Sg__insert__SWIG_0(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::iterator pos,std::vector< Pythia8::Vec4 >::value_type const &x){ return self->insert(pos, x); }
SWIGINTERN void std_vector_Sl_Pythia8_Vec4_Sg__insert__SWIG_1(std::vector< Pythia8::Vec4 > *self,std::vector< Pythia8::Vec4 >::iterator pos,std::vector< Pythia8::Vec4 >::size_type n,std::vector< Pythia8::Vec4 >::value_type const &x){ self->insert(pos, n, x); }


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.8
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

#ifndef SWIG_pythia8_WRAP_H_
#define SWIG_pythia8_WRAP_H_

#include <map>
#include <string>


class SwigDirector_RndmEngine : public Pythia8::RndmEngine, public Swig::Director {

public:
    SwigDirector_RndmEngine(PyObject *self);
    virtual ~SwigDirector_RndmEngine();
    virtual double flat();

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class RndmEngine doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[1];
#endif

};


class SwigDirector_BeamShape : public Pythia8::BeamShape, public Swig::Director {

public:
    SwigDirector_BeamShape(PyObject *self);
    virtual ~SwigDirector_BeamShape();
    virtual void init(Pythia8::Settings &settings, Pythia8::Rndm *rndmPtrIn);
    virtual void pick();
    using Pythia8::BeamShape::deltaPxA;
    using Pythia8::BeamShape::deltaPyA;
    using Pythia8::BeamShape::deltaPzA;
    using Pythia8::BeamShape::deltaPxB;
    using Pythia8::BeamShape::deltaPyB;
    using Pythia8::BeamShape::deltaPzB;
    using Pythia8::BeamShape::vertexX;
    using Pythia8::BeamShape::vertexY;
    using Pythia8::BeamShape::vertexZ;
    using Pythia8::BeamShape::vertexT;
    using Pythia8::BeamShape::allowMomentumSpread;
    using Pythia8::BeamShape::allowVertexSpread;
    using Pythia8::BeamShape::sigmaPxA;
    using Pythia8::BeamShape::sigmaPyA;
    using Pythia8::BeamShape::sigmaPzA;
    using Pythia8::BeamShape::maxDevA;
    using Pythia8::BeamShape::sigmaPxB;
    using Pythia8::BeamShape::sigmaPyB;
    using Pythia8::BeamShape::sigmaPzB;
    using Pythia8::BeamShape::maxDevB;
    using Pythia8::BeamShape::sigmaVertexX;
    using Pythia8::BeamShape::sigmaVertexY;
    using Pythia8::BeamShape::sigmaVertexZ;
    using Pythia8::BeamShape::maxDevVertex;
    using Pythia8::BeamShape::sigmaTime;
    using Pythia8::BeamShape::maxDevTime;
    using Pythia8::BeamShape::offsetX;
    using Pythia8::BeamShape::offsetY;
    using Pythia8::BeamShape::offsetZ;
    using Pythia8::BeamShape::offsetT;
    using Pythia8::BeamShape::rndmPtr;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class BeamShape doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[2];
#endif

};


class SwigDirector_PDF : public Pythia8::PDF, public Swig::Director {

public:
    SwigDirector_PDF(PyObject *self, int idBeamIn = 2212);
    virtual ~SwigDirector_PDF();
    virtual bool isSetup();
    virtual void newValenceContent(int idVal1In, int idVal2In);
    virtual void setExtrapolate(bool arg0);
    virtual double xf(int id, double x, double Q2);
    virtual double xfVal(int id, double x, double Q2);
    virtual double xfSea(int id, double x, double Q2);
    virtual bool insideBounds(double arg0, double arg1);
    virtual double alphaS(double arg0);
    virtual double mQuarkPDF(int arg0);
    virtual int nMembers();
    virtual void calcPDFEnvelope(int arg0, double arg1, double arg2, int arg3);
    virtual void calcPDFEnvelope(std::pair< int,int > arg0, std::pair< double,double > arg1, double arg2, int arg3);
    virtual Pythia8::PDF::PDFEnvelope getPDFEnvelope();
    virtual double gammaPDFxDependence(int arg0, double arg1);
    virtual double gammaPDFRefScale(int arg0);
    virtual int sampleGammaValFlavor(double arg0);
    virtual double xfIntegratedTotal(double arg0);
    virtual double xGamma();
    virtual void xPom(double arg0 = -1.0);
    virtual double xfFlux(int arg0, double arg1, double arg2);
    virtual double xfApprox(int arg0, double arg1, double arg2);
    virtual double xfGamma(int arg0, double arg1, double arg2);
    virtual double intFluxApprox();
    virtual double getXmin();
    virtual double getXhadr();
    virtual double sampleXgamma(double arg0);
    virtual double sampleQ2gamma(double arg0);
    virtual double xfMax(int id, double x, double Q2);
    virtual double xfSame(int id, double x, double Q2);
    virtual void setVMDscale(double arg0 = 1.);
    virtual void xfUpdate(int id, double x, double Q2);
    using Pythia8::PDF::idBeam;
    using Pythia8::PDF::idBeamAbs;
    using Pythia8::PDF::idSav;
    using Pythia8::PDF::idVal1;
    using Pythia8::PDF::idVal2;
    using Pythia8::PDF::xSav;
    using Pythia8::PDF::Q2Sav;
    using Pythia8::PDF::xu;
    using Pythia8::PDF::xd;
    using Pythia8::PDF::xs;
    using Pythia8::PDF::xubar;
    using Pythia8::PDF::xdbar;
    using Pythia8::PDF::xsbar;
    using Pythia8::PDF::xc;
    using Pythia8::PDF::xb;
    using Pythia8::PDF::xg;
    using Pythia8::PDF::xlepton;
    using Pythia8::PDF::xgamma;
    using Pythia8::PDF::xuVal;
    using Pythia8::PDF::xuSea;
    using Pythia8::PDF::xdVal;
    using Pythia8::PDF::xdSea;
    using Pythia8::PDF::isSet;
    using Pythia8::PDF::isInit;
    using Pythia8::PDF::xsVal;
    using Pythia8::PDF::xcVal;
    using Pythia8::PDF::xbVal;
    using Pythia8::PDF::xsSea;
    using Pythia8::PDF::xcSea;
    using Pythia8::PDF::xbSea;
    using Pythia8::PDF::hasGammaInLepton;
    using Pythia8::PDF::setValenceContent;
    using Pythia8::PDF::printErr;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class PDF doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[33];
#endif

};


class SwigDirector_ResonanceWidths : public Pythia8::ResonanceWidths, public Swig::Director {

public:
    SwigDirector_ResonanceWidths(PyObject *self);
    virtual ~SwigDirector_ResonanceWidths();
    virtual bool init(Pythia8::Info *infoPtrIn, Pythia8::Settings *settingsPtrIn, Pythia8::ParticleData *particleDataPtrIn, Pythia8::Couplings *couplingsPtrIn);
    virtual void initConstants();
    virtual void initConstantsSwigPublic() {
      Pythia8::ResonanceWidths::initConstants();
    }
    virtual bool initBSM();
    virtual bool initBSMSwigPublic() {
      return Pythia8::ResonanceWidths::initBSM();
    }
    virtual bool allowCalc();
    virtual bool allowCalcSwigPublic() {
      return Pythia8::ResonanceWidths::allowCalc();
    }
    virtual void calcPreFac(bool arg0 = false);
    virtual void calcPreFacSwigPublic(bool arg0 = false) {
      Pythia8::ResonanceWidths::calcPreFac(arg0);
    }
    virtual void calcWidth(bool arg0 = false);
    virtual void calcWidthSwigPublic(bool arg0 = false) {
      Pythia8::ResonanceWidths::calcWidth(arg0);
    }
    using Pythia8::ResonanceWidths::NPOINT;
    using Pythia8::ResonanceWidths::MASSMIN;
    using Pythia8::ResonanceWidths::MASSMARGIN;
    using Pythia8::ResonanceWidths::idRes;
    using Pythia8::ResonanceWidths::hasAntiRes;
    using Pythia8::ResonanceWidths::doForceWidth;
    using Pythia8::ResonanceWidths::isGeneric;
    using Pythia8::ResonanceWidths::allowCalcWidth;
    using Pythia8::ResonanceWidths::minWidth;
    using Pythia8::ResonanceWidths::minThreshold;
    using Pythia8::ResonanceWidths::mRes;
    using Pythia8::ResonanceWidths::GammaRes;
    using Pythia8::ResonanceWidths::m2Res;
    using Pythia8::ResonanceWidths::GamMRat;
    using Pythia8::ResonanceWidths::openPos;
    using Pythia8::ResonanceWidths::openNeg;
    using Pythia8::ResonanceWidths::forceFactor;
    using Pythia8::ResonanceWidths::iChannel;
    using Pythia8::ResonanceWidths::onMode;
    using Pythia8::ResonanceWidths::meMode;
    using Pythia8::ResonanceWidths::mult;
    using Pythia8::ResonanceWidths::id1;
    using Pythia8::ResonanceWidths::id2;
    using Pythia8::ResonanceWidths::id3;
    using Pythia8::ResonanceWidths::id1Abs;
    using Pythia8::ResonanceWidths::id2Abs;
    using Pythia8::ResonanceWidths::id3Abs;
    using Pythia8::ResonanceWidths::idInFlav;
    using Pythia8::ResonanceWidths::widNow;
    using Pythia8::ResonanceWidths::mHat;
    using Pythia8::ResonanceWidths::mf1;
    using Pythia8::ResonanceWidths::mf2;
    using Pythia8::ResonanceWidths::mf3;
    using Pythia8::ResonanceWidths::mr1;
    using Pythia8::ResonanceWidths::mr2;
    using Pythia8::ResonanceWidths::mr3;
    using Pythia8::ResonanceWidths::ps;
    using Pythia8::ResonanceWidths::kinFac;
    using Pythia8::ResonanceWidths::alpEM;
    using Pythia8::ResonanceWidths::alpS;
    using Pythia8::ResonanceWidths::colQ;
    using Pythia8::ResonanceWidths::preFac;
    using Pythia8::ResonanceWidths::particlePtr;
    using Pythia8::ResonanceWidths::infoPtr;
    using Pythia8::ResonanceWidths::settingsPtr;
    using Pythia8::ResonanceWidths::particleDataPtr;
    using Pythia8::ResonanceWidths::couplingsPtr;
    using Pythia8::ResonanceWidths::numInt1BW;
    using Pythia8::ResonanceWidths::numInt2BW;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class ResonanceWidths doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[8];
#endif

};


class SwigDirector_LHAup : public Pythia8::LHAup, public Swig::Director {

public:
    SwigDirector_LHAup(PyObject *self, int strategyIn = 3);
    virtual ~SwigDirector_LHAup();
    virtual void newEventFile(char const *arg0);
    virtual bool fileFound();
    virtual bool useExternal();
    virtual bool setInit();
    virtual bool setEvent(int idProcIn = 0);
    virtual bool skipEvent(int nSkip);
    virtual bool openLHEF(std::string fileNameIn);
    virtual bool closeLHEF(bool updateInit = false);
    using Pythia8::LHAup::CONVERTMB2PB;
    using Pythia8::LHAup::infoPtr;
    using Pythia8::LHAup::setBeamA;
    using Pythia8::LHAup::setBeamB;
    using Pythia8::LHAup::setStrategy;
    using Pythia8::LHAup::addProcess;
    using Pythia8::LHAup::setXSec;
    using Pythia8::LHAup::setXErr;
    using Pythia8::LHAup::setXMax;
    using Pythia8::LHAup::setProcess;
    using Pythia8::LHAup::addParticle;
    using Pythia8::LHAup::setIdX;
    using Pythia8::LHAup::setPdf;
    using Pythia8::LHAup::setScaleShowers;
    using Pythia8::LHAup::setInitLHEF;
    using Pythia8::LHAup::setNewEventLHEF;
    using Pythia8::LHAup::setOldEventLHEF;
    using Pythia8::LHAup::openFile;
    using Pythia8::LHAup::closeFile;
    using Pythia8::LHAup::setInfoHeader;
    using Pythia8::LHAup::nupSave;
    using Pythia8::LHAup::idprupSave;
    using Pythia8::LHAup::xwgtupSave;
    using Pythia8::LHAup::scalupSave;
    using Pythia8::LHAup::aqedupSave;
    using Pythia8::LHAup::aqcdupSave;
    using Pythia8::LHAup::xSecSumSave;
    using Pythia8::LHAup::xErrSumSave;
    using Pythia8::LHAup::particlesSave;
    using Pythia8::LHAup::getPDFSave;
    using Pythia8::LHAup::getScale;
    using Pythia8::LHAup::getScaleShowers;
    using Pythia8::LHAup::id1InSave;
    using Pythia8::LHAup::id2InSave;
    using Pythia8::LHAup::id1pdfInSave;
    using Pythia8::LHAup::id2pdfInSave;
    using Pythia8::LHAup::x1InSave;
    using Pythia8::LHAup::x2InSave;
    using Pythia8::LHAup::x1pdfInSave;
    using Pythia8::LHAup::x2pdfInSave;
    using Pythia8::LHAup::scalePDFInSave;
    using Pythia8::LHAup::pdf1InSave;
    using Pythia8::LHAup::pdf2InSave;
    using Pythia8::LHAup::scaleShowersInSave;
    using Pythia8::LHAup::fileName;
    using Pythia8::LHAup::dateNow;
    using Pythia8::LHAup::timeNow;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class LHAup doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[10];
#endif

};


class SwigDirector_MergingHooks : public Pythia8::MergingHooks, public Swig::Director {

public:
    SwigDirector_MergingHooks(PyObject *self);
    virtual ~SwigDirector_MergingHooks();
    virtual double tmsDefinition(Pythia8::Event const &event);
    virtual double dampenIfFailCuts(Pythia8::Event const &inEvent);
    virtual bool canCutOnRecState();
    virtual bool doCutOnRecState(Pythia8::Event const &event);
    virtual bool canVetoTrialEmission();
    virtual bool doVetoTrialEmission(Pythia8::Event const &arg0, Pythia8::Event const &arg1);
    virtual double hardProcessME(Pythia8::Event const &inEvent);
    virtual void init();
    virtual int getNumberOfClusteringSteps(Pythia8::Event const &event, bool resetNjetMax = false);
    virtual double tmsNow(Pythia8::Event const &event);
    virtual bool canVetoEmission();
    virtual bool doVetoEmission(Pythia8::Event const &arg0);
    virtual bool useShowerPlugin();
    virtual bool canVetoStep();
    virtual bool doVetoStep(Pythia8::Event const &process, Pythia8::Event const &event, bool doResonance = false);
    virtual bool setShowerStartingScales(bool isTrial, bool doMergeFirstEmm, double &pTscaleIn, Pythia8::Event const &event, double &pTmaxFSRIn, bool &limitPTmaxFSRin, double &pTmaxISRIn, bool &limitPTmaxISRin, double &pTmaxMPIIn, bool &limitPTmaxMPIin);

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class MergingHooks doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[18];
#endif

};


class SwigDirector_SigmaProcess : public Pythia8::SigmaProcess, public Swig::Director {

public:
    SwigDirector_SigmaProcess(PyObject *self);
    virtual ~SwigDirector_SigmaProcess();
    virtual void initProc();
    virtual bool initFlux();
    virtual void set1Kin(double arg0, double arg1, double arg2);
    virtual void set2Kin(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7);
    virtual void set2KinMPI(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6, bool arg7, double arg8, double arg9);
    virtual void set3Kin(double arg0, double arg1, double arg2, Pythia8::Vec4 arg3, Pythia8::Vec4 arg4, Pythia8::Vec4 arg5, double arg6, double arg7, double arg8, double arg9, double arg10, double arg11);
    virtual void sigmaKin();
    virtual double sigmaHat();
    virtual double sigmaHatWrap(int id1in = 0, int id2in = 0);
    virtual double sigmaPDF(bool initPS = false, bool samexGamma = false, bool useNewXvalues = false, double x1New = 0., double x2New = 0.);
    virtual void setIdColAcol();
    virtual bool final2KinMPI(int arg0 = 0, int arg1 = 0, Pythia8::Vec4 arg2 = 0., Pythia8::Vec4 arg3 = 0., double arg4 = 0., double arg5 = 0.);
    virtual double weightDecayFlav(Pythia8::Event &arg0);
    virtual double weightDecay(Pythia8::Event &arg0, int arg1, int arg2);
    virtual void setScale();
    virtual std::string name() const;
    virtual int code() const;
    virtual int nFinal() const;
    virtual std::string inFlux() const;
    virtual bool convert2mb() const;
    virtual bool convertM2() const;
    virtual bool isLHA() const;
    virtual bool isNonDiff() const;
    virtual bool isResolved() const;
    virtual bool isDiffA() const;
    virtual bool isDiffB() const;
    virtual bool isDiffC() const;
    virtual bool isSUSY() const;
    virtual bool allowNegativeSigma() const;
    virtual int id3Mass() const;
    virtual int id4Mass() const;
    virtual int id5Mass() const;
    virtual int resonanceA() const;
    virtual int resonanceB() const;
    virtual bool isSChannel() const;
    virtual int idSChannel() const;
    virtual bool isQCD3body() const;
    virtual int idTchan1() const;
    virtual int idTchan2() const;
    virtual double tChanFracPow1() const;
    virtual double tChanFracPow2() const;
    virtual bool useMirrorWeight() const;
    virtual int gmZmode() const;
    virtual void setIdInDiff(int arg0, int arg1);
    virtual bool setupForME();
    virtual bool setupForMESwigPublic() {
      return Pythia8::SigmaProcess::setupForME();
    }
    using Pythia8::SigmaProcess::CONVERT2MB;
    using Pythia8::SigmaProcess::MASSMARGIN;
    using Pythia8::SigmaProcess::COMPRELERR;
    using Pythia8::SigmaProcess::NCOMPSTEP;
    using Pythia8::SigmaProcess::infoPtr;
    using Pythia8::SigmaProcess::settingsPtr;
    using Pythia8::SigmaProcess::particleDataPtr;
    using Pythia8::SigmaProcess::rndmPtr;
    using Pythia8::SigmaProcess::beamAPtr;
    using Pythia8::SigmaProcess::beamBPtr;
    using Pythia8::SigmaProcess::couplingsPtr;
    using Pythia8::SigmaProcess::sigmaTotPtr;
    using Pythia8::SigmaProcess::slhaPtr;
    using Pythia8::SigmaProcess::lhaUpPtr;
    using Pythia8::SigmaProcess::nQuarkIn;
    using Pythia8::SigmaProcess::renormScale1;
    using Pythia8::SigmaProcess::renormScale2;
    using Pythia8::SigmaProcess::renormScale3;
    using Pythia8::SigmaProcess::renormScale3VV;
    using Pythia8::SigmaProcess::factorScale1;
    using Pythia8::SigmaProcess::factorScale2;
    using Pythia8::SigmaProcess::factorScale3;
    using Pythia8::SigmaProcess::factorScale3VV;
    using Pythia8::SigmaProcess::Kfactor;
    using Pythia8::SigmaProcess::mcME;
    using Pythia8::SigmaProcess::mbME;
    using Pythia8::SigmaProcess::mmuME;
    using Pythia8::SigmaProcess::mtauME;
    using Pythia8::SigmaProcess::renormMultFac;
    using Pythia8::SigmaProcess::renormFixScale;
    using Pythia8::SigmaProcess::factorMultFac;
    using Pythia8::SigmaProcess::factorFixScale;
    using Pythia8::SigmaProcess::higgsH1parity;
    using Pythia8::SigmaProcess::higgsH2parity;
    using Pythia8::SigmaProcess::higgsA3parity;
    using Pythia8::SigmaProcess::higgsH1eta;
    using Pythia8::SigmaProcess::higgsH2eta;
    using Pythia8::SigmaProcess::higgsA3eta;
    using Pythia8::SigmaProcess::higgsH1phi;
    using Pythia8::SigmaProcess::higgsH2phi;
    using Pythia8::SigmaProcess::higgsA3phi;
    using Pythia8::SigmaProcess::idA;
    using Pythia8::SigmaProcess::idB;
    using Pythia8::SigmaProcess::mA;
    using Pythia8::SigmaProcess::mB;
    using Pythia8::SigmaProcess::isLeptonA;
    using Pythia8::SigmaProcess::isLeptonB;
    using Pythia8::SigmaProcess::hasLeptonBeams;
    using Pythia8::SigmaProcess::lepton2gammaA;
    using Pythia8::SigmaProcess::lepton2gammaB;
    using Pythia8::SigmaProcess::inBeamA;
    using Pythia8::SigmaProcess::inBeamB;
    using Pythia8::SigmaProcess::addBeamA;
    using Pythia8::SigmaProcess::addBeamB;
    using Pythia8::SigmaProcess::sizeBeamA;
    using Pythia8::SigmaProcess::sizeBeamB;
    using Pythia8::SigmaProcess::inPair;
    using Pythia8::SigmaProcess::addPair;
    using Pythia8::SigmaProcess::sizePair;
    using Pythia8::SigmaProcess::mH;
    using Pythia8::SigmaProcess::sH;
    using Pythia8::SigmaProcess::sH2;
    using Pythia8::SigmaProcess::Q2RenSave;
    using Pythia8::SigmaProcess::alpEM;
    using Pythia8::SigmaProcess::alpS;
    using Pythia8::SigmaProcess::Q2FacSave;
    using Pythia8::SigmaProcess::x1Save;
    using Pythia8::SigmaProcess::x2Save;
    using Pythia8::SigmaProcess::pdf1Save;
    using Pythia8::SigmaProcess::pdf2Save;
    using Pythia8::SigmaProcess::sigmaSumSave;
    using Pythia8::SigmaProcess::id1;
    using Pythia8::SigmaProcess::id2;
    using Pythia8::SigmaProcess::id3;
    using Pythia8::SigmaProcess::id4;
    using Pythia8::SigmaProcess::id5;
    using Pythia8::SigmaProcess::idSave;
    using Pythia8::SigmaProcess::colSave;
    using Pythia8::SigmaProcess::acolSave;
    using Pythia8::SigmaProcess::mSave;
    using Pythia8::SigmaProcess::cosTheta;
    using Pythia8::SigmaProcess::sinTheta;
    using Pythia8::SigmaProcess::phi;
    using Pythia8::SigmaProcess::sHMass;
    using Pythia8::SigmaProcess::sHBeta;
    using Pythia8::SigmaProcess::pT2Mass;
    using Pythia8::SigmaProcess::pTFin;
    using Pythia8::SigmaProcess::parton;
    using Pythia8::SigmaProcess::partonT;
    using Pythia8::SigmaProcess::mSaveT;
    using Pythia8::SigmaProcess::pTFinT;
    using Pythia8::SigmaProcess::cosThetaT;
    using Pythia8::SigmaProcess::sinThetaT;
    using Pythia8::SigmaProcess::phiT;
    using Pythia8::SigmaProcess::setupForMEin;
    using Pythia8::SigmaProcess::mME;
    using Pythia8::SigmaProcess::pME;
    using Pythia8::SigmaProcess::swapTU;
    using Pythia8::SigmaProcess::setId;
    using Pythia8::SigmaProcess::setColAcol;
    using Pythia8::SigmaProcess::swapColAcol;
    using Pythia8::SigmaProcess::swapCol1234;
    using Pythia8::SigmaProcess::swapCol12;
    using Pythia8::SigmaProcess::swapCol34;
    using Pythia8::SigmaProcess::weightTopDecay;
    using Pythia8::SigmaProcess::weightHiggsDecay;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class SigmaProcess doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[58];
#endif

};


class SwigDirector_UserHooks : public Pythia8::UserHooks, public Swig::Director {

public:
    SwigDirector_UserHooks(PyObject *self);
    virtual ~SwigDirector_UserHooks();
    virtual bool initAfterBeams();
    virtual bool canModifySigma();
    virtual double multiplySigmaBy(Pythia8::SigmaProcess const *sigmaProcessPtr, Pythia8::PhaseSpace const *phaseSpacePtr, bool inEvent);
    virtual bool canBiasSelection();
    virtual double biasSelectionBy(Pythia8::SigmaProcess const *sigmaProcessPtr, Pythia8::PhaseSpace const *phaseSpacePtr, bool inEvent);
    virtual double biasedSelectionWeight();
    virtual bool canVetoProcessLevel();
    virtual bool doVetoProcessLevel(Pythia8::Event &arg0);
    virtual bool canVetoResonanceDecays();
    virtual bool doVetoResonanceDecays(Pythia8::Event &arg0);
    virtual bool canVetoPT();
    virtual double scaleVetoPT();
    virtual bool doVetoPT(int arg0, Pythia8::Event const &arg1);
    virtual bool canVetoStep();
    virtual int numberVetoStep();
    virtual bool doVetoStep(int arg0, int arg1, int arg2, Pythia8::Event const &arg3);
    virtual bool canVetoMPIStep();
    virtual int numberVetoMPIStep();
    virtual bool doVetoMPIStep(int arg0, Pythia8::Event const &arg1);
    virtual bool canVetoPartonLevelEarly();
    virtual bool doVetoPartonLevelEarly(Pythia8::Event const &arg0);
    virtual bool retryPartonLevel();
    virtual bool canVetoPartonLevel();
    virtual bool doVetoPartonLevel(Pythia8::Event const &arg0);
    virtual bool canSetResonanceScale();
    virtual double scaleResonance(int arg0, Pythia8::Event const &arg1);
    virtual bool canVetoISREmission();
    virtual bool doVetoISREmission(int arg0, Pythia8::Event const &arg1, int arg2);
    virtual bool canVetoFSREmission();
    virtual bool doVetoFSREmission(int arg0, Pythia8::Event const &arg1, int arg2, bool arg3 = false);
    virtual bool canVetoMPIEmission();
    virtual bool doVetoMPIEmission(int arg0, Pythia8::Event const &arg1);
    virtual bool canReconnectResonanceSystems();
    virtual bool doReconnectResonanceSystems(int arg0, Pythia8::Event &arg1);
    virtual bool canEnhanceEmission();
    virtual double enhanceFactor(std::string arg0);
    virtual double vetoProbability(std::string arg0);
    virtual bool canEnhanceTrial();
    virtual bool canChangeFragPar();
    virtual void setStringEnds(Pythia8::StringEnd const *arg0, Pythia8::StringEnd const *arg1, std::vector< int,std::allocator< int > > arg2);
    virtual bool doChangeFragPar(Pythia8::StringFlav *arg0, Pythia8::StringZ *arg1, Pythia8::StringPT *arg2, int arg3, double arg4, std::vector< int,std::allocator< int > > arg5, Pythia8::StringEnd const *arg6);
    virtual bool doVetoFragmentation(Pythia8::Particle arg0, Pythia8::StringEnd const *arg1);
    virtual bool doVetoFragmentation(Pythia8::Particle arg0, Pythia8::Particle arg1, Pythia8::StringEnd const *arg2, Pythia8::StringEnd const *arg3);
    virtual bool canSetImpactParameter() const;
    virtual double doSetImpactParameter();
    using Pythia8::UserHooks::infoPtr;
    using Pythia8::UserHooks::settingsPtr;
    using Pythia8::UserHooks::particleDataPtr;
    using Pythia8::UserHooks::rndmPtr;
    using Pythia8::UserHooks::beamAPtr;
    using Pythia8::UserHooks::beamBPtr;
    using Pythia8::UserHooks::beamPomAPtr;
    using Pythia8::UserHooks::beamPomBPtr;
    using Pythia8::UserHooks::coupSMPtr;
    using Pythia8::UserHooks::partonSystemsPtr;
    using Pythia8::UserHooks::sigmaTotPtr;
    using Pythia8::UserHooks::omitResonanceDecays;
    using Pythia8::UserHooks::subEvent;
    using Pythia8::UserHooks::workEvent;
    using Pythia8::UserHooks::selBias;
    using Pythia8::UserHooks::enhancedEventWeight;
    using Pythia8::UserHooks::pTEnhanced;
    using Pythia8::UserHooks::wtEnhanced;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class UserHooks doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[46];
#endif

};


class SwigDirector_PhaseSpace : public Pythia8::PhaseSpace, public Swig::Director {

public:
    SwigDirector_PhaseSpace(PyObject *self);
    virtual ~SwigDirector_PhaseSpace();
    virtual bool setupSampling();
    virtual bool trialKin(bool inEvent = true, bool repeatSame = false);
    virtual bool finalKin();
    virtual double sigmaSumSigned() const;
    virtual bool isResolved() const;
    virtual void rescaleSigma(double arg0);
    virtual void rescaleMomenta(double arg0);
    virtual double weightGammaPDFApprox();
    virtual void setGammaKinPtr(Pythia8::GammaKinematics *gammaKinPtrIn);
    using Pythia8::PhaseSpace::NMAXTRY;
    using Pythia8::PhaseSpace::NTRY3BODY;
    using Pythia8::PhaseSpace::SAFETYMARGIN;
    using Pythia8::PhaseSpace::TINY;
    using Pythia8::PhaseSpace::EVENFRAC;
    using Pythia8::PhaseSpace::SAMESIGMA;
    using Pythia8::PhaseSpace::MRESMINABS;
    using Pythia8::PhaseSpace::WIDTHMARGIN;
    using Pythia8::PhaseSpace::SAMEMASS;
    using Pythia8::PhaseSpace::MASSMARGIN;
    using Pythia8::PhaseSpace::EXTRABWWTMAX;
    using Pythia8::PhaseSpace::THRESHOLDSIZE;
    using Pythia8::PhaseSpace::THRESHOLDSTEP;
    using Pythia8::PhaseSpace::YRANGEMARGIN;
    using Pythia8::PhaseSpace::LEPTONXMIN;
    using Pythia8::PhaseSpace::LEPTONXMAX;
    using Pythia8::PhaseSpace::LEPTONXLOGMIN;
    using Pythia8::PhaseSpace::LEPTONXLOGMAX;
    using Pythia8::PhaseSpace::LEPTONTAUMIN;
    using Pythia8::PhaseSpace::SHATMINZ;
    using Pythia8::PhaseSpace::PT2RATMINZ;
    using Pythia8::PhaseSpace::WTCORRECTION;
    using Pythia8::PhaseSpace::sigmaProcessPtr;
    using Pythia8::PhaseSpace::infoPtr;
    using Pythia8::PhaseSpace::settingsPtr;
    using Pythia8::PhaseSpace::particleDataPtr;
    using Pythia8::PhaseSpace::rndmPtr;
    using Pythia8::PhaseSpace::beamAPtr;
    using Pythia8::PhaseSpace::beamBPtr;
    using Pythia8::PhaseSpace::couplingsPtr;
    using Pythia8::PhaseSpace::sigmaTotPtr;
    using Pythia8::PhaseSpace::userHooksPtr;
    using Pythia8::PhaseSpace::lhaUpPtr;
    using Pythia8::PhaseSpace::gammaKinPtr;
    using Pythia8::PhaseSpace::useBreitWigners;
    using Pythia8::PhaseSpace::doEnergySpread;
    using Pythia8::PhaseSpace::showSearch;
    using Pythia8::PhaseSpace::showViolation;
    using Pythia8::PhaseSpace::increaseMaximum;
    using Pythia8::PhaseSpace::hasQ2Min;
    using Pythia8::PhaseSpace::gmZmodeGlobal;
    using Pythia8::PhaseSpace::mHatGlobalMin;
    using Pythia8::PhaseSpace::mHatGlobalMax;
    using Pythia8::PhaseSpace::pTHatGlobalMin;
    using Pythia8::PhaseSpace::pTHatGlobalMax;
    using Pythia8::PhaseSpace::Q2GlobalMin;
    using Pythia8::PhaseSpace::pTHatMinDiverge;
    using Pythia8::PhaseSpace::minWidthBreitWigners;
    using Pythia8::PhaseSpace::minWidthNarrowBW;
    using Pythia8::PhaseSpace::idA;
    using Pythia8::PhaseSpace::idB;
    using Pythia8::PhaseSpace::idAgm;
    using Pythia8::PhaseSpace::idBgm;
    using Pythia8::PhaseSpace::mA;
    using Pythia8::PhaseSpace::mB;
    using Pythia8::PhaseSpace::eCM;
    using Pythia8::PhaseSpace::s;
    using Pythia8::PhaseSpace::sigmaMxGm;
    using Pythia8::PhaseSpace::hasLeptonBeamA;
    using Pythia8::PhaseSpace::hasLeptonBeamB;
    using Pythia8::PhaseSpace::hasOneLeptonBeam;
    using Pythia8::PhaseSpace::hasTwoLeptonBeams;
    using Pythia8::PhaseSpace::hasPointGammaA;
    using Pythia8::PhaseSpace::hasPointGammaB;
    using Pythia8::PhaseSpace::hasOnePointParticle;
    using Pythia8::PhaseSpace::hasTwoPointParticles;
    using Pythia8::PhaseSpace::hasGamma;
    using Pythia8::PhaseSpace::hasVMD;
    using Pythia8::PhaseSpace::newSigmaMx;
    using Pythia8::PhaseSpace::canModifySigma;
    using Pythia8::PhaseSpace::canBiasSelection;
    using Pythia8::PhaseSpace::canBias2Sel;
    using Pythia8::PhaseSpace::gmZmode;
    using Pythia8::PhaseSpace::bias2SelPow;
    using Pythia8::PhaseSpace::bias2SelRef;
    using Pythia8::PhaseSpace::wtBW;
    using Pythia8::PhaseSpace::sigmaNw;
    using Pythia8::PhaseSpace::sigmaMx;
    using Pythia8::PhaseSpace::sigmaPos;
    using Pythia8::PhaseSpace::sigmaNeg;
    using Pythia8::PhaseSpace::biasWt;
    using Pythia8::PhaseSpace::mHatMin;
    using Pythia8::PhaseSpace::mHatMax;
    using Pythia8::PhaseSpace::sHatMin;
    using Pythia8::PhaseSpace::sHatMax;
    using Pythia8::PhaseSpace::pTHatMin;
    using Pythia8::PhaseSpace::pTHatMax;
    using Pythia8::PhaseSpace::pT2HatMin;
    using Pythia8::PhaseSpace::pT2HatMax;
    using Pythia8::PhaseSpace::x1H;
    using Pythia8::PhaseSpace::x2H;
    using Pythia8::PhaseSpace::m3;
    using Pythia8::PhaseSpace::m4;
    using Pythia8::PhaseSpace::m5;
    using Pythia8::PhaseSpace::s3;
    using Pythia8::PhaseSpace::s4;
    using Pythia8::PhaseSpace::s5;
    using Pythia8::PhaseSpace::mHat;
    using Pythia8::PhaseSpace::sH;
    using Pythia8::PhaseSpace::tH;
    using Pythia8::PhaseSpace::uH;
    using Pythia8::PhaseSpace::pAbs;
    using Pythia8::PhaseSpace::p2Abs;
    using Pythia8::PhaseSpace::pTH;
    using Pythia8::PhaseSpace::theta;
    using Pythia8::PhaseSpace::phi;
    using Pythia8::PhaseSpace::betaZ;
    using Pythia8::PhaseSpace::pH;
    using Pythia8::PhaseSpace::mH;
    using Pythia8::PhaseSpace::decayKinematicsStep;
    using Pythia8::PhaseSpace::setup3Body;
    using Pythia8::PhaseSpace::setupSampling123;
    using Pythia8::PhaseSpace::trialKin123;
    using Pythia8::PhaseSpace::idResA;
    using Pythia8::PhaseSpace::idResB;
    using Pythia8::PhaseSpace::mResA;
    using Pythia8::PhaseSpace::mResB;
    using Pythia8::PhaseSpace::GammaResA;
    using Pythia8::PhaseSpace::GammaResB;
    using Pythia8::PhaseSpace::tauResA;
    using Pythia8::PhaseSpace::tauResB;
    using Pythia8::PhaseSpace::widResA;
    using Pythia8::PhaseSpace::widResB;
    using Pythia8::PhaseSpace::sameResMass;
    using Pythia8::PhaseSpace::useMirrorWeight;
    using Pythia8::PhaseSpace::hasNegZ;
    using Pythia8::PhaseSpace::hasPosZ;
    using Pythia8::PhaseSpace::tau;
    using Pythia8::PhaseSpace::y;
    using Pythia8::PhaseSpace::z;
    using Pythia8::PhaseSpace::tauMin;
    using Pythia8::PhaseSpace::tauMax;
    using Pythia8::PhaseSpace::yMax;
    using Pythia8::PhaseSpace::zMin;
    using Pythia8::PhaseSpace::zMax;
    using Pythia8::PhaseSpace::ratio34;
    using Pythia8::PhaseSpace::unity34;
    using Pythia8::PhaseSpace::zNeg;
    using Pythia8::PhaseSpace::zPos;
    using Pythia8::PhaseSpace::wtTau;
    using Pythia8::PhaseSpace::wtY;
    using Pythia8::PhaseSpace::wtZ;
    using Pythia8::PhaseSpace::wt3Body;
    using Pythia8::PhaseSpace::runBW3H;
    using Pythia8::PhaseSpace::runBW4H;
    using Pythia8::PhaseSpace::runBW5H;
    using Pythia8::PhaseSpace::intTau0;
    using Pythia8::PhaseSpace::intTau1;
    using Pythia8::PhaseSpace::intTau2;
    using Pythia8::PhaseSpace::intTau3;
    using Pythia8::PhaseSpace::intTau4;
    using Pythia8::PhaseSpace::intTau5;
    using Pythia8::PhaseSpace::intTau6;
    using Pythia8::PhaseSpace::intY0;
    using Pythia8::PhaseSpace::intY12;
    using Pythia8::PhaseSpace::intY34;
    using Pythia8::PhaseSpace::intY56;
    using Pythia8::PhaseSpace::mTchan1;
    using Pythia8::PhaseSpace::sTchan1;
    using Pythia8::PhaseSpace::mTchan2;
    using Pythia8::PhaseSpace::sTchan2;
    using Pythia8::PhaseSpace::frac3Flat;
    using Pythia8::PhaseSpace::frac3Pow1;
    using Pythia8::PhaseSpace::frac3Pow2;
    using Pythia8::PhaseSpace::zNegMin;
    using Pythia8::PhaseSpace::zNegMax;
    using Pythia8::PhaseSpace::zPosMin;
    using Pythia8::PhaseSpace::zPosMax;
    using Pythia8::PhaseSpace::p3cm;
    using Pythia8::PhaseSpace::p4cm;
    using Pythia8::PhaseSpace::p5cm;
    using Pythia8::PhaseSpace::nTau;
    using Pythia8::PhaseSpace::nY;
    using Pythia8::PhaseSpace::nZ;
    using Pythia8::PhaseSpace::tauCoef;
    using Pythia8::PhaseSpace::yCoef;
    using Pythia8::PhaseSpace::zCoef;
    using Pythia8::PhaseSpace::tauCoefSum;
    using Pythia8::PhaseSpace::yCoefSum;
    using Pythia8::PhaseSpace::zCoefSum;
    using Pythia8::PhaseSpace::limitTau;
    using Pythia8::PhaseSpace::limitY;
    using Pythia8::PhaseSpace::limitZ;
    using Pythia8::PhaseSpace::selectTau;
    using Pythia8::PhaseSpace::selectY;
    using Pythia8::PhaseSpace::selectZ;
    using Pythia8::PhaseSpace::select3Body;
    using Pythia8::PhaseSpace::solveSys;
    using Pythia8::PhaseSpace::useBW;
    using Pythia8::PhaseSpace::useNarrowBW;
    using Pythia8::PhaseSpace::idMass;
    using Pythia8::PhaseSpace::mPeak;
    using Pythia8::PhaseSpace::sPeak;
    using Pythia8::PhaseSpace::mWidth;
    using Pythia8::PhaseSpace::mMin;
    using Pythia8::PhaseSpace::mMax;
    using Pythia8::PhaseSpace::mw;
    using Pythia8::PhaseSpace::wmRat;
    using Pythia8::PhaseSpace::mLower;
    using Pythia8::PhaseSpace::mUpper;
    using Pythia8::PhaseSpace::sLower;
    using Pythia8::PhaseSpace::sUpper;
    using Pythia8::PhaseSpace::fracFlatS;
    using Pythia8::PhaseSpace::fracFlatM;
    using Pythia8::PhaseSpace::fracInv;
    using Pythia8::PhaseSpace::fracInv2;
    using Pythia8::PhaseSpace::atanLower;
    using Pythia8::PhaseSpace::atanUpper;
    using Pythia8::PhaseSpace::intBW;
    using Pythia8::PhaseSpace::intFlatS;
    using Pythia8::PhaseSpace::intFlatM;
    using Pythia8::PhaseSpace::intInv;
    using Pythia8::PhaseSpace::intInv2;
    using Pythia8::PhaseSpace::setupMass1;
    using Pythia8::PhaseSpace::setupMass2;
    using Pythia8::PhaseSpace::trialMass;
    using Pythia8::PhaseSpace::weightMass;
    using Pythia8::PhaseSpace::tRange;
    using Pythia8::PhaseSpace::tInRange;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class PhaseSpace doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[11];
#endif

};


class SwigDirector_SpaceShower : public Pythia8::SpaceShower, public Swig::Director {

public:
    SwigDirector_SpaceShower(PyObject *self);
    virtual ~SwigDirector_SpaceShower();
    virtual void init(Pythia8::BeamParticle *arg0, Pythia8::BeamParticle *arg1);
    virtual bool limitPTmax(Pythia8::Event &arg0, double arg1 = 0., double arg2 = 0.);
    virtual void prepare(int arg0, Pythia8::Event &arg1, bool arg2 = true);
    virtual void update(int arg0, Pythia8::Event &arg1, bool arg2 = false);
    virtual double pTnext(Pythia8::Event &arg0, double arg1, double arg2, int arg3 = -1, bool arg4 = false);
    virtual bool branch(Pythia8::Event &arg0);
    virtual bool initUncertainties();
    virtual bool doRestart() const;
    virtual bool wasGamma2qqbar();
    virtual bool getHasWeaklyRadiated();
    virtual int system() const;
    virtual double enhancePTmax() const;
    virtual Pythia8::Event clustered(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > getStateVariables(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual bool isSpacelike(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual std::vector< std::string,std::allocator< std::string > > getSplittingName(Pythia8::Event const &arg0, int arg1, int arg2, int arg3);
    virtual double getSplittingProb(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual bool allowedSplitting(Pythia8::Event const &arg0, int arg1, int arg2);
    virtual std::vector< int,std::allocator< int > > getRecoilers(Pythia8::Event const &arg0, int arg1, int arg2, std::string arg3);
    using Pythia8::SpaceShower::infoPtr;
    using Pythia8::SpaceShower::settingsPtr;
    using Pythia8::SpaceShower::particleDataPtr;
    using Pythia8::SpaceShower::rndmPtr;
    using Pythia8::SpaceShower::coupSMPtr;
    using Pythia8::SpaceShower::beamAPtr;
    using Pythia8::SpaceShower::beamBPtr;
    using Pythia8::SpaceShower::beamOffset;
    using Pythia8::SpaceShower::partonSystemsPtr;
    using Pythia8::SpaceShower::userHooksPtr;
    using Pythia8::SpaceShower::partonVertexPtr;
    using Pythia8::SpaceShower::doUncertainties;
    using Pythia8::SpaceShower::uVarMuSoftCorr;
    using Pythia8::SpaceShower::uVarMPIshowers;
    using Pythia8::SpaceShower::nUncertaintyVariations;
    using Pythia8::SpaceShower::nVarQCD;
    using Pythia8::SpaceShower::uVarNflavQ;
    using Pythia8::SpaceShower::dASmax;
    using Pythia8::SpaceShower::cNSpTmin;
    using Pythia8::SpaceShower::uVarpTmin2;
    using Pythia8::SpaceShower::overFactor;
    using Pythia8::SpaceShower::varG2GGmuRfac;
    using Pythia8::SpaceShower::varQ2QGmuRfac;
    using Pythia8::SpaceShower::varQ2GQmuRfac;
    using Pythia8::SpaceShower::varG2QQmuRfac;
    using Pythia8::SpaceShower::varX2XGmuRfac;
    using Pythia8::SpaceShower::varG2GGcNS;
    using Pythia8::SpaceShower::varQ2QGcNS;
    using Pythia8::SpaceShower::varQ2GQcNS;
    using Pythia8::SpaceShower::varG2QQcNS;
    using Pythia8::SpaceShower::varX2XGcNS;
    using Pythia8::SpaceShower::varPDFplus;
    using Pythia8::SpaceShower::varPDFminus;
    using Pythia8::SpaceShower::varPDFmember;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class SpaceShower doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[25];
#endif

};


class SwigDirector_TimeShower : public Pythia8::TimeShower, public Swig::Director {

public:
    SwigDirector_TimeShower(PyObject *self);
    virtual ~SwigDirector_TimeShower();
    virtual void init(Pythia8::BeamParticle *arg0 = 0, Pythia8::BeamParticle *arg1 = 0);
    virtual bool limitPTmax(Pythia8::Event &arg0, double arg1 = 0., double arg2 = 0.);
    virtual int shower(int arg0, int arg1, Pythia8::Event &arg2, double arg3, int arg4 = 0);
    virtual int showerQED(int arg0, int arg1, Pythia8::Event &arg2, double arg3);
    virtual int showerQEDafterRemnants(Pythia8::Event &arg0);
    virtual void prepareGlobal(Pythia8::Event &arg0);
    virtual void prepare(int arg0, Pythia8::Event &arg1, bool arg2 = true);
    virtual void rescatterUpdate(int arg0, Pythia8::Event &arg1);
    virtual void update(int arg0, Pythia8::Event &arg1, bool arg2 = false);
    virtual double pTnext(Pythia8::Event &arg0, double arg1, double arg2, bool arg3 = false, bool arg4 = false);
    virtual bool branch(Pythia8::Event &arg0, bool arg1 = false);
    virtual bool initUncertainties();
    virtual bool getHasWeaklyRadiated();
    virtual int system() const;
    virtual double enhancePTmax();
    virtual double pTLastInShower();
    virtual Pythia8::Event clustered(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > getStateVariables(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual bool isTimelike(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual std::vector< std::string,std::allocator< std::string > > getSplittingName(Pythia8::Event const &arg0, int arg1, int arg2, int arg3);
    virtual double getSplittingProb(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4);
    virtual bool allowedSplitting(Pythia8::Event const &arg0, int arg1, int arg2);
    virtual std::vector< int,std::allocator< int > > getRecoilers(Pythia8::Event const &arg0, int arg1, int arg2, std::string arg3);
    using Pythia8::TimeShower::infoPtr;
    using Pythia8::TimeShower::settingsPtr;
    using Pythia8::TimeShower::particleDataPtr;
    using Pythia8::TimeShower::rndmPtr;
    using Pythia8::TimeShower::coupSMPtr;
    using Pythia8::TimeShower::beamAPtr;
    using Pythia8::TimeShower::beamBPtr;
    using Pythia8::TimeShower::beamOffset;
    using Pythia8::TimeShower::partonSystemsPtr;
    using Pythia8::TimeShower::userHooksPtr;
    using Pythia8::TimeShower::partonVertexPtr;
    using Pythia8::TimeShower::doUncertainties;
    using Pythia8::TimeShower::uVarMuSoftCorr;
    using Pythia8::TimeShower::uVarMPIshowers;
    using Pythia8::TimeShower::noResVariations;
    using Pythia8::TimeShower::noProcVariations;
    using Pythia8::TimeShower::nUncertaintyVariations;
    using Pythia8::TimeShower::nVarQCD;
    using Pythia8::TimeShower::uVarNflavQ;
    using Pythia8::TimeShower::dASmax;
    using Pythia8::TimeShower::cNSpTmin;
    using Pythia8::TimeShower::uVarpTmin2;
    using Pythia8::TimeShower::overFactor;
    using Pythia8::TimeShower::varG2GGmuRfac;
    using Pythia8::TimeShower::varQ2QGmuRfac;
    using Pythia8::TimeShower::varG2QQmuRfac;
    using Pythia8::TimeShower::varX2XGmuRfac;
    using Pythia8::TimeShower::varG2GGcNS;
    using Pythia8::TimeShower::varQ2QGcNS;
    using Pythia8::TimeShower::varG2QQcNS;
    using Pythia8::TimeShower::varX2XGcNS;
    using Pythia8::TimeShower::varPDFplus;
    using Pythia8::TimeShower::varPDFminus;
    using Pythia8::TimeShower::varPDFmember;

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class TimeShower doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[33];
#endif

};


class SwigDirector_DecayHandler : public Pythia8::DecayHandler, public Swig::Director {

public:
    SwigDirector_DecayHandler(PyObject *self);
    virtual ~SwigDirector_DecayHandler();
    virtual bool decay(std::vector< int,std::allocator< int > > &arg0, std::vector< double,std::allocator< double > > &arg1, std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > &arg2, int arg3, Pythia8::Event const &arg4);
    virtual bool chainDecay(std::vector< int,std::allocator< int > > &arg0, std::vector< int,std::allocator< int > > &arg1, std::vector< double,std::allocator< double > > &arg2, std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > &arg3, int arg4, Pythia8::Event const &arg5);

/* Internal director utilities */
public:
    bool swig_get_inner(const char *swig_protected_method_name) const {
      std::map<std::string, bool>::const_iterator iv = swig_inner.find(swig_protected_method_name);
      return (iv != swig_inner.end() ? iv->second : false);
    }
    void swig_set_inner(const char *swig_protected_method_name, bool swig_val) const {
      swig_inner[swig_protected_method_name] = swig_val;
    }
private:
    mutable std::map<std::string, bool> swig_inner;

#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
/* VTable implementation */
    PyObject *swig_get_method(size_t method_index, const char *method_name) const {
      PyObject *method = vtable[method_index];
      if (!method) {
        swig::SwigVar_PyObject name = SWIG_Python_str_FromChar(method_name);
        method = PyObject_GetAttr(swig_get_self(), name);
        if (!method) {
          std::string msg = "Method in class DecayHandler doesn't exist, undefined ";
          msg += method_name;
          Swig::DirectorMethodException::raise(msg.c_str());
        }
        vtable[method_index] = method;
      }
      return method;
    }
private:
    mutable swig::SwigVar_PyObject vtable[2];
#endif

};


#endif

SwigDirector_RndmEngine::SwigDirector_RndmEngine(PyObject *self): Pythia8::RndmEngine(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::RndmEngine *)this, this); 
}




SwigDirector_RndmEngine::~SwigDirector_RndmEngine() {
}

double SwigDirector_RndmEngine::flat() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call RndmEngine.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "flat";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "flat", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'RndmEngine.flat'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


SwigDirector_BeamShape::SwigDirector_BeamShape(PyObject *self): Pythia8::BeamShape(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::BeamShape *)this, this); 
}




SwigDirector_BeamShape::~SwigDirector_BeamShape() {
}

void SwigDirector_BeamShape::init(Pythia8::Settings &settings, Pythia8::Rndm *rndmPtrIn) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&settings), SWIGTYPE_p_Pythia8__Settings,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(rndmPtrIn), SWIGTYPE_p_Pythia8__Rndm,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call BeamShape.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "init";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"init", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'BeamShape.init'");
    }
  }
}


void SwigDirector_BeamShape::pick() {
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call BeamShape.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "pick";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "pick", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'BeamShape.pick'");
    }
  }
}


SwigDirector_PDF::SwigDirector_PDF(PyObject *self, int idBeamIn): Pythia8::PDF(idBeamIn), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::PDF *)this, this); 
}




SwigDirector_PDF::~SwigDirector_PDF() {
}

bool SwigDirector_PDF::isSetup() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "isSetup";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isSetup", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.isSetup'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


void SwigDirector_PDF::newValenceContent(int idVal1In, int idVal2In) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(idVal1In));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(idVal2In));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "newValenceContent";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"newValenceContent", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.newValenceContent'");
    }
  }
}


void SwigDirector_PDF::setExtrapolate(bool arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_bool(static_cast< bool >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 2;
  const char * const swig_method_name = "setExtrapolate";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"setExtrapolate", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.setExtrapolate'");
    }
  }
}


double SwigDirector_PDF::xf(int id, double x, double Q2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(id));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(x));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(Q2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 3;
  const char * const swig_method_name = "xf";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xf", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xf'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::xfVal(int id, double x, double Q2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(id));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(x));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(Q2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "xfVal";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfVal", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfVal'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::xfSea(int id, double x, double Q2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(id));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(x));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(Q2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 5;
  const char * const swig_method_name = "xfSea";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfSea", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfSea'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_PDF::insideBounds(double arg0, double arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "insideBounds";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"insideBounds", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.insideBounds'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_PDF::alphaS(double arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 7;
  const char * const swig_method_name = "alphaS";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"alphaS", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.alphaS'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::mQuarkPDF(int arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "mQuarkPDF";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"mQuarkPDF", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.mQuarkPDF'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


int SwigDirector_PDF::nMembers() {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 9;
  const char * const swig_method_name = "nMembers";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "nMembers", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.nMembers'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


void SwigDirector_PDF::calcPDFEnvelope(int arg0, double arg1, double arg2, int arg3) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 10;
  const char * const swig_method_name = "calcPDFEnvelope";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"calcPDFEnvelope", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.calcPDFEnvelope'");
    }
  }
}


void SwigDirector_PDF::calcPDFEnvelope(std::pair< int,int > arg0, std::pair< double,double > arg1, double arg2, int arg3) {
  swig::SwigVar_PyObject obj0;
  obj0 = swig::from(static_cast< std::pair< int,int > >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_std__pairT_double_double_t,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 11;
  const char * const swig_method_name = "calcPDFEnvelope";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"calcPDFEnvelope", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.calcPDFEnvelope'");
    }
  }
}


Pythia8::PDF::PDFEnvelope SwigDirector_PDF::getPDFEnvelope() {
  void *swig_argp ;
  int swig_res = 0 ;
  
  Pythia8::PDF::PDFEnvelope c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 12;
  const char * const swig_method_name = "getPDFEnvelope";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "getPDFEnvelope", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.getPDFEnvelope'");
    }
  }
  swig_res = SWIG_ConvertPtr(result,&swig_argp,SWIGTYPE_p_Pythia8__PDF__PDFEnvelope,  0  | 0);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""Pythia8::PDF::PDFEnvelope""'");
  }
  c_result = *(reinterpret_cast< Pythia8::PDF::PDFEnvelope * >(swig_argp));
  if (SWIG_IsNewObj(swig_res)) delete reinterpret_cast< Pythia8::PDF::PDFEnvelope * >(swig_argp);
  return (Pythia8::PDF::PDFEnvelope) c_result;
}


double SwigDirector_PDF::gammaPDFxDependence(int arg0, double arg1) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 13;
  const char * const swig_method_name = "gammaPDFxDependence";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"gammaPDFxDependence", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.gammaPDFxDependence'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::gammaPDFRefScale(int arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 14;
  const char * const swig_method_name = "gammaPDFRefScale";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"gammaPDFRefScale", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.gammaPDFRefScale'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


int SwigDirector_PDF::sampleGammaValFlavor(double arg0) {
  int c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 15;
  const char * const swig_method_name = "sampleGammaValFlavor";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"sampleGammaValFlavor", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.sampleGammaValFlavor'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


double SwigDirector_PDF::xfIntegratedTotal(double arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 16;
  const char * const swig_method_name = "xfIntegratedTotal";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfIntegratedTotal", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfIntegratedTotal'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::xGamma() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 17;
  const char * const swig_method_name = "xGamma";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "xGamma", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xGamma'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


void SwigDirector_PDF::xPom(double arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 18;
  const char * const swig_method_name = "xPom";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xPom", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xPom'");
    }
  }
}


double SwigDirector_PDF::xfFlux(int arg0, double arg1, double arg2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 20;
  const char * const swig_method_name = "xfFlux";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfFlux", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfFlux'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::xfApprox(int arg0, double arg1, double arg2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 21;
  const char * const swig_method_name = "xfApprox";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfApprox", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfApprox'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::xfGamma(int arg0, double arg1, double arg2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 22;
  const char * const swig_method_name = "xfGamma";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfGamma", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfGamma'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::intFluxApprox() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 23;
  const char * const swig_method_name = "intFluxApprox";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "intFluxApprox", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.intFluxApprox'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::getXmin() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 24;
  const char * const swig_method_name = "getXmin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "getXmin", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.getXmin'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::getXhadr() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 25;
  const char * const swig_method_name = "getXhadr";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "getXhadr", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.getXhadr'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::sampleXgamma(double arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 26;
  const char * const swig_method_name = "sampleXgamma";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"sampleXgamma", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.sampleXgamma'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::sampleQ2gamma(double arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 27;
  const char * const swig_method_name = "sampleQ2gamma";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"sampleQ2gamma", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.sampleQ2gamma'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::xfMax(int id, double x, double Q2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(id));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(x));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(Q2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 28;
  const char * const swig_method_name = "xfMax";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfMax", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfMax'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_PDF::xfSame(int id, double x, double Q2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(id));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(x));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(Q2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 29;
  const char * const swig_method_name = "xfSame";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfSame", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfSame'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


void SwigDirector_PDF::setVMDscale(double arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 30;
  const char * const swig_method_name = "setVMDscale";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"setVMDscale", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.setVMDscale'");
    }
  }
}


void SwigDirector_PDF::xfUpdate(int id, double x, double Q2) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(id));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(x));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(Q2));
  swig_set_inner("xfUpdate", true);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PDF.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 32;
  const char * const swig_method_name = "xfUpdate";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"xfUpdate", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  swig_set_inner("xfUpdate", false);
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PDF.xfUpdate'");
    }
  }
}


SwigDirector_ResonanceWidths::SwigDirector_ResonanceWidths(PyObject *self): Pythia8::ResonanceWidths(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::ResonanceWidths *)this, this); 
}




SwigDirector_ResonanceWidths::~SwigDirector_ResonanceWidths() {
}

bool SwigDirector_ResonanceWidths::init(Pythia8::Info *infoPtrIn, Pythia8::Settings *settingsPtrIn, Pythia8::ParticleData *particleDataPtrIn, Pythia8::Couplings *couplingsPtrIn) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(infoPtrIn), SWIGTYPE_p_Pythia8__Info,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(settingsPtrIn), SWIGTYPE_p_Pythia8__Settings,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(particleDataPtrIn), SWIGTYPE_p_Pythia8__ParticleData,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_NewPointerObj(SWIG_as_voidptr(couplingsPtrIn), SWIGTYPE_p_Pythia8__Couplings,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call ResonanceWidths.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "init";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"init", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'ResonanceWidths.init'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


void SwigDirector_ResonanceWidths::initConstants() {
  swig_set_inner("initConstants", true);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call ResonanceWidths.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "initConstants";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "initConstants", NULL);
#endif
  swig_set_inner("initConstants", false);
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'ResonanceWidths.initConstants'");
    }
  }
}


bool SwigDirector_ResonanceWidths::initBSM() {
  bool c_result;
  swig_set_inner("initBSM", true);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call ResonanceWidths.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 2;
  const char * const swig_method_name = "initBSM";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "initBSM", NULL);
#endif
  swig_set_inner("initBSM", false);
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'ResonanceWidths.initBSM'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_ResonanceWidths::allowCalc() {
  bool c_result;
  swig_set_inner("allowCalc", true);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call ResonanceWidths.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 3;
  const char * const swig_method_name = "allowCalc";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "allowCalc", NULL);
#endif
  swig_set_inner("allowCalc", false);
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'ResonanceWidths.allowCalc'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


void SwigDirector_ResonanceWidths::calcPreFac(bool arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_bool(static_cast< bool >(arg0));
  swig_set_inner("calcPreFac", true);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call ResonanceWidths.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "calcPreFac";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"calcPreFac", (char *)"(O)" ,(PyObject *)obj0);
#endif
  swig_set_inner("calcPreFac", false);
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'ResonanceWidths.calcPreFac'");
    }
  }
}


void SwigDirector_ResonanceWidths::calcWidth(bool arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_bool(static_cast< bool >(arg0));
  swig_set_inner("calcWidth", true);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call ResonanceWidths.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "calcWidth";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"calcWidth", (char *)"(O)" ,(PyObject *)obj0);
#endif
  swig_set_inner("calcWidth", false);
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'ResonanceWidths.calcWidth'");
    }
  }
}


SwigDirector_LHAup::SwigDirector_LHAup(PyObject *self, int strategyIn): Pythia8::LHAup(strategyIn), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::LHAup *)this, this); 
}




SwigDirector_LHAup::~SwigDirector_LHAup() {
}

void SwigDirector_LHAup::newEventFile(char const *arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_FromCharPtr((const char *)arg0);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "newEventFile";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"newEventFile", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.newEventFile'");
    }
  }
}


bool SwigDirector_LHAup::fileFound() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "fileFound";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "fileFound", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.fileFound'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_LHAup::useExternal() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 2;
  const char * const swig_method_name = "useExternal";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "useExternal", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.useExternal'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_LHAup::setInit() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 3;
  const char * const swig_method_name = "setInit";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "setInit", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.setInit'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_LHAup::setEvent(int idProcIn) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(idProcIn));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "setEvent";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"setEvent", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.setEvent'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_LHAup::skipEvent(int nSkip) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(nSkip));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "skipEvent";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"skipEvent", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.skipEvent'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_LHAup::openLHEF(std::string fileNameIn) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_std_string(static_cast< std::string >(fileNameIn));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 7;
  const char * const swig_method_name = "openLHEF";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"openLHEF", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.openLHEF'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_LHAup::closeLHEF(bool updateInit) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_bool(static_cast< bool >(updateInit));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call LHAup.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "closeLHEF";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"closeLHEF", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'LHAup.closeLHEF'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


SwigDirector_MergingHooks::SwigDirector_MergingHooks(PyObject *self): Pythia8::MergingHooks(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::MergingHooks *)this, this); 
}




SwigDirector_MergingHooks::~SwigDirector_MergingHooks() {
}

double SwigDirector_MergingHooks::tmsDefinition(Pythia8::Event const &event) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&event), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "tmsDefinition";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"tmsDefinition", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.tmsDefinition'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_MergingHooks::dampenIfFailCuts(Pythia8::Event const &inEvent) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&inEvent), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "dampenIfFailCuts";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"dampenIfFailCuts", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.dampenIfFailCuts'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_MergingHooks::canCutOnRecState() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 2;
  const char * const swig_method_name = "canCutOnRecState";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canCutOnRecState", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.canCutOnRecState'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::doCutOnRecState(Pythia8::Event const &event) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&event), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 3;
  const char * const swig_method_name = "doCutOnRecState";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doCutOnRecState", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.doCutOnRecState'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::canVetoTrialEmission() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "canVetoTrialEmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoTrialEmission", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.canVetoTrialEmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::doVetoTrialEmission(Pythia8::Event const &arg0, Pythia8::Event const &arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 5;
  const char * const swig_method_name = "doVetoTrialEmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoTrialEmission", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.doVetoTrialEmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_MergingHooks::hardProcessME(Pythia8::Event const &inEvent) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&inEvent), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "hardProcessME";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"hardProcessME", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.hardProcessME'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


void SwigDirector_MergingHooks::init() {
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 7;
  const char * const swig_method_name = "init";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "init", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.init'");
    }
  }
}


int SwigDirector_MergingHooks::getNumberOfClusteringSteps(Pythia8::Event const &event, bool resetNjetMax) {
  int c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&event), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_bool(static_cast< bool >(resetNjetMax));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "getNumberOfClusteringSteps";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getNumberOfClusteringSteps", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.getNumberOfClusteringSteps'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


double SwigDirector_MergingHooks::tmsNow(Pythia8::Event const &event) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&event), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 10;
  const char * const swig_method_name = "tmsNow";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"tmsNow", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.tmsNow'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_MergingHooks::canVetoEmission() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 11;
  const char * const swig_method_name = "canVetoEmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoEmission", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.canVetoEmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::doVetoEmission(Pythia8::Event const &arg0) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 12;
  const char * const swig_method_name = "doVetoEmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoEmission", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.doVetoEmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::useShowerPlugin() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 13;
  const char * const swig_method_name = "useShowerPlugin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "useShowerPlugin", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.useShowerPlugin'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::canVetoStep() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 14;
  const char * const swig_method_name = "canVetoStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoStep", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.canVetoStep'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::doVetoStep(Pythia8::Event const &process, Pythia8::Event const &event, bool doResonance) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&process), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&event), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(doResonance));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 15;
  const char * const swig_method_name = "doVetoStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoStep", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.doVetoStep'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_MergingHooks::setShowerStartingScales(bool isTrial, bool doMergeFirstEmm, double &pTscaleIn, Pythia8::Event const &event, double &pTmaxFSRIn, bool &limitPTmaxFSRin, double &pTmaxISRIn, bool &limitPTmaxISRin, double &pTmaxMPIIn, bool &limitPTmaxMPIin) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_bool(static_cast< bool >(isTrial));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_bool(static_cast< bool >(doMergeFirstEmm));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(&pTscaleIn), SWIGTYPE_p_double,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_NewPointerObj(SWIG_as_voidptr(&event), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_NewPointerObj(SWIG_as_voidptr(&pTmaxFSRIn), SWIGTYPE_p_double,  0 );
  swig::SwigVar_PyObject obj5;
  obj5 = SWIG_NewPointerObj(SWIG_as_voidptr(&limitPTmaxFSRin), SWIGTYPE_p_bool,  0 );
  swig::SwigVar_PyObject obj6;
  obj6 = SWIG_NewPointerObj(SWIG_as_voidptr(&pTmaxISRIn), SWIGTYPE_p_double,  0 );
  swig::SwigVar_PyObject obj7;
  obj7 = SWIG_NewPointerObj(SWIG_as_voidptr(&limitPTmaxISRin), SWIGTYPE_p_bool,  0 );
  swig::SwigVar_PyObject obj8;
  obj8 = SWIG_NewPointerObj(SWIG_as_voidptr(&pTmaxMPIIn), SWIGTYPE_p_double,  0 );
  swig::SwigVar_PyObject obj9;
  obj9 = SWIG_NewPointerObj(SWIG_as_voidptr(&limitPTmaxMPIin), SWIGTYPE_p_bool,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call MergingHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 17;
  const char * const swig_method_name = "setShowerStartingScales";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7,(PyObject *)obj8,(PyObject *)obj9);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"setShowerStartingScales", (char *)"(OOOOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7,(PyObject *)obj8,(PyObject *)obj9);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'MergingHooks.setShowerStartingScales'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


SwigDirector_SigmaProcess::SwigDirector_SigmaProcess(PyObject *self): Pythia8::SigmaProcess(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::SigmaProcess *)this, this); 
}




SwigDirector_SigmaProcess::~SwigDirector_SigmaProcess() {
}

void SwigDirector_SigmaProcess::initProc() {
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "initProc";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "initProc", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.initProc'");
    }
  }
}


bool SwigDirector_SigmaProcess::initFlux() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "initFlux";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "initFlux", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.initFlux'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


void SwigDirector_SigmaProcess::set1Kin(double arg0, double arg1, double arg2) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 2;
  const char * const swig_method_name = "set1Kin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"set1Kin", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.set1Kin'");
    }
  }
}


void SwigDirector_SigmaProcess::set2Kin(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_double(static_cast< double >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_double(static_cast< double >(arg4));
  swig::SwigVar_PyObject obj5;
  obj5 = SWIG_From_double(static_cast< double >(arg5));
  swig::SwigVar_PyObject obj6;
  obj6 = SWIG_From_double(static_cast< double >(arg6));
  swig::SwigVar_PyObject obj7;
  obj7 = SWIG_From_double(static_cast< double >(arg7));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 3;
  const char * const swig_method_name = "set2Kin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"set2Kin", (char *)"(OOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.set2Kin'");
    }
  }
}


void SwigDirector_SigmaProcess::set2KinMPI(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6, bool arg7, double arg8, double arg9) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_double(static_cast< double >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_double(static_cast< double >(arg4));
  swig::SwigVar_PyObject obj5;
  obj5 = SWIG_From_double(static_cast< double >(arg5));
  swig::SwigVar_PyObject obj6;
  obj6 = SWIG_From_double(static_cast< double >(arg6));
  swig::SwigVar_PyObject obj7;
  obj7 = SWIG_From_bool(static_cast< bool >(arg7));
  swig::SwigVar_PyObject obj8;
  obj8 = SWIG_From_double(static_cast< double >(arg8));
  swig::SwigVar_PyObject obj9;
  obj9 = SWIG_From_double(static_cast< double >(arg9));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "set2KinMPI";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7,(PyObject *)obj8,(PyObject *)obj9);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"set2KinMPI", (char *)"(OOOOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7,(PyObject *)obj8,(PyObject *)obj9);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.set2KinMPI'");
    }
  }
}


void SwigDirector_SigmaProcess::set3Kin(double arg0, double arg1, double arg2, Pythia8::Vec4 arg3, Pythia8::Vec4 arg4, Pythia8::Vec4 arg5, double arg6, double arg7, double arg8, double arg9, double arg10, double arg11) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg3), SWIGTYPE_p_Pythia8__Vec4,  0 );
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg4), SWIGTYPE_p_Pythia8__Vec4,  0 );
  swig::SwigVar_PyObject obj5;
  obj5 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg5), SWIGTYPE_p_Pythia8__Vec4,  0 );
  swig::SwigVar_PyObject obj6;
  obj6 = SWIG_From_double(static_cast< double >(arg6));
  swig::SwigVar_PyObject obj7;
  obj7 = SWIG_From_double(static_cast< double >(arg7));
  swig::SwigVar_PyObject obj8;
  obj8 = SWIG_From_double(static_cast< double >(arg8));
  swig::SwigVar_PyObject obj9;
  obj9 = SWIG_From_double(static_cast< double >(arg9));
  swig::SwigVar_PyObject obj10;
  obj10 = SWIG_From_double(static_cast< double >(arg10));
  swig::SwigVar_PyObject obj11;
  obj11 = SWIG_From_double(static_cast< double >(arg11));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 5;
  const char * const swig_method_name = "set3Kin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOOOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7,(PyObject *)obj8,(PyObject *)obj9,(PyObject *)obj10,(PyObject *)obj11);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"set3Kin", (char *)"(OOOOOOOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6,(PyObject *)obj7,(PyObject *)obj8,(PyObject *)obj9,(PyObject *)obj10,(PyObject *)obj11);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.set3Kin'");
    }
  }
}


void SwigDirector_SigmaProcess::sigmaKin() {
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "sigmaKin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "sigmaKin", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.sigmaKin'");
    }
  }
}


double SwigDirector_SigmaProcess::sigmaHat() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 7;
  const char * const swig_method_name = "sigmaHat";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "sigmaHat", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.sigmaHat'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_SigmaProcess::sigmaHatWrap(int id1in, int id2in) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(id1in));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(id2in));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "sigmaHatWrap";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"sigmaHatWrap", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.sigmaHatWrap'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_SigmaProcess::sigmaPDF(bool initPS, bool samexGamma, bool useNewXvalues, double x1New, double x2New) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_bool(static_cast< bool >(initPS));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_bool(static_cast< bool >(samexGamma));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(useNewXvalues));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_double(static_cast< double >(x1New));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_double(static_cast< double >(x2New));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 11;
  const char * const swig_method_name = "sigmaPDF";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"sigmaPDF", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.sigmaPDF'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


void SwigDirector_SigmaProcess::setIdColAcol() {
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 17;
  const char * const swig_method_name = "setIdColAcol";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "setIdColAcol", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.setIdColAcol'");
    }
  }
}


bool SwigDirector_SigmaProcess::final2KinMPI(int arg0, int arg1, Pythia8::Vec4 arg2, Pythia8::Vec4 arg3, double arg4, double arg5) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg2), SWIGTYPE_p_Pythia8__Vec4,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg3), SWIGTYPE_p_Pythia8__Vec4,  0 );
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_double(static_cast< double >(arg4));
  swig::SwigVar_PyObject obj5;
  obj5 = SWIG_From_double(static_cast< double >(arg5));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 18;
  const char * const swig_method_name = "final2KinMPI";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"final2KinMPI", (char *)"(OOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.final2KinMPI'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_SigmaProcess::weightDecayFlav(Pythia8::Event &arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 25;
  const char * const swig_method_name = "weightDecayFlav";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"weightDecayFlav", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.weightDecayFlav'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_SigmaProcess::weightDecay(Pythia8::Event &arg0, int arg1, int arg2) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 26;
  const char * const swig_method_name = "weightDecay";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"weightDecay", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.weightDecay'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


void SwigDirector_SigmaProcess::setScale() {
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 27;
  const char * const swig_method_name = "setScale";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "setScale", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.setScale'");
    }
  }
}


std::string SwigDirector_SigmaProcess::name() const {
  std::string c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 28;
  const char * const swig_method_name = "name";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "name", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.name'");
    }
  }
  std::string *swig_optr = 0;
  int swig_ores = SWIG_AsPtr_std_string(result, &swig_optr);
  if (!SWIG_IsOK(swig_ores) || !swig_optr) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError((swig_optr ? swig_ores : SWIG_TypeError))), "in output value of type '""std::string""'");
  }
  c_result = *swig_optr;
  if (SWIG_IsNewObj(swig_ores)) delete swig_optr;
  return (std::string) c_result;
}


int SwigDirector_SigmaProcess::code() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 29;
  const char * const swig_method_name = "code";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "code", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.code'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_SigmaProcess::nFinal() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 30;
  const char * const swig_method_name = "nFinal";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "nFinal", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.nFinal'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


std::string SwigDirector_SigmaProcess::inFlux() const {
  std::string c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 31;
  const char * const swig_method_name = "inFlux";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "inFlux", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.inFlux'");
    }
  }
  std::string *swig_optr = 0;
  int swig_ores = SWIG_AsPtr_std_string(result, &swig_optr);
  if (!SWIG_IsOK(swig_ores) || !swig_optr) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError((swig_optr ? swig_ores : SWIG_TypeError))), "in output value of type '""std::string""'");
  }
  c_result = *swig_optr;
  if (SWIG_IsNewObj(swig_ores)) delete swig_optr;
  return (std::string) c_result;
}


bool SwigDirector_SigmaProcess::convert2mb() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 32;
  const char * const swig_method_name = "convert2mb";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "convert2mb", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.convert2mb'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::convertM2() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 33;
  const char * const swig_method_name = "convertM2";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "convertM2", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.convertM2'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::isLHA() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 34;
  const char * const swig_method_name = "isLHA";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isLHA", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isLHA'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::isNonDiff() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 35;
  const char * const swig_method_name = "isNonDiff";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isNonDiff", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isNonDiff'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::isResolved() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 36;
  const char * const swig_method_name = "isResolved";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isResolved", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isResolved'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::isDiffA() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 37;
  const char * const swig_method_name = "isDiffA";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isDiffA", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isDiffA'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::isDiffB() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 38;
  const char * const swig_method_name = "isDiffB";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isDiffB", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isDiffB'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::isDiffC() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 39;
  const char * const swig_method_name = "isDiffC";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isDiffC", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isDiffC'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::isSUSY() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 40;
  const char * const swig_method_name = "isSUSY";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isSUSY", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isSUSY'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SigmaProcess::allowNegativeSigma() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 41;
  const char * const swig_method_name = "allowNegativeSigma";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "allowNegativeSigma", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.allowNegativeSigma'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_SigmaProcess::id3Mass() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 42;
  const char * const swig_method_name = "id3Mass";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "id3Mass", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.id3Mass'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_SigmaProcess::id4Mass() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 43;
  const char * const swig_method_name = "id4Mass";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "id4Mass", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.id4Mass'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_SigmaProcess::id5Mass() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 44;
  const char * const swig_method_name = "id5Mass";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "id5Mass", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.id5Mass'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_SigmaProcess::resonanceA() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 45;
  const char * const swig_method_name = "resonanceA";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "resonanceA", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.resonanceA'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_SigmaProcess::resonanceB() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 46;
  const char * const swig_method_name = "resonanceB";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "resonanceB", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.resonanceB'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


bool SwigDirector_SigmaProcess::isSChannel() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 47;
  const char * const swig_method_name = "isSChannel";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isSChannel", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isSChannel'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_SigmaProcess::idSChannel() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 48;
  const char * const swig_method_name = "idSChannel";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "idSChannel", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.idSChannel'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


bool SwigDirector_SigmaProcess::isQCD3body() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 49;
  const char * const swig_method_name = "isQCD3body";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isQCD3body", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.isQCD3body'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_SigmaProcess::idTchan1() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 50;
  const char * const swig_method_name = "idTchan1";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "idTchan1", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.idTchan1'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_SigmaProcess::idTchan2() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 51;
  const char * const swig_method_name = "idTchan2";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "idTchan2", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.idTchan2'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


double SwigDirector_SigmaProcess::tChanFracPow1() const {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 52;
  const char * const swig_method_name = "tChanFracPow1";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "tChanFracPow1", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.tChanFracPow1'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_SigmaProcess::tChanFracPow2() const {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 53;
  const char * const swig_method_name = "tChanFracPow2";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "tChanFracPow2", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.tChanFracPow2'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_SigmaProcess::useMirrorWeight() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 54;
  const char * const swig_method_name = "useMirrorWeight";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "useMirrorWeight", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.useMirrorWeight'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_SigmaProcess::gmZmode() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 55;
  const char * const swig_method_name = "gmZmode";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "gmZmode", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.gmZmode'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


void SwigDirector_SigmaProcess::setIdInDiff(int arg0, int arg1) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 56;
  const char * const swig_method_name = "setIdInDiff";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"setIdInDiff", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.setIdInDiff'");
    }
  }
}


bool SwigDirector_SigmaProcess::setupForME() {
  bool c_result;
  swig_set_inner("setupForME", true);
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SigmaProcess.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 57;
  const char * const swig_method_name = "setupForME";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "setupForME", NULL);
#endif
  swig_set_inner("setupForME", false);
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SigmaProcess.setupForME'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


SwigDirector_UserHooks::SwigDirector_UserHooks(PyObject *self): Pythia8::UserHooks(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::UserHooks *)this, this); 
}




SwigDirector_UserHooks::~SwigDirector_UserHooks() {
}

bool SwigDirector_UserHooks::initAfterBeams() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "initAfterBeams";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "initAfterBeams", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.initAfterBeams'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canModifySigma() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "canModifySigma";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canModifySigma", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canModifySigma'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_UserHooks::multiplySigmaBy(Pythia8::SigmaProcess const *sigmaProcessPtr, Pythia8::PhaseSpace const *phaseSpacePtr, bool inEvent) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(sigmaProcessPtr), SWIGTYPE_p_Pythia8__SigmaProcess,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(phaseSpacePtr), SWIGTYPE_p_Pythia8__PhaseSpace,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(inEvent));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 2;
  const char * const swig_method_name = "multiplySigmaBy";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"multiplySigmaBy", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.multiplySigmaBy'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_UserHooks::canBiasSelection() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 3;
  const char * const swig_method_name = "canBiasSelection";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canBiasSelection", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canBiasSelection'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_UserHooks::biasSelectionBy(Pythia8::SigmaProcess const *sigmaProcessPtr, Pythia8::PhaseSpace const *phaseSpacePtr, bool inEvent) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(sigmaProcessPtr), SWIGTYPE_p_Pythia8__SigmaProcess,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(phaseSpacePtr), SWIGTYPE_p_Pythia8__PhaseSpace,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(inEvent));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "biasSelectionBy";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"biasSelectionBy", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.biasSelectionBy'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_UserHooks::biasedSelectionWeight() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 5;
  const char * const swig_method_name = "biasedSelectionWeight";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "biasedSelectionWeight", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.biasedSelectionWeight'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_UserHooks::canVetoProcessLevel() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "canVetoProcessLevel";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoProcessLevel", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoProcessLevel'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoProcessLevel(Pythia8::Event &arg0) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 7;
  const char * const swig_method_name = "doVetoProcessLevel";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoProcessLevel", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoProcessLevel'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoResonanceDecays() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "canVetoResonanceDecays";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoResonanceDecays", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoResonanceDecays'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoResonanceDecays(Pythia8::Event &arg0) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 9;
  const char * const swig_method_name = "doVetoResonanceDecays";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoResonanceDecays", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoResonanceDecays'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoPT() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 10;
  const char * const swig_method_name = "canVetoPT";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoPT", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoPT'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_UserHooks::scaleVetoPT() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 11;
  const char * const swig_method_name = "scaleVetoPT";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "scaleVetoPT", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.scaleVetoPT'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_UserHooks::doVetoPT(int arg0, Pythia8::Event const &arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 12;
  const char * const swig_method_name = "doVetoPT";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoPT", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoPT'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoStep() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 13;
  const char * const swig_method_name = "canVetoStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoStep", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoStep'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_UserHooks::numberVetoStep() {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 14;
  const char * const swig_method_name = "numberVetoStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "numberVetoStep", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.numberVetoStep'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


bool SwigDirector_UserHooks::doVetoStep(int arg0, int arg1, int arg2, Pythia8::Event const &arg3) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg3), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 15;
  const char * const swig_method_name = "doVetoStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoStep", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoStep'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoMPIStep() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 16;
  const char * const swig_method_name = "canVetoMPIStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoMPIStep", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoMPIStep'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_UserHooks::numberVetoMPIStep() {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 17;
  const char * const swig_method_name = "numberVetoMPIStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "numberVetoMPIStep", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.numberVetoMPIStep'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


bool SwigDirector_UserHooks::doVetoMPIStep(int arg0, Pythia8::Event const &arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 18;
  const char * const swig_method_name = "doVetoMPIStep";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoMPIStep", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoMPIStep'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoPartonLevelEarly() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 19;
  const char * const swig_method_name = "canVetoPartonLevelEarly";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoPartonLevelEarly", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoPartonLevelEarly'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoPartonLevelEarly(Pythia8::Event const &arg0) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 20;
  const char * const swig_method_name = "doVetoPartonLevelEarly";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoPartonLevelEarly", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoPartonLevelEarly'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::retryPartonLevel() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 21;
  const char * const swig_method_name = "retryPartonLevel";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "retryPartonLevel", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.retryPartonLevel'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoPartonLevel() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 22;
  const char * const swig_method_name = "canVetoPartonLevel";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoPartonLevel", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoPartonLevel'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoPartonLevel(Pythia8::Event const &arg0) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 23;
  const char * const swig_method_name = "doVetoPartonLevel";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoPartonLevel", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoPartonLevel'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canSetResonanceScale() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 24;
  const char * const swig_method_name = "canSetResonanceScale";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canSetResonanceScale", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canSetResonanceScale'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_UserHooks::scaleResonance(int arg0, Pythia8::Event const &arg1) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 25;
  const char * const swig_method_name = "scaleResonance";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"scaleResonance", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.scaleResonance'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_UserHooks::canVetoISREmission() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 26;
  const char * const swig_method_name = "canVetoISREmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoISREmission", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoISREmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoISREmission(int arg0, Pythia8::Event const &arg1, int arg2) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 27;
  const char * const swig_method_name = "doVetoISREmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoISREmission", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoISREmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoFSREmission() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 28;
  const char * const swig_method_name = "canVetoFSREmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoFSREmission", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoFSREmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoFSREmission(int arg0, Pythia8::Event const &arg1, int arg2, bool arg3) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_bool(static_cast< bool >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 29;
  const char * const swig_method_name = "doVetoFSREmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoFSREmission", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoFSREmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canVetoMPIEmission() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 31;
  const char * const swig_method_name = "canVetoMPIEmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canVetoMPIEmission", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canVetoMPIEmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoMPIEmission(int arg0, Pythia8::Event const &arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 32;
  const char * const swig_method_name = "doVetoMPIEmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoMPIEmission", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoMPIEmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canReconnectResonanceSystems() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 33;
  const char * const swig_method_name = "canReconnectResonanceSystems";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canReconnectResonanceSystems", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canReconnectResonanceSystems'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doReconnectResonanceSystems(int arg0, Pythia8::Event &arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 34;
  const char * const swig_method_name = "doReconnectResonanceSystems";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doReconnectResonanceSystems", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doReconnectResonanceSystems'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canEnhanceEmission() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 35;
  const char * const swig_method_name = "canEnhanceEmission";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canEnhanceEmission", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canEnhanceEmission'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_UserHooks::enhanceFactor(std::string arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_std_string(static_cast< std::string >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 36;
  const char * const swig_method_name = "enhanceFactor";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"enhanceFactor", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.enhanceFactor'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_UserHooks::vetoProbability(std::string arg0) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_std_string(static_cast< std::string >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 37;
  const char * const swig_method_name = "vetoProbability";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"vetoProbability", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.vetoProbability'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_UserHooks::canEnhanceTrial() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 38;
  const char * const swig_method_name = "canEnhanceTrial";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canEnhanceTrial", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canEnhanceTrial'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canChangeFragPar() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 39;
  const char * const swig_method_name = "canChangeFragPar";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canChangeFragPar", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canChangeFragPar'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


void SwigDirector_UserHooks::setStringEnds(Pythia8::StringEnd const *arg0, Pythia8::StringEnd const *arg1, std::vector< int,std::allocator< int > > arg2) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(arg0), SWIGTYPE_p_Pythia8__StringEnd,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(arg1), SWIGTYPE_p_Pythia8__StringEnd,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = swig::from(static_cast< std::vector< int,std::allocator< int > > >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 40;
  const char * const swig_method_name = "setStringEnds";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"setStringEnds", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.setStringEnds'");
    }
  }
}


bool SwigDirector_UserHooks::doChangeFragPar(Pythia8::StringFlav *arg0, Pythia8::StringZ *arg1, Pythia8::StringPT *arg2, int arg3, double arg4, std::vector< int,std::allocator< int > > arg5, Pythia8::StringEnd const *arg6) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(arg0), SWIGTYPE_p_Pythia8__StringFlav,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(arg1), SWIGTYPE_p_Pythia8__StringZ,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(arg2), SWIGTYPE_p_Pythia8__StringPT,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_double(static_cast< double >(arg4));
  swig::SwigVar_PyObject obj5;
  obj5 = swig::from(static_cast< std::vector< int,std::allocator< int > > >(arg5));
  swig::SwigVar_PyObject obj6;
  obj6 = SWIG_NewPointerObj(SWIG_as_voidptr(arg6), SWIGTYPE_p_Pythia8__StringEnd,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 41;
  const char * const swig_method_name = "doChangeFragPar";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doChangeFragPar", (char *)"(OOOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5,(PyObject *)obj6);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doChangeFragPar'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoFragmentation(Pythia8::Particle arg0, Pythia8::StringEnd const *arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Particle,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(arg1), SWIGTYPE_p_Pythia8__StringEnd,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 42;
  const char * const swig_method_name = "doVetoFragmentation";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoFragmentation", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoFragmentation'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::doVetoFragmentation(Pythia8::Particle arg0, Pythia8::Particle arg1, Pythia8::StringEnd const *arg2, Pythia8::StringEnd const *arg3) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Particle,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Particle,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(arg2), SWIGTYPE_p_Pythia8__StringEnd,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_NewPointerObj(SWIG_as_voidptr(arg3), SWIGTYPE_p_Pythia8__StringEnd,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 43;
  const char * const swig_method_name = "doVetoFragmentation";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"doVetoFragmentation", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doVetoFragmentation'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_UserHooks::canSetImpactParameter() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 44;
  const char * const swig_method_name = "canSetImpactParameter";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "canSetImpactParameter", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.canSetImpactParameter'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_UserHooks::doSetImpactParameter() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call UserHooks.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 45;
  const char * const swig_method_name = "doSetImpactParameter";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "doSetImpactParameter", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'UserHooks.doSetImpactParameter'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


SwigDirector_PhaseSpace::SwigDirector_PhaseSpace(PyObject *self): Pythia8::PhaseSpace(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::PhaseSpace *)this, this); 
}




SwigDirector_PhaseSpace::~SwigDirector_PhaseSpace() {
}

bool SwigDirector_PhaseSpace::setupSampling() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "setupSampling";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "setupSampling", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.setupSampling'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_PhaseSpace::trialKin(bool inEvent, bool repeatSame) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_bool(static_cast< bool >(inEvent));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_bool(static_cast< bool >(repeatSame));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "trialKin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"trialKin", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.trialKin'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_PhaseSpace::finalKin() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "finalKin";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "finalKin", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.finalKin'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


double SwigDirector_PhaseSpace::sigmaSumSigned() const {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 5;
  const char * const swig_method_name = "sigmaSumSigned";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "sigmaSumSigned", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.sigmaSumSigned'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_PhaseSpace::isResolved() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "isResolved";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "isResolved", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.isResolved'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


void SwigDirector_PhaseSpace::rescaleSigma(double arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 7;
  const char * const swig_method_name = "rescaleSigma";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"rescaleSigma", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.rescaleSigma'");
    }
  }
}


void SwigDirector_PhaseSpace::rescaleMomenta(double arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_double(static_cast< double >(arg0));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "rescaleMomenta";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"rescaleMomenta", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.rescaleMomenta'");
    }
  }
}


double SwigDirector_PhaseSpace::weightGammaPDFApprox() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 9;
  const char * const swig_method_name = "weightGammaPDFApprox";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "weightGammaPDFApprox", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.weightGammaPDFApprox'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


void SwigDirector_PhaseSpace::setGammaKinPtr(Pythia8::GammaKinematics *gammaKinPtrIn) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(gammaKinPtrIn), SWIGTYPE_p_Pythia8__GammaKinematics,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call PhaseSpace.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 10;
  const char * const swig_method_name = "setGammaKinPtr";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"setGammaKinPtr", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'PhaseSpace.setGammaKinPtr'");
    }
  }
}


SwigDirector_SpaceShower::SwigDirector_SpaceShower(PyObject *self): Pythia8::SpaceShower(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::SpaceShower *)this, this); 
}




SwigDirector_SpaceShower::~SwigDirector_SpaceShower() {
}

void SwigDirector_SpaceShower::init(Pythia8::BeamParticle *arg0, Pythia8::BeamParticle *arg1) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(arg0), SWIGTYPE_p_Pythia8__BeamParticle,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(arg1), SWIGTYPE_p_Pythia8__BeamParticle,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "init";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"init", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.init'");
    }
  }
}


bool SwigDirector_SpaceShower::limitPTmax(Pythia8::Event &arg0, double arg1, double arg2) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "limitPTmax";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"limitPTmax", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.limitPTmax'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


void SwigDirector_SpaceShower::prepare(int arg0, Pythia8::Event &arg1, bool arg2) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 4;
  const char * const swig_method_name = "prepare";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"prepare", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.prepare'");
    }
  }
}


void SwigDirector_SpaceShower::update(int arg0, Pythia8::Event &arg1, bool arg2) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "update";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"update", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.update'");
    }
  }
}


double SwigDirector_SpaceShower::pTnext(Pythia8::Event &arg0, double arg1, double arg2, int arg3, bool arg4) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_bool(static_cast< bool >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "pTnext";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"pTnext", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.pTnext'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_SpaceShower::branch(Pythia8::Event &arg0) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 11;
  const char * const swig_method_name = "branch";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"branch", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.branch'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SpaceShower::initUncertainties() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 12;
  const char * const swig_method_name = "initUncertainties";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "initUncertainties", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.initUncertainties'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SpaceShower::doRestart() const {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 13;
  const char * const swig_method_name = "doRestart";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "doRestart", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.doRestart'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SpaceShower::wasGamma2qqbar() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 14;
  const char * const swig_method_name = "wasGamma2qqbar";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "wasGamma2qqbar", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.wasGamma2qqbar'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_SpaceShower::getHasWeaklyRadiated() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 15;
  const char * const swig_method_name = "getHasWeaklyRadiated";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "getHasWeaklyRadiated", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.getHasWeaklyRadiated'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_SpaceShower::system() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 16;
  const char * const swig_method_name = "system";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "system", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.system'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


double SwigDirector_SpaceShower::enhancePTmax() const {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 17;
  const char * const swig_method_name = "enhancePTmax";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "enhancePTmax", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.enhancePTmax'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


Pythia8::Event SwigDirector_SpaceShower::clustered(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  void *swig_argp ;
  int swig_res = 0 ;
  
  Pythia8::Event c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 18;
  const char * const swig_method_name = "clustered";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"clustered", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.clustered'");
    }
  }
  swig_res = SWIG_ConvertPtr(result,&swig_argp,SWIGTYPE_p_Pythia8__Event,  0  | 0);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""Pythia8::Event""'");
  }
  c_result = *(reinterpret_cast< Pythia8::Event * >(swig_argp));
  if (SWIG_IsNewObj(swig_res)) delete reinterpret_cast< Pythia8::Event * >(swig_argp);
  return (Pythia8::Event) c_result;
}


std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > SwigDirector_SpaceShower::getStateVariables(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  void *swig_argp ;
  int swig_res = 0 ;
  
  std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 19;
  const char * const swig_method_name = "getStateVariables";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getStateVariables", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.getStateVariables'");
    }
  }
  swig_res = SWIG_ConvertPtr(result,&swig_argp,SWIGTYPE_p_std__mapT_std__string_double_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_double_t_t_t,  0  | 0);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > >""'");
  }
  c_result = *(reinterpret_cast< std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > * >(swig_argp));
  if (SWIG_IsNewObj(swig_res)) delete reinterpret_cast< std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > * >(swig_argp);
  return (std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > >) c_result;
}


bool SwigDirector_SpaceShower::isSpacelike(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 20;
  const char * const swig_method_name = "isSpacelike";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"isSpacelike", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.isSpacelike'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


std::vector< std::string,std::allocator< std::string > > SwigDirector_SpaceShower::getSplittingName(Pythia8::Event const &arg0, int arg1, int arg2, int arg3) {
  std::vector< std::string,std::allocator< std::string > > c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 21;
  const char * const swig_method_name = "getSplittingName";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getSplittingName", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.getSplittingName'");
    }
  }
  std::vector< std::string,std::allocator< std::string > > *swig_optr = 0;
  int swig_ores = swig::asptr(result, &swig_optr);
  if (!SWIG_IsOK(swig_ores) || !swig_optr) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError((swig_optr ? swig_ores : SWIG_TypeError))), "in output value of type '""std::vector< std::string,std::allocator< std::string > >""'");
  }
  c_result = *swig_optr;
  if (SWIG_IsNewObj(swig_ores)) delete swig_optr;
  return (std::vector< std::string,std::allocator< std::string > >) c_result;
}


double SwigDirector_SpaceShower::getSplittingProb(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 22;
  const char * const swig_method_name = "getSplittingProb";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getSplittingProb", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.getSplittingProb'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_SpaceShower::allowedSplitting(Pythia8::Event const &arg0, int arg1, int arg2) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 23;
  const char * const swig_method_name = "allowedSplitting";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"allowedSplitting", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.allowedSplitting'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


std::vector< int,std::allocator< int > > SwigDirector_SpaceShower::getRecoilers(Pythia8::Event const &arg0, int arg1, int arg2, std::string arg3) {
  std::vector< int,std::allocator< int > > c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_std_string(static_cast< std::string >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call SpaceShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 24;
  const char * const swig_method_name = "getRecoilers";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getRecoilers", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'SpaceShower.getRecoilers'");
    }
  }
  std::vector< int,std::allocator< int > > *swig_optr = 0;
  int swig_ores = swig::asptr(result, &swig_optr);
  if (!SWIG_IsOK(swig_ores) || !swig_optr) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError((swig_optr ? swig_ores : SWIG_TypeError))), "in output value of type '""std::vector< int,std::allocator< int > >""'");
  }
  c_result = *swig_optr;
  if (SWIG_IsNewObj(swig_ores)) delete swig_optr;
  return (std::vector< int,std::allocator< int > >) c_result;
}


SwigDirector_TimeShower::SwigDirector_TimeShower(PyObject *self): Pythia8::TimeShower(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::TimeShower *)this, this); 
}




SwigDirector_TimeShower::~SwigDirector_TimeShower() {
}

void SwigDirector_TimeShower::init(Pythia8::BeamParticle *arg0, Pythia8::BeamParticle *arg1) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(arg0), SWIGTYPE_p_Pythia8__BeamParticle,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(arg1), SWIGTYPE_p_Pythia8__BeamParticle,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "init";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"init", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.init'");
    }
  }
}


bool SwigDirector_TimeShower::limitPTmax(Pythia8::Event &arg0, double arg1, double arg2) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 3;
  const char * const swig_method_name = "limitPTmax";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"limitPTmax", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.limitPTmax'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_TimeShower::shower(int arg0, int arg1, Pythia8::Event &arg2, double arg3, int arg4) {
  int c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg2), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_double(static_cast< double >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_int(static_cast< int >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 6;
  const char * const swig_method_name = "shower";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"shower", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.shower'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_TimeShower::showerQED(int arg0, int arg1, Pythia8::Event &arg2, double arg3) {
  int c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg2), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_double(static_cast< double >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 8;
  const char * const swig_method_name = "showerQED";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"showerQED", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.showerQED'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


int SwigDirector_TimeShower::showerQEDafterRemnants(Pythia8::Event &arg0) {
  int c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 9;
  const char * const swig_method_name = "showerQEDafterRemnants";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"showerQEDafterRemnants", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.showerQEDafterRemnants'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


void SwigDirector_TimeShower::prepareGlobal(Pythia8::Event &arg0) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 10;
  const char * const swig_method_name = "prepareGlobal";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(O)" ,(PyObject *)obj0);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"prepareGlobal", (char *)"(O)" ,(PyObject *)obj0);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.prepareGlobal'");
    }
  }
}


void SwigDirector_TimeShower::prepare(int arg0, Pythia8::Event &arg1, bool arg2) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 11;
  const char * const swig_method_name = "prepare";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"prepare", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.prepare'");
    }
  }
}


void SwigDirector_TimeShower::rescatterUpdate(int arg0, Pythia8::Event &arg1) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 13;
  const char * const swig_method_name = "rescatterUpdate";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"rescatterUpdate", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.rescatterUpdate'");
    }
  }
}


void SwigDirector_TimeShower::update(int arg0, Pythia8::Event &arg1, bool arg2) {
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_From_int(static_cast< int >(arg0));
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_bool(static_cast< bool >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 14;
  const char * const swig_method_name = "update";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"update", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.update'");
    }
  }
}


double SwigDirector_TimeShower::pTnext(Pythia8::Event &arg0, double arg1, double arg2, bool arg3, bool arg4) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_double(static_cast< double >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_double(static_cast< double >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_bool(static_cast< bool >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_bool(static_cast< bool >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 16;
  const char * const swig_method_name = "pTnext";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"pTnext", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.pTnext'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_TimeShower::branch(Pythia8::Event &arg0, bool arg1) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_bool(static_cast< bool >(arg1));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 19;
  const char * const swig_method_name = "branch";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"branch", (char *)"(OO)" ,(PyObject *)obj0,(PyObject *)obj1);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.branch'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_TimeShower::initUncertainties() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 21;
  const char * const swig_method_name = "initUncertainties";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "initUncertainties", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.initUncertainties'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_TimeShower::getHasWeaklyRadiated() {
  bool c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 22;
  const char * const swig_method_name = "getHasWeaklyRadiated";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "getHasWeaklyRadiated", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.getHasWeaklyRadiated'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


int SwigDirector_TimeShower::system() const {
  int c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 23;
  const char * const swig_method_name = "system";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "system", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.system'");
    }
  }
  int swig_val;
  int swig_res = SWIG_AsVal_int(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""int""'");
  }
  c_result = static_cast< int >(swig_val);
  return (int) c_result;
}


double SwigDirector_TimeShower::enhancePTmax() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 24;
  const char * const swig_method_name = "enhancePTmax";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "enhancePTmax", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.enhancePTmax'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


double SwigDirector_TimeShower::pTLastInShower() {
  double c_result;
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 25;
  const char * const swig_method_name = "pTLastInShower";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, NULL, NULL);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *) "pTLastInShower", NULL);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.pTLastInShower'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


Pythia8::Event SwigDirector_TimeShower::clustered(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  void *swig_argp ;
  int swig_res = 0 ;
  
  Pythia8::Event c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 26;
  const char * const swig_method_name = "clustered";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"clustered", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.clustered'");
    }
  }
  swig_res = SWIG_ConvertPtr(result,&swig_argp,SWIGTYPE_p_Pythia8__Event,  0  | 0);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""Pythia8::Event""'");
  }
  c_result = *(reinterpret_cast< Pythia8::Event * >(swig_argp));
  if (SWIG_IsNewObj(swig_res)) delete reinterpret_cast< Pythia8::Event * >(swig_argp);
  return (Pythia8::Event) c_result;
}


std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > SwigDirector_TimeShower::getStateVariables(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  void *swig_argp ;
  int swig_res = 0 ;
  
  std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 27;
  const char * const swig_method_name = "getStateVariables";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getStateVariables", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.getStateVariables'");
    }
  }
  swig_res = SWIG_ConvertPtr(result,&swig_argp,SWIGTYPE_p_std__mapT_std__string_double_std__lessT_std__string_t_std__allocatorT_std__pairT_std__string_const_double_t_t_t,  0  | 0);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > >""'");
  }
  c_result = *(reinterpret_cast< std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > * >(swig_argp));
  if (SWIG_IsNewObj(swig_res)) delete reinterpret_cast< std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > > * >(swig_argp);
  return (std::map< std::string,double,std::less< std::string >,std::allocator< std::pair< std::string const,double > > >) c_result;
}


bool SwigDirector_TimeShower::isTimelike(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 28;
  const char * const swig_method_name = "isTimelike";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"isTimelike", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.isTimelike'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


std::vector< std::string,std::allocator< std::string > > SwigDirector_TimeShower::getSplittingName(Pythia8::Event const &arg0, int arg1, int arg2, int arg3) {
  std::vector< std::string,std::allocator< std::string > > c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 29;
  const char * const swig_method_name = "getSplittingName";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getSplittingName", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.getSplittingName'");
    }
  }
  std::vector< std::string,std::allocator< std::string > > *swig_optr = 0;
  int swig_ores = swig::asptr(result, &swig_optr);
  if (!SWIG_IsOK(swig_ores) || !swig_optr) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError((swig_optr ? swig_ores : SWIG_TypeError))), "in output value of type '""std::vector< std::string,std::allocator< std::string > >""'");
  }
  c_result = *swig_optr;
  if (SWIG_IsNewObj(swig_ores)) delete swig_optr;
  return (std::vector< std::string,std::allocator< std::string > >) c_result;
}


double SwigDirector_TimeShower::getSplittingProb(Pythia8::Event const &arg0, int arg1, int arg2, int arg3, std::string arg4) {
  double c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_std_string(static_cast< std::string >(arg4));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 30;
  const char * const swig_method_name = "getSplittingProb";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getSplittingProb", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.getSplittingProb'");
    }
  }
  double swig_val;
  int swig_res = SWIG_AsVal_double(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""double""'");
  }
  c_result = static_cast< double >(swig_val);
  return (double) c_result;
}


bool SwigDirector_TimeShower::allowedSplitting(Pythia8::Event const &arg0, int arg1, int arg2) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 31;
  const char * const swig_method_name = "allowedSplitting";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"allowedSplitting", (char *)"(OOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.allowedSplitting'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


std::vector< int,std::allocator< int > > SwigDirector_TimeShower::getRecoilers(Pythia8::Event const &arg0, int arg1, int arg2, std::string arg3) {
  std::vector< int,std::allocator< int > > c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_Pythia8__Event,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_From_int(static_cast< int >(arg1));
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_From_int(static_cast< int >(arg2));
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_std_string(static_cast< std::string >(arg3));
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call TimeShower.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 32;
  const char * const swig_method_name = "getRecoilers";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"getRecoilers", (char *)"(OOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'TimeShower.getRecoilers'");
    }
  }
  std::vector< int,std::allocator< int > > *swig_optr = 0;
  int swig_ores = swig::asptr(result, &swig_optr);
  if (!SWIG_IsOK(swig_ores) || !swig_optr) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError((swig_optr ? swig_ores : SWIG_TypeError))), "in output value of type '""std::vector< int,std::allocator< int > >""'");
  }
  c_result = *swig_optr;
  if (SWIG_IsNewObj(swig_ores)) delete swig_optr;
  return (std::vector< int,std::allocator< int > >) c_result;
}


SwigDirector_DecayHandler::SwigDirector_DecayHandler(PyObject *self): Pythia8::DecayHandler(), Swig::Director(self) {
  SWIG_DIRECTOR_RGTR((Pythia8::DecayHandler *)this, this); 
}




SwigDirector_DecayHandler::~SwigDirector_DecayHandler() {
}

bool SwigDirector_DecayHandler::decay(std::vector< int,std::allocator< int > > &arg0, std::vector< double,std::allocator< double > > &arg1, std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > &arg2, int arg3, Pythia8::Event const &arg4) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_std__vectorT_double_std__allocatorT_double_t_t,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg2), SWIGTYPE_p_std__vectorT_Pythia8__Vec4_std__allocatorT_Pythia8__Vec4_t_t,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_From_int(static_cast< int >(arg3));
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg4), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call DecayHandler.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 0;
  const char * const swig_method_name = "decay";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"decay", (char *)"(OOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'DecayHandler.decay'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


bool SwigDirector_DecayHandler::chainDecay(std::vector< int,std::allocator< int > > &arg0, std::vector< int,std::allocator< int > > &arg1, std::vector< double,std::allocator< double > > &arg2, std::vector< Pythia8::Vec4,std::allocator< Pythia8::Vec4 > > &arg3, int arg4, Pythia8::Event const &arg5) {
  bool c_result;
  swig::SwigVar_PyObject obj0;
  obj0 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg0), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t,  0 );
  swig::SwigVar_PyObject obj1;
  obj1 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg1), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t,  0 );
  swig::SwigVar_PyObject obj2;
  obj2 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg2), SWIGTYPE_p_std__vectorT_double_std__allocatorT_double_t_t,  0 );
  swig::SwigVar_PyObject obj3;
  obj3 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg3), SWIGTYPE_p_std__vectorT_Pythia8__Vec4_std__allocatorT_Pythia8__Vec4_t_t,  0 );
  swig::SwigVar_PyObject obj4;
  obj4 = SWIG_From_int(static_cast< int >(arg4));
  swig::SwigVar_PyObject obj5;
  obj5 = SWIG_NewPointerObj(SWIG_as_voidptr(&arg5), SWIGTYPE_p_Pythia8__Event,  0 );
  if (!swig_get_self()) {
    Swig::DirectorException::raise("'self' uninitialized, maybe you forgot to call DecayHandler.__init__.");
  }
#if defined(SWIG_PYTHON_DIRECTOR_VTABLE)
  const size_t swig_method_index = 1;
  const char * const swig_method_name = "chainDecay";
  PyObject* method = swig_get_method(swig_method_index, swig_method_name);
  swig::SwigVar_PyObject result = PyObject_CallFunction(method, (char *)"(OOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5);
#else
  swig::SwigVar_PyObject result = PyObject_CallMethod(swig_get_self(), (char *)"chainDecay", (char *)"(OOOOOO)" ,(PyObject *)obj0,(PyObject *)obj1,(PyObject *)obj2,(PyObject *)obj3,(PyObject *)obj4,(PyObject *)obj5);
#endif
  if (!result) {
    PyObject *error = PyErr_Occurred();
    if (error) {
      Swig::DirectorMethodException::raise("Error detected when calling 'DecayHandler.chainDecay'");
    }
  }
  bool swig_val;
  int swig_res = SWIG_AsVal_bool(result, &swig_val);
  if (!SWIG_IsOK(swig_res)) {
    Swig::DirectorTypeMismatchException::raise(SWIG_ErrorType(SWIG_ArgError(swig_res)), "in output value of type '""bool""'");
  }
  c_result = static_cast< bool >(swig_val);
  return (bool) c_result;
}


#ifdef __cplusplus
extern "C" {
#endif
SWIGINTERN PyObject *_wrap_delete_SwigPyIterator(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_SwigPyIterator",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SwigPyIterator" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_value(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:SwigPyIterator_value",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_value" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  try {
    result = (PyObject *)((swig::SwigPyIterator const *)arg1)->value();
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = result;
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_incr__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  size_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator_incr",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_incr" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  ecode2 = SWIG_AsVal_size_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SwigPyIterator_incr" "', argument " "2"" of type '" "size_t""'");
  } 
  arg2 = static_cast< size_t >(val2);
  try {
    result = (swig::SwigPyIterator *)(arg1)->incr(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_incr__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:SwigPyIterator_incr",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_incr" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  try {
    result = (swig::SwigPyIterator *)(arg1)->incr();
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_incr(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__SwigPyIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_SwigPyIterator_incr__SWIG_1(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__SwigPyIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_SwigPyIterator_incr__SWIG_0(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'SwigPyIterator_incr'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    swig::SwigPyIterator::incr(size_t)\n"
    "    swig::SwigPyIterator::incr()\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_decr__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  size_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator_decr",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_decr" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  ecode2 = SWIG_AsVal_size_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SwigPyIterator_decr" "', argument " "2"" of type '" "size_t""'");
  } 
  arg2 = static_cast< size_t >(val2);
  try {
    result = (swig::SwigPyIterator *)(arg1)->decr(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_decr__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:SwigPyIterator_decr",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_decr" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  try {
    result = (swig::SwigPyIterator *)(arg1)->decr();
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_decr(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__SwigPyIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_SwigPyIterator_decr__SWIG_1(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__SwigPyIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_SwigPyIterator_decr__SWIG_0(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'SwigPyIterator_decr'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    swig::SwigPyIterator::decr(size_t)\n"
    "    swig::SwigPyIterator::decr()\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_distance(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  swig::SwigPyIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  ptrdiff_t result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator_distance",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_distance" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_swig__SwigPyIterator,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SwigPyIterator_distance" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SwigPyIterator_distance" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  arg2 = reinterpret_cast< swig::SwigPyIterator * >(argp2);
  try {
    result = ((swig::SwigPyIterator const *)arg1)->distance((swig::SwigPyIterator const &)*arg2);
  }
  catch(std::invalid_argument &_e) {
    SWIG_Python_Raise(SWIG_NewPointerObj((new std::invalid_argument(static_cast< const std::invalid_argument& >(_e))),SWIGTYPE_p_std__invalid_argument,SWIG_POINTER_OWN), "std::invalid_argument", SWIGTYPE_p_std__invalid_argument); SWIG_fail;
  }
  
  resultobj = SWIG_From_ptrdiff_t(static_cast< ptrdiff_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_equal(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  swig::SwigPyIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator_equal",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_equal" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_swig__SwigPyIterator,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SwigPyIterator_equal" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SwigPyIterator_equal" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  arg2 = reinterpret_cast< swig::SwigPyIterator * >(argp2);
  try {
    result = (bool)((swig::SwigPyIterator const *)arg1)->equal((swig::SwigPyIterator const &)*arg2);
  }
  catch(std::invalid_argument &_e) {
    SWIG_Python_Raise(SWIG_NewPointerObj((new std::invalid_argument(static_cast< const std::invalid_argument& >(_e))),SWIGTYPE_p_std__invalid_argument,SWIG_POINTER_OWN), "std::invalid_argument", SWIGTYPE_p_std__invalid_argument); SWIG_fail;
  }
  
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_copy(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:SwigPyIterator_copy",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_copy" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  result = (swig::SwigPyIterator *)((swig::SwigPyIterator const *)arg1)->copy();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_next(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:SwigPyIterator_next",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_next" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  try {
    result = (PyObject *)(arg1)->next();
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = result;
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___next__(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:SwigPyIterator___next__",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___next__" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  try {
    result = (PyObject *)(arg1)->__next__();
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = result;
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_previous(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:SwigPyIterator_previous",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_previous" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  try {
    result = (PyObject *)(arg1)->previous();
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = result;
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator_advance(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator_advance",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator_advance" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SwigPyIterator_advance" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = static_cast< ptrdiff_t >(val2);
  try {
    result = (swig::SwigPyIterator *)(arg1)->advance(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___eq__(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  swig::SwigPyIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator___eq__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___eq__" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_swig__SwigPyIterator,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SwigPyIterator___eq__" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SwigPyIterator___eq__" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  arg2 = reinterpret_cast< swig::SwigPyIterator * >(argp2);
  result = (bool)((swig::SwigPyIterator const *)arg1)->operator ==((swig::SwigPyIterator const &)*arg2);
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___ne__(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  swig::SwigPyIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator___ne__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___ne__" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_swig__SwigPyIterator,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SwigPyIterator___ne__" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SwigPyIterator___ne__" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  arg2 = reinterpret_cast< swig::SwigPyIterator * >(argp2);
  result = (bool)((swig::SwigPyIterator const *)arg1)->operator !=((swig::SwigPyIterator const &)*arg2);
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___iadd__(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator___iadd__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___iadd__" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SwigPyIterator___iadd__" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = static_cast< ptrdiff_t >(val2);
  try {
    result = (swig::SwigPyIterator *) &(arg1)->operator +=(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___isub__(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator___isub__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___isub__" "', argument " "1"" of type '" "swig::SwigPyIterator *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SwigPyIterator___isub__" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = static_cast< ptrdiff_t >(val2);
  try {
    result = (swig::SwigPyIterator *) &(arg1)->operator -=(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___add__(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator___add__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___add__" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SwigPyIterator___add__" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = static_cast< ptrdiff_t >(val2);
  try {
    result = (swig::SwigPyIterator *)((swig::SwigPyIterator const *)arg1)->operator +(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___sub____SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  swig::SwigPyIterator *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator___sub__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___sub__" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SwigPyIterator___sub__" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = static_cast< ptrdiff_t >(val2);
  try {
    result = (swig::SwigPyIterator *)((swig::SwigPyIterator const *)arg1)->operator -(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      (void)_e;
      SWIG_SetErrorObj(PyExc_StopIteration, SWIG_Py_Void());
      SWIG_fail;
    }
  }
  
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__SwigPyIterator, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___sub____SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  swig::SwigPyIterator *arg1 = (swig::SwigPyIterator *) 0 ;
  swig::SwigPyIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  ptrdiff_t result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:SwigPyIterator___sub__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_swig__SwigPyIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SwigPyIterator___sub__" "', argument " "1"" of type '" "swig::SwigPyIterator const *""'"); 
  }
  arg1 = reinterpret_cast< swig::SwigPyIterator * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_swig__SwigPyIterator,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SwigPyIterator___sub__" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SwigPyIterator___sub__" "', argument " "2"" of type '" "swig::SwigPyIterator const &""'"); 
  }
  arg2 = reinterpret_cast< swig::SwigPyIterator * >(argp2);
  result = ((swig::SwigPyIterator const *)arg1)->operator -((swig::SwigPyIterator const &)*arg2);
  resultobj = SWIG_From_ptrdiff_t(static_cast< ptrdiff_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_SwigPyIterator___sub__(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__SwigPyIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_swig__SwigPyIterator, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_SwigPyIterator___sub____SWIG_1(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__SwigPyIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_ptrdiff_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_SwigPyIterator___sub____SWIG_0(self, args);
      }
    }
  }
  
fail:
  Py_INCREF(Py_NotImplemented);
  return Py_NotImplemented;
}


SWIGINTERN PyObject *SwigPyIterator_swigregister(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *obj;
  if (!PyArg_ParseTuple(args,(char*)"O:swigregister", &obj)) return NULL;
  SWIG_TypeNewClientData(SWIGTYPE_p_swig__SwigPyIterator, SWIG_NewClientData(obj));
  return SWIG_Py_Void();
}

SWIGINTERN int Swig_var_ios_base_boolalpha_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_boolalpha is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_boolalpha_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::boolalpha));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_dec_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_dec is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_dec_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::dec));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_fixed_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_fixed is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_fixed_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::fixed));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_hex_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_hex is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_hex_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::hex));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_internal_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_internal is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_internal_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::internal));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_left_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_left is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_left_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::left));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_oct_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_oct is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_oct_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::oct));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_right_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_right is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_right_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::right));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_scientific_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_scientific is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_scientific_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::scientific));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_showbase_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_showbase is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_showbase_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::showbase));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_showpoint_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_showpoint is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_showpoint_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::showpoint));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_showpos_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_showpos is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_showpos_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::showpos));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_skipws_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_skipws is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_skipws_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::skipws));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_unitbuf_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_unitbuf is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_unitbuf_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::unitbuf));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_uppercase_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_uppercase is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_uppercase_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::uppercase));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_adjustfield_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_adjustfield is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_adjustfield_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::adjustfield));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_basefield_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_basefield is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_basefield_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::basefield));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_floatfield_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_floatfield is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_floatfield_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::floatfield));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_badbit_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_badbit is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_badbit_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::badbit));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_eofbit_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_eofbit is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_eofbit_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::eofbit));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_failbit_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_failbit is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_failbit_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::failbit));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_goodbit_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_goodbit is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_goodbit_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::goodbit));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_app_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_app is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_app_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::app));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_ate_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_ate is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_ate_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::ate));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_binary_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_binary is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_binary_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::binary));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_ios_base_in_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_ios_base_in is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_ios_base_in_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::in));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_out_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_out is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_out_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::out));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_trunc_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_trunc is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_trunc_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::trunc));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_beg_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_beg is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_beg_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::beg));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_cur_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_cur is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_cur_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::cur));
  return pyobj;
}


SWIGINTERN int Swig_var_ios_base_end_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable ios_base_end is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_ios_base_end_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_From_int(static_cast< int >(std::ios_base::end));
  return pyobj;
}


SWIGINTERN PyObject *_wrap_ios_base_register_callback(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::ios_base::event_callback arg2 = (std::ios_base::event_callback) 0 ;
  int arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:ios_base_register_callback",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_register_callback" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  {
    int res = SWIG_ConvertFunctionPtr(obj1, (void**)(&arg2), SWIGTYPE_p_f_enum_std__ios_base__event_r_std__ios_base_int__void);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in method '" "ios_base_register_callback" "', argument " "2"" of type '" "std::ios_base::event_callback""'"); 
    }
  }
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ios_base_register_callback" "', argument " "3"" of type '" "int""'");
  } 
  arg3 = static_cast< int >(val3);
  (arg1)->register_callback(arg2,arg3);
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_flags__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::ios_base::fmtflags result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_base_flags",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_flags" "', argument " "1"" of type '" "std::ios_base const *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  result = (std::ios_base::fmtflags)((std::ios_base const *)arg1)->flags();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_flags__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::ios_base::fmtflags arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::ios_base::fmtflags result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_flags",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_flags" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_flags" "', argument " "2"" of type '" "std::ios_base::fmtflags""'");
  } 
  arg2 = static_cast< std::ios_base::fmtflags >(val2);
  result = (std::ios_base::fmtflags)(arg1)->flags(arg2);
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_flags(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_base_flags__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ios_base_flags__SWIG_1(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_base_flags'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::ios_base::flags() const\n"
    "    std::ios_base::flags(std::ios_base::fmtflags)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_base_setf__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::ios_base::fmtflags arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::ios_base::fmtflags result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_setf",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_setf" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_setf" "', argument " "2"" of type '" "std::ios_base::fmtflags""'");
  } 
  arg2 = static_cast< std::ios_base::fmtflags >(val2);
  result = (std::ios_base::fmtflags)(arg1)->setf(arg2);
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_setf__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::ios_base::fmtflags arg2 ;
  std::ios_base::fmtflags arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::ios_base::fmtflags result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:ios_base_setf",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_setf" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_setf" "', argument " "2"" of type '" "std::ios_base::fmtflags""'");
  } 
  arg2 = static_cast< std::ios_base::fmtflags >(val2);
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ios_base_setf" "', argument " "3"" of type '" "std::ios_base::fmtflags""'");
  } 
  arg3 = static_cast< std::ios_base::fmtflags >(val3);
  result = (std::ios_base::fmtflags)(arg1)->setf(arg2,arg3);
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_setf(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[4] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 3) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ios_base_setf__SWIG_0(self, args);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_int(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_ios_base_setf__SWIG_1(self, args);
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_base_setf'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::ios_base::setf(std::ios_base::fmtflags)\n"
    "    std::ios_base::setf(std::ios_base::fmtflags,std::ios_base::fmtflags)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_base_unsetf(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::ios_base::fmtflags arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_unsetf",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_unsetf" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_unsetf" "', argument " "2"" of type '" "std::ios_base::fmtflags""'");
  } 
  arg2 = static_cast< std::ios_base::fmtflags >(val2);
  (arg1)->unsetf(arg2);
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_precision__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_base_precision",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_precision" "', argument " "1"" of type '" "std::ios_base const *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  result = ((std::ios_base const *)arg1)->precision();
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_precision__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::streamsize arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_precision",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_precision" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_size_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_precision" "', argument " "2"" of type '" "std::streamsize""'");
  } 
  arg2 = static_cast< std::streamsize >(val2);
  result = (arg1)->precision(arg2);
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_precision(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_base_precision__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ios_base_precision__SWIG_1(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_base_precision'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::ios_base::precision() const\n"
    "    std::ios_base::precision(std::streamsize)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_base_width__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_base_width",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_width" "', argument " "1"" of type '" "std::ios_base const *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  result = ((std::ios_base const *)arg1)->width();
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_width__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::streamsize arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_width",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_width" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_size_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_width" "', argument " "2"" of type '" "std::streamsize""'");
  } 
  arg2 = static_cast< std::streamsize >(val2);
  result = (arg1)->width(arg2);
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_width(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_base_width__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__ios_base, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ios_base_width__SWIG_1(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_base_width'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::ios_base::width() const\n"
    "    std::ios_base::width(std::streamsize)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_base_sync_with_stdio__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  bool arg1 ;
  bool val1 ;
  int ecode1 = 0 ;
  PyObject * obj0 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_base_sync_with_stdio",&obj0)) SWIG_fail;
  ecode1 = SWIG_AsVal_bool(obj0, &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "ios_base_sync_with_stdio" "', argument " "1"" of type '" "bool""'");
  } 
  arg1 = static_cast< bool >(val1);
  result = (bool)std::ios_base::sync_with_stdio(arg1);
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_sync_with_stdio__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)":ios_base_sync_with_stdio")) SWIG_fail;
  result = (bool)std::ios_base::sync_with_stdio();
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_sync_with_stdio(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[2] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 1) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 0) {
    return _wrap_ios_base_sync_with_stdio__SWIG_1(self, args);
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_bool(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_ios_base_sync_with_stdio__SWIG_0(self, args);
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_base_sync_with_stdio'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::ios_base::sync_with_stdio(bool)\n"
    "    std::ios_base::sync_with_stdio()\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_base_imbue(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  std::locale *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::locale result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_imbue",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_imbue" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_std__locale,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ios_base_imbue" "', argument " "2"" of type '" "std::locale const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ios_base_imbue" "', argument " "2"" of type '" "std::locale const &""'"); 
  }
  arg2 = reinterpret_cast< std::locale * >(argp2);
  result = (arg1)->imbue((std::locale const &)*arg2);
  resultobj = SWIG_NewPointerObj((new std::locale(static_cast< const std::locale& >(result))), SWIGTYPE_p_std__locale, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_getloc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::locale result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_base_getloc",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_getloc" "', argument " "1"" of type '" "std::ios_base const *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  result = ((std::ios_base const *)arg1)->getloc();
  resultobj = SWIG_NewPointerObj((new std::locale(static_cast< const std::locale& >(result))), SWIGTYPE_p_std__locale, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_xalloc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  int result;
  
  if (!PyArg_ParseTuple(args,(char *)":ios_base_xalloc")) SWIG_fail;
  result = (int)std::ios_base::xalloc();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_iword(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  long *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_iword",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_iword" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_iword" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = static_cast< int >(val2);
  result = (long *) &(arg1)->iword(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_long, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_base_pword(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  void **result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_base_pword",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_base_pword" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_base_pword" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = static_cast< int >(val2);
  result = (void **) &(arg1)->pword(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_p_void, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_delete_ios_base(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base *arg1 = (std::ios_base *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_ios_base",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__ios_base, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_ios_base" "', argument " "1"" of type '" "std::ios_base *""'"); 
  }
  arg1 = reinterpret_cast< std::ios_base * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *ios_base_swigregister(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *obj;
  if (!PyArg_ParseTuple(args,(char*)"O:swigregister", &obj)) return NULL;
  SWIG_TypeNewClientData(SWIGTYPE_p_std__ios_base, SWIG_NewClientData(obj));
  return SWIG_Py_Void();
}

SWIGINTERN PyObject *_wrap_ios_rdstate(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::ios_base::iostate result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_rdstate",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_rdstate" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (std::ios_base::iostate)((std::basic_ios< char > const *)arg1)->rdstate();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_clear__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::ios_base::iostate arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_clear",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_clear" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_clear" "', argument " "2"" of type '" "std::ios_base::iostate""'");
  } 
  arg2 = static_cast< std::ios_base::iostate >(val2);
  (arg1)->clear(arg2);
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_clear__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_clear",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_clear" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  (arg1)->clear();
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_clear(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_clear__SWIG_1(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ios_clear__SWIG_0(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_clear'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_ios< char >::clear(std::ios_base::iostate)\n"
    "    std::basic_ios< char >::clear()\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_setstate(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::ios_base::iostate arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_setstate",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_setstate" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_setstate" "', argument " "2"" of type '" "std::ios_base::iostate""'");
  } 
  arg2 = static_cast< std::ios_base::iostate >(val2);
  (arg1)->setstate(arg2);
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_good(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_good",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_good" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (bool)((std::basic_ios< char > const *)arg1)->good();
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_eof(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_eof",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_eof" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (bool)((std::basic_ios< char > const *)arg1)->eof();
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_fail(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_fail",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_fail" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (bool)((std::basic_ios< char > const *)arg1)->fail();
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_bad(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  bool result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_bad",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_bad" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (bool)((std::basic_ios< char > const *)arg1)->bad();
  resultobj = SWIG_From_bool(static_cast< bool >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_exceptions__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::ios_base::iostate result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_exceptions",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_exceptions" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (std::ios_base::iostate)((std::basic_ios< char > const *)arg1)->exceptions();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_exceptions__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::ios_base::iostate arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_exceptions",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_exceptions" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_exceptions" "', argument " "2"" of type '" "std::ios_base::iostate""'");
  } 
  arg2 = static_cast< std::ios_base::iostate >(val2);
  (arg1)->exceptions(arg2);
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_exceptions(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_exceptions__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ios_exceptions__SWIG_1(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_exceptions'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_ios< char >::exceptions() const\n"
    "    std::basic_ios< char >::exceptions(std::ios_base::iostate)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_new_ios(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char,std::char_traits< char > > *arg1 = (std::basic_streambuf< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ios< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:new_ios",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_ios" "', argument " "1"" of type '" "std::basic_streambuf< char,std::char_traits< char > > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp1);
  result = (std::basic_ios< char > *)new std::basic_ios< char >(arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_delete_ios(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_ios",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_ios" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_tie__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_tie",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_tie" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (std::basic_ostream< char,std::char_traits< char > > *)((std::basic_ios< char > const *)arg1)->tie();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_tie__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::basic_ostream< char,std::char_traits< char > > *arg2 = (std::basic_ostream< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_tie",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_tie" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ios_tie" "', argument " "2"" of type '" "std::basic_ostream< char,std::char_traits< char > > *""'"); 
  }
  arg2 = reinterpret_cast< std::basic_ostream< char,std::char_traits< char > > * >(argp2);
  result = (std::basic_ostream< char,std::char_traits< char > > *)(arg1)->tie(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_tie(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_tie__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ios_tie__SWIG_1(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_tie'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_ios< char >::tie() const\n"
    "    std::basic_ios< char >::tie(std::basic_ostream< char,std::char_traits< char > > *)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_rdbuf__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_rdbuf",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_rdbuf" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (std::basic_streambuf< char,std::char_traits< char > > *)((std::basic_ios< char > const *)arg1)->rdbuf();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_rdbuf__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *arg2 = (std::basic_streambuf< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_rdbuf",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_rdbuf" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ios_rdbuf" "', argument " "2"" of type '" "std::basic_streambuf< char,std::char_traits< char > > *""'"); 
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp2);
  result = (std::basic_streambuf< char,std::char_traits< char > > *)(arg1)->rdbuf(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_rdbuf(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_rdbuf__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ios_rdbuf__SWIG_1(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_rdbuf'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_ios< char >::rdbuf() const\n"
    "    std::basic_ios< char >::rdbuf(std::basic_streambuf< char,std::char_traits< char > > *)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_copyfmt(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::basic_ios< char > *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ios< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_copyfmt",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_copyfmt" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ios_copyfmt" "', argument " "2"" of type '" "std::basic_ios< char > const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ios_copyfmt" "', argument " "2"" of type '" "std::basic_ios< char > const &""'"); 
  }
  arg2 = reinterpret_cast< std::basic_ios< char > * >(argp2);
  result = (std::basic_ios< char > *) &(arg1)->copyfmt((std::basic_ios< char > const &)*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_fill__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ios< char >::char_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ios_fill",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_fill" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  result = (std::basic_ios< char >::char_type)((std::basic_ios< char > const *)arg1)->fill();
  resultobj = SWIG_From_char(static_cast< char >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_fill__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::basic_ios< char >::char_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  char val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ios< char >::char_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_fill",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_fill" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  ecode2 = SWIG_AsVal_char(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_fill" "', argument " "2"" of type '" "std::basic_ios< char >::char_type""'");
  } 
  arg2 = static_cast< std::basic_ios< char >::char_type >(val2);
  result = (std::basic_ios< char >::char_type)(arg1)->fill(arg2);
  resultobj = SWIG_From_char(static_cast< char >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_fill(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_ios_fill__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_char(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ios_fill__SWIG_1(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ios_fill'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_ios< char >::fill() const\n"
    "    std::basic_ios< char >::fill(std::basic_ios< char >::char_type)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_ios_imbue(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::locale *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::locale result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_imbue",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_imbue" "', argument " "1"" of type '" "std::basic_ios< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_std__locale,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ios_imbue" "', argument " "2"" of type '" "std::locale const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ios_imbue" "', argument " "2"" of type '" "std::locale const &""'"); 
  }
  arg2 = reinterpret_cast< std::locale * >(argp2);
  result = (arg1)->imbue((std::locale const &)*arg2);
  resultobj = SWIG_NewPointerObj((new std::locale(static_cast< const std::locale& >(result))), SWIGTYPE_p_std__locale, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_narrow(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  std::basic_ios< char >::char_type arg2 ;
  char arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  char val2 ;
  int ecode2 = 0 ;
  char val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  char result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:ios_narrow",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_narrow" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  ecode2 = SWIG_AsVal_char(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_narrow" "', argument " "2"" of type '" "std::basic_ios< char >::char_type""'");
  } 
  arg2 = static_cast< std::basic_ios< char >::char_type >(val2);
  ecode3 = SWIG_AsVal_char(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ios_narrow" "', argument " "3"" of type '" "char""'");
  } 
  arg3 = static_cast< char >(val3);
  result = (char)((std::basic_ios< char > const *)arg1)->narrow(arg2,arg3);
  resultobj = SWIG_From_char(static_cast< char >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ios_widen(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ios< char > *arg1 = (std::basic_ios< char > *) 0 ;
  char arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  char val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ios< char >::char_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ios_widen",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ios_widen" "', argument " "1"" of type '" "std::basic_ios< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ios< char > * >(argp1);
  ecode2 = SWIG_AsVal_char(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ios_widen" "', argument " "2"" of type '" "char""'");
  } 
  arg2 = static_cast< char >(val2);
  result = (std::basic_ios< char >::char_type)((std::basic_ios< char > const *)arg1)->widen(arg2);
  resultobj = SWIG_From_char(static_cast< char >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *ios_swigregister(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *obj;
  if (!PyArg_ParseTuple(args,(char*)"O:swigregister", &obj)) return NULL;
  SWIG_TypeNewClientData(SWIGTYPE_p_std__basic_iosT_char_std__char_traitsT_char_t_t, SWIG_NewClientData(obj));
  return SWIG_Py_Void();
}

SWIGINTERN int Swig_var_cin_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable cin is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_cin_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_NewPointerObj(SWIG_as_voidptr(&std::cin), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t,  0 );
  return pyobj;
}


SWIGINTERN int Swig_var_cout_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable cout is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_cout_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_NewPointerObj(SWIG_as_voidptr(&std::cout), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t,  0 );
  return pyobj;
}


SWIGINTERN int Swig_var_cerr_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable cerr is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_cerr_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_NewPointerObj(SWIG_as_voidptr(&std::cerr), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t,  0 );
  return pyobj;
}


SWIGINTERN int Swig_var_clog_set(PyObject *) {
  SWIG_Error(SWIG_AttributeError,"Variable clog is read-only.");
  return 1;
}


SWIGINTERN PyObject *Swig_var_clog_get(void) {
  PyObject *pyobj = 0;
  
  pyobj = SWIG_NewPointerObj(SWIG_as_voidptr(&std::clog), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t,  0 );
  return pyobj;
}


SWIGINTERN PyObject *_wrap_new_ostream(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char,std::char_traits< char > > *arg1 = (std::basic_streambuf< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ostream< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:new_ostream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_ostream" "', argument " "1"" of type '" "std::basic_streambuf< char,std::char_traits< char > > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp1);
  result = (std::basic_ostream< char > *)new std::basic_ostream< char >(arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_delete_ostream(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_ostream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_ostream" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_ostream< char,std::char_traits< char > > &(*arg2)(std::basic_ostream< char,std::char_traits< char > > &) = (std::basic_ostream< char,std::char_traits< char > > &(*)(std::basic_ostream< char,std::char_traits< char > > &)) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  {
    int res = SWIG_ConvertFunctionPtr(obj1, (void**)(&arg2), SWIGTYPE_p_f_r_std__basic_ostream__char_std__char_traits__char______r_std__basic_ostreamT_char_std__char_traitsT_char_t_t);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "std::basic_ostream< char,std::char_traits< char > > &(*)(std::basic_ostream< char,std::char_traits< char > > &)""'"); 
    }
  }
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_ios< char,std::char_traits< char > > &(*arg2)(std::basic_ios< char,std::char_traits< char > > &) = (std::basic_ios< char,std::char_traits< char > > &(*)(std::basic_ios< char,std::char_traits< char > > &)) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  {
    int res = SWIG_ConvertFunctionPtr(obj1, (void**)(&arg2), SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_iosT_char_std__char_traitsT_char_t_t);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "std::basic_ios< char,std::char_traits< char > > &(*)(std::basic_ios< char,std::char_traits< char > > &)""'"); 
    }
  }
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_2(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::ios_base &(*arg2)(std::ios_base &) = (std::ios_base &(*)(std::ios_base &)) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  {
    int res = SWIG_ConvertFunctionPtr(obj1, (void**)(&arg2), SWIGTYPE_p_f_r_std__ios_base__r_std__ios_base);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "std::ios_base &(*)(std::ios_base &)""'"); 
    }
  }
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_3(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_long(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = static_cast< long >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_4(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  unsigned long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  unsigned long val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_unsigned_SS_long(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "unsigned long""'");
  } 
  arg2 = static_cast< unsigned long >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_5(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  bool arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  bool val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_bool(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "bool""'");
  } 
  arg2 = static_cast< bool >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_6(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  short val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_short(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "short""'");
  } 
  arg2 = static_cast< short >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_7(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  unsigned short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  unsigned short val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_unsigned_SS_short(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "unsigned short""'");
  } 
  arg2 = static_cast< unsigned short >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_8(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = static_cast< int >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_9(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  unsigned int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  unsigned int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_unsigned_SS_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "unsigned int""'");
  } 
  arg2 = static_cast< unsigned int >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_10(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  long long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long long val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_long_SS_long(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "long long""'");
  } 
  arg2 = static_cast< long long >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_11(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  unsigned long long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  unsigned long long val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_unsigned_SS_long_SS_long(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "unsigned long long""'");
  } 
  arg2 = static_cast< unsigned long long >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_12(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  double arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  double val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_double(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "double""'");
  } 
  arg2 = static_cast< double >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_13(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_float(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = static_cast< float >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_14(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  long double arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_long_double,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "long double""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ostream___lshift__" "', argument " "2"" of type '" "long double""'");
    } else {
      long double * temp = reinterpret_cast< long double * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_15(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  void *arg2 = (void *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1,SWIG_as_voidptrptr(&arg2), 0, 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "void const *""'"); 
  }
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<((void const *)arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_16(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *arg2 = (std::basic_streambuf< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "std::basic_streambuf< char,std::char_traits< char > > *""'"); 
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->operator <<(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift____SWIG_17(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_string< char,std::char_traits< char >,std::allocator< char > > *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream___lshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream___lshift__" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_std__basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ostream___lshift__" "', argument " "2"" of type '" "std::basic_string< char,std::char_traits< char >,std::allocator< char > > const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ostream___lshift__" "', argument " "2"" of type '" "std::basic_string< char,std::char_traits< char >,std::allocator< char > > const &""'"); 
  }
  arg2 = reinterpret_cast< std::basic_string< char,std::char_traits< char >,std::allocator< char > > * >(argp2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &std_basic_ostream_Sl_char_Sg__operator_Sl__Sl___SWIG_17(arg1,(std::basic_string< char,std::char_traits< char >,std::allocator< char > > const &)*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream___lshift__(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *ptr = 0;
      int res = SWIG_ConvertFunctionPtr(argv[1], &ptr, SWIGTYPE_p_f_r_std__basic_ostream__char_std__char_traits__char______r_std__basic_ostreamT_char_std__char_traitsT_char_t_t);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream___lshift____SWIG_0(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *ptr = 0;
      int res = SWIG_ConvertFunctionPtr(argv[1], &ptr, SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_iosT_char_std__char_traitsT_char_t_t);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream___lshift____SWIG_1(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *ptr = 0;
      int res = SWIG_ConvertFunctionPtr(argv[1], &ptr, SWIGTYPE_p_f_r_std__ios_base__r_std__ios_base);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream___lshift____SWIG_2(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_long_double, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream___lshift____SWIG_14(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream___lshift____SWIG_16(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_std__basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream___lshift____SWIG_17(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *ptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &ptr, 0, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream___lshift____SWIG_15(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_bool(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_5(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_unsigned_SS_short(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_7(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_short(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_6(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_unsigned_SS_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_9(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_8(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_unsigned_SS_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_4(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_3(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_unsigned_SS_long_SS_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_11(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long_SS_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_10(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_float(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_13(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_double(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_ostream___lshift____SWIG_12(self, args);
      }
    }
  }
  
fail:
  Py_INCREF(Py_NotImplemented);
  return Py_NotImplemented;
}


SWIGINTERN PyObject *_wrap_ostream_put(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_ostream< char >::char_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  char val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream_put",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream_put" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  ecode2 = SWIG_AsVal_char(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ostream_put" "', argument " "2"" of type '" "std::basic_ostream< char >::char_type""'");
  } 
  arg2 = static_cast< std::basic_ostream< char >::char_type >(val2);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->put(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream_write(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_ostream< char >::char_type *arg2 = (std::basic_ostream< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:ostream_write",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream_write" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ostream_write" "', argument " "2"" of type '" "std::basic_ostream< char >::char_type const *""'");
  }
  arg2 = reinterpret_cast< std::basic_ostream< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ostream_write" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->write((std::basic_ostream< char >::char_type const *)arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream_flush(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ostream_flush",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream_flush" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->flush();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream_tellp(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ostream< char >::pos_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ostream_tellp",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream_tellp" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  result = (arg1)->tellp();
  resultobj = SWIG_NewPointerObj((new std::basic_ostream< char >::pos_type(static_cast< const std::basic_ostream< char >::pos_type& >(result))), SWIGTYPE_p_streampos, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream_seekp__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_ostream< char >::pos_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:ostream_seekp",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream_seekp" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streampos,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ostream_seekp" "', argument " "2"" of type '" "std::basic_ostream< char >::pos_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ostream_seekp" "', argument " "2"" of type '" "std::basic_ostream< char >::pos_type""'");
    } else {
      std::basic_ostream< char >::pos_type * temp = reinterpret_cast< std::basic_ostream< char >::pos_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->seekp(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream_seekp__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char > *arg1 = (std::basic_ostream< char > *) 0 ;
  std::basic_ostream< char >::off_type arg2 ;
  std::ios_base::seekdir arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:ostream_seekp",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ostream_seekp" "', argument " "1"" of type '" "std::basic_ostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streamoff,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ostream_seekp" "', argument " "2"" of type '" "std::basic_ostream< char >::off_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ostream_seekp" "', argument " "2"" of type '" "std::basic_ostream< char >::off_type""'");
    } else {
      std::basic_ostream< char >::off_type * temp = reinterpret_cast< std::basic_ostream< char >::off_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ostream_seekp" "', argument " "3"" of type '" "std::ios_base::seekdir""'");
  } 
  arg3 = static_cast< std::ios_base::seekdir >(val3);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &(arg1)->seekp(arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_ostream_seekp(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[4] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 3) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streampos, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_ostream_seekp__SWIG_0(self, args);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streamoff, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_int(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_ostream_seekp__SWIG_1(self, args);
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'ostream_seekp'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_ostream< char >::seekp(std::basic_ostream< char >::pos_type)\n"
    "    std::basic_ostream< char >::seekp(std::basic_ostream< char >::off_type,std::ios_base::seekdir)\n");
  return 0;
}


SWIGINTERN PyObject *ostream_swigregister(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *obj;
  if (!PyArg_ParseTuple(args,(char*)"O:swigregister", &obj)) return NULL;
  SWIG_TypeNewClientData(SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, SWIG_NewClientData(obj));
  return SWIG_Py_Void();
}

SWIGINTERN PyObject *_wrap_new_istream(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char,std::char_traits< char > > *arg1 = (std::basic_streambuf< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istream< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:new_istream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_istream" "', argument " "1"" of type '" "std::basic_streambuf< char,std::char_traits< char > > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp1);
  result = (std::basic_istream< char > *)new std::basic_istream< char >(arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_delete_istream(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_istream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_istream" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char,std::char_traits< char > > &(*arg2)(std::basic_istream< char,std::char_traits< char > > &) = (std::basic_istream< char,std::char_traits< char > > &(*)(std::basic_istream< char,std::char_traits< char > > &)) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  {
    int res = SWIG_ConvertFunctionPtr(obj1, (void**)(&arg2), SWIGTYPE_p_f_r_std__basic_istream__char_std__char_traits__char______r_std__basic_istreamT_char_std__char_traitsT_char_t_t);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in method '" "istream___rshift__" "', argument " "2"" of type '" "std::basic_istream< char,std::char_traits< char > > &(*)(std::basic_istream< char,std::char_traits< char > > &)""'"); 
    }
  }
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_ios< char,std::char_traits< char > > &(*arg2)(std::basic_ios< char,std::char_traits< char > > &) = (std::basic_ios< char,std::char_traits< char > > &(*)(std::basic_ios< char,std::char_traits< char > > &)) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  {
    int res = SWIG_ConvertFunctionPtr(obj1, (void**)(&arg2), SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_iosT_char_std__char_traitsT_char_t_t);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in method '" "istream___rshift__" "', argument " "2"" of type '" "std::basic_ios< char,std::char_traits< char > > &(*)(std::basic_ios< char,std::char_traits< char > > &)""'"); 
    }
  }
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_2(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::ios_base &(*arg2)(std::ios_base &) = (std::ios_base &(*)(std::ios_base &)) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  {
    int res = SWIG_ConvertFunctionPtr(obj1, (void**)(&arg2), SWIGTYPE_p_f_r_std__ios_base__r_std__ios_base);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in method '" "istream___rshift__" "', argument " "2"" of type '" "std::ios_base &(*)(std::ios_base &)""'"); 
    }
  }
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_3(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  bool *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_bool,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "bool &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "bool &""'"); 
  }
  arg2 = reinterpret_cast< bool * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_4(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  short *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_short,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "short &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "short &""'"); 
  }
  arg2 = reinterpret_cast< short * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_5(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  unsigned short *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_unsigned_short,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned short &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned short &""'"); 
  }
  arg2 = reinterpret_cast< unsigned short * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_6(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  int *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_int,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "int &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "int &""'"); 
  }
  arg2 = reinterpret_cast< int * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_7(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  unsigned int *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_unsigned_int,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned int &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned int &""'"); 
  }
  arg2 = reinterpret_cast< unsigned int * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_8(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  long *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_long,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "long &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "long &""'"); 
  }
  arg2 = reinterpret_cast< long * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_9(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  unsigned long *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_unsigned_long,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned long &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned long &""'"); 
  }
  arg2 = reinterpret_cast< unsigned long * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_10(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  long long *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_long_long,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "long long &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "long long &""'"); 
  }
  arg2 = reinterpret_cast< long long * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_11(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  unsigned long long *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_unsigned_long_long,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned long long &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "unsigned long long &""'"); 
  }
  arg2 = reinterpret_cast< unsigned long long * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_12(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  float *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "float &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "float &""'"); 
  }
  arg2 = reinterpret_cast< float * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_13(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  double *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_double,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "double &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "double &""'"); 
  }
  arg2 = reinterpret_cast< double * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_14(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  long double *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_long_double,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "long double &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "long double &""'"); 
  }
  arg2 = reinterpret_cast< long double * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_15(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void **arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_p_void,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "void *&""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream___rshift__" "', argument " "2"" of type '" "void *&""'"); 
  }
  arg2 = reinterpret_cast< void ** >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift____SWIG_16(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *arg2 = (std::basic_streambuf< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream___rshift__",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream___rshift__" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream___rshift__" "', argument " "2"" of type '" "std::basic_streambuf< char,std::char_traits< char > > *""'"); 
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->operator >>(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream___rshift__(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *ptr = 0;
      int res = SWIG_ConvertFunctionPtr(argv[1], &ptr, SWIGTYPE_p_f_r_std__basic_istream__char_std__char_traits__char______r_std__basic_istreamT_char_std__char_traitsT_char_t_t);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_0(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *ptr = 0;
      int res = SWIG_ConvertFunctionPtr(argv[1], &ptr, SWIGTYPE_p_f_r_std__basic_ios__char_std__char_traits__char______r_std__basic_iosT_char_std__char_traitsT_char_t_t);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_1(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *ptr = 0;
      int res = SWIG_ConvertFunctionPtr(argv[1], &ptr, SWIGTYPE_p_f_r_std__ios_base__r_std__ios_base);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_2(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_bool, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_3(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_short, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_4(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_unsigned_short, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_5(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_int, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_6(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_unsigned_int, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_7(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_long, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_8(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_unsigned_long, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_9(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_long_long, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_10(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_unsigned_long_long, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_11(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_float, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_12(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_double, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_13(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_long_double, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_14(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_p_void, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_15(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream___rshift____SWIG_16(self, args);
      }
    }
  }
  
fail:
  Py_INCREF(Py_NotImplemented);
  return Py_NotImplemented;
}


SWIGINTERN PyObject *_wrap_istream_gcount(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istream_gcount",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_gcount" "', argument " "1"" of type '" "std::basic_istream< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  result = ((std::basic_istream< char > const *)arg1)->gcount();
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_get__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istream< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istream_get",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_get" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  result = (std::basic_istream< char >::int_type)(arg1)->get();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_get__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream_get",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_get" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_char,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_istream< char >::char_type &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_istream< char >::char_type &""'"); 
  }
  arg2 = reinterpret_cast< std::basic_istream< char >::char_type * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->get(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_get__SWIG_2(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type *arg2 = (std::basic_istream< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  std::basic_istream< char >::char_type arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  char val4 ;
  int ecode4 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  PyObject * obj3 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOOO:istream_get",&obj0,&obj1,&obj2,&obj3)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_get" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_istream< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_istream< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_get" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  ecode4 = SWIG_AsVal_char(obj3, &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "istream_get" "', argument " "4"" of type '" "std::basic_istream< char >::char_type""'");
  } 
  arg4 = static_cast< std::basic_istream< char >::char_type >(val4);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->get(arg2,arg3,arg4);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_get__SWIG_3(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type *arg2 = (std::basic_istream< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:istream_get",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_get" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_istream< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_istream< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_get" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->get(arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_get__SWIG_4(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *arg2 = 0 ;
  std::basic_istream< char >::char_type arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  char val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:istream_get",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_get" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_streambuf< char,std::char_traits< char > > &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_streambuf< char,std::char_traits< char > > &""'"); 
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp2);
  ecode3 = SWIG_AsVal_char(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_get" "', argument " "3"" of type '" "std::basic_istream< char >::char_type""'");
  } 
  arg3 = static_cast< std::basic_istream< char >::char_type >(val3);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->get(*arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_get__SWIG_5(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream_get",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_get" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_streambuf< char,std::char_traits< char > > &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream_get" "', argument " "2"" of type '" "std::basic_streambuf< char,std::char_traits< char > > &""'"); 
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->get(*arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_get(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[5] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 4) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_istream_get__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_char, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream_get__SWIG_1(self, args);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream_get__SWIG_5(self, args);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_char(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_istream_get__SWIG_4(self, args);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsCharPtrAndSize(argv[1], 0, NULL, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_size_t(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_istream_get__SWIG_3(self, args);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsCharPtrAndSize(argv[1], 0, NULL, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_size_t(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_char(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_istream_get__SWIG_2(self, args);
          }
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'istream_get'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_istream< char >::get()\n"
    "    std::basic_istream< char >::get(std::basic_istream< char >::char_type &)\n"
    "    std::basic_istream< char >::get(std::basic_istream< char >::char_type *,std::streamsize,std::basic_istream< char >::char_type)\n"
    "    std::basic_istream< char >::get(std::basic_istream< char >::char_type *,std::streamsize)\n"
    "    std::basic_istream< char >::get(std::basic_streambuf< char,std::char_traits< char > > &,std::basic_istream< char >::char_type)\n"
    "    std::basic_istream< char >::get(std::basic_streambuf< char,std::char_traits< char > > &)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_istream_getline__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type *arg2 = (std::basic_istream< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  std::basic_istream< char >::char_type arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  char val4 ;
  int ecode4 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  PyObject * obj3 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOOO:istream_getline",&obj0,&obj1,&obj2,&obj3)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_getline" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_getline" "', argument " "2"" of type '" "std::basic_istream< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_istream< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_getline" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  ecode4 = SWIG_AsVal_char(obj3, &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "istream_getline" "', argument " "4"" of type '" "std::basic_istream< char >::char_type""'");
  } 
  arg4 = static_cast< std::basic_istream< char >::char_type >(val4);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->getline(arg2,arg3,arg4);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_getline__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type *arg2 = (std::basic_istream< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:istream_getline",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_getline" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_getline" "', argument " "2"" of type '" "std::basic_istream< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_istream< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_getline" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->getline(arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_getline(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[5] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 4) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsCharPtrAndSize(argv[1], 0, NULL, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_size_t(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_istream_getline__SWIG_1(self, args);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsCharPtrAndSize(argv[1], 0, NULL, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_size_t(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_char(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_istream_getline__SWIG_0(self, args);
          }
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'istream_getline'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_istream< char >::getline(std::basic_istream< char >::char_type *,std::streamsize,std::basic_istream< char >::char_type)\n"
    "    std::basic_istream< char >::getline(std::basic_istream< char >::char_type *,std::streamsize)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_istream_ignore__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::streamsize arg2 ;
  std::basic_istream< char >::int_type arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:istream_ignore",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_ignore" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  ecode2 = SWIG_AsVal_size_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "istream_ignore" "', argument " "2"" of type '" "std::streamsize""'");
  } 
  arg2 = static_cast< std::streamsize >(val2);
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_ignore" "', argument " "3"" of type '" "std::basic_istream< char >::int_type""'");
  } 
  arg3 = static_cast< std::basic_istream< char >::int_type >(val3);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->ignore(arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_ignore__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::streamsize arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream_ignore",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_ignore" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  ecode2 = SWIG_AsVal_size_t(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "istream_ignore" "', argument " "2"" of type '" "std::streamsize""'");
  } 
  arg2 = static_cast< std::streamsize >(val2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->ignore(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_ignore__SWIG_2(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istream_ignore",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_ignore" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->ignore();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_ignore(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[4] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 3) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_istream_ignore__SWIG_2(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_istream_ignore__SWIG_1(self, args);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_int(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_istream_ignore__SWIG_0(self, args);
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'istream_ignore'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_istream< char >::ignore(std::streamsize,std::basic_istream< char >::int_type)\n"
    "    std::basic_istream< char >::ignore(std::streamsize)\n"
    "    std::basic_istream< char >::ignore()\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_istream_peek(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istream< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istream_peek",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_peek" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  result = (std::basic_istream< char >::int_type)(arg1)->peek();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_read(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type *arg2 = (std::basic_istream< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:istream_read",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_read" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_read" "', argument " "2"" of type '" "std::basic_istream< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_istream< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_read" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->read(arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_readsome(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type *arg2 = (std::basic_istream< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:istream_readsome",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_readsome" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_readsome" "', argument " "2"" of type '" "std::basic_istream< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_istream< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_readsome" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (arg1)->readsome(arg2,arg3);
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_putback(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::char_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  char val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream_putback",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_putback" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  ecode2 = SWIG_AsVal_char(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "istream_putback" "', argument " "2"" of type '" "std::basic_istream< char >::char_type""'");
  } 
  arg2 = static_cast< std::basic_istream< char >::char_type >(val2);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->putback(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_unget(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istream_unget",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_unget" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->unget();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_sync(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  int result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istream_sync",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_sync" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  result = (int)(arg1)->sync();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_tellg(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istream< char >::pos_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istream_tellg",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_tellg" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  result = (arg1)->tellg();
  resultobj = SWIG_NewPointerObj((new std::basic_istream< char >::pos_type(static_cast< const std::basic_istream< char >::pos_type& >(result))), SWIGTYPE_p_streampos, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_seekg__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::pos_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:istream_seekg",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_seekg" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streampos,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_seekg" "', argument " "2"" of type '" "std::basic_istream< char >::pos_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream_seekg" "', argument " "2"" of type '" "std::basic_istream< char >::pos_type""'");
    } else {
      std::basic_istream< char >::pos_type * temp = reinterpret_cast< std::basic_istream< char >::pos_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->seekg(arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_seekg__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istream< char > *arg1 = (std::basic_istream< char > *) 0 ;
  std::basic_istream< char >::off_type arg2 ;
  std::ios_base::seekdir arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_istream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:istream_seekg",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istream_seekg" "', argument " "1"" of type '" "std::basic_istream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istream< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streamoff,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "istream_seekg" "', argument " "2"" of type '" "std::basic_istream< char >::off_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "istream_seekg" "', argument " "2"" of type '" "std::basic_istream< char >::off_type""'");
    } else {
      std::basic_istream< char >::off_type * temp = reinterpret_cast< std::basic_istream< char >::off_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "istream_seekg" "', argument " "3"" of type '" "std::ios_base::seekdir""'");
  } 
  arg3 = static_cast< std::ios_base::seekdir >(val3);
  result = (std::basic_istream< char,std::char_traits< char > > *) &(arg1)->seekg(arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istream_seekg(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[4] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 3) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streampos, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_istream_seekg__SWIG_0(self, args);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streamoff, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_int(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_istream_seekg__SWIG_1(self, args);
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'istream_seekg'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_istream< char >::seekg(std::basic_istream< char >::pos_type)\n"
    "    std::basic_istream< char >::seekg(std::basic_istream< char >::off_type,std::ios_base::seekdir)\n");
  return 0;
}


SWIGINTERN PyObject *istream_swigregister(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *obj;
  if (!PyArg_ParseTuple(args,(char*)"O:swigregister", &obj)) return NULL;
  SWIG_TypeNewClientData(SWIGTYPE_p_std__basic_istreamT_char_std__char_traitsT_char_t_t, SWIG_NewClientData(obj));
  return SWIG_Py_Void();
}

SWIGINTERN PyObject *_wrap_new_iostream(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char,std::char_traits< char > > *arg1 = (std::basic_streambuf< char,std::char_traits< char > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_iostream< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:new_iostream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_iostream" "', argument " "1"" of type '" "std::basic_streambuf< char,std::char_traits< char > > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char,std::char_traits< char > > * >(argp1);
  result = (std::basic_iostream< char > *)new std::basic_iostream< char >(arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_iostreamT_char_std__char_traitsT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_delete_iostream(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_iostream< char > *arg1 = (std::basic_iostream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_iostream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_iostreamT_char_std__char_traitsT_char_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_iostream" "', argument " "1"" of type '" "std::basic_iostream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_iostream< char > * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *iostream_swigregister(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *obj;
  if (!PyArg_ParseTuple(args,(char*)"O:swigregister", &obj)) return NULL;
  SWIG_TypeNewClientData(SWIGTYPE_p_std__basic_iostreamT_char_std__char_traitsT_char_t_t, SWIG_NewClientData(obj));
  return SWIG_Py_Void();
}

SWIGINTERN PyObject *endl_cb_ptr_swigconstant(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *module;
  PyObject *d;
  if (!PyArg_ParseTuple(args,(char*)"O:swigconstant", &module)) return NULL;
  d = PyModule_GetDict(module);
  if (!d) return NULL;
  
  return SWIG_Py_Void();
}


SWIGINTERN PyObject *_wrap_endl(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char,std::char_traits< char > > *arg1 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:endl",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "endl" "', argument " "1"" of type '" "std::basic_ostream< char,std::char_traits< char > > &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "endl" "', argument " "1"" of type '" "std::basic_ostream< char,std::char_traits< char > > &""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char,std::char_traits< char > > * >(argp1);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &std::SWIGTEMPLATEDISAMBIGUATOR endl< char,std::char_traits< char > >(*arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *ends_cb_ptr_swigconstant(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *module;
  PyObject *d;
  if (!PyArg_ParseTuple(args,(char*)"O:swigconstant", &module)) return NULL;
  d = PyModule_GetDict(module);
  if (!d) return NULL;
  
  return SWIG_Py_Void();
}


SWIGINTERN PyObject *_wrap_ends(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char,std::char_traits< char > > *arg1 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:ends",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ends" "', argument " "1"" of type '" "std::basic_ostream< char,std::char_traits< char > > &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ends" "', argument " "1"" of type '" "std::basic_ostream< char,std::char_traits< char > > &""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char,std::char_traits< char > > * >(argp1);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &std::SWIGTEMPLATEDISAMBIGUATOR ends< char,std::char_traits< char > >(*arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *flush_cb_ptr_swigconstant(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *module;
  PyObject *d;
  if (!PyArg_ParseTuple(args,(char*)"O:swigconstant", &module)) return NULL;
  d = PyModule_GetDict(module);
  if (!d) return NULL;
  
  return SWIG_Py_Void();
}


SWIGINTERN PyObject *_wrap_flush(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_ostream< char,std::char_traits< char > > *arg1 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_ostream< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:flush",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1, SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "flush" "', argument " "1"" of type '" "std::basic_ostream< char,std::char_traits< char > > &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "flush" "', argument " "1"" of type '" "std::basic_ostream< char,std::char_traits< char > > &""'"); 
  }
  arg1 = reinterpret_cast< std::basic_ostream< char,std::char_traits< char > > * >(argp1);
  result = (std::basic_ostream< char,std::char_traits< char > > *) &std::SWIGTEMPLATEDISAMBIGUATOR flush< char,std::char_traits< char > >(*arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_ostreamT_char_std__char_traitsT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_delete_streambuf(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_streambuf",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_streambuf" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_pubimbue(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::locale *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::locale result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:streambuf_pubimbue",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_pubimbue" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_std__locale,  0  | 0);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_pubimbue" "', argument " "2"" of type '" "std::locale const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "streambuf_pubimbue" "', argument " "2"" of type '" "std::locale const &""'"); 
  }
  arg2 = reinterpret_cast< std::locale * >(argp2);
  result = (arg1)->pubimbue((std::locale const &)*arg2);
  resultobj = SWIG_NewPointerObj((new std::locale(static_cast< const std::locale& >(result))), SWIGTYPE_p_std__locale, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_getloc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::locale result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:streambuf_getloc",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_getloc" "', argument " "1"" of type '" "std::basic_streambuf< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  result = ((std::basic_streambuf< char > const *)arg1)->getloc();
  resultobj = SWIG_NewPointerObj((new std::locale(static_cast< const std::locale& >(result))), SWIGTYPE_p_std__locale, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_pubsetbuf(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::char_type *arg2 = (std::basic_streambuf< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_streambuf< char,std::char_traits< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:streambuf_pubsetbuf",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_pubsetbuf" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_pubsetbuf" "', argument " "2"" of type '" "std::basic_streambuf< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "streambuf_pubsetbuf" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (std::basic_streambuf< char,std::char_traits< char > > *)(arg1)->pubsetbuf(arg2,arg3);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_pubseekoff__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::off_type arg2 ;
  std::ios_base::seekdir arg3 ;
  std::ios_base::openmode arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  int val4 ;
  int ecode4 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  PyObject * obj3 = 0 ;
  std::basic_streambuf< char >::pos_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOOO:streambuf_pubseekoff",&obj0,&obj1,&obj2,&obj3)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_pubseekoff" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streamoff,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_pubseekoff" "', argument " "2"" of type '" "std::basic_streambuf< char >::off_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "streambuf_pubseekoff" "', argument " "2"" of type '" "std::basic_streambuf< char >::off_type""'");
    } else {
      std::basic_streambuf< char >::off_type * temp = reinterpret_cast< std::basic_streambuf< char >::off_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "streambuf_pubseekoff" "', argument " "3"" of type '" "std::ios_base::seekdir""'");
  } 
  arg3 = static_cast< std::ios_base::seekdir >(val3);
  ecode4 = SWIG_AsVal_int(obj3, &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "streambuf_pubseekoff" "', argument " "4"" of type '" "std::ios_base::openmode""'");
  } 
  arg4 = static_cast< std::ios_base::openmode >(val4);
  result = (arg1)->pubseekoff(arg2,arg3,arg4);
  resultobj = SWIG_NewPointerObj((new std::basic_streambuf< char >::pos_type(static_cast< const std::basic_streambuf< char >::pos_type& >(result))), SWIGTYPE_p_streampos, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_pubseekoff__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::off_type arg2 ;
  std::ios_base::seekdir arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_streambuf< char >::pos_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:streambuf_pubseekoff",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_pubseekoff" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streamoff,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_pubseekoff" "', argument " "2"" of type '" "std::basic_streambuf< char >::off_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "streambuf_pubseekoff" "', argument " "2"" of type '" "std::basic_streambuf< char >::off_type""'");
    } else {
      std::basic_streambuf< char >::off_type * temp = reinterpret_cast< std::basic_streambuf< char >::off_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "streambuf_pubseekoff" "', argument " "3"" of type '" "std::ios_base::seekdir""'");
  } 
  arg3 = static_cast< std::ios_base::seekdir >(val3);
  result = (arg1)->pubseekoff(arg2,arg3);
  resultobj = SWIG_NewPointerObj((new std::basic_streambuf< char >::pos_type(static_cast< const std::basic_streambuf< char >::pos_type& >(result))), SWIGTYPE_p_streampos, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_pubseekoff(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[5] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 4) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streamoff, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_int(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_streambuf_pubseekoff__SWIG_1(self, args);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streamoff, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_int(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_int(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_streambuf_pubseekoff__SWIG_0(self, args);
          }
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'streambuf_pubseekoff'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_streambuf< char >::pubseekoff(std::basic_streambuf< char >::off_type,std::ios_base::seekdir,std::ios_base::openmode)\n"
    "    std::basic_streambuf< char >::pubseekoff(std::basic_streambuf< char >::off_type,std::ios_base::seekdir)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_streambuf_pubseekpos__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::pos_type arg2 ;
  std::ios_base::openmode arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::basic_streambuf< char >::pos_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:streambuf_pubseekpos",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_pubseekpos" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streampos,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_pubseekpos" "', argument " "2"" of type '" "std::basic_streambuf< char >::pos_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "streambuf_pubseekpos" "', argument " "2"" of type '" "std::basic_streambuf< char >::pos_type""'");
    } else {
      std::basic_streambuf< char >::pos_type * temp = reinterpret_cast< std::basic_streambuf< char >::pos_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  ecode3 = SWIG_AsVal_int(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "streambuf_pubseekpos" "', argument " "3"" of type '" "std::ios_base::openmode""'");
  } 
  arg3 = static_cast< std::ios_base::openmode >(val3);
  result = (arg1)->pubseekpos(arg2,arg3);
  resultobj = SWIG_NewPointerObj((new std::basic_streambuf< char >::pos_type(static_cast< const std::basic_streambuf< char >::pos_type& >(result))), SWIGTYPE_p_streampos, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_pubseekpos__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::pos_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_streambuf< char >::pos_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:streambuf_pubseekpos",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_pubseekpos" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  {
    res2 = SWIG_ConvertPtr(obj1, &argp2, SWIGTYPE_p_streampos,  0  | 0);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_pubseekpos" "', argument " "2"" of type '" "std::basic_streambuf< char >::pos_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "streambuf_pubseekpos" "', argument " "2"" of type '" "std::basic_streambuf< char >::pos_type""'");
    } else {
      std::basic_streambuf< char >::pos_type * temp = reinterpret_cast< std::basic_streambuf< char >::pos_type * >(argp2);
      arg2 = *temp;
      if (SWIG_IsNewObj(res2)) delete temp;
    }
  }
  result = (arg1)->pubseekpos(arg2);
  resultobj = SWIG_NewPointerObj((new std::basic_streambuf< char >::pos_type(static_cast< const std::basic_streambuf< char >::pos_type& >(result))), SWIGTYPE_p_streampos, SWIG_POINTER_OWN |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_pubseekpos(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[4] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 3) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streampos, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_streambuf_pubseekpos__SWIG_1(self, args);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_ConvertPtr(argv[1], 0, SWIGTYPE_p_streampos, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_int(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_streambuf_pubseekpos__SWIG_0(self, args);
        }
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'streambuf_pubseekpos'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_streambuf< char >::pubseekpos(std::basic_streambuf< char >::pos_type,std::ios_base::openmode)\n"
    "    std::basic_streambuf< char >::pubseekpos(std::basic_streambuf< char >::pos_type)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_streambuf_pubsync(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  int result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:streambuf_pubsync",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_pubsync" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  result = (int)(arg1)->pubsync();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_in_avail(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:streambuf_in_avail",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_in_avail" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  result = (arg1)->in_avail();
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_snextc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_streambuf< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:streambuf_snextc",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_snextc" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  result = (std::basic_streambuf< char >::int_type)(arg1)->snextc();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_sbumpc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_streambuf< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:streambuf_sbumpc",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_sbumpc" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  result = (std::basic_streambuf< char >::int_type)(arg1)->sbumpc();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_sgetc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_streambuf< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:streambuf_sgetc",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_sgetc" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  result = (std::basic_streambuf< char >::int_type)(arg1)->sgetc();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_sgetn(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::char_type *arg2 = (std::basic_streambuf< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:streambuf_sgetn",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_sgetn" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_sgetn" "', argument " "2"" of type '" "std::basic_streambuf< char >::char_type *""'");
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "streambuf_sgetn" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (arg1)->sgetn(arg2,arg3);
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_sputbackc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::char_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  char val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_streambuf< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:streambuf_sputbackc",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_sputbackc" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  ecode2 = SWIG_AsVal_char(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "streambuf_sputbackc" "', argument " "2"" of type '" "std::basic_streambuf< char >::char_type""'");
  } 
  arg2 = static_cast< std::basic_streambuf< char >::char_type >(val2);
  result = (std::basic_streambuf< char >::int_type)(arg1)->sputbackc(arg2);
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_sungetc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_streambuf< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"O:streambuf_sungetc",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_sungetc" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  result = (std::basic_streambuf< char >::int_type)(arg1)->sungetc();
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_sputc(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::char_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  char val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_streambuf< char >::int_type result;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:streambuf_sputc",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_sputc" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  ecode2 = SWIG_AsVal_char(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "streambuf_sputc" "', argument " "2"" of type '" "std::basic_streambuf< char >::char_type""'");
  } 
  arg2 = static_cast< std::basic_streambuf< char >::char_type >(val2);
  result = (std::basic_streambuf< char >::int_type)(arg1)->sputc(arg2);
  resultobj = SWIG_From_int(static_cast< int >(result));
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_streambuf_sputn(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_streambuf< char > *arg1 = (std::basic_streambuf< char > *) 0 ;
  std::basic_streambuf< char >::char_type *arg2 = (std::basic_streambuf< char >::char_type *) 0 ;
  std::streamsize arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  size_t val3 ;
  int ecode3 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  PyObject * obj2 = 0 ;
  std::streamsize result;
  
  if (!PyArg_ParseTuple(args,(char *)"OOO:streambuf_sputn",&obj0,&obj1,&obj2)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "streambuf_sputn" "', argument " "1"" of type '" "std::basic_streambuf< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_streambuf< char > * >(argp1);
  res2 = SWIG_AsCharPtrAndSize(obj1, &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "streambuf_sputn" "', argument " "2"" of type '" "std::basic_streambuf< char >::char_type const *""'");
  }
  arg2 = reinterpret_cast< std::basic_streambuf< char >::char_type * >(buf2);
  ecode3 = SWIG_AsVal_size_t(obj2, &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "streambuf_sputn" "', argument " "3"" of type '" "std::streamsize""'");
  } 
  arg3 = static_cast< std::streamsize >(val3);
  result = (arg1)->sputn((std::basic_streambuf< char >::char_type const *)arg2,arg3);
  resultobj = SWIG_From_size_t(static_cast< size_t >(result));
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return resultobj;
fail:
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
  return NULL;
}


SWIGINTERN PyObject *streambuf_swigregister(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *obj;
  if (!PyArg_ParseTuple(args,(char*)"O:swigregister", &obj)) return NULL;
  SWIG_TypeNewClientData(SWIGTYPE_p_std__basic_streambufT_char_std__char_traitsT_char_t_t, SWIG_NewClientData(obj));
  return SWIG_Py_Void();
}

SWIGINTERN PyObject *_wrap_new_istringstream__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::ios_base::openmode arg1 ;
  int val1 ;
  int ecode1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istringstream< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:new_istringstream",&obj0)) SWIG_fail;
  ecode1 = SWIG_AsVal_int(obj0, &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_istringstream" "', argument " "1"" of type '" "std::ios_base::openmode""'");
  } 
  arg1 = static_cast< std::ios_base::openmode >(val1);
  result = (std::basic_istringstream< char > *)new std::basic_istringstream< char >(arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_new_istringstream__SWIG_1(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istringstream< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)":new_istringstream")) SWIG_fail;
  result = (std::basic_istringstream< char > *)new std::basic_istringstream< char >();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_new_istringstream__SWIG_2(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  basic_string< char,std::char_traits< char >,std::allocator< char > > *arg1 = 0 ;
  std::ios_base::openmode arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  PyObject * obj0 = 0 ;
  PyObject * obj1 = 0 ;
  std::basic_istringstream< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"OO:new_istringstream",&obj0,&obj1)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1, SWIGTYPE_p_basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t,  0  | 0);
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_istringstream" "', argument " "1"" of type '" "basic_string< char,std::char_traits< char >,std::allocator< char > > const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_istringstream" "', argument " "1"" of type '" "basic_string< char,std::char_traits< char >,std::allocator< char > > const &""'"); 
  }
  arg1 = reinterpret_cast< basic_string< char,std::char_traits< char >,std::allocator< char > > * >(argp1);
  ecode2 = SWIG_AsVal_int(obj1, &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "new_istringstream" "', argument " "2"" of type '" "std::ios_base::openmode""'");
  } 
  arg2 = static_cast< std::ios_base::openmode >(val2);
  result = (std::basic_istringstream< char > *)new std::basic_istringstream< char >((basic_string< char,std::char_traits< char >,std::allocator< char > > const &)*arg1,arg2);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_new_istringstream__SWIG_3(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  basic_string< char,std::char_traits< char >,std::allocator< char > > *arg1 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_istringstream< char > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:new_istringstream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1, SWIGTYPE_p_basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t,  0  | 0);
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_istringstream" "', argument " "1"" of type '" "basic_string< char,std::char_traits< char >,std::allocator< char > > const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_istringstream" "', argument " "1"" of type '" "basic_string< char,std::char_traits< char >,std::allocator< char > > const &""'"); 
  }
  arg1 = reinterpret_cast< basic_string< char,std::char_traits< char >,std::allocator< char > > * >(argp1);
  result = (std::basic_istringstream< char > *)new std::basic_istringstream< char >((basic_string< char,std::char_traits< char >,std::allocator< char > > const &)*arg1);
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, SWIG_POINTER_NEW |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_new_istringstream(PyObject *self, PyObject *args) {
  Py_ssize_t argc;
  PyObject *argv[3] = {
    0
  };
  Py_ssize_t ii;
  
  if (!PyTuple_Check(args)) SWIG_fail;
  argc = args ? PyObject_Length(args) : 0;
  for (ii = 0; (ii < 2) && (ii < argc); ii++) {
    argv[ii] = PyTuple_GET_ITEM(args,ii);
  }
  if (argc == 0) {
    return _wrap_new_istringstream__SWIG_1(self, args);
  }
  if (argc == 1) {
    int _v;
    int res = SWIG_ConvertPtr(argv[0], 0, SWIGTYPE_p_basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_new_istringstream__SWIG_3(self, args);
    }
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_int(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_istringstream__SWIG_0(self, args);
    }
  }
  if (argc == 2) {
    int _v;
    int res = SWIG_ConvertPtr(argv[0], 0, SWIGTYPE_p_basic_stringT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_new_istringstream__SWIG_2(self, args);
      }
    }
  }
  
fail:
  SWIG_SetErrorMsg(PyExc_NotImplementedError,"Wrong number or type of arguments for overloaded function 'new_istringstream'.\n"
    "  Possible C/C++ prototypes are:\n"
    "    std::basic_istringstream< char >::basic_istringstream(std::ios_base::openmode)\n"
    "    std::basic_istringstream< char >::basic_istringstream()\n"
    "    std::basic_istringstream< char >::basic_istringstream(basic_string< char,std::char_traits< char >,std::allocator< char > > const &,std::ios_base::openmode)\n"
    "    std::basic_istringstream< char >::basic_istringstream(basic_string< char,std::char_traits< char >,std::allocator< char > > const &)\n");
  return 0;
}


SWIGINTERN PyObject *_wrap_delete_istringstream(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istringstream< char > *arg1 = (std::basic_istringstream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:delete_istringstream",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_istringstream" "', argument " "1"" of type '" "std::basic_istringstream< char > *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istringstream< char > * >(argp1);
  delete arg1;
  resultobj = SWIG_Py_Void();
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istringstream_rdbuf(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istringstream< char > *arg1 = (std::basic_istringstream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  std::basic_stringbuf< char,std::char_traits< char >,std::allocator< char > > *result = 0 ;
  
  if (!PyArg_ParseTuple(args,(char *)"O:istringstream_rdbuf",&obj0)) SWIG_fail;
  res1 = SWIG_ConvertPtr(obj0, &argp1,SWIGTYPE_p_std__basic_istringstreamT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "istringstream_rdbuf" "', argument " "1"" of type '" "std::basic_istringstream< char > const *""'"); 
  }
  arg1 = reinterpret_cast< std::basic_istringstream< char > * >(argp1);
  result = (std::basic_stringbuf< char,std::char_traits< char >,std::allocator< char > > *)((std::basic_istringstream< char > const *)arg1)->rdbuf();
  resultobj = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__basic_stringbufT_char_std__char_traitsT_char_t_std__allocatorT_char_t_t, 0 |  0 );
  return resultobj;
fail:
  return NULL;
}


SWIGINTERN PyObject *_wrap_istringstream_str__SWIG_0(PyObject *SWIGUNUSEDPARM(self), PyObject *args) {
  PyObject *resultobj = 0;
  std::basic_istringstream< char > *arg1 = (std::basic_istringstream< char > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  PyObject * obj0 = 0 ;
  basic_string< char,std::char_traits< char >,std::allocator< char