/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png.scanlinefilters;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.png.scanlinefilters.ScanlineFilter;

public class ScanlineFilterAverage
extends ScanlineFilter {
    private final int BytesPerPixel;

    public ScanlineFilterAverage(int BytesPerPixel) {
        this.BytesPerPixel = BytesPerPixel;
    }

    public void unfilter(byte[] src, byte[] dst, byte[] up) throws ImageReadException, IOException {
        for (int i = 0; i < src.length; ++i) {
            byte Raw2 = 0;
            int prev_index = i - this.BytesPerPixel;
            if (prev_index >= 0) {
                Raw2 = dst[prev_index];
            }
            byte Prior = 0;
            if (up != null) {
                Prior = up[i];
            }
            int Average = ((0xFF & Raw2) + (0xFF & Prior)) / 2;
            dst[i] = (byte)((src[i] + Average) % 256);
        }
    }
}

